#!/bin/sh
set -e
. /etc/gitaly/gitaly-installer.conf

echo "Downloading Gitaly tarball version ${gitaly_version} from Gitaly official build artifacts..."

mkdir -p ${gitaly_cache}
echo "${gitaly_artifact_url}/v${gitaly_version}/download?job=build:binaries:+[${go_version}]"
# Skip download if already present
if ! test -f ${gitaly_cache}/gitaly-${gitaly_version}.zip
then
        curl --progress-bar -L -o "${gitaly_cache}/gitaly-${gitaly_version}.zip" "${gitaly_artifact_url}/v${gitaly_version}/download?job=build:binaries:+\[${go_version}\]"
fi
#
echo "Checking integrity of download..."
sha256sum -c ${gitaly_sha256sums}

echo "Extracting files..."
unzip -qq ${gitaly_cache}/gitaly-${gitaly_version}.zip -d ${gitaly_cache}
echo "Copying files to /usr/bin..."
echo "gitaly archive to copy: gitaly-${gitaly_version}"
# Copy binary executables to /usr/bin
mkdir -p ${gitaly_user_home}
cp -r  ${gitaly_cache}/_build/bin/* ${gitaly_user_home}
