/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.pack200.tests;

import junit.framework.TestCase;
import org.apache.harmony.pack200.AttributeLayout;
import org.apache.harmony.pack200.Pack200Exception;
import org.apache.harmony.pack200.tests.AttributeLayoutTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class AttributeLayoutTest
extends TestCase {
    public void testBadData() {
        AttributeLayoutTest.assertTrue((boolean)this.throwsException(null, 0, ""));
        AttributeLayoutTest.assertTrue((boolean)this.throwsException("", 0, ""));
        AttributeLayoutTest.assertTrue((!this.throwsException("name", 0, "") ? 1 : 0) != 0);
        AttributeLayoutTest.assertTrue((!this.throwsException("name", 2, "") ? 1 : 0) != 0);
        AttributeLayoutTest.assertTrue((!this.throwsException("name", 1, "") ? 1 : 0) != 0);
        AttributeLayoutTest.assertTrue((!this.throwsException("name", 3, "") ? 1 : 0) != 0);
        AttributeLayoutTest.assertTrue((boolean)this.throwsException("name", -1, ""));
        AttributeLayoutTest.assertTrue((boolean)this.throwsException("name", 1234, ""));
    }

    public void testLayoutRU() throws Pack200Exception {
        AttributeLayout layout = new AttributeLayout("RU", 0, "RU", 1);
        TestSegment segment = new TestSegment(this);
        AttributeLayoutTest.assertNull((Object)layout.getValue(-1L, segment.getConstantPool()));
        AttributeLayoutTest.assertEquals((Object)"Zero", (Object)layout.getValue(0L, segment.getConstantPool()));
        AttributeLayoutTest.assertEquals((Object)"One", (Object)layout.getValue(1L, segment.getConstantPool()));
    }

    public void testLayoutRUN() throws Pack200Exception {
        AttributeLayout layout = new AttributeLayout("RUN", 0, "RUN", 1);
        TestSegment segment = new TestSegment(this);
        AttributeLayoutTest.assertNull((Object)layout.getValue(0L, segment.getConstantPool()));
        AttributeLayoutTest.assertEquals((Object)"Zero", (Object)layout.getValue(1L, segment.getConstantPool()));
        AttributeLayoutTest.assertEquals((Object)"One", (Object)layout.getValue(2L, segment.getConstantPool()));
    }

    public void testLayoutRS() throws Pack200Exception {
        AttributeLayout layout = new AttributeLayout("RS", 0, "RS", 1);
        TestSegment segment = new TestSegment(this);
        AttributeLayoutTest.assertNull((Object)layout.getValue(-1L, segment.getConstantPool()));
        AttributeLayoutTest.assertEquals((Object)"Ein", (Object)layout.getValue(0L, segment.getConstantPool()));
        AttributeLayoutTest.assertEquals((Object)"Zwei", (Object)layout.getValue(1L, segment.getConstantPool()));
    }

    public void testLayoutRSN() throws Pack200Exception {
        AttributeLayout layout = new AttributeLayout("RSN", 0, "RSN", 1);
        TestSegment segment = new TestSegment(this);
        AttributeLayoutTest.assertNull((Object)layout.getValue(0L, segment.getConstantPool()));
        AttributeLayoutTest.assertEquals((Object)"Ein", (Object)layout.getValue(1L, segment.getConstantPool()));
        AttributeLayoutTest.assertEquals((Object)"Zwei", (Object)layout.getValue(2L, segment.getConstantPool()));
    }

    public boolean throwsException(String name, int context, String layout) {
        try {
            new AttributeLayout(name, context, layout, -1);
            return false;
        }
        catch (Pack200Exception e) {
            return true;
        }
    }
}

