/*! \file gsm_08_18.h */

#pragma once

#include <stdint.h>

/*! Fixed BVCI definitions (Section 5.4.1) */
#define BVCI_SIGNALLING	0x0000
#define BVCI_PTM	0x0001

/*! BSSGP PDU types (Section 11.3.26 / Table 11.27) */
enum bssgp_pdu_type {
	/* PDUs between RL and BSSGP SAPs */
	BSSGP_PDUT_DL_UNITDATA		= 0x00,
	BSSGP_PDUT_UL_UNITDATA		= 0x01,
	BSSGP_PDUT_RA_CAPABILITY	= 0x02,
	BSSGP_PDUT_PTM_UNITDATA		= 0x03,
	/* PDUs between GMM SAPs */
	BSSGP_PDUT_PAGING_PS		= 0x06,
	BSSGP_PDUT_PAGING_CS		= 0x07,
	BSSGP_PDUT_RA_CAPA_UDPATE	= 0x08,
	BSSGP_PDUT_RA_CAPA_UPDATE_ACK	= 0x09,
	BSSGP_PDUT_RADIO_STATUS		= 0x0a,
	BSSGP_PDUT_SUSPEND		= 0x0b,
	BSSGP_PDUT_SUSPEND_ACK		= 0x0c,
	BSSGP_PDUT_SUSPEND_NACK		= 0x0d,
	BSSGP_PDUT_RESUME		= 0x0e,
	BSSGP_PDUT_RESUME_ACK		= 0x0f,
	BSSGP_PDUT_RESUME_NACK		= 0x10,
	/* PDus between NM SAPs */
	BSSGP_PDUT_BVC_BLOCK		= 0x20,
	BSSGP_PDUT_BVC_BLOCK_ACK	= 0x21,
	BSSGP_PDUT_BVC_RESET		= 0x22,
	BSSGP_PDUT_BVC_RESET_ACK	= 0x23,
	BSSGP_PDUT_BVC_UNBLOCK		= 0x24,
	BSSGP_PDUT_BVC_UNBLOCK_ACK	= 0x25,
	BSSGP_PDUT_FLOW_CONTROL_BVC	= 0x26,
	BSSGP_PDUT_FLOW_CONTROL_BVC_ACK	= 0x27,
	BSSGP_PDUT_FLOW_CONTROL_MS	= 0x28,
	BSSGP_PDUT_FLOW_CONTROL_MS_ACK	= 0x29,
	BSSGP_PDUT_FLUSH_LL		= 0x2a,
	BSSGP_PDUT_FLUSH_LL_ACK		= 0x2b,
	BSSGP_PDUT_LLC_DISCARD		= 0x2c,
	BSSGP_PDUT_SGSN_INVOKE_TRACE	= 0x40,
	BSSGP_PDUT_STATUS		= 0x41,
	/* PDUs between PFM SAP's */
	BSSGP_PDUT_DOWNLOAD_BSS_PFC	= 0x50,
	BSSGP_PDUT_CREATE_BSS_PFC	= 0x51,
	BSSGP_PDUT_CREATE_BSS_PFC_ACK	= 0x52,
	BSSGP_PDUT_CREATE_BSS_PFC_NACK	= 0x53,
	BSSGP_PDUT_MODIFY_BSS_PFC	= 0x54,
	BSSGP_PDUT_MODIFY_BSS_PFC_ACK	= 0x55,
	BSSGP_PDUT_DELETE_BSS_PFC	= 0x56,
	BSSGP_PDUT_DELETE_BSS_PFC_ACK	= 0x57,
};

/*! BSSGP User-Data header (Section 10.2.1 and 10.2.2) */
struct bssgp_ud_hdr {
	uint8_t pdu_type;	/*!< BSSGP PDU type */
	uint32_t tlli;		/*!< Temporary Link-Local Identifier */
	uint8_t qos_profile[3];	/*!< QoS profile */
	uint8_t data[0];	/* optional/conditional IEs as TLVs */
} __attribute__((packed));

/*! BSSGP normal header */
struct bssgp_normal_hdr {
	uint8_t pdu_type;	/*!< BSSGP PDU type */
	uint8_t data[0];	/*!< optional/conditional IEs as TLVs */
};

/*! BSSGP Information Element Identifiers */
enum bssgp_iei_type {
	BSSGP_IE_ALIGNMENT		= 0x00,
	BSSGP_IE_BMAX_DEFAULT_MS	= 0x01,
	BSSGP_IE_BSS_AREA_ID		= 0x02,
	BSSGP_IE_BUCKET_LEAK_RATE	= 0x03,
	BSSGP_IE_BVCI			= 0x04,
	BSSGP_IE_BVC_BUCKET_SIZE	= 0x05,
	BSSGP_IE_BVC_MEASUREMENT	= 0x06,
	BSSGP_IE_CAUSE			= 0x07,
	BSSGP_IE_CELL_ID		= 0x08,
	BSSGP_IE_CHAN_NEEDED		= 0x09,
	BSSGP_IE_DRX_PARAMS		= 0x0a,
	BSSGP_IE_EMLPP_PRIO		= 0x0b,
	BSSGP_IE_FLUSH_ACTION		= 0x0c,
	BSSGP_IE_IMSI			= 0x0d,
	BSSGP_IE_LLC_PDU		= 0x0e,
	BSSGP_IE_LLC_FRAMES_DISCARDED	= 0x0f,
	BSSGP_IE_LOCATION_AREA		= 0x10,
	BSSGP_IE_MOBILE_ID		= 0x11,
	BSSGP_IE_MS_BUCKET_SIZE		= 0x12,
	BSSGP_IE_MS_RADIO_ACCESS_CAP	= 0x13,
	BSSGP_IE_OMC_ID			= 0x14,
	BSSGP_IE_PDU_IN_ERROR		= 0x15,
	BSSGP_IE_PDU_LIFETIME		= 0x16,
	BSSGP_IE_PRIORITY		= 0x17,
	BSSGP_IE_QOS_PROFILE		= 0x18,
	BSSGP_IE_RADIO_CAUSE		= 0x19,
	BSSGP_IE_RA_CAP_UPD_CAUSE	= 0x1a,
	BSSGP_IE_ROUTEING_AREA		= 0x1b,
	BSSGP_IE_R_DEFAULT_MS		= 0x1c,
	BSSGP_IE_SUSPEND_REF_NR		= 0x1d,
	BSSGP_IE_TAG			= 0x1e,
	BSSGP_IE_TLLI			= 0x1f,
	BSSGP_IE_TMSI			= 0x20,
	BSSGP_IE_TRACE_REFERENC		= 0x21,
	BSSGP_IE_TRACE_TYPE		= 0x22,
	BSSGP_IE_TRANSACTION_ID		= 0x23,
	BSSGP_IE_TRIGGER_ID		= 0x24,
	BSSGP_IE_NUM_OCT_AFF		= 0x25,
	BSSGP_IE_LSA_ID_LIST		= 0x26,
	BSSGP_IE_LSA_INFORMATION	= 0x27,
	BSSGP_IE_PACKET_FLOW_ID		= 0x28,
	BSSGP_IE_PACKET_FLOW_TIMER	= 0x29,
	BSSGP_IE_AGG_BSS_QOS_PROFILE	= 0x3a,
	BSSGP_IE_FEATURE_BITMAP		= 0x3b,
	BSSGP_IE_BUCKET_FULL_RATIO	= 0x3c,
	BSSGP_IE_SERVICE_UTRAN_CCO	= 0x3d,
};

/*! Cause coding (Section 11.3.8 / Table 11.10) */
enum gprs_bssgp_cause {
	BSSGP_CAUSE_PROC_OVERLOAD		= 0x00,
	BSSGP_CAUSE_EQUIP_FAIL			= 0x01,
	BSSGP_CAUSE_TRASIT_NET_FAIL		= 0x02,
	BSSGP_CAUSE_CAPA_GREATER_0KPBS		= 0x03,
	BSSGP_CAUSE_UNKNOWN_MS			= 0x04,
	BSSGP_CAUSE_UNKNOWN_BVCI		= 0x05,
	BSSGP_CAUSE_CELL_TRAF_CONG		= 0x06,
	BSSGP_CAUSE_SGSN_CONG			= 0x07,
	BSSGP_CAUSE_OML_INTERV			= 0x08,
	BSSGP_CAUSE_BVCI_BLOCKED		= 0x09,
	BSSGP_CAUSE_PFC_CREATE_FAIL		= 0x0a,
	BSSGP_CAUSE_PFC_PREEMPTED		= 0x0b,
	BSSGP_CAUSE_ABQP_NOT_SUPP		= 0x0c,
	BSSGP_CAUSE_SEM_INCORR_PDU		= 0x20,
	BSSGP_CAUSE_INV_MAND_INF		= 0x21,
	BSSGP_CAUSE_MISSING_MAND_IE		= 0x22,
	BSSGP_CAUSE_MISSING_COND_IE		= 0x23,
	BSSGP_CAUSE_UNEXP_COND_IE		= 0x24,
	BSSGP_CAUSE_COND_IE_ERR			= 0x25,
	BSSGP_CAUSE_PDU_INCOMP_STATE		= 0x26,
	BSSGP_CAUSE_PROTO_ERR_UNSPEC		= 0x27,
	BSSGP_CAUSE_PDU_INCOMP_FEAT		= 0x28,
	BSSGP_CAUSE_REQ_INFO_NOT_AVAIL		= 0x29,
	BSSGP_CAUSE_UNKN_DST			= 0x2a,
	BSSGP_CAUSE_UNKN_RIM_AI			= 0x2b,
	BSSGP_CAUSE_INVAL_CONT_UI		= 0x2c,
	BSSGP_CAUSE_PFC_QUEUE			= 0x2d,
	BSSGP_CAUSE_PFC_CREATED			= 0x2e,
	BSSGP_CAUSE_T12_EXPIRY			= 0x2f,
	BSSGP_CAUSE_MS_UNDER_PS_HO		= 0x30,
	BSSGP_CAUSE_UL_QUALITY			= 0x31,
	BSSGP_CAUSE_UL_STRENGTH			= 0x32,
	BSSGP_CAUSE_DL_QUALITY			= 0x33,
	BSSGP_CAUSE_DL_STRENGTH			= 0x34,
	BSSGP_CAUSE_DISTANCE			= 0x35,
	BSSGP_CAUSE_BETTER_CELL			= 0x36,
	BSSGP_CAUSE_TRAFFIC			= 0x37,
	BSSGP_CAUSE_MS_RADIO_LOSS		= 0x38,
	BSSGP_CAUSE_MS_BACK_OLD_CHAN		= 0x39,
	BSSGP_CAUSE_T13_EXPIRY			= 0x3a,
	BSSGP_CAUSE_T14_EXPIRY			= 0x3b,
	BSSGP_CAUSE_NOT_ALL_PFC			= 0x3c,
	BSSGP_CAUSE_CS				= 0x3d,
	BSSGP_CAUSE_REQ_ALG_NOT_SUPP		= 0x3e,
	BSSGP_CAUSE_RELOC_FAIL			= 0x3f,
	BSSGP_CAUSE_DIR_RETRY			= 0x40,
	BSSGP_CAUSE_TIME_CRIT_RELOC		= 0x41,
	BSSGP_CAUSE_PS_HO_TARG_NA		= 0x42,
	BSSGP_CAUSE_PS_HO_TARG_NOT_SUPP		= 0x43,
	BSSGP_CAUSE_PUESBINE			= 0x44,
	BSSGP_CAUSE_DTM_HO_NO_CS_RES		= 0x45,
	BSSGP_CAUSE_DTM_HO_PS_ALLOC_FAIL	= 0x46,
	BSSGP_CAUSE_DTM_HO_T24_EXPIRY		= 0x47,
	BSSGP_CAUSE_DTM_HO_INVAL_CS_IND		= 0x48,
	BSSGP_CAUSE_DTM_HO_T23_EXPIRY		= 0x49,
	BSSGP_CAUSE_DTM_HO_MSC_ERR		= 0x4a,
	BSSGP_CAUSE_INVAL_CSG_CELL		= 0x4b,
};
