/*
  Copyright (c) 2013-2017 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef GRANTLEETHEME_THEME_P_H
#define GRANTLEETHEME_THEME_P_H

#include "grantleetheme.h"
#include "grantleeki18nlocalizer.h"

#include <grantlee/template.h>
#include <grantlee/templateloader.h>
#include <grantlee/engine.h>

namespace GrantleeTheme {
class GRANTLEETHEME_NO_EXPORT ThemePrivate : public QSharedData
{
public:
    ThemePrivate();
    ThemePrivate(const ThemePrivate &other);
    ~ThemePrivate();

    static void setupEngine();
    void setupLoader();
    Grantlee::Context createContext(const QVariantHash &data = QVariantHash(), const QByteArray &applicationDomain = QByteArray());
    QString errorTemplate(const QString &reason, const QString &templateName, const Grantlee::Template &errorTemplate);

    QStringList displayExtraVariables;
    QString themeFileName;
    QString description;
    QString name;
    QString dirName;
    QString absolutePath;
    QString author;
    QString email;

    QSharedPointer<Grantlee::FileSystemTemplateLoader> loader;

    static QSharedPointer<GrantleeKi18nLocalizer> sLocalizer;
    static Grantlee::Engine *sEngine;
};
}

#endif
