/*
 * This code is auto-generated from Wikidata data. Licensed under CC0.
 */


#include "airportdb.h"
#include "airportdb_p.h"
#include "knowledgedb.h"
#include "timezonedb.h"

#include <limits>

using namespace KItinerary::KnowledgeDb;

namespace KItinerary {
namespace KnowledgeDb {

// airport data sorted by IATA code
// the corresponding index is used to acces data the following tables
static constexpr Airport airport_table[] = {
    Airport{IataCode{"AAA"}, CountryId{"FR"}, Timezone{6740}}, // Anaa Airport
    Airport{IataCode{"AAB"}, CountryId{"AU"}, Timezone{4901}}, // Arrabury Airport
    Airport{IataCode{"AAC"}, CountryId{"EG"}, Timezone{184}}, // El Arish International Airport
    Airport{IataCode{"AAE"}, CountryId{"DZ"}, Timezone{47}}, // Rabah Bitat Airport
    Airport{IataCode{"AAF"}, CountryId{"US"}, Timezone{}}, // Apalachicola Regional Airport
    Airport{IataCode{"AAG"}, CountryId{"BR"}, Timezone{3216}}, // Arapoti Airport
    Airport{IataCode{"AAI"}, CountryId{"BR"}, Timezone{865}}, // Arraias Airport
    Airport{IataCode{"AAJ"}, CountryId{"SR"}, Timezone{2912}}, // Cayana Airstrip
    Airport{IataCode{"AAK"}, CountryId{"KI"}, Timezone{6755}}, // Aranuka Airport
    Airport{IataCode{"AAL"}, CountryId{"DK"}, Timezone{5312}}, // Aalborg Airport
    Airport{IataCode{"AAM"}, CountryId{"ZA"}, Timezone{369}}, // Mala Mala Airport
    Airport{IataCode{"AAN"}, CountryId{"AE"}, Timezone{3902}}, // Al Ain International Airport
    Airport{IataCode{"AAO"}, CountryId{"VE"}, Timezone{1463}}, // Anaco Airport
    Airport{IataCode{"AAP"}, CountryId{"US"}, Timezone{1510}}, // Andrau Airpark
    Airport{IataCode{"AAQ"}, CountryId{"RU"}, Timezone{5620}}, // Anapa Airport
    Airport{IataCode{"AAR"}, CountryId{"DK"}, Timezone{5312}}, // Aarhus Airport
    Airport{IataCode{"AAS"}, CountryId{"ID"}, Timezone{4032}}, // Apalapsili Airport
    Airport{IataCode{"AAT"}, CountryId{"CN"}, Timezone{4607}}, // Altay Airport
    Airport{IataCode{"AAU"}, CountryId{"WS"}, Timezone{6205}}, // Asau Airport
    Airport{IataCode{"AAV"}, CountryId{"PH"}, Timezone{4240}}, // Allah Valley Airport
    Airport{IataCode{"AAW"}, CountryId{"PK"}, Timezone{4087}}, // Abbottabad Airport
    Airport{IataCode{"AAX"}, CountryId{"BR"}, Timezone{3216}}, // Araxá Airport
    Airport{IataCode{"AAY"}, CountryId{"YE"}, Timezone{3634}}, // Al Ghaydah Airport
    Airport{IataCode{"AAZ"}, CountryId{"GT"}, Timezone{1913}}, // Aeropuerto Internacional Los Altos
    Airport{IataCode{"ABA"}, CountryId{"RU"}, Timezone{4142}}, // Abakan International Airport
    Airport{IataCode{"ABB"}, CountryId{"NG"}, Timezone{462}}, // Asaba International Airport
    Airport{IataCode{"ABC"}, CountryId{"ES"}, Timezone{5549}}, // Albacete Airport
    Airport{IataCode{"ABD"}, CountryId{"IR"}, Timezone{3728}}, // Abadan Airport
    Airport{IataCode{"ABE"}, CountryId{"US"}, Timezone{2712}}, // Lehigh Valley International Airport
    Airport{IataCode{"ABF"}, CountryId{"KI"}, Timezone{6755}}, // Abaiang Atoll Airport
    Airport{IataCode{"ABG"}, CountryId{"AU"}, Timezone{4920}}, // Abingdon Airport
    Airport{IataCode{"ABH"}, CountryId{"AU"}, Timezone{4920}}, // Alpha Airport
    Airport{IataCode{"ABI"}, CountryId{"US"}, Timezone{1510}}, // Abilene Regional Airport
    Airport{IataCode{"ABJ"}, CountryId{"CI"}, Timezone{0}}, // Port Bouet Airport
    Airport{IataCode{"ABK"}, CountryId{"ET"}, Timezone{28}}, // Kabri Dar Airport
    Airport{IataCode{"ABL"}, CountryId{"US"}, Timezone{814}}, // Ambler Airport
    Airport{IataCode{"ABM"}, CountryId{"AU"}, Timezone{4920}}, // Northern Peninsula Airport
    Airport{IataCode{"ABN"}, CountryId{"SR"}, Timezone{2912}}, // Albina Airstrip
    Airport{IataCode{"ABO"}, CountryId{"CI"}, Timezone{0}}, // Aboisso Airport
    Airport{IataCode{"ABP"}, CountryId{"PG"}, Timezone{4032}}, // Atkamba Airport
    Airport{IataCode{"ABQ"}, CountryId{"US"}, Timezone{1667}}, // Albuquerque International Sunport
    Airport{IataCode{"ABR"}, CountryId{"US"}, Timezone{1510}}, // Aberdeen Regional Airport
    Airport{IataCode{"ABS"}, CountryId{"EG"}, Timezone{184}}, // Abu Simbel Airport
    Airport{IataCode{"ABT"}, CountryId{"SA"}, Timezone{4404}}, // Al-Baha Domestic Airport
    Airport{IataCode{"ABU"}, CountryId{"ID"}, Timezone{4226}}, // Haliwen Airport
    Airport{IataCode{"ABV"}, CountryId{"NG"}, Timezone{462}}, // Nnamdi Azikiwe International Airport
    Airport{IataCode{"ABW"}, CountryId{"PG"}, Timezone{6686}}, // Abau Airport
    Airport{IataCode{"ABX"}, CountryId{"AU"}, Timezone{5103}}, // Albury Airport
    Airport{IataCode{"ABY"}, CountryId{"US"}, Timezone{2712}}, // Southwest Georgia Regional Airport
    Airport{IataCode{"ABZ"}, CountryId{"GB"}, Timezone{5517}}, // Aberdeen Airport
    Airport{IataCode{"ACA"}, CountryId{"MX"}, Timezone{2588}}, // General Juan N. Álvarez International Airport
    Airport{IataCode{"ACB"}, CountryId{"US"}, Timezone{1682}}, // Antrim County Airport
    Airport{IataCode{"ACC"}, CountryId{"GH"}, Timezone{15}}, // Kotoka International Airport
    Airport{IataCode{"ACD"}, CountryId{"CO"}, Timezone{1376}}, // Alcides Fernández Airport
    Airport{IataCode{"ACE"}, CountryId{"ES"}, Timezone{4755}}, // Lanzarote Airport
    Airport{IataCode{"ACH"}, CountryId{"CH"}, Timezone{6021}}, // St. Gallen-Altenrhein Airport
    Airport{IataCode{"ACI"}, CountryId{"GG"}, Timezone{5361}}, // Alderney Airport
    Airport{IataCode{"ACJ"}, CountryId{"LK"}, Timezone{3854}}, // SLAF Anuradhapura
    Airport{IataCode{"ACK"}, CountryId{"US"}, Timezone{2712}}, // Nantucket Memorial Airport
    Airport{IataCode{"ACL"}, CountryId{"CO"}, Timezone{1376}}, // Aguaclara Airport
    Airport{IataCode{"ACN"}, CountryId{"MX"}, Timezone{2501}}, // Ciudad Acuña International Airport
    Airport{IataCode{"ACP"}, CountryId{"IR"}, Timezone{4543}}, // Sahand Airport
    Airport{IataCode{"ACQ"}, CountryId{"US"}, Timezone{1510}}, // Waseca Municipal Airport
    Airport{IataCode{"ACR"}, CountryId{"CO"}, Timezone{1376}}, // Araracuara Airport
    Airport{IataCode{"ACS"}, CountryId{"RU"}, Timezone{4142}}, // Achinsk Airport
    Airport{IataCode{"ACT"}, CountryId{"US"}, Timezone{1510}}, // Waco Regional Airport
    Airport{IataCode{"ACU"}, CountryId{"PA"}, Timezone{2877}}, // Achutupo Airport
    Airport{IataCode{"ACV"}, CountryId{"US"}, Timezone{2378}}, // Arcata-Eureka Airport
    Airport{IataCode{"ACX"}, CountryId{"CN"}, Timezone{4456}}, // Xingyi Wanfenglin Airport
    Airport{IataCode{"ACY"}, CountryId{"US"}, Timezone{2712}}, // Atlantic City International Airport
    Airport{IataCode{"ACZ"}, CountryId{"IR"}, Timezone{4543}}, // Zabol Airport
    Airport{IataCode{"ADA"}, CountryId{"TR"}, Timezone{5412}}, // Adana Şakirpaşa Airport
    Airport{IataCode{"ADB"}, CountryId{"TR"}, Timezone{5412}}, // Adnan Menderes Airport
    Airport{IataCode{"ADC"}, CountryId{"PG"}, Timezone{6686}}, // Andakombe Airport
    Airport{IataCode{"ADD"}, CountryId{"ET"}, Timezone{28}}, // Addis Ababa Bole International Airport
    Airport{IataCode{"ADE"}, CountryId{"YE"}, Timezone{3634}}, // Aden International Airport
    Airport{IataCode{"ADF"}, CountryId{"TR"}, Timezone{5412}}, // Adıyaman Airport
    Airport{IataCode{"ADG"}, CountryId{"US"}, Timezone{1682}}, // Lenawee County Airport
    Airport{IataCode{"ADH"}, CountryId{"RU"}, Timezone{4665}}, // Aldan Airport
    Airport{IataCode{"ADI"}, CountryId{"NA"}, Timezone{785}}, // Arandis Airport
    Airport{IataCode{"ADJ"}, CountryId{"JO"}, Timezone{3656}}, // Amman Civil Airport
    Airport{IataCode{"ADK"}, CountryId{"US"}, Timezone{801}}, // Adak Airport
    Airport{IataCode{"ADL"}, CountryId{"AU"}, Timezone{4901}}, // Adelaide Airport
    Airport{IataCode{"ADM"}, CountryId{"US"}, Timezone{1510}}, // Ardmore Municipal Airport
    Airport{IataCode{"ADO"}, CountryId{"AU"}, Timezone{4901}}, // Andamooka Airport
    Airport{IataCode{"ADP"}, CountryId{"LK"}, Timezone{3854}}, // SLAF Ampara
    Airport{IataCode{"ADQ"}, CountryId{"US"}, Timezone{814}}, // Kodiak Airport
    Airport{IataCode{"ADR"}, CountryId{"US"}, Timezone{2712}}, // Robert F. Swinnie Airport
    Airport{IataCode{"ADS"}, CountryId{"US"}, Timezone{1510}}, // Addison Airport
    Airport{IataCode{"ADT"}, CountryId{"US"}, Timezone{1510}}, // Ada Municipal Airport
    Airport{IataCode{"ADU"}, CountryId{"IR"}, Timezone{4543}}, // Ardabil Airport
    Airport{IataCode{"ADV"}, CountryId{"SD"}, Timezone{432}}, // Ed Daein Airport
    Airport{IataCode{"ADY"}, CountryId{"ZA"}, Timezone{369}}, // Alldays Airport
    Airport{IataCode{"ADZ"}, CountryId{"CO"}, Timezone{1376}}, // Gustavo Rojas Pinilla International Airport
    Airport{IataCode{"AEA"}, CountryId{"KI"}, Timezone{}}, // Abemama Atoll Airport
    Airport{IataCode{"AEB"}, CountryId{"CN"}, Timezone{4456}}, // Baise Bama Airport
    Airport{IataCode{"AEG"}, CountryId{"ID"}, Timezone{4032}}, // Aek Godang Airport
    Airport{IataCode{"AEH"}, CountryId{"TD"}, Timezone{656}}, // Abéché Airport
    Airport{IataCode{"AEI"}, CountryId{"ES"}, Timezone{5549}}, // Algeciras Heliport
    Airport{IataCode{"AEL"}, CountryId{"US"}, Timezone{1510}}, // Albert Lea Municipal Airport
    Airport{IataCode{"AEO"}, CountryId{"MR"}, Timezone{686}}, // Aioun el Atrouss Airport
    Airport{IataCode{"AEP"}, CountryId{"AR"}, Timezone{883}}, // Aeroparque Jorge Newbery
    Airport{IataCode{"AER"}, CountryId{"RU"}, Timezone{5620}}, // Sochi International Airport
    Airport{IataCode{"AES"}, CountryId{"NO"}, Timezone{5634}}, // Ålesund Airport, Vigra
    Airport{IataCode{"AET"}, CountryId{"US"}, Timezone{814}}, // Allakaket Airport
    Airport{IataCode{"AEU"}, CountryId{"IR"}, Timezone{4543}}, // Abu Musa Airport
    Airport{IataCode{"AEX"}, CountryId{"US"}, Timezone{1510}}, // Alexandria International Airport
    Airport{IataCode{"AEY"}, CountryId{"IS"}, Timezone{4823}}, // Akureyri Airport
    Airport{IataCode{"AFA"}, CountryId{"AR"}, Timezone{1019}}, // San Rafael Airport
    Airport{IataCode{"AFD"}, CountryId{"ZA"}, Timezone{369}}, // Port Alfred Airport
    Airport{IataCode{"AFE"}, CountryId{"US"}, Timezone{3255}}, // Kake Airport
    Airport{IataCode{"AFI"}, CountryId{}, Timezone{1376}}, // Amalfi Airport
    Airport{IataCode{"AFK"}, CountryId{"US"}, Timezone{1510}}, // Nebraska City Municipal Airport
    Airport{IataCode{"AFL"}, CountryId{"BR"}, Timezone{1579}}, // Alta Floresta Airport
    Airport{IataCode{"AFN"}, CountryId{"US"}, Timezone{2712}}, // Jaffrey Airport – Silver Ranch Airpark
    Airport{IataCode{"AFO"}, CountryId{"US"}, Timezone{1667}}, // Afton Municipal Airport
    Airport{IataCode{"AFP"}, CountryId{"US"}, Timezone{2712}}, // Anson County Airport
    Airport{IataCode{"AFS"}, CountryId{"UZ"}, Timezone{4430}}, // Zarafshan Airport
    Airport{IataCode{"AFT"}, CountryId{"SB"}, Timezone{6413}}, // Afutara Airport
    Airport{IataCode{"AFW"}, CountryId{"US"}, Timezone{1510}}, // Fort Worth Alliance Airport
    Airport{IataCode{"AFY"}, CountryId{"TR"}, Timezone{5412}}, // Afyon Airport
    Airport{IataCode{"AFZ"}, CountryId{"IR"}, Timezone{4543}}, // Sabzevar Airport
    Airport{IataCode{"AGA"}, CountryId{"MA"}, Timezone{215}}, // Agadir–Al Massira Airport
    Airport{IataCode{"AGC"}, CountryId{"US"}, Timezone{2712}}, // Allegheny County Airport
    Airport{IataCode{"AGD"}, CountryId{"ID"}, Timezone{4032}}, // Anggi Airport
    Airport{IataCode{"AGF"}, CountryId{"FR"}, Timezone{5646}}, // Agen La Garenne Airport
    Airport{IataCode{"AGH"}, CountryId{"SE"}, Timezone{5822}}, // Ängelholm-Helsingborg Airport
    Airport{IataCode{"AGI"}, CountryId{"SR"}, Timezone{2912}}, // Wageningen Airstrip
    Airport{IataCode{"AGJ"}, CountryId{"JP"}, Timezone{4568}}, // Aguni Airport
    Airport{IataCode{"AGL"}, CountryId{"PG"}, Timezone{6686}}, // Wanigela Airport
    Airport{IataCode{"AGN"}, CountryId{"US"}, Timezone{2260}}, // Angoon Seaplane Base
    Airport{IataCode{"AGO"}, CountryId{"US"}, Timezone{1510}}, // Magnolia Municipal Airport
    Airport{IataCode{"AGP"}, CountryId{"ES"}, Timezone{5549}}, // Málaga Airport
    Airport{IataCode{"AGQ"}, CountryId{"GR"}, Timezone{5169}}, // Agrinion Airport
    Airport{IataCode{"AGS"}, CountryId{"US"}, Timezone{2712}}, // Augusta Regional Airport
    Airport{IataCode{"AGT"}, CountryId{"PY"}, Timezone{1220}}, // Guaraní International Airport
    Airport{IataCode{"AGU"}, CountryId{"MX"}, Timezone{2588}}, // Lic. Jesús Terán Peredo International Airport
    Airport{IataCode{"AGV"}, CountryId{"VE"}, Timezone{1463}}, // Oswaldo Guevara Mujica Airport
    Airport{IataCode{"AGW"}, CountryId{"AU"}, Timezone{4920}}, // Agnew Airport
    Airport{IataCode{"AGX"}, CountryId{"IN"}, Timezone{4129}}, // Agatti Aerodrome
    Airport{IataCode{"AGY"}, CountryId{"AU"}, Timezone{5087}}, // Argyle Downs Airport
    Airport{IataCode{"AGZ"}, CountryId{"ZA"}, Timezone{369}}, // Aggeneys Airport
    Airport{IataCode{"AHB"}, CountryId{"SA"}, Timezone{4404}}, // Abha Regional Airport
    Airport{IataCode{"AHD"}, CountryId{"US"}, Timezone{1510}}, // Ardmore Downtown Executive Airport
    Airport{IataCode{"AHE"}, CountryId{"FR"}, Timezone{6740}}, // Ahe Airport
    Airport{IataCode{"AHF"}, CountryId{"US"}, Timezone{1510}}, // Arapahoe Municipal Airport
    Airport{IataCode{"AHH"}, CountryId{"US"}, Timezone{1510}}, // Amery Municipal Airport
    Airport{IataCode{"AHI"}, CountryId{"ID"}, Timezone{4032}}, // Amahai Airport
    Airport{IataCode{"AHJ"}, CountryId{"CN"}, Timezone{4456}}, // Hongyuan Airport
    Airport{IataCode{"AHL"}, CountryId{"GY"}, Timezone{1949}}, // Aishalton Airport
    Airport{IataCode{"AHM"}, CountryId{"US"}, Timezone{2378}}, // Ashland Municipal Airport
    Airport{IataCode{"AHN"}, CountryId{"US"}, Timezone{2712}}, // Athens Ben Epps Airport
    Airport{IataCode{"AHO"}, CountryId{"IT"}, Timezone{5702}}, // Aeroporto di Alghero-Fertilia
    Airport{IataCode{"AHQ"}, CountryId{"US"}, Timezone{1510}}, // Wahoo Municipal Airport
    Airport{IataCode{"AHS"}, CountryId{"HN"}, Timezone{3401}}, // Ahuas Airport
    Airport{IataCode{"AHU"}, CountryId{"MA"}, Timezone{215}}, // Cherif Al Idrissi Airport
    Airport{IataCode{"AHY"}, CountryId{"MG"}, Timezone{}}, // Amabatolahy Airport
    Airport{IataCode{"AHZ"}, CountryId{"FR"}, Timezone{5646}}, // Alpe d'Huez Airport
    Airport{IataCode{"AIA"}, CountryId{"US"}, Timezone{1667}}, // Alliance Municipal Airport
    Airport{IataCode{"AIC"}, CountryId{"MH"}, Timezone{6515}}, // Airok Airport
    Airport{IataCode{"AID"}, CountryId{"US"}, Timezone{2043}}, // Anderson Municipal Airport
    Airport{IataCode{"AIE"}, CountryId{"PG"}, Timezone{6686}}, // Aiome Airport
    Airport{IataCode{"AIF"}, CountryId{"BR"}, Timezone{3216}}, // Assis Airport
    Airport{IataCode{"AIG"}, CountryId{"CF"}, Timezone{104}}, // Yalinga Airport
    Airport{IataCode{"AIH"}, CountryId{"PG"}, Timezone{4032}}, // Aiambak Airport
    Airport{IataCode{"AII"}, CountryId{"DJ"}, Timezone{277}}, // Ali-Sabieh Airport
    Airport{IataCode{"AIK"}, CountryId{"US"}, Timezone{2712}}, // Aiken Municipal Airport
    Airport{IataCode{"AIL"}, CountryId{"PA"}, Timezone{2877}}, // Ailigandí Airport
    Airport{IataCode{"AIM"}, CountryId{"MH"}, Timezone{6515}}, // Ailuk Airport
    Airport{IataCode{"AIN"}, CountryId{"US"}, Timezone{814}}, // Wainwright Airport
    Airport{IataCode{"AIO"}, CountryId{"US"}, Timezone{1510}}, // Atlantic Municipal Airport
    Airport{IataCode{"AIR"}, CountryId{"BR"}, Timezone{1579}}, // Aripuanã Airport
    Airport{IataCode{"AIS"}, CountryId{"KI"}, Timezone{}}, // Arorae Island Airport
    Airport{IataCode{"AIT"}, CountryId{"NZ"}, Timezone{6707}}, // Aitutaki Airport
    Airport{IataCode{"AIU"}, CountryId{"NZ"}, Timezone{6707}}, // Enua Airport
    Airport{IataCode{"AIV"}, CountryId{"US"}, Timezone{1510}}, // George Downer Airport
    Airport{IataCode{"AIY"}, CountryId{"US"}, Timezone{2712}}, // Bader Field
    Airport{IataCode{"AIZ"}, CountryId{"US"}, Timezone{1510}}, // Lee C. Fine Memorial Airport
    Airport{IataCode{"AJA"}, CountryId{"FR"}, Timezone{5646}}, // Ajaccio Napoleon Bonaparte Airport
    Airport{IataCode{"AJF"}, CountryId{"SA"}, Timezone{4404}}, // Al-Jawf Domestic Airport
    Airport{IataCode{"AJI"}, CountryId{"TR"}, Timezone{5412}}, // Ağrı Airport
    Airport{IataCode{"AJJ"}, CountryId{"MR"}, Timezone{686}}, // Akjoujt Airport
    Airport{IataCode{"AJK"}, CountryId{"IR"}, Timezone{4543}}, // Arak Airport
    Airport{IataCode{"AJL"}, CountryId{"IN"}, Timezone{4129}}, // Lengpui Airport
    Airport{IataCode{"AJN"}, CountryId{"KM"}, Timezone{6099}}, // Ouani Airport
    Airport{IataCode{"AJO"}, CountryId{"US"}, Timezone{2378}}, // Corona Municipal Airport
    Airport{IataCode{"AJR"}, CountryId{"SE"}, Timezone{5822}}, // Arvidsjaur Airport
    Airport{IataCode{"AJS"}, CountryId{"MX"}, Timezone{2519}}, // Punta Abreojos Airstrip
    Airport{IataCode{"AJU"}, CountryId{"BR"}, Timezone{2420}}, // Santa Maria Airport
    Airport{IataCode{"AJY"}, CountryId{"NE"}, Timezone{672}}, // Mano Dayak International Airport
    Airport{IataCode{"AKA"}, CountryId{"CN"}, Timezone{4456}}, // Ankang Wulipu Airport
    Airport{IataCode{"AKB"}, CountryId{"US"}, Timezone{801}}, // Atka Airport
    Airport{IataCode{"AKC"}, CountryId{"US"}, Timezone{2712}}, // Akron Fulton International Airport
    Airport{IataCode{"AKD"}, CountryId{"IN"}, Timezone{4129}}, // Akola Airport
    Airport{IataCode{"AKE"}, CountryId{"GA"}, Timezone{475}}, // Akieni Airport
    Airport{IataCode{"AKF"}, CountryId{"LY"}, Timezone{757}}, // Kufra Airport
    Airport{IataCode{"AKI"}, CountryId{"US"}, Timezone{814}}, // Akiak Airport
    Airport{IataCode{"AKJ"}, CountryId{"JP"}, Timezone{4568}}, // Asahikawa Airport
    Airport{IataCode{"AKK"}, CountryId{"US"}, Timezone{814}}, // Akhiok Airport
    Airport{IataCode{"AKL"}, CountryId{"NZ"}, Timezone{6218}}, // Auckland Airport
    Airport{IataCode{"AKM"}, CountryId{"TD"}, Timezone{656}}, // Zakouma Airport
    Airport{IataCode{"AKN"}, CountryId{"US"}, Timezone{814}}, // King Salmon Airport
    Airport{IataCode{"AKO"}, CountryId{"US"}, Timezone{1667}}, // Colorado Plains Regional Airport
    Airport{IataCode{"AKP"}, CountryId{"US"}, Timezone{814}}, // Anaktuvuk Pass Airport
    Airport{IataCode{"AKQ"}, CountryId{"ID"}, Timezone{4032}}, // Gunung Batin Airport
    Airport{IataCode{"AKR"}, CountryId{"NG"}, Timezone{462}}, // Akure Airport
    Airport{IataCode{"AKS"}, CountryId{"SB"}, Timezone{6413}}, // Auki Gwaunaru'u Airport
    Airport{IataCode{"AKU"}, CountryId{"CN"}, Timezone{4607}}, // Aksu Airport
    Airport{IataCode{"AKV"}, CountryId{"CA"}, Timezone{2228}}, // Akulivik Airport
    Airport{IataCode{"AKW"}, CountryId{"IR"}, Timezone{4543}}, // Aghajari Airport
    Airport{IataCode{"AKX"}, CountryId{"KZ"}, Timezone{3690}}, // Aktobe Airport
    Airport{IataCode{"AKY"}, CountryId{"MM"}, Timezone{4678}}, // Sittwe Airport
    Airport{IataCode{"ALA"}, CountryId{"KZ"}, Timezone{3644}}, // Almaty International Airport
    Airport{IataCode{"ALB"}, CountryId{"US"}, Timezone{2712}}, // Albany International Airport
    Airport{IataCode{"ALC"}, CountryId{"ES"}, Timezone{5549}}, // Alicante Airport
    Airport{IataCode{"ALD"}, CountryId{"PE"}, Timezone{2365}}, // Alerta Airport
    Airport{IataCode{"ALE"}, CountryId{"US"}, Timezone{1510}}, // Alpine-Casparis Municipal Airport
    Airport{IataCode{"ALF"}, CountryId{"NO"}, Timezone{5634}}, // Alta Airport
    Airport{IataCode{"ALG"}, CountryId{"DZ"}, Timezone{47}}, // Houari Boumediene Airport
    Airport{IataCode{"ALH"}, CountryId{"AU"}, Timezone{5087}}, // Albany Airport
    Airport{IataCode{"ALI"}, CountryId{"US"}, Timezone{1510}}, // Alice International Airport
    Airport{IataCode{"ALJ"}, CountryId{"ZA"}, Timezone{785}}, // Alexander Bay Airport
    Airport{IataCode{"ALL"}, CountryId{"IT"}, Timezone{5702}}, // Albenga Airport
    Airport{IataCode{"ALM"}, CountryId{"US"}, Timezone{1667}}, // Alamogordo–White Sands Regional Airport
    Airport{IataCode{"ALN"}, CountryId{"US"}, Timezone{1510}}, // St. Louis Regional Airport
    Airport{IataCode{"ALO"}, CountryId{"US"}, Timezone{1510}}, // Waterloo Regional Airport
    Airport{IataCode{"ALP"}, CountryId{"SY"}, Timezone{3867}}, // Aleppo International Airport
    Airport{IataCode{"ALQ"}, CountryId{"BR"}, Timezone{3216}}, // Alegrete Airport
    Airport{IataCode{"ALR"}, CountryId{"NZ"}, Timezone{6218}}, // Alexandra Aerodrome
    Airport{IataCode{"ALS"}, CountryId{"US"}, Timezone{1667}}, // San Luis Valley Regional Airport
    Airport{IataCode{"ALU"}, CountryId{"SO"}, Timezone{608}}, // Alula Airport
    Airport{IataCode{"ALV"}, CountryId{"AD"}, Timezone{5549}}, // Andorra la Vella Heliport
    Airport{IataCode{"ALW"}, CountryId{"US"}, Timezone{2378}}, // Walla Walla Regional Airport
    Airport{IataCode{"ALX"}, CountryId{"US"}, Timezone{1510}}, // Thomas C. Russell Field
    Airport{IataCode{"ALY"}, CountryId{"EG"}, Timezone{184}}, // El Nouzha Airport
    Airport{IataCode{"ALZ"}, CountryId{"US"}, Timezone{814}}, // Alitak Seaplane Base
    Airport{IataCode{"AMA"}, CountryId{"US"}, Timezone{1510}}, // Rick Husband Amarillo International Airport
    Airport{IataCode{"AMB"}, CountryId{"MG"}, Timezone{6035}}, // Ambilobe Airport
    Airport{IataCode{"AMC"}, CountryId{"TD"}, Timezone{656}}, // Am Timan Airport
    Airport{IataCode{"AMD"}, CountryId{"IN"}, Timezone{4129}}, // Sardar Vallabhbhai Patel International Airport
    Airport{IataCode{"AMH"}, CountryId{"ET"}, Timezone{28}}, // Arba Minch Airport
    Airport{IataCode{"AMI"}, CountryId{"ID"}, Timezone{4226}}, // Selaparang Airport
    Airport{IataCode{"AMK"}, CountryId{"US"}, Timezone{1667}}, // Animas Air Park
    Airport{IataCode{"AMM"}, CountryId{"JO"}, Timezone{3656}}, // Queen Alia International Airport
    Airport{IataCode{"AMN"}, CountryId{"US"}, Timezone{1682}}, // Gratiot Community Airport
    Airport{IataCode{"AMO"}, CountryId{"TD"}, Timezone{656}}, // Mao Airport
    Airport{IataCode{"AMP"}, CountryId{"MG"}, Timezone{6035}}, // Ampanihy Airport
    Airport{IataCode{"AMQ"}, CountryId{"ID"}, Timezone{4032}}, // Pattimura Airport
    Airport{IataCode{"AMS"}, CountryId{"NL"}, Timezone{5120}}, // Amsterdam Airport Schiphol
    Airport{IataCode{"AMV"}, CountryId{"RU"}, Timezone{5620}}, // Amderma Airport
    Airport{IataCode{"AMW"}, CountryId{"US"}, Timezone{1510}}, // Ames Municipal Airport
    Airport{IataCode{"AMY"}, CountryId{"MG"}, Timezone{6035}}, // Ambatomainty Airport
    Airport{IataCode{"AMZ"}, CountryId{"NZ"}, Timezone{6218}}, // Ardmore Airport, New Zealand
    Airport{IataCode{"ANB"}, CountryId{"US"}, Timezone{1510}}, // Anniston Regional Airport
    Airport{IataCode{"ANC"}, CountryId{"US"}, Timezone{814}}, // Ted Stevens Anchorage International Airport
    Airport{IataCode{"AND"}, CountryId{"US"}, Timezone{2712}}, // Anderson Regional Airport
    Airport{IataCode{"ANE"}, CountryId{"FR"}, Timezone{5646}}, // Angers – Loire Airport
    Airport{IataCode{"ANF"}, CountryId{"CL"}, Timezone{3177}}, // Andrés Sabella Airport
    Airport{IataCode{"ANG"}, CountryId{"FR"}, Timezone{5646}}, // Angoulême – Brie – Champniers Airport
    Airport{IataCode{"ANI"}, CountryId{"US"}, Timezone{814}}, // Aniak Airport
    Airport{IataCode{"ANJ"}, CountryId{"CG"}, Timezone{148}}, // Zanaga Airport
    Airport{IataCode{"ANL"}, CountryId{"AO"}, Timezone{505}}, // Andulo Airport
    Airport{IataCode{"ANM"}, CountryId{"MG"}, Timezone{6035}}, // Antsirabato Airport
    Airport{IataCode{"ANN"}, CountryId{"US"}, Timezone{2569}}, // Annette Island Airport
    Airport{IataCode{"ANO"}, CountryId{"MZ"}, Timezone{565}}, // Angoche Airport
    Airport{IataCode{"ANP"}, CountryId{"US"}, Timezone{2712}}, // Lee Airport
    Airport{IataCode{"ANQ"}, CountryId{"US"}, Timezone{2043}}, // Tri-State Steuben County Airport
    Airport{IataCode{"ANR"}, CountryId{"BE"}, Timezone{5231}}, // Antwerp International Airport
    Airport{IataCode{"ANS"}, CountryId{"PE"}, Timezone{2365}}, // Andahuaylas Airport
    Airport{IataCode{"ANU"}, CountryId{"AG"}, Timezone{865}}, // V. C. Bird International Airport
    Airport{IataCode{"ANV"}, CountryId{"US"}, Timezone{814}}, // Anvik Airport
    Airport{IataCode{"ANW"}, CountryId{"US"}, Timezone{1510}}, // Ainsworth Regional Airport
    Airport{IataCode{"ANX"}, CountryId{"NO"}, Timezone{5634}}, // Andøya Airport
    Airport{IataCode{"ANY"}, CountryId{"US"}, Timezone{1510}}, // Anthony Municipal Airport
    Airport{IataCode{"AOD"}, CountryId{"TD"}, Timezone{656}}, // Abou-Deïa Airport
    Airport{IataCode{"AOE"}, CountryId{"TR"}, Timezone{5412}}, // Anadolu Airport
    Airport{IataCode{"AOG"}, CountryId{"CN"}, Timezone{4456}}, // Anshan Teng'ao Airport
    Airport{IataCode{"AOH"}, CountryId{"US"}, Timezone{2712}}, // Lima Allen County Airport
    Airport{IataCode{"AOI"}, CountryId{"IT"}, Timezone{5702}}, // Falconara Airport
    Airport{IataCode{"AOJ"}, CountryId{"JP"}, Timezone{4568}}, // Aomori Airport
    Airport{IataCode{"AOK"}, CountryId{"GR"}, Timezone{5169}}, // Karpathos Island National Airport
    Airport{IataCode{"AOL"}, CountryId{"AR"}, Timezone{942}}, // Paso de los Libres Airport
    Airport{IataCode{"AOM"}, CountryId{"OM"}, Timezone{4252}}, // Adam Airport
    Airport{IataCode{"AOO"}, CountryId{"US"}, Timezone{2712}}, // Altoona–Blair County Airport
    Airport{IataCode{"AOP"}, CountryId{"PE"}, Timezone{2365}}, // Alférez FAP Alfredo Vladimir Sara Bauer Airport
    Airport{IataCode{"AOR"}, CountryId{"MY"}, Timezone{4159}}, // Sultan Abdul Halim Airport
    Airport{IataCode{"AOS"}, CountryId{"US"}, Timezone{814}}, // Amook Bay Seaplane Base
    Airport{IataCode{"AOT"}, CountryId{"IT"}, Timezone{5702}}, // Aosta Airport
    Airport{IataCode{"AOU"}, CountryId{"LA"}, Timezone{4633}}, // Attapeu International Airport
    Airport{IataCode{"APA"}, CountryId{"US"}, Timezone{1667}}, // Centennial Airport
    Airport{IataCode{"APB"}, CountryId{"BO"}, Timezone{2350}}, // Apolo Airport
    Airport{IataCode{"APC"}, CountryId{"US"}, Timezone{2378}}, // Napa County Airport
    Airport{IataCode{"APF"}, CountryId{"US"}, Timezone{2712}}, // Naples Municipal Airport
    Airport{IataCode{"APK"}, CountryId{"FR"}, Timezone{6740}}, // Apataki Airport
    Airport{IataCode{"APL"}, CountryId{"MZ"}, Timezone{565}}, // Nampula Airport
    Airport{IataCode{"APN"}, CountryId{"US"}, Timezone{1682}}, // Alpena County Regional Airport
    Airport{IataCode{"APO"}, CountryId{"CO"}, Timezone{1376}}, // Antonio Roldán Betancourt Airport
    Airport{IataCode{"APQ"}, CountryId{"BR"}, Timezone{2420}}, // Arapiraca Airport
    Airport{IataCode{"APS"}, CountryId{"BR"}, Timezone{3216}}, // Anápolis Airport
    Airport{IataCode{"APT"}, CountryId{"US"}, Timezone{1510}}, // Marion County Airport
    Airport{IataCode{"APU"}, CountryId{"BR"}, Timezone{3216}}, // Apucarana Airport
    Airport{IataCode{"APV"}, CountryId{"US"}, Timezone{2378}}, // Apple Valley Airport
    Airport{IataCode{"APW"}, CountryId{"WS"}, Timezone{6205}}, // Faleolo International Airport
    Airport{IataCode{"APX"}, CountryId{"BR"}, Timezone{3216}}, // Arapongas Airport
    Airport{IataCode{"APY"}, CountryId{"BR"}, Timezone{1789}}, // Alto Parnaiba Airport
    Airport{IataCode{"APZ"}, CountryId{"AR"}, Timezone{1076}}, // Zapala Airport
    Airport{IataCode{"AQA"}, CountryId{"BR"}, Timezone{3216}}, // Araraquara Airport
    Airport{IataCode{"AQB"}, CountryId{"GT"}, Timezone{1913}}, // Quiché Airport
    Airport{IataCode{"AQC"}, CountryId{"US"}, Timezone{3255}}, // Klawock Seaplane Base
    Airport{IataCode{"AQG"}, CountryId{"CN"}, Timezone{4456}}, // Anqing Tianzhushan Airport
    Airport{IataCode{"AQI"}, CountryId{"SA"}, Timezone{4404}}, // Qaisumah Domestic Airport
    Airport{IataCode{"AQJ"}, CountryId{"JO"}, Timezone{184}}, // King Hussein International Airport
    Airport{IataCode{"AQM"}, CountryId{"BR"}, Timezone{2992}}, // Nova Vida Airport
    Airport{IataCode{"AQO"}, CountryId{"US"}, Timezone{1510}}, // Llano Municipal Airport
    Airport{IataCode{"AQP"}, CountryId{"PE"}, Timezone{2365}}, // Rodríguez Ballón International Airport
    Airport{IataCode{"AQW"}, CountryId{"US"}, Timezone{2712}}, // Harriman-and-West Airport
    Airport{IataCode{"AQY"}, CountryId{"US"}, Timezone{814}}, // Girdwood Airport
    Airport{IataCode{"ARA"}, CountryId{"US"}, Timezone{1510}}, // Acadiana Regional Airport
    Airport{IataCode{"ARB"}, CountryId{"US"}, Timezone{1682}}, // Ann Arbor Municipal Airport
    Airport{IataCode{"ARC"}, CountryId{"US"}, Timezone{814}}, // Arctic Village Airport
    Airport{IataCode{"ARD"}, CountryId{"ID"}, Timezone{4226}}, // Alor Island Airport
    Airport{IataCode{"ARE"}, CountryId{"US"}, Timezone{3012}}, // Antonio (Nery) Juarbe Pol Airport
    Airport{IataCode{"ARG"}, CountryId{"US"}, Timezone{1510}}, // Walnut Ridge Regional Airport
    Airport{IataCode{"ARH"}, CountryId{"RU"}, Timezone{5620}}, // Talagi Airport
    Airport{IataCode{"ARI"}, CountryId{"CL"}, Timezone{2365}}, // Chacalluta International Airport
    Airport{IataCode{"ARJ"}, CountryId{"ID"}, Timezone{4032}}, // Arso Airport
    Airport{IataCode{"ARK"}, CountryId{"TZ"}, Timezone{256}}, // Arusha Airport
    Airport{IataCode{"ARL"}, CountryId{"BF"}, Timezone{704}}, // Arly Airport
    Airport{IataCode{"ARM"}, CountryId{"AU"}, Timezone{5103}}, // Armidale Airport
    Airport{IataCode{"ARN"}, CountryId{"SE"}, Timezone{5822}}, // Stockholm Arlanda Airport
    Airport{IataCode{"ARQ"}, CountryId{}, Timezone{1463}}, // El Troncal Airport
    Airport{IataCode{"ARR"}, CountryId{"AR"}, Timezone{914}}, // D. Casimiro Szlapelis Airport
    Airport{IataCode{"ART"}, CountryId{"US"}, Timezone{2712}}, // Watertown International Airport
    Airport{IataCode{"ARU"}, CountryId{"BR"}, Timezone{3216}}, // Araçatuba Airport
    Airport{IataCode{"ARV"}, CountryId{"US"}, Timezone{1510}}, // Lakeland Airport
    Airport{IataCode{"ARW"}, CountryId{"RO"}, Timezone{5247}}, // Arad International Airport
    Airport{IataCode{"ARY"}, CountryId{"AU"}, Timezone{5067}}, // Ararat airport
    Airport{IataCode{"ARZ"}, CountryId{"AO"}, Timezone{505}}, // N'zeto Airport
    Airport{IataCode{"ASA"}, CountryId{"ER"}, Timezone{62}}, // Assab International Airport
    Airport{IataCode{"ASB"}, CountryId{"TM"}, Timezone{3702}}, // Ashgabat International Airport
    Airport{IataCode{"ASC"}, CountryId{"BO"}, Timezone{2350}}, // Ascencion De Guarayos Airport
    Airport{IataCode{"ASD"}, CountryId{"BS"}, Timezone{2697}}, // Andros Town International Airport
    Airport{IataCode{"ASE"}, CountryId{"US"}, Timezone{1667}}, // Aspen–Pitkin County Airport
    Airport{IataCode{"ASF"}, CountryId{"RU"}, Timezone{5152}}, // Narimanovo Airport
    Airport{IataCode{"ASG"}, CountryId{"NZ"}, Timezone{6218}}, // Ashburton Aerodrome
    Airport{IataCode{"ASH"}, CountryId{"US"}, Timezone{2712}}, // Nashua Municipal Airport
    Airport{IataCode{"ASJ"}, CountryId{"JP"}, Timezone{4568}}, // Amami Airport
    Airport{IataCode{"ASK"}, CountryId{"CI"}, Timezone{0}}, // Yamoussoukro Airport
    Airport{IataCode{"ASL"}, CountryId{"US"}, Timezone{1510}}, // Harrison County Airport
    Airport{IataCode{"ASM"}, CountryId{"ER"}, Timezone{62}}, // Asmara International Airport
    Airport{IataCode{"ASN"}, CountryId{"US"}, Timezone{1510}}, // Talladega Municipal Airport
    Airport{IataCode{"ASO"}, CountryId{"ET"}, Timezone{28}}, // Asosa Airport
    Airport{IataCode{"ASP"}, CountryId{"AU"}, Timezone{4978}}, // Alice Springs Airport
    Airport{IataCode{"ASQ"}, CountryId{"US"}, Timezone{2378}}, // Austin Airport
    Airport{IataCode{"ASR"}, CountryId{"TR"}, Timezone{5412}}, // Erkilet International Airport
    Airport{IataCode{"AST"}, CountryId{"US"}, Timezone{2378}}, // Astoria Regional Airport
    Airport{IataCode{"ASU"}, CountryId{"PY"}, Timezone{1220}}, // Silvio Pettirossi International Airport
    Airport{IataCode{"ASV"}, CountryId{"KE"}, Timezone{641}}, // Amboseli Airport
    Airport{IataCode{"ASW"}, CountryId{"EG"}, Timezone{184}}, // Aswan International Airport
    Airport{IataCode{"ASX"}, CountryId{"US"}, Timezone{1510}}, // John F. Kennedy Memorial Airport
    Airport{IataCode{"ASY"}, CountryId{"US"}, Timezone{1510}}, // Ashley Municipal Airport
    Airport{IataCode{"ATA"}, CountryId{"PE"}, Timezone{2365}}, // Comandante FAP Germán Arias Graziani Airport
    Airport{IataCode{"ATB"}, CountryId{"SD"}, Timezone{432}}, // Atbara Airport
    Airport{IataCode{"ATC"}, CountryId{"BS"}, Timezone{2697}}, // Arthur's Town Airport
    Airport{IataCode{"ATD"}, CountryId{"SB"}, Timezone{6413}}, // Uru Harbour Airport
    Airport{IataCode{"ATE"}, CountryId{"US"}, Timezone{1510}}, // Antlers Municipal Airport
    Airport{IataCode{"ATF"}, CountryId{"EC"}, Timezone{1949}}, // Chachoan Airport
    Airport{IataCode{"ATG"}, CountryId{"PE"}, Timezone{2365}}, // Tnte. Gral. Gerardo Pérez Pinedo Airport
    Airport{IataCode{"ATH"}, CountryId{"GR"}, Timezone{5169}}, // Athens International Airport
    Airport{IataCode{"ATI"}, CountryId{"UY"}, Timezone{2659}}, // Artigas Airport
    Airport{IataCode{"ATJ"}, CountryId{"MG"}, Timezone{6035}}, // Antsirabe Airport
    Airport{IataCode{"ATK"}, CountryId{"US"}, Timezone{814}}, // Atqasuk Edward Burnell Sr. Memorial Airport
    Airport{IataCode{"ATL"}, CountryId{"US"}, Timezone{2712}}, // Hartsfield–Jackson Atlanta International Airport
    Airport{IataCode{"ATM"}, CountryId{"BR"}, Timezone{3160}}, // Altamira Airport
    Airport{IataCode{"ATN"}, CountryId{"PG"}, Timezone{6686}}, // Namatanai Airport
    Airport{IataCode{"ATO"}, CountryId{"US"}, Timezone{2712}}, // Ohio University Airport
    Airport{IataCode{"ATP"}, CountryId{"PG"}, Timezone{6686}}, // Aitape Airport
    Airport{IataCode{"ATQ"}, CountryId{"IN"}, Timezone{4129}}, // Sri Guru Ram Dass Jee International Airport
    Airport{IataCode{"ATR"}, CountryId{"MR"}, Timezone{686}}, // Atar International Airport
    Airport{IataCode{"ATS"}, CountryId{"US"}, Timezone{1667}}, // Artesia Municipal Airport
    Airport{IataCode{"ATT"}, CountryId{"US"}, Timezone{2745}}, // Atmautluak Airport
    Airport{IataCode{"ATU"}, CountryId{"US"}, Timezone{801}}, // Casco Cove Coast Guard Station
    Airport{IataCode{"ATV"}, CountryId{"TD"}, Timezone{656}}, // Ati Airport
    Airport{IataCode{"ATW"}, CountryId{"US"}, Timezone{1510}}, // Appleton International Airport
    Airport{IataCode{"ATX"}, CountryId{"KZ"}, Timezone{3644}}, // Atbasar Airport
    Airport{IataCode{"ATY"}, CountryId{"US"}, Timezone{1510}}, // Watertown Regional Airport
    Airport{IataCode{"ATZ"}, CountryId{"EG"}, Timezone{184}}, // Assiut Airport
    Airport{IataCode{"AUA"}, CountryId{"NL"}, Timezone{1206}}, // Queen Beatrix International Airport
    Airport{IataCode{"AUB"}, CountryId{"BR"}, Timezone{1789}}, // Itauba Airport
    Airport{IataCode{"AUC"}, CountryId{"CO"}, Timezone{1463}}, // Santiago Pérez Quiroz Airport
    Airport{IataCode{"AUE"}, CountryId{"EG"}, Timezone{184}}, // Abu Rudeis Airport
    Airport{IataCode{"AUF"}, CountryId{"FR"}, Timezone{5646}}, // Auxerre – Branches Aerodrome
    Airport{IataCode{"AUG"}, CountryId{"US"}, Timezone{2712}}, // Augusta State Airport
    Airport{IataCode{"AUH"}, CountryId{"AE"}, Timezone{3902}}, // Abu Dhabi International Airport
    Airport{IataCode{"AUK"}, CountryId{"US"}, Timezone{2745}}, // Alakanuk Airport
    Airport{IataCode{"AUL"}, CountryId{"MH"}, Timezone{6515}}, // Aur Airport
    Airport{IataCode{"AUM"}, CountryId{"US"}, Timezone{1510}}, // Austin Municipal Airport
    Airport{IataCode{"AUN"}, CountryId{"US"}, Timezone{2378}}, // Auburn Municipal Airport
    Airport{IataCode{"AUO"}, CountryId{"US"}, Timezone{1510}}, // Auburn University Regional Airport
    Airport{IataCode{"AUP"}, CountryId{"PG"}, Timezone{6686}}, // Agaun Airport
    Airport{IataCode{"AUQ"}, CountryId{"FR"}, Timezone{6530}}, // Atuona Airport
    Airport{IataCode{"AUR"}, CountryId{"FR"}, Timezone{5646}}, // Aurillac Airport
    Airport{IataCode{"AUS"}, CountryId{"US"}, Timezone{1510}}, // Austin-Bergstrom International Airport
    Airport{IataCode{"AUU"}, CountryId{"AU"}, Timezone{4920}}, // Aurukun Airport
    Airport{IataCode{"AUW"}, CountryId{"US"}, Timezone{1510}}, // Wausau Downtown Airport
    Airport{IataCode{"AUX"}, CountryId{"BR"}, Timezone{865}}, // Araguaína Airport
    Airport{IataCode{"AUY"}, CountryId{"VU"}, Timezone{6301}}, // Anatom Airport
    Airport{IataCode{"AUZ"}, CountryId{"US"}, Timezone{1510}}, // Aurora Municipal Airport
    Airport{IataCode{"AVA"}, CountryId{"CN"}, Timezone{4456}}, // Anshun Huangguoshu Airport
    Airport{IataCode{"AVI"}, CountryId{"CU"}, Timezone{1980}}, // Máximo Gómez Airport
    Airport{IataCode{"AVK"}, CountryId{"MN"}, Timezone{4590}}, // Arvaikheer Airport
    Airport{IataCode{"AVL"}, CountryId{"US"}, Timezone{2712}}, // Asheville Regional Airport
    Airport{IataCode{"AVN"}, CountryId{"FR"}, Timezone{5646}}, // Avignon – Caumont Airport
    Airport{IataCode{"AVO"}, CountryId{"US"}, Timezone{2712}}, // Avon Park Executive Airport
    Airport{IataCode{"AVP"}, CountryId{"US"}, Timezone{2712}}, // Wilkes-Barre/Scranton International Airport
    Airport{IataCode{"AVU"}, CountryId{"SB"}, Timezone{6413}}, // Avu Avu Airport
    Airport{IataCode{"AVV"}, CountryId{"AU"}, Timezone{5067}}, // Avalon Airport
    Airport{IataCode{"AVW"}, CountryId{"US"}, Timezone{2931}}, // Marana Regional Airport
    Airport{IataCode{"AVX"}, CountryId{"US"}, Timezone{2378}}, // Catalina Airport
    Airport{IataCode{"AWA"}, CountryId{"ET"}, Timezone{28}}, // Awasa Airport
    Airport{IataCode{"AWB"}, CountryId{"PG"}, Timezone{6686}}, // Awaba Airport
    Airport{IataCode{"AWD"}, CountryId{"VU"}, Timezone{6301}}, // Aniwa Airport
    Airport{IataCode{"AWK"}, CountryId{"US"}, Timezone{}}, // Wake Island Airfield
    Airport{IataCode{"AWM"}, CountryId{"US"}, Timezone{1510}}, // West Memphis Municipal Airport
    Airport{IataCode{"AWO"}, CountryId{"US"}, Timezone{2378}}, // Arlington Municipal Airport
    Airport{IataCode{"AWZ"}, CountryId{"IR"}, Timezone{4543}}, // Ahwaz International Airport
    Airport{IataCode{"AXA"}, CountryId{"GB"}, Timezone{832}}, // Clayton J. Lloyd International Airport
    Airport{IataCode{"AXB"}, CountryId{"US"}, Timezone{3471}}, // Maxson Airfield
    Airport{IataCode{"AXC"}, CountryId{"AU"}, Timezone{4920}}, // Aramac Airport
    Airport{IataCode{"AXD"}, CountryId{"GR"}, Timezone{5169}}, // Alexandroupolis International Airport
    Airport{IataCode{"AXE"}, CountryId{"BR"}, Timezone{3216}}, // Xanxerê Airport
    Airport{IataCode{"AXF"}, CountryId{"CN"}, Timezone{4456}}, // Alxa Left Banner Bayanhot Airport
    Airport{IataCode{"AXG"}, CountryId{"US"}, Timezone{1510}}, // Algona Municipal Airport
    Airport{IataCode{"AXH"}, CountryId{"US"}, Timezone{1510}}, // Houston Southwest Airport
    Airport{IataCode{"AXJ"}, CountryId{"JP"}, Timezone{4568}}, // Amakusa Airfield
    Airport{IataCode{"AXK"}, CountryId{"YE"}, Timezone{3634}}, // Ataq Airport
    Airport{IataCode{"AXM"}, CountryId{"CO"}, Timezone{1376}}, // El Edén International Airport
    Airport{IataCode{"AXN"}, CountryId{"US"}, Timezone{1510}}, // Alexandria Municipal Airport
    Airport{IataCode{"AXP"}, CountryId{"BS"}, Timezone{2697}}, // Spring Point Airport
    Airport{IataCode{"AXQ"}, CountryId{"US"}, Timezone{2712}}, // Clarion County Airport
    Airport{IataCode{"AXS"}, CountryId{"US"}, Timezone{1510}}, // Altus/Quartz Mountain Regional Airport
    Airport{IataCode{"AXT"}, CountryId{"JP"}, Timezone{4568}}, // Akita Airport
    Airport{IataCode{"AXU"}, CountryId{"ET"}, Timezone{28}}, // Axum Airport
    Airport{IataCode{"AXV"}, CountryId{"US"}, Timezone{2712}}, // Neil Armstrong Airport
    Airport{IataCode{"AYA"}, CountryId{"CO"}, Timezone{1376}}, // Ayapel Airport
    Airport{IataCode{"AYK"}, CountryId{"KZ"}, Timezone{4389}}, // Arkalyk Airport
    Airport{IataCode{"AYN"}, CountryId{"CN"}, Timezone{4456}}, // Anyang Yudongbei Airport
    Airport{IataCode{"AYO"}, CountryId{"PY"}, Timezone{1220}}, // Juan de Ayolas Airport
    Airport{IataCode{"AYP"}, CountryId{"PE"}, Timezone{2365}}, // Coronel FAP Alfredo Mendívil Duarte Airport
    Airport{IataCode{"AYQ"}, CountryId{"AU"}, Timezone{4978}}, // Ayers Rock Airport
    Airport{IataCode{"AYR"}, CountryId{"AU"}, Timezone{4920}}, // Ayr Airport
    Airport{IataCode{"AYS"}, CountryId{"US"}, Timezone{2712}}, // Waycross-Ware County Airport
    Airport{IataCode{"AYT"}, CountryId{"TR"}, Timezone{5412}}, // Antalya International Airport
    Airport{IataCode{"AYU"}, CountryId{"PG"}, Timezone{6686}}, // Aiyura Airport
    Airport{IataCode{"AYW"}, CountryId{"ID"}, Timezone{4032}}, // Ayawasi Airport
    Airport{IataCode{"AYZ"}, CountryId{"US"}, Timezone{2712}}, // Zahn's Airport
    Airport{IataCode{"AZA"}, CountryId{"US"}, Timezone{2931}}, // Phoenix–Mesa Gateway Airport
    Airport{IataCode{"AZC"}, CountryId{"US"}, Timezone{1667}}, // Colorado City Municipal Airport
    Airport{IataCode{"AZD"}, CountryId{"IR"}, Timezone{4543}}, // Shahid Sadooghi Airport
    Airport{IataCode{"AZI"}, CountryId{"AE"}, Timezone{3902}}, // Al Bateen Executive Airport
    Airport{IataCode{"AZN"}, CountryId{"UZ"}, Timezone{4516}}, // Andizhan Airport
    Airport{IataCode{"AZO"}, CountryId{"US"}, Timezone{1682}}, // Kalamazoo/Battle Creek International Airport
    Airport{IataCode{"AZR"}, CountryId{"DZ"}, Timezone{47}}, // Touat-Cheikh Sidi Mohamed Belkebir Airport
    Airport{IataCode{"AZS"}, CountryId{"DO"}, Timezone{3194}}, // Samaná El Catey International Airport
    Airport{IataCode{"AZZ"}, CountryId{"AO"}, Timezone{505}}, // Ambriz Airport
    Airport{IataCode{"BAE"}, CountryId{"FR"}, Timezone{5646}}, // Barcelonnette – Saint-Pons Airport
    Airport{IataCode{"BAF"}, CountryId{"US"}, Timezone{2712}}, // Barnes Municipal Airport
    Airport{IataCode{"BAG"}, CountryId{"PH"}, Timezone{4240}}, // Loakan Airport
    Airport{IataCode{"BAH"}, CountryId{"BH"}, Timezone{3741}}, // Bahrain International Airport
    Airport{IataCode{"BAI"}, CountryId{"CR"}, Timezone{1544}}, // Buenos Aires Airport, Costa Rica
    Airport{IataCode{"BAM"}, CountryId{"US"}, Timezone{2378}}, // Battle Mountain Airport
    Airport{IataCode{"BAN"}, CountryId{"CD"}, Timezone{446}}, // Basongo Airport
    Airport{IataCode{"BAQ"}, CountryId{"CO"}, Timezone{1376}}, // Ernesto Cortissoz International Airport
    Airport{IataCode{"BAR"}, CountryId{"CN"}, Timezone{4456}}, // Qionghai Bo'ao Airport
    Airport{IataCode{"BAS"}, CountryId{"SB"}, Timezone{6235}}, // Balalae Airport
    Airport{IataCode{"BAT"}, CountryId{"BR"}, Timezone{3216}}, // Barretos Airport
    Airport{IataCode{"BAU"}, CountryId{"BR"}, Timezone{3216}}, // Bauru Airport
    Airport{IataCode{"BAV"}, CountryId{"CN"}, Timezone{4456}}, // Baotou Erliban Airport
    Airport{IataCode{"BAX"}, CountryId{"RU"}, Timezone{3777}}, // Barnaul Airport
    Airport{IataCode{"BAY"}, CountryId{"RO"}, Timezone{5247}}, // Maramures International Airport
    Airport{IataCode{"BAZ"}, CountryId{"BR"}, Timezone{2451}}, // Barcelos Airport
    Airport{IataCode{"BBA"}, CountryId{"CL"}, Timezone{3177}}, // Balmaceda Airport
    Airport{IataCode{"BBB"}, CountryId{"US"}, Timezone{1510}}, // Benson Municipal Airport
    Airport{IataCode{"BBC"}, CountryId{"US"}, Timezone{1510}}, // Bay City Municipal Airport
    Airport{IataCode{"BBD"}, CountryId{"US"}, Timezone{1510}}, // Curtis Field
    Airport{IataCode{"BBG"}, CountryId{"TV"}, Timezone{6755}}, // Butaritari Atoll Airport
    Airport{IataCode{"BBH"}, CountryId{"DE"}, Timezone{5199}}, // Stralsund Barth Airport
    Airport{IataCode{"BBI"}, CountryId{"IN"}, Timezone{4129}}, // Biju Patnaik Airport
    Airport{IataCode{"BBK"}, CountryId{"BW"}, Timezone{785}}, // Kasane Airport
    Airport{IataCode{"BBL"}, CountryId{"AU"}, Timezone{4920}}, // Ballera Airport
    Airport{IataCode{"BBM"}, CountryId{"KH"}, Timezone{4332}}, // Battambang Airport
    Airport{IataCode{"BBN"}, CountryId{"MY"}, Timezone{4190}}, // Bario Airport
    Airport{IataCode{"BBO"}, CountryId{"SO"}, Timezone{608}}, // Berbera Airport
    Airport{IataCode{"BBP"}, CountryId{"GB"}, Timezone{5517}}, // Bembridge Airport
    Airport{IataCode{"BBQ"}, CountryId{"AG"}, Timezone{865}}, // Codrington Airport
    Airport{IataCode{"BBR"}, CountryId{"FR"}, Timezone{1894}}, // Baillif Airport
    Airport{IataCode{"BBS"}, CountryId{"GB"}, Timezone{5517}}, // Blackbushe Airport
    Airport{IataCode{"BBT"}, CountryId{"CF"}, Timezone{104}}, // Berbérati Airport
    Airport{IataCode{"BBU"}, CountryId{"RO"}, Timezone{5247}}, // Aurel Vlaicu International Airport
    Airport{IataCode{"BBV"}, CountryId{"CI"}, Timezone{0}}, // Nero-Mer Airport
    Airport{IataCode{"BBW"}, CountryId{"US"}, Timezone{1510}}, // Broken Bow Municipal Airport
    Airport{IataCode{"BBX"}, CountryId{"US"}, Timezone{2712}}, // Wings Field
    Airport{IataCode{"BBY"}, CountryId{"CF"}, Timezone{104}}, // Bambari Airport
    Airport{IataCode{"BBZ"}, CountryId{"ZM"}, Timezone{537}}, // Zambezi Airport
    Airport{IataCode{"BCA"}, CountryId{"CU"}, Timezone{1980}}, // Gustavo Rizo Airport
    Airport{IataCode{"BCB"}, CountryId{"US"}, Timezone{2712}}, // Virginia Tech Montgomery Executive Airport
    Airport{IataCode{"BCC"}, CountryId{"US"}, Timezone{814}}, // Bear Creek 3 Airport
    Airport{IataCode{"BCD"}, CountryId{"PH"}, Timezone{4240}}, // Bacolod-Silay International Airport
    Airport{IataCode{"BCE"}, CountryId{"US"}, Timezone{1667}}, // Bryce Canyon Airport
    Airport{IataCode{"BCF"}, CountryId{"CF"}, Timezone{104}}, // Bouca Airport
    Airport{IataCode{"BCH"}, CountryId{"TL"}, Timezone{3902}}, // Baucau Airport
    Airport{IataCode{"BCI"}, CountryId{"AU"}, Timezone{4920}}, // Barcaldine Airport
    Airport{IataCode{"BCK"}, CountryId{"US"}, Timezone{1510}}, // Black River Falls Area Airport
    Airport{IataCode{"BCL"}, CountryId{"CR"}, Timezone{1544}}, // Barra del Colorado Airport
    Airport{IataCode{"BCM"}, CountryId{"RO"}, Timezone{5247}}, // Bacău International Airport
    Airport{IataCode{"BCN"}, CountryId{"ES"}, Timezone{5549}}, // Barcelona–El Prat Airport
    Airport{IataCode{"BCO"}, CountryId{"ET"}, Timezone{28}}, // Baco Airport
    Airport{IataCode{"BCQ"}, CountryId{"LY"}, Timezone{757}}, // Brak Airport
    Airport{IataCode{"BCR"}, CountryId{"RS"}, Timezone{5183}}, // Bela Crkva Airport
    Airport{IataCode{"BCS"}, CountryId{"US"}, Timezone{1510}}, // Southern Seaplane Airport
    Airport{IataCode{"BCT"}, CountryId{"US"}, Timezone{2712}}, // Boca Raton Airport
    Airport{IataCode{"BCU"}, CountryId{"NG"}, Timezone{462}}, // Bauchi State Airport
    Airport{IataCode{"BCV"}, CountryId{"BZ"}, Timezone{1322}}, // Hector Silva Airstrip
    Airport{IataCode{"BCW"}, CountryId{"MZ"}, Timezone{565}}, // Benguera Island Airport
    Airport{IataCode{"BDA"}, CountryId{"GB"}, Timezone{4738}}, // L.F. Wade International Airport
    Airport{IataCode{"BDB"}, CountryId{"AU"}, Timezone{4920}}, // Bundaberg Airport
    Airport{IataCode{"BDC"}, CountryId{"BR"}, Timezone{1789}}, // Barra do Corda Airport
    Airport{IataCode{"BDD"}, CountryId{"AU"}, Timezone{4920}}, // Badu Island Airport
    Airport{IataCode{"BDE"}, CountryId{"US"}, Timezone{1510}}, // Baudette International Airport
    Airport{IataCode{"BDG"}, CountryId{"US"}, Timezone{1667}}, // Blanding Municipal Airport
    Airport{IataCode{"BDH"}, CountryId{"IR"}, Timezone{4543}}, // Bandar Lengeh Airport
    Airport{IataCode{"BDI"}, CountryId{"SC"}, Timezone{}}, // Bird Island Airport
    Airport{IataCode{"BDJ"}, CountryId{"ID"}, Timezone{4226}}, // Syamsudin Noor Airport
    Airport{IataCode{"BDK"}, CountryId{"CI"}, Timezone{0}}, // Soko Airport
    Airport{IataCode{"BDL"}, CountryId{"US"}, Timezone{2712}}, // Bradley International Airport
    Airport{IataCode{"BDN"}, CountryId{"US"}, Timezone{2378}}, // Bend Municipal Airport
    Airport{IataCode{"BDO"}, CountryId{"ID"}, Timezone{4032}}, // Husein Sastranegara International Airport
    Airport{IataCode{"BDP"}, CountryId{"NP"}, Timezone{4100}}, // Bhadrapur Airport
    Airport{IataCode{"BDQ"}, CountryId{"IN"}, Timezone{4129}}, // Vadodara Airport
    Airport{IataCode{"BDR"}, CountryId{"US"}, Timezone{2712}}, // Sikorsky Memorial Airport
    Airport{IataCode{"BDS"}, CountryId{"IT"}, Timezone{5702}}, // Brindisi – Salento Airport
    Airport{IataCode{"BDT"}, CountryId{"CD"}, Timezone{446}}, // Gbadolite Airport
    Airport{IataCode{"BDU"}, CountryId{"NO"}, Timezone{5634}}, // Bardufoss Airport
    Airport{IataCode{"BDV"}, CountryId{"CD"}, Timezone{519}}, // Moba Airport
    Airport{IataCode{"BDX"}, CountryId{"US"}, Timezone{1667}}, // Broadus Airport
    Airport{IataCode{"BDY"}, CountryId{"US"}, Timezone{2378}}, // Bandon State Airport
    Airport{IataCode{"BEB"}, CountryId{"GB"}, Timezone{5517}}, // Benbecula Airport
    Airport{IataCode{"BEC"}, CountryId{"US"}, Timezone{1510}}, // Beech Factory Airport
    Airport{IataCode{"BED"}, CountryId{"US"}, Timezone{2712}}, // Hanscom Field
    Airport{IataCode{"BEF"}, CountryId{"NI"}, Timezone{2435}}, // Bluefields Airport
    Airport{IataCode{"BEG"}, CountryId{"RS"}, Timezone{5183}}, // Belgrade Nikola Tesla Airport
    Airport{IataCode{"BEH"}, CountryId{"US"}, Timezone{1682}}, // Southwest Michigan Regional Airport
    Airport{IataCode{"BEI"}, CountryId{"ET"}, Timezone{28}}, // Beica Airport
    Airport{IataCode{"BEJ"}, CountryId{"ID"}, Timezone{4226}}, // Kalimarau Airport
    Airport{IataCode{"BEK"}, CountryId{"IN"}, Timezone{4129}}, // Bareilly Airport
    Airport{IataCode{"BEL"}, CountryId{"BR"}, Timezone{1308}}, // Val de Cans International Airport
    Airport{IataCode{"BEM"}, CountryId{"CF"}, Timezone{104}}, // Bossembélé Airport
    Airport{IataCode{"BEN"}, CountryId{"LY"}, Timezone{757}}, // Benina International Airport
    Airport{IataCode{"BEO"}, CountryId{"AU"}, Timezone{5103}}, // Belmont Airport
    Airport{IataCode{"BEP"}, CountryId{"IN"}, Timezone{4129}}, // Bellary Airport
    Airport{IataCode{"BER"}, CountryId{"DE"}, Timezone{5199}}, // Berlin Brandenburg Airport
    Airport{IataCode{"BES"}, CountryId{"FR"}, Timezone{5646}}, // Brest Bretagne Airport
    Airport{IataCode{"BET"}, CountryId{"US"}, Timezone{814}}, // Bethel Airport
    Airport{IataCode{"BEU"}, CountryId{"AU"}, Timezone{4920}}, // Bedourie Airport
    Airport{IataCode{"BEV"}, CountryId{"IL"}, Timezone{4046}}, // Be'er Sheva Airport
    Airport{IataCode{"BEW"}, CountryId{"MZ"}, Timezone{565}}, // Beira Airport
    Airport{IataCode{"BEY"}, CountryId{"LB"}, Timezone{3790}}, // Beirut–Rafic Hariri International Airport
    Airport{IataCode{"BEZ"}, CountryId{"KI"}, Timezone{}}, // Beru Island Airport
    Airport{IataCode{"BFD"}, CountryId{"US"}, Timezone{2712}}, // Bradford Regional Airport
    Airport{IataCode{"BFF"}, CountryId{"US"}, Timezone{1667}}, // Western Nebraska Regional Airport
    Airport{IataCode{"BFG"}, CountryId{"US"}, Timezone{1667}}, // Bullfrog Basin Airport
    Airport{IataCode{"BFH"}, CountryId{"BR"}, Timezone{3216}}, // Bacacheri Airport
    Airport{IataCode{"BFI"}, CountryId{"US"}, Timezone{2378}}, // Boeing Field
    Airport{IataCode{"BFJ"}, CountryId{"CN"}, Timezone{4456}}, // Bijie Feixiong Airport
    Airport{IataCode{"BFK"}, CountryId{"US"}, Timezone{1510}}, // Buffalo Municipal Airport
    Airport{IataCode{"BFL"}, CountryId{"US"}, Timezone{2378}}, // Meadows Field Airport
    Airport{IataCode{"BFM"}, CountryId{"US"}, Timezone{1510}}, // Mobile Downtown Airport
    Airport{IataCode{"BFN"}, CountryId{"ZA"}, Timezone{369}}, // Bloemfontein Airport
    Airport{IataCode{"BFO"}, CountryId{"ZW"}, Timezone{355}}, // Buffalo Range Airport
    Airport{IataCode{"BFP"}, CountryId{"US"}, Timezone{2712}}, // Beaver County Airport
    Airport{IataCode{"BFQ"}, CountryId{"PA"}, Timezone{2877}}, // Bahía Piña Airport
    Airport{IataCode{"BFR"}, CountryId{"US"}, Timezone{2043}}, // Virgil I. Grissom Municipal Airport
    Airport{IataCode{"BFS"}, CountryId{"GB"}, Timezone{5517}}, // Belfast International Airport
    Airport{IataCode{"BFT"}, CountryId{"US"}, Timezone{2712}}, // Beaufort County Airport
    Airport{IataCode{"BFU"}, CountryId{"CN"}, Timezone{4456}}, // Bengbu Airport
    Airport{IataCode{"BFV"}, CountryId{"TH"}, Timezone{3777}}, // Buriram Airport
    Airport{IataCode{"BFW"}, CountryId{"DZ"}, Timezone{47}}, // Sidi Bel Abbes Airport
    Airport{IataCode{"BFX"}, CountryId{"CM"}, Timezone{293}}, // Bafoussam Airport
    Airport{IataCode{"BGA"}, CountryId{"CO"}, Timezone{1376}}, // Palonegro International Airport
    Airport{IataCode{"BGB"}, CountryId{"GA"}, Timezone{475}}, // Booué Airport
    Airport{IataCode{"BGC"}, CountryId{"PT"}, Timezone{5486}}, // Bragança Airport
    Airport{IataCode{"BGD"}, CountryId{"US"}, Timezone{1510}}, // Hutchinson County Airport
    Airport{IataCode{"BGE"}, CountryId{"US"}, Timezone{2712}}, // Decatur County Industrial Air Park
    Airport{IataCode{"BGF"}, CountryId{"CF"}, Timezone{104}}, // Bangui M'Poko International Airport
    Airport{IataCode{"BGG"}, CountryId{"TR"}, Timezone{5412}}, // Bingöl Airport
    Airport{IataCode{"BGH"}, CountryId{"MR"}, Timezone{686}}, // Abbaye Airport
    Airport{IataCode{"BGI"}, CountryId{"BB"}, Timezone{1291}}, // Grantley Adams International Airport
    Airport{IataCode{"BGK"}, CountryId{"BZ"}, Timezone{1322}}, // Big Creek Airport
    Airport{IataCode{"BGM"}, CountryId{"US"}, Timezone{2712}}, // Greater Binghamton Airport
    Airport{IataCode{"BGN"}, CountryId{"RU"}, Timezone{4485}}, // Belaya Gora Airport
    Airport{IataCode{"BGO"}, CountryId{"NO"}, Timezone{5634}}, // Bergen Airport
    Airport{IataCode{"BGQ"}, CountryId{"US"}, Timezone{814}}, // Big Lake Airport
    Airport{IataCode{"BGR"}, CountryId{"US"}, Timezone{2712}}, // Bangor International Airport
    Airport{IataCode{"BGT"}, CountryId{"US"}, Timezone{2931}}, // Bagdad Airport
    Airport{IataCode{"BGU"}, CountryId{"CF"}, Timezone{104}}, // Bangassou Airport
    Airport{IataCode{"BGV"}, CountryId{"BR"}, Timezone{3216}}, // Bento Gonçalves Airport
    Airport{IataCode{"BGW"}, CountryId{"IQ"}, Timezone{3728}}, // Baghdad International Airport
    Airport{IataCode{"BGX"}, CountryId{"BR"}, Timezone{3216}}, // Comandante Gustavo Kraemer Airport
    Airport{IataCode{"BGY"}, CountryId{"IT"}, Timezone{5702}}, // Il Caravaggio International Airport
    Airport{IataCode{"BGZ"}, CountryId{"PT"}, Timezone{5486}}, // Braga Airport
    Airport{IataCode{"BHA"}, CountryId{"EC"}, Timezone{1949}}, // Aeropuerto Los Perales
    Airport{IataCode{"BHB"}, CountryId{"US"}, Timezone{2712}}, // Hancock County-Bar Harbor Airport
    Airport{IataCode{"BHD"}, CountryId{"GB"}, Timezone{5517}}, // George Best Belfast City Airport
    Airport{IataCode{"BHE"}, CountryId{"NZ"}, Timezone{6218}}, // Woodbourne Airport
    Airport{IataCode{"BHG"}, CountryId{"HN"}, Timezone{3401}}, // Brus Laguna Airport
    Airport{IataCode{"BHH"}, CountryId{"SA"}, Timezone{4404}}, // Bisha Domestic Airport
    Airport{IataCode{"BHI"}, CountryId{"AR"}, Timezone{883}}, // Comandante Espora Airport
    Airport{IataCode{"BHJ"}, CountryId{"IN"}, Timezone{4129}}, // Bhuj Airport
    Airport{IataCode{"BHK"}, CountryId{"UZ"}, Timezone{4430}}, // Bukhara International Airport
    Airport{IataCode{"BHL"}, CountryId{"MX"}, Timezone{3455}}, // Bahía de los Ángeles Airport
    Airport{IataCode{"BHM"}, CountryId{"US"}, Timezone{1510}}, // Birmingham-Shuttlesworth International Airport
    Airport{IataCode{"BHN"}, CountryId{"YE"}, Timezone{3634}}, // Beihan Airport
    Airport{IataCode{"BHO"}, CountryId{"IN"}, Timezone{4129}}, // Raja Bhoj Airport
    Airport{IataCode{"BHP"}, CountryId{"NP"}, Timezone{4100}}, // Bhojpur Airport
    Airport{IataCode{"BHQ"}, CountryId{"AU"}, Timezone{4939}}, // Broken Hill Airport
    Airport{IataCode{"BHR"}, CountryId{"NP"}, Timezone{4100}}, // Bharatpur Airport
    Airport{IataCode{"BHS"}, CountryId{"AU"}, Timezone{5103}}, // Bathurst Airport
    Airport{IataCode{"BHU"}, CountryId{"IN"}, Timezone{4129}}, // Bhavnagar Airport
    Airport{IataCode{"BHV"}, CountryId{"PK"}, Timezone{4087}}, // Bahawalpur Airport
    Airport{IataCode{"BHX"}, CountryId{"GB"}, Timezone{5517}}, // Birmingham Airport
    Airport{IataCode{"BHY"}, CountryId{"CN"}, Timezone{4456}}, // Beihai Fucheng Airport
    Airport{IataCode{"BIA"}, CountryId{"FR"}, Timezone{5646}}, // Bastia – Poretta Airport
    Airport{IataCode{"BIB"}, CountryId{"SO"}, Timezone{608}}, // Baidoa Airport
    Airport{IataCode{"BID"}, CountryId{"US"}, Timezone{2712}}, // Block Island State Airport
    Airport{IataCode{"BII"}, CountryId{"MH"}, Timezone{6515}}, // Bikini Atoll Airport
    Airport{IataCode{"BIK"}, CountryId{"ID"}, Timezone{4032}}, // Frans Kaisiepo Airport
    Airport{IataCode{"BIL"}, CountryId{"US"}, Timezone{1667}}, // Billings Logan International Airport
    Airport{IataCode{"BIM"}, CountryId{"BS"}, Timezone{2697}}, // South Bimini Airport
    Airport{IataCode{"BIN"}, CountryId{"AF"}, Timezone{4061}}, // Bamyan Airport
    Airport{IataCode{"BIO"}, CountryId{"ES"}, Timezone{5549}}, // Bilbao Airport
    Airport{IataCode{"BIQ"}, CountryId{"FR"}, Timezone{5646}}, // Biarritz – Anglet – Bayonne Airport
    Airport{IataCode{"BIR"}, CountryId{"NP"}, Timezone{}}, // Biratnagar Airport
    Airport{IataCode{"BIS"}, CountryId{"US"}, Timezone{}}, // Bismarck Municipal Airport
    Airport{IataCode{"BIU"}, CountryId{"IS"}, Timezone{4823}}, // Bíldudalur Airport
    Airport{IataCode{"BIV"}, CountryId{"CF"}, Timezone{104}}, // Bria Airport
    Airport{IataCode{"BIY"}, CountryId{"ZA"}, Timezone{369}}, // Bisho Airport
    Airport{IataCode{"BJA"}, CountryId{"DZ"}, Timezone{47}}, // Soummam – Abane Ramdane Airport
    Airport{IataCode{"BJB"}, CountryId{"IR"}, Timezone{4543}}, // Bojnord Airport
    Airport{IataCode{"BJC"}, CountryId{"US"}, Timezone{1667}}, // Rocky Mountain Metropolitan Airport
    Airport{IataCode{"BJD"}, CountryId{"IS"}, Timezone{4823}}, // Bakkafjörður Airport
    Airport{IataCode{"BJF"}, CountryId{"NO"}, Timezone{5634}}, // Båtsfjord Airport
    Airport{IataCode{"BJG"}, CountryId{"ID"}, Timezone{4226}}, // Bolaang Airport
    Airport{IataCode{"BJH"}, CountryId{"NP"}, Timezone{4100}}, // Bajhang Airport
    Airport{IataCode{"BJI"}, CountryId{"US"}, Timezone{1510}}, // Bemidji Regional Airport
    Airport{IataCode{"BJJ"}, CountryId{"US"}, Timezone{2712}}, // Wayne County Airport
    Airport{IataCode{"BJK"}, CountryId{"ID"}, Timezone{4032}}, // Benjina Airport
    Airport{IataCode{"BJL"}, CountryId{"GM"}, Timezone{104}}, // Banjul International Airport
    Airport{IataCode{"BJM"}, CountryId{"BI"}, Timezone{519}}, // Bujumbura International Airport
    Airport{IataCode{"BJO"}, CountryId{"BO"}, Timezone{}}, // Bermejo Airport
    Airport{IataCode{"BJP"}, CountryId{"BR"}, Timezone{3216}}, // Bragança Paulista Airport
    Airport{IataCode{"BJR"}, CountryId{"ET"}, Timezone{28}}, // Bahir Dar Airport
    Airport{IataCode{"BJT"}, CountryId{"LK"}, Timezone{}}, // Bentota River Airport
    Airport{IataCode{"BJU"}, CountryId{"NP"}, Timezone{4100}}, // Bajura Airport
    Airport{IataCode{"BJV"}, CountryId{"TR"}, Timezone{5412}}, // Milas-Bodrum Airport
    Airport{IataCode{"BJW"}, CountryId{"ID"}, Timezone{4226}}, // Bajawa Soa Airport
    Airport{IataCode{"BJX"}, CountryId{"MX"}, Timezone{2588}}, // Del Bajío International Airport
    Airport{IataCode{"BJZ"}, CountryId{"ES"}, Timezone{5549}}, // Badajoz Airport
    Airport{IataCode{"BKA"}, CountryId{"RU"}, Timezone{5620}}, // Bykovo Airport
    Airport{IataCode{"BKB"}, CountryId{"IN"}, Timezone{4129}}, // Nal Airport
    Airport{IataCode{"BKC"}, CountryId{"US"}, Timezone{814}}, // Buckland Airport
    Airport{IataCode{"BKE"}, CountryId{"US"}, Timezone{2378}}, // Baker City Municipal Airport
    Airport{IataCode{"BKF"}, CountryId{"US"}, Timezone{814}}, // Lake Brooks Seaplane Base
    Airport{IataCode{"BKG"}, CountryId{"US"}, Timezone{1510}}, // Branson Airport
    Airport{IataCode{"BKH"}, CountryId{"US"}, Timezone{6446}}, // Pacific Missile Range Facility
    Airport{IataCode{"BKI"}, CountryId{"MY"}, Timezone{}}, // Kota Kinabalu International Airport
    Airport{IataCode{"BKJ"}, CountryId{"GN"}, Timezone{228}}, // Boké Baralande Airport
    Airport{IataCode{"BKK"}, CountryId{"TH"}, Timezone{3777}}, // Suvarnabhumi Airport
    Airport{IataCode{"BKL"}, CountryId{"US"}, Timezone{2712}}, // Cleveland Burke Lakefront Airport
    Airport{IataCode{"BKM"}, CountryId{"MY"}, Timezone{4190}}, // Ba'kelalan Airport
    Airport{IataCode{"BKN"}, CountryId{"TM"}, Timezone{3702}}, // Balkanabat Airport
    Airport{IataCode{"BKO"}, CountryId{"ML"}, Timezone{76}}, // Bamako-Sénou International Airport
    Airport{IataCode{"BKQ"}, CountryId{"AU"}, Timezone{4920}}, // Blackall Airport
    Airport{IataCode{"BKR"}, CountryId{"TD"}, Timezone{656}}, // Bokoro Airport
    Airport{IataCode{"BKS"}, CountryId{"ID"}, Timezone{4032}}, // Fatmawati Soekarno Airport
    Airport{IataCode{"BKV"}, CountryId{"US"}, Timezone{2712}}, // Brooksville–Tampa Bay Regional Airport
    Airport{IataCode{"BKW"}, CountryId{"US"}, Timezone{2712}}, // Raleigh County Memorial Airport
    Airport{IataCode{"BKX"}, CountryId{"US"}, Timezone{1510}}, // Brookings Regional Airport
    Airport{IataCode{"BKY"}, CountryId{"CD"}, Timezone{519}}, // Kavumu Airport
    Airport{IataCode{"BKZ"}, CountryId{"TZ"}, Timezone{256}}, // Bukoba Airport
    Airport{IataCode{"BLA"}, CountryId{"VE"}, Timezone{1463}}, // General José Antonio Anzoátegui International Airport
    Airport{IataCode{"BLB"}, CountryId{"PA"}, Timezone{2877}}, // Panamá Pacífico International Airport
    Airport{IataCode{"BLC"}, CountryId{"CM"}, Timezone{293}}, // Bali Airport
    Airport{IataCode{"BLD"}, CountryId{"US"}, Timezone{2378}}, // Boulder City Municipal Airport
    Airport{IataCode{"BLE"}, CountryId{"SE"}, Timezone{5822}}, // Dala Airport
    Airport{IataCode{"BLF"}, CountryId{"US"}, Timezone{2712}}, // Mercer County Airport
    Airport{IataCode{"BLG"}, CountryId{"MY"}, Timezone{4190}}, // Belaga Airport
    Airport{IataCode{"BLH"}, CountryId{"US"}, Timezone{2378}}, // Blythe Airport
    Airport{IataCode{"BLJ"}, CountryId{"DZ"}, Timezone{47}}, // Mostépha Ben Boulaid Airport
    Airport{IataCode{"BLK"}, CountryId{"GB"}, Timezone{5517}}, // Blackpool Airport
    Airport{IataCode{"BLL"}, CountryId{"DK"}, Timezone{5312}}, // Billund Airport
    Airport{IataCode{"BLM"}, CountryId{"US"}, Timezone{2712}}, // Monmouth Executive Airport
    Airport{IataCode{"BLN"}, CountryId{"AU"}, Timezone{5067}}, // Benalla Airport
    Airport{IataCode{"BLO"}, CountryId{"IS"}, Timezone{4823}}, // Blönduós Airport
    Airport{IataCode{"BLQ"}, CountryId{"IT"}, Timezone{5702}}, // Bologna Guglielmo Marconi Airport
    Airport{IataCode{"BLR"}, CountryId{"IN"}, Timezone{4129}}, // Kempegowda International Airport
    Airport{IataCode{"BLT"}, CountryId{"AU"}, Timezone{4920}}, // Blackwater Airport
    Airport{IataCode{"BLU"}, CountryId{"US"}, Timezone{2378}}, // Blue Canyon–Nyack Airport
    Airport{IataCode{"BLX"}, CountryId{"IT"}, Timezone{5702}}, // Belluno Airport
    Airport{IataCode{"BLY"}, CountryId{"IE"}, Timezone{5330}}, // Belmullet Aerodrome
    Airport{IataCode{"BLZ"}, CountryId{"MW"}, Timezone{132}}, // Chileka International Airport
    Airport{IataCode{"BMA"}, CountryId{"SE"}, Timezone{5822}}, // Stockholm Bromma Airport
    Airport{IataCode{"BMB"}, CountryId{"CD"}, Timezone{446}}, // Bumba Airport
    Airport{IataCode{"BMC"}, CountryId{"US"}, Timezone{1667}}, // Brigham City Airport
    Airport{IataCode{"BMD"}, CountryId{"MG"}, Timezone{6035}}, // Belo sur Tsiribihina Airport
    Airport{IataCode{"BME"}, CountryId{"AU"}, Timezone{}}, // Broome International Airport
    Airport{IataCode{"BMF"}, CountryId{"CF"}, Timezone{104}}, // Bakouma Airport
    Airport{IataCode{"BMG"}, CountryId{"US"}, Timezone{2043}}, // Monroe County Airport
    Airport{IataCode{"BMI"}, CountryId{"US"}, Timezone{1510}}, // Central Illinois Regional Airport
    Airport{IataCode{"BMJ"}, CountryId{"GY"}, Timezone{1949}}, // Baramita Airport
    Airport{IataCode{"BMK"}, CountryId{"DE"}, Timezone{5199}}, // Borkum Airfield
    Airport{IataCode{"BML"}, CountryId{"US"}, Timezone{2712}}, // Berlin Regional Airport
    Airport{IataCode{"BMM"}, CountryId{"GA"}, Timezone{551}}, // Bitam Airport
    Airport{IataCode{"BMO"}, CountryId{"MM"}, Timezone{4678}}, // Bhamo Airport
    Airport{IataCode{"BMP"}, CountryId{"IN"}, Timezone{4129}}, // Berhampur Airport
    Airport{IataCode{"BMQ"}, CountryId{"KE"}, Timezone{641}}, // Bamburi Airport
    Airport{IataCode{"BMR"}, CountryId{"DE"}, Timezone{5199}}, // Baltrum Airport
    Airport{IataCode{"BMS"}, CountryId{"BR"}, Timezone{1254}}, // Brumado Airport
    Airport{IataCode{"BMT"}, CountryId{"US"}, Timezone{1510}}, // Beaumont Municipal Airport
    Airport{IataCode{"BMU"}, CountryId{"ID"}, Timezone{4226}}, // Bima Airport
    Airport{IataCode{"BMV"}, CountryId{"VN"}, Timezone{3964}}, // Buon Ma Thuot Airport
    Airport{IataCode{"BMW"}, CountryId{"DZ"}, Timezone{47}}, // Bordj Mokhtar Airport
    Airport{IataCode{"BMY"}, CountryId{"FR"}, Timezone{6606}}, // Île Art – Waala Airport
    Airport{IataCode{"BNA"}, CountryId{"US"}, Timezone{1510}}, // Nashville International Airport
    Airport{IataCode{"BNB"}, CountryId{"CD"}, Timezone{446}}, // Boende Airport
    Airport{IataCode{"BNC"}, CountryId{"CD"}, Timezone{519}}, // Beni Airport
    Airport{IataCode{"BND"}, CountryId{"IR"}, Timezone{4543}}, // Bandar Abbas International Airport
    Airport{IataCode{"BNE"}, CountryId{"AU"}, Timezone{4920}}, // Brisbane Airport
    Airport{IataCode{"BNG"}, CountryId{"US"}, Timezone{2378}}, // Banning Municipal Airport
    Airport{IataCode{"BNI"}, CountryId{"NG"}, Timezone{462}}, // Benin Airport
    Airport{IataCode{"BNJ"}, CountryId{"DE"}, Timezone{5199}}, // Bonn/Hangelar Airport
    Airport{IataCode{"BNK"}, CountryId{"AU"}, Timezone{5103}}, // Ballina Byron Gateway Airport
    Airport{IataCode{"BNL"}, CountryId{"US"}, Timezone{2712}}, // Barnwell Regional Airport
    Airport{IataCode{"BNN"}, CountryId{"NO"}, Timezone{5634}}, // Brønnøysund Airport, Brønnøy
    Airport{IataCode{"BNO"}, CountryId{"US"}, Timezone{2378}}, // Burns Municipal Airport
    Airport{IataCode{"BNP"}, CountryId{"PK"}, Timezone{4087}}, // Bannu Airport
    Airport{IataCode{"BNR"}, CountryId{"BF"}, Timezone{704}}, // Banfora Airport
    Airport{IataCode{"BNS"}, CountryId{"VE"}, Timezone{1463}}, // Barinas Airport
    Airport{IataCode{"BNU"}, CountryId{"BR"}, Timezone{3216}}, // Blumenau Airport
    Airport{IataCode{"BNW"}, CountryId{"US"}, Timezone{1510}}, // Boone Municipal Airport
    Airport{IataCode{"BNX"}, CountryId{"BA"}, Timezone{5746}}, // Banja Luka International Airport
    Airport{IataCode{"BNY"}, CountryId{"SB"}, Timezone{}}, // Bellona/Anua Airport
    Airport{IataCode{"BOA"}, CountryId{"CD"}, Timezone{446}}, // Boma Airport
    Airport{IataCode{"BOB"}, CountryId{"FR"}, Timezone{6740}}, // Bora Bora Airport
    Airport{IataCode{"BOC"}, CountryId{"PA"}, Timezone{2877}}, // Bocas del Toro "Isla Colón" International Airport
    Airport{IataCode{"BOD"}, CountryId{"FR"}, Timezone{5646}}, // Bordeaux–Mérignac Airport
    Airport{IataCode{"BOE"}, CountryId{"CG"}, Timezone{148}}, // Boundji Airport
    Airport{IataCode{"BOG"}, CountryId{"CO"}, Timezone{1376}}, // El Dorado International Airport
    Airport{IataCode{"BOH"}, CountryId{"GB"}, Timezone{5517}}, // Bournemouth Airport
    Airport{IataCode{"BOI"}, CountryId{"US"}, Timezone{1391}}, // Boise Airport
    Airport{IataCode{"BOJ"}, CountryId{"BG"}, Timezone{5809}}, // Burgas Airport
    Airport{IataCode{"BOK"}, CountryId{"US"}, Timezone{2378}}, // Brookings Airport
    Airport{IataCode{"BOM"}, CountryId{"IN"}, Timezone{4129}}, // Chhatrapati Shivaji International Airport
    Airport{IataCode{"BON"}, CountryId{"NL"}, Timezone{2331}}, // Flamingo International Airport
    Airport{IataCode{"BOO"}, CountryId{"NO"}, Timezone{5634}}, // Bodø Airport
    Airport{IataCode{"BOP"}, CountryId{"CF"}, Timezone{104}}, // Bouar Airport
    Airport{IataCode{"BOS"}, CountryId{"US"}, Timezone{2712}}, // Logan International Airport
    Airport{IataCode{"BOT"}, CountryId{"PG"}, Timezone{4032}}, // Bosset Airport
    Airport{IataCode{"BOU"}, CountryId{"FR"}, Timezone{5646}}, // Bourges Airport
    Airport{IataCode{"BOW"}, CountryId{"US"}, Timezone{2712}}, // Bartow Municipal Airport
    Airport{IataCode{"BOX"}, CountryId{"AU"}, Timezone{4978}}, // Borroloola Airport
    Airport{IataCode{"BOY"}, CountryId{"BF"}, Timezone{704}}, // Bobo Dioulasso Airport
    Airport{IataCode{"BOZ"}, CountryId{"CF"}, Timezone{104}}, // Bozoum Airport
    Airport{IataCode{"BPC"}, CountryId{"CM"}, Timezone{293}}, // Bamenda Airport
    Airport{IataCode{"BPE"}, CountryId{"CN"}, Timezone{4456}}, // Qinhuangdao Beidaihe Airport
    Airport{IataCode{"BPF"}, CountryId{"SB"}, Timezone{6413}}, // Batuna Airport
    Airport{IataCode{"BPG"}, CountryId{"BR"}, Timezone{1579}}, // Barra do Garças Airport
    Airport{IataCode{"BPH"}, CountryId{"PH"}, Timezone{4240}}, // Bislig Airport
    Airport{IataCode{"BPI"}, CountryId{"US"}, Timezone{1667}}, // Miley Memorial Field
    Airport{IataCode{"BPK"}, CountryId{"PG"}, Timezone{6686}}, // Biangabip Airport
    Airport{IataCode{"BPL"}, CountryId{"CN"}, Timezone{4607}}, // Bole Alashankou Airport
    Airport{IataCode{"BPM"}, CountryId{"IN"}, Timezone{4129}}, // Begumpet Airport
    Airport{IataCode{"BPN"}, CountryId{"ID"}, Timezone{4226}}, // Sultan Aji Muhammad Sulaiman Airport
    Airport{IataCode{"BPR"}, CountryId{"PH"}, Timezone{4240}}, // Borongan Airport
    Airport{IataCode{"BPS"}, CountryId{"BR"}, Timezone{1254}}, // Porto Seguro Airport
    Airport{IataCode{"BPT"}, CountryId{"US"}, Timezone{1510}}, // Jack Brooks Regional Airport
    Airport{IataCode{"BPX"}, CountryId{"CN"}, Timezone{4456}}, // Qamdo Bamda Airport
    Airport{IataCode{"BPY"}, CountryId{"MG"}, Timezone{6035}}, // Besalampy Airport
    Airport{IataCode{"BQA"}, CountryId{"PH"}, Timezone{4240}}, // Dr. Juan C. Angara Airport
    Airport{IataCode{"BQB"}, CountryId{"AU"}, Timezone{5087}}, // Busselton Regional Airport
    Airport{IataCode{"BQE"}, CountryId{"GW"}, Timezone{118}}, // Bubaque Airport
    Airport{IataCode{"BQG"}, CountryId{"RU"}, Timezone{4648}}, // Bogorodskoye Airport
    Airport{IataCode{"BQH"}, CountryId{"GB"}, Timezone{5517}}, // London Biggin Hill Airport
    Airport{IataCode{"BQJ"}, CountryId{"RU"}, Timezone{4648}}, // Batagay Airport
    Airport{IataCode{"BQK"}, CountryId{"US"}, Timezone{2712}}, // Brunswick Golden Isles Airport
    Airport{IataCode{"BQL"}, CountryId{"AU"}, Timezone{4920}}, // Boulia Airport
    Airport{IataCode{"BQN"}, CountryId{"US"}, Timezone{3012}}, // Rafael Hernández Airport
    Airport{IataCode{"BQO"}, CountryId{"CI"}, Timezone{0}}, // Tehini Airport
    Airport{IataCode{"BQQ"}, CountryId{"BR"}, Timezone{1254}}, // Barra Airport
    Airport{IataCode{"BQR"}, CountryId{"US"}, Timezone{2712}}, // Buffalo-Lancaster Regional Airport
    Airport{IataCode{"BQS"}, CountryId{"RU"}, Timezone{4456}}, // Ignatyevo Airport
    Airport{IataCode{"BQT"}, CountryId{"BY"}, Timezone{5593}}, // Brest Airport
    Airport{IataCode{"BQU"}, CountryId{"VC"}, Timezone{3360}}, // J. F. Mitchell Airport
    Airport{IataCode{"BQW"}, CountryId{"AU"}, Timezone{5087}}, // Balgo Hill Airport
    Airport{IataCode{"BRA"}, CountryId{"BR"}, Timezone{1254}}, // Barreiras Airport
    Airport{IataCode{"BRB"}, CountryId{"BR"}, Timezone{1789}}, // Barreirinhas Airport
    Airport{IataCode{"BRC"}, CountryId{"AR"}, Timezone{1076}}, // San Carlos de Bariloche Airport
    Airport{IataCode{"BRD"}, CountryId{"US"}, Timezone{1510}}, // Brainerd Lakes Regional Airport
    Airport{IataCode{"BRE"}, CountryId{"DE"}, Timezone{5199}}, // Bremen Airport
    Airport{IataCode{"BRI"}, CountryId{"IT"}, Timezone{5702}}, // Bari Karol Wojtyła Airport
    Airport{IataCode{"BRK"}, CountryId{"AU"}, Timezone{5103}}, // Bourke Airport
    Airport{IataCode{"BRL"}, CountryId{"US"}, Timezone{1510}}, // Southeast Iowa Regional Airport
    Airport{IataCode{"BRM"}, CountryId{"VE"}, Timezone{1463}}, // Jacinto Lara International Airport
    Airport{IataCode{"BRN"}, CountryId{"CH"}, Timezone{6021}}, // Bern Airport
    Airport{IataCode{"BRO"}, CountryId{"US"}, Timezone{1510}}, // Brownsville/South Padre Island International Airport
    Airport{IataCode{"BRQ"}, CountryId{"CZ"}, Timezone{5676}}, // Brno-Tuřany Airport
    Airport{IataCode{"BRR"}, CountryId{"GB"}, Timezone{5517}}, // Barra Airport
    Airport{IataCode{"BRS"}, CountryId{"GB"}, Timezone{5517}}, // Bristol Airport
    Airport{IataCode{"BRT"}, CountryId{"AU"}, Timezone{4978}}, // Bathurst Island Airport
    Airport{IataCode{"BRU"}, CountryId{"BE"}, Timezone{5231}}, // Brussels Airport
    Airport{IataCode{"BRV"}, CountryId{"RO"}, Timezone{5247}}, // Braşov Airport
    Airport{IataCode{"BRW"}, CountryId{"US"}, Timezone{814}}, // Wiley Post–Will Rogers Memorial Airport
    Airport{IataCode{"BRX"}, CountryId{"DO"}, Timezone{3194}}, // María Montez International Airport
    Airport{IataCode{"BRY"}, CountryId{"US"}, Timezone{2712}}, // Samuels Field
    Airport{IataCode{"BSA"}, CountryId{"SO"}, Timezone{608}}, // Bender Qassim International Airport
    Airport{IataCode{"BSB"}, CountryId{"BR"}, Timezone{3216}}, // Brasília International Airport
    Airport{IataCode{"BSC"}, CountryId{"CO"}, Timezone{1376}}, // José Celestino Mutis Airport
    Airport{IataCode{"BSD"}, CountryId{"CN"}, Timezone{4456}}, // Baoshan Yunduan Airport
    Airport{IataCode{"BSE"}, CountryId{"MY"}, Timezone{4348}}, // Sematan Airport
    Airport{IataCode{"BSG"}, CountryId{"GQ"}, Timezone{551}}, // Bata Airport
    Airport{IataCode{"BSJ"}, CountryId{"AU"}, Timezone{5067}}, // Bairnsdale Airport
    Airport{IataCode{"BSK"}, CountryId{"DZ"}, Timezone{47}}, // Biskra Airport
    Airport{IataCode{"BSL"}, CountryId{"FR"}, Timezone{5646}}, // EuroAirport Basel-Mulhouse-Freiburg
    Airport{IataCode{"BSN"}, CountryId{"CF"}, Timezone{104}}, // Bossangoa Airport
    Airport{IataCode{"BSO"}, CountryId{"PH"}, Timezone{4240}}, // Basco Airport
    Airport{IataCode{"BSP"}, CountryId{"PG"}, Timezone{4032}}, // Bensbach Airport
    Airport{IataCode{"BSQ"}, CountryId{"US"}, Timezone{2931}}, // Bisbee Municipal Airport
    Airport{IataCode{"BSR"}, CountryId{"IQ"}, Timezone{3728}}, // Basra International Airport
    Airport{IataCode{"BSS"}, CountryId{"BR"}, Timezone{1789}}, // Balsas Airport
    Airport{IataCode{"BST"}, CountryId{"AF"}, Timezone{4061}}, // Bost Airport
    Airport{IataCode{"BSU"}, CountryId{"CD"}, Timezone{446}}, // Basankusu Airport
    Airport{IataCode{"BSW"}, CountryId{"US"}, Timezone{814}}, // Boswell Bay Airport
    Airport{IataCode{"BSX"}, CountryId{"MM"}, Timezone{4678}}, // Pathein Airport
    Airport{IataCode{"BSY"}, CountryId{"SO"}, Timezone{608}}, // Bardera Airport
    Airport{IataCode{"BTA"}, CountryId{"CM"}, Timezone{293}}, // Bertoua Airport
    Airport{IataCode{"BTB"}, CountryId{"CG"}, Timezone{148}}, // Bétou Airport
    Airport{IataCode{"BTE"}, CountryId{"SL"}, Timezone{323}}, // Sherbro International Airport
    Airport{IataCode{"BTF"}, CountryId{"US"}, Timezone{1667}}, // Skypark Airport
    Airport{IataCode{"BTG"}, CountryId{"CF"}, Timezone{104}}, // Batangafo Airport
    Airport{IataCode{"BTH"}, CountryId{"ID"}, Timezone{4470}}, // Hang Nadim Airport
    Airport{IataCode{"BTI"}, CountryId{"US"}, Timezone{814}}, // Barter Island LRRS Airport
    Airport{IataCode{"BTJ"}, CountryId{"ID"}, Timezone{4032}}, // Sultan Iskandar Muda Airport
    Airport{IataCode{"BTK"}, CountryId{"RU"}, Timezone{4006}}, // Bratsk Airport
    Airport{IataCode{"BTL"}, CountryId{"US"}, Timezone{1682}}, // W. K. Kellogg Airport
    Airport{IataCode{"BTM"}, CountryId{"US"}, Timezone{1667}}, // Bert Mooney Airport
    Airport{IataCode{"BTN"}, CountryId{"US"}, Timezone{2712}}, // Marlboro County Jetport
    Airport{IataCode{"BTO"}, CountryId{"SR"}, Timezone{2912}}, // Botopassi Airstrip
    Airport{IataCode{"BTP"}, CountryId{"US"}, Timezone{2712}}, // Butler County Airport
    Airport{IataCode{"BTQ"}, CountryId{"RW"}, Timezone{432}}, // Butare Airport
    Airport{IataCode{"BTR"}, CountryId{"US"}, Timezone{1510}}, // Baton Rouge Metropolitan Airport
    Airport{IataCode{"BTS"}, CountryId{"SK"}, Timezone{5213}}, // M. R. Štefánik Airport
    Airport{IataCode{"BTT"}, CountryId{"US"}, Timezone{814}}, // Bettles Airport
    Airport{IataCode{"BTU"}, CountryId{"MY"}, Timezone{4190}}, // Bintulu Airport
    Airport{IataCode{"BTV"}, CountryId{"US"}, Timezone{2712}}, // Burlington International Airport
    Airport{IataCode{"BTW"}, CountryId{"ID"}, Timezone{4226}}, // Batu Licin Airport
    Airport{IataCode{"BTY"}, CountryId{"US"}, Timezone{2378}}, // Beatty Airport
    Airport{IataCode{"BUA"}, CountryId{"PG"}, Timezone{6235}}, // Buka Airport
    Airport{IataCode{"BUC"}, CountryId{"AU"}, Timezone{4920}}, // Burketown Airport
    Airport{IataCode{"BUD"}, CountryId{"HU"}, Timezone{5264}}, // Budapest Ferenc Liszt International Airport
    Airport{IataCode{"BUF"}, CountryId{"US"}, Timezone{2712}}, // Buffalo Niagara International Airport
    Airport{IataCode{"BUG"}, CountryId{"AO"}, Timezone{505}}, // Benguela Airport
    Airport{IataCode{"BUI"}, CountryId{"ID"}, Timezone{4032}}, // Bokondini Airport
    Airport{IataCode{"BUJ"}, CountryId{"DZ"}, Timezone{47}}, // Ain Eddis Airport
    Airport{IataCode{"BUK"}, CountryId{"YE"}, Timezone{3634}}, // Albuq Airport
    Airport{IataCode{"BUL"}, CountryId{"PG"}, Timezone{6686}}, // Bulolo Airport
    Airport{IataCode{"BUN"}, CountryId{"CO"}, Timezone{1376}}, // Gerardo Tobar López Airport
    Airport{IataCode{"BUO"}, CountryId{"SO"}, Timezone{608}}, // Burao Airport
    Airport{IataCode{"BUP"}, CountryId{"IN"}, Timezone{4129}}, // Bathinda Airport
    Airport{IataCode{"BUQ"}, CountryId{"ZW"}, Timezone{355}}, // Joshua Mqabuko Nkomo International Airport
    Airport{IataCode{"BUR"}, CountryId{"US"}, Timezone{2378}}, // Bob Hope Airport
    Airport{IataCode{"BUS"}, CountryId{"GE"}, Timezone{4530}}, // Batumi International Airport
    Airport{IataCode{"BUT"}, CountryId{"BT"}, Timezone{4555}}, // Bathpalathang Airport
    Airport{IataCode{"BUU"}, CountryId{"US"}, Timezone{1510}}, // Burlington Municipal Airport
    Airport{IataCode{"BUV"}, CountryId{"UY"}, Timezone{942}}, // Placeres Airport
    Airport{IataCode{"BUW"}, CountryId{"ID"}, Timezone{4226}}, // Betoambari Airport
    Airport{IataCode{"BUX"}, CountryId{"CD"}, Timezone{519}}, // Bunia Airport
    Airport{IataCode{"BUY"}, CountryId{"AU"}, Timezone{5087}}, // Bunbury Airport
    Airport{IataCode{"BUZ"}, CountryId{"IR"}, Timezone{4543}}, // Bushehr Airport
    Airport{IataCode{"BVA"}, CountryId{"FR"}, Timezone{5646}}, // Beauvais-Tillé Airport
    Airport{IataCode{"BVB"}, CountryId{"BR"}, Timezone{1358}}, // Boa Vista International Airport
    Airport{IataCode{"BVC"}, CountryId{"CV"}, Timezone{4771}}, // Aristides Pereira International Airport
    Airport{IataCode{"BVE"}, CountryId{"FR"}, Timezone{5646}}, // Brive – Souillac Airport
    Airport{IataCode{"BVG"}, CountryId{"NO"}, Timezone{5634}}, // Berlevåg Airport
    Airport{IataCode{"BVH"}, CountryId{"BR"}, Timezone{2992}}, // Vilhena Airport
    Airport{IataCode{"BVI"}, CountryId{"AU"}, Timezone{4920}}, // Birdsville Airport
    Airport{IataCode{"BVK"}, CountryId{"BO"}, Timezone{2350}}, // Huacaraje Airport
    Airport{IataCode{"BVL"}, CountryId{"BO"}, Timezone{2350}}, // Baures Airport
    Airport{IataCode{"BVN"}, CountryId{"US"}, Timezone{1510}}, // Albion Municipal Airport
    Airport{IataCode{"BVO"}, CountryId{"US"}, Timezone{1510}}, // Bartlesville Municipal Airport
    Airport{IataCode{"BVR"}, CountryId{"CV"}, Timezone{4771}}, // Esperadinha Airport
    Airport{IataCode{"BVU"}, CountryId{"US"}, Timezone{814}}, // Beluga Airport
    Airport{IataCode{"BVV"}, CountryId{"RU"}, Timezone{4619}}, // Burevestnik Airport
    Airport{IataCode{"BVW"}, CountryId{"AU"}, Timezone{4920}}, // Batavia Downs Airport
    Airport{IataCode{"BVX"}, CountryId{"US"}, Timezone{1510}}, // Batesville Regional Airport
    Airport{IataCode{"BVY"}, CountryId{"US"}, Timezone{2712}}, // Beverly Municipal Airport
    Airport{IataCode{"BWA"}, CountryId{"NP"}, Timezone{4100}}, // Gautam Buddha Airport
    Airport{IataCode{"BWB"}, CountryId{"AU"}, Timezone{5087}}, // Barrow Island Airport
    Airport{IataCode{"BWC"}, CountryId{"US"}, Timezone{2378}}, // Brawley Municipal Airport
    Airport{IataCode{"BWD"}, CountryId{"US"}, Timezone{1510}}, // Brownwood Regional Airport
    Airport{IataCode{"BWE"}, CountryId{"DE"}, Timezone{5199}}, // Braunschweig Airport
    Airport{IataCode{"BWF"}, CountryId{"GB"}, Timezone{5517}}, // Barrow/Walney Island Airport
    Airport{IataCode{"BWG"}, CountryId{"US"}, Timezone{1510}}, // Bowling Green-Warren County Regional Airport
    Airport{IataCode{"BWH"}, CountryId{"MY"}, Timezone{4159}}, // RMAF Butterworth
    Airport{IataCode{"BWI"}, CountryId{"US"}, Timezone{2712}}, // Baltimore/Washington International Thurgood Marshall Airport
    Airport{IataCode{"BWK"}, CountryId{"HR"}, Timezone{5989}}, // Bol Airport
    Airport{IataCode{"BWL"}, CountryId{"US"}, Timezone{1510}}, // Blackwell–Tonkawa Municipal Airport
    Airport{IataCode{"BWM"}, CountryId{"US"}, Timezone{1667}}, // Bowman Municipal Airport
    Airport{IataCode{"BWN"}, CountryId{"BN"}, Timezone{}}, // Brunei International Airport
    Airport{IataCode{"BWO"}, CountryId{"RU"}, Timezone{5762}}, // Balakovo Airport
    Airport{IataCode{"BWQ"}, CountryId{"AU"}, Timezone{5103}}, // Brewarrina Airport
    Airport{IataCode{"BWS"}, CountryId{"US"}, Timezone{3503}}, // Blaine Municipal Airport
    Airport{IataCode{"BWT"}, CountryId{"AU"}, Timezone{5011}}, // Burnie Airport
    Airport{IataCode{"BWU"}, CountryId{"AU"}, Timezone{5103}}, // Bankstown Airport
    Airport{IataCode{"BWW"}, CountryId{"CU"}, Timezone{1980}}, // Las Brujas Airport
    Airport{IataCode{"BWX"}, CountryId{"ID"}, Timezone{4032}}, // Blimbingsari Airport
    Airport{IataCode{"BXB"}, CountryId{"ID"}, Timezone{4032}}, // Babo Airport
    Airport{IataCode{"BXD"}, CountryId{"ID"}, Timezone{4032}}, // Bade Airport
    Airport{IataCode{"BXE"}, CountryId{"SN"}, Timezone{243}}, // Bakel Airport
    Airport{IataCode{"BXG"}, CountryId{"AU"}, Timezone{5067}}, // Bendigo Airport
    Airport{IataCode{"BXH"}, CountryId{"KZ"}, Timezone{3644}}, // Balkhash Airport
    Airport{IataCode{"BXI"}, CountryId{"CI"}, Timezone{0}}, // Boundiali Airport
    Airport{IataCode{"BXJ"}, CountryId{"KZ"}, Timezone{3644}}, // Boraldai Airport
    Airport{IataCode{"BXK"}, CountryId{"US"}, Timezone{2931}}, // Buckeye Municipal Airport
    Airport{IataCode{"BXM"}, CountryId{"ID"}, Timezone{4032}}, // Batom Airport
    Airport{IataCode{"BXN"}, CountryId{"TR"}, Timezone{5412}}, // Bodrum-Imsik Airport
    Airport{IataCode{"BXO"}, CountryId{"CH"}, Timezone{6021}}, // Buochs Airport
    Airport{IataCode{"BXP"}, CountryId{"PL"}, Timezone{5975}}, // Biała Podlaska Airport
    Airport{IataCode{"BXR"}, CountryId{"IR"}, Timezone{4543}}, // Bam Airport
    Airport{IataCode{"BXS"}, CountryId{"US"}, Timezone{2378}}, // Borrego Valley Airport
    Airport{IataCode{"BXT"}, CountryId{"ID"}, Timezone{4226}}, // Bontang Airport
    Airport{IataCode{"BXU"}, CountryId{"PH"}, Timezone{4240}}, // Bancasi Airport
    Airport{IataCode{"BXV"}, CountryId{"IS"}, Timezone{4823}}, // Breiðdalsvík Airport
    Airport{IataCode{"BXW"}, CountryId{"ID"}, Timezone{4032}}, // Bawean Airport
    Airport{IataCode{"BXX"}, CountryId{"SO"}, Timezone{28}}, // Boorama Airport
    Airport{IataCode{"BYB"}, CountryId{"OM"}, Timezone{3902}}, // Dibba Airport
    Airport{IataCode{"BYC"}, CountryId{"BO"}, Timezone{2350}}, // Yacuiba Airport
    Airport{IataCode{"BYD"}, CountryId{"YE"}, Timezone{3634}}, // Al Bayda' Airport
    Airport{IataCode{"BYF"}, CountryId{"FR"}, Timezone{5646}}, // Albert – Picardie Airport
    Airport{IataCode{"BYH"}, CountryId{"US"}, Timezone{1510}}, // Arkansas International Airport
    Airport{IataCode{"BYI"}, CountryId{"US"}, Timezone{1391}}, // Burley Municipal Airport
    Airport{IataCode{"BYJ"}, CountryId{"PT"}, Timezone{5486}}, // Beja Airport
    Airport{IataCode{"BYK"}, CountryId{"CI"}, Timezone{0}}, // Bouaké Airport
    Airport{IataCode{"BYM"}, CountryId{"CU"}, Timezone{1980}}, // Carlos Manuel de Céspedes Airport
    Airport{IataCode{"BYN"}, CountryId{"MN"}, Timezone{4590}}, // Bayankhongor Airport
    Airport{IataCode{"BYO"}, CountryId{"BR"}, Timezone{1427}}, // Bonito Airport
    Airport{IataCode{"BYP"}, CountryId{"AU"}, Timezone{5087}}, // Barimunya Airport
    Airport{IataCode{"BYQ"}, CountryId{"ID"}, Timezone{4226}}, // Bunyu Airport
    Airport{IataCode{"BYR"}, CountryId{"DK"}, Timezone{5312}}, // Læsø Airport
    Airport{IataCode{"BYT"}, CountryId{"IE"}, Timezone{5330}}, // Bantry Aerodrome
    Airport{IataCode{"BZA"}, CountryId{"NI"}, Timezone{2435}}, // San Pedro Airport
    Airport{IataCode{"BZB"}, CountryId{"MZ"}, Timezone{565}}, // Bazaruto Island Airport
    Airport{IataCode{"BZC"}, CountryId{"BR"}, Timezone{3216}}, // Armação dos Búzios Airport
    Airport{IataCode{"BZD"}, CountryId{"AU"}, Timezone{5103}}, // Balranald Airport
    Airport{IataCode{"BZE"}, CountryId{"BZ"}, Timezone{1322}}, // Philip S. W. Goldson International Airport
    Airport{IataCode{"BZF"}, CountryId{"US"}, Timezone{2378}}, // Benton Field
    Airport{IataCode{"BZG"}, CountryId{"PL"}, Timezone{5975}}, // Bydgoszcz Ignacy Jan Paderewski Airport
    Airport{IataCode{"BZK"}, CountryId{"RU"}, Timezone{5620}}, // Bryansk International Airport
    Airport{IataCode{"BZL"}, CountryId{"BD"}, Timezone{3881}}, // Barisal Airport
    Airport{IataCode{"BZN"}, CountryId{"US"}, Timezone{1667}}, // Bozeman Yellowstone International Airport
    Airport{IataCode{"BZO"}, CountryId{"IT"}, Timezone{5702}}, // Bolzano airport
    Airport{IataCode{"BZR"}, CountryId{"FR"}, Timezone{5646}}, // Béziers Cap d'Agde Airport
    Airport{IataCode{"BZU"}, CountryId{"CD"}, Timezone{519}}, // Buta Zega Airport
    Airport{IataCode{"BZV"}, CountryId{"CG"}, Timezone{148}}, // Maya-Maya Airport
    Airport{IataCode{"BZY"}, CountryId{"MD"}, Timezone{5296}}, // Bălți International Airport
    Airport{IataCode{"CAA"}, CountryId{"HN"}, Timezone{3401}}, // El Aguacate Airport
    Airport{IataCode{"CAB"}, CountryId{"AO"}, Timezone{505}}, // Cabinda Airport
    Airport{IataCode{"CAC"}, CountryId{"BR"}, Timezone{3216}}, // Cascavel Airport
    Airport{IataCode{"CAD"}, CountryId{"US"}, Timezone{1682}}, // Wexford County Airport
    Airport{IataCode{"CAE"}, CountryId{"US"}, Timezone{2712}}, // Columbia Metropolitan Airport
    Airport{IataCode{"CAF"}, CountryId{"BR"}, Timezone{2451}}, // Carauari Airport
    Airport{IataCode{"CAG"}, CountryId{"IT"}, Timezone{5702}}, // Cagliari Elmas Airport
    Airport{IataCode{"CAH"}, CountryId{"VN"}, Timezone{3964}}, // Cà Mau Airport
    Airport{IataCode{"CAI"}, CountryId{"EG"}, Timezone{184}}, // Cairo International Airport
    Airport{IataCode{"CAJ"}, CountryId{"VE"}, Timezone{1463}}, // Canaima Airport
    Airport{IataCode{"CAK"}, CountryId{"US"}, Timezone{2712}}, // Akron-Canton Airport
    Airport{IataCode{"CAL"}, CountryId{"GB"}, Timezone{5517}}, // Campbeltown Airport
    Airport{IataCode{"CAM"}, CountryId{"BO"}, Timezone{2350}}, // Camiri Airport
    Airport{IataCode{"CAN"}, CountryId{"CN"}, Timezone{4456}}, // Guangzhou Baiyun International Airport
    Airport{IataCode{"CAO"}, CountryId{"US"}, Timezone{1667}}, // Clayton Municipal Airpark
    Airport{IataCode{"CAP"}, CountryId{"HT"}, Timezone{2947}}, // Cap-Haitien International Airport
    Airport{IataCode{"CAQ"}, CountryId{"CO"}, Timezone{1376}}, // Juan H. White Airport
    Airport{IataCode{"CAR"}, CountryId{"US"}, Timezone{2712}}, // Caribou Municipal Airport
    Airport{IataCode{"CAS"}, CountryId{"MA"}, Timezone{215}}, // Casablanca-Anfa Airport
    Airport{IataCode{"CAT"}, CountryId{"PT"}, Timezone{5486}}, // Cascais Municipal Aerodrome
    Airport{IataCode{"CAU"}, CountryId{"BR"}, Timezone{3094}}, // Caruaru Airport
    Airport{IataCode{"CAV"}, CountryId{"AO"}, Timezone{505}}, // Cazombo Airport
    Airport{IataCode{"CAW"}, CountryId{"BR"}, Timezone{3216}}, // Bartolomeu Lysandro Airport
    Airport{IataCode{"CAX"}, CountryId{"GB"}, Timezone{5517}}, // Carlisle Lake District Airport
    Airport{IataCode{"CAY"}, CountryId{"FR"}, Timezone{1479}}, // Cayenne – Félix Eboué Airport
    Airport{IataCode{"CAZ"}, CountryId{"AU"}, Timezone{5103}}, // Cobar Airport
    Airport{IataCode{"CBA"}, CountryId{"DJ"}, Timezone{277}}, // Chabelley Airport
    Airport{IataCode{"CBB"}, CountryId{"BO"}, Timezone{2350}}, // Jorge Wilstermann International Airport
    Airport{IataCode{"CBE"}, CountryId{"US"}, Timezone{2712}}, // Greater Cumberland Regional Airport
    Airport{IataCode{"CBF"}, CountryId{"US"}, Timezone{1510}}, // Council Bluffs Municipal Airport
    Airport{IataCode{"CBG"}, CountryId{"GB"}, Timezone{5517}}, // Cambridge Airport
    Airport{IataCode{"CBH"}, CountryId{"DZ"}, Timezone{47}}, // Boudghene Ben Ali Lotfi Airport
    Airport{IataCode{"CBJ"}, CountryId{"DO"}, Timezone{3194}}, // Cabo Rojo Airport
    Airport{IataCode{"CBK"}, CountryId{"US"}, Timezone{1510}}, // Colby Municipal Airport
    Airport{IataCode{"CBL"}, CountryId{"VE"}, Timezone{1463}}, // Tomás de Heres Airport
    Airport{IataCode{"CBN"}, CountryId{"ID"}, Timezone{4032}}, // Penggung Airport
    Airport{IataCode{"CBO"}, CountryId{"PH"}, Timezone{4240}}, // Awang Airport
    Airport{IataCode{"CBP"}, CountryId{"PT"}, Timezone{5486}}, // Coimbra Airport
    Airport{IataCode{"CBQ"}, CountryId{"NG"}, Timezone{462}}, // Margaret Ekpo International Airport
    Airport{IataCode{"CBR"}, CountryId{"AU"}, Timezone{5103}}, // Canberra International Airport
    Airport{IataCode{"CBS"}, CountryId{"VE"}, Timezone{1463}}, // Oro Negro Airport
    Airport{IataCode{"CBT"}, CountryId{"AO"}, Timezone{505}}, // Catumbela Airport
    Airport{IataCode{"CBU"}, CountryId{"DE"}, Timezone{5199}}, // Cottbus-Drewitz Airport
    Airport{IataCode{"CBV"}, CountryId{"GT"}, Timezone{1913}}, // Cobán Airport
    Airport{IataCode{"CBW"}, CountryId{"BR"}, Timezone{3216}}, // Campo Mourão Airport
    Airport{IataCode{"CBX"}, CountryId{"AU"}, Timezone{5103}}, // Condobolin Airport
    Airport{IataCode{"CCA"}, CountryId{"BO"}, Timezone{2350}}, // Chimore Airport
    Airport{IataCode{"CCB"}, CountryId{"US"}, Timezone{2378}}, // Cable Airport
    Airport{IataCode{"CCC"}, CountryId{"CU"}, Timezone{1980}}, // Jardines del Rey Airport
    Airport{IataCode{"CCF"}, CountryId{"FR"}, Timezone{5646}}, // Carcassonne Airport
    Airport{IataCode{"CCH"}, CountryId{"CL"}, Timezone{3177}}, // Chile Chico Airport
    Airport{IataCode{"CCI"}, CountryId{"BR"}, Timezone{3216}}, // Concórdia Airport
    Airport{IataCode{"CCJ"}, CountryId{"IN"}, Timezone{4129}}, // Calicut International Airport
    Airport{IataCode{"CCK"}, CountryId{"AU"}, Timezone{}}, // Cocos (Keeling) Islands Airport
    Airport{IataCode{"CCL"}, CountryId{"AU"}, Timezone{4920}}, // Chinchilla Airport
    Airport{IataCode{"CCM"}, CountryId{"BR"}, Timezone{3216}}, // Diomício Freitas Airport
    Airport{IataCode{"CCN"}, CountryId{"AF"}, Timezone{4061}}, // Chaghcharan Airport
    Airport{IataCode{"CCO"}, CountryId{"CO"}, Timezone{1376}}, // Carimagua Airport
    Airport{IataCode{"CCP"}, CountryId{"CL"}, Timezone{3177}}, // Carriel Sur International Airport
    Airport{IataCode{"CCR"}, CountryId{"US"}, Timezone{2378}}, // Buchanan Field Airport
    Airport{IataCode{"CCS"}, CountryId{"VE"}, Timezone{1463}}, // Simón Bolívar International Airport
    Airport{IataCode{"CCT"}, CountryId{"AR"}, Timezone{1076}}, // Colonia Catriel Airport
    Airport{IataCode{"CCU"}, CountryId{"IN"}, Timezone{4129}}, // Netaji Subhas Chandra Bose International Airport
    Airport{IataCode{"CCV"}, CountryId{"VU"}, Timezone{6301}}, // Craig Cove Airport
    Airport{IataCode{"CCW"}, CountryId{"AU"}, Timezone{4901}}, // Cowell Airport
    Airport{IataCode{"CCX"}, CountryId{"BR"}, Timezone{1579}}, // Cáceres Airport
    Airport{IataCode{"CCY"}, CountryId{"US"}, Timezone{1510}}, // Northeast Iowa Regional Airport
    Airport{IataCode{"CCZ"}, CountryId{"BS"}, Timezone{2697}}, // Chub Cay International Airport
    Airport{IataCode{"CDB"}, CountryId{"US"}, Timezone{2745}}, // Cold Bay Airport
    Airport{IataCode{"CDC"}, CountryId{"US"}, Timezone{1667}}, // Cedar City Regional Airport
    Airport{IataCode{"CDD"}, CountryId{"HN"}, Timezone{3401}}, // Cauquira Airport
    Airport{IataCode{"CDE"}, CountryId{"CN"}, Timezone{4456}}, // Chengde Airport
    Airport{IataCode{"CDF"}, CountryId{"IT"}, Timezone{5702}}, // Cortina Airport
    Airport{IataCode{"CDG"}, CountryId{"FR"}, Timezone{5646}}, // Paris-Charles de Gaulle Airport
    Airport{IataCode{"CDH"}, CountryId{"US"}, Timezone{1510}}, // Harrell Field
    Airport{IataCode{"CDI"}, CountryId{"BR"}, Timezone{3216}}, // Cachoeiro de Itapemirim Airport
    Airport{IataCode{"CDJ"}, CountryId{"BR"}, Timezone{1308}}, // Conceição do Araguaia Airport
    Airport{IataCode{"CDK"}, CountryId{"US"}, Timezone{2712}}, // George T. Lewis Airport
    Airport{IataCode{"CDN"}, CountryId{"US"}, Timezone{2712}}, // Woodward Field (airport)
    Airport{IataCode{"CDP"}, CountryId{"IN"}, Timezone{4129}}, // Cuddapah Airport
    Airport{IataCode{"CDR"}, CountryId{"US"}, Timezone{1667}}, // Chadron Municipal Airport
    Airport{IataCode{"CDS"}, CountryId{"US"}, Timezone{1510}}, // Childress Municipal Airport
    Airport{IataCode{"CDT"}, CountryId{"ES"}, Timezone{5549}}, // Castellón Airport
    Airport{IataCode{"CDU"}, CountryId{"AU"}, Timezone{5103}}, // Camden Airport
    Airport{IataCode{"CDV"}, CountryId{"US"}, Timezone{814}}, // Merle K. (Mudhole) Smith Airport
    Airport{IataCode{"CDW"}, CountryId{"US"}, Timezone{2712}}, // Essex County Airport
    Airport{IataCode{"CDY"}, CountryId{"PH"}, Timezone{4240}}, // Cagayan de Sulu Airport
    Airport{IataCode{"CEA"}, CountryId{"US"}, Timezone{1510}}, // Cessna Aircraft Field
    Airport{IataCode{"CEB"}, CountryId{"PH"}, Timezone{4240}}, // Mactan–Cebu International Airport
    Airport{IataCode{"CEC"}, CountryId{"US"}, Timezone{2378}}, // Del Norte County Airport
    Airport{IataCode{"CED"}, CountryId{"AU"}, Timezone{4901}}, // Ceduna Airport
    Airport{IataCode{"CEE"}, CountryId{"RU"}, Timezone{5620}}, // Cherepovets Airport
    Airport{IataCode{"CEF"}, CountryId{"US"}, Timezone{2712}}, // Westover Metropolitan Airport
    Airport{IataCode{"CEG"}, CountryId{"GB"}, Timezone{5517}}, // Hawarden Airport
    Airport{IataCode{"CEH"}, CountryId{"MW"}, Timezone{537}}, // Chelinda Airport
    Airport{IataCode{"CEI"}, CountryId{"TH"}, Timezone{3777}}, // Mae Fah Luang – Chiang Rai International Airport
    Airport{IataCode{"CEJ"}, CountryId{"UA"}, Timezone{5461}}, // Chernihiv Shestovitsa Airport
    Airport{IataCode{"CEK"}, CountryId{"RU"}, Timezone{4690}}, // Chelyabinsk Airport
    Airport{IataCode{"CEL"}, CountryId{"BS"}, Timezone{2697}}, // Cape Eleuthera Airport
    Airport{IataCode{"CEM"}, CountryId{"US"}, Timezone{814}}, // Central Airport
    Airport{IataCode{"CEN"}, CountryId{"MX"}, Timezone{1995}}, // Ciudad Obregón International Airport
    Airport{IataCode{"CEO"}, CountryId{"AO"}, Timezone{505}}, // Waco Kungo Airport
    Airport{IataCode{"CEP"}, CountryId{"BO"}, Timezone{2350}}, // Concepcion Airport
    Airport{IataCode{"CEQ"}, CountryId{"FR"}, Timezone{5646}}, // Cannes – Mandelieu Airport
    Airport{IataCode{"CER"}, CountryId{"FR"}, Timezone{5646}}, // Cherbourg – Maupertus Airport
    Airport{IataCode{"CES"}, CountryId{"AU"}, Timezone{5103}}, // Cessnock Airport
    Airport{IataCode{"CET"}, CountryId{"FR"}, Timezone{5646}}, // Cholet - The Pontreau Aerodrome
    Airport{IataCode{"CEU"}, CountryId{"US"}, Timezone{2712}}, // Oconee County Regional Airport
    Airport{IataCode{"CEV"}, CountryId{"US"}, Timezone{2043}}, // Mettel Field
    Airport{IataCode{"CEW"}, CountryId{"US"}, Timezone{1510}}, // Bob Sikes Airport
    Airport{IataCode{"CEY"}, CountryId{"US"}, Timezone{1510}}, // Murray-Calloway County Airport
    Airport{IataCode{"CEZ"}, CountryId{"US"}, Timezone{1667}}, // Cortez Municipal Airport
    Airport{IataCode{"CFB"}, CountryId{"BR"}, Timezone{3216}}, // Cabo Frio International Airport
    Airport{IataCode{"CFC"}, CountryId{"BR"}, Timezone{3216}}, // Caçador Airport
    Airport{IataCode{"CFD"}, CountryId{"US"}, Timezone{1510}}, // Coulter Field
    Airport{IataCode{"CFE"}, CountryId{"FR"}, Timezone{5646}}, // Clermont-Ferrand Auvergne Airport
    Airport{IataCode{"CFF"}, CountryId{"AO"}, Timezone{505}}, // Cafunfo Airport
    Airport{IataCode{"CFG"}, CountryId{"CU"}, Timezone{1980}}, // Jaime González Airport
    Airport{IataCode{"CFN"}, CountryId{"IE"}, Timezone{5330}}, // Donegal Airport
    Airport{IataCode{"CFO"}, CountryId{"BR"}, Timezone{1579}}, // Confresa Airport
    Airport{IataCode{"CFQ"}, CountryId{"CA"}, Timezone{1563}}, // Creston Aerodrome
    Airport{IataCode{"CFR"}, CountryId{"FR"}, Timezone{5646}}, // Caen – Carpiquet Airport
    Airport{IataCode{"CFS"}, CountryId{"AU"}, Timezone{5103}}, // Coffs Harbour Airport
    Airport{IataCode{"CFT"}, CountryId{"US"}, Timezone{2931}}, // Greenlee County Airport
    Airport{IataCode{"CFU"}, CountryId{"GR"}, Timezone{5169}}, // Corfu International Airport
    Airport{IataCode{"CFV"}, CountryId{"US"}, Timezone{1510}}, // Coffeyville Municipal Airport
    Airport{IataCode{"CGA"}, CountryId{"US"}, Timezone{3255}}, // Craig Seaplane Base
    Airport{IataCode{"CGB"}, CountryId{"BR"}, Timezone{1579}}, // Marechal Rondon International Airport
    Airport{IataCode{"CGC"}, CountryId{"PG"}, Timezone{6686}}, // Cape Gloucester Airport
    Airport{IataCode{"CGD"}, CountryId{"CN"}, Timezone{4456}}, // Changde Taohuayuan Airport
    Airport{IataCode{"CGE"}, CountryId{"US"}, Timezone{2712}}, // Cambridge–Dorchester Airport
    Airport{IataCode{"CGF"}, CountryId{"US"}, Timezone{2712}}, // Cuyahoga County Airport
    Airport{IataCode{"CGH"}, CountryId{"BR"}, Timezone{3216}}, // Congonhas-São Paulo Airport
    Airport{IataCode{"CGI"}, CountryId{"US"}, Timezone{1510}}, // Cape Girardeau Regional Airport
    Airport{IataCode{"CGJ"}, CountryId{"ZM"}, Timezone{537}}, // Kasompe Airport
    Airport{IataCode{"CGK"}, CountryId{"ID"}, Timezone{4032}}, // Soekarno–Hatta International Airport
    Airport{IataCode{"CGM"}, CountryId{"PH"}, Timezone{4240}}, // Camiguin Airport
    Airport{IataCode{"CGN"}, CountryId{"DE"}, Timezone{5199}}, // Cologne Bonn Airport
    Airport{IataCode{"CGO"}, CountryId{"CN"}, Timezone{4456}}, // Zhengzhou Xinzheng International Airport
    Airport{IataCode{"CGP"}, CountryId{"BD"}, Timezone{}}, // Shah Amanat International Airport
    Airport{IataCode{"CGQ"}, CountryId{"CN"}, Timezone{4456}}, // Dafangshen Airport
    Airport{IataCode{"CGR"}, CountryId{"BR"}, Timezone{1427}}, // Campo Grande International Airport
    Airport{IataCode{"CGS"}, CountryId{"US"}, Timezone{2712}}, // College Park Airport
    Airport{IataCode{"CGY"}, CountryId{"PH"}, Timezone{4240}}, // Laguindingan International Airport
    Airport{IataCode{"CGZ"}, CountryId{"US"}, Timezone{2931}}, // Casa Grande Municipal Airport
    Airport{IataCode{"CHA"}, CountryId{"US"}, Timezone{2712}}, // Chattanooga Metropolitan Airport
    Airport{IataCode{"CHB"}, CountryId{"PK"}, Timezone{4087}}, // Chilas Airport
    Airport{IataCode{"CHC"}, CountryId{"NZ"}, Timezone{6218}}, // Christchurch International Airport
    Airport{IataCode{"CHD"}, CountryId{"US"}, Timezone{2931}}, // Chandler Municipal Airport
    Airport{IataCode{"CHF"}, CountryId{"KR"}, Timezone{4445}}, // Jinhae Airport
    Airport{IataCode{"CHG"}, CountryId{"CN"}, Timezone{4456}}, // Chaoyang Airport
    Airport{IataCode{"CHH"}, CountryId{"PE"}, Timezone{2365}}, // Chachapoyas Airport
    Airport{IataCode{"CHJ"}, CountryId{"ZW"}, Timezone{355}}, // Chipinge Airport
    Airport{IataCode{"CHK"}, CountryId{"US"}, Timezone{1510}}, // Chickasha Municipal Airport
    Airport{IataCode{"CHL"}, CountryId{"US"}, Timezone{1391}}, // Challis Airport
    Airport{IataCode{"CHM"}, CountryId{"PE"}, Timezone{2365}}, // Tnte. FAP Jaime Montreuil Morales Airport
    Airport{IataCode{"CHN"}, CountryId{"KR"}, Timezone{4445}}, // Jeonju Airport
    Airport{IataCode{"CHO"}, CountryId{"US"}, Timezone{2712}}, // Charlottesville Albemarle Airport
    Airport{IataCode{"CHP"}, CountryId{"US"}, Timezone{814}}, // Circle Hot Springs Airport
    Airport{IataCode{"CHQ"}, CountryId{"GR"}, Timezone{5169}}, // Chania International Airport
    Airport{IataCode{"CHR"}, CountryId{"FR"}, Timezone{5646}}, // Châteauroux-Centre "Marcel Dassault" Airport
    Airport{IataCode{"CHS"}, CountryId{"US"}, Timezone{2712}}, // Charleston International Airport
    Airport{IataCode{"CHT"}, CountryId{"NZ"}, Timezone{6256}}, // Chatham Islands / Tuuta Airport
    Airport{IataCode{"CHU"}, CountryId{"US"}, Timezone{814}}, // Chuathbaluk Airport
    Airport{IataCode{"CHV"}, CountryId{"PT"}, Timezone{5486}}, // Chaves Airport
    Airport{IataCode{"CHX"}, CountryId{"PA"}, Timezone{1544}}, // Changuinola "Capitán Manuel Niño" International Airport
    Airport{IataCode{"CHY"}, CountryId{"SB"}, Timezone{6413}}, // Choiseul Bay Airport
    Airport{IataCode{"CHZ"}, CountryId{"US"}, Timezone{2378}}, // Chiloquin State Airport
    Airport{IataCode{"CIA"}, CountryId{"IT"}, Timezone{5702}}, // Ciampino–G.B. Pastine International Airport
    Airport{IataCode{"CIC"}, CountryId{"US"}, Timezone{2378}}, // Chico Municipal Airport
    Airport{IataCode{"CID"}, CountryId{"US"}, Timezone{1510}}, // The Eastern Iowa Airport
    Airport{IataCode{"CIF"}, CountryId{"CN"}, Timezone{4456}}, // Chifeng Yulong Airport
    Airport{IataCode{"CIG"}, CountryId{"US"}, Timezone{1667}}, // Craig–Moffat Airport
    Airport{IataCode{"CIH"}, CountryId{"CN"}, Timezone{4456}}, // Changzhi Wangcun Airport
    Airport{IataCode{"CII"}, CountryId{"US"}, Timezone{1667}}, // Choteau Airport
    Airport{IataCode{"CIJ"}, CountryId{"BO"}, Timezone{3141}}, // Captain Aníbal Arab Airport
    Airport{IataCode{"CIK"}, CountryId{"US"}, Timezone{814}}, // Chalkyitsik Airport
    Airport{IataCode{"CIL"}, CountryId{"US"}, Timezone{2745}}, // Council Airport
    Airport{IataCode{"CIM"}, CountryId{"CO"}, Timezone{1376}}, // Cimitarra Airport
    Airport{IataCode{"CIN"}, CountryId{"US"}, Timezone{1510}}, // Arthur N. Neu Airport
    Airport{IataCode{"CIO"}, CountryId{"PY"}, Timezone{1220}}, // Teniente Coronel Carmelo Peralta Airport
    Airport{IataCode{"CIP"}, CountryId{"ZM"}, Timezone{537}}, // Chipata Airport
    Airport{IataCode{"CIQ"}, CountryId{"GT"}, Timezone{1913}}, // Chiquimula Airport
    Airport{IataCode{"CIS"}, CountryId{"KI"}, Timezone{6315}}, // Canton Island Airport
    Airport{IataCode{"CIT"}, CountryId{"KZ"}, Timezone{3644}}, // Shymkent International Airport
    Airport{IataCode{"CIU"}, CountryId{"US"}, Timezone{1682}}, // Chippewa County International Airport
    Airport{IataCode{"CIW"}, CountryId{"VC"}, Timezone{3360}}, // Canouan Airport
    Airport{IataCode{"CIX"}, CountryId{"PE"}, Timezone{2365}}, // Cap. FAP José A. Quiñones Gonzáles International Airport
    Airport{IataCode{"CIY"}, CountryId{"IT"}, Timezone{5702}}, // Comiso Airport
    Airport{IataCode{"CIZ"}, CountryId{"BR"}, Timezone{2451}}, // Coari Airport
    Airport{IataCode{"CJA"}, CountryId{"PE"}, Timezone{2365}}, // Mayor General FAP Armando Revoredo Iglesias Airport
    Airport{IataCode{"CJB"}, CountryId{"IN"}, Timezone{4129}}, // Coimbatore Airport
    Airport{IataCode{"CJC"}, CountryId{"CL"}, Timezone{3177}}, // El Loa Airport
    Airport{IataCode{"CJF"}, CountryId{"AU"}, Timezone{5087}}, // Coondewanna Airport
    Airport{IataCode{"CJH"}, CountryId{"CA"}, Timezone{3503}}, // Chilko Lake (Tsylos Park Lodge) Aerodrome
    Airport{IataCode{"CJJ"}, CountryId{"KR"}, Timezone{4445}}, // Cheongju International Airport
    Airport{IataCode{"CJL"}, CountryId{"PK"}, Timezone{4087}}, // Chitral Airport
    Airport{IataCode{"CJM"}, CountryId{"TH"}, Timezone{3777}}, // Chumphon Airport
    Airport{IataCode{"CJN"}, CountryId{"ID"}, Timezone{4032}}, // Nusawiru Airport
    Airport{IataCode{"CJR"}, CountryId{"US"}, Timezone{2712}}, // Culpeper Regional Airport
    Airport{IataCode{"CJS"}, CountryId{"MX"}, Timezone{2861}}, // Abraham González International Airport
    Airport{IataCode{"CJT"}, CountryId{"MX"}, Timezone{2588}}, // Comitán Airport
    Airport{IataCode{"CJU"}, CountryId{"KR"}, Timezone{4445}}, // Jeju International Airport
    Airport{IataCode{"CJZ"}, CountryId{"BR"}, Timezone{1789}}, // Cajazeiras Airport
    Airport{IataCode{"CKB"}, CountryId{"US"}, Timezone{2712}}, // North Central West Virginia Airport
    Airport{IataCode{"CKC"}, CountryId{"UA"}, Timezone{5461}}, // Cherkasy International Airport
    Airport{IataCode{"CKD"}, CountryId{"US"}, Timezone{814}}, // Crooked Creek Airport
    Airport{IataCode{"CKE"}, CountryId{"US"}, Timezone{2378}}, // Lampson Field
    Airport{IataCode{"CKF"}, CountryId{"US"}, Timezone{2712}}, // Crisp County-Cordele Airport
    Airport{IataCode{"CKG"}, CountryId{"CN"}, Timezone{4456}}, // Chongqing Jiangbei International Airport
    Airport{IataCode{"CKH"}, CountryId{"RU"}, Timezone{4485}}, // Chokurdakh Airport
    Airport{IataCode{"CKI"}, CountryId{"AU"}, Timezone{4978}}, // Croker Island Airport
    Airport{IataCode{"CKL"}, CountryId{"RU"}, Timezone{5620}}, // Chkalovsky Airport
    Airport{IataCode{"CKM"}, CountryId{"US"}, Timezone{1510}}, // Fletcher Field Airport
    Airport{IataCode{"CKN"}, CountryId{"US"}, Timezone{1510}}, // Crookston Municipal Airport
    Airport{IataCode{"CKO"}, CountryId{"BR"}, Timezone{3216}}, // Cornélio Procópio Airport
    Airport{IataCode{"CKS"}, CountryId{"BR"}, Timezone{1308}}, // Carajás Airport
    Airport{IataCode{"CKT"}, CountryId{"IR"}, Timezone{4543}}, // Sarakhs Airport
    Airport{IataCode{"CKU"}, CountryId{"US"}, Timezone{814}}, // Cordova Municipal Airport
    Airport{IataCode{"CKV"}, CountryId{"US"}, Timezone{1510}}, // Clarksville-Montgomery County Regional Airport
    Airport{IataCode{"CKW"}, CountryId{"AU"}, Timezone{5087}}, // Graeme Rowley Aerodrome
    Airport{IataCode{"CKX"}, CountryId{"US"}, Timezone{814}}, // Chicken Airport
    Airport{IataCode{"CKY"}, CountryId{"GN"}, Timezone{228}}, // Conakry International Airport
    Airport{IataCode{"CKZ"}, CountryId{"US"}, Timezone{2712}}, // Pennridge Airport
    Airport{IataCode{"CLA"}, CountryId{"BD"}, Timezone{3881}}, // Comilla Airport
    Airport{IataCode{"CLD"}, CountryId{"US"}, Timezone{2378}}, // McClellan–Palomar Airport
    Airport{IataCode{"CLE"}, CountryId{"US"}, Timezone{2712}}, // Cleveland Hopkins International Airport
    Airport{IataCode{"CLG"}, CountryId{"US"}, Timezone{2378}}, // New Coalinga Municipal Airport
    Airport{IataCode{"CLH"}, CountryId{"AU"}, Timezone{5103}}, // Coolah Airport
    Airport{IataCode{"CLI"}, CountryId{"US"}, Timezone{1510}}, // Clintonville Municipal Airport
    Airport{IataCode{"CLJ"}, CountryId{"RO"}, Timezone{5247}}, // Cluj International Airport
    Airport{IataCode{"CLK"}, CountryId{"US"}, Timezone{1510}}, // Clinton Regional Airport
    Airport{IataCode{"CLL"}, CountryId{"US"}, Timezone{1510}}, // Easterwood Airport
    Airport{IataCode{"CLM"}, CountryId{"US"}, Timezone{2378}}, // William R. Fairchild International Airport
    Airport{IataCode{"CLN"}, CountryId{"BR"}, Timezone{1789}}, // Carolina Airport
    Airport{IataCode{"CLO"}, CountryId{"CO"}, Timezone{1376}}, // Alfonso Bonilla Aragón International Airport
    Airport{IataCode{"CLP"}, CountryId{"US"}, Timezone{814}}, // Clarks Point Airport
    Airport{IataCode{"CLQ"}, CountryId{"MX"}, Timezone{2588}}, // Lic. Miguel de la Madrid Airport
    Airport{IataCode{"CLR"}, CountryId{"US"}, Timezone{2378}}, // Cliff Hatfield Memorial Airport
    Airport{IataCode{"CLS"}, CountryId{"US"}, Timezone{2378}}, // Chehalis–Centralia Airport
    Airport{IataCode{"CLU"}, CountryId{"US"}, Timezone{2043}}, // Columbus Municipal Airport
    Airport{IataCode{"CLV"}, CountryId{"BR"}, Timezone{3216}}, // Caldas Novas Airport
    Airport{IataCode{"CLW"}, CountryId{"US"}, Timezone{2712}}, // Clearwater Air Park
    Airport{IataCode{"CLX"}, CountryId{"AR"}, Timezone{942}}, // Clorinda Airport
    Airport{IataCode{"CLY"}, CountryId{"FR"}, Timezone{5646}}, // Calvi – Sainte-Catherine Airport
    Airport{IataCode{"CLZ"}, CountryId{"VE"}, Timezone{1463}}, // Calabozo Airport
    Airport{IataCode{"CMA"}, CountryId{"AU"}, Timezone{4920}}, // Cunnamulla Airport
    Airport{IataCode{"CMB"}, CountryId{"LK"}, Timezone{3854}}, // Bandaranaike International Airport
    Airport{IataCode{"CMD"}, CountryId{"AU"}, Timezone{5103}}, // Cootamundra Airport
    Airport{IataCode{"CME"}, CountryId{"MX"}, Timezone{2554}}, // Ciudad del Carmen International Airport
    Airport{IataCode{"CMF"}, CountryId{"FR"}, Timezone{5646}}, // Chambéry Airport
    Airport{IataCode{"CMG"}, CountryId{"BR"}, Timezone{2350}}, // Corumbá International Airport
    Airport{IataCode{"CMH"}, CountryId{"US"}, Timezone{2712}}, // John Glenn Columbus International Airport
    Airport{IataCode{"CMI"}, CountryId{"US"}, Timezone{1510}}, // University of Illinois Willard Airport
    Airport{IataCode{"CMJ"}, CountryId{"TW"}, Timezone{4504}}, // Qimei Airport
    Airport{IataCode{"CMK"}, CountryId{"MW"}, Timezone{132}}, // Club Makokola Airport
    Airport{IataCode{"CML"}, CountryId{"AU"}, Timezone{4978}}, // Camooweal Airport
    Airport{IataCode{"CMM"}, CountryId{"GT"}, Timezone{1913}}, // Carmelita Airport
    Airport{IataCode{"CMN"}, CountryId{"MA"}, Timezone{215}}, // Mohammed V International Airport
    Airport{IataCode{"CMO"}, CountryId{"SO"}, Timezone{608}}, // Obbia Airport
    Airport{IataCode{"CMP"}, CountryId{"BR"}, Timezone{1308}}, // Santana do Araguaia Airport
    Airport{IataCode{"CMQ"}, CountryId{"AU"}, Timezone{4920}}, // Clermont Airport
    Airport{IataCode{"CMR"}, CountryId{"FR"}, Timezone{5646}}, // Colmar Airport
    Airport{IataCode{"CMS"}, CountryId{"SO"}, Timezone{608}}, // Scusciuban Airport
    Airport{IataCode{"CMU"}, CountryId{"PG"}, Timezone{6686}}, // Chimbu Airport
    Airport{IataCode{"CMV"}, CountryId{"NZ"}, Timezone{6218}}, // Coromandel Aerodrome
    Airport{IataCode{"CMW"}, CountryId{"CU"}, Timezone{1980}}, // Ignacio Agramonte International Airport
    Airport{IataCode{"CMX"}, CountryId{"US"}, Timezone{1682}}, // Houghton County Memorial Airport
    Airport{IataCode{"CMY"}, CountryId{"US"}, Timezone{1510}}, // Sparta/Fort McCoy Airport
    Airport{IataCode{"CNA"}, CountryId{"MX"}, Timezone{1995}}, // Cananea Airport
    Airport{IataCode{"CNB"}, CountryId{"AU"}, Timezone{5103}}, // Coonamble Airport
    Airport{IataCode{"CNC"}, CountryId{"AU"}, Timezone{4920}}, // Coconut Island Airport
    Airport{IataCode{"CND"}, CountryId{"RO"}, Timezone{5247}}, // Mihail Kogălniceanu International Airport
    Airport{IataCode{"CNF"}, CountryId{"BR"}, Timezone{3216}}, // Tancredo Neves International Airport
    Airport{IataCode{"CNH"}, CountryId{"US"}, Timezone{2712}}, // Claremont Municipal Airport
    Airport{IataCode{"CNI"}, CountryId{"CN"}, Timezone{4456}}, // Changhai Airport
    Airport{IataCode{"CNJ"}, CountryId{"AU"}, Timezone{4920}}, // Cloncurry Airport
    Airport{IataCode{"CNK"}, CountryId{"US"}, Timezone{1510}}, // Blosser Municipal Airport
    Airport{IataCode{"CNL"}, CountryId{"DK"}, Timezone{5312}}, // Sindal Airport
    Airport{IataCode{"CNM"}, CountryId{"US"}, Timezone{1667}}, // Cavern City Air Terminal
    Airport{IataCode{"CNO"}, CountryId{"US"}, Timezone{2378}}, // Chino Airport
    Airport{IataCode{"CNP"}, CountryId{"GL"}, Timezone{1610}}, // Nerlerit Inaat Airport
    Airport{IataCode{"CNQ"}, CountryId{"AR"}, Timezone{942}}, // Doctor Fernando Piragine Niveyro International Airport
    Airport{IataCode{"CNR"}, CountryId{"CL"}, Timezone{3177}}, // Chanaral Airport
    Airport{IataCode{"CNS"}, CountryId{"AU"}, Timezone{4920}}, // Cairns Airport
    Airport{IataCode{"CNU"}, CountryId{"US"}, Timezone{1510}}, // Chanute Martin Johnson Airport
    Airport{IataCode{"CNW"}, CountryId{"US"}, Timezone{1510}}, // TSTC Waco Airport
    Airport{IataCode{"CNX"}, CountryId{"TH"}, Timezone{3777}}, // Chiang Mai International Airport
    Airport{IataCode{"CNY"}, CountryId{"US"}, Timezone{1667}}, // Canyonlands Field
    Airport{IataCode{"CNZ"}, CountryId{"AO"}, Timezone{505}}, // Cangamba Airport
    Airport{IataCode{"COA"}, CountryId{"US"}, Timezone{2378}}, // Columbia Airport
    Airport{IataCode{"COC"}, CountryId{"AR"}, Timezone{942}}, // Comodoro Pierrestegui Airport
    Airport{IataCode{"COD"}, CountryId{"US"}, Timezone{1667}}, // Yellowstone Regional Airport
    Airport{IataCode{"COE"}, CountryId{"US"}, Timezone{2378}}, // Coeur d'Alene Airport
    Airport{IataCode{"COG"}, CountryId{"CO"}, Timezone{1376}}, // Mandinga Airport
    Airport{IataCode{"COH"}, CountryId{"IN"}, Timezone{4129}}, // Cooch Behar Airport
    Airport{IataCode{"COI"}, CountryId{"US"}, Timezone{2712}}, // Merritt Island Airport
    Airport{IataCode{"COJ"}, CountryId{"AU"}, Timezone{5103}}, // Coonabarabran Airport
    Airport{IataCode{"COK"}, CountryId{"IN"}, Timezone{4129}}, // Cochin International Airport
    Airport{IataCode{"COL"}, CountryId{"GB"}, Timezone{5517}}, // Coll Airport
    Airport{IataCode{"COM"}, CountryId{"US"}, Timezone{1510}}, // Coleman Municipal Airport
    Airport{IataCode{"CON"}, CountryId{"US"}, Timezone{2712}}, // Concord Municipal Airport
    Airport{IataCode{"COO"}, CountryId{"BJ"}, Timezone{723}}, // Cadjehoun Airport
    Airport{IataCode{"COP"}, CountryId{"US"}, Timezone{2712}}, // Cooperstown-Westville Airport
    Airport{IataCode{"COQ"}, CountryId{"MN"}, Timezone{3838}}, // Choibalsan Airport
    Airport{IataCode{"COR"}, CountryId{"AR"}, Timezone{942}}, // Ingeniero Aeronáutico Ambrosio L.V. Taravella International Airport
    Airport{IataCode{"COS"}, CountryId{"US"}, Timezone{1667}}, // Colorado Springs Airport
    Airport{IataCode{"COT"}, CountryId{"US"}, Timezone{1510}}, // Cotulla–La Salle County Airport
    Airport{IataCode{"COU"}, CountryId{"US"}, Timezone{1510}}, // Columbia Regional Airport
    Airport{IataCode{"COV"}, CountryId{"PT"}, Timezone{5486}}, // Covilhã Airport
    Airport{IataCode{"COX"}, CountryId{"BS"}, Timezone{2697}}, // Congo Town Airport
    Airport{IataCode{"COY"}, CountryId{"AU"}, Timezone{5087}}, // Coolawanyah Station Airport
    Airport{IataCode{"COZ"}, CountryId{"DO"}, Timezone{3194}}, // Constanza Airport
    Airport{IataCode{"CPA"}, CountryId{"LR"}, Timezone{625}}, // Cape Palmas Airport
    Airport{IataCode{"CPB"}, CountryId{"CO"}, Timezone{2877}}, // Capurganá Airport
    Airport{IataCode{"CPC"}, CountryId{"AR"}, Timezone{1076}}, // Aviador Carlos Campos Airport
    Airport{IataCode{"CPD"}, CountryId{"AU"}, Timezone{4901}}, // Coober Pedy Airport
    Airport{IataCode{"CPE"}, CountryId{"MX"}, Timezone{2554}}, // Ing. Alberto Acuña Ongay International Airport
    Airport{IataCode{"CPF"}, CountryId{"ID"}, Timezone{4032}}, // Ngloram Airport
    Airport{IataCode{"CPH"}, CountryId{"DK"}, Timezone{5312}}, // Copenhagen Airport
    Airport{IataCode{"CPK"}, CountryId{"US"}, Timezone{2712}}, // Chesapeake Regional Airport
    Airport{IataCode{"CPL"}, CountryId{}, Timezone{1376}}, // General Navas Pardo Airport
    Airport{IataCode{"CPM"}, CountryId{"US"}, Timezone{2378}}, // Compton/Woodley Airport
    Airport{IataCode{"CPO"}, CountryId{"CL"}, Timezone{3177}}, // Desierto de Atacama Airport
    Airport{IataCode{"CPQ"}, CountryId{"BR"}, Timezone{3216}}, // Campo dos Amarais Airport
    Airport{IataCode{"CPR"}, CountryId{"US"}, Timezone{1667}}, // Casper–Natrona County International Airport
    Airport{IataCode{"CPS"}, CountryId{"US"}, Timezone{1510}}, // St. Louis Downtown Airport
    Airport{IataCode{"CPT"}, CountryId{"ZA"}, Timezone{369}}, // Cape Town International Airport
    Airport{IataCode{"CPU"}, CountryId{"BR"}, Timezone{1789}}, // Cururupu Airport
    Airport{IataCode{"CPV"}, CountryId{"BR"}, Timezone{1789}}, // Campina Grande Airport
    Airport{IataCode{"CPX"}, CountryId{"US"}, Timezone{3012}}, // Benjamín Rivera Noriega Airport
    Airport{IataCode{"CQA"}, CountryId{"BR"}, Timezone{1579}}, // Canarana Airport
    Airport{IataCode{"CQB"}, CountryId{"US"}, Timezone{1510}}, // Chandler Regional Airport
    Airport{IataCode{"CQD"}, CountryId{"IR"}, Timezone{4543}}, // Shahrekord Airport
    Airport{IataCode{"CQF"}, CountryId{"FR"}, Timezone{5646}}, // Calais–Dunkerque Airport
    Airport{IataCode{"CQM"}, CountryId{"ES"}, Timezone{5549}}, // Ciudad Real Central Airport
    Airport{IataCode{"CQX"}, CountryId{"US"}, Timezone{2712}}, // Chatham Municipal Airport
    Airport{IataCode{"CRA"}, CountryId{"RO"}, Timezone{5247}}, // Craiova Airport
    Airport{IataCode{"CRB"}, CountryId{"AU"}, Timezone{5103}}, // Collarenebri Airport
    Airport{IataCode{"CRC"}, CountryId{"CO"}, Timezone{1376}}, // Santa Ana Airport
    Airport{IataCode{"CRD"}, CountryId{"AR"}, Timezone{914}}, // General Enrique Mosconi International Airport
    Airport{IataCode{"CRE"}, CountryId{"US"}, Timezone{2712}}, // Grand Strand Airport
    Airport{IataCode{"CRF"}, CountryId{"CF"}, Timezone{104}}, // Carnot Airport
    Airport{IataCode{"CRG"}, CountryId{"US"}, Timezone{2712}}, // Jacksonville Executive at Craig Airport
    Airport{IataCode{"CRI"}, CountryId{"BS"}, Timezone{2697}}, // Colonel Hill Airport
    Airport{IataCode{"CRK"}, CountryId{"PH"}, Timezone{4240}}, // Clark International Airport
    Airport{IataCode{"CRL"}, CountryId{"BE"}, Timezone{5231}}, // Brussels South Charleroi Airport
    Airport{IataCode{"CRM"}, CountryId{"PH"}, Timezone{4240}}, // Catarman National Airport
    Airport{IataCode{"CRO"}, CountryId{"US"}, Timezone{2378}}, // Corcoran Airport
    Airport{IataCode{"CRP"}, CountryId{"US"}, Timezone{1510}}, // Corpus Christi International Airport
    Airport{IataCode{"CRQ"}, CountryId{"BR"}, Timezone{1254}}, // Caravelas Airport
    Airport{IataCode{"CRR"}, CountryId{"AR"}, Timezone{942}}, // Ceres Airport
    Airport{IataCode{"CRS"}, CountryId{"US"}, Timezone{1510}}, // C. David Campbell Field
    Airport{IataCode{"CRT"}, CountryId{"US"}, Timezone{1510}}, // Z. M. Jack Stell Field
    Airport{IataCode{"CRU"}, CountryId{"GD"}, Timezone{1878}}, // Lauriston Airport
    Airport{IataCode{"CRV"}, CountryId{"IT"}, Timezone{5702}}, // Crotone Airport
    Airport{IataCode{"CRW"}, CountryId{"US"}, Timezone{2712}}, // Yeager Airport
    Airport{IataCode{"CRX"}, CountryId{"US"}, Timezone{1510}}, // Roscoe Turner Airport
    Airport{IataCode{"CRZ"}, CountryId{"TM"}, Timezone{3702}}, // Turkmenabat Airport
    Airport{IataCode{"CSA"}, CountryId{"GB"}, Timezone{5517}}, // Colonsay Airport
    Airport{IataCode{"CSB"}, CountryId{"RO"}, Timezone{5247}}, // Caransebeș Airport
    Airport{IataCode{"CSC"}, CountryId{"CR"}, Timezone{1544}}, // Codela Airport
    Airport{IataCode{"CSG"}, CountryId{"US"}, Timezone{2712}}, // Columbus Airport
    Airport{IataCode{"CSH"}, CountryId{"RU"}, Timezone{5620}}, // Solovki Airport
    Airport{IataCode{"CSI"}, CountryId{"AU"}, Timezone{5103}}, // Casino Airport
    Airport{IataCode{"CSK"}, CountryId{"SN"}, Timezone{243}}, // Cap Skirring Airport
    Airport{IataCode{"CSL"}, CountryId{"MX"}, Timezone{2519}}, // Cabo San Lucas International Airport
    Airport{IataCode{"CSM"}, CountryId{"US"}, Timezone{1510}}, // Clinton-Sherman Industrial Airpark
    Airport{IataCode{"CSN"}, CountryId{"US"}, Timezone{2378}}, // Carson Airport
    Airport{IataCode{"CSO"}, CountryId{"DE"}, Timezone{5199}}, // Magdeburg-Cochstedt Airport
    Airport{IataCode{"CSQ"}, CountryId{"US"}, Timezone{1510}}, // Creston Municipal Airport
    Airport{IataCode{"CSS"}, CountryId{"BR"}, Timezone{3216}}, // Cassilândia Airport
    Airport{IataCode{"CSU"}, CountryId{"BR"}, Timezone{3216}}, // Santa Cruz do Sul Airport
    Airport{IataCode{"CSX"}, CountryId{"CN"}, Timezone{4456}}, // Changsha Huanghua International Airport
    Airport{IataCode{"CSY"}, CountryId{"RU"}, Timezone{5620}}, // Cheboksary Airport
    Airport{IataCode{"CTA"}, CountryId{"IT"}, Timezone{5702}}, // Catania-Fontanarossa Airport
    Airport{IataCode{"CTB"}, CountryId{"US"}, Timezone{1667}}, // Cut Bank Municipal Airport
    Airport{IataCode{"CTC"}, CountryId{"AR"}, Timezone{914}}, // Coronel Felipe Varela International Airport
    Airport{IataCode{"CTD"}, CountryId{"PA"}, Timezone{2877}}, // Chitré Alonso Valderrama Airport
    Airport{IataCode{"CTE"}, CountryId{"PA"}, Timezone{2877}}, // Cartí Airport
    Airport{IataCode{"CTF"}, CountryId{"GT"}, Timezone{1913}}, // Coatepeque Airport
    Airport{IataCode{"CTG"}, CountryId{"CO"}, Timezone{1376}}, // Rafael Núñez International Airport
    Airport{IataCode{"CTH"}, CountryId{"US"}, Timezone{2712}}, // Chester County G. O. Carlson Airport
    Airport{IataCode{"CTI"}, CountryId{"AO"}, Timezone{505}}, // Cuito Cuanavale Airport
    Airport{IataCode{"CTJ"}, CountryId{"US"}, Timezone{2712}}, // West Georgia Regional Airport
    Airport{IataCode{"CTK"}, CountryId{"US"}, Timezone{1510}}, // Ingersoll Airport
    Airport{IataCode{"CTL"}, CountryId{"AU"}, Timezone{4920}}, // Charleville Airport
    Airport{IataCode{"CTM"}, CountryId{"MX"}, Timezone{1448}}, // Chetumal International Airport
    Airport{IataCode{"CTN"}, CountryId{"AU"}, Timezone{4920}}, // Cooktown Airport
    Airport{IataCode{"CTO"}, CountryId{"US"}, Timezone{2712}}, // Calverton Executive Airpark
    Airport{IataCode{"CTQ"}, CountryId{"BR"}, Timezone{3216}}, // Santa Vitória do Palmar Airport
    Airport{IataCode{"CTS"}, CountryId{"JP"}, Timezone{4568}}, // New Chitose Airport
    Airport{IataCode{"CTT"}, CountryId{"FR"}, Timezone{5646}}, // Le Castellet airport
    Airport{IataCode{"CTU"}, CountryId{"CN"}, Timezone{4456}}, // Chengdu Shuangliu International Airport
    Airport{IataCode{"CTV"}, CountryId{"MX"}, Timezone{3455}}, // Rancho Santa Inés Airstrip
    Airport{IataCode{"CTX"}, CountryId{"US"}, Timezone{2712}}, // Cortland County Airport
    Airport{IataCode{"CTY"}, CountryId{"US"}, Timezone{2712}}, // Cross City Airport
    Airport{IataCode{"CTZ"}, CountryId{"US"}, Timezone{2712}}, // Clinton-Sampson County Airport
    Airport{IataCode{"CUA"}, CountryId{"MX"}, Timezone{2519}}, // Ciudad Constitución Airport
    Airport{IataCode{"CUB"}, CountryId{"US"}, Timezone{2712}}, // Jim Hamilton – L.B. Owens Airport
    Airport{IataCode{"CUC"}, CountryId{"CO"}, Timezone{1376}}, // Camilo Daza International Airport
    Airport{IataCode{"CUD"}, CountryId{"AU"}, Timezone{4920}}, // Caloundra Airport
    Airport{IataCode{"CUE"}, CountryId{"EC"}, Timezone{1949}}, // Mariscal Lamar International Airport
    Airport{IataCode{"CUF"}, CountryId{"IT"}, Timezone{5702}}, // Cuneo International Airport
    Airport{IataCode{"CUH"}, CountryId{"US"}, Timezone{1510}}, // Cushing Municipal Airport
    Airport{IataCode{"CUK"}, CountryId{"BZ"}, Timezone{1322}}, // Caye Caulker Airport
    Airport{IataCode{"CUL"}, CountryId{"MX"}, Timezone{2519}}, // Federal de Bachigualato International Airport
    Airport{IataCode{"CUM"}, CountryId{"VE"}, Timezone{1463}}, // Antonio José de Sucre Airport
    Airport{IataCode{"CUN"}, CountryId{"MX"}, Timezone{1448}}, // Cancún International Airport
    Airport{IataCode{"CUO"}, CountryId{"CO"}, Timezone{1376}}, // Carurú Airport
    Airport{IataCode{"CUP"}, CountryId{"VE"}, Timezone{1463}}, // General José Francisco Bermúdez Airport
    Airport{IataCode{"CUQ"}, CountryId{"AU"}, Timezone{4920}}, // Coen Airport
    Airport{IataCode{"CUR"}, CountryId{"NL"}, Timezone{1594}}, // Hato International Airport
    Airport{IataCode{"CUS"}, CountryId{"US"}, Timezone{1667}}, // Columbus Municipal Airport
    Airport{IataCode{"CUT"}, CountryId{"AR"}, Timezone{1076}}, // Cutral Có Airport
    Airport{IataCode{"CUU"}, CountryId{"MX"}, Timezone{1526}}, // General Roberto Fierro Villalobos International Airport
    Airport{IataCode{"CUV"}, CountryId{"VE"}, Timezone{1463}}, // El Cubo Airport
    Airport{IataCode{"CUY"}, CountryId{"AU"}, Timezone{5087}}, // Cue Airport
    Airport{IataCode{"CUZ"}, CountryId{"PE"}, Timezone{2365}}, // Alejandro Velasco Astete International Airport
    Airport{IataCode{"CVC"}, CountryId{"AU"}, Timezone{4901}}, // Cleve Airport
    Airport{IataCode{"CVE"}, CountryId{"CO"}, Timezone{1376}}, // Covenas Airport
    Airport{IataCode{"CVF"}, CountryId{"FR"}, Timezone{5646}}, // Courchevel Airport
    Airport{IataCode{"CVG"}, CountryId{"US"}, Timezone{2712}}, // Cincinnati/Northern Kentucky International Airport
    Airport{IataCode{"CVH"}, CountryId{"AR"}, Timezone{1076}}, // Caviahue Airport
    Airport{IataCode{"CVJ"}, CountryId{"MX"}, Timezone{2588}}, // General Mariano Matamoros Airport
    Airport{IataCode{"CVK"}, CountryId{"US"}, Timezone{1510}}, // Sharp County Regional Airport
    Airport{IataCode{"CVM"}, CountryId{"MX"}, Timezone{2641}}, // General Pedro J. Méndez International Airport
    Airport{IataCode{"CVN"}, CountryId{"US"}, Timezone{1667}}, // Clovis Municipal Airport
    Airport{IataCode{"CVO"}, CountryId{"US"}, Timezone{2378}}, // Corvallis Municipal Airport
    Airport{IataCode{"CVQ"}, CountryId{"AU"}, Timezone{5087}}, // Carnarvon Airport
    Airport{IataCode{"CVT"}, CountryId{"GB"}, Timezone{5517}}, // Coventry Airport
    Airport{IataCode{"CVU"}, CountryId{"PT"}, Timezone{4722}}, // Corvo Airport
    Airport{IataCode{"CVX"}, CountryId{"US"}, Timezone{1682}}, // Charlevoix Municipal Airport
    Airport{IataCode{"CWA"}, CountryId{"US"}, Timezone{1510}}, // Central Wisconsin Airport
    Airport{IataCode{"CWB"}, CountryId{"BR"}, Timezone{3216}}, // Afonso Pena International Airport
    Airport{IataCode{"CWC"}, CountryId{"UA"}, Timezone{5461}}, // Chernivtsi International Airport
    Airport{IataCode{"CWF"}, CountryId{"US"}, Timezone{1510}}, // Chennault International Airport
    Airport{IataCode{"CWI"}, CountryId{"US"}, Timezone{1510}}, // Clinton Municipal Airport
    Airport{IataCode{"CWJ"}, CountryId{"CN"}, Timezone{4456}}, // Cangyuan Washan Airport
    Airport{IataCode{"CWL"}, CountryId{"GB"}, Timezone{5517}}, // Cardiff Airport
    Airport{IataCode{"CWS"}, CountryId{"US"}, Timezone{2378}}, // Center Island Airport
    Airport{IataCode{"CWT"}, CountryId{"AU"}, Timezone{5103}}, // Cowra Airport
    Airport{IataCode{"CWW"}, CountryId{"AU"}, Timezone{5103}}, // Corowa Airport
    Airport{IataCode{"CWX"}, CountryId{"US"}, Timezone{2931}}, // Cochise County Airport
    Airport{IataCode{"CXA"}, CountryId{"VE"}, Timezone{1463}}, // Caicara De Orinoco Airport
    Airport{IataCode{"CXB"}, CountryId{"BD"}, Timezone{3881}}, // Cox's Bazar Airport
    Airport{IataCode{"CXF"}, CountryId{"US"}, Timezone{814}}, // Coldfoot Airport
    Airport{IataCode{"CXH"}, CountryId{"CA"}, Timezone{3503}}, // Vancouver Harbour Water Airport
    Airport{IataCode{"CXI"}, CountryId{"KI"}, Timezone{6463}}, // Cassidy International Airport
    Airport{IataCode{"CXJ"}, CountryId{"BR"}, Timezone{3216}}, // Caxias do Sul Airport
    Airport{IataCode{"CXL"}, CountryId{"US"}, Timezone{2378}}, // Calexico International Airport
    Airport{IataCode{"CXM"}, CountryId{"AO"}, Timezone{505}}, // Camaxilo Airport
    Airport{IataCode{"CXN"}, CountryId{"SO"}, Timezone{608}}, // Candala Airport
    Airport{IataCode{"CXO"}, CountryId{"US"}, Timezone{1510}}, // Lone Star Executive Airport
    Airport{IataCode{"CXP"}, CountryId{"ID"}, Timezone{4032}}, // Tunggul Wulung Airport
    Airport{IataCode{"CXQ"}, CountryId{"AU"}, Timezone{5087}}, // Christmas Creek Airport
    Airport{IataCode{"CXR"}, CountryId{"VN"}, Timezone{3964}}, // Cam Ranh International Airport
    Airport{IataCode{"CXT"}, CountryId{"AU"}, Timezone{4920}}, // Charters Towers Airport
    Airport{IataCode{"CXW"}, CountryId{"US"}, Timezone{1510}}, // Conway Airport at Cantrell Field
    Airport{IataCode{"CXY"}, CountryId{"BS"}, Timezone{2697}}, // Cat Cay Airport
    Airport{IataCode{"CYA"}, CountryId{"HT"}, Timezone{2947}}, // Antoine-Simon Airport
    Airport{IataCode{"CYB"}, CountryId{"KY"}, Timezone{1495}}, // Charles Kirkconnell International Airport
    Airport{IataCode{"CYC"}, CountryId{"BZ"}, Timezone{1322}}, // Caye Chapel Airport
    Airport{IataCode{"CYF"}, CountryId{"US"}, Timezone{2745}}, // Chefornak Airport
    Airport{IataCode{"CYG"}, CountryId{"AU"}, Timezone{5067}}, // Corryong Airport
    Airport{IataCode{"CYI"}, CountryId{"TW"}, Timezone{4504}}, // Chiayi Airport
    Airport{IataCode{"CYL"}, CountryId{"HN"}, Timezone{3401}}, // Coyoles Airport
    Airport{IataCode{"CYM"}, CountryId{"US"}, Timezone{3255}}, // Chatham Seaplane Base
    Airport{IataCode{"CYO"}, CountryId{"CU"}, Timezone{1980}}, // Vilo Acuña Airport
    Airport{IataCode{"CYP"}, CountryId{"PH"}, Timezone{4240}}, // Calbayog Airport
    Airport{IataCode{"CYR"}, CountryId{"UY"}, Timezone{2659}}, // Colonia Airport
    Airport{IataCode{"CYS"}, CountryId{"US"}, Timezone{1667}}, // Cheyenne Regional Airport
    Airport{IataCode{"CYT"}, CountryId{"US"}, Timezone{814}}, // Yakataga Airport
    Airport{IataCode{"CYU"}, CountryId{"PH"}, Timezone{4240}}, // Cuyo Airport
    Airport{IataCode{"CYW"}, CountryId{"MX"}, Timezone{2588}}, // Captain Rogelio Castillo National Airport
    Airport{IataCode{"CYX"}, CountryId{"RU"}, Timezone{4485}}, // Chersky Airport
    Airport{IataCode{"CYZ"}, CountryId{"PH"}, Timezone{4240}}, // Cauayan Airport
    Airport{IataCode{"CZA"}, CountryId{"MX"}, Timezone{2554}}, // Chichen Itza International Airport
    Airport{IataCode{"CZC"}, CountryId{"US"}, Timezone{814}}, // Copper Center Airport
    Airport{IataCode{"CZE"}, CountryId{"VE"}, Timezone{1463}}, // José Leonardo Chirino Airport
    Airport{IataCode{"CZF"}, CountryId{"US"}, Timezone{2745}}, // Cape Romanzof LRRS Airport
    Airport{IataCode{"CZG"}, CountryId{"US"}, Timezone{2712}}, // Tri-Cities Airport (New York)
    Airport{IataCode{"CZH"}, CountryId{"BZ"}, Timezone{1322}}, // Corozal Airport
    Airport{IataCode{"CZJ"}, CountryId{"PA"}, Timezone{2877}}, // Corazón de Jesús Airport
    Airport{IataCode{"CZK"}, CountryId{"US"}, Timezone{2378}}, // Cascade Locks State Airport
    Airport{IataCode{"CZL"}, CountryId{"DZ"}, Timezone{47}}, // Mohamed Boudiaf International Airport
    Airport{IataCode{"CZM"}, CountryId{"MX"}, Timezone{1448}}, // Cozumel International Airport
    Airport{IataCode{"CZN"}, CountryId{"US"}, Timezone{814}}, // Chisana Airport
    Airport{IataCode{"CZS"}, CountryId{"BR"}, Timezone{3141}}, // Cruzeiro do Sul International Airport
    Airport{IataCode{"CZU"}, CountryId{"CO"}, Timezone{1376}}, // Las Brujas Airport
    Airport{IataCode{"CZW"}, CountryId{"PL"}, Timezone{5975}}, // Rudniki, EPCH Airport
    Airport{IataCode{"CZX"}, CountryId{"CN"}, Timezone{4456}}, // Changzhou Benniu Airport
    Airport{IataCode{"DAB"}, CountryId{"US"}, Timezone{2712}}, // Daytona Beach International Airport
    Airport{IataCode{"DAC"}, CountryId{"BD"}, Timezone{3881}}, // Shahjalal International Airport
    Airport{IataCode{"DAD"}, CountryId{"VN"}, Timezone{3964}}, // Da Nang International Airport
    Airport{IataCode{"DAG"}, CountryId{"US"}, Timezone{2378}}, // Barstow-Daggett Airport
    Airport{IataCode{"DAK"}, CountryId{"EG"}, Timezone{184}}, // Dakhla Oasis Airport
    Airport{IataCode{"DAL"}, CountryId{"US"}, Timezone{1510}}, // Dallas Love Field
    Airport{IataCode{"DAM"}, CountryId{"SY"}, Timezone{3867}}, // Damascus International Airport
    Airport{IataCode{"DAN"}, CountryId{"US"}, Timezone{2712}}, // Danville Regional Airport
    Airport{IataCode{"DAR"}, CountryId{"TZ"}, Timezone{256}}, // Julius Nyerere International Airport
    Airport{IataCode{"DAS"}, CountryId{"CA"}, Timezone{3573}}, // Great Bear Lake Airport
    Airport{IataCode{"DAT"}, CountryId{"CN"}, Timezone{4456}}, // Datong Yungang Airport
    Airport{IataCode{"DAU"}, CountryId{"PG"}, Timezone{6686}}, // Daru Airport
    Airport{IataCode{"DAV"}, CountryId{"PA"}, Timezone{2877}}, // Enrique Malek International Airport
    Airport{IataCode{"DAW"}, CountryId{"US"}, Timezone{2712}}, // Skyhaven Airport
    Airport{IataCode{"DAX"}, CountryId{"CN"}, Timezone{4456}}, // Dazhou Heshi Airport
    Airport{IataCode{"DAY"}, CountryId{"US"}, Timezone{2712}}, // Dayton International Airport
    Airport{IataCode{"DAZ"}, CountryId{"AF"}, Timezone{3913}}, // Darwaz Airport
    Airport{IataCode{"DBA"}, CountryId{"PK"}, Timezone{4087}}, // Dalbandin Airport
    Airport{IataCode{"DBB"}, CountryId{"EG"}, Timezone{184}}, // El Alamein International Airport
    Airport{IataCode{"DBC"}, CountryId{"CN"}, Timezone{4456}}, // Baicheng Chang'an Airport
    Airport{IataCode{"DBD"}, CountryId{"IN"}, Timezone{4129}}, // Dhanbad Airport
    Airport{IataCode{"DBM"}, CountryId{"ET"}, Timezone{28}}, // Debre Marqos Airport
    Airport{IataCode{"DBN"}, CountryId{"US"}, Timezone{2712}}, // W. H. 'Bud' Barron Airport
    Airport{IataCode{"DBO"}, CountryId{"AU"}, Timezone{5103}}, // Dubbo City Airport
    Airport{IataCode{"DBQ"}, CountryId{"US"}, Timezone{1510}}, // Dubuque Regional Airport
    Airport{IataCode{"DBR"}, CountryId{"IN"}, Timezone{}}, // Darbhanga Airport
    Airport{IataCode{"DBS"}, CountryId{"US"}, Timezone{1391}}, // Dubois Municipal Airport
    Airport{IataCode{"DBT"}, CountryId{"ET"}, Timezone{28}}, // Debre Tabor Airport
    Airport{IataCode{"DBV"}, CountryId{"HR"}, Timezone{5989}}, // Dubrovnik Airport
    Airport{IataCode{"DBY"}, CountryId{"AU"}, Timezone{4920}}, // Dalby Airport
    Airport{IataCode{"DCA"}, CountryId{"US"}, Timezone{2712}}, // Ronald Reagan Washington National Airport
    Airport{IataCode{"DCF"}, CountryId{"DM"}, Timezone{1698}}, // Canefield Airport
    Airport{IataCode{"DCK"}, CountryId{"US"}, Timezone{814}}, // Dahl Creek Airport
    Airport{IataCode{"DCM"}, CountryId{"FR"}, Timezone{5646}}, // Castres–Mazamet Airport
    Airport{IataCode{"DCR"}, CountryId{"US"}, Timezone{2043}}, // Decatur Hi-Way Airport
    Airport{IataCode{"DCT"}, CountryId{"BS"}, Timezone{2697}}, // Duncan Town Airport
    Airport{IataCode{"DCU"}, CountryId{"US"}, Timezone{1510}}, // Pryor Field Regional Airport
    Airport{IataCode{"DCY"}, CountryId{"CN"}, Timezone{4456}}, // Daocheng Yading Airport
    Airport{IataCode{"DDC"}, CountryId{"US"}, Timezone{1510}}, // Dodge City Regional Airport
    Airport{IataCode{"DDD"}, CountryId{"MV"}, Timezone{6142}}, // Dhaalu Airport
    Airport{IataCode{"DDG"}, CountryId{"CN"}, Timezone{4456}}, // Dandong Langtou Airport
    Airport{IataCode{"DDH"}, CountryId{"US"}, Timezone{2712}}, // William H. Morse State Airport
    Airport{IataCode{"DDP"}, CountryId{"US"}, Timezone{3012}}, // Dorado Airport
    Airport{IataCode{"DEA"}, CountryId{"PK"}, Timezone{4087}}, // Dera Ghazi Khan International Airport
    Airport{IataCode{"DEB"}, CountryId{"HU"}, Timezone{5264}}, // Debrecen International Airport
    Airport{IataCode{"DEC"}, CountryId{"US"}, Timezone{1510}}, // Decatur Airport
    Airport{IataCode{"DED"}, CountryId{"IN"}, Timezone{4129}}, // Jolly Grant Airport
    Airport{IataCode{"DEE"}, CountryId{"RU"}, Timezone{4619}}, // Mendeleevo Airport
    Airport{IataCode{"DEF"}, CountryId{"IR"}, Timezone{4543}}, // Dezful Airport
    Airport{IataCode{"DEH"}, CountryId{"US"}, Timezone{1510}}, // Decorah Municipal Airport
    Airport{IataCode{"DEI"}, CountryId{"SC"}, Timezone{}}, // Denis Island Airport
    Airport{IataCode{"DEL"}, CountryId{"IN"}, Timezone{4129}}, // Indira Gandhi International Airport
    Airport{IataCode{"DEM"}, CountryId{"ET"}, Timezone{28}}, // Dembidolo Airport
    Airport{IataCode{"DEN"}, CountryId{"US"}, Timezone{1667}}, // Denver International Airport
    Airport{IataCode{"DEP"}, CountryId{"IN"}, Timezone{4129}}, // Daporijo Airport
    Airport{IataCode{"DEQ"}, CountryId{"US"}, Timezone{1510}}, // J. Lynn Helms Sevier County Airport
    Airport{IataCode{"DES"}, CountryId{"SC"}, Timezone{6130}}, // Desroches Airport
    Airport{IataCode{"DET"}, CountryId{"US"}, Timezone{1682}}, // Coleman A. Young International Airport
    Airport{IataCode{"DEW"}, CountryId{"US"}, Timezone{2378}}, // Deer Park Airport
    Airport{IataCode{"DEZ"}, CountryId{"SY"}, Timezone{3867}}, // Deir ez-Zor Airport
    Airport{IataCode{"DFI"}, CountryId{"US"}, Timezone{2712}}, // Defiance Memorial Airport
    Airport{IataCode{"DFW"}, CountryId{"US"}, Timezone{1510}}, // Dallas/Fort Worth International Airport
    Airport{IataCode{"DGA"}, CountryId{"BZ"}, Timezone{1322}}, // Dangriga Airport
    Airport{IataCode{"DGE"}, CountryId{"AU"}, Timezone{5103}}, // Mudgee Airport
    Airport{IataCode{"DGF"}, CountryId{"CA"}, Timezone{3503}}, // Douglas Lake Airport
    Airport{IataCode{"DGL"}, CountryId{"US"}, Timezone{2931}}, // Douglas Municipal Airport
    Airport{IataCode{"DGO"}, CountryId{"MX"}, Timezone{2641}}, // General Guadalupe Victoria International Airport
    Airport{IataCode{"DGP"}, CountryId{"LV"}, Timezone{5690}}, // Daugavpils International Airport
    Airport{IataCode{"DGR"}, CountryId{"NZ"}, Timezone{6218}}, // Dargaville Aerodrome
    Airport{IataCode{"DGT"}, CountryId{"PH"}, Timezone{4240}}, // Sibulan Airport
    Airport{IataCode{"DGU"}, CountryId{"BF"}, Timezone{704}}, // Dedougou Airport
    Airport{IataCode{"DGW"}, CountryId{"US"}, Timezone{1667}}, // Converse County Airport
    Airport{IataCode{"DGX"}, CountryId{"GB"}, Timezone{5517}}, // MOD St Athan
    Airport{IataCode{"DHA"}, CountryId{"SA"}, Timezone{4404}}, // Dhahran Airfield
    Airport{IataCode{"DHI"}, CountryId{"NP"}, Timezone{4100}}, // Dhangadhi Airport
    Airport{IataCode{"DHM"}, CountryId{"IN"}, Timezone{4129}}, // Gaggal Airport
    Airport{IataCode{"DHN"}, CountryId{"IN"}, Timezone{4129}}, // Sagar Airport
    Airport{IataCode{"DHR"}, CountryId{"NL"}, Timezone{5120}}, // De Kooy Airfield
    Airport{IataCode{"DHT"}, CountryId{"US"}, Timezone{1510}}, // Dalhart Municipal Airport
    Airport{IataCode{"DIB"}, CountryId{"IN"}, Timezone{4129}}, // Dibrugarh Airport
    Airport{IataCode{"DIE"}, CountryId{"MG"}, Timezone{6035}}, // Arrachart Airport
    Airport{IataCode{"DIG"}, CountryId{"CN"}, Timezone{4456}}, // Dêqên Shangri-La Airport
    Airport{IataCode{"DIJ"}, CountryId{"US"}, Timezone{1391}}, // Driggs-Reed Memorial Airport
    Airport{IataCode{"DIK"}, CountryId{"US"}, Timezone{1667}}, // Dickinson Theodore Roosevelt Regional Airport
    Airport{IataCode{"DIL"}, CountryId{"TL"}, Timezone{3902}}, // Presidente Nicolau Lobato International Airport
    Airport{IataCode{"DIM"}, CountryId{"CI"}, Timezone{0}}, // Dimbokro Airport
    Airport{IataCode{"DIN"}, CountryId{"VN"}, Timezone{4633}}, // Dien Bien Phu Airport
    Airport{IataCode{"DIP"}, CountryId{"BF"}, Timezone{704}}, // Diapaga Airport
    Airport{IataCode{"DIQ"}, CountryId{"BR"}, Timezone{3216}}, // Divinópolis Airport
    Airport{IataCode{"DIR"}, CountryId{"ET"}, Timezone{28}}, // Aba Tenna Dejazmach Yilma International Airport
    Airport{IataCode{"DIS"}, CountryId{"CG"}, Timezone{148}}, // Dolisie Airport
    Airport{IataCode{"DIU"}, CountryId{"IN"}, Timezone{4129}}, // Diu Airport
    Airport{IataCode{"DIV"}, CountryId{"CI"}, Timezone{0}}, // Divo Airport
    Airport{IataCode{"DIY"}, CountryId{"TR"}, Timezone{5412}}, // Diyarbakır Airport
    Airport{IataCode{"DJA"}, CountryId{"BJ"}, Timezone{723}}, // Djougou Airport
    Airport{IataCode{"DJB"}, CountryId{"ID"}, Timezone{4032}}, // Sultan Thaha Airport
    Airport{IataCode{"DJE"}, CountryId{"TN"}, Timezone{772}}, // Djerba–Zarzis International Airport
    Airport{IataCode{"DJG"}, CountryId{"DZ"}, Timezone{47}}, // Djanet Inedbirene Airport
    Airport{IataCode{"DJJ"}, CountryId{"ID"}, Timezone{4032}}, // Sentani Airport
    Airport{IataCode{"DJM"}, CountryId{"CG"}, Timezone{148}}, // Djambala Airport
    Airport{IataCode{"DJN"}, CountryId{"US"}, Timezone{814}}, // Delta Junction Airport
    Airport{IataCode{"DJO"}, CountryId{"CI"}, Timezone{0}}, // Daloa Airport
    Airport{IataCode{"DJU"}, CountryId{"IS"}, Timezone{4823}}, // Djúpivogur Airport
    Airport{IataCode{"DKA"}, CountryId{"NG"}, Timezone{462}}, // Katsina Airport
    Airport{IataCode{"DKI"}, CountryId{"AU"}, Timezone{4920}}, // Dunk Island Airport
    Airport{IataCode{"DKK"}, CountryId{"US"}, Timezone{2712}}, // Chautauqua County/Dunkirk Airport
    Airport{IataCode{"DKR"}, CountryId{"SN"}, Timezone{243}}, // Léopold Sédar Senghor International Airport
    Airport{IataCode{"DKS"}, CountryId{"RU"}, Timezone{4142}}, // Dikson Airport
    Airport{IataCode{"DKX"}, CountryId{"US"}, Timezone{2712}}, // Knoxville Downtown Island Airport
    Airport{IataCode{"DLA"}, CountryId{"CM"}, Timezone{293}}, // Douala International Airport
    Airport{IataCode{"DLC"}, CountryId{"CN"}, Timezone{4456}}, // Dalian Zhoushuizi International Airport
    Airport{IataCode{"DLD"}, CountryId{"NO"}, Timezone{5634}}, // Geilo Airport
    Airport{IataCode{"DLE"}, CountryId{"FR"}, Timezone{5646}}, // Dole–Jura Airport
    Airport{IataCode{"DLG"}, CountryId{"US"}, Timezone{814}}, // Dillingham Airport
    Airport{IataCode{"DLH"}, CountryId{"US"}, Timezone{1510}}, // Duluth International Airport
    Airport{IataCode{"DLI"}, CountryId{"VN"}, Timezone{3964}}, // Lien Khuong Airport
    Airport{IataCode{"DLL"}, CountryId{"US"}, Timezone{2712}}, // Dillon County Airport
    Airport{IataCode{"DLM"}, CountryId{"TR"}, Timezone{5412}}, // Dalaman Airport
    Airport{IataCode{"DLN"}, CountryId{"US"}, Timezone{1667}}, // Dillon Airport
    Airport{IataCode{"DLO"}, CountryId{"US"}, Timezone{2378}}, // Delano Municipal Airport
    Airport{IataCode{"DLS"}, CountryId{"US"}, Timezone{2378}}, // Columbia Gorge Regional Airport
    Airport{IataCode{"DLU"}, CountryId{"CN"}, Timezone{4456}}, // Dali Airport
    Airport{IataCode{"DLY"}, CountryId{"VU"}, Timezone{6301}}, // Dillon's Bay Airport
    Airport{IataCode{"DLZ"}, CountryId{"MN"}, Timezone{4590}}, // Dalanzadgad Airport
    Airport{IataCode{"DMB"}, CountryId{"KZ"}, Timezone{3644}}, // Taraz Airport
    Airport{IataCode{"DMD"}, CountryId{"AU"}, Timezone{4920}}, // Doomadgee Airport
    Airport{IataCode{"DME"}, CountryId{"RU"}, Timezone{5620}}, // Domodedovo International Airport
    Airport{IataCode{"DMK"}, CountryId{"TH"}, Timezone{3777}}, // Don Mueang International Airport
    Airport{IataCode{"DMM"}, CountryId{"SA"}, Timezone{4404}}, // King Fahd International Airport
    Airport{IataCode{"DMN"}, CountryId{"US"}, Timezone{1667}}, // Deming Municipal Airport
    Airport{IataCode{"DMO"}, CountryId{"US"}, Timezone{1510}}, // Sedalia Regional Airport
    Airport{IataCode{"DMT"}, CountryId{"BR"}, Timezone{1579}}, // Diamantino Airport
    Airport{IataCode{"DMU"}, CountryId{"IN"}, Timezone{4129}}, // Dimapur Airport
    Airport{IataCode{"DMW"}, CountryId{"US"}, Timezone{2712}}, // Carroll County Regional Airport
    Airport{IataCode{"DND"}, CountryId{"GB"}, Timezone{5517}}, // Dundee Airport
    Airport{IataCode{"DNH"}, CountryId{"CN"}, Timezone{4456}}, // Dunhuang Airport
    Airport{IataCode{"DNI"}, CountryId{"SD"}, Timezone{432}}, // Wad Medani Airport
    Airport{IataCode{"DNK"}, CountryId{"UA"}, Timezone{5461}}, // Dnipropetrovsk International Airport
    Airport{IataCode{"DNL"}, CountryId{"US"}, Timezone{2712}}, // Daniel Field
    Airport{IataCode{"DNN"}, CountryId{"US"}, Timezone{2712}}, // Dalton Municipal Airport
    Airport{IataCode{"DNP"}, CountryId{"NP"}, Timezone{4100}}, // Tribhuvannagar Airport
    Airport{IataCode{"DNQ"}, CountryId{"AU"}, Timezone{5103}}, // Deniliquin Airport
    Airport{IataCode{"DNR"}, CountryId{"FR"}, Timezone{5646}}, // Dinard–Pleurtuit–Saint-Malo Airport
    Airport{IataCode{"DNS"}, CountryId{"US"}, Timezone{1510}}, // Denison Municipal Airport
    Airport{IataCode{"DNV"}, CountryId{"US"}, Timezone{1510}}, // Vermilion Regional Airport
    Airport{IataCode{"DNX"}, CountryId{"SD"}, Timezone{432}}, // Galegu Airport
    Airport{IataCode{"DOB"}, CountryId{"ID"}, Timezone{4032}}, // Dobo Airport
    Airport{IataCode{"DOD"}, CountryId{"TZ"}, Timezone{256}}, // Dodoma Airport
    Airport{IataCode{"DOE"}, CountryId{"SR"}, Timezone{2912}}, // Djoemoe Airstrip
    Airport{IataCode{"DOG"}, CountryId{"SD"}, Timezone{432}}, // Dongola Airport
    Airport{IataCode{"DOH"}, CountryId{"QA"}, Timezone{4378}}, // Hamad International Airport
    Airport{IataCode{"DOK"}, CountryId{"UA"}, Timezone{5461}}, // Donetsk International Airport
    Airport{IataCode{"DOL"}, CountryId{"FR"}, Timezone{5646}}, // Deauville – Saint-Gatien Airport
    Airport{IataCode{"DOM"}, CountryId{"DM"}, Timezone{1698}}, // Douglas–Charles Airport
    Airport{IataCode{"DON"}, CountryId{"GT"}, Timezone{1913}}, // Dos Lagunas Airport
    Airport{IataCode{"DOP"}, CountryId{"NP"}, Timezone{4100}}, // Dolpa Airport
    Airport{IataCode{"DOR"}, CountryId{"BF"}, Timezone{704}}, // Dori Airport
    Airport{IataCode{"DOU"}, CountryId{"BR"}, Timezone{1427}}, // Dourados Airport
    Airport{IataCode{"DOY"}, CountryId{"CN"}, Timezone{4456}}, // Dongying Shengli Airport
    Airport{IataCode{"DPA"}, CountryId{"US"}, Timezone{1510}}, // DuPage Airport
    Airport{IataCode{"DPE"}, CountryId{"FR"}, Timezone{5646}}, // Dieppe - Saint-Aubin Airport
    Airport{IataCode{"DPL"}, CountryId{"PH"}, Timezone{4240}}, // Dipolog Airport
    Airport{IataCode{"DPO"}, CountryId{"AU"}, Timezone{5011}}, // Devonport Airport
    Airport{IataCode{"DPS"}, CountryId{"ID"}, Timezone{4226}}, // Ngurah Rai International Airport
    Airport{IataCode{"DPT"}, CountryId{"RU"}, Timezone{4648}}, // Deputatsky Airport
    Airport{IataCode{"DQA"}, CountryId{"CN"}, Timezone{4456}}, // Daqing Sartu Airport
    Airport{IataCode{"DQH"}, CountryId{"US"}, Timezone{814}}, // Alpine Airstrip
    Airport{IataCode{"DRA"}, CountryId{"US"}, Timezone{2378}}, // Desert Rock Airport
    Airport{IataCode{"DRB"}, CountryId{"AU"}, Timezone{5087}}, // Derby Airport
    Airport{IataCode{"DRC"}, CountryId{"AO"}, Timezone{505}}, // Dirico Airport
    Airport{IataCode{"DRE"}, CountryId{"US"}, Timezone{1682}}, // Drummond Island Airport
    Airport{IataCode{"DRG"}, CountryId{"US"}, Timezone{2745}}, // Deering Airport
    Airport{IataCode{"DRH"}, CountryId{"ID"}, Timezone{4032}}, // Dabra Airport
    Airport{IataCode{"DRI"}, CountryId{"US"}, Timezone{1510}}, // Beauregard Regional Airport
    Airport{IataCode{"DRJ"}, CountryId{"SR"}, Timezone{2912}}, // Drietabbetje Airstrip
    Airport{IataCode{"DRK"}, CountryId{"CR"}, Timezone{1544}}, // Drake Bay Airport
    Airport{IataCode{"DRN"}, CountryId{"AU"}, Timezone{4920}}, // Dirranbandi Airport
    Airport{IataCode{"DRO"}, CountryId{"US"}, Timezone{1667}}, // Durango–La Plata County Airport
    Airport{IataCode{"DRS"}, CountryId{"DE"}, Timezone{5199}}, // Dresden Airport
    Airport{IataCode{"DRT"}, CountryId{"US"}, Timezone{1510}}, // Del Rio International Airport
    Airport{IataCode{"DRV"}, CountryId{"MV"}, Timezone{6142}}, // Dharavandhoo Airport
    Airport{IataCode{"DSA"}, CountryId{"GB"}, Timezone{5517}}, // Doncaster Sheffield Airport
    Airport{IataCode{"DSC"}, CountryId{"CM"}, Timezone{293}}, // Dschang Airport
    Airport{IataCode{"DSD"}, CountryId{"FR"}, Timezone{1894}}, // La Désirade Airport
    Airport{IataCode{"DSE"}, CountryId{"ET"}, Timezone{28}}, // Combolcha Airport
    Airport{IataCode{"DSI"}, CountryId{"US"}, Timezone{1510}}, // Destin Executive Airport
    Airport{IataCode{"DSK"}, CountryId{"PK"}, Timezone{4087}}, // Dera Ismail Khan Airport
    Airport{IataCode{"DSM"}, CountryId{"US"}, Timezone{1510}}, // Des Moines International Airport
    Airport{IataCode{"DSN"}, CountryId{"CN"}, Timezone{4456}}, // Ordos Ejin Horo Airport
    Airport{IataCode{"DSO"}, CountryId{"KP"}, Timezone{4363}}, // Sondok Airport
    Airport{IataCode{"DSR"}, CountryId{"AU"}, Timezone{5087}}, // Sunrise Dam Airport
    Airport{IataCode{"DSS"}, CountryId{"SN"}, Timezone{243}}, // Blaise Diagne International Airport
    Airport{IataCode{"DSV"}, CountryId{"US"}, Timezone{2712}}, // Dansville Municipal Airport
    Airport{IataCode{"DSX"}, CountryId{"TW"}, Timezone{}}, // Dongsha Island Airport
    Airport{IataCode{"DTA"}, CountryId{"US"}, Timezone{1667}}, // Delta Municipal Airport
    Airport{IataCode{"DTB"}, CountryId{"ID"}, Timezone{4032}}, // Silangit Airport
    Airport{IataCode{"DTD"}, CountryId{"ID"}, Timezone{4226}}, // Datadawai Airport
    Airport{IataCode{"DTE"}, CountryId{"PH"}, Timezone{4240}}, // Bagasbas Airport
    Airport{IataCode{"DTH"}, CountryId{"US"}, Timezone{2378}}, // Furnace Creek Airport
    Airport{IataCode{"DTI"}, CountryId{"BR"}, Timezone{3216}}, // Diamantina Airport
    Airport{IataCode{"DTL"}, CountryId{"US"}, Timezone{1510}}, // Detroit Lakes Airport
    Airport{IataCode{"DTM"}, CountryId{"DE"}, Timezone{5199}}, // Dortmund Airport
    Airport{IataCode{"DTN"}, CountryId{"US"}, Timezone{1510}}, // Shreveport Downtown Airport
    Airport{IataCode{"DTO"}, CountryId{"US"}, Timezone{1510}}, // Denton Municipal Airport
    Airport{IataCode{"DTW"}, CountryId{"US"}, Timezone{1682}}, // Detroit Metropolitan Wayne County Airport
    Airport{IataCode{"DUA"}, CountryId{"US"}, Timezone{1510}}, // Durant Regional Airport – Eaker Field
    Airport{IataCode{"DUB"}, CountryId{"IE"}, Timezone{5330}}, // Dublin Airport
    Airport{IataCode{"DUC"}, CountryId{"US"}, Timezone{1510}}, // Halliburton Field (airport)
    Airport{IataCode{"DUD"}, CountryId{"NZ"}, Timezone{6218}}, // Dunedin International Airport
    Airport{IataCode{"DUE"}, CountryId{"AO"}, Timezone{505}}, // Dundo Airport
    Airport{IataCode{"DUF"}, CountryId{"US"}, Timezone{2712}}, // Pine Island Airport
    Airport{IataCode{"DUG"}, CountryId{"US"}, Timezone{2931}}, // Bisbee-Douglas International Airport
    Airport{IataCode{"DUH"}, CountryId{"US"}, Timezone{1682}}, // Toledo Suburban Airport
    Airport{IataCode{"DUJ"}, CountryId{"US"}, Timezone{2712}}, // DuBois Regional Airport
    Airport{IataCode{"DUM"}, CountryId{"ID"}, Timezone{4032}}, // Pinang Kampai Airport
    Airport{IataCode{"DUQ"}, CountryId{"CA"}, Timezone{3503}}, // Duncan Airport
    Airport{IataCode{"DUR"}, CountryId{"ZA"}, Timezone{369}}, // King Shaka International Airport
    Airport{IataCode{"DUS"}, CountryId{"DE"}, Timezone{5199}}, // Düsseldorf International Airport
    Airport{IataCode{"DUT"}, CountryId{"US"}, Timezone{2745}}, // Unalaska Airport
    Airport{IataCode{"DVD"}, CountryId{"MG"}, Timezone{6035}}, // Andavadoaka Airport
    Airport{IataCode{"DVK"}, CountryId{"CA"}, Timezone{3573}}, // Diavik Airport
    Airport{IataCode{"DVL"}, CountryId{"US"}, Timezone{1510}}, // Devils Lake Regional Airport
    Airport{IataCode{"DVN"}, CountryId{"US"}, Timezone{1510}}, // Davenport Municipal Airport
    Airport{IataCode{"DVO"}, CountryId{"PH"}, Timezone{4240}}, // Francisco Bangoy International Airport
    Airport{IataCode{"DVT"}, CountryId{"US"}, Timezone{2931}}, // Phoenix Deer Valley Airport
    Airport{IataCode{"DWA"}, CountryId{"MW"}, Timezone{132}}, // Dwangwa Airport
    Airport{IataCode{"DWB"}, CountryId{"MG"}, Timezone{6035}}, // Soalala Airport
    Airport{IataCode{"DWC"}, CountryId{"AE"}, Timezone{3902}}, // Al Maktoum International Airport
    Airport{IataCode{"DWD"}, CountryId{"SA"}, Timezone{4404}}, // Dawadmi Domestic Airport
    Airport{IataCode{"DWH"}, CountryId{"US"}, Timezone{1510}}, // David Wayne Hooks Memorial Airport
    Airport{IataCode{"DWS"}, CountryId{"US"}, Timezone{2712}}, // Walt Disney World Airport
    Airport{IataCode{"DWU"}, CountryId{"US"}, Timezone{2712}}, // Ashland Regional Airport
    Airport{IataCode{"DXB"}, CountryId{"AE"}, Timezone{3902}}, // Dubai International Airport
    Airport{IataCode{"DXE"}, CountryId{"US"}, Timezone{1510}}, // Bruce Campbell Field
    Airport{IataCode{"DXR"}, CountryId{"US"}, Timezone{2712}}, // Danbury Municipal Airport
    Airport{IataCode{"DYA"}, CountryId{"AU"}, Timezone{4920}}, // Dysart Airport
    Airport{IataCode{"DYG"}, CountryId{"CN"}, Timezone{4456}}, // Zhangjiajie Hehua Airport
    Airport{IataCode{"DYL"}, CountryId{"US"}, Timezone{2712}}, // Doylestown Airport
    Airport{IataCode{"DYR"}, CountryId{"RU"}, Timezone{3667}}, // Ugolny Airport
    Airport{IataCode{"DYT"}, CountryId{"US"}, Timezone{1510}}, // Sky Harbor Airport & Seaplane Base
    Airport{IataCode{"DYU"}, CountryId{"TJ"}, Timezone{3913}}, // Dushanbe International Airport
    Airport{IataCode{"DZA"}, CountryId{"FR"}, Timezone{6175}}, // Dzaoudzi Pamandzi International Airport
    Airport{IataCode{"DZJ"}, CountryId{"US"}, Timezone{2712}}, // Blairsville Airport
    Airport{IataCode{"DZN"}, CountryId{"KZ"}, Timezone{3644}}, // Zhezkazgan Airport
    Airport{IataCode{"DZO"}, CountryId{"UY"}, Timezone{2659}}, // Santa Bernardina International Airport
    Airport{IataCode{"EAA"}, CountryId{"US"}, Timezone{814}}, // Eagle Airport
    Airport{IataCode{"EAB"}, CountryId{"YE"}, Timezone{3634}}, // Abbs Airport
    Airport{IataCode{"EAE"}, CountryId{"VU"}, Timezone{6301}}, // Siwo Airport
    Airport{IataCode{"EAL"}, CountryId{"MH"}, Timezone{6497}}, // Elenak Airport
    Airport{IataCode{"EAM"}, CountryId{"SA"}, Timezone{4404}}, // Najran Domestic Airport
    Airport{IataCode{"EAP"}, CountryId{"FR"}, Timezone{5646}}, // EuroAirport Basel-Mulhouse-Freiburg
    Airport{IataCode{"EAR"}, CountryId{"US"}, Timezone{1510}}, // Kearney Regional Airport
    Airport{IataCode{"EAS"}, CountryId{"ES"}, Timezone{5549}}, // San Sebastián Airport
    Airport{IataCode{"EAT"}, CountryId{"US"}, Timezone{2378}}, // Pangborn Memorial Airport
    Airport{IataCode{"EAU"}, CountryId{"US"}, Timezone{1510}}, // Chippewa Valley Regional Airport
    Airport{IataCode{"EBA"}, CountryId{"IT"}, Timezone{5702}}, // Marina di Campo Airport
    Airport{IataCode{"EBB"}, CountryId{"UG"}, Timezone{401}}, // Entebbe International Airport
    Airport{IataCode{"EBD"}, CountryId{"SD"}, Timezone{432}}, // El Obeid Airport
    Airport{IataCode{"EBG"}, CountryId{"CO"}, Timezone{1376}}, // El Bagre Airport
    Airport{IataCode{"EBJ"}, CountryId{"DK"}, Timezone{5312}}, // Esbjerg Airport
    Airport{IataCode{"EBL"}, CountryId{"IQ"}, Timezone{3728}}, // Erbil International Airport
    Airport{IataCode{"EBO"}, CountryId{"MH"}, Timezone{6515}}, // Ebon Airport
    Airport{IataCode{"EBS"}, CountryId{"US"}, Timezone{1510}}, // Webster City Municipal Airport
    Airport{IataCode{"EBU"}, CountryId{"FR"}, Timezone{5646}}, // Saint-Étienne – Bouthéon Airport
    Airport{IataCode{"EBW"}, CountryId{"CM"}, Timezone{293}}, // Ebolowa Airport
    Airport{IataCode{"ECG"}, CountryId{"US"}, Timezone{2712}}, // Elizabeth City Regional Airport
    Airport{IataCode{"ECH"}, CountryId{"AU"}, Timezone{5067}}, // Echuca Airport
    Airport{IataCode{"ECI"}, CountryId{"NI"}, Timezone{2435}}, // Costa Esmeralda Airport
    Airport{IataCode{"ECN"}, CountryId{"CY"}, Timezone{3927}}, // Ercan International Airport
    Airport{IataCode{"ECP"}, CountryId{"US"}, Timezone{1510}}, // Northwest Florida Beaches International Airport
    Airport{IataCode{"ECR"}, CountryId{}, Timezone{1376}}, // El Charco Airport
    Airport{IataCode{"ECV"}, CountryId{"ES"}, Timezone{5549}}, // Cuatro Vientos Airport
    Airport{IataCode{"EDB"}, CountryId{"SD"}, Timezone{432}}, // El Debba Airport
    Airport{IataCode{"EDC"}, CountryId{"US"}, Timezone{1510}}, // Austin Executive Airport
    Airport{IataCode{"EDE"}, CountryId{"US"}, Timezone{2712}}, // Northeastern Regional Airport
    Airport{IataCode{"EDI"}, CountryId{"GB"}, Timezone{5517}}, // Edinburgh Airport
    Airport{IataCode{"EDJ"}, CountryId{"US"}, Timezone{2712}}, // Bellefontaine Regional Airport
    Airport{IataCode{"EDK"}, CountryId{"US"}, Timezone{1510}}, // Captain Jack Thomas/El Dorado Airport
    Airport{IataCode{"EDL"}, CountryId{"KE"}, Timezone{641}}, // Eldoret International Airport
    Airport{IataCode{"EDM"}, CountryId{"FR"}, Timezone{5646}}, // La Roche-sur-Yon - Les Ajoncs Airport
    Airport{IataCode{"EDO"}, CountryId{"TR"}, Timezone{5412}}, // Balıkesir Koca Seyit Airport
    Airport{IataCode{"EDQ"}, CountryId{"HN"}, Timezone{3401}}, // Erandique Airport
    Airport{IataCode{"EDR"}, CountryId{"AU"}, Timezone{}}, // Edward River Airport
    Airport{IataCode{"EDU"}, CountryId{"US"}, Timezone{2378}}, // University Airport
    Airport{IataCode{"EED"}, CountryId{"US"}, Timezone{2378}}, // Needles Airport
    Airport{IataCode{"EEK"}, CountryId{"US"}, Timezone{2745}}, // Eek Airport
    Airport{IataCode{"EEN"}, CountryId{"US"}, Timezone{2712}}, // Dillant–Hopkins Airport
    Airport{IataCode{"EET"}, CountryId{"US"}, Timezone{1510}}, // Shelby County Airport
    Airport{IataCode{"EFD"}, CountryId{"US"}, Timezone{1510}}, // Ellington International Airport
    Airport{IataCode{"EFG"}, CountryId{"PG"}, Timezone{6686}}, // Efogi Airport
    Airport{IataCode{"EFK"}, CountryId{"US"}, Timezone{2712}}, // Newport State Airport (Vermont)
    Airport{IataCode{"EFL"}, CountryId{"GR"}, Timezone{5169}}, // Cephalonia International Airport “Anna Pollatou”
    Airport{IataCode{"EGC"}, CountryId{"FR"}, Timezone{5646}}, // Bergerac Dordogne Périgord Airport
    Airport{IataCode{"EGE"}, CountryId{"US"}, Timezone{1667}}, // Eagle County Regional Airport
    Airport{IataCode{"EGH"}, CountryId{"EG"}, Timezone{184}}, // El Gora Airport
    Airport{IataCode{"EGI"}, CountryId{"US"}, Timezone{1510}}, // Duke Field
    Airport{IataCode{"EGL"}, CountryId{"ET"}, Timezone{28}}, // Neghelle Airport
    Airport{IataCode{"EGM"}, CountryId{"SB"}, Timezone{6413}}, // Seghe Airport
    Airport{IataCode{"EGN"}, CountryId{"SD"}, Timezone{432}}, // Geneina Airport
    Airport{IataCode{"EGO"}, CountryId{"RU"}, Timezone{5620}}, // Belgorod International Airport
    Airport{IataCode{"EGP"}, CountryId{"US"}, Timezone{1510}}, // Maverick County Memorial International Airport
    Airport{IataCode{"EGS"}, CountryId{"IS"}, Timezone{4823}}, // Egilsstaðir Airport
    Airport{IataCode{"EGT"}, CountryId{"US"}, Timezone{1510}}, // Wellington Municipal Airport
    Airport{IataCode{"EGV"}, CountryId{"US"}, Timezone{1510}}, // Eagle River Union Airport
    Airport{IataCode{"EGX"}, CountryId{"US"}, Timezone{814}}, // Egegik Airport
    Airport{IataCode{"EHA"}, CountryId{"US"}, Timezone{1510}}, // Elkhart–Morton County Airport
    Airport{IataCode{"EHL"}, CountryId{"AR"}, Timezone{1076}}, // AeroClub El Bolson
    Airport{IataCode{"EHM"}, CountryId{"US"}, Timezone{2745}}, // Cape Newenham LRRS Airport
    Airport{IataCode{"EHO"}, CountryId{"US"}, Timezone{2712}}, // Shelby-Cleveland County Regional Airport
    Airport{IataCode{"EHR"}, CountryId{"US"}, Timezone{1510}}, // Henderson City-County Airport
    Airport{IataCode{"EIB"}, CountryId{"DE"}, Timezone{5199}}, // Eisenach-Kindel Airport
    Airport{IataCode{"EIE"}, CountryId{"RU"}, Timezone{4142}}, // Yeniseysk Airport
    Airport{IataCode{"EIK"}, CountryId{"RU"}, Timezone{5620}}, // Eisk Airport
    Airport{IataCode{"EIN"}, CountryId{"NL"}, Timezone{5120}}, // Eindhoven Airport
    Airport{IataCode{"EIS"}, CountryId{"GB"}, Timezone{3487}}, // Terrance B. Lettsome International Airport
    Airport{IataCode{"EIY"}, CountryId{"IL"}, Timezone{4046}}, // Ein Yahav Airfield
    Airport{IataCode{"EJA"}, CountryId{"CO"}, Timezone{1376}}, // Yariguíes Airport
    Airport{IataCode{"EJH"}, CountryId{"SA"}, Timezone{4404}}, // Al Wajh Domestic Airport
    Airport{IataCode{"EJN"}, CountryId{"CN"}, Timezone{4456}}, // Ejin Banner Taolai Airport
    Airport{IataCode{"EJT"}, CountryId{"US"}, Timezone{6515}}, // Enejit Airport
    Airport{IataCode{"EKA"}, CountryId{"US"}, Timezone{2378}}, // Murray Field
    Airport{IataCode{"EKB"}, CountryId{"KZ"}, Timezone{3644}}, // Ekibastuz Airport
    Airport{IataCode{"EKI"}, CountryId{"US"}, Timezone{}}, // Elkhart Municipal Airport
    Airport{IataCode{"EKO"}, CountryId{"US"}, Timezone{2378}}, // Elko Regional Airport
    Airport{IataCode{"EKQ"}, CountryId{"US"}, Timezone{2303}}, // Wayne County Airport
    Airport{IataCode{"EKS"}, CountryId{"RU"}, Timezone{}}, // Shakhtyorsk Airport
    Airport{IataCode{"EKT"}, CountryId{"SE"}, Timezone{5822}}, // Eskilstuna Airport
    Airport{IataCode{"EKX"}, CountryId{"US"}, Timezone{2712}}, // Elizabethtown Regional Airport
    Airport{IataCode{"EKY"}, CountryId{"US"}, Timezone{1510}}, // Bessemer Airport
    Airport{IataCode{"ELB"}, CountryId{}, Timezone{1376}}, // Las Flores Airport
    Airport{IataCode{"ELC"}, CountryId{"AU"}, Timezone{4978}}, // Elcho Island Airport
    Airport{IataCode{"ELD"}, CountryId{"US"}, Timezone{1510}}, // South Arkansas Regional Airport at Goodwin Field
    Airport{IataCode{"ELE"}, CountryId{"PA"}, Timezone{2877}}, // El Real Airport
    Airport{IataCode{"ELF"}, CountryId{"SD"}, Timezone{432}}, // El Fasher Airport
    Airport{IataCode{"ELG"}, CountryId{"DZ"}, Timezone{47}}, // El Golea Airport
    Airport{IataCode{"ELH"}, CountryId{"BS"}, Timezone{2697}}, // North Eleuthera Airport
    Airport{IataCode{"ELI"}, CountryId{"US"}, Timezone{2745}}, // Elim Airport
    Airport{IataCode{"ELK"}, CountryId{"US"}, Timezone{1510}}, // Elk City Regional Business Airport
    Airport{IataCode{"ELM"}, CountryId{"US"}, Timezone{2712}}, // Elmira Corning Regional Airport
    Airport{IataCode{"ELN"}, CountryId{"US"}, Timezone{2378}}, // Bowers Airport
    Airport{IataCode{"ELO"}, CountryId{"AR"}, Timezone{1220}}, // El Dorado Airport, Argentina
    Airport{IataCode{"ELP"}, CountryId{"US"}, Timezone{1667}}, // El Paso International Airport
    Airport{IataCode{"ELQ"}, CountryId{"SA"}, Timezone{4404}}, // Prince Nayef bin Abdulaziz Regional Airport
    Airport{IataCode{"ELS"}, CountryId{"ZA"}, Timezone{369}}, // East London Airport
    Airport{IataCode{"ELT"}, CountryId{"EG"}, Timezone{184}}, // El Tor Airport
    Airport{IataCode{"ELU"}, CountryId{"DZ"}, Timezone{47}}, // Guemar Airport
    Airport{IataCode{"ELV"}, CountryId{"US"}, Timezone{2260}}, // Elfin Cove Seaplane Base
    Airport{IataCode{"ELX"}, CountryId{"VE"}, Timezone{1463}}, // El Tigre Airport
    Airport{IataCode{"ELY"}, CountryId{"US"}, Timezone{2378}}, // Ely Airport
    Airport{IataCode{"ELZ"}, CountryId{"US"}, Timezone{2712}}, // Wellsville Municipal Airport
    Airport{IataCode{"EMA"}, CountryId{"GB"}, Timezone{5517}}, // East Midlands Airport
    Airport{IataCode{"EMD"}, CountryId{"AU"}, Timezone{4920}}, // Emerald Airport
    Airport{IataCode{"EME"}, CountryId{"DE"}, Timezone{5199}}, // Emden Airport
    Airport{IataCode{"EMI"}, CountryId{"PG"}, Timezone{6686}}, // Emirau Airport
    Airport{IataCode{"EMK"}, CountryId{"US"}, Timezone{2745}}, // Emmonak Airport
    Airport{IataCode{"EMM"}, CountryId{"US"}, Timezone{1667}}, // Kemmerer Municipal Airport
    Airport{IataCode{"EMN"}, CountryId{"MR"}, Timezone{686}}, // Néma Airport
    Airport{IataCode{"EMP"}, CountryId{"US"}, Timezone{1510}}, // Emporia Municipal Airport
    Airport{IataCode{"EMT"}, CountryId{"US"}, Timezone{2378}}, // San Gabriel Valley Airport
    Airport{IataCode{"EMX"}, CountryId{"AR"}, Timezone{1076}}, // El Maitén Airport
    Airport{IataCode{"ENA"}, CountryId{"US"}, Timezone{814}}, // Kenai Municipal Airport
    Airport{IataCode{"ENC"}, CountryId{"FR"}, Timezone{5646}}, // Nancy-Essey Airport
    Airport{IataCode{"ENE"}, CountryId{"ID"}, Timezone{4226}}, // H. Hasan Aroeboesman Airport
    Airport{IataCode{"ENF"}, CountryId{"FI"}, Timezone{5377}}, // Enontekiö Airport
    Airport{IataCode{"ENH"}, CountryId{"CN"}, Timezone{4456}}, // Enshi Xujiaping Airport
    Airport{IataCode{"ENI"}, CountryId{"PH"}, Timezone{4240}}, // El Nido Airport
    Airport{IataCode{"ENJ"}, CountryId{"GT"}, Timezone{1913}}, // El Naranjo Airport
    Airport{IataCode{"ENK"}, CountryId{"GB"}, Timezone{5517}}, // Enniskillen/St Angelo Airport
    Airport{IataCode{"ENL"}, CountryId{"US"}, Timezone{1510}}, // Centralia Municipal Airport
    Airport{IataCode{"ENN"}, CountryId{"US"}, Timezone{814}}, // Nenana Municipal Airport
    Airport{IataCode{"ENO"}, CountryId{"PY"}, Timezone{1220}}, // Teniente Amin Ayub Gonzalez Airport
    Airport{IataCode{"ENS"}, CountryId{"NL"}, Timezone{5120}}, // Enschede Airport Twente
    Airport{IataCode{"ENT"}, CountryId{"MH"}, Timezone{6515}}, // Enewetak Auxiliary Airfield
    Airport{IataCode{"ENU"}, CountryId{"NG"}, Timezone{462}}, // Akanu Ibiam International Airport
    Airport{IataCode{"ENV"}, CountryId{"US"}, Timezone{2378}}, // Wendover Airport
    Airport{IataCode{"ENW"}, CountryId{"US"}, Timezone{1510}}, // Kenosha Regional Airport
    Airport{IataCode{"ENY"}, CountryId{"CN"}, Timezone{4456}}, // Yan'an Ershilipu Airport
    Airport{IataCode{"EOE"}, CountryId{"US"}, Timezone{2712}}, // Newberry County Airport
    Airport{IataCode{"EOH"}, CountryId{"CO"}, Timezone{1376}}, // Enrique Olaya Herrera Airport
    Airport{IataCode{"EOI"}, CountryId{"GB"}, Timezone{5517}}, // Eday Airport
    Airport{IataCode{"EOK"}, CountryId{"US"}, Timezone{1510}}, // Keokuk Municipal Airport
    Airport{IataCode{"EOP"}, CountryId{"US"}, Timezone{2712}}, // Pike County Airport
    Airport{IataCode{"EOR"}, CountryId{"VE"}, Timezone{1463}}, // El Dorado Airport
    Airport{IataCode{"EOS"}, CountryId{"US"}, Timezone{1510}}, // Neosho Hugh Robinson Airport
    Airport{IataCode{"EOZ"}, CountryId{"VE"}, Timezone{1463}}, // Elorza Airport
    Airport{IataCode{"EPA"}, CountryId{"AR"}, Timezone{883}}, // El Palomar Airport
    Airport{IataCode{"EPH"}, CountryId{"US"}, Timezone{2378}}, // Ephrata Municipal Airport
    Airport{IataCode{"EPL"}, CountryId{"FR"}, Timezone{5646}}, // Épinal – Mirecourt Airport
    Airport{IataCode{"EPM"}, CountryId{"US"}, Timezone{2712}}, // Eastport Municipal Airport
    Airport{IataCode{"EPR"}, CountryId{"AU"}, Timezone{5087}}, // Esperance Airport
    Airport{IataCode{"EPS"}, CountryId{"DO"}, Timezone{3194}}, // Arroyo Barril Airport
    Airport{IataCode{"EPU"}, CountryId{"EE"}, Timezone{5839}}, // Pärnu Airport
    Airport{IataCode{"EQS"}, CountryId{"AR"}, Timezone{914}}, // Esquel Airport
    Airport{IataCode{"EQY"}, CountryId{"US"}, Timezone{2712}}, // Charlotte-Monroe Executive Airport
    Airport{IataCode{"ERA"}, CountryId{"SO"}, Timezone{608}}, // Erigavo Airport
    Airport{IataCode{"ERC"}, CountryId{"TR"}, Timezone{5412}}, // Erzincan Airport
    Airport{IataCode{"ERD"}, CountryId{"UA"}, Timezone{6003}}, // Berdyansk Airport
    Airport{IataCode{"ERF"}, CountryId{"DE"}, Timezone{5199}}, // Erfurt-Weimar Airport
    Airport{IataCode{"ERG"}, CountryId{"RU"}, Timezone{4006}}, // Erbogachen Airport
    Airport{IataCode{"ERH"}, CountryId{"MA"}, Timezone{215}}, // Moulay Ali Cherif Airport
    Airport{IataCode{"ERI"}, CountryId{"US"}, Timezone{2712}}, // Erie International Airport
    Airport{IataCode{"ERL"}, CountryId{"CN"}, Timezone{4456}}, // Erenhot Saiwusu International Airport
    Airport{IataCode{"ERM"}, CountryId{"BR"}, Timezone{3216}}, // Erechim Airport
    Airport{IataCode{"ERN"}, CountryId{"BR"}, Timezone{1732}}, // Eirunepé Airport
    Airport{IataCode{"ERQ"}, CountryId{"AU"}, Timezone{4920}}, // Elrose Airport
    Airport{IataCode{"ERR"}, CountryId{"US"}, Timezone{2712}}, // Errol Airport
    Airport{IataCode{"ERS"}, CountryId{"NA"}, Timezone{785}}, // Eros Airport
    Airport{IataCode{"ERV"}, CountryId{"US"}, Timezone{1510}}, // Kerrville Municipal Airport
    Airport{IataCode{"ERY"}, CountryId{"US"}, Timezone{1682}}, // Luce County Airport
    Airport{IataCode{"ERZ"}, CountryId{"TR"}, Timezone{5412}}, // Erzurum Airport
    Airport{IataCode{"ESB"}, CountryId{"TR"}, Timezone{5412}}, // Esenboğa International Airport
    Airport{IataCode{"ESC"}, CountryId{"US"}, Timezone{1682}}, // Delta County Airport
    Airport{IataCode{"ESD"}, CountryId{"US"}, Timezone{2378}}, // Orcas Island Airport
    Airport{IataCode{"ESE"}, CountryId{"MX"}, Timezone{3455}}, // Ensenada Airport
    Airport{IataCode{"ESG"}, CountryId{"PY"}, Timezone{1220}}, // Dr. Luis María Argaña International Airport
    Airport{IataCode{"ESH"}, CountryId{"GB"}, Timezone{5517}}, // Shoreham Airport
    Airport{IataCode{"ESK"}, CountryId{"TR"}, Timezone{5412}}, // Eskişehir Airport
    Airport{IataCode{"ESL"}, CountryId{"RU"}, Timezone{5620}}, // Elista Airport
    Airport{IataCode{"ESM"}, CountryId{"EC"}, Timezone{1949}}, // Colonel Carlos Concha Torres Airport
    Airport{IataCode{"ESN"}, CountryId{"US"}, Timezone{2712}}, // Easton Airport
    Airport{IataCode{"ESO"}, CountryId{"US"}, Timezone{1667}}, // Ohkay Owingeh Airport
    Airport{IataCode{"ESP"}, CountryId{"US"}, Timezone{2712}}, // Stroudsburg-Pocono Airport
    Airport{IataCode{"ESR"}, CountryId{"CL"}, Timezone{3177}}, // Ricardo García Posada Airport
    Airport{IataCode{"ESS"}, CountryId{"DE"}, Timezone{5199}}, // Flughafen Essen/Mülheim
    Airport{IataCode{"ESU"}, CountryId{"MA"}, Timezone{215}}, // Mogador Airport
    Airport{IataCode{"ESW"}, CountryId{"US"}, Timezone{2378}}, // Easton State Airport
    Airport{IataCode{"ETB"}, CountryId{"US"}, Timezone{1510}}, // West Bend Municipal Airport
    Airport{IataCode{"ETH"}, CountryId{"IL"}, Timezone{184}}, // Eilat Airport
    Airport{IataCode{"ETR"}, CountryId{"EC"}, Timezone{1949}}, // Santa Rosa Airport
    Airport{IataCode{"ETS"}, CountryId{"US"}, Timezone{1510}}, // Enterprise Municipal Airport
    Airport{IataCode{"ETZ"}, CountryId{"FR"}, Timezone{5646}}, // Metz-Nancy-Lorraine Airport
    Airport{IataCode{"EUA"}, CountryId{"TO"}, Timezone{6770}}, // 'Eua Airport
    Airport{IataCode{"EUC"}, CountryId{"AU"}, Timezone{4995}}, // Eucla Airport
    Airport{IataCode{"EUE"}, CountryId{"US"}, Timezone{2378}}, // Eureka Airport
    Airport{IataCode{"EUF"}, CountryId{"US"}, Timezone{1510}}, // Weedon Field
    Airport{IataCode{"EUG"}, CountryId{"US"}, Timezone{2378}}, // Eugene Airport
    Airport{IataCode{"EUL"}, CountryId{"US"}, Timezone{1391}}, // Caldwell Industrial Airport
    Airport{IataCode{"EUN"}, CountryId{"MA"}, Timezone{307}}, // Hassan I Airport
    Airport{IataCode{"EUQ"}, CountryId{"PH"}, Timezone{4240}}, // Evelio Javier Airport
    Airport{IataCode{"EUX"}, CountryId{"NL"}, Timezone{2331}}, // F.D. Roosevelt Airport
    Airport{IataCode{"EVB"}, CountryId{"US"}, Timezone{2712}}, // New Smyrna Beach Municipal Airport
    Airport{IataCode{"EVE"}, CountryId{"NO"}, Timezone{5634}}, // Harstad/Narvik Airport, Evenes
    Airport{IataCode{"EVG"}, CountryId{"SE"}, Timezone{5822}}, // Härjedalen Sveg Airport
    Airport{IataCode{"EVH"}, CountryId{"AU"}, Timezone{5103}}, // Evans Head Memorial Aerodrome
    Airport{IataCode{"EVN"}, CountryId{"AM"}, Timezone{4709}}, // Zvartnots International Airport
    Airport{IataCode{"EVU"}, CountryId{"US"}, Timezone{1510}}, // Northwest Missouri Regional Airport
    Airport{IataCode{"EVV"}, CountryId{"US"}, Timezone{1510}}, // Evansville Regional Airport
    Airport{IataCode{"EVY"}, CountryId{"US"}, Timezone{2712}}, // Summit Airport
    Airport{IataCode{"EWB"}, CountryId{"US"}, Timezone{2712}}, // New Bedford Regional Airport
    Airport{IataCode{"EWE"}, CountryId{"ID"}, Timezone{4032}}, // Ewer Airport
    Airport{IataCode{"EWI"}, CountryId{"ID"}, Timezone{4032}}, // Enarotali Airport
    Airport{IataCode{"EWK"}, CountryId{"US"}, Timezone{1510}}, // Newton City/County Airport
    Airport{IataCode{"EWN"}, CountryId{"US"}, Timezone{2712}}, // Coastal Carolina Regional Airport
    Airport{IataCode{"EWO"}, CountryId{"CG"}, Timezone{148}}, // Ewo Airport
    Airport{IataCode{"EWR"}, CountryId{"US"}, Timezone{2712}}, // Newark Liberty International Airport
    Airport{IataCode{"EXI"}, CountryId{"US"}, Timezone{2260}}, // Excursion Inlet Seaplane Base
    Airport{IataCode{"EXT"}, CountryId{"GB"}, Timezone{5517}}, // Exeter International Airport
    Airport{IataCode{"EXX"}, CountryId{"US"}, Timezone{2712}}, // Davidson County Airport
    Airport{IataCode{"EYF"}, CountryId{"US"}, Timezone{2712}}, // Curtis L. Brown Jr. Field
    Airport{IataCode{"EYK"}, CountryId{"RU"}, Timezone{4690}}, // Beloyarsk Airport
    Airport{IataCode{"EYL"}, CountryId{"ML"}, Timezone{76}}, // Yélimané Airport
    Airport{IataCode{"EYP"}, CountryId{"CO"}, Timezone{1376}}, // El Alcaraván Airport
    Airport{IataCode{"EYQ"}, CountryId{"US"}, Timezone{1510}}, // Weiser Air Park
    Airport{IataCode{"EYR"}, CountryId{"US"}, Timezone{2378}}, // Yerington Municipal Airport
    Airport{IataCode{"EYS"}, CountryId{"KE"}, Timezone{641}}, // Eliye Springs Airport
    Airport{IataCode{"EYW"}, CountryId{"US"}, Timezone{2712}}, // Key West International Airport
    Airport{IataCode{"EZE"}, CountryId{"AR"}, Timezone{883}}, // Ministro Pistarini International Airport
    Airport{IataCode{"EZS"}, CountryId{"TR"}, Timezone{5412}}, // Elazığ Airport
    Airport{IataCode{"FAA"}, CountryId{"GN"}, Timezone{228}}, // Faranah Airport
    Airport{IataCode{"FAB"}, CountryId{"GB"}, Timezone{5517}}, // Farnborough Airport
    Airport{IataCode{"FAC"}, CountryId{"FR"}, Timezone{6740}}, // Faaite Airport
    Airport{IataCode{"FAE"}, CountryId{"FO"}, Timezone{4791}}, // Vágar Airport
    Airport{IataCode{"FAG"}, CountryId{"IS"}, Timezone{4823}}, // Fagurhólsmýri Airport
    Airport{IataCode{"FAH"}, CountryId{"AF"}, Timezone{4061}}, // Farah Airport
    Airport{IataCode{"FAI"}, CountryId{"US"}, Timezone{814}}, // Fairbanks International Airport
    Airport{IataCode{"FAJ"}, CountryId{"US"}, Timezone{3012}}, // Diego Jiménez Torres Airport
    Airport{IataCode{"FAN"}, CountryId{"NO"}, Timezone{5634}}, // Farsund Airport
    Airport{IataCode{"FAO"}, CountryId{"PT"}, Timezone{5486}}, // Faro Airport
    Airport{IataCode{"FAQ"}, CountryId{"PG"}, Timezone{6686}}, // Frieda River Airport
    Airport{IataCode{"FAR"}, CountryId{"US"}, Timezone{1510}}, // Hector International Airport
    Airport{IataCode{"FAS"}, CountryId{"IS"}, Timezone{4823}}, // Fáskrúðsfjörður Airport
    Airport{IataCode{"FAT"}, CountryId{"US"}, Timezone{2378}}, // Fresno Yosemite International Airport
    Airport{IataCode{"FAU"}, CountryId{"OM"}, Timezone{4252}}, // Fahud Airport Airport
    Airport{IataCode{"FAV"}, CountryId{"FR"}, Timezone{6740}}, // Fakarava Airport
    Airport{IataCode{"FAY"}, CountryId{"US"}, Timezone{2712}}, // Fayetteville Regional Airport
    Airport{IataCode{"FAZ"}, CountryId{"IR"}, Timezone{4543}}, // Fasa Airport
    Airport{IataCode{"FBA"}, CountryId{"BR"}, Timezone{2451}}, // Fonte Boa Airport
    Airport{IataCode{"FBD"}, CountryId{"AF"}, Timezone{4061}}, // Fayzabad Airport
    Airport{IataCode{"FBE"}, CountryId{"BR"}, Timezone{3216}}, // Francisco Beltrão Airport
    Airport{IataCode{"FBM"}, CountryId{"CD"}, Timezone{519}}, // Lubumbashi International Airport
    Airport{IataCode{"FBS"}, CountryId{"US"}, Timezone{2378}}, // Friday Harbor Seaplane Base
    Airport{IataCode{"FCA"}, CountryId{"US"}, Timezone{1667}}, // Glacier Park International Airport
    Airport{IataCode{"FCB"}, CountryId{"ZA"}, Timezone{369}}, // Ficksburg Sentraoes Airport
    Airport{IataCode{"FCH"}, CountryId{"US"}, Timezone{2378}}, // Fresno Chandler Executive Airport
    Airport{IataCode{"FCI"}, CountryId{"US"}, Timezone{2712}}, // Chesterfield County Airport
    Airport{IataCode{"FCM"}, CountryId{"US"}, Timezone{1510}}, // Flying Cloud Airport
    Airport{IataCode{"FCN"}, CountryId{"DE"}, Timezone{5199}}, // Sea-Airport Cuxhaven/Nordholz
    Airport{IataCode{"FCO"}, CountryId{"IT"}, Timezone{5702}}, // Leonardo da Vinci–Fiumicino Airport
    Airport{IataCode{"FCY"}, CountryId{"US"}, Timezone{1510}}, // Forrest City Municipal Airport
    Airport{IataCode{"FDE"}, CountryId{"NO"}, Timezone{5634}}, // Førde Airport
    Airport{IataCode{"FDF"}, CountryId{"FR"}, Timezone{2482}}, // Martinique Aimé Césaire International Airport
    Airport{IataCode{"FDH"}, CountryId{"DE"}, Timezone{5199}}, // Friedrichshafen Airport
    Airport{IataCode{"FDK"}, CountryId{"US"}, Timezone{2712}}, // Frederick Municipal Airport
    Airport{IataCode{"FDO"}, CountryId{"AR"}, Timezone{883}}, // San Fernando Airport
    Airport{IataCode{"FDR"}, CountryId{"US"}, Timezone{1510}}, // Frederick Regional Airport
    Airport{IataCode{"FDU"}, CountryId{"CD"}, Timezone{446}}, // Bandundu Airport
    Airport{IataCode{"FDW"}, CountryId{"US"}, Timezone{2712}}, // Fairfield County Airport
    Airport{IataCode{"FDY"}, CountryId{"US"}, Timezone{2712}}, // Findlay Airport
    Airport{IataCode{"FEB"}, CountryId{"NP"}, Timezone{4100}}, // Sanfebagar Airport
    Airport{IataCode{"FEC"}, CountryId{"BR"}, Timezone{1254}}, // Feira de Santana Airport
    Airport{IataCode{"FEG"}, CountryId{"UZ"}, Timezone{4516}}, // Fergana International Airport
    Airport{IataCode{"FEJ"}, CountryId{"BR"}, Timezone{3141}}, // Feijó Airport
    Airport{IataCode{"FEK"}, CountryId{"CI"}, Timezone{0}}, // Ferkessédougou Airport
    Airport{IataCode{"FEN"}, CountryId{"BR"}, Timezone{2758}}, // Fernando de Noronha Airport
    Airport{IataCode{"FEP"}, CountryId{"US"}, Timezone{1510}}, // Albertus Airport
    Airport{IataCode{"FET"}, CountryId{"US"}, Timezone{1510}}, // Fremont Municipal Airport
    Airport{IataCode{"FEZ"}, CountryId{"MA"}, Timezone{215}}, // Fes-Saïss Airport
    Airport{IataCode{"FFA"}, CountryId{"US"}, Timezone{2712}}, // First Flight Airport
    Airport{IataCode{"FFC"}, CountryId{"US"}, Timezone{2712}}, // Atlanta Regional Airport
    Airport{IataCode{"FFL"}, CountryId{"US"}, Timezone{1510}}, // Fairfield Municipal Airport
    Airport{IataCode{"FFM"}, CountryId{"US"}, Timezone{1510}}, // Fergus Falls Municipal Airport
    Airport{IataCode{"FFT"}, CountryId{"US"}, Timezone{2712}}, // Capital City Airport
    Airport{IataCode{"FFU"}, CountryId{"CL"}, Timezone{}}, // Futaleufu Airport
    Airport{IataCode{"FFX"}, CountryId{"US"}, Timezone{1682}}, // Fremont Municipal Airport
    Airport{IataCode{"FGD"}, CountryId{"MR"}, Timezone{686}}, // Fderik Airport
    Airport{IataCode{"FGI"}, CountryId{"WS"}, Timezone{6205}}, // Fagali'i Airport
    Airport{IataCode{"FGL"}, CountryId{"NZ"}, Timezone{6218}}, // Fox Glacier Heliport
    Airport{IataCode{"FGU"}, CountryId{"FR"}, Timezone{6740}}, // Fangatau Airport
    Airport{IataCode{"FGX"}, CountryId{"US"}, Timezone{2712}}, // Fleming-Mason Airport
    Airport{IataCode{"FHB"}, CountryId{"US"}, Timezone{2712}}, // Fernandina Beach Municipal Airport
    Airport{IataCode{"FHU"}, CountryId{"US"}, Timezone{2931}}, // Sierra Vista Municipal Airport
    Airport{IataCode{"FID"}, CountryId{"US"}, Timezone{2712}}, // Elizabeth Field
    Airport{IataCode{"FIE"}, CountryId{"GB"}, Timezone{5517}}, // Fair Isle Airport
    Airport{IataCode{"FIG"}, CountryId{"GN"}, Timezone{228}}, // Fria Airport
    Airport{IataCode{"FIH"}, CountryId{"CD"}, Timezone{148}}, // N'djili Airport
    Airport{IataCode{"FIL"}, CountryId{"US"}, Timezone{1667}}, // Fillmore Municipal Airport
    Airport{IataCode{"FIN"}, CountryId{"PG"}, Timezone{6686}}, // Finschhafen Airport
    Airport{IataCode{"FIT"}, CountryId{"US"}, Timezone{2712}}, // Fitchburg Municipal Airport
    Airport{IataCode{"FIZ"}, CountryId{"AU"}, Timezone{5087}}, // Fitzroy Crossing Airport
    Airport{IataCode{"FJR"}, CountryId{"AE"}, Timezone{3902}}, // Fujairah International Airport
    Airport{IataCode{"FKA"}, CountryId{"US"}, Timezone{1510}}, // Fillmore County Airport
    Airport{IataCode{"FKB"}, CountryId{"DE"}, Timezone{5646}}, // Baden Airport
    Airport{IataCode{"FKI"}, CountryId{"CD"}, Timezone{519}}, // Bangoka International Airport
    Airport{IataCode{"FKJ"}, CountryId{"JP"}, Timezone{4568}}, // Fukui Airport
    Airport{IataCode{"FKL"}, CountryId{"US"}, Timezone{2712}}, // Venango Regional Airport
    Airport{IataCode{"FKN"}, CountryId{"US"}, Timezone{2712}}, // Franklin Municipal-John Beverly Rose Airport
    Airport{IataCode{"FKQ"}, CountryId{"ID"}, Timezone{4032}}, // Fakfak Airport
    Airport{IataCode{"FKS"}, CountryId{"JP"}, Timezone{4568}}, // Fukushima Airport
    Airport{IataCode{"FLA"}, CountryId{"CO"}, Timezone{1376}}, // Gustavo Artunduaga Paredes Airport
    Airport{IataCode{"FLB"}, CountryId{"BR"}, Timezone{1789}}, // Floriano Airport
    Airport{IataCode{"FLD"}, CountryId{"US"}, Timezone{1510}}, // Fond du Lac County Airport
    Airport{IataCode{"FLF"}, CountryId{"DE"}, Timezone{5199}}, // Schaferhaus Airport
    Airport{IataCode{"FLG"}, CountryId{"US"}, Timezone{2931}}, // Flagstaff Pulliam Airport
    Airport{IataCode{"FLL"}, CountryId{"US"}, Timezone{2712}}, // Fort Lauderdale–Hollywood International Airport
    Airport{IataCode{"FLM"}, CountryId{"PY"}, Timezone{1220}}, // Filadelfia Airport
    Airport{IataCode{"FLN"}, CountryId{"BR"}, Timezone{3216}}, // Hercílio Luz International Airport
    Airport{IataCode{"FLO"}, CountryId{"US"}, Timezone{2712}}, // Florence Regional Airport
    Airport{IataCode{"FLP"}, CountryId{"US"}, Timezone{1510}}, // Marion County Regional Airport
    Airport{IataCode{"FLR"}, CountryId{"IT"}, Timezone{5702}}, // Florence Airport, Peretola
    Airport{IataCode{"FLS"}, CountryId{"AU"}, Timezone{5011}}, // Flinders Island Airport
    Airport{IataCode{"FLT"}, CountryId{"HT"}, Timezone{2947}}, // Phaeton Airport
    Airport{IataCode{"FLU"}, CountryId{"US"}, Timezone{2712}}, // Flushing Airport
    Airport{IataCode{"FLW"}, CountryId{"PT"}, Timezone{4722}}, // Flores Airport
    Airport{IataCode{"FLX"}, CountryId{"US"}, Timezone{2378}}, // Fallon Municipal Airport
    Airport{IataCode{"FLY"}, CountryId{"US"}, Timezone{1667}}, // Meadow Lake Airport
    Airport{IataCode{"FMA"}, CountryId{"AR"}, Timezone{942}}, // Formosa International Airport
    Airport{IataCode{"FMC"}, CountryId{"US"}, Timezone{814}}, // Five Mile Airport
    Airport{IataCode{"FME"}, CountryId{"US"}, Timezone{2712}}, // Tipton Airport
    Airport{IataCode{"FMI"}, CountryId{"CD"}, Timezone{519}}, // Kalemie Airport
    Airport{IataCode{"FMM"}, CountryId{"DE"}, Timezone{5199}}, // Memmingen Airport
    Airport{IataCode{"FMN"}, CountryId{"US"}, Timezone{1667}}, // Four Corners Regional Airport
    Airport{IataCode{"FMO"}, CountryId{"DE"}, Timezone{5199}}, // Münster Osnabrück International Airport
    Airport{IataCode{"FMU"}, CountryId{"US"}, Timezone{2378}}, // Florence Municipal Airport
    Airport{IataCode{"FMY"}, CountryId{"US"}, Timezone{2712}}, // Page Field
    Airport{IataCode{"FMZ"}, CountryId{"US"}, Timezone{1510}}, // Fairmont State Airfield
    Airport{IataCode{"FNA"}, CountryId{"SL"}, Timezone{323}}, // Lungi International Airport
    Airport{IataCode{"FNB"}, CountryId{"DE"}, Timezone{5199}}, // Neubrandenburg Airport
    Airport{IataCode{"FNC"}, CountryId{"PT"}, Timezone{4806}}, // Cristiano Ronaldo Airport
    Airport{IataCode{"FNE"}, CountryId{"PG"}, Timezone{6686}}, // Fane Airport
    Airport{IataCode{"FNG"}, CountryId{"BF"}, Timezone{704}}, // Fada N'gourma Airport
    Airport{IataCode{"FNH"}, CountryId{"ET"}, Timezone{28}}, // Fincha Airport
    Airport{IataCode{"FNI"}, CountryId{"FR"}, Timezone{5646}}, // Nîmes-Alès-Camargue-Cévennes Airport
    Airport{IataCode{"FNJ"}, CountryId{"KP"}, Timezone{4363}}, // Pyongyang Sunan International Airport
    Airport{IataCode{"FNL"}, CountryId{"US"}, Timezone{1667}}, // Fort Collins–Loveland Municipal Airport
    Airport{IataCode{"FNR"}, CountryId{"US"}, Timezone{2260}}, // Funter Bay Seaplane Base
    Airport{IataCode{"FNT"}, CountryId{"US"}, Timezone{1682}}, // Bishop International Airport
    Airport{IataCode{"FNU"}, CountryId{"IT"}, Timezone{5702}}, // Oristano-Fenosu Airport
    Airport{IataCode{"FOA"}, CountryId{"GB"}, Timezone{5517}}, // Foula Airfield
    Airport{IataCode{"FOC"}, CountryId{"CN"}, Timezone{4456}}, // Fuzhou Changle International Airport
    Airport{IataCode{"FOD"}, CountryId{"US"}, Timezone{1510}}, // Fort Dodge Regional Airport
    Airport{IataCode{"FOE"}, CountryId{"US"}, Timezone{1510}}, // Topeka Regional Airport
    Airport{IataCode{"FOG"}, CountryId{"IT"}, Timezone{5702}}, // Foggia "Gino Lisa" Airport
    Airport{IataCode{"FOK"}, CountryId{"US"}, Timezone{2712}}, // Francis S. Gabreski Airport
    Airport{IataCode{"FOM"}, CountryId{"CM"}, Timezone{293}}, // Foumban Nkounja Airport
    Airport{IataCode{"FON"}, CountryId{"CR"}, Timezone{1544}}, // Arenal Airport
    Airport{IataCode{"FOO"}, CountryId{"ID"}, Timezone{4032}}, // Kornasoren Airport
    Airport{IataCode{"FOR"}, CountryId{"BR"}, Timezone{1789}}, // Pinto Martins – Fortaleza International Airport
    Airport{IataCode{"FOS"}, CountryId{"AU"}, Timezone{5087}}, // Forrest Airport
    Airport{IataCode{"FOT"}, CountryId{"AU"}, Timezone{}}, // Forster (Wallis Island) Airport
    Airport{IataCode{"FOU"}, CountryId{"GA"}, Timezone{475}}, // Fougamou Airport
    Airport{IataCode{"FOY"}, CountryId{"LR"}, Timezone{323}}, // Foya Airport
    Airport{IataCode{"FPK"}, CountryId{"US"}, Timezone{1682}}, // Fitch H. Beach Airport
    Airport{IataCode{"FPO"}, CountryId{"BS"}, Timezone{2697}}, // Grand Bahama International Airport
    Airport{IataCode{"FPR"}, CountryId{"US"}, Timezone{2712}}, // Treasure Coast International Airport
    Airport{IataCode{"FPY"}, CountryId{"US"}, Timezone{2712}}, // Perry-Foley Airport
    Airport{IataCode{"FRA"}, CountryId{"DE"}, Timezone{5199}}, // Frankfurt Airport
    Airport{IataCode{"FRB"}, CountryId{"AU"}, Timezone{5103}}, // Forbes Airport
    Airport{IataCode{"FRC"}, CountryId{"BR"}, Timezone{3216}}, // Franca Airport
    Airport{IataCode{"FRD"}, CountryId{"US"}, Timezone{2378}}, // Friday Harbor Airport
    Airport{IataCode{"FRE"}, CountryId{"SB"}, Timezone{6413}}, // Fera Airport
    Airport{IataCode{"FRG"}, CountryId{"US"}, Timezone{2712}}, // Republic Airport
    Airport{IataCode{"FRH"}, CountryId{"US"}, Timezone{2163}}, // French Lick Municipal Airport
    Airport{IataCode{"FRJ"}, CountryId{"FR"}, Timezone{5646}}, // Frejus Airport
    Airport{IataCode{"FRK"}, CountryId{"SC"}, Timezone{6130}}, // Frégate Island Airport
    Airport{IataCode{"FRL"}, CountryId{"IT"}, Timezone{5702}}, // Forlì Airport
    Airport{IataCode{"FRM"}, CountryId{"US"}, Timezone{1510}}, // Fairmont Municipal Airport
    Airport{IataCode{"FRO"}, CountryId{"NO"}, Timezone{5634}}, // Florø Airport
    Airport{IataCode{"FRR"}, CountryId{"US"}, Timezone{2712}}, // Front Royal-Warren County Airport
    Airport{IataCode{"FRS"}, CountryId{"GT"}, Timezone{1913}}, // Mundo Maya International Airport
    Airport{IataCode{"FRT"}, CountryId{"CL"}, Timezone{3177}}, // Frutillar Airport
    Airport{IataCode{"FRU"}, CountryId{"KG"}, Timezone{3802}}, // Manas International Airport
    Airport{IataCode{"FRW"}, CountryId{"BW"}, Timezone{339}}, // Francistown Airport
    Airport{IataCode{"FRY"}, CountryId{"US"}, Timezone{2712}}, // Eastern Slopes Regional Airport
    Airport{IataCode{"FSC"}, CountryId{"FR"}, Timezone{5646}}, // Figari Sud-Corse Airport
    Airport{IataCode{"FSD"}, CountryId{"US"}, Timezone{1510}}, // Sioux Falls Regional Airport
    Airport{IataCode{"FSK"}, CountryId{"US"}, Timezone{1510}}, // Fort Scott Municipal Airport
    Airport{IataCode{"FSM"}, CountryId{"US"}, Timezone{1510}}, // Fort Smith Regional Airport
    Airport{IataCode{"FSO"}, CountryId{"US"}, Timezone{2712}}, // Franklin County State Airport
    Airport{IataCode{"FSP"}, CountryId{"FR"}, Timezone{2608}}, // Saint-Pierre Airport
    Airport{IataCode{"FST"}, CountryId{"US"}, Timezone{1510}}, // Fort Stockton-Pecos County Airport
    Airport{IataCode{"FSU"}, CountryId{"US"}, Timezone{1667}}, // Fort Sumner Municipal Airport
    Airport{IataCode{"FSZ"}, CountryId{"JP"}, Timezone{4568}}, // Shizuoka Airport
    Airport{IataCode{"FTA"}, CountryId{"VU"}, Timezone{6301}}, // Futuna Airport
    Airport{IataCode{"FTE"}, CountryId{"AR"}, Timezone{1045}}, // Comandante Armando Tola International Airport
    Airport{IataCode{"FTG"}, CountryId{"US"}, Timezone{1667}}, // Front Range Airport
    Airport{IataCode{"FTI"}, CountryId{"US"}, Timezone{6621}}, // Fitiuta Airport
    Airport{IataCode{"FTU"}, CountryId{"MG"}, Timezone{6035}}, // Tôlanaro Airport
    Airport{IataCode{"FTW"}, CountryId{"US"}, Timezone{1510}}, // Fort Worth Meacham International Airport
    Airport{IataCode{"FTX"}, CountryId{"CG"}, Timezone{148}}, // Owando Airport
    Airport{IataCode{"FTY"}, CountryId{"US"}, Timezone{2712}}, // Fulton County Airport
    Airport{IataCode{"FUE"}, CountryId{"ES"}, Timezone{4755}}, // Fuerteventura Airport
    Airport{IataCode{"FUG"}, CountryId{"CN"}, Timezone{4456}}, // Fuyang Xiguan Airport
    Airport{IataCode{"FUJ"}, CountryId{"JP"}, Timezone{4568}}, // Fukue Airport
    Airport{IataCode{"FUK"}, CountryId{"JP"}, Timezone{4568}}, // Fukuoka Airport
    Airport{IataCode{"FUL"}, CountryId{"US"}, Timezone{2378}}, // Fullerton Municipal Airport
    Airport{IataCode{"FUN"}, CountryId{"TV"}, Timezone{6362}}, // Funafuti International Airport
    Airport{IataCode{"FUO"}, CountryId{"CN"}, Timezone{4456}}, // Foshan Shadi Airport
    Airport{IataCode{"FUT"}, CountryId{"FR"}, Timezone{6801}}, // Pointe Vele Airport
    Airport{IataCode{"FVM"}, CountryId{"MV"}, Timezone{6142}}, // Fuvahmulah Airport
    Airport{IataCode{"FWA"}, CountryId{"US"}, Timezone{2043}}, // Fort Wayne International Airport
    Airport{IataCode{"FWB"}, CountryId{"US"}, Timezone{1510}}, // Branson West Airport
    Airport{IataCode{"FWC"}, CountryId{"US"}, Timezone{1510}}, // Fairfield Municipal Airport
    Airport{IataCode{"FWN"}, CountryId{"US"}, Timezone{2712}}, // Sussex Airport
    Airport{IataCode{"FWQ"}, CountryId{"US"}, Timezone{2712}}, // Rostraver Airport
    Airport{IataCode{"FWS"}, CountryId{"US"}, Timezone{1510}}, // Fort Worth Spinks Airport
    Airport{IataCode{"FXE"}, CountryId{"US"}, Timezone{2712}}, // Fort Lauderdale Executive Airport
    Airport{IataCode{"FXO"}, CountryId{"MZ"}, Timezone{565}}, // Cuamba Airport
    Airport{IataCode{"FXY"}, CountryId{"US"}, Timezone{1510}}, // Forest City Municipal Airport
    Airport{IataCode{"FYE"}, CountryId{"US"}, Timezone{1510}}, // Fayette County Airport
    Airport{IataCode{"FYJ"}, CountryId{"CN"}, Timezone{4456}}, // Fuyuan Dongji Airport
    Airport{IataCode{"FYM"}, CountryId{"US"}, Timezone{1510}}, // Fayetteville Municipal Airport
    Airport{IataCode{"FYN"}, CountryId{"CN"}, Timezone{4607}}, // Fuyun Koktokay Airport
    Airport{IataCode{"FYT"}, CountryId{"TD"}, Timezone{656}}, // Faya-Largeau Airport
    Airport{IataCode{"FYU"}, CountryId{"US"}, Timezone{814}}, // Fort Yukon Airport
    Airport{IataCode{"FYV"}, CountryId{"US"}, Timezone{1510}}, // Drake Field
    Airport{IataCode{"FZI"}, CountryId{"US"}, Timezone{2712}}, // Fostoria Metropolitan Airport
    Airport{IataCode{"FZO"}, CountryId{"GB"}, Timezone{5517}}, // Bristol Filton Airport
    Airport{IataCode{"FZU"}, CountryId{"CD"}, Timezone{519}}, // Luebo Airport
    Airport{IataCode{"FZY"}, CountryId{"US"}, Timezone{2712}}, // Oswego County Airport
    Airport{IataCode{"GAA"}, CountryId{"CO"}, Timezone{1376}}, // Guaymaral Airport
    Airport{IataCode{"GAB"}, CountryId{"US"}, Timezone{2378}}, // Gabbs Airport
    Airport{IataCode{"GAC"}, CountryId{"HN"}, Timezone{3401}}, // Celaque Airport
    Airport{IataCode{"GAD"}, CountryId{"US"}, Timezone{1510}}, // Northeast Alabama Regional Airport
    Airport{IataCode{"GAE"}, CountryId{"TN"}, Timezone{772}}, // Gabès – Matmata International Airport
    Airport{IataCode{"GAF"}, CountryId{"TN"}, Timezone{772}}, // Gafsa – Ksar International Airport
    Airport{IataCode{"GAG"}, CountryId{"US"}, Timezone{1510}}, // Gage Airport
    Airport{IataCode{"GAH"}, CountryId{"AU"}, Timezone{4920}}, // Gayndah Airport
    Airport{IataCode{"GAI"}, CountryId{"US"}, Timezone{2712}}, // Montgomery County Airpark
    Airport{IataCode{"GAJ"}, CountryId{"JP"}, Timezone{4568}}, // Yamagata Airport
    Airport{IataCode{"GAL"}, CountryId{"US"}, Timezone{814}}, // Edward G. Pitka Sr. Airport
    Airport{IataCode{"GAM"}, CountryId{"US"}, Timezone{2745}}, // Gambell Airport
    Airport{IataCode{"GAN"}, CountryId{"MV"}, Timezone{6142}}, // Gan International Airport
    Airport{IataCode{"GAO"}, CountryId{"CU"}, Timezone{1980}}, // Mariana Grajales Airport
    Airport{IataCode{"GAP"}, CountryId{"PG"}, Timezone{6686}}, // Gusap Airport
    Airport{IataCode{"GAQ"}, CountryId{"ML"}, Timezone{76}}, // Gao International Airport
    Airport{IataCode{"GAS"}, CountryId{"KE"}, Timezone{641}}, // Garissa Airport
    Airport{IataCode{"GAT"}, CountryId{"FR"}, Timezone{5646}}, // Gap – Tallard Airport
    Airport{IataCode{"GAU"}, CountryId{"IN"}, Timezone{4129}}, // Lokpriya Gopinath Bordoloi International Airport
    Airport{IataCode{"GAW"}, CountryId{"AU"}, Timezone{4901}}, // Gawler Aerodrome
    Airport{IataCode{"GAX"}, CountryId{"GA"}, Timezone{475}}, // Gamba Airport
    Airport{IataCode{"GAY"}, CountryId{"IN"}, Timezone{4129}}, // Gaya Airport
    Airport{IataCode{"GAZ"}, CountryId{"PG"}, Timezone{6686}}, // Guasopa Airport
    Airport{IataCode{"GBA"}, CountryId{"GB"}, Timezone{5517}}, // Cotswold Airport
    Airport{IataCode{"GBB"}, CountryId{"AZ"}, Timezone{3754}}, // Qabala Airport
    Airport{IataCode{"GBD"}, CountryId{"US"}, Timezone{1510}}, // Great Bend Municipal Airport
    Airport{IataCode{"GBE"}, CountryId{"BW"}, Timezone{339}}, // Sir Seretse Khama International Airport
    Airport{IataCode{"GBG"}, CountryId{"US"}, Timezone{1510}}, // Galesburg Municipal Airport
    Airport{IataCode{"GBH"}, CountryId{"US"}, Timezone{814}}, // Galbraith Lake Airport
    Airport{IataCode{"GBI"}, CountryId{"BS"}, Timezone{2697}}, // Grand Bahama Airport
    Airport{IataCode{"GBJ"}, CountryId{"FR"}, Timezone{1894}}, // Marie-Galante Airport
    Airport{IataCode{"GBK"}, CountryId{"SL"}, Timezone{323}}, // Gbangbatok Airport
    Airport{IataCode{"GBL"}, CountryId{"AU"}, Timezone{4978}}, // South Goulburn Island Airport
    Airport{IataCode{"GBM"}, CountryId{"SO"}, Timezone{608}}, // Garbaharey Airport
    Airport{IataCode{"GBR"}, CountryId{"US"}, Timezone{2712}}, // Walter J. Koladza Airport
    Airport{IataCode{"GBT"}, CountryId{"IR"}, Timezone{4543}}, // Gorgan Airport
    Airport{IataCode{"GBU"}, CountryId{"SD"}, Timezone{432}}, // Khashm El Girba Airport
    Airport{IataCode{"GBV"}, CountryId{"AU"}, Timezone{5087}}, // Gibb River Airport
    Airport{IataCode{"GBZ"}, CountryId{"NZ"}, Timezone{6218}}, // Great Barrier Aerodrome
    Airport{IataCode{"GCC"}, CountryId{"US"}, Timezone{1667}}, // Gillette–Campbell County Airport
    Airport{IataCode{"GCH"}, CountryId{"IR"}, Timezone{4543}}, // Gachsaran Airport
    Airport{IataCode{"GCI"}, CountryId{"GG"}, Timezone{5361}}, // Guernsey Airport
    Airport{IataCode{"GCJ"}, CountryId{"ZA"}, Timezone{369}}, // Grand Central Airport
    Airport{IataCode{"GCK"}, CountryId{"US"}, Timezone{1510}}, // Garden City Regional Airport
    Airport{IataCode{"GCM"}, CountryId{"GB"}, Timezone{1495}}, // Owen Roberts International Airport
    Airport{IataCode{"GCN"}, CountryId{"US"}, Timezone{2931}}, // Grand Canyon National Park Airport
    Airport{IataCode{"GCT"}, CountryId{"US"}, Timezone{2931}}, // Grand Canyon Bar 10 Airport
    Airport{IataCode{"GCW"}, CountryId{"US"}, Timezone{2931}}, // Grand Canyon West Airport
    Airport{IataCode{"GCY"}, CountryId{"US"}, Timezone{2712}}, // Greeneville-Greene County Municipal Airport
    Airport{IataCode{"GDA"}, CountryId{"CF"}, Timezone{104}}, // Gounda Airport
    Airport{IataCode{"GDB"}, CountryId{"US"}, Timezone{1510}}, // Granite Falls Municipal Airport
    Airport{IataCode{"GDC"}, CountryId{"US"}, Timezone{2712}}, // Donaldson Center Airport
    Airport{IataCode{"GDE"}, CountryId{"ET"}, Timezone{28}}, // Gode Airport
    Airport{IataCode{"GDG"}, CountryId{"RU"}, Timezone{4665}}, // Magdagachi Airport
    Airport{IataCode{"GDI"}, CountryId{"CF"}, Timezone{104}}, // Gordil Airport
    Airport{IataCode{"GDJ"}, CountryId{"CD"}, Timezone{519}}, // Gandajika Airport
    Airport{IataCode{"GDL"}, CountryId{"MX"}, Timezone{2588}}, // Guadalajara International Airport
    Airport{IataCode{"GDM"}, CountryId{"US"}, Timezone{2712}}, // Gardner Municipal Airport
    Airport{IataCode{"GDN"}, CountryId{"PL"}, Timezone{5975}}, // Gdańsk Lech Wałęsa Airport
    Airport{IataCode{"GDO"}, CountryId{"VE"}, Timezone{1463}}, // Guasdualito Airport
    Airport{IataCode{"GDP"}, CountryId{"BR"}, Timezone{1789}}, // Guadalupe Airport
    Airport{IataCode{"GDQ"}, CountryId{"ET"}, Timezone{28}}, // Gondar Airport
    Airport{IataCode{"GDT"}, CountryId{"TC"}, Timezone{1859}}, // JAGS McCartney International Airport
    Airport{IataCode{"GDV"}, CountryId{"US"}, Timezone{1667}}, // Dawson Community Airport
    Airport{IataCode{"GDW"}, CountryId{"US"}, Timezone{1682}}, // Gladwin Zettel Memorial Airport
    Airport{IataCode{"GDX"}, CountryId{"RU"}, Timezone{4213}}, // Sokol Airport
    Airport{IataCode{"GDY"}, CountryId{"US"}, Timezone{2712}}, // Grundy Municipal Airport
    Airport{IataCode{"GDZ"}, CountryId{"RU"}, Timezone{5620}}, // Gelendzhik Airport
    Airport{IataCode{"GEA"}, CountryId{"FR"}, Timezone{6606}}, // Nouméa Magenta Airport
    Airport{IataCode{"GED"}, CountryId{"US"}, Timezone{2712}}, // Delaware Coastal Airport
    Airport{IataCode{"GEE"}, CountryId{"AU"}, Timezone{5011}}, // George Town Aerodrome
    Airport{IataCode{"GEL"}, CountryId{"BR"}, Timezone{3216}}, // Santo Ângelo Airport
    Airport{IataCode{"GEO"}, CountryId{"GY"}, Timezone{1949}}, // Cheddi Jagan International Airport
    Airport{IataCode{"GER"}, CountryId{"CU"}, Timezone{1980}}, // Rafael Cabrera Mustelier Airport
    Airport{IataCode{"GES"}, CountryId{"PH"}, Timezone{4240}}, // General Santos International Airport
    Airport{IataCode{"GET"}, CountryId{"AU"}, Timezone{5087}}, // Geraldton Airport
    Airport{IataCode{"GEU"}, CountryId{"US"}, Timezone{2931}}, // Glendale Municipal Airport
    Airport{IataCode{"GEV"}, CountryId{"SE"}, Timezone{5822}}, // Gällivare Airport
    Airport{IataCode{"GEX"}, CountryId{"AU"}, Timezone{5067}}, // Geelong Airport
    Airport{IataCode{"GEZ"}, CountryId{"US"}, Timezone{2043}}, // Shelbyville Municipal Airport
    Airport{IataCode{"GFD"}, CountryId{"US"}, Timezone{2043}}, // Pope Field
    Airport{IataCode{"GFF"}, CountryId{"AU"}, Timezone{5103}}, // Griffith Airport
    Airport{IataCode{"GFK"}, CountryId{"US"}, Timezone{1510}}, // Grand Forks International Airport
    Airport{IataCode{"GFL"}, CountryId{"US"}, Timezone{2712}}, // Floyd Bennett Memorial Airport
    Airport{IataCode{"GFN"}, CountryId{"AU"}, Timezone{5103}}, // Clarence Valley Regional Airport
    Airport{IataCode{"GFO"}, CountryId{"GY"}, Timezone{1949}}, // Bartica Airport
    Airport{IataCode{"GFR"}, CountryId{"FR"}, Timezone{5646}}, // Granville-Mont-Saint-Michel Airport
    Airport{IataCode{"GFY"}, CountryId{"NA"}, Timezone{785}}, // Grootfontein Airport
    Airport{IataCode{"GGC"}, CountryId{"AO"}, Timezone{505}}, // Lumbala Airport
    Airport{IataCode{"GGE"}, CountryId{"US"}, Timezone{2712}}, // Georgetown County Airport
    Airport{IataCode{"GGF"}, CountryId{"US"}, Timezone{1667}}, // Grant Municipal Airport
    Airport{IataCode{"GGG"}, CountryId{"US"}, Timezone{1510}}, // East Texas Regional Airport
    Airport{IataCode{"GGM"}, CountryId{"KE"}, Timezone{641}}, // Kakamega Airport
    Airport{IataCode{"GGN"}, CountryId{"CI"}, Timezone{0}}, // Gagnoa Airport
    Airport{IataCode{"GGO"}, CountryId{"CI"}, Timezone{0}}, // Guiglo Airport
    Airport{IataCode{"GGR"}, CountryId{"SO"}, Timezone{608}}, // Garowe International Airport
    Airport{IataCode{"GGS"}, CountryId{"AR"}, Timezone{1045}}, // Gobernador Gregores Airport
    Airport{IataCode{"GGT"}, CountryId{"BS"}, Timezone{2697}}, // Exuma International Airport
    Airport{IataCode{"GGW"}, CountryId{"US"}, Timezone{1667}}, // Glasgow Airport
    Airport{IataCode{"GHA"}, CountryId{"DZ"}, Timezone{47}}, // Noumérat – Moufdi Zakaria Airport
    Airport{IataCode{"GHB"}, CountryId{"BS"}, Timezone{2697}}, // Governor's Harbour Airport
    Airport{IataCode{"GHC"}, CountryId{"BS"}, Timezone{2697}}, // Great Harbour Cay Airport
    Airport{IataCode{"GHE"}, CountryId{"PA"}, Timezone{2877}}, // Garachiné Airport
    Airport{IataCode{"GHG"}, CountryId{"US"}, Timezone{2712}}, // Marshfield Municipal Airport
    Airport{IataCode{"GHK"}, CountryId{"CA"}, Timezone{3573}}, // Gahcho Kue Aerodrome
    Airport{IataCode{"GHM"}, CountryId{"US"}, Timezone{1510}}, // Centerville Municipal Airport
    Airport{IataCode{"GHN"}, CountryId{"CN"}, Timezone{4456}}, // Kwanghan Airfield
    Airport{IataCode{"GHT"}, CountryId{"LY"}, Timezone{47}}, // Ghat Airport
    Airport{IataCode{"GHU"}, CountryId{"AR"}, Timezone{942}}, // Gualeguaychú Airport
    Airport{IataCode{"GIB"}, CountryId{"GB"}, Timezone{5549}}, // Gibraltar International Airport
    Airport{IataCode{"GIC"}, CountryId{"AU"}, Timezone{6686}}, // Boigu Island Airport
    Airport{IataCode{"GID"}, CountryId{"BI"}, Timezone{167}}, // Gitega Airport
    Airport{IataCode{"GIF"}, CountryId{"US"}, Timezone{2712}}, // Winter Haven's Gilbert Airport
    Airport{IataCode{"GIG"}, CountryId{"BR"}, Timezone{3216}}, // Rio de Janeiro-Galeão International Airport
    Airport{IataCode{"GII"}, CountryId{"GN"}, Timezone{228}}, // Siguiri Airport
    Airport{IataCode{"GIL"}, CountryId{"PK"}, Timezone{4087}}, // Gilgit Airport
    Airport{IataCode{"GIR"}, CountryId{"CO"}, Timezone{1376}}, // Santiago Vila Airport
    Airport{IataCode{"GIS"}, CountryId{"NZ"}, Timezone{6218}}, // Gisborne Airport
    Airport{IataCode{"GIU"}, CountryId{"LK"}, Timezone{3854}}, // Sigiriya Airport
    Airport{IataCode{"GIZ"}, CountryId{"SA"}, Timezone{4404}}, // Jizan Regional Airport
    Airport{IataCode{"GJA"}, CountryId{"HN"}, Timezone{3401}}, // Guanaja Airport
    Airport{IataCode{"GJL"}, CountryId{"DZ"}, Timezone{47}}, // Jijel Ferhat Abbas Airport
    Airport{IataCode{"GJM"}, CountryId{"BR"}, Timezone{2350}}, // Guajará-Mirim Airport
    Airport{IataCode{"GJR"}, CountryId{"IS"}, Timezone{4823}}, // Gjögur Airport
    Airport{IataCode{"GJT"}, CountryId{"US"}, Timezone{1667}}, // Grand Junction Regional Airport
    Airport{IataCode{"GKA"}, CountryId{"PG"}, Timezone{6686}}, // Goroka Airport
    Airport{IataCode{"GKD"}, CountryId{"TR"}, Timezone{5169}}, // Gökçeada Airport
    Airport{IataCode{"GKK"}, CountryId{"MV"}, Timezone{6142}}, // Kooddoo Airport
    Airport{IataCode{"GKN"}, CountryId{"US"}, Timezone{814}}, // Gulkana Airport
    Airport{IataCode{"GKT"}, CountryId{"US"}, Timezone{2712}}, // Gatlinburg-Pigeon Forge Airport
    Airport{IataCode{"GKY"}, CountryId{"US"}, Timezone{1510}}, // Arlington Municipal Airport
    Airport{IataCode{"GLA"}, CountryId{"GB"}, Timezone{5517}}, // Glasgow Airport
    Airport{IataCode{"GLB"}, CountryId{"US"}, Timezone{2931}}, // San Carlos Apache Airport
    Airport{IataCode{"GLD"}, CountryId{"US"}, Timezone{1667}}, // Goodland Municipal Airport
    Airport{IataCode{"GLE"}, CountryId{"US"}, Timezone{1510}}, // Gainesville Municipal Airport
    Airport{IataCode{"GLF"}, CountryId{"CR"}, Timezone{1544}}, // Golfito Airport
    Airport{IataCode{"GLH"}, CountryId{"US"}, Timezone{1510}}, // Mid Delta Regional Airport
    Airport{IataCode{"GLI"}, CountryId{"AU"}, Timezone{5103}}, // Glen Innes Airport
    Airport{IataCode{"GLK"}, CountryId{"SO"}, Timezone{608}}, // Oshaco International Airport
    Airport{IataCode{"GLL"}, CountryId{"NO"}, Timezone{5634}}, // Gol Airport
    Airport{IataCode{"GLN"}, CountryId{"MA"}, Timezone{215}}, // Guelmim Airport
    Airport{IataCode{"GLO"}, CountryId{"GB"}, Timezone{5517}}, // Gloucestershire Airport
    Airport{IataCode{"GLR"}, CountryId{"US"}, Timezone{1682}}, // Gaylord Regional Airport
    Airport{IataCode{"GLS"}, CountryId{"US"}, Timezone{1510}}, // Scholes International Airport at Galveston
    Airport{IataCode{"GLT"}, CountryId{"AU"}, Timezone{4920}}, // Gladstone Airport
    Airport{IataCode{"GLU"}, CountryId{"BT"}, Timezone{4555}}, // Gelephu Airport
    Airport{IataCode{"GLV"}, CountryId{"US"}, Timezone{2745}}, // Golovin Airport
    Airport{IataCode{"GLW"}, CountryId{"US"}, Timezone{1510}}, // Glasgow Municipal Airport
    Airport{IataCode{"GLX"}, CountryId{"ID"}, Timezone{4032}}, // Garmalamo Airport
    Airport{IataCode{"GMA"}, CountryId{"CD"}, Timezone{446}}, // Gemena Airport
    Airport{IataCode{"GMB"}, CountryId{"ET"}, Timezone{28}}, // Gambela Airport
    Airport{IataCode{"GMD"}, CountryId{"MA"}, Timezone{215}}, // Ben Slimane Airport
    Airport{IataCode{"GME"}, CountryId{"BY"}, Timezone{5593}}, // Gomel Airport
    Airport{IataCode{"GMI"}, CountryId{"PG"}, Timezone{6686}}, // Gasmata Airport
    Airport{IataCode{"GMJ"}, CountryId{"US"}, Timezone{1510}}, // Grove Municipal Airport
    Airport{IataCode{"GML"}, CountryId{"UA"}, Timezone{5461}}, // Gostomel Airport
    Airport{IataCode{"GMM"}, CountryId{"CG"}, Timezone{148}}, // Gamboma Airport
    Airport{IataCode{"GMN"}, CountryId{"NZ"}, Timezone{}}, // Greymouth Airport
    Airport{IataCode{"GMO"}, CountryId{"NG"}, Timezone{462}}, // Gombe Lawanti International Airport
    Airport{IataCode{"GMP"}, CountryId{"KR"}, Timezone{4445}}, // Gimpo International Airport
    Airport{IataCode{"GMQ"}, CountryId{"CN"}, Timezone{4456}}, // Golog Airport
    Airport{IataCode{"GMR"}, CountryId{"FR"}, Timezone{6397}}, // Totegegie Airport
    Airport{IataCode{"GMU"}, CountryId{"US"}, Timezone{2712}}, // Greenville Downtown Airport
    Airport{IataCode{"GMZ"}, CountryId{"ES"}, Timezone{4755}}, // La Gomera Airport
    Airport{IataCode{"GNA"}, CountryId{"BY"}, Timezone{5593}}, // Hrodna Airport
    Airport{IataCode{"GNB"}, CountryId{"FR"}, Timezone{5646}}, // Grenoble-Isère Airport
    Airport{IataCode{"GND"}, CountryId{"GD"}, Timezone{1878}}, // Maurice Bishop International Airport
    Airport{IataCode{"GNF"}, CountryId{"US"}, Timezone{2378}}, // Gansner Field
    Airport{IataCode{"GNI"}, CountryId{"TW"}, Timezone{4504}}, // Lyudao Airport
    Airport{IataCode{"GNK"}, CountryId{"BE"}, Timezone{5231}}, // Zwartberg Airport
    Airport{IataCode{"GNM"}, CountryId{"BR"}, Timezone{1254}}, // Guanambi Airport
    Airport{IataCode{"GNN"}, CountryId{"ET"}, Timezone{28}}, // Ghinnir Airport
    Airport{IataCode{"GNR"}, CountryId{"AR"}, Timezone{1076}}, // Dr. Arturo Umberto Illia Airport
    Airport{IataCode{"GNS"}, CountryId{"ID"}, Timezone{4032}}, // Binaka Airport
    Airport{IataCode{"GNT"}, CountryId{"US"}, Timezone{1667}}, // Grants-Milan Municipal Airport
    Airport{IataCode{"GNU"}, CountryId{"US"}, Timezone{814}}, // Goodnews Airport
    Airport{IataCode{"GNV"}, CountryId{"US"}, Timezone{2712}}, // Gainesville Regional Airport
    Airport{IataCode{"GNY"}, CountryId{"TR"}, Timezone{5412}}, // Şanlıurfa GAP Airport
    Airport{IataCode{"GNZ"}, CountryId{"BW"}, Timezone{339}}, // Ghanzi Airport
    Airport{IataCode{"GOA"}, CountryId{"IT"}, Timezone{5702}}, // Genoa Cristoforo Colombo Airport
    Airport{IataCode{"GOB"}, CountryId{"ET"}, Timezone{28}}, // Robe Airport
    Airport{IataCode{"GOG"}, CountryId{"NA"}, Timezone{785}}, // Gobabis Airport
    Airport{IataCode{"GOH"}, CountryId{"GL"}, Timezone{1825}}, // Nuuk Airport
    Airport{IataCode{"GOI"}, CountryId{"IN"}, Timezone{4129}}, // Dabolim Airport
    Airport{IataCode{"GOJ"}, CountryId{"RU"}, Timezone{5620}}, // Nizhny Novgorod International Airport
    Airport{IataCode{"GOK"}, CountryId{"US"}, Timezone{1510}}, // Guthrie–Edmond Regional Airport
    Airport{IataCode{"GOL"}, CountryId{"US"}, Timezone{2378}}, // Gold Beach Municipal Airport
    Airport{IataCode{"GOM"}, CountryId{"CD"}, Timezone{519}}, // Goma International Airport
    Airport{IataCode{"GOO"}, CountryId{"AU"}, Timezone{4920}}, // Goondiwindi Airport
    Airport{IataCode{"GOP"}, CountryId{"IN"}, Timezone{4129}}, // Gorakhpur Airport
    Airport{IataCode{"GOQ"}, CountryId{"CN"}, Timezone{4456}}, // Golmud Airport
    Airport{IataCode{"GOR"}, CountryId{"ET"}, Timezone{28}}, // Gore Airport
    Airport{IataCode{"GOT"}, CountryId{"SE"}, Timezone{5822}}, // Gothenburg-Landvetter Airport
    Airport{IataCode{"GOU"}, CountryId{"CM"}, Timezone{293}}, // Garoua International Airport
    Airport{IataCode{"GOV"}, CountryId{"AU"}, Timezone{4978}}, // Gove Airport
    Airport{IataCode{"GOZ"}, CountryId{"BG"}, Timezone{5809}}, // Gorna Oryahovitsa Airport
    Airport{IataCode{"GPA"}, CountryId{"GR"}, Timezone{5169}}, // Araxos Airport
    Airport{IataCode{"GPB"}, CountryId{"BR"}, Timezone{3216}}, // Guarapuava Airport
    Airport{IataCode{"GPD"}, CountryId{"AU"}, Timezone{4920}}, // Mount Gordon Airport
    Airport{IataCode{"GPH"}, CountryId{"US"}, Timezone{1510}}, // Midwest National Air Center
    Airport{IataCode{"GPI"}, CountryId{"CO"}, Timezone{1376}}, // Guapi Airport
    Airport{IataCode{"GPL"}, CountryId{"CR"}, Timezone{1544}}, // Guápiles Airport
    Airport{IataCode{"GPM"}, CountryId{"US"}, Timezone{1510}}, // Grand Prairie Municipal Airport
    Airport{IataCode{"GPN"}, CountryId{"AU"}, Timezone{4978}}, // Garden Point Airport
    Airport{IataCode{"GPO"}, CountryId{"AR"}, Timezone{1076}}, // General Pico Airport
    Airport{IataCode{"GPS"}, CountryId{"EC"}, Timezone{6379}}, // Seymour Airport
    Airport{IataCode{"GPT"}, CountryId{"US"}, Timezone{1510}}, // Gulfport-Biloxi International Airport
    Airport{IataCode{"GPZ"}, CountryId{"US"}, Timezone{1510}}, // Grand Rapids – Itasca County Airport
    Airport{IataCode{"GQQ"}, CountryId{"US"}, Timezone{2712}}, // Galion Municipal Airport
    Airport{IataCode{"GRB"}, CountryId{"US"}, Timezone{1510}}, // Green Bay–Austin Straubel International Airport
    Airport{IataCode{"GRD"}, CountryId{"US"}, Timezone{2712}}, // Greenwood County Airport
    Airport{IataCode{"GRE"}, CountryId{"US"}, Timezone{1510}}, // Greenville Airport
    Airport{IataCode{"GRG"}, CountryId{"AF"}, Timezone{4061}}, // Gardez Airport
    Airport{IataCode{"GRI"}, CountryId{"US"}, Timezone{1510}}, // Central Nebraska Regional Airport
    Airport{IataCode{"GRJ"}, CountryId{"ZA"}, Timezone{369}}, // George Airport
    Airport{IataCode{"GRK"}, CountryId{"US"}, Timezone{1510}}, // Killeen–Fort Hood Regional Airport
    Airport{IataCode{"GRM"}, CountryId{"US"}, Timezone{1510}}, // Grand Marais/Cook County Airport
    Airport{IataCode{"GRO"}, CountryId{"ES"}, Timezone{5549}}, // Girona-Costa Brava Airport
    Airport{IataCode{"GRP"}, CountryId{"BR"}, Timezone{865}}, // Gurupi Airport
    Airport{IataCode{"GRQ"}, CountryId{"NL"}, Timezone{5120}}, // Groningen Airport Eelde
    Airport{IataCode{"GRR"}, CountryId{"US"}, Timezone{1682}}, // Gerald R. Ford International Airport
    Airport{IataCode{"GRS"}, CountryId{"IT"}, Timezone{5702}}, // Grosseto Airport
    Airport{IataCode{"GRU"}, CountryId{"BR"}, Timezone{3216}}, // São Paulo-Guarulhos International Airport
    Airport{IataCode{"GRV"}, CountryId{"RU"}, Timezone{5620}}, // Grozny Airport
    Airport{IataCode{"GRW"}, CountryId{"PT"}, Timezone{4722}}, // Graciosa Airport
    Airport{IataCode{"GRX"}, CountryId{"ES"}, Timezone{5549}}, // Federico García Lorca Airport
    Airport{IataCode{"GRY"}, CountryId{"IS"}, Timezone{4823}}, // Grímsey Airport
    Airport{IataCode{"GRZ"}, CountryId{"AT"}, Timezone{5929}}, // Graz Airport
    Airport{IataCode{"GSA"}, CountryId{"MY"}, Timezone{4190}}, // Long Pasia Airport
    Airport{IataCode{"GSE"}, CountryId{"SE"}, Timezone{5822}}, // Gothenburg City Airport
    Airport{IataCode{"GSH"}, CountryId{"US"}, Timezone{2043}}, // Goshen Municipal Airport
    Airport{IataCode{"GSI"}, CountryId{"FR"}, Timezone{2912}}, // Grand-Santi Airport
    Airport{IataCode{"GSJ"}, CountryId{"GT"}, Timezone{1913}}, // San José Airport
    Airport{IataCode{"GSL"}, CountryId{"CA"}, Timezone{3573}}, // Taltheilei Narrows Airport
    Airport{IataCode{"GSM"}, CountryId{"IR"}, Timezone{4543}}, // Dayrestan Airport
    Airport{IataCode{"GSO"}, CountryId{"US"}, Timezone{2712}}, // Piedmont Triad International Airport
    Airport{IataCode{"GSP"}, CountryId{"US"}, Timezone{2712}}, // Greenville-Spartanburg International Airport
    Airport{IataCode{"GSQ"}, CountryId{"EG"}, Timezone{184}}, // Sharq Al-Owainat Airport
    Airport{IataCode{"GSR"}, CountryId{"SO"}, Timezone{608}}, // Gardo Airport
    Airport{IataCode{"GST"}, CountryId{"US"}, Timezone{2260}}, // Gustavus Airport
    Airport{IataCode{"GSU"}, CountryId{"SD"}, Timezone{432}}, // Gedaref Airport
    Airport{IataCode{"GSW"}, CountryId{"US"}, Timezone{1510}}, // Greater Southwest International Airport
    Airport{IataCode{"GTA"}, CountryId{"SB"}, Timezone{6413}}, // Gatokae Aerodrome
    Airport{IataCode{"GTB"}, CountryId{"MY"}, Timezone{4190}}, // Genting Airport
    Airport{IataCode{"GTE"}, CountryId{"AU"}, Timezone{4978}}, // Groote Eylandt Airport
    Airport{IataCode{"GTF"}, CountryId{"US"}, Timezone{1667}}, // Great Falls International Airport
    Airport{IataCode{"GTG"}, CountryId{"US"}, Timezone{1510}}, // Grantsburg Municipal Airport
    Airport{IataCode{"GTN"}, CountryId{"NZ"}, Timezone{6218}}, // Mount Cook Aerodrome
    Airport{IataCode{"GTO"}, CountryId{"ID"}, Timezone{4226}}, // Jalaluddin Airport
    Airport{IataCode{"GTP"}, CountryId{"US"}, Timezone{2378}}, // Grants Pass Airport
    Airport{IataCode{"GTR"}, CountryId{"US"}, Timezone{1510}}, // Golden Triangle Regional Airport
    Airport{IataCode{"GTS"}, CountryId{"AU"}, Timezone{4978}}, // The Granites Airport
    Airport{IataCode{"GTT"}, CountryId{"AU"}, Timezone{4920}}, // Georgetown Airport
    Airport{IataCode{"GTU"}, CountryId{"US"}, Timezone{1510}}, // Georgetown Municipal Airport
    Airport{IataCode{"GTW"}, CountryId{"CZ"}, Timezone{5676}}, // Holesov
    Airport{IataCode{"GTY"}, CountryId{"US"}, Timezone{2712}}, // Gettysburg Regional Airport
    Airport{IataCode{"GUA"}, CountryId{"GT"}, Timezone{1913}}, // La Aurora International Airport
    Airport{IataCode{"GUB"}, CountryId{"MX"}, Timezone{3455}}, // Guerrero Negro Airport
    Airport{IataCode{"GUC"}, CountryId{"US"}, Timezone{1667}}, // Gunnison–Crested Butte Regional Airport
    Airport{IataCode{"GUD"}, CountryId{"ML"}, Timezone{76}}, // Goundam Airport
    Airport{IataCode{"GUF"}, CountryId{"US"}, Timezone{1510}}, // Jack Edwards Airport
    Airport{IataCode{"GUH"}, CountryId{"AU"}, Timezone{5103}}, // Gunnedah Airport
    Airport{IataCode{"GUI"}, CountryId{"VE"}, Timezone{1463}}, // Güiria Airport
    Airport{IataCode{"GUJ"}, CountryId{"BR"}, Timezone{3216}}, // Guaratinguetá Airport
    Airport{IataCode{"GUL"}, CountryId{"AU"}, Timezone{5103}}, // Goulburn Airport
    Airport{IataCode{"GUM"}, CountryId{"US"}, Timezone{6433}}, // Antonio B. Won Pat International Airport
    Airport{IataCode{"GUO"}, CountryId{"HN"}, Timezone{3401}}, // Gualaco Airport
    Airport{IataCode{"GUP"}, CountryId{"US"}, Timezone{1667}}, // Gallup Municipal Airport
    Airport{IataCode{"GUQ"}, CountryId{"VE"}, Timezone{1463}}, // Guanare Airport
    Airport{IataCode{"GUR"}, CountryId{"PG"}, Timezone{6686}}, // Gurney Airport
    Airport{IataCode{"GUS"}, CountryId{"US"}, Timezone{2043}}, // Grissom Aeroplex
    Airport{IataCode{"GUU"}, CountryId{"IS"}, Timezone{4823}}, // Grundarfjörður Airport
    Airport{IataCode{"GUW"}, CountryId{"KZ"}, Timezone{3716}}, // Atyrau Airport
    Airport{IataCode{"GUY"}, CountryId{"US"}, Timezone{1510}}, // Guymon Municipal Airport
    Airport{IataCode{"GUZ"}, CountryId{"BR"}, Timezone{3216}}, // Guarapari Airport
    Airport{IataCode{"GVA"}, CountryId{"CH"}, Timezone{5646}}, // Geneva International Airport
    Airport{IataCode{"GVL"}, CountryId{"US"}, Timezone{2712}}, // Lee Gilmer Memorial Airport
    Airport{IataCode{"GVQ"}, CountryId{"US"}, Timezone{2712}}, // Genesee County Airport
    Airport{IataCode{"GVR"}, CountryId{"BR"}, Timezone{3216}}, // Governador Valadares Airport
    Airport{IataCode{"GVT"}, CountryId{"US"}, Timezone{1510}}, // Majors Airport
    Airport{IataCode{"GVW"}, CountryId{"US"}, Timezone{}}, // Richards-Gebaur Memorial Airport
    Airport{IataCode{"GVX"}, CountryId{"SE"}, Timezone{5822}}, // Gävle-Sandviken Airport
    Airport{IataCode{"GWD"}, CountryId{"PK"}, Timezone{4087}}, // Gwadar International Airport
    Airport{IataCode{"GWL"}, CountryId{"IN"}, Timezone{4129}}, // Gwalior Airport
    Airport{IataCode{"GWO"}, CountryId{"US"}, Timezone{1510}}, // Greenwood-Leflore Airport
    Airport{IataCode{"GWT"}, CountryId{"DE"}, Timezone{5199}}, // Sylt Airport
    Airport{IataCode{"GWW"}, CountryId{"US"}, Timezone{2712}}, // Wayne Executive Jetport
    Airport{IataCode{"GWY"}, CountryId{"IE"}, Timezone{5330}}, // Galway Airport
    Airport{IataCode{"GXF"}, CountryId{"YE"}, Timezone{3634}}, // Sayun Airport
    Airport{IataCode{"GXG"}, CountryId{"AO"}, Timezone{505}}, // Negage Airport
    Airport{IataCode{"GXH"}, CountryId{"CN"}, Timezone{4456}}, // Gannan Xiahe Airport
    Airport{IataCode{"GXQ"}, CountryId{"CL"}, Timezone{3177}}, // Teniente Vidal Airport
    Airport{IataCode{"GXX"}, CountryId{"CM"}, Timezone{293}}, // Yagoua Airport
    Airport{IataCode{"GXY"}, CountryId{"US"}, Timezone{1667}}, // Greeley–Weld County Airport
    Airport{IataCode{"GYA"}, CountryId{"BO"}, Timezone{2350}}, // Guayaramerín Airport
    Airport{IataCode{"GYB"}, CountryId{"US"}, Timezone{1510}}, // Giddings-Lee County Airport
    Airport{IataCode{"GYD"}, CountryId{"AZ"}, Timezone{3754}}, // Heydar Aliyev International Airport
    Airport{IataCode{"GYE"}, CountryId{"EC"}, Timezone{1949}}, // José Joaquín de Olmedo International Airport
    Airport{IataCode{"GYG"}, CountryId{"RU"}, Timezone{4665}}, // Magan Airport
    Airport{IataCode{"GYI"}, CountryId{"RW"}, Timezone{519}}, // Gisenyi Airport
    Airport{IataCode{"GYL"}, CountryId{"AU"}, Timezone{5087}}, // Argyle Airport
    Airport{IataCode{"GYM"}, CountryId{"MX"}, Timezone{1995}}, // General José María Yáñez International Airport
    Airport{IataCode{"GYN"}, CountryId{"BR"}, Timezone{3216}}, // Santa Genoveva Airport
    Airport{IataCode{"GYP"}, CountryId{"AU"}, Timezone{4920}}, // Gympie Airport
    Airport{IataCode{"GYR"}, CountryId{"US"}, Timezone{2931}}, // Phoenix Goodyear Airport
    Airport{IataCode{"GYS"}, CountryId{"CN"}, Timezone{4456}}, // Guangyuan Panlong Airport
    Airport{IataCode{"GYU"}, CountryId{"CN"}, Timezone{4456}}, // Guyuan Liupanshan Airport
    Airport{IataCode{"GYY"}, CountryId{"US"}, Timezone{1510}}, // Gary/Chicago International Airport
    Airport{IataCode{"GZA"}, CountryId{"PS"}, Timezone{184}}, // Yasser Arafat International Airport
    Airport{IataCode{"GZH"}, CountryId{"US"}, Timezone{1510}}, // Middleton Field
    Airport{IataCode{"GZI"}, CountryId{"AF"}, Timezone{4061}}, // Ghazni Airport
    Airport{IataCode{"GZL"}, CountryId{"US"}, Timezone{1510}}, // Stigler Regional Airport
    Airport{IataCode{"GZO"}, CountryId{"SB"}, Timezone{6413}}, // Nusatupe Airport
    Airport{IataCode{"GZP"}, CountryId{"TR"}, Timezone{}}, // Antalya Gazipasa-Alanya Airport
    Airport{IataCode{"GZS"}, CountryId{"US"}, Timezone{1510}}, // Abernathy Field
    Airport{IataCode{"GZT"}, CountryId{"TR"}, Timezone{5412}}, // Oğuzeli Airport
    Airport{IataCode{"GZW"}, CountryId{"IR"}, Timezone{4543}}, // Qazvin Airport
    Airport{IataCode{"HAA"}, CountryId{"NO"}, Timezone{5634}}, // Hasvik Airport
    Airport{IataCode{"HAB"}, CountryId{"US"}, Timezone{1510}}, // Marion County – Rankin Fite Airport
    Airport{IataCode{"HAC"}, CountryId{"JP"}, Timezone{4568}}, // Hachijojima Airport
    Airport{IataCode{"HAD"}, CountryId{"SE"}, Timezone{5822}}, // Halmstad Airport
    Airport{IataCode{"HAE"}, CountryId{"KP"}, Timezone{4363}}, // Haeju Airport
    Airport{IataCode{"HAF"}, CountryId{"US"}, Timezone{2378}}, // Half Moon Bay Airport
    Airport{IataCode{"HAH"}, CountryId{"KM"}, Timezone{6099}}, // Prince Said Ibrahim International Airport
    Airport{IataCode{"HAJ"}, CountryId{"DE"}, Timezone{5199}}, // Hannover Airport
    Airport{IataCode{"HAK"}, CountryId{"CN"}, Timezone{4456}}, // Haikou Meilan International Airport
    Airport{IataCode{"HAL"}, CountryId{"NA"}, Timezone{785}}, // Halali Airport
    Airport{IataCode{"HAM"}, CountryId{"DE"}, Timezone{5199}}, // Hamburg Airport
    Airport{IataCode{"HAN"}, CountryId{"VN"}, Timezone{3964}}, // Noi Bai International Airport
    Airport{IataCode{"HAO"}, CountryId{"US"}, Timezone{2712}}, // Butler County Regional Airport
    Airport{IataCode{"HAQ"}, CountryId{"MV"}, Timezone{6142}}, // Hanimaadhoo Airport
    Airport{IataCode{"HAR"}, CountryId{"US"}, Timezone{2712}}, // Capital City Airport
    Airport{IataCode{"HAS"}, CountryId{"SA"}, Timezone{4404}}, // Ha'il Regional Airport
    Airport{IataCode{"HAU"}, CountryId{"NO"}, Timezone{5634}}, // Haugesund Airport, Karmøy
    Airport{IataCode{"HAV"}, CountryId{"CU"}, Timezone{1980}}, // José Martí International Airport
    Airport{IataCode{"HAW"}, CountryId{"GB"}, Timezone{5517}}, // Haverfordwest Aerodrome
    Airport{IataCode{"HAX"}, CountryId{"US"}, Timezone{1510}}, // Hatbox Field
    Airport{IataCode{"HAY"}, CountryId{"US"}, Timezone{814}}, // Haycock Airport
    Airport{IataCode{"HBA"}, CountryId{"AU"}, Timezone{5011}}, // Hobart International Airport
    Airport{IataCode{"HBE"}, CountryId{"EG"}, Timezone{184}}, // Borg El Arab Airport
    Airport{IataCode{"HBG"}, CountryId{"US"}, Timezone{1510}}, // Hattiesburg Bobby L. Chain Municipal Airport
    Airport{IataCode{"HBI"}, CountryId{"US"}, Timezone{2712}}, // Asheboro Regional Airport
    Airport{IataCode{"HBK"}, CountryId{"US"}, Timezone{2931}}, // Holbrook Municipal Airport
    Airport{IataCode{"HBR"}, CountryId{"US"}, Timezone{1510}}, // Hobart Regional Airport
    Airport{IataCode{"HBU"}, CountryId{"MN"}, Timezone{3996}}, // Bulgan Airport
    Airport{IataCode{"HBX"}, CountryId{"IN"}, Timezone{4129}}, // Hubli Airport
    Airport{IataCode{"HCA"}, CountryId{"US"}, Timezone{1510}}, // Big Spring McMahon-Wrinkle Airport
    Airport{IataCode{"HCC"}, CountryId{"US"}, Timezone{2712}}, // Columbia County Airport
    Airport{IataCode{"HCD"}, CountryId{"US"}, Timezone{1510}}, // Hutchinson Municipal Airport
    Airport{IataCode{"HCJ"}, CountryId{"CN"}, Timezone{4456}}, // Hechi Jinchengjiang Airport
    Airport{IataCode{"HCM"}, CountryId{"SO"}, Timezone{608}}, // Eyl Airport
    Airport{IataCode{"HCN"}, CountryId{"TW"}, Timezone{4504}}, // Hengchun Airport
    Airport{IataCode{"HCQ"}, CountryId{"AU"}, Timezone{5087}}, // Halls Creek Airport
    Airport{IataCode{"HCR"}, CountryId{"US"}, Timezone{814}}, // Holy Cross Airport
    Airport{IataCode{"HCW"}, CountryId{"US"}, Timezone{2712}}, // Cheraw Municipal Airport
    Airport{IataCode{"HDA"}, CountryId{"IL"}, Timezone{4046}}, // Ein Shemer Airfield
    Airport{IataCode{"HDC"}, CountryId{"US"}, Timezone{1510}}, // Hammond Northshore Regional Airport
    Airport{IataCode{"HDD"}, CountryId{"PK"}, Timezone{4087}}, // Hyderabad Airport
    Airport{IataCode{"HDF"}, CountryId{"DE"}, Timezone{5199}}, // Heringsdorf Airport
    Airport{IataCode{"HDG"}, CountryId{"CN"}, Timezone{4456}}, // Handan Airport
    Airport{IataCode{"HDI"}, CountryId{"US"}, Timezone{2712}}, // Hardwick Field
    Airport{IataCode{"HDM"}, CountryId{"IR"}, Timezone{4543}}, // Hamadan Airport
    Airport{IataCode{"HDN"}, CountryId{"US"}, Timezone{1667}}, // Yampa Valley Airport
    Airport{IataCode{"HDO"}, CountryId{"US"}, Timezone{1510}}, // South Texas Regional Airport at Hondo
    Airport{IataCode{"HDY"}, CountryId{"TH"}, Timezone{3777}}, // Hat Yai International Airport
    Airport{IataCode{"HEA"}, CountryId{"AF"}, Timezone{4061}}, // Herat International Airport
    Airport{IataCode{"HEE"}, CountryId{"US"}, Timezone{1510}}, // Thompson-Robbins Airport
    Airport{IataCode{"HEG"}, CountryId{"US"}, Timezone{2712}}, // Herlong Recreational Airport
    Airport{IataCode{"HEH"}, CountryId{"MM"}, Timezone{4678}}, // Heho Airport
    Airport{IataCode{"HEI"}, CountryId{"US"}, Timezone{1667}}, // Hettinger Municipal Airport
    Airport{IataCode{"HEK"}, CountryId{"CN"}, Timezone{4456}}, // Heihe Aihui Airport
    Airport{IataCode{"HEL"}, CountryId{"FI"}, Timezone{5377}}, // Helsinki Airport
    Airport{IataCode{"HEN"}, CountryId{"FI"}, Timezone{5377}}, // Hernesaari Heliport
    Airport{IataCode{"HEO"}, CountryId{"PG"}, Timezone{6686}}, // Haelogo Airport
    Airport{IataCode{"HER"}, CountryId{"GR"}, Timezone{5169}}, // Heraklion International Airport
    Airport{IataCode{"HES"}, CountryId{"US"}, Timezone{2378}}, // Hermiston Municipal Airport
    Airport{IataCode{"HET"}, CountryId{"CN"}, Timezone{4456}}, // Hohhot Baita International Airport
    Airport{IataCode{"HEW"}, CountryId{"GR"}, Timezone{5169}}, // Hellinikon Airport
    Airport{IataCode{"HEX"}, CountryId{"DO"}, Timezone{3194}}, // Herrera International Airport
    Airport{IataCode{"HEZ"}, CountryId{"US"}, Timezone{1510}}, // Natchez-Adams County Airport
    Airport{IataCode{"HFA"}, CountryId{}, Timezone{4046}}, // Haifa International Airport
    Airport{IataCode{"HFD"}, CountryId{"US"}, Timezone{2712}}, // Hartford-Brainard Airport
    Airport{IataCode{"HFE"}, CountryId{"CN"}, Timezone{4456}}, // Hefei Xinqiao International Airport
    Airport{IataCode{"HFF"}, CountryId{"US"}, Timezone{2712}}, // Camp Mackall
    Airport{IataCode{"HFN"}, CountryId{"IS"}, Timezone{4823}}, // Hornafjörður Airport
    Airport{IataCode{"HFS"}, CountryId{"SE"}, Timezone{5822}}, // Hagfors Airport
    Airport{IataCode{"HFT"}, CountryId{"NO"}, Timezone{5634}}, // Hammerfest Airport
    Airport{IataCode{"HGA"}, CountryId{"SO"}, Timezone{608}}, // Hargeisa International Airport
    Airport{IataCode{"HGD"}, CountryId{"AU"}, Timezone{4920}}, // Hughenden Airport
    Airport{IataCode{"HGE"}, CountryId{"VE"}, Timezone{1463}}, // Higuerote Airport
    Airport{IataCode{"HGH"}, CountryId{"CN"}, Timezone{4456}}, // Hangzhou Xiaoshan International Airport
    Airport{IataCode{"HGI"}, CountryId{"SS"}, Timezone{389}}, // Paloich Airport
    Airport{IataCode{"HGL"}, CountryId{"DE"}, Timezone{5199}}, // Heligoland Airport
    Airport{IataCode{"HGN"}, CountryId{"TH"}, Timezone{4678}}, // Mae Hong Son Airport
    Airport{IataCode{"HGO"}, CountryId{"CI"}, Timezone{0}}, // Korhogo Airport
    Airport{IataCode{"HGR"}, CountryId{"US"}, Timezone{2712}}, // Hagerstown Regional Airport
    Airport{IataCode{"HGS"}, CountryId{"SL"}, Timezone{323}}, // Hastings Airport
    Airport{IataCode{"HGU"}, CountryId{"PG"}, Timezone{6686}}, // Mount Hagen Airport
    Airport{IataCode{"HHH"}, CountryId{"US"}, Timezone{2712}}, // Hilton Head Airport
    Airport{IataCode{"HHN"}, CountryId{"DE"}, Timezone{5199}}, // Frankfurt-Hahn Airport
    Airport{IataCode{"HHQ"}, CountryId{"TH"}, Timezone{3777}}, // Hua Hin Airport
    Airport{IataCode{"HHR"}, CountryId{"US"}, Timezone{2378}}, // Hawthorne Municipal Airport
    Airport{IataCode{"HHZ"}, CountryId{"FR"}, Timezone{6740}}, // Hikueru Airport
    Airport{IataCode{"HIA"}, CountryId{"CN"}, Timezone{4456}}, // Huai'an Lianshui Airport
    Airport{IataCode{"HIB"}, CountryId{"US"}, Timezone{1510}}, // Range Regional Airport
    Airport{IataCode{"HID"}, CountryId{"AU"}, Timezone{4920}}, // Horn Island Airport
    Airport{IataCode{"HIE"}, CountryId{"US"}, Timezone{2712}}, // Mount Washington Regional Airport
    Airport{IataCode{"HII"}, CountryId{"US"}, Timezone{2931}}, // Lake Havasu City Airport
    Airport{IataCode{"HIJ"}, CountryId{"JP"}, Timezone{4568}}, // Hiroshima Airport
    Airport{IataCode{"HIL"}, CountryId{"ET"}, Timezone{28}}, // Shilavo Airport
    Airport{IataCode{"HIM"}, CountryId{"LK"}, Timezone{3854}}, // SLAF Hingurakgoda
    Airport{IataCode{"HIN"}, CountryId{"KR"}, Timezone{4445}}, // Sacheon Airport
    Airport{IataCode{"HIO"}, CountryId{"US"}, Timezone{2378}}, // Hillsboro Airport
    Airport{IataCode{"HIR"}, CountryId{"SB"}, Timezone{6413}}, // Honiara International Airport
    Airport{IataCode{"HIW"}, CountryId{"JP"}, Timezone{4568}}, // Hiroshima-Nishi Airport
    Airport{IataCode{"HJJ"}, CountryId{"CN"}, Timezone{4456}}, // Huaihua Zhijiang Airport
    Airport{IataCode{"HJO"}, CountryId{"US"}, Timezone{2378}}, // Hanford Municipal Airport
    Airport{IataCode{"HJR"}, CountryId{"IN"}, Timezone{4129}}, // Khajuraho Airport
    Airport{IataCode{"HJT"}, CountryId{"MN"}, Timezone{4590}}, // Khujirt Airport
    Airport{IataCode{"HKA"}, CountryId{"US"}, Timezone{1510}}, // Blytheville Municipal Airport
    Airport{IataCode{"HKB"}, CountryId{"US"}, Timezone{814}}, // Healy Lake Airport
    Airport{IataCode{"HKD"}, CountryId{"JP"}, Timezone{4568}}, // Hakodate Airport
    Airport{IataCode{"HKG"}, CountryId{"CN"}, Timezone{4456}}, // Hong Kong International Airport
    Airport{IataCode{"HKK"}, CountryId{"NZ"}, Timezone{}}, // Hokitika Airport
    Airport{IataCode{"HKN"}, CountryId{"PG"}, Timezone{6686}}, // Hoskins Airport
    Airport{IataCode{"HKO"}, CountryId{"KE"}, Timezone{}}, // Rhamu Airport
    Airport{IataCode{"HKP"}, CountryId{"US"}, Timezone{6446}}, // Kaanapali Airport
    Airport{IataCode{"HKS"}, CountryId{"US"}, Timezone{1510}}, // Hawkins Field
    Airport{IataCode{"HKT"}, CountryId{"TH"}, Timezone{}}, // Phuket International Airport
    Airport{IataCode{"HKY"}, CountryId{"US"}, Timezone{2712}}, // Hickory Regional Airport
    Airport{IataCode{"HLA"}, CountryId{"ZA"}, Timezone{369}}, // Lanseria International Airport
    Airport{IataCode{"HLC"}, CountryId{"US"}, Timezone{1510}}, // Hill City Municipal Airport
    Airport{IataCode{"HLD"}, CountryId{"CN"}, Timezone{4456}}, // Hulunbuir Hailar Airport
    Airport{IataCode{"HLE"}, CountryId{"GB"}, Timezone{4865}}, // Saint Helena Airport
    Airport{IataCode{"HLF"}, CountryId{"SE"}, Timezone{5822}}, // Hultsfred Airport
    Airport{IataCode{"HLG"}, CountryId{"US"}, Timezone{2712}}, // Wheeling Ohio County Airport
    Airport{IataCode{"HLH"}, CountryId{"CN"}, Timezone{4456}}, // Ulanhot Airport
    Airport{IataCode{"HLI"}, CountryId{"US"}, Timezone{2378}}, // Hollister Municipal Airport
    Airport{IataCode{"HLJ"}, CountryId{"LT"}, Timezone{5943}}, // Barysiai Airport
    Airport{IataCode{"HLM"}, CountryId{"US"}, Timezone{1682}}, // Park Township Airport
    Airport{IataCode{"HLN"}, CountryId{"US"}, Timezone{1667}}, // Helena Regional Airport
    Airport{IataCode{"HLP"}, CountryId{"ID"}, Timezone{4032}}, // Halim Perdanakusuma Airport
    Airport{IataCode{"HLS"}, CountryId{"AU"}, Timezone{5011}}, // St Helens Airport
    Airport{IataCode{"HLT"}, CountryId{"AU"}, Timezone{5067}}, // Hamilton Airport
    Airport{IataCode{"HLW"}, CountryId{"ZA"}, Timezone{369}}, // Hluhluwe Airport
    Airport{IataCode{"HLZ"}, CountryId{"NZ"}, Timezone{6218}}, // Hamilton International Airport
    Airport{IataCode{"HMA"}, CountryId{"RU"}, Timezone{4690}}, // Khanty-Mansiysk Airport
    Airport{IataCode{"HMB"}, CountryId{"EG"}, Timezone{184}}, // Sohag International Airport
    Airport{IataCode{"HME"}, CountryId{"DZ"}, Timezone{47}}, // Oued Irara–Krim Belkacem Airport
    Airport{IataCode{"HMI"}, CountryId{"CN"}, Timezone{4607}}, // Hami Airport
    Airport{IataCode{"HMJ"}, CountryId{"UA"}, Timezone{5461}}, // Khmelnytskyi Airport
    Airport{IataCode{"HMO"}, CountryId{"MX"}, Timezone{1995}}, // General Ignacio Pesqueira García International Airport
    Airport{IataCode{"HMR"}, CountryId{"NO"}, Timezone{5634}}, // Hamar Airport
    Airport{IataCode{"HMT"}, CountryId{"US"}, Timezone{2378}}, // Hemet-Ryan Airport
    Airport{IataCode{"HNA"}, CountryId{"JP"}, Timezone{4568}}, // Hanamaki Airport
    Airport{IataCode{"HNB"}, CountryId{"US"}, Timezone{2163}}, // Huntingburg Airport
    Airport{IataCode{"HNC"}, CountryId{"US"}, Timezone{2712}}, // Billy Mitchell Airport
    Airport{IataCode{"HND"}, CountryId{"JP"}, Timezone{4568}}, // Tokyo International Airport
    Airport{IataCode{"HNH"}, CountryId{"US"}, Timezone{2260}}, // Hoonah Airport
    Airport{IataCode{"HNL"}, CountryId{"US"}, Timezone{6446}}, // Honolulu International Airport
    Airport{IataCode{"HNM"}, CountryId{"US"}, Timezone{6446}}, // Hana Airport
    Airport{IataCode{"HNS"}, CountryId{"US"}, Timezone{2260}}, // Haines Airport
    Airport{IataCode{"HNY"}, CountryId{"CN"}, Timezone{4456}}, // Hengyang Nanyue Airport
    Airport{IataCode{"HNZ"}, CountryId{"US"}, Timezone{2712}}, // Henderson-Oxford Airport
    Airport{IataCode{"HOA"}, CountryId{"KE"}, Timezone{641}}, // Hola Airport
    Airport{IataCode{"HOB"}, CountryId{"US"}, Timezone{1667}}, // Lea County Regional Airport
    Airport{IataCode{"HOD"}, CountryId{"YE"}, Timezone{3634}}, // Hodeida International Airport
    Airport{IataCode{"HOE"}, CountryId{"LA"}, Timezone{4633}}, // Ban Huoeisay Airport
    Airport{IataCode{"HOF"}, CountryId{"SA"}, Timezone{4404}}, // Al-Ahsa Domestic Airport
    Airport{IataCode{"HOG"}, CountryId{"CU"}, Timezone{1980}}, // Frank País Airport
    Airport{IataCode{"HOH"}, CountryId{"AT"}, Timezone{6021}}, // Hohenems-Dornbirn Airport
    Airport{IataCode{"HOI"}, CountryId{"FR"}, Timezone{6740}}, // Hao Airport
    Airport{IataCode{"HOK"}, CountryId{"AU"}, Timezone{4978}}, // Hooker Creek Airport
    Airport{IataCode{"HOM"}, CountryId{"US"}, Timezone{814}}, // Homer Airport
    Airport{IataCode{"HON"}, CountryId{"US"}, Timezone{1510}}, // Huron Regional Airport
    Airport{IataCode{"HOO"}, CountryId{"VN"}, Timezone{4633}}, // Quang Tri Airport
    Airport{IataCode{"HOR"}, CountryId{"PT"}, Timezone{4722}}, // Horta Airport
    Airport{IataCode{"HOS"}, CountryId{"AR"}, Timezone{1076}}, // Chos Malal Airport
    Airport{IataCode{"HOT"}, CountryId{"US"}, Timezone{1510}}, // Memorial Field Airport
    Airport{IataCode{"HOU"}, CountryId{"US"}, Timezone{1510}}, // William P. Hobby Airport
    Airport{IataCode{"HOV"}, CountryId{"NO"}, Timezone{5634}}, // Ørsta-Volda Airport
    Airport{IataCode{"HPA"}, CountryId{"TO"}, Timezone{6770}}, // Lifuka Island Airport
    Airport{IataCode{"HPB"}, CountryId{"US"}, Timezone{2745}}, // Hooper Bay Airport
    Airport{IataCode{"HPG"}, CountryId{"CN"}, Timezone{4456}}, // Shennongjia Airport
    Airport{IataCode{"HPH"}, CountryId{"VN"}, Timezone{3964}}, // Cat Bi International Airport
    Airport{IataCode{"HPN"}, CountryId{"US"}, Timezone{2712}}, // Westchester County Airport
    Airport{IataCode{"HPV"}, CountryId{"US"}, Timezone{6446}}, // Princeville Airport
    Airport{IataCode{"HPX"}, CountryId{}, Timezone{1579}}, // Água Boa Airport
    Airport{IataCode{"HPY"}, CountryId{"US"}, Timezone{1510}}, // Baytown Airport
    Airport{IataCode{"HQG"}, CountryId{"US"}, Timezone{1510}}, // Hugoton Municipal Airport
    Airport{IataCode{"HQM"}, CountryId{"US"}, Timezone{2378}}, // Bowerman Airport
    Airport{IataCode{"HQZ"}, CountryId{"US"}, Timezone{1510}}, // Mesquite Metro Airport
    Airport{IataCode{"HRB"}, CountryId{"CN"}, Timezone{4456}}, // Harbin Taiping International Airport
    Airport{IataCode{"HRE"}, CountryId{"ZW"}, Timezone{355}}, // Harare International Airport
    Airport{IataCode{"HRG"}, CountryId{"EG"}, Timezone{184}}, // Hurghada International Airport
    Airport{IataCode{"HRI"}, CountryId{"LK"}, Timezone{3854}}, // Mattala Rajapaksa International Airport
    Airport{IataCode{"HRJ"}, CountryId{"NP"}, Timezone{4100}}, // Chaurjhari Airport
    Airport{IataCode{"HRK"}, CountryId{"UA"}, Timezone{5461}}, // Kharkiv International Airport
    Airport{IataCode{"HRL"}, CountryId{"US"}, Timezone{1510}}, // Valley International Airport
    Airport{IataCode{"HRM"}, CountryId{"DZ"}, Timezone{47}}, // Hassi R'Mel Airport
    Airport{IataCode{"HRO"}, CountryId{"US"}, Timezone{1510}}, // Boone County Airport
    Airport{IataCode{"HRS"}, CountryId{"ZA"}, Timezone{369}}, // Harrismith Airport
    Airport{IataCode{"HRU"}, CountryId{"US"}, Timezone{1510}}, // Herington Regional Airport
    Airport{IataCode{"HRZ"}, CountryId{"IL"}, Timezone{4046}}, // Herzliya Airport
    Airport{IataCode{"HSA"}, CountryId{"US"}, Timezone{1510}}, // Stennis International Airport
    Airport{IataCode{"HSC"}, CountryId{"CN"}, Timezone{4456}}, // Shaoguan Guitou Airport
    Airport{IataCode{"HSD"}, CountryId{"US"}, Timezone{1510}}, // Sundance Airpark
    Airport{IataCode{"HSG"}, CountryId{"JP"}, Timezone{4568}}, // Saga Airport
    Airport{IataCode{"HSH"}, CountryId{"US"}, Timezone{2378}}, // Henderson Executive Airport
    Airport{IataCode{"HSI"}, CountryId{"US"}, Timezone{1510}}, // Hastings Municipal Airport
    Airport{IataCode{"HSK"}, CountryId{"ES"}, Timezone{5549}}, // Huesca-Pirineos Airport
    Airport{IataCode{"HSL"}, CountryId{"US"}, Timezone{814}}, // Huslia Airport
    Airport{IataCode{"HSM"}, CountryId{"AU"}, Timezone{5067}}, // Horsham Airport
    Airport{IataCode{"HSN"}, CountryId{"CN"}, Timezone{4456}}, // Zhoushan Putuoshan Airport
    Airport{IataCode{"HSR"}, CountryId{"US"}, Timezone{1667}}, // Hot Springs Municipal Airport
    Airport{IataCode{"HSS"}, CountryId{"IN"}, Timezone{4129}}, // Hisar Airport
    Airport{IataCode{"HSV"}, CountryId{"US"}, Timezone{1510}}, // Huntsville International Airport
    Airport{IataCode{"HTA"}, CountryId{"RU"}, Timezone{3827}}, // Kadala Airport
    Airport{IataCode{"HTG"}, CountryId{"RU"}, Timezone{4142}}, // Khatanga Airport
    Airport{IataCode{"HTH"}, CountryId{"US"}, Timezone{2378}}, // Hawthorne Industrial Airport
    Airport{IataCode{"HTI"}, CountryId{"AU"}, Timezone{4920}}, // Great Barrier Reef Airport
    Airport{IataCode{"HTL"}, CountryId{"US"}, Timezone{1682}}, // Roscommon County – Blodgett Memorial Airport
    Airport{IataCode{"HTM"}, CountryId{"MN"}, Timezone{4590}}, // Khatgal Airport
    Airport{IataCode{"HTN"}, CountryId{"CN"}, Timezone{4607}}, // Hotan Airport
    Airport{IataCode{"HTO"}, CountryId{"US"}, Timezone{2712}}, // East Hampton Airport
    Airport{IataCode{"HTR"}, CountryId{"JP"}, Timezone{4568}}, // Hateruma Airport
    Airport{IataCode{"HTS"}, CountryId{"US"}, Timezone{2712}}, // Tri-State Airport
    Airport{IataCode{"HTT"}, CountryId{"CN"}, Timezone{4456}}, // Huatugou Airport
    Airport{IataCode{"HTU"}, CountryId{"AU"}, Timezone{5067}}, // Hopetoun Airport
    Airport{IataCode{"HTV"}, CountryId{"US"}, Timezone{1510}}, // Huntsville Regional Airport
    Airport{IataCode{"HTW"}, CountryId{"US"}, Timezone{2712}}, // Lawrence County Airpark
    Airport{IataCode{"HTY"}, CountryId{"TR"}, Timezone{5412}}, // Hatay Airport
    Airport{IataCode{"HTZ"}, CountryId{"CO"}, Timezone{1376}}, // Hato Corozal Airport
    Airport{IataCode{"HUB"}, CountryId{"AU"}, Timezone{4978}}, // Humbert River Airport
    Airport{IataCode{"HUC"}, CountryId{"US"}, Timezone{3012}}, // Humacao Airport
    Airport{IataCode{"HUD"}, CountryId{"US"}, Timezone{1510}}, // Humboldt Municipal Airport
    Airport{IataCode{"HUE"}, CountryId{"ET"}, Timezone{28}}, // Humera Airport
    Airport{IataCode{"HUF"}, CountryId{"US"}, Timezone{2043}}, // Terre Haute International Airport
    Airport{IataCode{"HUG"}, CountryId{"GT"}, Timezone{1913}}, // Huehuetenango Airport
    Airport{IataCode{"HUH"}, CountryId{"FR"}, Timezone{6740}}, // Huahine – Fare Airport
    Airport{IataCode{"HUI"}, CountryId{"VN"}, Timezone{3964}}, // Phu Bai International Airport
    Airport{IataCode{"HUJ"}, CountryId{"US"}, Timezone{1510}}, // Stan Stamper Municipal Airport
    Airport{IataCode{"HUK"}, CountryId{"BW"}, Timezone{339}}, // Hukuntsi Airport
    Airport{IataCode{"HUL"}, CountryId{"US"}, Timezone{2712}}, // Houlton International Airport
    Airport{IataCode{"HUM"}, CountryId{"US"}, Timezone{1510}}, // Houma-Terrebonne Airport
    Airport{IataCode{"HUN"}, CountryId{"TW"}, Timezone{4504}}, // Hualien Airport
    Airport{IataCode{"HUO"}, CountryId{"CN"}, Timezone{4456}}, // Holingol Huolinhe Airport
    Airport{IataCode{"HUQ"}, CountryId{"LY"}, Timezone{757}}, // Waddan Airport
    Airport{IataCode{"HUS"}, CountryId{"US"}, Timezone{814}}, // Hughes Airport
    Airport{IataCode{"HUT"}, CountryId{"US"}, Timezone{1510}}, // Hutchinson Municipal Airport
    Airport{IataCode{"HUU"}, CountryId{"PE"}, Timezone{2365}}, // Alférez FAP David Figueroa Fernandini Airport
    Airport{IataCode{"HUV"}, CountryId{"SE"}, Timezone{5822}}, // Hudiksvall Airport
    Airport{IataCode{"HUW"}, CountryId{"BR"}, Timezone{2451}}, // Humaitá Airport
    Airport{IataCode{"HUX"}, CountryId{"MX"}, Timezone{2588}}, // Bahías de Huatulco International Airport
    Airport{IataCode{"HUY"}, CountryId{"GB"}, Timezone{5517}}, // Humberside Airport
    Airport{IataCode{"HUZ"}, CountryId{"CN"}, Timezone{4456}}, // Huizhou Airport
    Airport{IataCode{"HVA"}, CountryId{"MG"}, Timezone{6035}}, // Analalava Airport
    Airport{IataCode{"HVB"}, CountryId{"AU"}, Timezone{4920}}, // Hervey Bay Airport
    Airport{IataCode{"HVC"}, CountryId{"US"}, Timezone{1510}}, // Hopkinsville-Christian County Airport
    Airport{IataCode{"HVD"}, CountryId{"MN"}, Timezone{3996}}, // Khovd Airport
    Airport{IataCode{"HVG"}, CountryId{"NO"}, Timezone{5634}}, // Honningsvåg Airport, Valan
    Airport{IataCode{"HVK"}, CountryId{"IS"}, Timezone{4823}}, // Hólmavík Airport
    Airport{IataCode{"HVN"}, CountryId{"US"}, Timezone{2712}}, // Tweed-New Haven Regional Airport
    Airport{IataCode{"HVR"}, CountryId{"US"}, Timezone{1667}}, // Havre City-County Airport
    Airport{IataCode{"HVS"}, CountryId{"US"}, Timezone{2712}}, // Hartsville Regional Airport
    Airport{IataCode{"HWM"}, CountryId{"AU"}, Timezone{4920}}, // Kowanyama Airport
    Airport{IataCode{"HWN"}, CountryId{"ZW"}, Timezone{355}}, // Hwange National Park Airport
    Airport{IataCode{"HWO"}, CountryId{"US"}, Timezone{2712}}, // North Perry Airport
    Airport{IataCode{"HWQ"}, CountryId{"US"}, Timezone{1667}}, // Wheatland County Airport
    Airport{IataCode{"HWY"}, CountryId{"US"}, Timezone{2712}}, // Warrenton-Fauquier Airport
    Airport{IataCode{"HXD"}, CountryId{"CN"}, Timezone{4456}}, // Delingha Airport
    Airport{IataCode{"HXX"}, CountryId{"AU"}, Timezone{5103}}, // Hay Airport
    Airport{IataCode{"HYA"}, CountryId{"US"}, Timezone{2712}}, // Barnstable Municipal Airport
    Airport{IataCode{"HYC"}, CountryId{"GB"}, Timezone{5517}}, // Wycombe Air Park
    Airport{IataCode{"HYD"}, CountryId{"IN"}, Timezone{4129}}, // Rajiv Gandhi International Airport
    Airport{IataCode{"HYG"}, CountryId{"US"}, Timezone{3255}}, // Hydaburg Seaplane Base
    Airport{IataCode{"HYI"}, CountryId{"US"}, Timezone{1510}}, // San Marcos Municipal Airport
    Airport{IataCode{"HYL"}, CountryId{"US"}, Timezone{3255}}, // Hollis Seaplane Base
    Airport{IataCode{"HYN"}, CountryId{"CN"}, Timezone{4456}}, // Taizhou Luqiao Airport
    Airport{IataCode{"HYR"}, CountryId{"US"}, Timezone{1510}}, // Sawyer County Airport
    Airport{IataCode{"HYS"}, CountryId{"US"}, Timezone{1510}}, // Hays Regional Airport
    Airport{IataCode{"HYW"}, CountryId{"US"}, Timezone{2712}}, // Conway-Horry County Airport
    Airport{IataCode{"HYX"}, CountryId{"US"}, Timezone{1682}}, // Saginaw County H.W. Browne Airport
    Airport{IataCode{"HZB"}, CountryId{"FR"}, Timezone{5646}}, // Merville – Calonne Airport
    Airport{IataCode{"HZD"}, CountryId{"US"}, Timezone{1510}}, // Carroll County Airport
    Airport{IataCode{"HZE"}, CountryId{"US"}, Timezone{2774}}, // Mercer County Regional Airport
    Airport{IataCode{"HZG"}, CountryId{"CN"}, Timezone{4456}}, // Hanzhong Chenggu Airport
    Airport{IataCode{"HZH"}, CountryId{"CN"}, Timezone{4456}}, // Liping Airport
    Airport{IataCode{"HZK"}, CountryId{"IS"}, Timezone{4823}}, // Húsavík Airport
    Airport{IataCode{"HZL"}, CountryId{"US"}, Timezone{2712}}, // Hazleton Municipal Airport
    Airport{IataCode{"HZP"}, CountryId{"CA"}, Timezone{1715}}, // Fort MacKay/Horizon Airport
    Airport{IataCode{"HZR"}, CountryId{"US"}, Timezone{1510}}, // False River Regional Airport
    Airport{IataCode{"IAA"}, CountryId{"RU"}, Timezone{4142}}, // Igarka Airport
    Airport{IataCode{"IAD"}, CountryId{"US"}, Timezone{2712}}, // Washington Dulles International Airport
    Airport{IataCode{"IAG"}, CountryId{"US"}, Timezone{}}, // Niagara Falls International Airport
    Airport{IataCode{"IAH"}, CountryId{"US"}, Timezone{1510}}, // George Bush Intercontinental Airport
    Airport{IataCode{"IAM"}, CountryId{"DZ"}, Timezone{47}}, // In Aménas Airport
    Airport{IataCode{"IAN"}, CountryId{"US"}, Timezone{814}}, // Bob Baker Memorial Airport
    Airport{IataCode{"IAO"}, CountryId{"PH"}, Timezone{4240}}, // Sayak Airport
    Airport{IataCode{"IAQ"}, CountryId{"IR"}, Timezone{4543}}, // Bastak Airport
    Airport{IataCode{"IAR"}, CountryId{"RU"}, Timezone{5620}}, // Tunoshna Airport
    Airport{IataCode{"IAS"}, CountryId{"RO"}, Timezone{5247}}, // Iași International Airport
    Airport{IataCode{"IBA"}, CountryId{"NG"}, Timezone{462}}, // Ibadan Airport
    Airport{IataCode{"IBE"}, CountryId{"CO"}, Timezone{1376}}, // Perales Airport
    Airport{IataCode{"IBL"}, CountryId{"MZ"}, Timezone{565}}, // Indigo Bay Lodge Airport
    Airport{IataCode{"IBP"}, CountryId{"PE"}, Timezone{2365}}, // Iberia Airport
    Airport{IataCode{"IBZ"}, CountryId{"ES"}, Timezone{5549}}, // Ibiza Airport
    Airport{IataCode{"ICA"}, CountryId{}, Timezone{1463}}, // Icabarú Airport
    Airport{IataCode{"ICC"}, CountryId{"VE"}, Timezone{1463}}, // Andrés Miguel Salazar Marcano Airport
    Airport{IataCode{"ICI"}, CountryId{"FJ"}, Timezone{6349}}, // Cicia Airport
    Airport{IataCode{"ICK"}, CountryId{"SR"}, Timezone{1949}}, // Majoor Henry Fernandes Airport
    Airport{IataCode{"ICN"}, CountryId{"KR"}, Timezone{4445}}, // Incheon International Airport
    Airport{IataCode{"ICR"}, CountryId{"CU"}, Timezone{1980}}, // Nicaro Airport
    Airport{IataCode{"ICT"}, CountryId{"US"}, Timezone{1510}}, // Wichita Dwight D. Eisenhower National Airport
    Airport{IataCode{"ICY"}, CountryId{"US"}, Timezone{814}}, // Icy Bay Airport
    Airport{IataCode{"IDA"}, CountryId{"US"}, Timezone{1391}}, // Idaho Falls Regional Airport
    Airport{IataCode{"IDF"}, CountryId{"CD"}, Timezone{446}}, // Idiofa Airport
    Airport{IataCode{"IDH"}, CountryId{"US"}, Timezone{2378}}, // Idaho County Airport
    Airport{IataCode{"IDI"}, CountryId{"US"}, Timezone{2712}}, // Indiana County-Jimmy Stewart Airport
    Airport{IataCode{"IDL"}, CountryId{"US"}, Timezone{1510}}, // Indianola Municipal Airport
    Airport{IataCode{"IDP"}, CountryId{"US"}, Timezone{1510}}, // Independence Municipal Airport
    Airport{IataCode{"IDR"}, CountryId{"IN"}, Timezone{4129}}, // Devi Ahilyabai Holkar Airport
    Airport{IataCode{"IDY"}, CountryId{"FR"}, Timezone{5646}}, // Île d'Yeu Aerodrome
    Airport{IataCode{"IEG"}, CountryId{"PL"}, Timezone{5975}}, // Zielona Góra Airport
    Airport{IataCode{"IEJ"}, CountryId{"JP"}, Timezone{}}, // Iejima Airport
    Airport{IataCode{"IER"}, CountryId{"US"}, Timezone{1510}}, // Natchitoches Regional Airport
    Airport{IataCode{"IES"}, CountryId{"DE"}, Timezone{5199}}, // Riesa-Göhlis Aerodrome
    Airport{IataCode{"IEV"}, CountryId{"UA"}, Timezone{5461}}, // Kyiv Zhuliany International Airport
    Airport{IataCode{"IFJ"}, CountryId{"IS"}, Timezone{4823}}, // Ísafjörður Airport
    Airport{IataCode{"IFL"}, CountryId{"AU"}, Timezone{4920}}, // Innisfail Airport
    Airport{IataCode{"IFN"}, CountryId{"IR"}, Timezone{4543}}, // Isfahan International Airport
    Airport{IataCode{"IFO"}, CountryId{"UA"}, Timezone{5461}}, // Ivano-Frankivsk International Airport
    Airport{IataCode{"IFP"}, CountryId{"US"}, Timezone{2378}}, // Laughlin/Bullhead International Airport
    Airport{IataCode{"IGA"}, CountryId{"BS"}, Timezone{2697}}, // Inagua Airport
    Airport{IataCode{"IGB"}, CountryId{"AR"}, Timezone{1076}}, // Ingeniero Jacobacci Airport
    Airport{IataCode{"IGD"}, CountryId{"TR"}, Timezone{5412}}, // Iğdır Airport
    Airport{IataCode{"IGE"}, CountryId{"GA"}, Timezone{475}}, // Tchongorove Airport
    Airport{IataCode{"IGG"}, CountryId{"US"}, Timezone{814}}, // Igiugig Airport
    Airport{IataCode{"IGH"}, CountryId{"AU"}, Timezone{4920}}, // Ingham Airport
    Airport{IataCode{"IGM"}, CountryId{"US"}, Timezone{2931}}, // Kingman Airport
    Airport{IataCode{"IGN"}, CountryId{"PH"}, Timezone{4240}}, // Maria Cristina Airport
    Airport{IataCode{"IGO"}, CountryId{}, Timezone{1376}}, // Jaime Ortíz Betancur Airport
    Airport{IataCode{"IGR"}, CountryId{"AR"}, Timezone{942}}, // Cataratas del Iguazú International Airport
    Airport{IataCode{"IGS"}, CountryId{"DE"}, Timezone{5199}}, // Ingolstadt Manching Airport
    Airport{IataCode{"IGT"}, CountryId{"RU"}, Timezone{5620}}, // Magas Airport
    Airport{IataCode{"IGU"}, CountryId{"BR"}, Timezone{}}, // Foz do Iguaçu International Airport
    Airport{IataCode{"IGX"}, CountryId{"US"}, Timezone{2712}}, // Horace Williams Airport
    Airport{IataCode{"IHC"}, CountryId{"MZ"}, Timezone{565}}, // Inhaca Airport
    Airport{IataCode{"IHO"}, CountryId{"MG"}, Timezone{}}, // Ihosy Airport
    Airport{IataCode{"IHR"}, CountryId{"IR"}, Timezone{4543}}, // Iranshahr Airport
    Airport{IataCode{"IHU"}, CountryId{"PG"}, Timezone{6686}}, // Ihu Airport
    Airport{IataCode{"IIA"}, CountryId{"IE"}, Timezone{5330}}, // Inishmaan Aerodrome
    Airport{IataCode{"IIB"}, CountryId{"US"}, Timezone{1510}}, // Independence Municipal Airport
    Airport{IataCode{"IIL"}, CountryId{"IR"}, Timezone{4543}}, // Ilam Airport
    Airport{IataCode{"IIS"}, CountryId{"PG"}, Timezone{6235}}, // Nissan Island Airport
    Airport{IataCode{"IJD"}, CountryId{"US"}, Timezone{2712}}, // Windham Airport
    Airport{IataCode{"IJK"}, CountryId{"RU"}, Timezone{5714}}, // Izhevsk Airport
    Airport{IataCode{"IJU"}, CountryId{"BR"}, Timezone{3216}}, // Ijuí Airport
    Airport{IataCode{"IKA"}, CountryId{"IR"}, Timezone{4543}}, // Tehran Imam Khomeini International Airport
    Airport{IataCode{"IKB"}, CountryId{"US"}, Timezone{2712}}, // Wilkes County Airport
    Airport{IataCode{"IKG"}, CountryId{"US"}, Timezone{1510}}, // Kleberg County Airport
    Airport{IataCode{"IKI"}, CountryId{"JP"}, Timezone{4568}}, // Iki Airport
    Airport{IataCode{"IKK"}, CountryId{"US"}, Timezone{1510}}, // Greater Kankakee Airport
    Airport{IataCode{"IKL"}, CountryId{"CD"}, Timezone{446}}, // Ikela Airport
    Airport{IataCode{"IKS"}, CountryId{"RU"}, Timezone{4665}}, // Tiksi Airport
    Airport{IataCode{"IKT"}, CountryId{"RU"}, Timezone{4006}}, // International Airport Irkutsk
    Airport{IataCode{"IKU"}, CountryId{"KG"}, Timezone{3802}}, // Tamchy Airport
    Airport{IataCode{"IKV"}, CountryId{"US"}, Timezone{1510}}, // Ankeny Regional Airport
    Airport{IataCode{"IKW"}, CountryId{"US"}, Timezone{1682}}, // Jack Barstow Municipal Airport
    Airport{IataCode{"ILB"}, CountryId{"BR"}, Timezone{1427}}, // Solteira Island Airport
    Airport{IataCode{"ILD"}, CountryId{"ES"}, Timezone{5549}}, // Lleida-Alguaire Airport
    Airport{IataCode{"ILE"}, CountryId{"US"}, Timezone{1510}}, // Skylark Field
    Airport{IataCode{"ILF"}, CountryId{"CA"}, Timezone{3540}}, // Ilford Airport
    Airport{IataCode{"ILG"}, CountryId{"US"}, Timezone{2712}}, // New Castle Airport
    Airport{IataCode{"ILI"}, CountryId{"US"}, Timezone{814}}, // Iliamna Airport
    Airport{IataCode{"ILK"}, CountryId{"MG"}, Timezone{}}, // Atsinanana Airport
    Airport{IataCode{"ILL"}, CountryId{"US"}, Timezone{1510}}, // Willmar Municipal Airport
    Airport{IataCode{"ILM"}, CountryId{"US"}, Timezone{2712}}, // Wilmington International Airport
    Airport{IataCode{"ILN"}, CountryId{"US"}, Timezone{2712}}, // Airborne Airpark
    Airport{IataCode{"ILO"}, CountryId{"PH"}, Timezone{4240}}, // Iloilo International Airport
    Airport{IataCode{"ILP"}, CountryId{"FR"}, Timezone{6606}}, // Île des Pins Airport
    Airport{IataCode{"ILQ"}, CountryId{"PE"}, Timezone{2365}}, // Ilo Airport
    Airport{IataCode{"ILR"}, CountryId{"NG"}, Timezone{462}}, // Ilorin International Airport
    Airport{IataCode{"ILS"}, CountryId{"SV"}, Timezone{1749}}, // Ilopango International Airport
    Airport{IataCode{"ILU"}, CountryId{"KE"}, Timezone{641}}, // Kilaguni Airport
    Airport{IataCode{"ILY"}, CountryId{"GB"}, Timezone{5517}}, // Islay Airport
    Airport{IataCode{"ILZ"}, CountryId{"SK"}, Timezone{5213}}, // Žilina Airport
    Airport{IataCode{"IMB"}, CountryId{"GY"}, Timezone{1949}}, // Imbaimadai Airport
    Airport{IataCode{"IMI"}, CountryId{"MH"}, Timezone{6515}}, // Ine Airport
    Airport{IataCode{"IMK"}, CountryId{"NP"}, Timezone{4100}}, // Simikot Airport
    Airport{IataCode{"IMM"}, CountryId{"US"}, Timezone{2712}}, // Immokalee Airport
    Airport{IataCode{"IMO"}, CountryId{"CF"}, Timezone{104}}, // Zemio Airport
    Airport{IataCode{"IMP"}, CountryId{"BR"}, Timezone{1789}}, // Imperatriz Airport
    Airport{IataCode{"IMT"}, CountryId{"US"}, Timezone{1510}}, // Ford Airport
    Airport{IataCode{"INA"}, CountryId{"RU"}, Timezone{5620}}, // Inta Airport
    Airport{IataCode{"INB"}, CountryId{"BZ"}, Timezone{1322}}, // Independence Airport (Belize)
    Airport{IataCode{"INC"}, CountryId{"CN"}, Timezone{4456}}, // Yinchuan Hedong International Airport
    Airport{IataCode{"IND"}, CountryId{"US"}, Timezone{2043}}, // Indianapolis International Airport
    Airport{IataCode{"INF"}, CountryId{"DZ"}, Timezone{47}}, // In Guezzam Airport
    Airport{IataCode{"ING"}, CountryId{"AR"}, Timezone{1045}}, // Lago Argentino Airport
    Airport{IataCode{"INH"}, CountryId{"MZ"}, Timezone{565}}, // Inhambane Airport
    Airport{IataCode{"INI"}, CountryId{"RS"}, Timezone{5183}}, // Niš Constantine the Great Airport
    Airport{IataCode{"INJ"}, CountryId{"US"}, Timezone{1510}}, // Hillsboro Municipal Airport
    Airport{IataCode{"INK"}, CountryId{"US"}, Timezone{1510}}, // Winkler County Airport
    Airport{IataCode{"INL"}, CountryId{"US"}, Timezone{3540}}, // Falls International Airport
    Airport{IataCode{"INN"}, CountryId{"AT"}, Timezone{5929}}, // Innsbruck Airport
    Airport{IataCode{"INO"}, CountryId{"CD"}, Timezone{446}}, // Inongo Airport
    Airport{IataCode{"INQ"}, CountryId{"IE"}, Timezone{5330}}, // Inisheer Aerodrome
    Airport{IataCode{"INT"}, CountryId{"US"}, Timezone{2712}}, // Smith Reynolds Airport
    Airport{IataCode{"INU"}, CountryId{"NR"}, Timezone{}}, // Nauru International Airport
    Airport{IataCode{"INV"}, CountryId{"GB"}, Timezone{5517}}, // Inverness Airport
    Airport{IataCode{"INW"}, CountryId{"US"}, Timezone{2931}}, // Winslow-Lindbergh Regional Airport
    Airport{IataCode{"INZ"}, CountryId{"DZ"}, Timezone{47}}, // In Salah Airport
    Airport{IataCode{"IOA"}, CountryId{"GR"}, Timezone{5169}}, // Ioannina National Airport
    Airport{IataCode{"IOM"}, CountryId{"IM"}, Timezone{5393}}, // Isle of Man Airport
    Airport{IataCode{"ION"}, CountryId{"CG"}, Timezone{148}}, // Impfondo Airport
    Airport{IataCode{"IOR"}, CountryId{"IE"}, Timezone{5330}}, // Inishmore Aerodrome
    Airport{IataCode{"IOS"}, CountryId{"BR"}, Timezone{1254}}, // Ilhéus Jorge Amado Airport
    Airport{IataCode{"IOW"}, CountryId{"US"}, Timezone{1510}}, // Iowa City Municipal Airport
    Airport{IataCode{"IPA"}, CountryId{"BA"}, Timezone{6301}}, // Ipota Airport
    Airport{IataCode{"IPC"}, CountryId{"CL"}, Timezone{6286}}, // Mataveri International Airport
    Airport{IataCode{"IPE"}, CountryId{"PH"}, Timezone{4240}}, // Ipil Airport
    Airport{IataCode{"IPG"}, CountryId{"BR"}, Timezone{1376}}, // Ipiranga Airport
    Airport{IataCode{"IPH"}, CountryId{"MY"}, Timezone{4159}}, // Sultan Azlan Shah Airport
    Airport{IataCode{"IPI"}, CountryId{"CO"}, Timezone{1376}}, // San Luis Airport
    Airport{IataCode{"IPJ"}, CountryId{"US"}, Timezone{2712}}, // Lincolnton-Lincoln County Regional Airport
    Airport{IataCode{"IPL"}, CountryId{"US"}, Timezone{2378}}, // Imperial County Airport
    Airport{IataCode{"IPN"}, CountryId{"BR"}, Timezone{3216}}, // Usiminas Airport
    Airport{IataCode{"IPT"}, CountryId{"US"}, Timezone{2712}}, // Williamsport Regional Airport
    Airport{IataCode{"IQN"}, CountryId{"CN"}, Timezone{4456}}, // Qingyang Airport
    Airport{IataCode{"IQQ"}, CountryId{"CL"}, Timezone{3177}}, // Diego Aracena International Airport
    Airport{IataCode{"IQT"}, CountryId{"PE"}, Timezone{2365}}, // Crnl. FAP Francisco Secada Vignetta International Airport
    Airport{IataCode{"IRA"}, CountryId{"SB"}, Timezone{6413}}, // Kirakira Airport
    Airport{IataCode{"IRC"}, CountryId{"US"}, Timezone{814}}, // Circle City Airport
    Airport{IataCode{"IRD"}, CountryId{"BD"}, Timezone{3881}}, // Ishurdi Airport
    Airport{IataCode{"IRG"}, CountryId{"AU"}, Timezone{4920}}, // Lockhart River Airport
    Airport{IataCode{"IRI"}, CountryId{"TZ"}, Timezone{256}}, // Iringa Airport
    Airport{IataCode{"IRJ"}, CountryId{"AR"}, Timezone{992}}, // Capitán Vicente Almandos Almonacid Airport
    Airport{IataCode{"IRK"}, CountryId{"US"}, Timezone{1510}}, // Kirksville Regional Airport
    Airport{IataCode{"IRO"}, CountryId{"CF"}, Timezone{104}}, // Birao Airport
    Airport{IataCode{"IRP"}, CountryId{"CD"}, Timezone{519}}, // Matari Airport
    Airport{IataCode{"IRZ"}, CountryId{"BR"}, Timezone{2451}}, // Tapuruquara Airport
    Airport{IataCode{"ISA"}, CountryId{"AU"}, Timezone{4920}}, // Mount Isa Airport
    Airport{IataCode{"ISB"}, CountryId{"PK"}, Timezone{4087}}, // Islamabad International AirPort
    Airport{IataCode{"ISC"}, CountryId{"GB"}, Timezone{5517}}, // St Mary's Airport
    Airport{IataCode{"ISE"}, CountryId{"TR"}, Timezone{5412}}, // Isparta Süleyman Demirel Airport
    Airport{IataCode{"ISG"}, CountryId{"JP"}, Timezone{4568}}, // New Ishigaki Airport
    Airport{IataCode{"ISI"}, CountryId{"AU"}, Timezone{4920}}, // Isisford Airport
    Airport{IataCode{"ISJ"}, CountryId{"MX"}, Timezone{1448}}, // Isla Mujeres Airport
    Airport{IataCode{"ISK"}, CountryId{"IN"}, Timezone{4129}}, // Ozar Airport
    Airport{IataCode{"ISM"}, CountryId{"US"}, Timezone{2712}}, // Kissimmee Gateway Airport
    Airport{IataCode{"ISN"}, CountryId{"US"}, Timezone{1510}}, // Sloulin Field International Airport
    Airport{IataCode{"ISO"}, CountryId{"US"}, Timezone{2712}}, // Kinston Regional Jetport
    Airport{IataCode{"ISP"}, CountryId{"US"}, Timezone{2712}}, // Long Island MacArthur Airport
    Airport{IataCode{"ISQ"}, CountryId{"US"}, Timezone{1682}}, // Schoolcraft County Airport
    Airport{IataCode{"ISS"}, CountryId{"US"}, Timezone{2712}}, // Wiscasset Airport
    Airport{IataCode{"IST"}, CountryId{"TR"}, Timezone{5412}}, // Atatürk International Airport
    Airport{IataCode{"ISU"}, CountryId{"IQ"}, Timezone{3728}}, // Sulaimaniyah International Airport
    Airport{IataCode{"ISW"}, CountryId{"US"}, Timezone{1510}}, // South Wood County Airport
    Airport{IataCode{"ISZ"}, CountryId{"US"}, Timezone{2712}}, // Cincinnati-Blue Ash Airport
    Airport{IataCode{"ITA"}, CountryId{"BR"}, Timezone{2451}}, // Itacoatiara Airport
    Airport{IataCode{"ITB"}, CountryId{"BR"}, Timezone{3160}}, // Itaituba Airport
    Airport{IataCode{"ITH"}, CountryId{"US"}, Timezone{2712}}, // Ithaca Tompkins Regional Airport
    Airport{IataCode{"ITM"}, CountryId{"JP"}, Timezone{4568}}, // Osaka International Airport
    Airport{IataCode{"ITO"}, CountryId{"US"}, Timezone{6446}}, // Hilo International Airport
    Airport{IataCode{"ITP"}, CountryId{"BR"}, Timezone{3216}}, // Itaperuna Airport
    Airport{IataCode{"ITQ"}, CountryId{"BR"}, Timezone{942}}, // Itaqui Airport
    Airport{IataCode{"ITR"}, CountryId{"BR"}, Timezone{3216}}, // Itumbiara Airport
    Airport{IataCode{"ITU"}, CountryId{"RU"}, Timezone{4619}}, // Iturup Airport
    Airport{IataCode{"IUE"}, CountryId{"NU"}, Timezone{6577}}, // Niue International Airport
    Airport{IataCode{"IUS"}, CountryId{"PG"}, Timezone{6235}}, // Inus Airport
    Airport{IataCode{"IVA"}, CountryId{"MG"}, Timezone{6035}}, // Ampampamena Airport
    Airport{IataCode{"IVC"}, CountryId{"NZ"}, Timezone{6218}}, // Invercargill Airport
    Airport{IataCode{"IVG"}, CountryId{"ME"}, Timezone{5659}}, // Dolac Airport
    Airport{IataCode{"IVL"}, CountryId{"FI"}, Timezone{5377}}, // Ivalo Airport
    Airport{IataCode{"IVR"}, CountryId{"AU"}, Timezone{5103}}, // Inverell Airport
    Airport{IataCode{"IWA"}, CountryId{"RU"}, Timezone{5620}}, // Ivanovo Yuzhny Airport
    Airport{IataCode{"IWD"}, CountryId{"US"}, Timezone{2536}}, // Gogebic-Iron County Airport
    Airport{IataCode{"IWJ"}, CountryId{"JP"}, Timezone{4568}}, // Iwami Airport
    Airport{IataCode{"IWS"}, CountryId{"US"}, Timezone{1510}}, // West Houston Airport
    Airport{IataCode{"IXA"}, CountryId{"IN"}, Timezone{3881}}, // Agartala Airport
    Airport{IataCode{"IXB"}, CountryId{"IN"}, Timezone{4100}}, // Bagdogra Airport
    Airport{IataCode{"IXC"}, CountryId{"IN"}, Timezone{4129}}, // Chandigarh Airport
    Airport{IataCode{"IXD"}, CountryId{"IN"}, Timezone{4129}}, // Allahabad Airport
    Airport{IataCode{"IXE"}, CountryId{"IN"}, Timezone{4129}}, // Mangalore Airport
    Airport{IataCode{"IXG"}, CountryId{"IN"}, Timezone{4129}}, // Belgaum Airport
    Airport{IataCode{"IXH"}, CountryId{"IN"}, Timezone{3881}}, // Kailashahar Airport
    Airport{IataCode{"IXI"}, CountryId{"IN"}, Timezone{4129}}, // Lilabari Airport
    Airport{IataCode{"IXJ"}, CountryId{"IN"}, Timezone{4087}}, // Jammu Airport
    Airport{IataCode{"IXK"}, CountryId{"IN"}, Timezone{4129}}, // Keshod Airport
    Airport{IataCode{"IXL"}, CountryId{"IN"}, Timezone{4129}}, // Kushok Bakula Rimpochee Airport
    Airport{IataCode{"IXM"}, CountryId{"IN"}, Timezone{4129}}, // Madurai International Airport
    Airport{IataCode{"IXN"}, CountryId{"IN"}, Timezone{3881}}, // Khowai Airport
    Airport{IataCode{"IXP"}, CountryId{"IN"}, Timezone{4129}}, // Pathankot Airport
    Airport{IataCode{"IXQ"}, CountryId{"IN"}, Timezone{3881}}, // Kamalpur Airport
    Airport{IataCode{"IXR"}, CountryId{"IN"}, Timezone{4129}}, // Birsa Munda Airport
    Airport{IataCode{"IXS"}, CountryId{"IN"}, Timezone{4129}}, // Silchar Airport
    Airport{IataCode{"IXT"}, CountryId{"IN"}, Timezone{4129}}, // Pasighat Airport
    Airport{IataCode{"IXU"}, CountryId{"IN"}, Timezone{4129}}, // Aurangabad Airport
    Airport{IataCode{"IXV"}, CountryId{"IN"}, Timezone{4129}}, // Along Airport
    Airport{IataCode{"IXW"}, CountryId{"IN"}, Timezone{4129}}, // Sonari Airport
    Airport{IataCode{"IXY"}, CountryId{"IN"}, Timezone{4129}}, // Kandla Airport
    Airport{IataCode{"IXZ"}, CountryId{"IN"}, Timezone{4129}}, // Veer Savarkar International Airport
    Airport{IataCode{"IYA"}, CountryId{"US"}, Timezone{1510}}, // Abbeville Chris Crusta Memorial Airport
    Airport{IataCode{"IYK"}, CountryId{"US"}, Timezone{2378}}, // Inyokern Airport
    Airport{IataCode{"IZA"}, CountryId{"BR"}, Timezone{3216}}, // Zona da Mata Regional Airport
    Airport{IataCode{"IZO"}, CountryId{"JP"}, Timezone{4568}}, // Izumo Airport
    Airport{IataCode{"IZT"}, CountryId{"MX"}, Timezone{2588}}, // Ixtepec Airport
    Airport{IataCode{"JAA"}, CountryId{"AF"}, Timezone{4061}}, // Jalalabad Airport
    Airport{IataCode{"JAB"}, CountryId{"AU"}, Timezone{4978}}, // Jabiru Airport
    Airport{IataCode{"JAC"}, CountryId{"US"}, Timezone{1667}}, // Jackson Hole Airport
    Airport{IataCode{"JAD"}, CountryId{"AU"}, Timezone{5087}}, // Jandakot Airport
    Airport{IataCode{"JAE"}, CountryId{"PE"}, Timezone{2365}}, // Shumba Airport
    Airport{IataCode{"JAI"}, CountryId{"IN"}, Timezone{4129}}, // Jaipur Airport
    Airport{IataCode{"JAK"}, CountryId{"HT"}, Timezone{2947}}, // Jacmel Airport
    Airport{IataCode{"JAL"}, CountryId{"MX"}, Timezone{2588}}, // El Lencero Airport
    Airport{IataCode{"JAN"}, CountryId{"US"}, Timezone{1510}}, // Jackson-Evers International Airport
    Airport{IataCode{"JAO"}, CountryId{"RS"}, Timezone{5183}}, // Jagodina Airport
    Airport{IataCode{"JAP"}, CountryId{"CR"}, Timezone{1544}}, // Chacarita Airport
    Airport{IataCode{"JAQ"}, CountryId{"PG"}, Timezone{6686}}, // Jacquinot Bay Airport
    Airport{IataCode{"JAR"}, CountryId{}, Timezone{4543}}, // Jahrom Airport
    Airport{IataCode{"JAT"}, CountryId{"MH"}, Timezone{}}, // Jabot Airport
    Airport{IataCode{"JAU"}, CountryId{"PE"}, Timezone{2365}}, // Francisco Carle Airport
    Airport{IataCode{"JAV"}, CountryId{"GL"}, Timezone{1825}}, // Ilulissat Airport
    Airport{IataCode{"JAX"}, CountryId{"US"}, Timezone{2712}}, // Jacksonville International Airport
    Airport{IataCode{"JBB"}, CountryId{"ID"}, Timezone{4032}}, // Notohadinegoro Airport
    Airport{IataCode{"JBQ"}, CountryId{"DO"}, Timezone{3194}}, // La Isabela International Airport
    Airport{IataCode{"JBR"}, CountryId{"US"}, Timezone{1510}}, // Jonesboro Municipal Airport
    Airport{IataCode{"JBT"}, CountryId{"US"}, Timezone{814}}, // Bethel Seaplane Base
    Airport{IataCode{"JCB"}, CountryId{"BR"}, Timezone{3216}}, // Joaçaba Airport
    Airport{IataCode{"JCH"}, CountryId{"GL"}, Timezone{1825}}, // Qasigiannguit Heliport
    Airport{IataCode{"JCI"}, CountryId{"US"}, Timezone{1510}}, // New Century AirCenter
    Airport{IataCode{"JCK"}, CountryId{"AU"}, Timezone{4920}}, // Julia Creek Airport
    Airport{IataCode{"JCR"}, CountryId{"BR"}, Timezone{3160}}, // Jacareacanga Airport
    Airport{IataCode{"JDA"}, CountryId{"US"}, Timezone{2378}}, // Grant County Regional Airport
    Airport{IataCode{"JDD"}, CountryId{"US"}, Timezone{1510}}, // Wood County Airport
    Airport{IataCode{"JDF"}, CountryId{"BR"}, Timezone{3216}}, // Juiz de Fora Airport
    Airport{IataCode{"JDG"}, CountryId{"KR"}, Timezone{4445}}, // Jungseok Airport
    Airport{IataCode{"JDH"}, CountryId{"IN"}, Timezone{4129}}, // Jodhpur Airport
    Airport{IataCode{"JDN"}, CountryId{"US"}, Timezone{1667}}, // Jordan Airport
    Airport{IataCode{"JDO"}, CountryId{"BR"}, Timezone{1789}}, // Juazeiro do Norte Airport
    Airport{IataCode{"JDR"}, CountryId{"BR"}, Timezone{3216}}, // São João del-Rei Airport
    Airport{IataCode{"JDZ"}, CountryId{"CN"}, Timezone{4456}}, // Jingdezhen Luojia Airport
    Airport{IataCode{"JED"}, CountryId{"SA"}, Timezone{4404}}, // King Abdulaziz International Airport
    Airport{IataCode{"JEE"}, CountryId{"HT"}, Timezone{2947}}, // Jérémie Airport
    Airport{IataCode{"JEF"}, CountryId{"US"}, Timezone{1510}}, // Jefferson City Memorial Airport
    Airport{IataCode{"JEG"}, CountryId{"GL"}, Timezone{1825}}, // Aasiaat Airport
    Airport{IataCode{"JEJ"}, CountryId{"MH"}, Timezone{6515}}, // Jeh Airport
    Airport{IataCode{"JEQ"}, CountryId{"BR"}, Timezone{1254}}, // Jequié Airport
    Airport{IataCode{"JER"}, CountryId{"JE"}, Timezone{5428}}, // Jersey Airport
    Airport{IataCode{"JES"}, CountryId{"US"}, Timezone{2712}}, // Jesup-Wayne County Airport
    Airport{IataCode{"JFK"}, CountryId{"US"}, Timezone{2712}}, // John F. Kennedy International Airport
    Airport{IataCode{"JFN"}, CountryId{"US"}, Timezone{2712}}, // Northeast Ohio Regional Airport
    Airport{IataCode{"JFR"}, CountryId{"GL"}, Timezone{1825}}, // Paamiut Airport
    Airport{IataCode{"JFX"}, CountryId{"US"}, Timezone{1510}}, // Walker County Airport
    Airport{IataCode{"JGA"}, CountryId{"IN"}, Timezone{4129}}, // Jamnagar Airport
    Airport{IataCode{"JGB"}, CountryId{"IN"}, Timezone{4129}}, // Jagdalpur Airport
    Airport{IataCode{"JGD"}, CountryId{"CN"}, Timezone{4456}}, // Jiagedaqi Airport
    Airport{IataCode{"JGN"}, CountryId{"CN"}, Timezone{4456}}, // Jiayuguan Airport
    Airport{IataCode{"JGO"}, CountryId{"GL"}, Timezone{1825}}, // Qeqertarsuaq Heliport
    Airport{IataCode{"JGS"}, CountryId{"CN"}, Timezone{4456}}, // Jinggangshan Airport
    Airport{IataCode{"JHB"}, CountryId{"MY"}, Timezone{4159}}, // Senai International Airport
    Airport{IataCode{"JHG"}, CountryId{"CN"}, Timezone{4456}}, // Xishuangbanna Gasa Airport
    Airport{IataCode{"JHL"}, CountryId{"CA"}, Timezone{1715}}, // Fort MacKay/Albian Aerodrome
    Airport{IataCode{"JHM"}, CountryId{"US"}, Timezone{6446}}, // Kapalua Airport
    Airport{IataCode{"JHN"}, CountryId{"US"}, Timezone{1510}}, // Stanton County Municipal Airport
    Airport{IataCode{"JHQ"}, CountryId{"AU"}, Timezone{4920}}, // Whitsunday Airport
    Airport{IataCode{"JHS"}, CountryId{"GL"}, Timezone{1825}}, // Sisimiut Airport
    Airport{IataCode{"JHW"}, CountryId{"US"}, Timezone{2712}}, // Chautauqua County-Jamestown Airport
    Airport{IataCode{"JIA"}, CountryId{"BR"}, Timezone{1579}}, // Juína Airport
    Airport{IataCode{"JIB"}, CountryId{"DJ"}, Timezone{277}}, // Djibouti-Ambouli International Airport
    Airport{IataCode{"JIC"}, CountryId{"CN"}, Timezone{4456}}, // Jinchang Jinchuan Airport
    Airport{IataCode{"JIJ"}, CountryId{"ET"}, Timezone{28}}, // Jijiga Airport
    Airport{IataCode{"JIK"}, CountryId{"GR"}, Timezone{5169}}, // Ikaria Island National Airport
    Airport{IataCode{"JIL"}, CountryId{"CN"}, Timezone{4456}}, // Jilin Ertaizi Airport
    Airport{IataCode{"JIM"}, CountryId{"ET"}, Timezone{28}}, // Aba Segud Airport
    Airport{IataCode{"JIN"}, CountryId{"UG"}, Timezone{401}}, // Jinja Airport
    Airport{IataCode{"JIO"}, CountryId{"ID"}, Timezone{4032}}, // Jos Orno Imsula Airport
    Airport{IataCode{"JIQ"}, CountryId{"CN"}, Timezone{4456}}, // Qianjiang Wulingshan Airport
    Airport{IataCode{"JIU"}, CountryId{"CN"}, Timezone{4456}}, // Jiujiang Lushan Airport
    Airport{IataCode{"JIW"}, CountryId{"PK"}, Timezone{4543}}, // Jiwani Airport
    Airport{IataCode{"JJC"}, CountryId{"MX"}, Timezone{2588}}, // Atizapan De Zaragoza Airport
    Airport{IataCode{"JJG"}, CountryId{"BR"}, Timezone{3216}}, // Jaguaruna Regional Airport
    Airport{IataCode{"JJI"}, CountryId{"PE"}, Timezone{2365}}, // Juanjuí Airport
    Airport{IataCode{"JJM"}, CountryId{"KE"}, Timezone{641}}, // Mulika Lodge Airport
    Airport{IataCode{"JJN"}, CountryId{"CN"}, Timezone{4456}}, // Quanzhou Jinjiang Airport
    Airport{IataCode{"JKG"}, CountryId{"SE"}, Timezone{5822}}, // Jönköping Airport
    Airport{IataCode{"JKH"}, CountryId{"GR"}, Timezone{5169}}, // Chios Island National Airport
    Airport{IataCode{"JKL"}, CountryId{"GR"}, Timezone{5169}}, // Kalymnos Island National Airport
    Airport{IataCode{"JKR"}, CountryId{"NP"}, Timezone{4129}}, // Janakpur Airport
    Airport{IataCode{"JKV"}, CountryId{"US"}, Timezone{1510}}, // Cherokee County Airport
    Airport{IataCode{"JLN"}, CountryId{"US"}, Timezone{1510}}, // Joplin Regional Airport
    Airport{IataCode{"JLR"}, CountryId{"IN"}, Timezone{4129}}, // Jabalpur Airport
    Airport{IataCode{"JMB"}, CountryId{"AO"}, Timezone{505}}, // Jamba Airport
    Airport{IataCode{"JMJ"}, CountryId{"CN"}, Timezone{4456}}, // Lancang Airport
    Airport{IataCode{"JMK"}, CountryId{"GR"}, Timezone{5169}}, // Mykonos Island National Airport
    Airport{IataCode{"JMO"}, CountryId{"NP"}, Timezone{4100}}, // Jomsom Airport
    Airport{IataCode{"JMS"}, CountryId{"US"}, Timezone{1510}}, // Jamestown Regional Airport
    Airport{IataCode{"JMU"}, CountryId{"CN"}, Timezone{4456}}, // Jiamusi Dongjiao Airport
    Airport{IataCode{"JNA"}, CountryId{"BR"}, Timezone{3216}}, // Januaria Airport
    Airport{IataCode{"JNB"}, CountryId{"ZA"}, Timezone{369}}, // OR Tambo International Airport
    Airport{IataCode{"JNG"}, CountryId{"CN"}, Timezone{4456}}, // Jining Qufu Airport
    Airport{IataCode{"JNI"}, CountryId{"AR"}, Timezone{883}}, // Junín Airport
    Airport{IataCode{"JNJ"}, CountryId{"OM"}, Timezone{4252}}, // Duqm Jaaluni Airport
    Airport{IataCode{"JNU"}, CountryId{"US"}, Timezone{2260}}, // Juneau International Airport
    Airport{IataCode{"JNX"}, CountryId{"GR"}, Timezone{5169}}, // Naxos Island National Airport
    Airport{IataCode{"JNZ"}, CountryId{"CN"}, Timezone{4456}}, // Jinzhou Bay Airport
    Airport{IataCode{"JOE"}, CountryId{"FI"}, Timezone{5377}}, // Joensuu Airport
    Airport{IataCode{"JOG"}, CountryId{"ID"}, Timezone{4032}}, // Adisucipto International Airport
    Airport{IataCode{"JOI"}, CountryId{"BR"}, Timezone{3216}}, // Joinville-Lauro Carneiro de Loyola Airport
    Airport{IataCode{"JOJ"}, CountryId{"CA"}, Timezone{1405}}, // Doris Lake Aerodrome
    Airport{IataCode{"JOK"}, CountryId{"RU"}, Timezone{5620}}, // Yoshkar-Ola Airport
    Airport{IataCode{"JOL"}, CountryId{"PH"}, Timezone{4240}}, // Jolo Airport
    Airport{IataCode{"JON"}, CountryId{"US"}, Timezone{6446}}, // Johnston Atoll Airport
    Airport{IataCode{"JOS"}, CountryId{"NG"}, Timezone{462}}, // Yakubu Gowon Airport
    Airport{IataCode{"JOT"}, CountryId{"US"}, Timezone{1510}}, // Joliet Regional Airport
    Airport{IataCode{"JPA"}, CountryId{"BR"}, Timezone{1789}}, // Presidente Castro Pinto International Airport
    Airport{IataCode{"JPR"}, CountryId{"BR"}, Timezone{2992}}, // Ji-Paraná Airport
    Airport{IataCode{"JQA"}, CountryId{"GL"}, Timezone{1825}}, // Qaarsut Airport
    Airport{IataCode{"JQE"}, CountryId{"PA"}, Timezone{2877}}, // Jaqué Airport
    Airport{IataCode{"JQF"}, CountryId{"US"}, Timezone{2712}}, // Concord Regional Airport
    Airport{IataCode{"JRF"}, CountryId{"US"}, Timezone{6446}}, // Kalaeloa Airport
    Airport{IataCode{"JRH"}, CountryId{"IN"}, Timezone{4129}}, // Jorhat Airport
    Airport{IataCode{"JRN"}, CountryId{"BR"}, Timezone{1579}}, // Juruena Airport
    Airport{IataCode{"JRO"}, CountryId{"TZ"}, Timezone{256}}, // Kilimanjaro International Airport
    Airport{IataCode{"JRZ"}, CountryId{"AR"}, Timezone{883}}, // Benito Juárez Airport, Argentina
    Airport{IataCode{"JSA"}, CountryId{"IN"}, Timezone{4129}}, // Jharsuguda Airport
    Airport{IataCode{"JSH"}, CountryId{"GR"}, Timezone{5169}}, // Sitia Public Airport
    Airport{IataCode{"JSI"}, CountryId{"GR"}, Timezone{5169}}, // Skiathos Island National Airport
    Airport{IataCode{"JSJ"}, CountryId{"CN"}, Timezone{4456}}, // Jiansanjiang Airport
    Airport{IataCode{"JSM"}, CountryId{"AR"}, Timezone{914}}, // José de San Martín Airport
    Airport{IataCode{"JSR"}, CountryId{"BD"}, Timezone{3881}}, // Jessore Airport
    Airport{IataCode{"JST"}, CountryId{"US"}, Timezone{2712}}, // Johnstown–Cambria County Airport
    Airport{IataCode{"JSU"}, CountryId{"GL"}, Timezone{1825}}, // Maniitsoq Airport
    Airport{IataCode{"JSV"}, CountryId{"US"}, Timezone{1510}}, // Sallisaw Municipal Airport
    Airport{IataCode{"JSY"}, CountryId{"GR"}, Timezone{5169}}, // Syros Island National Airport
    Airport{IataCode{"JTC"}, CountryId{"BR"}, Timezone{3216}}, // Bauru-Arealva Airport
    Airport{IataCode{"JTI"}, CountryId{"BR"}, Timezone{3216}}, // Jataí Airport
    Airport{IataCode{"JTR"}, CountryId{"GR"}, Timezone{5169}}, // Santorini (Thira) National Airport
    Airport{IataCode{"JTY"}, CountryId{"GR"}, Timezone{5169}}, // Astypalaia Island National Airport
    Airport{IataCode{"JUA"}, CountryId{"BR"}, Timezone{1579}}, // Juara Airport
    Airport{IataCode{"JUB"}, CountryId{"SS"}, Timezone{389}}, // Juba International Airport
    Airport{IataCode{"JUH"}, CountryId{"CN"}, Timezone{4456}}, // Chizhou Jiuhuashan Airport
    Airport{IataCode{"JUI"}, CountryId{"DE"}, Timezone{5199}}, // Juist Airport
    Airport{IataCode{"JUJ"}, CountryId{"AR"}, Timezone{992}}, // Gobernador Horacio Guzmán International Airport
    Airport{IataCode{"JUL"}, CountryId{"PE"}, Timezone{2365}}, // Inca Manco Cápac International Airport
    Airport{IataCode{"JUM"}, CountryId{"NP"}, Timezone{4100}}, // Jumla Airport
    Airport{IataCode{"JUR"}, CountryId{"AU"}, Timezone{5087}}, // Jurien Bay Airport
    Airport{IataCode{"JUS"}, CountryId{"AR"}, Timezone{883}}, // Aeroclub Argentino
    Airport{IataCode{"JUV"}, CountryId{"GL"}, Timezone{1825}}, // Upernavik Airport
    Airport{IataCode{"JUZ"}, CountryId{"CN"}, Timezone{4456}}, // Quzhou Airport
    Airport{IataCode{"JVA"}, CountryId{"MG"}, Timezone{6035}}, // Ankavandra Airport
    Airport{IataCode{"JVI"}, CountryId{"US"}, Timezone{2712}}, // Central Jersey Regional Airport
    Airport{IataCode{"JVL"}, CountryId{"US"}, Timezone{1510}}, // Southern Wisconsin Regional Airport
    Airport{IataCode{"JVM"}, CountryId{"US"}, Timezone{814}}, // Jonesville Mine Airport
    Airport{IataCode{"JVW"}, CountryId{"US"}, Timezone{1510}}, // John Bell Williams Airport
    Airport{IataCode{"JVY"}, CountryId{"US"}, Timezone{2275}}, // Clark Regional Airport
    Airport{IataCode{"JWA"}, CountryId{"BW"}, Timezone{339}}, // Jwaneng Airport
    Airport{IataCode{"JWG"}, CountryId{"US"}, Timezone{1510}}, // Watonga Regional Airport
    Airport{IataCode{"JWN"}, CountryId{"IR"}, Timezone{4543}}, // Zanjan Airport
    Airport{IataCode{"JXA"}, CountryId{"CN"}, Timezone{4456}}, // Jixi Xingkaihu Airport
    Airport{IataCode{"JXN"}, CountryId{"US"}, Timezone{1682}}, // Jackson County Airport
    Airport{IataCode{"JYM"}, CountryId{"US"}, Timezone{1682}}, // Hillsdale Municipal Airport
    Airport{IataCode{"JYO"}, CountryId{"US"}, Timezone{2712}}, // Leesburg Executive Airport
    Airport{IataCode{"JYR"}, CountryId{"IR"}, Timezone{4543}}, // Jiroft Airport
    Airport{IataCode{"JYV"}, CountryId{"FI"}, Timezone{5377}}, // Jyväskylä Airport
    Airport{IataCode{"JZH"}, CountryId{"CN"}, Timezone{4456}}, // Jiuzhai Huanglong Airport
    Airport{IataCode{"JZI"}, CountryId{"US"}, Timezone{2712}}, // Charleston Executive Airport
    Airport{IataCode{"JZP"}, CountryId{"US"}, Timezone{2712}}, // Pickens County Airport
    Airport{IataCode{"KAA"}, CountryId{"ZM"}, Timezone{537}}, // Kasama Airport
    Airport{IataCode{"KAB"}, CountryId{"ZW"}, Timezone{537}}, // Kariba Airport
    Airport{IataCode{"KAC"}, CountryId{"SY"}, Timezone{3867}}, // Qamishli Airport
    Airport{IataCode{"KAD"}, CountryId{"NG"}, Timezone{462}}, // Kaduna Airport
    Airport{IataCode{"KAE"}, CountryId{"US"}, Timezone{3255}}, // Kake Seaplane Base
    Airport{IataCode{"KAI"}, CountryId{"GY"}, Timezone{1949}}, // Kaieteur International Airport
    Airport{IataCode{"KAJ"}, CountryId{"FI"}, Timezone{5377}}, // Kajaani Airport
    Airport{IataCode{"KAL"}, CountryId{"US"}, Timezone{814}}, // Kaltag Airport
    Airport{IataCode{"KAM"}, CountryId{"YE"}, Timezone{3634}}, // Kamaran Airport
    Airport{IataCode{"KAN"}, CountryId{"NG"}, Timezone{462}}, // Mallam Aminu Kano International Airport
    Airport{IataCode{"KAO"}, CountryId{"FI"}, Timezone{5377}}, // Kuusamo Airport
    Airport{IataCode{"KAP"}, CountryId{"CD"}, Timezone{519}}, // Kapanga Airport
    Airport{IataCode{"KAR"}, CountryId{"GY"}, Timezone{1949}}, // Kamarang Airport
    Airport{IataCode{"KAS"}, CountryId{"NA"}, Timezone{785}}, // Karasburg Airport
    Airport{IataCode{"KAT"}, CountryId{"NZ"}, Timezone{6218}}, // Kaitaia Airport
    Airport{IataCode{"KAW"}, CountryId{"MM"}, Timezone{4678}}, // Kawthaung Airport
    Airport{IataCode{"KAX"}, CountryId{"AU"}, Timezone{5087}}, // Kalbarri Airport
    Airport{IataCode{"KBA"}, CountryId{"SL"}, Timezone{323}}, // Kabala Airport
    Airport{IataCode{"KBC"}, CountryId{"US"}, Timezone{814}}, // Birch Creek Airport
    Airport{IataCode{"KBG"}, CountryId{"UG"}, Timezone{401}}, // Kabalega Falls Airport
    Airport{IataCode{"KBI"}, CountryId{"CM"}, Timezone{293}}, // Kribi Airport
    Airport{IataCode{"KBL"}, CountryId{"AF"}, Timezone{4061}}, // Hamid Karzai International Airport
    Airport{IataCode{"KBN"}, CountryId{"CD"}, Timezone{519}}, // Tunta Airport
    Airport{IataCode{"KBO"}, CountryId{"CD"}, Timezone{519}}, // Kabalo Airport
    Airport{IataCode{"KBP"}, CountryId{"UA"}, Timezone{5461}}, // Boryspil International Airport
    Airport{IataCode{"KBQ"}, CountryId{"MW"}, Timezone{132}}, // Kasungu Airport
    Airport{IataCode{"KBR"}, CountryId{"MY"}, Timezone{3777}}, // Sultan Ismail Petra Airport
    Airport{IataCode{"KBS"}, CountryId{"SL"}, Timezone{323}}, // Bo Airport
    Airport{IataCode{"KBU"}, CountryId{"ID"}, Timezone{4226}}, // Gusti Syamsir Alam Airport
    Airport{IataCode{"KBV"}, CountryId{"TH"}, Timezone{3777}}, // Krabi Airport
    Airport{IataCode{"KBW"}, CountryId{"US"}, Timezone{814}}, // Chignik Bay Seaplane Base
    Airport{IataCode{"KBY"}, CountryId{"AU"}, Timezone{4901}}, // Streaky Bay Airport
    Airport{IataCode{"KBZ"}, CountryId{"NZ"}, Timezone{6218}}, // Kaikoura Aerodrome
    Airport{IataCode{"KCA"}, CountryId{"CN"}, Timezone{4607}}, // Kuqa Qiuci Airport
    Airport{IataCode{"KCB"}, CountryId{"SR"}, Timezone{2912}}, // Tepoe Airstrip
    Airport{IataCode{"KCC"}, CountryId{"US"}, Timezone{3255}}, // Coffman Cove Seaplane Base
    Airport{IataCode{"KCF"}, CountryId{"PK"}, Timezone{4087}}, // Kadanwari Airport
    Airport{IataCode{"KCG"}, CountryId{"US"}, Timezone{814}}, // Chignik Fisheries Airport
    Airport{IataCode{"KCH"}, CountryId{"MY"}, Timezone{4190}}, // Kuching International Airport
    Airport{IataCode{"KCK"}, CountryId{"RU"}, Timezone{4006}}, // Kirensk Airport
    Airport{IataCode{"KCL"}, CountryId{"US"}, Timezone{814}}, // Chignik Lagoon Airport
    Airport{IataCode{"KCM"}, CountryId{"TR"}, Timezone{5412}}, // Kahramanmaraş Airport
    Airport{IataCode{"KCQ"}, CountryId{"US"}, Timezone{814}}, // Chignik Lake Airport
    Airport{IataCode{"KCT"}, CountryId{"LK"}, Timezone{3854}}, // SLAF Koggala
    Airport{IataCode{"KCU"}, CountryId{"UG"}, Timezone{401}}, // Masindi Airport
    Airport{IataCode{"KCZ"}, CountryId{"JP"}, Timezone{4568}}, // Kōchi Airport
    Airport{IataCode{"KDA"}, CountryId{"SN"}, Timezone{243}}, // Kolda North Airport
    Airport{IataCode{"KDB"}, CountryId{"AU"}, Timezone{5087}}, // Kambalda Airport
    Airport{IataCode{"KDC"}, CountryId{"BJ"}, Timezone{723}}, // Kandi Airport
    Airport{IataCode{"KDD"}, CountryId{"PK"}, Timezone{4087}}, // Khuzdar Airport
    Airport{IataCode{"KDH"}, CountryId{"AF"}, Timezone{4061}}, // Kandahar International Airport
    Airport{IataCode{"KDI"}, CountryId{"ID"}, Timezone{4226}}, // Haluoleo Airport
    Airport{IataCode{"KDJ"}, CountryId{"GA"}, Timezone{475}}, // Ndjolé Ville Airport
    Airport{IataCode{"KDK"}, CountryId{"US"}, Timezone{814}}, // Kodiak Municipal Airport
    Airport{IataCode{"KDL"}, CountryId{"EE"}, Timezone{5839}}, // Kärdla Airport
    Airport{IataCode{"KDM"}, CountryId{"MV"}, Timezone{}}, // Kaadedhdhoo Airport
    Airport{IataCode{"KDN"}, CountryId{"GA"}, Timezone{475}}, // Ndendé Airport
    Airport{IataCode{"KDO"}, CountryId{"MV"}, Timezone{6142}}, // Kadhdhoo Airport
    Airport{IataCode{"KDR"}, CountryId{"PG"}, Timezone{6686}}, // Kandrian Airport
    Airport{IataCode{"KDU"}, CountryId{"PK"}, Timezone{4087}}, // Skardu Airport
    Airport{IataCode{"KDV"}, CountryId{"FJ"}, Timezone{6349}}, // Vunisea Airport
    Airport{IataCode{"KDX"}, CountryId{"SD"}, Timezone{432}}, // Kadugli Airport
    Airport{IataCode{"KDY"}, CountryId{"RU"}, Timezone{4115}}, // Teply Klyuch Airport
    Airport{IataCode{"KEB"}, CountryId{"US"}, Timezone{814}}, // Nanwalek Airport
    Airport{IataCode{"KED"}, CountryId{"MR"}, Timezone{686}}, // Kaédi Airport
    Airport{IataCode{"KEE"}, CountryId{"CG"}, Timezone{148}}, // Kelle Airport
    Airport{IataCode{"KEF"}, CountryId{"IS"}, Timezone{4823}}, // Keflavík International Airport
    Airport{IataCode{"KEH"}, CountryId{"US"}, Timezone{2378}}, // Kenmore Air Harbor
    Airport{IataCode{"KEJ"}, CountryId{"RU"}, Timezone{4277}}, // Kemerovo International Airport
    Airport{IataCode{"KEK"}, CountryId{"US"}, Timezone{814}}, // Ekwok Airport
    Airport{IataCode{"KEM"}, CountryId{"FI"}, Timezone{5377}}, // Kemi-Tornio Airport
    Airport{IataCode{"KEN"}, CountryId{"SL"}, Timezone{323}}, // Kenema Airport
    Airport{IataCode{"KEO"}, CountryId{"CI"}, Timezone{0}}, // Odienné Airport
    Airport{IataCode{"KEP"}, CountryId{"NP"}, Timezone{}}, // Nepalgunj Airport
    Airport{IataCode{"KER"}, CountryId{"IR"}, Timezone{4543}}, // Kerman Airport
    Airport{IataCode{"KES"}, CountryId{"CA"}, Timezone{3540}}, // Kelsey Airport
    Airport{IataCode{"KET"}, CountryId{"MM"}, Timezone{4678}}, // Kengtung Airport
    Airport{IataCode{"KEU"}, CountryId{"KE"}, Timezone{641}}, // Keekorok Airport
    Airport{IataCode{"KEW"}, CountryId{"CA"}, Timezone{3540}}, // Keewaywin Airport
    Airport{IataCode{"KEY"}, CountryId{"KE"}, Timezone{641}}, // Kericho Airport
    Airport{IataCode{"KFA"}, CountryId{"MR"}, Timezone{686}}, // Kiffa Airport
    Airport{IataCode{"KFE"}, CountryId{"AU"}, Timezone{5087}}, // Fortescue Dave Forrest Airport
    Airport{IataCode{"KFG"}, CountryId{"AU"}, Timezone{4978}}, // Kalkgurung Airport
    Airport{IataCode{"KFP"}, CountryId{"US"}, Timezone{2745}}, // False Pass Airport
    Airport{IataCode{"KFS"}, CountryId{"TR"}, Timezone{5412}}, // Kastamonu Airport
    Airport{IataCode{"KGA"}, CountryId{"CD"}, Timezone{519}}, // Kananga Airport
    Airport{IataCode{"KGC"}, CountryId{"AU"}, Timezone{4901}}, // Kingscote Airport
    Airport{IataCode{"KGD"}, CountryId{"RU"}, Timezone{5442}}, // Khrabrovo Airport
    Airport{IataCode{"KGE"}, CountryId{"SB"}, Timezone{6413}}, // Kaghau Airport
    Airport{IataCode{"KGF"}, CountryId{"KZ"}, Timezone{3644}}, // Sary-Arka Airport
    Airport{IataCode{"KGG"}, CountryId{"SN"}, Timezone{243}}, // Kédougou Airport
    Airport{IataCode{"KGI"}, CountryId{"AU"}, Timezone{5087}}, // Kalgoorlie-Boulder Airport
    Airport{IataCode{"KGJ"}, CountryId{"MW"}, Timezone{132}}, // Karonga Airport
    Airport{IataCode{"KGK"}, CountryId{"US"}, Timezone{814}}, // Koliganek Airport
    Airport{IataCode{"KGL"}, CountryId{"RW"}, Timezone{432}}, // Kigali International Airport
    Airport{IataCode{"KGN"}, CountryId{"CD"}, Timezone{505}}, // Kasongo Lunda Airport
    Airport{IataCode{"KGP"}, CountryId{"RU"}, Timezone{4690}}, // Kogalym International Airport
    Airport{IataCode{"KGS"}, CountryId{"GR"}, Timezone{5169}}, // Kos Island International Airport
    Airport{IataCode{"KGT"}, CountryId{"CN"}, Timezone{4456}}, // Kangding Airport
    Airport{IataCode{"KGU"}, CountryId{"MY"}, Timezone{4190}}, // Keningau Airport
    Airport{IataCode{"KGX"}, CountryId{"US"}, Timezone{814}}, // Grayling Airport
    Airport{IataCode{"KGY"}, CountryId{"AU"}, Timezone{4920}}, // Kingaroy Airport
    Airport{IataCode{"KHC"}, CountryId{"RU"}, Timezone{5777}}, // Kerch Airport
    Airport{IataCode{"KHD"}, CountryId{"IR"}, Timezone{4543}}, // Khorramabad Airport
    Airport{IataCode{"KHE"}, CountryId{"UA"}, Timezone{5461}}, // Kherson International Airport
    Airport{IataCode{"KHG"}, CountryId{"CN"}, Timezone{4607}}, // Kashgar Airport
    Airport{IataCode{"KHH"}, CountryId{"TW"}, Timezone{4504}}, // Kaohsiung International Airport
    Airport{IataCode{"KHI"}, CountryId{"PK"}, Timezone{4087}}, // Jinnah International Airport
    Airport{IataCode{"KHK"}, CountryId{"IR"}, Timezone{4543}}, // Khark Airport
    Airport{IataCode{"KHM"}, CountryId{"MM"}, Timezone{4678}}, // Khamti Airport
    Airport{IataCode{"KHN"}, CountryId{"CN"}, Timezone{4456}}, // Nanchang Changbei International Airport
    Airport{IataCode{"KHR"}, CountryId{"MN"}, Timezone{4590}}, // Kharkhorin Airport
    Airport{IataCode{"KHS"}, CountryId{"OM"}, Timezone{4252}}, // Khasab Airport
    Airport{IataCode{"KHT"}, CountryId{"AF"}, Timezone{4061}}, // Khost Airfield
    Airport{IataCode{"KHU"}, CountryId{"UA"}, Timezone{5461}}, // Kremenchuk Airport
    Airport{IataCode{"KHV"}, CountryId{"RU"}, Timezone{4648}}, // Khabarovsk Novy Airport
    Airport{IataCode{"KHW"}, CountryId{"BW"}, Timezone{339}}, // Khwai River Airport
    Airport{IataCode{"KHY"}, CountryId{"IR"}, Timezone{4543}}, // Khoy Airport
    Airport{IataCode{"KIC"}, CountryId{"US"}, Timezone{2378}}, // Mesa Del Rey Airport
    Airport{IataCode{"KID"}, CountryId{"SE"}, Timezone{5822}}, // Kristianstad Airport
    Airport{IataCode{"KIE"}, CountryId{"PG"}, Timezone{6235}}, // Kieta Airport
    Airport{IataCode{"KIF"}, CountryId{"CA"}, Timezone{3540}}, // Kingfisher Lake Airport
    Airport{IataCode{"KIH"}, CountryId{"IR"}, Timezone{4543}}, // Kish International Airport
    Airport{IataCode{"KIJ"}, CountryId{"JP"}, Timezone{4568}}, // Niigata Airport
    Airport{IataCode{"KIM"}, CountryId{"ZA"}, Timezone{369}}, // Kimberley Airport
    Airport{IataCode{"KIN"}, CountryId{"JM"}, Timezone{2260}}, // Norman Manley International Airport
    Airport{IataCode{"KIO"}, CountryId{"MH"}, Timezone{}}, // Kili Airport
    Airport{IataCode{"KIP"}, CountryId{"US"}, Timezone{1510}}, // Kickapoo Downtown Airport
    Airport{IataCode{"KIR"}, CountryId{"IE"}, Timezone{5330}}, // Kerry Airport
    Airport{IataCode{"KIS"}, CountryId{"KE"}, Timezone{641}}, // Kisumu International Airport
    Airport{IataCode{"KIT"}, CountryId{"GR"}, Timezone{5169}}, // Kithira Island National Airport "Alexandros Aristotelous Onassis"
    Airport{IataCode{"KIV"}, CountryId{"MD"}, Timezone{5296}}, // Chișinău International Airport
    Airport{IataCode{"KIW"}, CountryId{"ZM"}, Timezone{537}}, // Southdowns Airport
    Airport{IataCode{"KIX"}, CountryId{"JP"}, Timezone{4568}}, // Kansai International Airport
    Airport{IataCode{"KIY"}, CountryId{"TZ"}, Timezone{256}}, // Kilwa Masoko Airport
    Airport{IataCode{"KJA"}, CountryId{"BD"}, Timezone{3881}}, // Khan Jahan Ali Airport
    Airport{IataCode{"KJH"}, CountryId{"CN"}, Timezone{4456}}, // Kaili Huangping Airport
    Airport{IataCode{"KJI"}, CountryId{"CN"}, Timezone{4607}}, // Kanas Airport
    Airport{IataCode{"KJK"}, CountryId{"BE"}, Timezone{5231}}, // Kortrijk-Wevelgem International Airport
    Airport{IataCode{"KJP"}, CountryId{"JP"}, Timezone{4568}}, // Kerama Airport
    Airport{IataCode{"KKA"}, CountryId{"US"}, Timezone{814}}, // Koyuk Alfred Adams Airport
    Airport{IataCode{"KKB"}, CountryId{"US"}, Timezone{814}}, // Kitoi Bay Seaplane Base
    Airport{IataCode{"KKC"}, CountryId{"TH"}, Timezone{3777}}, // Khon Kaen Airport
    Airport{IataCode{"KKD"}, CountryId{"PG"}, Timezone{6686}}, // Kokoda Airport
    Airport{IataCode{"KKE"}, CountryId{"NZ"}, Timezone{6218}}, // Kerikeri Airport
    Airport{IataCode{"KKH"}, CountryId{"US"}, Timezone{2745}}, // Kongiganak Airport
    Airport{IataCode{"KKI"}, CountryId{"US"}, Timezone{814}}, // Akiachak Airport
    Airport{IataCode{"KKJ"}, CountryId{"JP"}, Timezone{4568}}, // Kitakyushu Airport
    Airport{IataCode{"KKN"}, CountryId{"NO"}, Timezone{5634}}, // Kirkenes Airport, Høybuktmoen
    Airport{IataCode{"KKO"}, CountryId{"NZ"}, Timezone{6218}}, // Kaikohe Aerodrome
    Airport{IataCode{"KKR"}, CountryId{"FR"}, Timezone{6740}}, // Kaukura Airport
    Airport{IataCode{"KKT"}, CountryId{"US"}, Timezone{1510}}, // Kentland Municipal Airport
    Airport{IataCode{"KKW"}, CountryId{"CD"}, Timezone{446}}, // Kikwit Airport
    Airport{IataCode{"KKX"}, CountryId{"JP"}, Timezone{4568}}, // Kikai Airport
    Airport{IataCode{"KKY"}, CountryId{"IE"}, Timezone{5330}}, // Kilkenny Airport
    Airport{IataCode{"KKZ"}, CountryId{"KH"}, Timezone{3777}}, // Koh Kong Airport
    Airport{IataCode{"KLA"}, CountryId{"UG"}, Timezone{401}}, // Kampala Airport
    Airport{IataCode{"KLB"}, CountryId{"ZM"}, Timezone{537}}, // Kalabo Airport
    Airport{IataCode{"KLC"}, CountryId{"SN"}, Timezone{243}}, // Kaolack Airport
    Airport{IataCode{"KLD"}, CountryId{"RU"}, Timezone{5620}}, // Migalovo
    Airport{IataCode{"KLE"}, CountryId{"CM"}, Timezone{293}}, // Kaélé Airport
    Airport{IataCode{"KLF"}, CountryId{"RU"}, Timezone{5620}}, // "Kaluga" (Grabtsevo) Airport
    Airport{IataCode{"KLG"}, CountryId{"US"}, Timezone{814}}, // Kalskag Airport
    Airport{IataCode{"KLH"}, CountryId{"IN"}, Timezone{4129}}, // Kolhapur Airport
    Airport{IataCode{"KLJ"}, CountryId{"LT"}, Timezone{5943}}, // Klaipėda Airport
    Airport{IataCode{"KLK"}, CountryId{"KE"}, Timezone{641}}, // Kalokol Airport
    Airport{IataCode{"KLL"}, CountryId{"US"}, Timezone{814}}, // Levelock Airport
    Airport{IataCode{"KLM"}, CountryId{"IR"}, Timezone{4543}}, // Kalaleh Airport
    Airport{IataCode{"KLN"}, CountryId{"US"}, Timezone{814}}, // Larsen Bay Airport
    Airport{IataCode{"KLO"}, CountryId{"PH"}, Timezone{4240}}, // Kalibo International Airport
    Airport{IataCode{"KLP"}, CountryId{"ID"}, Timezone{4348}}, // Seruyan Kuala Pembuang Airport
    Airport{IataCode{"KLR"}, CountryId{"SE"}, Timezone{5822}}, // Kalmar Airport
    Airport{IataCode{"KLS"}, CountryId{"US"}, Timezone{2378}}, // Southwest Washington Regional Airport
    Airport{IataCode{"KLU"}, CountryId{"AT"}, Timezone{5929}}, // Klagenfurt Airport
    Airport{IataCode{"KLV"}, CountryId{"CZ"}, Timezone{5676}}, // Karlovy Vary Airport
    Airport{IataCode{"KLW"}, CountryId{"US"}, Timezone{3255}}, // Klawock Airport
    Airport{IataCode{"KLX"}, CountryId{"GR"}, Timezone{5169}}, // Kalamata International Airport
    Airport{IataCode{"KLY"}, CountryId{"CD"}, Timezone{519}}, // Kinkungwa Airport
    Airport{IataCode{"KLZ"}, CountryId{"ZA"}, Timezone{369}}, // Kleinzee Airport
    Airport{IataCode{"KMA"}, CountryId{"PG"}, Timezone{6686}}, // Kerema Airport
    Airport{IataCode{"KMC"}, CountryId{"SA"}, Timezone{4404}}, // Hafar Al-Batin Domestic Airport
    Airport{IataCode{"KME"}, CountryId{"RW"}, Timezone{519}}, // Kamembe Airport
    Airport{IataCode{"KMG"}, CountryId{"CN"}, Timezone{4456}}, // Kunming Changshui International Airport
    Airport{IataCode{"KMH"}, CountryId{"ZA"}, Timezone{369}}, // Johan Pienaar Airport
    Airport{IataCode{"KMI"}, CountryId{"JP"}, Timezone{4568}}, // Miyazaki Airport
    Airport{IataCode{"KMJ"}, CountryId{"JP"}, Timezone{4568}}, // Kumamoto Airport
    Airport{IataCode{"KMK"}, CountryId{"CG"}, Timezone{148}}, // Makabana Airport
    Airport{IataCode{"KMN"}, CountryId{"CD"}, Timezone{519}}, // Kamina Airport
    Airport{IataCode{"KMO"}, CountryId{"US"}, Timezone{814}}, // Manokotak Airport
    Airport{IataCode{"KMP"}, CountryId{"NA"}, Timezone{785}}, // Keetmanshoop Airport
    Airport{IataCode{"KMQ"}, CountryId{"JP"}, Timezone{4568}}, // Komatsu Airport
    Airport{IataCode{"KMS"}, CountryId{"GH"}, Timezone{15}}, // Kumasi Airport
    Airport{IataCode{"KMT"}, CountryId{"KH"}, Timezone{4332}}, // Kampot Airport
    Airport{IataCode{"KMU"}, CountryId{"SO"}, Timezone{608}}, // Kismayo Airport
    Airport{IataCode{"KMV"}, CountryId{"MM"}, Timezone{4678}}, // Kalaymyo Airport
    Airport{IataCode{"KMW"}, CountryId{"RU"}, Timezone{5620}}, // Kostroma Airport
    Airport{IataCode{"KMY"}, CountryId{"US"}, Timezone{814}}, // Moser Bay Seaplane Base
    Airport{IataCode{"KMZ"}, CountryId{"ZM"}, Timezone{537}}, // Kaoma Airport
    Airport{IataCode{"KNA"}, CountryId{"CL"}, Timezone{3177}}, // Viña del Mar Airport
    Airport{IataCode{"KNB"}, CountryId{"US"}, Timezone{1667}}, // Kanab Municipal Airport
    Airport{IataCode{"KND"}, CountryId{"CD"}, Timezone{519}}, // Kindu Airport
    Airport{IataCode{"KNG"}, CountryId{"ID"}, Timezone{4032}}, // Kaimana Airport
    Airport{IataCode{"KNH"}, CountryId{"TW"}, Timezone{4456}}, // Kinmen Airport
    Airport{IataCode{"KNI"}, CountryId{"AU"}, Timezone{5087}}, // Katanning Airport
    Airport{IataCode{"KNJ"}, CountryId{"CG"}, Timezone{148}}, // Kindamba Airport
    Airport{IataCode{"KNK"}, CountryId{"US"}, Timezone{814}}, // Kokhanok Airport
    Airport{IataCode{"KNM"}, CountryId{"CD"}, Timezone{519}}, // Kaniama Airport
    Airport{IataCode{"KNN"}, CountryId{"GN"}, Timezone{228}}, // Kankan Airport
    Airport{IataCode{"KNO"}, CountryId{"ID"}, Timezone{4032}}, // Kuala Namu International Airport
    Airport{IataCode{"KNP"}, CountryId{"AO"}, Timezone{505}}, // Kapanda Airport
    Airport{IataCode{"KNQ"}, CountryId{"FR"}, Timezone{6606}}, // Koné Airport
    Airport{IataCode{"KNS"}, CountryId{"AU"}, Timezone{4961}}, // King Island Airport
    Airport{IataCode{"KNT"}, CountryId{"US"}, Timezone{1510}}, // Kennett Memorial Airport
    Airport{IataCode{"KNU"}, CountryId{"IN"}, Timezone{4129}}, // Kanpur Airport
    Airport{IataCode{"KNW"}, CountryId{"US"}, Timezone{814}}, // New Stuyahok Airport
    Airport{IataCode{"KNX"}, CountryId{"AU"}, Timezone{5087}}, // Kununurra Airport
    Airport{IataCode{"KNZ"}, CountryId{"ML"}, Timezone{243}}, // Kéniéba Airport
    Airport{IataCode{"KOA"}, CountryId{"US"}, Timezone{6446}}, // Kona International Airport
    Airport{IataCode{"KOC"}, CountryId{"FR"}, Timezone{6606}}, // Koumac Airport
    Airport{IataCode{"KOE"}, CountryId{"ID"}, Timezone{4226}}, // El Tari Airport
    Airport{IataCode{"KOI"}, CountryId{"GB"}, Timezone{5517}}, // Kirkwall Airport
    Airport{IataCode{"KOJ"}, CountryId{"JP"}, Timezone{4568}}, // Kagoshima Airport
    Airport{IataCode{"KOK"}, CountryId{"FI"}, Timezone{5377}}, // Kokkola-Pietarsaari Airport
    Airport{IataCode{"KOL"}, CountryId{"CF"}, Timezone{104}}, // Koumala Airport
    Airport{IataCode{"KOO"}, CountryId{"CD"}, Timezone{519}}, // Kongolo Airport
    Airport{IataCode{"KOP"}, CountryId{"TH"}, Timezone{3777}}, // Nakhon Phanom Airport
    Airport{IataCode{"KOQ"}, CountryId{"DE"}, Timezone{5199}}, // Köthen Airport
    Airport{IataCode{"KOS"}, CountryId{"KH"}, Timezone{4332}}, // Sihanoukville International Airport
    Airport{IataCode{"KOT"}, CountryId{"US"}, Timezone{2745}}, // Kotlik Airport
    Airport{IataCode{"KOU"}, CountryId{"GA"}, Timezone{475}}, // Koulamoutou Airport
    Airport{IataCode{"KOV"}, CountryId{"KZ"}, Timezone{3644}}, // Kokshetau Airport
    Airport{IataCode{"KOW"}, CountryId{"CN"}, Timezone{4456}}, // Ganzhou Huangjin Airport
    Airport{IataCode{"KOY"}, CountryId{"US"}, Timezone{814}}, // Olga Bay Seaplane Base
    Airport{IataCode{"KOZ"}, CountryId{"US"}, Timezone{814}}, // Ouzinkie Airport
    Airport{IataCode{"KPB"}, CountryId{"US"}, Timezone{3255}}, // Point Baker Seaplane Base
    Airport{IataCode{"KPC"}, CountryId{"US"}, Timezone{2745}}, // Port Clarence Coast Guard Station
    Airport{IataCode{"KPI"}, CountryId{"MY"}, Timezone{4190}}, // Kapit Airport
    Airport{IataCode{"KPN"}, CountryId{"US"}, Timezone{2745}}, // Kipnuk Airport
    Airport{IataCode{"KPO"}, CountryId{"KR"}, Timezone{4445}}, // Pohang Airport
    Airport{IataCode{"KPR"}, CountryId{"US"}, Timezone{814}}, // Port Williams Seaplane Base
    Airport{IataCode{"KPS"}, CountryId{"AU"}, Timezone{5103}}, // Kempsey Airport
    Airport{IataCode{"KPT"}, CountryId{"US"}, Timezone{1391}}, // Jackpot Airport
    Airport{IataCode{"KPV"}, CountryId{"US"}, Timezone{814}}, // Perryville Airport
    Airport{IataCode{"KPW"}, CountryId{"RU"}, Timezone{3667}}, // Keperveyem Airport
    Airport{IataCode{"KPY"}, CountryId{"US"}, Timezone{814}}, // Port Bailey Seaplane Base
    Airport{IataCode{"KQA"}, CountryId{"US"}, Timezone{2745}}, // Akutan Airport
    Airport{IataCode{"KQR"}, CountryId{"AU"}, Timezone{5087}}, // Karara Airport
    Airport{IataCode{"KQT"}, CountryId{"TJ"}, Timezone{3913}}, // Qurghonteppa International Airport
    Airport{IataCode{"KRA"}, CountryId{"AU"}, Timezone{5067}}, // Kerang Airport
    Airport{IataCode{"KRB"}, CountryId{"AU"}, Timezone{4920}}, // Karumba Airport
    Airport{IataCode{"KRC"}, CountryId{"ID"}, Timezone{4032}}, // Depati Parbo Airport
    Airport{IataCode{"KRE"}, CountryId{"BI"}, Timezone{432}}, // Kirundo Airport
    Airport{IataCode{"KRF"}, CountryId{"SE"}, Timezone{5822}}, // Kramfors-Sollefteå Airport
    Airport{IataCode{"KRG"}, CountryId{"GY"}, Timezone{1358}}, // Karasabai Airport
    Airport{IataCode{"KRH"}, CountryId{"GB"}, Timezone{5517}}, // Redhill Aerodrome
    Airport{IataCode{"KRI"}, CountryId{"PG"}, Timezone{6686}}, // Kikori Airport
    Airport{IataCode{"KRK"}, CountryId{"PL"}, Timezone{5975}}, // John Paul II International Airport Kraków-Balice
    Airport{IataCode{"KRL"}, CountryId{"CN"}, Timezone{4607}}, // Korla Airport
    Airport{IataCode{"KRM"}, CountryId{"GY"}, Timezone{1949}}, // Karanambo Airport
    Airport{IataCode{"KRN"}, CountryId{"SE"}, Timezone{5822}}, // Kiruna Airport
    Airport{IataCode{"KRO"}, CountryId{"RU"}, Timezone{4690}}, // Kurgan Airport
    Airport{IataCode{"KRP"}, CountryId{"DK"}, Timezone{5312}}, // Karup Airport
    Airport{IataCode{"KRR"}, CountryId{"RU"}, Timezone{5620}}, // Krasnodar International Airport
    Airport{IataCode{"KRS"}, CountryId{"NO"}, Timezone{5634}}, // Kristiansand Airport, Kjevik
    Airport{IataCode{"KRT"}, CountryId{"SD"}, Timezone{432}}, // Khartoum International Airport
    Airport{IataCode{"KRV"}, CountryId{"KE"}, Timezone{641}}, // Kimwarer Airport
    Airport{IataCode{"KRW"}, CountryId{"TM"}, Timezone{3702}}, // Turkmenbashi Airport
    Airport{IataCode{"KRY"}, CountryId{"CN"}, Timezone{4607}}, // Karamay Airport
    Airport{IataCode{"KRZ"}, CountryId{"CD"}, Timezone{446}}, // Basango Mboliasa Airport
    Airport{IataCode{"KSA"}, CountryId{"FM"}, Timezone{}}, // Kosrae International Airport
    Airport{IataCode{"KSC"}, CountryId{"SK"}, Timezone{5213}}, // Košice International Airport
    Airport{IataCode{"KSD"}, CountryId{"SE"}, Timezone{5822}}, // Karlstad Airport
    Airport{IataCode{"KSE"}, CountryId{"UG"}, Timezone{401}}, // Kasese Airport
    Airport{IataCode{"KSF"}, CountryId{"DE"}, Timezone{5199}}, // Kassel Airport
    Airport{IataCode{"KSH"}, CountryId{"IR"}, Timezone{4543}}, // Kermanshah Airport
    Airport{IataCode{"KSI"}, CountryId{"GN"}, Timezone{228}}, // Kissidougou Airport
    Airport{IataCode{"KSJ"}, CountryId{"GR"}, Timezone{5169}}, // Kassos Island Public Airport
    Airport{IataCode{"KSK"}, CountryId{"SE"}, Timezone{5822}}, // Karlskoga Airport
    Airport{IataCode{"KSL"}, CountryId{"SD"}, Timezone{432}}, // Kassala Airport
    Airport{IataCode{"KSM"}, CountryId{"US"}, Timezone{2745}}, // St. Mary's Airport
    Airport{IataCode{"KSN"}, CountryId{"KZ"}, Timezone{4389}}, // Kostanay Airport
    Airport{IataCode{"KSO"}, CountryId{"GR"}, Timezone{5169}}, // Kastoria National Airport
    Airport{IataCode{"KSQ"}, CountryId{"UZ"}, Timezone{4430}}, // Karshi Airport
    Airport{IataCode{"KSR"}, CountryId{"ID"}, Timezone{4226}}, // H. Aroeppala Airport
    Airport{IataCode{"KSS"}, CountryId{"ML"}, Timezone{76}}, // Sikasso Airport
    Airport{IataCode{"KST"}, CountryId{"SD"}, Timezone{432}}, // Rabak Airport
    Airport{IataCode{"KSU"}, CountryId{"NO"}, Timezone{5634}}, // Kristiansund Airport, Kvernberget
    Airport{IataCode{"KSV"}, CountryId{"AU"}, Timezone{4920}}, // Springvale Airport
    Airport{IataCode{"KSY"}, CountryId{"TR"}, Timezone{5412}}, // Kars Airport
    Airport{IataCode{"KSZ"}, CountryId{"RU"}, Timezone{5620}}, // Kotlas Airport
    Airport{IataCode{"KTA"}, CountryId{"AU"}, Timezone{5087}}, // Karratha Airport
    Airport{IataCode{"KTB"}, CountryId{"US"}, Timezone{3255}}, // Thorne Bay Seaplane Base
    Airport{IataCode{"KTC"}, CountryId{"CI"}, Timezone{0}}, // Katiola Airport
    Airport{IataCode{"KTD"}, CountryId{"JP"}, Timezone{4568}}, // Kitadaito Airport
    Airport{IataCode{"KTE"}, CountryId{"MY"}, Timezone{4159}}, // Kerteh Airport
    Airport{IataCode{"KTF"}, CountryId{"NZ"}, Timezone{6218}}, // Takaka Aerodrome
    Airport{IataCode{"KTG"}, CountryId{"ID"}, Timezone{4348}}, // Ketapang Airport
    Airport{IataCode{"KTI"}, CountryId{"KH"}, Timezone{4332}}, // Kratié Airport
    Airport{IataCode{"KTL"}, CountryId{"KE"}, Timezone{641}}, // Kitale Airport
    Airport{IataCode{"KTM"}, CountryId{"NP"}, Timezone{4100}}, // Tribhuvan International Airport
    Airport{IataCode{"KTN"}, CountryId{"US"}, Timezone{3255}}, // Ketchikan International Airport
    Airport{IataCode{"KTO"}, CountryId{"GY"}, Timezone{1949}}, // Kato Airport
    Airport{IataCode{"KTP"}, CountryId{"JM"}, Timezone{2260}}, // Tinson Pen Aerodrome
    Airport{IataCode{"KTS"}, CountryId{"US"}, Timezone{2745}}, // Brevig Mission Airport
    Airport{IataCode{"KTT"}, CountryId{"FI"}, Timezone{5377}}, // Kittilä Airport
    Airport{IataCode{"KTU"}, CountryId{"IN"}, Timezone{4129}}, // Kota Airport
    Airport{IataCode{"KTV"}, CountryId{}, Timezone{1463}}, // Kamarata Airport
    Airport{IataCode{"KTW"}, CountryId{"PL"}, Timezone{5975}}, // Katowice International Airport
    Airport{IataCode{"KTX"}, CountryId{"ML"}, Timezone{76}}, // Koutiala Airport
    Airport{IataCode{"KUA"}, CountryId{"MY"}, Timezone{4159}}, // Sultan Haji Ahmad Shah Airport
    Airport{IataCode{"KUC"}, CountryId{"KI"}, Timezone{}}, // Kuria Airport
    Airport{IataCode{"KUD"}, CountryId{"MY"}, Timezone{4190}}, // Kudat Airport
    Airport{IataCode{"KUE"}, CountryId{"SB"}, Timezone{}}, // Kukudu Airport
    Airport{IataCode{"KUF"}, CountryId{"RU"}, Timezone{5714}}, // Kurumoch International Airport
    Airport{IataCode{"KUG"}, CountryId{"AU"}, Timezone{4920}}, // Kubin Airport
    Airport{IataCode{"KUH"}, CountryId{"JP"}, Timezone{4568}}, // Kushiro Airport
    Airport{IataCode{"KUK"}, CountryId{"US"}, Timezone{2745}}, // Kasigluk Airport
    Airport{IataCode{"KUL"}, CountryId{"MY"}, Timezone{4159}}, // Kuala Lumpur International Airport
    Airport{IataCode{"KUM"}, CountryId{"JP"}, Timezone{4568}}, // Yakushima Airport
    Airport{IataCode{"KUN"}, CountryId{"LT"}, Timezone{5943}}, // Kaunas Airport
    Airport{IataCode{"KUO"}, CountryId{"FI"}, Timezone{5377}}, // Kuopio Airport
    Airport{IataCode{"KUR"}, CountryId{"AF"}, Timezone{4061}}, // Razer Airport
    Airport{IataCode{"KUS"}, CountryId{"GL"}, Timezone{1825}}, // Kulusuk Airport
    Airport{IataCode{"KUT"}, CountryId{"GE"}, Timezone{4530}}, // Kutaisi International Airport
    Airport{IataCode{"KUU"}, CountryId{"IN"}, Timezone{4129}}, // Bhuntar Airport
    Airport{IataCode{"KUV"}, CountryId{"KR"}, Timezone{4445}}, // Gunsan Airport
    Airport{IataCode{"KUY"}, CountryId{"PG"}, Timezone{6686}}, // Kamusi Airport
    Airport{IataCode{"KVA"}, CountryId{"GR"}, Timezone{5169}}, // Kavala International Airport
    Airport{IataCode{"KVB"}, CountryId{"SE"}, Timezone{5822}}, // Skövde Airport
    Airport{IataCode{"KVC"}, CountryId{"US"}, Timezone{2745}}, // King Cove Airport
    Airport{IataCode{"KVD"}, CountryId{"AZ"}, Timezone{3754}}, // Ganja International Airport
    Airport{IataCode{"KVG"}, CountryId{"PG"}, Timezone{6686}}, // Kavieng Airport
    Airport{IataCode{"KVK"}, CountryId{"RU"}, Timezone{5620}}, // Kirovsk-Apatity Airport
    Airport{IataCode{"KVL"}, CountryId{"US"}, Timezone{2745}}, // Kivalina Airport
    Airport{IataCode{"KVM"}, CountryId{"RU"}, Timezone{3667}}, // Markovo Airport
    Airport{IataCode{"KVO"}, CountryId{"RS"}, Timezone{5183}}, // Morava Airport
    Airport{IataCode{"KVS"}, CountryId{"RS"}, Timezone{5183}}, // Kraljevo Sport Airport
    Airport{IataCode{"KVX"}, CountryId{"RU"}, Timezone{5473}}, // Pobedilovo Airport
    Airport{IataCode{"KWB"}, CountryId{"ID"}, Timezone{4032}}, // Dewadaru Airport
    Airport{IataCode{"KWE"}, CountryId{"CN"}, Timezone{4456}}, // Guiyang Longdongbao International Airport
    Airport{IataCode{"KWF"}, CountryId{"US"}, Timezone{3255}}, // Waterfall Seaplane Base
    Airport{IataCode{"KWG"}, CountryId{"UA"}, Timezone{5461}}, // Kryvyi Rih International Airport
    Airport{IataCode{"KWH"}, CountryId{"AF"}, Timezone{3913}}, // Khwahan Airport
    Airport{IataCode{"KWI"}, CountryId{"KW"}, Timezone{4190}}, // Kuwait International Airport
    Airport{IataCode{"KWJ"}, CountryId{"KR"}, Timezone{4445}}, // Gwangju Airport
    Airport{IataCode{"KWK"}, CountryId{"US"}, Timezone{2745}}, // Kwigillingok Airport
    Airport{IataCode{"KWL"}, CountryId{"CN"}, Timezone{4456}}, // Guilin Liangjiang International Airport
    Airport{IataCode{"KWN"}, CountryId{"US"}, Timezone{814}}, // Quinhagak Airport
    Airport{IataCode{"KWP"}, CountryId{"US"}, Timezone{814}}, // West Point Village Seaplane Base
    Airport{IataCode{"KWS"}, CountryId{"IL"}, Timezone{3790}}, // Kiryat Shmona Airport
    Airport{IataCode{"KWT"}, CountryId{"US"}, Timezone{814}}, // Kwethluk Airport
    Airport{IataCode{"KWY"}, CountryId{"KE"}, Timezone{641}}, // Kiwayu Airport
    Airport{IataCode{"KWZ"}, CountryId{"CD"}, Timezone{519}}, // Kolwezi Airport
    Airport{IataCode{"KXD"}, CountryId{"RU"}, Timezone{4690}}, // Kondinskoye Airport
    Airport{IataCode{"KXF"}, CountryId{"FJ"}, Timezone{6349}}, // Koro Airport
    Airport{IataCode{"KXK"}, CountryId{"RU"}, Timezone{4648}}, // Komsomolsk-on-Amur Airport
    Airport{IataCode{"KYD"}, CountryId{"TW"}, Timezone{4504}}, // Lanyu Airport
    Airport{IataCode{"KYK"}, CountryId{"US"}, Timezone{814}}, // Karluk Airport
    Airport{IataCode{"KYP"}, CountryId{"MM"}, Timezone{4678}}, // Kyaukpyu Airport
    Airport{IataCode{"KYS"}, CountryId{"ML"}, Timezone{76}}, // Kayes Airport
    Airport{IataCode{"KYU"}, CountryId{"US"}, Timezone{814}}, // Koyukuk Airport
    Airport{IataCode{"KYZ"}, CountryId{"RU"}, Timezone{4142}}, // Kyzyl Airport
    Airport{IataCode{"KZB"}, CountryId{"US"}, Timezone{814}}, // Zachar Bay Seaplane Base
    Airport{IataCode{"KZC"}, CountryId{"KH"}, Timezone{4332}}, // Kampong Chhnang Airport
    Airport{IataCode{"KZD"}, CountryId{"KH"}, Timezone{4332}}, // Krakor Airport
    Airport{IataCode{"KZI"}, CountryId{"GR"}, Timezone{5169}}, // Kozani National Airport
    Airport{IataCode{"KZK"}, CountryId{"KH"}, Timezone{4332}}, // Kampong Cham Airport
    Airport{IataCode{"KZN"}, CountryId{"RU"}, Timezone{5620}}, // Kazan International Airport
    Airport{IataCode{"KZO"}, CountryId{"KZ"}, Timezone{4389}}, // Kyzylorda Airport
    Airport{IataCode{"KZR"}, CountryId{"TR"}, Timezone{5412}}, // Zafer Airport
    Airport{IataCode{"KZS"}, CountryId{"GR"}, Timezone{5412}}, // Kastellorizo Airport
    Airport{IataCode{"LAA"}, CountryId{"US"}, Timezone{1667}}, // Lamar Municipal Airport (Colorado)
    Airport{IataCode{"LAC"}, CountryId{"MY"}, Timezone{}}, // Layang-Layang Airport
    Airport{IataCode{"LAD"}, CountryId{"AO"}, Timezone{505}}, // Quatro de Fevereiro Airport
    Airport{IataCode{"LAE"}, CountryId{"PG"}, Timezone{6686}}, // Lae Airfield
    Airport{IataCode{"LAF"}, CountryId{"US"}, Timezone{2043}}, // Purdue University Airport
    Airport{IataCode{"LAH"}, CountryId{"ID"}, Timezone{4032}}, // Oesman Sadik Airport
    Airport{IataCode{"LAI"}, CountryId{"FR"}, Timezone{5646}}, // Lannion – Côte de Granit Airport
    Airport{IataCode{"LAJ"}, CountryId{"BR"}, Timezone{3216}}, // Lages Airport
    Airport{IataCode{"LAK"}, CountryId{"CA"}, Timezone{3573}}, // Aklavik/Freddie Carmichael Airport
    Airport{IataCode{"LAL"}, CountryId{"US"}, Timezone{2712}}, // Lakeland Linder Regional Airport
    Airport{IataCode{"LAM"}, CountryId{"US"}, Timezone{1667}}, // Los Alamos County Airport
    Airport{IataCode{"LAN"}, CountryId{"US"}, Timezone{1682}}, // Capital Region International Airport
    Airport{IataCode{"LAO"}, CountryId{"PH"}, Timezone{}}, // Laoag International Airport
    Airport{IataCode{"LAP"}, CountryId{"MX"}, Timezone{2519}}, // Manuel Márquez de León International Airport
    Airport{IataCode{"LAQ"}, CountryId{"LY"}, Timezone{757}}, // Al Abraq International Airport
    Airport{IataCode{"LAR"}, CountryId{"US"}, Timezone{1667}}, // Laramie Regional Airport
    Airport{IataCode{"LAS"}, CountryId{"US"}, Timezone{2378}}, // McCarran International Airport
    Airport{IataCode{"LAU"}, CountryId{"KE"}, Timezone{641}}, // Manda Airport
    Airport{IataCode{"LAW"}, CountryId{"US"}, Timezone{1510}}, // Lawton–Fort Sill Regional Airport
    Airport{IataCode{"LAX"}, CountryId{"US"}, Timezone{2378}}, // Los Angeles International Airport
    Airport{IataCode{"LAY"}, CountryId{"ZA"}, Timezone{369}}, // Ladysmith Airport
    Airport{IataCode{"LAZ"}, CountryId{"BR"}, Timezone{1254}}, // Bom Jesus da Lapa Airport
    Airport{IataCode{"LBA"}, CountryId{"GB"}, Timezone{5517}}, // Leeds Bradford International Airport
    Airport{IataCode{"LBB"}, CountryId{"US"}, Timezone{1510}}, // Lubbock Preston Smith International Airport
    Airport{IataCode{"LBC"}, CountryId{"DE"}, Timezone{5199}}, // Lübeck Airport
    Airport{IataCode{"LBD"}, CountryId{"TJ"}, Timezone{3913}}, // Khujand Airport
    Airport{IataCode{"LBE"}, CountryId{"US"}, Timezone{2712}}, // Arnold Palmer Regional Airport
    Airport{IataCode{"LBF"}, CountryId{"US"}, Timezone{1510}}, // North Platte Regional Airport
    Airport{IataCode{"LBG"}, CountryId{"FR"}, Timezone{5646}}, // Paris–Le Bourget Airport
    Airport{IataCode{"LBJ"}, CountryId{"ID"}, Timezone{4226}}, // Komodo Airport
    Airport{IataCode{"LBK"}, CountryId{"KE"}, Timezone{641}}, // Liboi Airport
    Airport{IataCode{"LBL"}, CountryId{"US"}, Timezone{1510}}, // Liberal Mid-America Regional Airport
    Airport{IataCode{"LBN"}, CountryId{"KE"}, Timezone{641}}, // Lake Baringo Airport
    Airport{IataCode{"LBO"}, CountryId{"CD"}, Timezone{519}}, // Lusambo Airport
    Airport{IataCode{"LBP"}, CountryId{"MY"}, Timezone{4190}}, // Long Banga Airport
    Airport{IataCode{"LBQ"}, CountryId{"GA"}, Timezone{475}}, // Lambaréné Airport
    Airport{IataCode{"LBR"}, CountryId{"BR"}, Timezone{2451}}, // Lábrea Airport
    Airport{IataCode{"LBS"}, CountryId{"FJ"}, Timezone{6349}}, // Labasa Airport
    Airport{IataCode{"LBT"}, CountryId{"US"}, Timezone{2712}}, // Lumberton Municipal Airport
    Airport{IataCode{"LBU"}, CountryId{"MY"}, Timezone{}}, // Labuan Airport
    Airport{IataCode{"LBV"}, CountryId{"GA"}, Timezone{475}}, // Libreville International Airport
    Airport{IataCode{"LBW"}, CountryId{"ID"}, Timezone{4190}}, // Juvai Semaring Airport
    Airport{IataCode{"LBX"}, CountryId{"PH"}, Timezone{4240}}, // Lubang Airport
    Airport{IataCode{"LBZ"}, CountryId{"AO"}, Timezone{505}}, // Lucapa Airport
    Airport{IataCode{"LCA"}, CountryId{"CY"}, Timezone{4264}}, // Larnaca International Airport
    Airport{IataCode{"LCB"}, CountryId{"BR"}, Timezone{1579}}, // Pontes e Lacerda Airport
    Airport{IataCode{"LCC"}, CountryId{"IT"}, Timezone{5702}}, // Lecce Galatina Airport
    Airport{IataCode{"LCE"}, CountryId{"HN"}, Timezone{3401}}, // Golosón International Airport
    Airport{IataCode{"LCF"}, CountryId{"GT"}, Timezone{1913}}, // Río Dulce Airport
    Airport{IataCode{"LCG"}, CountryId{"ES"}, Timezone{5549}}, // A Coruña Airport
    Airport{IataCode{"LCH"}, CountryId{"US"}, Timezone{1510}}, // Lake Charles Regional Airport
    Airport{IataCode{"LCI"}, CountryId{"US"}, Timezone{2712}}, // Laconia Municipal Airport
    Airport{IataCode{"LCJ"}, CountryId{"PL"}, Timezone{5975}}, // Łódź Władysław Reymont Airport
    Airport{IataCode{"LCK"}, CountryId{"US"}, Timezone{2712}}, // Rickenbacker International Airport
    Airport{IataCode{"LCL"}, CountryId{"CU"}, Timezone{1980}}, // La Coloma Airport
    Airport{IataCode{"LCM"}, CountryId{"AR"}, Timezone{942}}, // La Cumbre Airport
    Airport{IataCode{"LCO"}, CountryId{"CG"}, Timezone{148}}, // Lague Airport
    Airport{IataCode{"LCQ"}, CountryId{"US"}, Timezone{2712}}, // Lake City Gateway Airport
    Airport{IataCode{"LCR"}, CountryId{"CO"}, Timezone{1376}}, // La Chorrera Airport
    Airport{IataCode{"LCV"}, CountryId{"IT"}, Timezone{5702}}, // Lucca-Tassignano Airport
    Airport{IataCode{"LCX"}, CountryId{"CN"}, Timezone{4456}}, // Longyan Guanzhishan Airport
    Airport{IataCode{"LCY"}, CountryId{"GB"}, Timezone{5517}}, // London City Airport
    Airport{IataCode{"LDA"}, CountryId{"IN"}, Timezone{4129}}, // Malda Airport
    Airport{IataCode{"LDB"}, CountryId{"BR"}, Timezone{3216}}, // Londrina Airport
    Airport{IataCode{"LDE"}, CountryId{"FR"}, Timezone{5646}}, // Tarbes-Lourdes-Pyrénées Airport
    Airport{IataCode{"LDG"}, CountryId{"RU"}, Timezone{5620}}, // Leshukonskoye Airport
    Airport{IataCode{"LDH"}, CountryId{"AU"}, Timezone{}}, // Lord Howe Island Airport
    Airport{IataCode{"LDI"}, CountryId{"TZ"}, Timezone{256}}, // Lindi Airport
    Airport{IataCode{"LDJ"}, CountryId{"US"}, Timezone{2712}}, // Linden Airport
    Airport{IataCode{"LDK"}, CountryId{"SE"}, Timezone{5822}}, // Lidköping-Hovby Airport
    Airport{IataCode{"LDM"}, CountryId{"US"}, Timezone{1682}}, // Mason County Airport
    Airport{IataCode{"LDN"}, CountryId{"NP"}, Timezone{4100}}, // Lamidanda Airport
    Airport{IataCode{"LDO"}, CountryId{"SR"}, Timezone{2912}}, // Laduani Airstrip
    Airport{IataCode{"LDS"}, CountryId{"CN"}, Timezone{4456}}, // Yichun Lindu Airport
    Airport{IataCode{"LDU"}, CountryId{"MY"}, Timezone{4190}}, // Lahad Datu Airport
    Airport{IataCode{"LDX"}, CountryId{"FR"}, Timezone{2912}}, // Saint-Laurent-du-Maroni Airport
    Airport{IataCode{"LDY"}, CountryId{"GB"}, Timezone{5330}}, // City of Derry Airport
    Airport{IataCode{"LEA"}, CountryId{"AU"}, Timezone{5087}}, // Learmonth Airport
    Airport{IataCode{"LEB"}, CountryId{"US"}, Timezone{2712}}, // Lebanon Municipal Airport
    Airport{IataCode{"LEC"}, CountryId{"BR"}, Timezone{1254}}, // Lençóis Airport
    Airport{IataCode{"LED"}, CountryId{"RU"}, Timezone{5620}}, // Pulkovo Airport
    Airport{IataCode{"LEE"}, CountryId{"US"}, Timezone{2712}}, // Leesburg International Airport
    Airport{IataCode{"LEF"}, CountryId{"LS"}, Timezone{579}}, // Lebakeng Airport
    Airport{IataCode{"LEH"}, CountryId{"FR"}, Timezone{5646}}, // Le Havre – Octeville Airport
    Airport{IataCode{"LEI"}, CountryId{"ES"}, Timezone{5549}}, // Almería Airport
    Airport{IataCode{"LEJ"}, CountryId{"DE"}, Timezone{5199}}, // Leipzig/Halle Airport
    Airport{IataCode{"LEK"}, CountryId{"GN"}, Timezone{228}}, // Tata Airport
    Airport{IataCode{"LEL"}, CountryId{"AU"}, Timezone{4978}}, // Lake Evella Airport
    Airport{IataCode{"LEN"}, CountryId{"ES"}, Timezone{5549}}, // León Airport
    Airport{IataCode{"LEP"}, CountryId{"BR"}, Timezone{3216}}, // Leopoldina Airport
    Airport{IataCode{"LEQ"}, CountryId{"GB"}, Timezone{5517}}, // Land's End Airport
    Airport{IataCode{"LER"}, CountryId{"AU"}, Timezone{5087}}, // Leinster Airport
    Airport{IataCode{"LES"}, CountryId{"LS"}, Timezone{579}}, // Lesobeng Airport
    Airport{IataCode{"LET"}, CountryId{"CO"}, Timezone{1376}}, // Alfredo Vásquez Cobo International Airport
    Airport{IataCode{"LEU"}, CountryId{"ES"}, Timezone{5549}}, // La Seu d'Urgell Airport
    Airport{IataCode{"LEV"}, CountryId{"FJ"}, Timezone{6349}}, // Levuka Airfield
    Airport{IataCode{"LEW"}, CountryId{"US"}, Timezone{2712}}, // Auburn/Lewiston Municipal Airport
    Airport{IataCode{"LEX"}, CountryId{"US"}, Timezone{2712}}, // Blue Grass Airport
    Airport{IataCode{"LEY"}, CountryId{"NL"}, Timezone{5120}}, // Lelystad Airport
    Airport{IataCode{"LEZ"}, CountryId{"HN"}, Timezone{3401}}, // La Esperanza Airport
    Airport{IataCode{"LFB"}, CountryId{"MZ"}, Timezone{565}}, // Lumbo Airport
    Airport{IataCode{"LFK"}, CountryId{"US"}, Timezone{1510}}, // Angelina County Airport
    Airport{IataCode{"LFM"}, CountryId{"IR"}, Timezone{4543}}, // Lamerd Airport
    Airport{IataCode{"LFN"}, CountryId{"US"}, Timezone{2712}}, // Triangle North Executive Airport
    Airport{IataCode{"LFQ"}, CountryId{"CN"}, Timezone{4456}}, // Linfen Qiaoli Airport
    Airport{IataCode{"LFR"}, CountryId{"VE"}, Timezone{1463}}, // La Fría Airport
    Airport{IataCode{"LFT"}, CountryId{"US"}, Timezone{1510}}, // Lafayette Regional Airport
    Airport{IataCode{"LFW"}, CountryId{"TG"}, Timezone{493}}, // Lomé-Tokoin Airport
    Airport{IataCode{"LGA"}, CountryId{"US"}, Timezone{2712}}, // LaGuardia Airport
    Airport{IataCode{"LGB"}, CountryId{"US"}, Timezone{2378}}, // Long Beach Airport
    Airport{IataCode{"LGC"}, CountryId{"US"}, Timezone{2712}}, // LaGrange-Callaway Airport
    Airport{IataCode{"LGD"}, CountryId{"US"}, Timezone{2378}}, // La Grande/Union County Airport
    Airport{IataCode{"LGE"}, CountryId{"AU"}, Timezone{5087}}, // Lake Gregory Airport
    Airport{IataCode{"LGG"}, CountryId{"BE"}, Timezone{5231}}, // Liege Airport
    Airport{IataCode{"LGH"}, CountryId{"AU"}, Timezone{4901}}, // Leigh Creek Airport
    Airport{IataCode{"LGI"}, CountryId{"BS"}, Timezone{2697}}, // Deadman's Cay Airport
    Airport{IataCode{"LGK"}, CountryId{"MY"}, Timezone{}}, // Langkawi International Airport
    Airport{IataCode{"LGL"}, CountryId{"MY"}, Timezone{4190}}, // Long Lellang Airport
    Airport{IataCode{"LGM"}, CountryId{"AR"}, Timezone{914}}, // Lago Musters Airport
    Airport{IataCode{"LGO"}, CountryId{"DE"}, Timezone{5199}}, // Langeoog Airport
    Airport{IataCode{"LGP"}, CountryId{"PH"}, Timezone{4240}}, // Legazpi Airport
    Airport{IataCode{"LGQ"}, CountryId{"EC"}, Timezone{1949}}, // Lago Agrio Airport
    Airport{IataCode{"LGR"}, CountryId{"CL"}, Timezone{3177}}, // Cochrane, Chile Airport
    Airport{IataCode{"LGS"}, CountryId{"AR"}, Timezone{1019}}, // Comodoro D. Ricardo Salomón Airport
    Airport{IataCode{"LGT"}, CountryId{"CO"}, Timezone{1376}}, // Las Gaviotas Airport
    Airport{IataCode{"LGU"}, CountryId{"US"}, Timezone{1667}}, // Logan-Cache Airport
    Airport{IataCode{"LGW"}, CountryId{"GB"}, Timezone{5517}}, // Gatwick Airport
    Airport{IataCode{"LGX"}, CountryId{"SO"}, Timezone{608}}, // Lugh Ganane Airport
    Airport{IataCode{"LHB"}, CountryId{"GB"}, Timezone{5517}}, // Bruntingthorpe Aerodrome
    Airport{IataCode{"LHC"}, CountryId{"PE"}, Timezone{1376}}, // Caballococha Airport
    Airport{IataCode{"LHD"}, CountryId{"US"}, Timezone{814}}, // Lake Hood Seaplane Base
    Airport{IataCode{"LHE"}, CountryId{"PK"}, Timezone{4087}}, // Allama Iqbal International Airport
    Airport{IataCode{"LHG"}, CountryId{"AU"}, Timezone{5103}}, // Lightning Ridge Airport
    Airport{IataCode{"LHM"}, CountryId{"US"}, Timezone{2378}}, // Lincoln Regional Airport
    Airport{IataCode{"LHR"}, CountryId{"GB"}, Timezone{5517}}, // Heathrow Airport
    Airport{IataCode{"LHS"}, CountryId{"AR"}, Timezone{1045}}, // Colonia Las Heras Airport
    Airport{IataCode{"LHV"}, CountryId{"US"}, Timezone{2712}}, // William T. Piper Memorial Airport
    Airport{IataCode{"LHW"}, CountryId{"CN"}, Timezone{4456}}, // Lanzhou Zhongchuan International Airport
    Airport{IataCode{"LHX"}, CountryId{"US"}, Timezone{1667}}, // La Junta Municipal Airport
    Airport{IataCode{"LIA"}, CountryId{"CN"}, Timezone{4456}}, // Liangping Airport
    Airport{IataCode{"LIE"}, CountryId{"CD"}, Timezone{104}}, // Libenge Airport
    Airport{IataCode{"LIF"}, CountryId{"FR"}, Timezone{6606}}, // Lifou Airport
    Airport{IataCode{"LIG"}, CountryId{"FR"}, Timezone{5646}}, // Limoges – Bellegarde Airport
    Airport{IataCode{"LIH"}, CountryId{"US"}, Timezone{6446}}, // Lihue Airport
    Airport{IataCode{"LIK"}, CountryId{"MH"}, Timezone{6515}}, // Likiep Airport
    Airport{IataCode{"LIL"}, CountryId{"FR"}, Timezone{5646}}, // Lille Airport
    Airport{IataCode{"LIM"}, CountryId{"PE"}, Timezone{2365}}, // Jorge Chávez International Airport
    Airport{IataCode{"LIN"}, CountryId{"IT"}, Timezone{5702}}, // Linate Airport
    Airport{IataCode{"LIO"}, CountryId{"CR"}, Timezone{1544}}, // Limón International Airport
    Airport{IataCode{"LIP"}, CountryId{"BR"}, Timezone{3216}}, // Lins Airport
    Airport{IataCode{"LIQ"}, CountryId{"CD"}, Timezone{446}}, // Lisala Airport
    Airport{IataCode{"LIR"}, CountryId{"CR"}, Timezone{1544}}, // Daniel Oduber Quirós International Airport
    Airport{IataCode{"LIS"}, CountryId{"PT"}, Timezone{5486}}, // Lisbon Airport
    Airport{IataCode{"LIT"}, CountryId{"US"}, Timezone{1510}}, // Bill and Hillary Clinton National Airport
    Airport{IataCode{"LIU"}, CountryId{"US"}, Timezone{1510}}, // Littlefield Municipal Airport
    Airport{IataCode{"LIW"}, CountryId{"MM"}, Timezone{4678}}, // Loikaw Airport
    Airport{IataCode{"LIX"}, CountryId{"MW"}, Timezone{565}}, // Likoma Airport
    Airport{IataCode{"LIZ"}, CountryId{"US"}, Timezone{2712}}, // Loring International Airport
    Airport{IataCode{"LJA"}, CountryId{"CD"}, Timezone{519}}, // Lodja Airport
    Airport{IataCode{"LJG"}, CountryId{"CN"}, Timezone{4456}}, // Lijiang Sanyi Airport
    Airport{IataCode{"LJN"}, CountryId{"US"}, Timezone{1510}}, // Texas Gulf Coast Regional Airport
    Airport{IataCode{"LJU"}, CountryId{"SI"}, Timezone{5500}}, // Ljubljana Jože Pučnik Airport
    Airport{IataCode{"LKA"}, CountryId{"ID"}, Timezone{4226}}, // Gewayantana Airport
    Airport{IataCode{"LKB"}, CountryId{"FJ"}, Timezone{6349}}, // Lakeba Airport
    Airport{IataCode{"LKE"}, CountryId{"US"}, Timezone{2378}}, // Kenmore Air Harbor Seaplane Base
    Airport{IataCode{"LKG"}, CountryId{"KE"}, Timezone{641}}, // Lokichogio Airport
    Airport{IataCode{"LKH"}, CountryId{"MY"}, Timezone{4190}}, // Long Akah Airport
    Airport{IataCode{"LKK"}, CountryId{"US"}, Timezone{814}}, // Kulik Lake Airport
    Airport{IataCode{"LKL"}, CountryId{"NO"}, Timezone{5634}}, // Station Group Banak
    Airport{IataCode{"LKN"}, CountryId{"NO"}, Timezone{5634}}, // Leknes Airport
    Airport{IataCode{"LKO"}, CountryId{"IN"}, Timezone{4129}}, // Chaudhary Charan Singh Airport
    Airport{IataCode{"LKP"}, CountryId{"US"}, Timezone{2712}}, // Lake Placid Airport
    Airport{IataCode{"LKR"}, CountryId{"US"}, Timezone{2712}}, // Lancaster County Airport
    Airport{IataCode{"LKV"}, CountryId{"US"}, Timezone{2378}}, // Lake County Airport
    Airport{IataCode{"LKW"}, CountryId{"OM"}, Timezone{3902}}, // Lekhwair Airport
    Airport{IataCode{"LKY"}, CountryId{"TZ"}, Timezone{256}}, // Lake Manyara Airport
    Airport{IataCode{"LLA"}, CountryId{"SE"}, Timezone{5822}}, // Luleå Airport
    Airport{IataCode{"LLB"}, CountryId{"CN"}, Timezone{4456}}, // Libo Airport
    Airport{IataCode{"LLE"}, CountryId{"ZA"}, Timezone{369}}, // Malelane Airport
    Airport{IataCode{"LLF"}, CountryId{"CN"}, Timezone{4456}}, // Yongzhou Lingling Airport
    Airport{IataCode{"LLG"}, CountryId{"AU"}, Timezone{4920}}, // Chillagoe Airport
    Airport{IataCode{"LLH"}, CountryId{"HN"}, Timezone{3401}}, // La Lima Airport
    Airport{IataCode{"LLI"}, CountryId{"ET"}, Timezone{28}}, // Lalibela Airport
    Airport{IataCode{"LLJ"}, CountryId{"BD"}, Timezone{3881}}, // Lalmonirhat Airport
    Airport{IataCode{"LLK"}, CountryId{"AZ"}, Timezone{3754}}, // Lankaran International Airport
    Airport{IataCode{"LLO"}, CountryId{"ID"}, Timezone{4226}}, // Palopo Lagaligo Airport
    Airport{IataCode{"LLQ"}, CountryId{"US"}, Timezone{1510}}, // Monticello Municipal Airport
    Airport{IataCode{"LLR"}, CountryId{"US"}, Timezone{2378}}, // Little River Airport
    Airport{IataCode{"LLS"}, CountryId{"AR"}, Timezone{942}}, // Alférez Armando Rodríguez Airport
    Airport{IataCode{"LLT"}, CountryId{"AO"}, Timezone{505}}, // Lobito Airport
    Airport{IataCode{"LLU"}, CountryId{"US"}, Timezone{1510}}, // Lamar Municipal Airport
    Airport{IataCode{"LLV"}, CountryId{"CN"}, Timezone{4456}}, // Lüliang Airport
    Airport{IataCode{"LLW"}, CountryId{"MW"}, Timezone{132}}, // Lilongwe International Airport
    Airport{IataCode{"LLX"}, CountryId{"US"}, Timezone{2712}}, // Caledonia County Airport
    Airport{IataCode{"LLY"}, CountryId{"US"}, Timezone{2712}}, // South Jersey Regional Airport
    Airport{IataCode{"LMB"}, CountryId{"MW"}, Timezone{132}}, // Salima Airport
    Airport{IataCode{"LMC"}, CountryId{"CO"}, Timezone{1376}}, // La Macarena Airport
    Airport{IataCode{"LME"}, CountryId{"FR"}, Timezone{5646}}, // Airport Le Mans-Arnage
    Airport{IataCode{"LML"}, CountryId{"MH"}, Timezone{6515}}, // Lae Airport
    Airport{IataCode{"LMM"}, CountryId{"MX"}, Timezone{2519}}, // Valle del Fuerte Federal International Airport
    Airport{IataCode{"LMN"}, CountryId{"MY"}, Timezone{3815}}, // Limbang Airport
    Airport{IataCode{"LMP"}, CountryId{"IT"}, Timezone{5702}}, // Lampedusa Airport
    Airport{IataCode{"LMQ"}, CountryId{"LY"}, Timezone{757}}, // Marsa Brega Airport
    Airport{IataCode{"LMR"}, CountryId{"ZA"}, Timezone{369}}, // Lime Acres Finsch Mine Airport
    Airport{IataCode{"LMS"}, CountryId{"US"}, Timezone{1510}}, // Louisville Winston County Airport
    Airport{IataCode{"LMT"}, CountryId{"US"}, Timezone{2378}}, // Klamath Falls Airport
    Airport{IataCode{"LMY"}, CountryId{"PG"}, Timezone{6686}}, // Lake Murray Airport
    Airport{IataCode{"LNA"}, CountryId{"US"}, Timezone{2712}}, // Palm Beach County Park Airport
    Airport{IataCode{"LNB"}, CountryId{"VU"}, Timezone{6301}}, // Lamen Bay Airport
    Airport{IataCode{"LNC"}, CountryId{"US"}, Timezone{1510}}, // Lancaster Airport
    Airport{IataCode{"LND"}, CountryId{"US"}, Timezone{1667}}, // Hunt Field
    Airport{IataCode{"LNE"}, CountryId{"VU"}, Timezone{6301}}, // Lonorore Airport
    Airport{IataCode{"LNI"}, CountryId{"US"}, Timezone{814}}, // Point Lonely Short Range Radar Site
    Airport{IataCode{"LNJ"}, CountryId{"CN"}, Timezone{4456}}, // Lincang Airport
    Airport{IataCode{"LNL"}, CountryId{"US"}, Timezone{2536}}, // Kings Land O' Lakes Airport
    Airport{IataCode{"LNN"}, CountryId{"US"}, Timezone{2712}}, // Willoughby Lost Nation Municipal Airport
    Airport{IataCode{"LNO"}, CountryId{"AU"}, Timezone{5087}}, // Leonora Airport
    Airport{IataCode{"LNP"}, CountryId{"US"}, Timezone{2712}}, // Lonesome Pine Airport
    Airport{IataCode{"LNR"}, CountryId{"US"}, Timezone{1510}}, // Tri-County Regional Airport
    Airport{IataCode{"LNS"}, CountryId{"US"}, Timezone{2712}}, // Lancaster Airport
    Airport{IataCode{"LNV"}, CountryId{"PG"}, Timezone{6686}}, // Lihir Island Airport
    Airport{IataCode{"LNX"}, CountryId{"RU"}, Timezone{5620}}, // Smolensk North Airport
    Airport{IataCode{"LNY"}, CountryId{"US"}, Timezone{6446}}, // Lanai Airport
    Airport{IataCode{"LNZ"}, CountryId{"AT"}, Timezone{5929}}, // Linz Airport
    Airport{IataCode{"LOB"}, CountryId{"CL"}, Timezone{3177}}, // San Rafael Airport (Chile)
    Airport{IataCode{"LOD"}, CountryId{"VU"}, Timezone{6301}}, // Longana Airport
    Airport{IataCode{"LOE"}, CountryId{"TH"}, Timezone{3777}}, // Loei Airport
    Airport{IataCode{"LOH"}, CountryId{"EC"}, Timezone{1949}}, // Camilo Ponce Enríquez Airport - Ciudad de Catamayo
    Airport{IataCode{"LOI"}, CountryId{"BR"}, Timezone{3216}}, // Lontras Airport
    Airport{IataCode{"LOK"}, CountryId{"KE"}, Timezone{641}}, // Lodwar Airport
    Airport{IataCode{"LOL"}, CountryId{"US"}, Timezone{2378}}, // Derby Field
    Airport{IataCode{"LOM"}, CountryId{"MX"}, Timezone{2588}}, // Francisco Primo de Verdad National Airport
    Airport{IataCode{"LON"}, CountryId{"VN"}, Timezone{3964}}, // Long Thanh International Airport
    Airport{IataCode{"LOO"}, CountryId{"DZ"}, Timezone{47}}, // L'Mekrareg Airport
    Airport{IataCode{"LOP"}, CountryId{"ID"}, Timezone{4226}}, // Lombok International Airport
    Airport{IataCode{"LOQ"}, CountryId{"BW"}, Timezone{339}}, // Lobatse Airport
    Airport{IataCode{"LOS"}, CountryId{"NG"}, Timezone{462}}, // Murtala Muhammed International Airport
    Airport{IataCode{"LOT"}, CountryId{"US"}, Timezone{1510}}, // Lewis University Airport
    Airport{IataCode{"LOU"}, CountryId{"US"}, Timezone{2275}}, // Bowman Field
    Airport{IataCode{"LOV"}, CountryId{"MX"}, Timezone{2641}}, // Venustiano Carranza International Airport
    Airport{IataCode{"LOW"}, CountryId{"US"}, Timezone{2712}}, // Louisa County Airport
    Airport{IataCode{"LOY"}, CountryId{"KE"}, Timezone{641}}, // Loiyangalani Airport
    Airport{IataCode{"LOZ"}, CountryId{"US"}, Timezone{2712}}, // London-Corbin Airport
    Airport{IataCode{"LPA"}, CountryId{"ES"}, Timezone{4755}}, // Gran Canaria Airport
    Airport{IataCode{"LPB"}, CountryId{"BO"}, Timezone{2350}}, // El Alto International Airport
    Airport{IataCode{"LPC"}, CountryId{"US"}, Timezone{2378}}, // Lompoc Airport
    Airport{IataCode{"LPD"}, CountryId{"CO"}, Timezone{1376}}, // La Pedrera Airport
    Airport{IataCode{"LPE"}, CountryId{"CO"}, Timezone{1376}}, // La Primavera Airport
    Airport{IataCode{"LPF"}, CountryId{"CN"}, Timezone{4456}}, // Liupanshui Yuezhao Airport
    Airport{IataCode{"LPG"}, CountryId{"AR"}, Timezone{883}}, // La Plata Airport
    Airport{IataCode{"LPI"}, CountryId{"SE"}, Timezone{5822}}, // Linköping City Airport
    Airport{IataCode{"LPK"}, CountryId{"RU"}, Timezone{5620}}, // Lipetsk Airport
    Airport{IataCode{"LPL"}, CountryId{"GB"}, Timezone{5517}}, // Liverpool John Lennon Airport
    Airport{IataCode{"LPM"}, CountryId{"VU"}, Timezone{6301}}, // Malekoula Airport
    Airport{IataCode{"LPO"}, CountryId{"US"}, Timezone{1510}}, // La Porte Municipal Airport
    Airport{IataCode{"LPP"}, CountryId{"FI"}, Timezone{5377}}, // Lappeenranta Airport
    Airport{IataCode{"LPQ"}, CountryId{"LA"}, Timezone{4633}}, // Luang Prabang International Airport
    Airport{IataCode{"LPR"}, CountryId{"US"}, Timezone{2712}}, // Lorain County Regional Airport
    Airport{IataCode{"LPS"}, CountryId{"US"}, Timezone{2378}}, // Fishermans Bay/LPS Seaplane Base
    Airport{IataCode{"LPT"}, CountryId{"TH"}, Timezone{3777}}, // Lampang Airport
    Airport{IataCode{"LPU"}, CountryId{"ID"}, Timezone{}}, // Long Apung Airport
    Airport{IataCode{"LPX"}, CountryId{"LV"}, Timezone{5690}}, // Liepāja International Airport
    Airport{IataCode{"LPY"}, CountryId{"FR"}, Timezone{5646}}, // Le Puy – Loudes Airport
    Airport{IataCode{"LQK"}, CountryId{"US"}, Timezone{2712}}, // Pickens County Airport
    Airport{IataCode{"LQM"}, CountryId{"CO"}, Timezone{1376}}, // Caucayá Airport
    Airport{IataCode{"LQN"}, CountryId{"AF"}, Timezone{4061}}, // Qala i Naw Airport
    Airport{IataCode{"LRA"}, CountryId{"GR"}, Timezone{5169}}, // Larissa National Airport
    Airport{IataCode{"LRB"}, CountryId{"LS"}, Timezone{369}}, // Leribe Airport
    Airport{IataCode{"LRD"}, CountryId{"US"}, Timezone{}}, // Laredo International Airport
    Airport{IataCode{"LRE"}, CountryId{"AU"}, Timezone{4920}}, // Longreach Airport
    Airport{IataCode{"LRG"}, CountryId{"US"}, Timezone{2712}}, // Lincoln Regional Airport
    Airport{IataCode{"LRH"}, CountryId{"FR"}, Timezone{5646}}, // La Rochelle – Île de Ré Airport
    Airport{IataCode{"LRJ"}, CountryId{"US"}, Timezone{1510}}, // Le Mars Municipal Airport
    Airport{IataCode{"LRL"}, CountryId{"TG"}, Timezone{493}}, // Niamtougou International Airport
    Airport{IataCode{"LRM"}, CountryId{"DO"}, Timezone{3194}}, // La Romana International Airport
    Airport{IataCode{"LRO"}, CountryId{"US"}, Timezone{2712}}, // Mount Pleasant Regional Airport
    Airport{IataCode{"LRQ"}, CountryId{"CA"}, Timezone{3540}}, // Laurie River Airport
    Airport{IataCode{"LRR"}, CountryId{"IR"}, Timezone{4543}}, // Larestan International Airport
    Airport{IataCode{"LRS"}, CountryId{"GR"}, Timezone{5169}}, // Leros Island National Airport
    Airport{IataCode{"LRT"}, CountryId{"FR"}, Timezone{5646}}, // Lorient South Brittany Airport
    Airport{IataCode{"LRU"}, CountryId{"US"}, Timezone{1667}}, // Las Cruces International Airport
    Airport{IataCode{"LRV"}, CountryId{"VE"}, Timezone{1463}}, // Los Roques Airport
    Airport{IataCode{"LSA"}, CountryId{"PG"}, Timezone{6686}}, // Losuia Airport
    Airport{IataCode{"LSC"}, CountryId{"CL"}, Timezone{3177}}, // La Florida Airport
    Airport{IataCode{"LSE"}, CountryId{"US"}, Timezone{1510}}, // La Crosse Regional Airport
    Airport{IataCode{"LSH"}, CountryId{"MM"}, Timezone{4678}}, // Lashio Airport
    Airport{IataCode{"LSI"}, CountryId{"GB"}, Timezone{5517}}, // Sumburgh Airport
    Airport{IataCode{"LSL"}, CountryId{"CR"}, Timezone{2435}}, // Los Chiles Airport
    Airport{IataCode{"LSM"}, CountryId{"MY"}, Timezone{}}, // Long Semado Airport
    Airport{IataCode{"LSN"}, CountryId{"US"}, Timezone{2378}}, // Los Banos Municipal Airport
    Airport{IataCode{"LSO"}, CountryId{"FR"}, Timezone{5646}}, // Sables-d'Olonne - Talmont Airport
    Airport{IataCode{"LSP"}, CountryId{"VE"}, Timezone{1463}}, // Josefa Camejo International Airport
    Airport{IataCode{"LSQ"}, CountryId{"CL"}, Timezone{3177}}, // María Dolores Airport
    Airport{IataCode{"LSR"}, CountryId{"US"}, Timezone{2745}}, // Lost River 1 Airport
    Airport{IataCode{"LSS"}, CountryId{"FR"}, Timezone{1894}}, // Les Saintes Airport
    Airport{IataCode{"LST"}, CountryId{"AU"}, Timezone{5011}}, // Launceston Airport
    Airport{IataCode{"LSU"}, CountryId{"MY"}, Timezone{3815}}, // Long Sukang Airport
    Airport{IataCode{"LSW"}, CountryId{"ID"}, Timezone{4032}}, // Malikus Saleh Airport
    Airport{IataCode{"LSY"}, CountryId{"AU"}, Timezone{5103}}, // Lismore Airport
    Airport{IataCode{"LSZ"}, CountryId{"HR"}, Timezone{5989}}, // Lošinj Airport
    Airport{IataCode{"LTA"}, CountryId{"ZA"}, Timezone{369}}, // Tzaneen Airport
    Airport{IataCode{"LTC"}, CountryId{"TD"}, Timezone{656}}, // Laï Airport
    Airport{IataCode{"LTD"}, CountryId{"LY"}, Timezone{757}}, // Ghadames Airport
    Airport{IataCode{"LTI"}, CountryId{"MN"}, Timezone{3996}}, // Altai Airport
    Airport{IataCode{"LTK"}, CountryId{"SY"}, Timezone{3867}}, // Bassel Al-Assad International Airport
    Airport{IataCode{"LTL"}, CountryId{"GA"}, Timezone{475}}, // Lastourville Airport
    Airport{IataCode{"LTM"}, CountryId{"GY"}, Timezone{1358}}, // Lethem Airport
    Airport{IataCode{"LTN"}, CountryId{"GB"}, Timezone{5517}}, // Luton Airport
    Airport{IataCode{"LTO"}, CountryId{"MX"}, Timezone{2519}}, // Loreto International Airport
    Airport{IataCode{"LTQ"}, CountryId{"FR"}, Timezone{5646}}, // Le Touquet – Côte d'Opale Airport
    Airport{IataCode{"LTT"}, CountryId{"FR"}, Timezone{5646}}, // La Môle – Saint-Tropez Airport
    Airport{IataCode{"LTU"}, CountryId{"IN"}, Timezone{4129}}, // Latur Airport
    Airport{IataCode{"LTW"}, CountryId{"US"}, Timezone{2712}}, // St. Mary's County Regional Airport
    Airport{IataCode{"LTX"}, CountryId{"EC"}, Timezone{1949}}, // Cotopaxi International Airport
    Airport{IataCode{"LTY"}, CountryId{"US"}, Timezone{1667}}, // Liberty County Airport
    Airport{IataCode{"LUA"}, CountryId{"NP"}, Timezone{4100}}, // Tenzing-Hillary Airport
    Airport{IataCode{"LUB"}, CountryId{"GY"}, Timezone{1949}}, // Lumid Pau Airport
    Airport{IataCode{"LUC"}, CountryId{"FJ"}, Timezone{6349}}, // Laucala Airport
    Airport{IataCode{"LUD"}, CountryId{"NA"}, Timezone{785}}, // Lüderitz Airport
    Airport{IataCode{"LUG"}, CountryId{"CH"}, Timezone{5702}}, // Lugano Airport
    Airport{IataCode{"LUH"}, CountryId{"IN"}, Timezone{4129}}, // Sahnewal Airport
    Airport{IataCode{"LUI"}, CountryId{"HN"}, Timezone{3401}}, // La Unión Airport
    Airport{IataCode{"LUK"}, CountryId{"US"}, Timezone{2712}}, // Cincinnati Municipal Lunken Airport
    Airport{IataCode{"LUL"}, CountryId{"US"}, Timezone{1510}}, // Hesler-Noble Field
    Airport{IataCode{"LUM"}, CountryId{"CN"}, Timezone{4456}}, // Dehong Mangshi Airport
    Airport{IataCode{"LUN"}, CountryId{"ZM"}, Timezone{537}}, // Lusaka International Airport
    Airport{IataCode{"LUO"}, CountryId{"AO"}, Timezone{505}}, // Luena Airport
    Airport{IataCode{"LUP"}, CountryId{"US"}, Timezone{6446}}, // Kalaupapa Airport
    Airport{IataCode{"LUQ"}, CountryId{"AR"}, Timezone{1127}}, // Brigadier Mayor César Raúl Ojeda Airport
    Airport{IataCode{"LUR"}, CountryId{"US"}, Timezone{2745}}, // Cape Lisburne LRRS Airport
    Airport{IataCode{"LUS"}, CountryId{"CD"}, Timezone{446}}, // Lusanga Airport
    Airport{IataCode{"LUU"}, CountryId{"AU"}, Timezone{4920}}, // Laura Airport
    Airport{IataCode{"LUV"}, CountryId{"ID"}, Timezone{4032}}, // Karel Sadsuitubun Airport
    Airport{IataCode{"LUW"}, CountryId{"ID"}, Timezone{4226}}, // Syukuran Aminuddin Amir Airport
    Airport{IataCode{"LUX"}, CountryId{"LU"}, Timezone{5531}}, // Luxembourg Airport
    Airport{IataCode{"LUZ"}, CountryId{"PL"}, Timezone{5975}}, // Lublin Airport
    Airport{IataCode{"LVA"}, CountryId{"FR"}, Timezone{5646}}, // Laval - Entrammes Airport
    Airport{IataCode{"LVB"}, CountryId{"BR"}, Timezone{3216}}, // Santana do Livramento Airport
    Airport{IataCode{"LVI"}, CountryId{"ZM"}, Timezone{537}}, // Harry Mwanga Nkumbula International Airport
    Airport{IataCode{"LVK"}, CountryId{"US"}, Timezone{2378}}, // Livermore Municipal Airport
    Airport{IataCode{"LVM"}, CountryId{"US"}, Timezone{1667}}, // Mission Field
    Airport{IataCode{"LVN"}, CountryId{"US"}, Timezone{1510}}, // Airlake Airport
    Airport{IataCode{"LVO"}, CountryId{"AU"}, Timezone{5087}}, // Laverton Airport
    Airport{IataCode{"LVP"}, CountryId{"IR"}, Timezone{4543}}, // Lavan Airport
    Airport{IataCode{"LVR"}, CountryId{"BR"}, Timezone{1579}}, // Lucas do Rio Verde Airport
    Airport{IataCode{"LVS"}, CountryId{"US"}, Timezone{1667}}, // Las Vegas Municipal Airport
    Airport{IataCode{"LWB"}, CountryId{"US"}, Timezone{2712}}, // Greenbrier Valley Airport
    Airport{IataCode{"LWC"}, CountryId{"US"}, Timezone{1510}}, // Lawrence Municipal Airport
    Airport{IataCode{"LWE"}, CountryId{"ID"}, Timezone{4226}}, // Wonopito Airport
    Airport{IataCode{"LWK"}, CountryId{"GB"}, Timezone{5517}}, // Tingwall Airport
    Airport{IataCode{"LWL"}, CountryId{"US"}, Timezone{2378}}, // Wells Municipal Airport
    Airport{IataCode{"LWM"}, CountryId{"US"}, Timezone{2712}}, // Lawrence Municipal Airport
    Airport{IataCode{"LWN"}, CountryId{"AM"}, Timezone{5412}}, // Shirak International Airport
    Airport{IataCode{"LWO"}, CountryId{"UA"}, Timezone{5461}}, // Lviv Danylo Halytskyi International Airport
    Airport{IataCode{"LWS"}, CountryId{"US"}, Timezone{2378}}, // Lewiston – Nez Perce County Airport
    Airport{IataCode{"LWT"}, CountryId{"US"}, Timezone{1667}}, // Lewistown Municipal Airport
    Airport{IataCode{"LWV"}, CountryId{"US"}, Timezone{1510}}, // Lawrenceville-Vincennes International Airport
    Airport{IataCode{"LWY"}, CountryId{"MY"}, Timezone{4190}}, // Lawas Airport
    Airport{IataCode{"LXA"}, CountryId{"CN"}, Timezone{4456}}, // Lhasa Gonggar Airport
    Airport{IataCode{"LXG"}, CountryId{"LA"}, Timezone{4633}}, // Louangnamtha Airport
    Airport{IataCode{"LXL"}, CountryId{"US"}, Timezone{1510}}, // Little Falls/Morrison County Airport
    Airport{IataCode{"LXN"}, CountryId{"US"}, Timezone{1510}}, // Jim Kelly Field
    Airport{IataCode{"LXR"}, CountryId{"EG"}, Timezone{184}}, // Luxor International Airport
    Airport{IataCode{"LXS"}, CountryId{"GR"}, Timezone{5169}}, // Lemnos International Airport
    Airport{IataCode{"LXU"}, CountryId{"ZM"}, Timezone{537}}, // Lukulu Airport
    Airport{IataCode{"LXV"}, CountryId{"US"}, Timezone{1667}}, // Lake County Airport
    Airport{IataCode{"LYA"}, CountryId{"CN"}, Timezone{4456}}, // Luoyang Beijiao Airport
    Airport{IataCode{"LYB"}, CountryId{"GB"}, Timezone{1495}}, // Edward Bodden Airfield
    Airport{IataCode{"LYC"}, CountryId{"SE"}, Timezone{5822}}, // Lycksele Airport
    Airport{IataCode{"LYG"}, CountryId{"CN"}, Timezone{4456}}, // Lianyungang Airport
    Airport{IataCode{"LYH"}, CountryId{"US"}, Timezone{2712}}, // Lynchburg Regional Airport
    Airport{IataCode{"LYI"}, CountryId{"CN"}, Timezone{4456}}, // Linyi Shubuling Airport
    Airport{IataCode{"LYM"}, CountryId{"GB"}, Timezone{5517}}, // Lympne Airport
    Airport{IataCode{"LYN"}, CountryId{"FR"}, Timezone{5646}}, // Lyon-Bron Airport
    Airport{IataCode{"LYP"}, CountryId{"PK"}, Timezone{4087}}, // Faisalabad International Airport
    Airport{IataCode{"LYR"}, CountryId{"NO"}, Timezone{3614}}, // Svalbard Airport
    Airport{IataCode{"LYS"}, CountryId{"FR"}, Timezone{5646}}, // Lyon-Saint Exupéry Airport
    Airport{IataCode{"LYU"}, CountryId{"US"}, Timezone{1510}}, // Ely Municipal Airport
    Airport{IataCode{"LYX"}, CountryId{"GB"}, Timezone{5517}}, // Lydd Airport
    Airport{IataCode{"LZA"}, CountryId{"CD"}, Timezone{519}}, // Luiza Airport
    Airport{IataCode{"LZC"}, CountryId{"MX"}, Timezone{2588}}, // Lázaro Cárdenas Airport
    Airport{IataCode{"LZD"}, CountryId{"US"}, Timezone{2712}}, // Danielson Airport
    Airport{IataCode{"LZH"}, CountryId{"CN"}, Timezone{4456}}, // Liuzhou Bailian Airport
    Airport{IataCode{"LZM"}, CountryId{"AO"}, Timezone{505}}, // Luzamba Airport
    Airport{IataCode{"LZN"}, CountryId{"TW"}, Timezone{4456}}, // Matsu Nangan Airport
    Airport{IataCode{"LZO"}, CountryId{"CN"}, Timezone{4456}}, // Luzhou Lantian Airport
    Airport{IataCode{"LZR"}, CountryId{"AU"}, Timezone{4920}}, // Lizard Island Airport
    Airport{IataCode{"LZU"}, CountryId{"US"}, Timezone{2712}}, // Gwinnett County Airport
    Airport{IataCode{"LZY"}, CountryId{"CN"}, Timezone{4456}}, // Nyingchi Mainling Airport
    Airport{IataCode{"MAA"}, CountryId{"IN"}, Timezone{4129}}, // Chennai International Airport
    Airport{IataCode{"MAB"}, CountryId{"BR"}, Timezone{1308}}, // Marabá Airport
    Airport{IataCode{"MAC"}, CountryId{"US"}, Timezone{2712}}, // Macon Downtown Airport
    Airport{IataCode{"MAD"}, CountryId{"ES"}, Timezone{5549}}, // Adolfo Suárez Madrid–Barajas Airport
    Airport{IataCode{"MAE"}, CountryId{"US"}, Timezone{2378}}, // Madera Municipal Airport
    Airport{IataCode{"MAF"}, CountryId{"US"}, Timezone{1510}}, // Midland International Airport
    Airport{IataCode{"MAG"}, CountryId{"PG"}, Timezone{6686}}, // Madang Airport
    Airport{IataCode{"MAH"}, CountryId{"ES"}, Timezone{5549}}, // Menorca Airport
    Airport{IataCode{"MAI"}, CountryId{"MW"}, Timezone{132}}, // Mangochi Airport
    Airport{IataCode{"MAJ"}, CountryId{"MH"}, Timezone{6515}}, // Marshall Islands International Airport
    Airport{IataCode{"MAK"}, CountryId{"SS"}, Timezone{389}}, // Malakal Airport
    Airport{IataCode{"MAL"}, CountryId{"US"}, Timezone{2712}}, // Malone-Dufort Airport
    Airport{IataCode{"MAM"}, CountryId{"MX"}, Timezone{2501}}, // General Servando Canales International Airport
    Airport{IataCode{"MAN"}, CountryId{"GB"}, Timezone{5517}}, // Manchester Airport
    Airport{IataCode{"MAO"}, CountryId{"BR"}, Timezone{2451}}, // Eduardo Gomes International Airport
    Airport{IataCode{"MAQ"}, CountryId{"TH"}, Timezone{4678}}, // Mae Sot Airport
    Airport{IataCode{"MAR"}, CountryId{"VE"}, Timezone{1463}}, // La Chinita International Airport
    Airport{IataCode{"MAS"}, CountryId{"PG"}, Timezone{6686}}, // Momote Airport
    Airport{IataCode{"MAT"}, CountryId{"CD"}, Timezone{446}}, // Tshimpi Airport
    Airport{IataCode{"MAU"}, CountryId{"FR"}, Timezone{6740}}, // Maupiti Airport
    Airport{IataCode{"MAV"}, CountryId{"MH"}, Timezone{6515}}, // Maloelap Airport
    Airport{IataCode{"MAW"}, CountryId{"US"}, Timezone{1510}}, // Malden Regional Airport
    Airport{IataCode{"MAX"}, CountryId{"SN"}, Timezone{243}}, // Ouro Sogui Airport
    Airport{IataCode{"MAY"}, CountryId{"BS"}, Timezone{2697}}, // Clarence A. Bain Airport
    Airport{IataCode{"MAZ"}, CountryId{"US"}, Timezone{3012}}, // Eugenio María de Hostos Airport
    Airport{IataCode{"MBA"}, CountryId{"KE"}, Timezone{641}}, // Moi International Airport
    Airport{IataCode{"MBC"}, CountryId{"GA"}, Timezone{475}}, // Mbigou Airport
    Airport{IataCode{"MBD"}, CountryId{"ZA"}, Timezone{339}}, // Mafikeng Airport
    Airport{IataCode{"MBE"}, CountryId{"JP"}, Timezone{4568}}, // Monbetsu Airport
    Airport{IataCode{"MBG"}, CountryId{"US"}, Timezone{1667}}, // Mobridge Municipal Airport
    Airport{IataCode{"MBH"}, CountryId{"AU"}, Timezone{4920}}, // Maryborough Airport
    Airport{IataCode{"MBI"}, CountryId{"TZ"}, Timezone{256}}, // Mbeya Airport
    Airport{IataCode{"MBJ"}, CountryId{"JM"}, Timezone{2260}}, // Sangster International Airport
    Airport{IataCode{"MBK"}, CountryId{"BR"}, Timezone{1579}}, // Matupá Airport
    Airport{IataCode{"MBL"}, CountryId{"US"}, Timezone{1682}}, // Manistee County Blacker Airport
    Airport{IataCode{"MBO"}, CountryId{"PH"}, Timezone{4240}}, // Mamburao Airport
    Airport{IataCode{"MBP"}, CountryId{"PE"}, Timezone{2365}}, // Moyobamba Airport
    Airport{IataCode{"MBQ"}, CountryId{"UG"}, Timezone{401}}, // Mbarara Airport
    Airport{IataCode{"MBS"}, CountryId{"US"}, Timezone{1682}}, // MBS International Airport
    Airport{IataCode{"MBT"}, CountryId{"PH"}, Timezone{4240}}, // Moises R. Espinosa Airport
    Airport{IataCode{"MBU"}, CountryId{"SB"}, Timezone{6413}}, // Mbambanakira Airport
    Airport{IataCode{"MBW"}, CountryId{"AU"}, Timezone{5067}}, // Moorabbin Airport
    Airport{IataCode{"MBX"}, CountryId{"SI"}, Timezone{5500}}, // Maribor Edvard Rusjan Airport
    Airport{IataCode{"MBY"}, CountryId{"PH"}, Timezone{4240}}, // Malaybalay Airport
    Airport{IataCode{"MBZ"}, CountryId{"BR"}, Timezone{2451}}, // Maués Airport
    Airport{IataCode{"MCA"}, CountryId{"GN"}, Timezone{228}}, // Macenta Airport
    Airport{IataCode{"MCB"}, CountryId{"US"}, Timezone{1510}}, // McComb-Pike County Airport
    Airport{IataCode{"MCC"}, CountryId{"US"}, Timezone{2378}}, // McClellan Airfield
    Airport{IataCode{"MCD"}, CountryId{"US"}, Timezone{1682}}, // Mackinac Island Airport
    Airport{IataCode{"MCE"}, CountryId{"US"}, Timezone{2378}}, // Merced Regional Airport
    Airport{IataCode{"MCG"}, CountryId{"US"}, Timezone{814}}, // McGrath Airport
    Airport{IataCode{"MCH"}, CountryId{"EC"}, Timezone{1949}}, // General Manuel Serrano Airport
    Airport{IataCode{"MCI"}, CountryId{"US"}, Timezone{1510}}, // Kansas City International Airport
    Airport{IataCode{"MCJ"}, CountryId{"CO"}, Timezone{1376}}, // Jorge Isaacs Airport
    Airport{IataCode{"MCK"}, CountryId{"US"}, Timezone{1510}}, // McCook Ben Nelson Regional Airport
    Airport{IataCode{"MCL"}, CountryId{"US"}, Timezone{814}}, // McKinley National Park Airport
    Airport{IataCode{"MCN"}, CountryId{"US"}, Timezone{2712}}, // Middle Georgia Regional Airport
    Airport{IataCode{"MCO"}, CountryId{"US"}, Timezone{2712}}, // Orlando International Airport
    Airport{IataCode{"MCP"}, CountryId{"BR"}, Timezone{1308}}, // Macapá International Airport
    Airport{IataCode{"MCQ"}, CountryId{"HU"}, Timezone{5264}}, // Miskolc Airport
    Airport{IataCode{"MCS"}, CountryId{"AR"}, Timezone{942}}, // Monte Caseros Airport
    Airport{IataCode{"MCT"}, CountryId{"OM"}, Timezone{4252}}, // Muscat International Airport
    Airport{IataCode{"MCU"}, CountryId{"FR"}, Timezone{5646}}, // Montluçon – Guéret Airport
    Airport{IataCode{"MCV"}, CountryId{"AU"}, Timezone{4978}}, // McArthur River Mine Airport
    Airport{IataCode{"MCW"}, CountryId{"US"}, Timezone{1510}}, // Mason City Municipal Airport
    Airport{IataCode{"MCX"}, CountryId{"RU"}, Timezone{5620}}, // Uytash Airport
    Airport{IataCode{"MCY"}, CountryId{"AU"}, Timezone{4920}}, // Sunshine Coast Airport
    Airport{IataCode{"MCZ"}, CountryId{"BR"}, Timezone{2420}}, // Zumbi dos Palmares International Airport
    Airport{IataCode{"MDB"}, CountryId{"BZ"}, Timezone{1322}}, // Melinda Airport
    Airport{IataCode{"MDC"}, CountryId{"ID"}, Timezone{4226}}, // Sam Ratulangi International Airport
    Airport{IataCode{"MDD"}, CountryId{"US"}, Timezone{1510}}, // Midland Airpark
    Airport{IataCode{"MDE"}, CountryId{"CO"}, Timezone{1376}}, // José María Córdova International Airport
    Airport{IataCode{"MDF"}, CountryId{"US"}, Timezone{1510}}, // Taylor County Airport
    Airport{IataCode{"MDG"}, CountryId{"CN"}, Timezone{4456}}, // Mudanjiang Hailang International Airport
    Airport{IataCode{"MDH"}, CountryId{"US"}, Timezone{1510}}, // Southern Illinois Airport
    Airport{IataCode{"MDI"}, CountryId{"NG"}, Timezone{462}}, // Makurdi Airport
    Airport{IataCode{"MDJ"}, CountryId{"US"}, Timezone{2378}}, // Madras Municipal Airport
    Airport{IataCode{"MDK"}, CountryId{"CD"}, Timezone{446}}, // Mbandaka Airport
    Airport{IataCode{"MDL"}, CountryId{"MM"}, Timezone{4678}}, // Mandalay International Airport
    Airport{IataCode{"MDN"}, CountryId{"US"}, Timezone{2043}}, // Madison Municipal Airport
    Airport{IataCode{"MDO"}, CountryId{"US"}, Timezone{814}}, // Middleton Island Airport
    Airport{IataCode{"MDQ"}, CountryId{"AR"}, Timezone{883}}, // Astor Piazzolla International Airport
    Airport{IataCode{"MDS"}, CountryId{"GB"}, Timezone{1859}}, // Middle Caicos Airport
    Airport{IataCode{"MDT"}, CountryId{"US"}, Timezone{2712}}, // Harrisburg International Airport
    Airport{IataCode{"MDU"}, CountryId{"PG"}, Timezone{6686}}, // Mendi Airport
    Airport{IataCode{"MDV"}, CountryId{"GA"}, Timezone{551}}, // Médouneu Airport
    Airport{IataCode{"MDW"}, CountryId{"US"}, Timezone{1510}}, // Chicago Midway International Airport
    Airport{IataCode{"MDX"}, CountryId{"AR"}, Timezone{942}}, // Mercedes Airport
    Airport{IataCode{"MDY"}, CountryId{"US"}, Timezone{6548}}, // Henderson Field
    Airport{IataCode{"MDZ"}, CountryId{"AR"}, Timezone{1019}}, // Governor Francisco Gabrielli International Airport
    Airport{IataCode{"MEA"}, CountryId{"BR"}, Timezone{3216}}, // Macaé Airport
    Airport{IataCode{"MEB"}, CountryId{"AU"}, Timezone{5067}}, // Essendon Airport
    Airport{IataCode{"MEC"}, CountryId{"EC"}, Timezone{1949}}, // Eloy Alfaro International Airport
    Airport{IataCode{"MED"}, CountryId{"SA"}, Timezone{4404}}, // Prince Mohammad Bin Abdulaziz Airport
    Airport{IataCode{"MEE"}, CountryId{"FR"}, Timezone{6606}}, // Maré Airport
    Airport{IataCode{"MEF"}, CountryId{"TD"}, Timezone{656}}, // Melfi Airport
    Airport{IataCode{"MEG"}, CountryId{"AO"}, Timezone{505}}, // Malanje Airport
    Airport{IataCode{"MEH"}, CountryId{"NO"}, Timezone{5634}}, // Mehamn Airport
    Airport{IataCode{"MEI"}, CountryId{"US"}, Timezone{1510}}, // Meridian Regional Airport
    Airport{IataCode{"MEJ"}, CountryId{"US"}, Timezone{2712}}, // Port Meadville Airport
    Airport{IataCode{"MEL"}, CountryId{"AU"}, Timezone{5067}}, // Melbourne Airport
    Airport{IataCode{"MEM"}, CountryId{"US"}, Timezone{1510}}, // Memphis International Airport
    Airport{IataCode{"MEN"}, CountryId{"FR"}, Timezone{5646}}, // Mende - Brenoux Airport
    Airport{IataCode{"MEO"}, CountryId{"US"}, Timezone{2712}}, // Dare County Regional Airport
    Airport{IataCode{"MEP"}, CountryId{"MY"}, Timezone{4159}}, // Mersing Airport
    Airport{IataCode{"MEQ"}, CountryId{"ID"}, Timezone{4032}}, // Cut Nyak Dhien Airport
    Airport{IataCode{"MER"}, CountryId{"US"}, Timezone{2378}}, // Castle Airport
    Airport{IataCode{"MEU"}, CountryId{"BR"}, Timezone{3160}}, // Monte Dourado Airport
    Airport{IataCode{"MEV"}, CountryId{"US"}, Timezone{2378}}, // Minden-Tahoe Airport
    Airport{IataCode{"MEW"}, CountryId{"CD"}, Timezone{519}}, // Mweka Airport
    Airport{IataCode{"MEX"}, CountryId{"MX"}, Timezone{2588}}, // Mexico City International Airport
    Airport{IataCode{"MEY"}, CountryId{"NP"}, Timezone{4100}}, // Meghauli Airport
    Airport{IataCode{"MEZ"}, CountryId{"US"}, Timezone{1510}}, // Mena Intermountain Municipal Airport
    Airport{IataCode{"MFA"}, CountryId{"TZ"}, Timezone{256}}, // Mafia Airport
    Airport{IataCode{"MFC"}, CountryId{"LS"}, Timezone{}}, // Mafeteng Airport
    Airport{IataCode{"MFD"}, CountryId{"US"}, Timezone{2712}}, // Mansfield Lahm Regional Airport
    Airport{IataCode{"MFE"}, CountryId{"US"}, Timezone{1510}}, // McAllen-Miller International Airport
    Airport{IataCode{"MFF"}, CountryId{"GA"}, Timezone{475}}, // Moanda Airport
    Airport{IataCode{"MFG"}, CountryId{"PK"}, Timezone{4087}}, // Muzaffarabad Airport
    Airport{IataCode{"MFH"}, CountryId{"US"}, Timezone{2378}}, // Mesquite Airport
    Airport{IataCode{"MFI"}, CountryId{"US"}, Timezone{1510}}, // Marshfield Municipal Airport
    Airport{IataCode{"MFJ"}, CountryId{"FJ"}, Timezone{6349}}, // Moala Airport
    Airport{IataCode{"MFK"}, CountryId{"TW"}, Timezone{4456}}, // Matsu Beigan Airport
    Airport{IataCode{"MFM"}, CountryId{"CN"}, Timezone{4456}}, // Macau International Airport
    Airport{IataCode{"MFN"}, CountryId{"NZ"}, Timezone{6218}}, // Milford Sound Airport
    Airport{IataCode{"MFO"}, CountryId{"PG"}, Timezone{6686}}, // Manguna Airport
    Airport{IataCode{"MFQ"}, CountryId{"NE"}, Timezone{672}}, // Maradi Airport
    Airport{IataCode{"MFR"}, CountryId{"US"}, Timezone{2378}}, // Rogue Valley International-Medford Airport
    Airport{IataCode{"MFS"}, CountryId{"CO"}, Timezone{1376}}, // Miraflores Airport
    Airport{IataCode{"MFU"}, CountryId{"ZM"}, Timezone{537}}, // Mfuwe Airport
    Airport{IataCode{"MFV"}, CountryId{"US"}, Timezone{2712}}, // Accomack County Airport
    Airport{IataCode{"MFX"}, CountryId{"FR"}, Timezone{5646}}, // Méribel Airport
    Airport{IataCode{"MGA"}, CountryId{"NI"}, Timezone{2435}}, // Augusto C. Sandino International Airport
    Airport{IataCode{"MGB"}, CountryId{"AU"}, Timezone{4901}}, // Mount Gambier Airport
    Airport{IataCode{"MGC"}, CountryId{"US"}, Timezone{1510}}, // Michigan City Municipal Airport
    Airport{IataCode{"MGD"}, CountryId{"BO"}, Timezone{2350}}, // Magdalena Airport
    Airport{IataCode{"MGE"}, CountryId{"CO"}, Timezone{1376}}, // Baracoa Regional Airport
    Airport{IataCode{"MGF"}, CountryId{"BR"}, Timezone{3216}}, // Maringá Regional Airport
    Airport{IataCode{"MGG"}, CountryId{"US"}, Timezone{1510}}, // Maple Lake Municipal Airport
    Airport{IataCode{"MGH"}, CountryId{"ZA"}, Timezone{369}}, // Margate Airport
    Airport{IataCode{"MGI"}, CountryId{"UY"}, Timezone{883}}, // Martín García Island Airport
    Airport{IataCode{"MGJ"}, CountryId{"US"}, Timezone{2712}}, // Orange County Airport
    Airport{IataCode{"MGL"}, CountryId{"DE"}, Timezone{5199}}, // Düsseldorf Mönchengladbach Airport
    Airport{IataCode{"MGM"}, CountryId{"US"}, Timezone{1510}}, // Montgomery Regional Airport
    Airport{IataCode{"MGN"}, CountryId{"CO"}, Timezone{1376}}, // Baracoa Airport
    Airport{IataCode{"MGQ"}, CountryId{"SO"}, Timezone{608}}, // Aden Adde International Airport
    Airport{IataCode{"MGR"}, CountryId{"US"}, Timezone{2712}}, // Moultrie Municipal Airport
    Airport{IataCode{"MGT"}, CountryId{"AU"}, Timezone{4978}}, // Milingimbi Airport
    Airport{IataCode{"MGV"}, CountryId{"AU"}, Timezone{5087}}, // Margaret River Station Airport
    Airport{IataCode{"MGW"}, CountryId{"US"}, Timezone{2712}}, // Morgantown Municipal Airport
    Airport{IataCode{"MGX"}, CountryId{"GA"}, Timezone{475}}, // Moabi Airport
    Airport{IataCode{"MGY"}, CountryId{"US"}, Timezone{2712}}, // Dayton–Wright Brothers Airport
    Airport{IataCode{"MGZ"}, CountryId{"MM"}, Timezone{4678}}, // Myeik Airport
    Airport{IataCode{"MHA"}, CountryId{"GY"}, Timezone{1949}}, // Mahdia Airport
    Airport{IataCode{"MHC"}, CountryId{"CL"}, Timezone{3177}}, // Mocopulli Airport
    Airport{IataCode{"MHD"}, CountryId{"IR"}, Timezone{4543}}, // Mashhad International Airport
    Airport{IataCode{"MHE"}, CountryId{"US"}, Timezone{1510}}, // Mitchell Municipal Airport
    Airport{IataCode{"MHH"}, CountryId{"BS"}, Timezone{2697}}, // Leonard M. Thompson International Airport
    Airport{IataCode{"MHI"}, CountryId{"DJ"}, Timezone{277}}, // Moucha Airport
    Airport{IataCode{"MHK"}, CountryId{"US"}, Timezone{1510}}, // Manhattan Regional Airport
    Airport{IataCode{"MHL"}, CountryId{"US"}, Timezone{1510}}, // Marshall Memorial Municipal Airport
    Airport{IataCode{"MHM"}, CountryId{"US"}, Timezone{814}}, // Minchumina Airport
    Airport{IataCode{"MHP"}, CountryId{"BY"}, Timezone{5593}}, // Minsk-1 Airport
    Airport{IataCode{"MHQ"}, CountryId{"FI"}, Timezone{5576}}, // Mariehamn Airport
    Airport{IataCode{"MHR"}, CountryId{"US"}, Timezone{2378}}, // Sacramento Mather Airport
    Airport{IataCode{"MHS"}, CountryId{"US"}, Timezone{2378}}, // Dunsmuir Municipal-Mott Airport
    Airport{IataCode{"MHT"}, CountryId{"US"}, Timezone{2712}}, // Manchester–Boston Regional Airport
    Airport{IataCode{"MHU"}, CountryId{"AU"}, Timezone{5067}}, // Mount Hotham Airport
    Airport{IataCode{"MHV"}, CountryId{"US"}, Timezone{2378}}, // Mojave Air and Space Port
    Airport{IataCode{"MHW"}, CountryId{"BO"}, Timezone{2350}}, // Monteagudo Airport
    Airport{IataCode{"MHX"}, CountryId{"NZ"}, Timezone{6707}}, // Manihiki Island Airport
    Airport{IataCode{"MIA"}, CountryId{"US"}, Timezone{2712}}, // Miami International Airport
    Airport{IataCode{"MIC"}, CountryId{"US"}, Timezone{1510}}, // Crystal Airport
    Airport{IataCode{"MID"}, CountryId{"MX"}, Timezone{2554}}, // Manuel Crescencio Rejón International Airport
    Airport{IataCode{"MIE"}, CountryId{"US"}, Timezone{2043}}, // Delaware County Airport
    Airport{IataCode{"MIG"}, CountryId{"CN"}, Timezone{4456}}, // Mianyang Nanjiao Airport
    Airport{IataCode{"MII"}, CountryId{"BR"}, Timezone{3216}}, // Marília Airport
    Airport{IataCode{"MIJ"}, CountryId{"MH"}, Timezone{}}, // Mili Airport
    Airport{IataCode{"MIK"}, CountryId{"FI"}, Timezone{5377}}, // Mikkeli Airport
    Airport{IataCode{"MIM"}, CountryId{"AU"}, Timezone{5103}}, // Merimbula Airport
    Airport{IataCode{"MIO"}, CountryId{"US"}, Timezone{1510}}, // Miami Municipal Airport
    Airport{IataCode{"MIP"}, CountryId{"IL"}, Timezone{4046}}, // Mitzpe Ramon Airfield
    Airport{IataCode{"MIQ"}, CountryId{"US"}, Timezone{1510}}, // Millard Airport
    Airport{IataCode{"MIR"}, CountryId{"TN"}, Timezone{772}}, // Monastir Habib Bourguiba International Airport
    Airport{IataCode{"MIS"}, CountryId{"PG"}, Timezone{6686}}, // Misima Airport
    Airport{IataCode{"MIT"}, CountryId{"US"}, Timezone{2378}}, // Shafter Airport
    Airport{IataCode{"MIU"}, CountryId{"NG"}, Timezone{462}}, // Maiduguri International Airport
    Airport{IataCode{"MIV"}, CountryId{"US"}, Timezone{2712}}, // Millville Municipal Airport
    Airport{IataCode{"MJA"}, CountryId{"MG"}, Timezone{6035}}, // Manja Airport
    Airport{IataCode{"MJB"}, CountryId{"MH"}, Timezone{}}, // Mejit Airport
    Airport{IataCode{"MJC"}, CountryId{"CI"}, Timezone{0}}, // Man Airport
    Airport{IataCode{"MJD"}, CountryId{"PK"}, Timezone{4087}}, // Moenjodaro Airport
    Airport{IataCode{"MJE"}, CountryId{"MH"}, Timezone{}}, // Majkin Airport
    Airport{IataCode{"MJF"}, CountryId{"NO"}, Timezone{5634}}, // Mosjøen Airport
    Airport{IataCode{"MJI"}, CountryId{"LY"}, Timezone{757}}, // Mitiga International Airport
    Airport{IataCode{"MJK"}, CountryId{"AU"}, Timezone{5087}}, // Shark Bay Airport
    Airport{IataCode{"MJL"}, CountryId{"GA"}, Timezone{475}}, // Mouila Airport
    Airport{IataCode{"MJM"}, CountryId{"CD"}, Timezone{519}}, // Mbuji Mayi Airport
    Airport{IataCode{"MJN"}, CountryId{"MG"}, Timezone{6035}}, // Amborovy Airport
    Airport{IataCode{"MJO"}, CountryId{"NA"}, Timezone{785}}, // Mount Etjo Airport
    Airport{IataCode{"MJP"}, CountryId{"AU"}, Timezone{5087}}, // Manjimup Airport
    Airport{IataCode{"MJQ"}, CountryId{"US"}, Timezone{1510}}, // Jackson Municipal Airport, Minnesota
    Airport{IataCode{"MJR"}, CountryId{"AR"}, Timezone{883}}, // Miramar Airport
    Airport{IataCode{"MJT"}, CountryId{"GR"}, Timezone{5169}}, // Mytilene International Airport
    Airport{IataCode{"MJU"}, CountryId{"ID"}, Timezone{4226}}, // Tampa Padang Airport
    Airport{IataCode{"MJV"}, CountryId{"ES"}, Timezone{5549}}, // Murcia-San Javier Airport
    Airport{IataCode{"MJX"}, CountryId{"US"}, Timezone{2712}}, // Robert J. Miller Air Park
    Airport{IataCode{"MJZ"}, CountryId{"RU"}, Timezone{4665}}, // Mirny Airport
    Airport{IataCode{"MKA"}, CountryId{"CZ"}, Timezone{5676}}, // Marianske Lazne Airport
    Airport{IataCode{"MKB"}, CountryId{"GA"}, Timezone{475}}, // Mékambo Airport
    Airport{IataCode{"MKC"}, CountryId{"US"}, Timezone{1510}}, // Charles B. Wheeler Downtown Airport
    Airport{IataCode{"MKE"}, CountryId{"US"}, Timezone{1510}}, // General Mitchell International Airport
    Airport{IataCode{"MKF"}, CountryId{"ID"}, Timezone{}}, // Miangas Airport
    Airport{IataCode{"MKG"}, CountryId{"US"}, Timezone{1682}}, // Muskegon County Airport
    Airport{IataCode{"MKH"}, CountryId{"LS"}, Timezone{579}}, // Mokhotlong Airport
    Airport{IataCode{"MKI"}, CountryId{"CF"}, Timezone{104}}, // Poste Airport
    Airport{IataCode{"MKJ"}, CountryId{"CG"}, Timezone{148}}, // Makoua Airport
    Airport{IataCode{"MKK"}, CountryId{"US"}, Timezone{6446}}, // Molokai Airport
    Airport{IataCode{"MKL"}, CountryId{"US"}, Timezone{1510}}, // McKellar-Sipes Regional Airport
    Airport{IataCode{"MKM"}, CountryId{"MY"}, Timezone{4190}}, // Mukah Airport
    Airport{IataCode{"MKN"}, CountryId{"US"}, Timezone{1510}}, // Comanche County-City Airport
    Airport{IataCode{"MKO"}, CountryId{"US"}, Timezone{1510}}, // Davis Field
    Airport{IataCode{"MKQ"}, CountryId{"ID"}, Timezone{4032}}, // Mopah Airport
    Airport{IataCode{"MKR"}, CountryId{"AU"}, Timezone{5087}}, // Meekatharra Airport
    Airport{IataCode{"MKS"}, CountryId{"ET"}, Timezone{28}}, // Mekane Selam Airport
    Airport{IataCode{"MKT"}, CountryId{"US"}, Timezone{1510}}, // Mankato Regional Airport
    Airport{IataCode{"MKU"}, CountryId{"GA"}, Timezone{475}}, // Makokou Airport
    Airport{IataCode{"MKW"}, CountryId{"ID"}, Timezone{4032}}, // Rendani Airport
    Airport{IataCode{"MKY"}, CountryId{"AU"}, Timezone{4920}}, // Mackay Airport
    Airport{IataCode{"MKZ"}, CountryId{"MY"}, Timezone{4159}}, // Malacca International Airport
    Airport{IataCode{"MLA"}, CountryId{"MT"}, Timezone{5563}}, // Malta International Airport
    Airport{IataCode{"MLB"}, CountryId{"US"}, Timezone{2712}}, // Melbourne International Airport
    Airport{IataCode{"MLC"}, CountryId{"US"}, Timezone{1510}}, // McAlester Regional Airport
    Airport{IataCode{"MLE"}, CountryId{"MV"}, Timezone{6142}}, // Ibrahim Nasir International Airport
    Airport{IataCode{"MLG"}, CountryId{"ID"}, Timezone{4032}}, // Abdul Rachman Saleh Airport
    Airport{IataCode{"MLH"}, CountryId{"FR"}, Timezone{5646}}, // EuroAirport Basel-Mulhouse-Freiburg
    Airport{IataCode{"MLI"}, CountryId{"US"}, Timezone{1510}}, // Quad City International Airport
    Airport{IataCode{"MLJ"}, CountryId{"US"}, Timezone{2712}}, // Baldwin County Airport
    Airport{IataCode{"MLK"}, CountryId{"US"}, Timezone{1667}}, // Malta Airport (Montana)
    Airport{IataCode{"MLL"}, CountryId{"US"}, Timezone{2745}}, // Marshall Don Hunter Sr. Airport
    Airport{IataCode{"MLM"}, CountryId{"MX"}, Timezone{2588}}, // General Francisco J. Mujica International Airport
    Airport{IataCode{"MLN"}, CountryId{"ES"}, Timezone{215}}, // Melilla Airport
    Airport{IataCode{"MLO"}, CountryId{"GR"}, Timezone{5169}}, // Milos Island National Airport
    Airport{IataCode{"MLP"}, CountryId{"PH"}, Timezone{4240}}, // Malabang Airport
    Airport{IataCode{"MLS"}, CountryId{"US"}, Timezone{1667}}, // Miles City Airport
    Airport{IataCode{"MLT"}, CountryId{"US"}, Timezone{2712}}, // Millinocket Municipal Airport
    Airport{IataCode{"MLU"}, CountryId{"US"}, Timezone{1510}}, // Monroe Regional Airport
    Airport{IataCode{"MLW"}, CountryId{"LR"}, Timezone{625}}, // Spriggs Payne Airport
    Airport{IataCode{"MLY"}, CountryId{"US"}, Timezone{814}}, // Manley Hot Springs Airport
    Airport{IataCode{"MLZ"}, CountryId{"UY"}, Timezone{2659}}, // Cerro Largo International Airport
    Airport{IataCode{"MMA"}, CountryId{"SE"}, Timezone{}}, // Bulltofta Airport
    Airport{IataCode{"MMB"}, CountryId{"JP"}, Timezone{4568}}, // Memanbetsu Airport
    Airport{IataCode{"MMC"}, CountryId{"MX"}, Timezone{2641}}, // Ciudad Mante National Airport
    Airport{IataCode{"MMD"}, CountryId{"JP"}, Timezone{}}, // Minami-Daito Airport
    Airport{IataCode{"MME"}, CountryId{"GB"}, Timezone{5517}}, // Durham Tees Valley Airport
    Airport{IataCode{"MMF"}, CountryId{"CM"}, Timezone{293}}, // Mamfe Airport
    Airport{IataCode{"MMG"}, CountryId{"AU"}, Timezone{5087}}, // Mount Magnet Airport
    Airport{IataCode{"MMH"}, CountryId{"US"}, Timezone{2378}}, // Mammoth Yosemite Airport
    Airport{IataCode{"MMI"}, CountryId{"US"}, Timezone{2712}}, // McMinn County Airport
    Airport{IataCode{"MMJ"}, CountryId{"JP"}, Timezone{4568}}, // Matsumoto Airport
    Airport{IataCode{"MMK"}, CountryId{"RU"}, Timezone{5620}}, // Murmansk Airport
    Airport{IataCode{"MML"}, CountryId{"US"}, Timezone{1510}}, // Southwest Minnesota Regional Airport
    Airport{IataCode{"MMM"}, CountryId{"AU"}, Timezone{4920}}, // Middlemount Airport
    Airport{IataCode{"MMN"}, CountryId{"US"}, Timezone{2712}}, // Minute Man Air Field
    Airport{IataCode{"MMO"}, CountryId{"CV"}, Timezone{4771}}, // Maio Airport
    Airport{IataCode{"MMP"}, CountryId{"CO"}, Timezone{1376}}, // San Bernardo Airport
    Airport{IataCode{"MMQ"}, CountryId{"ZM"}, Timezone{537}}, // Mbala Airport
    Airport{IataCode{"MMT"}, CountryId{"US"}, Timezone{2712}}, // McEntire Joint National Guard Base
    Airport{IataCode{"MMU"}, CountryId{"US"}, Timezone{2712}}, // Morristown Municipal Airport
    Airport{IataCode{"MMV"}, CountryId{"US"}, Timezone{2378}}, // McMinnville Municipal Airport
    Airport{IataCode{"MMX"}, CountryId{"SE"}, Timezone{5822}}, // Malmö Airport
    Airport{IataCode{"MMY"}, CountryId{"JP"}, Timezone{4568}}, // Miyako Airport
    Airport{IataCode{"MMZ"}, CountryId{"AF"}, Timezone{4061}}, // Maimana Airfield
    Airport{IataCode{"MNA"}, CountryId{"ID"}, Timezone{4226}}, // Melonguane Airport
    Airport{IataCode{"MNB"}, CountryId{"CD"}, Timezone{446}}, // Muanda Airport
    Airport{IataCode{"MNC"}, CountryId{"MZ"}, Timezone{565}}, // Nacala Airport
    Airport{IataCode{"MNF"}, CountryId{"FJ"}, Timezone{6349}}, // Mana Island Airport
    Airport{IataCode{"MNG"}, CountryId{"AU"}, Timezone{4978}}, // Maningrida Airport
    Airport{IataCode{"MNH"}, CountryId{"OM"}, Timezone{4252}}, // Rustaq Airport
    Airport{IataCode{"MNI"}, CountryId{"GB"}, Timezone{2678}}, // John A. Osborne Airport
    Airport{IataCode{"MNJ"}, CountryId{"MG"}, Timezone{6035}}, // Mananjary Airport
    Airport{IataCode{"MNK"}, CountryId{"KI"}, Timezone{}}, // Maiana Airport
    Airport{IataCode{"MNL"}, CountryId{"PH"}, Timezone{4240}}, // Ninoy Aquino International Airport
    Airport{IataCode{"MNM"}, CountryId{"US"}, Timezone{2536}}, // Menominee-Marinette Twin County Airport
    Airport{IataCode{"MNN"}, CountryId{"US"}, Timezone{2712}}, // Marion Municipal Airport
    Airport{IataCode{"MNQ"}, CountryId{"AU"}, Timezone{4920}}, // Monto Airport
    Airport{IataCode{"MNR"}, CountryId{"ZM"}, Timezone{537}}, // Mongu Airport
    Airport{IataCode{"MNS"}, CountryId{"ZM"}, Timezone{537}}, // Mansa Airport
    Airport{IataCode{"MNT"}, CountryId{"US"}, Timezone{814}}, // Minto Al Wright Airport
    Airport{IataCode{"MNU"}, CountryId{"MM"}, Timezone{4678}}, // Mawlamyaing Airport
    Airport{IataCode{"MNV"}, CountryId{"US"}, Timezone{2712}}, // Monroe County Airport
    Airport{IataCode{"MNX"}, CountryId{"BR"}, Timezone{2451}}, // Manicoré Airport
    Airport{IataCode{"MNY"}, CountryId{"SB"}, Timezone{}}, // Mono Airport
    Airport{IataCode{"MNZ"}, CountryId{"US"}, Timezone{2712}}, // Manassas Regional Airport
    Airport{IataCode{"MOA"}, CountryId{"CU"}, Timezone{1980}}, // Orestes Acosta Airport
    Airport{IataCode{"MOB"}, CountryId{"US"}, Timezone{1510}}, // Mobile Regional Airport
    Airport{IataCode{"MOC"}, CountryId{"BR"}, Timezone{3216}}, // Montes Claros Airport
    Airport{IataCode{"MOD"}, CountryId{"US"}, Timezone{2378}}, // Modesto City-County Airport
    Airport{IataCode{"MOE"}, CountryId{"MM"}, Timezone{4678}}, // Momeik Airport
    Airport{IataCode{"MOF"}, CountryId{"ID"}, Timezone{4226}}, // Frans Seda Airport
    Airport{IataCode{"MOG"}, CountryId{"MM"}, Timezone{4678}}, // Monghsat Airport
    Airport{IataCode{"MOI"}, CountryId{"NZ"}, Timezone{6707}}, // Mitiaro Airport
    Airport{IataCode{"MOJ"}, CountryId{"SR"}, Timezone{2912}}, // Moengo Airstrip
    Airport{IataCode{"MOL"}, CountryId{"NO"}, Timezone{5634}}, // Molde Airport
    Airport{IataCode{"MOM"}, CountryId{"MR"}, Timezone{686}}, // Letfotar Airport
    Airport{IataCode{"MON"}, CountryId{"NZ"}, Timezone{6218}}, // Glentanner Aerodrome
    Airport{IataCode{"MOO"}, CountryId{"AU"}, Timezone{4901}}, // Moomba Airport
    Airport{IataCode{"MOP"}, CountryId{"US"}, Timezone{1682}}, // Mount Pleasant Municipal Airport
    Airport{IataCode{"MOQ"}, CountryId{"MG"}, Timezone{6035}}, // Morondava Airport
    Airport{IataCode{"MOR"}, CountryId{"US"}, Timezone{2712}}, // Morristown Regional Airport
    Airport{IataCode{"MOS"}, CountryId{"US"}, Timezone{2745}}, // Moses Point Airport
    Airport{IataCode{"MOT"}, CountryId{"US"}, Timezone{1510}}, // Minot International Airport
    Airport{IataCode{"MOU"}, CountryId{"US"}, Timezone{2745}}, // Mountain Village Airport
    Airport{IataCode{"MOV"}, CountryId{"AU"}, Timezone{4920}}, // Moranbah Airport
    Airport{IataCode{"MOZ"}, CountryId{"FR"}, Timezone{6740}}, // Moorea Airport
    Airport{IataCode{"MPA"}, CountryId{"NA"}, Timezone{537}}, // Katima Mulilo Airport
    Airport{IataCode{"MPB"}, CountryId{"US"}, Timezone{2712}}, // Miami Seaplane Base
    Airport{IataCode{"MPD"}, CountryId{"PK"}, Timezone{4087}}, // Sindhri Airport
    Airport{IataCode{"MPE"}, CountryId{"US"}, Timezone{2712}}, // Griswold Airport
    Airport{IataCode{"MPG"}, CountryId{"US"}, Timezone{2712}}, // Marshall County Airport
    Airport{IataCode{"MPH"}, CountryId{"PH"}, Timezone{4240}}, // Godofredo P. Ramos Airport
    Airport{IataCode{"MPJ"}, CountryId{"US"}, Timezone{1510}}, // Petit Jean Park Airport
    Airport{IataCode{"MPK"}, CountryId{"KR"}, Timezone{4445}}, // Mokpo Airport
    Airport{IataCode{"MPL"}, CountryId{"FR"}, Timezone{5646}}, // Montpellier – Méditerranée Airport
    Airport{IataCode{"MPM"}, CountryId{"MZ"}, Timezone{565}}, // Maputo International Airport
    Airport{IataCode{"MPO"}, CountryId{"US"}, Timezone{2712}}, // Pocono Mountains Municipal Airport
    Airport{IataCode{"MPP"}, CountryId{}, Timezone{2877}}, // Mulatupo Airport
    Airport{IataCode{"MPS"}, CountryId{"US"}, Timezone{1510}}, // Mount Pleasant Regional Airport (Texas)
    Airport{IataCode{"MPV"}, CountryId{"US"}, Timezone{2712}}, // Edward F. Knapp State Airport
    Airport{IataCode{"MPW"}, CountryId{"UA"}, Timezone{5461}}, // Mariupol International Airport
    Airport{IataCode{"MPY"}, CountryId{"FR"}, Timezone{2912}}, // Maripasoula Airport
    Airport{IataCode{"MPZ"}, CountryId{"US"}, Timezone{1510}}, // Mount Pleasant Municipal Airport
    Airport{IataCode{"MQB"}, CountryId{"US"}, Timezone{1510}}, // Macomb Municipal Airport
    Airport{IataCode{"MQC"}, CountryId{"FR"}, Timezone{2608}}, // Miquelon Airport
    Airport{IataCode{"MQD"}, CountryId{"AR"}, Timezone{1076}}, // Maquinchao Airport
    Airport{IataCode{"MQF"}, CountryId{"RU"}, Timezone{4690}}, // Magnitogorsk International Airport
    Airport{IataCode{"MQH"}, CountryId{"BR"}, Timezone{3216}}, // Minaçu Airport
    Airport{IataCode{"MQJ"}, CountryId{"RU"}, Timezone{4485}}, // Moma Airport
    Airport{IataCode{"MQK"}, CountryId{"BO"}, Timezone{1579}}, // San Matías Airport
    Airport{IataCode{"MQL"}, CountryId{"AU"}, Timezone{5103}}, // Mildura Airport
    Airport{IataCode{"MQM"}, CountryId{"TR"}, Timezone{5412}}, // Mardin Airport
    Airport{IataCode{"MQN"}, CountryId{"NO"}, Timezone{5634}}, // Mo i Rana Airport
    Airport{IataCode{"MQP"}, CountryId{"ZA"}, Timezone{369}}, // Kruger Mpumalanga International Airport
    Airport{IataCode{"MQQ"}, CountryId{"TD"}, Timezone{656}}, // Moundou Airport
    Airport{IataCode{"MQS"}, CountryId{"VC"}, Timezone{3360}}, // Mustique Airport
    Airport{IataCode{"MQT"}, CountryId{"US"}, Timezone{1682}}, // Sawyer International Airport
    Airport{IataCode{"MQU"}, CountryId{"CO"}, Timezone{1376}}, // Mariquita Airport
    Airport{IataCode{"MQV"}, CountryId{"DZ"}, Timezone{47}}, // Mostaganem Airport
    Airport{IataCode{"MQW"}, CountryId{"US"}, Timezone{2712}}, // Telfair-Wheeler Airport
    Airport{IataCode{"MQX"}, CountryId{"ET"}, Timezone{28}}, // Alula Aba Nega Airport
    Airport{IataCode{"MQY"}, CountryId{"US"}, Timezone{1510}}, // Smyrna Airport
    Airport{IataCode{"MQZ"}, CountryId{"AU"}, Timezone{5087}}, // Margaret River Airport
    Airport{IataCode{"MRA"}, CountryId{"LY"}, Timezone{757}}, // Misrata Airport
    Airport{IataCode{"MRB"}, CountryId{"US"}, Timezone{2712}}, // Eastern WV Regional Airport
    Airport{IataCode{"MRC"}, CountryId{"US"}, Timezone{1510}}, // Maury County Airport
    Airport{IataCode{"MRD"}, CountryId{"VE"}, Timezone{1463}}, // Alberto Carnevalli Airport
    Airport{IataCode{"MRE"}, CountryId{"KE"}, Timezone{641}}, // Mara Serena Airport
    Airport{IataCode{"MRF"}, CountryId{"US"}, Timezone{1510}}, // Marfa Municipal Airport
    Airport{IataCode{"MRG"}, CountryId{"AU"}, Timezone{4920}}, // Mareeba Airfield
    Airport{IataCode{"MRH"}, CountryId{"US"}, Timezone{2712}}, // Michael J. Smith Field
    Airport{IataCode{"MRI"}, CountryId{"US"}, Timezone{814}}, // Merrill Field
    Airport{IataCode{"MRJ"}, CountryId{"HN"}, Timezone{3401}}, // Marcala Airport
    Airport{IataCode{"MRK"}, CountryId{"US"}, Timezone{2712}}, // Marco Island Airport
    Airport{IataCode{"MRN"}, CountryId{"US"}, Timezone{2712}}, // Foothills Regional Airport
    Airport{IataCode{"MRO"}, CountryId{"NZ"}, Timezone{6218}}, // Hood Aerodrome
    Airport{IataCode{"MRQ"}, CountryId{"PH"}, Timezone{4240}}, // Marinduque Airport
    Airport{IataCode{"MRR"}, CountryId{"EC"}, Timezone{1949}}, // José María Velasco Ibarra Airport
    Airport{IataCode{"MRS"}, CountryId{"FR"}, Timezone{5646}}, // Marseille Provence Airport
    Airport{IataCode{"MRT"}, CountryId{"US"}, Timezone{2712}}, // Union County Airport
    Airport{IataCode{"MRU"}, CountryId{"MU"}, Timezone{6158}}, // Sir Seewoosagur Ramgoolam International Airport
    Airport{IataCode{"MRV"}, CountryId{"RU"}, Timezone{5620}}, // Mineralnye Vody Airport
    Airport{IataCode{"MRW"}, CountryId{"DK"}, Timezone{5312}}, // Lolland Falster Airport
    Airport{IataCode{"MRX"}, CountryId{"IR"}, Timezone{4543}}, // Mahshahr Airport
    Airport{IataCode{"MRY"}, CountryId{"US"}, Timezone{2378}}, // Monterey Regional Airport
    Airport{IataCode{"MRZ"}, CountryId{"AU"}, Timezone{5103}}, // Moree Airport
    Airport{IataCode{"MSA"}, CountryId{"CA"}, Timezone{3540}}, // Muskrat Dam Airport
    Airport{IataCode{"MSC"}, CountryId{"US"}, Timezone{2931}}, // Falcon Field
    Airport{IataCode{"MSD"}, CountryId{"US"}, Timezone{1667}}, // Mount Pleasant Airport (Utah)
    Airport{IataCode{"MSE"}, CountryId{"GB"}, Timezone{5517}}, // Manston Airport
    Airport{IataCode{"MSF"}, CountryId{"AU"}, Timezone{4978}}, // Mount Swan Airport
    Airport{IataCode{"MSG"}, CountryId{"LS"}, Timezone{579}}, // Matsaile Airport
    Airport{IataCode{"MSJ"}, CountryId{"JP"}, Timezone{4568}}, // Misawa Airport
    Airport{IataCode{"MSL"}, CountryId{"US"}, Timezone{1510}}, // Northwest Alabama Regional Airport
    Airport{IataCode{"MSM"}, CountryId{"CD"}, Timezone{446}}, // Masi-Manimba Airport
    Airport{IataCode{"MSN"}, CountryId{"PH"}, Timezone{4240}}, // Panan-awan Airport
    Airport{IataCode{"MSO"}, CountryId{"US"}, Timezone{1667}}, // Missoula International Airport
    Airport{IataCode{"MSP"}, CountryId{"US"}, Timezone{1510}}, // Minneapolis–Saint Paul International Airport
    Airport{IataCode{"MSQ"}, CountryId{"BY"}, Timezone{5593}}, // Minsk National Airport
    Airport{IataCode{"MSS"}, CountryId{"US"}, Timezone{}}, // Massena International Airport
    Airport{IataCode{"MST"}, CountryId{"NL"}, Timezone{5231}}, // Maastricht Aachen Airport
    Airport{IataCode{"MSU"}, CountryId{"LS"}, Timezone{369}}, // Moshoeshoe I International Airport
    Airport{IataCode{"MSV"}, CountryId{"US"}, Timezone{2712}}, // Sullivan County International Airport
    Airport{IataCode{"MSW"}, CountryId{"ER"}, Timezone{62}}, // Massawa International Airport
    Airport{IataCode{"MSX"}, CountryId{"CG"}, Timezone{148}}, // Mossendjo Airport
    Airport{IataCode{"MSY"}, CountryId{"US"}, Timezone{1510}}, // Louis Armstrong New Orleans International Airport
    Airport{IataCode{"MSZ"}, CountryId{"AO"}, Timezone{505}}, // Namibe Airport
    Airport{IataCode{"MTA"}, CountryId{"NZ"}, Timezone{6218}}, // Matamata Airport
    Airport{IataCode{"MTB"}, CountryId{"CO"}, Timezone{1376}}, // El Pindo Airport
    Airport{IataCode{"MTF"}, CountryId{"ET"}, Timezone{28}}, // Mizan Teferi Airport
    Airport{IataCode{"MTG"}, CountryId{"BR"}, Timezone{1579}}, // Vila Bela da Santíssima Trindade Airport
    Airport{IataCode{"MTH"}, CountryId{"US"}, Timezone{2712}}, // Florida Keys Marathon Airport
    Airport{IataCode{"MTI"}, CountryId{"CV"}, Timezone{4771}}, // Mosteiros Airport
    Airport{IataCode{"MTJ"}, CountryId{"US"}, Timezone{1667}}, // Montrose Regional Airport
    Airport{IataCode{"MTK"}, CountryId{"KI"}, Timezone{6755}}, // Makin Airport
    Airport{IataCode{"MTL"}, CountryId{"AU"}, Timezone{5103}}, // Maitland Airport
    Airport{IataCode{"MTM"}, CountryId{"US"}, Timezone{}}, // Metlakatla Seaplane Base
    Airport{IataCode{"MTN"}, CountryId{"US"}, Timezone{2712}}, // Martin State Airport
    Airport{IataCode{"MTO"}, CountryId{"US"}, Timezone{1510}}, // Coles County Memorial Airport
    Airport{IataCode{"MTP"}, CountryId{"US"}, Timezone{2712}}, // Montauk Airport
    Airport{IataCode{"MTQ"}, CountryId{"AU"}, Timezone{4920}}, // Mitchell Airport
    Airport{IataCode{"MTR"}, CountryId{"CO"}, Timezone{1376}}, // Los Garzones Airport
    Airport{IataCode{"MTS"}, CountryId{"SZ"}, Timezone{593}}, // Matsapha Airport
    Airport{IataCode{"MTT"}, CountryId{"MX"}, Timezone{2588}}, // Minatitlán/Coatzacoalcos National Airport
    Airport{IataCode{"MTV"}, CountryId{"VU"}, Timezone{6301}}, // Mota Lava Airport
    Airport{IataCode{"MTW"}, CountryId{"US"}, Timezone{1510}}, // Manitowoc County Airport
    Airport{IataCode{"MTY"}, CountryId{"MX"}, Timezone{2641}}, // Monterrey International Airport
    Airport{IataCode{"MTZ"}, CountryId{"IL"}, Timezone{3952}}, // Bar Yehuda Airfield
    Airport{IataCode{"MUA"}, CountryId{"SB"}, Timezone{6413}}, // Munda Airport
    Airport{IataCode{"MUB"}, CountryId{"BW"}, Timezone{339}}, // Maun Airport
    Airport{IataCode{"MUC"}, CountryId{"DE"}, Timezone{5199}}, // Munich Airport
    Airport{IataCode{"MUD"}, CountryId{"MZ"}, Timezone{565}}, // Mueda Airport
    Airport{IataCode{"MUE"}, CountryId{"US"}, Timezone{6446}}, // Waimea-Kohala Airport
    Airport{IataCode{"MUG"}, CountryId{"MX"}, Timezone{2519}}, // Mulegé Airstrip
    Airport{IataCode{"MUH"}, CountryId{"EG"}, Timezone{184}}, // Marsa Matruh International Airport
    Airport{IataCode{"MUJ"}, CountryId{"ET"}, Timezone{28}}, // Mui Airport
    Airport{IataCode{"MUL"}, CountryId{"US"}, Timezone{2712}}, // Spence Airport
    Airport{IataCode{"MUN"}, CountryId{"VE"}, Timezone{1463}}, // José Tadeo Monagas International Airport
    Airport{IataCode{"MUR"}, CountryId{"MY"}, Timezone{4190}}, // Marudi Airport
    Airport{IataCode{"MUS"}, CountryId{"JP"}, Timezone{}}, // Minami Torishima Airport
    Airport{IataCode{"MUT"}, CountryId{"US"}, Timezone{1510}}, // Muscatine Municipal Airport
    Airport{IataCode{"MUW"}, CountryId{"DZ"}, Timezone{47}}, // Ghriss Airport
    Airport{IataCode{"MUX"}, CountryId{"PK"}, Timezone{4087}}, // Multan International Airport
    Airport{IataCode{"MUY"}, CountryId{"CG"}, Timezone{148}}, // Mouyondzi Airport
    Airport{IataCode{"MUZ"}, CountryId{"TZ"}, Timezone{256}}, // Musoma Airport
    Airport{IataCode{"MVA"}, CountryId{"IS"}, Timezone{4823}}, // Mývatn Airport
    Airport{IataCode{"MVB"}, CountryId{"GA"}, Timezone{475}}, // M'Vengue El Hadj Omar Bongo Ondimba International Airport
    Airport{IataCode{"MVC"}, CountryId{"US"}, Timezone{1510}}, // Monroe County Airport
    Airport{IataCode{"MVD"}, CountryId{"UY"}, Timezone{2659}}, // Carrasco International Airport
    Airport{IataCode{"MVE"}, CountryId{"US"}, Timezone{1510}}, // Montevideo–Chippewa County Airport
    Airport{IataCode{"MVF"}, CountryId{"BR"}, Timezone{1789}}, // Mossoró Airport
    Airport{IataCode{"MVL"}, CountryId{"US"}, Timezone{2712}}, // Morrisville-Stowe State Airport
    Airport{IataCode{"MVM"}, CountryId{"US"}, Timezone{1667}}, // Kayenta Airport
    Airport{IataCode{"MVN"}, CountryId{"US"}, Timezone{1510}}, // Mount Vernon Airport
    Airport{IataCode{"MVO"}, CountryId{"TD"}, Timezone{656}}, // Mongo Airport
    Airport{IataCode{"MVP"}, CountryId{"CO"}, Timezone{1376}}, // Fabio Alberto León Bentley Airport
    Airport{IataCode{"MVQ"}, CountryId{"BY"}, Timezone{5593}}, // Mogilev Airport
    Airport{IataCode{"MVR"}, CountryId{"CM"}, Timezone{293}}, // Salak Airport
    Airport{IataCode{"MVS"}, CountryId{"BR"}, Timezone{1254}}, // Mucuri Airport
    Airport{IataCode{"MVV"}, CountryId{"FR"}, Timezone{5646}}, // Megève Aerodrome
    Airport{IataCode{"MVW"}, CountryId{"US"}, Timezone{2378}}, // Skagit Regional Airport
    Airport{IataCode{"MVX"}, CountryId{"GA"}, Timezone{475}}, // Minvoul Airport
    Airport{IataCode{"MVY"}, CountryId{"US"}, Timezone{2712}}, // Martha's Vineyard Airport
    Airport{IataCode{"MVZ"}, CountryId{"ZW"}, Timezone{355}}, // Masvingo Airport
    Airport{IataCode{"MWA"}, CountryId{"US"}, Timezone{1510}}, // Williamson County Regional Airport
    Airport{IataCode{"MWB"}, CountryId{"AU"}, Timezone{5087}}, // Morawa Airport
    Airport{IataCode{"MWC"}, CountryId{"US"}, Timezone{1510}}, // Lawrence J. Timmerman Airport
    Airport{IataCode{"MWE"}, CountryId{"SD"}, Timezone{432}}, // Merowe Airport
    Airport{IataCode{"MWF"}, CountryId{"VU"}, Timezone{6301}}, // Maewo-Naone Airport
    Airport{IataCode{"MWH"}, CountryId{"US"}, Timezone{2378}}, // Grant County International Airport
    Airport{IataCode{"MWK"}, CountryId{"ID"}, Timezone{4032}}, // Matak Airport
    Airport{IataCode{"MWL"}, CountryId{"US"}, Timezone{1510}}, // Mineral Wells Airport
    Airport{IataCode{"MWN"}, CountryId{"TZ"}, Timezone{256}}, // Mwadui Airport
    Airport{IataCode{"MWO"}, CountryId{"US"}, Timezone{2712}}, // Middletown Regional Airport
    Airport{IataCode{"MWQ"}, CountryId{"MM"}, Timezone{4678}}, // Magway Airport
    Airport{IataCode{"MWV"}, CountryId{"KH"}, Timezone{4332}}, // Mondulkiri Airport
    Airport{IataCode{"MWX"}, CountryId{"KR"}, Timezone{4445}}, // Muan International Airport
    Airport{IataCode{"MWZ"}, CountryId{"TZ"}, Timezone{256}}, // Mwanza Airport
    Airport{IataCode{"MXA"}, CountryId{"US"}, Timezone{1510}}, // Manila Municipal Airport
    Airport{IataCode{"MXB"}, CountryId{"ID"}, Timezone{4226}}, // Andi Jemma Airport
    Airport{IataCode{"MXC"}, CountryId{"US"}, Timezone{1667}}, // Monticello Airport
    Airport{IataCode{"MXE"}, CountryId{"US"}, Timezone{2712}}, // Laurinburg-Maxton Airport
    Airport{IataCode{"MXG"}, CountryId{"US"}, Timezone{2712}}, // Marlboro Airport
    Airport{IataCode{"MXH"}, CountryId{"PG"}, Timezone{6686}}, // Moro Airport
    Airport{IataCode{"MXI"}, CountryId{"PH"}, Timezone{4240}}, // Imelda R. Marcos Airport
    Airport{IataCode{"MXJ"}, CountryId{"NG"}, Timezone{462}}, // Minna Airport
    Airport{IataCode{"MXL"}, CountryId{"MX"}, Timezone{}}, // General Rodolfo Sánchez Taboada International Airport
    Airport{IataCode{"MXM"}, CountryId{"MG"}, Timezone{6035}}, // Morombe Airport
    Airport{IataCode{"MXN"}, CountryId{"FR"}, Timezone{5646}}, // Morlaix – Ploujean Airport
    Airport{IataCode{"MXO"}, CountryId{"US"}, Timezone{1510}}, // Monticello Regional Airport
    Airport{IataCode{"MXP"}, CountryId{"IT"}, Timezone{5702}}, // Milan–Malpensa Airport
    Airport{IataCode{"MXR"}, CountryId{"TD"}, Timezone{656}}, // Moussoro Airport
    Airport{IataCode{"MXS"}, CountryId{"WS"}, Timezone{6205}}, // Maota Airport
    Airport{IataCode{"MXT"}, CountryId{"MG"}, Timezone{6035}}, // Maintirano Airport
    Airport{IataCode{"MXU"}, CountryId{"AU"}, Timezone{5087}}, // Mullewa Airport
    Airport{IataCode{"MXV"}, CountryId{"MN"}, Timezone{4590}}, // Mörön Airport
    Airport{IataCode{"MXW"}, CountryId{"MN"}, Timezone{4590}}, // Mandalgovi Airport
    Airport{IataCode{"MXX"}, CountryId{"SE"}, Timezone{5822}}, // Mora-Siljan Airport
    Airport{IataCode{"MXY"}, CountryId{"US"}, Timezone{814}}, // McCarthy Airport
    Airport{IataCode{"MXZ"}, CountryId{"CN"}, Timezone{4456}}, // Meixian Airport
    Airport{IataCode{"MYA"}, CountryId{"AU"}, Timezone{5103}}, // Moruya Airport
    Airport{IataCode{"MYB"}, CountryId{"GA"}, Timezone{475}}, // Mayumba Airport
    Airport{IataCode{"MYC"}, CountryId{"TD"}, Timezone{656}}, // Massenya Airport
    Airport{IataCode{"MYD"}, CountryId{"KE"}, Timezone{641}}, // Malindi Airport
    Airport{IataCode{"MYE"}, CountryId{"JP"}, Timezone{4568}}, // Miyakejima Airport
    Airport{IataCode{"MYF"}, CountryId{"US"}, Timezone{2378}}, // Montgomery Field Airport
    Airport{IataCode{"MYG"}, CountryId{"BS"}, Timezone{2697}}, // Mayaguana Airport
    Airport{IataCode{"MYH"}, CountryId{"US"}, Timezone{2931}}, // Marble Canyon Airport
    Airport{IataCode{"MYI"}, CountryId{"AU"}, Timezone{4920}}, // Murray Island Airport
    Airport{IataCode{"MYJ"}, CountryId{"JP"}, Timezone{4568}}, // Matsuyama Airport
    Airport{IataCode{"MYK"}, CountryId{"US"}, Timezone{814}}, // May Creek Airport
    Airport{IataCode{"MYL"}, CountryId{"US"}, Timezone{1391}}, // McCall Municipal Airport
    Airport{IataCode{"MYM"}, CountryId{"GY"}, Timezone{1949}}, // Monkey Mountain Airport
    Airport{IataCode{"MYN"}, CountryId{"YE"}, Timezone{3634}}, // Marib Airport
    Airport{IataCode{"MYP"}, CountryId{"TM"}, Timezone{3702}}, // Mary Airport
    Airport{IataCode{"MYQ"}, CountryId{"IN"}, Timezone{4129}}, // Mysore Airport
    Airport{IataCode{"MYR"}, CountryId{"US"}, Timezone{2712}}, // Myrtle Beach International Airport
    Airport{IataCode{"MYT"}, CountryId{"MM"}, Timezone{4678}}, // Myitkyina Airport
    Airport{IataCode{"MYU"}, CountryId{"US"}, Timezone{2745}}, // Mekoryuk Airport
    Airport{IataCode{"MYV"}, CountryId{"US"}, Timezone{2378}}, // Yuba County Airport
    Airport{IataCode{"MYW"}, CountryId{"TZ"}, Timezone{256}}, // Mtwara Airport
    Airport{IataCode{"MYX"}, CountryId{"BS"}, Timezone{2697}}, // Big Whale Cay Airport
    Airport{IataCode{"MYY"}, CountryId{"MY"}, Timezone{4190}}, // Miri Airport
    Airport{IataCode{"MYZ"}, CountryId{"MW"}, Timezone{132}}, // Monkey Bay Airport
    Airport{IataCode{"MZA"}, CountryId{"PE"}, Timezone{2365}}, // Manuel Prado Airport
    Airport{IataCode{"MZB"}, CountryId{"MZ"}, Timezone{565}}, // Mocímboa da Praia Airport
    Airport{IataCode{"MZC"}, CountryId{"GA"}, Timezone{475}}, // Mitzic Airport
    Airport{IataCode{"MZE"}, CountryId{"BZ"}, Timezone{1322}}, // Manatee Airport
    Airport{IataCode{"MZI"}, CountryId{"ML"}, Timezone{76}}, // Mopti Airport
    Airport{IataCode{"MZJ"}, CountryId{"US"}, Timezone{2931}}, // Pinal Airpark
    Airport{IataCode{"MZK"}, CountryId{"KI"}, Timezone{6755}}, // Marakei Airport
    Airport{IataCode{"MZL"}, CountryId{"CO"}, Timezone{1376}}, // La Nubia Airport
    Airport{IataCode{"MZO"}, CountryId{"CU"}, Timezone{1980}}, // Sierra Maestra Airport
    Airport{IataCode{"MZP"}, CountryId{"NZ"}, Timezone{6218}}, // Motueka Aerodrome
    Airport{IataCode{"MZR"}, CountryId{"AF"}, Timezone{4061}}, // Mazar-i-Sharif Airport
    Airport{IataCode{"MZT"}, CountryId{"MX"}, Timezone{2519}}, // General Rafael Buelna International Airport
    Airport{IataCode{"MZU"}, CountryId{"IN"}, Timezone{4129}}, // Muzzafarpur Airport
    Airport{IataCode{"MZV"}, CountryId{"MY"}, Timezone{}}, // Mulu Airport
    Airport{IataCode{"MZW"}, CountryId{"DZ"}, Timezone{47}}, // Mécheria Airport
    Airport{IataCode{"MZZ"}, CountryId{"US"}, Timezone{2043}}, // Marion Municipal Airport
    Airport{IataCode{"NAA"}, CountryId{"AU"}, Timezone{5103}}, // Narrabri Airport
    Airport{IataCode{"NAC"}, CountryId{"AU"}, Timezone{4901}}, // Naracoorte Airport
    Airport{IataCode{"NAE"}, CountryId{"BJ"}, Timezone{723}}, // Natitingou Airport
    Airport{IataCode{"NAG"}, CountryId{"IN"}, Timezone{4129}}, // Dr. Babasaheb Ambedkar International Airport
    Airport{IataCode{"NAH"}, CountryId{"ID"}, Timezone{4226}}, // Naha Airport
    Airport{IataCode{"NAI"}, CountryId{"GY"}, Timezone{1949}}, // Annai Airport
    Airport{IataCode{"NAJ"}, CountryId{"AZ"}, Timezone{3754}}, // Nakhchivan Airport
    Airport{IataCode{"NAK"}, CountryId{"TH"}, Timezone{3777}}, // Khorat Airport
    Airport{IataCode{"NAL"}, CountryId{"RU"}, Timezone{5620}}, // Nalchik Airport
    Airport{IataCode{"NAM"}, CountryId{"ID"}, Timezone{4032}}, // Namlea Airport
    Airport{IataCode{"NAN"}, CountryId{"FJ"}, Timezone{6349}}, // Nadi International Airport
    Airport{IataCode{"NAO"}, CountryId{"CN"}, Timezone{4456}}, // Nanchong Gaoping Airport
    Airport{IataCode{"NAP"}, CountryId{"IT"}, Timezone{5702}}, // Naples International Airport
    Airport{IataCode{"NAQ"}, CountryId{"GL"}, Timezone{3421}}, // Qaanaaq Airport
    Airport{IataCode{"NAR"}, CountryId{"CO"}, Timezone{1376}}, // Puerto Nare Airport
    Airport{IataCode{"NAS"}, CountryId{"GB"}, Timezone{2697}}, // Lynden Pindling International Airport
    Airport{IataCode{"NAT"}, CountryId{"BR"}, Timezone{1789}}, // Greater Natal International Airport
    Airport{IataCode{"NAU"}, CountryId{"FR"}, Timezone{6740}}, // Napuka Airport
    Airport{IataCode{"NAV"}, CountryId{"TR"}, Timezone{5412}}, // Nevşehir Kapadokya Airport
    Airport{IataCode{"NAW"}, CountryId{"TH"}, Timezone{3777}}, // Narathiwat Airport
    Airport{IataCode{"NAY"}, CountryId{"CN"}, Timezone{4456}}, // Beijing Nanyuan Airport
    Airport{IataCode{"NBB"}, CountryId{"CO"}, Timezone{1376}}, // Barranco Minas Airport
    Airport{IataCode{"NBC"}, CountryId{"RU"}, Timezone{5620}}, // Begishevo Airport
    Airport{IataCode{"NBE"}, CountryId{"TN"}, Timezone{772}}, // Enfidha – Hammamet International Airport
    Airport{IataCode{"NBL"}, CountryId{"PA"}, Timezone{2877}}, // Wannukandi Airport
    Airport{IataCode{"NBN"}, CountryId{"GQ"}, Timezone{551}}, // Annobon Airport
    Airport{IataCode{"NBO"}, CountryId{"KE"}, Timezone{641}}, // Jomo Kenyatta International Airport
    Airport{IataCode{"NBS"}, CountryId{"CN"}, Timezone{4456}}, // Changbaishan Airport
    Airport{IataCode{"NBW"}, CountryId{"CU"}, Timezone{1980}}, // Leeward Point Field
    Airport{IataCode{"NBX"}, CountryId{"ID"}, Timezone{4032}}, // Nabire Airport
    Airport{IataCode{"NCA"}, CountryId{"GB"}, Timezone{1859}}, // North Caicos Airport
    Airport{IataCode{"NCE"}, CountryId{"FR"}, Timezone{5646}}, // Nice Côte d'Azur Airport
    Airport{IataCode{"NCG"}, CountryId{"MX"}, Timezone{1526}}, // Nuevo Casas Grandes Airport
    Airport{IataCode{"NCH"}, CountryId{"TZ"}, Timezone{256}}, // Nachingwea Airport
    Airport{IataCode{"NCI"}, CountryId{"CO"}, Timezone{1376}}, // Necoclí Airport
    Airport{IataCode{"NCJ"}, CountryId{"AR"}, Timezone{942}}, // Sunchales Airport
    Airport{IataCode{"NCL"}, CountryId{"GB"}, Timezone{5517}}, // Newcastle Airport
    Airport{IataCode{"NCN"}, CountryId{"US"}, Timezone{814}}, // Chenega Bay Airport
    Airport{IataCode{"NCR"}, CountryId{"NI"}, Timezone{2435}}, // San Carlos Airport
    Airport{IataCode{"NCS"}, CountryId{"ZA"}, Timezone{369}}, // Newcastle Airport
    Airport{IataCode{"NCT"}, CountryId{"CR"}, Timezone{1544}}, // Nicoya Guanacaste Airport
    Airport{IataCode{"NCU"}, CountryId{"UZ"}, Timezone{4430}}, // Nukus Airport
    Airport{IataCode{"NCY"}, CountryId{"FR"}, Timezone{5646}}, // Annecy – Haute-Savoie – Mont Blanc Airport
    Airport{IataCode{"NDA"}, CountryId{"ID"}, Timezone{4032}}, // Bandanaira Airport
    Airport{IataCode{"NDB"}, CountryId{"MR"}, Timezone{307}}, // Nouadhibou International Airport
    Airport{IataCode{"NDC"}, CountryId{"IN"}, Timezone{4129}}, // Shri Guru Gobind Singh Ji Airport
    Airport{IataCode{"NDD"}, CountryId{"AO"}, Timezone{505}}, // Sumbe Airport
    Airport{IataCode{"NDE"}, CountryId{"KE"}, Timezone{28}}, // Mandera Airport
    Airport{IataCode{"NDF"}, CountryId{"AO"}, Timezone{505}}, // N'dalatando Airport
    Airport{IataCode{"NDG"}, CountryId{"CN"}, Timezone{4456}}, // Qiqihar Sanjiazi Airport
    Airport{IataCode{"NDJ"}, CountryId{"TD"}, Timezone{293}}, // N'Djamena International Airport
    Airport{IataCode{"NDK"}, CountryId{"MH"}, Timezone{}}, // Namorik Airport
    Airport{IataCode{"NDL"}, CountryId{"CF"}, Timezone{104}}, // N'Délé Airport
    Airport{IataCode{"NDR"}, CountryId{"MA"}, Timezone{215}}, // Nador International Airport
    Airport{IataCode{"NDU"}, CountryId{"NA"}, Timezone{505}}, // Rundu Airport
    Airport{IataCode{"NDY"}, CountryId{"GB"}, Timezone{5517}}, // Sanday Airport
    Airport{IataCode{"NEC"}, CountryId{"AR"}, Timezone{883}}, // Necochea Airport
    Airport{IataCode{"NEF"}, CountryId{"RU"}, Timezone{}}, // Neftekamsk Airport
    Airport{IataCode{"NEG"}, CountryId{"JM"}, Timezone{2260}}, // Negril Aerodrome
    Airport{IataCode{"NEJ"}, CountryId{"ET"}, Timezone{28}}, // Nejjo Airport
    Airport{IataCode{"NEK"}, CountryId{"ET"}, Timezone{28}}, // Nekemte Airport
    Airport{IataCode{"NER"}, CountryId{"RU"}, Timezone{4665}}, // Chulman Airport
    Airport{IataCode{"NEV"}, CountryId{"KN"}, Timezone{3308}}, // Vance W. Amory International Airport
    Airport{IataCode{"NFG"}, CountryId{"RU"}, Timezone{4690}}, // Nefteyugansk Airport
    Airport{IataCode{"NFO"}, CountryId{"TO"}, Timezone{6770}}, // Mata'aho Airport
    Airport{IataCode{"NGA"}, CountryId{"AU"}, Timezone{5103}}, // Young Airport
    Airport{IataCode{"NGB"}, CountryId{"CN"}, Timezone{4456}}, // Ningbo Lishe International Airport
    Airport{IataCode{"NGD"}, CountryId{"VG"}, Timezone{3487}}, // Auguste George Airport
    Airport{IataCode{"NGE"}, CountryId{"CM"}, Timezone{293}}, // Ngaoundéré Airport
    Airport{IataCode{"NGI"}, CountryId{"FJ"}, Timezone{6349}}, // Ngau Airport
    Airport{IataCode{"NGK"}, CountryId{"RU"}, Timezone{4416}}, // Nogliki Airport
    Airport{IataCode{"NGO"}, CountryId{"JP"}, Timezone{4568}}, // Chubu Centrair International Airport
    Airport{IataCode{"NGQ"}, CountryId{"CN"}, Timezone{4456}}, // Ngari Gunsa Airport
    Airport{IataCode{"NGS"}, CountryId{"JP"}, Timezone{4568}}, // Nagasaki Airport
    Airport{IataCode{"NGT"}, CountryId{"US"}, Timezone{1510}}, // Goliad County Industrial Airpark
    Airport{IataCode{"NGX"}, CountryId{"NP"}, Timezone{4100}}, // Manang Airport
    Airport{IataCode{"NHF"}, CountryId{"SD"}, Timezone{432}}, // New Halfa Airport
    Airport{IataCode{"NHZ"}, CountryId{"US"}, Timezone{2712}}, // Brunswick Executive Airport
    Airport{IataCode{"NIA"}, CountryId{"LR"}, Timezone{228}}, // Nimba Airport
    Airport{IataCode{"NIB"}, CountryId{"US"}, Timezone{814}}, // Nikolai Airport
    Airport{IataCode{"NIC"}, CountryId{"CY"}, Timezone{3927}}, // Nicosia International Airport
    Airport{IataCode{"NIF"}, CountryId{"AU"}, Timezone{5087}}, // Nifty Airport
    Airport{IataCode{"NIG"}, CountryId{"KI"}, Timezone{6755}}, // Nikunau Airport
    Airport{IataCode{"NIK"}, CountryId{"SN"}, Timezone{243}}, // Niokolo-Koba Airport
    Airport{IataCode{"NIM"}, CountryId{"NE"}, Timezone{672}}, // Diori Hamani International Airport
    Airport{IataCode{"NIO"}, CountryId{"CD"}, Timezone{446}}, // Nioki Airport
    Airport{IataCode{"NIT"}, CountryId{"FR"}, Timezone{5646}}, // Niort - Marais Poitevin Airport
    Airport{IataCode{"NIU"}, CountryId{"FR"}, Timezone{6740}}, // Niau Airport
    Airport{IataCode{"NIX"}, CountryId{"ML"}, Timezone{76}}, // Nioro Airport
    Airport{IataCode{"NJC"}, CountryId{"RU"}, Timezone{4690}}, // Nizhnevartovsk Airport
    Airport{IataCode{"NJF"}, CountryId{"IQ"}, Timezone{3728}}, // Al Najaf International Airport
    Airport{IataCode{"NKC"}, CountryId{"MR"}, Timezone{686}}, // Nouakchott–Oumtounsy International Airport
    Airport{IataCode{"NKG"}, CountryId{"CN"}, Timezone{4456}}, // Nanjing Lukou International Airport
    Airport{IataCode{"NKL"}, CountryId{"CD"}, Timezone{446}}, // Nkolo-Fuma Airport
    Airport{IataCode{"NKM"}, CountryId{"JP"}, Timezone{4568}}, // Nagoya Airfield
    Airport{IataCode{"NKS"}, CountryId{"CM"}, Timezone{293}}, // Nkongsamba Airport
    Airport{IataCode{"NKT"}, CountryId{"TR"}, Timezone{5412}}, // Şırnak Airport
    Airport{IataCode{"NKU"}, CountryId{"LS"}, Timezone{579}}, // Nkaus Airport
    Airport{IataCode{"NKY"}, CountryId{"CG"}, Timezone{148}}, // Yokangassi Airport
    Airport{IataCode{"NLA"}, CountryId{"ZM"}, Timezone{537}}, // Simon Mwansa Kapwepwe International Airport
    Airport{IataCode{"NLD"}, CountryId{"MX"}, Timezone{2501}}, // Quetzalcóatl International Airport
    Airport{IataCode{"NLE"}, CountryId{"US"}, Timezone{1682}}, // Jerry Tyler Memorial Airport
    Airport{IataCode{"NLF"}, CountryId{"AU"}, Timezone{4920}}, // Darnley Island Airport
    Airport{IataCode{"NLG"}, CountryId{"US"}, Timezone{814}}, // Nelson Lagoon Airport
    Airport{IataCode{"NLH"}, CountryId{"CN"}, Timezone{4456}}, // Lugu Lake Airport
    Airport{IataCode{"NLI"}, CountryId{"RU"}, Timezone{4648}}, // Nikolayevsk-on-Amur Airport
    Airport{IataCode{"NLK"}, CountryId{"AU"}, Timezone{}}, // Norfolk Island Airport
    Airport{IataCode{"NLN"}, CountryId{"US"}, Timezone{2378}}, // Kneeland Airport
    Airport{IataCode{"NLO"}, CountryId{"CD"}, Timezone{148}}, // N'Dolo Airport
    Airport{IataCode{"NLP"}, CountryId{"ZA"}, Timezone{369}}, // Nelspruit Airport
    Airport{IataCode{"NLT"}, CountryId{"CN"}, Timezone{4607}}, // Nalati Airport
    Airport{IataCode{"NLV"}, CountryId{"UA"}, Timezone{5461}}, // Mykolaiv Airport
    Airport{IataCode{"NMA"}, CountryId{"UZ"}, Timezone{4516}}, // Namangan Airport
    Airport{IataCode{"NMB"}, CountryId{"IN"}, Timezone{4129}}, // Daman Airport
    Airport{IataCode{"NMC"}, CountryId{"BS"}, Timezone{2697}}, // Norman's Cay Airport
    Airport{IataCode{"NME"}, CountryId{"US"}, Timezone{2745}}, // Nightmute Airport
    Airport{IataCode{"NMG"}, CountryId{"PA"}, Timezone{2877}}, // San Miguel Airport
    Airport{IataCode{"NML"}, CountryId{"CA"}, Timezone{1715}}, // Fort McMurray/Mildred Lake Airport
    Airport{IataCode{"NMS"}, CountryId{"MM"}, Timezone{4678}}, // Namsang Airport
    Airport{IataCode{"NNA"}, CountryId{"MA"}, Timezone{215}}, // Tourisme Airport
    Airport{IataCode{"NNB"}, CountryId{"SB"}, Timezone{6413}}, // Santa Ana Airport
    Airport{IataCode{"NNG"}, CountryId{"CN"}, Timezone{4456}}, // Nanning Wuxu International Airport
    Airport{IataCode{"NNI"}, CountryId{"NA"}, Timezone{785}}, // Namutoni Airport
    Airport{IataCode{"NNK"}, CountryId{"US"}, Timezone{814}}, // Naknek Airport
    Airport{IataCode{"NNL"}, CountryId{"US"}, Timezone{814}}, // Nondalton Airport
    Airport{IataCode{"NNM"}, CountryId{"RU"}, Timezone{5620}}, // Naryan-Mar Airport
    Airport{IataCode{"NNN"}, CountryId{"UA"}, Timezone{5461}}, // Sviatoshyn Airfield
    Airport{IataCode{"NNR"}, CountryId{"IE"}, Timezone{5330}}, // Connemara Airport
    Airport{IataCode{"NNT"}, CountryId{"TH"}, Timezone{3777}}, // Nan Nakhon Airport
    Airport{IataCode{"NNU"}, CountryId{"BR"}, Timezone{3216}}, // Jorge Schieber Airport
    Airport{IataCode{"NNX"}, CountryId{"ID"}, Timezone{4226}}, // Nunukan Airport
    Airport{IataCode{"NNY"}, CountryId{"CN"}, Timezone{4456}}, // Nanyang Jiangying Airport
    Airport{IataCode{"NOB"}, CountryId{"CR"}, Timezone{1544}}, // Nosara Airport
    Airport{IataCode{"NOC"}, CountryId{"IE"}, Timezone{5330}}, // Ireland West Airport Knock
    Airport{IataCode{"NOD"}, CountryId{"DE"}, Timezone{5199}}, // Norden-Norddeich Airport
    Airport{IataCode{"NOG"}, CountryId{"MX"}, Timezone{1995}}, // Nogales International Airport (Mexico)
    Airport{IataCode{"NOJ"}, CountryId{"RU"}, Timezone{4690}}, // Noyabrsk Airport
    Airport{IataCode{"NOK"}, CountryId{"BR"}, Timezone{1579}}, // Nova Xavantina Airport
    Airport{IataCode{"NON"}, CountryId{"KI"}, Timezone{6755}}, // Nonouti Airport
    Airport{IataCode{"NOP"}, CountryId{"TR"}, Timezone{5412}}, // Sinop Airport
    Airport{IataCode{"NOR"}, CountryId{"IS"}, Timezone{4823}}, // Norðfjörður Airport
    Airport{IataCode{"NOS"}, CountryId{"MG"}, Timezone{6035}}, // Fascene Airport
    Airport{IataCode{"NOT"}, CountryId{"US"}, Timezone{2378}}, // Marin County Airport
    Airport{IataCode{"NOU"}, CountryId{"FR"}, Timezone{6606}}, // La Tontouta International Airport
    Airport{IataCode{"NOV"}, CountryId{"AO"}, Timezone{505}}, // Albano Machado Airport
    Airport{IataCode{"NOZ"}, CountryId{"RU"}, Timezone{4277}}, // Spichenkovo Airport
    Airport{IataCode{"NPE"}, CountryId{"NZ"}, Timezone{6218}}, // Hawke's Bay Airport
    Airport{IataCode{"NPL"}, CountryId{"NZ"}, Timezone{6218}}, // New Plymouth Airport
    Airport{IataCode{"NPO"}, CountryId{"ID"}, Timezone{4348}}, // Nanga Pinoh Airport
    Airport{IataCode{"NPR"}, CountryId{"BR"}, Timezone{3160}}, // Novo Progresso Airport
    Airport{IataCode{"NPT"}, CountryId{"US"}, Timezone{2712}}, // Newport State Airport
    Airport{IataCode{"NQA"}, CountryId{"US"}, Timezone{1510}}, // Millington Regional Jetport
    Airport{IataCode{"NQL"}, CountryId{"BR"}, Timezone{3216}}, // Niquelândia Airport
    Airport{IataCode{"NQN"}, CountryId{"AR"}, Timezone{1076}}, // Presidente Perón International Airport
    Airport{IataCode{"NQU"}, CountryId{"CO"}, Timezone{1376}}, // Reyes Murillo Airport
    Airport{IataCode{"NQY"}, CountryId{"GB"}, Timezone{5517}}, // Newquay Cornwall Airport
    Airport{IataCode{"NRA"}, CountryId{"AU"}, Timezone{5103}}, // Narrandera Airport
    Airport{IataCode{"NRC"}, CountryId{"US"}, Timezone{2378}}, // NASA Crows Landing Airport
    Airport{IataCode{"NRD"}, CountryId{"DE"}, Timezone{5199}}, // Norderney Airport
    Airport{IataCode{"NRE"}, CountryId{"ID"}, Timezone{4032}}, // Namrole Airport
    Airport{IataCode{"NRG"}, CountryId{"AU"}, Timezone{5087}}, // Narrogin Airport
    Airport{IataCode{"NRI"}, CountryId{"US"}, Timezone{1510}}, // Grand Lake Regional Airport
    Airport{IataCode{"NRK"}, CountryId{"SE"}, Timezone{5822}}, // Norrköping Airport
    Airport{IataCode{"NRL"}, CountryId{"GB"}, Timezone{5517}}, // North Ronaldsay Airport
    Airport{IataCode{"NRM"}, CountryId{"ML"}, Timezone{76}}, // Keibane Airport
    Airport{IataCode{"NRN"}, CountryId{"DE"}, Timezone{5120}}, // Weeze Airport
    Airport{IataCode{"NRR"}, CountryId{"US"}, Timezone{3012}}, // José Aponte de la Torre Airport
    Airport{IataCode{"NRT"}, CountryId{"JP"}, Timezone{4568}}, // Narita International Airport
    Airport{IataCode{"NSB"}, CountryId{}, Timezone{2697}}, // North Bimini Airport
    Airport{IataCode{"NSH"}, CountryId{"IR"}, Timezone{4543}}, // Noshahr Airport
    Airport{IataCode{"NSI"}, CountryId{"CM"}, Timezone{293}}, // Yaoundé Nsimalen International Airport
    Airport{IataCode{"NSK"}, CountryId{"RU"}, Timezone{4142}}, // Alykel Airport
    Airport{IataCode{"NSM"}, CountryId{"AU"}, Timezone{5087}}, // Norseman Airport
    Airport{IataCode{"NSN"}, CountryId{"NZ"}, Timezone{6218}}, // Nelson Airport, New Zealand
    Airport{IataCode{"NSO"}, CountryId{"AU"}, Timezone{5103}}, // Scone Airport
    Airport{IataCode{"NST"}, CountryId{"TH"}, Timezone{3777}}, // Nakhon Si Thammarat Airport
    Airport{IataCode{"NTB"}, CountryId{"NO"}, Timezone{5634}}, // Notodden Airport
    Airport{IataCode{"NTE"}, CountryId{"FR"}, Timezone{5646}}, // Nantes Atlantique Airport
    Airport{IataCode{"NTG"}, CountryId{"CN"}, Timezone{4456}}, // Nantong Xingdong Airport
    Airport{IataCode{"NTN"}, CountryId{"AU"}, Timezone{4920}}, // Normanton Airport
    Airport{IataCode{"NTQ"}, CountryId{"JP"}, Timezone{4568}}, // Noto Airport
    Airport{IataCode{"NTR"}, CountryId{"MX"}, Timezone{2641}}, // Del Norte International Airport
    Airport{IataCode{"NTT"}, CountryId{"TO"}, Timezone{6770}}, // Niuatoputapu Airport
    Airport{IataCode{"NTX"}, CountryId{"ID"}, Timezone{4032}}, // Ranai Airport
    Airport{IataCode{"NTY"}, CountryId{"ZA"}, Timezone{369}}, // Pilanesberg International Airport
    Airport{IataCode{"NUB"}, CountryId{"AU"}, Timezone{4978}}, // Numbulwar Airport
    Airport{IataCode{"NUD"}, CountryId{"SD"}, Timezone{432}}, // En Nahud Airport
    Airport{IataCode{"NUE"}, CountryId{"DE"}, Timezone{5199}}, // Nuremberg Airport
    Airport{IataCode{"NUI"}, CountryId{"US"}, Timezone{814}}, // Nuiqsut Airport
    Airport{IataCode{"NUK"}, CountryId{"FR"}, Timezone{6740}}, // Nukutavake Airport
    Airport{IataCode{"NUL"}, CountryId{"US"}, Timezone{814}}, // Nulato Airport
    Airport{IataCode{"NUN"}, CountryId{"US"}, Timezone{1510}}, // Saufley Field
    Airport{IataCode{"NUP"}, CountryId{"US"}, Timezone{2745}}, // Nunapitchuk Airport
    Airport{IataCode{"NUQ"}, CountryId{"US"}, Timezone{2378}}, // Moffett Federal Airfield
    Airport{IataCode{"NUS"}, CountryId{"VU"}, Timezone{6301}}, // Norsup Airport
    Airport{IataCode{"NUU"}, CountryId{"KE"}, Timezone{641}}, // Nakuru Airport
    Airport{IataCode{"NUX"}, CountryId{"RU"}, Timezone{4690}}, // Novy Urengoy Airport
    Airport{IataCode{"NVA"}, CountryId{"CO"}, Timezone{1376}}, // Benito Salas Airport
    Airport{IataCode{"NVG"}, CountryId{"NI"}, Timezone{2435}}, // Nueva Guinea Airport
    Airport{IataCode{"NVI"}, CountryId{"UZ"}, Timezone{4430}}, // Navoi International Airport
    Airport{IataCode{"NVJ"}, CountryId{"MX"}, Timezone{1995}}, // Navojoa Airport
    Airport{IataCode{"NVK"}, CountryId{"NO"}, Timezone{5634}}, // Narvik Airport, Framnes
    Airport{IataCode{"NVN"}, CountryId{"US"}, Timezone{2378}}, // Nervino Airport
    Airport{IataCode{"NVR"}, CountryId{"RU"}, Timezone{5620}}, // Novgorod Airport
    Airport{IataCode{"NVS"}, CountryId{"FR"}, Timezone{5646}}, // Nevers-Fourchambault Airport
    Airport{IataCode{"NVT"}, CountryId{"BR"}, Timezone{3216}}, // Ministro Victor Konder International Airport
    Airport{IataCode{"NWA"}, CountryId{"KM"}, Timezone{6099}}, // Mohéli Bandar Es Eslam Airport
    Airport{IataCode{"NWH"}, CountryId{"US"}, Timezone{2712}}, // Parlin Field
    Airport{IataCode{"NWI"}, CountryId{"GB"}, Timezone{5517}}, // Norwich International Airport
    Airport{IataCode{"NXP"}, CountryId{"US"}, Timezone{2378}}, // Twentynine Palms Strategic Expeditionary Landing Field
    Airport{IataCode{"NYA"}, CountryId{"RU"}, Timezone{4690}}, // Nyagan Airport
    Airport{IataCode{"NYE"}, CountryId{"KE"}, Timezone{641}}, // Nyeri Airport
    Airport{IataCode{"NYI"}, CountryId{"GH"}, Timezone{15}}, // Sunyani Airport
    Airport{IataCode{"NYK"}, CountryId{"KE"}, Timezone{641}}, // Nanyuki Airport
    Airport{IataCode{"NYM"}, CountryId{"RU"}, Timezone{4690}}, // Nadym Airport
    Airport{IataCode{"NYN"}, CountryId{"AU"}, Timezone{5103}}, // Nyngan Airport
    Airport{IataCode{"NYO"}, CountryId{"SE"}, Timezone{5822}}, // Stockholm Skavsta Airport
    Airport{IataCode{"NYR"}, CountryId{"RU"}, Timezone{4665}}, // Nyurba Airport
    Airport{IataCode{"NYT"}, CountryId{"MM"}, Timezone{4678}}, // Naypyidaw Airport
    Airport{IataCode{"NYU"}, CountryId{"MM"}, Timezone{4678}}, // Nyaung U Airport
    Airport{IataCode{"NZA"}, CountryId{"AO"}, Timezone{505}}, // Nzagi Airport
    Airport{IataCode{"NZC"}, CountryId{"PE"}, Timezone{2365}}, // Maria Reiche Neuman Airport
    Airport{IataCode{"NZE"}, CountryId{"GN"}, Timezone{228}}, // Nzérékoré Airport
    Airport{IataCode{"NZH"}, CountryId{"CN"}, Timezone{4456}}, // Manzhouli Xijiao Airport
    Airport{IataCode{"NZK"}, CountryId{"NZ"}, Timezone{}}, // Karamea Airport
    Airport{IataCode{"NZL"}, CountryId{"CN"}, Timezone{4456}}, // Zhalantun Airport
    Airport{IataCode{"OAG"}, CountryId{"AU"}, Timezone{5103}}, // Orange Airport
    Airport{IataCode{"OAJ"}, CountryId{"US"}, Timezone{2712}}, // Albert J. Ellis Airport
    Airport{IataCode{"OAK"}, CountryId{"US"}, Timezone{2378}}, // Oakland International Airport
    Airport{IataCode{"OAL"}, CountryId{"BR"}, Timezone{2992}}, // Cacoal Airport
    Airport{IataCode{"OAM"}, CountryId{"NZ"}, Timezone{6218}}, // Oamaru Airport
    Airport{IataCode{"OAN"}, CountryId{"HN"}, Timezone{3401}}, // El Arrayán Airport
    Airport{IataCode{"OAR"}, CountryId{"US"}, Timezone{2378}}, // Marina Municipal Airport
    Airport{IataCode{"OAS"}, CountryId{"AF"}, Timezone{4061}}, // Sharana Airstrip
    Airport{IataCode{"OAX"}, CountryId{"MX"}, Timezone{2588}}, // Xoxocotlán International Airport
    Airport{IataCode{"OBC"}, CountryId{"DJ"}, Timezone{277}}, // Obock Airport
    Airport{IataCode{"OBE"}, CountryId{"US"}, Timezone{2712}}, // Okeechobee County Airport
    Airport{IataCode{"OBF"}, CountryId{"DE"}, Timezone{5199}}, // Oberpfaffenhofen Airport
    Airport{IataCode{"OBI"}, CountryId{"BR"}, Timezone{3160}}, // Tirios Airport
    Airport{IataCode{"OBN"}, CountryId{"GB"}, Timezone{5517}}, // Oban Airport
    Airport{IataCode{"OBO"}, CountryId{"JP"}, Timezone{4568}}, // Tokachi-Obihiro Airport
    Airport{IataCode{"OBS"}, CountryId{"FR"}, Timezone{5646}}, // Aubenas Aerodrome
    Airport{IataCode{"OBU"}, CountryId{"US"}, Timezone{814}}, // Kobuk Airport
    Airport{IataCode{"OBX"}, CountryId{"PG"}, Timezone{6686}}, // Obo Airport
    Airport{IataCode{"OCA"}, CountryId{"US"}, Timezone{2712}}, // Ocean Reef Club Airport
    Airport{IataCode{"OCC"}, CountryId{"EC"}, Timezone{1949}}, // Francisco de Orellana Airport
    Airport{IataCode{"OCE"}, CountryId{"US"}, Timezone{2712}}, // Ocean City Municipal Airport
    Airport{IataCode{"OCF"}, CountryId{"US"}, Timezone{2712}}, // Ocala International Airport
    Airport{IataCode{"OCJ"}, CountryId{"JM"}, Timezone{2260}}, // Ian Fleming International Airport
    Airport{IataCode{"OCM"}, CountryId{"AU"}, Timezone{5087}}, // Boolgeeda Airport
    Airport{IataCode{"OCN"}, CountryId{"US"}, Timezone{2378}}, // Oceanside Municipal Airport
    Airport{IataCode{"OCS"}, CountryId{"GQ"}, Timezone{551}}, // Corisco International Airport
    Airport{IataCode{"OCV"}, CountryId{"CO"}, Timezone{1376}}, // Aguas Claras Airport
    Airport{IataCode{"ODA"}, CountryId{"CF"}, Timezone{104}}, // Ouadda Airport
    Airport{IataCode{"ODB"}, CountryId{"ES"}, Timezone{5549}}, // Córdoba Airport
    Airport{IataCode{"ODC"}, CountryId{"US"}, Timezone{2378}}, // Oakdale Airport
    Airport{IataCode{"ODE"}, CountryId{"DK"}, Timezone{5312}}, // Hans Christian Andersen Airport
    Airport{IataCode{"ODJ"}, CountryId{"CF"}, Timezone{104}}, // Ouanda Djallé Airport
    Airport{IataCode{"ODM"}, CountryId{"US"}, Timezone{2712}}, // Garrett County Airport
    Airport{IataCode{"ODN"}, CountryId{"MY"}, Timezone{4190}}, // Long Seridan Airport
    Airport{IataCode{"ODO"}, CountryId{"RU"}, Timezone{4006}}, // Bodaybo Airport
    Airport{IataCode{"ODS"}, CountryId{"UA"}, Timezone{5461}}, // Odessa International Airport
    Airport{IataCode{"ODW"}, CountryId{"US"}, Timezone{2378}}, // A.J. Eisenberg Airport
    Airport{IataCode{"ODY"}, CountryId{"LA"}, Timezone{4633}}, // Oudomsay Airport
    Airport{IataCode{"OEA"}, CountryId{"US"}, Timezone{1510}}, // O'Neal Airport
    Airport{IataCode{"OEB"}, CountryId{"US"}, Timezone{1682}}, // Branch County Memorial Airport
    Airport{IataCode{"OEC"}, CountryId{"TL"}, Timezone{4226}}, // Oecusse Airport
    Airport{IataCode{"OEL"}, CountryId{"RU"}, Timezone{5620}}, // Oryol Yuzhny Airport
    Airport{IataCode{"OEM"}, CountryId{"SR"}, Timezone{2912}}, // Vincent Fayks Airport
    Airport{IataCode{"OEO"}, CountryId{"US"}, Timezone{1510}}, // L.O. Simenstad Municipal Airport
    Airport{IataCode{"OER"}, CountryId{"SE"}, Timezone{5822}}, // Örnsköldsvik Airport
    Airport{IataCode{"OES"}, CountryId{"AR"}, Timezone{1076}}, // Antoine de Saint Exupéry Airport
    Airport{IataCode{"OET"}, CountryId{"SA"}, Timezone{4404}}, // Thumamah Airport
    Airport{IataCode{"OFI"}, CountryId{"CI"}, Timezone{0}}, // Ouango Fitini Airport
    Airport{IataCode{"OFJ"}, CountryId{"IS"}, Timezone{4823}}, // Ólafsfjörður Airport
    Airport{IataCode{"OFK"}, CountryId{"US"}, Timezone{1510}}, // Norfolk Regional Airport
    Airport{IataCode{"OFP"}, CountryId{"US"}, Timezone{2712}}, // Hanover County Municipal Airport
    Airport{IataCode{"OFU"}, CountryId{"US"}, Timezone{6621}}, // Ofu Airport
    Airport{IataCode{"OGB"}, CountryId{"US"}, Timezone{2712}}, // Orangeburg Municipal Airport
    Airport{IataCode{"OGD"}, CountryId{"US"}, Timezone{1667}}, // Ogden-Hinckley Airport
    Airport{IataCode{"OGG"}, CountryId{"US"}, Timezone{6446}}, // Kahului Airport
    Airport{IataCode{"OGL"}, CountryId{"GY"}, Timezone{1949}}, // Eugene F. Correia International Airport - Ogle
    Airport{IataCode{"OGM"}, CountryId{"PA"}, Timezone{2877}}, // Ustupu-Ogobsucum Airport
    Airport{IataCode{"OGN"}, CountryId{"JP"}, Timezone{}}, // Yonaguni Airport
    Airport{IataCode{"OGO"}, CountryId{"CI"}, Timezone{0}}, // Abengourou Airport
    Airport{IataCode{"OGR"}, CountryId{"TD"}, Timezone{293}}, // Bongor Airport
    Airport{IataCode{"OGS"}, CountryId{"US"}, Timezone{3471}}, // Ogdensburg International Airport
    Airport{IataCode{"OGU"}, CountryId{"TR"}, Timezone{5412}}, // Ordu Giresun Airport
    Airport{IataCode{"OGX"}, CountryId{"DZ"}, Timezone{47}}, // Ain Beida Airport
    Airport{IataCode{"OGZ"}, CountryId{"RU"}, Timezone{5620}}, // Beslan Airport
    Airport{IataCode{"OHA"}, CountryId{"NZ"}, Timezone{6218}}, // RNZAF Base Ohakea
    Airport{IataCode{"OHD"}, CountryId{"MK"}, Timezone{5795}}, // Ohrid "St. Paul the Apostle" Airport
    Airport{IataCode{"OHE"}, CountryId{"CN"}, Timezone{4456}}, // Mohe Gulian Airport
    Airport{IataCode{"OHH"}, CountryId{"RU"}, Timezone{4416}}, // Okha Airport
    Airport{IataCode{"OHI"}, CountryId{"NA"}, Timezone{785}}, // Oshakati Airport
    Airport{IataCode{"OHO"}, CountryId{"RU"}, Timezone{4648}}, // Okhotsk Airport
    Airport{IataCode{"OHS"}, CountryId{"OM"}, Timezone{4252}}, // Sohar Airport
    Airport{IataCode{"OIA"}, CountryId{"BR"}, Timezone{1308}}, // Ourilândia do Norte Airport
    Airport{IataCode{"OIC"}, CountryId{"US"}, Timezone{2712}}, // Lt. Warren Eaton Airport
    Airport{IataCode{"OIM"}, CountryId{"JP"}, Timezone{4568}}, // Oshima Airport
    Airport{IataCode{"OIR"}, CountryId{"JP"}, Timezone{4568}}, // Okushiri Airport
    Airport{IataCode{"OIT"}, CountryId{"JP"}, Timezone{4568}}, // Oita Airport
    Airport{IataCode{"OJA"}, CountryId{"US"}, Timezone{1510}}, // Thomas P. Stafford Airport
    Airport{IataCode{"OJC"}, CountryId{"US"}, Timezone{1510}}, // Johnson County Executive Airport
    Airport{IataCode{"OKA"}, CountryId{"JP"}, Timezone{4568}}, // Naha Airport
    Airport{IataCode{"OKC"}, CountryId{"US"}, Timezone{1510}}, // Will Rogers World Airport
    Airport{IataCode{"OKD"}, CountryId{"JP"}, Timezone{4568}}, // Okadama Airport
    Airport{IataCode{"OKE"}, CountryId{"JP"}, Timezone{4568}}, // Okinoerabu Airport
    Airport{IataCode{"OKF"}, CountryId{"NA"}, Timezone{785}}, // Okaukuejo Airport
    Airport{IataCode{"OKG"}, CountryId{"CG"}, Timezone{148}}, // Okoyo Airport
    Airport{IataCode{"OKI"}, CountryId{"JP"}, Timezone{4568}}, // Oki Airport
    Airport{IataCode{"OKJ"}, CountryId{"JP"}, Timezone{4568}}, // Okayama Airport
    Airport{IataCode{"OKK"}, CountryId{"US"}, Timezone{2043}}, // Kokomo Municipal Airport
    Airport{IataCode{"OKL"}, CountryId{"ID"}, Timezone{4032}}, // Oksibil Airport
    Airport{IataCode{"OKM"}, CountryId{"US"}, Timezone{1510}}, // Okmulgee Regional Airport
    Airport{IataCode{"OKN"}, CountryId{"GA"}, Timezone{475}}, // Okondja Airport
    Airport{IataCode{"OKR"}, CountryId{"AU"}, Timezone{4920}}, // Yorke Island Airport
    Airport{IataCode{"OKS"}, CountryId{"JP"}, Timezone{4568}}, // Kōnan Airport
    Airport{IataCode{"OKT"}, CountryId{"RU"}, Timezone{5620}}, // Oktyabrsky Airport
    Airport{IataCode{"OKU"}, CountryId{"NA"}, Timezone{785}}, // Mokuti Lodge Airport
    Airport{IataCode{"OLA"}, CountryId{"NO"}, Timezone{5634}}, // Ørland Airport
    Airport{IataCode{"OLB"}, CountryId{"IT"}, Timezone{5702}}, // Olbia Costa Smeralda Airport
    Airport{IataCode{"OLC"}, CountryId{"BR"}, Timezone{2451}}, // São Paulo de Olivença Airport
    Airport{IataCode{"OLD"}, CountryId{"US"}, Timezone{2712}}, // Old Town Municipal Airport and Seaplane Base
    Airport{IataCode{"OLE"}, CountryId{"US"}, Timezone{2712}}, // Cattaraugus County-Olean Airport
    Airport{IataCode{"OLF"}, CountryId{"US"}, Timezone{1667}}, // L. M. Clayton Airport
    Airport{IataCode{"OLH"}, CountryId{"US"}, Timezone{814}}, // Old Harbor Airport
    Airport{IataCode{"OLI"}, CountryId{"IS"}, Timezone{4823}}, // Rif Airport
    Airport{IataCode{"OLJ"}, CountryId{"VU"}, Timezone{}}, // Olpoi Airport
    Airport{IataCode{"OLL"}, CountryId{"CG"}, Timezone{148}}, // Oyo Ollombo Airport
    Airport{IataCode{"OLM"}, CountryId{"US"}, Timezone{2378}}, // Olympia Regional Airport
    Airport{IataCode{"OLN"}, CountryId{"AR"}, Timezone{914}}, // Sarmiento Airport
    Airport{IataCode{"OLO"}, CountryId{"CZ"}, Timezone{5676}}, // Olomouc Airport
    Airport{IataCode{"OLP"}, CountryId{"AU"}, Timezone{4901}}, // Olympic Dam Airport
    Airport{IataCode{"OLS"}, CountryId{"US"}, Timezone{2931}}, // Nogales International Airport
    Airport{IataCode{"OLU"}, CountryId{"US"}, Timezone{1510}}, // Columbus Municipal Airport
    Airport{IataCode{"OLV"}, CountryId{"US"}, Timezone{1510}}, // Olive Branch Airport
    Airport{IataCode{"OLZ"}, CountryId{"RU"}, Timezone{4665}}, // Olyokminsk Airport
    Airport{IataCode{"OMA"}, CountryId{"US"}, Timezone{1510}}, // Eppley Airfield
    Airport{IataCode{"OMB"}, CountryId{"GA"}, Timezone{475}}, // Omboue Hospital Airport
    Airport{IataCode{"OMC"}, CountryId{"PH"}, Timezone{4240}}, // Ormoc Airport
    Airport{IataCode{"OMD"}, CountryId{"NA"}, Timezone{785}}, // Oranjemund Airport
    Airport{IataCode{"OME"}, CountryId{"US"}, Timezone{2745}}, // Nome Airport
    Airport{IataCode{"OMG"}, CountryId{"NA"}, Timezone{}}, // Omega Airport
    Airport{IataCode{"OMH"}, CountryId{"IR"}, Timezone{4543}}, // Urmia Airport
    Airport{IataCode{"OMK"}, CountryId{"US"}, Timezone{2378}}, // Omak Airport
    Airport{IataCode{"OMM"}, CountryId{"OM"}, Timezone{4252}}, // Marmul, OOMX Airport
    Airport{IataCode{"OMO"}, CountryId{"BA"}, Timezone{5746}}, // Mostar International Airport
    Airport{IataCode{"OMR"}, CountryId{"RO"}, Timezone{5247}}, // Oradea International Airport
    Airport{IataCode{"OMS"}, CountryId{"RU"}, Timezone{4322}}, // Omsk Tsentralny Airport
    Airport{IataCode{"OMY"}, CountryId{"KH"}, Timezone{4332}}, // Thbeng Meanchey Airport
    Airport{IataCode{"ONA"}, CountryId{"US"}, Timezone{1510}}, // Winona Municipal Airport
    Airport{IataCode{"OND"}, CountryId{"NA"}, Timezone{785}}, // Ondangwa Airport
    Airport{IataCode{"ONG"}, CountryId{"AU"}, Timezone{4920}}, // Mornington Island Airport
    Airport{IataCode{"ONH"}, CountryId{"US"}, Timezone{2712}}, // Oneonta Municipal Airport
    Airport{IataCode{"ONJ"}, CountryId{"JP"}, Timezone{4568}}, // Odate-Noshiro Airport
    Airport{IataCode{"ONK"}, CountryId{"RU"}, Timezone{4665}}, // Olenyok Airport
    Airport{IataCode{"ONL"}, CountryId{"US"}, Timezone{1510}}, // O'Neill Municipal Airport
    Airport{IataCode{"ONO"}, CountryId{"US"}, Timezone{1391}}, // Ontario Municipal Airport
    Airport{IataCode{"ONP"}, CountryId{"US"}, Timezone{2378}}, // Newport Municipal Airport
    Airport{IataCode{"ONQ"}, CountryId{"TR"}, Timezone{5412}}, // Zonguldak Airport
    Airport{IataCode{"ONS"}, CountryId{"AU"}, Timezone{5087}}, // Onslow Airport
    Airport{IataCode{"ONT"}, CountryId{"US"}, Timezone{2378}}, // LA/Ontario International Airport
    Airport{IataCode{"ONX"}, CountryId{"PA"}, Timezone{2877}}, // Enrique Adolfo Jiménez Airport
    Airport{IataCode{"ONZ"}, CountryId{"US"}, Timezone{1682}}, // Grosse Ile Municipal Airport
    Airport{IataCode{"OOD"}, CountryId{"AU"}, Timezone{4901}}, // Oodnadatta Airport
    Airport{IataCode{"OOK"}, CountryId{"US"}, Timezone{2745}}, // Toksook Bay Airport
    Airport{IataCode{"OOL"}, CountryId{"AU"}, Timezone{4920}}, // Gold Coast Airport
    Airport{IataCode{"OOM"}, CountryId{"AU"}, Timezone{5103}}, // Cooma – Snowy Mountains Airport
    Airport{IataCode{"OOT"}, CountryId{"KI"}, Timezone{}}, // Onotoa Airport
    Airport{IataCode{"OPA"}, CountryId{"IS"}, Timezone{4823}}, // Kópasker Airport
    Airport{IataCode{"OPF"}, CountryId{"US"}, Timezone{2712}}, // Opa-locka Airport
    Airport{IataCode{"OPI"}, CountryId{"AU"}, Timezone{4978}}, // Oenpelli Airport
    Airport{IataCode{"OPL"}, CountryId{"US"}, Timezone{1510}}, // St. Landry Parish Airport
    Airport{IataCode{"OPO"}, CountryId{"PT"}, Timezone{5486}}, // Francisco de Sá Carneiro Airport
    Airport{IataCode{"OPS"}, CountryId{"BR"}, Timezone{1579}}, // Sinop Airport
    Airport{IataCode{"OPU"}, CountryId{"PG"}, Timezone{6686}}, // Balimo Airport
    Airport{IataCode{"OPW"}, CountryId{"NA"}, Timezone{785}}, // Opuwa Airport
    Airport{IataCode{"OQN"}, CountryId{"US"}, Timezone{2712}}, // Brandywine Airport
    Airport{IataCode{"OQU"}, CountryId{"US"}, Timezone{2712}}, // Quonset State Airport
    Airport{IataCode{"ORA"}, CountryId{"AR"}, Timezone{1076}}, // Orán Airport
    Airport{IataCode{"ORB"}, CountryId{"SE"}, Timezone{5822}}, // Örebro Airport
    Airport{IataCode{"ORC"}, CountryId{"CO"}, Timezone{1376}}, // Orocue Airport
    Airport{IataCode{"ORD"}, CountryId{"US"}, Timezone{1510}}, // O'Hare International Airport
    Airport{IataCode{"ORE"}, CountryId{"FR"}, Timezone{5646}}, // Orléans – Saint-Denis-de-l'Hôtel Airport
    Airport{IataCode{"ORF"}, CountryId{"US"}, Timezone{2712}}, // Norfolk International Airport
    Airport{IataCode{"ORG"}, CountryId{"SR"}, Timezone{2912}}, // Zorg en Hoop Airport
    Airport{IataCode{"ORH"}, CountryId{"US"}, Timezone{2712}}, // Worcester Regional Airport
    Airport{IataCode{"ORI"}, CountryId{"US"}, Timezone{814}}, // Port Lions Airport
    Airport{IataCode{"ORJ"}, CountryId{"GY"}, Timezone{1358}}, // Orinduik Airport
    Airport{IataCode{"ORK"}, CountryId{"IE"}, Timezone{5330}}, // Cork Airport
    Airport{IataCode{"ORL"}, CountryId{"US"}, Timezone{2712}}, // Orlando Executive Airport
    Airport{IataCode{"ORM"}, CountryId{"GB"}, Timezone{5517}}, // Sywell Aerodrome
    Airport{IataCode{"ORN"}, CountryId{"DZ"}, Timezone{47}}, // Oran Es Sénia Airport
    Airport{IataCode{"ORO"}, CountryId{"HN"}, Timezone{3401}}, // Yoro Airport
    Airport{IataCode{"ORP"}, CountryId{"BW"}, Timezone{339}}, // Orapa Airport
    Airport{IataCode{"ORT"}, CountryId{"US"}, Timezone{814}}, // Northway Airport
    Airport{IataCode{"ORU"}, CountryId{"BO"}, Timezone{2350}}, // Juan Mendoza Airport
    Airport{IataCode{"ORV"}, CountryId{"US"}, Timezone{814}}, // Robert (Bob) Curtis Memorial Airport
    Airport{IataCode{"ORW"}, CountryId{"PK"}, Timezone{4087}}, // Ormara Airport
    Airport{IataCode{"ORX"}, CountryId{"BR"}, Timezone{3160}}, // Oriximiná Airport
    Airport{IataCode{"ORY"}, CountryId{"FR"}, Timezone{5646}}, // Orly Airport
    Airport{IataCode{"ORZ"}, CountryId{"BZ"}, Timezone{1322}}, // Orange Walk Airport
    Airport{IataCode{"OSC"}, CountryId{"US"}, Timezone{1682}}, // Oscoda-Wurtsmith Airport
    Airport{IataCode{"OSD"}, CountryId{"SE"}, Timezone{5822}}, // Åre Östersund Airport
    Airport{IataCode{"OSF"}, CountryId{"RU"}, Timezone{5620}}, // Ostafyevo International Airport
    Airport{IataCode{"OSH"}, CountryId{"US"}, Timezone{1510}}, // Wittman Regional Airport
    Airport{IataCode{"OSI"}, CountryId{"HR"}, Timezone{5989}}, // Osijek Airport
    Airport{IataCode{"OSL"}, CountryId{"NO"}, Timezone{5634}}, // Oslo Airport
    Airport{IataCode{"OSM"}, CountryId{"IQ"}, Timezone{3728}}, // Mosul International Airport
    Airport{IataCode{"OSO"}, CountryId{"AU"}, Timezone{4920}}, // Osborne Mine Airport
    Airport{IataCode{"OSP"}, CountryId{"PL"}, Timezone{5975}}, // Słupsk-Redzikowo Airport
    Airport{IataCode{"OSR"}, CountryId{"CZ"}, Timezone{5676}}, // Leoš Janáček Airport Ostrava
    Airport{IataCode{"OSS"}, CountryId{"KG"}, Timezone{4516}}, // Osh Airport
    Airport{IataCode{"OST"}, CountryId{"BE"}, Timezone{5231}}, // Ostend-Bruges International Airport
    Airport{IataCode{"OSU"}, CountryId{"US"}, Timezone{2712}}, // Ohio State University Airport
    Airport{IataCode{"OSW"}, CountryId{"RU"}, Timezone{4690}}, // Orsk Airport
    Airport{IataCode{"OSY"}, CountryId{"NO"}, Timezone{5634}}, // Namsos Airport
    Airport{IataCode{"OSZ"}, CountryId{"PL"}, Timezone{5975}}, // Koszalin-Zegrze Pomorskie Airport
    Airport{IataCode{"OTC"}, CountryId{"TD"}, Timezone{656}}, // Bol Airport
    Airport{IataCode{"OTD"}, CountryId{"PA"}, Timezone{2877}}, // Contadora Airport
    Airport{IataCode{"OTH"}, CountryId{"US"}, Timezone{2378}}, // Southwest Oregon Regional Airport
    Airport{IataCode{"OTI"}, CountryId{"ID"}, Timezone{4032}}, // Pitu Airport
    Airport{IataCode{"OTJ"}, CountryId{"NA"}, Timezone{785}}, // Otjiwarongo Airport
    Airport{IataCode{"OTL"}, CountryId{"MR"}, Timezone{686}}, // Boutilimit Airport
    Airport{IataCode{"OTM"}, CountryId{"US"}, Timezone{1510}}, // Ottumwa Regional Airport
    Airport{IataCode{"OTN"}, CountryId{"US"}, Timezone{1510}}, // Ed-Air Airport
    Airport{IataCode{"OTP"}, CountryId{"RO"}, Timezone{5247}}, // Henri Coandă International Airport
    Airport{IataCode{"OTR"}, CountryId{"CR"}, Timezone{1544}}, // Coto 47 Airport
    Airport{IataCode{"OTS"}, CountryId{"US"}, Timezone{2378}}, // Anacortes Airport
    Airport{IataCode{"OTU"}, CountryId{"CO"}, Timezone{1376}}, // Otú Airport
    Airport{IataCode{"OTZ"}, CountryId{"US"}, Timezone{2745}}, // Ralph Wien Memorial Airport
    Airport{IataCode{"OUA"}, CountryId{"BF"}, Timezone{704}}, // Ouagadougou Airport
    Airport{IataCode{"OUD"}, CountryId{"MA"}, Timezone{215}}, // Angads Airport
    Airport{IataCode{"OUE"}, CountryId{"CG"}, Timezone{148}}, // Ouésso Airport
    Airport{IataCode{"OUG"}, CountryId{"BF"}, Timezone{704}}, // Ouahigouya Airport
    Airport{IataCode{"OUL"}, CountryId{"FI"}, Timezone{5377}}, // Oulu Airport
    Airport{IataCode{"OUM"}, CountryId{"TD"}, Timezone{656}}, // Oum Hadjer Airport
    Airport{IataCode{"OUN"}, CountryId{"US"}, Timezone{1510}}, // University of Oklahoma Westheimer Airport
    Airport{IataCode{"OUR"}, CountryId{"CM"}, Timezone{293}}, // Batouri Airport
    Airport{IataCode{"OUS"}, CountryId{"BR"}, Timezone{3216}}, // Ourinhos Airport
    Airport{IataCode{"OUT"}, CountryId{"TD"}, Timezone{656}}, // Bousso Airport
    Airport{IataCode{"OUZ"}, CountryId{"MR"}, Timezone{686}}, // Tazadit Airport
    Airport{IataCode{"OVB"}, CountryId{"RU"}, Timezone{4295}}, // Tolmachevo Airport
    Airport{IataCode{"OVD"}, CountryId{"ES"}, Timezone{5549}}, // Asturias Airport
    Airport{IataCode{"OVE"}, CountryId{"US"}, Timezone{2378}}, // Oroville Municipal Airport
    Airport{IataCode{"OVL"}, CountryId{"CL"}, Timezone{3177}}, // El Tuqui Airport
    Airport{IataCode{"OVR"}, CountryId{"AR"}, Timezone{883}}, // Olavarría Airport
    Airport{IataCode{"OVS"}, CountryId{"RU"}, Timezone{4690}}, // Sovetsky Airport
    Airport{IataCode{"OWB"}, CountryId{"US"}, Timezone{1510}}, // Owensboro-Daviess County Regional Airport
    Airport{IataCode{"OWD"}, CountryId{"US"}, Timezone{2712}}, // Norwood Memorial Airport
    Airport{IataCode{"OWI"}, CountryId{"US"}, Timezone{1510}}, // Ottawa Municipal Airport
    Airport{IataCode{"OWK"}, CountryId{"US"}, Timezone{2712}}, // Central Maine Airport of Norridgewock
    Airport{IataCode{"OWP"}, CountryId{"US"}, Timezone{1510}}, // William R. Pogue Municipal Airport
    Airport{IataCode{"OXB"}, CountryId{"GW"}, Timezone{118}}, // Osvaldo Vieira International Airport
    Airport{IataCode{"OXC"}, CountryId{"US"}, Timezone{2712}}, // Waterbury-Oxford Airport
    Airport{IataCode{"OXD"}, CountryId{"US"}, Timezone{2043}}, // Miami University Airport
    Airport{IataCode{"OXF"}, CountryId{"GB"}, Timezone{5517}}, // London Oxford Airport
    Airport{IataCode{"OYA"}, CountryId{"AR"}, Timezone{942}}, // Goya Airport
    Airport{IataCode{"OYE"}, CountryId{"GA"}, Timezone{475}}, // Oyem Airport
    Airport{IataCode{"OYG"}, CountryId{"UG"}, Timezone{389}}, // Moyo Airport
    Airport{IataCode{"OYK"}, CountryId{"BR"}, Timezone{1479}}, // Oiapoque Airport
    Airport{IataCode{"OYL"}, CountryId{"KE"}, Timezone{28}}, // Moyale Airport
    Airport{IataCode{"OYO"}, CountryId{"AR"}, Timezone{883}}, // Tres Arroyos Airport
    Airport{IataCode{"OYP"}, CountryId{"FR"}, Timezone{1479}}, // Saint-Georges-de-l'Oyapock Airport
    Airport{IataCode{"OZC"}, CountryId{"PH"}, Timezone{4240}}, // Labo Airport
    Airport{IataCode{"OZG"}, CountryId{"MA"}, Timezone{215}}, // Zagora Airport
    Airport{IataCode{"OZH"}, CountryId{"UA"}, Timezone{6003}}, // Zaporizhzhia International Airport
    Airport{IataCode{"OZS"}, CountryId{"US"}, Timezone{1510}}, // Camdenton Memorial Airport
    Airport{IataCode{"OZW"}, CountryId{"US"}, Timezone{1682}}, // Livingston County Spencer J. Hardy Airport
    Airport{IataCode{"OZZ"}, CountryId{"MA"}, Timezone{215}}, // Ouarzazate Airport
    Airport{IataCode{"PAA"}, CountryId{"MM"}, Timezone{4678}}, // Hpa-An Airport
    Airport{IataCode{"PAB"}, CountryId{"IN"}, Timezone{4129}}, // Bilaspur Airport
    Airport{IataCode{"PAC"}, CountryId{"PA"}, Timezone{2877}}, // Albrook "Marcos A. Gelabert" International Airport
    Airport{IataCode{"PAD"}, CountryId{"DE"}, Timezone{5199}}, // Paderborn Lippstadt Airport
    Airport{IataCode{"PAE"}, CountryId{"US"}, Timezone{2378}}, // Paine Field
    Airport{IataCode{"PAF"}, CountryId{"UG"}, Timezone{401}}, // Pakuba Airport
    Airport{IataCode{"PAG"}, CountryId{"PH"}, Timezone{4240}}, // Pagadian Airport
    Airport{IataCode{"PAH"}, CountryId{"US"}, Timezone{1510}}, // Barkley Regional Airport
    Airport{IataCode{"PAJ"}, CountryId{"PK"}, Timezone{}}, // Parachinar Airport
    Airport{IataCode{"PAK"}, CountryId{"US"}, Timezone{6446}}, // Port Allen Airport
    Airport{IataCode{"PAN"}, CountryId{"TH"}, Timezone{3777}}, // Pattani Airport
    Airport{IataCode{"PAO"}, CountryId{"US"}, Timezone{2378}}, // Palo Alto Airport of Santa Clara County
    Airport{IataCode{"PAP"}, CountryId{"HT"}, Timezone{2947}}, // Toussaint Louverture International Airport
    Airport{IataCode{"PAQ"}, CountryId{"US"}, Timezone{814}}, // Palmer Municipal Airport
    Airport{IataCode{"PAS"}, CountryId{"GR"}, Timezone{5169}}, // Paros National Airport
    Airport{IataCode{"PAT"}, CountryId{"IN"}, Timezone{4129}}, // Lok Nayak Jayaprakash Airport
    Airport{IataCode{"PAV"}, CountryId{"BR"}, Timezone{1254}}, // Paulo Afonso Airport
    Airport{IataCode{"PAX"}, CountryId{"HT"}, Timezone{2947}}, // Port-de-Paix Airport
    Airport{IataCode{"PAZ"}, CountryId{"MX"}, Timezone{2588}}, // El Tajín National Airport
    Airport{IataCode{"PBC"}, CountryId{"MX"}, Timezone{2588}}, // Hermanos Serdán International Airport
    Airport{IataCode{"PBD"}, CountryId{"IN"}, Timezone{4129}}, // Porbandar Airport
    Airport{IataCode{"PBE"}, CountryId{"CO"}, Timezone{1376}}, // Morela Airport
    Airport{IataCode{"PBF"}, CountryId{"US"}, Timezone{1510}}, // Grider Field
    Airport{IataCode{"PBG"}, CountryId{"US"}, Timezone{2712}}, // Plattsburgh International Airport
    Airport{IataCode{"PBH"}, CountryId{"BT"}, Timezone{4555}}, // Paro Airport
    Airport{IataCode{"PBI"}, CountryId{"US"}, Timezone{2712}}, // Palm Beach International Airport
    Airport{IataCode{"PBJ"}, CountryId{"VU"}, Timezone{6301}}, // Paama Airport
    Airport{IataCode{"PBL"}, CountryId{"VE"}, Timezone{1463}}, // General Bartolomé Salom Airport
    Airport{IataCode{"PBM"}, CountryId{"SR"}, Timezone{2912}}, // Johan Adolf Pengel International Airport
    Airport{IataCode{"PBN"}, CountryId{"AO"}, Timezone{505}}, // Porto Amboim Airport
    Airport{IataCode{"PBO"}, CountryId{"AU"}, Timezone{5087}}, // Paraburdoo Airport
    Airport{IataCode{"PBP"}, CountryId{"CR"}, Timezone{1544}}, // Punta Islita Airport
    Airport{IataCode{"PBQ"}, CountryId{"BR"}, Timezone{2992}}, // Pimenta Bueno Airport
    Airport{IataCode{"PBR"}, CountryId{"GT"}, Timezone{1913}}, // Puerto Barrios Airport
    Airport{IataCode{"PBU"}, CountryId{"MM"}, Timezone{4678}}, // Putao Airport
    Airport{IataCode{"PBV"}, CountryId{"BR"}, Timezone{1579}}, // Porto Dos Gaúchos Airport
    Airport{IataCode{"PBZ"}, CountryId{"ZA"}, Timezone{369}}, // Plettenberg Bay Airport
    Airport{IataCode{"PCA"}, CountryId{"US"}, Timezone{814}}, // Portage Creek Airport
    Airport{IataCode{"PCB"}, CountryId{"ID"}, Timezone{4032}}, // Pondok Cabe Airport
    Airport{IataCode{"PCD"}, CountryId{"US"}, Timezone{1510}}, // Prairie du Chien Municipal Airport
    Airport{IataCode{"PCH"}, CountryId{"HN"}, Timezone{3401}}, // Palacios Airport
    Airport{IataCode{"PCL"}, CountryId{"PE"}, Timezone{2365}}, // FAP Captain David Abensur Rengifo International Airport
    Airport{IataCode{"PCM"}, CountryId{"US"}, Timezone{2712}}, // Plant City Airport
    Airport{IataCode{"PCN"}, CountryId{"NZ"}, Timezone{6218}}, // Picton Aerodrome
    Airport{IataCode{"PCO"}, CountryId{"MX"}, Timezone{2519}}, // Punta Colorada Airstrip
    Airport{IataCode{"PCP"}, CountryId{"ST"}, Timezone{741}}, // Príncipe Airport
    Airport{IataCode{"PCR"}, CountryId{"CO"}, Timezone{}}, // Germán Olano Airport
    Airport{IataCode{"PCS"}, CountryId{"BR"}, Timezone{1789}}, // Picos Airport
    Airport{IataCode{"PCT"}, CountryId{"US"}, Timezone{2712}}, // Princeton Airport
    Airport{IataCode{"PCW"}, CountryId{"US"}, Timezone{2712}}, // Erie-Ottawa International Airport
    Airport{IataCode{"PCZ"}, CountryId{"US"}, Timezone{1510}}, // Waupaca Municipal Airport
    Airport{IataCode{"PDA"}, CountryId{"CO"}, Timezone{1376}}, // Obando Airport
    Airport{IataCode{"PDB"}, CountryId{"US"}, Timezone{814}}, // Pedro Bay Airport
    Airport{IataCode{"PDD"}, CountryId{"MZ"}, Timezone{565}}, // Ponta do Ouro Airport
    Airport{IataCode{"PDG"}, CountryId{"ID"}, Timezone{4032}}, // Minangkabau International Airport
    Airport{IataCode{"PDK"}, CountryId{"US"}, Timezone{2712}}, // DeKalb-Peachtree Airport
    Airport{IataCode{"PDL"}, CountryId{"PT"}, Timezone{4722}}, // João Paulo II Airport
    Airport{IataCode{"PDO"}, CountryId{"ID"}, Timezone{4032}}, // Pendopo Airport
    Airport{IataCode{"PDP"}, CountryId{"UY"}, Timezone{2659}}, // Capitán de Corbeta Carlos A. Curbelo International Airport
    Airport{IataCode{"PDS"}, CountryId{"MX"}, Timezone{2501}}, // Piedras Negras International Airport
    Airport{IataCode{"PDU"}, CountryId{"UY"}, Timezone{942}}, // Paysandú Airport
    Airport{IataCode{"PDX"}, CountryId{"US"}, Timezone{2378}}, // Portland International Airport
    Airport{IataCode{"PDZ"}, CountryId{}, Timezone{1463}}, // Pedernales Airport
    Airport{IataCode{"PEC"}, CountryId{"US"}, Timezone{2260}}, // Pelican Seaplane Base
    Airport{IataCode{"PED"}, CountryId{"CZ"}, Timezone{5676}}, // Pardubice Airport
    Airport{IataCode{"PEE"}, CountryId{"RU"}, Timezone{4690}}, // Bolshoye Savino Airport
    Airport{IataCode{"PEF"}, CountryId{"DE"}, Timezone{5199}}, // Peenemünde Airfield
    Airport{IataCode{"PEG"}, CountryId{"IT"}, Timezone{5702}}, // Perugia San Francesco d'Assisi – Umbria International Airport
    Airport{IataCode{"PEH"}, CountryId{"AR"}, Timezone{883}}, // Comodoro P. Zanni Airport
    Airport{IataCode{"PEI"}, CountryId{"CO"}, Timezone{1376}}, // Matecaña International Airport
    Airport{IataCode{"PEK"}, CountryId{"CN"}, Timezone{4456}}, // Beijing Capital International Airport
    Airport{IataCode{"PEL"}, CountryId{"LS"}, Timezone{579}}, // Pelaneng Airport
    Airport{IataCode{"PEM"}, CountryId{"PE"}, Timezone{2365}}, // Padre Aldamiz International Airport
    Airport{IataCode{"PEN"}, CountryId{"MY"}, Timezone{4159}}, // Penang International Airport
    Airport{IataCode{"PEO"}, CountryId{"US"}, Timezone{2712}}, // Penn Yan Airport
    Airport{IataCode{"PEQ"}, CountryId{"US"}, Timezone{1510}}, // Pecos Municipal Airport
    Airport{IataCode{"PER"}, CountryId{"AU"}, Timezone{5087}}, // Perth Airport
    Airport{IataCode{"PES"}, CountryId{"RU"}, Timezone{5620}}, // Petrozavodsk Airport
    Airport{IataCode{"PET"}, CountryId{"BR"}, Timezone{3216}}, // Pelotas International Airport
    Airport{IataCode{"PEU"}, CountryId{"HN"}, Timezone{3401}}, // Puerto Lempira Airport
    Airport{IataCode{"PEW"}, CountryId{"PK"}, Timezone{4087}}, // Bacha Khan International Airport
    Airport{IataCode{"PEX"}, CountryId{"RU"}, Timezone{5620}}, // Pechora Airport
    Airport{IataCode{"PEZ"}, CountryId{"RU"}, Timezone{5620}}, // Penza Airport
    Airport{IataCode{"PFB"}, CountryId{"BR"}, Timezone{3216}}, // Lauro Kurtz Airport
    Airport{IataCode{"PFC"}, CountryId{"US"}, Timezone{2378}}, // Pacific City State Airport
    Airport{IataCode{"PFJ"}, CountryId{"IS"}, Timezone{4823}}, // Patreksfjörður Airport
    Airport{IataCode{"PFN"}, CountryId{"US"}, Timezone{1510}}, // Panama City–Bay County International Airport
    Airport{IataCode{"PFO"}, CountryId{"CY"}, Timezone{4264}}, // Paphos International Airport
    Airport{IataCode{"PFQ"}, CountryId{"IR"}, Timezone{3754}}, // Parsabad-Moghan Airport
    Airport{IataCode{"PFR"}, CountryId{"CD"}, Timezone{446}}, // Ilebo Airport
    Airport{IataCode{"PGA"}, CountryId{"US"}, Timezone{2931}}, // Page Municipal Airport
    Airport{IataCode{"PGB"}, CountryId{"RS"}, Timezone{5183}}, // Progar Airport
    Airport{IataCode{"PGC"}, CountryId{"US"}, Timezone{2712}}, // Grant County Airport
    Airport{IataCode{"PGD"}, CountryId{"US"}, Timezone{2712}}, // Punta Gorda Airport
    Airport{IataCode{"PGF"}, CountryId{"FR"}, Timezone{5646}}, // Perpignan–Rivesaltes Airport
    Airport{IataCode{"PGH"}, CountryId{"IN"}, Timezone{4129}}, // Pantnagar Airport
    Airport{IataCode{"PGI"}, CountryId{"AO"}, Timezone{519}}, // Chitato Airport
    Airport{IataCode{"PGK"}, CountryId{"ID"}, Timezone{4032}}, // Depati Amir Airport
    Airport{IataCode{"PGL"}, CountryId{"US"}, Timezone{1510}}, // Trent Lott International Airport
    Airport{IataCode{"PGM"}, CountryId{"US"}, Timezone{814}}, // Port Graham Airport
    Airport{IataCode{"PGN"}, CountryId{"HT"}, Timezone{2947}}, // Pignon Airport
    Airport{IataCode{"PGO"}, CountryId{"US"}, Timezone{1667}}, // Stevens Field
    Airport{IataCode{"PGP"}, CountryId{"ST"}, Timezone{741}}, // Porto Alegre Airport
    Airport{IataCode{"PGR"}, CountryId{"US"}, Timezone{1510}}, // Kirk Field
    Airport{IataCode{"PGS"}, CountryId{"US"}, Timezone{2931}}, // Grand Canyon Caverns Airport
    Airport{IataCode{"PGU"}, CountryId{"IR"}, Timezone{4543}}, // Persian Gulf Airport
    Airport{IataCode{"PGV"}, CountryId{"US"}, Timezone{2712}}, // Pitt-Greenville Airport
    Airport{IataCode{"PGX"}, CountryId{"FR"}, Timezone{5646}}, // Périgueux Bassillac Airport
    Airport{IataCode{"PGZ"}, CountryId{"BR"}, Timezone{3216}}, // Ponta Grossa Airport
    Airport{IataCode{"PHB"}, CountryId{"BR"}, Timezone{1789}}, // Parnaíba-Prefeito Dr. João Silva Filho International Airport
    Airport{IataCode{"PHC"}, CountryId{"NG"}, Timezone{462}}, // Port Harcourt International Airport
    Airport{IataCode{"PHD"}, CountryId{"US"}, Timezone{2712}}, // Harry Clever Field
    Airport{IataCode{"PHE"}, CountryId{"AU"}, Timezone{5087}}, // Port Hedland International Airport
    Airport{IataCode{"PHF"}, CountryId{"US"}, Timezone{2712}}, // Newport News/Williamsburg International Airport
    Airport{IataCode{"PHG"}, CountryId{"NG"}, Timezone{462}}, // Port Harcourt City Airport
    Airport{IataCode{"PHI"}, CountryId{"BR"}, Timezone{1789}}, // Pinheiro Airport
    Airport{IataCode{"PHK"}, CountryId{"US"}, Timezone{2712}}, // Palm Beach County Glades Airport
    Airport{IataCode{"PHL"}, CountryId{"US"}, Timezone{2712}}, // Philadelphia International Airport
    Airport{IataCode{"PHM"}, CountryId{"DE"}, Timezone{5199}}, // Böblingen Airport
    Airport{IataCode{"PHN"}, CountryId{"US"}, Timezone{1682}}, // St. Clair County International Airport
    Airport{IataCode{"PHO"}, CountryId{"US"}, Timezone{2745}}, // Point Hope Airport
    Airport{IataCode{"PHQ"}, CountryId{"AU"}, Timezone{4920}}, // The Monument Airport
    Airport{IataCode{"PHS"}, CountryId{"TH"}, Timezone{3777}}, // Phitsanulok Airport
    Airport{IataCode{"PHT"}, CountryId{"US"}, Timezone{1510}}, // Henry County Airport
    Airport{IataCode{"PHW"}, CountryId{"ZA"}, Timezone{369}}, // Hendrik Van Eck Airport
    Airport{IataCode{"PHX"}, CountryId{"US"}, Timezone{2931}}, // Phoenix Sky Harbor International Airport
    Airport{IataCode{"PHY"}, CountryId{"TH"}, Timezone{3777}}, // Phetchabun Airport
    Airport{IataCode{"PIA"}, CountryId{"US"}, Timezone{1510}}, // Peoria International Airport
    Airport{IataCode{"PIB"}, CountryId{"US"}, Timezone{1510}}, // Hattiesburg-Laurel Regional Airport
    Airport{IataCode{"PIC"}, CountryId{"GB"}, Timezone{1859}}, // Pine Cay Airport
    Airport{IataCode{"PID"}, CountryId{"BS"}, Timezone{2697}}, // New Providence Airport
    Airport{IataCode{"PIE"}, CountryId{"US"}, Timezone{2712}}, // St. Petersburg–Clearwater International Airport
    Airport{IataCode{"PIF"}, CountryId{"TW"}, Timezone{4504}}, // Pingtung Airport
    Airport{IataCode{"PIG"}, CountryId{"AR"}, Timezone{883}}, // Pigue Airport
    Airport{IataCode{"PIH"}, CountryId{"US"}, Timezone{1391}}, // Pocatello Regional Airport
    Airport{IataCode{"PIK"}, CountryId{"GB"}, Timezone{5517}}, // Glasgow Prestwick Airport
    Airport{IataCode{"PIL"}, CountryId{"PY"}, Timezone{942}}, // Carlos Miguel Jiménez Airport
    Airport{IataCode{"PIM"}, CountryId{"US"}, Timezone{2712}}, // Harris County Airport
    Airport{IataCode{"PIN"}, CountryId{"BR"}, Timezone{2451}}, // Parintins Airport
    Airport{IataCode{"PIO"}, CountryId{"PE"}, Timezone{2365}}, // Capitán FAP Renán Elías Olivera Airport
    Airport{IataCode{"PIP"}, CountryId{"US"}, Timezone{814}}, // Pilot Point Airport
    Airport{IataCode{"PIR"}, CountryId{"US"}, Timezone{1510}}, // Pierre Regional Airport
    Airport{IataCode{"PIS"}, CountryId{"FR"}, Timezone{5646}}, // Poitiers – Biard Airport
    Airport{IataCode{"PIT"}, CountryId{"US"}, Timezone{2712}}, // Pittsburgh International Airport
    Airport{IataCode{"PIU"}, CountryId{"PE"}, Timezone{2365}}, // Cap. FAP Guillermo Concha Iberico International Airport
    Airport{IataCode{"PIW"}, CountryId{"CA"}, Timezone{3540}}, // Pikwitonei Airport
    Airport{IataCode{"PIX"}, CountryId{"PT"}, Timezone{4722}}, // Pico Airport
    Airport{IataCode{"PIZ"}, CountryId{"US"}, Timezone{2745}}, // Point Lay LRRS Airport
    Airport{IataCode{"PJA"}, CountryId{"SE"}, Timezone{5822}}, // Pajala Airport
    Airport{IataCode{"PJB"}, CountryId{"US"}, Timezone{2931}}, // Payson Airport
    Airport{IataCode{"PJC"}, CountryId{"PY"}, Timezone{1220}}, // Dr. Augusto Roberto Fuster International Airport
    Airport{IataCode{"PJG"}, CountryId{"PK"}, Timezone{4087}}, // Panjgur Airport
    Airport{IataCode{"PJM"}, CountryId{"CR"}, Timezone{1544}}, // Puerto Jiménez Airport
    Airport{IataCode{"PKA"}, CountryId{"US"}, Timezone{814}}, // Napaskiak Airport
    Airport{IataCode{"PKB"}, CountryId{"US"}, Timezone{2712}}, // Mid-Ohio Valley Regional Airport
    Airport{IataCode{"PKC"}, CountryId{"RU"}, Timezone{4072}}, // Petropavlovsk-Kamchatsky Airport
    Airport{IataCode{"PKE"}, CountryId{"AU"}, Timezone{5103}}, // Parkes Regional Airport
    Airport{IataCode{"PKF"}, CountryId{"US"}, Timezone{1510}}, // Park Falls Municipal Airport
    Airport{IataCode{"PKG"}, CountryId{"MY"}, Timezone{}}, // Pangkor Airport
    Airport{IataCode{"PKH"}, CountryId{"GR"}, Timezone{5169}}, // Porto Cheli Airport
    Airport{IataCode{"PKJ"}, CountryId{"GT"}, Timezone{1913}}, // Playa Grande Airport
    Airport{IataCode{"PKK"}, CountryId{"MM"}, Timezone{4678}}, // Pakokku Airport
    Airport{IataCode{"PKN"}, CountryId{"ID"}, Timezone{4348}}, // Iskandar Airport
    Airport{IataCode{"PKO"}, CountryId{"BJ"}, Timezone{723}}, // Parakou Airport
    Airport{IataCode{"PKP"}, CountryId{"FR"}, Timezone{6740}}, // Puka-Puka Airport
    Airport{IataCode{"PKR"}, CountryId{"NP"}, Timezone{4100}}, // Pokhara Airport
    Airport{IataCode{"PKT"}, CountryId{"AU"}, Timezone{4978}}, // Port Keats Airfield
    Airport{IataCode{"PKU"}, CountryId{"ID"}, Timezone{4032}}, // Sultan Syarif Kasim II Airport
    Airport{IataCode{"PKV"}, CountryId{"RU"}, Timezone{5620}}, // Pskov Airport
    Airport{IataCode{"PKW"}, CountryId{"BW"}, Timezone{339}}, // Selebi-Phikwe Airport
    Airport{IataCode{"PKY"}, CountryId{"ID"}, Timezone{4348}}, // Tjilik Riwut Airport
    Airport{IataCode{"PKZ"}, CountryId{"LA"}, Timezone{4633}}, // Pakse International Airport
    Airport{IataCode{"PLB"}, CountryId{"US"}, Timezone{2712}}, // Clinton County Airport
    Airport{IataCode{"PLD"}, CountryId{"CR"}, Timezone{1544}}, // Carrillo Airport
    Airport{IataCode{"PLF"}, CountryId{"TD"}, Timezone{656}}, // Pala Airport
    Airport{IataCode{"PLH"}, CountryId{"GB"}, Timezone{5517}}, // Plymouth City Airport
    Airport{IataCode{"PLJ"}, CountryId{"BZ"}, Timezone{1322}}, // Placencia Airport
    Airport{IataCode{"PLK"}, CountryId{"US"}, Timezone{1510}}, // M. Graham Clark Field, Taney County Airport
    Airport{IataCode{"PLL"}, CountryId{"BR"}, Timezone{2451}}, // Ponta Pelada Airport
    Airport{IataCode{"PLM"}, CountryId{"ID"}, Timezone{4032}}, // Sultan Mahmud Badaruddin II International Airport
    Airport{IataCode{"PLN"}, CountryId{"US"}, Timezone{1682}}, // Pellston Regional Airport
    Airport{IataCode{"PLO"}, CountryId{"AU"}, Timezone{4901}}, // Port Lincoln Airport
    Airport{IataCode{"PLQ"}, CountryId{"LT"}, Timezone{5943}}, // Palanga International Airport
    Airport{IataCode{"PLR"}, CountryId{"US"}, Timezone{1510}}, // St. Clair County Airport
    Airport{IataCode{"PLS"}, CountryId{"TC"}, Timezone{1859}}, // Providenciales International Airport
    Airport{IataCode{"PLT"}, CountryId{"CO"}, Timezone{1376}}, // Plato Airport
    Airport{IataCode{"PLU"}, CountryId{"BR"}, Timezone{3216}}, // Belo Horizonte/Pampulha – Carlos Drummond de Andrade Airport
    Airport{IataCode{"PLV"}, CountryId{"UA"}, Timezone{5461}}, // Poltava Airport
    Airport{IataCode{"PLW"}, CountryId{"ID"}, Timezone{4226}}, // Mutiara Airport
    Airport{IataCode{"PLX"}, CountryId{"KZ"}, Timezone{3644}}, // Semey Airport
    Airport{IataCode{"PLY"}, CountryId{"US"}, Timezone{2043}}, // Plymouth Municipal Airport (Indiana)
    Airport{IataCode{"PLZ"}, CountryId{"ZA"}, Timezone{369}}, // Port Elizabeth Airport
    Airport{IataCode{"PMA"}, CountryId{"TZ"}, Timezone{256}}, // Pemba Airport
    Airport{IataCode{"PMB"}, CountryId{"US"}, Timezone{1510}}, // Pembina Municipal Airport
    Airport{IataCode{"PMC"}, CountryId{"CL"}, Timezone{3177}}, // El Tepual Airport
    Airport{IataCode{"PMD"}, CountryId{"US"}, Timezone{2378}}, // LA/Palmdale Regional Airport
    Airport{IataCode{"PMF"}, CountryId{"IT"}, Timezone{5702}}, // Parma Airport
    Airport{IataCode{"PMG"}, CountryId{"BR"}, Timezone{1220}}, // Ponta Porã International Airport
    Airport{IataCode{"PMH"}, CountryId{"US"}, Timezone{2712}}, // Greater Portsmouth Regional Airport
    Airport{IataCode{"PMI"}, CountryId{"ES"}, Timezone{5549}}, // Palma de Mallorca Airport
    Airport{IataCode{"PMK"}, CountryId{"AU"}, Timezone{4920}}, // Palm Island Airport
    Airport{IataCode{"PML"}, CountryId{"US"}, Timezone{814}}, // Port Moller Airport
    Airport{IataCode{"PMO"}, CountryId{"IT"}, Timezone{5702}}, // Falcone–Borsellino Airport
    Airport{IataCode{"PMQ"}, CountryId{"AR"}, Timezone{1045}}, // Perito Moreno Airport
    Airport{IataCode{"PMR"}, CountryId{"NZ"}, Timezone{6218}}, // Palmerston North International Airport
    Airport{IataCode{"PMS"}, CountryId{"SY"}, Timezone{3867}}, // Palmyra Airport
    Airport{IataCode{"PMV"}, CountryId{"VE"}, Timezone{1463}}, // Del Caribe "Santiago Mariño" International Airport
    Airport{IataCode{"PMW"}, CountryId{"BR"}, Timezone{865}}, // Palmas Airport
    Airport{IataCode{"PMX"}, CountryId{"US"}, Timezone{2712}}, // Metropolitan Airport
    Airport{IataCode{"PMY"}, CountryId{"AR"}, Timezone{914}}, // El Tehuelche Airport
    Airport{IataCode{"PMZ"}, CountryId{"CR"}, Timezone{1544}}, // Palmar Sur Airport
    Airport{IataCode{"PNA"}, CountryId{"ES"}, Timezone{5549}}, // Pamplona Airport
    Airport{IataCode{"PNB"}, CountryId{"BR"}, Timezone{865}}, // Porto Nacional Airport
    Airport{IataCode{"PNC"}, CountryId{"US"}, Timezone{1510}}, // Ponca City Regional Airport
    Airport{IataCode{"PND"}, CountryId{"BZ"}, Timezone{1322}}, // Punta Gorda Airport
    Airport{IataCode{"PNE"}, CountryId{"US"}, Timezone{2712}}, // Northeast Philadelphia Airport
    Airport{IataCode{"PNG"}, CountryId{"BR"}, Timezone{3216}}, // Paranaguá Airport
    Airport{IataCode{"PNH"}, CountryId{"KH"}, Timezone{4332}}, // Phnom Penh International Airport
    Airport{IataCode{"PNI"}, CountryId{"FM"}, Timezone{6670}}, // Pohnpei International Airport
    Airport{IataCode{"PNK"}, CountryId{"ID"}, Timezone{4348}}, // Supadio Airport
    Airport{IataCode{"PNL"}, CountryId{"IT"}, Timezone{5702}}, // Pantelleria Airport
    Airport{IataCode{"PNM"}, CountryId{"US"}, Timezone{1510}}, // Princeton Municipal Airport
    Airport{IataCode{"PNN"}, CountryId{"US"}, Timezone{2712}}, // Princeton Municipal Airport (Maine)
    Airport{IataCode{"PNP"}, CountryId{"PG"}, Timezone{6686}}, // Girua Airport
    Airport{IataCode{"PNQ"}, CountryId{"IN"}, Timezone{4129}}, // Pune Airport
    Airport{IataCode{"PNR"}, CountryId{"CG"}, Timezone{148}}, // Pointe Noire Airport
    Airport{IataCode{"PNS"}, CountryId{"US"}, Timezone{1510}}, // Pensacola International Airport
    Airport{IataCode{"PNT"}, CountryId{"CL"}, Timezone{3032}}, // Teniente Julio Gallardo Airport
    Airport{IataCode{"PNU"}, CountryId{"US"}, Timezone{1667}}, // Panguitch Municipal Airport
    Airport{IataCode{"PNX"}, CountryId{"US"}, Timezone{1510}}, // North Texas Regional Airport
    Airport{IataCode{"PNY"}, CountryId{"IN"}, Timezone{4129}}, // Pondicherry Airport
    Airport{IataCode{"PNZ"}, CountryId{"BR"}, Timezone{1254}}, // Petrolina Airport
    Airport{IataCode{"POA"}, CountryId{"BR"}, Timezone{3216}}, // Salgado Filho International Airport
    Airport{IataCode{"POC"}, CountryId{"US"}, Timezone{2378}}, // Brackett Field
    Airport{IataCode{"POD"}, CountryId{"SN"}, Timezone{686}}, // Podor Airport
    Airport{IataCode{"POG"}, CountryId{"GA"}, Timezone{475}}, // Port-Gentil International Airport
    Airport{IataCode{"POI"}, CountryId{"BO"}, Timezone{2350}}, // Captain Nicolas Rojas Airport
    Airport{IataCode{"POJ"}, CountryId{"BR"}, Timezone{3216}}, // Patos de Minas Airport
    Airport{IataCode{"POL"}, CountryId{"MZ"}, Timezone{565}}, // Pemba Airport
    Airport{IataCode{"POM"}, CountryId{"PG"}, Timezone{6686}}, // Jacksons International Airport
    Airport{IataCode{"PON"}, CountryId{"GT"}, Timezone{1913}}, // Poptún Airport
    Airport{IataCode{"POO"}, CountryId{"BR"}, Timezone{3216}}, // Poços de Caldas Airport
    Airport{IataCode{"POP"}, CountryId{"DO"}, Timezone{3194}}, // Gregorio Luperón International Airport
    Airport{IataCode{"POR"}, CountryId{"FI"}, Timezone{5377}}, // Pori Airport
    Airport{IataCode{"POS"}, CountryId{"TT"}, Timezone{2970}}, // Piarco International Airport
    Airport{IataCode{"POT"}, CountryId{"JM"}, Timezone{2260}}, // Ken Jones Aerodrome
    Airport{IataCode{"POU"}, CountryId{"US"}, Timezone{2712}}, // Hudson Valley Regional Airport
    Airport{IataCode{"POV"}, CountryId{"US"}, Timezone{2712}}, // Portage County Regional Airport
    Airport{IataCode{"POW"}, CountryId{"SI"}, Timezone{5989}}, // Portorož Airport
    Airport{IataCode{"POX"}, CountryId{"FR"}, Timezone{5646}}, // Pontoise – Cormeilles Aerodrome
    Airport{IataCode{"POZ"}, CountryId{"PL"}, Timezone{5975}}, // Poznań-Ławica Airport
    Airport{IataCode{"PPB"}, CountryId{"BR"}, Timezone{3216}}, // Presidente Prudente Airport
    Airport{IataCode{"PPC"}, CountryId{"US"}, Timezone{814}}, // Prospect Creek Airport
    Airport{IataCode{"PPE"}, CountryId{"MX"}, Timezone{1995}}, // Puerto Peñasco International Airport
    Airport{IataCode{"PPF"}, CountryId{"US"}, Timezone{1510}}, // Tri-City Airport (Kansas)
    Airport{IataCode{"PPG"}, CountryId{"US"}, Timezone{6621}}, // Pago Pago International Airport
    Airport{IataCode{"PPH"}, CountryId{}, Timezone{1463}}, // Parai-tepuí Airport
    Airport{IataCode{"PPI"}, CountryId{"AU"}, Timezone{4901}}, // Port Pirie Airport
    Airport{IataCode{"PPK"}, CountryId{"KZ"}, Timezone{3644}}, // Petropavl Airport
    Airport{IataCode{"PPL"}, CountryId{"NP"}, Timezone{4100}}, // Phaplu Airport
    Airport{IataCode{"PPM"}, CountryId{"US"}, Timezone{2712}}, // Pompano Beach Airpark
    Airport{IataCode{"PPN"}, CountryId{"CO"}, Timezone{1376}}, // Guillermo León Valencia Airport
    Airport{IataCode{"PPP"}, CountryId{"AU"}, Timezone{4920}}, // Whitsunday Coast Airport
    Airport{IataCode{"PPQ"}, CountryId{"NZ"}, Timezone{6218}}, // Kapiti Coast Airport
    Airport{IataCode{"PPR"}, CountryId{"ID"}, Timezone{4032}}, // Tuanku Tambusai Airport
    Airport{IataCode{"PPS"}, CountryId{"PH"}, Timezone{4240}}, // Puerto Princesa International Airport
    Airport{IataCode{"PPT"}, CountryId{"FR"}, Timezone{6740}}, // Faa'a International Airport
    Airport{IataCode{"PPV"}, CountryId{"US"}, Timezone{3255}}, // Port Protection Seaplane Base
    Airport{IataCode{"PPW"}, CountryId{"GB"}, Timezone{5517}}, // Papa Westray Airport
    Airport{IataCode{"PPY"}, CountryId{"BR"}, Timezone{3216}}, // Pouso Alegre Airport
    Airport{IataCode{"PPZ"}, CountryId{}, Timezone{1463}}, // Puerto Páez Airport
    Airport{IataCode{"PQC"}, CountryId{"VN"}, Timezone{4332}}, // Phu Quoc International Airport
    Airport{IataCode{"PQI"}, CountryId{"US"}, Timezone{2712}}, // Northern Maine Regional Airport at Presque Isle
    Airport{IataCode{"PQM"}, CountryId{"MX"}, Timezone{2588}}, // Palenque International Airport
    Airport{IataCode{"PQQ"}, CountryId{"AU"}, Timezone{5103}}, // Port Macquarie Airport
    Airport{IataCode{"PQS"}, CountryId{"US"}, Timezone{2745}}, // Pilot Station Airport
    Airport{IataCode{"PRA"}, CountryId{"AR"}, Timezone{942}}, // General Justo José de Urquiza Airport
    Airport{IataCode{"PRB"}, CountryId{"US"}, Timezone{2378}}, // Paso Robles Municipal Airport
    Airport{IataCode{"PRC"}, CountryId{"US"}, Timezone{2931}}, // Ernest A. Love Field
    Airport{IataCode{"PRG"}, CountryId{"CZ"}, Timezone{5676}}, // Prague Václav Havel Airport
    Airport{IataCode{"PRH"}, CountryId{"TH"}, Timezone{3777}}, // Phrae Airport
    Airport{IataCode{"PRI"}, CountryId{"SC"}, Timezone{6130}}, // Praslin Island Airport
    Airport{IataCode{"PRM"}, CountryId{"PT"}, Timezone{5486}}, // Portimão Airport
    Airport{IataCode{"PRN"}, CountryId{"XK"}, Timezone{5183}}, // Pristina International Airport Adem Jashari
    Airport{IataCode{"PRO"}, CountryId{"US"}, Timezone{1510}}, // Perry Municipal Airport
    Airport{IataCode{"PRP"}, CountryId{"FR"}, Timezone{5646}}, // Propriano Airport
    Airport{IataCode{"PRQ"}, CountryId{"AR"}, Timezone{942}}, // Presidencia Roque Sáenz Peña Airport
    Airport{IataCode{"PRR"}, CountryId{"GY"}, Timezone{1949}}, // Paruima Airport
    Airport{IataCode{"PRV"}, CountryId{"CZ"}, Timezone{5676}}, // Přerov Airport
    Airport{IataCode{"PRW"}, CountryId{"US"}, Timezone{1510}}, // Prentice Airport
    Airport{IataCode{"PRX"}, CountryId{"US"}, Timezone{1510}}, // Cox Field
    Airport{IataCode{"PRY"}, CountryId{"ZA"}, Timezone{369}}, // Wonderboom Airport
    Airport{IataCode{"PRZ"}, CountryId{"US"}, Timezone{2378}}, // Prineville Airport
    Airport{IataCode{"PSA"}, CountryId{"IT"}, Timezone{5702}}, // Pisa International Airport
    Airport{IataCode{"PSB"}, CountryId{"US"}, Timezone{2712}}, // Mid-State Regional Airport
    Airport{IataCode{"PSC"}, CountryId{"US"}, Timezone{2378}}, // Tri-Cities Airport
    Airport{IataCode{"PSD"}, CountryId{"EG"}, Timezone{184}}, // Port Said Airport
    Airport{IataCode{"PSE"}, CountryId{"US"}, Timezone{3012}}, // Mercedita Airport
    Airport{IataCode{"PSF"}, CountryId{"US"}, Timezone{2712}}, // Pittsfield Municipal Airport
    Airport{IataCode{"PSG"}, CountryId{"US"}, Timezone{3255}}, // Petersburg James A. Johnson Airport
    Airport{IataCode{"PSI"}, CountryId{"PK"}, Timezone{4087}}, // Pasni Airport
    Airport{IataCode{"PSJ"}, CountryId{"ID"}, Timezone{4226}}, // Kasiguncu Airport
    Airport{IataCode{"PSK"}, CountryId{"US"}, Timezone{2712}}, // New River Valley Airport
    Airport{IataCode{"PSL"}, CountryId{"GB"}, Timezone{5517}}, // Perth Airport
    Airport{IataCode{"PSM"}, CountryId{"US"}, Timezone{2712}}, // Portsmouth International Airport at Pease
    Airport{IataCode{"PSO"}, CountryId{"CO"}, Timezone{1376}}, // Antonio Nariño Airport
    Airport{IataCode{"PSP"}, CountryId{"US"}, Timezone{2378}}, // Palm Springs International Airport
    Airport{IataCode{"PSQ"}, CountryId{"US"}, Timezone{2712}}, // Philadelphia Seaplane Base
    Airport{IataCode{"PSR"}, CountryId{"IT"}, Timezone{5702}}, // Abruzzo Airport
    Airport{IataCode{"PSS"}, CountryId{"AR"}, Timezone{1220}}, // Libertador General José de San Martín Airport
    Airport{IataCode{"PST"}, CountryId{}, Timezone{1980}}, // Preston Airport
    Airport{IataCode{"PSU"}, CountryId{"ID"}, Timezone{4348}}, // Pangsuma Airport
    Airport{IataCode{"PSV"}, CountryId{"GB"}, Timezone{}}, // Papa Stour Airport
    Airport{IataCode{"PSX"}, CountryId{"US"}, Timezone{1510}}, // Palacios Municipal Airport
    Airport{IataCode{"PSY"}, CountryId{"GB"}, Timezone{4884}}, // Port Stanley Airport
    Airport{IataCode{"PSZ"}, CountryId{"BO"}, Timezone{2350}}, // Puerto Suárez International Airport
    Airport{IataCode{"PTA"}, CountryId{"US"}, Timezone{814}}, // Port Alsworth Airport
    Airport{IataCode{"PTD"}, CountryId{"US"}, Timezone{3255}}, // Port Alexander Seaplane Base
    Airport{IataCode{"PTF"}, CountryId{"FJ"}, Timezone{6349}}, // Malolo Lailai Airport
    Airport{IataCode{"PTG"}, CountryId{"ZA"}, Timezone{369}}, // Polokwane International Airport
    Airport{IataCode{"PTH"}, CountryId{"US"}, Timezone{814}}, // Port Heiden Airport
    Airport{IataCode{"PTJ"}, CountryId{"AU"}, Timezone{5067}}, // Portland Airport
    Airport{IataCode{"PTK"}, CountryId{"US"}, Timezone{1682}}, // Oakland County International Airport
    Airport{IataCode{"PTM"}, CountryId{"VE"}, Timezone{1463}}, // Palmarito Airport
    Airport{IataCode{"PTN"}, CountryId{"US"}, Timezone{1510}}, // Harry P. Williams Memorial Airport
    Airport{IataCode{"PTO"}, CountryId{"BR"}, Timezone{3216}}, // Pato Branco Airport
    Airport{IataCode{"PTP"}, CountryId{"FR"}, Timezone{1894}}, // Pointe-à-Pitre International Airport
    Airport{IataCode{"PTS"}, CountryId{"US"}, Timezone{1510}}, // Atkinson Municipal Airport
    Airport{IataCode{"PTT"}, CountryId{"US"}, Timezone{1510}}, // Pratt Regional Airport
    Airport{IataCode{"PTU"}, CountryId{"US"}, Timezone{814}}, // Platinum Airport
    Airport{IataCode{"PTV"}, CountryId{"US"}, Timezone{2378}}, // Porterville Municipal Airport
    Airport{IataCode{"PTW"}, CountryId{"US"}, Timezone{2712}}, // Heritage Field Airport
    Airport{IataCode{"PTX"}, CountryId{"CO"}, Timezone{1376}}, // Contador Airport
    Airport{IataCode{"PTY"}, CountryId{"PA"}, Timezone{2877}}, // Tocumen International Airport
    Airport{IataCode{"PTZ"}, CountryId{"EC"}, Timezone{1949}}, // Rio Amazonas Airport
    Airport{IataCode{"PUB"}, CountryId{"US"}, Timezone{1667}}, // Pueblo Memorial Airport
    Airport{IataCode{"PUD"}, CountryId{"AR"}, Timezone{1045}}, // Puerto Deseado Airport
    Airport{IataCode{"PUE"}, CountryId{"PA"}, Timezone{2877}}, // Puerto Obaldia Airport
    Airport{IataCode{"PUF"}, CountryId{"FR"}, Timezone{5646}}, // Pau Pyrénées Airport
    Airport{IataCode{"PUG"}, CountryId{"AU"}, Timezone{4901}}, // Port Augusta Airport
    Airport{IataCode{"PUJ"}, CountryId{"DO"}, Timezone{3194}}, // Punta Cana International Airport
    Airport{IataCode{"PUK"}, CountryId{"FR"}, Timezone{6740}}, // Pukarua Airport
    Airport{IataCode{"PUM"}, CountryId{"ID"}, Timezone{4226}}, // Sangia Nibandera Airport
    Airport{IataCode{"PUN"}, CountryId{"CD"}, Timezone{519}}, // Punia Airport
    Airport{IataCode{"PUP"}, CountryId{"BF"}, Timezone{704}}, // Pô Airport
    Airport{IataCode{"PUQ"}, CountryId{"CL"}, Timezone{3032}}, // Presidente Carlos Ibáñez del Campo International Airport
    Airport{IataCode{"PUR"}, CountryId{"BO"}, Timezone{2350}}, // Puerto Rico Airport
    Airport{IataCode{"PUS"}, CountryId{"KR"}, Timezone{4445}}, // Gimhae International Airport
    Airport{IataCode{"PUT"}, CountryId{"IN"}, Timezone{4129}}, // Sri Sathya Sai Airport
    Airport{IataCode{"PUU"}, CountryId{"CO"}, Timezone{1376}}, // Tres de Mayo Airport
    Airport{IataCode{"PUW"}, CountryId{"US"}, Timezone{2378}}, // Pullman-Moscow Regional Airport
    Airport{IataCode{"PUX"}, CountryId{"CL"}, Timezone{3177}}, // El Mirador Airport
    Airport{IataCode{"PUY"}, CountryId{"HR"}, Timezone{5989}}, // Pula Airport
    Airport{IataCode{"PUZ"}, CountryId{"NI"}, Timezone{2435}}, // Puerto Cabezas Airport
    Airport{IataCode{"PVA"}, CountryId{"CO"}, Timezone{1376}}, // El Embrujo Airport
    Airport{IataCode{"PVB"}, CountryId{"US"}, Timezone{1510}}, // Platteville Municipal Airport
    Airport{IataCode{"PVC"}, CountryId{"US"}, Timezone{2712}}, // Provincetown Municipal Airport
    Airport{IataCode{"PVD"}, CountryId{"US"}, Timezone{2712}}, // T. F. Green Airport
    Airport{IataCode{"PVE"}, CountryId{"PA"}, Timezone{2877}}, // El Porvenir Airport
    Airport{IataCode{"PVF"}, CountryId{"US"}, Timezone{2378}}, // Placerville Airport
    Airport{IataCode{"PVG"}, CountryId{"CN"}, Timezone{4456}}, // Shanghai Pudong International Airport
    Airport{IataCode{"PVH"}, CountryId{"BR"}, Timezone{2451}}, // Governador Jorge Teixeira de Oliveira International Airport
    Airport{IataCode{"PVI"}, CountryId{"BR"}, Timezone{3216}}, // Paranavaí Airport
    Airport{IataCode{"PVK"}, CountryId{"GR"}, Timezone{5169}}, // Aktion National Airport
    Airport{IataCode{"PVL"}, CountryId{"US"}, Timezone{2712}}, // Pike County Airport
    Airport{IataCode{"PVO"}, CountryId{"EC"}, Timezone{1949}}, // Reales Tamarindos Airport
    Airport{IataCode{"PVP"}, CountryId{"MX"}, Timezone{2519}}, // Palo Verde Airport
    Airport{IataCode{"PVR"}, CountryId{"MX"}, Timezone{1268}}, // Licenciado Gustavo Díaz Ordaz International Airport
    Airport{IataCode{"PVS"}, CountryId{"RU"}, Timezone{3667}}, // Provideniya Bay Airport
    Airport{IataCode{"PVU"}, CountryId{"US"}, Timezone{1667}}, // Provo Municipal Airport
    Airport{IataCode{"PVW"}, CountryId{"US"}, Timezone{1510}}, // Hale County Airport
    Airport{IataCode{"PWA"}, CountryId{"US"}, Timezone{1510}}, // Wiley Post Airport
    Airport{IataCode{"PWD"}, CountryId{"US"}, Timezone{1667}}, // Sher-Wood Airport
    Airport{IataCode{"PWE"}, CountryId{"RU"}, Timezone{3667}}, // Pevek Airport
    Airport{IataCode{"PWK"}, CountryId{"US"}, Timezone{1510}}, // Chicago Executive Airport
    Airport{IataCode{"PWL"}, CountryId{"ID"}, Timezone{4032}}, // Purwokerto Airport
    Airport{IataCode{"PWM"}, CountryId{"US"}, Timezone{2712}}, // Portland International Jetport
    Airport{IataCode{"PWN"}, CountryId{"BS"}, Timezone{2697}}, // Pitts Town Airport
    Airport{IataCode{"PWO"}, CountryId{"CD"}, Timezone{519}}, // Pweto Airport
    Airport{IataCode{"PWQ"}, CountryId{"KZ"}, Timezone{3644}}, // Pavlodar Airport
    Airport{IataCode{"PWT"}, CountryId{"US"}, Timezone{2378}}, // Bremerton National Airport
    Airport{IataCode{"PWY"}, CountryId{"US"}, Timezone{1667}}, // Ralph Wenz Field
    Airport{IataCode{"PXA"}, CountryId{"ID"}, Timezone{4032}}, // Q17998449
    Airport{IataCode{"PXE"}, CountryId{"US"}, Timezone{2712}}, // Perry-Houston County Airport
    Airport{IataCode{"PXH"}, CountryId{"AU"}, Timezone{4901}}, // Prominent Hill Airport
    Airport{IataCode{"PXL"}, CountryId{"US"}, Timezone{2931}}, // Polacca Airport
    Airport{IataCode{"PXM"}, CountryId{"MX"}, Timezone{2588}}, // Puerto Escondido International Airport
    Airport{IataCode{"PXO"}, CountryId{"PT"}, Timezone{4806}}, // Porto Santo Airport
    Airport{IataCode{"PXR"}, CountryId{"TH"}, Timezone{3777}}, // Surin Pakdi Airport
    Airport{IataCode{"PXU"}, CountryId{"VN"}, Timezone{3964}}, // Pleiku Airport
    Airport{IataCode{"PYA"}, CountryId{"CO"}, Timezone{1376}}, // Velasquez Airport
    Airport{IataCode{"PYB"}, CountryId{"IN"}, Timezone{4129}}, // Jeypore Airport
    Airport{IataCode{"PYC"}, CountryId{}, Timezone{2877}}, // Playón Chico Airport
    Airport{IataCode{"PYE"}, CountryId{"NZ"}, Timezone{6707}}, // Tongareva Airport
    Airport{IataCode{"PYH"}, CountryId{"VE"}, Timezone{1376}}, // Cacique Aramare Airport
    Airport{IataCode{"PYJ"}, CountryId{"RU"}, Timezone{4665}}, // Polyarny Airport
    Airport{IataCode{"PYK"}, CountryId{"IR"}, Timezone{4543}}, // Payam International Airport
    Airport{IataCode{"PYM"}, CountryId{"US"}, Timezone{2712}}, // Plymouth Municipal Airport
    Airport{IataCode{"PYO"}, CountryId{"EC"}, Timezone{1949}}, // Putumayo Airport
    Airport{IataCode{"PYP"}, CountryId{"US"}, Timezone{1510}}, // Centre–Piedmont–Cherokee County Regional Airport
    Airport{IataCode{"PYS"}, CountryId{"US"}, Timezone{2378}}, // Paradise Skypark
    Airport{IataCode{"PYY"}, CountryId{"TH"}, Timezone{3777}}, // Pai Airport
    Airport{IataCode{"PZA"}, CountryId{"CO"}, Timezone{1376}}, // Paz De Ariporo Airport
    Airport{IataCode{"PZB"}, CountryId{"ZA"}, Timezone{369}}, // Pietermaritzburg Airport
    Airport{IataCode{"PZH"}, CountryId{"PK"}, Timezone{4087}}, // Zhob Airport
    Airport{IataCode{"PZI"}, CountryId{"CN"}, Timezone{4456}}, // Panzhihua Bao'anying Airport
    Airport{IataCode{"PZO"}, CountryId{"VE"}, Timezone{1463}}, // Manuel Carlos Piar Guayana Airport
    Airport{IataCode{"PZS"}, CountryId{"CL"}, Timezone{3177}}, // Maquehue Airport
    Airport{IataCode{"PZU"}, CountryId{"SD"}, Timezone{432}}, // Port Sudan New International Airport
    Airport{IataCode{"PZY"}, CountryId{"SK"}, Timezone{5213}}, // Piešťany Airport
    Airport{IataCode{"QAJ"}, CountryId{"AE"}, Timezone{3902}}, // Ajman International Airport
    Airport{IataCode{"QAK"}, CountryId{"BR"}, Timezone{3216}}, // Maj Brig Doorgal Borges Airport
    Airport{IataCode{"QAM"}, CountryId{"FR"}, Timezone{5646}}, // Amiens – Glisy Aerodrome
    Airport{IataCode{"QAQ"}, CountryId{"IT"}, Timezone{5702}}, // L'Aquila Preturo Airport
    Airport{IataCode{"QAS"}, CountryId{"DZ"}, Timezone{47}}, // Chlef International Airport
    Airport{IataCode{"QBC"}, CountryId{"CA"}, Timezone{3503}}, // Bella Coola Airport
    Airport{IataCode{"QBG"}, CountryId{"RS"}, Timezone{5183}}, // Pančevo Airport
    Airport{IataCode{"QBQ"}, CountryId{"FR"}, Timezone{5646}}, // Besançon – La Vèze Aerodrome
    Airport{IataCode{"QBS"}, CountryId{"IT"}, Timezone{5702}}, // Verona Boscomantico
    Airport{IataCode{"QCN"}, CountryId{"BR"}, Timezone{3216}}, // Canela Airport
    Airport{IataCode{"QCP"}, CountryId{"BR"}, Timezone{3216}}, // Botucatu Airport
    Airport{IataCode{"QDC"}, CountryId{"BR"}, Timezone{3216}}, // Dracena Airport
    Airport{IataCode{"QDF"}, CountryId{"BR"}, Timezone{3216}}, // Bandeirinhas/Conselheiro Lafaiete Airport
    Airport{IataCode{"QDJ"}, CountryId{"DZ"}, Timezone{47}}, // Tsletsi Airport
    Airport{IataCode{"QDV"}, CountryId{"BR"}, Timezone{3216}}, // Jundiaí Airport
    Airport{IataCode{"QFD"}, CountryId{"DZ"}, Timezone{47}}, // Boufarik Airport
    Airport{IataCode{"QFG"}, CountryId{"GL"}, Timezone{1825}}, // Eqalugaarsuit Heliport
    Airport{IataCode{"QFN"}, CountryId{"GL"}, Timezone{1825}}, // Narsaq Kujalleq Heliport
    Airport{IataCode{"QFO"}, CountryId{"GB"}, Timezone{5517}}, // Duxford Aerodrome
    Airport{IataCode{"QFR"}, CountryId{"IT"}, Timezone{5702}}, // Frosinone Airport
    Airport{IataCode{"QGF"}, CountryId{"BR"}, Timezone{3216}}, // Montenegro Airport
    Airport{IataCode{"QGP"}, CountryId{"BR"}, Timezone{3094}}, // Garanhuns Airport
    Airport{IataCode{"QGU"}, CountryId{"JP"}, Timezone{4568}}, // Gifu Air Field
    Airport{IataCode{"QGY"}, CountryId{"HU"}, Timezone{5264}}, // Győr-Pér International Airport
    Airport{IataCode{"QHB"}, CountryId{"BR"}, Timezone{3216}}, // Pedro Morganti Airport
    Airport{IataCode{"QHP"}, CountryId{"BR"}, Timezone{3216}}, // Base De Aviacao De Taubate Airport
    Airport{IataCode{"QHR"}, CountryId{"ET"}, Timezone{28}}, // Harar Meda Airport
    Airport{IataCode{"QJB"}, CountryId{"SA"}, Timezone{4404}}, // Jubail Airport
    Airport{IataCode{"QJH"}, CountryId{"GL"}, Timezone{1825}}, // Qassimiut Heliport
    Airport{IataCode{"QJL"}, CountryId{"NO"}, Timezone{5634}}, // Kjøllefjord Airport
    Airport{IataCode{"QKE"}, CountryId{"ZM"}, Timezone{537}}, // Milliken Airport
    Airport{IataCode{"QKX"}, CountryId{"NO"}, Timezone{5634}}, // Kautokeino Airport
    Airport{IataCode{"QKZ"}, CountryId{"DE"}, Timezone{5199}}, // Konstanz Airport
    Airport{IataCode{"QLA"}, CountryId{"GB"}, Timezone{5517}}, // Lasham Airfield
    Airport{IataCode{"QLD"}, CountryId{"DZ"}, Timezone{47}}, // Blida Airport
    Airport{IataCode{"QMF"}, CountryId{"BR"}, Timezone{3216}}, // Mafra Airport
    Airport{IataCode{"QMH"}, CountryId{"DZ"}, Timezone{47}}, // Oum el Bouaghi Airport
    Airport{IataCode{"QMJ"}, CountryId{"IR"}, Timezone{4543}}, // Shahid Asyaee Airport
    Airport{IataCode{"QMM"}, CountryId{"IT"}, Timezone{5702}}, // Massa-Cinquale Airport
    Airport{IataCode{"QMZ"}, CountryId{"DE"}, Timezone{5199}}, // Mainz Finthen Airport
    Airport{IataCode{"QNC"}, CountryId{"CH"}, Timezone{6021}}, // Neuchâtel Airport
    Airport{IataCode{"QND"}, CountryId{"RS"}, Timezone{5183}}, // Novi Sad Airport
    Airport{IataCode{"QNJ"}, CountryId{"FR"}, Timezone{6021}}, // Annemasse Aerodrome
    Airport{IataCode{"QNM"}, CountryId{"BE"}, Timezone{5231}}, // Namur-Suarlee Airport
    Airport{IataCode{"QNV"}, CountryId{"BR"}, Timezone{3216}}, // Aeroclub, Nova Iguacu Airport
    Airport{IataCode{"QNX"}, CountryId{"FR"}, Timezone{5646}}, // Mâcon - Charnay Airport
    Airport{IataCode{"QNY"}, CountryId{"US"}, Timezone{2712}}, // New York Skyports Inc. Seaplane Base
    Airport{IataCode{"QOJ"}, CountryId{"BR"}, Timezone{942}}, // São Borja Airport
    Airport{IataCode{"QOW"}, CountryId{"NG"}, Timezone{462}}, // Sam Mbakwe Airport
    Airport{IataCode{"QPA"}, CountryId{"IT"}, Timezone{5702}}, // Padua Airport
    Airport{IataCode{"QPD"}, CountryId{"CU"}, Timezone{1980}}, // Pinar del Río Airport
    Airport{IataCode{"QPH"}, CountryId{"BW"}, Timezone{339}}, // Palapye Airport
    Airport{IataCode{"QPJ"}, CountryId{"HU"}, Timezone{5264}}, // Pécs-Pogány International Airport
    Airport{IataCode{"QPS"}, CountryId{"BR"}, Timezone{3216}}, // Campo Fontenelle Airport
    Airport{IataCode{"QRA"}, CountryId{"ZA"}, Timezone{369}}, // Rand Airport
    Airport{IataCode{"QRC"}, CountryId{"CL"}, Timezone{3177}}, // Independencia Airport
    Airport{IataCode{"QRE"}, CountryId{"BR"}, Timezone{3216}}, // Carazinho Airport
    Airport{IataCode{"QRM"}, CountryId{"AU"}, Timezone{5103}}, // Narromine Airport
    Airport{IataCode{"QRO"}, CountryId{"MX"}, Timezone{2588}}, // Querétaro International Airport
    Airport{IataCode{"QRR"}, CountryId{"AU"}, Timezone{5103}}, // Warren Airport
    Airport{IataCode{"QRT"}, CountryId{"IT"}, Timezone{5702}}, // Rieti Airport
    Airport{IataCode{"QRV"}, CountryId{"FR"}, Timezone{5646}}, // Arras – Roclincourt Airport
    Airport{IataCode{"QRW"}, CountryId{"NG"}, Timezone{462}}, // Warri Airport
    Airport{IataCode{"QSA"}, CountryId{"ES"}, Timezone{5549}}, // Sabadell Airport
    Airport{IataCode{"QSC"}, CountryId{"BR"}, Timezone{3216}}, // São Carlos Airport
    Airport{IataCode{"QSF"}, CountryId{"DZ"}, Timezone{47}}, // Ain Arnat Airport
    Airport{IataCode{"QSI"}, CountryId{"TZ"}, Timezone{256}}, // Moshi Airport
    Airport{IataCode{"QSN"}, CountryId{"CU"}, Timezone{1980}}, // San Nicolás de Bari Airport
    Airport{IataCode{"QSR"}, CountryId{"IT"}, Timezone{5702}}, // Salerno Costa d'Amalfi Airport
    Airport{IataCode{"QSX"}, CountryId{"GY"}, Timezone{1949}}, // New Amsterdam Airport
    Airport{IataCode{"QTK"}, CountryId{"DE"}, Timezone{5199}}, // Rothenburg/Görlitz Airport
    Airport{IataCode{"QUB"}, CountryId{"LY"}, Timezone{757}}, // Ubari Airport
    Airport{IataCode{"QUG"}, CountryId{"GB"}, Timezone{5517}}, // Chichester/Goodwood Airport
    Airport{IataCode{"QUO"}, CountryId{"NG"}, Timezone{462}}, // Akwa Ibom Airport
    Airport{IataCode{"QUS"}, CountryId{"NG"}, Timezone{462}}, // Gusau Airstrip
    Airport{IataCode{"QUT"}, CountryId{"JP"}, Timezone{4568}}, // Utsunomiya Air Field
    Airport{IataCode{"QVA"}, CountryId{"IT"}, Timezone{5702}}, // Varese-Venegono Airport
    Airport{IataCode{"QVP"}, CountryId{"BR"}, Timezone{3216}}, // Avaré-Arandu Airport
    Airport{IataCode{"QWG"}, CountryId{"US"}, Timezone{2712}}, // Wilgrove Air Park
    Airport{IataCode{"QWV"}, CountryId{"RS"}, Timezone{5183}}, // Valjevo Airport
    Airport{IataCode{"QXB"}, CountryId{"FR"}, Timezone{5646}}, // Aix-en-Provence Aerodrome
    Airport{IataCode{"QYO"}, CountryId{"PL"}, Timezone{5975}}, // Dajtki Airport
    Airport{IataCode{"QYR"}, CountryId{"FR"}, Timezone{5646}}, // Troyes – Barberey Airport
    Airport{IataCode{"QYY"}, CountryId{"PL"}, Timezone{5975}}, // Białystok-Krywlany Airport
    Airport{IataCode{"QZN"}, CountryId{"DZ"}, Timezone{47}}, // Relizane Airport
    Airport{IataCode{"RAB"}, CountryId{"PG"}, Timezone{6686}}, // Rabaul Airport
    Airport{IataCode{"RAC"}, CountryId{"US"}, Timezone{1510}}, // John H. Batten Airport
    Airport{IataCode{"RAE"}, CountryId{"SA"}, Timezone{4404}}, // Arar Domestic Airport
    Airport{IataCode{"RAF"}, CountryId{"AR"}, Timezone{942}}, // Rafaela Aerodrome
    Airport{IataCode{"RAH"}, CountryId{"SA"}, Timezone{4404}}, // Rafha Domestic Airport
    Airport{IataCode{"RAI"}, CountryId{"CV"}, Timezone{4771}}, // Praia International Airport
    Airport{IataCode{"RAJ"}, CountryId{"IN"}, Timezone{4129}}, // Rajkot Airport
    Airport{IataCode{"RAK"}, CountryId{"MA"}, Timezone{215}}, // Marrakesh Menara Airport
    Airport{IataCode{"RAL"}, CountryId{"US"}, Timezone{2378}}, // Riverside Municipal Airport
    Airport{IataCode{"RAM"}, CountryId{"AU"}, Timezone{4978}}, // Ramingining Airport
    Airport{IataCode{"RAN"}, CountryId{"IT"}, Timezone{5702}}, // Ravenna Airport
    Airport{IataCode{"RAO"}, CountryId{"BR"}, Timezone{3216}}, // Leite Lopes Airport
    Airport{IataCode{"RAP"}, CountryId{"US"}, Timezone{1667}}, // Rapid City Regional Airport
    Airport{IataCode{"RAQ"}, CountryId{"ID"}, Timezone{4226}}, // Sugimanuru Airport
    Airport{IataCode{"RAR"}, CountryId{"NZ"}, Timezone{6707}}, // Rarotonga International Airport
    Airport{IataCode{"RAS"}, CountryId{"IR"}, Timezone{4543}}, // Rasht Airport
    Airport{IataCode{"RAT"}, CountryId{"RU"}, Timezone{4690}}, // Raduzhny Airport
    Airport{IataCode{"RAV"}, CountryId{"CO"}, Timezone{1376}}, // Cravo Norte Airport
    Airport{IataCode{"RAW"}, CountryId{"US"}, Timezone{1510}}, // Warsaw Municipal Airport (Missouri)
    Airport{IataCode{"RAZ"}, CountryId{"PK"}, Timezone{4087}}, // Rawalakot Airport
    Airport{IataCode{"RBA"}, CountryId{"MA"}, Timezone{215}}, // Rabat-Salé Airport
    Airport{IataCode{"RBB"}, CountryId{"BR"}, Timezone{2451}}, // Borba Airport
    Airport{IataCode{"RBC"}, CountryId{"AU"}, Timezone{5067}}, // Robinvale Airport
    Airport{IataCode{"RBD"}, CountryId{"US"}, Timezone{1510}}, // Dallas Executive Airport
    Airport{IataCode{"RBE"}, CountryId{"KH"}, Timezone{4332}}, // Ratanakiri Airport
    Airport{IataCode{"RBF"}, CountryId{"US"}, Timezone{2378}}, // Big Bear City Airport
    Airport{IataCode{"RBG"}, CountryId{"US"}, Timezone{2378}}, // Roseburg Regional Airport
    Airport{IataCode{"RBJ"}, CountryId{"JP"}, Timezone{4568}}, // Rebun Airport
    Airport{IataCode{"RBK"}, CountryId{"US"}, Timezone{2378}}, // French Valley Airport
    Airport{IataCode{"RBL"}, CountryId{"US"}, Timezone{2378}}, // Red Bluff Municipal Airport
    Airport{IataCode{"RBM"}, CountryId{"DE"}, Timezone{5199}}, // Straubing Wallmühle Airport
    Airport{IataCode{"RBN"}, CountryId{"US"}, Timezone{2712}}, // Fort Jefferson
    Airport{IataCode{"RBO"}, CountryId{"BO"}, Timezone{2350}}, // Robore Airport
    Airport{IataCode{"RBQ"}, CountryId{"BO"}, Timezone{2350}}, // Rurrenabaque Airport
    Airport{IataCode{"RBR"}, CountryId{"BR"}, Timezone{3141}}, // Rio Branco International Airport
    Airport{IataCode{"RBS"}, CountryId{"AU"}, Timezone{5067}}, // Orbost Airport
    Airport{IataCode{"RBT"}, CountryId{"KE"}, Timezone{641}}, // Marsabit Airport
    Airport{IataCode{"RBV"}, CountryId{"SB"}, Timezone{6413}}, // Ramata Airport
    Airport{IataCode{"RBW"}, CountryId{"US"}, Timezone{2712}}, // Lowcountry Regional Airport
    Airport{IataCode{"RBX"}, CountryId{"SS"}, Timezone{389}}, // Rumbek Airport
    Airport{IataCode{"RBY"}, CountryId{"US"}, Timezone{814}}, // Ruby Airport
    Airport{IataCode{"RCB"}, CountryId{"ZA"}, Timezone{369}}, // Richards Bay Airport
    Airport{IataCode{"RCE"}, CountryId{"US"}, Timezone{2378}}, // Roche Harbor Seaplane Base
    Airport{IataCode{"RCH"}, CountryId{"CO"}, Timezone{1376}}, // Almirante Padilla Airport
    Airport{IataCode{"RCL"}, CountryId{"VU"}, Timezone{6301}}, // Redcliffe Airport
    Airport{IataCode{"RCM"}, CountryId{"AU"}, Timezone{4920}}, // Richmond Airport
    Airport{IataCode{"RCP"}, CountryId{"US"}, Timezone{1510}}, // Rooks County Regional Airport
    Airport{IataCode{"RCQ"}, CountryId{"AR"}, Timezone{942}}, // Reconquista Airport
    Airport{IataCode{"RCR"}, CountryId{"US"}, Timezone{2043}}, // Fulton County Airport
    Airport{IataCode{"RCS"}, CountryId{"GB"}, Timezone{5517}}, // Rochester Airport
    Airport{IataCode{"RCT"}, CountryId{"US"}, Timezone{1682}}, // Nartron Field
    Airport{IataCode{"RCU"}, CountryId{"AR"}, Timezone{942}}, // Las Higueras Airport
    Airport{IataCode{"RCX"}, CountryId{"US"}, Timezone{1510}}, // Rusk County Airport
    Airport{IataCode{"RCY"}, CountryId{"BS"}, Timezone{2697}}, // Port Nelson Airport
    Airport{IataCode{"RCZ"}, CountryId{"US"}, Timezone{2712}}, // Richmond County Airport
    Airport{IataCode{"RDB"}, CountryId{"US"}, Timezone{2745}}, // Red Dog Airport
    Airport{IataCode{"RDC"}, CountryId{"BR"}, Timezone{1308}}, // Redenção Airport
    Airport{IataCode{"RDD"}, CountryId{"US"}, Timezone{2378}}, // Redding Municipal Airport
    Airport{IataCode{"RDG"}, CountryId{"US"}, Timezone{2712}}, // Reading Regional Airport
    Airport{IataCode{"RDK"}, CountryId{"US"}, Timezone{1510}}, // Red Oak Municipal Airport
    Airport{IataCode{"RDM"}, CountryId{"US"}, Timezone{2378}}, // Roberts Field
    Airport{IataCode{"RDN"}, CountryId{"MY"}, Timezone{4159}}, // Redang Airport
    Airport{IataCode{"RDO"}, CountryId{"PL"}, Timezone{5975}}, // Radom-Sadków Airport
    Airport{IataCode{"RDP"}, CountryId{"IN"}, Timezone{4129}}, // Kazi Nazrul Islam Airport
    Airport{IataCode{"RDS"}, CountryId{"AR"}, Timezone{1019}}, // Rincón de los Sauces Airport
    Airport{IataCode{"RDT"}, CountryId{"SN"}, Timezone{686}}, // Richard Toll Airport
    Airport{IataCode{"RDU"}, CountryId{"US"}, Timezone{2712}}, // Raleigh–Durham International Airport
    Airport{IataCode{"RDV"}, CountryId{"US"}, Timezone{814}}, // Red Devil Airport
    Airport{IataCode{"RDZ"}, CountryId{"FR"}, Timezone{5646}}, // Rodez-Aveyron Airport
    Airport{IataCode{"REA"}, CountryId{"FR"}, Timezone{6740}}, // Reao Airport
    Airport{IataCode{"REB"}, CountryId{"DE"}, Timezone{5199}}, // Müritz Airpark
    Airport{IataCode{"REC"}, CountryId{"BR"}, Timezone{3094}}, // Recife/Guararapes–Gilberto Freyre International Airport
    Airport{IataCode{"RED"}, CountryId{"US"}, Timezone{2712}}, // Mifflin County Airport
    Airport{IataCode{"REG"}, CountryId{"IT"}, Timezone{5702}}, // Reggio Calabria Airport
    Airport{IataCode{"REI"}, CountryId{"FR"}, Timezone{1479}}, // Régina Airport
    Airport{IataCode{"REL"}, CountryId{"AR"}, Timezone{914}}, // Almirante Marcos A. Zar Airport
    Airport{IataCode{"REN"}, CountryId{"RU"}, Timezone{4690}}, // Orenburg Tsentralny Airport
    Airport{IataCode{"REO"}, CountryId{"US"}, Timezone{1391}}, // Rome State Airport
    Airport{IataCode{"REP"}, CountryId{"KH"}, Timezone{4332}}, // Siem Reap International Airport
    Airport{IataCode{"RER"}, CountryId{"GT"}, Timezone{1913}}, // Retalhuleu Airport
    Airport{IataCode{"RES"}, CountryId{"AR"}, Timezone{942}}, // Resistencia International Airport
    Airport{IataCode{"RET"}, CountryId{"NO"}, Timezone{5634}}, // Røst Airport
    Airport{IataCode{"REU"}, CountryId{"ES"}, Timezone{5549}}, // Reus Airport
    Airport{IataCode{"REX"}, CountryId{"MX"}, Timezone{2501}}, // General Lucio Blanco International Airport
    Airport{IataCode{"REY"}, CountryId{"BO"}, Timezone{2350}}, // Reyes Airport
    Airport{IataCode{"REZ"}, CountryId{"BR"}, Timezone{3216}}, // Resende Airport
    Airport{IataCode{"RFA"}, CountryId{"CF"}, Timezone{104}}, // Rafaï Airport
    Airport{IataCode{"RFD"}, CountryId{"US"}, Timezone{1510}}, // Chicago Rockford International Airport
    Airport{IataCode{"RFI"}, CountryId{"US"}, Timezone{1510}}, // Rusk County Airport
    Airport{IataCode{"RFN"}, CountryId{"IS"}, Timezone{4823}}, // Raufarhöfn Airport
    Airport{IataCode{"RFP"}, CountryId{"FR"}, Timezone{6740}}, // Raiatea Airport
    Airport{IataCode{"RFS"}, CountryId{"NI"}, Timezone{2435}}, // Rosita Airport
    Airport{IataCode{"RGA"}, CountryId{"AR"}, Timezone{1180}}, // Rio Grande Airport
    Airport{IataCode{"RGH"}, CountryId{"IN"}, Timezone{4129}}, // Balurghat Airport
    Airport{IataCode{"RGI"}, CountryId{"FR"}, Timezone{6740}}, // Rangiroa Airport
    Airport{IataCode{"RGK"}, CountryId{"RU"}, Timezone{3777}}, // Gorno-Altaysk Airport
    Airport{IataCode{"RGL"}, CountryId{"AR"}, Timezone{1045}}, // Piloto Civil Norberto Fernández International Airport
    Airport{IataCode{"RGN"}, CountryId{"MM"}, Timezone{4678}}, // Yangon International Airport
    Airport{IataCode{"RGO"}, CountryId{"KP"}, Timezone{4363}}, // Chongjin Airport
    Airport{IataCode{"RGS"}, CountryId{"ES"}, Timezone{5549}}, // Burgos Airport
    Airport{IataCode{"RGT"}, CountryId{"ID"}, Timezone{4032}}, // Japura Airport
    Airport{IataCode{"RHD"}, CountryId{"AR"}, Timezone{1154}}, // Las Termas Airport
    Airport{IataCode{"RHG"}, CountryId{"RW"}, Timezone{519}}, // Ruhengeri Airport
    Airport{IataCode{"RHI"}, CountryId{"US"}, Timezone{1510}}, // Rhinelander–Oneida County Airport
    Airport{IataCode{"RHO"}, CountryId{"GR"}, Timezone{5169}}, // Rhodes International Airport
    Airport{IataCode{"RHP"}, CountryId{"NP"}, Timezone{4100}}, // Ramechhap Airport
    Airport{IataCode{"RHT"}, CountryId{"CN"}, Timezone{4456}}, // Alxa Right Banner Badanjilin Airport
    Airport{IataCode{"RHV"}, CountryId{"US"}, Timezone{2378}}, // Reid-Hillview Airport
    Airport{IataCode{"RIA"}, CountryId{"BR"}, Timezone{3216}}, // Santa Maria Airport
    Airport{IataCode{"RIB"}, CountryId{"BO"}, Timezone{2350}}, // Riberalta Airport
    Airport{IataCode{"RIC"}, CountryId{"US"}, Timezone{2712}}, // Richmond International Airport
    Airport{IataCode{"RID"}, CountryId{"US"}, Timezone{2043}}, // Richmond Municipal Airport
    Airport{IataCode{"RIE"}, CountryId{"US"}, Timezone{1510}}, // Rice Lake Regional Airport
    Airport{IataCode{"RIG"}, CountryId{"BR"}, Timezone{3216}}, // Rio Grande Airport
    Airport{IataCode{"RIH"}, CountryId{"PA"}, Timezone{2877}}, // Río Hato Airport
    Airport{IataCode{"RIJ"}, CountryId{"PE"}, Timezone{2365}}, // Juan Simons Vela Airport
    Airport{IataCode{"RIL"}, CountryId{"US"}, Timezone{1667}}, // Garfield County Regional Airport
    Airport{IataCode{"RIM"}, CountryId{"PE"}, Timezone{2365}}, // San Nicolas Airport
    Airport{IataCode{"RIN"}, CountryId{"SB"}, Timezone{6413}}, // Ringi Cove Airport
    Airport{IataCode{"RIR"}, CountryId{"US"}, Timezone{2378}}, // Flabob Airport
    Airport{IataCode{"RIS"}, CountryId{"JP"}, Timezone{4568}}, // Rishiri Airport
    Airport{IataCode{"RIU"}, CountryId{"US"}, Timezone{2378}}, // Rancho Murieta Airport
    Airport{IataCode{"RIW"}, CountryId{"US"}, Timezone{1667}}, // Riverton Regional Airport
    Airport{IataCode{"RIX"}, CountryId{"LV"}, Timezone{5690}}, // Riga International Airport
    Airport{IataCode{"RIY"}, CountryId{"YE"}, Timezone{3634}}, // Riyan Airport
    Airport{IataCode{"RIZ"}, CountryId{"CN"}, Timezone{4456}}, // Rizhao Shanzihe Airport
    Airport{IataCode{"RJA"}, CountryId{"IN"}, Timezone{4129}}, // Rajahmundry Airport
    Airport{IataCode{"RJH"}, CountryId{"BD"}, Timezone{3881}}, // Shah Makhdum Airport
    Airport{IataCode{"RJK"}, CountryId{"HR"}, Timezone{5989}}, // Rijeka Airport
    Airport{IataCode{"RJL"}, CountryId{"ES"}, Timezone{5549}}, // Logroño-Agoncillo Airport
    Airport{IataCode{"RJN"}, CountryId{"IR"}, Timezone{4543}}, // Rafsanjan Airport
    Airport{IataCode{"RKC"}, CountryId{"US"}, Timezone{2378}}, // Montague Airport
    Airport{IataCode{"RKD"}, CountryId{"US"}, Timezone{2712}}, // Knox County Regional Airport
    Airport{IataCode{"RKE"}, CountryId{"DK"}, Timezone{5312}}, // Roskilde Airport
    Airport{IataCode{"RKH"}, CountryId{"US"}, Timezone{2712}}, // Rock Hill/York County Airport
    Airport{IataCode{"RKI"}, CountryId{"ID"}, Timezone{4032}}, // Rokot Airport
    Airport{IataCode{"RKP"}, CountryId{"US"}, Timezone{1510}}, // Aransas County Airport
    Airport{IataCode{"RKR"}, CountryId{"US"}, Timezone{1510}}, // Robert S. Kerr Airport
    Airport{IataCode{"RKS"}, CountryId{"US"}, Timezone{1667}}, // Rock Springs–Sweetwater County Airport
    Airport{IataCode{"RKT"}, CountryId{"AE"}, Timezone{3902}}, // Ras Al Khaimah International Airport
    Airport{IataCode{"RKV"}, CountryId{"IS"}, Timezone{4823}}, // Reykjavík Airport
    Airport{IataCode{"RKW"}, CountryId{"US"}, Timezone{1510}}, // Rockwood Municipal Airport
    Airport{IataCode{"RKZ"}, CountryId{"CN"}, Timezone{4456}}, // Shigatse Peace Airport
    Airport{IataCode{"RLD"}, CountryId{"US"}, Timezone{2378}}, // Richland Airport
    Airport{IataCode{"RLG"}, CountryId{"DE"}, Timezone{5199}}, // Rostock Airport
    Airport{IataCode{"RLK"}, CountryId{"CN"}, Timezone{4456}}, // Bayannur Tianjitai Airport
    Airport{IataCode{"RLO"}, CountryId{"AR"}, Timezone{1127}}, // Sta. Rosa De Conlara Airport
    Airport{IataCode{"RLT"}, CountryId{"NE"}, Timezone{672}}, // Arlit Airport
    Airport{IataCode{"RMA"}, CountryId{"AU"}, Timezone{4920}}, // Roma Airport
    Airport{IataCode{"RMB"}, CountryId{"OM"}, Timezone{3902}}, // Buraimi Airport
    Airport{IataCode{"RMD"}, CountryId{"IN"}, Timezone{4129}}, // Ramagundam Airport
    Airport{IataCode{"RME"}, CountryId{"US"}, Timezone{2712}}, // Griffiss International Airport
    Airport{IataCode{"RMF"}, CountryId{"EG"}, Timezone{184}}, // Marsa Alam International Airport
    Airport{IataCode{"RMG"}, CountryId{"US"}, Timezone{2712}}, // Richard B. Russell Airport
    Airport{IataCode{"RMI"}, CountryId{"IT"}, Timezone{5702}}, // Federico Fellini International Airport
    Airport{IataCode{"RMK"}, CountryId{"AU"}, Timezone{4901}}, // Renmark Airport
    Airport{IataCode{"RML"}, CountryId{"LK"}, Timezone{3854}}, // Ratmalana Airport
    Airport{IataCode{"RMN"}, CountryId{"US"}, Timezone{2712}}, // Stafford Regional Airport
    Airport{IataCode{"RMP"}, CountryId{"US"}, Timezone{814}}, // Rampart Airport
    Airport{IataCode{"RMT"}, CountryId{"FR"}, Timezone{6740}}, // Rimatara Airport
    Airport{IataCode{"RMU"}, CountryId{"ES"}, Timezone{5549}}, // International airport of the Region of Murcia
    Airport{IataCode{"RMY"}, CountryId{"US"}, Timezone{2378}}, // Mariposa-Yosemite Airport
    Airport{IataCode{"RNA"}, CountryId{"SB"}, Timezone{6413}}, // Ulawa Airport
    Airport{IataCode{"RNB"}, CountryId{"SE"}, Timezone{5822}}, // Ronneby Airport
    Airport{IataCode{"RNC"}, CountryId{"US"}, Timezone{1510}}, // Warren County Memorial Airport
    Airport{IataCode{"RNE"}, CountryId{"FR"}, Timezone{5646}}, // Roanne Airport
    Airport{IataCode{"RNH"}, CountryId{"US"}, Timezone{1510}}, // New Richmond Regional Airport
    Airport{IataCode{"RNI"}, CountryId{"NI"}, Timezone{2435}}, // Corn Island Airport
    Airport{IataCode{"RNJ"}, CountryId{"JP"}, Timezone{4568}}, // Yoron Airport
    Airport{IataCode{"RNL"}, CountryId{"SB"}, Timezone{6413}}, // Rennell/Tingoa Airport
    Airport{IataCode{"RNM"}, CountryId{"OM"}, Timezone{4252}}, // Qarn Alam Airport
    Airport{IataCode{"RNN"}, CountryId{"DK"}, Timezone{5312}}, // Bornholm Airport
    Airport{IataCode{"RNO"}, CountryId{"US"}, Timezone{2378}}, // Reno–Tahoe International Airport
    Airport{IataCode{"RNP"}, CountryId{"MH"}, Timezone{6515}}, // Rongelap Airport
    Airport{IataCode{"RNS"}, CountryId{"FR"}, Timezone{5646}}, // Rennes – Saint-Jacques Airport
    Airport{IataCode{"RNT"}, CountryId{"US"}, Timezone{2378}}, // Renton Municipal Airport
    Airport{IataCode{"RNV"}, CountryId{"US"}, Timezone{1510}}, // Cleveland Municipal Airport
    Airport{IataCode{"RNZ"}, CountryId{"US"}, Timezone{1510}}, // Jasper County Airport
    Airport{IataCode{"ROA"}, CountryId{"US"}, Timezone{2712}}, // Roanoke–Blacksburg Regional Airport
    Airport{IataCode{"ROB"}, CountryId{"LR"}, Timezone{625}}, // Roberts International Airport
    Airport{IataCode{"ROC"}, CountryId{"US"}, Timezone{2712}}, // Greater Rochester International Airport
    Airport{IataCode{"ROD"}, CountryId{"ZA"}, Timezone{369}}, // Robertson Airfield
    Airport{IataCode{"ROG"}, CountryId{"US"}, Timezone{1510}}, // Rogers Municipal Airport
    Airport{IataCode{"ROI"}, CountryId{"TH"}, Timezone{3777}}, // Roi Et Airport
    Airport{IataCode{"ROK"}, CountryId{"AU"}, Timezone{4920}}, // Rockhampton Airport
    Airport{IataCode{"RON"}, CountryId{"CO"}, Timezone{1376}}, // Juan José Rondón Airport
    Airport{IataCode{"ROO"}, CountryId{"BR"}, Timezone{1579}}, // Rondonópolis Airport
    Airport{IataCode{"ROP"}, CountryId{"US"}, Timezone{6725}}, // Rota International Airport
    Airport{IataCode{"ROR"}, CountryId{"PW"}, Timezone{}}, // Roman Tmetuchl International Airport
    Airport{IataCode{"ROS"}, CountryId{"AR"}, Timezone{942}}, // Rosario – Islas Malvinas International Airport
    Airport{IataCode{"ROT"}, CountryId{"NZ"}, Timezone{6218}}, // Rotorua International Airport
    Airport{IataCode{"ROV"}, CountryId{"RU"}, Timezone{5620}}, // Platov International Airport
    Airport{IataCode{"ROW"}, CountryId{"US"}, Timezone{1667}}, // Roswell International Air Center
    Airport{IataCode{"ROY"}, CountryId{"AR"}, Timezone{914}}, // Río Mayo Airport
    Airport{IataCode{"RPB"}, CountryId{"US"}, Timezone{1510}}, // Belleville Municipal Airport
    Airport{IataCode{"RPJ"}, CountryId{"US"}, Timezone{1510}}, // Rochelle Municipal Airport
    Airport{IataCode{"RPK"}, CountryId{"FR"}, Timezone{5646}}, // Reims – Prunay Aerodrome
    Airport{IataCode{"RPM"}, CountryId{"AU"}, Timezone{4978}}, // Ngukurr Airport
    Airport{IataCode{"RPN"}, CountryId{"IL"}, Timezone{4046}}, // Rosh Pina Airport
    Airport{IataCode{"RPR"}, CountryId{"IN"}, Timezone{4129}}, // Swami Vivekananda Airport
    Airport{IataCode{"RPX"}, CountryId{"US"}, Timezone{1667}}, // Roundup Airport
    Airport{IataCode{"RQE"}, CountryId{"US"}, Timezone{1667}}, // Window Rock Airport
    Airport{IataCode{"RQO"}, CountryId{"US"}, Timezone{1510}}, // El Reno Regional Airport
    Airport{IataCode{"RRG"}, CountryId{"MU"}, Timezone{6158}}, // Sir Gaëtan Duval Airport
    Airport{IataCode{"RRK"}, CountryId{"IN"}, Timezone{4129}}, // Rourkela Airport
    Airport{IataCode{"RRL"}, CountryId{"US"}, Timezone{1510}}, // Merrill Municipal Airport
    Airport{IataCode{"RRR"}, CountryId{"FR"}, Timezone{6740}}, // Raroia Airport
    Airport{IataCode{"RRS"}, CountryId{"NO"}, Timezone{5634}}, // Røros Airport
    Airport{IataCode{"RRT"}, CountryId{"US"}, Timezone{1510}}, // Warroad International Airport
    Airport{IataCode{"RSA"}, CountryId{"AR"}, Timezone{1076}}, // Santa Rosa Airport
    Airport{IataCode{"RSD"}, CountryId{"BS"}, Timezone{2697}}, // Rock Sound International Airport
    Airport{IataCode{"RSE"}, CountryId{"AU"}, Timezone{5103}}, // Rose Bay Water Airport
    Airport{IataCode{"RSH"}, CountryId{"US"}, Timezone{814}}, // Russian Mission Airport
    Airport{IataCode{"RSJ"}, CountryId{"US"}, Timezone{2378}}, // Rosario Seaplane Base
    Airport{IataCode{"RSN"}, CountryId{"US"}, Timezone{1510}}, // Ruston Regional Airport
    Airport{IataCode{"RSS"}, CountryId{"SD"}, Timezone{432}}, // Damazin Airport
    Airport{IataCode{"RST"}, CountryId{"US"}, Timezone{1510}}, // Rochester International Airport
    Airport{IataCode{"RSU"}, CountryId{"KR"}, Timezone{4445}}, // Yeosu Airport
    Airport{IataCode{"RSV"}, CountryId{"US"}, Timezone{1510}}, // Crawford County Airport
    Airport{IataCode{"RSW"}, CountryId{"US"}, Timezone{2712}}, // Southwest Florida International Airport
    Airport{IataCode{"RTA"}, CountryId{"FJ"}, Timezone{6349}}, // Rotuma Airport
    Airport{IataCode{"RTB"}, CountryId{"HN"}, Timezone{3401}}, // Juan Manuel Gálvez International Airport
    Airport{IataCode{"RTC"}, CountryId{"IN"}, Timezone{4129}}, // Ratnagiri Airport
    Airport{IataCode{"RTG"}, CountryId{"ID"}, Timezone{}}, // Q12474106
    Airport{IataCode{"RTL"}, CountryId{"US"}, Timezone{1510}}, // Spirit Lake Municipal Airport
    Airport{IataCode{"RTM"}, CountryId{"NL"}, Timezone{5120}}, // Rotterdam The Hague Airport
    Airport{IataCode{"RTN"}, CountryId{"US"}, Timezone{1667}}, // Raton Municipal Airport
    Airport{IataCode{"RTS"}, CountryId{"AU"}, Timezone{5087}}, // Rottnest Island Airport
    Airport{IataCode{"RTW"}, CountryId{"RU"}, Timezone{5762}}, // Saratov Tsentralny Airport
    Airport{IataCode{"RUA"}, CountryId{"UG"}, Timezone{519}}, // Arua Airport
    Airport{IataCode{"RUD"}, CountryId{"IR"}, Timezone{4543}}, // Shahroud Airport
    Airport{IataCode{"RUE"}, CountryId{"US"}, Timezone{1510}}, // Russellville Regional Airport
    Airport{IataCode{"RUG"}, CountryId{"US"}, Timezone{1510}}, // Rugby Municipal Airport
    Airport{IataCode{"RUH"}, CountryId{"SA"}, Timezone{4404}}, // King Khalid International Airport
    Airport{IataCode{"RUI"}, CountryId{"US"}, Timezone{1667}}, // Sierra Blanca Regional Airport
    Airport{IataCode{"RUK"}, CountryId{"NP"}, Timezone{4100}}, // Rukumkot Airport
    Airport{IataCode{"RUM"}, CountryId{"NP"}, Timezone{4100}}, // Rumjatar Airport
    Airport{IataCode{"RUN"}, CountryId{"FR"}, Timezone{6190}}, // Roland Garros Airport
    Airport{IataCode{"RUP"}, CountryId{"IN"}, Timezone{3881}}, // Rupsi Airport
    Airport{IataCode{"RUR"}, CountryId{"FR"}, Timezone{6740}}, // Rurutu Airport
    Airport{IataCode{"RUS"}, CountryId{"SB"}, Timezone{6413}}, // Marau Airport
    Airport{IataCode{"RUT"}, CountryId{"US"}, Timezone{2712}}, // Rutland Southern Vermont Regional Airport
    Airport{IataCode{"RUV"}, CountryId{"GT"}, Timezone{1913}}, // Rubelsanto Airport
    Airport{IataCode{"RUY"}, CountryId{"HN"}, Timezone{3401}}, // Copán Ruinas Airport
    Airport{IataCode{"RVA"}, CountryId{"MG"}, Timezone{6035}}, // Farafangana Airport
    Airport{IataCode{"RVD"}, CountryId{"BR"}, Timezone{3216}}, // Rio Verde Airport
    Airport{IataCode{"RVE"}, CountryId{"CO"}, Timezone{1376}}, // Los Colonizadores Airport
    Airport{IataCode{"RVH"}, CountryId{"RU"}, Timezone{5620}}, // Rzhevka Airport
    Airport{IataCode{"RVI"}, CountryId{"RU"}, Timezone{5620}}, // Rostov-on-Don Airport
    Airport{IataCode{"RVK"}, CountryId{"NO"}, Timezone{5634}}, // Rørvik Airport
    Airport{IataCode{"RVN"}, CountryId{"FI"}, Timezone{5377}}, // Rovaniemi Airport
    Airport{IataCode{"RVR"}, CountryId{"US"}, Timezone{1667}}, // Green River Municipal Airport
    Airport{IataCode{"RVS"}, CountryId{"US"}, Timezone{1510}}, // Richard Lloyd Jones Jr. Airport
    Airport{IataCode{"RVT"}, CountryId{"AU"}, Timezone{5087}}, // Ravensthorpe Airport
    Airport{IataCode{"RVV"}, CountryId{"FR"}, Timezone{6740}}, // Raivavae Airport
    Airport{IataCode{"RVY"}, CountryId{"UY"}, Timezone{2659}}, // Rivera International Airport
    Airport{IataCode{"RWI"}, CountryId{"US"}, Timezone{2712}}, // Rocky Mount-Wilson Regional Airport
    Airport{IataCode{"RWL"}, CountryId{"US"}, Timezone{1667}}, // Rawlins Municipal Airport
    Airport{IataCode{"RWN"}, CountryId{"UA"}, Timezone{5461}}, // Rivne International Airport
    Airport{IataCode{"RWV"}, CountryId{"US"}, Timezone{1510}}, // Caldwell Municipal Airport
    Airport{IataCode{"RXE"}, CountryId{"US"}, Timezone{1391}}, // Rexburg-Madison County Airport
    Airport{IataCode{"RXS"}, CountryId{"PH"}, Timezone{4240}}, // Roxas Airport
    Airport{IataCode{"RYB"}, CountryId{"RU"}, Timezone{5620}}, // Staroselye Airport
    Airport{IataCode{"RYG"}, CountryId{"NO"}, Timezone{5634}}, // Moss Airport, Rygge
    Airport{IataCode{"RYK"}, CountryId{"PK"}, Timezone{4087}}, // Shaikh Zayed International Airport
    Airport{IataCode{"RYN"}, CountryId{"US"}, Timezone{2931}}, // Ryan Airfield
    Airport{IataCode{"RYO"}, CountryId{"AR"}, Timezone{1045}}, // Rio Turbio Airport
    Airport{IataCode{"RYV"}, CountryId{"US"}, Timezone{1510}}, // Watertown Municipal Airport
    Airport{IataCode{"RYY"}, CountryId{"US"}, Timezone{2712}}, // Cobb County Airport
    Airport{IataCode{"RZA"}, CountryId{"AR"}, Timezone{1045}}, // Santa Cruz Airport, Argentina
    Airport{IataCode{"RZE"}, CountryId{"PL"}, Timezone{5975}}, // Rzeszów-Jasionka Airport
    Airport{IataCode{"RZN"}, CountryId{"RU"}, Timezone{5620}}, // Turlatovo Airport
    Airport{IataCode{"RZP"}, CountryId{"PH"}, Timezone{4240}}, // Taytay Airport
    Airport{IataCode{"RZR"}, CountryId{"IR"}, Timezone{4543}}, // Ramsar Airport
    Airport{IataCode{"RZS"}, CountryId{"PK"}, Timezone{4087}}, // Sawan Airport
    Airport{IataCode{"RZZ"}, CountryId{"US"}, Timezone{2712}}, // Halifax County Airport
    Airport{IataCode{"SAA"}, CountryId{"US"}, Timezone{1667}}, // Shively Field
    Airport{IataCode{"SAB"}, CountryId{"NL"}, Timezone{2331}}, // Juancho E. Yrausquin Airport
    Airport{IataCode{"SAC"}, CountryId{"US"}, Timezone{2378}}, // Sacramento Executive Airport
    Airport{IataCode{"SAD"}, CountryId{"US"}, Timezone{2931}}, // Safford Regional Airport
    Airport{IataCode{"SAF"}, CountryId{"US"}, Timezone{1667}}, // Santa Fe Municipal Airport
    Airport{IataCode{"SAG"}, CountryId{"IN"}, Timezone{4129}}, // Shirdi Airport
    Airport{IataCode{"SAH"}, CountryId{"YE"}, Timezone{3634}}, // Sana'a International Airport
    Airport{IataCode{"SAK"}, CountryId{"IS"}, Timezone{4823}}, // Sauðárkrókur Airport
    Airport{IataCode{"SAL"}, CountryId{"SV"}, Timezone{1749}}, // Monseñor Óscar Arnulfo Romero International Airport
    Airport{IataCode{"SAM"}, CountryId{"PG"}, Timezone{6686}}, // Salamo Airport
    Airport{IataCode{"SAN"}, CountryId{"US"}, Timezone{2378}}, // San Diego International Airport
    Airport{IataCode{"SAP"}, CountryId{"HN"}, Timezone{3401}}, // Ramón Villeda Morales International Airport
    Airport{IataCode{"SAQ"}, CountryId{"BS"}, Timezone{2697}}, // San Andros Airport
    Airport{IataCode{"SAS"}, CountryId{"US"}, Timezone{2378}}, // Salton Sea Airport
    Airport{IataCode{"SAT"}, CountryId{"US"}, Timezone{1510}}, // San Antonio International Airport
    Airport{IataCode{"SAU"}, CountryId{"ID"}, Timezone{4226}}, // Tardamu Airport
    Airport{IataCode{"SAV"}, CountryId{"US"}, Timezone{2712}}, // Savannah/Hilton Head International Airport
    Airport{IataCode{"SAW"}, CountryId{"TR"}, Timezone{5412}}, // Sabiha Gökçen International Airport
    Airport{IataCode{"SAY"}, CountryId{"IT"}, Timezone{5702}}, // Siena-Ampugnano Airport
    Airport{IataCode{"SAZ"}, CountryId{"LR"}, Timezone{625}}, // Sasstown Airport
    Airport{IataCode{"SBA"}, CountryId{"US"}, Timezone{2378}}, // Santa Barbara Municipal Airport
    Airport{IataCode{"SBB"}, CountryId{"VE"}, Timezone{1463}}, // Santa Bárbara de Barinas Airport
    Airport{IataCode{"SBD"}, CountryId{"US"}, Timezone{2378}}, // San Bernardino International Airport
    Airport{IataCode{"SBF"}, CountryId{"AF"}, Timezone{4061}}, // Sardeh Band Airport
    Airport{IataCode{"SBG"}, CountryId{"ID"}, Timezone{4032}}, // Maimun Saleh Airport
    Airport{IataCode{"SBH"}, CountryId{"FR"}, Timezone{3269}}, // Gustaf III Airport
    Airport{IataCode{"SBI"}, CountryId{"GN"}, Timezone{228}}, // Sambailo Airport
    Airport{IataCode{"SBJ"}, CountryId{"BR"}, Timezone{3216}}, // Sao Mateus Airport
    Airport{IataCode{"SBK"}, CountryId{"FR"}, Timezone{5646}}, // Saint-Brieuc – Armor Airport
    Airport{IataCode{"SBL"}, CountryId{"BO"}, Timezone{2350}}, // Santa Ana del Yacuma Airport
    Airport{IataCode{"SBM"}, CountryId{"US"}, Timezone{1510}}, // Sheboygan County Memorial Airport
    Airport{IataCode{"SBN"}, CountryId{"US"}, Timezone{}}, // South Bend Regional Airport
    Airport{IataCode{"SBO"}, CountryId{"US"}, Timezone{1667}}, // Salina-Gunnison Airport
    Airport{IataCode{"SBP"}, CountryId{"US"}, Timezone{2378}}, // San Luis Obispo County Regional Airport
    Airport{IataCode{"SBQ"}, CountryId{"PK"}, Timezone{4087}}, // Sibi Airport
    Airport{IataCode{"SBR"}, CountryId{"AU"}, Timezone{4920}}, // Saibai Island Airport
    Airport{IataCode{"SBS"}, CountryId{"US"}, Timezone{1667}}, // Steamboat Springs Airport
    Airport{IataCode{"SBT"}, CountryId{"RU"}, Timezone{4690}}, // Sabetta International Airport
    Airport{IataCode{"SBW"}, CountryId{"MY"}, Timezone{4190}}, // Sibu Airport
    Airport{IataCode{"SBX"}, CountryId{"US"}, Timezone{1667}}, // Shelby Airport
    Airport{IataCode{"SBY"}, CountryId{"US"}, Timezone{2712}}, // Salisbury–Ocean City–Wicomico Regional Airport
    Airport{IataCode{"SBZ"}, CountryId{"RO"}, Timezone{5247}}, // Sibiu International Airport
    Airport{IataCode{"SCB"}, CountryId{"US"}, Timezone{1510}}, // Scribner State Airport
    Airport{IataCode{"SCC"}, CountryId{"US"}, Timezone{814}}, // Deadhorse Airport
    Airport{IataCode{"SCD"}, CountryId{"US"}, Timezone{1510}}, // Sylacauga Municipal Airport
    Airport{IataCode{"SCE"}, CountryId{"US"}, Timezone{2712}}, // University Park Airport
    Airport{IataCode{"SCF"}, CountryId{"US"}, Timezone{2931}}, // Scottsdale Airport
    Airport{IataCode{"SCH"}, CountryId{"US"}, Timezone{2712}}, // Schenectady County Airport
    Airport{IataCode{"SCI"}, CountryId{"VE"}, Timezone{1463}}, // Paramillo Airport
    Airport{IataCode{"SCK"}, CountryId{"US"}, Timezone{2378}}, // Stockton Metropolitan Airport
    Airport{IataCode{"SCL"}, CountryId{"CL"}, Timezone{3177}}, // Comodoro Arturo Merino Benítez International Airport
    Airport{IataCode{"SCM"}, CountryId{"US"}, Timezone{2745}}, // Scammon Bay Airport
    Airport{IataCode{"SCN"}, CountryId{"DE"}, Timezone{5199}}, // Saarbrücken Airport
    Airport{IataCode{"SCO"}, CountryId{"KZ"}, Timezone{3679}}, // Aktau Airport
    Airport{IataCode{"SCP"}, CountryId{"FR"}, Timezone{5646}}, // Mont-Dauphin - Saint-Crépin Airport
    Airport{IataCode{"SCQ"}, CountryId{"ES"}, Timezone{5549}}, // Santiago de Compostela Airport
    Airport{IataCode{"SCS"}, CountryId{"GB"}, Timezone{5517}}, // Scatsta Airport
    Airport{IataCode{"SCT"}, CountryId{"YE"}, Timezone{3634}}, // Socotra Airport
    Airport{IataCode{"SCU"}, CountryId{"CU"}, Timezone{1980}}, // Antonio Maceo Airport
    Airport{IataCode{"SCV"}, CountryId{"RO"}, Timezone{5247}}, // Suceava Airport
    Airport{IataCode{"SCW"}, CountryId{"RU"}, Timezone{5620}}, // Syktyvkar Airport
    Airport{IataCode{"SCX"}, CountryId{"MX"}, Timezone{2588}}, // Salina Cruz Airport
    Airport{IataCode{"SCY"}, CountryId{"EC"}, Timezone{6379}}, // San Cristóbal Airport
    Airport{IataCode{"SCZ"}, CountryId{"SB"}, Timezone{}}, // Santa Cruz/Graciosa Bay/Luova Airport
    Airport{IataCode{"SDC"}, CountryId{"US"}, Timezone{2712}}, // Williamson–Sodus Airport
    Airport{IataCode{"SDD"}, CountryId{"AO"}, Timezone{505}}, // Lubango Airport
    Airport{IataCode{"SDE"}, CountryId{"AR"}, Timezone{942}}, // Vicecomodoro Ángel de la Paz Aragonés Airport
    Airport{IataCode{"SDF"}, CountryId{"US"}, Timezone{2275}}, // Louisville International Airport
    Airport{IataCode{"SDG"}, CountryId{"IR"}, Timezone{4543}}, // Sanandaj Airport
    Airport{IataCode{"SDH"}, CountryId{"HN"}, Timezone{3401}}, // Santa Rosa de Copán Airport
    Airport{IataCode{"SDI"}, CountryId{"PG"}, Timezone{6686}}, // Saidor Airport
    Airport{IataCode{"SDJ"}, CountryId{"JP"}, Timezone{4568}}, // Sendai Airport
    Airport{IataCode{"SDK"}, CountryId{"MY"}, Timezone{4190}}, // Sandakan Airport
    Airport{IataCode{"SDL"}, CountryId{"SE"}, Timezone{5822}}, // Sundsvall-Härnösand Airport
    Airport{IataCode{"SDM"}, CountryId{"US"}, Timezone{2378}}, // Brown Field Municipal Airport
    Airport{IataCode{"SDN"}, CountryId{"NO"}, Timezone{5634}}, // Sandane Airport
    Airport{IataCode{"SDO"}, CountryId{"RS"}, Timezone{5183}}, // Smederevo Airport
    Airport{IataCode{"SDP"}, CountryId{"US"}, Timezone{814}}, // Sand Point Airport
    Airport{IataCode{"SDQ"}, CountryId{"DO"}, Timezone{3194}}, // Las Américas International Airport
    Airport{IataCode{"SDR"}, CountryId{"ES"}, Timezone{5549}}, // Santander Airport
    Airport{IataCode{"SDS"}, CountryId{"JP"}, Timezone{4568}}, // Sado Airport
    Airport{IataCode{"SDT"}, CountryId{"PK"}, Timezone{4087}}, // Saidu Sharif Airport
    Airport{IataCode{"SDU"}, CountryId{"BR"}, Timezone{3216}}, // Santos Dumont Airport
    Airport{IataCode{"SDV"}, CountryId{"IL"}, Timezone{4046}}, // Sde Dov Airport
    Airport{IataCode{"SDX"}, CountryId{"US"}, Timezone{2931}}, // Sedona Airport
    Airport{IataCode{"SDY"}, CountryId{"US"}, Timezone{1667}}, // Sidney-Richland Municipal Airport
    Airport{IataCode{"SEA"}, CountryId{"US"}, Timezone{2378}}, // Seattle–Tacoma International Airport
    Airport{IataCode{"SEB"}, CountryId{"LY"}, Timezone{757}}, // Sabha Airport
    Airport{IataCode{"SEE"}, CountryId{"US"}, Timezone{2378}}, // Gillespie Field
    Airport{IataCode{"SEF"}, CountryId{"US"}, Timezone{2712}}, // Sebring Regional Airport
    Airport{IataCode{"SEG"}, CountryId{"US"}, Timezone{2712}}, // Penn Valley Airport
    Airport{IataCode{"SEK"}, CountryId{"RU"}, Timezone{4485}}, // Srednekolymsk Airport
    Airport{IataCode{"SEM"}, CountryId{"US"}, Timezone{1510}}, // Craig Field Airport
    Airport{IataCode{"SEN"}, CountryId{"GB"}, Timezone{5517}}, // London Southend Airport
    Airport{IataCode{"SEO"}, CountryId{"CI"}, Timezone{0}}, // Séguéla Airport
    Airport{IataCode{"SEQ"}, CountryId{"ID"}, Timezone{4032}}, // Sungai Pakning
    Airport{IataCode{"SER"}, CountryId{"US"}, Timezone{2043}}, // Freeman Municipal Airport
    Airport{IataCode{"SES"}, CountryId{"US"}, Timezone{1510}}, // Selma Municipal Airport
    Airport{IataCode{"SEU"}, CountryId{"TZ"}, Timezone{256}}, // Seronera Airstrip
    Airport{IataCode{"SEW"}, CountryId{"EG"}, Timezone{184}}, // Siwa Oasis North Airport
    Airport{IataCode{"SEY"}, CountryId{"MR"}, Timezone{686}}, // Sélibaby Airport
    Airport{IataCode{"SEZ"}, CountryId{"SC"}, Timezone{6130}}, // Seychelles International Airport
    Airport{IataCode{"SFA"}, CountryId{"TN"}, Timezone{772}}, // Sfax–Thyna International Airport
    Airport{IataCode{"SFB"}, CountryId{"US"}, Timezone{2712}}, // Orlando Sanford International Airport
    Airport{IataCode{"SFC"}, CountryId{"FR"}, Timezone{1894}}, // Saint-François Airport
    Airport{IataCode{"SFD"}, CountryId{"VE"}, Timezone{1463}}, // Las Flecheras Airport
    Airport{IataCode{"SFE"}, CountryId{"PH"}, Timezone{4240}}, // San Fernando Airport
    Airport{IataCode{"SFF"}, CountryId{"US"}, Timezone{2378}}, // Felts Field
    Airport{IataCode{"SFG"}, CountryId{"FR"}, Timezone{832}}, // L'Espérance Airport
    Airport{IataCode{"SFH"}, CountryId{"MX"}, Timezone{3455}}, // San Felipe International Airport
    Airport{IataCode{"SFJ"}, CountryId{"GL"}, Timezone{1825}}, // Kangerlussuaq Airport
    Airport{IataCode{"SFK"}, CountryId{"HU"}, Timezone{5264}}, // Siófok-Kiliti Airport
    Airport{IataCode{"SFL"}, CountryId{"CV"}, Timezone{4771}}, // São Filipe Airport
    Airport{IataCode{"SFM"}, CountryId{"US"}, Timezone{2712}}, // Sanford Regional Airport
    Airport{IataCode{"SFN"}, CountryId{"AR"}, Timezone{942}}, // Sauce Viejo Airport
    Airport{IataCode{"SFO"}, CountryId{"US"}, Timezone{2378}}, // San Francisco International Airport
    Airport{IataCode{"SFQ"}, CountryId{"TR"}, Timezone{5412}}, // Sanliurfa Airport
    Airport{IataCode{"SFS"}, CountryId{"PH"}, Timezone{4240}}, // Subic Bay International Airport
    Airport{IataCode{"SFT"}, CountryId{"SE"}, Timezone{5822}}, // Skellefteå Airport
    Airport{IataCode{"SFZ"}, CountryId{"US"}, Timezone{2712}}, // North Central State Airport
    Airport{IataCode{"SGA"}, CountryId{"AF"}, Timezone{4061}}, // Sheghnan Airport
    Airport{IataCode{"SGC"}, CountryId{"RU"}, Timezone{4690}}, // Surgut International Airport
    Airport{IataCode{"SGD"}, CountryId{"DK"}, Timezone{5312}}, // Sønderborg Airport
    Airport{IataCode{"SGE"}, CountryId{"DE"}, Timezone{5199}}, // Siegerland Airport
    Airport{IataCode{"SGF"}, CountryId{"US"}, Timezone{1510}}, // Springfield-Branson National Airport
    Airport{IataCode{"SGH"}, CountryId{"US"}, Timezone{2712}}, // Springfield-Beckley Municipal Airport
    Airport{IataCode{"SGK"}, CountryId{"PG"}, Timezone{6686}}, // Sangapi Airport
    Airport{IataCode{"SGL"}, CountryId{"CO"}, Timezone{1376}}, // Los Pozos Airport
    Airport{IataCode{"SGM"}, CountryId{"MX"}, Timezone{2519}}, // San Ignacio Airfield
    Airport{IataCode{"SGN"}, CountryId{"VN"}, Timezone{3964}}, // Tan Son Nhat International Airport
    Airport{IataCode{"SGO"}, CountryId{"AU"}, Timezone{4920}}, // St George Airport
    Airport{IataCode{"SGP"}, CountryId{"AU"}, Timezone{5087}}, // Shay Gap Airport
    Airport{IataCode{"SGR"}, CountryId{"US"}, Timezone{1510}}, // Sugar Land Regional Airport
    Airport{IataCode{"SGS"}, CountryId{"PH"}, Timezone{4240}}, // Sanga-Sanga Airport
    Airport{IataCode{"SGT"}, CountryId{"US"}, Timezone{1510}}, // Stuttgart Municipal Airport
    Airport{IataCode{"SGU"}, CountryId{"US"}, Timezone{1667}}, // St. George Regional Airport
    Airport{IataCode{"SGV"}, CountryId{"AR"}, Timezone{1076}}, // Sierra Grande Airport
    Airport{IataCode{"SGW"}, CountryId{"US"}, Timezone{3255}}, // Saginaw Seaplane Base
    Airport{IataCode{"SGX"}, CountryId{"TZ"}, Timezone{256}}, // Songea Airport
    Airport{IataCode{"SGY"}, CountryId{"US"}, Timezone{2260}}, // Skagway Airport
    Airport{IataCode{"SGZ"}, CountryId{"TH"}, Timezone{3777}}, // Songkhla Airport
    Airport{IataCode{"SHA"}, CountryId{"CN"}, Timezone{4456}}, // Shanghai Hongqiao International Airport
    Airport{IataCode{"SHB"}, CountryId{"JP"}, Timezone{4568}}, // Nakashibetsu Airport
    Airport{IataCode{"SHC"}, CountryId{"ET"}, Timezone{28}}, // Shire Airport
    Airport{IataCode{"SHD"}, CountryId{"US"}, Timezone{2712}}, // Shenandoah Valley Regional Airport
    Airport{IataCode{"SHE"}, CountryId{"CN"}, Timezone{4456}}, // Shenyang Taoxian International Airport
    Airport{IataCode{"SHF"}, CountryId{"CN"}, Timezone{4607}}, // Shihezi Huayuan Airport
    Airport{IataCode{"SHG"}, CountryId{"US"}, Timezone{814}}, // Shungnak Airport
    Airport{IataCode{"SHH"}, CountryId{"US"}, Timezone{2745}}, // Shishmaref Airport
    Airport{IataCode{"SHI"}, CountryId{"JP"}, Timezone{4568}}, // Shimojishima Airport
    Airport{IataCode{"SHJ"}, CountryId{"AE"}, Timezone{3902}}, // Sharjah International Airport
    Airport{IataCode{"SHK"}, CountryId{"LS"}, Timezone{579}}, // Sehonghong Airport
    Airport{IataCode{"SHL"}, CountryId{"IN"}, Timezone{4129}}, // Shillong Airport
    Airport{IataCode{"SHM"}, CountryId{"JP"}, Timezone{4568}}, // Nanki-Shirahama Airport
    Airport{IataCode{"SHN"}, CountryId{"US"}, Timezone{2378}}, // Sanderson Field
    Airport{IataCode{"SHO"}, CountryId{"SZ"}, Timezone{593}}, // Sikhuphe International Airport
    Airport{IataCode{"SHQ"}, CountryId{"AU"}, Timezone{4920}}, // Southport Airport
    Airport{IataCode{"SHR"}, CountryId{"US"}, Timezone{1667}}, // Sheridan County Airport
    Airport{IataCode{"SHS"}, CountryId{"CN"}, Timezone{4456}}, // Shashi Airport
    Airport{IataCode{"SHT"}, CountryId{"AU"}, Timezone{5067}}, // Shepparton Airport
    Airport{IataCode{"SHU"}, CountryId{"AU"}, Timezone{4978}}, // Smith Point Airport
    Airport{IataCode{"SHV"}, CountryId{"US"}, Timezone{1510}}, // Shreveport Regional Airport
    Airport{IataCode{"SHW"}, CountryId{"SA"}, Timezone{4404}}, // Sharurah Domestic Airport
    Airport{IataCode{"SHX"}, CountryId{"US"}, Timezone{814}}, // Shageluk Airport
    Airport{IataCode{"SHY"}, CountryId{"TZ"}, Timezone{256}}, // Shinyanga Airport
    Airport{IataCode{"SHZ"}, CountryId{"LS"}, Timezone{579}}, // Seshutes Airport
    Airport{IataCode{"SIA"}, CountryId{"CN"}, Timezone{4456}}, // Xi'an Xiguan Airport
    Airport{IataCode{"SIB"}, CountryId{"CG"}, Timezone{148}}, // Sibiti Airport
    Airport{IataCode{"SIC"}, CountryId{"PA"}, Timezone{2877}}, // San José Airport, Las Perlas
    Airport{IataCode{"SID"}, CountryId{"CV"}, Timezone{4771}}, // Amílcar Cabral International Airport
    Airport{IataCode{"SIF"}, CountryId{"NP"}, Timezone{4100}}, // Simara Airport
    Airport{IataCode{"SIG"}, CountryId{"US"}, Timezone{3012}}, // Fernando Luis Ribas Dominicci Airport
    Airport{IataCode{"SII"}, CountryId{"MA"}, Timezone{215}}, // Sidi Ifni Airport
    Airport{IataCode{"SIJ"}, CountryId{"IS"}, Timezone{4823}}, // Siglufjörður Airport
    Airport{IataCode{"SIK"}, CountryId{"US"}, Timezone{1510}}, // Sikeston Memorial Municipal Airport
    Airport{IataCode{"SIN"}, CountryId{"SG"}, Timezone{4470}}, // Singapore Changi Airport
    Airport{IataCode{"SIO"}, CountryId{"AU"}, Timezone{5011}}, // Smithton Airport
    Airport{IataCode{"SIP"}, CountryId{"RU"}, Timezone{5777}}, // Simferopol International Airport
    Airport{IataCode{"SIQ"}, CountryId{"ID"}, Timezone{}}, // Dabo Singkep Airport
    Airport{IataCode{"SIR"}, CountryId{"CH"}, Timezone{6021}}, // Sion Airport
    Airport{IataCode{"SIS"}, CountryId{"ZA"}, Timezone{369}}, // Sishen Airport
    Airport{IataCode{"SIT"}, CountryId{"US"}, Timezone{3255}}, // Sitka Rocky Gutierrez Airport
    Airport{IataCode{"SIU"}, CountryId{"NI"}, Timezone{2435}}, // Siuna Airport
    Airport{IataCode{"SIV"}, CountryId{"US"}, Timezone{2043}}, // Sullivan County Airport
    Airport{IataCode{"SIW"}, CountryId{"ID"}, Timezone{4032}}, // Sibisa Airport
    Airport{IataCode{"SIX"}, CountryId{"ID"}, Timezone{4032}}, // Ferdinand Lumban Tobing Airport
    Airport{IataCode{"SIY"}, CountryId{"US"}, Timezone{2378}}, // Siskiyou County Airport
    Airport{IataCode{"SJB"}, CountryId{"BO"}, Timezone{2350}}, // San Joaquín Airport
    Airport{IataCode{"SJC"}, CountryId{"US"}, Timezone{2378}}, // San Jose International Airport
    Airport{IataCode{"SJD"}, CountryId{"MX"}, Timezone{2519}}, // Los Cabos International Airport
    Airport{IataCode{"SJE"}, CountryId{"CO"}, Timezone{1376}}, // Jorge Enrique González Torres Airport
    Airport{IataCode{"SJI"}, CountryId{"PH"}, Timezone{4240}}, // San Jose Airport
    Airport{IataCode{"SJJ"}, CountryId{"BA"}, Timezone{5746}}, // Sarajevo International Airport
    Airport{IataCode{"SJK"}, CountryId{"BR"}, Timezone{3216}}, // São José dos Campos Airport
    Airport{IataCode{"SJL"}, CountryId{"BR"}, Timezone{2451}}, // São Gabriel da Cachoeira Airport
    Airport{IataCode{"SJM"}, CountryId{"DO"}, Timezone{3194}}, // San Juan de la Maguana Airport
    Airport{IataCode{"SJN"}, CountryId{"US"}, Timezone{2931}}, // St. Johns Industrial Air Park
    Airport{IataCode{"SJO"}, CountryId{"CR"}, Timezone{1544}}, // Juan Santamaría International Airport
    Airport{IataCode{"SJP"}, CountryId{"BR"}, Timezone{3216}}, // São José do Rio Preto Airport
    Airport{IataCode{"SJQ"}, CountryId{"ZM"}, Timezone{537}}, // Sesheke Airport
    Airport{IataCode{"SJS"}, CountryId{"BO"}, Timezone{2350}}, // San José de Chiquitos Airport
    Airport{IataCode{"SJT"}, CountryId{"US"}, Timezone{1510}}, // San Angelo Regional Airport
    Airport{IataCode{"SJU"}, CountryId{"US"}, Timezone{3012}}, // Luis Muñoz Marín International Airport
    Airport{IataCode{"SJV"}, CountryId{"BO"}, Timezone{2350}}, // San Javier Airport (Bolivia)
    Airport{IataCode{"SJW"}, CountryId{"CN"}, Timezone{4456}}, // Shijiazhuang Zhengding International Airport
    Airport{IataCode{"SJX"}, CountryId{"BZ"}, Timezone{1448}}, // Sarteneja Airport
    Airport{IataCode{"SJY"}, CountryId{"FI"}, Timezone{5377}}, // Seinäjoki Airport
    Airport{IataCode{"SJZ"}, CountryId{"PT"}, Timezone{4722}}, // São Jorge Airport
    Airport{IataCode{"SKB"}, CountryId{"KN"}, Timezone{3308}}, // Robert L. Bradshaw International Airport
    Airport{IataCode{"SKC"}, CountryId{"PG"}, Timezone{6686}}, // Suki Airport
    Airport{IataCode{"SKD"}, CountryId{"UZ"}, Timezone{4430}}, // Samarkand International Airport
    Airport{IataCode{"SKE"}, CountryId{"NO"}, Timezone{5634}}, // Skien Airport, Geiteryggen
    Airport{IataCode{"SKF"}, CountryId{"US"}, Timezone{1510}}, // Kelly Field Annex
    Airport{IataCode{"SKG"}, CountryId{"GR"}, Timezone{5169}}, // Thessaloniki International Airport
    Airport{IataCode{"SKH"}, CountryId{"NP"}, Timezone{4100}}, // Surkhet Airport
    Airport{IataCode{"SKI"}, CountryId{"DZ"}, Timezone{47}}, // Skikda Airport
    Airport{IataCode{"SKK"}, CountryId{"US"}, Timezone{814}}, // Shaktoolik Airport
    Airport{IataCode{"SKL"}, CountryId{"GB"}, Timezone{5517}}, // Broadford Airfield
    Airport{IataCode{"SKN"}, CountryId{"NO"}, Timezone{5634}}, // Stokmarknes Airport
    Airport{IataCode{"SKO"}, CountryId{"NG"}, Timezone{462}}, // Sadiq Abubakar III International Airport
    Airport{IataCode{"SKP"}, CountryId{"MK"}, Timezone{5795}}, // Skopje "Alexander the Great" Airport
    Airport{IataCode{"SKQ"}, CountryId{"LS"}, Timezone{579}}, // Sekake Airport
    Airport{IataCode{"SKR"}, CountryId{"ET"}, Timezone{28}}, // Shakiso Airport
    Airport{IataCode{"SKS"}, CountryId{"DK"}, Timezone{5312}}, // Vojens Airport
    Airport{IataCode{"SKT"}, CountryId{"PK"}, Timezone{4087}}, // Sialkot International Airport
    Airport{IataCode{"SKU"}, CountryId{"GR"}, Timezone{5169}}, // Skyros Island National Airport
    Airport{IataCode{"SKV"}, CountryId{"EG"}, Timezone{184}}, // St. Catherine International Airport
    Airport{IataCode{"SKW"}, CountryId{"US"}, Timezone{814}}, // Skwentna Airport
    Airport{IataCode{"SKX"}, CountryId{"RU"}, Timezone{5620}}, // Saransk Airport
    Airport{IataCode{"SKY"}, CountryId{"US"}, Timezone{2712}}, // Griffing Sandusky Airport
    Airport{IataCode{"SKZ"}, CountryId{"PK"}, Timezone{4087}}, // Sukkur Airport
    Airport{IataCode{"SLA"}, CountryId{"AR"}, Timezone{1076}}, // Martín Miguel de Güemes International Airport
    Airport{IataCode{"SLB"}, CountryId{"US"}, Timezone{1510}}, // Storm Lake Municipal Airport
    Airport{IataCode{"SLC"}, CountryId{"US"}, Timezone{1667}}, // Salt Lake City International Airport
    Airport{IataCode{"SLD"}, CountryId{"SK"}, Timezone{5213}}, // Sliač Airport
    Airport{IataCode{"SLE"}, CountryId{"US"}, Timezone{2378}}, // McNary Field
    Airport{IataCode{"SLG"}, CountryId{"US"}, Timezone{1510}}, // Smith Field
    Airport{IataCode{"SLH"}, CountryId{"VU"}, Timezone{6301}}, // Vanua Lava Airport
    Airport{IataCode{"SLI"}, CountryId{"ZM"}, Timezone{537}}, // Solwezi Airport
    Airport{IataCode{"SLJ"}, CountryId{"AU"}, Timezone{5087}}, // Solomon Airport
    Airport{IataCode{"SLK"}, CountryId{"US"}, Timezone{2712}}, // Adirondack Regional Airport
    Airport{IataCode{"SLL"}, CountryId{"OM"}, Timezone{4252}}, // Salalah Airport
    Airport{IataCode{"SLM"}, CountryId{"ES"}, Timezone{5549}}, // Salamanca Airport
    Airport{IataCode{"SLN"}, CountryId{"US"}, Timezone{1510}}, // Salina Regional Airport
    Airport{IataCode{"SLO"}, CountryId{"US"}, Timezone{1510}}, // Salem-Leckrone Airport
    Airport{IataCode{"SLP"}, CountryId{"MX"}, Timezone{2588}}, // San Luis Potosí International Airport
    Airport{IataCode{"SLQ"}, CountryId{"US"}, Timezone{814}}, // Sleetmute Airport
    Airport{IataCode{"SLR"}, CountryId{"US"}, Timezone{1510}}, // Sulphur Springs Municipal Airport
    Airport{IataCode{"SLS"}, CountryId{"BG"}, Timezone{5809}}, // Silistra Airfield
    Airport{IataCode{"SLT"}, CountryId{"US"}, Timezone{1667}}, // Harriet Alexander Field
    Airport{IataCode{"SLU"}, CountryId{"LC"}, Timezone{3325}}, // George F. L. Charles Airport
    Airport{IataCode{"SLV"}, CountryId{"IN"}, Timezone{4129}}, // Shimla Airport
    Airport{IataCode{"SLW"}, CountryId{"MX"}, Timezone{2641}}, // Plan de Guadalupe International Airport
    Airport{IataCode{"SLX"}, CountryId{"GB"}, Timezone{1859}}, // Salt Cay Airport
    Airport{IataCode{"SLY"}, CountryId{"RU"}, Timezone{4690}}, // Salekhard Airport
    Airport{IataCode{"SLZ"}, CountryId{"BR"}, Timezone{1789}}, // Marechal Cunha Machado International Airport
    Airport{IataCode{"SMA"}, CountryId{"PT"}, Timezone{4722}}, // Santa Maria Airport
    Airport{IataCode{"SMB"}, CountryId{"CL"}, Timezone{3032}}, // Franco Bianco Airport
    Airport{IataCode{"SMC"}, CountryId{"RS"}, Timezone{5183}}, // Sremska Mitrovica Airport
    Airport{IataCode{"SMD"}, CountryId{"US"}, Timezone{2043}}, // Smith Field
    Airport{IataCode{"SME"}, CountryId{"US"}, Timezone{2712}}, // Lake Cumberland Regional Airport
    Airport{IataCode{"SMF"}, CountryId{"US"}, Timezone{2378}}, // Sacramento International Airport
    Airport{IataCode{"SMG"}, CountryId{"PE"}, Timezone{2365}}, // Santa Maria Airport (Peru)
    Airport{IataCode{"SMI"}, CountryId{"GR"}, Timezone{5169}}, // Samos International Airport
    Airport{IataCode{"SMK"}, CountryId{"US"}, Timezone{2745}}, // St. Michael Airport
    Airport{IataCode{"SML"}, CountryId{"BS"}, Timezone{2697}}, // Stella Maris Airport
    Airport{IataCode{"SMM"}, CountryId{"MY"}, Timezone{4190}}, // Semporna Airport
    Airport{IataCode{"SMN"}, CountryId{"US"}, Timezone{1391}}, // Lemhi County Airport
    Airport{IataCode{"SMO"}, CountryId{"US"}, Timezone{2378}}, // Santa Monica Airport
    Airport{IataCode{"SMP"}, CountryId{"PG"}, Timezone{6686}}, // Stockholm Airport
    Airport{IataCode{"SMQ"}, CountryId{"ID"}, Timezone{4348}}, // Sampit Airport
    Airport{IataCode{"SMR"}, CountryId{"CO"}, Timezone{1376}}, // Simón Bolívar International Airport
    Airport{IataCode{"SMS"}, CountryId{"MG"}, Timezone{6035}}, // Sainte Marie Airport
    Airport{IataCode{"SMT"}, CountryId{"BR"}, Timezone{1579}}, // Sorriso Airport
    Airport{IataCode{"SMV"}, CountryId{"CH"}, Timezone{6021}}, // Samedan Airport
    Airport{IataCode{"SMW"}, CountryId{"EH"}, Timezone{307}}, // Smara Airport
    Airport{IataCode{"SMX"}, CountryId{"US"}, Timezone{2378}}, // Santa Maria Public Airport
    Airport{IataCode{"SMY"}, CountryId{"SN"}, Timezone{243}}, // Simenti Airport
    Airport{IataCode{"SMZ"}, CountryId{"SR"}, Timezone{2912}}, // Stoelmans Eiland Airstrip
    Airport{IataCode{"SNA"}, CountryId{"US"}, Timezone{2378}}, // John Wayne Airport
    Airport{IataCode{"SNB"}, CountryId{"AU"}, Timezone{4978}}, // Snake Bay Airport
    Airport{IataCode{"SNC"}, CountryId{"EC"}, Timezone{1949}}, // General Ulpiano Paez Airport
    Airport{IataCode{"SNE"}, CountryId{"CV"}, Timezone{4771}}, // Preguiça Airport
    Airport{IataCode{"SNF"}, CountryId{"VE"}, Timezone{1463}}, // Sub Teniente Nestor Arias Airport
    Airport{IataCode{"SNG"}, CountryId{"BO"}, Timezone{2350}}, // Cap. Av. Juan Cochamanidis San Airport
    Airport{IataCode{"SNH"}, CountryId{"AU"}, Timezone{4920}}, // Stanthorpe Airport
    Airport{IataCode{"SNI"}, CountryId{"LR"}, Timezone{625}}, // Greenville/Sinoe Airport
    Airport{IataCode{"SNK"}, CountryId{"US"}, Timezone{1510}}, // Winston Field Airport
    Airport{IataCode{"SNL"}, CountryId{"US"}, Timezone{1510}}, // Shawnee Regional Airport
    Airport{IataCode{"SNM"}, CountryId{"BO"}, Timezone{2350}}, // San Ignacio de Moxos Airport
    Airport{IataCode{"SNN"}, CountryId{"IE"}, Timezone{5330}}, // Shannon Airport
    Airport{IataCode{"SNO"}, CountryId{"TH"}, Timezone{3777}}, // Sakon Nakhon Airport
    Airport{IataCode{"SNP"}, CountryId{"US"}, Timezone{2745}}, // St. Paul Island Airport
    Airport{IataCode{"SNR"}, CountryId{"FR"}, Timezone{5646}}, // Saint-Nazaire - Montoir Airport
    Airport{IataCode{"SNS"}, CountryId{"US"}, Timezone{2378}}, // Salinas Municipal Airport
    Airport{IataCode{"SNT"}, CountryId{"CO"}, Timezone{1376}}, // Las Cruces Airport
    Airport{IataCode{"SNU"}, CountryId{"CU"}, Timezone{1980}}, // Abel Santamaría Airport
    Airport{IataCode{"SNV"}, CountryId{"VE"}, Timezone{1463}}, // Santa Elena de Uairén Airport
    Airport{IataCode{"SNW"}, CountryId{"MM"}, Timezone{4678}}, // Thandwe Airport
    Airport{IataCode{"SNX"}, CountryId{"DO"}, Timezone{3194}}, // Sabana de la Mar Airport
    Airport{IataCode{"SNY"}, CountryId{"US"}, Timezone{1667}}, // Sidney Municipal Airport
    Airport{IataCode{"SNZ"}, CountryId{"BR"}, Timezone{3216}}, // Bartolomeu de Gusmão Airport
    Airport{IataCode{"SOB"}, CountryId{"HU"}, Timezone{5264}}, // Sármellék International Airport
    Airport{IataCode{"SOC"}, CountryId{"ID"}, Timezone{4032}}, // Adisumarmo International Airport
    Airport{IataCode{"SOD"}, CountryId{"BR"}, Timezone{3216}}, // Sorocaba Airport
    Airport{IataCode{"SOE"}, CountryId{"CG"}, Timezone{148}}, // Souanké Airport
    Airport{IataCode{"SOF"}, CountryId{"BG"}, Timezone{5809}}, // Sofia Airport
    Airport{IataCode{"SOG"}, CountryId{"NO"}, Timezone{5634}}, // Sogndal Airport, Haukåsen
    Airport{IataCode{"SOJ"}, CountryId{"NO"}, Timezone{5634}}, // Sørkjosen Airport
    Airport{IataCode{"SOK"}, CountryId{"LS"}, Timezone{579}}, // Semonkong Airport
    Airport{IataCode{"SOM"}, CountryId{"VE"}, Timezone{1463}}, // San Tomé Airport
    Airport{IataCode{"SON"}, CountryId{"VU"}, Timezone{6301}}, // Santo-Pekoa International Airport
    Airport{IataCode{"SOO"}, CountryId{"SE"}, Timezone{5822}}, // Söderhamn Airport
    Airport{IataCode{"SOP"}, CountryId{"US"}, Timezone{2712}}, // Moore County Airport
    Airport{IataCode{"SOQ"}, CountryId{"ID"}, Timezone{4032}}, // Sorong Airport
    Airport{IataCode{"SOU"}, CountryId{"GB"}, Timezone{5517}}, // Southampton Airport
    Airport{IataCode{"SOV"}, CountryId{"US"}, Timezone{814}}, // Seldovia Airport
    Airport{IataCode{"SOW"}, CountryId{"US"}, Timezone{2931}}, // Show Low Regional Airport
    Airport{IataCode{"SOX"}, CountryId{"CO"}, Timezone{1376}}, // Alberto Lleras Camargo Airport
    Airport{IataCode{"SOY"}, CountryId{"GB"}, Timezone{5517}}, // Stronsay Airport
    Airport{IataCode{"SPA"}, CountryId{"US"}, Timezone{2712}}, // Spartanburg Downtown Memorial Airport
    Airport{IataCode{"SPB"}, CountryId{"US"}, Timezone{3342}}, // Charlotte Amalie Harbor Seaplane Base
    Airport{IataCode{"SPC"}, CountryId{"ES"}, Timezone{4755}}, // La Palma Airport
    Airport{IataCode{"SPD"}, CountryId{"BD"}, Timezone{3881}}, // Saidpur Airport
    Airport{IataCode{"SPF"}, CountryId{"US"}, Timezone{1667}}, // Black Hills Airport
    Airport{IataCode{"SPG"}, CountryId{"US"}, Timezone{2712}}, // Albert Whitted Airport
    Airport{IataCode{"SPI"}, CountryId{"US"}, Timezone{1510}}, // Abraham Lincoln Capital Airport
    Airport{IataCode{"SPJ"}, CountryId{"GR"}, Timezone{5169}}, // Sparti Airport
    Airport{IataCode{"SPL"}, CountryId{"RS"}, Timezone{5183}}, // Smederevska Palanka Airport
    Airport{IataCode{"SPM"}, CountryId{"DO"}, Timezone{3194}}, // Cueva Las Maravillas Airport
    Airport{IataCode{"SPN"}, CountryId{"US"}, Timezone{6725}}, // Saipan International Airport
    Airport{IataCode{"SPP"}, CountryId{"AO"}, Timezone{505}}, // Menongue Airport
    Airport{IataCode{"SPR"}, CountryId{"BZ"}, Timezone{1322}}, // John Greif II Airport
    Airport{IataCode{"SPS"}, CountryId{"US"}, Timezone{1510}}, // Wichita Falls Municipal Airport
    Airport{IataCode{"SPU"}, CountryId{"HR"}, Timezone{5989}}, // Split Airport
    Airport{IataCode{"SPV"}, CountryId{"RS"}, Timezone{5183}}, // Stara Pazova Airport
    Airport{IataCode{"SPW"}, CountryId{"US"}, Timezone{1510}}, // Spencer Municipal Airport
    Airport{IataCode{"SPX"}, CountryId{}, Timezone{184}}, // Sphinx International Airport
    Airport{IataCode{"SPY"}, CountryId{"CI"}, Timezone{0}}, // San Pédro Airport
    Airport{IataCode{"SPZ"}, CountryId{"US"}, Timezone{1510}}, // Springdale Municipal Airport
    Airport{IataCode{"SQA"}, CountryId{"US"}, Timezone{2378}}, // Santa Ynez Airport
    Airport{IataCode{"SQC"}, CountryId{"AU"}, Timezone{5087}}, // Southern Cross Airport
    Airport{IataCode{"SQD"}, CountryId{"CN"}, Timezone{4456}}, // Shangrao Sanqingshan Airport
    Airport{IataCode{"SQG"}, CountryId{"ID"}, Timezone{4348}}, // Sintang Airport
    Airport{IataCode{"SQH"}, CountryId{"VN"}, Timezone{3964}}, // Nà Sản Airport
    Airport{IataCode{"SQJ"}, CountryId{"CN"}, Timezone{4456}}, // Sanming Shaxian Airport
    Airport{IataCode{"SQL"}, CountryId{"US"}, Timezone{2378}}, // San Carlos Airport
    Airport{IataCode{"SQO"}, CountryId{"SE"}, Timezone{5822}}, // Storuman Airport
    Airport{IataCode{"SQQ"}, CountryId{"LT"}, Timezone{5943}}, // Šiauliai International Airport
    Airport{IataCode{"SQR"}, CountryId{"ID"}, Timezone{4226}}, // Soroako Airport
    Airport{IataCode{"SQS"}, CountryId{"BZ"}, Timezone{1322}}, // Matthew Spain Airport
    Airport{IataCode{"SQV"}, CountryId{"US"}, Timezone{2378}}, // Sequim Valley Airport
    Airport{IataCode{"SQW"}, CountryId{"DK"}, Timezone{5312}}, // Skive Airport
    Airport{IataCode{"SQX"}, CountryId{"BR"}, Timezone{3216}}, // Sao Miguel Do Oeste Airport
    Airport{IataCode{"SQY"}, CountryId{"BR"}, Timezone{3216}}, // São Lourenço do Sul Airport
    Airport{IataCode{"SRA"}, CountryId{"BR"}, Timezone{3216}}, // Santa Rosa Airport
    Airport{IataCode{"SRB"}, CountryId{"BO"}, Timezone{2350}}, // Santa Rosa Airport
    Airport{IataCode{"SRC"}, CountryId{"US"}, Timezone{1510}}, // Searcy Municipal Airport
    Airport{IataCode{"SRD"}, CountryId{"BO"}, Timezone{2350}}, // San Ramón Airport
    Airport{IataCode{"SRE"}, CountryId{"BO"}, Timezone{2350}}, // Alcantari Airport
    Airport{IataCode{"SRG"}, CountryId{"ID"}, Timezone{4032}}, // Achmad Yani International Airport
    Airport{IataCode{"SRH"}, CountryId{"TD"}, Timezone{656}}, // Sarh Airport
    Airport{IataCode{"SRI"}, CountryId{"ID"}, Timezone{4226}}, // Temindung Airport
    Airport{IataCode{"SRJ"}, CountryId{"BO"}, Timezone{2350}}, // Capitán Germán Quiroga Guardia Airport
    Airport{IataCode{"SRN"}, CountryId{"AU"}, Timezone{5011}}, // Strahan Airport
    Airport{IataCode{"SRP"}, CountryId{"NO"}, Timezone{5634}}, // Stord Airport
    Airport{IataCode{"SRQ"}, CountryId{"US"}, Timezone{2712}}, // Sarasota–Bradenton International Airport
    Airport{IataCode{"SRT"}, CountryId{"UG"}, Timezone{401}}, // Soroti Airport
    Airport{IataCode{"SRV"}, CountryId{"US"}, Timezone{814}}, // Stony River Airport
    Airport{IataCode{"SRW"}, CountryId{"US"}, Timezone{2712}}, // Mid-Carolina Regional Airport
    Airport{IataCode{"SRY"}, CountryId{"IR"}, Timezone{4543}}, // Dasht-e Naz Airport
    Airport{IataCode{"SRZ"}, CountryId{"BO"}, Timezone{2350}}, // El Trompillo Airport
    Airport{IataCode{"SSA"}, CountryId{"BR"}, Timezone{1254}}, // Deputado Luís Eduardo Magalhães International Airport
    Airport{IataCode{"SSB"}, CountryId{"US"}, Timezone{3342}}, // Christiansted Harbor Seaplane Base
    Airport{IataCode{"SSD"}, CountryId{"CL"}, Timezone{3177}}, // Víctor Lafón Airport
    Airport{IataCode{"SSE"}, CountryId{"IN"}, Timezone{4129}}, // Solapur Airport
    Airport{IataCode{"SSF"}, CountryId{"US"}, Timezone{1510}}, // Stinson Municipal Airport
    Airport{IataCode{"SSG"}, CountryId{"GQ"}, Timezone{551}}, // Malabo International Airport
    Airport{IataCode{"SSH"}, CountryId{"EG"}, Timezone{184}}, // Sharm el-Sheikh International Airport
    Airport{IataCode{"SSI"}, CountryId{"US"}, Timezone{2712}}, // Malcolm McKinnon Airport
    Airport{IataCode{"SSJ"}, CountryId{"NO"}, Timezone{5634}}, // Sandnessjøen Airport
    Airport{IataCode{"SSL"}, CountryId{"CO"}, Timezone{1376}}, // Santa Rosalía Airport
    Airport{IataCode{"SSM"}, CountryId{"US"}, Timezone{3471}}, // Sault Ste. Marie Municipal Airport
    Airport{IataCode{"SSO"}, CountryId{"BR"}, Timezone{3216}}, // São Lourenço Airport
    Airport{IataCode{"SSQ"}, CountryId{"CA"}, Timezone{3471}}, // La Sarre Airport
    Airport{IataCode{"SSR"}, CountryId{"VU"}, Timezone{6301}}, // Sara Airport
    Airport{IataCode{"SST"}, CountryId{"AR"}, Timezone{883}}, // Santa Teresita Airport
    Airport{IataCode{"SSY"}, CountryId{"AO"}, Timezone{505}}, // Mbanza Congo Airport
    Airport{IataCode{"STA"}, CountryId{"DK"}, Timezone{5312}}, // Stauning Vestjylland Airport
    Airport{IataCode{"STB"}, CountryId{"VE"}, Timezone{1463}}, // Miguel Urdaneta Fernández Airport
    Airport{IataCode{"STC"}, CountryId{"US"}, Timezone{1510}}, // St. Cloud Regional Airport
    Airport{IataCode{"STD"}, CountryId{"VE"}, Timezone{1463}}, // Mayor Buenaventura Vivas Airport
    Airport{IataCode{"STE"}, CountryId{"US"}, Timezone{1510}}, // Stevens Point Municipal Airport
    Airport{IataCode{"STF"}, CountryId{"US"}, Timezone{1510}}, // George M. Bryan Airport
    Airport{IataCode{"STG"}, CountryId{"US"}, Timezone{2745}}, // St. George Airport
    Airport{IataCode{"STH"}, CountryId{"CA"}, Timezone{1715}}, // Strathmore (D.J. Murray) Airport
    Airport{IataCode{"STI"}, CountryId{"DO"}, Timezone{3194}}, // Cibao International Airport
    Airport{IataCode{"STJ"}, CountryId{"US"}, Timezone{1510}}, // Rosecrans Memorial Airport
    Airport{IataCode{"STM"}, CountryId{"BR"}, Timezone{3160}}, // Santarém-Maestro Wilson Fonseca Airport
    Airport{IataCode{"STN"}, CountryId{"GB"}, Timezone{5517}}, // London Stansted Airport
    Airport{IataCode{"STP"}, CountryId{"US"}, Timezone{1510}}, // St. Paul Downtown Airport
    Airport{IataCode{"STQ"}, CountryId{"US"}, Timezone{2712}}, // St. Marys Municipal Airport
    Airport{IataCode{"STR"}, CountryId{"DE"}, Timezone{5199}}, // Stuttgart Airport
    Airport{IataCode{"STT"}, CountryId{"US"}, Timezone{3342}}, // Cyril E. King Airport
    Airport{IataCode{"STV"}, CountryId{"IN"}, Timezone{4129}}, // Surat Airport
    Airport{IataCode{"STW"}, CountryId{"RU"}, Timezone{5620}}, // Stavropol Shpakovskoye Airport
    Airport{IataCode{"STX"}, CountryId{"US"}, Timezone{3342}}, // Henry E. Rohlsen Airport
    Airport{IataCode{"STY"}, CountryId{"UY"}, Timezone{942}}, // Nueva Hespérides International Airport
    Airport{IataCode{"STZ"}, CountryId{"BR"}, Timezone{1579}}, // Santa Terezinha Airport
    Airport{IataCode{"SUA"}, CountryId{"US"}, Timezone{2712}}, // Witham Field
    Airport{IataCode{"SUB"}, CountryId{"ID"}, Timezone{4032}}, // Juanda International Airport
    Airport{IataCode{"SUD"}, CountryId{"US"}, Timezone{1510}}, // Stroud Municipal Airport
    Airport{IataCode{"SUE"}, CountryId{"US"}, Timezone{1510}}, // Door County Cherryland Airport
    Airport{IataCode{"SUF"}, CountryId{"IT"}, Timezone{5702}}, // Lamezia Terme International Airport
    Airport{IataCode{"SUG"}, CountryId{"PH"}, Timezone{4240}}, // Surigao Airport
    Airport{IataCode{"SUH"}, CountryId{"OM"}, Timezone{4252}}, // Sur Airport
    Airport{IataCode{"SUI"}, CountryId{"GE"}, Timezone{4530}}, // Sukhumi Babushara Airport
    Airport{IataCode{"SUJ"}, CountryId{"RO"}, Timezone{5247}}, // Satu Mare International Airport
    Airport{IataCode{"SUK"}, CountryId{"RU"}, Timezone{4665}}, // Sakkyryr Airport
    Airport{IataCode{"SUL"}, CountryId{"PK"}, Timezone{4087}}, // Sui Airport
    Airport{IataCode{"SUM"}, CountryId{"US"}, Timezone{2712}}, // Sumter Airport
    Airport{IataCode{"SUN"}, CountryId{"US"}, Timezone{1391}}, // Friedman Memorial Airport
    Airport{IataCode{"SUO"}, CountryId{"US"}, Timezone{2378}}, // Sunriver Airport
    Airport{IataCode{"SUP"}, CountryId{"ID"}, Timezone{4032}}, // Trunojoyo Airport
    Airport{IataCode{"SUQ"}, CountryId{"EC"}, Timezone{1949}}, // Sucúa Airport
    Airport{IataCode{"SUR"}, CountryId{"CA"}, Timezone{3471}}, // Summer Beaver Airport
    Airport{IataCode{"SUS"}, CountryId{"US"}, Timezone{1510}}, // Spirit of St. Louis Airport
    Airport{IataCode{"SUT"}, CountryId{"TZ"}, Timezone{256}}, // Sumbawanga Airport
    Airport{IataCode{"SUV"}, CountryId{"FJ"}, Timezone{6349}}, // Nausori International Airport
    Airport{IataCode{"SUW"}, CountryId{"US"}, Timezone{1510}}, // Richard I. Bong Airport
    Airport{IataCode{"SUX"}, CountryId{"US"}, Timezone{1510}}, // Sioux Gateway Airport
    Airport{IataCode{"SUY"}, CountryId{"RU"}, Timezone{4665}}, // Suntar Airport
    Airport{IataCode{"SUZ"}, CountryId{"AR"}, Timezone{883}}, // Brigadier Hector Eduardo Ruiz Airport
    Airport{IataCode{"SVA"}, CountryId{"US"}, Timezone{2745}}, // Savoonga Airport
    Airport{IataCode{"SVB"}, CountryId{"MG"}, Timezone{6035}}, // Sambava Airport
    Airport{IataCode{"SVC"}, CountryId{"US"}, Timezone{1667}}, // Grant County Airport
    Airport{IataCode{"SVD"}, CountryId{"VC"}, Timezone{3360}}, // Argyle International Airport
    Airport{IataCode{"SVE"}, CountryId{"US"}, Timezone{2378}}, // Susanville Municipal Airport
    Airport{IataCode{"SVF"}, CountryId{"BJ"}, Timezone{723}}, // Savé Airport
    Airport{IataCode{"SVG"}, CountryId{"NO"}, Timezone{5634}}, // Stavanger Airport
    Airport{IataCode{"SVI"}, CountryId{"CO"}, Timezone{1376}}, // Eduardo Falla Solano Airport
    Airport{IataCode{"SVJ"}, CountryId{"NO"}, Timezone{5634}}, // Svolvær Airport
    Airport{IataCode{"SVK"}, CountryId{"BZ"}, Timezone{1322}}, // Silver Creek Airport
    Airport{IataCode{"SVL"}, CountryId{"FI"}, Timezone{5377}}, // Savonlinna Airport
    Airport{IataCode{"SVO"}, CountryId{"RU"}, Timezone{5620}}, // Sheremetyevo International Airport
    Airport{IataCode{"SVP"}, CountryId{"AO"}, Timezone{505}}, // Kuito Airport
    Airport{IataCode{"SVQ"}, CountryId{"ES"}, Timezone{5549}}, // San Pablo Airport
    Airport{IataCode{"SVS"}, CountryId{"US"}, Timezone{814}}, // Stevens Village Airport
    Airport{IataCode{"SVT"}, CountryId{"BW"}, Timezone{339}}, // Savuti Airport
    Airport{IataCode{"SVU"}, CountryId{"FJ"}, Timezone{6349}}, // Savusavu Airport
    Airport{IataCode{"SVW"}, CountryId{"US"}, Timezone{814}}, // Sparrevohn LRRS Airport
    Airport{IataCode{"SVX"}, CountryId{"RU"}, Timezone{4690}}, // Koltsovo Airport
    Airport{IataCode{"SVZ"}, CountryId{"VE"}, Timezone{1376}}, // Juan Vicente Gómez International Airport
    Airport{IataCode{"SWA"}, CountryId{"CN"}, Timezone{4456}}, // Jieyang Chaoshan Airport
    Airport{IataCode{"SWC"}, CountryId{"AU"}, Timezone{5067}}, // Stawell Airport
    Airport{IataCode{"SWD"}, CountryId{"US"}, Timezone{814}}, // Seward Airport
    Airport{IataCode{"SWE"}, CountryId{"PG"}, Timezone{6686}}, // Samberigi Airport
    Airport{IataCode{"SWF"}, CountryId{"US"}, Timezone{2712}}, // Stewart International Airport
    Airport{IataCode{"SWH"}, CountryId{"AU"}, Timezone{5067}}, // Swan Hill Airport
    Airport{IataCode{"SWI"}, CountryId{"US"}, Timezone{1510}}, // Sherman Municipal Airport
    Airport{IataCode{"SWJ"}, CountryId{"VU"}, Timezone{6301}}, // South West Bay Airport
    Airport{IataCode{"SWO"}, CountryId{"US"}, Timezone{1510}}, // Stillwater Regional Airport
    Airport{IataCode{"SWP"}, CountryId{"NA"}, Timezone{785}}, // Swakopmund Airport
    Airport{IataCode{"SWQ"}, CountryId{"ID"}, Timezone{4226}}, // Brangbiji Airport
    Airport{IataCode{"SWS"}, CountryId{"GB"}, Timezone{5517}}, // Swansea Airport
    Airport{IataCode{"SWT"}, CountryId{"RU"}, Timezone{4579}}, // Strezhevoy Airport
    Airport{IataCode{"SWV"}, CountryId{"RU"}, Timezone{4213}}, // Severo-Evensk Airport
    Airport{IataCode{"SWW"}, CountryId{"US"}, Timezone{1510}}, // Avenger Field
    Airport{IataCode{"SWX"}, CountryId{"BW"}, Timezone{785}}, // Shakawe Airport
    Airport{IataCode{"SWY"}, CountryId{"MY"}, Timezone{4159}}, // Sitiawan Airport
    Airport{IataCode{"SXB"}, CountryId{"FR"}, Timezone{5646}}, // Strasbourg Airport
    Airport{IataCode{"SXE"}, CountryId{"AU"}, Timezone{5067}}, // West Sale Airport
    Airport{IataCode{"SXF"}, CountryId{"DE"}, Timezone{5199}}, // Berlin Schönefeld Airport
    Airport{IataCode{"SXG"}, CountryId{"ZM"}, Timezone{537}}, // Senanga Airport
    Airport{IataCode{"SXI"}, CountryId{"IR"}, Timezone{4543}}, // Sirri Island Airport
    Airport{IataCode{"SXL"}, CountryId{"IE"}, Timezone{5330}}, // Sligo Airport
    Airport{IataCode{"SXM"}, CountryId{"NL"}, Timezone{832}}, // Princess Juliana International Airport
    Airport{IataCode{"SXN"}, CountryId{"BW"}, Timezone{339}}, // Sua Pan Airport
    Airport{IataCode{"SXO"}, CountryId{"BR"}, Timezone{1579}}, // São Félix do Araguaia Airport
    Airport{IataCode{"SXP"}, CountryId{"US"}, Timezone{2745}}, // Sheldon Point Airport
    Airport{IataCode{"SXQ"}, CountryId{"US"}, Timezone{814}}, // Soldotna Airport
    Airport{IataCode{"SXR"}, CountryId{"IN"}, Timezone{4129}}, // Srinagar Airport
    Airport{IataCode{"SXU"}, CountryId{"ET"}, Timezone{28}}, // Soddo Airport
    Airport{IataCode{"SXV"}, CountryId{"IN"}, Timezone{4129}}, // Salem Airport
    Airport{IataCode{"SXX"}, CountryId{"BR"}, Timezone{1308}}, // São Félix do Xingu Airport
    Airport{IataCode{"SXY"}, CountryId{"US"}, Timezone{2712}}, // Sidney Municipal Airport (New York)
    Airport{IataCode{"SXZ"}, CountryId{"TR"}, Timezone{5412}}, // Siirt Airport
    Airport{IataCode{"SYB"}, CountryId{"US"}, Timezone{814}}, // Seal Bay Seaplane Base
    Airport{IataCode{"SYD"}, CountryId{"AU"}, Timezone{5103}}, // Sydney Airport
    Airport{IataCode{"SYE"}, CountryId{"YE"}, Timezone{3634}}, // Saadah Airport
    Airport{IataCode{"SYH"}, CountryId{"NP"}, Timezone{4100}}, // Syangboche Airport
    Airport{IataCode{"SYI"}, CountryId{"US"}, Timezone{1510}}, // Shelbyville Municipal Airport
    Airport{IataCode{"SYJ"}, CountryId{"IR"}, Timezone{4543}}, // Sirjan Airport
    Airport{IataCode{"SYK"}, CountryId{"IS"}, Timezone{4823}}, // Stykkishólmur Airport
    Airport{IataCode{"SYM"}, CountryId{"CN"}, Timezone{4456}}, // Pu'er Simao Airport
    Airport{IataCode{"SYN"}, CountryId{"US"}, Timezone{1510}}, // Stanton Airfield
    Airport{IataCode{"SYO"}, CountryId{"JP"}, Timezone{4568}}, // Shonai Airport
    Airport{IataCode{"SYP"}, CountryId{"PA"}, Timezone{2877}}, // Ruben Cantu Airport
    Airport{IataCode{"SYQ"}, CountryId{"CR"}, Timezone{1544}}, // Tobías Bolaños International Airport
    Airport{IataCode{"SYR"}, CountryId{"US"}, Timezone{2712}}, // Syracuse Hancock International Airport
    Airport{IataCode{"SYS"}, CountryId{"RU"}, Timezone{4665}}, // Saskylakh Airport
    Airport{IataCode{"SYT"}, CountryId{"FR"}, Timezone{5646}}, // Saint-Yan Airport
    Airport{IataCode{"SYU"}, CountryId{"AU"}, Timezone{4920}}, // Warraber Island Airport
    Airport{IataCode{"SYW"}, CountryId{"PK"}, Timezone{4087}}, // Sehwan Sharif Airport
    Airport{IataCode{"SYX"}, CountryId{"CN"}, Timezone{4456}}, // Sanya Phoenix International Airport
    Airport{IataCode{"SYY"}, CountryId{"GB"}, Timezone{5517}}, // Stornoway Airport
    Airport{IataCode{"SYZ"}, CountryId{"IR"}, Timezone{4543}}, // Shiraz International Airport, Iran
    Airport{IataCode{"SZA"}, CountryId{"AO"}, Timezone{505}}, // Soyo Airport
    Airport{IataCode{"SZB"}, CountryId{"MY"}, Timezone{4159}}, // Sultan Abdul Aziz Shah Airport
    Airport{IataCode{"SZE"}, CountryId{"ET"}, Timezone{28}}, // Semera Airport
    Airport{IataCode{"SZF"}, CountryId{"TR"}, Timezone{5412}}, // Samsun-Çarşamba Airport
    Airport{IataCode{"SZG"}, CountryId{"AT"}, Timezone{5199}}, // Salzburg Airport
    Airport{IataCode{"SZI"}, CountryId{"KZ"}, Timezone{3644}}, // Zaysan Airport
    Airport{IataCode{"SZJ"}, CountryId{"CU"}, Timezone{1980}}, // Siguanea Airport
    Airport{IataCode{"SZK"}, CountryId{"ZA"}, Timezone{369}}, // Skukuza Airport
    Airport{IataCode{"SZN"}, CountryId{"US"}, Timezone{2378}}, // Santa Cruz Island Airport
    Airport{IataCode{"SZP"}, CountryId{"US"}, Timezone{2378}}, // Santa Paula Airport
    Airport{IataCode{"SZR"}, CountryId{"BG"}, Timezone{5809}}, // Stara Zagora Airport
    Airport{IataCode{"SZS"}, CountryId{"NZ"}, Timezone{6218}}, // Ryan's Creek Aerodrome
    Airport{IataCode{"SZT"}, CountryId{"MX"}, Timezone{2588}}, // San Cristóbal de las Casas National Airport
    Airport{IataCode{"SZV"}, CountryId{"CN"}, Timezone{4456}}, // Suzhou Guangfu Airport
    Airport{IataCode{"SZW"}, CountryId{"DE"}, Timezone{5199}}, // Parchim International Airport
    Airport{IataCode{"SZX"}, CountryId{"CN"}, Timezone{4456}}, // Shenzhen Bao'an International Airport
    Airport{IataCode{"SZY"}, CountryId{"PL"}, Timezone{5975}}, // Szczytno-Szymany International Airport
    Airport{IataCode{"SZZ"}, CountryId{"PL"}, Timezone{5975}}, // "Solidarity" Szczecin-Goleniów Airport
    Airport{IataCode{"TAB"}, CountryId{"TT"}, Timezone{2970}}, // Arthur Napoleon Raymond Robinson International Airport
    Airport{IataCode{"TAC"}, CountryId{"PH"}, Timezone{4240}}, // Daniel Z. Romualdez Airport
    Airport{IataCode{"TAD"}, CountryId{"US"}, Timezone{1667}}, // Perry Stokes Airport
    Airport{IataCode{"TAE"}, CountryId{"KR"}, Timezone{4445}}, // Daegu International Airport
    Airport{IataCode{"TAF"}, CountryId{"DZ"}, Timezone{47}}, // Oran Tafraoui Airport
    Airport{IataCode{"TAG"}, CountryId{"PH"}, Timezone{4240}}, // Tagbilaran Airport
    Airport{IataCode{"TAH"}, CountryId{"VU"}, Timezone{}}, // Whitegrass Airport
    Airport{IataCode{"TAI"}, CountryId{"YE"}, Timezone{3634}}, // Ta'izz International Airport
    Airport{IataCode{"TAJ"}, CountryId{"PG"}, Timezone{6686}}, // Tadji Airport
    Airport{IataCode{"TAK"}, CountryId{"JP"}, Timezone{4568}}, // Takamatsu Airport
    Airport{IataCode{"TAL"}, CountryId{"US"}, Timezone{814}}, // Ralph M. Calhoun Memorial Airport
    Airport{IataCode{"TAM"}, CountryId{"MX"}, Timezone{2641}}, // General Francisco Javier Mina International Airport
    Airport{IataCode{"TAN"}, CountryId{"US"}, Timezone{2712}}, // Taunton Municipal Airport
    Airport{IataCode{"TAO"}, CountryId{"CN"}, Timezone{4456}}, // Qingdao Liuting International Airport
    Airport{IataCode{"TAP"}, CountryId{"MX"}, Timezone{2588}}, // Tapachula International Airport
    Airport{IataCode{"TAR"}, CountryId{"IT"}, Timezone{5702}}, // Taranto-Grottaglie Airport
    Airport{IataCode{"TAS"}, CountryId{"UZ"}, Timezone{4516}}, // Tashkent International Airport
    Airport{IataCode{"TAT"}, CountryId{"SK"}, Timezone{5213}}, // Poprad-Tatry Airport
    Airport{IataCode{"TAV"}, CountryId{"US"}, Timezone{6621}}, // Tau Airport
    Airport{IataCode{"TAW"}, CountryId{"UY"}, Timezone{2659}}, // Tacuarembó Airport
    Airport{IataCode{"TAY"}, CountryId{"EE"}, Timezone{5839}}, // Tartu Airport
    Airport{IataCode{"TAZ"}, CountryId{"TM"}, Timezone{3702}}, // Daşoguz Airport
    Airport{IataCode{"TBA"}, CountryId{"LK"}, Timezone{3854}}, // SLAF Iranamadu
    Airport{IataCode{"TBB"}, CountryId{"VN"}, Timezone{3964}}, // Tuy Hoa Airport
    Airport{IataCode{"TBC"}, CountryId{"US"}, Timezone{1667}}, // Tuba City Airport
    Airport{IataCode{"TBF"}, CountryId{"KI"}, Timezone{6755}}, // Tabiteuea Nord Aerodrome
    Airport{IataCode{"TBG"}, CountryId{"PG"}, Timezone{4032}}, // Tabubil Airport
    Airport{IataCode{"TBH"}, CountryId{"PH"}, Timezone{4240}}, // Tugdan Airport
    Airport{IataCode{"TBI"}, CountryId{"BS"}, Timezone{2697}}, // New Bight Airport
    Airport{IataCode{"TBJ"}, CountryId{"TN"}, Timezone{772}}, // Tabarka-Ain Draham International Airport
    Airport{IataCode{"TBN"}, CountryId{"US"}, Timezone{1510}}, // Waynesville-St. Robert Regional Airport
    Airport{IataCode{"TBO"}, CountryId{"TZ"}, Timezone{256}}, // Tabora Airport
    Airport{IataCode{"TBP"}, CountryId{"PE"}, Timezone{2365}}, // Cap. FAP Pedro Canga Rodríguez Airport
    Airport{IataCode{"TBR"}, CountryId{"US"}, Timezone{2712}}, // Statesboro-Bulloch County Airport
    Airport{IataCode{"TBS"}, CountryId{"GE"}, Timezone{4530}}, // Tbilisi International Airport
    Airport{IataCode{"TBT"}, CountryId{"BR"}, Timezone{2365}}, // Tabatinga International Airport
    Airport{IataCode{"TBU"}, CountryId{"TO"}, Timezone{6770}}, // Fuaʻamotu International Airport
    Airport{IataCode{"TBW"}, CountryId{"RU"}, Timezone{5620}}, // Tambov Donskoye Airport
    Airport{IataCode{"TBY"}, CountryId{"BW"}, Timezone{339}}, // Tshabong Airport
    Airport{IataCode{"TBZ"}, CountryId{"IR"}, Timezone{4543}}, // Tabriz International Airport
    Airport{IataCode{"TCA"}, CountryId{"AU"}, Timezone{4978}}, // Tennant Creek Airport
    Airport{IataCode{"TCB"}, CountryId{"BS"}, Timezone{2697}}, // Treasure Cay Airport
    Airport{IataCode{"TCC"}, CountryId{"US"}, Timezone{1667}}, // Tucumcari Municipal Airport
    Airport{IataCode{"TCD"}, CountryId{"CO"}, Timezone{1376}}, // Tarapacá Airport
    Airport{IataCode{"TCE"}, CountryId{"RO"}, Timezone{5247}}, // Tulcea Airport
    Airport{IataCode{"TCG"}, CountryId{"CN"}, Timezone{4607}}, // Tacheng Airport
    Airport{IataCode{"TCH"}, CountryId{"GA"}, Timezone{475}}, // Tchibanga Airport
    Airport{IataCode{"TCL"}, CountryId{"US"}, Timezone{1510}}, // Tuscaloosa Regional Airport
    Airport{IataCode{"TCN"}, CountryId{"MX"}, Timezone{2588}}, // Tehuacán Airport
    Airport{IataCode{"TCO"}, CountryId{"CO"}, Timezone{1376}}, // La Florida Airport
    Airport{IataCode{"TCP"}, CountryId{"EG"}, Timezone{184}}, // Taba International Airport
    Airport{IataCode{"TCQ"}, CountryId{"PE"}, Timezone{2365}}, // Crnl. FAP Carlos Ciriani Santa Rosa International Airport
    Airport{IataCode{"TCR"}, CountryId{"IN"}, Timezone{4129}}, // Tuticorin Airport
    Airport{IataCode{"TCS"}, CountryId{"US"}, Timezone{1667}}, // Truth or Consequences Municipal Airport
    Airport{IataCode{"TCT"}, CountryId{"US"}, Timezone{814}}, // Takotna Airport
    Airport{IataCode{"TCW"}, CountryId{"AU"}, Timezone{5103}}, // Tocumwal Airport
    Airport{IataCode{"TCX"}, CountryId{"IR"}, Timezone{4543}}, // Tabas Airport
    Airport{IataCode{"TCY"}, CountryId{"US"}, Timezone{2378}}, // Tracy Municipal Airport
    Airport{IataCode{"TCZ"}, CountryId{"CN"}, Timezone{4456}}, // Tengchong Tuofeng Airport
    Airport{IataCode{"TDA"}, CountryId{"CO"}, Timezone{1376}}, // Trinidad Airport
    Airport{IataCode{"TDD"}, CountryId{"BO"}, Timezone{2350}}, // Teniente Jorge Henrich Arauz Airport
    Airport{IataCode{"TDF"}, CountryId{"US"}, Timezone{2712}}, // Person County Airport
    Airport{IataCode{"TDG"}, CountryId{"PH"}, Timezone{4240}}, // Tandag Airport
    Airport{IataCode{"TDJ"}, CountryId{"DJ"}, Timezone{277}}, // Tadjoura Airport
    Airport{IataCode{"TDL"}, CountryId{"AR"}, Timezone{883}}, // Tandil Airport
    Airport{IataCode{"TDO"}, CountryId{"US"}, Timezone{2378}}, // South Lewis County Airport
    Airport{IataCode{"TDS"}, CountryId{"PG"}, Timezone{6686}}, // Sasereme Airport
    Airport{IataCode{"TDW"}, CountryId{"US"}, Timezone{1510}}, // Tradewind Airport
    Airport{IataCode{"TDX"}, CountryId{"TH"}, Timezone{3777}}, // Trat Airport
    Airport{IataCode{"TDZ"}, CountryId{"US"}, Timezone{2712}}, // Toledo Executive Airport
    Airport{IataCode{"TEA"}, CountryId{"HN"}, Timezone{3401}}, // Tela Airport
    Airport{IataCode{"TEB"}, CountryId{"US"}, Timezone{2712}}, // Teterboro Airport
    Airport{IataCode{"TEC"}, CountryId{"BR"}, Timezone{3216}}, // Telêmaco Borba Airport
    Airport{IataCode{"TED"}, CountryId{"DK"}, Timezone{5312}}, // Thisted Airport
    Airport{IataCode{"TEE"}, CountryId{"DZ"}, Timezone{47}}, // Cheikh Larbi Tébessi Airport
    Airport{IataCode{"TEF"}, CountryId{"AU"}, Timezone{5087}}, // Telfer Airport
    Airport{IataCode{"TEG"}, CountryId{"BF"}, Timezone{704}}, // Tenkodogo Airport
    Airport{IataCode{"TEI"}, CountryId{"IN"}, Timezone{4129}}, // Tezu Airport
    Airport{IataCode{"TEK"}, CountryId{"US"}, Timezone{814}}, // Tatitlek Airport
    Airport{IataCode{"TEL"}, CountryId{"MY"}, Timezone{4190}}, // Telupid Airport
    Airport{IataCode{"TEM"}, CountryId{"AU"}, Timezone{5103}}, // Temora Airport
    Airport{IataCode{"TEN"}, CountryId{"CN"}, Timezone{4456}}, // Tongren Fenghuang Airport
    Airport{IataCode{"TER"}, CountryId{"PT"}, Timezone{4722}}, // Lajes Airport
    Airport{IataCode{"TES"}, CountryId{"ER"}, Timezone{62}}, // Teseney Airport
    Airport{IataCode{"TET"}, CountryId{"MZ"}, Timezone{565}}, // Chingozi Airport
    Airport{IataCode{"TEU"}, CountryId{"NZ"}, Timezone{6218}}, // Manapouri Aerodrome
    Airport{IataCode{"TEV"}, CountryId{"ES"}, Timezone{5549}}, // Teruel Airport
    Airport{IataCode{"TEX"}, CountryId{"US"}, Timezone{1667}}, // Telluride Regional Airport
    Airport{IataCode{"TEY"}, CountryId{"IS"}, Timezone{4823}}, // Thingeyri Airport
    Airport{IataCode{"TEZ"}, CountryId{"IN"}, Timezone{4129}}, // Tezpur Airport
    Airport{IataCode{"TFF"}, CountryId{"BR"}, Timezone{2451}}, // Tefé Airport
    Airport{IataCode{"TFI"}, CountryId{"PG"}, Timezone{6686}}, // Tufi Airport
    Airport{IataCode{"TFL"}, CountryId{"BR"}, Timezone{3216}}, // Teófilo Otoni Airport
    Airport{IataCode{"TFM"}, CountryId{"PG"}, Timezone{6686}}, // Telefomin Airport
    Airport{IataCode{"TFN"}, CountryId{"ES"}, Timezone{4755}}, // Tenerife North Airport
    Airport{IataCode{"TFS"}, CountryId{"ES"}, Timezone{4755}}, // Tenerife South Airport
    Airport{IataCode{"TGC"}, CountryId{"MY"}, Timezone{4190}}, // Tanjung Manis Airport
    Airport{IataCode{"TGD"}, CountryId{"ME"}, Timezone{5659}}, // Podgorica Airport
    Airport{IataCode{"TGE"}, CountryId{"US"}, Timezone{1510}}, // Sharpe Field
    Airport{IataCode{"TGG"}, CountryId{"MY"}, Timezone{4159}}, // Sultan Mahmud Airport
    Airport{IataCode{"TGH"}, CountryId{"VU"}, Timezone{6301}}, // Tongoa Airport
    Airport{IataCode{"TGI"}, CountryId{"PE"}, Timezone{2365}}, // Tingo María Airport
    Airport{IataCode{"TGJ"}, CountryId{"FR"}, Timezone{6606}}, // Tiga Airport
    Airport{IataCode{"TGM"}, CountryId{"RO"}, Timezone{5247}}, // Târgu Mureș International Airport
    Airport{IataCode{"TGN"}, CountryId{"AU"}, Timezone{5067}}, // Latrobe Valley Airport
    Airport{IataCode{"TGO"}, CountryId{"CN"}, Timezone{4456}}, // Tongliao Airport
    Airport{IataCode{"TGP"}, CountryId{"RU"}, Timezone{4142}}, // Podkamennaya Tunguska Airport
    Airport{IataCode{"TGQ"}, CountryId{"BR"}, Timezone{1579}}, // Tangará da Serra Airport
    Airport{IataCode{"TGR"}, CountryId{"DZ"}, Timezone{47}}, // Sidi Mahdi Airport
    Airport{IataCode{"TGS"}, CountryId{"MZ"}, Timezone{565}}, // Chókwè airport
    Airport{IataCode{"TGT"}, CountryId{"TZ"}, Timezone{256}}, // Tanga Airport
    Airport{IataCode{"TGU"}, CountryId{"HN"}, Timezone{3401}}, // Toncontín International Airport
    Airport{IataCode{"TGV"}, CountryId{"BG"}, Timezone{5809}}, // Targovishte Airport
    Airport{IataCode{"TGZ"}, CountryId{"MX"}, Timezone{2588}}, // Ángel Albino Corzo International Airport
    Airport{IataCode{"THA"}, CountryId{"US"}, Timezone{1510}}, // Tullahoma Regional Airport
    Airport{IataCode{"THB"}, CountryId{"LS"}, Timezone{579}}, // Thaba Tseka Airport
    Airport{IataCode{"THC"}, CountryId{"LR"}, Timezone{625}}, // Tchien Airport
    Airport{IataCode{"THD"}, CountryId{"VN"}, Timezone{3964}}, // Tho Xuan Airport
    Airport{IataCode{"THE"}, CountryId{"BR"}, Timezone{1789}}, // Teresina Airport
    Airport{IataCode{"THG"}, CountryId{"AU"}, Timezone{4920}}, // Thangool Airport
    Airport{IataCode{"THI"}, CountryId{"MR"}, Timezone{686}}, // Tichitt Airport
    Airport{IataCode{"THL"}, CountryId{"MM"}, Timezone{4678}}, // Tachilek Airport
    Airport{IataCode{"THM"}, CountryId{"US"}, Timezone{1667}}, // Thompson Falls Airport
    Airport{IataCode{"THN"}, CountryId{"SE"}, Timezone{5822}}, // Trollhättan-Vänersborg Airport
    Airport{IataCode{"THO"}, CountryId{"IS"}, Timezone{4823}}, // Þórshöfn Airport
    Airport{IataCode{"THP"}, CountryId{"US"}, Timezone{1667}}, // Hot Springs County-Thermopolis Municipal Airport
    Airport{IataCode{"THQ"}, CountryId{"CN"}, Timezone{4456}}, // Tianshui Maijishan Airport
    Airport{IataCode{"THR"}, CountryId{"IR"}, Timezone{4543}}, // Mehrabad International Airport
    Airport{IataCode{"THS"}, CountryId{"TH"}, Timezone{3777}}, // Sukhothai Airport
    Airport{IataCode{"THT"}, CountryId{"MR"}, Timezone{686}}, // Tamchakett Airport
    Airport{IataCode{"THV"}, CountryId{"US"}, Timezone{2712}}, // York Airport (Pennsylvania)
    Airport{IataCode{"THX"}, CountryId{"RU"}, Timezone{4142}}, // Turukhansk Airport
    Airport{IataCode{"THZ"}, CountryId{"NE"}, Timezone{672}}, // Tahoua Airport
    Airport{IataCode{"TIA"}, CountryId{"AL"}, Timezone{5854}}, // Tirana International Airport Nënë Tereza
    Airport{IataCode{"TIB"}, CountryId{"CO"}, Timezone{1376}}, // Tibu Airport
    Airport{IataCode{"TIC"}, CountryId{"MH"}, Timezone{6515}}, // Tinak Airport
    Airport{IataCode{"TID"}, CountryId{"DZ"}, Timezone{47}}, // Abdelhafid Boussouf Bou Chekif Airport
    Airport{IataCode{"TIE"}, CountryId{"ET"}, Timezone{28}}, // Tippi Airport
    Airport{IataCode{"TIF"}, CountryId{"SA"}, Timezone{4404}}, // Ta’if Regional Airport
    Airport{IataCode{"TIH"}, CountryId{"FR"}, Timezone{6740}}, // Tikehau Airport
    Airport{IataCode{"TII"}, CountryId{"AF"}, Timezone{4061}}, // Tarin Kowt Airport
    Airport{IataCode{"TIJ"}, CountryId{"MX"}, Timezone{2378}}, // Tijuana International Airport
    Airport{IataCode{"TIL"}, CountryId{"CA"}, Timezone{1715}}, // Cheadle Airport
    Airport{IataCode{"TIM"}, CountryId{"ID"}, Timezone{4032}}, // Timika Airport
    Airport{IataCode{"TIN"}, CountryId{"DZ"}, Timezone{47}}, // Tindouf Airport
    Airport{IataCode{"TIP"}, CountryId{"LY"}, Timezone{757}}, // Tripoli International Airport
    Airport{IataCode{"TIQ"}, CountryId{"US"}, Timezone{}}, // Tinian International Airport
    Airport{IataCode{"TIR"}, CountryId{"IN"}, Timezone{4129}}, // Tirupati Airport
    Airport{IataCode{"TIU"}, CountryId{"NZ"}, Timezone{6218}}, // Richard Pearse Airport
    Airport{IataCode{"TIV"}, CountryId{"ME"}, Timezone{5659}}, // Tivat Airport
    Airport{IataCode{"TIW"}, CountryId{"US"}, Timezone{2378}}, // Tacoma Narrows Airport
    Airport{IataCode{"TIX"}, CountryId{"US"}, Timezone{2712}}, // Space Coast Regional Airport
    Airport{IataCode{"TIY"}, CountryId{"MR"}, Timezone{686}}, // Tidjikja Airport
    Airport{IataCode{"TIZ"}, CountryId{"PG"}, Timezone{6686}}, // Tari Airport
    Airport{IataCode{"TJA"}, CountryId{"BO"}, Timezone{2350}}, // Capitán Oriel Lea Plaza Airport
    Airport{IataCode{"TJB"}, CountryId{"ID"}, Timezone{4032}}, // Sei Bati Airport
    Airport{IataCode{"TJG"}, CountryId{"ID"}, Timezone{4348}}, // Warukin Airport
    Airport{IataCode{"TJH"}, CountryId{"JP"}, Timezone{4568}}, // Tajima Airport
    Airport{IataCode{"TJI"}, CountryId{"HN"}, Timezone{3401}}, // Trujillo Airport
    Airport{IataCode{"TJK"}, CountryId{"TR"}, Timezone{5412}}, // Tokat Airport
    Airport{IataCode{"TJL"}, CountryId{"BR"}, Timezone{1427}}, // Três Lagoas Airport
    Airport{IataCode{"TJM"}, CountryId{"RU"}, Timezone{4690}}, // Roshchino International Airport
    Airport{IataCode{"TJQ"}, CountryId{"ID"}, Timezone{4032}}, // Buluh Tumbang Airport
    Airport{IataCode{"TJS"}, CountryId{"ID"}, Timezone{4226}}, // Tanjung Harapan Airport
    Airport{IataCode{"TJU"}, CountryId{"TJ"}, Timezone{3913}}, // Kulob Airport
    Airport{IataCode{"TKA"}, CountryId{"US"}, Timezone{814}}, // Talkeetna Airport
    Airport{IataCode{"TKC"}, CountryId{"CM"}, Timezone{293}}, // Tiko Airport
    Airport{IataCode{"TKD"}, CountryId{"GH"}, Timezone{15}}, // Takoradi Airport
    Airport{IataCode{"TKE"}, CountryId{"US"}, Timezone{2260}}, // Tenakee Seaplane Base
    Airport{IataCode{"TKF"}, CountryId{"US"}, Timezone{2378}}, // Truckee Tahoe Airport
    Airport{IataCode{"TKG"}, CountryId{"ID"}, Timezone{4032}}, // Radin Inten II Airport
    Airport{IataCode{"TKH"}, CountryId{"TH"}, Timezone{3777}}, // Takhli Airport
    Airport{IataCode{"TKI"}, CountryId{"US"}, Timezone{3255}}, // Tokeen Seaplane Base
    Airport{IataCode{"TKJ"}, CountryId{"US"}, Timezone{814}}, // Tok Junction Airport
    Airport{IataCode{"TKK"}, CountryId{"FM"}, Timezone{6272}}, // Chuuk International Airport
    Airport{IataCode{"TKN"}, CountryId{"JP"}, Timezone{}}, // Tokunoshima Airport
    Airport{IataCode{"TKO"}, CountryId{"LS"}, Timezone{579}}, // Tlokoeng Airport
    Airport{IataCode{"TKQ"}, CountryId{"TZ"}, Timezone{256}}, // Kigoma Airport
    Airport{IataCode{"TKR"}, CountryId{"BD"}, Timezone{}}, // Thakurgaon STOLport
    Airport{IataCode{"TKS"}, CountryId{"JP"}, Timezone{4568}}, // Tokushima Airport
    Airport{IataCode{"TKT"}, CountryId{"TH"}, Timezone{3777}}, // Tak Airport
    Airport{IataCode{"TKU"}, CountryId{"FI"}, Timezone{5377}}, // Turku Airport
    Airport{IataCode{"TKV"}, CountryId{"FR"}, Timezone{6740}}, // Tatakoto Airport
    Airport{IataCode{"TKW"}, CountryId{}, Timezone{}}, // Tekin Airport
    Airport{IataCode{"TKX"}, CountryId{"FR"}, Timezone{6740}}, // Takaroa Airport
    Airport{IataCode{"TKZ"}, CountryId{"NZ"}, Timezone{6218}}, // Tokoroa Airport
    Airport{IataCode{"TLA"}, CountryId{"US"}, Timezone{2745}}, // Teller Airport
    Airport{IataCode{"TLB"}, CountryId{"PK"}, Timezone{4087}}, // Tarbela Dam Airport
    Airport{IataCode{"TLC"}, CountryId{"MX"}, Timezone{2588}}, // Lic. Adolfo López Mateos International Airport
    Airport{IataCode{"TLD"}, CountryId{"BW"}, Timezone{339}}, // Tuli Lodge Airport
    Airport{IataCode{"TLE"}, CountryId{"MG"}, Timezone{6035}}, // Toliara Airport
    Airport{IataCode{"TLF"}, CountryId{"US"}, Timezone{814}}, // Telida Airport
    Airport{IataCode{"TLH"}, CountryId{"US"}, Timezone{2712}}, // Tallahassee International Airport
    Airport{IataCode{"TLI"}, CountryId{"ID"}, Timezone{4226}}, // Sultan Bantilan Airport
    Airport{IataCode{"TLJ"}, CountryId{"US"}, Timezone{814}}, // Tatalina LRRS Airport
    Airport{IataCode{"TLK"}, CountryId{"RU"}, Timezone{4665}}, // Talakan
    Airport{IataCode{"TLL"}, CountryId{"EE"}, Timezone{5839}}, // Tallinn Airport
    Airport{IataCode{"TLM"}, CountryId{"DZ"}, Timezone{47}}, // Zenata – Messali El Hadj Airport
    Airport{IataCode{"TLN"}, CountryId{"FR"}, Timezone{5646}}, // Toulon-Hyères Airport
    Airport{IataCode{"TLQ"}, CountryId{"CN"}, Timezone{4607}}, // Turpan Jiaohe Airport
    Airport{IataCode{"TLR"}, CountryId{"US"}, Timezone{2378}}, // Mefford Field Airport
    Airport{IataCode{"TLS"}, CountryId{"FR"}, Timezone{5646}}, // Toulouse–Blagnac Airport
    Airport{IataCode{"TLT"}, CountryId{"US"}, Timezone{814}}, // Tuluksak Airport
    Airport{IataCode{"TLU"}, CountryId{"CO"}, Timezone{1376}}, // Golfo de Morrosquillo Airport
    Airport{IataCode{"TLV"}, CountryId{"IL"}, Timezone{4046}}, // Ben Gurion Airport
    Airport{IataCode{"TLX"}, CountryId{"CL"}, Timezone{3177}}, // Panguilemo Airport
    Airport{IataCode{"TLZ"}, CountryId{"BR"}, Timezone{3216}}, // Catalão Airport
    Airport{IataCode{"TMA"}, CountryId{"US"}, Timezone{2712}}, // Henry Tift Myers Airport
    Airport{IataCode{"TMB"}, CountryId{"US"}, Timezone{2712}}, // Miami Executive Airport
    Airport{IataCode{"TMC"}, CountryId{"ID"}, Timezone{4226}}, // Tambolaka Airport
    Airport{IataCode{"TMD"}, CountryId{"MR"}, Timezone{686}}, // Timbedra Airport
    Airport{IataCode{"TME"}, CountryId{"CO"}, Timezone{1376}}, // Gabriel Vargas Santos Airport
    Airport{IataCode{"TMF"}, CountryId{"MV"}, Timezone{6142}}, // Thimarafushi Airport
    Airport{IataCode{"TMG"}, CountryId{"MY"}, Timezone{4190}}, // Tommanggong Airport
    Airport{IataCode{"TMI"}, CountryId{"NP"}, Timezone{4100}}, // Tumlingtar Airport
    Airport{IataCode{"TMJ"}, CountryId{"UZ"}, Timezone{}}, // Termez Airport
    Airport{IataCode{"TMK"}, CountryId{"US"}, Timezone{2378}}, // Tillamook Airport
    Airport{IataCode{"TML"}, CountryId{"GH"}, Timezone{15}}, // Tamale Airport
    Airport{IataCode{"TMM"}, CountryId{"MG"}, Timezone{6035}}, // Toamasina Airport
    Airport{IataCode{"TMN"}, CountryId{"KI"}, Timezone{}}, // Tamana Airport
    Airport{IataCode{"TMO"}, CountryId{"VE"}, Timezone{1463}}, // Tumeremo Airport
    Airport{IataCode{"TMP"}, CountryId{"FI"}, Timezone{5377}}, // Tampere-Pirkkala Airport
    Airport{IataCode{"TMQ"}, CountryId{"BF"}, Timezone{704}}, // Tambao Airport
    Airport{IataCode{"TMR"}, CountryId{"DZ"}, Timezone{47}}, // Aguenar–Hadj Bey Akhamok Airport
    Airport{IataCode{"TMS"}, CountryId{"ST"}, Timezone{741}}, // São Tomé International Airport
    Airport{IataCode{"TMT"}, CountryId{"BR"}, Timezone{3160}}, // Porto Trombetas Airport
    Airport{IataCode{"TMU"}, CountryId{"CR"}, Timezone{1544}}, // Tambor Airport
    Airport{IataCode{"TMW"}, CountryId{"AU"}, Timezone{5103}}, // Tamworth Airport
    Airport{IataCode{"TMX"}, CountryId{"DZ"}, Timezone{47}}, // Timimoun Airport
    Airport{IataCode{"TMZ"}, CountryId{"NZ"}, Timezone{6218}}, // Thames Aerodrome
    Airport{IataCode{"TNA"}, CountryId{"CN"}, Timezone{4456}}, // Jinan Yaoqiang International Airport
    Airport{IataCode{"TNC"}, CountryId{"US"}, Timezone{2745}}, // Tin City LRRS Airport
    Airport{IataCode{"TND"}, CountryId{"CU"}, Timezone{1980}}, // Alberto Delgado Airport
    Airport{IataCode{"TNE"}, CountryId{"JP"}, Timezone{4568}}, // New Tanegashima Airport
    Airport{IataCode{"TNF"}, CountryId{"FR"}, Timezone{5646}}, // Toussus-le-Noble Airport
    Airport{IataCode{"TNG"}, CountryId{"MA"}, Timezone{215}}, // Tangier Ibn Battouta Airport
    Airport{IataCode{"TNH"}, CountryId{"CN"}, Timezone{4456}}, // Tonghua Sanyuanpu Airport
    Airport{IataCode{"TNI"}, CountryId{"IN"}, Timezone{4129}}, // Satna Airport
    Airport{IataCode{"TNJ"}, CountryId{"ID"}, Timezone{4032}}, // Raja Haji Fisabilillah Airport
    Airport{IataCode{"TNK"}, CountryId{"US"}, Timezone{2745}}, // Tununak Airport
    Airport{IataCode{"TNL"}, CountryId{"UA"}, Timezone{5461}}, // Ternopil Airport
    Airport{IataCode{"TNN"}, CountryId{"TW"}, Timezone{4504}}, // Tainan Airport
    Airport{IataCode{"TNO"}, CountryId{"CR"}, Timezone{1544}}, // Tamarindo Airport
    Airport{IataCode{"TNP"}, CountryId{"US"}, Timezone{2378}}, // Twentynine Palms Airport
    Airport{IataCode{"TNR"}, CountryId{"MG"}, Timezone{6035}}, // Ivato Airport
    Airport{IataCode{"TNS"}, CountryId{"CA"}, Timezone{3573}}, // Tungsten (Cantung) Airport
    Airport{IataCode{"TNT"}, CountryId{"US"}, Timezone{2712}}, // Dade-Collier Training and Transition Airport
    Airport{IataCode{"TNU"}, CountryId{"US"}, Timezone{1510}}, // Newton Municipal Airport (Iowa)
    Airport{IataCode{"TNW"}, CountryId{"EC"}, Timezone{1949}}, // Jumandy Airport
    Airport{IataCode{"TNX"}, CountryId{"KH"}, Timezone{4332}}, // Stung Treng Airport
    Airport{IataCode{"TOA"}, CountryId{"US"}, Timezone{2378}}, // Zamperini Field
    Airport{IataCode{"TOB"}, CountryId{"LY"}, Timezone{757}}, // Tobruk Airport
    Airport{IataCode{"TOC"}, CountryId{"US"}, Timezone{2712}}, // Toccoa Airport
    Airport{IataCode{"TOD"}, CountryId{"MY"}, Timezone{4159}}, // Tioman Airport
    Airport{IataCode{"TOE"}, CountryId{"TN"}, Timezone{772}}, // Tozeur–Nefta International Airport
    Airport{IataCode{"TOF"}, CountryId{"RU"}, Timezone{4579}}, // Bogashevo Airport
    Airport{IataCode{"TOG"}, CountryId{"US"}, Timezone{814}}, // Togiak Airport
    Airport{IataCode{"TOH"}, CountryId{"VU"}, Timezone{6301}}, // Torres Airport
    Airport{IataCode{"TOI"}, CountryId{"US"}, Timezone{1510}}, // Troy Municipal Airport
    Airport{IataCode{"TOL"}, CountryId{"US"}, Timezone{2712}}, // Toledo Express Airport
    Airport{IataCode{"TOM"}, CountryId{"ML"}, Timezone{76}}, // Timbuktu Airport
    Airport{IataCode{"TOO"}, CountryId{"CR"}, Timezone{1544}}, // San Vito de Java Airport
    Airport{IataCode{"TOP"}, CountryId{"US"}, Timezone{1510}}, // Philip Billard Municipal Airport
    Airport{IataCode{"TOQ"}, CountryId{"CL"}, Timezone{3177}}, // Barriles Airport
    Airport{IataCode{"TOR"}, CountryId{"US"}, Timezone{1667}}, // Torrington Municipal Airport
    Airport{IataCode{"TOS"}, CountryId{"NO"}, Timezone{5634}}, // Tromsø Airport
    Airport{IataCode{"TOT"}, CountryId{"SR"}, Timezone{2912}}, // Totness Airstrip
    Airport{IataCode{"TOU"}, CountryId{"FR"}, Timezone{6606}}, // Touho Airport
    Airport{IataCode{"TOW"}, CountryId{"BR"}, Timezone{3216}}, // Toledo Airport (Brazil)
    Airport{IataCode{"TOY"}, CountryId{"JP"}, Timezone{4568}}, // Toyama Airport
    Airport{IataCode{"TOZ"}, CountryId{"CI"}, Timezone{0}}, // Mahana Airport
    Airport{IataCode{"TPA"}, CountryId{"US"}, Timezone{2712}}, // Tampa International Airport
    Airport{IataCode{"TPC"}, CountryId{"EC"}, Timezone{1949}}, // Tarapoa Airport
    Airport{IataCode{"TPE"}, CountryId{"TW"}, Timezone{4504}}, // Taoyuan International Airport
    Airport{IataCode{"TPF"}, CountryId{"US"}, Timezone{2712}}, // Peter O. Knight Airport
    Airport{IataCode{"TPG"}, CountryId{"MY"}, Timezone{4159}}, // Taiping Airport
    Airport{IataCode{"TPH"}, CountryId{"US"}, Timezone{2378}}, // Tonopah Airport
    Airport{IataCode{"TPI"}, CountryId{"PG"}, Timezone{6686}}, // Tapini Airport
    Airport{IataCode{"TPJ"}, CountryId{"NP"}, Timezone{4100}}, // Taplejung Airport
    Airport{IataCode{"TPL"}, CountryId{"US"}, Timezone{1510}}, // Draughon-Miller Central Texas Regional Airport
    Airport{IataCode{"TPN"}, CountryId{"EC"}, Timezone{1949}}, // Tiputini Airport
    Airport{IataCode{"TPP"}, CountryId{"PE"}, Timezone{2365}}, // Cad. FAP Guillermo del Castillo Paredes Airport
    Airport{IataCode{"TPQ"}, CountryId{"MX"}, Timezone{2519}}, // Amado Nervo International Airport
    Airport{IataCode{"TPR"}, CountryId{"AU"}, Timezone{5087}}, // Tom Price Airport
    Airport{IataCode{"TPS"}, CountryId{"IT"}, Timezone{5702}}, // Vincenzo Florio Airport Trapani-Birgi
    Airport{IataCode{"TPU"}, CountryId{"NP"}, Timezone{4100}}, // Tikapur Airport
    Airport{IataCode{"TQH"}, CountryId{"US"}, Timezone{1510}}, // Tahlequah Municipal Airport
    Airport{IataCode{"TQL"}, CountryId{"AR"}, Timezone{883}}, // Ñanco Lauquen Airport
    Airport{IataCode{"TQN"}, CountryId{"AF"}, Timezone{4061}}, // Taloqan Airport
    Airport{IataCode{"TQP"}, CountryId{"AU"}, Timezone{4920}}, // Trepell Airport
    Airport{IataCode{"TRA"}, CountryId{"JP"}, Timezone{4568}}, // Tarama Airport
    Airport{IataCode{"TRB"}, CountryId{"CO"}, Timezone{1376}}, // Gonzalo Mejia Airport
    Airport{IataCode{"TRC"}, CountryId{"MX"}, Timezone{2641}}, // Francisco Sarabia International Airport
    Airport{IataCode{"TRD"}, CountryId{"NO"}, Timezone{5634}}, // Trondheim Airport
    Airport{IataCode{"TRE"}, CountryId{"GB"}, Timezone{5517}}, // Tiree Airport
    Airport{IataCode{"TRF"}, CountryId{"NO"}, Timezone{5634}}, // Sandefjord Airport, Torp
    Airport{IataCode{"TRG"}, CountryId{"NZ"}, Timezone{6218}}, // Tauranga Airport
    Airport{IataCode{"TRH"}, CountryId{"US"}, Timezone{2378}}, // Trona Airport
    Airport{IataCode{"TRI"}, CountryId{"US"}, Timezone{2712}}, // Tri-Cities Regional Airport
    Airport{IataCode{"TRK"}, CountryId{"ID"}, Timezone{4226}}, // Juwata International Airport
    Airport{IataCode{"TRL"}, CountryId{"US"}, Timezone{1510}}, // Terrell Municipal Airport
    Airport{IataCode{"TRM"}, CountryId{"US"}, Timezone{2378}}, // Jacqueline Cochran Regional Airport
    Airport{IataCode{"TRN"}, CountryId{"IT"}, Timezone{5702}}, // Turin Airport
    Airport{IataCode{"TRO"}, CountryId{"AU"}, Timezone{5103}}, // Taree Airport
    Airport{IataCode{"TRQ"}, CountryId{"BR"}, Timezone{3141}}, // Tarauacá Airport
    Airport{IataCode{"TRS"}, CountryId{"IT"}, Timezone{5702}}, // Trieste – Friuli Venezia Giulia Airport
    Airport{IataCode{"TRU"}, CountryId{"PE"}, Timezone{2365}}, // Cap. FAP Carlos Martínez de Pinillos International Airport
    Airport{IataCode{"TRV"}, CountryId{"IN"}, Timezone{4129}}, // Trivandrum International Airport
    Airport{IataCode{"TRW"}, CountryId{"KI"}, Timezone{6755}}, // Bonriki International Airport
    Airport{IataCode{"TRX"}, CountryId{"US"}, Timezone{1510}}, // Trenton Municipal Airport
    Airport{IataCode{"TRY"}, CountryId{"UG"}, Timezone{401}}, // Tororo Airport
    Airport{IataCode{"TRZ"}, CountryId{"IN"}, Timezone{4129}}, // Tiruchirapalli Airport
    Airport{IataCode{"TSB"}, CountryId{"NA"}, Timezone{785}}, // Tsumeb Airport
    Airport{IataCode{"TSC"}, CountryId{"EC"}, Timezone{1949}}, // Taisha Airport
    Airport{IataCode{"TSE"}, CountryId{"KZ"}, Timezone{3644}}, // Astana International Airport
    Airport{IataCode{"TSF"}, CountryId{"IT"}, Timezone{5702}}, // Treviso Airport
    Airport{IataCode{"TSG"}, CountryId{"US"}, Timezone{814}}, // Tanacross Airport
    Airport{IataCode{"TSH"}, CountryId{"CD"}, Timezone{519}}, // Tshikapa Airport
    Airport{IataCode{"TSJ"}, CountryId{"JP"}, Timezone{}}, // Tsushima Airport
    Airport{IataCode{"TSL"}, CountryId{"MX"}, Timezone{2588}}, // Tamuín National Airport
    Airport{IataCode{"TSM"}, CountryId{"US"}, Timezone{1667}}, // Taos Regional Airport
    Airport{IataCode{"TSN"}, CountryId{"CN"}, Timezone{4456}}, // Tianjin Binhai International Airport
    Airport{IataCode{"TSO"}, CountryId{"GB"}, Timezone{5517}}, // Tresco Heliport
    Airport{IataCode{"TSP"}, CountryId{"US"}, Timezone{2378}}, // Tehachapi Municipal Airport
    Airport{IataCode{"TSQ"}, CountryId{"BR"}, Timezone{3216}}, // Torres Airport
    Airport{IataCode{"TSR"}, CountryId{"RO"}, Timezone{5247}}, // Traian Vuia International Airport
    Airport{IataCode{"TSS"}, CountryId{"US"}, Timezone{2712}}, // East 34th Street Heliport
    Airport{IataCode{"TST"}, CountryId{"TH"}, Timezone{3777}}, // Trang Airport
    Airport{IataCode{"TSU"}, CountryId{"KI"}, Timezone{6755}}, // Tabiteuea Süd Airport
    Airport{IataCode{"TSV"}, CountryId{"AU"}, Timezone{4920}}, // Townsville Airport
    Airport{IataCode{"TSY"}, CountryId{"ID"}, Timezone{4032}}, // Tasikmalaya Airport
    Airport{IataCode{"TTA"}, CountryId{"MA"}, Timezone{215}}, // Tan Tan Airport
    Airport{IataCode{"TTB"}, CountryId{"IT"}, Timezone{5702}}, // Tortolì-Arbatax Airport
    Airport{IataCode{"TTC"}, CountryId{"CL"}, Timezone{3177}}, // Las Breas Airport
    Airport{IataCode{"TTD"}, CountryId{"US"}, Timezone{2378}}, // Portland-Troutdale Airport
    Airport{IataCode{"TTE"}, CountryId{"ID"}, Timezone{4032}}, // Babullah Airport
    Airport{IataCode{"TTG"}, CountryId{"AR"}, Timezone{1076}}, // Tartagal "General Enrique Mosconi" Airport
    Airport{IataCode{"TTJ"}, CountryId{"JP"}, Timezone{4568}}, // Tottori Airport
    Airport{IataCode{"TTM"}, CountryId{"CO"}, Timezone{1376}}, // Tablón de Tamará Airport
    Airport{IataCode{"TTN"}, CountryId{"US"}, Timezone{2712}}, // Trenton-Mercer Airport
    Airport{IataCode{"TTO"}, CountryId{"US"}, Timezone{1510}}, // Britton Municipal Airport
    Airport{IataCode{"TTQ"}, CountryId{"CR"}, Timezone{1544}}, // Tortuguero Airport
    Airport{IataCode{"TTR"}, CountryId{"ID"}, Timezone{4226}}, // Pongtiku Airport
    Airport{IataCode{"TTS"}, CountryId{"MG"}, Timezone{6035}}, // Tsaratanana Airport
    Airport{IataCode{"TTT"}, CountryId{"TW"}, Timezone{4504}}, // Taitung Airport
    Airport{IataCode{"TTU"}, CountryId{"MA"}, Timezone{215}}, // Sania Ramel Airport
    Airport{IataCode{"TUA"}, CountryId{"EC"}, Timezone{1376}}, // Teniente Coronel Luis a Mantilla International Airport
    Airport{IataCode{"TUB"}, CountryId{"FR"}, Timezone{6740}}, // Tubuai – Mataura Airport
    Airport{IataCode{"TUC"}, CountryId{"AR"}, Timezone{1154}}, // Teniente Benjamín Matienzo International Airport
    Airport{IataCode{"TUD"}, CountryId{"SN"}, Timezone{243}}, // Tambacounda Airport
    Airport{IataCode{"TUF"}, CountryId{"FR"}, Timezone{5646}}, // Tours Val de Loire Airport
    Airport{IataCode{"TUG"}, CountryId{"PH"}, Timezone{4240}}, // Tuguegarao Airport
    Airport{IataCode{"TUI"}, CountryId{"SA"}, Timezone{4404}}, // Turaif Domestic Airport
    Airport{IataCode{"TUJ"}, CountryId{"ET"}, Timezone{28}}, // Tum Airport
    Airport{IataCode{"TUK"}, CountryId{"PK"}, Timezone{4087}}, // Turbat International Airport
    Airport{IataCode{"TUL"}, CountryId{"US"}, Timezone{1510}}, // Tulsa International Airport
    Airport{IataCode{"TUM"}, CountryId{"AU"}, Timezone{5103}}, // Tumut Airport
    Airport{IataCode{"TUN"}, CountryId{"TN"}, Timezone{772}}, // Tunis–Carthage International Airport
    Airport{IataCode{"TUO"}, CountryId{"NZ"}, Timezone{6218}}, // Taupo Airport
    Airport{IataCode{"TUP"}, CountryId{"US"}, Timezone{1510}}, // Tupelo Regional Airport
    Airport{IataCode{"TUQ"}, CountryId{"BF"}, Timezone{704}}, // Tougan Airport
    Airport{IataCode{"TUR"}, CountryId{"BR"}, Timezone{1308}}, // Tucuruí Airport
    Airport{IataCode{"TUS"}, CountryId{"US"}, Timezone{2931}}, // Tucson International Airport
    Airport{IataCode{"TUU"}, CountryId{"SA"}, Timezone{4404}}, // Tabuk Regional Airport
    Airport{IataCode{"TUV"}, CountryId{"VE"}, Timezone{1463}}, // San Rafael Airport (Venezuela)
    Airport{IataCode{"TUX"}, CountryId{"CA"}, Timezone{1646}}, // Tumbler Ridge Airport
    Airport{IataCode{"TVA"}, CountryId{"MG"}, Timezone{6035}}, // Morafenobe Airport
    Airport{IataCode{"TVC"}, CountryId{"US"}, Timezone{1682}}, // Cherry Capital Airport
    Airport{IataCode{"TVF"}, CountryId{"US"}, Timezone{1510}}, // Thief River Falls Regional Airport
    Airport{IataCode{"TVI"}, CountryId{"US"}, Timezone{2712}}, // Thomasville Regional Airport
    Airport{IataCode{"TVK"}, CountryId{"US"}, Timezone{1510}}, // Centerville Municipal Airport
    Airport{IataCode{"TVL"}, CountryId{"US"}, Timezone{2378}}, // Lake Tahoe Airport
    Airport{IataCode{"TVS"}, CountryId{"CN"}, Timezone{4456}}, // Tangshan Sannühe Airport
    Airport{IataCode{"TVU"}, CountryId{"FJ"}, Timezone{6349}}, // Matei Airport
    Airport{IataCode{"TVY"}, CountryId{"MM"}, Timezone{4678}}, // Dawei Airport
    Airport{IataCode{"TWA"}, CountryId{"US"}, Timezone{814}}, // Twin Hills Airport
    Airport{IataCode{"TWB"}, CountryId{"AU"}, Timezone{4920}}, // Toowoomba Airport
    Airport{IataCode{"TWD"}, CountryId{"US"}, Timezone{2378}}, // Jefferson County International Airport
    Airport{IataCode{"TWF"}, CountryId{"US"}, Timezone{1391}}, // Magic Valley Regional Airport
    Airport{IataCode{"TWU"}, CountryId{"MY"}, Timezone{4190}}, // Tawau Airport
    Airport{IataCode{"TWZ"}, CountryId{"NZ"}, Timezone{6218}}, // Pukaki Airport
    Airport{IataCode{"TXE"}, CountryId{"ID"}, Timezone{4032}}, // Takengon Rembele Airport
    Airport{IataCode{"TXF"}, CountryId{"BR"}, Timezone{1254}}, // Teixeira de Freitas Airport
    Airport{IataCode{"TXG"}, CountryId{"TW"}, Timezone{4504}}, // Taichung Aero Airport
    Airport{IataCode{"TXK"}, CountryId{"US"}, Timezone{1510}}, // Texarkana Regional Airport
    Airport{IataCode{"TXL"}, CountryId{"DE"}, Timezone{5199}}, // Berlin Tegel Airport
    Airport{IataCode{"TXN"}, CountryId{"CN"}, Timezone{4456}}, // Huangshan Tunxi International Airport
    Airport{IataCode{"TXU"}, CountryId{"CI"}, Timezone{0}}, // Tabou Airport
    Airport{IataCode{"TYA"}, CountryId{"RU"}, Timezone{5620}}, // Klokovo
    Airport{IataCode{"TYB"}, CountryId{"AU"}, Timezone{5103}}, // Tibooburra Airport
    Airport{IataCode{"TYD"}, CountryId{"RU"}, Timezone{4665}}, // Tynda Airport
    Airport{IataCode{"TYE"}, CountryId{"US"}, Timezone{814}}, // Tyonek Airport
    Airport{IataCode{"TYF"}, CountryId{"SE"}, Timezone{5822}}, // Torsby Airport
    Airport{IataCode{"TYL"}, CountryId{"PE"}, Timezone{2365}}, // Cap. FAP Víctor Montes Arias Airport
    Airport{IataCode{"TYM"}, CountryId{"BS"}, Timezone{2697}}, // Staniel Cay Airport
    Airport{IataCode{"TYN"}, CountryId{"CN"}, Timezone{4456}}, // Taiyuan Wusu International Airport
    Airport{IataCode{"TYQ"}, CountryId{"US"}, Timezone{2043}}, // Indianapolis Executive Airport
    Airport{IataCode{"TYR"}, CountryId{"US"}, Timezone{1510}}, // Tyler Pounds Regional Airport
    Airport{IataCode{"TYS"}, CountryId{"US"}, Timezone{2712}}, // McGhee Tyson Airport
    Airport{IataCode{"TYT"}, CountryId{"UY"}, Timezone{2659}}, // Treinta y Tres Airport
    Airport{IataCode{"TYZ"}, CountryId{"US"}, Timezone{2931}}, // Taylor Airport
    Airport{IataCode{"TZA"}, CountryId{"BZ"}, Timezone{1322}}, // Belize City Municipal Airport
    Airport{IataCode{"TZC"}, CountryId{"US"}, Timezone{1682}}, // Tuscola Area Airport
    Airport{IataCode{"TZL"}, CountryId{"BA"}, Timezone{5746}}, // Tuzla International Airport
    Airport{IataCode{"TZR"}, CountryId{"US"}, Timezone{2712}}, // Bolton Field
    Airport{IataCode{"TZX"}, CountryId{"TR"}, Timezone{5412}}, // Trabzon Airport
    Airport{IataCode{"UAC"}, CountryId{"MX"}, Timezone{3455}}, // San Luis Río Colorado Airport
    Airport{IataCode{"UAI"}, CountryId{"TL"}, Timezone{3902}}, // Suai Airport
    Airport{IataCode{"UAK"}, CountryId{"GL"}, Timezone{1825}}, // Narsarsuaq Airport
    Airport{IataCode{"UAL"}, CountryId{"AO"}, Timezone{505}}, // Luau Airport
    Airport{IataCode{"UAO"}, CountryId{"US"}, Timezone{2378}}, // Aurora State Airport
    Airport{IataCode{"UAQ"}, CountryId{"AR"}, Timezone{1100}}, // Domingo Faustino Sarmiento Airport
    Airport{IataCode{"UAR"}, CountryId{"MA"}, Timezone{215}}, // Bouarfa Airport
    Airport{IataCode{"UAS"}, CountryId{"KE"}, Timezone{641}}, // Samburu Airport
    Airport{IataCode{"UAX"}, CountryId{"GT"}, Timezone{1913}}, // Uaxactun Airport
    Airport{IataCode{"UBA"}, CountryId{"BR"}, Timezone{3216}}, // Uberaba Airport
    Airport{IataCode{"UBB"}, CountryId{"AU"}, Timezone{4920}}, // Mabuiag Island Airport
    Airport{IataCode{"UBI"}, CountryId{"PG"}, Timezone{6235}}, // Buin Airport
    Airport{IataCode{"UBJ"}, CountryId{"JP"}, Timezone{4568}}, // Yamaguchi Ube Airport
    Airport{IataCode{"UBP"}, CountryId{"TH"}, Timezone{3777}}, // Ubon Ratchathani Airport
    Airport{IataCode{"UBS"}, CountryId{"US"}, Timezone{1510}}, // Columbus-Lowndes County Airport
    Airport{IataCode{"UBT"}, CountryId{"BR"}, Timezone{3216}}, // Ubatuba Airport
    Airport{IataCode{"UCA"}, CountryId{"US"}, Timezone{2712}}, // Oneida County Airport
    Airport{IataCode{"UCB"}, CountryId{"CN"}, Timezone{4456}}, // Ulanqab Airport
    Airport{IataCode{"UCC"}, CountryId{"US"}, Timezone{2378}}, // Yucca Airstrip
    Airport{IataCode{"UCK"}, CountryId{"UA"}, Timezone{5461}}, // Lutsk Airport
    Airport{IataCode{"UCN"}, CountryId{"LR"}, Timezone{}}, // Buchanan Airport
    Airport{IataCode{"UCP"}, CountryId{"US"}, Timezone{2712}}, // New Castle Municipal Airport
    Airport{IataCode{"UCT"}, CountryId{"RU"}, Timezone{5620}}, // Ukhta Airport
    Airport{IataCode{"UCY"}, CountryId{"US"}, Timezone{1510}}, // Everett-Stewart Regional Airport
    Airport{IataCode{"UCZ"}, CountryId{"PE"}, Timezone{2365}}, // Uchiza Airport
    Airport{IataCode{"UDD"}, CountryId{"US"}, Timezone{2378}}, // Bermuda Dunes Airport
    Airport{IataCode{"UDG"}, CountryId{"US"}, Timezone{2712}}, // Darlington County Jetport
    Airport{IataCode{"UDI"}, CountryId{"BR"}, Timezone{3216}}, // Uberlândia Airport
    Airport{IataCode{"UDJ"}, CountryId{"UA"}, Timezone{5213}}, // Uzhhorod International Airport
    Airport{IataCode{"UDL"}, CountryId{"ID"}, Timezone{4226}}, // Buol Airport
    Airport{IataCode{"UDN"}, CountryId{"IT"}, Timezone{5702}}, // Udine-Campoformido Airport
    Airport{IataCode{"UDR"}, CountryId{"IN"}, Timezone{4129}}, // Udaipur Airport
    Airport{IataCode{"UEE"}, CountryId{"AU"}, Timezone{5011}}, // Queenstown Airport
    Airport{IataCode{"UEL"}, CountryId{"MZ"}, Timezone{565}}, // Quelimane Airport
    Airport{IataCode{"UEO"}, CountryId{"JP"}, Timezone{}}, // Kumejima Airport
    Airport{IataCode{"UES"}, CountryId{"US"}, Timezone{1510}}, // Waukesha County Airport
    Airport{IataCode{"UET"}, CountryId{"PK"}, Timezone{4087}}, // Quetta International Airport
    Airport{IataCode{"UFA"}, CountryId{"RU"}, Timezone{4690}}, // Ufa International Airport
    Airport{IataCode{"UGA"}, CountryId{"MN"}, Timezone{4590}}, // Bulgan Airport
    Airport{IataCode{"UGB"}, CountryId{"US"}, Timezone{814}}, // Ugashik Bay Airport
    Airport{IataCode{"UGC"}, CountryId{"UZ"}, Timezone{4430}}, // Urgench International Airport
    Airport{IataCode{"UGN"}, CountryId{"US"}, Timezone{1510}}, // Waukegan Regional Airport
    Airport{IataCode{"UGO"}, CountryId{"AO"}, Timezone{505}}, // Uíge Airport
    Airport{IataCode{"UGS"}, CountryId{"US"}, Timezone{814}}, // Ugashik Airport
    Airport{IataCode{"UHE"}, CountryId{"CZ"}, Timezone{5676}}, // Kunovice Airport
    Airport{IataCode{"UIB"}, CountryId{"CO"}, Timezone{1376}}, // El Caraño Airport
    Airport{IataCode{"UIH"}, CountryId{"VN"}, Timezone{3964}}, // Phu Cat Airport
    Airport{IataCode{"UII"}, CountryId{"HN"}, Timezone{3401}}, // Útila Airport
    Airport{IataCode{"UIK"}, CountryId{"RU"}, Timezone{4006}}, // Ust-Ilimsk Airport
    Airport{IataCode{"UIL"}, CountryId{"US"}, Timezone{2378}}, // Quillayute Airport
    Airport{IataCode{"UIN"}, CountryId{"US"}, Timezone{1510}}, // Quincy Regional Airport
    Airport{IataCode{"UIO"}, CountryId{"EC"}, Timezone{1949}}, // Mariscal Sucre International Airport
    Airport{IataCode{"UIP"}, CountryId{"FR"}, Timezone{5646}}, // Quimper – Cornouaille Airport
    Airport{IataCode{"UIR"}, CountryId{"AU"}, Timezone{5103}}, // Quirindi Airport
    Airport{IataCode{"UIT"}, CountryId{"MH"}, Timezone{6515}}, // Jaluit Airport
    Airport{IataCode{"UJE"}, CountryId{"MH"}, Timezone{6515}}, // Ujae Airport
    Airport{IataCode{"UJU"}, CountryId{"KP"}, Timezone{4456}}, // Uiju Airfield
    Airport{IataCode{"UKA"}, CountryId{"KE"}, Timezone{641}}, // Ukunda Airport
    Airport{IataCode{"UKB"}, CountryId{"JP"}, Timezone{4568}}, // Kobe Airport
    Airport{IataCode{"UKG"}, CountryId{"RU"}, Timezone{4648}}, // Ust-Kuyga Airport
    Airport{IataCode{"UKI"}, CountryId{"US"}, Timezone{2378}}, // Ukiah Municipal Airport
    Airport{IataCode{"UKK"}, CountryId{"KZ"}, Timezone{3644}}, // Oskemen Airport
    Airport{IataCode{"UKL"}, CountryId{"US"}, Timezone{1510}}, // Coffey County Airport
    Airport{IataCode{"UKR"}, CountryId{"YE"}, Timezone{3634}}, // Mukeiras Airport
    Airport{IataCode{"UKS"}, CountryId{"RU"}, Timezone{5777}}, // Sevastopol International Airport
    Airport{IataCode{"UKT"}, CountryId{"US"}, Timezone{2712}}, // Quakertown Airport
    Airport{IataCode{"UKX"}, CountryId{"RU"}, Timezone{4006}}, // Ust-Kut Airport
    Airport{IataCode{"ULA"}, CountryId{"AR"}, Timezone{1045}}, // Capitán José Daniel Vazquez Airport
    Airport{IataCode{"ULB"}, CountryId{"VU"}, Timezone{6301}}, // Ulei Airport
    Airport{IataCode{"ULC"}, CountryId{"CL"}, Timezone{3177}}, // Los Cerrillos Airport
    Airport{IataCode{"ULD"}, CountryId{"ZA"}, Timezone{369}}, // Prince M. Buthelezi Airport
    Airport{IataCode{"ULG"}, CountryId{"MN"}, Timezone{3996}}, // Ölgii Airport
    Airport{IataCode{"ULH"}, CountryId{"SA"}, Timezone{4404}}, // Prince Abdul Majeed bin Abdul Aziz Domestic Airport
    Airport{IataCode{"ULK"}, CountryId{"RU"}, Timezone{4665}}, // Lensk Airport
    Airport{IataCode{"ULM"}, CountryId{"US"}, Timezone{1510}}, // New Ulm Municipal Airport
    Airport{IataCode{"ULN"}, CountryId{"MN"}, Timezone{4590}}, // Chinggis Khaan International Airport
    Airport{IataCode{"ULO"}, CountryId{"MN"}, Timezone{3996}}, // Ulaangom Airport
    Airport{IataCode{"ULP"}, CountryId{"AU"}, Timezone{4920}}, // Quilpie Airport
    Airport{IataCode{"ULQ"}, CountryId{"CO"}, Timezone{1376}}, // Heriberto Gíl Martínez Airport
    Airport{IataCode{"ULU"}, CountryId{"UG"}, Timezone{401}}, // Gulu Airport
    Airport{IataCode{"ULV"}, CountryId{"RU"}, Timezone{5868}}, // Ulyanovsk Baratayevka Airport
    Airport{IataCode{"ULY"}, CountryId{"RU"}, Timezone{5868}}, // Ulyanovsk Vostochny Airport
    Airport{IataCode{"ULZ"}, CountryId{"MN"}, Timezone{3996}}, // Donoi Airport
    Airport{IataCode{"UMA"}, CountryId{"CU"}, Timezone{1980}}, // Punta de Maisi Airport
    Airport{IataCode{"UME"}, CountryId{"SE"}, Timezone{5822}}, // Umeå Airport
    Airport{IataCode{"UMM"}, CountryId{"US"}, Timezone{814}}, // Summit Airport
    Airport{IataCode{"UMP"}, CountryId{"US"}, Timezone{2043}}, // Indianapolis Metropolitan Airport
    Airport{IataCode{"UMS"}, CountryId{"RU"}, Timezone{4115}}, // Ust-Maya Airport
    Airport{IataCode{"UMT"}, CountryId{"US"}, Timezone{814}}, // Umiat Airport
    Airport{IataCode{"UMU"}, CountryId{"BR"}, Timezone{3216}}, // Umuarama Airport
    Airport{IataCode{"UMY"}, CountryId{"UA"}, Timezone{5461}}, // Sumy Airport
    Airport{IataCode{"UNA"}, CountryId{"BR"}, Timezone{1254}}, // Una-Comandatuba Airport
    Airport{IataCode{"UND"}, CountryId{"AF"}, Timezone{4061}}, // Kunduz Airport
    Airport{IataCode{"UNE"}, CountryId{"LS"}, Timezone{579}}, // Qacha's Nek Airport
    Airport{IataCode{"UNG"}, CountryId{"PG"}, Timezone{}}, // Kiunga Airport
    Airport{IataCode{"UNI"}, CountryId{"VC"}, Timezone{3360}}, // Union Island Airport
    Airport{IataCode{"UNK"}, CountryId{"US"}, Timezone{814}}, // Unalakleet Airport
    Airport{IataCode{"UNN"}, CountryId{"TH"}, Timezone{3777}}, // Ranong Airport
    Airport{IataCode{"UNO"}, CountryId{"US"}, Timezone{1510}}, // West Plains Regional Airport
    Airport{IataCode{"UNU"}, CountryId{"US"}, Timezone{1510}}, // Dodge County Airport
    Airport{IataCode{"UOS"}, CountryId{"US"}, Timezone{1510}}, // Franklin County Airport
    Airport{IataCode{"UOX"}, CountryId{"US"}, Timezone{1510}}, // University-Oxford Airport
    Airport{IataCode{"UPB"}, CountryId{"CU"}, Timezone{1980}}, // Playa Baracoa Airport
    Airport{IataCode{"UPG"}, CountryId{"ID"}, Timezone{4226}}, // Sultan Hasanuddin International Airport
    Airport{IataCode{"UPL"}, CountryId{"CR"}, Timezone{1544}}, // Upala Airport
    Airport{IataCode{"UPN"}, CountryId{"MX"}, Timezone{2588}}, // Lic. y Gen. Ignacio López Rayón International Airport
    Airport{IataCode{"UPP"}, CountryId{"US"}, Timezone{6446}}, // Upolu Airport
    Airport{IataCode{"URA"}, CountryId{"KZ"}, Timezone{4322}}, // Oral Ak Zhol Airport
    Airport{IataCode{"URB"}, CountryId{"BR"}, Timezone{1427}}, // Urubupunga Airport
    Airport{IataCode{"URC"}, CountryId{"CN"}, Timezone{4607}}, // Ürümqi Diwopu International Airport
    Airport{IataCode{"URE"}, CountryId{"EE"}, Timezone{5839}}, // Kuressaare Airport
    Airport{IataCode{"URG"}, CountryId{"BR"}, Timezone{942}}, // Ruben Berta International Airport
    Airport{IataCode{"URJ"}, CountryId{"RU"}, Timezone{4690}}, // Uray Airport
    Airport{IataCode{"URO"}, CountryId{"FR"}, Timezone{5646}}, // Rouen Airport
    Airport{IataCode{"URR"}, CountryId{"CO"}, Timezone{1376}}, // Urrao Airport
    Airport{IataCode{"URS"}, CountryId{"RU"}, Timezone{5620}}, // Kursk Vostochny Airport
    Airport{IataCode{"URT"}, CountryId{"TH"}, Timezone{3777}}, // Surat Thani Airport
    Airport{IataCode{"URY"}, CountryId{"SA"}, Timezone{4404}}, // Gurayat Domestic Airport
    Airport{IataCode{"USH"}, CountryId{"AR"}, Timezone{1180}}, // Ushuaia – Malvinas Argentinas International Airport
    Airport{IataCode{"USI"}, CountryId{"GY"}, Timezone{1463}}, // Mabaruma Airport
    Airport{IataCode{"USK"}, CountryId{"RU"}, Timezone{5620}}, // Usinsk Airport
    Airport{IataCode{"USM"}, CountryId{"TH"}, Timezone{3777}}, // Samui Airport
    Airport{IataCode{"USN"}, CountryId{"KR"}, Timezone{4445}}, // Ulsan Airport
    Airport{IataCode{"USQ"}, CountryId{"TR"}, Timezone{5412}}, // Uşak Airport
    Airport{IataCode{"USR"}, CountryId{"RU"}, Timezone{4619}}, // Ust-Nera Airport
    Airport{IataCode{"USS"}, CountryId{"CU"}, Timezone{1980}}, // Sancti Spíritus Airport
    Airport{IataCode{"UST"}, CountryId{"US"}, Timezone{2712}}, // Northeast Florida Regional Airport
    Airport{IataCode{"USU"}, CountryId{"PH"}, Timezone{4240}}, // Francisco B. Reyes Airport
    Airport{IataCode{"UTA"}, CountryId{"ZW"}, Timezone{355}}, // Mutare Airport
    Airport{IataCode{"UTB"}, CountryId{"AU"}, Timezone{4920}}, // Muttaburra Airport
    Airport{IataCode{"UTG"}, CountryId{"LS"}, Timezone{579}}, // Quthing Airport
    Airport{IataCode{"UTH"}, CountryId{"TH"}, Timezone{3777}}, // Udon Thani International Airport
    Airport{IataCode{"UTK"}, CountryId{"MH"}, Timezone{6515}}, // Utirik Airport
    Airport{IataCode{"UTM"}, CountryId{"US"}, Timezone{1510}}, // Tunica Municipal Airport
    Airport{IataCode{"UTN"}, CountryId{"ZA"}, Timezone{369}}, // Upington Airport
    Airport{IataCode{"UTO"}, CountryId{"US"}, Timezone{814}}, // Indian Mountain LRRS Airport
    Airport{IataCode{"UTP"}, CountryId{"TH"}, Timezone{3777}}, // U-Tapao International Airport
    Airport{IataCode{"UTS"}, CountryId{"RU"}, Timezone{5620}}, // Ust-Tsylma Airport
    Airport{IataCode{"UTT"}, CountryId{"ZA"}, Timezone{369}}, // Mthatha Airport
    Airport{IataCode{"UUA"}, CountryId{"RU"}, Timezone{5620}}, // Bugulma Airport
    Airport{IataCode{"UUD"}, CountryId{"RU"}, Timezone{4006}}, // Ulan-Ude Airport
    Airport{IataCode{"UUK"}, CountryId{"US"}, Timezone{814}}, // Ugnu-Kuparuk Airport
    Airport{IataCode{"UUN"}, CountryId{"MN"}, Timezone{3838}}, // Baruun-Urt Airport
    Airport{IataCode{"UUS"}, CountryId{"RU"}, Timezone{4416}}, // Yuzhno-Sakhalinsk Airport
    Airport{IataCode{"UVA"}, CountryId{"US"}, Timezone{1510}}, // Garner Field
    Airport{IataCode{"UVE"}, CountryId{"FR"}, Timezone{6606}}, // Ouvéa Airport
    Airport{IataCode{"UVF"}, CountryId{"LC"}, Timezone{3325}}, // Hewanorra International Airport
    Airport{IataCode{"UVL"}, CountryId{"EG"}, Timezone{184}}, // El Kharga Airport
    Airport{IataCode{"UWA"}, CountryId{"US"}, Timezone{2712}}, // Ware Airport
    Airport{IataCode{"UXL"}, CountryId{"US"}, Timezone{1510}}, // Southland Field
    Airport{IataCode{"UYF"}, CountryId{"US"}, Timezone{2712}}, // Madison County Airport
    Airport{IataCode{"UYL"}, CountryId{"SD"}, Timezone{432}}, // Nyala Airport
    Airport{IataCode{"UYN"}, CountryId{"CN"}, Timezone{4456}}, // Yulin Yuyang Airport
    Airport{IataCode{"UYU"}, CountryId{"BO"}, Timezone{2350}}, // Joya Andina Airport
    Airport{IataCode{"UZC"}, CountryId{"RS"}, Timezone{5183}}, // Ponikve Airport
    Airport{IataCode{"UZM"}, CountryId{"CA"}, Timezone{1405}}, // Hope Bay Aerodrome
    Airport{IataCode{"UZU"}, CountryId{"AR"}, Timezone{942}}, // Curuzú Cuatiá Airport
    Airport{IataCode{"VAA"}, CountryId{"FI"}, Timezone{5377}}, // Vaasa Airport
    Airport{IataCode{"VAF"}, CountryId{"FR"}, Timezone{5646}}, // Valence-Chabeuil Airport
    Airport{IataCode{"VAG"}, CountryId{"BR"}, Timezone{3216}}, // Varginha Airport
    Airport{IataCode{"VAH"}, CountryId{"BO"}, Timezone{2350}}, // Vallegrande Airport
    Airport{IataCode{"VAI"}, CountryId{"PG"}, Timezone{6686}}, // Vanimo Airport
    Airport{IataCode{"VAK"}, CountryId{"US"}, Timezone{2745}}, // Chevak Airport
    Airport{IataCode{"VAL"}, CountryId{"BR"}, Timezone{1254}}, // Valenca Airport
    Airport{IataCode{"VAM"}, CountryId{"MV"}, Timezone{6142}}, // Maamigili Airport
    Airport{IataCode{"VAN"}, CountryId{"TR"}, Timezone{5412}}, // Van Ferit Melen Airport
    Airport{IataCode{"VAO"}, CountryId{"SB"}, Timezone{6413}}, // Suavanao Airport
    Airport{IataCode{"VAP"}, CountryId{"CL"}, Timezone{3177}}, // Viñamar Airport
    Airport{IataCode{"VAR"}, CountryId{"BG"}, Timezone{5809}}, // Varna Airport
    Airport{IataCode{"VAS"}, CountryId{"TR"}, Timezone{5412}}, // Sivas Airport
    Airport{IataCode{"VAT"}, CountryId{"MG"}, Timezone{}}, // Vatomandry Airport
    Airport{IataCode{"VAV"}, CountryId{"TO"}, Timezone{6770}}, // Vava'u International Airport
    Airport{IataCode{"VAW"}, CountryId{"NO"}, Timezone{5634}}, // Vardø Airport, Svartnes
    Airport{IataCode{"VBC"}, CountryId{"MM"}, Timezone{4678}}, // Mandalay Chanmyathazi Airport
    Airport{IataCode{"VBS"}, CountryId{"IT"}, Timezone{5702}}, // Brescia Airport
    Airport{IataCode{"VBT"}, CountryId{"US"}, Timezone{1510}}, // Bentonville Municipal Airport
    Airport{IataCode{"VBV"}, CountryId{"FJ"}, Timezone{6349}}, // Vanuabalavu Airport
    Airport{IataCode{"VBY"}, CountryId{"SE"}, Timezone{5822}}, // Visby Airport
    Airport{IataCode{"VCA"}, CountryId{"VN"}, Timezone{3964}}, // Can Tho International Airport
    Airport{IataCode{"VCB"}, CountryId{"US"}, Timezone{2378}}, // Nut Tree Airport
    Airport{IataCode{"VCC"}, CountryId{"CM"}, Timezone{293}}, // Limbe Airport
    Airport{IataCode{"VCD"}, CountryId{"AU"}, Timezone{4978}}, // Victoria River Downs Airport
    Airport{IataCode{"VCE"}, CountryId{"IT"}, Timezone{5702}}, // Venice Marco Polo Airport
    Airport{IataCode{"VCF"}, CountryId{"AR"}, Timezone{1076}}, // Valcheta Airport
    Airport{IataCode{"VCH"}, CountryId{"UY"}, Timezone{2659}}, // Vichadero Airport
    Airport{IataCode{"VCL"}, CountryId{"VN"}, Timezone{3964}}, // Chu Lai International Airport
    Airport{IataCode{"VCP"}, CountryId{"BR"}, Timezone{3216}}, // Viracopos International Airport
    Airport{IataCode{"VCR"}, CountryId{"VE"}, Timezone{1463}}, // Carora Airport
    Airport{IataCode{"VCS"}, CountryId{"VN"}, Timezone{3964}}, // Con Dao Airport
    Airport{IataCode{"VCT"}, CountryId{"US"}, Timezone{1510}}, // Victoria Regional Airport
    Airport{IataCode{"VCV"}, CountryId{"US"}, Timezone{2378}}, // Southern California Logistics Airport
    Airport{IataCode{"VDA"}, CountryId{"IL"}, Timezone{}}, // Ovda Airport
    Airport{IataCode{"VDB"}, CountryId{"NO"}, Timezone{5634}}, // Fagernes Airport, Leirin
    Airport{IataCode{"VDC"}, CountryId{"BR"}, Timezone{1254}}, // Vitória da Conquista Airport
    Airport{IataCode{"VDE"}, CountryId{"ES"}, Timezone{4755}}, // El Hierro Airport
    Airport{IataCode{"VDF"}, CountryId{"US"}, Timezone{2712}}, // Tampa Executive Airport
    Airport{IataCode{"VDH"}, CountryId{"VN"}, Timezone{3964}}, // Dong Hoi Airport
    Airport{IataCode{"VDI"}, CountryId{"US"}, Timezone{2712}}, // Vidalia Regional Airport
    Airport{IataCode{"VDM"}, CountryId{"AR"}, Timezone{914}}, // Gobernador Edgardo Castello Airport
    Airport{IataCode{"VDP"}, CountryId{"VE"}, Timezone{1463}}, // Valle de la Pascua Airport
    Airport{IataCode{"VDR"}, CountryId{"AR"}, Timezone{942}}, // Villa Dolores Airport
    Airport{IataCode{"VDS"}, CountryId{"NO"}, Timezone{5634}}, // Vadsø Airport
    Airport{IataCode{"VDY"}, CountryId{"IN"}, Timezone{4129}}, // Vidyanagar Airport
    Airport{IataCode{"VDZ"}, CountryId{"US"}, Timezone{814}}, // Valdez Airport
    Airport{IataCode{"VEE"}, CountryId{"US"}, Timezone{814}}, // Venetie Airport
    Airport{IataCode{"VEL"}, CountryId{"US"}, Timezone{1667}}, // Vernal Regional Airport
    Airport{IataCode{"VER"}, CountryId{"MX"}, Timezone{2588}}, // General Heriberto Jara International Airport
    Airport{IataCode{"VES"}, CountryId{"US"}, Timezone{2712}}, // Darke County Airport
    Airport{IataCode{"VEY"}, CountryId{"IS"}, Timezone{4823}}, // Vestmannaeyjar Airport
    Airport{IataCode{"VFA"}, CountryId{"ZW"}, Timezone{355}}, // Victoria Falls Airport
    Airport{IataCode{"VGA"}, CountryId{"IN"}, Timezone{4129}}, // Vijayawada Airport
    Airport{IataCode{"VGC"}, CountryId{"US"}, Timezone{2712}}, // Hamilton Municipal Airport
    Airport{IataCode{"VGD"}, CountryId{"RU"}, Timezone{5620}}, // Vologda Airport
    Airport{IataCode{"VGN"}, CountryId{"PH"}, Timezone{}}, // Mindoro Airport
    Airport{IataCode{"VGO"}, CountryId{"ES"}, Timezone{5549}}, // Vigo Airport
    Airport{IataCode{"VGT"}, CountryId{"US"}, Timezone{2378}}, // North Las Vegas Airport
    Airport{IataCode{"VGZ"}, CountryId{"CO"}, Timezone{1376}}, // Villa Garzón Airport
    Airport{IataCode{"VHC"}, CountryId{"AO"}, Timezone{505}}, // Saurimo Airport
    Airport{IataCode{"VHM"}, CountryId{"SE"}, Timezone{5822}}, // Vilhelmina Airport
    Airport{IataCode{"VHN"}, CountryId{"US"}, Timezone{1510}}, // Culberson County Airport
    Airport{IataCode{"VHV"}, CountryId{"RU"}, Timezone{4665}}, // Verkhnevilyuysk Airport
    Airport{IataCode{"VHY"}, CountryId{"FR"}, Timezone{5646}}, // Vichy – Charmeil Airport
    Airport{IataCode{"VHZ"}, CountryId{"FR"}, Timezone{6740}}, // Vahitahi Airport
    Airport{IataCode{"VIA"}, CountryId{"BR"}, Timezone{3216}}, // Videira Airport
    Airport{IataCode{"VIB"}, CountryId{"MX"}, Timezone{2519}}, // Villa Constitución Airport
    Airport{IataCode{"VID"}, CountryId{"BG"}, Timezone{5809}}, // Vidin Airfield
    Airport{IataCode{"VIE"}, CountryId{"AT"}, Timezone{5929}}, // Wien-Schwechat Airport
    Airport{IataCode{"VIG"}, CountryId{"VE"}, Timezone{1463}}, // Juan Pablo Pérez Alfonso Airport
    Airport{IataCode{"VIH"}, CountryId{"US"}, Timezone{1510}}, // Rolla National Airport
    Airport{IataCode{"VII"}, CountryId{"VN"}, Timezone{3964}}, // Vinh Airport
    Airport{IataCode{"VIJ"}, CountryId{"VG"}, Timezone{3487}}, // Virgin Gorda Airport
    Airport{IataCode{"VIL"}, CountryId{"MA"}, Timezone{307}}, // Dakhla Airport
    Airport{IataCode{"VIN"}, CountryId{"UA"}, Timezone{5461}}, // Havryshivka Vinnytsia International Airport
    Airport{IataCode{"VIR"}, CountryId{"ZA"}, Timezone{369}}, // Virginia Airport
    Airport{IataCode{"VIS"}, CountryId{"US"}, Timezone{2378}}, // Visalia Municipal Airport
    Airport{IataCode{"VIT"}, CountryId{"ES"}, Timezone{5549}}, // Vitoria Airport
    Airport{IataCode{"VIV"}, CountryId{"PG"}, Timezone{6686}}, // Vivigani Airfield
    Airport{IataCode{"VIX"}, CountryId{"BR"}, Timezone{3216}}, // Eurico de Aguiar Salles Airport
    Airport{IataCode{"VJI"}, CountryId{"US"}, Timezone{2712}}, // Virginia Highlands Airport
    Airport{IataCode{"VKG"}, CountryId{"VN"}, Timezone{3964}}, // Rach Gia Airport
    Airport{IataCode{"VKO"}, CountryId{"RU"}, Timezone{5620}}, // Vnukovo International Airport
    Airport{IataCode{"VKT"}, CountryId{"RU"}, Timezone{5620}}, // Vorkuta Airport
    Airport{IataCode{"VKX"}, CountryId{"US"}, Timezone{2712}}, // Potomac Airfield
    Airport{IataCode{"VLC"}, CountryId{"ES"}, Timezone{5549}}, // Manises Airport
    Airport{IataCode{"VLD"}, CountryId{"US"}, Timezone{2712}}, // Valdosta Regional Airport
    Airport{IataCode{"VLE"}, CountryId{"US"}, Timezone{2931}}, // Valle Airport
    Airport{IataCode{"VLG"}, CountryId{"AR"}, Timezone{883}}, // Villa Gesell Airport
    Airport{IataCode{"VLI"}, CountryId{"VU"}, Timezone{6301}}, // Bauerfield International Airport
    Airport{IataCode{"VLL"}, CountryId{"ES"}, Timezone{5549}}, // Valladolid Airport
    Airport{IataCode{"VLM"}, CountryId{"BO"}, Timezone{2350}}, // Lieutenant Colonel Rafael Pabón Airport
    Airport{IataCode{"VLN"}, CountryId{"VE"}, Timezone{1463}}, // Arturo Michelena International Airport
    Airport{IataCode{"VLP"}, CountryId{"BR"}, Timezone{1579}}, // Vila Rica Airport
    Airport{IataCode{"VLR"}, CountryId{"CL"}, Timezone{3177}}, // Vallenar Airport
    Airport{IataCode{"VLS"}, CountryId{"VU"}, Timezone{6301}}, // Valesdir Airport
    Airport{IataCode{"VLU"}, CountryId{"RU"}, Timezone{5620}}, // Velikiye Luki Airport
    Airport{IataCode{"VLV"}, CountryId{"VE"}, Timezone{1463}}, // Dr. Antonio Nicolás Briceño Airport
    Airport{IataCode{"VLY"}, CountryId{"GB"}, Timezone{5517}}, // Anglesey Airport
    Airport{IataCode{"VME"}, CountryId{"AR"}, Timezone{1127}}, // Villa Reynolds Airport
    Airport{IataCode{"VMI"}, CountryId{"PY"}, Timezone{1220}}, // Dr. Juan Plate Airport
    Airport{IataCode{"VMR"}, CountryId{"AR"}, Timezone{942}}, // Presidente Néstor Kirchner Airport
    Airport{IataCode{"VMU"}, CountryId{"PG"}, Timezone{6686}}, // Baimuru Airport
    Airport{IataCode{"VNC"}, CountryId{"US"}, Timezone{2712}}, // Venice Municipal Airport
    Airport{IataCode{"VND"}, CountryId{"MG"}, Timezone{}}, // Vangaindrano Airport
    Airport{IataCode{"VNE"}, CountryId{"FR"}, Timezone{5646}}, // Meucon Airport
    Airport{IataCode{"VNO"}, CountryId{"LT"}, Timezone{5943}}, // Vilnius Airport
    Airport{IataCode{"VNS"}, CountryId{"IN"}, Timezone{4129}}, // Lal Bahadur Shastri Airport
    Airport{IataCode{"VNT"}, CountryId{"LV"}, Timezone{5690}}, // Ventspils International Airport
    Airport{IataCode{"VNX"}, CountryId{"MZ"}, Timezone{565}}, // Vilankulo Airport
    Airport{IataCode{"VNY"}, CountryId{"US"}, Timezone{2378}}, // Van Nuys Airport
    Airport{IataCode{"VOD"}, CountryId{"CZ"}, Timezone{5676}}, // Vodochody Airport
    Airport{IataCode{"VOG"}, CountryId{"RU"}, Timezone{5958}}, // Volgograd International Airport
    Airport{IataCode{"VOH"}, CountryId{"MG"}, Timezone{6035}}, // Vohemar Airport
    Airport{IataCode{"VOI"}, CountryId{"LR"}, Timezone{625}}, // Voinjama Airport
    Airport{IataCode{"VOL"}, CountryId{"GR"}, Timezone{5169}}, // Nea Anchialos National Airport
    Airport{IataCode{"VOT"}, CountryId{"BR"}, Timezone{3216}}, // Votuporanga Airport
    Airport{IataCode{"VOZ"}, CountryId{"RU"}, Timezone{5620}}, // Voronezh International Airport
    Airport{IataCode{"VPA"}, CountryId{"CL"}, Timezone{3177}}, // Rodelillo Airfield
    Airport{IataCode{"VPC"}, CountryId{"US"}, Timezone{2712}}, // Cartersville Airport
    Airport{IataCode{"VPE"}, CountryId{"AO"}, Timezone{505}}, // Ondjiva Pereira Airport
    Airport{IataCode{"VPN"}, CountryId{"IS"}, Timezone{4823}}, // Vopnafjörður Airport
    Airport{IataCode{"VPS"}, CountryId{"US"}, Timezone{1510}}, // Destin–Fort Walton Beach Airport
    Airport{IataCode{"VPY"}, CountryId{"MZ"}, Timezone{565}}, // Chimoio Airport
    Airport{IataCode{"VPZ"}, CountryId{"US"}, Timezone{1510}}, // Porter County Regional Airport
    Airport{IataCode{"VQQ"}, CountryId{"US"}, Timezone{2712}}, // Cecil Airport
    Airport{IataCode{"VQS"}, CountryId{"US"}, Timezone{3012}}, // Antonio Rivera Rodríguez Airport
    Airport{IataCode{"VRA"}, CountryId{"CU"}, Timezone{1980}}, // Juan Gualberto Gómez Airport
    Airport{IataCode{"VRB"}, CountryId{"US"}, Timezone{2712}}, // Vero Beach Municipal Airport
    Airport{IataCode{"VRC"}, CountryId{"PH"}, Timezone{4240}}, // Virac Airport
    Airport{IataCode{"VRE"}, CountryId{"ZA"}, Timezone{369}}, // Vredendal Airport
    Airport{IataCode{"VRI"}, CountryId{"RU"}, Timezone{5620}}, // Varandey Airport
    Airport{IataCode{"VRL"}, CountryId{"PT"}, Timezone{5486}}, // Vila Real Airport
    Airport{IataCode{"VRN"}, CountryId{"IT"}, Timezone{5702}}, // Verona Villafranca Airport
    Airport{IataCode{"VRO"}, CountryId{"CU"}, Timezone{1980}}, // Kawama Airport
    Airport{IataCode{"VRU"}, CountryId{"ZA"}, Timezone{369}}, // Vryburg Airport
    Airport{IataCode{"VRY"}, CountryId{"NO"}, Timezone{5634}}, // Værøy Airport
    Airport{IataCode{"VSA"}, CountryId{"MX"}, Timezone{2588}}, // Carlos Rovirosa Pérez International Airport
    Airport{IataCode{"VSE"}, CountryId{"PT"}, Timezone{5486}}, // Viseu Airport
    Airport{IataCode{"VSF"}, CountryId{"US"}, Timezone{2712}}, // Hartness State Airport
    Airport{IataCode{"VSG"}, CountryId{"UA"}, Timezone{5461}}, // Luhansk International Airport
    Airport{IataCode{"VSK"}, CountryId{"US"}, Timezone{2378}}, // Vista Field
    Airport{IataCode{"VTB"}, CountryId{"BY"}, Timezone{5593}}, // Vitebsk Vostochny Airport
    Airport{IataCode{"VTE"}, CountryId{"LA"}, Timezone{4633}}, // Wattay International Airport
    Airport{IataCode{"VTG"}, CountryId{"VN"}, Timezone{3964}}, // Vung Tau Airport
    Airport{IataCode{"VTN"}, CountryId{"US"}, Timezone{1510}}, // Miller Field
    Airport{IataCode{"VTR"}, CountryId{"IT"}, Timezone{5702}}, // Rome Viterbo Airport
    Airport{IataCode{"VTU"}, CountryId{"CU"}, Timezone{1980}}, // Hermanos Ameijeiras Airport
    Airport{IataCode{"VTZ"}, CountryId{"IN"}, Timezone{4129}}, // Visakhapatnam Airport
    Airport{IataCode{"VUE"}, CountryId{"AU"}, Timezone{4978}}, // Yuendumu Airport
    Airport{IataCode{"VUJ"}, CountryId{"US"}, Timezone{2712}}, // Stanly County Airport
    Airport{IataCode{"VUO"}, CountryId{"US"}, Timezone{2378}}, // Pearson Field
    Airport{IataCode{"VUP"}, CountryId{"CO"}, Timezone{1376}}, // Alfonso López Pumarejo Airport
    Airport{IataCode{"VUS"}, CountryId{"RU"}, Timezone{5620}}, // Veliky Ustyug Airport
    Airport{IataCode{"VVC"}, CountryId{"CO"}, Timezone{1376}}, // La Vanguardia Airport
    Airport{IataCode{"VVI"}, CountryId{"BO"}, Timezone{2350}}, // Viru Viru International Airport
    Airport{IataCode{"VVO"}, CountryId{"RU"}, Timezone{4648}}, // Vladivostok International Airport
    Airport{IataCode{"VVZ"}, CountryId{"DZ"}, Timezone{47}}, // Takhamalt Airport
    Airport{IataCode{"VXC"}, CountryId{"MZ"}, Timezone{565}}, // Lichinga Airport
    Airport{IataCode{"VXE"}, CountryId{"CV"}, Timezone{4771}}, // São Pedro Airport
    Airport{IataCode{"VXO"}, CountryId{"SE"}, Timezone{5822}}, // Växjö Småland Airport
    Airport{IataCode{"VYI"}, CountryId{"RU"}, Timezone{4665}}, // Vilyuisk Airport
    Airport{IataCode{"VYS"}, CountryId{"US"}, Timezone{1510}}, // Illinois Valley Regional Airport
    Airport{IataCode{"WAA"}, CountryId{"US"}, Timezone{2745}}, // Wales Airport
    Airport{IataCode{"WAE"}, CountryId{"SA"}, Timezone{4404}}, // Wadi al-Dawasir Domestic Airport
    Airport{IataCode{"WAG"}, CountryId{"NZ"}, Timezone{6218}}, // Wanganui Airport
    Airport{IataCode{"WAH"}, CountryId{"US"}, Timezone{1510}}, // Harry Stern Airport
    Airport{IataCode{"WAI"}, CountryId{"MG"}, Timezone{6035}}, // Ambalabe Airport
    Airport{IataCode{"WAK"}, CountryId{"MG"}, Timezone{6035}}, // Ankazoabo Airport
    Airport{IataCode{"WAM"}, CountryId{"MG"}, Timezone{6035}}, // Ambatondrazaka Airport
    Airport{IataCode{"WAP"}, CountryId{"CL"}, Timezone{3177}}, // Alto Palena Airport
    Airport{IataCode{"WAQ"}, CountryId{"MG"}, Timezone{6035}}, // Antsalova Airport
    Airport{IataCode{"WAT"}, CountryId{"IE"}, Timezone{5330}}, // Waterford Airport
    Airport{IataCode{"WAW"}, CountryId{"PL"}, Timezone{5975}}, // Warsaw Chopin Airport
    Airport{IataCode{"WAX"}, CountryId{"LY"}, Timezone{757}}, // Zuwarah Airport
    Airport{IataCode{"WAY"}, CountryId{"US"}, Timezone{2712}}, // Greene County Airport
    Airport{IataCode{"WAZ"}, CountryId{"AU"}, Timezone{4920}}, // Warwick Airport
    Airport{IataCode{"WBB"}, CountryId{"US"}, Timezone{2745}}, // Stebbins Airport
    Airport{IataCode{"WBM"}, CountryId{"PG"}, Timezone{6686}}, // Wapenamanda Airport
    Airport{IataCode{"WBO"}, CountryId{"MG"}, Timezone{}}, // Antsoa Airport
    Airport{IataCode{"WBQ"}, CountryId{"US"}, Timezone{814}}, // Beaver Airport
    Airport{IataCode{"WBR"}, CountryId{"US"}, Timezone{1682}}, // Roben-Hood Airport
    Airport{IataCode{"WBU"}, CountryId{"US"}, Timezone{1667}}, // Boulder Municipal Airport
    Airport{IataCode{"WBW"}, CountryId{"US"}, Timezone{2712}}, // Wilkes-Barre Wyoming Valley Airport
    Airport{IataCode{"WCA"}, CountryId{"CL"}, Timezone{3177}}, // Gamboa Airport
    Airport{IataCode{"WCH"}, CountryId{"CL"}, Timezone{}}, // Nuevo Chaitén Airport
    Airport{IataCode{"WCR"}, CountryId{"US"}, Timezone{814}}, // Chandalar Lake Airport
    Airport{IataCode{"WDG"}, CountryId{"US"}, Timezone{1510}}, // Enid Woodring Regional Airport
    Airport{IataCode{"WDH"}, CountryId{"NA"}, Timezone{785}}, // Windhoek Hosea Kutako International Airport
    Airport{IataCode{"WDR"}, CountryId{"US"}, Timezone{2712}}, // Barrow County Airport
    Airport{IataCode{"WDS"}, CountryId{"CN"}, Timezone{4456}}, // Shiyan Wudangshan Airport
    Airport{IataCode{"WEF"}, CountryId{"CN"}, Timezone{4456}}, // Weifang Airport
    Airport{IataCode{"WEH"}, CountryId{"CN"}, Timezone{4456}}, // Weihai Dashuibo Airport
    Airport{IataCode{"WEI"}, CountryId{"AU"}, Timezone{4920}}, // Weipa Airport
    Airport{IataCode{"WEL"}, CountryId{"ZA"}, Timezone{369}}, // Welkom Airport
    Airport{IataCode{"WFB"}, CountryId{"US"}, Timezone{3255}}, // Ketchikan Harbor Seaplane Base
    Airport{IataCode{"WFI"}, CountryId{"MG"}, Timezone{6035}}, // Fianarantsoa Airport
    Airport{IataCode{"WFK"}, CountryId{"US"}, Timezone{2625}}, // Northern Aroostook Regional Airport
    Airport{IataCode{"WGC"}, CountryId{"IN"}, Timezone{4129}}, // Warangal Airport
    Airport{IataCode{"WGE"}, CountryId{"AU"}, Timezone{5103}}, // Walgett Airport
    Airport{IataCode{"WGN"}, CountryId{"CN"}, Timezone{4456}}, // Shaoyang Wugang Airport
    Airport{IataCode{"WGO"}, CountryId{"US"}, Timezone{2712}}, // Winchester Regional Airport
    Airport{IataCode{"WGP"}, CountryId{"ID"}, Timezone{4226}}, // Mau Hau Airport
    Airport{IataCode{"WGT"}, CountryId{"AU"}, Timezone{5067}}, // Wangaratta Airport
    Airport{IataCode{"WHD"}, CountryId{"US"}, Timezone{3255}}, // Hyder Seaplane Base
    Airport{IataCode{"WHF"}, CountryId{"SD"}, Timezone{432}}, // Wadi Halfa Airport
    Airport{IataCode{"WHK"}, CountryId{"NZ"}, Timezone{6218}}, // Whakatane Airport
    Airport{IataCode{"WHP"}, CountryId{"US"}, Timezone{2378}}, // Whiteman Airport
    Airport{IataCode{"WHS"}, CountryId{"GB"}, Timezone{5517}}, // Whalsay Airport
    Airport{IataCode{"WHT"}, CountryId{"US"}, Timezone{1510}}, // Wharton Regional Airport
    Airport{IataCode{"WIB"}, CountryId{"US"}, Timezone{1510}}, // Wilbarger County Airport
    Airport{IataCode{"WIC"}, CountryId{"GB"}, Timezone{5517}}, // Wick Airport
    Airport{IataCode{"WIK"}, CountryId{"NZ"}, Timezone{6218}}, // Waiheke Island Aerodrome
    Airport{IataCode{"WIL"}, CountryId{"KE"}, Timezone{641}}, // Wilson Airport
    Airport{IataCode{"WIN"}, CountryId{"AU"}, Timezone{4920}}, // Winton Airport
    Airport{IataCode{"WIO"}, CountryId{"AU"}, Timezone{5103}}, // Wilcannia Airport
    Airport{IataCode{"WIR"}, CountryId{"NZ"}, Timezone{6218}}, // Wairoa Aerodrome
    Airport{IataCode{"WJA"}, CountryId{"MH"}, Timezone{}}, // Woja Airport
    Airport{IataCode{"WJF"}, CountryId{"US"}, Timezone{2378}}, // General William J. Fox Airfield
    Airport{IataCode{"WJR"}, CountryId{"KE"}, Timezone{641}}, // Wajir Airport
    Airport{IataCode{"WJU"}, CountryId{"KR"}, Timezone{4445}}, // Wonju Airport
    Airport{IataCode{"WKA"}, CountryId{"NZ"}, Timezone{6218}}, // Wanaka Airport
    Airport{IataCode{"WKB"}, CountryId{"AU"}, Timezone{5067}}, // Warracknabeal Airport
    Airport{IataCode{"WKI"}, CountryId{"ZW"}, Timezone{355}}, // Hwange Town Airport
    Airport{IataCode{"WKJ"}, CountryId{"JP"}, Timezone{4568}}, // Wakkanai Airport
    Airport{IataCode{"WKK"}, CountryId{"US"}, Timezone{814}}, // Aleknagik Airport
    Airport{IataCode{"WKN"}, CountryId{"PG"}, Timezone{6235}}, // Wakunai Airport
    Airport{IataCode{"WKR"}, CountryId{"BS"}, Timezone{2697}}, // Walkers Cay Airport
    Airport{IataCode{"WLD"}, CountryId{"US"}, Timezone{1510}}, // Strother Field
    Airport{IataCode{"WLE"}, CountryId{"AU"}, Timezone{4920}}, // Miles Airport
    Airport{IataCode{"WLG"}, CountryId{"NZ"}, Timezone{6218}}, // Wellington International Airport
    Airport{IataCode{"WLH"}, CountryId{"VU"}, Timezone{6301}}, // Walaha Airport
    Airport{IataCode{"WLK"}, CountryId{"US"}, Timezone{814}}, // Selawik Airport
    Airport{IataCode{"WLS"}, CountryId{"FR"}, Timezone{6801}}, // Hihifo Airport
    Airport{IataCode{"WLW"}, CountryId{"US"}, Timezone{2378}}, // Willows-Glenn County Airport
    Airport{IataCode{"WMA"}, CountryId{"MG"}, Timezone{6035}}, // Mandritsara Airport
    Airport{IataCode{"WMB"}, CountryId{"AU"}, Timezone{5067}}, // Warrnambool Airport
    Airport{IataCode{"WMC"}, CountryId{"US"}, Timezone{2378}}, // Winnemucca Municipal Airport
    Airport{IataCode{"WMD"}, CountryId{"MG"}, Timezone{}}, // Mandabe Airport
    Airport{IataCode{"WME"}, CountryId{"AU"}, Timezone{5087}}, // Mount Keith Airport
    Airport{IataCode{"WMH"}, CountryId{"US"}, Timezone{1510}}, // Ozark Regional Airport
    Airport{IataCode{"WMI"}, CountryId{"PL"}, Timezone{5975}}, // Warsaw-Modlin Mazovia Airport
    Airport{IataCode{"WML"}, CountryId{"NZ"}, Timezone{6218}}, // West Melton Aerodrome
    Airport{IataCode{"WMN"}, CountryId{"MG"}, Timezone{6035}}, // Maroantsetra Airport
    Airport{IataCode{"WMO"}, CountryId{"US"}, Timezone{2745}}, // White Mountain Airport
    Airport{IataCode{"WMP"}, CountryId{"MG"}, Timezone{6035}}, // Mampikony Airport
    Airport{IataCode{"WMR"}, CountryId{"MG"}, Timezone{6035}}, // Mananara Nord Airport
    Airport{IataCode{"WMX"}, CountryId{"ID"}, Timezone{4032}}, // Wamena Airport
    Airport{IataCode{"WNA"}, CountryId{"US"}, Timezone{814}}, // Napakiak Airport
    Airport{IataCode{"WNC"}, CountryId{"US"}, Timezone{3255}}, // Naukati Bay Seaplane Base
    Airport{IataCode{"WNH"}, CountryId{"CN"}, Timezone{4456}}, // Wenshan Puzhehei Airport
    Airport{IataCode{"WNI"}, CountryId{"ID"}, Timezone{4226}}, // Matahora Airport
    Airport{IataCode{"WNN"}, CountryId{"CA"}, Timezone{3540}}, // Wunnummin Lake Airport
    Airport{IataCode{"WNP"}, CountryId{"PH"}, Timezone{4240}}, // Naga Airport
    Airport{IataCode{"WNR"}, CountryId{"AU"}, Timezone{4920}}, // Windorah Airport
    Airport{IataCode{"WNS"}, CountryId{"PK"}, Timezone{4087}}, // Nawabshah Airport
    Airport{IataCode{"WNZ"}, CountryId{"CN"}, Timezone{4456}}, // Wenzhou Yongqiang International Airport
    Airport{IataCode{"WOL"}, CountryId{"AU"}, Timezone{5103}}, // Illawarra Regional Airport
    Airport{IataCode{"WON"}, CountryId{"AU"}, Timezone{}}, // Wondoola Airport
    Airport{IataCode{"WOS"}, CountryId{"KP"}, Timezone{4363}}, // Wonsan Airport
    Airport{IataCode{"WOT"}, CountryId{"TW"}, Timezone{4504}}, // Wang-an Airport
    Airport{IataCode{"WOW"}, CountryId{"US"}, Timezone{814}}, // Willow Airport
    Airport{IataCode{"WPA"}, CountryId{"CL"}, Timezone{3177}}, // Cabo Juan Román Airfield
    Airport{IataCode{"WPB"}, CountryId{"MG"}, Timezone{6035}}, // Port Bergé Airport
    Airport{IataCode{"WPC"}, CountryId{"CA"}, Timezone{1715}}, // Pincher Creek Airport
    Airport{IataCode{"WPL"}, CountryId{"CA"}, Timezone{3503}}, // Powell Lake Water Aerodrome
    Airport{IataCode{"WPR"}, CountryId{"CL"}, Timezone{3032}}, // Capitan Fuentes Martinez Airport
    Airport{IataCode{"WPU"}, CountryId{"CL"}, Timezone{1180}}, // Guardiamarina Zañartu Airport
    Airport{IataCode{"WRE"}, CountryId{"NZ"}, Timezone{6218}}, // Whangarei Airport
    Airport{IataCode{"WRG"}, CountryId{"US"}, Timezone{3255}}, // Wrangell Airport
    Airport{IataCode{"WRL"}, CountryId{"US"}, Timezone{1667}}, // Worland Municipal Airport
    Airport{IataCode{"WRN"}, CountryId{"AU"}, Timezone{5087}}, // Windarling Airport
    Airport{IataCode{"WRO"}, CountryId{"PL"}, Timezone{5975}}, // Wrocław – Copernicus Airport
    Airport{IataCode{"WRR"}, CountryId{"ID"}, Timezone{4032}}, // Werur Airport
    Airport{IataCode{"WRT"}, CountryId{"GB"}, Timezone{5517}}, // Warton Aerodrome
    Airport{IataCode{"WRY"}, CountryId{"GB"}, Timezone{5517}}, // Westray Airport
    Airport{IataCode{"WSE"}, CountryId{"EC"}, Timezone{1949}}, // Santa Cecilia Airport
    Airport{IataCode{"WSF"}, CountryId{"US"}, Timezone{2745}}, // Cape Sarichef Airport
    Airport{IataCode{"WSG"}, CountryId{"US"}, Timezone{2712}}, // Washington County Airport
    Airport{IataCode{"WSH"}, CountryId{"US"}, Timezone{2712}}, // Brookhaven Airport
    Airport{IataCode{"WSJ"}, CountryId{"US"}, Timezone{814}}, // San Juan (Uganik) Seaplane Base
    Airport{IataCode{"WSN"}, CountryId{"ID"}, Timezone{4032}}, // Lt. Col. Wisnu Airfield
    Airport{IataCode{"WSO"}, CountryId{"SR"}, Timezone{2912}}, // Washabo Airport
    Airport{IataCode{"WSP"}, CountryId{"NI"}, Timezone{3401}}, // Waspam Airport
    Airport{IataCode{"WST"}, CountryId{"US"}, Timezone{2712}}, // Westerly State Airport
    Airport{IataCode{"WSX"}, CountryId{"US"}, Timezone{2378}}, // Westsound/WSX Seaplane Base
    Airport{IataCode{"WSZ"}, CountryId{"NZ"}, Timezone{6218}}, // Westport Airport, New Zealand
    Airport{IataCode{"WTA"}, CountryId{"MG"}, Timezone{6035}}, // Tambohorano Airport
    Airport{IataCode{"WTB"}, CountryId{"AU"}, Timezone{4920}}, // Brisbane West Wellcamp Airport
    Airport{IataCode{"WTD"}, CountryId{"BS"}, Timezone{2697}}, // West End Airport
    Airport{IataCode{"WTE"}, CountryId{"MH"}, Timezone{6515}}, // Wotje Airport
    Airport{IataCode{"WTK"}, CountryId{"US"}, Timezone{2745}}, // Noatak Airport
    Airport{IataCode{"WTL"}, CountryId{"US"}, Timezone{2745}}, // Tuntutuliak Airport
    Airport{IataCode{"WTO"}, CountryId{"MH"}, Timezone{}}, // Wotho Airport
    Airport{IataCode{"WTP"}, CountryId{"PG"}, Timezone{6686}}, // Woitape Airport
    Airport{IataCode{"WTR"}, CountryId{"US"}, Timezone{2931}}, // Whiteriver Airport
    Airport{IataCode{"WTS"}, CountryId{"MG"}, Timezone{6035}}, // Tsiroanomandidy Airport
    Airport{IataCode{"WTZ"}, CountryId{"NZ"}, Timezone{6218}}, // Whitianga Aerodrome
    Airport{IataCode{"WUA"}, CountryId{"CN"}, Timezone{4456}}, // Wuhai Airport
    Airport{IataCode{"WUB"}, CountryId{"ID"}, Timezone{4032}}, // Buli Airport
    Airport{IataCode{"WUD"}, CountryId{"AU"}, Timezone{4901}}, // Wudinna Airport
    Airport{IataCode{"WUG"}, CountryId{"PG"}, Timezone{6686}}, // Wau Airport, Papua New Guinea
    Airport{IataCode{"WUH"}, CountryId{"CN"}, Timezone{4456}}, // Wuhan Tianhe International Airport
    Airport{IataCode{"WUI"}, CountryId{"AU"}, Timezone{5087}}, // Murrin Murrin Airport
    Airport{IataCode{"WUN"}, CountryId{"AU"}, Timezone{5087}}, // Wiluna Airport
    Airport{IataCode{"WUS"}, CountryId{"CN"}, Timezone{4456}}, // Wuyishan Airport
    Airport{IataCode{"WUT"}, CountryId{"CN"}, Timezone{4456}}, // Xinzhou Wutaishan Airport
    Airport{IataCode{"WUU"}, CountryId{"SS"}, Timezone{389}}, // Wau Airport
    Airport{IataCode{"WUX"}, CountryId{"CN"}, Timezone{4456}}, // Sunan Shuofang International Airport
    Airport{IataCode{"WUZ"}, CountryId{"CN"}, Timezone{4456}}, // Wuzhou Changzhoudao Airport
    Airport{IataCode{"WVB"}, CountryId{"NA"}, Timezone{785}}, // Walvis Bay Airport
    Airport{IataCode{"WVI"}, CountryId{"US"}, Timezone{2378}}, // Watsonville Municipal Airport
    Airport{IataCode{"WVK"}, CountryId{"MG"}, Timezone{6035}}, // Manakara Airport
    Airport{IataCode{"WVL"}, CountryId{"US"}, Timezone{2712}}, // Waterville Robert LaFleur Airport
    Airport{IataCode{"WWA"}, CountryId{"US"}, Timezone{814}}, // Wasilla Airport
    Airport{IataCode{"WWD"}, CountryId{"US"}, Timezone{2712}}, // Cape May Airport
    Airport{IataCode{"WWK"}, CountryId{"PG"}, Timezone{6686}}, // Wewak Airport
    Airport{IataCode{"WWP"}, CountryId{"US"}, Timezone{3255}}, // North Whale Seaplane Base
    Airport{IataCode{"WWR"}, CountryId{"US"}, Timezone{1510}}, // West Woodward Airport
    Airport{IataCode{"WWT"}, CountryId{"US"}, Timezone{2745}}, // Newtok Airport
    Airport{IataCode{"WWY"}, CountryId{"AU"}, Timezone{5103}}, // West Wyalong Airport
    Airport{IataCode{"WXN"}, CountryId{"CN"}, Timezone{4456}}, // Wanzhou Wuqiao Airport
    Airport{IataCode{"WYA"}, CountryId{"AU"}, Timezone{4901}}, // Whyalla Airport
    Airport{IataCode{"WYE"}, CountryId{"SL"}, Timezone{323}}, // Yengema Airport
    Airport{IataCode{"WYN"}, CountryId{"AU"}, Timezone{5087}}, // Wyndham Airport
    Airport{IataCode{"WYS"}, CountryId{"US"}, Timezone{1667}}, // Yellowstone Airport
    Airport{IataCode{"XAB"}, CountryId{"FR"}, Timezone{5646}}, // Aerodrome Abbeville
    Airport{IataCode{"XAP"}, CountryId{"BR"}, Timezone{3216}}, // Chapecó Airport
    Airport{IataCode{"XAR"}, CountryId{"BF"}, Timezone{704}}, // Aribinda Airport
    Airport{IataCode{"XAU"}, CountryId{"FR"}, Timezone{1479}}, // Saül Airport
    Airport{IataCode{"XBE"}, CountryId{"CA"}, Timezone{3540}}, // Bearskin Lake Airport
    Airport{IataCode{"XBG"}, CountryId{"BF"}, Timezone{704}}, // Bogande Airport
    Airport{IataCode{"XBJ"}, CountryId{"IR"}, Timezone{4543}}, // Birjand International Airport
    Airport{IataCode{"XBK"}, CountryId{"FR"}, Timezone{5646}}, // Bourg – Ceyzériat Airport
    Airport{IataCode{"XBO"}, CountryId{"BF"}, Timezone{704}}, // Boulsa Airport
    Airport{IataCode{"XBP"}, CountryId{"US"}, Timezone{1510}}, // Bridgeport Municipal Airport
    Airport{IataCode{"XBQ"}, CountryId{"FR"}, Timezone{5646}}, // Blois - Le Breuil Airport
    Airport{IataCode{"XBR"}, CountryId{"CA"}, Timezone{3471}}, // Brockville-Thousand Islands Regional Tackaberry Airport
    Airport{IataCode{"XCD"}, CountryId{"FR"}, Timezone{5646}}, // Chalon – Champforgeuil Airport
    Airport{IataCode{"XCH"}, CountryId{"AU"}, Timezone{6069}}, // Christmas Island Airport
    Airport{IataCode{"XCL"}, CountryId{"CA"}, Timezone{3109}}, // Cluff Lake Airport
    Airport{IataCode{"XCM"}, CountryId{"CA"}, Timezone{3471}}, // Chatham-Kent Airport
    Airport{IataCode{"XCR"}, CountryId{"FR"}, Timezone{5646}}, // Châlons Vatry Airport
    Airport{IataCode{"XCY"}, CountryId{"FR"}, Timezone{5646}}, // Château-Thierry – Belleau Aerodrome
    Airport{IataCode{"XCZ"}, CountryId{"FR"}, Timezone{5646}}, // Charleville-Mézières Airport
    Airport{IataCode{"XDE"}, CountryId{"BF"}, Timezone{704}}, // Diébougou Airport
    Airport{IataCode{"XDJ"}, CountryId{"BF"}, Timezone{704}}, // Djibo Airport
    Airport{IataCode{"XDR"}, CountryId{"FR"}, Timezone{5646}}, // Vernouillet Airport
    Airport{IataCode{"XEP"}, CountryId{"FR"}, Timezone{5646}}, // Épernay Plivot Airport
    Airport{IataCode{"XES"}, CountryId{"US"}, Timezone{1510}}, // Grand Geneva Resort Airport
    Airport{IataCode{"XFN"}, CountryId{"CN"}, Timezone{4456}}, // Xiangyang Liuji Airport
    Airport{IataCode{"XGA"}, CountryId{"BF"}, Timezone{704}}, // Gaoua Airport
    Airport{IataCode{"XGG"}, CountryId{"BF"}, Timezone{704}}, // Gorom Gorom Airport
    Airport{IataCode{"XGN"}, CountryId{"AO"}, Timezone{505}}, // Xangongo Airport
    Airport{IataCode{"XGR"}, CountryId{"CA"}, Timezone{3471}}, // Kangiqsualujjuaq (Georges River) Airport
    Airport{IataCode{"XIC"}, CountryId{"CN"}, Timezone{4456}}, // Xichang Qingshan Airport
    Airport{IataCode{"XIG"}, CountryId{"BR"}, Timezone{1308}}, // Xinguara Municipal Airport
    Airport{IataCode{"XIL"}, CountryId{"CN"}, Timezone{4456}}, // Xilinhot Airport
    Airport{IataCode{"XIY"}, CountryId{"CN"}, Timezone{4456}}, // Xi'an Xianyang International Airport
    Airport{IataCode{"XJM"}, CountryId{"PK"}, Timezone{4087}}, // Gurha Salim Airport
    Airport{IataCode{"XKA"}, CountryId{"BF"}, Timezone{704}}, // Kantchari Airport
    Airport{IataCode{"XKH"}, CountryId{"LA"}, Timezone{4633}}, // Xieng Khouang Airport
    Airport{IataCode{"XKS"}, CountryId{"CA"}, Timezone{3540}}, // Kasabonika Airport
    Airport{IataCode{"XKY"}, CountryId{"BF"}, Timezone{704}}, // Kaya Airport
    Airport{IataCode{"XLB"}, CountryId{"CA"}, Timezone{3540}}, // Lac Brochet Airport
    Airport{IataCode{"XLG"}, CountryId{"FR"}, Timezone{5646}}, // Lognes-Émerainville Aerodrome
    Airport{IataCode{"XLL"}, CountryId{"US"}, Timezone{2712}}, // Greensboro North Airport
    Airport{IataCode{"XLS"}, CountryId{"SN"}, Timezone{686}}, // Saint-Louis Airport
    Airport{IataCode{"XLU"}, CountryId{"BF"}, Timezone{704}}, // Leo Airport
    Airport{IataCode{"XMC"}, CountryId{"AU"}, Timezone{5067}}, // Mallacoota Airport
    Airport{IataCode{"XMD"}, CountryId{"US"}, Timezone{1510}}, // Madison Municipal Airport
    Airport{IataCode{"XME"}, CountryId{"FR"}, Timezone{}}, // Maubeuge - Élesmes Airport
    Airport{IataCode{"XMF"}, CountryId{"FR"}, Timezone{5646}}, // Montbéliard – Courcelles Aerodrome
    Airport{IataCode{"XMG"}, CountryId{"NP"}, Timezone{4129}}, // Mahendranagar Airport
    Airport{IataCode{"XMH"}, CountryId{"FR"}, Timezone{6740}}, // Manihi Airport
    Airport{IataCode{"XMI"}, CountryId{"TZ"}, Timezone{256}}, // Masasi Airport
    Airport{IataCode{"XMN"}, CountryId{"CN"}, Timezone{4456}}, // Xiamen Gaoqi International Airport
    Airport{IataCode{"XMP"}, CountryId{"CA"}, Timezone{3521}}, // Macmillian Pass Airport
    Airport{IataCode{"XMS"}, CountryId{"EC"}, Timezone{1949}}, // Edmundo Carvajal Airport
    Airport{IataCode{"XMU"}, CountryId{"FR"}, Timezone{5646}}, // Moulins – Montbeugny Airport
    Airport{IataCode{"XMW"}, CountryId{"FR"}, Timezone{5646}}, // Montauban Airport
    Airport{IataCode{"XMY"}, CountryId{"AU"}, Timezone{4920}}, // Yam Island Airport
    Airport{IataCode{"XNA"}, CountryId{"US"}, Timezone{1510}}, // Northwest Arkansas Regional Airport
    Airport{IataCode{"XNN"}, CountryId{"CN"}, Timezone{4456}}, // Xining Caojiabao Airport
    Airport{IataCode{"XNO"}, CountryId{"US"}, Timezone{2712}}, // North Auxiliary Airfield
    Airport{IataCode{"XNT"}, CountryId{"CN"}, Timezone{4456}}, // Xingtai Dalian Airport
    Airport{IataCode{"XNU"}, CountryId{"BF"}, Timezone{704}}, // Nouna Airport
    Airport{IataCode{"XPA"}, CountryId{"BF"}, Timezone{704}}, // Pama Airport
    Airport{IataCode{"XPK"}, CountryId{"CA"}, Timezone{3540}}, // Pukatawagan Airport
    Airport{IataCode{"XPP"}, CountryId{"CA"}, Timezone{3540}}, // Poplar River Airport
    Airport{IataCode{"XPR"}, CountryId{"US"}, Timezone{1667}}, // Pine Ridge Airport
    Airport{IataCode{"XQP"}, CountryId{"CR"}, Timezone{1544}}, // Quepos La Managua Airport
    Airport{IataCode{"XQU"}, CountryId{"CA"}, Timezone{3503}}, // Qualicum Beach Airport
    Airport{IataCode{"XRR"}, CountryId{"CA"}, Timezone{3521}}, // Ross River Airport
    Airport{IataCode{"XRY"}, CountryId{"ES"}, Timezone{5549}}, // Jerez Airport
    Airport{IataCode{"XSA"}, CountryId{"US"}, Timezone{2712}}, // Tappahannock-Essex County Airport
    Airport{IataCode{"XSB"}, CountryId{"AE"}, Timezone{3902}}, // Sir Bani Yas Airport
    Airport{IataCode{"XSC"}, CountryId{"GB"}, Timezone{1859}}, // South Caicos Airport
    Airport{IataCode{"XSD"}, CountryId{"US"}, Timezone{2378}}, // Tonopah Test Range Airport
    Airport{IataCode{"XSE"}, CountryId{"BF"}, Timezone{704}}, // Sebba Airport
    Airport{IataCode{"XSI"}, CountryId{"CA"}, Timezone{3540}}, // South Indian Lake Airport
    Airport{IataCode{"XSJ"}, CountryId{"FR"}, Timezone{5646}}, // Peronne-St Quentin Airport
    Airport{IataCode{"XSN"}, CountryId{"FR"}, Timezone{5646}}, // Sallanches Aerodrome
    Airport{IataCode{"XSP"}, CountryId{"SG"}, Timezone{4159}}, // Seletar Airport
    Airport{IataCode{"XSU"}, CountryId{"FR"}, Timezone{5646}}, // Saumur - Saint-Florent Airport
    Airport{IataCode{"XTG"}, CountryId{"AU"}, Timezone{4920}}, // Thargomindah Airport
    Airport{IataCode{"XTL"}, CountryId{"CA"}, Timezone{3540}}, // Tadoule Lake Airport
    Airport{IataCode{"XTO"}, CountryId{"AU"}, Timezone{4920}}, // Taroom Airport
    Airport{IataCode{"XUD"}, CountryId{"GB"}, Timezone{5517}}, // Cranfield Airport
    Airport{IataCode{"XUZ"}, CountryId{"CN"}, Timezone{4456}}, // Xuzhou Guanyin Airport
    Airport{IataCode{"XVF"}, CountryId{"FR"}, Timezone{5646}}, // Villefranche – Tarare Airport
    Airport{IataCode{"XVG"}, CountryId{"US"}, Timezone{1510}}, // Longville Municipal Airport
    Airport{IataCode{"XVN"}, CountryId{"FR"}, Timezone{5646}}, // Verdun-Le-Rozelier Airport
    Airport{IataCode{"XVO"}, CountryId{"FR"}, Timezone{5646}}, // Vesoul - Frotey Airport
    Airport{IataCode{"XVS"}, CountryId{"FR"}, Timezone{5646}}, // Valenciennes-Denain Airport
    Airport{IataCode{"XWA"}, CountryId{"US"}, Timezone{1510}}, // Williston Basin International Airport
    Airport{IataCode{"XYA"}, CountryId{"SB"}, Timezone{6413}}, // Yandina Airport
    Airport{IataCode{"XYP"}, CountryId{"FR"}, Timezone{5646}}, // Persan-Beaumont Airport
    Airport{IataCode{"XZA"}, CountryId{"BF"}, Timezone{704}}, // Zabré Airport
    Airport{IataCode{"XZB"}, CountryId{"FR"}, Timezone{5646}}, // Saint-Cyr-l'École Airport
    Airport{IataCode{"XZX"}, CountryId{"FR"}, Timezone{5646}}, // Chavenay - Villepreux Airport
    Airport{IataCode{"YAA"}, CountryId{"CA"}, Timezone{3503}}, // Anahim Lake Airport
    Airport{IataCode{"YAB"}, CountryId{"CA"}, Timezone{3073}}, // Arctic Bay Airport
    Airport{IataCode{"YAC"}, CountryId{"CA"}, Timezone{3540}}, // Cat Lake Airport
    Airport{IataCode{"YAG"}, CountryId{"CA"}, Timezone{3540}}, // Fort Frances Municipal Airport
    Airport{IataCode{"YAH"}, CountryId{"CA"}, Timezone{3471}}, // La Grande-4 Airport
    Airport{IataCode{"YAI"}, CountryId{"CL"}, Timezone{3177}}, // General Bernardo O'Higgins Airport
    Airport{IataCode{"YAK"}, CountryId{"US"}, Timezone{3557}}, // Yakutat Airport
    Airport{IataCode{"YAL"}, CountryId{"CA"}, Timezone{3503}}, // Alert Bay Airport
    Airport{IataCode{"YAM"}, CountryId{"CA"}, Timezone{3471}}, // Sault Ste. Marie Airport
    Airport{IataCode{"YAN"}, CountryId{"CD"}, Timezone{519}}, // Yangambi Airport
    Airport{IataCode{"YAO"}, CountryId{"CM"}, Timezone{293}}, // Yaoundé Airport
    Airport{IataCode{"YAP"}, CountryId{"FM"}, Timezone{}}, // Yap International Airport
    Airport{IataCode{"YAR"}, CountryId{"CA"}, Timezone{3471}}, // La Grande-3 Airport
    Airport{IataCode{"YAS"}, CountryId{"FJ"}, Timezone{6349}}, // Yasawa Island Airport
    Airport{IataCode{"YAT"}, CountryId{"CA"}, Timezone{3471}}, // Attawapiskat Airport
    Airport{IataCode{"YAU"}, CountryId{"CA"}, Timezone{3471}}, // Kattiniq/Donaldson Airport
    Airport{IataCode{"YAV"}, CountryId{"CA"}, Timezone{3503}}, // Mayne Island Water Aerodrome
    Airport{IataCode{"YAX"}, CountryId{"CA"}, Timezone{3540}}, // Angling Lake/Wapekeka Airport
    Airport{IataCode{"YAY"}, CountryId{"CA"}, Timezone{3291}}, // St. Anthony Airport
    Airport{IataCode{"YAZ"}, CountryId{"CA"}, Timezone{3503}}, // Tofino/Long Beach Airport
    Airport{IataCode{"YBA"}, CountryId{"CA"}, Timezone{1715}}, // Banff Airport
    Airport{IataCode{"YBB"}, CountryId{"CA"}, Timezone{1405}}, // Kugaaruk Airport
    Airport{IataCode{"YBC"}, CountryId{"CA"}, Timezone{3471}}, // Baie-Comeau Airport
    Airport{IataCode{"YBE"}, CountryId{"CA"}, Timezone{3109}}, // Uranium City Airport
    Airport{IataCode{"YBF"}, CountryId{"CA"}, Timezone{3503}}, // Bamfield Water Aerodrome
    Airport{IataCode{"YBI"}, CountryId{"CA"}, Timezone{1859}}, // Black Tickle Airport
    Airport{IataCode{"YBJ"}, CountryId{"CA"}, Timezone{3471}}, // Baie-Johan-Beetz Seaplane Base
    Airport{IataCode{"YBK"}, CountryId{"CA"}, Timezone{3073}}, // Baker Lake Airport
    Airport{IataCode{"YBL"}, CountryId{"CA"}, Timezone{3503}}, // Campbell River Airport
    Airport{IataCode{"YBM"}, CountryId{"CA"}, Timezone{3503}}, // Bronson Creek Airport
    Airport{IataCode{"YBO"}, CountryId{"CA"}, Timezone{3503}}, // Bob Quinn Lake Airport
    Airport{IataCode{"YBP"}, CountryId{"CN"}, Timezone{4456}}, // Yibin Caiba Airport
    Airport{IataCode{"YBR"}, CountryId{"CA"}, Timezone{3540}}, // Brandon Municipal Airport
    Airport{IataCode{"YBS"}, CountryId{"CA"}, Timezone{3540}}, // Opapimiskan Lake Airport
    Airport{IataCode{"YBT"}, CountryId{"CA"}, Timezone{3540}}, // Brochet Airport
    Airport{IataCode{"YBU"}, CountryId{"CA"}, Timezone{3109}}, // Nipawin Airport
    Airport{IataCode{"YBV"}, CountryId{"CA"}, Timezone{3540}}, // Berens River Airport
    Airport{IataCode{"YBW"}, CountryId{"CA"}, Timezone{3503}}, // Bedwell Harbour Water Aerodrome
    Airport{IataCode{"YBX"}, CountryId{"CA"}, Timezone{1337}}, // Lourdes-de-Blanc-Sablon Airport
    Airport{IataCode{"YBY"}, CountryId{"CA"}, Timezone{1715}}, // Bonnyville Airport
    Airport{IataCode{"YCA"}, CountryId{"CA"}, Timezone{3503}}, // Courtenay Airpark
    Airport{IataCode{"YCB"}, CountryId{"CA"}, Timezone{1405}}, // Cambridge Bay Airport
    Airport{IataCode{"YCC"}, CountryId{"CA"}, Timezone{3471}}, // Cornwall Regional Airport
    Airport{IataCode{"YCD"}, CountryId{"CA"}, Timezone{3503}}, // Nanaimo Airport
    Airport{IataCode{"YCE"}, CountryId{"CA"}, Timezone{3471}}, // Centralia/James T. Field Memorial Aerodrome
    Airport{IataCode{"YCF"}, CountryId{"CA"}, Timezone{3503}}, // Cortes Island (Hansen Airfield) Airport
    Airport{IataCode{"YCG"}, CountryId{"CA"}, Timezone{3503}}, // West Kootenay Regional Airport
    Airport{IataCode{"YCH"}, CountryId{"CA"}, Timezone{2625}}, // Miramichi Airport
    Airport{IataCode{"YCK"}, CountryId{"CA"}, Timezone{3573}}, // Colville Lake Airport
    Airport{IataCode{"YCL"}, CountryId{"CA"}, Timezone{2625}}, // Charlo Airport
    Airport{IataCode{"YCM"}, CountryId{"CA"}, Timezone{3471}}, // St. Catharines/Niagara District Airport
    Airport{IataCode{"YCN"}, CountryId{"CA"}, Timezone{3471}}, // Cochrane Airport
    Airport{IataCode{"YCO"}, CountryId{"CA"}, Timezone{1405}}, // Kugluktuk Airport
    Airport{IataCode{"YCP"}, CountryId{"CA"}, Timezone{3503}}, // Blue River Airport
    Airport{IataCode{"YCQ"}, CountryId{"CA"}, Timezone{1646}}, // Chetwynd Airport
    Airport{IataCode{"YCR"}, CountryId{"CA"}, Timezone{3540}}, // Cross Lake Airport
    Airport{IataCode{"YCS"}, CountryId{"CA"}, Timezone{3073}}, // Chesterfield Inlet Airport
    Airport{IataCode{"YCT"}, CountryId{"CA"}, Timezone{1715}}, // Coronation Airport
    Airport{IataCode{"YCU"}, CountryId{"CN"}, Timezone{4456}}, // Yuncheng Guangong Airport
    Airport{IataCode{"YCW"}, CountryId{"CA"}, Timezone{3503}}, // Chilliwack Airport
    Airport{IataCode{"YCY"}, CountryId{"CA"}, Timezone{2228}}, // Clyde River Airport
    Airport{IataCode{"YCZ"}, CountryId{"CA"}, Timezone{1715}}, // Fairmont Hot Springs Airport
    Airport{IataCode{"YDA"}, CountryId{"CA"}, Timezone{3521}}, // Dawson City Airport
    Airport{IataCode{"YDB"}, CountryId{"CA"}, Timezone{3521}}, // Burwash Airport
    Airport{IataCode{"YDC"}, CountryId{"CA"}, Timezone{1715}}, // Drayton Valley Industrial Airport
    Airport{IataCode{"YDE"}, CountryId{"CA"}, Timezone{1859}}, // Paradise River Airport
    Airport{IataCode{"YDF"}, CountryId{"CA"}, Timezone{3291}}, // Deer Lake Regional Airport
    Airport{IataCode{"YDG"}, CountryId{"CA"}, Timezone{1964}}, // Digby/Annapolis Regional Airport
    Airport{IataCode{"YDJ"}, CountryId{"CA"}, Timezone{3109}}, // Hatchet Lake Airport
    Airport{IataCode{"YDL"}, CountryId{"CA"}, Timezone{3503}}, // Dease Lake Airport
    Airport{IataCode{"YDN"}, CountryId{"CA"}, Timezone{3540}}, // Lt. Col W.G. (Billy) Barker VC Airport
    Airport{IataCode{"YDO"}, CountryId{"CA"}, Timezone{3471}}, // Dolbeau-Saint-Félicien Airport
    Airport{IataCode{"YDP"}, CountryId{"CA"}, Timezone{1859}}, // Nain Airport
    Airport{IataCode{"YDQ"}, CountryId{"CA"}, Timezone{1646}}, // Dawson Creek Airport
    Airport{IataCode{"YDT"}, CountryId{"CA"}, Timezone{3503}}, // Boundary Bay Airport
    Airport{IataCode{"YDU"}, CountryId{"CA"}, Timezone{3573}}, // Kasba Lake Airport
    Airport{IataCode{"YDV"}, CountryId{"CA"}, Timezone{3540}}, // Bloodvein River Airport
    Airport{IataCode{"YDW"}, CountryId{"CA"}, Timezone{3573}}, // Obre Lake/North of Sixty Airport
    Airport{IataCode{"YEA"}, CountryId{"CA"}, Timezone{1715}}, // Empress Airport
    Airport{IataCode{"YEB"}, CountryId{"CA"}, Timezone{1682}}, // Bar River Airport
    Airport{IataCode{"YEE"}, CountryId{"CA"}, Timezone{3471}}, // Midland/Huronia Airport
    Airport{IataCode{"YEG"}, CountryId{"CA"}, Timezone{1715}}, // Edmonton International Airport
    Airport{IataCode{"YEH"}, CountryId{"IR"}, Timezone{4543}}, // Asalouyeh Airport
    Airport{IataCode{"YEK"}, CountryId{"CA"}, Timezone{3073}}, // Arviat Airport
    Airport{IataCode{"YEL"}, CountryId{"CA"}, Timezone{3471}}, // Elliot Lake Municipal Airport
    Airport{IataCode{"YEM"}, CountryId{"CA"}, Timezone{3471}}, // Manitowaning/Manitoulin East Municipal Airport
    Airport{IataCode{"YEN"}, CountryId{"CA"}, Timezone{3109}}, // Estevan Regional Aerodrome
    Airport{IataCode{"YER"}, CountryId{"CA"}, Timezone{3471}}, // Fort Severn Airport
    Airport{IataCode{"YES"}, CountryId{"IR"}, Timezone{4543}}, // Yasuj Airport
    Airport{IataCode{"YET"}, CountryId{"CA"}, Timezone{1715}}, // Edson Airport
    Airport{IataCode{"YEU"}, CountryId{"CA"}, Timezone{3073}}, // Eureka Aerodrome
    Airport{IataCode{"YEV"}, CountryId{"CA"}, Timezone{2213}}, // Inuvik (Mike Zubko) Airport
    Airport{IataCode{"YEY"}, CountryId{"CA"}, Timezone{3471}}, // Amos/Magny Airport
    Airport{IataCode{"YFA"}, CountryId{"CA"}, Timezone{3471}}, // Fort Albany Airport
    Airport{IataCode{"YFB"}, CountryId{"CA"}, Timezone{2228}}, // Iqaluit Airport
    Airport{IataCode{"YFC"}, CountryId{"CA"}, Timezone{2625}}, // Fredericton International Airport
    Airport{IataCode{"YFD"}, CountryId{"CA"}, Timezone{3471}}, // Brantford Airport
    Airport{IataCode{"YFE"}, CountryId{"CA"}, Timezone{3471}}, // Forestville Airport
    Airport{IataCode{"YFG"}, CountryId{"CA"}, Timezone{3471}}, // Fontages Airport
    Airport{IataCode{"YFH"}, CountryId{"CA"}, Timezone{3471}}, // Fort Hope Airport
    Airport{IataCode{"YFI"}, CountryId{"CA"}, Timezone{1715}}, // Fort MacKay/Firebag Aerodrome
    Airport{IataCode{"YFJ"}, CountryId{"CA"}, Timezone{3573}}, // Wekweètì Airport
    Airport{IataCode{"YFL"}, CountryId{"CA"}, Timezone{3573}}, // Fort Reliance Water Aerodrome
    Airport{IataCode{"YFO"}, CountryId{"CA"}, Timezone{3540}}, // Flin Flon Airport
    Airport{IataCode{"YFR"}, CountryId{"CA"}, Timezone{3573}}, // Fort Resolution Airport
    Airport{IataCode{"YFS"}, CountryId{"CA"}, Timezone{3573}}, // Fort Simpson Airport
    Airport{IataCode{"YFX"}, CountryId{"CA"}, Timezone{3291}}, // St. Lewis (Fox Harbour) Airport
    Airport{IataCode{"YGA"}, CountryId{"CA"}, Timezone{3471}}, // Lac Gagnon Water Aerodrome
    Airport{IataCode{"YGB"}, CountryId{"CA"}, Timezone{3503}}, // Texada/Gillies Bay Airport
    Airport{IataCode{"YGC"}, CountryId{"CA"}, Timezone{1715}}, // Grande Cache Airport
    Airport{IataCode{"YGD"}, CountryId{"CA"}, Timezone{3471}}, // Goderich Airport
    Airport{IataCode{"YGE"}, CountryId{"CA"}, Timezone{1715}}, // Golden Airport
    Airport{IataCode{"YGG"}, CountryId{"CA"}, Timezone{3503}}, // Ganges Water Aerodrome
    Airport{IataCode{"YGH"}, CountryId{"CA"}, Timezone{3573}}, // Fort Good Hope Airport
    Airport{IataCode{"YGJ"}, CountryId{"JP"}, Timezone{4568}}, // Miho-Yonago Airport
    Airport{IataCode{"YGK"}, CountryId{"CA"}, Timezone{3471}}, // Kingston/Norman Rogers Airport
    Airport{IataCode{"YGL"}, CountryId{"CA"}, Timezone{3471}}, // La Grande Rivière Airport
    Airport{IataCode{"YGM"}, CountryId{"CA"}, Timezone{3540}}, // Gimli Industrial Park Airport
    Airport{IataCode{"YGO"}, CountryId{"CA"}, Timezone{3540}}, // Gods Lake Narrows Airport
    Airport{IataCode{"YGP"}, CountryId{"CA"}, Timezone{3471}}, // Michel-Pouliot Gaspé Airport
    Airport{IataCode{"YGQ"}, CountryId{"CA"}, Timezone{3471}}, // Geraldton (Greenstone Regional) Airport
    Airport{IataCode{"YGR"}, CountryId{"CA"}, Timezone{1964}}, // Îles-de-la-Madeleine Airport
    Airport{IataCode{"YGT"}, CountryId{"CA"}, Timezone{2228}}, // Igloolik Airport
    Airport{IataCode{"YGV"}, CountryId{"CA"}, Timezone{3471}}, // Havre Saint-Pierre Airport
    Airport{IataCode{"YGW"}, CountryId{"CA"}, Timezone{2228}}, // Kuujjuarapik Airport
    Airport{IataCode{"YGX"}, CountryId{"CA"}, Timezone{3540}}, // Gillam Airport
    Airport{IataCode{"YGZ"}, CountryId{"CA"}, Timezone{2228}}, // Grise Fiord Airport
    Airport{IataCode{"YHA"}, CountryId{"CA"}, Timezone{3291}}, // Port Hope Simpson Airport
    Airport{IataCode{"YHB"}, CountryId{"CA"}, Timezone{3109}}, // Hudson Bay Airport
    Airport{IataCode{"YHD"}, CountryId{"CA"}, Timezone{3540}}, // Dryden Regional Airport
    Airport{IataCode{"YHE"}, CountryId{"CA"}, Timezone{3503}}, // Hope Aerodrome
    Airport{IataCode{"YHF"}, CountryId{"CA"}, Timezone{3471}}, // Hearst (René Fontaine) Municipal Airport
    Airport{IataCode{"YHG"}, CountryId{"CA"}, Timezone{3291}}, // Charlottetown Airport
    Airport{IataCode{"YHH"}, CountryId{"CA"}, Timezone{3503}}, // Campbell River Water Aerodrome
    Airport{IataCode{"YHI"}, CountryId{"CA"}, Timezone{3573}}, // Ulukhaktok/Holman Airport
    Airport{IataCode{"YHK"}, CountryId{"CA"}, Timezone{1405}}, // Gjoa Haven Airport
    Airport{IataCode{"YHM"}, CountryId{"CA"}, Timezone{3471}}, // John C. Munro Hamilton International Airport
    Airport{IataCode{"YHN"}, CountryId{"CA"}, Timezone{3471}}, // Hornepayne Municipal Airport
    Airport{IataCode{"YHO"}, CountryId{"CA"}, Timezone{1859}}, // Hopedale Airport
    Airport{IataCode{"YHP"}, CountryId{"CA"}, Timezone{3540}}, // Poplar Hill Airport
    Airport{IataCode{"YHR"}, CountryId{"CA"}, Timezone{1337}}, // Chevery Airport
    Airport{IataCode{"YHS"}, CountryId{"CA"}, Timezone{3503}}, // Sechelt Aerodrome
    Airport{IataCode{"YHT"}, CountryId{"CA"}, Timezone{3521}}, // Haines Junction Airport
    Airport{IataCode{"YHU"}, CountryId{"CA"}, Timezone{3471}}, // Montréal/Saint-Hubert Airport
    Airport{IataCode{"YHY"}, CountryId{"CA"}, Timezone{3573}}, // Hay River/Merlyn Carter Airport
    Airport{IataCode{"YHZ"}, CountryId{"CA"}, Timezone{1964}}, // Halifax Stanfield International Airport
    Airport{IataCode{"YIB"}, CountryId{"CA"}, Timezone{1237}}, // Atikokan Municipal Airport
    Airport{IataCode{"YIC"}, CountryId{"CN"}, Timezone{4456}}, // Yichun Mingyueshan Airport
    Airport{IataCode{"YIE"}, CountryId{"CN"}, Timezone{4456}}, // Arxan Yi'ershi Airport
    Airport{IataCode{"YIF"}, CountryId{"CA"}, Timezone{1337}}, // Saint-Augustin Airport
    Airport{IataCode{"YIG"}, CountryId{"CA"}, Timezone{3503}}, // Big Bay Water Aerodrome
    Airport{IataCode{"YIH"}, CountryId{"CN"}, Timezone{4456}}, // Yichang Airport
    Airport{IataCode{"YIK"}, CountryId{"CA"}, Timezone{2228}}, // Ivujivik Airport
    Airport{IataCode{"YIN"}, CountryId{"CN"}, Timezone{4607}}, // Yining Airport
    Airport{IataCode{"YIO"}, CountryId{"CA"}, Timezone{2228}}, // Pond Inlet Airport
    Airport{IataCode{"YIP"}, CountryId{"US"}, Timezone{1682}}, // Willow Run Airport
    Airport{IataCode{"YIV"}, CountryId{"CA"}, Timezone{3540}}, // Island Lake Airport
    Airport{IataCode{"YIW"}, CountryId{"CN"}, Timezone{4456}}, // Yiwu Airport
    Airport{IataCode{"YJA"}, CountryId{"CA"}, Timezone{1715}}, // Jasper Airport
    Airport{IataCode{"YJF"}, CountryId{"CA"}, Timezone{3573}}, // Fort Liard Airport
    Airport{IataCode{"YJM"}, CountryId{"CA"}, Timezone{3503}}, // Fort St. James (Perison) Airport
    Airport{IataCode{"YJN"}, CountryId{"CA"}, Timezone{3471}}, // Saint-Jean Airport
    Airport{IataCode{"YJP"}, CountryId{"CA"}, Timezone{1715}}, // Hinton/Jasper-Hinton Airport
    Airport{IataCode{"YJS"}, CountryId{"KP"}, Timezone{4363}}, // Samjiyŏn Airport
    Airport{IataCode{"YJT"}, CountryId{"CA"}, Timezone{3291}}, // Stephenville International Airport
    Airport{IataCode{"YKA"}, CountryId{"CA"}, Timezone{3503}}, // Kamloops Airport
    Airport{IataCode{"YKC"}, CountryId{"CA"}, Timezone{3109}}, // Collins Bay Airport
    Airport{IataCode{"YKD"}, CountryId{"CA"}, Timezone{3471}}, // Kincardine Airport
    Airport{IataCode{"YKE"}, CountryId{"CA"}, Timezone{3540}}, // Knee Lake Airport
    Airport{IataCode{"YKF"}, CountryId{"CA"}, Timezone{3471}}, // Region of Waterloo International Airport
    Airport{IataCode{"YKG"}, CountryId{"CA"}, Timezone{3471}}, // Kangirsuk Airport
    Airport{IataCode{"YKH"}, CountryId{"CN"}, Timezone{4456}}, // Yingkou Lanqi Airport
    Airport{IataCode{"YKJ"}, CountryId{"CA"}, Timezone{3109}}, // Key Lake Airport
    Airport{IataCode{"YKK"}, CountryId{"CA"}, Timezone{3503}}, // Kitkatla Water Aerodrome
    Airport{IataCode{"YKL"}, CountryId{"CA"}, Timezone{3471}}, // Schefferville Airport
    Airport{IataCode{"YKM"}, CountryId{"US"}, Timezone{2378}}, // Yakima Air Terminal
    Airport{IataCode{"YKN"}, CountryId{"US"}, Timezone{1510}}, // Chan Gurney Municipal Airport
    Airport{IataCode{"YKO"}, CountryId{"TR"}, Timezone{5412}}, // Hakkari Yüksekova Airport
    Airport{IataCode{"YKQ"}, CountryId{"CA"}, Timezone{2228}}, // Waskaganish Airport
    Airport{IataCode{"YKS"}, CountryId{"RU"}, Timezone{4665}}, // Yakutsk Airport
    Airport{IataCode{"YKU"}, CountryId{"CA"}, Timezone{2228}}, // Chisasibi Airport
    Airport{IataCode{"YKX"}, CountryId{"CA"}, Timezone{3471}}, // Kirkland Lake Airport
    Airport{IataCode{"YKY"}, CountryId{"CA"}, Timezone{3109}}, // Kindersley Regional Airport
    Airport{IataCode{"YKZ"}, CountryId{"CA"}, Timezone{3471}}, // Buttonville Municipal Airport
    Airport{IataCode{"YLB"}, CountryId{"CA"}, Timezone{1715}}, // Lac La Biche Airport
    Airport{IataCode{"YLC"}, CountryId{"CA"}, Timezone{2228}}, // Kimmirut Airport
    Airport{IataCode{"YLD"}, CountryId{"CA"}, Timezone{3471}}, // Chapleau Airport
    Airport{IataCode{"YLE"}, CountryId{"CA"}, Timezone{3573}}, // Whatì Airport
    Airport{IataCode{"YLH"}, CountryId{"CA"}, Timezone{3471}}, // Lansdowne House Airport
    Airport{IataCode{"YLJ"}, CountryId{"CA"}, Timezone{3109}}, // Meadow Lake Airport
    Airport{IataCode{"YLK"}, CountryId{"CA"}, Timezone{3471}}, // Lake Simcoe Regional Airport
    Airport{IataCode{"YLL"}, CountryId{"CA"}, Timezone{1715}}, // Lloydminster Airport
    Airport{IataCode{"YLQ"}, CountryId{"CA"}, Timezone{3471}}, // La Tuque Airport
    Airport{IataCode{"YLR"}, CountryId{"CA"}, Timezone{3540}}, // Leaf Rapids Airport
    Airport{IataCode{"YLS"}, CountryId{"CA"}, Timezone{3471}}, // Lebel-sur-Quévillon Airport
    Airport{IataCode{"YLT"}, CountryId{"CA"}, Timezone{2892}}, // Alert Airport
    Airport{IataCode{"YLV"}, CountryId{"AZ"}, Timezone{3754}}, // Yevlakh Airport
    Airport{IataCode{"YLW"}, CountryId{"CA"}, Timezone{3503}}, // Kelowna International Airport
    Airport{IataCode{"YLY"}, CountryId{"CA"}, Timezone{3503}}, // Langley Regional Airport
    Airport{IataCode{"YMA"}, CountryId{"CA"}, Timezone{3521}}, // Mayo Airport
    Airport{IataCode{"YMB"}, CountryId{"CA"}, Timezone{3503}}, // Merritt Airport
    Airport{IataCode{"YMD"}, CountryId{"CA"}, Timezone{3573}}, // Mould Bay Airport
    Airport{IataCode{"YME"}, CountryId{"CA"}, Timezone{3471}}, // Matane Airport
    Airport{IataCode{"YMG"}, CountryId{"CA"}, Timezone{3471}}, // Manitouwadge Airport
    Airport{IataCode{"YMH"}, CountryId{"CA"}, Timezone{3291}}, // Mary's Harbour Airport
    Airport{IataCode{"YML"}, CountryId{"CA"}, Timezone{3471}}, // Charlevoix Airport
    Airport{IataCode{"YMM"}, CountryId{"CA"}, Timezone{1715}}, // Fort McMurray International Airport
    Airport{IataCode{"YMN"}, CountryId{"CA"}, Timezone{1859}}, // Makkovik Airport
    Airport{IataCode{"YMO"}, CountryId{"CA"}, Timezone{3471}}, // Moosonee Airport
    Airport{IataCode{"YMP"}, CountryId{"CA"}, Timezone{3503}}, // Port McNeill Airport
    Airport{IataCode{"YMS"}, CountryId{"PE"}, Timezone{2365}}, // Moisés Benzaquén Rengifo Airport
    Airport{IataCode{"YMT"}, CountryId{"CA"}, Timezone{3471}}, // Chibougamau/Chapais Airport
    Airport{IataCode{"YMU"}, CountryId{"CA"}, Timezone{3503}}, // Mansons Landing Water Aerodrome
    Airport{IataCode{"YMV"}, CountryId{"CA"}, Timezone{2228}}, // Mary River Aerodrome
    Airport{IataCode{"YMW"}, CountryId{"CA"}, Timezone{3471}}, // Maniwaki Airport
    Airport{IataCode{"YMX"}, CountryId{"CA"}, Timezone{3471}}, // Montréal–Mirabel International Airport
    Airport{IataCode{"YNA"}, CountryId{"CA"}, Timezone{3471}}, // Natashquan Airport
    Airport{IataCode{"YNB"}, CountryId{"SA"}, Timezone{4404}}, // Yanbu Airport
    Airport{IataCode{"YNC"}, CountryId{"CA"}, Timezone{3471}}, // Wemindji Airport
    Airport{IataCode{"YND"}, CountryId{"CA"}, Timezone{3471}}, // Gatineau-Ottawa Executive Airport
    Airport{IataCode{"YNE"}, CountryId{"CA"}, Timezone{3540}}, // Norway House Airport
    Airport{IataCode{"YNG"}, CountryId{"US"}, Timezone{2712}}, // Youngstown-Warren Regional Airport
    Airport{IataCode{"YNH"}, CountryId{"CA"}, Timezone{1646}}, // Hudson's Hope Airport
    Airport{IataCode{"YNJ"}, CountryId{"CN"}, Timezone{4456}}, // Yanji Chaoyangchuan Airport
    Airport{IataCode{"YNL"}, CountryId{"CA"}, Timezone{3109}}, // Points North Landing Airport
    Airport{IataCode{"YNM"}, CountryId{"CA"}, Timezone{3471}}, // Matagami Airport
    Airport{IataCode{"YNO"}, CountryId{"CA"}, Timezone{3540}}, // North Spirit Lake Airport
    Airport{IataCode{"YNP"}, CountryId{"CA"}, Timezone{1859}}, // Natuashish Airport
    Airport{IataCode{"YNR"}, CountryId{"CA"}, Timezone{3540}}, // Arnes Airport
    Airport{IataCode{"YNS"}, CountryId{"CA"}, Timezone{3471}}, // Nemiscau Airport
    Airport{IataCode{"YNT"}, CountryId{"CN"}, Timezone{4456}}, // Yantai Penglai International Airport
    Airport{IataCode{"YNX"}, CountryId{"CA"}, Timezone{3573}}, // Snap Lake Airport
    Airport{IataCode{"YNY"}, CountryId{"KR"}, Timezone{4445}}, // Yangyang International Airport
    Airport{IataCode{"YNZ"}, CountryId{"CN"}, Timezone{4456}}, // Yancheng Nanyang Airport
    Airport{IataCode{"YOA"}, CountryId{"CA"}, Timezone{3573}}, // Ekati Airport
    Airport{IataCode{"YOC"}, CountryId{"CA"}, Timezone{3521}}, // Old Crow Airport
    Airport{IataCode{"YOE"}, CountryId{"CA"}, Timezone{1715}}, // Donnelly Airport
    Airport{IataCode{"YOG"}, CountryId{"CA"}, Timezone{3471}}, // Ogoki Post Airport
    Airport{IataCode{"YOH"}, CountryId{"CA"}, Timezone{3540}}, // Oxford House Airport
    Airport{IataCode{"YOI"}, CountryId{"CA"}, Timezone{3471}}, // Opinaca Aerodrome
    Airport{IataCode{"YOJ"}, CountryId{"CA"}, Timezone{1715}}, // High Level Airport
    Airport{IataCode{"YOL"}, CountryId{"NG"}, Timezone{462}}, // Yola Airport
    Airport{IataCode{"YON"}, CountryId{"BT"}, Timezone{4555}}, // Yongphulla Airport
    Airport{IataCode{"YOO"}, CountryId{"CA"}, Timezone{3471}}, // Oshawa Airport
    Airport{IataCode{"YOP"}, CountryId{"CA"}, Timezone{1715}}, // Rainbow Lake Airport
    Airport{IataCode{"YOS"}, CountryId{"CA"}, Timezone{3471}}, // Owen Sound Billy Bishop Regional Airport
    Airport{IataCode{"YOT"}, CountryId{"IL"}, Timezone{4046}}, // Yotvata Airfield
    Airport{IataCode{"YOW"}, CountryId{"CA"}, Timezone{3471}}, // Ottawa Macdonald-Cartier International Airport
    Airport{IataCode{"YPA"}, CountryId{"CA"}, Timezone{3109}}, // Prince Albert (Glass Field) Airport
    Airport{IataCode{"YPB"}, CountryId{"CA"}, Timezone{3503}}, // Port Alberni (Alberni Valley Regional) Airport
    Airport{IataCode{"YPC"}, CountryId{"CA"}, Timezone{3573}}, // Paulatuk (Nora Aliqatchialuk Ruben) Airport
    Airport{IataCode{"YPD"}, CountryId{"CA"}, Timezone{3471}}, // Parry Sound Area Municipal Airport
    Airport{IataCode{"YPE"}, CountryId{"CA"}, Timezone{1715}}, // Peace River Airport
    Airport{IataCode{"YPF"}, CountryId{"CA"}, Timezone{3503}}, // Esquimalt Airport
    Airport{IataCode{"YPG"}, CountryId{"CA"}, Timezone{3540}}, // Portage la Prairie Southport Airport
    Airport{IataCode{"YPH"}, CountryId{"CA"}, Timezone{3471}}, // Inukjuak Airport
    Airport{IataCode{"YPI"}, CountryId{"CA"}, Timezone{3503}}, // Port Simpson Water Aerodrome
    Airport{IataCode{"YPJ"}, CountryId{"CA"}, Timezone{3471}}, // Aupaluk Airport
    Airport{IataCode{"YPK"}, CountryId{"CA"}, Timezone{3503}}, // Pitt Meadows Airport
    Airport{IataCode{"YPL"}, CountryId{"CA"}, Timezone{3471}}, // Pickle Lake Airport
    Airport{IataCode{"YPM"}, CountryId{"CA"}, Timezone{3540}}, // Pikangikum Airport
    Airport{IataCode{"YPN"}, CountryId{"CA"}, Timezone{3471}}, // Port-Menier Airport
    Airport{IataCode{"YPO"}, CountryId{"CA"}, Timezone{3471}}, // Peawanuck Airport
    Airport{IataCode{"YPQ"}, CountryId{"CA"}, Timezone{3471}}, // Peterborough Airport
    Airport{IataCode{"YPR"}, CountryId{"CA"}, Timezone{3503}}, // Prince Rupert Airport
    Airport{IataCode{"YPS"}, CountryId{"CA"}, Timezone{1964}}, // Port Hawkesbury Airport
    Airport{IataCode{"YPT"}, CountryId{"CA"}, Timezone{3503}}, // Pender Harbour Water Aerodrome
    Airport{IataCode{"YPW"}, CountryId{"CA"}, Timezone{3503}}, // Powell River Airport
    Airport{IataCode{"YPX"}, CountryId{"CA"}, Timezone{3471}}, // Puvirnituq Airport
    Airport{IataCode{"YPY"}, CountryId{"CA"}, Timezone{1715}}, // Fort Chipewyan Airport
    Airport{IataCode{"YPZ"}, CountryId{"CA"}, Timezone{3503}}, // Burns Lake Airport
    Airport{IataCode{"YQA"}, CountryId{"CA"}, Timezone{3471}}, // Muskoka Airport
    Airport{IataCode{"YQB"}, CountryId{"CA"}, Timezone{3471}}, // Québec City Jean Lesage International Airport
    Airport{IataCode{"YQC"}, CountryId{"CA"}, Timezone{2228}}, // Quaqtaq Airport
    Airport{IataCode{"YQD"}, CountryId{"CA"}, Timezone{3540}}, // The Pas Airport
    Airport{IataCode{"YQF"}, CountryId{"CA"}, Timezone{1715}}, // Red Deer Regional Airport
    Airport{IataCode{"YQG"}, CountryId{"CA"}, Timezone{}}, // Windsor International Airport
    Airport{IataCode{"YQH"}, CountryId{"CA"}, Timezone{3521}}, // Watson Lake Airport
    Airport{IataCode{"YQI"}, CountryId{"CA"}, Timezone{1964}}, // Yarmouth Airport
    Airport{IataCode{"YQK"}, CountryId{"CA"}, Timezone{3540}}, // Kenora Airport
    Airport{IataCode{"YQL"}, CountryId{"CA"}, Timezone{1715}}, // Lethbridge Airport
    Airport{IataCode{"YQM"}, CountryId{"CA"}, Timezone{2625}}, // Greater Moncton International Airport
    Airport{IataCode{"YQN"}, CountryId{"CA"}, Timezone{3471}}, // Nakina Airport
    Airport{IataCode{"YQR"}, CountryId{"CA"}, Timezone{3109}}, // Regina International Airport
    Airport{IataCode{"YQS"}, CountryId{"CA"}, Timezone{3471}}, // St. Thomas Municipal Airport
    Airport{IataCode{"YQT"}, CountryId{"CA"}, Timezone{3435}}, // Thunder Bay International Airport
    Airport{IataCode{"YQU"}, CountryId{"CA"}, Timezone{1715}}, // Grande Prairie Airport
    Airport{IataCode{"YQV"}, CountryId{"CA"}, Timezone{3109}}, // Yorkton Municipal Airport
    Airport{IataCode{"YQW"}, CountryId{"CA"}, Timezone{3109}}, // North Battleford Airport
    Airport{IataCode{"YQX"}, CountryId{"CA"}, Timezone{3291}}, // Gander International Airport
    Airport{IataCode{"YQY"}, CountryId{"CA"}, Timezone{1807}}, // Sydney/J.A. Douglas McCurdy Airport
    Airport{IataCode{"YQZ"}, CountryId{"CA"}, Timezone{3503}}, // Quesnel Airport
    Airport{IataCode{"YRA"}, CountryId{"CA"}, Timezone{3573}}, // Gamètì/Rae Lakes Airport
    Airport{IataCode{"YRB"}, CountryId{"CA"}, Timezone{3124}}, // Resolute Bay Airport
    Airport{IataCode{"YRC"}, CountryId{"CA"}, Timezone{3471}}, // Chicoutimi/Saint-Honoré Aerodrome
    Airport{IataCode{"YRF"}, CountryId{"CA"}, Timezone{1859}}, // Cartwright Airport
    Airport{IataCode{"YRG"}, CountryId{"CA"}, Timezone{1859}}, // Rigolet Airport
    Airport{IataCode{"YRI"}, CountryId{"CA"}, Timezone{3471}}, // Rivière-du-Loup Airport
    Airport{IataCode{"YRJ"}, CountryId{"CA"}, Timezone{3471}}, // Roberval Airport
    Airport{IataCode{"YRL"}, CountryId{"CA"}, Timezone{3540}}, // Red Lake Airport
    Airport{IataCode{"YRM"}, CountryId{"CA"}, Timezone{1715}}, // Rocky Mountain House Airport
    Airport{IataCode{"YRN"}, CountryId{"CA"}, Timezone{3503}}, // Rivers Inlet Water Aerodrome
    Airport{IataCode{"YRO"}, CountryId{"CA"}, Timezone{3471}}, // Ottawa/Rockcliffe Airport
    Airport{IataCode{"YRP"}, CountryId{"CA"}, Timezone{3471}}, // Carp Airport
    Airport{IataCode{"YRQ"}, CountryId{"CA"}, Timezone{3471}}, // Trois-Rivières Airport
    Airport{IataCode{"YRS"}, CountryId{"CA"}, Timezone{3540}}, // Red Sucker Lake Airport
    Airport{IataCode{"YRT"}, CountryId{"CA"}, Timezone{3073}}, // Rankin Inlet Airport
    Airport{IataCode{"YRV"}, CountryId{"CA"}, Timezone{3503}}, // Revelstoke Airport
    Airport{IataCode{"YSA"}, CountryId{"CA"}, Timezone{1964}}, // Sable Island Aerodrome
    Airport{IataCode{"YSB"}, CountryId{"CA"}, Timezone{3471}}, // Sudbury Airport
    Airport{IataCode{"YSC"}, CountryId{"CA"}, Timezone{3471}}, // Sherbrooke Airport
    Airport{IataCode{"YSE"}, CountryId{"CA"}, Timezone{3503}}, // Squamish Airport
    Airport{IataCode{"YSF"}, CountryId{"CA"}, Timezone{3109}}, // Stony Rapids Airport
    Airport{IataCode{"YSG"}, CountryId{"CA"}, Timezone{3573}}, // Lutselk'e Airport
    Airport{IataCode{"YSH"}, CountryId{"CA"}, Timezone{3471}}, // Smiths Falls-Montague Airport
    Airport{IataCode{"YSI"}, CountryId{"CA"}, Timezone{3471}}, // Parry Sound/Frying Pan Island-Sans Souci Water Aerodrome
    Airport{IataCode{"YSJ"}, CountryId{"CA"}, Timezone{2625}}, // Saint John Airport
    Airport{IataCode{"YSK"}, CountryId{"CA"}, Timezone{2228}}, // Sanikiluaq Airport
    Airport{IataCode{"YSL"}, CountryId{"CA"}, Timezone{2625}}, // Saint-Léonard Aerodrome
    Airport{IataCode{"YSM"}, CountryId{"CA"}, Timezone{3573}}, // Fort Smith Airport
    Airport{IataCode{"YSN"}, CountryId{"CA"}, Timezone{3503}}, // Salmon Arm Airport
    Airport{IataCode{"YSO"}, CountryId{"CA"}, Timezone{1859}}, // Postville Airport
    Airport{IataCode{"YSP"}, CountryId{"CA"}, Timezone{3471}}, // Marathon Aerodrome
    Airport{IataCode{"YSQ"}, CountryId{"CN"}, Timezone{4456}}, // Songyuan Chaganhu Airport
    Airport{IataCode{"YSR"}, CountryId{"CA"}, Timezone{2228}}, // Nanisivik Airport
    Airport{IataCode{"YST"}, CountryId{"CA"}, Timezone{3540}}, // St. Theresa Point Airport
    Airport{IataCode{"YSU"}, CountryId{"CA"}, Timezone{1964}}, // Summerside Airport
    Airport{IataCode{"YSV"}, CountryId{"CA"}, Timezone{1859}}, // Saglek Airport
    Airport{IataCode{"YSX"}, CountryId{"CA"}, Timezone{3503}}, // Bella Bella/Shearwater Water Aerodrome
    Airport{IataCode{"YSY"}, CountryId{"CA"}, Timezone{3573}}, // Sachs Harbour (David Nasogaluak Jr. Saaryuaq) Airport
    Airport{IataCode{"YTA"}, CountryId{"CA"}, Timezone{3471}}, // Pembroke Airport
    Airport{IataCode{"YTB"}, CountryId{"CA"}, Timezone{3503}}, // Hartley Bay Water Aerodrome
    Airport{IataCode{"YTD"}, CountryId{"CA"}, Timezone{3540}}, // Thicket Portage Airport
    Airport{IataCode{"YTE"}, CountryId{"CA"}, Timezone{2228}}, // Cape Dorset Airport
    Airport{IataCode{"YTF"}, CountryId{"CA"}, Timezone{3471}}, // Alma Airport
    Airport{IataCode{"YTG"}, CountryId{"CA"}, Timezone{3503}}, // Sullivan Bay Water Aerodrome
    Airport{IataCode{"YTH"}, CountryId{"CA"}, Timezone{3540}}, // Thompson Airport
    Airport{IataCode{"YTJ"}, CountryId{"CA"}, Timezone{3471}}, // Terrace Bay Airport
    Airport{IataCode{"YTL"}, CountryId{"CA"}, Timezone{3540}}, // Big Trout Lake Airport
    Airport{IataCode{"YTM"}, CountryId{"CA"}, Timezone{3471}}, // Mont Tremblant International Airport
    Airport{IataCode{"YTN"}, CountryId{"CA"}, Timezone{1964}}, // Trenton Aerodrome
    Airport{IataCode{"YTP"}, CountryId{"CA"}, Timezone{3503}}, // Tofino Harbour Water Aerodrome
    Airport{IataCode{"YTQ"}, CountryId{"CA"}, Timezone{3471}}, // Tasiujaq Airport
    Airport{IataCode{"YTS"}, CountryId{"CA"}, Timezone{3471}}, // Timmins/Victor M. Power Airport
    Airport{IataCode{"YTT"}, CountryId{"CA"}, Timezone{3109}}, // Tisdale Airport
    Airport{IataCode{"YTU"}, CountryId{"CA"}, Timezone{3503}}, // Tasu Water Aerodrome
    Airport{IataCode{"YTX"}, CountryId{"CA"}, Timezone{3503}}, // Telegraph Creek Airport
    Airport{IataCode{"YTY"}, CountryId{"CN"}, Timezone{4456}}, // Yangzhou Taizhou Airport
    Airport{IataCode{"YTZ"}, CountryId{"CA"}, Timezone{3471}}, // Billy Bishop Toronto City Airport
    Airport{IataCode{"YUB"}, CountryId{"CA"}, Timezone{3573}}, // Tuktoyaktuk/James Gruben Airport
    Airport{IataCode{"YUD"}, CountryId{"CA"}, Timezone{2228}}, // Umiujaq Airport
    Airport{IataCode{"YUE"}, CountryId{"AU"}, Timezone{4978}}, // Yuendumu Airport
    Airport{IataCode{"YUL"}, CountryId{"CA"}, Timezone{3471}}, // Montréal–Pierre Elliott Trudeau International Airport
    Airport{IataCode{"YUM"}, CountryId{"US"}, Timezone{2931}}, // Yuma International Airport
    Airport{IataCode{"YUS"}, CountryId{"CN"}, Timezone{4456}}, // Yushu Batang Airport
    Airport{IataCode{"YUT"}, CountryId{"CA"}, Timezone{3073}}, // Repulse Bay Airport
    Airport{IataCode{"YUX"}, CountryId{"CA"}, Timezone{2228}}, // Hall Beach Airport
    Airport{IataCode{"YUY"}, CountryId{"CA"}, Timezone{3471}}, // Rouyn-Noranda Airport
    Airport{IataCode{"YVA"}, CountryId{"KM"}, Timezone{}}, // Iconi Airport
    Airport{IataCode{"YVB"}, CountryId{"CA"}, Timezone{3471}}, // Bonaventure Airport
    Airport{IataCode{"YVC"}, CountryId{"CA"}, Timezone{3109}}, // La Ronge (Barber Field) Airport
    Airport{IataCode{"YVE"}, CountryId{"CA"}, Timezone{3503}}, // Vernon Regional Airport
    Airport{IataCode{"YVG"}, CountryId{"CA"}, Timezone{1715}}, // Vermilion Airport
    Airport{IataCode{"YVM"}, CountryId{"CA"}, Timezone{2892}}, // Qikiqtarjuaq Airport
    Airport{IataCode{"YVO"}, CountryId{"CA"}, Timezone{3471}}, // Val-d'Or Airport
    Airport{IataCode{"YVP"}, CountryId{"CA"}, Timezone{3471}}, // Kuujjuaq Airport
    Airport{IataCode{"YVQ"}, CountryId{"CA"}, Timezone{3573}}, // Norman Wells Airport
    Airport{IataCode{"YVR"}, CountryId{"CA"}, Timezone{3503}}, // Vancouver International Airport
    Airport{IataCode{"YVT"}, CountryId{"CA"}, Timezone{3109}}, // Buffalo Narrows Airport
    Airport{IataCode{"YVV"}, CountryId{"CA"}, Timezone{3471}}, // Wiarton Airport
    Airport{IataCode{"YVZ"}, CountryId{"CA"}, Timezone{3540}}, // Deer Lake Airport
    Airport{IataCode{"YWA"}, CountryId{"CA"}, Timezone{3471}}, // Petawawa Airport
    Airport{IataCode{"YWB"}, CountryId{"CA"}, Timezone{3471}}, // Kangiqsujuaq Airport
    Airport{IataCode{"YWG"}, CountryId{"CA"}, Timezone{3540}}, // Winnipeg James Armstrong Richardson International Airport
    Airport{IataCode{"YWH"}, CountryId{"CA"}, Timezone{3503}}, // Victoria Inner Harbour Airport
    Airport{IataCode{"YWJ"}, CountryId{"CA"}, Timezone{3573}}, // Déline Airport
    Airport{IataCode{"YWK"}, CountryId{"CA"}, Timezone{1859}}, // Wabush Airport
    Airport{IataCode{"YWL"}, CountryId{"CA"}, Timezone{3503}}, // Williams Lake Airport
    Airport{IataCode{"YWM"}, CountryId{"CA"}, Timezone{3291}}, // Williams Harbour Airport
    Airport{IataCode{"YWO"}, CountryId{"CA"}, Timezone{1405}}, // Lupin Airport
    Airport{IataCode{"YWP"}, CountryId{"CA"}, Timezone{3471}}, // Webequie Airport
    Airport{IataCode{"YWQ"}, CountryId{"CA"}, Timezone{3471}}, // Chutes-des-Passes/Lac Margane Water Aerodrome
    Airport{IataCode{"YWR"}, CountryId{"CA"}, Timezone{3471}}, // White River Water Aerodrome
    Airport{IataCode{"YWS"}, CountryId{"CA"}, Timezone{3503}}, // Whistler/Green Lake Water Aerodrome
    Airport{IataCode{"YWV"}, CountryId{"CA"}, Timezone{1715}}, // Wainwright Aerodrome
    Airport{IataCode{"YWY"}, CountryId{"CA"}, Timezone{3573}}, // Wrigley Airport
    Airport{IataCode{"YXC"}, CountryId{"CA"}, Timezone{1715}}, // Canadian Rockies International Airport
    Airport{IataCode{"YXD"}, CountryId{"CA"}, Timezone{1715}}, // Edmonton City Centre (Blatchford Field) Airport
    Airport{IataCode{"YXE"}, CountryId{"CA"}, Timezone{3109}}, // Saskatoon John G. Diefenbaker International Airport
    Airport{IataCode{"YXH"}, CountryId{"CA"}, Timezone{1715}}, // Medicine Hat Airport
    Airport{IataCode{"YXI"}, CountryId{"CA"}, Timezone{3471}}, // Killaloe/Bonnechere Airport
    Airport{IataCode{"YXJ"}, CountryId{"CA"}, Timezone{1646}}, // Fort St. John Airport
    Airport{IataCode{"YXK"}, CountryId{"CA"}, Timezone{3471}}, // Rimouski Airport
    Airport{IataCode{"YXL"}, CountryId{"CA"}, Timezone{3540}}, // Sioux Lookout Airport
    Airport{IataCode{"YXN"}, CountryId{"CA"}, Timezone{3073}}, // Whale Cove Airport
    Airport{IataCode{"YXP"}, CountryId{"CA"}, Timezone{2892}}, // Pangnirtung Airport
    Airport{IataCode{"YXQ"}, CountryId{"CA"}, Timezone{3521}}, // Beaver Creek Airport
    Airport{IataCode{"YXR"}, CountryId{"CA"}, Timezone{3471}}, // Earlton (Timiskaming Regional) Airport
    Airport{IataCode{"YXS"}, CountryId{"CA"}, Timezone{3503}}, // Prince George Airport
    Airport{IataCode{"YXT"}, CountryId{"CA"}, Timezone{3503}}, // Northwest Regional Airport
    Airport{IataCode{"YXU"}, CountryId{"CA"}, Timezone{3471}}, // London International Airport
    Airport{IataCode{"YXX"}, CountryId{"CA"}, Timezone{3503}}, // Abbotsford International Airport
    Airport{IataCode{"YXY"}, CountryId{"CA"}, Timezone{3521}}, // Erik Nielsen Whitehorse International Airport
    Airport{IataCode{"YXZ"}, CountryId{"CA"}, Timezone{3471}}, // Wawa Airport
    Airport{IataCode{"YYB"}, CountryId{"CA"}, Timezone{3471}}, // North Bay/Jack Garland Airport
    Airport{IataCode{"YYC"}, CountryId{"CA"}, Timezone{1715}}, // Calgary International Airport
    Airport{IataCode{"YYD"}, CountryId{"CA"}, Timezone{3503}}, // Smithers Airport
    Airport{IataCode{"YYE"}, CountryId{"CA"}, Timezone{1769}}, // Fort Nelson Airport
    Airport{IataCode{"YYF"}, CountryId{"CA"}, Timezone{3503}}, // Penticton Regional Airport
    Airport{IataCode{"YYG"}, CountryId{"CA"}, Timezone{1964}}, // Charlottetown Airport
    Airport{IataCode{"YYH"}, CountryId{"CA"}, Timezone{1405}}, // Taloyoak Airport
    Airport{IataCode{"YYJ"}, CountryId{"CA"}, Timezone{3503}}, // Victoria International Airport
    Airport{IataCode{"YYL"}, CountryId{"CA"}, Timezone{3540}}, // Lynn Lake Airport
    Airport{IataCode{"YYM"}, CountryId{"CA"}, Timezone{1715}}, // Cowley Airport
    Airport{IataCode{"YYN"}, CountryId{"CA"}, Timezone{3109}}, // Swift Current Airport
    Airport{IataCode{"YYO"}, CountryId{"CA"}, Timezone{3109}}, // Wynyard/W. B. Needham Field Aerodrome
    Airport{IataCode{"YYQ"}, CountryId{"CA"}, Timezone{3540}}, // Churchill Airport
    Airport{IataCode{"YYT"}, CountryId{"CA"}, Timezone{3291}}, // St. John's International Airport
    Airport{IataCode{"YYU"}, CountryId{"CA"}, Timezone{3471}}, // Kapuskasing Airport
    Airport{IataCode{"YYW"}, CountryId{"CA"}, Timezone{3471}}, // Armstrong Airport
    Airport{IataCode{"YYY"}, CountryId{"CA"}, Timezone{3471}}, // Mont-Joli Airport
    Airport{IataCode{"YYZ"}, CountryId{"CA"}, Timezone{3471}}, // Toronto Pearson International Airport
    Airport{IataCode{"YZA"}, CountryId{"CA"}, Timezone{3503}}, // Cache Creek Airport
    Airport{IataCode{"YZD"}, CountryId{"CA"}, Timezone{3471}}, // Downsview Airport
    Airport{IataCode{"YZE"}, CountryId{"CA"}, Timezone{3471}}, // Gore Bay-Manitoulin Airport
    Airport{IataCode{"YZF"}, CountryId{"CA"}, Timezone{3573}}, // Yellowknife Airport
    Airport{IataCode{"YZG"}, CountryId{"CA"}, Timezone{3471}}, // Salluit Airport
    Airport{IataCode{"YZH"}, CountryId{"CA"}, Timezone{1715}}, // Slave Lake Airport
    Airport{IataCode{"YZP"}, CountryId{"CA"}, Timezone{3503}}, // Sandspit Airport
    Airport{IataCode{"YZR"}, CountryId{"CA"}, Timezone{}}, // Sarnia Chris Hadfield Airport
    Airport{IataCode{"YZS"}, CountryId{"CA"}, Timezone{1237}}, // Coral Harbour Airport
    Airport{IataCode{"YZT"}, CountryId{"CA"}, Timezone{3503}}, // Port Hardy Airport
    Airport{IataCode{"YZU"}, CountryId{"CA"}, Timezone{1715}}, // Whitecourt Airport
    Airport{IataCode{"YZV"}, CountryId{"CA"}, Timezone{3471}}, // Sept-Îles Airport
    Airport{IataCode{"YZW"}, CountryId{"CA"}, Timezone{3521}}, // Teslin Airport
    Airport{IataCode{"YZY"}, CountryId{"CN"}, Timezone{4456}}, // Zhangye Ganzhou Airport
    Airport{IataCode{"YZZ"}, CountryId{"CA"}, Timezone{3503}}, // Trail Airport
    Airport{IataCode{"ZAA"}, CountryId{"CA"}, Timezone{3503}}, // Alice Arm/Silver City Water Aerodrome
    Airport{IataCode{"ZAC"}, CountryId{"CA"}, Timezone{3540}}, // York Landing Airport
    Airport{IataCode{"ZAD"}, CountryId{"HR"}, Timezone{5989}}, // Zadar Airport
    Airport{IataCode{"ZAG"}, CountryId{"HR"}, Timezone{5989}}, // Zagreb Airport
    Airport{IataCode{"ZAH"}, CountryId{"IR"}, Timezone{4543}}, // Zahedan Airport
    Airport{IataCode{"ZAJ"}, CountryId{"AF"}, Timezone{4543}}, // Zaranj Airport
    Airport{IataCode{"ZAL"}, CountryId{"CL"}, Timezone{3177}}, // Pichoy Airfield
    Airport{IataCode{"ZAM"}, CountryId{"PH"}, Timezone{4240}}, // Zamboanga International Airport
    Airport{IataCode{"ZAP"}, CountryId{"MX"}, Timezone{2588}}, // Zapopan Airport
    Airport{IataCode{"ZAR"}, CountryId{"NG"}, Timezone{462}}, // Zaria Airport
    Airport{IataCode{"ZAT"}, CountryId{"CN"}, Timezone{4456}}, // Zhaotong Airport
    Airport{IataCode{"ZAZ"}, CountryId{"ES"}, Timezone{5549}}, // Zaragoza Airport
    Airport{IataCode{"ZBF"}, CountryId{"CA"}, Timezone{2625}}, // Bathurst Airport
    Airport{IataCode{"ZBG"}, CountryId{"PL"}, Timezone{5975}}, // Elbląg Airport
    Airport{IataCode{"ZBK"}, CountryId{"ME"}, Timezone{5659}}, // Žabljak Airport
    Airport{IataCode{"ZBL"}, CountryId{"AU"}, Timezone{4920}}, // Biloela Airport
    Airport{IataCode{"ZBM"}, CountryId{"CA"}, Timezone{3471}}, // Roland-Désourdy Airport
    Airport{IataCode{"ZBO"}, CountryId{"AU"}, Timezone{4920}}, // Bowen Airport
    Airport{IataCode{"ZBR"}, CountryId{"IR"}, Timezone{4543}}, // Konarak Airport
    Airport{IataCode{"ZBY"}, CountryId{"LA"}, Timezone{4633}}, // Sayaboury Airport
    Airport{IataCode{"ZCA"}, CountryId{"DE"}, Timezone{5199}}, // Arnsberg Menden
    Airport{IataCode{"ZCC"}, CountryId{"DE"}, Timezone{5646}}, // Oos Airport
    Airport{IataCode{"ZCL"}, CountryId{"MX"}, Timezone{2588}}, // General Leobardo C. Ruiz International Airport
    Airport{IataCode{"ZCO"}, CountryId{"CL"}, Timezone{3177}}, // Aeropuerto La Araucanía
    Airport{IataCode{"ZCQ"}, CountryId{"CL"}, Timezone{3177}}, // General Freire Airfield
    Airport{IataCode{"ZDY"}, CountryId{"AE"}, Timezone{3902}}, // Dalma Airport
    Airport{IataCode{"ZEF"}, CountryId{"US"}, Timezone{2712}}, // Elkin Municipal Airport
    Airport{IataCode{"ZEL"}, CountryId{"CA"}, Timezone{3503}}, // Bella Bella Airport
    Airport{IataCode{"ZEM"}, CountryId{"CA"}, Timezone{2228}}, // Eastmain River Airport
    Airport{IataCode{"ZER"}, CountryId{"IN"}, Timezone{4129}}, // Zero Airport
    Airport{IataCode{"ZFA"}, CountryId{"CA"}, Timezone{3521}}, // Faro Airport
    Airport{IataCode{"ZFD"}, CountryId{"CA"}, Timezone{3109}}, // Fond-du-Lac Airport
    Airport{IataCode{"ZFM"}, CountryId{"CA"}, Timezone{3573}}, // Fort McPherson Airport
    Airport{IataCode{"ZFN"}, CountryId{"CA"}, Timezone{3573}}, // Tulita Airport
    Airport{IataCode{"ZFW"}, CountryId{"CA"}, Timezone{1715}}, // Fairview Airport
    Airport{IataCode{"ZGF"}, CountryId{"CA"}, Timezone{3503}}, // Grand Forks Airport
    Airport{IataCode{"ZGI"}, CountryId{"CA"}, Timezone{3540}}, // Gods River Airport
    Airport{IataCode{"ZGL"}, CountryId{"AU"}, Timezone{}}, // South Galway Airport
    Airport{IataCode{"ZGM"}, CountryId{"ZM"}, Timezone{537}}, // Ngoma Airport
    Airport{IataCode{"ZGR"}, CountryId{"CA"}, Timezone{3540}}, // Little Grand Rapids Airport
    Airport{IataCode{"ZGS"}, CountryId{"CA"}, Timezone{1337}}, // La Romaine Airport
    Airport{IataCode{"ZGU"}, CountryId{"VU"}, Timezone{6301}}, // Gaua Airport
    Airport{IataCode{"ZHA"}, CountryId{"CN"}, Timezone{4456}}, // Zhanjiang Airport
    Airport{IataCode{"ZHM"}, CountryId{"BD"}, Timezone{3881}}, // Shamshernagar Airport
    Airport{IataCode{"ZHP"}, CountryId{"CA"}, Timezone{1715}}, // High Prairie Airport
    Airport{IataCode{"ZHV"}, CountryId{"CH"}, Timezone{5646}}, // Les Eplatures Airport
    Airport{IataCode{"ZHY"}, CountryId{"CN"}, Timezone{4456}}, // Zhongwei Shapotou Airport
    Airport{IataCode{"ZIA"}, CountryId{"RU"}, Timezone{5620}}, // Zhukovsky International Airport
    Airport{IataCode{"ZIC"}, CountryId{"CL"}, Timezone{3177}}, // Victoria Airport
    Airport{IataCode{"ZIG"}, CountryId{"SN"}, Timezone{243}}, // Ziguinchor Airport
    Airport{IataCode{"ZIH"}, CountryId{"MX"}, Timezone{2588}}, // Ixtapa-Zihuatanejo International Airport
    Airport{IataCode{"ZIN"}, CountryId{"CH"}, Timezone{6021}}, // Interlaken Airport
    Airport{IataCode{"ZIS"}, CountryId{}, Timezone{757}}, // Alzintan Airport
    Airport{IataCode{"ZIX"}, CountryId{"RU"}, Timezone{4665}}, // Zhigansk Airport
    Airport{IataCode{"ZJG"}, CountryId{"CA"}, Timezone{3540}}, // Jenpeg Airport
    Airport{IataCode{"ZJI"}, CountryId{"CH"}, Timezone{6021}}, // Locarno Airport
    Airport{IataCode{"ZJN"}, CountryId{"CA"}, Timezone{3540}}, // Swan River Airport
    Airport{IataCode{"ZKB"}, CountryId{"ZM"}, Timezone{537}}, // Kasaba Bay Airport
    Airport{IataCode{"ZKE"}, CountryId{"CA"}, Timezone{3471}}, // Kashechewan Airport
    Airport{IataCode{"ZKG"}, CountryId{"CA"}, Timezone{3471}}, // Kegaska Airport
    Airport{IataCode{"ZKM"}, CountryId{"GA"}, Timezone{475}}, // Sette Cama Airport
    Airport{IataCode{"ZKP"}, CountryId{"RU"}, Timezone{4485}}, // Zyryanka Airport
    Airport{IataCode{"ZLG"}, CountryId{"MA"}, Timezone{307}}, // La Güera Airport
    Airport{IataCode{"ZLO"}, CountryId{"MX"}, Timezone{2588}}, // Playa de Oro International Airport
    Airport{IataCode{"ZLR"}, CountryId{"CL"}, Timezone{3177}}, // Linares Airport
    Airport{IataCode{"ZLT"}, CountryId{"CA"}, Timezone{1337}}, // La Tabatière Airport
    Airport{IataCode{"ZLX"}, CountryId{"SD"}, Timezone{432}}, // Zalingei Airport
    Airport{IataCode{"ZMG"}, CountryId{"DE"}, Timezone{5199}}, // Magdeburg Aerodrome
    Airport{IataCode{"ZMH"}, CountryId{"CA"}, Timezone{3503}}, // South Cariboo Regional Airport
    Airport{IataCode{"ZMM"}, CountryId{"MX"}, Timezone{2588}}, // Zamora Airport
    Airport{IataCode{"ZMO"}, CountryId{"IT"}, Timezone{5702}}, // Modena Airport
    Airport{IataCode{"ZMT"}, CountryId{"CA"}, Timezone{3503}}, // Masset Airport
    Airport{IataCode{"ZNA"}, CountryId{"CA"}, Timezone{3503}}, // Nanaimo Harbour Water Airport
    Airport{IataCode{"ZNC"}, CountryId{"US"}, Timezone{814}}, // Nyac Airport
    Airport{IataCode{"ZND"}, CountryId{"NE"}, Timezone{672}}, // Zinder Airport
    Airport{IataCode{"ZNE"}, CountryId{"AU"}, Timezone{5087}}, // Newman Airport
    Airport{IataCode{"ZNJ"}, CountryId{"ZA"}, Timezone{369}}, // Heilbron Airport
    Airport{IataCode{"ZNL"}, CountryId{"CA"}, Timezone{3503}}, // Nelson Airport
    Airport{IataCode{"ZNZ"}, CountryId{"TZ"}, Timezone{256}}, // Abeid Amani Karume International Airport
    Airport{IataCode{"ZOF"}, CountryId{"CA"}, Timezone{3503}}, // Ocean Falls Water Aerodrome
    Airport{IataCode{"ZOS"}, CountryId{"CL"}, Timezone{3177}}, // Cañal Bajo Carlos Hott Siebert Airport
    Airport{IataCode{"ZPB"}, CountryId{"CA"}, Timezone{3540}}, // Sachigo Lake Airport
    Airport{IataCode{"ZPC"}, CountryId{"CL"}, Timezone{3177}}, // Pucón Airport
    Airport{IataCode{"ZPH"}, CountryId{"US"}, Timezone{2712}}, // Zephyrhills Municipal Airport
    Airport{IataCode{"ZPO"}, CountryId{"CA"}, Timezone{3109}}, // Pinehouse Lake Airport
    Airport{IataCode{"ZQF"}, CountryId{"DE"}, Timezone{5199}}, // Trier-Föhren Airport
    Airport{IataCode{"ZQN"}, CountryId{"NZ"}, Timezone{6218}}, // Queenstown Airport
    Airport{IataCode{"ZQS"}, CountryId{"CA"}, Timezone{3503}}, // Queen Charlotte City Water Aerodrome
    Airport{IataCode{"ZQV"}, CountryId{"DE"}, Timezone{5199}}, // Worms Airport
    Airport{IataCode{"ZQW"}, CountryId{"DE"}, Timezone{5199}}, // Zweibrücken Airport
    Airport{IataCode{"ZQZ"}, CountryId{"CN"}, Timezone{4456}}, // Zhangjiakou Ningyuan Airport
    Airport{IataCode{"ZRE"}, CountryId{"RS"}, Timezone{5183}}, // Zrenjanin Airport
    Airport{IataCode{"ZRH"}, CountryId{"CH"}, Timezone{6021}}, // Zurich Airport
    Airport{IataCode{"ZRI"}, CountryId{"ID"}, Timezone{}}, // Serui Airport
    Airport{IataCode{"ZRJ"}, CountryId{"CA"}, Timezone{3540}}, // Round Lake (Weagamow Lake) Airport
    Airport{IataCode{"ZRO"}, CountryId{"IT"}, Timezone{5702}}, // Reggio Emilia Airport
    Airport{IataCode{"ZSA"}, CountryId{"BS"}, Timezone{2697}}, // San Salvador Airport
    Airport{IataCode{"ZSE"}, CountryId{"FR"}, Timezone{6190}}, // Pierrefonds Airport
    Airport{IataCode{"ZSJ"}, CountryId{"CA"}, Timezone{3540}}, // Sandy Lake Airport
    Airport{IataCode{"ZSP"}, CountryId{"CA"}, Timezone{1715}}, // St. Paul Aerodrome
    Airport{IataCode{"ZSS"}, CountryId{"CI"}, Timezone{0}}, // Sassandra Airport
    Airport{IataCode{"ZST"}, CountryId{"CA"}, Timezone{3255}}, // Stewart Aerodrome
    Airport{IataCode{"ZSU"}, CountryId{"DE"}, Timezone{5199}}, // Dessau Aerodrome
    Airport{IataCode{"ZSW"}, CountryId{"CA"}, Timezone{3503}}, // Prince Rupert/Seal Cove Water Airport
    Airport{IataCode{"ZTA"}, CountryId{"FR"}, Timezone{6740}}, // Tureia Airport
    Airport{IataCode{"ZTB"}, CountryId{"CA"}, Timezone{1337}}, // Tête-à-la-Baleine Airport
    Airport{IataCode{"ZTH"}, CountryId{"GR"}, Timezone{5169}}, // Zakynthos International Airport
    Airport{IataCode{"ZTM"}, CountryId{"CA"}, Timezone{3540}}, // Shamattawa Airport
    Airport{IataCode{"ZTR"}, CountryId{"UA"}, Timezone{5461}}, // Zhytomyr Airport
    Airport{IataCode{"ZTS"}, CountryId{"CA"}, Timezone{3503}}, // Tahsis Water Aerodrome
    Airport{IataCode{"ZTU"}, CountryId{"AZ"}, Timezone{3754}}, // Zaqatala International Airport
    Airport{IataCode{"ZUC"}, CountryId{"CA"}, Timezone{3540}}, // Ignace Municipal Airport
    Airport{IataCode{"ZUD"}, CountryId{"CL"}, Timezone{3177}}, // Pupelde Airport
    Airport{IataCode{"ZUH"}, CountryId{"CN"}, Timezone{4456}}, // Zhuhai Sanzao Airport
    Airport{IataCode{"ZUL"}, CountryId{"AR"}, Timezone{883}}, // Azul Airport
    Airport{IataCode{"ZUM"}, CountryId{"CA"}, Timezone{1859}}, // Churchill Falls Airport
    Airport{IataCode{"ZUN"}, CountryId{"US"}, Timezone{1667}}, // Black Rock Airport
    Airport{IataCode{"ZVA"}, CountryId{"MG"}, Timezone{6035}}, // Miandrivazo Airport
    Airport{IataCode{"ZVG"}, CountryId{"AU"}, Timezone{5087}}, // Springvale Airport
    Airport{IataCode{"ZVK"}, CountryId{"LA"}, Timezone{3777}}, // Savannakhet Airport
    Airport{IataCode{"ZVL"}, CountryId{"CA"}, Timezone{1715}}, // Edmonton/Villeneuve Airport
    Airport{IataCode{"ZWA"}, CountryId{"MG"}, Timezone{6035}}, // Andapa Airport
    Airport{IataCode{"ZWL"}, CountryId{"CA"}, Timezone{3109}}, // Wollaston Lake Airport
    Airport{IataCode{"ZXB"}, CountryId{"NO"}, Timezone{3614}}, // Jan Mayensfield
    Airport{IataCode{"ZXT"}, CountryId{"AZ"}, Timezone{3754}}, // Zabrat Airport
    Airport{IataCode{"ZYI"}, CountryId{"CN"}, Timezone{4456}}, // Zunyi Xinzhou Airport
    Airport{IataCode{"ZYL"}, CountryId{"BD"}, Timezone{3881}}, // Osmani International Airport
    Airport{IataCode{"ZZO"}, CountryId{"RU"}, Timezone{4416}}, // Zonalnoye Airport
    Airport{IataCode{"ZZU"}, CountryId{"MW"}, Timezone{132}}, // Mzuzu Airport
    Airport{IataCode{"ZZV"}, CountryId{"US"}, Timezone{2712}}, // Zanesville Municipal Airport
};

// airport coordinates in latitude/longitude pairs
// stored out of line of the airport_table to avoid alignment padding
static constexpr Coordinate coordinate_table[] = {
    Coordinate{-145.512, -17.3489}, // AAA
    Coordinate{141.047, -26.6906}, // AAB
    Coordinate{33.8358, 31.0733}, // AAC
    Coordinate{7.80944, 36.8222}, // AAE
    Coordinate{-85.0275, 29.7275}, // AAF
    Coordinate{-49.7906, -24.1042}, // AAG
    Coordinate{-46.8856, -13.0239}, // AAI
    Coordinate{-55.5778, 3.89861}, // AAJ
    Coordinate{173.636, 0.185278}, // AAK
    Coordinate{9.84917, 57.0928}, // AAL
    Coordinate{31.5447, -24.8181}, // AAM
    Coordinate{55.6149, 24.2595}, // AAN
    Coordinate{-64.4708, 9.4303}, // AAO
    Coordinate{-95.5833, 29.7167}, // AAP
    Coordinate{37.3473, 45.0021}, // AAQ
    Coordinate{10.6192, 56.3042}, // AAR
    Coordinate{139.311, -3.88472}, // AAS
    Coordinate{88.0844, 47.7504}, // AAT
    Coordinate{-172.628, -13.505}, // AAU
    Coordinate{124.753, 6.36777}, // AAV
    Coordinate{73.2167, 34.15}, // AAW
    Coordinate{-46.9656, -19.5606}, // AAX
    Coordinate{52.1742, 16.1934}, // AAY
    Coordinate{-91.5019, 14.8656}, // AAZ
    Coordinate{91.3859, 53.7433}, // ABA
    Coordinate{6.65889, 6.20306}, // ABB
    Coordinate{-1.86333, 38.9483}, // ABC
    Coordinate{48.2283, 30.3711}, // ABD
    Coordinate{-75.4405, 40.6523}, // ABE
    Coordinate{173.04, 1.79639}, // ABF
    Coordinate{143.184, -17.6075}, // ABG
    Coordinate{146.583, -23.6467}, // ABH
    Coordinate{-99.6831, 32.4132}, // ABI
    Coordinate{-3.92578, 5.26142}, // ABJ
    Coordinate{44.2416, 6.73281}, // ABK
    Coordinate{-157.857, 67.1066}, // ABL
    Coordinate{142.459, -10.9508}, // ABM
    Coordinate{-54.05, 5.51667}, // ABN
    Coordinate{-3.26667, 5.43306}, // ABO
    Coordinate{141.1, -6.06667}, // ABP
    Coordinate{-106.609, 35.0403}, // ABQ
    Coordinate{-98.4228, 45.4483}, // ABR
    Coordinate{31.6117, 22.3758}, // ABS
    Coordinate{41.6343, 20.2961}, // ABT
    Coordinate{124.9, -9.33333}, // ABU
    Coordinate{7.26319, 9.00681}, // ABV
    Coordinate{148.7, -10.1667}, // ABW
    Coordinate{146.958, -36.0678}, // ABX
    Coordinate{-84.1944, 31.5356}, // ABY
    Coordinate{-2.19778, 57.2019}, // ABZ
    Coordinate{-99.754, 16.756}, // ACA
    Coordinate{-85.1983, 44.9886}, // ACB
    Coordinate{-0.167389, 5.60467}, // ACC
    Coordinate{-77.2739, 8.49806}, // ACD
    Coordinate{-13.6053, 28.9456}, // ACE
    Coordinate{9.56083, 47.485}, // ACH
    Coordinate{-2.21444, 49.7067}, // ACI
    Coordinate{80.4283, 8.30139}, // ACJ
    Coordinate{-70.059, 41.2529}, // ACK
    Coordinate{-72.9906, 4.74694}, // ACL
    Coordinate{-101.101, 29.3317}, // ACN
    Coordinate{46.1279, 37.348}, // ACP
    Coordinate{-93.5531, 44.0733}, // ACQ
    Coordinate{-72.3978, -0.601111}, // ACR
    Coordinate{90.5767, 56.2683}, // ACS
    Coordinate{-97.2306, 31.6114}, // ACT
    Coordinate{-78.0167, 9.18333}, // ACU
    Coordinate{-124.108, 40.9778}, // ACV
    Coordinate{104.959, 25.0883}, // ACX
    Coordinate{-74.5772, 39.4575}, // ACY
    Coordinate{61.5439, 31.0983}, // ACZ
    Coordinate{35.2803, 36.9819}, // ADA
    Coordinate{27.155, 38.2892}, // ADB
    Coordinate{145.733, -7.13333}, // ADC
    Coordinate{38.7994, 8.97778}, // ADD
    Coordinate{45.0288, 12.8295}, // ADE
    Coordinate{38.4689, 37.7317}, // ADF
    Coordinate{-84.0772, 41.8678}, // ADG
    Coordinate{125.4, 58.6}, // ADH
    Coordinate{14.98, -22.4622}, // ADI
    Coordinate{35.9914, 31.9725}, // ADJ
    Coordinate{-176.646, 51.8781}, // ADK
    Coordinate{138.531, -34.945}, // ADL
    Coordinate{-97.0206, 34.3042}, // ADM
    Coordinate{137.137, -30.4383}, // ADO
    Coordinate{81.6258, 7.33667}, // ADP
    Coordinate{-152.494, 57.7497}, // ADQ
    Coordinate{-79.5261, 33.4517}, // ADR
    Coordinate{-96.8364, 32.9686}, // ADS
    Coordinate{-96.6714, 34.8044}, // ADT
    Coordinate{48.4242, 38.3256}, // ADU
    Coordinate{26.1192, 11.4036}, // ADV
    Coordinate{29.0555, -22.679}, // ADY
    Coordinate{-81.7111, 12.5836}, // ADZ
    Coordinate{173.829, 0.490833}, // AEA
    Coordinate{106.959, 23.7194}, // AEB
    Coordinate{99.4305, 1.4001}, // AEG
    Coordinate{20.8442, 13.8469}, // AEH
    Coordinate{-5.44111, 36.1289}, // AEI
    Coordinate{-93.3672, 43.6817}, // AEL
    Coordinate{-9.63778, 16.7111}, // AEO
    Coordinate{-58.4164, -34.5589}, // AEP
    Coordinate{39.9567, 43.45}, // AER
    Coordinate{6.11972, 62.5625}, // AES
    Coordinate{-152.622, 66.5519}, // AET
    Coordinate{55.0317, 25.8756}, // AEU
    Coordinate{-92.5486, 31.3275}, // AEX
    Coordinate{-18.0727, 65.66}, // AEY
    Coordinate{-68.4036, -34.5967}, // AFA
    Coordinate{26.8797, -33.5542}, // AFD
    Coordinate{-133.91, 56.9614}, // AFE
    Coordinate{-75.0472, 6.89444}, // AFI
    Coordinate{-95.8678, 40.6056}, // AFK
    Coordinate{-56.105, -9.86639}, // AFL
    Coordinate{-72.003, 42.8051}, // AFN
    Coordinate{-110.942, 42.7089}, // AFO
    Coordinate{-80.0772, 35.0206}, // AFP
    Coordinate{64.2328, 41.6136}, // AFS
    Coordinate{160.948, -9.19139}, // AFT
    Coordinate{-97.3189, 32.9878}, // AFW
    Coordinate{30.6011, 38.7264}, // AFY
    Coordinate{57.5952, 36.1681}, // AFZ
    Coordinate{-9.41139, 30.3225}, // AGA
    Coordinate{-79.9302, 40.3544}, // AGC
    Coordinate{133.867, -1.38333}, // AGD
    Coordinate{0.590556, 44.1747}, // AGF
    Coordinate{12.8472, 56.2961}, // AGH
    Coordinate{-56.6333, 5.76667}, // AGI
    Coordinate{127.24, 26.5928}, // AGJ
    Coordinate{149.156, -9.3375}, // AGL
    Coordinate{-134.585, 57.5036}, // AGN
    Coordinate{-93.2169, 33.2275}, // AGO
    Coordinate{-4.49917, 36.675}, // AGP
    Coordinate{21.3511, 38.6019}, // AGQ
    Coordinate{-82.0628, 33.1994}, // AGS
    Coordinate{-54.8433, -25.4553}, // AGT
    Coordinate{-102.318, 21.7056}, // AGU
    Coordinate{-69.2375, 9.55333}, // AGV
    Coordinate{142.149, -12.1456}, // AGW
    Coordinate{72.1789, 10.8281}, // AGX
    Coordinate{128.75, -16.35}, // AGY
    Coordinate{18.8136, -29.2817}, // AGZ
    Coordinate{42.6566, 18.2404}, // AHB
    Coordinate{-97.1228, 34.1469}, // AHD
    Coordinate{-146.257, -14.4281}, // AHE
    Coordinate{-99.9064, 40.3394}, // AHF
    Coordinate{-92.3753, 45.2811}, // AHH
    Coordinate{128.917, -3.33333}, // AHI
    Coordinate{102.357, 32.5292}, // AHJ
    Coordinate{-59.3222, 2.47222}, // AHL
    Coordinate{-122.661, 42.1903}, // AHM
    Coordinate{-83.3264, 33.9486}, // AHN
    Coordinate{8.28861, 40.6311}, // AHO
    Coordinate{-96.5944, 41.2406}, // AHQ
    Coordinate{-84.3522, 15.4722}, // AHS
    Coordinate{-3.83944, 35.1769}, // AHU
    Coordinate{}, // AHY
    Coordinate{6.08361, 45.0875}, // AHZ
    Coordinate{-102.804, 42.0533}, // AIA
    Coordinate{168.826, 7.27917}, // AIC
    Coordinate{-85.6131, 40.1086}, // AID
    Coordinate{144.732, -5.14222}, // AIE
    Coordinate{-50.4531, -22.64}, // AIF
    Coordinate{23.2667, 6.51667}, // AIG
    Coordinate{141.266, -7.3425}, // AIH
    Coordinate{42.7167, 11.1333}, // AII
    Coordinate{-81.685, 33.6494}, // AIK
    Coordinate{-78.0236, 9.22222}, // AIL
    Coordinate{169.983, 10.2169}, // AIM
    Coordinate{-159.995, 70.6381}, // AIN
    Coordinate{-95.0469, 41.4072}, // AIO
    Coordinate{-59.3892, -10.2531}, // AIR
    Coordinate{176.802, -2.61626}, // AIS
    Coordinate{-159.764, -18.8308}, // AIT
    Coordinate{-158.12, -19.9678}, // AIU
    Coordinate{-88.1978, 33.1064}, // AIV
    Coordinate{-74.4561, 39.36}, // AIY
    Coordinate{-92.5495, 38.096}, // AIZ
    Coordinate{8.8025, 41.9239}, // AJA
    Coordinate{40.0997, 29.7853}, // AJF
    Coordinate{43.0272, 39.6544}, // AJI
    Coordinate{-14.3833, 19.733}, // AJJ
    Coordinate{49.8473, 34.1381}, // AJK
    Coordinate{92.6204, 23.8384}, // AJL
    Coordinate{44.4296, -12.1317}, // AJN
    Coordinate{-117.603, 33.8978}, // AJO
    Coordinate{19.2819, 65.5903}, // AJR
    Coordinate{-113.56, 26.7272}, // AJS
    Coordinate{-37.0733, -10.9853}, // AJU
    Coordinate{7.99028, 16.9622}, // AJY
    Coordinate{108.931, 32.7081}, // AKA
    Coordinate{-174.206, 52.2206}, // AKB
    Coordinate{-81.4669, 41.0375}, // AKC
    Coordinate{77.0586, 20.6989}, // AKD
    Coordinate{13.9033, -1.13972}, // AKE
    Coordinate{23.3133, 24.1767}, // AKF
    Coordinate{-161.231, 60.9028}, // AKI
    Coordinate{142.447, 43.6708}, // AKJ
    Coordinate{-154.182, 56.9386}, // AKK
    Coordinate{174.792, -37.0081}, // AKL
    Coordinate{19.8175, 10.8908}, // AKM
    Coordinate{-156.649, 58.6764}, // AKN
    Coordinate{-103.222, 40.1756}, // AKO
    Coordinate{-151.743, 68.1336}, // AKP
    Coordinate{105.233, -4.61667}, // AKQ
    Coordinate{5.30083, 7.24667}, // AKR
    Coordinate{160.681, -8.69778}, // AKS
    Coordinate{80.2917, 41.2625}, // AKU
    Coordinate{-78.1486, 60.8186}, // AKV
    Coordinate{49.6769, 30.7444}, // AKW
    Coordinate{57.2033, 50.245}, // AKX
    Coordinate{92.8725, 20.1328}, // AKY
    Coordinate{77.0406, 43.3519}, // ALA
    Coordinate{-73.8019, 42.7492}, // ALB
    Coordinate{-0.558056, 38.2822}, // ALC
    Coordinate{-69.3333, -11.6833}, // ALD
    Coordinate{-103.684, 30.3842}, // ALE
    Coordinate{23.3717, 69.9761}, // ALF
    Coordinate{3.21694, 36.6944}, // ALG
    Coordinate{117.809, -34.9433}, // ALH
    Coordinate{-98.0269, 27.7408}, // ALI
    Coordinate{16.5344, -28.5733}, // ALJ
    Coordinate{8.12533, 44.0457}, // ALL
    Coordinate{-105.991, 32.84}, // ALM
    Coordinate{-90.0461, 38.8903}, // ALN
    Coordinate{-92.4003, 42.5569}, // ALO
    Coordinate{37.2242, 36.1806}, // ALP
    Coordinate{-55.8922, -29.8125}, // ALQ
    Coordinate{169.373, -45.2117}, // ALR
    Coordinate{-105.866, 37.435}, // ALS
    Coordinate{50.7483, 11.9586}, // ALU
    Coordinate{1.525, 42.5078}, // ALV
    Coordinate{-118.289, 46.0947}, // ALW
    Coordinate{-85.9631, 32.9147}, // ALX
    Coordinate{29.9489, 31.1839}, // ALY
    Coordinate{-154.248, 56.8994}, // ALZ
    Coordinate{-101.706, 35.2194}, // AMA
    Coordinate{48.9833, -13.1883}, // AMB
    Coordinate{20.274, 11.034}, // AMC
    Coordinate{72.6347, 23.0772}, // AMD
    Coordinate{37.5903, 6.03972}, // AMH
    Coordinate{116.094, -8.56056}, // AMI
    Coordinate{-107.869, 37.2031}, // AMK
    Coordinate{35.9933, 31.7225}, // AMM
    Coordinate{-84.6881, 43.3222}, // AMN
    Coordinate{15.3144, 14.1456}, // AMO
    Coordinate{44.7333, -24.7}, // AMP
    Coordinate{128.089, -3.71026}, // AMQ
    Coordinate{4.76028, 52.3081}, // AMS
    Coordinate{61.5633, 69.7633}, // AMV
    Coordinate{-93.6217, 41.9919}, // AMW
    Coordinate{45.6242, -17.6864}, // AMY
    Coordinate{174.973, -37.0297}, // AMZ
    Coordinate{-85.8581, 33.5881}, // ANB
    Coordinate{-149.998, 61.1742}, // ANC
    Coordinate{-82.709, 34.4949}, // AND
    Coordinate{-0.312222, 47.5603}, // ANE
    Coordinate{-70.4451, -23.4445}, // ANF
    Coordinate{0.219167, 45.7294}, // ANG
    Coordinate{-159.543, 61.5817}, // ANI
    Coordinate{13.8167, -2.85}, // ANJ
    Coordinate{16.711, -11.4715}, // ANL
    Coordinate{50.3202, -14.9994}, // ANM
    Coordinate{-131.572, 55.0425}, // ANN
    Coordinate{39.9333, -16.1833}, // ANO
    Coordinate{-76.5683, 38.9428}, // ANP
    Coordinate{-85.0836, 41.6397}, // ANQ
    Coordinate{4.46028, 51.1894}, // ANR
    Coordinate{-73.3528, -13.7128}, // ANS
    Coordinate{-61.7931, 17.1367}, // ANU
    Coordinate{-160.191, 62.6467}, // ANV
    Coordinate{-99.9931, 42.5792}, // ANW
    Coordinate{16.1442, 69.2925}, // ANX
    Coordinate{-98.0797, 37.1586}, // ANY
    Coordinate{19.2833, 11.4667}, // AOD
    Coordinate{30.5194, 39.81}, // AOE
    Coordinate{122.856, 41.1047}, // AOG
    Coordinate{-84.0275, 40.7083}, // AOH
    Coordinate{13.3623, 43.6163}, // AOI
    Coordinate{140.689, 40.7333}, // AOJ
    Coordinate{27.1467, 35.4167}, // AOK
    Coordinate{-57.1522, -29.6894}, // AOL
    Coordinate{57.3822, 22.4972}, // AOM
    Coordinate{-78.32, 40.2964}, // AOO
    Coordinate{-76.4666, -2.79611}, // AOP
    Coordinate{100.398, 6.18944}, // AOR
    Coordinate{-153.815, 57.4714}, // AOS
    Coordinate{7.36385, 45.7392}, // AOT
    Coordinate{107.045, 14.7931}, // AOU
    Coordinate{-104.849, 39.57}, // APA
    Coordinate{-68.4167, -14.8181}, // APB
    Coordinate{-122.281, 38.2132}, // APC
    Coordinate{-81.7756, 26.1525}, // APF
    Coordinate{-146.414, -15.5726}, // APK
    Coordinate{39.2818, -15.1056}, // APL
    Coordinate{-83.5603, 45.0781}, // APN
    Coordinate{-76.7134, 7.81117}, // APO
    Coordinate{-36.6306, -9.77639}, // APQ
    Coordinate{-48.9281, -16.3625}, // APS
    Coordinate{-85.5853, 35.0606}, // APT
    Coordinate{-51.385, -23.6122}, // APU
    Coordinate{-117.186, 34.5753}, // APV
    Coordinate{-172.008, -13.8297}, // APW
    Coordinate{-51.4908, -23.3558}, // APX
    Coordinate{-45.9506, -9.08361}, // APY
    Coordinate{-70.1136, -38.9756}, // APZ
    Coordinate{-48.1403, -21.8044}, // AQA
    Coordinate{-91.1506, 15.0108}, // AQB
    Coordinate{-133.102, 55.5547}, // AQC
    Coordinate{117.05, 30.5822}, // AQG
    Coordinate{46.125, 28.335}, // AQI
    Coordinate{35.0181, 29.6116}, // AQJ
    Coordinate{-62.8256, -10.1781}, // AQM
    Coordinate{-98.6619, 30.7836}, // AQO
    Coordinate{-71.5831, -16.3411}, // AQP
    Coordinate{-73.1703, 42.6958}, // AQW
    Coordinate{-149.126, 60.9661}, // AQY
    Coordinate{-91.8839, 30.0377}, // ARA
    Coordinate{-83.7456, 42.2231}, // ARB
    Coordinate{-145.579, 68.1147}, // ARC
    Coordinate{124.598, -8.13167}, // ARD
    Coordinate{-66.6756, 18.4511}, // ARE
    Coordinate{-90.925, 36.1247}, // ARG
    Coordinate{40.7167, 64.6}, // ARH
    Coordinate{-70.3386, -18.3486}, // ARI
    Coordinate{128.917, -3.33333}, // ARJ
    Coordinate{36.6219, -3.36667}, // ARK
    Coordinate{1.48333, 11.5833}, // ARL
    Coordinate{151.617, -30.5283}, // ARM
    Coordinate{17.9186, 59.6519}, // ARN
    Coordinate{-71.3889, 7.02111}, // ARQ
    Coordinate{-70.8129, -45.0136}, // ARR
    Coordinate{-76.0206, 43.9919}, // ART
    Coordinate{-50.4264, -21.1442}, // ARU
    Coordinate{-89.7308, 45.9278}, // ARV
    Coordinate{21.2619, 46.1767}, // ARW
    Coordinate{142.988, -37.31}, // ARY
    Coordinate{12.8626, -7.25903}, // ARZ
    Coordinate{42.645, 13.0717}, // ASA
    Coordinate{58.3608, 37.9869}, // ASB
    Coordinate{-63.1559, -15.9322}, // ASC
    Coordinate{-77.8, 24.6983}, // ASD
    Coordinate{-106.869, 39.2231}, // ASE
    Coordinate{48.0063, 46.2833}, // ASF
    Coordinate{171.797, -43.9033}, // ASG
    Coordinate{-71.5147, 42.7817}, // ASH
    Coordinate{129.712, 28.4308}, // ASJ
    Coordinate{-5.36558, 6.90317}, // ASK
    Coordinate{-94.3078, 32.5206}, // ASL
    Coordinate{38.9017, 15.285}, // ASM
    Coordinate{-86.0511, 33.5694}, // ASN
    Coordinate{34.5861, 10.0183}, // ASO
    Coordinate{133.902, -23.8069}, // ASP
    Coordinate{-117.195, 39.4681}, // ASQ
    Coordinate{35.4953, 38.7703}, // ASR
    Coordinate{-123.879, 46.1581}, // AST
    Coordinate{-57.5192, -25.2397}, // ASU
    Coordinate{37.2508, -2.63583}, // ASV
    Coordinate{32.8197, 23.9642}, // ASW
    Coordinate{-90.9189, 46.5486}, // ASX
    Coordinate{-99.3517, 46.0247}, // ASY
    Coordinate{-77.5983, -9.34722}, // ATA
    Coordinate{34.0569, 17.7097}, // ATB
    Coordinate{-75.6739, 24.6294}, // ATC
    Coordinate{161.011, -8.87333}, // ATD
    Coordinate{-95.6497, 34.1925}, // ATE
    Coordinate{-78.5744, -1.21194}, // ATF
    Coordinate{-73.7679, -10.7309}, // ATG
    Coordinate{23.9444, 37.9364}, // ATH
    Coordinate{-56.5078, -30.4008}, // ATI
    Coordinate{47.067, -19.8348}, // ATJ
    Coordinate{-157.436, 70.4672}, // ATK
    Coordinate{-84.4281, 33.6367}, // ATL
    Coordinate{-52.2522, -3.25083}, // ATM
    Coordinate{152.442, -3.66667}, // ATN
    Coordinate{-82.2292, 39.2119}, // ATO
    Coordinate{142.346, -3.14417}, // ATP
    Coordinate{74.7992, 31.7078}, // ATQ
    Coordinate{-13.0431, 20.5067}, // ATR
    Coordinate{-104.468, 32.8525}, // ATS
    Coordinate{-162.273, 60.8667}, // ATT
    Coordinate{173.176, 52.8325}, // ATU
    Coordinate{18.3133, 13.2389}, // ATV
    Coordinate{-88.5192, 44.2581}, // ATW
    Coordinate{68.3633, 51.8517}, // ATX
    Coordinate{-97.1547, 44.9139}, // ATY
    Coordinate{31.0119, 27.0464}, // ATZ
    Coordinate{-70.0153, 12.5014}, // AUA
    Coordinate{-41.983, -7.1}, // AUB
    Coordinate{-70.7369, 7.06889}, // AUC
    Coordinate{33.2, 28.8989}, // AUE
    Coordinate{3.49667, 47.8464}, // AUF
    Coordinate{-69.7972, 44.3206}, // AUG
    Coordinate{54.6511, 24.4331}, // AUH
    Coordinate{-164.66, 62.68}, // AUK
    Coordinate{171.173, 8.1455}, // AUL
    Coordinate{-92.9328, 43.6625}, // AUM
    Coordinate{-121.082, 38.9547}, // AUN
    Coordinate{-85.4339, 32.615}, // AUO
    Coordinate{149.386, -9.93083}, // AUP
    Coordinate{-139.013, -9.76861}, // AUQ
    Coordinate{2.41667, 44.8975}, // AUR
    Coordinate{-97.67, 30.1944}, // AUS
    Coordinate{141.721, -13.3539}, // AUU
    Coordinate{-89.6267, 44.9261}, // AUW
    Coordinate{-48.2408, -7.22833}, // AUX
    Coordinate{169.771, -20.2492}, // AUY
    Coordinate{-88.4756, 41.7719}, // AUZ
    Coordinate{105.873, 26.2606}, // AVA
    Coordinate{-78.7894, 22.0269}, // AVI
    Coordinate{102.799, 46.2525}, // AVK
    Coordinate{-82.5417, 35.4361}, // AVL
    Coordinate{4.90194, 43.9067}, // AVN
    Coordinate{-81.5289, 27.5914}, // AVO
    Coordinate{-75.7233, 41.3383}, // AVP
    Coordinate{160.41, -9.86818}, // AVU
    Coordinate{144.469, -38.0394}, // AVV
    Coordinate{-111.218, 32.4096}, // AVW
    Coordinate{-118.416, 33.405}, // AVX
    Coordinate{38.5, 7.067}, // AWA
    Coordinate{142.751, -8.01433}, // AWB
    Coordinate{169.601, -19.2344}, // AWD
    Coordinate{166.637, 19.2825}, // AWK
    Coordinate{-90.2344, 35.135}, // AWM
    Coordinate{-122.159, 48.1608}, // AWO
    Coordinate{48.762, 31.3374}, // AWZ
    Coordinate{-63.055, 18.2047}, // AXA
    Coordinate{-75.8997, 44.3167}, // AXB
    Coordinate{145.242, -22.9667}, // AXC
    Coordinate{25.9563, 40.8559}, // AXD
    Coordinate{-52.3731, -26.8756}, // AXE
    Coordinate{105.631, 38.8233}, // AXF
    Coordinate{-94.2719, 43.0778}, // AXG
    Coordinate{-95.4769, 29.5061}, // AXH
    Coordinate{130.159, 32.4822}, // AXJ
    Coordinate{46.8261, 14.5511}, // AXK
    Coordinate{-75.7664, 4.4525}, // AXM
    Coordinate{-95.3947, 45.8664}, // AXN
    Coordinate{-73.975, 22.4444}, // AXP
    Coordinate{-79.4422, 41.225}, // AXQ
    Coordinate{-99.3383, 34.6989}, // AXS
    Coordinate{140.219, 39.6156}, // AXT
    Coordinate{38.7761, 14.1369}, // AXU
    Coordinate{-84.2981, 40.4936}, // AXV
    Coordinate{-75.1464, 8.32}, // AYA
    Coordinate{66.96, 50.325}, // AYK
    Coordinate{114.344, 36.1339}, // AYN
    Coordinate{-56.8539, -27.3706}, // AYO
    Coordinate{-74.2042, -13.1547}, // AYP
    Coordinate{130.976, -25.1861}, // AYQ
    Coordinate{147.33, -19.585}, // AYR
    Coordinate{-82.3956, 31.2492}, // AYS
    Coordinate{30.7928, 36.9003}, // AYT
    Coordinate{145.904, -6.33778}, // AYU
    Coordinate{132.5, -1.2}, // AYW
    Coordinate{-73.4164, 40.6667}, // AYZ
    Coordinate{-111.656, 33.3078}, // AZA
    Coordinate{-113.014, 36.96}, // AZC
    Coordinate{54.2764, 31.905}, // AZD
    Coordinate{54.4581, 24.4266}, // AZI
    Coordinate{72.2939, 40.7278}, // AZN
    Coordinate{-85.5519, 42.235}, // AZO
    Coordinate{-0.186361, 27.8378}, // AZR
    Coordinate{-69.7375, 19.27}, // AZS
    Coordinate{13.1156, -7.88333}, // AZZ
    Coordinate{6.60917, 44.3872}, // BAE
    Coordinate{-72.7158, 42.1581}, // BAF
    Coordinate{120.616, 16.375}, // BAG
    Coordinate{50.6336, 26.2708}, // BAH
    Coordinate{-83.33, 9.16361}, // BAI
    Coordinate{-116.876, 40.5997}, // BAM
    Coordinate{20.4333, -4.31667}, // BAN
    Coordinate{-74.7818, 10.8886}, // BAQ
    Coordinate{110.459, 19.1406}, // BAR
    Coordinate{155.888, -6.9925}, // BAS
    Coordinate{-48.5958, -20.5856}, // BAT
    Coordinate{-49.0539, -22.3436}, // BAU
    Coordinate{109.997, 40.5597}, // BAV
    Coordinate{83.5417, 53.3633}, // BAX
    Coordinate{23.4662, 47.6582}, // BAY
    Coordinate{-62.9194, -0.981112}, // BAZ
    Coordinate{-71.687, -45.9164}, // BBA
    Coordinate{-95.6506, 45.3319}, // BBB
    Coordinate{-95.8633, 28.9733}, // BBC
    Coordinate{-99.3239, 31.1792}, // BBD
    Coordinate{172.811, 3.08333}, // BBG
    Coordinate{12.7101, 54.3382}, // BBH
    Coordinate{85.8178, 20.2444}, // BBI
    Coordinate{25.1631, -17.8297}, // BBK
    Coordinate{141.808, -27.4083}, // BBL
    Coordinate{103.223, 13.094}, // BBM
    Coordinate{115.469, 3.73694}, // BBN
    Coordinate{44.9411, 10.3892}, // BBO
    Coordinate{-1.10944, 50.6781}, // BBP
    Coordinate{-61.8269, 17.6358}, // BBQ
    Coordinate{-61.7422, 16.0133}, // BBR
    Coordinate{-0.8475, 51.3239}, // BBS
    Coordinate{15.7861, 4.22139}, // BBT
    Coordinate{26.1036, 44.5036}, // BBU
    Coordinate{-6.92396, 4.63333}, // BBV
    Coordinate{-99.6422, 41.4364}, // BBW
    Coordinate{-75.265, 40.1375}, // BBX
    Coordinate{20.6475, 5.84694}, // BBY
    Coordinate{23.1042, -13.5361}, // BBZ
    Coordinate{-74.5061, 20.3653}, // BCA
    Coordinate{-80.4078, 37.2078}, // BCB
    Coordinate{-156.144, 63.5717}, // BCC
    Coordinate{122.93, 10.6425}, // BCD
    Coordinate{-112.145, 37.7064}, // BCE
    Coordinate{18.2667, 6.51667}, // BCF
    Coordinate{126.399, -8.48528}, // BCH
    Coordinate{145.307, -23.5653}, // BCI
    Coordinate{-90.8553, 44.2508}, // BCK
    Coordinate{-83.5833, 10.7667}, // BCL
    Coordinate{26.9103, 46.5219}, // BCM
    Coordinate{2.07833, 41.2969}, // BCN
    Coordinate{36.55, 5.78287}, // BCO
    Coordinate{14.2655, 27.6547}, // BCQ
    Coordinate{21.367, 44.8867}, // BCR
    Coordinate{-90.0222, 29.8661}, // BCS
    Coordinate{-80.1078, 26.3786}, // BCT
    Coordinate{9.74444, 10.4833}, // BCU
    Coordinate{-88.7761, 17.2694}, // BCV
    Coordinate{35.4383, -21.8531}, // BCW
    Coordinate{-64.6787, 32.364}, // BDA
    Coordinate{152.319, -24.9039}, // BDB
    Coordinate{-45.2422, -5.5025}, // BDC
    Coordinate{142.175, -10.15}, // BDD
    Coordinate{-94.6122, 48.7283}, // BDE
    Coordinate{-109.483, 37.5833}, // BDG
    Coordinate{54.8248, 26.5314}, // BDH
    Coordinate{55.2087, -3.72147}, // BDI
    Coordinate{114.762, -3.44222}, // BDJ
    Coordinate{-2.76194, 8.01722}, // BDK
    Coordinate{-72.6833, 41.9392}, // BDL
    Coordinate{-121.2, 44.0944}, // BDN
    Coordinate{107.576, -6.90056}, // BDO
    Coordinate{88.0794, 26.5706}, // BDP
    Coordinate{73.2161, 22.3293}, // BDQ
    Coordinate{-73.1261, 41.1633}, // BDR
    Coordinate{17.9469, 40.6575}, // BDS
    Coordinate{20.9667, 4.25}, // BDT
    Coordinate{18.5403, 69.0558}, // BDU
    Coordinate{29.7333, -7.1}, // BDV
    Coordinate{-105.457, 45.4706}, // BDX
    Coordinate{-124.408, 43.0865}, // BDY
    Coordinate{-7.36278, 57.4811}, // BEB
    Coordinate{-97.215, 37.6944}, // BEC
    Coordinate{-71.2889, 42.47}, // BED
    Coordinate{-83.7742, 11.9908}, // BEF
    Coordinate{20.3069, 44.8194}, // BEG
    Coordinate{-86.4261, 42.1286}, // BEH
    Coordinate{34.5167, 9.35}, // BEI
    Coordinate{117.432, 2.15528}, // BEJ
    Coordinate{79.4469, 28.4225}, // BEK
    Coordinate{-48.4789, -1.38472}, // BEL
    Coordinate{17.6333, 5.26667}, // BEM
    Coordinate{20.2708, 32.0975}, // BEN
    Coordinate{151.648, -33.0667}, // BEO
    Coordinate{76.8828, 15.1628}, // BEP
    Coordinate{13.5033, 52.3667}, // BER
    Coordinate{-4.42167, 48.4472}, // BES
    Coordinate{-161.837, 60.7786}, // BET
    Coordinate{139.46, -24.3461}, // BEU
    Coordinate{34.723, 31.287}, // BEV
    Coordinate{34.9075, -19.7964}, // BEW
    Coordinate{35.4883, 33.8211}, // BEY
    Coordinate{176.007, -1.35472}, // BEZ
    Coordinate{-78.64, 41.8031}, // BFD
    Coordinate{-103.596, 41.8739}, // BFF
    Coordinate{-110.713, 37.5458}, // BFG
    Coordinate{-49.2336, -25.4033}, // BFH
    Coordinate{-122.302, 47.53}, // BFI
    Coordinate{105.301, 27.3003}, // BFJ
    Coordinate{-99.6186, 36.8633}, // BFK
    Coordinate{-119.058, 35.4339}, // BFL
    Coordinate{-88.0681, 30.6267}, // BFM
    Coordinate{26.3039, -29.0939}, // BFN
    Coordinate{31.5786, -21.01}, // BFO
    Coordinate{-80.3914, 40.7725}, // BFP
    Coordinate{-78.1806, 7.5875}, // BFQ
    Coordinate{-86.4453, 38.84}, // BFR
    Coordinate{-6.21583, 54.6575}, // BFS
    Coordinate{-80.6344, 32.4122}, // BFT
    Coordinate{117.32, 32.8475}, // BFU
    Coordinate{103.251, 15.2267}, // BFV
    Coordinate{-0.593275, 35.1718}, // BFW
    Coordinate{10.3544, 5.53472}, // BFX
    Coordinate{-73.1847, 7.12639}, // BGA
    Coordinate{11.9431, -0.106944}, // BGB
    Coordinate{-6.70713, 41.8578}, // BGC
    Coordinate{-101.394, 35.7008}, // BGD
    Coordinate{-84.6375, 30.9717}, // BGE
    Coordinate{18.5197, 4.39778}, // BGF
    Coordinate{40.5925, 38.8611}, // BGG
    Coordinate{-14.2, 16.6333}, // BGH
    Coordinate{-59.4925, 13.0747}, // BGI
    Coordinate{-88.4167, 16.5167}, // BGK
    Coordinate{-75.9797, 42.2086}, // BGM
    Coordinate{146.235, 68.5569}, // BGN
    Coordinate{5.21806, 60.2936}, // BGO
    Coordinate{-149.814, 61.5361}, // BGQ
    Coordinate{-68.8281, 44.8072}, // BGR
    Coordinate{-113.17, 34.5958}, // BGT
    Coordinate{22.7833, 4.78333}, // BGU
    Coordinate{-51.5364, -29.1483}, // BGV
    Coordinate{44.2344, 33.2625}, // BGW
    Coordinate{-54.1097, -31.3908}, // BGX
    Coordinate{9.70028, 45.6689}, // BGY
    Coordinate{-8.44514, 41.5871}, // BGZ
    Coordinate{-80.4042, -0.608111}, // BHA
    Coordinate{-68.3617, 44.4497}, // BHB
    Coordinate{-5.87123, 54.6155}, // BHD
    Coordinate{173.87, -41.5183}, // BHE
    Coordinate{-84.5436, 15.7631}, // BHG
    Coordinate{42.6208, 19.9844}, // BHH
    Coordinate{-62.1575, -38.7203}, // BHI
    Coordinate{69.6703, 23.2878}, // BHJ
    Coordinate{64.4833, 39.775}, // BHK
    Coordinate{-113.561, 28.9772}, // BHL
    Coordinate{-86.7522, 33.5639}, // BHM
    Coordinate{45.72, 14.7819}, // BHN
    Coordinate{77.3369, 23.2869}, // BHO
    Coordinate{87.0508, 27.1475}, // BHP
    Coordinate{141.472, -32.0014}, // BHQ
    Coordinate{84.4294, 27.6781}, // BHR
    Coordinate{149.652, -33.41}, // BHS
    Coordinate{72.1853, 21.7522}, // BHU
    Coordinate{71.7114, 29.3471}, // BHV
    Coordinate{-1.74806, 52.4539}, // BHX
    Coordinate{109.294, 21.5394}, // BHY
    Coordinate{9.48472, 42.55}, // BIA
    Coordinate{43.6178, 3.09267}, // BIB
    Coordinate{-71.5778, 41.1681}, // BID
    Coordinate{165.565, 11.5225}, // BII
    Coordinate{136.107, -1.19}, // BIK
    Coordinate{-108.543, 45.8078}, // BIL
    Coordinate{-79.2647, 25.7}, // BIM
    Coordinate{67.8206, 34.81}, // BIN
    Coordinate{-2.91056, 43.3011}, // BIO
    Coordinate{-1.52333, 43.4683}, // BIQ
    Coordinate{87.2639, 26.4814}, // BIR
    Coordinate{-100.746, 46.7728}, // BIS
    Coordinate{-23.5461, 65.6414}, // BIU
    Coordinate{21.9894, 6.52667}, // BIV
    Coordinate{27.285, -32.895}, // BIY
    Coordinate{5.06947, 36.712}, // BJA
    Coordinate{57.3064, 37.4892}, // BJB
    Coordinate{-105.117, 39.9089}, // BJC
    Coordinate{-14.8244, 66.0219}, // BJD
    Coordinate{29.6925, 70.6003}, // BJF
    Coordinate{122.112, -0.960556}, // BJG
    Coordinate{81.1853, 29.5389}, // BJH
    Coordinate{-94.9347, 47.5108}, // BJI
    Coordinate{-81.8883, 40.8747}, // BJJ
    Coordinate{134.274, -6.0662}, // BJK
    Coordinate{-16.6522, 13.338}, // BJL
    Coordinate{29.3185, -3.32402}, // BJM
    Coordinate{-64.3128, -22.7733}, // BJO
    Coordinate{-46.5375, -22.9792}, // BJP
    Coordinate{37.312, 11.5986}, // BJR
    Coordinate{79.9833, 6.41667}, // BJT
    Coordinate{81.6667, 29.5}, // BJU
    Coordinate{27.6642, 37.2506}, // BJV
    Coordinate{121.063, -8.7125}, // BJW
    Coordinate{-101.481, 20.9933}, // BJX
    Coordinate{-6.82139, 38.8914}, // BJZ
    Coordinate{38.0639, 55.6222}, // BKA
    Coordinate{73.2069, 28.0704}, // BKB
    Coordinate{-161.149, 65.9817}, // BKC
    Coordinate{-117.809, 44.8372}, // BKE
    Coordinate{-155.777, 58.5547}, // BKF
    Coordinate{-93.2006, 36.5319}, // BKG
    Coordinate{-159.785, 22.0228}, // BKH
    Coordinate{116.053, 5.94472}, // BKI
    Coordinate{-14.2811, 10.9658}, // BKJ
    Coordinate{100.747, 13.6811}, // BKK
    Coordinate{-81.6833, 41.5175}, // BKL
    Coordinate{115.618, 3.974}, // BKM
    Coordinate{54.3628, 39.4814}, // BKN
    Coordinate{-7.94306, 12.5378}, // BKO
    Coordinate{145.428, -24.4283}, // BKQ
    Coordinate{17.067, 12.383}, // BKR
    Coordinate{102.337, -3.86188}, // BKS
    Coordinate{-82.4556, 28.4736}, // BKV
    Coordinate{-81.1242, 37.7872}, // BKW
    Coordinate{-96.8169, 44.3047}, // BKX
    Coordinate{28.8086, -2.30889}, // BKY
    Coordinate{31.8211, -1.33222}, // BKZ
    Coordinate{-64.6892, 10.1072}, // BLA
    Coordinate{-79.5994, 8.915}, // BLB
    Coordinate{10.0339, 5.89528}, // BLC
    Coordinate{-114.861, 35.9475}, // BLD
    Coordinate{15.515, 60.4219}, // BLE
    Coordinate{-81.2078, 37.2958}, // BLF
    Coordinate{113.761, 2.63611}, // BLG
    Coordinate{-114.713, 33.6147}, // BLH
    Coordinate{6.30925, 35.7518}, // BLJ
    Coordinate{-3.02833, 53.7714}, // BLK
    Coordinate{9.15194, 55.7403}, // BLL
    Coordinate{-74.125, 40.1869}, // BLM
    Coordinate{146.007, -36.5519}, // BLN
    Coordinate{-20.2875, 65.645}, // BLO
    Coordinate{11.2887, 44.5354}, // BLQ
    Coordinate{77.7056, 13.1989}, // BLR
    Coordinate{148.807, -23.6031}, // BLT
    Coordinate{-120.71, 39.275}, // BLU
    Coordinate{12.2481, 46.1667}, // BLX
    Coordinate{-10.0308, 54.2228}, // BLY
    Coordinate{34.9676, -15.6798}, // BLZ
    Coordinate{17.9397, 59.3544}, // BMA
    Coordinate{22.4817, 2.18278}, // BMB
    Coordinate{-112.062, 41.5525}, // BMC
    Coordinate{44.5333, -19.6867}, // BMD
    Coordinate{122.232, -17.9447}, // BME
    Coordinate{22.8006, 5.69417}, // BMF
    Coordinate{-86.6167, 39.1461}, // BMG
    Coordinate{-88.9158, 40.4772}, // BMI
    Coordinate{-60.488, 7.37012}, // BMJ
    Coordinate{6.70917, 53.5956}, // BMK
    Coordinate{-71.1758, 44.5753}, // BML
    Coordinate{11.4933, 2.07556}, // BMM
    Coordinate{97.2469, 24.2667}, // BMO
    Coordinate{84.8769, 19.2975}, // BMP
    Coordinate{39.7312, -3.98005}, // BMQ
    Coordinate{7.37324, 53.7248}, // BMR
    Coordinate{-41.8208, -14.2583}, // BMS
    Coordinate{-94.215, 30.0703}, // BMT
    Coordinate{118.687, -8.53972}, // BMU
    Coordinate{108.12, 12.6681}, // BMV
    Coordinate{0.927, 21.3778}, // BMW
    Coordinate{163.661, -19.7206}, // BMY
    Coordinate{-86.6819, 36.1267}, // BNA
    Coordinate{20.8667, -0.283333}, // BNB
    Coordinate{29.4667, 0.575}, // BNC
    Coordinate{56.3778, 27.2181}, // BND
    Coordinate{153.118, -27.3833}, // BNE
    Coordinate{-116.851, 33.9225}, // BNG
    Coordinate{5.59944, 6.31694}, // BNI
    Coordinate{7.16333, 50.7689}, // BNJ
    Coordinate{153.562, -28.8333}, // BNK
    Coordinate{-81.3881, 33.2581}, // BNL
    Coordinate{12.2175, 65.4611}, // BNN
    Coordinate{-118.956, 43.5919}, // BNO
    Coordinate{70.5242, 32.9719}, // BNP
    Coordinate{-4.717, 10.683}, // BNR
    Coordinate{-70.2208, 8.61944}, // BNS
    Coordinate{-49.0936, -26.8328}, // BNU
    Coordinate{-93.8475, 42.0494}, // BNW
    Coordinate{17.2975, 44.9414}, // BNX
    Coordinate{159.798, -11.3017}, // BNY
    Coordinate{13.0636, -5.86667}, // BOA
    Coordinate{-151.753, -16.4436}, // BOB
    Coordinate{-82.2508, 9.34083}, // BOC
    Coordinate{-0.715556, 44.8283}, // BOD
    Coordinate{15.3833, -1.03333}, // BOE
    Coordinate{-74.1469, 4.70139}, // BOG
    Coordinate{-1.8425, 50.78}, // BOH
    Coordinate{-116.223, 43.5644}, // BOI
    Coordinate{27.5153, 42.5703}, // BOJ
    Coordinate{-124.29, 42.0744}, // BOK
    Coordinate{72.8681, 19.0886}, // BOM
    Coordinate{-68.2686, 12.1311}, // BON
    Coordinate{14.3653, 67.2692}, // BOO
    Coordinate{15.6378, 5.9625}, // BOP
    Coordinate{-71.0064, 42.3631}, // BOS
    Coordinate{141.092, -7.24083}, // BOT
    Coordinate{2.37, 47.0608}, // BOU
    Coordinate{-81.7833, 27.9433}, // BOW
    Coordinate{136.3, -16.0753}, // BOX
    Coordinate{-4.33083, 11.16}, // BOY
    Coordinate{16.3167, 6.33333}, // BOZ
    Coordinate{10.1167, 6.03917}, // BPC
    Coordinate{119.059, 39.6664}, // BPE
    Coordinate{158, -8.63}, // BPF
    Coordinate{-52.3894, -15.8608}, // BPG
    Coordinate{126.324, 8.19637}, // BPH
    Coordinate{-110.111, 42.585}, // BPI
    Coordinate{141.744, -5.52639}, // BPK
    Coordinate{82.2997, 44.895}, // BPL
    Coordinate{78.4675, 17.4531}, // BPM
    Coordinate{116.894, -1.26833}, // BPN
    Coordinate{125.479, 11.6742}, // BPR
    Coordinate{-39.0778, -16.4381}, // BPS
    Coordinate{-94.0206, 29.9508}, // BPT
    Coordinate{97.1086, 30.5536}, // BPX
    Coordinate{44.4833, -16.75}, // BPY
    Coordinate{121.5, 15.7303}, // BQA
    Coordinate{115.4, -33.6872}, // BQB
    Coordinate{-15.8381, 11.2972}, // BQE
    Coordinate{140.449, 52.3806}, // BQG
    Coordinate{0.0325, 51.3308}, // BQH
    Coordinate{134.695, 67.6488}, // BQJ
    Coordinate{-81.4664, 31.2589}, // BQK
    Coordinate{139.9, -22.9133}, // BQL
    Coordinate{-67.1294, 18.4949}, // BQN
    Coordinate{-3.0338, 9.254}, // BQO
    Coordinate{-43.1475, -11.0839}, // BQQ
    Coordinate{-78.6122, 42.9222}, // BQR
    Coordinate{127.413, 50.425}, // BQS
    Coordinate{23.8981, 52.1083}, // BQT
    Coordinate{-61.2644, 12.9869}, // BQU
    Coordinate{127.973, -20.1483}, // BQW
    Coordinate{-45.01, -12.08}, // BRA
    Coordinate{-42.8058, -2.75639}, // BRB
    Coordinate{-71.1575, -41.1511}, // BRC
    Coordinate{-94.1356, 46.4022}, // BRD
    Coordinate{8.78667, 53.0475}, // BRE
    Coordinate{16.7606, 41.1389}, // BRI
    Coordinate{145.952, -30.0392}, // BRK
    Coordinate{-91.1256, 40.7831}, // BRL
    Coordinate{-69.3586, 10.0428}, // BRM
    Coordinate{7.49917, 46.9122}, // BRN
    Coordinate{-97.4258, 25.9069}, // BRO
    Coordinate{16.6944, 49.1514}, // BRQ
    Coordinate{-7.44167, 57.0236}, // BRR
    Coordinate{-2.71917, 51.3828}, // BRS
    Coordinate{130.62, -11.7692}, // BRT
    Coordinate{4.48444, 50.9014}, // BRU
    Coordinate{25.5243, 45.7071}, // BRV
    Coordinate{-156.766, 71.2856}, // BRW
    Coordinate{-71.1219, 18.2517}, // BRX
    Coordinate{-85.4997, 37.8144}, // BRY
    Coordinate{49.15, 11.2756}, // BSA
    Coordinate{-47.9186, -15.8711}, // BSB
    Coordinate{-77.3944, 6.20278}, // BSC
    Coordinate{99.1683, 25.0533}, // BSD
    Coordinate{109.763, 1.81361}, // BSE
    Coordinate{9.80282, 1.90104}, // BSG
    Coordinate{147.568, -37.8875}, // BSJ
    Coordinate{5.73831, 34.7934}, // BSK
    Coordinate{7.52917, 47.59}, // EAP
    Coordinate{17.4333, 6.5}, // BSN
    Coordinate{121.979, 20.4504}, // BSO
    Coordinate{141.256, -8.85633}, // BSP
    Coordinate{-109.883, 31.3639}, // BSQ
    Coordinate{47.6625, 30.5489}, // BSR
    Coordinate{-46.0533, -7.52528}, // BSS
    Coordinate{64.3647, 31.5588}, // BST
    Coordinate{19.7889, 1.21667}, // BSU
    Coordinate{-146.146, 60.4231}, // BSW
    Coordinate{94.78, 16.8125}, // BSX
    Coordinate{42.3077, 2.33672}, // BSY
    Coordinate{13.7167, 4.54861}, // BTA
    Coordinate{18.5, 3.05}, // BTB
    Coordinate{-12.5183, 7.53194}, // BTE
    Coordinate{-111.927, 40.8694}, // BTF
    Coordinate{18.3, 7.31667}, // BTG
    Coordinate{104.119, 1.12083}, // BTH
    Coordinate{-143.582, 70.1339}, // BTI
    Coordinate{95.4203, 5.52333}, // BTJ
    Coordinate{101.698, 56.37}, // BTK
    Coordinate{-85.25, 42.3064}, // BTL
    Coordinate{-112.497, 45.9547}, // BTM
    Coordinate{-79.7344, 34.6217}, // BTN
    Coordinate{-55.45, 4.21667}, // BTO
    Coordinate{-79.9497, 40.7769}, // BTP
    Coordinate{29.74, -2.595}, // BTQ
    Coordinate{-91.15, 30.5328}, // BTR
    Coordinate{17.2128, 48.17}, // BTS
    Coordinate{-151.529, 66.9139}, // BTT
    Coordinate{113.02, 3.12361}, // BTU
    Coordinate{-73.1533, 44.4719}, // BTV
    Coordinate{115.996, -3.45}, // BTW
    Coordinate{-116.787, 36.8611}, // BTY
    Coordinate{154.673, -5.42222}, // BUA
    Coordinate{139.534, -17.7486}, // BUC
    Coordinate{19.2619, 47.4394}, // BUD
    Coordinate{-78.7322, 42.9406}, // BUF
    Coordinate{13.4036, -12.6089}, // BUG
    Coordinate{138.65, -3.71667}, // BUI
    Coordinate{4.20575, 35.3327}, // BUJ
    Coordinate{43.7667, 15.8333}, // BUK
    Coordinate{146.649, -7.21611}, // BUL
    Coordinate{-76.9897, 3.81972}, // BUN
    Coordinate{45.5667, 9.5}, // BUO
    Coordinate{74.7556, 30.27}, // BUP
    Coordinate{28.6179, -20.0174}, // BUQ
    Coordinate{-118.359, 34.2006}, // BUR
    Coordinate{41.5994, 41.6103}, // BUS
    Coordinate{90.7464, 27.5628}, // BUT
    Coordinate{-88.3047, 42.6908}, // BUU
    Coordinate{-57.5597, -30.3194}, // BUV
    Coordinate{122.568, -5.48778}, // BUW
    Coordinate{30.2167, 1.56583}, // BUX
    Coordinate{115.677, -33.3781}, // BUY
    Coordinate{50.8303, 28.9448}, // BUZ
    Coordinate{2.11278, 49.4544}, // BVA
    Coordinate{-60.6922, 2.84139}, // BVB
    Coordinate{-22.8886, 16.1372}, // BVC
    Coordinate{1.48556, 45.0397}, // BVE
    Coordinate{29.0342, 70.8714}, // BVG
    Coordinate{-60.0972, -12.6942}, // BVH
    Coordinate{139.348, -25.8975}, // BVI
    Coordinate{-63.8783, -13.6066}, // BVK
    Coordinate{-63.5833, -13.5833}, // BVL
    Coordinate{-98.0558, 41.7286}, // BVN
    Coordinate{-96.0111, 36.7642}, // BVO
    Coordinate{-24.746, 14.8643}, // BVR
    Coordinate{-151.045, 61.1731}, // BVU
    Coordinate{147.622, 44.92}, // BVV
    Coordinate{142.675, -12.6592}, // BVW
    Coordinate{-91.6475, 35.7261}, // BVX
    Coordinate{-70.9165, 42.5842}, // BVY
    Coordinate{83.4161, 27.5056}, // BWA
    Coordinate{115.405, -20.8658}, // BWB
    Coordinate{-115.517, 32.9931}, // BWC
    Coordinate{-98.9564, 31.7936}, // BWD
    Coordinate{10.5553, 52.3192}, // BWE
    Coordinate{-3.26722, 54.1286}, // BWF
    Coordinate{-86.4197, 36.9644}, // BWG
    Coordinate{100.391, 5.46611}, // BWH
    Coordinate{-76.6683, 39.1753}, // BWI
    Coordinate{16.6797, 43.2858}, // BWK
    Coordinate{-97.3494, 36.745}, // BWL
    Coordinate{-103.428, 46.1869}, // BWM
    Coordinate{114.928, 4.94417}, // BWN
    Coordinate{47.75, 51.85}, // BWO
    Coordinate{146.817, -29.9739}, // BWQ
    Coordinate{-122.732, 48.99}, // BWS
    Coordinate{145.731, -40.9989}, // BWT
    Coordinate{150.988, -33.925}, // BWU
    Coordinate{-79.1472, 22.6211}, // BWW
    Coordinate{114.34, -8.3106}, // BWX
    Coordinate{133.417, -2.55}, // BXB
    Coordinate{139.583, -7.16667}, // BXD
    Coordinate{-12.4833, 14.8472}, // BXE
    Coordinate{144.33, -36.7394}, // BXG
    Coordinate{75.005, 46.8933}, // BXH
    Coordinate{-6.467, 9.533}, // BXI
    Coordinate{76.8825, 43.3517}, // BXJ
    Coordinate{-112.686, 33.4206}, // BXK
    Coordinate{139.6, -2.28333}, // BXM
    Coordinate{27.6556, 37.1361}, // BXN
    Coordinate{8.39694, 46.9744}, // BXO
    Coordinate{23.1436, 52.0031}, // BXP
    Coordinate{58.4497, 29.0842}, // BXR
    Coordinate{-116.321, 33.2589}, // BXS
    Coordinate{117.477, 0.121661}, // BXT
    Coordinate{125.478, 8.95132}, // BXU
    Coordinate{-14.0228, 64.79}, // BXV
    Coordinate{112.679, -5.72361}, // BXW
    Coordinate{43.1508, 9.94556}, // BXX
    Coordinate{56.2452, 25.6141}, // BYB
    Coordinate{-63.6517, -21.9608}, // BYC
    Coordinate{45.4403, 14.1056}, // BYD
    Coordinate{2.6925, 49.97}, // BYF
    Coordinate{-89.9439, 35.9644}, // BYH
    Coordinate{-113.772, 42.5425}, // BYI
    Coordinate{-7.9325, 38.0789}, // BYJ
    Coordinate{-5.07361, 7.73889}, // BYK
    Coordinate{-76.6214, 20.3964}, // BYM
    Coordinate{100.7, 46.1706}, // BYN
    Coordinate{-56.4561, -21.2472}, // BYO
    Coordinate{119.166, -22.6739}, // BYP
    Coordinate{117.867, 3.45583}, // BYQ
    Coordinate{10.9997, 57.2769}, // BYR
    Coordinate{-9.48444, 51.6689}, // BYT
    Coordinate{-84.6306, 14.0383}, // BZA
    Coordinate{35.4728, -21.5428}, // BZB
    Coordinate{-41.9656, -22.771}, // BZC
    Coordinate{143.578, -34.6236}, // BZD
    Coordinate{-88.3083, 17.5392}, // BZE
    Coordinate{-122.408, 40.5742}, // BZF
    Coordinate{17.9778, 53.0967}, // BZG
    Coordinate{34.1764, 53.2142}, // BZK
    Coordinate{90.3012, 22.7989}, // BZL
    Coordinate{-111.152, 45.7775}, // BZN
    Coordinate{11.3264, 46.4603}, // BZO
    Coordinate{3.35333, 43.3233}, // BZR
    Coordinate{24.7833, 2.81667}, // BZU
    Coordinate{15.253, -4.2517}, // BZV
    Coordinate{27.7772, 47.8431}, // BZY
    Coordinate{-85.7717, 14.8756}, // CAA
    Coordinate{12.1881, -5.59711}, // CAB
    Coordinate{-53.5019, -25.0022}, // CAC
    Coordinate{-85.4189, 44.2753}, // CAD
    Coordinate{-81.1194, 33.9389}, // CAE
    Coordinate{-66.8956, -4.87861}, // CAF
    Coordinate{9.05428, 39.2515}, // CAG
    Coordinate{105.179, 9.17556}, // CAH
    Coordinate{31.4056, 30.1219}, // CAI
    Coordinate{-62.8542, 6.23194}, // CAJ
    Coordinate{-81.4422, 40.9161}, // CAK
    Coordinate{-5.68639, 55.4372}, // CAL
    Coordinate{-63.5278, -20.0071}, // CAM
    Coordinate{113.299, 23.3924}, // CAN
    Coordinate{-103.15, 36.4464}, // CAO
    Coordinate{-72.2, 19.7331}, // CAP
    Coordinate{-75.1983, 7.96833}, // CAQ
    Coordinate{-68.0179, 46.8715}, // CAR
    Coordinate{-7.66056, 33.5569}, // CAS
    Coordinate{-9.35528, 38.7256}, // CAT
    Coordinate{-36.0108, -8.28444}, // CAU
    Coordinate{22.916, -11.8929}, // CAV
    Coordinate{-41.3078, -21.7011}, // CAW
    Coordinate{-2.80917, 54.9375}, // CAX
    Coordinate{-52.3619, 4.81972}, // CAY
    Coordinate{145.793, -31.5383}, // CAZ
    Coordinate{43.0667, 11.5167}, // CBA
    Coordinate{-66.1769, -17.4208}, // CBB
    Coordinate{-78.7608, 39.6156}, // CBE
    Coordinate{-95.7586, 41.26}, // CBF
    Coordinate{0.175, 52.205}, // CBG
    Coordinate{-2.26119, 31.6547}, // CBH
    Coordinate{-71.6447, 17.9289}, // CBJ
    Coordinate{-101.047, 39.4275}, // CBK
    Coordinate{-63.5361, 8.12222}, // CBL
    Coordinate{108.54, -6.75614}, // CBN
    Coordinate{124.21, 7.16076}, // CBO
    Coordinate{-8.47222, 40.1614}, // CBP
    Coordinate{8.34694, 4.97583}, // CBQ
    Coordinate{149.195, -35.3069}, // CBR
    Coordinate{-71.3225, 10.33}, // CBS
    Coordinate{13.4873, -12.4795}, // CBT
    Coordinate{14.532, 51.8895}, // CBU
    Coordinate{-90.4067, 15.4689}, // CBV
    Coordinate{-52.3569, -24.0025}, // CBW
    Coordinate{147.208, -33.065}, // CBX
    Coordinate{-65.1415, -16.99}, // CCA
    Coordinate{-117.688, 34.1117}, // CCB
    Coordinate{-78.3286, 22.4611}, // CCC
    Coordinate{2.30855, 43.2158}, // CCF
    Coordinate{-71.6907, -46.5827}, // CCH
    Coordinate{-52.0511, -27.1806}, // CCI
    Coordinate{75.9504, 11.1381}, // CCJ
    Coordinate{96.8339, -12.1883}, // CCK
    Coordinate{150.617, -26.775}, // CCL
    Coordinate{-49.4214, -28.7244}, // CCM
    Coordinate{65.2706, 34.5264}, // CCN
    Coordinate{-71.3364, 4.56417}, // CCO
    Coordinate{-73.0631, -36.7725}, // CCP
    Coordinate{-122.057, 37.9897}, // CCR
    Coordinate{-66.9906, 10.6031}, // CCS
    Coordinate{-67.835, -37.91}, // CCT
    Coordinate{88.4467, 22.6539}, // CCU
    Coordinate{167.924, -16.265}, // CCV
    Coordinate{136.892, -33.6667}, // CCW
    Coordinate{-57.6308, -16.0436}, // CCX
    Coordinate{-92.6108, 43.0725}, // CCY
    Coordinate{-77.8833, 25.4167}, // CCZ
    Coordinate{-162.724, 55.2053}, // CDB
    Coordinate{-113.099, 37.7008}, // CDC
    Coordinate{-83.5917, 15.3167}, // CDD
    Coordinate{118.072, 41.1219}, // CDE
    Coordinate{12.1151, 46.5743}, // CDF
    Coordinate{2.54778, 49.0097}, // CDG
    Coordinate{-92.7633, 33.6228}, // CDH
    Coordinate{-41.1875, -20.8367}, // CDI
    Coordinate{-49.3031, -8.34861}, // CDJ
    Coordinate{-83.0506, 29.1342}, // CDK
    Coordinate{-80.565, 34.2836}, // CDN
    Coordinate{78.7728, 14.51}, // CDP
    Coordinate{-103.095, 42.8375}, // CDR
    Coordinate{-100.288, 34.4339}, // CDS
    Coordinate{0.02474, 39.9981}, // CDT
    Coordinate{150.687, -34.0403}, // CDU
    Coordinate{-145.477, 60.4917}, // CDV
    Coordinate{-74.2814, 40.8753}, // CDW
    Coordinate{118.495, 7.01273}, // CDY
    Coordinate{-97.2506, 37.6486}, // CEA
    Coordinate{123.983, 10.3167}, // CEB
    Coordinate{-124.237, 41.7803}, // CEC
    Coordinate{133.71, -32.1306}, // CED
    Coordinate{38.0283, 59.2767}, // CEE
    Coordinate{-72.5347, 42.1939}, // CEF
    Coordinate{-2.97778, 53.1781}, // CEG
    Coordinate{33.8, -10.55}, // CEH
    Coordinate{99.8828, 19.9522}, // CEI
    Coordinate{31.16, 51.4033}, // CEJ
    Coordinate{61.505, 55.305}, // CEK
    Coordinate{-76.2947, 24.7903}, // CEL
    Coordinate{-144.781, 65.5739}, // CEM
    Coordinate{-109.833, 27.3925}, // CEN
    Coordinate{15.1015, -11.4264}, // CEO
    Coordinate{-62.026, -16.1472}, // CEP
    Coordinate{6.95417, 43.5464}, // CEQ
    Coordinate{-1.47528, 49.6508}, // CER
    Coordinate{151.342, -32.7883}, // CES
    Coordinate{-0.877222, 47.0819}, // CET
    Coordinate{-82.8868, 34.6719}, // CEU
    Coordinate{-85.1311, 39.6983}, // CEV
    Coordinate{-86.5221, 30.7788}, // CEW
    Coordinate{-88.3728, 36.6644}, // CEY
    Coordinate{-108.628, 37.3031}, // CEZ
    Coordinate{-42.0714, -22.9208}, // CFB
    Coordinate{-50.9397, -26.7897}, // CFC
    Coordinate{-96.3314, 30.7156}, // CFD
    Coordinate{3.1625, 45.7858}, // CFE
    Coordinate{17.9906, -8.78347}, // CFF
    Coordinate{-80.3975, 22.15}, // CFG
    Coordinate{-8.34111, 55.0442}, // CFN
    Coordinate{-51.5672, -10.6336}, // CFO
    Coordinate{-116.498, 49.0367}, // CFQ
    Coordinate{-0.45, 49.1733}, // CFR
    Coordinate{153.116, -30.3206}, // CFS
    Coordinate{-109.211, 32.9569}, // CFT
    Coordinate{19.9122, 39.6019}, // CFU
    Coordinate{-95.5719, 37.0942}, // CFV
    Coordinate{-133.148, 55.4789}, // CGA
    Coordinate{-56.1175, -15.65}, // CGB
    Coordinate{148.432, -5.45917}, // CGC
    Coordinate{111.64, 28.9189}, // CGD
    Coordinate{-76.0303, 38.5394}, // CGE
    Coordinate{-81.4864, 41.565}, // CGF
    Coordinate{-46.6564, -23.6261}, // CGH
    Coordinate{-89.5708, 37.2253}, // CGI
    Coordinate{27.8939, -12.5728}, // CGJ
    Coordinate{106.654, -6.12736}, // CGK
    Coordinate{124.707, 9.25361}, // CGM
    Coordinate{7.14278, 50.8658}, // CGN
    Coordinate{113.841, 34.5197}, // CGO
    Coordinate{91.8133, 22.2497}, // CGP
    Coordinate{121.196, 43.905}, // CGQ
    Coordinate{-54.6703, -20.4694}, // CGR
    Coordinate{-76.9223, 38.9806}, // CGS
    Coordinate{124.457, 8.6125}, // CGY
    Coordinate{-111.767, 32.955}, // CGZ
    Coordinate{-85.2039, 35.0353}, // CHA
    Coordinate{74.0817, 35.4267}, // CHB
    Coordinate{172.532, -43.4894}, // CHC
    Coordinate{-111.811, 33.2692}, // CHD
    Coordinate{128.696, 35.1411}, // CHF
    Coordinate{120.435, 41.5381}, // CHG
    Coordinate{-77.8561, -6.20194}, // CHH
    Coordinate{32.6289, -20.2064}, // CHJ
    Coordinate{-97.9678, 35.0972}, // CHK
    Coordinate{-114.218, 44.5236}, // CHL
    Coordinate{-78.5239, -9.14972}, // CHM
    Coordinate{127.119, 35.8783}, // CHN
    Coordinate{-78.4529, 38.1386}, // CHO
    Coordinate{-144.611, 65.4856}, // CHP
    Coordinate{24.1497, 35.5317}, // CHQ
    Coordinate{1.72111, 46.8603}, // CHR
    Coordinate{-80.0406, 32.8986}, // CHS
    Coordinate{-176.457, -43.81}, // CHT
    Coordinate{-159.216, 61.5792}, // CHU
    Coordinate{-7.46445, 41.7222}, // CHV
    Coordinate{-82.5486, 9.45889}, // CHX
    Coordinate{156.396, -6.71194}, // CHY
    Coordinate{-121.876, 42.5831}, // CHZ
    Coordinate{12.5972, 41.7994}, // CIA
    Coordinate{-121.858, 39.7953}, // CIC
    Coordinate{-91.7003, 41.8891}, // CID
    Coordinate{118.908, 42.235}, // CIF
    Coordinate{-107.522, 40.4953}, // CIG
    Coordinate{113.126, 36.2475}, // CIH
    Coordinate{-112.168, 47.8283}, // CII
    Coordinate{-68.7828, -11.0403}, // CIJ
    Coordinate{-143.74, 66.645}, // CIK
    Coordinate{-163.703, 64.8978}, // CIL
    Coordinate{-73.97, 6.36667}, // CIM
    Coordinate{-94.7889, 42.0461}, // CIN
    Coordinate{-57.4278, -23.4417}, // CIO
    Coordinate{32.5869, -13.5569}, // CIP
    Coordinate{-89.6167, 14.85}, // CIQ
    Coordinate{-171.713, -2.77}, // CIS
    Coordinate{69.4761, 42.365}, // CIT
    Coordinate{-84.4725, 46.2508}, // CIU
    Coordinate{-61.3444, 12.6992}, // CIW
    Coordinate{-79.8281, -6.78722}, // CIX
    Coordinate{14.6069, 36.9917}, // CIY
    Coordinate{-63.1311, -4.13389}, // CIZ
    Coordinate{-78.4892, -7.13917}, // CJA
    Coordinate{77.0419, 11.0305}, // CJB
    Coordinate{-68.9036, -22.4897}, // CJC
    Coordinate{118.802, -22.9667}, // CJF
    Coordinate{-124.142, 51.6261}, // CJH
    Coordinate{127.499, 36.7164}, // CJJ
    Coordinate{71.7981, 35.8817}, // CJL
    Coordinate{99.3617, 10.7111}, // CJM
    Coordinate{108.49, -7.72039}, // CJN
    Coordinate{-77.8597, 38.5256}, // CJR
    Coordinate{-106.429, 31.6361}, // CJS
    Coordinate{-92.0506, 16.175}, // CJT
    Coordinate{126.493, 33.5122}, // CJU
    Coordinate{-38.5719, -6.90444}, // CJZ
    Coordinate{-80.2281, 39.2967}, // CKB
    Coordinate{31.9953, 49.4156}, // CKC
    Coordinate{-158.135, 61.8678}, // CKD
    Coordinate{-122.901, 38.9906}, // CKE
    Coordinate{-83.7739, 31.9889}, // CKF
    Coordinate{106.642, 29.7192}, // CKG
    Coordinate{147.897, 70.625}, // CKH
    Coordinate{132.483, -11.1653}, // CKI
    Coordinate{38.0617, 55.8783}, // CKL
    Coordinate{-90.5122, 34.2997}, // CKM
    Coordinate{-96.6217, 47.8408}, // CKN
    Coordinate{-50.6028, -23.1528}, // CKO
    Coordinate{-50.0042, -6.11778}, // CKS
    Coordinate{61.07, 36.4881}, // CKT
    Coordinate{-145.727, 60.5439}, // CKU
    Coordinate{-87.415, 36.6219}, // CKV
    Coordinate{119.652, -22.3556}, // CKW
    Coordinate{-141.952, 64.0714}, // CKX
    Coordinate{-13.6119, 9.57689}, // CKY
    Coordinate{-75.2906, 40.3892}, // CKZ
    Coordinate{91.1833, 23.4333}, // CLA
    Coordinate{-117.28, 33.1283}, // CLD
    Coordinate{-81.8497, 41.4117}, // CLE
    Coordinate{-120.294, 36.1631}, // CLG
    Coordinate{149.61, -31.7733}, // CLH
    Coordinate{-88.7308, 44.6133}, // CLI
    Coordinate{23.6861, 46.7851}, // CLJ
    Coordinate{-98.9328, 35.5383}, // CLK
    Coordinate{-96.3639, 30.5886}, // CLL
    Coordinate{-123.5, 48.1203}, // CLM
    Coordinate{-47.4586, -7.33361}, // CLN
    Coordinate{-76.3814, 3.54306}, // CLO
    Coordinate{-158.529, 58.8336}, // CLP
    Coordinate{-103.578, 19.2769}, // CLQ
    Coordinate{-115.521, 33.1314}, // CLR
    Coordinate{-122.59, 46.4062}, // CLS
    Coordinate{-85.8964, 39.2619}, // CLU
    Coordinate{-48.61, -17.7247}, // CLV
    Coordinate{-82.7586, 27.9767}, // CLW
    Coordinate{-57.7348, -25.3048}, // CLX
    Coordinate{8.79, 42.525}, // CLY
    Coordinate{-67.4169, 8.92444}, // CLZ
    Coordinate{145.622, -28.03}, // CMA
    Coordinate{79.8836, 7.18111}, // CMB
    Coordinate{148.028, -34.625}, // CMD
    Coordinate{-91.7995, 18.652}, // CME
    Coordinate{5.88, 45.6392}, // CMF
    Coordinate{-57.6714, -19.0119}, // CMG
    Coordinate{-82.8919, 39.9981}, // CMH
    Coordinate{-88.2781, 40.0392}, // CMI
    Coordinate{119.418, 23.2131}, // CMJ
    Coordinate{35.1325, -14.3069}, // CMK
    Coordinate{138.125, -19.9117}, // CML
    Coordinate{-90.0528, 17.4625}, // CMM
    Coordinate{-7.58167, 33.3642}, // CMN
    Coordinate{48.5256, 5.35}, // CMO
    Coordinate{-50.3503, -9.33528}, // CMP
    Coordinate{147.62, -22.7733}, // CMQ
    Coordinate{7.35917, 48.1103}, // CMR
    Coordinate{50.2056, 10.3}, // CMS
    Coordinate{144.97, -6.02417}, // CMU
    Coordinate{175.509, -36.7917}, // CMV
    Coordinate{-77.8475, 21.4203}, // CMW
    Coordinate{-88.4892, 47.1683}, // CMX
    Coordinate{-90.7378, 43.9583}, // CMY
    Coordinate{-110.267, 31}, // CNA
    Coordinate{148.375, -30.9834}, // CNB
    Coordinate{143.067, -10.05}, // CNC
    Coordinate{28.4883, 44.3621}, // CND
    Coordinate{-43.9714, -19.6239}, // CNF
    Coordinate{-72.3686, 43.3706}, // CNH
    Coordinate{122.667, 39.2664}, // CNI
    Coordinate{140.504, -20.6686}, // CNJ
    Coordinate{-97.6522, 39.5492}, // CNK
    Coordinate{10.2266, 57.5047}, // CNL
    Coordinate{-104.263, 32.3375}, // CNM
    Coordinate{-117.637, 33.9747}, // CNO
    Coordinate{-22.6486, 70.7433}, // CNP
    Coordinate{-58.7619, -27.4456}, // CNQ
    Coordinate{-70.6074, -26.3344}, // CNR
    Coordinate{145.755, -16.8858}, // CNS
    Coordinate{-95.485, 37.6689}, // CNU
    Coordinate{-97.0742, 31.6378}, // CNW
    Coordinate{98.9625, 18.7667}, // CNX
    Coordinate{-109.755, 38.755}, // CNY
    Coordinate{19.8604, -13.7094}, // CNZ
    Coordinate{-120.414, 38.0306}, // COA
    Coordinate{-57.9967, -31.2969}, // COC
    Coordinate{-109.024, 44.5203}, // COD
    Coordinate{-116.819, 47.7744}, // COE
    Coordinate{-76.6833, 5.08333}, // COG
    Coordinate{89.4679, 26.3307}, // COH
    Coordinate{-80.6856, 28.3417}, // COI
    Coordinate{149.267, -31.3333}, // COJ
    Coordinate{76.4019, 10.1519}, // COK
    Coordinate{-6.61778, 56.6019}, // COL
    Coordinate{-99.4033, 31.8411}, // COM
    Coordinate{-71.5022, 43.2028}, // CON
    Coordinate{2.385, 6.35583}, // COO
    Coordinate{-74.8911, 42.6292}, // COP
    Coordinate{114.646, 48.1356}, // COQ
    Coordinate{-64.2083, -31.31}, // COR
    Coordinate{-104.701, 38.8058}, // COS
    Coordinate{-99.2183, 28.4567}, // COT
    Coordinate{-92.2197, 38.8181}, // COU
    Coordinate{-7.48, 40.2642}, // COV
    Coordinate{-77.5898, 24.1587}, // COX
    Coordinate{117.759, -21.7942}, // COY
    Coordinate{-70.7197, 18.9075}, // COZ
    Coordinate{-7.70012, 4.36764}, // CPA
    Coordinate{-77.35, 8.63028}, // CPB
    Coordinate{-71.1372, -40.0753}, // CPC
    Coordinate{134.721, -29.04}, // CPD
    Coordinate{-90.5008, 19.8158}, // CPE
    Coordinate{111.548, -7.19472}, // CPF
    Coordinate{12.6561, 55.6181}, // CPH
    Coordinate{-76.3206, 36.6656}, // CPK
    Coordinate{-75.4653, 3.72444}, // CPL
    Coordinate{-118.244, 33.89}, // CPM
    Coordinate{-70.7792, -27.2612}, // CPO
    Coordinate{-47.1081, -22.8592}, // CPQ
    Coordinate{-106.464, 42.9081}, // CPR
    Coordinate{-90.1561, 38.5708}, // CPS
    Coordinate{18.5972, -33.9694}, // CPT
    Coordinate{-44.8669, -1.82111}, // CPU
    Coordinate{-35.895, -7.26917}, // CPV
    Coordinate{-65.3044, 18.3133}, // CPX
    Coordinate{-52.2708, -13.5744}, // CQA
    Coordinate{-96.8203, 35.7239}, // CQB
    Coordinate{50.8422, 32.2972}, // CQD
    Coordinate{1.95139, 50.9608}, // CQF
    Coordinate{-3.97, 38.8564}, // CQM
    Coordinate{-69.9894, 41.6883}, // CQX
    Coordinate{23.8886, 44.3181}, // CRA
    Coordinate{148.582, -29.5219}, // CRB
    Coordinate{-75.9558, 4.75833}, // CRC
    Coordinate{-67.4656, -45.7853}, // CRD
    Coordinate{-78.7239, 33.8117}, // CRE
    Coordinate{15.9, 4.93333}, // CRF
    Coordinate{-81.5144, 30.3364}, // CRG
    Coordinate{-74.1822, 22.7456}, // CRI
    Coordinate{120.56, 15.1858}, // CRK
    Coordinate{4.46516, 50.4641}, // CRL
    Coordinate{124.636, 12.5022}, // CRM
    Coordinate{-119.595, 36.1028}, // CRO
    Coordinate{-97.5011, 27.7703}, // CRP
    Coordinate{-39.2544, -17.6506}, // CRQ
    Coordinate{-61.8767, -29.8717}, // CRR
    Coordinate{-96.4006, 32.0281}, // CRS
    Coordinate{-91.8803, 33.1783}, // CRT
    Coordinate{-61.4722, 12.4769}, // CRU
    Coordinate{17.0803, 38.9972}, // CRV
    Coordinate{-81.5931, 38.3758}, // CRW
    Coordinate{-88.6036, 34.915}, // CRX
    Coordinate{63.6133, 39.0833}, // CRZ
    Coordinate{-6.24306, 56.0575}, // CSA
    Coordinate{22.2522, 45.4202}, // CSB
    Coordinate{-83.5931, 10.1606}, // CSC
    Coordinate{-84.9389, 32.5164}, // CSG
    Coordinate{35.7333, 65.03}, // CSH
    Coordinate{153.067, -28.8833}, // CSI
    Coordinate{-16.7461, 12.3889}, // CSK
    Coordinate{-109.937, 22.9475}, // CSL
    Coordinate{-99.2006, 35.3397}, // CSM
    Coordinate{-119.734, 39.1922}, // CSN
    Coordinate{11.418, 51.8559}, // CSO
    Coordinate{-94.3633, 41.0214}, // CSQ
    Coordinate{-51.6853, -19.1464}, // CSS
    Coordinate{-52.4122, -29.6836}, // CSU
    Coordinate{113.221, 28.1967}, // CSX
    Coordinate{47.3472, 56.09}, // CSY
    Coordinate{15.0639, 37.4667}, // CTA
    Coordinate{-112.376, 48.6083}, // CTB
    Coordinate{-65.7508, -28.5931}, // CTC
    Coordinate{-80.4097, 7.9875}, // CTD
    Coordinate{-78.9792, 9.45278}, // CTE
    Coordinate{-91.8825, 14.6942}, // CTF
    Coordinate{-75.5131, 10.4425}, // CTG
    Coordinate{-75.8656, 39.9789}, // CTH
    Coordinate{19.1572, -15.1605}, // CTI
    Coordinate{-85.1522, 33.6317}, // CTJ
    Coordinate{-90.0747, 40.5692}, // CTK
    Coordinate{146.262, -26.4133}, // CTL
    Coordinate{-88.3269, 18.5046}, // CTM
    Coordinate{145.184, -15.4447}, // CTN
    Coordinate{-72.7919, 40.915}, // CTO
    Coordinate{-53.3442, -33.5022}, // CTQ
    Coordinate{141.692, 42.7752}, // CTS
    Coordinate{5.78611, 43.2522}, // CTT
    Coordinate{103.948, 30.58}, // CTU
    Coordinate{-114.701, 29.7264}, // CTV
    Coordinate{-76.2147, 42.5925}, // CTX
    Coordinate{-83.1047, 29.6356}, // CTY
    Coordinate{-78.3656, 34.975}, // CTZ
    Coordinate{-111.615, 25.0539}, // CUA
    Coordinate{-80.9953, 33.9706}, // CUB
    Coordinate{-72.5117, 7.9275}, // CUC
    Coordinate{153.105, -26.8017}, // CUD
    Coordinate{-78.9844, -2.88944}, // CUE
    Coordinate{7.62182, 44.546}, // CUF
    Coordinate{-96.7733, 35.95}, // CUH
    Coordinate{-88.0294, 17.735}, // CUK
    Coordinate{-107.475, 24.7644}, // CUL
    Coordinate{-64.1306, 10.4503}, // CUM
    Coordinate{-86.8769, 21.0367}, // CUN
    Coordinate{-71.2972, 1.01389}, // CUO
    Coordinate{-63.2617, 10.66}, // CUP
    Coordinate{143.114, -13.7619}, // CUQ
    Coordinate{-68.9597, 12.1889}, // CUR
    Coordinate{-107.662, 31.8081}, // CUS
    Coordinate{-69.2647, -38.9397}, // CUT
    Coordinate{-105.964, 28.7028}, // CUU
    Coordinate{-72.5366, 8.75639}, // CUV
    Coordinate{117.918, -27.4467}, // CUY
    Coordinate{-71.9436, -13.5356}, // CUZ
    Coordinate{136.505, -33.71}, // CVC
    Coordinate{-75.7, 9.4}, // CVE
    Coordinate{6.62717, 45.3974}, // CVF
    Coordinate{-84.6678, 39.0489}, // CVG
    Coordinate{-71.0161, -37.8506}, // CVH
    Coordinate{-99.2619, 18.8345}, // CVJ
    Coordinate{-91.5628, 36.265}, // CVK
    Coordinate{-98.9565, 23.7033}, // CVM
    Coordinate{-103.079, 34.4253}, // CVN
    Coordinate{-123.289, 44.4972}, // CVO
    Coordinate{113.672, -24.8806}, // CVQ
    Coordinate{-1.47972, 52.3725}, // CVT
    Coordinate{-31.1128, 39.6708}, // CVU
    Coordinate{-85.2753, 45.3047}, // CVX
    Coordinate{-89.6667, 44.7775}, // CWA
    Coordinate{-49.1761, -25.5317}, // CWB
    Coordinate{25.9811, 48.2589}, // CWC
    Coordinate{-93.1431, 30.2106}, // CWF
    Coordinate{-90.3292, 41.8311}, // CWI
    Coordinate{99.3704, 23.2739}, // CWJ
    Coordinate{-3.34333, 51.3967}, // CWL
    Coordinate{-122.832, 48.49}, // CWS
    Coordinate{148.648, -33.845}, // CWT
    Coordinate{146.352, -35.99}, // CWW
    Coordinate{-109.895, 32.2456}, // CWX
    Coordinate{-66.1653, 7.61921}, // CXA
    Coordinate{91.9648, 21.4498}, // CXB
    Coordinate{-150.204, 67.2522}, // CXF
    Coordinate{-123.111, 49.2944}, // CXH
    Coordinate{-157.359, 1.98611}, // CXI
    Coordinate{-51.1897, -29.1956}, // CXJ
    Coordinate{-115.513, 32.6694}, // CXL
    Coordinate{18.9238, -8.37311}, // CXM
    Coordinate{49.9086, 11.4944}, // CXN
    Coordinate{-95.4144, 30.3525}, // CXO
    Coordinate{109.05, -7.63333}, // CXP
    Coordinate{125.917, -18.8833}, // CXQ
    Coordinate{109.219, 11.9981}, // CXR
    Coordinate{146.273, -20.0433}, // CXT
    Coordinate{-92.555, 35.0197}, // CXW
    Coordinate{-79.2761, 25.5553}, // CXY
    Coordinate{-73.7883, 18.2667}, // CYA
    Coordinate{-79.8828, 19.6869}, // CYB
    Coordinate{-88.0411, 17.7008}, // CYC
    Coordinate{-164.286, 60.1492}, // CYF
    Coordinate{147.888, -36.1828}, // CYG
    Coordinate{120.383, 23.4617}, // CYI
    Coordinate{-86.675, 15.4458}, // CYL
    Coordinate{-134.946, 57.515}, // CYM
    Coordinate{-81.5456, 21.6161}, // CYO
    Coordinate{124.545, 12.0727}, // CYP
    Coordinate{-57.7706, -34.4564}, // CYR
    Coordinate{-104.811, 41.1556}, // CYS
    Coordinate{-142.494, 60.0819}, // CYT
    Coordinate{121.068, 10.8581}, // CYU
    Coordinate{-100.9, 20.5458}, // CYW
    Coordinate{161.337, 68.7433}, // CYX
    Coordinate{121.718, 16.93}, // CYZ
    Coordinate{-88.4489, 20.6386}, // CZA
    Coordinate{-145.294, 61.9411}, // CZC
    Coordinate{-69.6817, 11.415}, // CZE
    Coordinate{-166.037, 61.7819}, // CZF
    Coordinate{-76.0964, 42.0786}, // CZG
    Coordinate{-88.4108, 18.3822}, // CZH
    Coordinate{-78.575, 9.44722}, // CZJ
    Coordinate{-121.879, 45.6769}, // CZK
    Coordinate{6.61706, 36.2824}, // CZL
    Coordinate{-86.9289, 20.515}, // CZM
    Coordinate{-142.048, 62.0711}, // CZN
    Coordinate{-72.7694, -7.59944}, // CZS
    Coordinate{-75.2856, 9.33278}, // CZU
    Coordinate{19.2047, 50.885}, // CZW
    Coordinate{119.776, 31.9193}, // CZX
    Coordinate{-81.0606, 29.1847}, // DAB
    Coordinate{90.4006, 23.8428}, // DAC
    Coordinate{108.199, 16.0439}, // DAD
    Coordinate{-116.787, 34.8536}, // DAG
    Coordinate{29.0028, 25.4111}, // DAK
    Coordinate{-96.8517, 32.8472}, // DAL
    Coordinate{36.5156, 33.4115}, // DAM
    Coordinate{-79.3361, 36.5728}, // DAN
    Coordinate{39.2028, -6.87806}, // DAR
    Coordinate{-119.717, 66.7031}, // DAS
    Coordinate{113.482, 40.0603}, // DAT
    Coordinate{143.208, -9.08667}, // DAU
    Coordinate{-82.435, 8.39083}, // DAV
    Coordinate{-70.9292, 43.2842}, // DAW
    Coordinate{107.5, 31.3}, // DAX
    Coordinate{-84.2194, 39.9025}, // DAY
    Coordinate{70.8818, 38.4617}, // DAZ
    Coordinate{64.4042, 28.875}, // DBA
    Coordinate{28.4607, 30.9251}, // DBB
    Coordinate{123.019, 45.5053}, // DBC
    Coordinate{86.4253, 23.8339}, // DBD
    Coordinate{37.7333, 10.3167}, // DBM
    Coordinate{-82.9853, 32.5644}, // DBN
    Coordinate{148.575, -32.2167}, // DBO
    Coordinate{-90.7094, 42.4019}, // DBQ
    Coordinate{}, // DBR
    Coordinate{-112.221, 44.1622}, // DBS
    Coordinate{38, 11.9667}, // DBT
    Coordinate{18.2683, 42.5614}, // DBV
    Coordinate{151.267, -27.1553}, // DBY
    Coordinate{-77.0378, 38.8522}, // DCA
    Coordinate{-61.3922, 15.3367}, // DCF
    Coordinate{-156.905, 66.9433}, // DCK
    Coordinate{2.29056, 43.555}, // DCM
    Coordinate{-84.8625, 40.8375}, // DCR
    Coordinate{-75.7294, 22.1817}, // DCT
    Coordinate{-86.9453, 34.6542}, // DCU
    Coordinate{100.053, 29.3231}, // DCY
    Coordinate{-99.9656, 37.7631}, // DDC
    Coordinate{72.8928, 2.66722}, // DDD
    Coordinate{124.287, 40.0257}, // DDG
    Coordinate{-73.2461, 42.8911}, // DDH
    Coordinate{-66.2925, 18.4644}, // DDP
    Coordinate{70.4858, 29.9608}, // DEA
    Coordinate{21.6153, 47.4889}, // DEB
    Coordinate{-88.8656, 39.8344}, // DEC
    Coordinate{78.1802, 30.1897}, // DED
    Coordinate{145.85, 44.0333}, // DEE
    Coordinate{48.3833, 32.4333}, // DEF
    Coordinate{-91.7394, 43.2756}, // DEH
    Coordinate{55.6645, -3.80222}, // DEI
    Coordinate{77.0994, 28.5544}, // DEL
    Coordinate{34.85, 8.55}, // DEM
    Coordinate{-104.673, 39.8617}, // DEN
    Coordinate{94.2167, 27.9833}, // DEP
    Coordinate{-94.3994, 34.0469}, // DEQ
    Coordinate{53.65, -5.7}, // DES
    Coordinate{-83.01, 42.4092}, // DET
    Coordinate{-117.429, 47.9669}, // DEW
    Coordinate{40.1758, 35.2853}, // DEZ
    Coordinate{-84.4289, 41.3375}, // DFI
    Coordinate{-97.0381, 32.8969}, // DFW
    Coordinate{-88.2586, 16.9825}, // DGA
    Coordinate{149.611, -32.5625}, // DGE
    Coordinate{-120.183, 50.1667}, // DGF
    Coordinate{-109.506, 31.3425}, // DGL
    Coordinate{-104.528, 24.1242}, // DGO
    Coordinate{26.665, 55.9447}, // DGP
    Coordinate{173.894, -35.9397}, // DGR
    Coordinate{123.299, 9.33361}, // DGT
    Coordinate{-3.49, 12.459}, // DGU
    Coordinate{-105.386, 42.7972}, // DGW
    Coordinate{-3.43583, 51.4047}, // DGX
    Coordinate{50.1519, 26.2653}, // DHA
    Coordinate{80.5819, 28.7533}, // DHI
    Coordinate{76.2619, 32.165}, // DHM
    Coordinate{78.8557, 23.754}, // DHN
    Coordinate{4.78278, 52.9225}, // DHR
    Coordinate{-102.547, 36.0225}, // DHT
    Coordinate{95.018, 27.481}, // DIB
    Coordinate{49.2917, -12.3511}, // DIE
    Coordinate{99.6773, 27.7933}, // DIG
    Coordinate{-111.098, 43.7425}, // DIJ
    Coordinate{-102.802, 46.7972}, // DIK
    Coordinate{125.525, -8.54655}, // DIL
    Coordinate{-4.6411, 6.6}, // DIM
    Coordinate{103.008, 21.3972}, // DIN
    Coordinate{1.783, 12.05}, // DIP
    Coordinate{-44.87, -20.1819}, // DIQ
    Coordinate{41.8542, 9.62361}, // DIR
    Coordinate{12.6597, -4.20611}, // DIS
    Coordinate{70.9211, 20.7131}, // DIU
    Coordinate{-5.35444, 5.79306}, // DIV
    Coordinate{40.2008, 37.8925}, // DIY
    Coordinate{1.6376, 9.692}, // DJA
    Coordinate{103.644, -1.63806}, // DJB
    Coordinate{10.7753, 33.875}, // DJE
    Coordinate{9.45211, 24.2929}, // DJG
    Coordinate{140.516, -2.57694}, // DJJ
    Coordinate{14.75, -2.53333}, // DJM
    Coordinate{-145.717, 64.0506}, // DJN
    Coordinate{-6.47319, 6.79281}, // DJO
    Coordinate{-14.2778, 64.6431}, // DJU
    Coordinate{7.66028, 13.0078}, // DKA
    Coordinate{146.14, -17.9417}, // DKI
    Coordinate{-79.2719, 42.4933}, // DKK
    Coordinate{-17.4793, 14.7438}, // DKR
    Coordinate{80.3817, 73.5167}, // DKS
    Coordinate{-83.8736, 35.9639}, // DKX
    Coordinate{9.71944, 4.00583}, // DLA
    Coordinate{121.538, 38.9656}, // DLC
    Coordinate{8.51245, 60.4167}, // DLD
    Coordinate{5.42444, 47.0422}, // DLE
    Coordinate{-158.506, 59.0447}, // DLG
    Coordinate{-92.1936, 46.8422}, // DLH
    Coordinate{108.374, 11.7506}, // DLI
    Coordinate{-79.3686, 34.4492}, // DLL
    Coordinate{28.7928, 36.7147}, // DLM
    Coordinate{-112.552, 45.2553}, // DLN
    Coordinate{-119.236, 35.7456}, // DLO
    Coordinate{-121.167, 45.6186}, // DLS
    Coordinate{100.318, 25.6511}, // DLU
    Coordinate{169.001, -18.7694}, // DLY
    Coordinate{104.367, 43.6086}, // DLZ
    Coordinate{71.3036, 42.8536}, // DMB
    Coordinate{138.822, -17.9403}, // DMD
    Coordinate{37.9061, 55.4086}, // DME
    Coordinate{100.607, 13.9125}, // DMK
    Coordinate{49.7978, 26.4711}, // DMM
    Coordinate{-107.721, 32.2622}, // DMN
    Coordinate{-93.1758, 38.7075}, // DMO
    Coordinate{-56.4006, -14.3769}, // DMT
    Coordinate{93.7711, 25.8839}, // DMU
    Coordinate{-77.0078, 39.6083}, // DMW
    Coordinate{-3.0175, 56.4525}, // DND
    Coordinate{94.8003, 40.1636}, // DNH
    Coordinate{36.3289, 15.3875}, // DNI
    Coordinate{35.1006, 48.3572}, // DNK
    Coordinate{-82.0394, 33.4664}, // DNL
    Coordinate{-84.8703, 34.7231}, // DNN
    Coordinate{82.2942, 28.1108}, // DNP
    Coordinate{144.946, -35.56}, // DNQ
    Coordinate{-2.08, 48.5878}, // DNR
    Coordinate{-95.3806, 41.9867}, // DNS
    Coordinate{-87.5956, 40.1992}, // DNV
    Coordinate{35.067, 12.533}, // DNX
    Coordinate{134.212, -5.77167}, // DOB
    Coordinate{35.7494, -6.17036}, // DOD
    Coordinate{-55.4816, 4.00571}, // DOE
    Coordinate{30.43, 19.1536}, // DOG
    Coordinate{51.6081, 25.2731}, // DOH
    Coordinate{37.7256, 48.075}, // DOK
    Coordinate{0.154167, 49.3633}, // DOL
    Coordinate{-61.3, 15.5469}, // DOM
    Coordinate{-89.6884, 17.6124}, // DON
    Coordinate{82.8192, 28.9858}, // DOP
    Coordinate{-0.066667, 14.0333}, // DOR
    Coordinate{-54.9256, -22.2006}, // DOU
    Coordinate{118.784, 37.5103}, // DOY
    Coordinate{-88.2483, 41.9069}, // DPA
    Coordinate{1.08528, 49.8825}, // DPE
    Coordinate{123.334, 8.60139}, // DPL
    Coordinate{146.43, -41.1697}, // DPO
    Coordinate{115.168, -8.74806}, // DPS
    Coordinate{139.899, 69.3917}, // DPT
    Coordinate{125.228, 46.5872}, // DQA
    Coordinate{-150.945, 70.3442}, // DQH
    Coordinate{-116.033, 36.6194}, // DRA
    Coordinate{123.661, -17.37}, // DRB
    Coordinate{20.7663, -17.9815}, // DRC
    Coordinate{-83.7439, 46.0094}, // DRE
    Coordinate{-162.766, 66.0694}, // DRG
    Coordinate{138.317, -2.8}, // DRH
    Coordinate{-93.34, 30.8317}, // DRI
    Coordinate{-54.6667, 4.11667}, // DRJ
    Coordinate{-83.65, 8.73333}, // DRK
    Coordinate{148.217, -28.5917}, // DRN
    Coordinate{-107.754, 37.1514}, // DRO
    Coordinate{13.7681, 51.1344}, // DRS
    Coordinate{-100.927, 29.3742}, // DRT
    Coordinate{73.1306, 5.15667}, // DRV
    Coordinate{-1.00417, 53.4753}, // DSA
    Coordinate{10.0641, 5.44809}, // DSC
    Coordinate{-61.0844, 16.2969}, // DSD
    Coordinate{39.7114, 11.0825}, // DSE
    Coordinate{-86.4714, 30.4}, // DSI
    Coordinate{70.8964, 31.9092}, // DSK
    Coordinate{-93.6631, 41.5339}, // DSM
    Coordinate{109.862, 39.4939}, // DSN
    Coordinate{127.475, 39.7473}, // DSO
    Coordinate{122.455, -29.0983}, // DSR
    Coordinate{-17.0689, 14.6708}, // DSS
    Coordinate{-77.7131, 42.5708}, // DSV
    Coordinate{116.717, 20.7}, // DSX
    Coordinate{-112.508, 39.3806}, // DTA
    Coordinate{98.9953, 2.25972}, // DTB
    Coordinate{116.48, 0.72}, // DTD
    Coordinate{122.979, 14.1262}, // DTE
    Coordinate{-116.881, 36.4639}, // DTH
    Coordinate{-43.6511, -18.2333}, // DTI
    Coordinate{-95.8847, 46.8253}, // DTL
    Coordinate{7.61222, 51.5183}, // DTM
    Coordinate{-93.745, 32.5403}, // DTN
    Coordinate{-97.1981, 33.2008}, // DTO
    Coordinate{-83.3533, 42.2125}, // DTW
    Coordinate{-96.3944, 33.9422}, // DUA
    Coordinate{-6.27, 53.4214}, // DUB
    Coordinate{-97.96, 34.4708}, // DUC
    Coordinate{170.198, -45.9281}, // DUD
    Coordinate{20.8185, -7.40064}, // DUE
    Coordinate{-75.7886, 36.2533}, // DUF
    Coordinate{-109.604, 31.4689}, // DUG
    Coordinate{-83.6558, 41.7358}, // DUH
    Coordinate{-78.8986, 41.1783}, // DUJ
    Coordinate{101.434, 1.60919}, // DUM
    Coordinate{-123.717, 48.7583}, // DUQ
    Coordinate{31.1164, -29.6144}, // DUR
    Coordinate{6.76667, 51.2894}, // DUS
    Coordinate{-166.545, 53.8989}, // DUT
    Coordinate{43.2706, -22.1111}, // DVD
    Coordinate{-110.29, 64.5114}, // DVK
    Coordinate{-98.9083, 48.1144}, // DVL
    Coordinate{-90.5883, 41.6103}, // DVN
    Coordinate{125.646, 7.12552}, // DVO
    Coordinate{-112.082, 33.6883}, // DVT
    Coordinate{34.1311, -12.5183}, // DWA
    Coordinate{45.3667, -16.1}, // DWB
    Coordinate{55.1722, 24.8861}, // DWC
    Coordinate{44.1211, 24.4497}, // DWD
    Coordinate{-95.5528, 30.0619}, // DWH
    Coordinate{-81.5715, 28.4}, // DWS
    Coordinate{-82.7381, 38.5544}, // DWU
    Coordinate{55.3644, 25.2528}, // DXB
    Coordinate{-90.1031, 32.4386}, // DXE
    Coordinate{-73.4822, 41.3717}, // DXR
    Coordinate{148.364, -22.6222}, // DYA
    Coordinate{110.443, 29.1031}, // DYG
    Coordinate{-75.1219, 40.3331}, // DYL
    Coordinate{177.742, 64.735}, // DYR
    Coordinate{-92.0433, 46.7219}, // DYT
    Coordinate{68.8217, 38.5436}, // DYU
    Coordinate{45.2806, -12.8067}, // DZA
    Coordinate{-83.9972, 34.8544}, // DZJ
    Coordinate{67.7333, 47.7083}, // DZN
    Coordinate{-56.4992, -33.3586}, // DZO
    Coordinate{-141.15, 64.7781}, // EAA
    Coordinate{43.1778, 15.3}, // EAB
    Coordinate{168.342, -17.0892}, // EAE
    Coordinate{167.333, 9.08333}, // EAL
    Coordinate{44.4192, 17.6114}, // EAM
    Coordinate{7.52917, 47.59}, // EAP
    Coordinate{-99.0067, 40.7269}, // EAR
    Coordinate{-1.79056, 43.3564}, // EAS
    Coordinate{-120.206, 47.3981}, // EAT
    Coordinate{-91.4842, 44.8658}, // EAU
    Coordinate{10.2394, 42.7603}, // EBA
    Coordinate{32.4431, 0.0447222}, // EBB
    Coordinate{30.2325, 13.1531}, // EBD
    Coordinate{-74.8089, 7.59639}, // EBG
    Coordinate{8.55333, 55.5258}, // EBJ
    Coordinate{43.9631, 36.2375}, // EBL
    Coordinate{168.753, 4.59889}, // EBO
    Coordinate{-93.8692, 42.4364}, // EBS
    Coordinate{4.29639, 45.5406}, // EBU
    Coordinate{11.1833, 2.85}, // EBW
    Coordinate{-76.1744, 36.2606}, // ECG
    Coordinate{144.762, -36.1572}, // ECH
    Coordinate{-85.9333, 11.4333}, // ECI
    Coordinate{33.4884, 35.1596}, // ECN
    Coordinate{-85.7956, 30.3583}, // ECP
    Coordinate{-78.0944, 2.45}, // ECR
    Coordinate{-3.785, 40.3706}, // ECV
    Coordinate{30.9583, 18.025}, // EDB
    Coordinate{-97.5733, 30.3967}, // EDC
    Coordinate{-76.5672, 36.0278}, // EDE
    Coordinate{-3.3725, 55.95}, // EDI
    Coordinate{-83.8189, 40.3722}, // EDJ
    Coordinate{-96.8175, 37.7742}, // EDK
    Coordinate{35.2389, 0.404444}, // EDL
    Coordinate{-1.38167, 46.7025}, // EDM
    Coordinate{27.0138, 39.5546}, // EDO
    Coordinate{-88.4375, 14.2361}, // EDQ
    Coordinate{141.609, -14.8967}, // EDR
    Coordinate{-121.786, 38.5314}, // EDU
    Coordinate{-114.623, 34.7664}, // EED
    Coordinate{-162.044, 60.2136}, // EEK
    Coordinate{-72.2708, 42.8983}, // EEN
    Coordinate{-86.7831, 33.1778}, // EET
    Coordinate{-95.1589, 29.6072}, // EFD
    Coordinate{147.66, -9.15567}, // EFG
    Coordinate{-72.2292, 44.8889}, // EFK
    Coordinate{20.5003, 38.12}, // EFL
    Coordinate{0.520555, 44.8244}, // EGC
    Coordinate{-106.918, 39.6425}, // EGE
    Coordinate{34.1292, 31.0689}, // EGH
    Coordinate{-86.5254, 30.6492}, // EGI
    Coordinate{39.75, 5.28333}, // EGL
    Coordinate{157.875, -8.578}, // EGM
    Coordinate{22.4672, 13.4817}, // EGN
    Coordinate{36.59, 50.6433}, // EGO
    Coordinate{-100.513, 28.8572}, // EGP
    Coordinate{-14.4014, 65.2833}, // EGS
    Coordinate{-97.3883, 37.3236}, // EGT
    Coordinate{-89.2683, 45.9322}, // EGV
    Coordinate{-157.376, 58.1856}, // EGX
    Coordinate{-101.88, 37.0008}, // EHA
    Coordinate{-71.5322, -41.9433}, // EHL
    Coordinate{-162.063, 58.6464}, // EHM
    Coordinate{-81.6008, 35.2558}, // EHO
    Coordinate{-87.6856, 37.8078}, // EHR
    Coordinate{10.4727, 50.9922}, // EIB
    Coordinate{92.1133, 58.4733}, // EIE
    Coordinate{38.2145, 46.6835}, // EIK
    Coordinate{5.37417, 51.4506}, // EIN
    Coordinate{-64.5431, 18.4456}, // EIS
    Coordinate{35.2032, 30.6215}, // EIY
    Coordinate{-73.8067, 7.02444}, // EJA
    Coordinate{36.4764, 26.1986}, // EJH
    Coordinate{101.001, 42.0156}, // EJN
    Coordinate{171.984, 6.04028}, // EJT
    Coordinate{-124.113, 40.8033}, // EKA
    Coordinate{75.2167, 51.5833}, // EKB
    Coordinate{-86.0033, 41.7194}, // EKI
    Coordinate{-115.792, 40.825}, // EKO
    Coordinate{-84.8561, 36.8553}, // EKQ
    Coordinate{}, // EKS
    Coordinate{16.7083, 59.35}, // EKT
    Coordinate{-85.925, 37.6861}, // EKX
    Coordinate{-86.9264, 33.3125}, // EKY
    Coordinate{-73.975, 9.04583}, // ELB
    Coordinate{135.571, -12.0193}, // ELC
    Coordinate{-92.8133, 33.2211}, // ELD
    Coordinate{-77.7264, 8.10694}, // ELE
    Coordinate{25.3244, 13.6147}, // ELF
    Coordinate{2.86422, 30.5774}, // ELG
    Coordinate{-76.6836, 25.475}, // ELH
    Coordinate{-162.271, 64.615}, // ELI
    Coordinate{-99.3943, 35.4308}, // ELK
    Coordinate{-76.8917, 42.16}, // ELM
    Coordinate{-120.531, 47.0331}, // ELN
    Coordinate{-54.5747, -26.4}, // ELO
    Coordinate{-106.378, 31.8072}, // ELP
    Coordinate{43.7742, 26.3028}, // ELQ
    Coordinate{27.8214, -33.035}, // ELS
    Coordinate{33.6456, 28.2092}, // ELT
    Coordinate{6.78258, 33.5129}, // ELU
    Coordinate{-136.348, 58.1953}, // ELV
    Coordinate{-64.2106, 8.83278}, // ELX
    Coordinate{-114.842, 39.2997}, // ELY
    Coordinate{-77.99, 42.1094}, // ELZ
    Coordinate{-1.32806, 52.8311}, // EMA
    Coordinate{148.179, -23.5675}, // EMD
    Coordinate{7.2275, 53.3911}, // EME
    Coordinate{149.975, -1.64167}, // EMI
    Coordinate{-164.491, 62.7861}, // EMK
    Coordinate{-110.557, 41.8242}, // EMM
    Coordinate{-7.31639, 16.6219}, // EMN
    Coordinate{-96.1911, 38.3322}, // EMP
    Coordinate{-118.035, 34.0861}, // EMT
    Coordinate{-71.1707, -42.0333}, // EMX
    Coordinate{-151.245, 60.5733}, // ENA
    Coordinate{6.22611, 48.6922}, // ENC
    Coordinate{121.661, -8.84917}, // ENE
    Coordinate{23.4275, 68.3644}, // ENF
    Coordinate{109.485, 30.3203}, // ENH
    Coordinate{119.416, 11.2025}, // ENI
    Coordinate{-90.1514, 17.3528}, // ENJ
    Coordinate{-7.65194, 54.3986}, // ENK
    Coordinate{-89.092, 38.5148}, // ENL
    Coordinate{-149.074, 64.5472}, // ENN
    Coordinate{-55.8396, -27.2358}, // ENO
    Coordinate{6.88667, 52.2742}, // ENS
    Coordinate{162.328, 11.34}, // ENT
    Coordinate{7.56194, 6.47417}, // ENU
    Coordinate{-114.031, 40.7186}, // ENV
    Coordinate{-87.9278, 42.5956}, // ENW
    Coordinate{109.553, 36.6367}, // ENY
    Coordinate{-81.6406, 34.3094}, // EOE
    Coordinate{-75.5903, 6.21972}, // EOH
    Coordinate{-2.77222, 59.1906}, // EOI
    Coordinate{-91.4286, 40.46}, // EOK
    Coordinate{-82.9281, 39.1669}, // EOP
    Coordinate{-61.6389, 6.71583}, // EOR
    Coordinate{-94.3917, 36.8108}, // EOS
    Coordinate{-69.4967, 7.05972}, // EOZ
    Coordinate{-58.6125, -34.61}, // EPA
    Coordinate{-119.517, 47.3081}, // EPH
    Coordinate{6.06667, 48.3247}, // EPL
    Coordinate{-67.0128, 44.91}, // EPM
    Coordinate{121.823, -33.6844}, // EPR
    Coordinate{-69.4333, 19.1986}, // EPS
    Coordinate{24.4728, 58.4192}, // EPU
    Coordinate{-71.1467, -42.9067}, // EQS
    Coordinate{-80.6203, 35.0189}, // EQY
    Coordinate{47.3833, 10.6347}, // ERA
    Coordinate{39.5206, 39.71}, // ERC
    Coordinate{36.7581, 46.8147}, // ERD
    Coordinate{10.9581, 50.9797}, // ERF
    Coordinate{108.03, 61.275}, // ERG
    Coordinate{-4.40066, 31.9475}, // ERH
    Coordinate{-80.1808, 42.085}, // ERI
    Coordinate{112.098, 43.4267}, // ERL
    Coordinate{-52.2761, -27.66}, // ERM
    Coordinate{-69.8831, -6.6375}, // ERN
    Coordinate{141.007, -20.9767}, // ERQ
    Coordinate{-71.1643, 44.7927}, // ERR
    Coordinate{17.0806, -22.6122}, // ERS
    Coordinate{-99.0856, 29.9767}, // ERV
    Coordinate{-85.4572, 46.311}, // ERY
    Coordinate{41.1692, 39.9553}, // ERZ
    Coordinate{32.995, 40.1281}, // ESB
    Coordinate{-87.0936, 45.7228}, // ESC
    Coordinate{-122.911, 48.7081}, // ESD
    Coordinate{-116.604, 31.7952}, // ESE
    Coordinate{-60.6217, -22.045}, // ESG
    Coordinate{-0.297222, 50.8356}, // ESH
    Coordinate{30.5819, 39.7822}, // ESK
    Coordinate{44.3308, 46.3739}, // ESL
    Coordinate{-79.6267, 0.978611}, // ESM
    Coordinate{-76.0689, 38.8042}, // ESN
    Coordinate{-106.045, 36.0261}, // ESO
    Coordinate{-75.1606, 41.0358}, // ESP
    Coordinate{-69.7658, -26.3133}, // ESR
    Coordinate{6.93722, 51.4022}, // ESS
    Coordinate{-9.68167, 31.3975}, // ESU
    Coordinate{-121.186, 47.2542}, // ESW
    Coordinate{-88.1278, 43.4222}, // ETB
    Coordinate{34.9592, 29.5594}, // ETH
    Coordinate{-79.9778, -3.43528}, // ETR
    Coordinate{-85.8997, 31.2997}, // ETS
    Coordinate{6.24667, 48.9783}, // ETZ
    Coordinate{-174.95, -21.3833}, // EUA
    Coordinate{128.877, -31.7067}, // EUC
    Coordinate{-116.005, 39.6042}, // EUE
    Coordinate{-85.1289, 31.9514}, // EUF
    Coordinate{-123.219, 44.1231}, // EUG
    Coordinate{-116.636, 43.6419}, // EUL
    Coordinate{-13.2192, 27.1517}, // EUN
    Coordinate{121.932, 10.7658}, // EUQ
    Coordinate{-62.9794, 17.4964}, // EUX
    Coordinate{-80.9489, 29.0556}, // EVB
    Coordinate{16.6781, 68.4913}, // EVE
    Coordinate{14.4228, 62.0478}, // EVG
    Coordinate{153.42, -29.0933}, // EVH
    Coordinate{44.3958, 40.1472}, // EVN
    Coordinate{-94.9167, 40.3533}, // EVU
    Coordinate{-87.5308, 38.0383}, // EVV
    Coordinate{-75.7206, 39.5203}, // EVY
    Coordinate{-70.9569, 41.6761}, // EWB
    Coordinate{138.067, -5.48333}, // EWE
    Coordinate{136.378, -3.92583}, // EWI
    Coordinate{-97.2744, 38.0583}, // EWK
    Coordinate{-77.0431, 35.0731}, // EWN
    Coordinate{14.8, -0.883333}, // EWO
    Coordinate{-74.1686, 40.6925}, // EWR
    Coordinate{-135.449, 58.4206}, // EXI
    Coordinate{-3.41389, 50.7344}, // EXT
    Coordinate{-80.3039, 35.7811}, // EXX
    Coordinate{-78.5792, 34.6017}, // EYF
    Coordinate{66.6831, 63.6831}, // EYK
    Coordinate{-10.567, 15.133}, // EYL
    Coordinate{-72.3862, 5.31962}, // EYP
    Coordinate{-95.6397, 29.9353}, // EYQ
    Coordinate{-119.158, 39.0042}, // EYR
    Coordinate{35.9744, 3.23639}, // EYS
    Coordinate{-81.7594, 24.5561}, // EYW
    Coordinate{-58.5358, -34.8222}, // EZE
    Coordinate{39.2914, 38.605}, // EZS
    Coordinate{-10.7698, 10.0355}, // FAA
    Coordinate{-0.7775, 51.2753}, // FAB
    Coordinate{-145.333, -16.6869}, // FAC
    Coordinate{-7.27722, 62.0636}, // FAE
    Coordinate{-16.6417, 63.875}, // FAG
    Coordinate{62.1655, 32.3662}, // FAH
    Coordinate{-147.856, 64.815}, // FAI
    Coordinate{-65.6619, 18.3081}, // FAJ
    Coordinate{6.625, 58.1003}, // FAN
    Coordinate{-7.96583, 37.0144}, // FAO
    Coordinate{141.96, -4.609}, // FAQ
    Coordinate{-96.8158, 46.9206}, // FAR
    Coordinate{-14.05, 64.9319}, // FAS
    Coordinate{-119.719, 36.7709}, // FAT
    Coordinate{56.4825, 22.3483}, // FAU
    Coordinate{-145.657, -16.0542}, // FAV
    Coordinate{-78.8803, 34.9911}, // FAY
    Coordinate{53.7233, 28.8917}, // FAZ
    Coordinate{-66.0672, -2.53361}, // FBA
    Coordinate{70.5183, 37.1194}, // FBD
    Coordinate{-53.0639, -26.0594}, // FBE
    Coordinate{27.531, -11.5913}, // FBM
    Coordinate{-123.01, 48.5372}, // FBS
    Coordinate{-114.256, 48.3106}, // FCA
    Coordinate{27.9089, -28.8231}, // FCB
    Coordinate{-119.82, 36.7322}, // FCH
    Coordinate{-77.525, 37.4067}, // FCI
    Coordinate{-93.4572, 44.8272}, // FCM
    Coordinate{8.66417, 53.7683}, // FCN
    Coordinate{12.2389, 41.8003}, // FCO
    Coordinate{-90.775, 34.9419}, // FCY
    Coordinate{5.75694, 61.3911}, // FDE
    Coordinate{-60.9964, 14.5922}, // FDF
    Coordinate{9.51139, 47.6714}, // FDH
    Coordinate{-77.3744, 39.4175}, // FDK
    Coordinate{-58.5913, -34.4549}, // FDO
    Coordinate{-98.9839, 34.3522}, // FDR
    Coordinate{17.3817, -3.31139}, // FDU
    Coordinate{-81.1089, 34.3156}, // FDW
    Coordinate{-83.6686, 41.0119}, // FDY
    Coordinate{81.2167, 29.2333}, // FEB
    Coordinate{-38.9067, -12.2031}, // FEC
    Coordinate{71.745, 40.3589}, // FEG
    Coordinate{-70.3472, -8.14083}, // FEJ
    Coordinate{-5.2, 9.6}, // FEK
    Coordinate{-32.4283, -3.85472}, // FEN
    Coordinate{-89.5819, 42.2461}, // FEP
    Coordinate{-96.5203, 41.4492}, // FET
    Coordinate{-4.97778, 33.9272}, // FEZ
    Coordinate{-75.6714, 36.0183}, // FFA
    Coordinate{-84.5719, 33.3572}, // FFC
    Coordinate{-91.9808, 41.0558}, // FFL
    Coordinate{-96.1567, 46.2844}, // FFM
    Coordinate{-84.9061, 38.1819}, // FFT
    Coordinate{-71.8512, -43.1888}, // FFU
    Coordinate{-85.995, 43.4394}, // FFX
    Coordinate{-12.733, 22.667}, // FGD
    Coordinate{-171.742, -13.8492}, // FGI
    Coordinate{170.02, -43.4621}, // FGL
    Coordinate{-140.887, -15.8197}, // FGU
    Coordinate{-83.7433, 38.5417}, // FGX
    Coordinate{-81.4611, 30.6119}, // FHB
    Coordinate{-110.344, 31.5883}, // FHU
    Coordinate{-72.0317, 41.2514}, // FID
    Coordinate{-1.61722, 59.5353}, // FIE
    Coordinate{-13.5692, 10.3506}, // FIG
    Coordinate{15.4446, -4.38575}, // FIH
    Coordinate{-112.363, 38.9581}, // FIL
    Coordinate{147.854, -6.62229}, // FIN
    Coordinate{-71.7589, 42.5542}, // FIT
    Coordinate{125.559, -18.182}, // FIZ
    Coordinate{56.3239, 25.1097}, // FJR
    Coordinate{-92.1794, 43.6761}, // FKA
    Coordinate{8.08056, 48.7794}, // FKB
    Coordinate{25.3381, 0.481667}, // FKI
    Coordinate{136.224, 36.1428}, // FKJ
    Coordinate{-79.8603, 41.3778}, // FKL
    Coordinate{-76.9039, 36.6981}, // FKN
    Coordinate{132.267, -2.92}, // FKQ
    Coordinate{140.428, 37.2275}, // FKS
    Coordinate{-75.5644, 1.58917}, // FLA
    Coordinate{-43.0781, -6.84611}, // FLB
    Coordinate{-88.4883, 43.7711}, // FLD
    Coordinate{9.37667, 54.7733}, // FLF
    Coordinate{-111.669, 35.1403}, // FLG
    Coordinate{-80.1528, 26.0725}, // FLL
    Coordinate{-60.054, -22.36}, // FLM
    Coordinate{-48.5525, -27.6703}, // FLN
    Coordinate{-79.7239, 34.1853}, // FLO
    Coordinate{-92.5903, 36.2908}, // FLP
    Coordinate{11.2029, 43.8088}, // FLR
    Coordinate{147.993, -40.0914}, // FLS
    Coordinate{-71.9003, 19.6775}, // FLT
    Coordinate{-73.8333, 40.7792}, // FLU
    Coordinate{-31.1322, 39.4581}, // FLW
    Coordinate{-118.749, 39.4992}, // FLX
    Coordinate{-104.57, 38.9458}, // FLY
    Coordinate{-58.2281, -26.2128}, // FMA
    Coordinate{-149.84, 65.9269}, // FMC
    Coordinate{-76.7594, 39.0853}, // FME
    Coordinate{29.25, -5.87556}, // FMI
    Coordinate{10.2394, 47.9889}, // FMM
    Coordinate{-108.23, 36.7411}, // FMN
    Coordinate{7.68483, 52.1346}, // FMO
    Coordinate{-124.111, 43.9828}, // FMU
    Coordinate{-81.8633, 26.5867}, // FMY
    Coordinate{-97.5731, 40.5861}, // FMZ
    Coordinate{-13.1955, 8.61644}, // FNA
    Coordinate{13.306, 53.6022}, // FNB
    Coordinate{-16.7781, 32.6942}, // FNC
    Coordinate{147.085, -8.6}, // FNE
    Coordinate{0.35, 12.033}, // FNG
    Coordinate{37.3764, 9.58333}, // FNH
    Coordinate{4.41639, 43.7575}, // FNI
    Coordinate{125.67, 39.2239}, // FNJ
    Coordinate{-105.011, 40.4519}, // FNL
    Coordinate{-134.898, 58.2544}, // FNR
    Coordinate{-83.7436, 42.9656}, // FNT
    Coordinate{8.64083, 39.8936}, // FNU
    Coordinate{-2.05333, 60.1217}, // FOA
    Coordinate{119.663, 25.935}, // FOC
    Coordinate{-94.1919, 42.5511}, // FOD
    Coordinate{-95.6636, 38.9508}, // FOE
    Coordinate{15.5351, 41.4329}, // FOG
    Coordinate{-72.6317, 40.8436}, // FOK
    Coordinate{10.7508, 5.63694}, // FOM
    Coordinate{-84.5778, 10.47}, // FON
    Coordinate{134.872, -0.936389}, // FOO
    Coordinate{-38.5322, -3.77583}, // FOR
    Coordinate{128.115, -30.8383}, // FOS
    Coordinate{}, // FOT
    Coordinate{10.617, -1.283}, // FOU
    Coordinate{-10.2264, 8.35222}, // FOY
    Coordinate{-84.8114, 42.5744}, // FPK
    Coordinate{-78.6956, 26.5586}, // FPO
    Coordinate{-80.3683, 27.495}, // FPR
    Coordinate{-83.5783, 30.0722}, // FPY
    Coordinate{8.57056, 50.0333}, // FRA
    Coordinate{147.935, -33.3636}, // FRB
    Coordinate{-47.3825, -20.5903}, // FRC
    Coordinate{-123.024, 48.5219}, // FRD
    Coordinate{159.577, -8.10746}, // FRE
    Coordinate{-73.4133, 40.7289}, // FRG
    Coordinate{-86.6369, 38.5061}, // FRH
    Coordinate{6.73556, 43.4172}, // FRJ
    Coordinate{55.9408, -4.58389}, // FRK
    Coordinate{12.0696, 44.1954}, // FRL
    Coordinate{-94.4156, 43.6439}, // FRM
    Coordinate{5.02472, 61.5836}, // FRO
    Coordinate{-78.2533, 38.9175}, // FRR
    Coordinate{-89.8663, 16.909}, // FRS
    Coordinate{-73.0646, -41.1308}, // FRT
    Coordinate{74.4775, 43.0613}, // FRU
    Coordinate{27.4744, -21.1594}, // FRW
    Coordinate{-70.9478, 43.9911}, // FRY
    Coordinate{9.09667, 41.5022}, // FSC
    Coordinate{-96.7419, 43.5819}, // FSD
    Coordinate{-94.7694, 37.7983}, // FSK
    Coordinate{-94.3675, 35.3367}, // FSM
    Coordinate{-73.0975, 44.9403}, // FSO
    Coordinate{-56.1742, 46.7631}, // FSP
    Coordinate{-102.913, 30.9153}, // FST
    Coordinate{-104.216, 34.4878}, // FSU
    Coordinate{138.189, 34.7961}, // FSZ
    Coordinate{170.232, -19.5164}, // FTA
    Coordinate{-72.0532, -50.2803}, // FTE
    Coordinate{-104.543, 39.7853}, // FTG
    Coordinate{-169.424, -14.2161}, // FTI
    Coordinate{46.9558, -25.0381}, // FTU
    Coordinate{-97.3624, 32.8198}, // FTW
    Coordinate{15.95, -0.531389}, // FTX
    Coordinate{-84.5214, 33.7792}, // FTY
    Coordinate{-13.8639, 28.4528}, // FUE
    Coordinate{115.734, 32.8819}, // FUG
    Coordinate{128.833, 32.6664}, // FUJ
    Coordinate{130.452, 33.5844}, // FUK
    Coordinate{-117.98, 33.872}, // FUL
    Coordinate{179.196, -8.525}, // FUN
    Coordinate{113.071, 23.0825}, // FUO
    Coordinate{-178.066, -14.3114}, // FUT
    Coordinate{73.4325, -0.309444}, // FVM
    Coordinate{-85.1953, 40.9783}, // FWA
    Coordinate{-93.4022, 36.6986}, // FWB
    Coordinate{-88.4128, 38.3786}, // FWC
    Coordinate{-74.6231, 41.2003}, // FWN
    Coordinate{-79.8314, 40.2097}, // FWQ
    Coordinate{-97.3081, 32.5653}, // FWS
    Coordinate{-80.1708, 26.1972}, // FXE
    Coordinate{36.5283, -14.8175}, // FXO
    Coordinate{-93.6242, 43.2347}, // FXY
    Coordinate{-89.3944, 35.2078}, // FYE
    Coordinate{134.366, 48.1995}, // FYJ
    Coordinate{-86.5639, 35.0597}, // FYM
    Coordinate{89.5079, 46.8011}, // FYN
    Coordinate{19.1108, 17.9143}, // FYT
    Coordinate{-145.246, 66.5725}, // FYU
    Coordinate{-94.17, 36.005}, // FYV
    Coordinate{-83.3944, 41.1908}, // FZI
    Coordinate{-2.59361, 51.5194}, // FZO
    Coordinate{21.3333, -5.35}, // FZU
    Coordinate{-76.3881, 43.3508}, // FZY
    Coordinate{-74.0608, 4.81139}, // GAA
    Coordinate{-117.959, 38.9242}, // GAB
    Coordinate{-88.5958, 14.5736}, // GAC
    Coordinate{-86.0892, 33.9728}, // GAD
    Coordinate{9.92005, 33.7343}, // GAE
    Coordinate{8.81361, 34.4156}, // GAF
    Coordinate{-99.7764, 36.2956}, // GAG
    Coordinate{151.62, -25.6153}, // GAH
    Coordinate{-77.166, 39.1683}, // GAI
    Coordinate{140.371, 38.4119}, // GAJ
    Coordinate{-156.938, 64.7361}, // GAL
    Coordinate{-171.733, 63.7667}, // GAM
    Coordinate{73.1556, -0.693333}, // GAN
    Coordinate{-75.1583, 20.0853}, // GAO
    Coordinate{145.96, -6.05359}, // GAP
    Coordinate{-0.00583333, 16.2483}, // GAQ
    Coordinate{39.6483, -0.463428}, // GAS
    Coordinate{6.03667, 44.4539}, // GAT
    Coordinate{91.5855, 26.1049}, // GAU
    Coordinate{138.719, -34.6}, // GAW
    Coordinate{9.99583, -2.76583}, // GAX
    Coordinate{84.9511, 24.7444}, // GAY
    Coordinate{152.95, -9.23333}, // GAZ
    Coordinate{-2.05694, 51.6681}, // GBA
    Coordinate{47.7125, 40.8267}, // GBB
    Coordinate{-98.8592, 38.3442}, // GBD
    Coordinate{25.9183, -24.5553}, // GBE
    Coordinate{-90.4311, 40.9381}, // GBG
    Coordinate{-149.49, 68.4797}, // GBH
    Coordinate{-78.3667, 26.6318}, // GBI
    Coordinate{-61.2722, 15.8686}, // GBJ
    Coordinate{-12.3833, 7.76667}, // GBK
    Coordinate{133.382, -11.65}, // GBL
    Coordinate{42.2131, 3.32278}, // GBM
    Coordinate{-73.4032, 42.1842}, // GBR
    Coordinate{54.4053, 36.9067}, // GBT
    Coordinate{35.878, 14.925}, // GBU
    Coordinate{126.445, -16.4233}, // GBV
    Coordinate{175.472, -36.2414}, // GBZ
    Coordinate{-105.539, 44.3489}, // GCC
    Coordinate{50.8281, 30.3375}, // GCH
    Coordinate{-2.60194, 49.435}, // GCI
    Coordinate{28.14, -25.9871}, // GCJ
    Coordinate{-100.724, 37.9275}, // GCK
    Coordinate{-81.3592, 19.2925}, // GCM
    Coordinate{-112.147, 35.9522}, // GCN
    Coordinate{-113.231, 36.258}, // GCT
    Coordinate{-113.816, 35.9903}, // GCW
    Coordinate{-82.815, 36.1931}, // GCY
    Coordinate{21.1972, 9.27222}, // GDA
    Coordinate{-95.5561, 44.7533}, // GDB
    Coordinate{-82.3764, 34.7566}, // GDC
    Coordinate{43.5786, 5.93513}, // GDE
    Coordinate{125.8, 53.4667}, // GDG
    Coordinate{21.7333, 9.58333}, // GDI
    Coordinate{23.95, -6.73333}, // GDJ
    Coordinate{-103.311, 20.5218}, // GDL
    Coordinate{-72.0161, 42.55}, // GDM
    Coordinate{18.4661, 54.3775}, // GDN
    Coordinate{-70.7564, 7.21111}, // GDO
    Coordinate{-43.5822, -6.78222}, // GDP
    Coordinate{37.4318, 12.5197}, // GDQ
    Coordinate{-71.1422, 21.4444}, // GDT
    Coordinate{-104.807, 47.1386}, // GDV
    Coordinate{-84.475, 43.9706}, // GDW
    Coordinate{150.721, 59.9111}, // GDX
    Coordinate{-82.125, 37.2325}, // GDY
    Coordinate{38.0094, 44.5725}, // GDZ
    Coordinate{166.473, -22.2583}, // GEA
    Coordinate{-75.3589, 38.6892}, // GED
    Coordinate{146.84, -41.08}, // GEE
    Coordinate{-54.1689, -28.2822}, // GEL
    Coordinate{-58.2539, 6.49833}, // GEO
    Coordinate{-82.7839, 21.8347}, // GER
    Coordinate{125.096, 6.058}, // GES
    Coordinate{114.707, -28.7961}, // GET
    Coordinate{-112.295, 33.5269}, // GEU
    Coordinate{20.8122, 67.1331}, // GEV
    Coordinate{144.333, -38.2253}, // GEX
    Coordinate{-85.8047, 39.5831}, // GEZ
    Coordinate{-85.7361, 39.7903}, // GFD
    Coordinate{146.067, -34.2517}, // GFF
    Coordinate{-97.1761, 47.9492}, // GFK
    Coordinate{-73.6103, 43.3411}, // GFL
    Coordinate{153.03, -29.76}, // GFN
    Coordinate{-58.6541, 6.36018}, // GFO
    Coordinate{-1.56422, 48.8815}, // GFR
    Coordinate{18.1228, -19.6022}, // GFY
    Coordinate{21.4503, -14.1051}, // GGC
    Coordinate{-79.3203, 33.3114}, // GGE
    Coordinate{-101.734, 40.8706}, // GGF
    Coordinate{-94.7114, 32.3839}, // GGG
    Coordinate{34.5514, 0.263945}, // GGM
    Coordinate{-5.98694, 6.10333}, // GGN
    Coordinate{-7.47861, 6.52499}, // GGO
    Coordinate{48.4833, 8.4}, // GGR
    Coordinate{-70.1492, -48.7828}, // GGS
    Coordinate{-75.878, 23.5626}, // GGT
    Coordinate{-106.615, 48.2125}, // GGW
    Coordinate{3.79467, 32.3843}, // GHA
    Coordinate{-76.3311, 25.2847}, // GHB
    Coordinate{-77.85, 25.7383}, // GHC
    Coordinate{-78.3669, 8.065}, // GHE
    Coordinate{-70.6722, 42.0983}, // GHG
    Coordinate{-109.2, 63.4331}, // GHK
    Coordinate{-87.4453, 35.8375}, // GHM
    Coordinate{104.33, 30.9478}, // GHN
    Coordinate{10.1425, 25.1456}, // GHT
    Coordinate{-58.6131, -33.0103}, // GHU
    Coordinate{-5.34972, 36.1511}, // GIB
    Coordinate{142.217, -9.23333}, // GIC
    Coordinate{29.8941, -3.43333}, // GID
    Coordinate{-81.7533, 28.0628}, // GIF
    Coordinate{-43.2506, -22.81}, // GIG
    Coordinate{-9.167, 11.433}, // GII
    Coordinate{74.3336, 35.9186}, // GIL
    Coordinate{-74.7967, 4.27611}, // GIR
    Coordinate{177.978, -38.6633}, // GIS
    Coordinate{80.7281, 7.95589}, // GIU
    Coordinate{42.5858, 16.9011}, // GIZ
    Coordinate{-85.9067, 16.4453}, // GJA
    Coordinate{5.87361, 36.7951}, // GJL
    Coordinate{-65.2817, -10.7883}, // GJM
    Coordinate{-21.3296, 65.9933}, // GJR
    Coordinate{-108.527, 39.1225}, // GJT
    Coordinate{145.392, -6.08169}, // GKA
    Coordinate{25.8822, 40.2011}, // GKD
    Coordinate{73.4331, 0.730833}, // GKK
    Coordinate{-145.454, 62.155}, // GKN
    Coordinate{-83.5286, 35.8578}, // GKT
    Coordinate{-97.0942, 32.6639}, // GKY
    Coordinate{-4.43306, 55.8719}, // GLA
    Coordinate{-110.667, 33.3531}, // GLB
    Coordinate{-101.699, 39.3706}, // GLD
    Coordinate{-97.1969, 33.6514}, // GLE
    Coordinate{-83.1833, 8.65}, // GLF
    Coordinate{-90.9856, 33.4828}, // GLH
    Coordinate{151.69, -29.675}, // GLI
    Coordinate{47.4044, 6.69019}, // GLK
    Coordinate{9.05056, 60.7908}, // GLL
    Coordinate{-10.0678, 29.0167}, // GLN
    Coordinate{-2.16722, 51.8942}, // GLO
    Coordinate{-84.7033, 45.0131}, // GLR
    Coordinate{-94.8606, 29.2653}, // GLS
    Coordinate{151.223, -23.8697}, // GLT
    Coordinate{90.4653, 26.8686}, // GLU
    Coordinate{-163.007, 64.5506}, // GLV
    Coordinate{-85.9539, 37.0317}, // GLW
    Coordinate{127.786, 1.83722}, // GLX
    Coordinate{19.7667, 3.23528}, // GMA
    Coordinate{34.5631, 8.12861}, // GMB
    Coordinate{-7.22139, 33.6556}, // GMD
    Coordinate{31.0167, 52.5269}, // GME
    Coordinate{150.333, -6.275}, // GMI
    Coordinate{-94.7386, 36.6067}, // GMJ
    Coordinate{30.1919, 50.6036}, // GML
    Coordinate{15.8667, -1.86667}, // GMM
    Coordinate{171.19, -42.4617}, // GMN
    Coordinate{10.9, 10.2989}, // GMO
    Coordinate{126.798, 37.5569}, // GMP
    Coordinate{100.302, 34.4213}, // GMQ
    Coordinate{-134.883, -23.0833}, // GMR
    Coordinate{-82.35, 34.8481}, // GMU
    Coordinate{-17.2146, 28.0296}, // GMZ
    Coordinate{24.0539, 53.6019}, // GNA
    Coordinate{5.33278, 45.3631}, // GNB
    Coordinate{-61.7861, 12.0042}, // GND
    Coordinate{-120.945, 39.9439}, // GNF
    Coordinate{121.466, 22.6736}, // GNI
    Coordinate{5.52565, 51.015}, // GNK
    Coordinate{-42.7511, -14.2081}, // GNM
    Coordinate{40.7167, 7.15}, // GNN
    Coordinate{-67.6206, -39.0008}, // GNR
    Coordinate{97.7044, 1.16611}, // GNS
    Coordinate{-107.902, 35.1672}, // GNT
    Coordinate{-161.577, 59.1175}, // GNU
    Coordinate{-82.2717, 29.69}, // GNV
    Coordinate{38.9, 37.45}, // GNY
    Coordinate{21.6578, -21.7}, // GNZ
    Coordinate{8.83756, 44.4135}, // GOA
    Coordinate{40.045, 7.11889}, // GOB
    Coordinate{18.9747, -22.5072}, // GOG
    Coordinate{-51.6778, 64.1917}, // GOH
    Coordinate{73.8314, 15.3808}, // GOI
    Coordinate{43.7867, 56.23}, // GOJ
    Coordinate{-97.4161, 35.8514}, // GOK
    Coordinate{-124.425, 42.4153}, // GOL
    Coordinate{29.2383, -1.67056}, // GOM
    Coordinate{150.32, -28.5217}, // GOO
    Coordinate{83.45, 26.74}, // GOP
    Coordinate{94.7861, 36.4006}, // GOQ
    Coordinate{35.5525, 8.16167}, // GOR
    Coordinate{12.2911, 57.66}, // GOT
    Coordinate{13.37, 9.33583}, // GOU
    Coordinate{136.818, -12.27}, // GOV
    Coordinate{25.7125, 43.1514}, // GOZ
    Coordinate{21.4167, 38.15}, // GPA
    Coordinate{-51.5244, -25.3881}, // GPB
    Coordinate{139.407, -19.775}, // GPD
    Coordinate{-94.3097, 39.3325}, // GPH
    Coordinate{-77.8983, 2.57}, // GPI
    Coordinate{-83.8, 10.2167}, // GPL
    Coordinate{-97.0469, 32.6989}, // GPM
    Coordinate{130.425, -11.3992}, // GPN
    Coordinate{-63.7581, -35.6961}, // GPO
    Coordinate{-90.2658, -0.453889}, // GPS
    Coordinate{-89.07, 30.4072}, // GPT
    Coordinate{-93.5097, 47.2111}, // GPZ
    Coordinate{-82.7239, 40.7533}, // GQQ
    Coordinate{-88.1297, 44.4847}, // GRB
    Coordinate{-82.1592, 34.2486}, // GRD
    Coordinate{-89.3783, 38.8361}, // GRE
    Coordinate{69.2385, 33.6299}, // GRG
    Coordinate{-98.3097, 40.9675}, // GRI
    Coordinate{22.375, -34.0067}, // GRJ
    Coordinate{-97.8289, 31.0672}, // GRK
    Coordinate{-90.3831, 47.8383}, // GRM
    Coordinate{2.76056, 41.9008}, // GRO
    Coordinate{-49.1322, -11.7436}, // GRP
    Coordinate{6.57806, 53.1206}, // GRQ
    Coordinate{-85.5228, 42.8808}, // GRR
    Coordinate{11.0717, 42.7597}, // GRS
    Coordinate{-46.4731, -23.4356}, // GRU
    Coordinate{45.6997, 43.3883}, // GRV
    Coordinate{-28.0286, 39.0925}, // GRW
    Coordinate{-3.77722, 37.1886}, // GRX
    Coordinate{-18.0186, 66.5467}, // GRY
    Coordinate{15.4392, 46.9931}, // GRZ
    Coordinate{115.719, 4.40944}, // GSA
    Coordinate{11.8706, 57.7756}, // GSE
    Coordinate{-85.7942, 41.5264}, // GSH
    Coordinate{-54.3811, 4.28333}, // GSI
    Coordinate{-90.8358, 13.9361}, // GSJ
    Coordinate{-111.541, 62.5972}, // GSL
    Coordinate{55.8978, 26.7511}, // GSM
    Coordinate{-79.9372, 36.0978}, // GSO
    Coordinate{-82.2189, 34.8956}, // GSP
    Coordinate{28.7164, 22.5806}, // GSQ
    Coordinate{49.0833, 9.51667}, // GSR
    Coordinate{-135.708, 58.4253}, // GST
    Coordinate{35.3169, 14.1365}, // GSU
    Coordinate{-97.0492, 32.8314}, // GSW
    Coordinate{158.203, -8.73917}, // GTA
    Coordinate{111.7, 2.11667}, // GTB
    Coordinate{136.46, -13.975}, // GTE
    Coordinate{-111.371, 47.4828}, // GTF
    Coordinate{-92.6644, 45.7981}, // GTG
    Coordinate{170.133, -43.7668}, // GTN
    Coordinate{122.85, 0.637222}, // GTO
    Coordinate{-123.388, 42.5101}, // GTP
    Coordinate{-88.5914, 33.4483}, // GTR
    Coordinate{130.35, -20.5483}, // GTS
    Coordinate{143.53, -18.305}, // GTT
    Coordinate{-97.6794, 30.6788}, // GTU
    Coordinate{17.5703, 49.3203}, // GTW
    Coordinate{-77.2742, 39.8408}, // GTY
    Coordinate{-90.5275, 14.5833}, // GUA
    Coordinate{-114.024, 28.0258}, // GUB
    Coordinate{-106.933, 38.5339}, // GUC
    Coordinate{-3.6, 16.35}, // GUD
    Coordinate{-87.6717, 30.2897}, // GUF
    Coordinate{150.25, -30.9617}, // GUH
    Coordinate{-62.3125, 10.5739}, // GUI
    Coordinate{-45.2044, -22.7917}, // GUJ
    Coordinate{149.718, -34.81}, // GUL
    Coordinate{144.797, 13.4839}, // GUM
    Coordinate{-86.0619, 15.0253}, // GUO
    Coordinate{-108.789, 35.5111}, // GUP
    Coordinate{-69.7544, 9.02778}, // GUQ
    Coordinate{150.334, -10.3114}, // GUR
    Coordinate{-86.1522, 40.6481}, // GUS
    Coordinate{-23.2222, 64.9917}, // GUU
    Coordinate{51.8294, 47.1222}, // GUW
    Coordinate{-101.508, 36.685}, // GUY
    Coordinate{-40.4922, -20.6506}, // GUZ
    Coordinate{6.10944, 46.2383}, // GVA
    Coordinate{-83.8303, 34.2725}, // GVL
    Coordinate{-78.1697, 43.0317}, // GVQ
    Coordinate{-41.9861, -18.8969}, // GVR
    Coordinate{-96.0653, 33.0678}, // GVT
    Coordinate{}, // GVW
    Coordinate{16.9511, 60.5944}, // GVX
    Coordinate{62.3294, 25.2284}, // GWD
    Coordinate{78.2278, 26.2933}, // GWL
    Coordinate{-90.0692, 33.6464}, // GWO
    Coordinate{8.34056, 54.9133}, // GWT
    Coordinate{-77.965, 35.4606}, // GWW
    Coordinate{-8.94159, 53.3002}, // GWY
    Coordinate{48.7881, 15.9661}, // GXF
    Coordinate{15.2876, -7.75431}, // GXG
    Coordinate{102.645, 34.8106}, // GXH
    Coordinate{-72.1065, -45.5947}, // GXQ
    Coordinate{15.2437, 10.3531}, // GXX
    Coordinate{-104.633, 40.4375}, // GXY
    Coordinate{-65.3458, -10.8217}, // GYA
    Coordinate{-96.98, 30.1692}, // GYB
    Coordinate{50.0467, 40.4675}, // GYD
    Coordinate{-79.8836, -2.1575}, // GYE
    Coordinate{129.563, 62.1083}, // GYG
    Coordinate{29.2583, -1.68}, // GYI
    Coordinate{128.451, -16.6369}, // GYL
    Coordinate{-110.924, 27.9692}, // GYM
    Coordinate{-49.2267, -16.6297}, // GYN
    Coordinate{152.702, -26.2833}, // GYP
    Coordinate{-112.374, 33.4281}, // GYR
    Coordinate{105.693, 32.39}, // GYS
    Coordinate{106.218, 36.0761}, // GYU
    Coordinate{-87.4128, 41.6164}, // GYY
    Coordinate{34.2761, 31.2464}, // GZA
    Coordinate{-87.0442, 31.4158}, // GZH
    Coordinate{68.4123, 33.5308}, // GZI
    Coordinate{-95.0939, 35.2881}, // GZL
    Coordinate{156.864, -8.09861}, // GZO
    Coordinate{32.1814, 36.1756}, // GZP
    Coordinate{-87.0569, 35.1536}, // GZS
    Coordinate{37.4789, 36.9478}, // GZT
    Coordinate{50.0333, 36.2333}, // GZW
    Coordinate{22.1397, 70.4867}, // HAA
    Coordinate{-87.9983, 34.1175}, // HAB
    Coordinate{139.786, 33.115}, // HAC
    Coordinate{12.82, 56.6908}, // HAD
    Coordinate{125.779, 38.0054}, // HAE
    Coordinate{-122.501, 37.5133}, // HAF
    Coordinate{43.2714, -11.5367}, // HAH
    Coordinate{9.685, 52.4608}, // HAJ
    Coordinate{110.459, 19.9347}, // HAK
    Coordinate{16.4583, -19.0314}, // HAL
    Coordinate{9.99111, 53.6303}, // HAM
    Coordinate{105.807, 21.2211}, // HAN
    Coordinate{-84.5219, 39.3638}, // HAO
    Coordinate{73.1685, 6.74417}, // HAQ
    Coordinate{-76.8514, 40.2172}, // HAR
    Coordinate{41.6863, 27.4397}, // HAS
    Coordinate{5.2125, 59.3433}, // HAU
    Coordinate{-82.4089, 22.9889}, // HAV
    Coordinate{-4.96111, 51.8331}, // HAW
    Coordinate{-95.4128, 35.7458}, // HAX
    Coordinate{-161.157, 65.2011}, // HAY
    Coordinate{147.51, -42.8361}, // HBA
    Coordinate{29.6964, 30.9178}, // HBE
    Coordinate{-89.2528, 31.265}, // HBG
    Coordinate{-79.8947, 35.6544}, // HBI
    Coordinate{-110.138, 34.9408}, // HBK
    Coordinate{-99.0514, 34.9914}, // HBR
    Coordinate{91.5819, 46.1017}, // HBU
    Coordinate{75.0847, 15.3617}, // HBX
    Coordinate{-101.522, 32.2125}, // HCA
    Coordinate{-73.7103, 42.2914}, // HCC
    Coordinate{-94.3825, 44.86}, // HCD
    Coordinate{107.7, 24.7839}, // HCJ
    Coordinate{49.8, 7.91667}, // HCM
    Coordinate{120.73, 22.0381}, // HCN
    Coordinate{127.67, -18.2339}, // HCQ
    Coordinate{-159.775, 62.1883}, // HCR
    Coordinate{-79.9569, 34.7128}, // HCW
    Coordinate{35.0006, 32.4369}, // HDA
    Coordinate{-90.4183, 30.5217}, // HDC
    Coordinate{68.3663, 25.3179}, // HDD
    Coordinate{14.1522, 53.8786}, // HDF
    Coordinate{114.43, 36.5239}, // HDG
    Coordinate{-84.8325, 35.22}, // HDI
    Coordinate{48.5525, 34.8692}, // HDM
    Coordinate{-107.218, 40.4811}, // HDN
    Coordinate{-99.1775, 29.3592}, // HDO
    Coordinate{100.393, 6.93306}, // HDY
    Coordinate{62.2279, 34.2101}, // HEA
    Coordinate{-90.6758, 34.5764}, // HEE
    Coordinate{-81.8058, 30.2778}, // HEG
    Coordinate{96.7919, 20.7469}, // HEH
    Coordinate{-102.656, 46.015}, // HEI
    Coordinate{127.309, 50.1722}, // HEK
    Coordinate{24.9633, 60.3172}, // HEL
    Coordinate{24.9242, 60.1478}, // HEN
    Coordinate{147.6, -9.1375}, // HEO
    Coordinate{25.1803, 35.3397}, // HER
    Coordinate{-119.259, 45.8283}, // HES
    Coordinate{111.822, 40.8514}, // HET
    Coordinate{23.7295, 37.8984}, // HEW
    Coordinate{-69.9703, 18.4686}, // HEX
    Coordinate{-91.2972, 31.6136}, // HEZ
    Coordinate{35.0431, 32.8094}, // HFA
    Coordinate{-72.6494, 41.7367}, // HFD
    Coordinate{116.989, 31.9911}, // HFE
    Coordinate{-79.4975, 35.0364}, // HFF
    Coordinate{-15.2272, 64.2956}, // HFN
    Coordinate{13.5806, 60.025}, // HFS
    Coordinate{23.6686, 70.6797}, // HFT
    Coordinate{44.0888, 9.51817}, // HGA
    Coordinate{144.225, -20.815}, // HGD
    Coordinate{-66.0998, 10.4667}, // HGE
    Coordinate{120.434, 30.2294}, // HGH
    Coordinate{32.5006, 10.5292}, // HGI
    Coordinate{7.91444, 54.1858}, // HGL
    Coordinate{97.9747, 19.3011}, // HGN
    Coordinate{-5.55666, 9.38718}, // HGO
    Coordinate{-77.7264, 39.7086}, // HGR
    Coordinate{-13.1291, 8.3943}, // HGS
    Coordinate{144.296, -5.82679}, // HGU
    Coordinate{-80.6975, 32.2244}, // HHH
    Coordinate{7.26417, 49.9483}, // HHN
    Coordinate{99.9514, 12.6303}, // HHQ
    Coordinate{-118.335, 33.9228}, // HHR
    Coordinate{-142.613, -17.5478}, // HHZ
    Coordinate{119.148, 33.7772}, // HIA
    Coordinate{-92.8389, 47.3867}, // HIB
    Coordinate{142.29, -10.5864}, // HID
    Coordinate{-71.5445, 44.3676}, // HIE
    Coordinate{-114.358, 34.5711}, // HII
    Coordinate{132.919, 34.4361}, // HIJ
    Coordinate{44.7639, 6.07778}, // HIL
    Coordinate{80.9817, 8.053}, // HIM
    Coordinate{128.07, 35.0885}, // HIN
    Coordinate{-122.95, 45.5404}, // HIO
    Coordinate{160.055, -9.428}, // HIR
    Coordinate{132.414, 34.3669}, // HIW
    Coordinate{109.7, 27.4414}, // HJJ
    Coordinate{-119.628, 36.3167}, // HJO
    Coordinate{79.9184, 24.8172}, // HJR
    Coordinate{102.778, 46.9253}, // HJT
    Coordinate{-89.8308, 35.9406}, // HKA
    Coordinate{-144.693, 63.9958}, // HKB
    Coordinate{140.822, 41.77}, // HKD
    Coordinate{113.914, 22.3089}, // HKG
    Coordinate{170.985, -42.7136}, // HKK
    Coordinate{150.405, -5.46217}, // HKN
    Coordinate{}, // HKO
    Coordinate{-156.69, 20.9433}, // HKP
    Coordinate{-90.2225, 32.3347}, // HKS
    Coordinate{98.3169, 8.11333}, // HKT
    Coordinate{-81.3894, 35.7411}, // HKY
    Coordinate{27.9261, -25.9386}, // HLA
    Coordinate{-99.8314, 39.3803}, // HLC
    Coordinate{119.825, 49.205}, // HLD
    Coordinate{-5.64592, -15.9591}, // HLE
    Coordinate{15.8337, 57.5214}, // HLF
    Coordinate{-80.6464, 40.175}, // HLG
    Coordinate{122.008, 46.1953}, // HLH
    Coordinate{-121.41, 36.8933}, // HLI
    Coordinate{23.5581, 56.0673}, // HLJ
    Coordinate{-86.1619, 42.7958}, // HLM
    Coordinate{-111.983, 46.6067}, // HLN
    Coordinate{106.891, -6.26639}, // HLP
    Coordinate{148.282, -41.3367}, // HLS
    Coordinate{142.065, -37.6489}, // HLT
    Coordinate{32.275, -28.0083}, // HLW
    Coordinate{175.332, -37.8667}, // HLZ
    Coordinate{69.0867, 61.0283}, // HMA
    Coordinate{31.7393, 26.3399}, // HMB
    Coordinate{6.14056, 31.6739}, // HME
    Coordinate{93.6694, 42.8425}, // HMI
    Coordinate{26.9333, 49.36}, // HMJ
    Coordinate{-111.048, 29.0958}, // HMO
    Coordinate{11.0681, 60.8181}, // HMR
    Coordinate{-117.022, 33.7339}, // HMT
    Coordinate{141.135, 39.4286}, // HNA
    Coordinate{-86.9536, 38.2489}, // HNB
    Coordinate{-75.6178, 35.2328}, // HNC
    Coordinate{139.781, 35.5533}, // HND
    Coordinate{-135.41, 58.0961}, // HNH
    Coordinate{-157.923, 21.3186}, // HNL
    Coordinate{-156.014, 20.7956}, // HNM
    Coordinate{-135.524, 59.2439}, // HNS
    Coordinate{112.618, 26.7239}, // HNY
    Coordinate{-78.5292, 36.3617}, // HNZ
    Coordinate{40.0039, -1.52}, // HOA
    Coordinate{-103.217, 32.6875}, // HOB
    Coordinate{42.9763, 14.753}, // HOD
    Coordinate{100.426, 20.2578}, // HOE
    Coordinate{49.4852, 25.2853}, // HOF
    Coordinate{-76.315, 20.7856}, // HOG
    Coordinate{9.7, 47.385}, // HOH
    Coordinate{-140.946, -18.0747}, // HOI
    Coordinate{130.643, -18.3367}, // HOK
    Coordinate{-151.477, 59.6456}, // HOM
    Coordinate{-98.2286, 44.3853}, // HON
    Coordinate{106.591, 17.0153}, // HOO
    Coordinate{-28.7164, 38.52}, // HOR
    Coordinate{-70.2225, -37.4447}, // HOS
    Coordinate{-93.0961, 34.4781}, // HOT
    Coordinate{-95.2789, 29.6456}, // HOU
    Coordinate{6.07583, 62.1786}, // HOV
    Coordinate{-174.341, -19.778}, // HPA
    Coordinate{-166.147, 61.5239}, // HPB
    Coordinate{110.338, 31.6336}, // HPG
    Coordinate{106.725, 20.8192}, // HPH
    Coordinate{-73.7075, 41.0669}, // HPN
    Coordinate{-159.446, 22.2092}, // HPV
    Coordinate{-52.1522, -14.0194}, // HPX
    Coordinate{-94.9528, 29.7861}, // HPY
    Coordinate{-101.371, 37.1631}, // HQG
    Coordinate{-123.937, 46.9711}, // HQM
    Coordinate{-96.5306, 32.7469}, // HQZ
    Coordinate{126.25, 45.6234}, // HRB
    Coordinate{31.0928, -17.9318}, // HRE
    Coordinate{33.7992, 27.1781}, // HRG
    Coordinate{81.1236, 6.28889}, // HRI
    Coordinate{83.8333, 28}, // HRJ
    Coordinate{36.29, 49.9247}, // HRK
    Coordinate{-97.655, 26.2272}, // HRL
    Coordinate{3.31039, 32.9315}, // HRM
    Coordinate{-93.1547, 36.2614}, // HRO
    Coordinate{29.1064, -28.235}, // HRS
    Coordinate{-96.8081, 38.6947}, // HRU
    Coordinate{34.834, 32.1803}, // HRZ
    Coordinate{-89.4547, 30.3678}, // HSA
    Coordinate{113.421, 24.9786}, // HSC
    Coordinate{-97.7061, 35.6019}, // HSD
    Coordinate{130.302, 33.1497}, // HSG
    Coordinate{-115.134, 35.9728}, // HSH
    Coordinate{-98.4278, 40.6053}, // HSI
    Coordinate{-0.323333, 42.0808}, // HSK
    Coordinate{-156.351, 65.6978}, // HSL
    Coordinate{142.173, -36.6697}, // HSM
    Coordinate{122.362, 29.9342}, // HSN
    Coordinate{-103.388, 43.3683}, // HSR
    Coordinate{75.7533, 29.1792}, // HSS
    Coordinate{-86.775, 34.6372}, // HSV
    Coordinate{113.305, 52.0267}, // HTA
    Coordinate{102.487, 71.9683}, // HTG
    Coordinate{-118.634, 38.5444}, // HTH
    Coordinate{148.952, -20.3581}, // HTI
    Coordinate{-84.6711, 44.3597}, // HTL
    Coordinate{100.137, 50.4394}, // HTM
    Coordinate{79.865, 37.0333}, // HTN
    Coordinate{-72.2517, 40.9594}, // HTO
    Coordinate{123.804, 24.0583}, // HTR
    Coordinate{-82.5586, 38.3669}, // HTS
    Coordinate{90.8417, 38.2033}, // HTT
    Coordinate{142.36, -35.715}, // HTU
    Coordinate{-95.5872, 30.7469}, // HTV
    Coordinate{-82.4944, 38.4192}, // HTW
    Coordinate{36.2822, 36.3628}, // HTY
    Coordinate{-71.7625, 6.15278}, // HTZ
    Coordinate{130.63, -16.4897}, // HUB
    Coordinate{-65.8008, 18.1381}, // HUC
    Coordinate{-94.2453, 42.7361}, // HUD
    Coordinate{36.8817, 13.8303}, // HUE
    Coordinate{-87.3075, 39.4514}, // HUF
    Coordinate{-91.505, 15.3164}, // HUG
    Coordinate{-151.022, -16.6872}, // HUH
    Coordinate{107.703, 16.4017}, // HUI
    Coordinate{-95.5419, 34.0347}, // HUJ
    Coordinate{21.7581, -23.9897}, // HUK
    Coordinate{-67.7919, 46.1231}, // HUL
    Coordinate{-90.6606, 29.5664}, // HUM
    Coordinate{121.618, 24.0231}, // HUN
    Coordinate{119.407, 45.4872}, // HUO
    Coordinate{15.95, 29.1111}, // HUQ
    Coordinate{-154.265, 66.0392}, // HUS
    Coordinate{-97.8606, 38.0656}, // HUT
    Coordinate{-76.2048, -9.87881}, // HUU
    Coordinate{17.0806, 61.7683}, // HUV
    Coordinate{-63.0506, -7.53361}, // HUW
    Coordinate{-96.2625, 15.7742}, // HUX
    Coordinate{-0.350833, 53.5744}, // HUY
    Coordinate{114.6, 23.0483}, // HUZ
    Coordinate{47.7638, -14.6333}, // HVA
    Coordinate{152.88, -25.3189}, // HVB
    Coordinate{-87.455, 36.8569}, // HVC
    Coordinate{91.6258, 47.9614}, // HVD
    Coordinate{25.9836, 71.0097}, // HVG
    Coordinate{-21.6964, 65.7047}, // HVK
    Coordinate{-72.8867, 41.2639}, // HVN
    Coordinate{-109.762, 48.5431}, // HVR
    Coordinate{-80.1192, 34.4031}, // HVS
    Coordinate{141.751, -15.4856}, // HWM
    Coordinate{27.0045, -18.6351}, // HWN
    Coordinate{-80.2408, 26.0011}, // HWO
    Coordinate{-109.853, 46.4486}, // HWQ
    Coordinate{-77.7106, 38.5864}, // HWY
    Coordinate{97.2686, 37.125}, // HXD
    Coordinate{144.83, -34.5317}, // HXX
    Coordinate{-70.2803, 41.6694}, // HYA
    Coordinate{-0.808333, 51.6117}, // HYC
    Coordinate{78.4281, 17.24}, // HYD
    Coordinate{-132.828, 55.2064}, // HYG
    Coordinate{-97.8631, 29.8928}, // HYI
    Coordinate{-132.624, 55.4906}, // HYL
    Coordinate{121.429, 28.5622}, // HYN
    Coordinate{-91.4442, 46.0253}, // HYR
    Coordinate{-99.2731, 38.8422}, // HYS
    Coordinate{-79.1222, 33.8286}, // HYW
    Coordinate{-83.8623, 43.4334}, // HYX
    Coordinate{2.64, 50.6166}, // HZB
    Coordinate{-88.4633, 36.0892}, // HZD
    Coordinate{-101.581, 47.29}, // HZE
    Coordinate{107.202, 33.1367}, // HZG
    Coordinate{109.152, 26.3228}, // HZH
    Coordinate{-17.4258, 65.9522}, // HZK
    Coordinate{-75.995, 40.9867}, // HZL
    Coordinate{-111.701, 57.3817}, // HZP
    Coordinate{-91.4786, 30.7183}, // HZR
    Coordinate{86.6217, 67.4367}, // IAA
    Coordinate{-77.4558, 38.9444}, // IAD
    Coordinate{-78.9461, 43.1072}, // IAG
    Coordinate{-95.3414, 29.9844}, // IAH
    Coordinate{9.64278, 28.0514}, // IAM
    Coordinate{-160.437, 66.9758}, // IAN
    Coordinate{126.014, 9.85889}, // IAO
    Coordinate{54.3186, 27.2127}, // IAQ
    Coordinate{40.1567, 57.56}, // IAR
    Coordinate{27.62, 47.1789}, // IAS
    Coordinate{3.97833, 7.36222}, // IBA
    Coordinate{-75.1325, 4.42139}, // IBE
    Coordinate{35.4522, -21.7072}, // IBL
    Coordinate{-69.4889, -11.4117}, // IBP
    Coordinate{1.37312, 38.8729}, // IBZ
    Coordinate{-61.7389, 4.3375}, // ICA
    Coordinate{-63.9814, 10.7942}, // ICC
    Coordinate{-179.342, -17.7431}, // ICI
    Coordinate{-57.0394, 5.95556}, // ICK
    Coordinate{126.439, 37.4625}, // ICN
    Coordinate{-75.5333, 20.6833}, // ICR
    Coordinate{-97.4331, 37.6499}, // ICT
    Coordinate{-141.662, 59.9689}, // ICY
    Coordinate{-112.071, 43.5136}, // IDA
    Coordinate{19.6, -5}, // IDF
    Coordinate{-116.123, 45.9425}, // IDH
    Coordinate{-79.1056, 40.6322}, // IDI
    Coordinate{-90.6789, 33.4858}, // IDL
    Coordinate{-95.7783, 37.1583}, // IDP
    Coordinate{75.8008, 22.7217}, // IDR
    Coordinate{-2.39111, 46.7186}, // IDY
    Coordinate{15.7986, 52.1386}, // IEG
    Coordinate{127.787, 26.7225}, // IEJ
    Coordinate{-93.0992, 31.7358}, // IER
    Coordinate{13.356, 51.2935}, // IES
    Coordinate{30.4517, 50.4017}, // IEV
    Coordinate{-23.1353, 66.0581}, // IFJ
    Coordinate{146.012, -17.5586}, // IFL
    Coordinate{51.8611, 32.7508}, // IFN
    Coordinate{24.6861, 48.8842}, // IFO
    Coordinate{-114.559, 35.1575}, // IFP
    Coordinate{-73.6669, 20.975}, // IGA
    Coordinate{-69.575, -41.3208}, // IGB
    Coordinate{43.8664, 39.9831}, // IGD
    Coordinate{9.31389, -1.91944}, // IGE
    Coordinate{-155.902, 59.3242}, // IGG
    Coordinate{146.152, -18.6606}, // IGH
    Coordinate{-113.938, 35.2594}, // IGM
    Coordinate{124.214, 8.13052}, // IGN
    Coordinate{-76.6833, 7.67778}, // IGO
    Coordinate{-54.4733, -25.7372}, // IGR
    Coordinate{11.534, 48.7157}, // IGS
    Coordinate{45.013, 43.3193}, // IGT
    Coordinate{-54.485, -25.6003}, // IGU
    Coordinate{-79.0658, 35.935}, // IGX
    Coordinate{32.9292, -25.9978}, // IHC
    Coordinate{}, // IHO
    Coordinate{60.7204, 27.2289}, // IHR
    Coordinate{145.4, -7.90017}, // IHU
    Coordinate{-9.57, 53.0919}, // IIA
    Coordinate{-91.9478, 42.4569}, // IIB
    Coordinate{46.4044, 33.5866}, // IIL
    Coordinate{154.227, -4.5}, // IIS
    Coordinate{-72.1803, 41.7442}, // IJD
    Coordinate{53.4567, 56.8333}, // IJK
    Coordinate{-53.8456, -28.3706}, // IJU
    Coordinate{51.1522, 35.4161}, // IKA
    Coordinate{-81.0983, 36.2228}, // IKB
    Coordinate{-98.0308, 27.5508}, // IKG
    Coordinate{129.786, 33.7492}, // IKI
    Coordinate{-87.8464, 41.0714}, // IKK
    Coordinate{23.2833, -1.2}, // IKL
    Coordinate{128.903, 71.6975}, // IKS
    Coordinate{104.395, 52.2672}, // IKT
    Coordinate{76.7133, 42.5883}, // IKU
    Coordinate{-93.5664, 41.6911}, // IKV
    Coordinate{-84.2614, 43.6628}, // IKW
    Coordinate{-51.3167, -20.4167}, // ILB
    Coordinate{0.535833, 41.7278}, // ILD
    Coordinate{-97.6864, 31.0858}, // ILE
    Coordinate{-95.6181, 56.0517}, // ILF
    Coordinate{-75.6067, 39.6786}, // ILG
    Coordinate{-154.911, 59.7539}, // ILI
    Coordinate{}, // ILK
    Coordinate{-95.1306, 45.1178}, // ILL
    Coordinate{-77.9025, 34.2706}, // ILM
    Coordinate{-83.7922, 39.4281}, // ILN
    Coordinate{122.493, 10.7147}, // ILO
    Coordinate{167.451, -22.5889}, // ILP
    Coordinate{-71.3606, -17.695}, // ILQ
    Coordinate{4.49444, 8.44056}, // ILR
    Coordinate{-89.1256, 13.6917}, // ILS
    Coordinate{38.0675, -2.91914}, // ILU
    Coordinate{-6.24917, 55.6833}, // ILY
    Coordinate{18.6136, 49.2333}, // ILZ
    Coordinate{-60.2833, 5.71667}, // IMB
    Coordinate{171.483, 7.01667}, // IMI
    Coordinate{81.8189, 29.9711}, // IMK
    Coordinate{-81.4028, 26.4325}, // IMM
    Coordinate{25.1022, 5.00167}, // IMO
    Coordinate{-47.4583, -5.53056}, // IMP
    Coordinate{-88.1144, 45.8183}, // IMT
    Coordinate{60.1114, 66.0556}, // INA
    Coordinate{-88.4106, 16.5219}, // INB
    Coordinate{106.393, 38.3217}, // INC
    Coordinate{-86.2944, 39.7172}, // IND
    Coordinate{5.74889, 19.5689}, // INF
    Coordinate{-72.3, -50.3333}, // ING
    Coordinate{35.4085, -23.8764}, // INH
    Coordinate{21.8536, 43.3372}, // INI
    Coordinate{-97.0972, 32.0836}, // INJ
    Coordinate{-103.202, 31.7797}, // INK
    Coordinate{-93.4022, 48.5656}, // INL
    Coordinate{11.3439, 47.2603}, // INN
    Coordinate{18.2858, -1.94722}, // INO
    Coordinate{-9.51111, 53.0586}, // INQ
    Coordinate{-80.2219, 36.1336}, // INT
    Coordinate{166.919, -0.547458}, // INU
    Coordinate{-4.0475, 57.5425}, // INV
    Coordinate{-110.723, 35.0219}, // INW
    Coordinate{2.51142, 27.2505}, // INZ
    Coordinate{20.8219, 39.6964}, // IOA
    Coordinate{-4.62389, 54.0833}, // IOM
    Coordinate{18.045, 1.58333}, // ION
    Coordinate{-9.65389, 53.1062}, // IOR
    Coordinate{-39.0333, -14.815}, // IOS
    Coordinate{-91.5465, 41.6392}, // IOW
    Coordinate{169.283, -18.8564}, // IPA
    Coordinate{-109.422, -27.1647}, // IPC
    Coordinate{122.601, 7.78614}, // IPE
    Coordinate{-69.6947, -2.93361}, // IPG
    Coordinate{101.092, 4.56778}, // IPH
    Coordinate{-77.6717, 0.861667}, // IPI
    Coordinate{-81.1611, 35.4833}, // IPJ
    Coordinate{-115.579, 32.8342}, // IPL
    Coordinate{-42.4881, -19.4706}, // IPN
    Coordinate{-76.9217, 41.2417}, // IPT
    Coordinate{107.603, 35.7997}, // IQN
    Coordinate{-70.1813, -20.5352}, // IQQ
    Coordinate{-73.3086, -3.78472}, // IQT
    Coordinate{161.898, -10.4494}, // IRA
    Coordinate{-144.076, 65.8278}, // IRC
    Coordinate{89.0486, 24.1525}, // IRD
    Coordinate{143.305, -12.7869}, // IRG
    Coordinate{35.7519, -7.66944}, // IRI
    Coordinate{-66.8025, -29.3892}, // IRJ
    Coordinate{-92.545, 40.0933}, // IRK
    Coordinate{22.7167, 10.2333}, // IRO
    Coordinate{27.5881, 2.82667}, // IRP
    Coordinate{-65.0339, -0.41694}, // IRZ
    Coordinate{139.489, -20.6639}, // ISA
    Coordinate{73.0992, 33.6164}, // ISB
    Coordinate{-6.29167, 49.9133}, // ISC
    Coordinate{30.3819, 37.865}, // ISE
    Coordinate{124.245, 24.3964}, // ISG
    Coordinate{144.425, -24.2583}, // ISI
    Coordinate{-86.7403, 21.245}, // ISJ
    Coordinate{73.9131, 20.1192}, // ISK
    Coordinate{-81.4372, 28.2897}, // ISM
    Coordinate{-103.642, 48.1781}, // ISN
    Coordinate{-77.6117, 35.3233}, // ISO
    Coordinate{-73.1003, 40.7953}, // ISP
    Coordinate{-86.1717, 45.9744}, // ISQ
    Coordinate{-69.7125, 43.9614}, // ISS
    Coordinate{28.8142, 40.9761}, // IST
    Coordinate{45.3144, 35.5608}, // ISU
    Coordinate{-89.8389, 44.3603}, // ISW
    Coordinate{-84.3889, 39.2467}, // ISZ
    Coordinate{-58.4817, -3.12639}, // ITA
    Coordinate{-56.0008, -4.24222}, // ITB
    Coordinate{-76.4586, 42.4914}, // ITH
    Coordinate{135.438, 34.7855}, // ITM
    Coordinate{-155.048, 19.7253}, // ITO
    Coordinate{-41.8756, -21.2194}, // ITP
    Coordinate{-56.5367, -29.1809}, // ITQ
    Coordinate{-49.2142, -18.445}, // ITR
    Coordinate{147.956, 45.2564}, // ITU
    Coordinate{-169.926, -19.08}, // IUE
    Coordinate{155.15, -5.78306}, // IUS
    Coordinate{48.6327, -13.485}, // IVA
    Coordinate{168.313, -46.415}, // IVC
    Coordinate{19.862, 42.839}, // IVG
    Coordinate{27.4139, 68.6108}, // IVL
    Coordinate{151.143, -29.8883}, // IVR
    Coordinate{40.9333, 56.9417}, // IWA
    Coordinate{-90.1314, 46.5275}, // IWD
    Coordinate{131.79, 34.6764}, // IWJ
    Coordinate{-95.6725, 29.8183}, // IWS
    Coordinate{91.2392, 23.89}, // IXA
    Coordinate{88.3282, 26.6811}, // IXB
    Coordinate{76.7885, 30.6733}, // IXC
    Coordinate{81.7339, 25.44}, // IXD
    Coordinate{74.8897, 12.9619}, // IXE
    Coordinate{74.6175, 15.8586}, // IXG
    Coordinate{92.0072, 24.3078}, // IXH
    Coordinate{94.0969, 27.2906}, // IXI
    Coordinate{74.8367, 32.6892}, // IXJ
    Coordinate{70.2691, 21.315}, // IXK
    Coordinate{77.5457, 34.1357}, // IXL
    Coordinate{78.0883, 9.83361}, // IXM
    Coordinate{91.6039, 24.0617}, // IXN
    Coordinate{75.6344, 32.2336}, // IXP
    Coordinate{91.8142, 24.1317}, // IXQ
    Coordinate{85.3217, 23.3142}, // IXR
    Coordinate{92.9786, 24.912}, // IXS
    Coordinate{95.3833, 28.1}, // IXT
    Coordinate{75.3976, 19.8628}, // IXU
    Coordinate{94.8019, 28.164}, // IXV
    Coordinate{86.1643, 22.8136}, // IXW
    Coordinate{70.1003, 23.1122}, // IXY
    Coordinate{92.7297, 11.6411}, // IXZ
    Coordinate{-92.0842, 29.9758}, // IYA
    Coordinate{-117.829, 35.6586}, // IYK
    Coordinate{-43.1731, -21.5131}, // IZA
    Coordinate{132.89, 35.4136}, // IZO
    Coordinate{-95.0931, 16.4456}, // IZT
    Coordinate{70.4985, 34.3997}, // JAA
    Coordinate{132.893, -12.6583}, // JAB
    Coordinate{-110.738, 43.6072}, // JAC
    Coordinate{115.881, -32.0975}, // JAD
    Coordinate{-78.7742, -5.59528}, // JAE
    Coordinate{75.8122, 26.8242}, // JAI
    Coordinate{-72.5186, 18.2411}, // JAK
    Coordinate{-96.7975, 19.4744}, // JAL
    Coordinate{-90.0758, 32.3111}, // JAN
    Coordinate{21.2331, 43.9767}, // JAO
    Coordinate{-84.7833, 9.98333}, // JAP
    Coordinate{151.507, -5.6525}, // JAQ
    Coordinate{53.5789, 28.5867}, // JAR
    Coordinate{168.978, 7.75}, // JAT
    Coordinate{-75.4733, -11.7831}, // JAU
    Coordinate{-51.0572, 69.2433}, // JAV
    Coordinate{-81.6878, 30.4942}, // JAX
    Coordinate{113.694, -8.24111}, // JBB
    Coordinate{-69.9814, 18.5756}, // JBQ
    Coordinate{-90.6464, 35.8317}, // JBR
    Coordinate{-161.743, 60.7819}, // JBT
    Coordinate{-51.5517, -27.1728}, // JCB
    Coordinate{-51.1747, 68.8172}, // JCH
    Coordinate{-94.8903, 38.8308}, // JCI
    Coordinate{141.722, -20.6683}, // JCK
    Coordinate{-57.7758, -6.23528}, // JCR
    Coordinate{-118.968, 44.4028}, // JDA
    Coordinate{-95.4964, 32.7422}, // JDD
    Coordinate{-43.3856, -21.7931}, // JDF
    Coordinate{126.713, 33.3983}, // JDG
    Coordinate{73.0467, 26.2511}, // JDH
    Coordinate{-106.953, 47.3289}, // JDN
    Coordinate{-39.2717, -7.21833}, // JDO
    Coordinate{-44.2264, -21.0864}, // JDR
    Coordinate{117.176, 29.3386}, // JDZ
    Coordinate{39.1556, 21.6811}, // JED
    Coordinate{-74.1705, 18.6633}, // JEE
    Coordinate{-92.1561, 38.5911}, // JEF
    Coordinate{-52.7847, 68.7218}, // JEG
    Coordinate{168.962, 7.565}, // JEJ
    Coordinate{-40.0719, -13.8778}, // JEQ
    Coordinate{-2.19528, 49.2081}, // JER
    Coordinate{-81.8825, 31.5539}, // JES
    Coordinate{-73.7789, 40.6397}, // JFK
    Coordinate{-80.6956, 41.7781}, // JFN
    Coordinate{-49.6708, 62.0147}, // JFR
    Coordinate{-87.3142, 33.9019}, // JFX
    Coordinate{70.0125, 22.4656}, // JGA
    Coordinate{82.0369, 19.0744}, // JGB
    Coordinate{124.118, 50.3714}, // JGD
    Coordinate{98.3383, 39.8597}, // JGN
    Coordinate{-53.5381, 69.2511}, // JGO
    Coordinate{114.737, 26.8575}, // JGS
    Coordinate{103.669, 1.64111}, // JHB
    Coordinate{100.76, 21.9739}, // JHG
    Coordinate{-111.419, 57.2239}, // JHL
    Coordinate{-156.673, 20.9631}, // JHM
    Coordinate{-101.732, 37.5853}, // JHN
    Coordinate{148.755, -20.2767}, // JHQ
    Coordinate{-53.7294, 66.9514}, // JHS
    Coordinate{-79.2581, 42.1533}, // JHW
    Coordinate{-58.7114, -11.4194}, // JIA
    Coordinate{43.1593, 11.5473}, // JIB
    Coordinate{102.348, 38.5419}, // JIC
    Coordinate{42.9119, 9.33222}, // JIJ
    Coordinate{26.3471, 37.6827}, // JIK
    Coordinate{126.396, 44.0022}, // JIL
    Coordinate{36.815, 7.66201}, // JIM
    Coordinate{33.1931, 0.4525}, // JIN
    Coordinate{127.909, -8.14056}, // JIO
    Coordinate{108.829, 29.5175}, // JIQ
    Coordinate{115.801, 29.4769}, // JIU
    Coordinate{61.8054, 25.0678}, // JIW
    Coordinate{-99.2889, 19.5747}, // JJC
    Coordinate{-49.0603, -28.6753}, // JJG
    Coordinate{-76.7292, -7.16972}, // JJI
    Coordinate{38.1706, 0.230278}, // JJM
    Coordinate{118.589, 24.7989}, // JJN
    Coordinate{14.0717, 57.7583}, // JKG
    Coordinate{26.1406, 38.3431}, // JKH
    Coordinate{26.9406, 36.9633}, // JKL
    Coordinate{85.9222, 26.7086}, // JKR
    Coordinate{-95.2175, 31.8694}, // JKV
    Coordinate{-94.4983, 37.1517}, // JLN
    Coordinate{80.0603, 23.1834}, // JLR
    Coordinate{16.0653, -14.6986}, // JMB
    Coordinate{99.7864, 22.4158}, // JMJ
    Coordinate{25.3481, 37.4351}, // JMK
    Coordinate{83.7225, 28.7822}, // JMO
    Coordinate{-98.6783, 46.9297}, // JMS
    Coordinate{130.465, 46.8433}, // JMU
    Coordinate{-44.3864, -15.4747}, // JNA
    Coordinate{28.2461, -26.1392}, // JNB
    Coordinate{116.347, 35.2928}, // JNG
    Coordinate{-60.9339, -34.5458}, // JNI
    Coordinate{57.6344, 19.5022}, // JNJ
    Coordinate{-134.576, 58.355}, // JNU
    Coordinate{25.3682, 37.0811}, // JNX
    Coordinate{121.28, 40.93}, // JNZ
    Coordinate{29.6244, 62.6589}, // JOE
    Coordinate{110.432, -7.78806}, // JOG
    Coordinate{-48.7978, -26.2231}, // JOI
    Coordinate{-106.585, 68.1253}, // JOJ
    Coordinate{47.895, 56.705}, // JOK
    Coordinate{121.01, 6.05307}, // JOL
    Coordinate{-169.534, 16.7286}, // JON
    Coordinate{8.86889, 9.63972}, // JOS
    Coordinate{-88.1756, 41.5178}, // JOT
    Coordinate{-34.9503, -7.14833}, // JPA
    Coordinate{-61.8467, -10.8706}, // JPR
    Coordinate{-52.6961, 70.7342}, // JQA
    Coordinate{-78.1572, 7.51778}, // JQE
    Coordinate{-80.7092, 35.3878}, // JQF
    Coordinate{-158.07, 21.3072}, // JRF
    Coordinate{94.175, 26.73}, // JRH
    Coordinate{-58.4894, -10.3058}, // JRN
    Coordinate{37.0744, -3.42944}, // JRO
    Coordinate{-59.7921, -37.7061}, // JRZ
    Coordinate{84.0503, 21.9133}, // JSA
    Coordinate{26.1013, 35.2161}, // JSH
    Coordinate{23.5036, 39.1772}, // JSI
    Coordinate{132.66, 47.11}, // JSJ
    Coordinate{-70.4486, -44.0583}, // JSM
    Coordinate{89.1608, 23.1836}, // JSR
    Coordinate{-78.8347, 40.3156}, // JST
    Coordinate{-52.9394, 65.4125}, // JSU
    Coordinate{-94.8028, 35.4383}, // JSV
    Coordinate{24.95, 37.4228}, // JSY
    Coordinate{-49.0683, -22.1578}, // JTC
    Coordinate{-51.7753, -17.83}, // JTI
    Coordinate{25.4793, 36.3992}, // JTR
    Coordinate{26.3758, 36.5798}, // JTY
    Coordinate{-57.5389, -11.2867}, // JUA
    Coordinate{31.6011, 4.87201}, // JUB
    Coordinate{117.687, 30.7403}, // JUH
    Coordinate{7.05573, 53.6816}, // JUI
    Coordinate{-65.0978, -24.3928}, // JUJ
    Coordinate{-70.1581, -15.4669}, // JUL
    Coordinate{82.1933, 29.2744}, // JUM
    Coordinate{115.055, -30.3033}, // JUR
    Coordinate{-58.5995, -34.7305}, // JUS
    Coordinate{-56.1306, 72.7903}, // JUV
    Coordinate{118.899, 28.9658}, // JUZ
    Coordinate{45.2833, -18.8}, // JVA
    Coordinate{-74.5983, 40.5244}, // JVI
    Coordinate{-89.0417, 42.6203}, // JVL
    Coordinate{-148.926, 61.7319}, // JVM
    Coordinate{-90.4106, 32.3044}, // JVW
    Coordinate{-85.7383, 38.3656}, // JVY
    Coordinate{24.691, -24.6023}, // JWA
    Coordinate{-98.4208, 35.8644}, // JWG
    Coordinate{48.3585, 36.7742}, // JWN
    Coordinate{130.997, 45.3061}, // JXA
    Coordinate{-84.4606, 42.2606}, // JXN
    Coordinate{-84.5858, 41.9214}, // JYM
    Coordinate{-77.5575, 39.0781}, // JYO
    Coordinate{57.6703, 28.7269}, // JYR
    Coordinate{25.6728, 62.4008}, // JYV
    Coordinate{103.685, 32.8542}, // JZH
    Coordinate{-80.0028, 32.7008}, // JZI
    Coordinate{-84.4572, 34.4533}, // JZP
    Coordinate{31.1333, -10.2167}, // KAA
    Coordinate{28.885, -16.5197}, // KAB
    Coordinate{41.1914, 37.0206}, // KAC
    Coordinate{7.32, 10.6958}, // KAD
    Coordinate{-133.946, 56.9731}, // KAE
    Coordinate{-59.4914, 5.1725}, // KAI
    Coordinate{27.6875, 64.2842}, // KAJ
    Coordinate{-158.741, 64.3189}, // KAL
    Coordinate{42.6111, 15.3611}, // KAM
    Coordinate{8.52444, 12.0475}, // KAN
    Coordinate{29.2319, 65.9903}, // KAO
    Coordinate{22.65, -8.35}, // KAP
    Coordinate{-60.6139, 5.86528}, // KAR
    Coordinate{18.7333, -28.0333}, // KAS
    Coordinate{173.285, -35.07}, // KAT
    Coordinate{98.538, 10.0493}, // KAW
    Coordinate{114.26, -27.6917}, // KAX
    Coordinate{-11.55, 9.583}, // KBA
    Coordinate{-145.824, 66.2739}, // KBC
    Coordinate{31.4978, 2.32639}, // KBG
    Coordinate{9.97722, 2.87278}, // KBI
    Coordinate{69.2123, 34.5659}, // KBL
    Coordinate{24.3333, -6.12056}, // KBN
    Coordinate{26.9167, -6.08333}, // KBO
    Coordinate{30.8933, 50.3447}, // KBP
    Coordinate{33.4667, -13.0167}, // KBQ
    Coordinate{102.293, 6.16667}, // KBR
    Coordinate{-11.7624, 7.94389}, // KBS
    Coordinate{116.163, -3.29278}, // KBU
    Coordinate{98.9853, 8.10016}, // KBV
    Coordinate{-158.401, 56.2956}, // KBW
    Coordinate{134.293, -32.8358}, // KBY
    Coordinate{173.602, -42.425}, // KBZ
    Coordinate{82.9869, 41.7181}, // KCA
    Coordinate{-55.7167, 3.15}, // KCB
    Coordinate{-132.834, 56.0147}, // KCC
    Coordinate{69.1564, 27.1553}, // KCF
    Coordinate{-158.591, 56.3178}, // KCG
    Coordinate{110.347, 1.48444}, // KCH
    Coordinate{108.061, 57.7728}, // KCK
    Coordinate{-158.534, 56.3111}, // KCL
    Coordinate{36.9533, 37.5386}, // KCM
    Coordinate{-158.775, 56.255}, // KCQ
    Coordinate{80.3206, 5.99389}, // KCT
    Coordinate{31.7367, 1.75}, // KCU
    Coordinate{133.669, 33.5461}, // KCZ
    Coordinate{-14.9681, 12.8983}, // KDA
    Coordinate{121.598, -31.19}, // KDB
    Coordinate{2.933, 11.133}, // KDC
    Coordinate{66.6403, 27.7926}, // KDD
    Coordinate{65.8503, 31.5072}, // KDH
    Coordinate{122.418, -4.08161}, // KDI
    Coordinate{10.7611, -0.188889}, // KDJ
    Coordinate{-152.374, 57.8058}, // KDK
    Coordinate{22.8306, 58.9906}, // KDL
    Coordinate{72.9962, 0.488056}, // KDM
    Coordinate{11.3611, -2.40556}, // KDN
    Coordinate{73.5197, 1.85835}, // KDO
    Coordinate{149.542, -6.20833}, // KDR
    Coordinate{75.5361, 35.3356}, // KDU
    Coordinate{178.157, -19.0581}, // KDV
    Coordinate{29.6992, 11.1371}, // KDX
    Coordinate{136.842, 62.7861}, // KDY
    Coordinate{-151.925, 59.3522}, // KEB
    Coordinate{-13.5167, 16.15}, // KED
    Coordinate{14.5333, -0.0833333}, // KEE
    Coordinate{-22.6056, 63.985}, // KEF
    Coordinate{-122.259, 47.7547}, // KEH
    Coordinate{86.11, 55.2717}, // KEJ
    Coordinate{-157.472, 59.3547}, // KEK
    Coordinate{24.5847, 65.7792}, // KEM
    Coordinate{-11.1766, 7.8913}, // KEN
    Coordinate{-7.567, 9.5}, // KEO
    Coordinate{81.6669, 28.1036}, // KEP
    Coordinate{56.9511, 30.2744}, // KER
    Coordinate{-96.5061, 56.0367}, // KES
    Coordinate{99.6361, 21.3017}, // KET
    Coordinate{35.2508, -1.58592}, // KEU
    Coordinate{-92.8364, 52.9911}, // KEW
    Coordinate{35.2508, -0.413778}, // KEY
    Coordinate{-11.4061, 16.5833}, // KFA
    Coordinate{119.437, -22.2919}, // KFE
    Coordinate{130.808, -17.4319}, // KFG
    Coordinate{-163.41, 54.8475}, // KFP
    Coordinate{33.7908, 41.3047}, // KFS
    Coordinate{22.4667, -5.9}, // KGA
    Coordinate{137.521, -35.7139}, // KGC
    Coordinate{20.5925, 54.89}, // KGD
    Coordinate{157.587, -7.33278}, // KGE
    Coordinate{73.3353, 49.6717}, // KGF
    Coordinate{-12.2203, 12.5667}, // KGG
    Coordinate{121.462, -30.7894}, // KGI
    Coordinate{33.8928, -9.95494}, // KGJ
    Coordinate{-157.259, 59.7267}, // KGK
    Coordinate{30.1331, -1.96656}, // KGL
    Coordinate{16.8056, -6.46806}, // KGN
    Coordinate{74.535, 62.19}, // KGP
    Coordinate{27.0917, 36.7933}, // KGS
    Coordinate{101.735, 30.1575}, // KGT
    Coordinate{116.159, 5.35444}, // KGU
    Coordinate{-160.065, 62.8944}, // KGX
    Coordinate{151.841, -26.5808}, // KGY
    Coordinate{36.4014, 45.3725}, // KHC
    Coordinate{48.2808, 33.4354}, // KHD
    Coordinate{32.5022, 46.6681}, // KHE
    Coordinate{76.02, 39.5431}, // KHG
    Coordinate{120.35, 22.5769}, // KHH
    Coordinate{67.1605, 24.9045}, // KHI
    Coordinate{50.3233, 29.2594}, // KHK
    Coordinate{95.6744, 25.9875}, // KHM
    Coordinate{115.9, 28.865}, // KHN
    Coordinate{102.826, 47.2467}, // KHR
    Coordinate{56.2333, 26.1708}, // KHS
    Coordinate{69.9517, 33.3336}, // KHT
    Coordinate{33.4753, 49.1308}, // KHU
    Coordinate{135.188, 48.5281}, // KHV
    Coordinate{23.7878, -19.1494}, // KHW
    Coordinate{44.9736, 38.4275}, // KHY
    Coordinate{-121.121, 36.2286}, // KIC
    Coordinate{14.0833, 55.9119}, // KID
    Coordinate{155.723, -6.30333}, // KIE
    Coordinate{-89.8553, 53.0125}, // KIF
    Coordinate{53.9797, 26.5262}, // KIH
    Coordinate{139.112, 37.9558}, // KIJ
    Coordinate{24.7636, -28.8017}, // KIM
    Coordinate{-76.7875, 17.9356}, // KIN
    Coordinate{169.128, 5.64617}, // KIO
    Coordinate{-98.4903, 33.8606}, // KIP
    Coordinate{-9.52389, 52.1808}, // KIR
    Coordinate{34.7289, -0.086111}, // KIS
    Coordinate{23.017, 36.2743}, // KIT
    Coordinate{28.9308, 46.9278}, // KIV
    Coordinate{28.1497, -12.9003}, // KIW
    Coordinate{135.233, 34.4342}, // KIX
    Coordinate{39.5086, -8.91111}, // KIY
    Coordinate{89.644, 22.647}, // KJA
    Coordinate{107.981, 26.9742}, // KJH
    Coordinate{86.9981, 48.2211}, // KJI
    Coordinate{3.20472, 50.8172}, // KJK
    Coordinate{127.293, 26.1683}, // KJP
    Coordinate{-161.154, 64.9394}, // KKA
    Coordinate{-152.371, 58.1908}, // KKB
    Coordinate{102.782, 16.4644}, // KKC
    Coordinate{147.733, -8.88306}, // KKD
    Coordinate{173.912, -35.2628}, // KKE
    Coordinate{-162.881, 59.9608}, // KKH
    Coordinate{-161.423, 60.9047}, // KKI
    Coordinate{131.035, 33.8456}, // KKJ
    Coordinate{29.8878, 69.725}, // KKN
    Coordinate{173.817, -35.4528}, // KKO
    Coordinate{-146.886, -15.6677}, // KKR
    Coordinate{-87.4283, 40.7586}, // KKT
    Coordinate{18.7833, -5.03583}, // KKW
    Coordinate{129.928, 28.3214}, // KKX
    Coordinate{-7.29611, 52.6508}, // KKY
    Coordinate{102.996, 11.6132}, // KKZ
    Coordinate{32.5925, 0.326111}, // KLA
    Coordinate{22.4806, -14.9983}, // KLB
    Coordinate{-16.0511, 14.1467}, // KLC
    Coordinate{35.76, 56.825}, // KLD
    Coordinate{14.4456, 10.0925}, // KLE
    Coordinate{36.3689, 54.5467}, // KLF
    Coordinate{-160.341, 61.5364}, // KLG
    Coordinate{74.2894, 16.6647}, // KLH
    Coordinate{21.2428, 55.7119}, // KLJ
    Coordinate{35.8342, 3.48036}, // KLK
    Coordinate{-156.859, 59.1281}, // KLL
    Coordinate{55.4519, 37.375}, // KLM
    Coordinate{-153.977, 57.535}, // KLN
    Coordinate{122.378, 11.6813}, // KLO
    Coordinate{112.537, -3.37639}, // KLP
    Coordinate{16.2833, 56.6833}, // KLR
    Coordinate{-122.898, 46.1181}, // KLS
    Coordinate{14.3372, 46.6428}, // KLU
    Coordinate{12.915, 50.2031}, // KLV
    Coordinate{-133.076, 55.5792}, // KLW
    Coordinate{22.0256, 37.0684}, // KLX
    Coordinate{26.7333, -2.57639}, // KLY
    Coordinate{17.0933, -29.6884}, // KLZ
    Coordinate{145.771, -7.96365}, // KMA
    Coordinate{45.5281, 27.9008}, // KMC
    Coordinate{28.9078, -2.46222}, // KME
    Coordinate{102.929, 25.1019}, // KMG
    Coordinate{23.4114, -27.4597}, // KMH
    Coordinate{131.449, 31.8772}, // KMI
    Coordinate{130.855, 32.8372}, // KMJ
    Coordinate{12.6167, -3.48333}, // KMK
    Coordinate{24.9833, -8.73333}, // KMN
    Coordinate{-159.05, 58.9903}, // KMO
    Coordinate{18.1114, -26.5397}, // KMP
    Coordinate{136.408, 36.3939}, // KMQ
    Coordinate{-1.59056, 6.71444}, // KMS
    Coordinate{104.162, 10.6341}, // KMT
    Coordinate{42.4475, -0.389333}, // KMU
    Coordinate{94.0508, 23.1875}, // KMV
    Coordinate{41.02, 57.7967}, // KMW
    Coordinate{-154.146, 57.0256}, // KMY
    Coordinate{24.7833, -14.8}, // KMZ
    Coordinate{-71.4786, -32.9497}, // KNA
    Coordinate{-112.531, 37.0111}, // KNB
    Coordinate{25.9, -2.93333}, // KND
    Coordinate{133.695, -3.64452}, // KNG
    Coordinate{118.359, 24.4278}, // KNH
    Coordinate{117.653, -33.7}, // KNI
    Coordinate{14.5167, -3.95}, // KNJ
    Coordinate{-154.803, 59.4331}, // KNK
    Coordinate{24.1569, -7.60139}, // KNM
    Coordinate{-9.22733, 10.4485}, // KNN
    Coordinate{98.878, 3.64174}, // KNO
    Coordinate{15.4565, -9.77078}, // KNP
    Coordinate{164.838, -21.0533}, // KNQ
    Coordinate{143.878, -39.8775}, // KNS
    Coordinate{-90.0367, 36.2258}, // KNT
    Coordinate{80.4117, 26.4028}, // KNU
    Coordinate{-157.373, 59.4517}, // KNW
    Coordinate{128.708, -15.7781}, // KNX
    Coordinate{-11.2528, 12.8333}, // KNZ
    Coordinate{-156.046, 19.7389}, // KOA
    Coordinate{164.256, -20.5464}, // KOC
    Coordinate{123.671, -10.1714}, // KOE
    Coordinate{-2.90056, 58.9581}, // KOI
    Coordinate{130.717, 31.8033}, // KOJ
    Coordinate{23.1392, 63.7203}, // KOK
    Coordinate{21.25, 8.5}, // KOL
    Coordinate{26.99, -5.4}, // KOO
    Coordinate{104.642, 17.3839}, // KOP
    Coordinate{11.9472, 51.7211}, // KOQ
    Coordinate{103.637, 10.58}, // KOS
    Coordinate{-163.533, 63.0306}, // KOT
    Coordinate{12.4411, -1.18444}, // KOU
    Coordinate{69.5967, 53.33}, // KOV
    Coordinate{114.777, 25.8517}, // KOW
    Coordinate{-154.23, 57.1614}, // KOY
    Coordinate{-152.501, 57.9229}, // KOZ
    Coordinate{-133.622, 56.3519}, // KPB
    Coordinate{-166.859, 65.2536}, // KPC
    Coordinate{112.843, 2.00833}, // KPI
    Coordinate{-164.031, 59.9331}, // KPN
    Coordinate{129.42, 35.9878}, // KPO
    Coordinate{-152.582, 58.49}, // KPR
    Coordinate{152.77, -31.0744}, // KPS
    Coordinate{-114.658, 41.9761}, // KPT
    Coordinate{-159.161, 55.9067}, // KPV
    Coordinate{166.139, 67.8469}, // KPW
    Coordinate{-153.041, 57.93}, // KPY
    Coordinate{-165.604, 54.1447}, // KQA
    Coordinate{116.687, -29.2167}, // KQR
    Coordinate{68.8628, 37.8622}, // KQT
    Coordinate{143.939, -35.7517}, // KRA
    Coordinate{140.83, -17.4558}, // KRB
    Coordinate{101.463, -2.09111}, // KRC
    Coordinate{30.0942, -2.54722}, // KRE
    Coordinate{17.7686, 63.0483}, // KRF
    Coordinate{-59.5333, 4.03333}, // KRG
    Coordinate{-0.138611, 51.2136}, // KRH
    Coordinate{144.25, -7.42472}, // KRI
    Coordinate{19.7847, 50.0778}, // KRK
    Coordinate{86.1431, 41.6164}, // KRL
    Coordinate{-59.3097, 3.75195}, // KRM
    Coordinate{20.3356, 67.8214}, // KRN
    Coordinate{65.4153, 55.475}, // KRO
    Coordinate{9.12472, 56.2975}, // KRP
    Coordinate{39.1706, 45.0347}, // KRR
    Coordinate{8.085, 58.2039}, // KRS
    Coordinate{32.5532, 15.5895}, // KRT
    Coordinate{35.665, 0.32}, // KRV
    Coordinate{53.0072, 40.0633}, // KRW
    Coordinate{84.9525, 45.4664}, // KRY
    Coordinate{19, -1.45}, // KRZ
    Coordinate{162.958, 5.35694}, // KSA
    Coordinate{21.2411, 48.6631}, // KSC
    Coordinate{13.3375, 59.4447}, // KSD
    Coordinate{30.1025, 0.19}, // KSE
    Coordinate{9.37763, 51.4084}, // KSF
    Coordinate{47.1564, 34.3459}, // KSH
    Coordinate{-10.1244, 9.16056}, // KSI
    Coordinate{26.91, 35.4214}, // KSJ
    Coordinate{14.4947, 59.3333}, // KSK
    Coordinate{36.3286, 15.3872}, // KSL
    Coordinate{-163.302, 62.0608}, // KSM
    Coordinate{63.5503, 53.2069}, // KSN
    Coordinate{21.2811, 40.4463}, // KSO
    Coordinate{65.7733, 38.8033}, // KSQ
    Coordinate{120.437, -6.17567}, // KSR
    Coordinate{-5.7989, 11.327}, // KSS
    Coordinate{32.6981, 13.1894}, // KST
    Coordinate{7.82611, 63.1119}, // KSU
    Coordinate{140.703, -23.5431}, // KSV
    Coordinate{43.0989, 40.5586}, // KSY
    Coordinate{46.6967, 61.2367}, // KSZ
    Coordinate{116.773, -20.7122}, // KTA
    Coordinate{-132.537, 55.6881}, // KTB
    Coordinate{-5.0654, 8.1344}, // KTC
    Coordinate{131.327, 25.9447}, // KTD
    Coordinate{103.427, 4.53722}, // KTE
    Coordinate{172.775, -40.9038}, // KTF
    Coordinate{109.963, -1.81639}, // KTG
    Coordinate{106.055, 12.4852}, // KTI
    Coordinate{34.9508, 0.897222}, // KTL
    Coordinate{85.3578, 27.6972}, // KTM
    Coordinate{-131.711, 55.3542}, // KTN
    Coordinate{-59.8322, 4.64917}, // KTO
    Coordinate{-76.825, 17.9858}, // KTP
    Coordinate{-166.466, 65.3314}, // KTS
    Coordinate{24.8481, 67.6986}, // KTT
    Coordinate{75.8456, 25.1601}, // KTU
    Coordinate{-62.3375, 5.71667}, // KTV
    Coordinate{19.08, 50.4742}, // KTW
    Coordinate{-5.467, 12.35}, // KTX
    Coordinate{103.209, 3.77518}, // KUA
    Coordinate{173.44, 0.219662}, // KUC
    Coordinate{116.831, 6.92417}, // KUD
    Coordinate{}, // KUE
    Coordinate{50.155, 53.5017}, // KUF
    Coordinate{142.218, -10.225}, // KUG
    Coordinate{144.193, 43.0408}, // KUH
    Coordinate{-162.524, 60.8733}, // KUK
    Coordinate{101.71, 2.74556}, // KUL
    Coordinate{130.659, 30.3856}, // KUM
    Coordinate{24.0847, 54.9639}, // KUN
    Coordinate{27.7944, 63.0086}, // KUO
    Coordinate{70.7622, 36.0175}, // KUR
    Coordinate{-37.1236, 65.5736}, // KUS
    Coordinate{42.4825, 42.1764}, // KUT
    Coordinate{77.1544, 31.8767}, // KUU
    Coordinate{126.616, 35.9039}, // KUV
    Coordinate{143.122, -7.4196}, // KUY
    Coordinate{24.6192, 40.9133}, // KVA
    Coordinate{13.9728, 58.4561}, // KVB
    Coordinate{-162.266, 55.1164}, // KVC
    Coordinate{46.3175, 40.7378}, // KVD
    Coordinate{150.808, -2.57917}, // KVG
    Coordinate{33.5881, 67.4631}, // KVK
    Coordinate{-164.564, 67.7361}, // KVL
    Coordinate{170.414, 64.6653}, // KVM
    Coordinate{20.5853, 43.8186}, // KVO
    Coordinate{20.724, 43.7307}, // KVS
    Coordinate{49.3483, 58.5033}, // KVX
    Coordinate{110.479, -5.80111}, // KWB
    Coordinate{106.801, 26.5386}, // KWE
    Coordinate{-133.243, 55.2964}, // KWF
    Coordinate{33.2069, 48.0431}, // KWG
    Coordinate{70.2033, 37.8917}, // KWH
    Coordinate{47.98, 29.2268}, // KWI
    Coordinate{126.809, 35.1264}, // KWJ
    Coordinate{-163.169, 59.8764}, // KWK
    Coordinate{110.039, 25.2181}, // KWL
    Coordinate{-161.845, 59.755}, // KWN
    Coordinate{-153.549, 57.77}, // KWP
    Coordinate{35.5967, 33.2167}, // KWS
    Coordinate{-161.444, 60.7903}, // KWT
    Coordinate{41.2975, -1.96056}, // KWY
    Coordinate{25.5, -10.7667}, // KWZ
    Coordinate{67.4333, 59.65}, // KXD
    Coordinate{179.422, -17.3458}, // KXF
    Coordinate{136.933, 50.4083}, // KXK
    Coordinate{121.527, 22.0294}, // KYD
    Coordinate{-154.454, 57.5661}, // KYK
    Coordinate{93.5347, 19.4244}, // KYP
    Coordinate{-11.4044, 14.4811}, // KYS
    Coordinate{-157.731, 64.8758}, // KYU
    Coordinate{94.4052, 51.6761}, // KYZ
    Coordinate{-153.746, 57.5533}, // KZB
    Coordinate{104.564, 12.255}, // KZC
    Coordinate{104.148, 12.5395}, // KZD
    Coordinate{21.8408, 40.2858}, // KZI
    Coordinate{105.441, 12.0289}, // KZK
    Coordinate{49.2817, 55.6067}, // KZN
    Coordinate{65.5925, 44.7069}, // KZO
    Coordinate{30.13, 39.1114}, // KZR
    Coordinate{29.5667, 36.1278}, // KZS
    Coordinate{-102.689, 38.0697}, // LAA
    Coordinate{113.842, 7.37222}, // LAC
    Coordinate{13.2312, -8.85808}, // LAD
    Coordinate{146.996, -6.73306}, // LAE
    Coordinate{-86.9369, 40.4122}, // LAF
    Coordinate{127.501, -0.637222}, // LAH
    Coordinate{-3.47444, 48.7542}, // LAI
    Coordinate{-50.2822, -27.7828}, // LAJ
    Coordinate{-135.006, 68.2233}, // LAK
    Coordinate{-82.0186, 27.9889}, // LAL
    Coordinate{-106.269, 35.8797}, // LAM
    Coordinate{-84.5862, 42.7786}, // LAN
    Coordinate{120.532, 18.1781}, // LAO
    Coordinate{-110.363, 24.0727}, // LAP
    Coordinate{21.9639, 32.7886}, // LAQ
    Coordinate{-105.675, 41.3119}, // LAR
    Coordinate{-115.152, 36.08}, // LAS
    Coordinate{40.9131, -2.25235}, // LAU
    Coordinate{-98.4164, 34.5678}, // LAW
    Coordinate{-118.408, 33.9425}, // LAX
    Coordinate{29.7526, -28.581}, // LAY
    Coordinate{-43.4078, -13.2617}, // LAZ
    Coordinate{-1.66056, 53.8658}, // LBA
    Coordinate{-101.821, 33.6636}, // LBB
    Coordinate{10.7192, 53.8053}, // LBC
    Coordinate{69.6947, 40.215}, // LBD
    Coordinate{-79.4067, 40.2747}, // LBE
    Coordinate{-100.684, 41.1261}, // LBF
    Coordinate{2.44056, 48.9512}, // LBG
    Coordinate{119.889, -8.48667}, // LBJ
    Coordinate{40.8817, 0.34833}, // LBK
    Coordinate{-100.96, 37.0442}, // LBL
    Coordinate{36.1042, 0.6661}, // LBN
    Coordinate{23.3783, -4.96667}, // LBO
    Coordinate{115.45, 3.18333}, // LBP
    Coordinate{10.2458, -0.704167}, // LBQ
    Coordinate{-64.7839, -7.25028}, // LBR
    Coordinate{179.34, -16.4668}, // LBS
    Coordinate{-79.0594, 34.6097}, // LBT
    Coordinate{115.25, 5.30056}, // LBU
    Coordinate{9.41222, 0.458611}, // LBV
    Coordinate{115.683, 3.86667}, // LBW
    Coordinate{120.103, 13.8565}, // LBX
    Coordinate{20.7328, -8.44153}, // LBZ
    Coordinate{33.6303, 34.8789}, // LCA
    Coordinate{-59.3853, -15.2308}, // LCB
    Coordinate{18.1333, 40.2392}, // LCC
    Coordinate{-86.8522, 15.7428}, // LCE
    Coordinate{-88.9611, 15.6681}, // LCF
    Coordinate{-8.37722, 43.3019}, // LCG
    Coordinate{-93.2233, 30.1261}, // LCH
    Coordinate{-71.4189, 43.5728}, // LCI
    Coordinate{19.3981, 51.7219}, // LCJ
    Coordinate{-82.9278, 39.8139}, // LCK
    Coordinate{-83.6422, 22.3361}, // LCL
    Coordinate{-64.5333, -31.0086}, // LCM
    Coordinate{14.5333, -2.45}, // LCO
    Coordinate{-82.5769, 30.1819}, // LCQ
    Coordinate{-72.8023, -1.45789}, // LCR
    Coordinate{10.5764, 43.8256}, // LCV
    Coordinate{116.746, 25.6742}, // LCX
    Coordinate{0.055278, 51.5053}, // LCY
    Coordinate{88.1306, 25}, // LDA
    Coordinate{-51.1367, -23.3303}, // LDB
    Coordinate{-0.00194444, 43.185}, // LDE
    Coordinate{45.7228, 64.8958}, // LDG
    Coordinate{159.077, -31.5383}, // LDH
    Coordinate{39.7586, -9.85}, // LDI
    Coordinate{-74.2447, 40.6175}, // LDJ
    Coordinate{13.1742, 58.4653}, // LDK
    Coordinate{-86.4078, 43.9625}, // LDM
    Coordinate{86.67, 27.2531}, // LDN
    Coordinate{-55.4075, 4.3754}, // LDO
    Coordinate{129.019, 47.7519}, // LDS
    Coordinate{118.324, 5.03222}, // LDU
    Coordinate{-54.0344, 5.48306}, // LDX
    Coordinate{-7.16194, 55.0428}, // LDY
    Coordinate{114.089, -22.2358}, // LEA
    Coordinate{-72.3042, 43.6261}, // LEB
    Coordinate{-41.2769, -12.4833}, // LEC
    Coordinate{30.2625, 59.8003}, // LED
    Coordinate{-81.8087, 28.8231}, // LEE
    Coordinate{28.6556, -29.8908}, // LEF
    Coordinate{0.088055, 49.5339}, // LEH
    Coordinate{-2.37, 36.8439}, // LEI
    Coordinate{12.2364, 51.4239}, // LEJ
    Coordinate{-12.29, 11.3382}, // LEK
    Coordinate{135.805, -12.4983}, // LEL
    Coordinate{-5.65556, 42.5889}, // LEN
    Coordinate{-42.7331, -21.4719}, // LEP
    Coordinate{-5.67056, 50.1028}, // LEQ
    Coordinate{120.703, -27.8433}, // LER
    Coordinate{28.3167, -29.7833}, // LES
    Coordinate{-69.9431, -4.19333}, // LET
    Coordinate{1.40917, 42.3386}, // LEU
    Coordinate{178.759, -17.7111}, // LEV
    Coordinate{-70.2836, 44.0486}, // LEW
    Coordinate{-84.6058, 38.0364}, // LEX
    Coordinate{5.52306, 52.4553}, // LEY
    Coordinate{-88.175, 14.2903}, // LEZ
    Coordinate{40.6667, -15.0333}, // LFB
    Coordinate{-94.75, 31.2339}, // LFK
    Coordinate{53.1881, 27.3727}, // LFM
    Coordinate{-78.3303, 36.0233}, // LFN
    Coordinate{111.497, 36.0431}, // LFQ
    Coordinate{-72.2711, 8.23917}, // LFR
    Coordinate{-91.9875, 30.2053}, // LFT
    Coordinate{1.25417, 6.16583}, // LFW
    Coordinate{-73.8726, 40.7772}, // LGA
    Coordinate{-118.152, 33.8178}, // LGB
    Coordinate{-85.0725, 33.0089}, // LGC
    Coordinate{-118.007, 45.2903}, // LGD
    Coordinate{127.619, -20.1089}, // LGE
    Coordinate{5.44417, 50.6378}, // LGG
    Coordinate{138.427, -30.9983}, // LGH
    Coordinate{-75.0942, 23.1789}, // LGI
    Coordinate{99.7286, 6.32972}, // LGK
    Coordinate{115.179, 3.45944}, // LGL
    Coordinate{-69.0008, -45.5822}, // LGM
    Coordinate{7.49867, 53.7428}, // LGO
    Coordinate{123.723, 13.1569}, // LGP
    Coordinate{-76.8694, 0.0925}, // LGQ
    Coordinate{-72.5877, -47.2437}, // LGR
    Coordinate{-69.5742, -35.4933}, // LGS
    Coordinate{-70.9264, 4.55}, // LGT
    Coordinate{-111.852, 41.7912}, // LGU
    Coordinate{-0.190278, 51.1472}, // LGW
    Coordinate{42.5458, 3.8125}, // LGX
    Coordinate{-1.13056, 52.4869}, // LHB
    Coordinate{-70.5083, -3.91686}, // LHC
    Coordinate{-149.972, 61.18}, // LHD
    Coordinate{74.4025, 31.5214}, // LHE
    Coordinate{147.984, -29.4567}, // LHG
    Coordinate{-121.351, 38.9092}, // LHM
    Coordinate{-0.461389, 51.4775}, // LHR
    Coordinate{-68.9653, -46.5384}, // LHS
    Coordinate{-77.4222, 41.1358}, // LHV
    Coordinate{103.619, 36.5075}, // LHW
    Coordinate{-103.51, 38.05}, // LHX
    Coordinate{107.786, 30.6794}, // LIA
    Coordinate{18.6333, 3.63333}, // LIE
    Coordinate{167.24, -20.775}, // LIF
    Coordinate{1.18028, 45.8608}, // LIG
    Coordinate{-159.339, 21.9761}, // LIH
    Coordinate{169.309, 9.82333}, // LIK
    Coordinate{3.08694, 50.5633}, // LIL
    Coordinate{-77.1144, -12.0219}, // LIM
    Coordinate{9.27833, 45.4494}, // LIN
    Coordinate{-83.0219, 9.95778}, // LIO
    Coordinate{-49.7311, -21.6628}, // LIP
    Coordinate{21.4833, 2.16667}, // LIQ
    Coordinate{-85.5442, 10.5931}, // LIR
    Coordinate{-9.13417, 38.7742}, // LIS
    Coordinate{-92.2195, 34.7308}, // LIT
    Coordinate{-102.387, 33.9239}, // LIU
    Coordinate{97.2147, 19.6914}, // LIW
    Coordinate{34.7372, -12.0758}, // LIX
    Coordinate{-67.8833, 46.95}, // LIZ
    Coordinate{23.4444, -3.41866}, // LJA
    Coordinate{100.246, 26.6792}, // LJG
    Coordinate{-95.4622, 29.1086}, // LJN
    Coordinate{14.4561, 46.2244}, // LJU
    Coordinate{123.002, -8.27454}, // LKA
    Coordinate{-178.817, -18.1992}, // LKB
    Coordinate{-122.339, 47.6289}, // LKE
    Coordinate{34.345, 4.20412}, // LKG
    Coordinate{114.783, 3.31306}, // LKH
    Coordinate{-155.121, 58.9819}, // LKK
    Coordinate{24.9739, 70.0667}, // LKL
    Coordinate{13.6094, 68.1525}, // LKN
    Coordinate{80.8833, 26.7619}, // LKO
    Coordinate{-73.9619, 44.2644}, // LKP
    Coordinate{-80.8547, 34.7228}, // LKR
    Coordinate{-120.399, 42.1611}, // LKV
    Coordinate{55.375, 22.8056}, // LKW
    Coordinate{35.8183, -3.37583}, // LKY
    Coordinate{22.1219, 65.5436}, // LLA
    Coordinate{107.962, 25.4525}, // LLB
    Coordinate{31.5658, -25.4736}, // LLE
    Coordinate{111.612, 26.3456}, // LLF
    Coordinate{144.529, -17.1428}, // LLG
    Coordinate{-87.8986, 15.4431}, // LLH
    Coordinate{38.9911, 11.9739}, // LLI
    Coordinate{89.4331, 25.8875}, // LLJ
    Coordinate{48.8064, 38.7586}, // LLK
    Coordinate{120.245, -3.08472}, // LLO
    Coordinate{-91.7511, 33.6386}, // LLQ
    Coordinate{-123.754, 39.2619}, // LLR
    Coordinate{-60.5491, -24.7214}, // LLS
    Coordinate{13.5333, -12.3667}, // LLT
    Coordinate{-94.3114, 37.4894}, // LLU
    Coordinate{111.143, 37.6833}, // LLV
    Coordinate{33.7808, -13.7892}, // LLW
    Coordinate{-72.0181, 44.5692}, // LLX
    Coordinate{-74.8458, 39.9428}, // LLY
    Coordinate{34.5831, -13.7569}, // LMB
    Coordinate{-73.7875, 2.17917}, // LMC
    Coordinate{0.201667, 47.9486}, // LME
    Coordinate{166.266, 8.92167}, // LML
    Coordinate{-109.081, 25.6861}, // LMM
    Coordinate{115.01, 4.80806}, // LMN
    Coordinate{12.6181, 35.4978}, // LMP
    Coordinate{19.5764, 30.3781}, // LMQ
    Coordinate{23.4391, -28.3601}, // LMR
    Coordinate{-89.0614, 33.1447}, // LMS
    Coordinate{-121.733, 42.1561}, // LMT
    Coordinate{141.493, -7.0094}, // LMY
    Coordinate{-80.085, 26.5931}, // LNA
    Coordinate{168.16, -16.585}, // LNB
    Coordinate{-96.7175, 32.5775}, // LNC
    Coordinate{-108.73, 42.8152}, // LND
    Coordinate{168.172, -15.8647}, // LNE
    Coordinate{-153.242, 70.9108}, // LNI
    Coordinate{100.025, 23.7383}, // LNJ
    Coordinate{-89.2119, 46.1539}, // LNL
    Coordinate{-81.3897, 41.6839}, // LNN
    Coordinate{121.315, -28.8781}, // LNO
    Coordinate{-82.53, 36.9875}, // LNP
    Coordinate{-90.1797, 43.2119}, // LNR
    Coordinate{-76.2944, 40.1222}, // LNS
    Coordinate{152.628, -3.0424}, // LNV
    Coordinate{32.025, 54.825}, // LNX
    Coordinate{-156.951, 20.7856}, // LNY
    Coordinate{14.1875, 48.2333}, // LNZ
    Coordinate{-70.6481, -32.8144}, // LOB
    Coordinate{167.968, -15.3058}, // LOD
    Coordinate{101.722, 17.4392}, // LOE
    Coordinate{-79.3719, -3.99583}, // LOH
    Coordinate{-49.5433, -27.1603}, // LOI
    Coordinate{35.6086, 3.12222}, // LOK
    Coordinate{-118.565, 40.0664}, // LOL
    Coordinate{-101.944, 21.2592}, // LOM
    Coordinate{106.818, 10.9754}, // LON
    Coordinate{2.92833, 33.7644}, // LOO
    Coordinate{116.277, -8.75732}, // LOP
    Coordinate{25.7139, -25.1975}, // LOQ
    Coordinate{3.32111, 6.57722}, // LOS
    Coordinate{-88.0961, 41.6072}, // LOT
    Coordinate{-85.6636, 38.2281}, // LOU
    Coordinate{-101.47, 26.9558}, // LOV
    Coordinate{-77.97, 38.0097}, // LOW
    Coordinate{36.7167, 2.74706}, // LOY
    Coordinate{-84.0775, 37.0869}, // LOZ
    Coordinate{-15.3867, 27.9319}, // LPA
    Coordinate{-68.1922, -16.5133}, // LPB
    Coordinate{-120.468, 34.6656}, // LPC
    Coordinate{-69.5794, -1.33167}, // LPD
    Coordinate{-70.4206, 5.47917}, // LPE
    Coordinate{104.979, 26.6064}, // LPF
    Coordinate{-57.8947, -34.9722}, // LPG
    Coordinate{15.6728, 58.4083}, // LPI
    Coordinate{39.5383, 52.7033}, // LPK
    Coordinate{-2.84972, 53.3336}, // LPL
    Coordinate{167.817, -16.45}, // LPM
    Coordinate{-86.7344, 41.5725}, // LPO
    Coordinate{28.1486, 61.0458}, // LPP
    Coordinate{102.162, 19.8986}, // LPQ
    Coordinate{-82.1776, 41.3443}, // LPR
    Coordinate{-122.918, 48.5164}, // LPS
    Coordinate{99.5042, 18.2709}, // LPT
    Coordinate{114.97, 1.70361}, // LPU
    Coordinate{21.0969, 56.5175}, // LPX
    Coordinate{3.76333, 45.0797}, // LPY
    Coordinate{-82.7028, 34.81}, // LQK
    Coordinate{-74.775, -0.182222}, // LQM
    Coordinate{63.1176, 34.9857}, // LQN
    Coordinate{22.4486, 39.6486}, // LRA
    Coordinate{28.0528, -28.8556}, // LRB
    Coordinate{-99.4617, 27.5439}, // LRD
    Coordinate{144.28, -23.4342}, // LRE
    Coordinate{-68.5347, 45.3622}, // LRG
    Coordinate{-1.19528, 46.1792}, // LRH
    Coordinate{-96.1936, 42.7781}, // LRJ
    Coordinate{1.09278, 9.76963}, // LRL
    Coordinate{-68.9117, 18.4511}, // LRM
    Coordinate{-79.7828, 32.8978}, // LRO
    Coordinate{-101.304, 56.2486}, // LRQ
    Coordinate{54.3814, 27.6731}, // LRR
    Coordinate{26.8003, 37.1847}, // LRS
    Coordinate{-3.44, 47.7606}, // LRT
    Coordinate{-106.922, 32.2894}, // LRU
    Coordinate{-66.6717, 11.9458}, // LRV
    Coordinate{151.08, -8.5051}, // LSA
    Coordinate{-71.1994, -29.9161}, // LSC
    Coordinate{-91.2567, 43.8792}, // LSE
    Coordinate{97.7525, 22.9758}, // LSH
    Coordinate{-1.29389, 59.8814}, // LSI
    Coordinate{-84.7, 11.0333}, // LSL
    Coordinate{115.583, 4.21639}, // LSM
    Coordinate{-120.869, 37.0628}, // LSN
    Coordinate{-1.725, 46.4756}, // LSO
    Coordinate{-70.1514, 11.7808}, // LSP
    Coordinate{-72.4256, -37.4019}, // LSQ
    Coordinate{-167.163, 65.3961}, // LSR
    Coordinate{-61.5806, 15.8644}, // LSS
    Coordinate{147.214, -41.5453}, // LST
    Coordinate{115.494, 4.55222}, // LSU
    Coordinate{96.9503, 5.22667}, // LSW
    Coordinate{153.26, -28.8303}, // LSY
    Coordinate{14.3931, 44.5658}, // LSZ
    Coordinate{30.3293, -23.8244}, // LTA
    Coordinate{16.3, 9.4}, // LTC
    Coordinate{9.71533, 30.1517}, // LTD
    Coordinate{96.2192, 46.3758}, // LTI
    Coordinate{35.9486, 35.4008}, // LTK
    Coordinate{12.7486, -0.825}, // LTL
    Coordinate{-59.7961, 3.36889}, // LTM
    Coordinate{-0.368333, 51.8747}, // LTN
    Coordinate{-111.348, 25.9892}, // LTO
    Coordinate{1.6275, 50.5147}, // LTQ
    Coordinate{6.4816, 43.2054}, // LTT
    Coordinate{76.4642, 18.4117}, // LTU
    Coordinate{-76.55, 38.3153}, // LTW
    Coordinate{-78.6158, -0.906944}, // LTX
    Coordinate{-110.991, 48.5108}, // LTY
    Coordinate{86.7314, 27.6875}, // LUA
    Coordinate{-59.4333, 2.4}, // LUB
    Coordinate{-179.667, -16.7481}, // LUC
    Coordinate{15.2428, -26.6875}, // LUD
    Coordinate{8.91028, 46.0036}, // LUG
    Coordinate{75.9525, 30.8526}, // LUH
    Coordinate{-86.6925, 15.0333}, // LUI
    Coordinate{-84.4186, 39.1033}, // LUK
    Coordinate{-89.1728, 31.6731}, // LUL
    Coordinate{98.5478, 24.4}, // LUM
    Coordinate{28.4525, -15.3306}, // LUN
    Coordinate{19.8899, -11.7711}, // LUO
    Coordinate{-156.974, 21.2111}, // LUP
    Coordinate{-66.3522, -33.2772}, // LUQ
    Coordinate{-166.111, 68.875}, // LUR
    Coordinate{18.7167, -4.8}, // LUS
    Coordinate{144.45, -15.55}, // LUU
    Coordinate{132.759, -5.75917}, // LUV
    Coordinate{122.761, -1.03778}, // LUW
    Coordinate{6.20444, 49.6233}, // LUX
    Coordinate{22.6903, 51.2319}, // LUZ
    Coordinate{-0.74278, 48.0322}, // LVA
    Coordinate{-55.6247, -30.8358}, // LVB
    Coordinate{25.8186, -17.8217}, // LVI
    Coordinate{-121.82, 37.6934}, // LVK
    Coordinate{-110.448, 45.6994}, // LVM
    Coordinate{-93.2281, 44.6278}, // LVN
    Coordinate{122.423, -28.6136}, // LVO
    Coordinate{53.3561, 26.8103}, // LVP
    Coordinate{-55.9422, -13.0372}, // LVR
    Coordinate{-105.143, 35.6542}, // LVS
    Coordinate{-80.3994, 37.8583}, // LWB
    Coordinate{-95.2164, 39.0111}, // LWC
    Coordinate{122.237, -8.64056}, // LWE
    Coordinate{-1.24361, 60.1919}, // LWK
    Coordinate{-114.922, 41.1172}, // LWL
    Coordinate{-71.1233, 42.7172}, // LWM
    Coordinate{43.8592, 40.7503}, // LWN
    Coordinate{23.9561, 49.8125}, // LWO
    Coordinate{-117.015, 46.3744}, // LWS
    Coordinate{-109.467, 47.0492}, // LWT
    Coordinate{-87.6056, 38.7642}, // LWV
    Coordinate{115.403, 4.84917}, // LWY
    Coordinate{90.9119, 29.2978}, // LXA
    Coordinate{101.402, 20.9606}, // LXG
    Coordinate{-94.3475, 45.9497}, // LXL
    Coordinate{-99.7758, 40.7906}, // LXN
    Coordinate{32.7064, 25.6708}, // LXR
    Coordinate{25.2363, 39.9171}, // LXS
    Coordinate{23.25, -14.375}, // LXU
    Coordinate{-106.317, 39.2203}, // LXV
    Coordinate{112.388, 34.7413}, // LYA
    Coordinate{-80.1, 19.6667}, // LYB
    Coordinate{18.7161, 64.5481}, // LYC
    Coordinate{118.874, 34.5717}, // LYG
    Coordinate{-79.2011, 37.3253}, // LYH
    Coordinate{118.412, 35.0461}, // LYI
    Coordinate{1.01667, 51.0833}, // LYM
    Coordinate{4.93889, 45.7294}, // LYN
    Coordinate{72.9947, 31.365}, // LYP
    Coordinate{15.4656, 78.2461}, // LYR
    Coordinate{5.08111, 45.7256}, // LYS
    Coordinate{-91.8308, 47.8244}, // LYU
    Coordinate{0.939167, 50.9561}, // LYX
    Coordinate{22.4, -7.18333}, // LZA
    Coordinate{-102.22, 17.9833}, // LZC
    Coordinate{-71.9011, 41.8197}, // LZD
    Coordinate{109.391, 24.2075}, // LZH
    Coordinate{18.0493, -9.11596}, // LZM
    Coordinate{119.958, 26.1597}, // LZN
    Coordinate{105.391, 28.8528}, // LZO
    Coordinate{145.453, -14.6767}, // LZR
    Coordinate{-83.9625, 33.9781}, // LZU
    Coordinate{94.3353, 29.3033}, // LZY
    Coordinate{80.1636, 12.9822}, // MAA
    Coordinate{-49.1383, -5.36778}, // MAB
    Coordinate{-83.5619, 32.8222}, // MAC
    Coordinate{-3.56083, 40.4722}, // MAD
    Coordinate{-120.113, 36.9886}, // MAE
    Coordinate{-102.202, 31.9425}, // MAF
    Coordinate{145.783, -5.20833}, // MAG
    Coordinate{4.21861, 39.8625}, // MAH
    Coordinate{35.2625, -14.4889}, // MAI
    Coordinate{171.272, 7.06498}, // MAJ
    Coordinate{31.6522, 9.55889}, // MAK
    Coordinate{-74.3289, 44.8536}, // MAL
    Coordinate{-97.5253, 25.7699}, // MAM
    Coordinate{-2.275, 53.3539}, // MAN
    Coordinate{-60.0506, -3.04111}, // MAO
    Coordinate{98.5436, 16.6997}, // MAQ
    Coordinate{-71.7278, 10.5581}, // MAR
    Coordinate{147.424, -2.06194}, // MAS
    Coordinate{13.4384, -5.79833}, // MAT
    Coordinate{-152.243, -16.4264}, // MAU
    Coordinate{171.231, 8.705}, // MAV
    Coordinate{-89.9925, 36.5983}, // MAW
    Coordinate{-13.3228, 15.5936}, // MAX
    Coordinate{-77.6847, 24.2833}, // MAY
    Coordinate{-67.1485, 18.2557}, // MAZ
    Coordinate{39.5942, -4.03472}, // MBA
    Coordinate{11.9125, -1.89306}, // MBC
    Coordinate{25.5444, -25.8075}, // MBD
    Coordinate{143.404, 44.3042}, // MBE
    Coordinate{-100.406, 45.5464}, // MBG
    Coordinate{152.715, -25.5133}, // MBH
    Coordinate{33.4622, -8.91861}, // MBI
    Coordinate{-77.9133, 18.5036}, // MBJ
    Coordinate{-54.9528, -10.1703}, // MBK
    Coordinate{-86.2469, 44.2725}, // MBL
    Coordinate{120.605, 13.2051}, // MBO
    Coordinate{-76.9883, -6.01889}, // MBP
    Coordinate{30.6, -0.555}, // MBQ
    Coordinate{-84.0797, 43.5328}, // MBS
    Coordinate{123.627, 12.3671}, // MBT
    Coordinate{159.839, -9.7475}, // MBU
    Coordinate{145.102, -37.9758}, // MBW
    Coordinate{15.6861, 46.48}, // MBX
    Coordinate{125.117, 8.14056}, // MBY
    Coordinate{-57.7122, -3.35695}, // MBZ
    Coordinate{-9.467, 8.533}, // MCA
    Coordinate{-90.4719, 31.1783}, // MCB
    Coordinate{-121.401, 38.6678}, // MCC
    Coordinate{-84.6372, 45.865}, // MCD
    Coordinate{-120.514, 37.2847}, // MCE
    Coordinate{-155.606, 62.9528}, // MCG
    Coordinate{-79.9614, -3.26889}, // MCH
    Coordinate{-94.7139, 39.2975}, // MCI
    Coordinate{-72.4933, 11.2325}, // MCJ
    Coordinate{-100.592, 40.2064}, // MCK
    Coordinate{-148.911, 63.7325}, // MCL
    Coordinate{-83.6492, 32.6928}, // MCN
    Coordinate{-81.3089, 28.4294}, // MCO
    Coordinate{-51.0703, 0.05083}, // MCP
    Coordinate{20.79, 48.1378}, // MCQ
    Coordinate{-57.6403, -30.2719}, // MCS
    Coordinate{58.2817, 23.5928}, // MCT
    Coordinate{2.36278, 46.2261}, // MCU
    Coordinate{136.075, -16.445}, // MCV
    Coordinate{-93.3311, 43.1578}, // MCW
    Coordinate{47.6523, 42.8168}, // MCX
    Coordinate{153.091, -26.6033}, // MCY
    Coordinate{-35.7836, -9.51722}, // MCZ
    Coordinate{-88.3042, 17.0045}, // MDB
    Coordinate{124.926, 1.54917}, // MDC
    Coordinate{-102.101, 32.0367}, // MDD
    Coordinate{-75.4267, 6.16722}, // MDE
    Coordinate{-90.3008, 45.1014}, // MDF
    Coordinate{129.569, 44.5242}, // MDG
    Coordinate{-89.2519, 37.7781}, // MDH
    Coordinate{8.61389, 7.70361}, // MDI
    Coordinate{-121.155, 44.6703}, // MDJ
    Coordinate{18.2886, 0.0225}, // MDK
    Coordinate{95.9781, 21.7022}, // MDL
    Coordinate{-85.4647, 38.76}, // MDN
    Coordinate{-146.307, 59.4497}, // MDO
    Coordinate{-57.5733, -37.9342}, // MDQ
    Coordinate{-71.8025, 21.8258}, // MDS
    Coordinate{-76.7633, 40.1931}, // MDT
    Coordinate{143.657, -6.14774}, // MDU
    Coordinate{10.7556, 1.00694}, // MDV
    Coordinate{-87.7525, 41.7861}, // MDW
    Coordinate{-58.087, -29.2261}, // MDX
    Coordinate{-177.381, 28.2014}, // MDY
    Coordinate{-68.7928, -32.8317}, // MDZ
    Coordinate{-41.7639, -22.3458}, // MEA
    Coordinate{144.901, -37.7297}, // MEB
    Coordinate{-80.6786, -0.945833}, // MEC
    Coordinate{39.7058, 24.5503}, // MED
    Coordinate{168.038, -21.4814}, // MEE
    Coordinate{17.95, 11.05}, // MEF
    Coordinate{16.3124, -9.52492}, // MEG
    Coordinate{27.8264, 71.0289}, // MEH
    Coordinate{-88.7425, 32.3372}, // MEI
    Coordinate{-80.2147, 41.6267}, // MEJ
    Coordinate{144.843, -37.6733}, // MEL
    Coordinate{-89.9767, 35.0425}, // MEM
    Coordinate{3.52743, 44.5042}, // MEN
    Coordinate{-75.6956, 35.9189}, // MEO
    Coordinate{103.876, 2.3864}, // MEP
    Coordinate{96.2508, 4.04372}, // MEQ
    Coordinate{-120.568, 37.3806}, // MER
    Coordinate{-52.6022, -0.889722}, // MEU
    Coordinate{-119.752, 39.0008}, // MEV
    Coordinate{21.5417, -4.855}, // MEW
    Coordinate{-99.0719, 19.4361}, // MEX
    Coordinate{84.2289, 27.5772}, // MEY
    Coordinate{-94.2028, 34.5453}, // MEZ
    Coordinate{39.6683, -7.9175}, // MFA
    Coordinate{27.2433, -29.8289}, // MFC
    Coordinate{-82.5167, 40.8214}, // MFD
    Coordinate{-98.2386, 26.1758}, // MFE
    Coordinate{13.2694, -1.53778}, // MFF
    Coordinate{73.5086, 34.339}, // MFG
    Coordinate{-114.055, 36.835}, // MFH
    Coordinate{-90.1894, 44.6369}, // MFI
    Coordinate{179.951, -18.5669}, // MFJ
    Coordinate{120.003, 26.2239}, // MFK
    Coordinate{113.591, 22.1494}, // MFM
    Coordinate{167.923, -44.6733}, // MFN
    Coordinate{151.792, -5.5825}, // MFO
    Coordinate{7.1202, 13.5008}, // MFQ
    Coordinate{-122.874, 42.3742}, // MFR
    Coordinate{-71.9444, 1.35}, // MFS
    Coordinate{31.9333, -13.2667}, // MFU
    Coordinate{-75.7608, 37.6467}, // MFV
    Coordinate{6.5775, 45.4075}, // MFX
    Coordinate{-86.1681, 12.1414}, // MGA
    Coordinate{140.785, -37.7456}, // MGB
    Coordinate{-86.8211, 41.7033}, // MGC
    Coordinate{-64.1366, -13.3084}, // MGD
    Coordinate{-74.8461, 9.11807}, // MGE
    Coordinate{-52.0122, -23.4794}, // MGF
    Coordinate{-93.9856, 45.2361}, // MGG
    Coordinate{30.3431, -30.8594}, // MGH
    Coordinate{-58.2469, -34.1819}, // MGI
    Coordinate{-74.2647, 41.51}, // MGJ
    Coordinate{6.50444, 51.2303}, // MGL
    Coordinate{-86.3939, 32.3006}, // MGM
    Coordinate{-74.8667, 9.28333}, // MGN
    Coordinate{45.3047, 2.01361}, // MGQ
    Coordinate{-83.8033, 31.085}, // MGR
    Coordinate{134.894, -12.0944}, // MGT
    Coordinate{126.874, -18.6243}, // MGV
    Coordinate{-79.9164, 39.6428}, // MGW
    Coordinate{11, -2.43333}, // MGX
    Coordinate{-84.225, 39.5889}, // MGY
    Coordinate{98.6214, 12.4397}, // MGZ
    Coordinate{-59.1511, 5.26667}, // MHA
    Coordinate{-73.7158, -42.3404}, // MHC
    Coordinate{59.645, 36.2342}, // MHD
    Coordinate{-98.0386, 43.7747}, // MHE
    Coordinate{-77.0836, 26.5114}, // MHH
    Coordinate{43.2, 11.7167}, // MHI
    Coordinate{-96.6717, 39.1411}, // MHK
    Coordinate{-93.2028, 39.0956}, // MHL
    Coordinate{-152.302, 63.8861}, // MHM
    Coordinate{27.5397, 53.8644}, // MHP
    Coordinate{19.8964, 60.1219}, // MHQ
    Coordinate{-121.298, 38.5539}, // MHR
    Coordinate{-122.272, 41.2631}, // MHS
    Coordinate{-71.4372, 42.9278}, // MHT
    Coordinate{147.334, -37.0475}, // MHU
    Coordinate{-118.152, 35.0594}, // MHV
    Coordinate{-63.9624, -19.8238}, // MHW
    Coordinate{-161, -10.3806}, // MHX
    Coordinate{-80.2906, 25.7933}, // MIA
    Coordinate{-93.3539, 45.0619}, // MIC
    Coordinate{-89.6578, 20.9369}, // MID
    Coordinate{-85.3958, 40.2422}, // MIE
    Coordinate{104.74, 31.43}, // MIG
    Coordinate{-49.9269, -22.1956}, // MII
    Coordinate{171.731, 6.085}, // MIJ
    Coordinate{27.2, 61.6864}, // MIK
    Coordinate{149.901, -36.9086}, // MIM
    Coordinate{-94.8875, 36.9092}, // MIO
    Coordinate{34.8067, 30.6522}, // MIP
    Coordinate{-96.1122, 41.1961}, // MIQ
    Coordinate{10.7547, 35.7581}, // MIR
    Coordinate{152.838, -10.6891}, // MIS
    Coordinate{-119.192, 35.5058}, // MIT
    Coordinate{13.0808, 11.8553}, // MIU
    Coordinate{-75.0722, 39.3678}, // MIV
    Coordinate{44.3167, -21.4167}, // MJA
    Coordinate{170.869, 10.2833}, // MJB
    Coordinate{-7.58722, 7.26667}, // MJC
    Coordinate{68.1431, 27.3352}, // MJD
    Coordinate{168.264, 7.76222}, // MJE
    Coordinate{13.2149, 65.7836}, // MJF
    Coordinate{13.2778, 32.8944}, // MJI
    Coordinate{113.577, -25.8933}, // MJK
    Coordinate{11.0578, -1.85}, // MJL
    Coordinate{23.5667, -6.12111}, // MJM
    Coordinate{46.3511, -15.6669}, // MJN
    Coordinate{16.4528, -21.0231}, // MJO
    Coordinate{116.14, -34.2653}, // MJP
    Coordinate{-94.9867, 43.65}, // MJQ
    Coordinate{-57.871, -38.2258}, // MJR
    Coordinate{26.5979, 39.0567}, // MJT
    Coordinate{119.03, -2.58673}, // MJU
    Coordinate{-0.812222, 37.7747}, // MJV
    Coordinate{-74.2925, 39.9275}, // MJX
    Coordinate{114.022, 62.5344}, // MJZ
    Coordinate{12.7166, 49.9228}, // MKA
    Coordinate{13.9681, 0.977778}, // MKB
    Coordinate{-94.5928, 39.1233}, // MKC
    Coordinate{-87.8967, 42.9472}, // MKE
    Coordinate{126.581, 5.56222}, // MKF
    Coordinate{-86.2356, 43.1678}, // MKG
    Coordinate{29.0722, -29.2817}, // MKH
    Coordinate{26.4833, 5.4}, // MKI
    Coordinate{15.5821, -0.019055}, // MKJ
    Coordinate{-157.096, 21.1528}, // MKK
    Coordinate{-88.9156, 35.5997}, // MKL
    Coordinate{112.064, 2.89985}, // MKM
    Coordinate{-98.5992, 31.9203}, // MKN
    Coordinate{-95.3617, 35.6578}, // MKO
    Coordinate{140.418, -8.52028}, // MKQ
    Coordinate{118.548, -26.6117}, // MKR
    Coordinate{38.7414, 10.7244}, // MKS
    Coordinate{-93.9186, 44.2217}, // MKT
    Coordinate{12.8908, 0.579167}, // MKU
    Coordinate{134.049, -0.891667}, // MKW
    Coordinate{149.18, -21.1717}, // MKY
    Coordinate{102.251, 2.26333}, // MKZ
    Coordinate{14.4775, 35.8575}, // MLA
    Coordinate{-80.6453, 28.1028}, // MLB
    Coordinate{-95.7833, 34.8825}, // MLC
    Coordinate{73.5291, 4.19183}, // MLE
    Coordinate{112.714, -7.92639}, // MLG
    Coordinate{7.52917, 47.59}, // EAP
    Coordinate{-90.5075, 41.4486}, // MLI
    Coordinate{-83.2414, 33.1542}, // MLJ
    Coordinate{-107.919, 48.3669}, // MLK
    Coordinate{-162.026, 61.8642}, // MLL
    Coordinate{-101.025, 19.8497}, // MLM
    Coordinate{-2.95639, 35.2797}, // MLN
    Coordinate{24.475, 36.6961}, // MLO
    Coordinate{124.056, 7.61667}, // MLP
    Coordinate{-105.886, 46.4281}, // MLS
    Coordinate{-68.6856, 45.6478}, // MLT
    Coordinate{-92.0377, 32.5109}, // MLU
    Coordinate{-10.7586, 6.28917}, // MLW
    Coordinate{-150.644, 64.9975}, // MLY
    Coordinate{-54.2217, -32.3425}, // MLZ
    Coordinate{13.0597, 55.605}, // MMA
    Coordinate{144.164, 43.8806}, // MMB
    Coordinate{-99.0181, 22.7403}, // MMC
    Coordinate{131.264, 25.8467}, // MMD
    Coordinate{-1.42944, 54.5092}, // MME
    Coordinate{9.30361, 5.70417}, // MMF
    Coordinate{117.842, -28.1161}, // MMG
    Coordinate{-118.839, 37.6242}, // MMH
    Coordinate{-84.5625, 35.3972}, // MMI
    Coordinate{137.923, 36.1667}, // MMJ
    Coordinate{32.7559, 68.7838}, // MMK
    Coordinate{-95.8219, 44.4505}, // MML
    Coordinate{148.705, -22.8033}, // MMM
    Coordinate{-71.5178, 42.4606}, // MMN
    Coordinate{-23.2136, 15.1558}, // MMO
    Coordinate{-74.4383, 9.25972}, // MMP
    Coordinate{31.3333, -8.85833}, // MMQ
    Coordinate{-80.8011, 33.9208}, // MMT
    Coordinate{-74.415, 40.7994}, // MMU
    Coordinate{-123.136, 45.1944}, // MMV
    Coordinate{13.3714, 55.53}, // MMX
    Coordinate{125.295, 24.7828}, // MMY
    Coordinate{64.7609, 35.9307}, // MMZ
    Coordinate{126.673, 4.00694}, // MNA
    Coordinate{12.35, -5.93333}, // MNB
    Coordinate{40.7122, -14.4881}, // MNC
    Coordinate{177.098, -17.6731}, // MNF
    Coordinate{134.234, -12.0561}, // MNG
    Coordinate{57.4889, 23.6389}, // MNH
    Coordinate{-62.1933, 16.7914}, // MNI
    Coordinate{48.3556, -21.2061}, // MNJ
    Coordinate{173.031, 1.00359}, // MNK
    Coordinate{121.019, 14.5086}, // MNL
    Coordinate{-87.6383, 45.1267}, // MNM
    Coordinate{-83.0633, 40.6161}, // MNN
    Coordinate{151.1, -24.8867}, // MNQ
    Coordinate{23.1528, -15.2544}, // MNR
    Coordinate{28.857, -11.1381}, // MNS
    Coordinate{-149.369, 65.1481}, // MNT
    Coordinate{97.6572, 16.4405}, // MNU
    Coordinate{-84.3803, 35.5453}, // MNV
    Coordinate{-61.2839, -5.81695}, // MNX
    Coordinate{155.565, -7.41611}, // MNY
    Coordinate{-77.5156, 38.7214}, // MNZ
    Coordinate{-74.9222, 20.6539}, // MOA
    Coordinate{-88.2428, 30.6914}, // MOB
    Coordinate{-43.8219, -16.7061}, // MOC
    Coordinate{-120.954, 37.6258}, // MOD
    Coordinate{96.6531, 23.0919}, // MOE
    Coordinate{120.833, -8.64056}, // MOF
    Coordinate{99.2567, 20.5167}, // MOG
    Coordinate{-157.703, -19.8427}, // MOI
    Coordinate{-54.4003, 5.6076}, // MOJ
    Coordinate{7.2625, 62.7447}, // MOL
    Coordinate{-12.5, 17.75}, // MOM
    Coordinate{170.128, -43.9067}, // MON
    Coordinate{140.197, -28.1}, // MOO
    Coordinate{-84.7375, 43.6217}, // MOP
    Coordinate{44.3174, -20.2848}, // MOQ
    Coordinate{-83.3756, 36.1794}, // MOR
    Coordinate{-162.057, 64.6981}, // MOS
    Coordinate{-101.28, 48.2594}, // MOT
    Coordinate{-163.682, 62.0953}, // MOU
    Coordinate{148.077, -22.0578}, // MOV
    Coordinate{-149.762, -17.4894}, // MOZ
    Coordinate{24.1764, -17.6342}, // MPA
    Coordinate{-80.1703, 25.7783}, // MPB
    Coordinate{69.0333, 25.6836}, // MPD
    Coordinate{-72.5497, 41.2711}, // MPE
    Coordinate{-80.7358, 39.8808}, // MPG
    Coordinate{121.955, 11.9247}, // MPH
    Coordinate{-92.9092, 35.1389}, // MPJ
    Coordinate{126.38, 34.7589}, // MPK
    Coordinate{3.95929, 43.5789}, // MPL
    Coordinate{32.5725, -25.9208}, // MPM
    Coordinate{-75.38, 41.1378}, // MPO
    Coordinate{-77.7331, 8.94528}, // MPP
    Coordinate{-94.9617, 33.0969}, // MPS
    Coordinate{-72.5622, 44.2036}, // MPV
    Coordinate{37.4564, 47.0725}, // MPW
    Coordinate{-54.0394, 3.65556}, // MPY
    Coordinate{-91.5111, 40.9467}, // MPZ
    Coordinate{-90.6525, 40.52}, // MQB
    Coordinate{-56.3844, 47.0958}, // MQC
    Coordinate{-68.7333, -41.25}, // MQD
    Coordinate{58.7567, 53.3933}, // MQF
    Coordinate{-48.2006, -13.5506}, // MQH
    Coordinate{143.263, 66.45}, // MQJ
    Coordinate{-58.4015, -16.3379}, // MQK
    Coordinate{142.086, -34.2292}, // MQL
    Coordinate{40.6317, 37.2233}, // MQM
    Coordinate{14.3017, 66.3639}, // MQN
    Coordinate{31.0993, -25.3916}, // MQP
    Coordinate{16.0714, 8.62417}, // MQQ
    Coordinate{-61.1803, 12.8877}, // MQS
    Coordinate{-87.3953, 46.3536}, // MQT
    Coordinate{-74.8837, 5.2125}, // MQU
    Coordinate{0.148997, 35.9089}, // MQV
    Coordinate{-82.8794, 32.0969}, // MQW
    Coordinate{39.5333, 13.4672}, // MQX
    Coordinate{-86.52, 36.0089}, // MQY
    Coordinate{115.099, -33.9304}, // MQZ
    Coordinate{15.0597, 32.3256}, // MRA
    Coordinate{-77.9847, 39.4019}, // MRB
    Coordinate{-87.1792, 35.5544}, // MRC
    Coordinate{-71.1611, 8.58222}, // MRD
    Coordinate{35.0081, -1.40611}, // MRE
    Coordinate{-104.018, 30.3711}, // MRF
    Coordinate{145.419, -17.0692}, // MRG
    Coordinate{-76.6606, 34.7336}, // MRH
    Coordinate{-149.844, 61.2136}, // MRI
    Coordinate{-88.0333, 14.15}, // MRJ
    Coordinate{-81.6725, 25.995}, // MRK
    Coordinate{-81.6114, 35.8203}, // MRN
    Coordinate{175.633, -40.975}, // MRO
    Coordinate{121.825, 13.36}, // MRQ
    Coordinate{-79.9408, -4.37806}, // MRR
    Coordinate{5.215, 43.4367}, // MRS
    Coordinate{-83.3517, 40.2247}, // MRT
    Coordinate{57.683, -20.43}, // MRU
    Coordinate{43.0833, 44.225}, // MRV
    Coordinate{11.44, 54.6993}, // MRW
    Coordinate{49.1506, 30.5562}, // MRX
    Coordinate{-121.843, 36.5869}, // MRY
    Coordinate{149.845, -29.4989}, // MRZ
    Coordinate{-91.7628, 53.4414}, // MSA
    Coordinate{-111.728, 33.4608}, // MSC
    Coordinate{-111.476, 39.5267}, // MSD
    Coordinate{1.34611, 51.3422}, // MSE
    Coordinate{134.917, -22.6667}, // MSF
    Coordinate{28.8092, -29.8136}, // MSG
    Coordinate{141.372, 40.7053}, // MSJ
    Coordinate{-87.6103, 34.7453}, // MSL
    Coordinate{17.85, -4.78333}, // MSM
    Coordinate{124.783, 10.1871}, // MSN
    Coordinate{-114.091, 46.9164}, // MSO
    Coordinate{-93.2217, 44.8819}, // MSP
    Coordinate{28.0325, 53.8825}, // MSQ
    Coordinate{-74.8456, 44.9358}, // MSS
    Coordinate{5.76954, 50.9126}, // MST
    Coordinate{27.5525, -29.4622}, // MSU
    Coordinate{-74.795, 41.7017}, // MSV
    Coordinate{39.368, 15.6711}, // MSW
    Coordinate{12.7, -2.95}, // MSX
    Coordinate{-90.2581, 29.9933}, // MSY
    Coordinate{12.1667, -15.2167}, // MSZ
    Coordinate{175.74, -37.7344}, // MTA
    Coordinate{-75.4325, 7.97167}, // MTB
    Coordinate{35.5333, 6.96667}, // MTF
    Coordinate{-59.9672, -15.0153}, // MTG
    Coordinate{-81.0514, 24.7261}, // MTH
    Coordinate{-24.34, 15.045}, // MTI
    Coordinate{-107.894, 38.5098}, // MTJ
    Coordinate{172.992, 3.37411}, // MTK
    Coordinate{151.488, -32.7033}, // MTL
    Coordinate{-131.578, 55.1311}, // MTM
    Coordinate{-76.4139, 39.3256}, // MTN
    Coordinate{-88.2792, 39.4781}, // MTO
    Coordinate{-71.9206, 41.0767}, // MTP
    Coordinate{147.937, -26.4833}, // MTQ
    Coordinate{-75.8258, 8.82361}, // MTR
    Coordinate{31.3078, -26.5286}, // MTS
    Coordinate{-94.5808, 18.1036}, // MTT
    Coordinate{167.711, -13.6658}, // MTV
    Coordinate{-87.6806, 44.1289}, // MTW
    Coordinate{-100.106, 25.7783}, // MTY
    Coordinate{35.3886, 31.3282}, // MTZ
    Coordinate{157.263, -8.32797}, // MUA
    Coordinate{23.4281, -19.9725}, // MUB
    Coordinate{11.7861, 48.3539}, // MUC
    Coordinate{39.5631, -11.6729}, // MUD
    Coordinate{-155.668, 20.0014}, // MUE
    Coordinate{-111.971, 26.9058}, // MUG
    Coordinate{27.2217, 31.3253}, // MUH
    Coordinate{35.7486, 5.86389}, // MUJ
    Coordinate{-83.7042, 31.1378}, // MUL
    Coordinate{-63.1533, 9.74917}, // MUN
    Coordinate{114.322, 4.1775}, // MUR
    Coordinate{153.979, 24.2897}, // MUS
    Coordinate{-91.1483, 41.3678}, // MUT
    Coordinate{0.147142, 35.2077}, // MUW
    Coordinate{71.4192, 30.2033}, // MUX
    Coordinate{13.9167, -4.01472}, // MUY
    Coordinate{33.8022, -1.50278}, // MUZ
    Coordinate{-16.9181, 65.6558}, // MVA
    Coordinate{13.4347, -1.65611}, // MVB
    Coordinate{-87.3511, 31.4581}, // MVC
    Coordinate{-56.0308, -34.8383}, // MVD
    Coordinate{-95.712, 44.9714}, // MVE
    Coordinate{-37.3617, -5.19583}, // MVF
    Coordinate{-72.6139, 44.5347}, // MVL
    Coordinate{-110.228, 36.7164}, // MVM
    Coordinate{-88.8586, 38.3233}, // MVN
    Coordinate{18.6775, 12.1719}, // MVO
    Coordinate{-70.2341, 1.25353}, // MVP
    Coordinate{30.095, 53.955}, // MVQ
    Coordinate{14.2531, 10.4514}, // MVR
    Coordinate{-39.8642, -18.0494}, // MVS
    Coordinate{6.64999, 45.8223}, // MVV
    Coordinate{-122.421, 48.4708}, // MVW
    Coordinate{12.1167, 2.15}, // MVX
    Coordinate{-70.6144, 41.3931}, // MVY
    Coordinate{30.8589, -20.0619}, // MVZ
    Coordinate{-89.0111, 37.755}, // MWA
    Coordinate{116.022, -29.2014}, // MWB
    Coordinate{-88.0344, 43.1103}, // MWC
    Coordinate{31.8187, 18.45}, // MWE
    Coordinate{168.079, -14.9944}, // MWF
    Coordinate{-119.319, 47.2086}, // MWH
    Coordinate{106.258, 3.34812}, // MWK
    Coordinate{-98.0603, 32.7817}, // MWL
    Coordinate{33.6167, -3.5}, // MWN
    Coordinate{-84.3964, 39.5317}, // MWO
    Coordinate{94.9729, 20.1579}, // MWQ
    Coordinate{107.187, 12.4606}, // MWV
    Coordinate{126.383, 34.9914}, // MWX
    Coordinate{32.9325, -2.44444}, // MWZ
    Coordinate{-90.1544, 35.8944}, // MXA
    Coordinate{120.331, -2.55972}, // MXB
    Coordinate{-109.341, 37.9325}, // MXC
    Coordinate{-79.3658, 34.7919}, // MXE
    Coordinate{-71.509, 42.3432}, // MXG
    Coordinate{143.238, -6.36333}, // MXH
    Coordinate{126.216, 6.95028}, // MXI
    Coordinate{6.46222, 9.65194}, // MXJ
    Coordinate{-115.248, 32.6296}, // MXL
    Coordinate{43.3667, -21.7539}, // MXM
    Coordinate{-3.81667, 48.6008}, // MXN
    Coordinate{-91.1633, 42.2203}, // MXO
    Coordinate{8.72306, 45.63}, // MXP
    Coordinate{16.5006, 13.6441}, // MXR
    Coordinate{-172.258, -13.7422}, // MXS
    Coordinate{44.0322, -18.0508}, // MXT
    Coordinate{115.518, -28.4739}, // MXU
    Coordinate{100.099, 49.6631}, // MXV
    Coordinate{106.283, 45.7667}, // MXW
    Coordinate{14.5111, 60.9586}, // MXX
    Coordinate{-142.904, 61.4369}, // MXY
    Coordinate{116.133, 24.35}, // MXZ
    Coordinate{150.144, -35.8978}, // MYA
    Coordinate{10.6764, -3.45833}, // MYB
    Coordinate{16.1633, 11.4134}, // MYC
    Coordinate{40.1005, -3.22917}, // MYD
    Coordinate{139.56, 34.0736}, // MYE
    Coordinate{-117.139, 32.8158}, // MYF
    Coordinate{-73.0333, 22.3794}, // MYG
    Coordinate{-111.644, 36.8113}, // MYH
    Coordinate{144.054, -9.91667}, // MYI
    Coordinate{132.7, 33.8272}, // MYJ
    Coordinate{-142.687, 61.3356}, // MYK
    Coordinate{-116.102, 44.8886}, // MYL
    Coordinate{-59.6833, 4.48333}, // MYM
    Coordinate{45.3269, 15.4692}, // MYN
    Coordinate{61.8967, 37.6067}, // MYP
    Coordinate{76.6583, 12.2292}, // MYQ
    Coordinate{-78.9311, 33.6797}, // MYR
    Coordinate{97.3519, 25.3836}, // MYT
    Coordinate{-166.271, 60.3714}, // MYU
    Coordinate{-121.57, 39.0978}, // MYV
    Coordinate{40.1819, -10.3361}, // MYW
    Coordinate{-77.7884, 25.402}, // MYX
    Coordinate{113.987, 4.32194}, // MYY
    Coordinate{34.9167, -14.1}, // MYZ
    Coordinate{-74.5358, -11.3257}, // MZA
    Coordinate{40.35, -11.3617}, // MZB
    Coordinate{11.5528, 0.777778}, // MZC
    Coordinate{-89.0238, 17.2784}, // MZE
    Coordinate{-4.08417, 14.5086}, // MZI
    Coordinate{-111.325, 32.5097}, // MZJ
    Coordinate{173.267, 2.05028}, // MZK
    Coordinate{-75.4624, 5.02984}, // MZL
    Coordinate{-77.0867, 20.2889}, // MZO
    Coordinate{172.994, -41.1233}, // MZP
    Coordinate{67.2091, 36.7069}, // MZR
    Coordinate{-106.266, 23.1614}, // MZT
    Coordinate{85.3136, 26.1192}, // MZU
    Coordinate{114.809, 4.05047}, // MZV
    Coordinate{-0.256226, 33.5318}, // MZW
    Coordinate{-85.6797, 40.49}, // MZZ
    Coordinate{149.827, -30.3192}, // NAA
    Coordinate{140.725, -36.985}, // NAC
    Coordinate{1.36667, 10.3833}, // NAE
    Coordinate{79.0472, 21.0925}, // NAG
    Coordinate{125.528, 3.68306}, // NAH
    Coordinate{-59.1242, 3.95944}, // NAI
    Coordinate{45.4583, 39.1886}, // NAJ
    Coordinate{102.083, 14.9333}, // NAK
    Coordinate{43.6383, 43.5133}, // NAL
    Coordinate{127.083, -3.25}, // NAM
    Coordinate{177.443, -17.7553}, // NAN
    Coordinate{106.16, 30.7939}, // NAO
    Coordinate{14.2908, 40.8844}, // NAP
    Coordinate{-69.3886, 77.4886}, // NAQ
    Coordinate{-74.5906, 6.21002}, // NAR
    Coordinate{-77.4661, 25.0389}, // NAS
    Coordinate{-35.3664, -5.76889}, // NAT
    Coordinate{-141.267, -14.1767}, // NAU
    Coordinate{34.5264, 38.7764}, // NAV
    Coordinate{101.743, 6.52}, // NAW
    Coordinate{116.388, 39.7825}, // NAY
    Coordinate{-69.8, 3.48333}, // NBB
    Coordinate{52.095, 55.5633}, // NBC
    Coordinate{10.4386, 36.0758}, // NBE
    Coordinate{-78.1389, 9.25028}, // NBL
    Coordinate{5.62194, -1.41028}, // NBN
    Coordinate{36.9275, -1.31917}, // NBO
    Coordinate{127.549, 42.0881}, // NBS
    Coordinate{-75.2069, 19.9064}, // NBW
    Coordinate{135.496, -3.37028}, // NBX
    Coordinate{-71.9394, 21.9175}, // NCA
    Coordinate{7.215, 43.6653}, // NCE
    Coordinate{-107.883, 30.4}, // NCG
    Coordinate{38.78, -10.3583}, // NCH
    Coordinate{-76.7778, 8.45139}, // NCI
    Coordinate{-61.5289, -30.9572}, // NCJ
    Coordinate{-1.69167, 55.0375}, // NCL
    Coordinate{-147.992, 60.0772}, // NCN
    Coordinate{-84.7656, 11.1331}, // NCR
    Coordinate{29.9764, -27.7729}, // NCS
    Coordinate{-85.4456, 10.1394}, // NCT
    Coordinate{59.6233, 42.4883}, // NCU
    Coordinate{6.10639, 45.9308}, // NCY
    Coordinate{129.904, -4.52167}, // NDA
    Coordinate{-17.0311, 20.9283}, // NDB
    Coordinate{77.3186, 19.1819}, // NDC
    Coordinate{13.8478, -11.168}, // NDD
    Coordinate{41.8444, 3.93396}, // NDE
    Coordinate{14.9833, -9.28056}, // NDF
    Coordinate{123.918, 47.2397}, // NDG
    Coordinate{15.0247, 12.125}, // NDJ
    Coordinate{168.126, 5.63306}, // NDK
    Coordinate{20.6344, 8.43}, // NDL
    Coordinate{-3.02821, 34.9888}, // NDR
    Coordinate{19.7194, -17.9564}, // NDU
    Coordinate{-2.57667, 59.2503}, // NDY
    Coordinate{-58.8172, -38.4833}, // NEC
    Coordinate{54.3483, 56.11}, // NEF
    Coordinate{-78.3356, 18.34}, // NEG
    Coordinate{35.4667, 9.52222}, // NEJ
    Coordinate{36.6, 9.05}, // NEK
    Coordinate{124.912, 56.9133}, // NER
    Coordinate{-62.59, 17.2056}, // NEV
    Coordinate{72.65, 61.1083}, // NFG
    Coordinate{-175.631, -15.5711}, // NFO
    Coordinate{148.248, -34.2556}, // NGA
    Coordinate{121.462, 29.8267}, // NGB
    Coordinate{-64.3281, 18.7275}, // NGD
    Coordinate{13.5592, 7.35694}, // NGE
    Coordinate{179.34, -18.1156}, // NGI
    Coordinate{143.142, 51.7839}, // NGK
    Coordinate{136.805, 34.8583}, // NGO
    Coordinate{80.0443, 32.1142}, // NGQ
    Coordinate{129.914, 32.9169}, // NGS
    Coordinate{-97.6125, 28.6117}, // NGT
    Coordinate{84, 28.6333}, // NGX
    Coordinate{35.7278, 15.3556}, // NHF
    Coordinate{-69.9389, 43.8922}, // NHZ
    Coordinate{-8.60013, 7.5}, // NIA
    Coordinate{-154.358, 63.0186}, // NIB
    Coordinate{33.2772, 35.15}, // NIC
    Coordinate{121.595, -21.6737}, // NIF
    Coordinate{176.409, -1.31667}, // NIG
    Coordinate{-12.7264, 13.0542}, // NIK
    Coordinate{2.17028, 13.4817}, // NIM
    Coordinate{17.6847, -2.7175}, // NIO
    Coordinate{-0.394445, 46.3133}, // NIT
    Coordinate{-146.37, -16.1194}, // NIU
    Coordinate{-9.58333, 15.2333}, // NIX
    Coordinate{76.4817, 60.9483}, // NJC
    Coordinate{44.4043, 31.9899}, // NJF
    Coordinate{-15.9697, 18.31}, // NKC
    Coordinate{118.862, 31.7422}, // NKG
    Coordinate{14.8167, -5.42083}, // NKL
    Coordinate{136.924, 35.255}, // NKM
    Coordinate{9.93333, 4.95}, // NKS
    Coordinate{42.06, 37.3639}, // NKT
    Coordinate{28.1969, -30.0217}, // NKU
    Coordinate{13.2833, -4.21667}, // NKY
    Coordinate{28.66, -13}, // NLA
    Coordinate{-99.5706, 27.4434}, // NLD
    Coordinate{-86.2259, 41.8407}, // NLE
    Coordinate{143.78, -9.57833}, // NLF
    Coordinate{-161.16, 56.0075}, // NLG
    Coordinate{100.757, 27.5438}, // NLH
    Coordinate{140.655, 53.1539}, // NLI
    Coordinate{167.938, -29.0425}, // NLK
    Coordinate{-123.927, 40.7192}, // NLN
    Coordinate{15.3272, -4.32667}, // NLO
    Coordinate{30.9118, -25.5022}, // NLP
    Coordinate{83.3803, 43.4331}, // NLT
    Coordinate{31.9208, 47.0581}, // NLV
    Coordinate{71.5567, 40.9844}, // NMA
    Coordinate{72.8432, 20.4344}, // NMB
    Coordinate{-76.8203, 24.5942}, // NMC
    Coordinate{-164.701, 60.4711}, // NME
    Coordinate{-78.9333, 8.45694}, // NMG
    Coordinate{-111.574, 57.0556}, // NML
    Coordinate{97.7369, 20.8856}, // NMS
    Coordinate{-6.61667, 34.25}, // NNA
    Coordinate{162.454, -10.8481}, // NNB
    Coordinate{108.172, 22.6083}, // NNG
    Coordinate{16.925, -18.8111}, // NNI
    Coordinate{-157.02, 58.7328}, // NNK
    Coordinate{-154.839, 59.9803}, // NNL
    Coordinate{53.125, 67.64}, // NNM
    Coordinate{30.385, 50.4783}, // NNN
    Coordinate{-9.46778, 53.2305}, // NNR
    Coordinate{100.783, 18.8078}, // NNT
    Coordinate{-40.3339, -17.8172}, // NNU
    Coordinate{117.667, 4.13667}, // NNX
    Coordinate{112.615, 32.9808}, // NNY
    Coordinate{-85.6531, 9.96667}, // NOB
    Coordinate{-8.81861, 53.9103}, // NOC
    Coordinate{7.18889, 53.6331}, // NOD
    Coordinate{-110.977, 31.2261}, // NOG
    Coordinate{75.27, 63.1833}, // NOJ
    Coordinate{-52.3492, -14.6973}, // NOK
    Coordinate{174.428, -0.639667}, // NON
    Coordinate{35.0664, 42.0158}, // NOP
    Coordinate{-13.7464, 65.1319}, // NOR
    Coordinate{48.3147, -13.3119}, // NOS
    Coordinate{-122.556, 38.1436}, // NOT
    Coordinate{166.216, -22.0164}, // NOU
    Coordinate{15.7606, -12.8089}, // NOV
    Coordinate{86.8783, 53.81}, // NOZ
    Coordinate{176.87, -39.4683}, // NPE
    Coordinate{174.179, -39.0086}, // NPL
    Coordinate{111.473, 0.06362}, // NPO
    Coordinate{-55.4008, -7.12583}, // NPR
    Coordinate{-71.2817, 41.5325}, // NPT
    Coordinate{-89.8703, 35.3567}, // NQA
    Coordinate{-48.4919, -14.4364}, // NQL
    Coordinate{-68.1558, -38.9489}, // NQN
    Coordinate{-77.2833, 5.7}, // NQU
    Coordinate{-4.99528, 50.4408}, // NQY
    Coordinate{146.512, -34.7022}, // NRA
    Coordinate{-121.109, 37.4081}, // NRC
    Coordinate{7.23008, 53.7069}, // NRD
    Coordinate{126.7, -3.85583}, // NRE
    Coordinate{117.08, -32.93}, // NRG
    Coordinate{-94.8619, 36.5775}, // NRI
    Coordinate{16.2317, 58.5861}, // NRK
    Coordinate{-2.43444, 59.3675}, // NRL
    Coordinate{-7.26667, 15.2287}, // NRM
    Coordinate{6.14194, 51.6014}, // NRN
    Coordinate{-65.6433, 18.2453}, // NRR
    Coordinate{140.388, 35.7649}, // NRT
    Coordinate{-79.25, 25.7669}, // NSB
    Coordinate{51.4647, 36.6633}, // NSH
    Coordinate{11.5533, 3.7225}, // NSI
    Coordinate{87.3333, 69.31}, // NSK
    Coordinate{121.754, -32.2114}, // NSM
    Coordinate{173.221, -41.2983}, // NSN
    Coordinate{150.832, -32.0372}, // NSO
    Coordinate{99.9447, 8.53944}, // NST
    Coordinate{9.21222, 59.5656}, // NTB
    Coordinate{-1.60778, 47.1569}, // NTE
    Coordinate{120.976, 32.0708}, // NTG
    Coordinate{141.07, -17.685}, // NTN
    Coordinate{136.962, 37.2933}, // NTQ
    Coordinate{-100.237, 25.8656}, // NTR
    Coordinate{-173.755, -15.9767}, // NTT
    Coordinate{108.388, 3.90871}, // NTX
    Coordinate{27.1716, -25.3355}, // NTY
    Coordinate{135.717, -14.2717}, // NUB
    Coordinate{28.333, 12.6667}, // NUD
    Coordinate{11.0781, 49.4986}, // NUE
    Coordinate{-151.006, 70.21}, // NUI
    Coordinate{-138.772, -19.285}, // NUK
    Coordinate{-158.074, 64.7294}, // NUL
    Coordinate{-87.3381, 30.4697}, // NUN
    Coordinate{-162.439, 60.9058}, // NUP
    Coordinate{-122.048, 37.415}, // NUQ
    Coordinate{167.401, -16.0797}, // NUS
    Coordinate{36.1508, -0.302778}, // NUU
    Coordinate{76.5217, 66.07}, // NUX
    Coordinate{-75.2939, 2.95}, // NVA
    Coordinate{-84.4547, 11.6667}, // NVG
    Coordinate{65.175, 40.1178}, // NVI
    Coordinate{-109.416, 26.9903}, // NVJ
    Coordinate{17.3867, 68.4369}, // NVK
    Coordinate{-120.353, 39.8186}, // NVN
    Coordinate{31.2417, 58.4933}, // NVR
    Coordinate{3.11083, 47.0036}, // NVS
    Coordinate{-48.6514, -26.88}, // NVT
    Coordinate{43.7618, -12.2981}, // NWA
    Coordinate{-72.1893, 43.3881}, // NWH
    Coordinate{1.28278, 52.6758}, // NWI
    Coordinate{-116.162, 34.2961}, // NXP
    Coordinate{65.615, 62.11}, // NYA
    Coordinate{36.9667, -0.371389}, // NYE
    Coordinate{-2.32861, 7.36167}, // NYI
    Coordinate{37.0342, -0.069444}, // NYK
    Coordinate{72.7033, 65.48}, // NYM
    Coordinate{147.203, -31.5517}, // NYN
    Coordinate{16.9122, 58.7886}, // NYO
    Coordinate{118.333, 63.2931}, // NYR
    Coordinate{96.1999, 19.6191}, // NYT
    Coordinate{94.9303, 21.1789}, // NYU
    Coordinate{21.3579, -7.71694}, // NZA
    Coordinate{-74.9618, -14.8542}, // NZC
    Coordinate{-8.7026, 7.8132}, // NZE
    Coordinate{117.33, 49.5667}, // NZH
    Coordinate{172.105, -41.25}, // NZK
    Coordinate{122.768, 47.8658}, // NZL
    Coordinate{149.133, -33.3817}, // OAG
    Coordinate{-77.6122, 34.8292}, // OAJ
    Coordinate{-122.221, 37.7214}, // OAK
    Coordinate{-61.4508, -11.4956}, // OAL
    Coordinate{171.082, -44.97}, // OAM
    Coordinate{-86.5764, 15.5069}, // OAN
    Coordinate{-121.762, 36.6814}, // OAR
    Coordinate{68.8386, 33.126}, // OAS
    Coordinate{-96.7267, 17}, // OAX
    Coordinate{43.2786, 11.9683}, // OBC
    Coordinate{-80.8511, 27.266}, // OBE
    Coordinate{11.2831, 48.0814}, // OBF
    Coordinate{-55.9467, 2.22417}, // OBI
    Coordinate{-5.4, 56.4636}, // OBN
    Coordinate{143.217, 42.7333}, // OBO
    Coordinate{4.36917, 44.5394}, // OBS
    Coordinate{-156.897, 66.9122}, // OBU
    Coordinate{141.324, -7.59053}, // OBX
    Coordinate{-80.2783, 25.3203}, // OCA
    Coordinate{-76.9867, -0.462778}, // OCC
    Coordinate{-75.1239, 38.3106}, // OCE
    Coordinate{-82.2242, 29.1725}, // OCF
    Coordinate{-76.9753, 18.4006}, // OCJ
    Coordinate{117.275, -22.5397}, // OCM
    Coordinate{-117.351, 33.2181}, // OCN
    Coordinate{9.33056, 0.916667}, // OCS
    Coordinate{-73.3581, 8.315}, // OCV
    Coordinate{22.4, 8.01667}, // ODA
    Coordinate{-4.84888, 37.842}, // ODB
    Coordinate{-120.8, 37.7564}, // ODC
    Coordinate{10.3308, 55.4767}, // ODE
    Coordinate{22.7833, 8.9}, // ODJ
    Coordinate{-79.3394, 39.5803}, // ODM
    Coordinate{115.063, 3.97611}, // ODN
    Coordinate{114.243, 57.8664}, // ODO
    Coordinate{30.6781, 46.4269}, // ODS
    Coordinate{-122.674, 48.2517}, // ODW
    Coordinate{101.993, 20.6806}, // ODY
    Coordinate{-87.5522, 38.6914}, // OEA
    Coordinate{-85.0522, 41.9336}, // OEB
    Coordinate{124.352, -9.19833}, // OEC
    Coordinate{36.0017, 52.935}, // OEL
    Coordinate{-55.4417, 3.34611}, // OEM
    Coordinate{-92.69, 45.3094}, // OEO
    Coordinate{18.99, 63.4078}, // OER
    Coordinate{-65.0344, -40.7514}, // OES
    Coordinate{46.6411, 25.2131}, // OET
    Coordinate{-4.05, 9.6}, // OFI
    Coordinate{-18.6667, 66.0736}, // OFJ
    Coordinate{-97.435, 41.9856}, // OFK
    Coordinate{-77.4364, 37.7089}, // OFP
    Coordinate{-169.67, -14.1844}, // OFU
    Coordinate{-80.8594, 33.4569}, // OGB
    Coordinate{-112.013, 41.1956}, // OGD
    Coordinate{-156.431, 20.8986}, // OGG
    Coordinate{-58.1058, 6.80722}, // OGL
    Coordinate{-77.9819, 9.13278}, // OGM
    Coordinate{122.98, 24.4675}, // OGN
    Coordinate{-3.47028, 6.71556}, // OGO
    Coordinate{15.3797, 10.2883}, // OGR
    Coordinate{-75.4656, 44.6819}, // OGS
    Coordinate{38.0667, 40.9667}, // OGU
    Coordinate{5.40667, 31.9314}, // OGX
    Coordinate{44.6067, 43.205}, // OGZ
    Coordinate{175.387, -40.2067}, // OHA
    Coordinate{20.7422, 41.1799}, // OHD
    Coordinate{122.421, 52.9211}, // OHE
    Coordinate{142.88, 53.5178}, // OHH
    Coordinate{15.699, -17.7972}, // OHI
    Coordinate{143.057, 59.4101}, // OHO
    Coordinate{56.6953, 24.3328}, // OHS
    Coordinate{-51.06, -6.77583}, // OIA
    Coordinate{-75.5242, 42.5664}, // OIC
    Coordinate{139.36, 34.7819}, // OIM
    Coordinate{139.433, 42.0717}, // OIR
    Coordinate{131.737, 33.4794}, // OIT
    Coordinate{-98.6686, 35.5458}, // OJA
    Coordinate{-94.7375, 38.8475}, // OJC
    Coordinate{127.646, 26.1958}, // OKA
    Coordinate{-97.6008, 35.3931}, // OKC
    Coordinate{141.381, 43.1175}, // OKD
    Coordinate{128.706, 27.4317}, // OKE
    Coordinate{15.9167, -19.15}, // OKF
    Coordinate{15.0733, -1.44833}, // OKG
    Coordinate{133.323, 36.1783}, // OKI
    Coordinate{133.855, 34.7569}, // OKJ
    Coordinate{-86.0589, 40.5281}, // OKK
    Coordinate{140.664, -5.10161}, // OKL
    Coordinate{-95.9486, 35.6681}, // OKM
    Coordinate{13.6728, -0.664167}, // OKN
    Coordinate{143.404, -9.75333}, // OKR
    Coordinate{133.933, 34.5914}, // OKS
    Coordinate{53.3883, 54.44}, // OKT
    Coordinate{17.0519, -18.8144}, // OKU
    Coordinate{9.60389, 63.6992}, // OLA
    Coordinate{9.51763, 40.8987}, // OLB
    Coordinate{-68.9583, -3.46944}, // OLC
    Coordinate{-68.6744, 44.9525}, // OLD
    Coordinate{-78.3714, 42.2411}, // OLE
    Coordinate{-105.575, 48.0944}, // OLF
    Coordinate{-153.269, 57.2183}, // OLH
    Coordinate{-23.8231, 64.9114}, // OLI
    Coordinate{166.558, -14.8817}, // OLJ
    Coordinate{15.9142, -1.21861}, // OLL
    Coordinate{-122.902, 46.9694}, // OLM
    Coordinate{-69, -45.5819}, // OLN
    Coordinate{17.2108, 49.5878}, // OLO
    Coordinate{136.877, -30.485}, // OLP
    Coordinate{-110.848, 31.4178}, // OLS
    Coordinate{-97.3428, 41.4481}, // OLU
    Coordinate{-89.7869, 34.9789}, // OLV
    Coordinate{120.464, 60.3992}, // OLZ
    Coordinate{-95.8937, 41.302}, // OMA
    Coordinate{9.26278, -1.58333}, // OMB
    Coordinate{124.566, 11.0562}, // OMC
    Coordinate{16.4467, -28.5847}, // OMD
    Coordinate{-165.445, 64.5122}, // OME
    Coordinate{22.1889, -18.0303}, // OMG
    Coordinate{45.0686, 37.6681}, // OMH
    Coordinate{-119.518, 48.4642}, // OMK
    Coordinate{55.1753, 18.136}, // OMM
    Coordinate{17.8458, 43.2828}, // OMO
    Coordinate{21.9024, 47.0253}, // OMR
    Coordinate{73.3083, 54.9667}, // OMS
    Coordinate{104.972, 13.7606}, // OMY
    Coordinate{-91.7083, 44.0772}, // ONA
    Coordinate{15.95, -17.8781}, // OND
    Coordinate{139.178, -16.6625}, // ONG
    Coordinate{-75.0644, 42.5247}, // ONH
    Coordinate{140.372, 40.1919}, // ONJ
    Coordinate{112.479, 68.5156}, // ONK
    Coordinate{-98.6872, 42.4694}, // ONL
    Coordinate{-117.013, 44.0194}, // ONO
    Coordinate{-124.058, 44.5803}, // ONP
    Coordinate{32.0886, 41.5064}, // ONQ
    Coordinate{115.113, -21.6684}, // ONS
    Coordinate{-117.601, 34.0561}, // ONT
    Coordinate{-79.8675, 9.35528}, // ONX
    Coordinate{-83.1614, 42.0992}, // ONZ
    Coordinate{135.445, -27.56}, // OOD
    Coordinate{-165.087, 60.5414}, // OOK
    Coordinate{153.505, -28.165}, // OOL
    Coordinate{148.973, -36.3006}, // OOM
    Coordinate{175.526, -1.79639}, // OOT
    Coordinate{-16.4667, 66.3108}, // OPA
    Coordinate{-80.2783, 25.9069}, // OPF
    Coordinate{133.005, -12.3253}, // OPI
    Coordinate{-92.0994, 30.5583}, // OPL
    Coordinate{-8.67806, 41.2356}, // OPO
    Coordinate{-55.5861, -11.885}, // OPS
    Coordinate{142.94, -8.05117}, // OPU
    Coordinate{13.83, -18.07}, // OPW
    Coordinate{-75.5819, 39.99}, // OQN
    Coordinate{-71.4122, 41.5972}, // OQU
    Coordinate{-64.3292, -23.1528}, // ORA
    Coordinate{15.0381, 59.2236}, // ORB
    Coordinate{-71.3564, 4.78972}, // ORC
    Coordinate{-87.9047, 41.9786}, // ORD
    Coordinate{2.16417, 47.8975}, // ORE
    Coordinate{-76.2011, 36.8947}, // ORF
    Coordinate{-55.1901, 5.81147}, // ORG
    Coordinate{-71.8758, 42.2672}, // ORH
    Coordinate{-152.846, 57.8853}, // ORI
    Coordinate{-60.0333, 4.72778}, // ORJ
    Coordinate{-8.49111, 51.8414}, // ORK
    Coordinate{-81.3331, 28.5456}, // ORL
    Coordinate{-0.791389, 52.3061}, // ORM
    Coordinate{-0.611389, 35.6272}, // ORN
    Coordinate{-87.1356, 15.1278}, // ORO
    Coordinate{25.3178, -21.2672}, // ORP
    Coordinate{-141.928, 62.9611}, // ORT
    Coordinate{-67.0761, -17.9625}, // ORU
    Coordinate{-161.022, 66.8175}, // ORV
    Coordinate{64.5861, 25.2747}, // ORW
    Coordinate{-55.8672, -1.76695}, // ORX
    Coordinate{2.37944, 48.7233}, // ORY
    Coordinate{-88.5483, 18.0744}, // ORZ
    Coordinate{-83.3942, 44.4517}, // OSC
    Coordinate{14.5019, 63.1942}, // OSD
    Coordinate{37.5072, 55.5117}, // OSF
    Coordinate{-88.5569, 43.9844}, // OSH
    Coordinate{18.8103, 45.4628}, // OSI
    Coordinate{11.0839, 60.2028}, // OSL
    Coordinate{43.1475, 36.3058}, // OSM
    Coordinate{140.557, -22.0817}, // OSO
    Coordinate{17.1075, 54.4789}, // OSP
    Coordinate{18.1108, 49.6961}, // OSR
    Coordinate{72.7931, 40.6089}, // OSS
    Coordinate{2.87028, 51.2003}, // OST
    Coordinate{-83.0731, 40.0797}, // OSU
    Coordinate{58.5967, 51.0717}, // OSW
    Coordinate{11.6, 64.4667}, // OSY
    Coordinate{16.2642, 54.0422}, // OSZ
    Coordinate{14.7393, 13.4433}, // OTC
    Coordinate{-79.0344, 8.62861}, // OTD
    Coordinate{-124.263, 43.4172}, // OTH
    Coordinate{128.315, 2.04583}, // OTI
    Coordinate{16.6625, -20.4306}, // OTJ
    Coordinate{-14.7167, 17.533}, // OTL
    Coordinate{-92.4481, 41.1067}, // OTM
    Coordinate{-87.4997, 38.8514}, // OTN
    Coordinate{26.085, 44.5711}, // OTP
    Coordinate{-82.9667, 8.6}, // OTR
    Coordinate{-122.662, 48.4989}, // OTS
    Coordinate{-74.7183, 7.01194}, // OTU
    Coordinate{-162.599, 66.8847}, // OTZ
    Coordinate{-1.51222, 12.3531}, // OUA
    Coordinate{-1.92389, 34.7872}, // OUD
    Coordinate{16.0378, 1.61583}, // OUE
    Coordinate{-2.417, 13.567}, // OUG
    Coordinate{25.3556, 64.9292}, // OUL
    Coordinate{19.2333, 13.2667}, // OUM
    Coordinate{-97.4722, 35.2456}, // OUN
    Coordinate{14.3625, 4.47083}, // OUR
    Coordinate{-49.9119, -22.9736}, // OUS
    Coordinate{16.717, 10.483}, // OUT
    Coordinate{-12.4686, 22.7567}, // OUZ
    Coordinate{82.6506, 55.0125}, // OVB
    Coordinate{-6.03472, 43.5636}, // OVD
    Coordinate{-121.622, 39.4878}, // OVE
    Coordinate{-71.1761, -30.5594}, // OVL
    Coordinate{-60.2167, -36.89}, // OVR
    Coordinate{63.605, 61.325}, // OVS
    Coordinate{-87.1669, 37.7389}, // OWB
    Coordinate{-71.1731, 42.1906}, // OWD
    Coordinate{-95.2519, 38.5392}, // OWI
    Coordinate{-69.8665, 44.7155}, // OWK
    Coordinate{-96.1519, 36.1753}, // OWP
    Coordinate{-15.6536, 11.895}, // OXB
    Coordinate{-73.1353, 41.4786}, // OXC
    Coordinate{-84.7844, 39.5022}, // OXD
    Coordinate{-1.32, 51.8369}, // OXF
    Coordinate{-59.2506, -29.1044}, // OYA
    Coordinate{11.5814, 1.54311}, // OYE
    Coordinate{31.7644, 3.64889}, // OYG
    Coordinate{-51.7967, 3.85588}, // OYK
    Coordinate{39.102, 3.465}, // OYL
    Coordinate{-60.3333, -38.4}, // OYO
    Coordinate{-51.8056, 3.89333}, // OYP
    Coordinate{123.841, 8.17852}, // OZC
    Coordinate{-5.86667, 30.2667}, // OZG
    Coordinate{35.3158, 47.8669}, // OZH
    Coordinate{-92.6911, 37.9739}, // OZS
    Coordinate{-83.9822, 42.6294}, // OZW
    Coordinate{-6.90944, 30.9392}, // OZZ
    Coordinate{97.6744, 16.8931}, // PAA
    Coordinate{82.0648, 21.9883}, // PAB
    Coordinate{-79.5556, 8.97333}, // PAC
    Coordinate{8.61722, 51.6153}, // PAD
    Coordinate{-122.281, 47.9061}, // PAE
    Coordinate{31.5544, 2.20222}, // PAF
    Coordinate{123.458, 7.82722}, // PAG
    Coordinate{-88.7731, 37.0603}, // PAH
    Coordinate{70.0714, 33.9027}, // PAJ
    Coordinate{-159.603, 21.8969}, // PAK
    Coordinate{101.154, 6.78546}, // PAN
    Coordinate{-122.115, 37.4611}, // PAO
    Coordinate{-72.2925, 18.58}, // PAP
    Coordinate{-149.089, 61.595}, // PAQ
    Coordinate{25.128, 37.0112}, // PAS
    Coordinate{85.0919, 25.5936}, // PAT
    Coordinate{-38.2542, -9.40222}, // PAV
    Coordinate{-72.85, 19.9333}, // PAX
    Coordinate{-97.4608, 20.6021}, // PAZ
    Coordinate{-98.3714, 19.1581}, // PBC
    Coordinate{69.6572, 21.6486}, // PBD
    Coordinate{-74.4106, 6.45972}, // PBE
    Coordinate{-91.9356, 34.1744}, // PBF
    Coordinate{-73.4681, 44.6508}, // PBG
    Coordinate{89.4206, 27.4088}, // PBH
    Coordinate{-80.0956, 26.6832}, // PBI
    Coordinate{168.236, -16.4319}, // PBJ
    Coordinate{-68.0733, 10.4781}, // PBL
    Coordinate{-55.1878, 5.45283}, // PBM
    Coordinate{13.7657, -10.722}, // PBN
    Coordinate{117.746, -23.1714}, // PBO
    Coordinate{-85.3667, 9.85}, // PBP
    Coordinate{-61.1811, -11.6417}, // PBQ
    Coordinate{-88.585, 15.7308}, // PBR
    Coordinate{97.4264, 27.3197}, // PBU
    Coordinate{-57.3689, -11.532}, // PBV
    Coordinate{23.3294, -34.0883}, // PBZ
    Coordinate{-157.711, 58.9064}, // PCA
    Coordinate{106.765, -6.3368}, // PCB
    Coordinate{-91.1236, 43.0192}, // PCD
    Coordinate{-84.9403, 15.9542}, // PCH
    Coordinate{-74.5743, -8.37794}, // PCL
    Coordinate{-82.1642, 28.0003}, // PCM
    Coordinate{173.958, -41.3447}, // PCN
    Coordinate{-109.536, 23.575}, // PCO
    Coordinate{7.41167, 1.66306}, // PCP
    Coordinate{-67.4931, 6.18444}, // PCR
    Coordinate{-41.5194, -7.06528}, // PCS
    Coordinate{-74.6589, 40.3992}, // PCT
    Coordinate{-82.8694, 41.5164}, // PCW
    Coordinate{-89.0197, 44.3333}, // PCZ
    Coordinate{-67.9061, 3.85361}, // PDA
    Coordinate{-154.13, 59.7972}, // PDB
    Coordinate{32.8383, -26.8267}, // PDD
    Coordinate{100.281, -0.786667}, // PDG
    Coordinate{-84.3019, 33.8756}, // PDK
    Coordinate{-25.6978, 37.7419}, // PDL
    Coordinate{103.88, -3.28607}, // PDO
    Coordinate{-55.0942, -34.855}, // PDP
    Coordinate{-100.534, 28.6274}, // PDS
    Coordinate{-58.0622, -32.3633}, // PDU
    Coordinate{-122.598, 45.5886}, // PDX
    Coordinate{-62.2333, 9.97778}, // PDZ
    Coordinate{-136.236, 57.9553}, // PEC
    Coordinate{15.7386, 50.0133}, // PED
    Coordinate{56.0267, 57.9167}, // PEE
    Coordinate{13.7728, 54.1578}, // PEF
    Coordinate{12.5102, 43.0958}, // PEG
    Coordinate{-61.8575, -35.8447}, // PEH
    Coordinate{-75.7394, 4.8125}, // PEI
    Coordinate{116.584, 40.08}, // PEK
    Coordinate{28.4972, -29.0881}, // PEL
    Coordinate{-69.2286, -12.6136}, // PEM
    Coordinate{100.277, 5.29694}, // PEN
    Coordinate{-77.0528, 42.6372}, // PEO
    Coordinate{-103.511, 31.3825}, // PEQ
    Coordinate{115.967, -31.9403}, // PER
    Coordinate{34.1567, 61.885}, // PES
    Coordinate{-52.3311, -31.7161}, // PET
    Coordinate{-83.7831, 15.2667}, // PEU
    Coordinate{71.5147, 33.9939}, // PEW
    Coordinate{57.13, 65.1217}, // PEX
    Coordinate{45.0167, 53.1167}, // PEZ
    Coordinate{-52.3286, -28.2453}, // PFB
    Coordinate{-123.962, 45.1997}, // PFC
    Coordinate{-23.965, 65.5558}, // PFJ
    Coordinate{-85.6828, 30.2122}, // PFN
    Coordinate{32.485, 34.7183}, // PFO
    Coordinate{47.8547, 39.6036}, // PFQ
    Coordinate{20.6, -4.33}, // PFR
    Coordinate{-111.448, 36.9261}, // PGA
    Coordinate{20.1808, 44.723}, // PGB
    Coordinate{-79.1458, 38.995}, // PGC
    Coordinate{-81.9908, 26.9189}, // PGD
    Coordinate{2.87056, 42.7406}, // PGF
    Coordinate{79.4725, 29.0321}, // PGH
    Coordinate{20.8035, -7.35756}, // PGI
    Coordinate{106.139, -2.16194}, // PGK
    Coordinate{-88.5292, 30.4628}, // PGL
    Coordinate{-151.832, 59.3483}, // PGM
    Coordinate{-72.1186, 19.3214}, // PGN
    Coordinate{-107.055, 37.2881}, // PGO
    Coordinate{6.51667, 0.0333333}, // PGP
    Coordinate{-90.5092, 36.0639}, // PGR
    Coordinate{-113.247, 35.5269}, // PGS
    Coordinate{52.7375, 27.3794}, // PGU
    Coordinate{-77.3853, 35.6353}, // PGV
    Coordinate{0.815217, 45.1975}, // PGX
    Coordinate{-50.1444, -25.1878}, // PGZ
    Coordinate{-41.7303, -2.89389}, // PHB
    Coordinate{6.94944, 5.01528}, // PHC
    Coordinate{-81.42, 40.4703}, // PHD
    Coordinate{118.626, -20.3778}, // PHE
    Coordinate{-76.4931, 37.1319}, // PHF
    Coordinate{7.01765, 4.84162}, // PHG
    Coordinate{-45.0672, -2.48361}, // PHI
    Coordinate{-80.6933, 26.785}, // PHK
    Coordinate{-75.2411, 39.8719}, // PHL
    Coordinate{8.99419, 48.6899}, // PHM
    Coordinate{-82.5289, 42.9108}, // PHN
    Coordinate{-166.799, 68.3489}, // PHO
    Coordinate{139.923, -21.8117}, // PHQ
    Coordinate{100.279, 16.7731}, // PHS
    Coordinate{-88.3828, 36.3383}, // PHT
    Coordinate{31.155, -23.9372}, // PHW
    Coordinate{-112.012, 33.4342}, // PHX
    Coordinate{101.195, 16.6758}, // PHY
    Coordinate{-89.6933, 40.6642}, // PIA
    Coordinate{-89.3369, 31.4672}, // PIB
    Coordinate{-72.0904, 21.8779}, // PIC
    Coordinate{-77.2933, 25.0792}, // PID
    Coordinate{-82.6875, 27.91}, // PIE
    Coordinate{120.478, 22.6953}, // PIF
    Coordinate{-62.3833, -37.6061}, // PIG
    Coordinate{-112.596, 42.9098}, // PIH
    Coordinate{-4.59444, 55.5094}, // PIK
    Coordinate{-58.318, -26.8815}, // PIL
    Coordinate{-84.8825, 32.8406}, // PIM
    Coordinate{-56.7711, -2.66944}, // PIN
    Coordinate{-76.2203, -13.745}, // PIO
    Coordinate{-157.572, 57.5803}, // PIP
    Coordinate{-100.286, 44.3828}, // PIR
    Coordinate{0.306667, 46.5875}, // PIS
    Coordinate{-80.2567, 40.496}, // PIT
    Coordinate{-80.6167, -5.2}, // PIU
    Coordinate{-97.1636, 55.5894}, // PIW
    Coordinate{-28.4414, 38.5544}, // PIX
    Coordinate{-163.011, 69.7322}, // PIZ
    Coordinate{23.0689, 67.2458}, // PJA
    Coordinate{-111.339, 34.2569}, // PJB
    Coordinate{-55.8297, -22.6414}, // PJC
    Coordinate{64.1325, 26.9545}, // PJG
    Coordinate{-83.3, 8.53333}, // PJM
    Coordinate{-161.778, 60.7028}, // PKA
    Coordinate{-81.4394, 39.345}, // PKB
    Coordinate{158.454, 53.1677}, // PKC
    Coordinate{148.239, -33.1314}, // PKE
    Coordinate{-90.4244, 45.955}, // PKF
    Coordinate{100.553, 4.24472}, // PKG
    Coordinate{23.149, 37.2988}, // PKH
    Coordinate{-90.7417, 15.9975}, // PKJ
    Coordinate{95.1023, 21.3445}, // PKK
    Coordinate{111.673, -2.705}, // PKN
    Coordinate{2.60917, 9.35722}, // PKO
    Coordinate{-138.811, -14.8093}, // PKP
    Coordinate{83.9819, 28.2008}, // PKR
    Coordinate{129.528, -14.2483}, // PKT
    Coordinate{101.444, 0.460833}, // PKU
    Coordinate{28.3983, 57.785}, // PKV
    Coordinate{27.8205, -22.0572}, // PKW
    Coordinate{113.942, -2.225}, // PKY
    Coordinate{105.782, 15.1339}, // PKZ
    Coordinate{-73.5244, 44.6875}, // PLB
    Coordinate{-85.4833, 9.86667}, // PLD
    Coordinate{14.925, 9.37806}, // PLF
    Coordinate{-4.10583, 50.4228}, // PLH
    Coordinate{-88.3617, 16.5369}, // PLJ
    Coordinate{-93.2289, 36.6258}, // PLK
    Coordinate{-59.9864, -3.14611}, // PLL
    Coordinate{104.7, -2.90028}, // PLM
    Coordinate{-84.7967, 45.5708}, // PLN
    Coordinate{135.88, -34.6053}, // PLO
    Coordinate{21.0939, 55.9733}, // PLQ
    Coordinate{-86.2492, 33.5589}, // PLR
    Coordinate{-72.2658, 21.7736}, // PLS
    Coordinate{-74.7861, 9.8}, // PLT
    Coordinate{-43.9506, -19.8519}, // PLU
    Coordinate{34.3986, 49.5739}, // PLV
    Coordinate{119.91, -0.918611}, // PLW
    Coordinate{80.2344, 50.3514}, // PLX
    Coordinate{-86.3003, 41.365}, // PLY
    Coordinate{25.6103, -33.99}, // PLZ
    Coordinate{39.8114, -5.25722}, // PMA
    Coordinate{-97.2408, 48.9425}, // PMB
    Coordinate{-73.0939, -41.4386}, // PMC
    Coordinate{-118.084, 34.6294}, // PMD
    Coordinate{10.2953, 44.8222}, // PMF
    Coordinate{-55.7025, -22.5497}, // PMG
    Coordinate{-82.8472, 38.8406}, // PMH
    Coordinate{2.73881, 39.5517}, // PMI
    Coordinate{146.581, -18.7553}, // PMK
    Coordinate{-160.561, 56.0061}, // PML
    Coordinate{13.0994, 38.1819}, // PMO
    Coordinate{-70.9805, -46.5381}, // PMQ
    Coordinate{175.617, -40.3206}, // PMR
    Coordinate{38.3, 34.55}, // PMS
    Coordinate{-63.9675, 10.9131}, // PMV
    Coordinate{-48.3578, -10.29}, // PMW
    Coordinate{-72.3114, 42.2233}, // PMX
    Coordinate{-65.1014, -42.7585}, // PMY
    Coordinate{-83.4686, 8.95111}, // PMZ
    Coordinate{-1.647, 42.77}, // PNA
    Coordinate{-48.4003, -10.7169}, // PNB
    Coordinate{-97.0997, 36.7319}, // PNC
    Coordinate{-88.8081, 16.1022}, // PND
    Coordinate{-75.0106, 40.0819}, // PNE
    Coordinate{-48.5311, -25.5406}, // PNG
    Coordinate{104.844, 11.5464}, // PNH
    Coordinate{158.209, 6.985}, // PNI
    Coordinate{109.404, -0.150556}, // PNK
    Coordinate{11.9686, 36.8164}, // PNL
    Coordinate{-93.6083, 45.56}, // PNM
    Coordinate{-67.5644, 45.2006}, // PNN
    Coordinate{148.309, -8.80444}, // PNP
    Coordinate{73.9197, 18.5822}, // PNQ
    Coordinate{11.8858, -4.81333}, // PNR
    Coordinate{-87.1866, 30.4734}, // PNS
    Coordinate{-72.5284, -51.6717}, // PNT
    Coordinate{-112.392, 37.8453}, // PNU
    Coordinate{-96.6736, 33.7142}, // PNX
    Coordinate{79.8105, 11.9658}, // PNY
    Coordinate{-40.5969, -9.3675}, // PNZ
    Coordinate{-51.1711, -29.9939}, // POA
    Coordinate{-117.782, 34.0916}, // POC
    Coordinate{-14.9667, 16.6781}, // POD
    Coordinate{8.75444, -0.711667}, // POG
    Coordinate{-65.7236, -19.5431}, // POI
    Coordinate{-46.4914, -18.6722}, // POJ
    Coordinate{40.5225, -12.9868}, // POL
    Coordinate{147.22, -9.44333}, // POM
    Coordinate{-89.4167, 16.3264}, // PON
    Coordinate{-46.5681, -21.8431}, // POO
    Coordinate{-70.57, 19.7578}, // POP
    Coordinate{21.7978, 61.4614}, // POR
    Coordinate{-61.3372, 10.5953}, // POS
    Coordinate{-76.5361, 18.1967}, // POT
    Coordinate{-73.8842, 41.6267}, // POU
    Coordinate{-81.2517, 41.2103}, // POV
    Coordinate{13.615, 45.4734}, // POW
    Coordinate{2.04072, 49.0966}, // POX
    Coordinate{16.8264, 52.4211}, // POZ
    Coordinate{-51.4189, -22.1783}, // PPB
    Coordinate{-150.644, 66.8142}, // PPC
    Coordinate{-113.533, 31.35}, // PPE
    Coordinate{-95.5061, 37.3308}, // PPF
    Coordinate{-170.711, -14.3317}, // PPG
    Coordinate{-61.5194, 4.57028}, // PPH
    Coordinate{137.995, -33.2389}, // PPI
    Coordinate{69.185, 54.7744}, // PPK
    Coordinate{86.5844, 27.5181}, // PPL
    Coordinate{-80.1111, 26.2472}, // PPM
    Coordinate{-76.6092, 2.45417}, // PPN
    Coordinate{148.552, -20.495}, // PPP
    Coordinate{174.989, -40.9047}, // PPQ
    Coordinate{100.37, 0.845478}, // PPR
    Coordinate{118.759, 9.74222}, // PPS
    Coordinate{-149.611, -17.5567}, // PPT
    Coordinate{-133.61, 56.3289}, // PPV
    Coordinate{-2.90028, 59.3517}, // PPW
    Coordinate{-45.9194, -22.2889}, // PPY
    Coordinate{-67.4497, 6.21944}, // PPZ
    Coordinate{103.991, 10.1717}, // PQC
    Coordinate{-68.0447, 46.6889}, // PQI
    Coordinate{-92.0156, 17.533}, // PQM
    Coordinate{152.863, -31.4358}, // PQQ
    Coordinate{-162.899, 61.9344}, // PQS
    Coordinate{-60.4803, -31.7947}, // PRA
    Coordinate{-120.627, 35.6728}, // PRB
    Coordinate{-112.42, 34.6544}, // PRC
    Coordinate{14.26, 50.1008}, // PRG
    Coordinate{100.165, 18.1317}, // PRH
    Coordinate{55.6916, -4.31924}, // PRI
    Coordinate{-8.57972, 37.1475}, // PRM
    Coordinate{21.0358, 42.5728}, // PRN
    Coordinate{-94.1597, 41.8281}, // PRO
    Coordinate{8.89389, 41.6603}, // PRP
    Coordinate{-60.4934, -26.7667}, // PRQ
    Coordinate{-61.0556, 5.81667}, // PRR
    Coordinate{17.4047, 49.4258}, // PRV
    Coordinate{-90.2758, 45.5386}, // PRW
    Coordinate{-95.4508, 33.6367}, // PRX
    Coordinate{28.2167, -25.6536}, // PRY
    Coordinate{-120.904, 44.2869}, // PRZ
    Coordinate{10.3925, 43.6839}, // PSA
    Coordinate{-78.0872, 40.8833}, // PSB
    Coordinate{-119.119, 46.2647}, // PSC
    Coordinate{32.24, 31.2794}, // PSD
    Coordinate{-66.5631, 18.0083}, // PSE
    Coordinate{-73.2929, 42.4268}, // PSF
    Coordinate{-132.946, 56.8014}, // PSG
    Coordinate{63.3444, 25.2902}, // PSI
    Coordinate{120.656, -1.41838}, // PSJ
    Coordinate{-80.6786, 37.1372}, // PSK
    Coordinate{-3.37222, 56.4392}, // PSL
    Coordinate{-70.8233, 43.0781}, // PSM
    Coordinate{-77.2914, 1.39611}, // PSO
    Coordinate{-116.507, 33.8297}, // PSP
    Coordinate{-75.2997, 39.8589}, // PSQ
    Coordinate{14.1872, 42.4372}, // PSR
    Coordinate{-55.9706, -27.3858}, // PSS
    Coordinate{-75.6572, 20.7342}, // PST
    Coordinate{112.937, 0.835556}, // PSU
    Coordinate{}, // PSV
    Coordinate{-96.2508, 28.7275}, // PSX
    Coordinate{-57.7776, -51.6857}, // PSY
    Coordinate{-57.8206, -18.9753}, // PSZ
    Coordinate{-154.319, 60.2044}, // PTA
    Coordinate{-134.648, 56.2469}, // PTD
    Coordinate{177.216, -17.7831}, // PTF
    Coordinate{29.4585, -23.8453}, // PTG
    Coordinate{-158.633, 56.9592}, // PTH
    Coordinate{141.471, -38.3181}, // PTJ
    Coordinate{-83.4194, 42.6656}, // PTK
    Coordinate{-70.1832, 7.56671}, // PTM
    Coordinate{-91.3389, 29.7094}, // PTN
    Coordinate{-52.6942, -26.2178}, // PTO
    Coordinate{-61.5258, 16.2642}, // PTP
    Coordinate{-94.7311, 37.4494}, // PTS
    Coordinate{-98.7469, 37.7025}, // PTT
    Coordinate{-161.819, 59.0114}, // PTU
    Coordinate{-119.063, 36.0297}, // PTV
    Coordinate{-75.5567, 40.2394}, // PTW
    Coordinate{-76.0875, 1.85694}, // PTX
    Coordinate{-79.3836, 9.07139}, // PTY
    Coordinate{-78.0628, -1.50528}, // PTZ
    Coordinate{-104.496, 38.2892}, // PUB
    Coordinate{-65.9164, -47.7356}, // PUD
    Coordinate{-77.5331, 8.68306}, // PUE
    Coordinate{-0.418611, 43.38}, // PUF
    Coordinate{137.717, -32.5069}, // PUG
    Coordinate{-68.3519, 18.5667}, // PUJ
    Coordinate{-137.017, -18.2956}, // PUK
    Coordinate{121.524, -4.34139}, // PUM
    Coordinate{26.3333, -1.36667}, // PUN
    Coordinate{-1.14847, 11.1791}, // PUP
    Coordinate{-70.8544, -53.0025}, // PUQ
    Coordinate{-67.5472, -11.1072}, // PUR
    Coordinate{128.938, 35.1806}, // PUS
    Coordinate{77.7911, 14.1467}, // PUT
    Coordinate{-76.5008, 0.505278}, // PUU
    Coordinate{-117.109, 46.7439}, // PUW
    Coordinate{-72.9468, -41.3493}, // PUX
    Coordinate{13.9222, 44.8936}, // PUY
    Coordinate{-83.3877, 14.0462}, // PUZ
    Coordinate{-81.3583, 13.3569}, // PVA
    Coordinate{-90.4444, 42.6894}, // PVB
    Coordinate{-70.2214, 42.0719}, // PVC
    Coordinate{-71.4283, 41.7239}, // PVD
    Coordinate{-78.9475, 9.55833}, // PVE
    Coordinate{-120.753, 38.7242}, // PVF
    Coordinate{121.805, 31.1433}, // PVG
    Coordinate{-63.9028, -8.71361}, // PVH
    Coordinate{-52.4886, -23.0917}, // PVI
    Coordinate{20.7667, 38.9261}, // PVK
    Coordinate{-82.5664, 37.5617}, // PVL
    Coordinate{-80.4719, -1.04139}, // PVO
    Coordinate{-112.099, 27.0931}, // PVP
    Coordinate{-105.254, 20.68}, // PVR
    Coordinate{-173.247, 64.3783}, // PVS
    Coordinate{-111.723, 40.2192}, // PVU
    Coordinate{-101.716, 34.1689}, // PVW
    Coordinate{-97.6469, 35.5342}, // PWA
    Coordinate{-104.523, 48.7889}, // PWD
    Coordinate{170.597, 69.7833}, // PWE
    Coordinate{-87.9017, 42.1142}, // PWK
    Coordinate{109.417, -7.46167}, // PWL
    Coordinate{-70.3092, 43.6461}, // PWM
    Coordinate{-74.3464, 22.8297}, // PWN
    Coordinate{28.8896, -8.46853}, // PWO
    Coordinate{77.0739, 52.195}, // PWQ
    Coordinate{-122.765, 47.4903}, // PWT
    Coordinate{-109.807, 42.7956}, // PWY
    Coordinate{103.379, -4.0225}, // PXA
    Coordinate{-83.7672, 32.5106}, // PXE
    Coordinate{135.522, -29.7167}, // PXH
    Coordinate{-110.423, 35.7917}, // PXL
    Coordinate{-97.0891, 15.8767}, // PXM
    Coordinate{-16.3497, 33.0708}, // PXO
    Coordinate{103.498, 14.8683}, // PXR
    Coordinate{108.017, 14.0044}, // PXU
    Coordinate{-74.457, 5.93904}, // PYA
    Coordinate{82.5519, 18.8797}, // PYB
    Coordinate{-78.2347, 9.30972}, // PYC
    Coordinate{-158.033, -9.01444}, // PYE
    Coordinate{-67.6061, 5.62}, // PYH
    Coordinate{112.05, 66.4167}, // PYJ
    Coordinate{50.8228, 35.7761}, // PYK
    Coordinate{-70.7289, 41.9089}, // PYM
    Coordinate{-75.9, 0.08333}, // PYO
    Coordinate{-85.61, 34.09}, // PYP
    Coordinate{-121.616, 39.7106}, // PYS
    Coordinate{98.4359, 19.3704}, // PYY
    Coordinate{-71.8917, 5.875}, // PZA
    Coordinate{30.3983, -29.6506}, // PZB
    Coordinate{69.4634, 31.3583}, // PZH
    Coordinate{101.799, 26.5423}, // PZI
    Coordinate{-62.7603, 8.28861}, // PZO
    Coordinate{-72.6372, -38.7669}, // PZS
    Coordinate{37.2341, 19.4336}, // PZU
    Coordinate{17.8286, 48.625}, // PZY
    Coordinate{55.9925, 25.3103}, // QAJ
    Coordinate{-43.7611, -21.275}, // QAK
    Coordinate{2.38694, 49.8731}, // QAM
    Coordinate{13.3103, 42.3806}, // QAQ
    Coordinate{1.33564, 36.2148}, // QAS
    Coordinate{-126.596, 52.3875}, // QBC
    Coordinate{20.6353, 44.9022}, // QBG
    Coordinate{6.08056, 47.2053}, // QBQ
    Coordinate{10.9281, 45.4719}, // QBS
    Coordinate{-50.8322, -29.3706}, // QCN
    Coordinate{-48.4675, -22.9367}, // QCP
    Coordinate{-51.6069, -21.4611}, // QDC
    Coordinate{-43.7981, -20.7386}, // QDF
    Coordinate{3.349, 34.6671}, // QDJ
    Coordinate{-46.9436, -23.1817}, // QDV
    Coordinate{2.87599, 36.5458}, // QFD
    Coordinate{-45.9142, 60.6242}, // QFG
    Coordinate{-44.6536, 60.0036}, // QFN
    Coordinate{0.131944, 52.0908}, // QFO
    Coordinate{13.2939, 41.6481}, // QFR
    Coordinate{-51.4894, -29.7194}, // QGF
    Coordinate{-36.4714, -8.83494}, // QGP
    Coordinate{136.869, 35.3939}, // QGU
    Coordinate{17.8136, 47.6244}, // QGY
    Coordinate{-47.6194, -22.7106}, // QHB
    Coordinate{-45.516, -23.0401}, // QHP
    Coordinate{39.0059, 8.7163}, // QHR
    Coordinate{49.405, 27.0385}, // QJB
    Coordinate{-47.1525, 60.7792}, // QJH
    Coordinate{27.3492, 70.9406}, // QJL
    Coordinate{28.3792, -14.45}, // QKE
    Coordinate{23.0342, 69.0403}, // QKX
    Coordinate{9.13722, 47.6818}, // QKZ
    Coordinate{-1.03361, 51.1872}, // QLA
    Coordinate{2.81417, 36.5036}, // QLD
    Coordinate{-49.8322, -26.1589}, // QMF
    Coordinate{7.25719, 35.8775}, // QMH
    Coordinate{49.2686, 32.0022}, // QMJ
    Coordinate{10.1431, 43.9856}, // QMM
    Coordinate{8.148, 49.9685}, // QMZ
    Coordinate{6.86472, 46.9575}, // QNC
    Coordinate{19.8339, 45.3857}, // QND
    Coordinate{6.26806, 46.1919}, // QNJ
    Coordinate{4.76889, 50.4881}, // QNM
    Coordinate{-43.4647, -22.7467}, // QNV
    Coordinate{4.79583, 46.2958}, // QNX
    Coordinate{-73.9728, 40.7339}, // QNY
    Coordinate{-56.0328, -28.6531}, // QOJ
    Coordinate{7.20583, 5.42694}, // QOW
    Coordinate{11.8481, 45.3958}, // QPA
    Coordinate{-83.6784, 22.4214}, // QPD
    Coordinate{27.1333, -22.5636}, // QPH
    Coordinate{18.241, 45.9909}, // QPJ
    Coordinate{-47.3442, -21.9844}, // QPS
    Coordinate{28.1511, -26.2425}, // QRA
    Coordinate{-70.7708, -34.1678}, // QRC
    Coordinate{-52.8156, -28.3214}, // QRE
    Coordinate{148.225, -32.2144}, // QRM
    Coordinate{-100.188, 20.6174}, // QRO
    Coordinate{147.803, -31.7333}, // QRR
    Coordinate{12.8503, 42.4261}, // QRT
    Coordinate{2.80278, 50.3239}, // QRV
    Coordinate{5.81944, 5.59722}, // QRW
    Coordinate{2.10503, 41.5209}, // QSA
    Coordinate{-47.9033, -21.8764}, // QSC
    Coordinate{5.28861, 36.1767}, // QSF
    Coordinate{37.3256, -3.36278}, // QSI
    Coordinate{-81.9208, 22.7564}, // QSN
    Coordinate{14.9125, 40.62}, // QSR
    Coordinate{-58.5892, 6.4225}, // QSX
    Coordinate{14.95, 51.3632}, // QTK
    Coordinate{12.8231, 26.5672}, // QUB
    Coordinate{-0.759167, 50.8594}, // QUG
    Coordinate{8.09889, 4.87583}, // QUO
    Coordinate{6.69611, 12.1717}, // QUS
    Coordinate{139.871, 36.5147}, // QUT
    Coordinate{8.88694, 45.7406}, // QVA
    Coordinate{-48.9842, -23.0931}, // QVP
    Coordinate{-80.67, 35.2139}, // QWG
    Coordinate{20.0219, 44.2978}, // QWV
    Coordinate{5.36, 43.505}, // QXB
    Coordinate{20.415, 53.7731}, // QYO
    Coordinate{4.01667, 48.3217}, // QYR
    Coordinate{22.8175, 53.1031}, // QYY
    Coordinate{0.626956, 35.7517}, // QZN
    Coordinate{152.379, -4.34028}, // RAB
    Coordinate{-87.8153, 42.7606}, // RAC
    Coordinate{41.1382, 30.9066}, // RAE
    Coordinate{-61.5042, -31.2844}, // RAF
    Coordinate{43.4906, 29.6264}, // RAH
    Coordinate{-23.4847, 14.9411}, // RAI
    Coordinate{70.7794, 22.3092}, // RAJ
    Coordinate{-8.04083, 31.6086}, // RAK
    Coordinate{-117.445, 33.9519}, // RAL
    Coordinate{134.898, -12.3567}, // RAM
    Coordinate{12.225, 44.3642}, // RAN
    Coordinate{-47.7767, -21.1364}, // RAO
    Coordinate{-103.057, 44.0453}, // RAP
    Coordinate{122.6, -4.8}, // RAQ
    Coordinate{-159.806, -21.2028}, // RAR
    Coordinate{49.6058, 37.3233}, // RAS
    Coordinate{77.33, 62.1583}, // RAT
    Coordinate{-70.2131, 6.32056}, // RAV
    Coordinate{-93.3456, 38.3469}, // RAW
    Coordinate{73.7981, 33.8497}, // RAZ
    Coordinate{-6.75167, 34.0514}, // RBA
    Coordinate{-59.5978, -4.40861}, // RBB
    Coordinate{142.117, -34.65}, // RBC
    Coordinate{-96.8683, 32.6808}, // RBD
    Coordinate{106.984, 13.7294}, // RBE
    Coordinate{-116.856, 34.2639}, // RBF
    Coordinate{-123.356, 43.2389}, // RBG
    Coordinate{141.039, 45.455}, // RBJ
    Coordinate{-117.129, 33.5742}, // RBK
    Coordinate{-122.252, 40.1508}, // RBL
    Coordinate{12.5192, 48.9017}, // RBM
    Coordinate{-82.87, 24.62}, // RBN
    Coordinate{-59.7658, -18.3276}, // RBO
    Coordinate{-67.4981, -14.4275}, // RBQ
    Coordinate{-67.8981, -9.86889}, // RBR
    Coordinate{148.61, -37.79}, // RBS
    Coordinate{37.9842, 2.345}, // RBT
    Coordinate{157.643, -8.16806}, // RBV
    Coordinate{-80.6406, 32.9211}, // RBW
    Coordinate{29.67, 6.83}, // RBX
    Coordinate{-155.47, 64.7272}, // RBY
    Coordinate{32.0919, -28.7408}, // RCB
    Coordinate{-123.16, 48.6081}, // RCE
    Coordinate{-72.9258, 11.5261}, // RCH
    Coordinate{167.835, -15.472}, // RCL
    Coordinate{143.115, -20.7019}, // RCM
    Coordinate{-99.3047, 39.3467}, // RCP
    Coordinate{-59.68, -29.2103}, // RCQ
    Coordinate{-86.1817, 41.0656}, // RCR
    Coordinate{0.502778, 51.3519}, // RCS
    Coordinate{-85.5167, 43.9}, // RCT
    Coordinate{-64.2647, -33.0936}, // RCU
    Coordinate{-91.0006, 45.4969}, // RCX
    Coordinate{-74.8361, 23.6844}, // RCY
    Coordinate{-79.7597, 34.8914}, // RCZ
    Coordinate{-162.899, 68.0322}, // RDB
    Coordinate{-49.9806, -8.03111}, // RDC
    Coordinate{-122.293, 40.5089}, // RDD
    Coordinate{-75.9653, 40.3786}, // RDG
    Coordinate{-95.2589, 41.0108}, // RDK
    Coordinate{-121.15, 44.2542}, // RDM
    Coordinate{103.007, 5.76528}, // RDN
    Coordinate{21.2136, 51.3892}, // RDO
    Coordinate{87.2433, 23.6214}, // RDP
    Coordinate{-68.9043, -37.3906}, // RDS
    Coordinate{-15.6572, 16.4375}, // RDT
    Coordinate{-78.7875, 35.8778}, // RDU
    Coordinate{-157.35, 61.7881}, // RDV
    Coordinate{2.48278, 44.4078}, // RDZ
    Coordinate{-136.443, -18.4659}, // REA
    Coordinate{12.7522, 53.3052}, // REB
    Coordinate{-34.9228, -8.12639}, // REC
    Coordinate{-77.6269, 40.6775}, // RED
    Coordinate{15.6536, 38.0719}, // REG
    Coordinate{-52.132, 4.314}, // REI
    Coordinate{-65.2838, -43.2098}, // REL
    Coordinate{55.4567, 51.7958}, // REN
    Coordinate{-117.886, 42.5778}, // REO
    Coordinate{103.813, 13.4106}, // REP
    Coordinate{-91.6972, 14.5211}, // RER
    Coordinate{-59.0561, -27.45}, // RES
    Coordinate{12.1033, 67.5278}, // RET
    Coordinate{1.16722, 41.1475}, // REU
    Coordinate{-98.2283, 26.0086}, // REX
    Coordinate{-67.3917, -14.3233}, // REY
    Coordinate{-44.4817, -22.4786}, // REZ
    Coordinate{23.9281, 4.98957}, // RFA
    Coordinate{-89.0972, 42.1953}, // RFD
    Coordinate{-94.8517, 32.1417}, // RFI
    Coordinate{-15.9183, 66.4064}, // RFN
    Coordinate{-151.466, -16.723}, // RFP
    Coordinate{-84.4086, 13.8897}, // RFS
    Coordinate{-67.7539, -53.7811}, // RGA
    Coordinate{88.7956, 25.2617}, // RGH
    Coordinate{-147.659, -14.9564}, // RGI
    Coordinate{85.8333, 51.9667}, // RGK
    Coordinate{-69.3128, -51.6089}, // RGL
    Coordinate{96.1331, 16.9072}, // RGN
    Coordinate{129.649, 41.4297}, // RGO
    Coordinate{-3.61361, 42.3575}, // RGS
    Coordinate{102.335, -0.352222}, // RGT
    Coordinate{-64.9483, -27.5106}, // RHD
    Coordinate{29.6333, -1.5}, // RHG
    Coordinate{-89.4664, 45.6308}, // RHI
    Coordinate{28.0861, 36.4053}, // RHO
    Coordinate{86.0614, 27.3939}, // RHP
    Coordinate{101.644, 39.2133}, // RHT
    Coordinate{-121.82, 37.3328}, // RHV
    Coordinate{-53.6922, -29.7108}, // RIA
    Coordinate{-66.1167, -11.0167}, // RIB
    Coordinate{-77.3194, 37.505}, // RIC
    Coordinate{-84.8428, 39.7561}, // RID
    Coordinate{-91.7733, 45.42}, // RIE
    Coordinate{-52.1633, -32.0817}, // RIG
    Coordinate{-80.1297, 8.37583}, // RIH
    Coordinate{-77.16, -6.06806}, // RIJ
    Coordinate{-107.727, 39.5264}, // RIL
    Coordinate{-77.5028, -6.39231}, // RIM
    Coordinate{157.143, -8.12639}, // RIN
    Coordinate{-117.41, 33.9889}, // RIR
    Coordinate{141.188, 45.2419}, // RIS
    Coordinate{-121.103, 38.4867}, // RIU
    Coordinate{-108.46, 43.0642}, // RIW
    Coordinate{23.9711, 56.9236}, // RIX
    Coordinate{49.375, 14.6625}, // RIY
    Coordinate{119.317, 35.3997}, // RIZ
    Coordinate{81.8183, 17.1083}, // RJA
    Coordinate{88.6163, 24.4369}, // RJH
    Coordinate{14.5703, 45.2169}, // RJK
    Coordinate{-2.32028, 42.4603}, // RJL
    Coordinate{56.0508, 30.2975}, // RJN
    Coordinate{-122.546, 41.7303}, // RKC
    Coordinate{-69.0992, 44.06}, // RKD
    Coordinate{12.1314, 55.5856}, // RKE
    Coordinate{-81.0572, 34.9878}, // RKH
    Coordinate{99.7044, -2.1001}, // RKI
    Coordinate{-97.0436, 28.0861}, // RKP
    Coordinate{-94.6211, 35.0217}, // RKR
    Coordinate{-109.065, 41.5942}, // RKS
    Coordinate{55.9389, 25.6136}, // RKT
    Coordinate{-21.9406, 64.13}, // RKV
    Coordinate{-84.6897, 35.9222}, // RKW
    Coordinate{89.3069, 29.3517}, // RKZ
    Coordinate{-119.304, 46.3056}, // RLD
    Coordinate{12.2783, 53.9183}, // RLG
    Coordinate{107.739, 40.9264}, // RLK
    Coordinate{-65.1858, -32.3845}, // RLO
    Coordinate{7.36, 18.7889}, // RLT
    Coordinate{148.775, -26.545}, // RMA
    Coordinate{55.7833, 24.2417}, // RMB
    Coordinate{81.8183, 17.1103}, // RMD
    Coordinate{-75.4069, 43.2339}, // RME
    Coordinate{34.5836, 25.5569}, // RMF
    Coordinate{-85.1586, 34.3508}, // RMG
    Coordinate{12.6094, 44.0194}, // RMI
    Coordinate{140.673, -34.1967}, // RMK
    Coordinate{79.8862, 6.82199}, // RML
    Coordinate{-77.4556, 38.3981}, // RMN
    Coordinate{-150.141, 65.5078}, // RMP
    Coordinate{-152.805, -22.6387}, // RMT
    Coordinate{-1.12411, 37.8036}, // RMU
    Coordinate{-120.039, 37.5108}, // RMY
    Coordinate{161.979, -9.85472}, // RNA
    Coordinate{15.265, 56.2667}, // RNB
    Coordinate{-85.8439, 35.6986}, // RNC
    Coordinate{3.99972, 46.0527}, // RNE
    Coordinate{-92.5391, 45.1478}, // RNH
    Coordinate{-83.0606, 12.1714}, // RNI
    Coordinate{128.402, 27.0439}, // RNJ
    Coordinate{160.071, -11.5583}, // RNL
    Coordinate{57.0506, 21.3748}, // RNM
    Coordinate{14.7594, 55.0633}, // RNN
    Coordinate{-119.768, 39.4992}, // RNO
    Coordinate{166.887, 11.1572}, // RNP
    Coordinate{-1.73222, 48.0719}, // RNS
    Coordinate{-122.216, 47.4931}, // RNT
    Coordinate{-90.7578, 33.7611}, // RNV
    Coordinate{-87.1825, 40.9478}, // RNZ
    Coordinate{-79.9756, 37.3256}, // ROA
    Coordinate{-10.3622, 6.23389}, // ROB
    Coordinate{-77.6725, 43.1189}, // ROC
    Coordinate{19.8999, -33.8124}, // ROD
    Coordinate{-94.1069, 36.3725}, // ROG
    Coordinate{103.774, 16.1167}, // ROI
    Coordinate{150.475, -23.3817}, // ROK
    Coordinate{-73.1057, 5.76442}, // RON
    Coordinate{-54.7242, -16.5853}, // ROO
    Coordinate{145.242, 14.1744}, // ROP
    Coordinate{134.544, 7.36722}, // ROR
    Coordinate{-60.7844, -32.9036}, // ROS
    Coordinate{176.317, -38.1092}, // ROT
    Coordinate{39.924, 47.4716}, // ROV
    Coordinate{-104.531, 33.3016}, // ROW
    Coordinate{-70.2594, -45.7056}, // ROY
    Coordinate{-97.6597, 39.8178}, // RPB
    Coordinate{-89.0783, 41.8931}, // RPJ
    Coordinate{4.15667, 49.2086}, // RPK
    Coordinate{134.747, -14.7228}, // RPM
    Coordinate{35.5719, 32.981}, // RPN
    Coordinate{81.7385, 21.1803}, // RPR
    Coordinate{-108.543, 46.475}, // RPX
    Coordinate{-109.067, 35.6519}, // RQE
    Coordinate{-98.0058, 35.4728}, // RQO
    Coordinate{63.3608, -19.7575}, // RRG
    Coordinate{84.8097, 22.2565}, // RRK
    Coordinate{-89.7128, 45.1989}, // RRL
    Coordinate{-142.477, -16.045}, // RRR
    Coordinate{11.3423, 62.5784}, // RRS
    Coordinate{-95.3483, 48.9414}, // RRT
    Coordinate{-64.2794, -36.5919}, // RSA
    Coordinate{-76.1778, 24.8917}, // RSD
    Coordinate{151.255, -33.8706}, // RSE
    Coordinate{-161.319, 61.775}, // RSH
    Coordinate{-122.868, 48.6456}, // RSJ
    Coordinate{-92.5883, 32.5147}, // RSN
    Coordinate{34.3364, 11.7858}, // RSS
    Coordinate{-92.5, 43.9083}, // RST
    Coordinate{127.617, 34.8423}, // RSU
    Coordinate{-87.6497, 39.0161}, // RSV
    Coordinate{-81.7553, 26.5361}, // RSW
    Coordinate{177.071, -12.4825}, // RTA
    Coordinate{-86.5222, 16.3172}, // RTB
    Coordinate{73.3278, 17.0122}, // RTC
    Coordinate{}, // RTG
    Coordinate{-95.1392, 43.3875}, // RTL
    Coordinate{4.43333, 51.95}, // RTM
    Coordinate{-104.502, 36.7417}, // RTN
    Coordinate{115.54, -32.0067}, // RTS
    Coordinate{46.0467, 51.565}, // RTW
    Coordinate{30.9122, 3.04722}, // RUA
    Coordinate{55.1042, 36.4253}, // RUD
    Coordinate{-93.0933, 35.2592}, // RUE
    Coordinate{-100.024, 48.3903}, // RUG
    Coordinate{46.6989, 24.9578}, // RUH
    Coordinate{-105.535, 33.4628}, // RUI
    Coordinate{82.1942, 28.6272}, // RUK
    Coordinate{86.5506, 27.3036}, // RUM
    Coordinate{55.5164, -20.89}, // RUN
    Coordinate{89.9067, 26.1397}, // RUP
    Coordinate{-151.368, -22.4335}, // RUR
    Coordinate{160.825, -9.86167}, // RUS
    Coordinate{-72.9497, 43.53}, // RUT
    Coordinate{-90.4453, 15.992}, // RUV
    Coordinate{-89.0078, 14.9167}, // RUY
    Coordinate{47.8203, -22.805}, // RVA
    Coordinate{-50.9561, -17.8347}, // RVD
    Coordinate{-71.9, 6.91667}, // RVE
    Coordinate{30.5883, 59.98}, // RVH
    Coordinate{39.8183, 47.2583}, // RVI
    Coordinate{11.1461, 64.8383}, // RVK
    Coordinate{25.8308, 66.5617}, // RVN
    Coordinate{-110.228, 38.9614}, // RVR
    Coordinate{-95.9846, 36.0396}, // RVS
    Coordinate{120.208, -33.7972}, // RVT
    Coordinate{-147.7, -23.8861}, // RVV
    Coordinate{-55.4761, -30.9744}, // RVY
    Coordinate{-77.8919, 35.8564}, // RWI
    Coordinate{-107.2, 41.8056}, // RWL
    Coordinate{26.1417, 50.6072}, // RWN
    Coordinate{-96.7042, 30.5156}, // RWV
    Coordinate{-111.805, 43.8339}, // RXE
    Coordinate{122.752, 11.5978}, // RXS
    Coordinate{38.925, 58.1017}, // RYB
    Coordinate{10.7856, 59.3789}, // RYG
    Coordinate{70.2797, 28.3839}, // RYK
    Coordinate{-111.174, 32.1422}, // RYN
    Coordinate{-72.2219, -51.6092}, // RYO
    Coordinate{-88.7233, 43.1697}, // RYV
    Coordinate{-84.5986, 34.0131}, // RYY
    Coordinate{-68.5792, -50.0167}, // RZA
    Coordinate{22.0189, 50.11}, // RZE
    Coordinate{39.855, 54.555}, // RZN
    Coordinate{119.508, 10.8189}, // RZP
    Coordinate{50.6796, 36.9092}, // RZR
    Coordinate{68.8739, 26.9594}, // RZS
    Coordinate{-77.7094, 36.4394}, // RZZ
    Coordinate{-106.824, 41.4447}, // SAA
    Coordinate{-63.2206, 17.6456}, // SAB
    Coordinate{-121.493, 38.5125}, // SAC
    Coordinate{-109.635, 32.8533}, // SAD
    Coordinate{-106.089, 35.6172}, // SAF
    Coordinate{74.3789, 19.6886}, // SAG
    Coordinate{44.2197, 15.4764}, // SAH
    Coordinate{-19.5728, 65.7317}, // SAK
    Coordinate{-89.0557, 13.4409}, // SAL
    Coordinate{150.789, -9.67133}, // SAM
    Coordinate{-117.19, 32.7336}, // SAN
    Coordinate{-87.9236, 15.4528}, // SAP
    Coordinate{-78.05, 25.05}, // SAQ
    Coordinate{-115.952, 33.2411}, // SAS
    Coordinate{-98.472, 29.527}, // SAT
    Coordinate{121.898, -10.4278}, // SAU
    Coordinate{-81.2022, 32.1275}, // SAV
    Coordinate{29.3092, 40.8983}, // SAW
    Coordinate{11.2549, 43.2564}, // SAY
    Coordinate{-8.43333, 4.66667}, // SAZ
    Coordinate{-119.84, 34.4261}, // SBA
    Coordinate{-71.1657, 7.80278}, // SBB
    Coordinate{-117.235, 34.0953}, // SBD
    Coordinate{68.6365, 33.321}, // SBF
    Coordinate{95.3416, 5.8745}, // SBG
    Coordinate{-62.8439, 17.9044}, // SBH
    Coordinate{-13.3585, 12.5727}, // SBI
    Coordinate{-39.8336, -18.7214}, // SBJ
    Coordinate{-2.85667, 48.5375}, // SBK
    Coordinate{-65.4353, -13.7622}, // SBL
    Coordinate{-87.8517, 43.7697}, // SBM
    Coordinate{-86.3172, 41.7083}, // SBN
    Coordinate{-111.838, 39.0292}, // SBO
    Coordinate{-120.642, 35.2369}, // SBP
    Coordinate{67.8431, 29.5744}, // SBQ
    Coordinate{142.625, -9.37833}, // SBR
    Coordinate{-106.866, 40.5161}, // SBS
    Coordinate{72.0522, 71.2192}, // SBT
    Coordinate{111.985, 2.26139}, // SBW
    Coordinate{-111.871, 48.5406}, // SBX
    Coordinate{-75.5094, 38.34}, // SBY
    Coordinate{24.0856, 45.7858}, // SBZ
    Coordinate{-96.63, 41.6103}, // SCB
    Coordinate{-148.465, 70.1947}, // SCC
    Coordinate{-86.3056, 33.1719}, // SCD
    Coordinate{-77.8486, 40.8492}, // SCE
    Coordinate{-111.911, 33.6228}, // SCF
    Coordinate{-73.9289, 42.8525}, // SCH
    Coordinate{-72.2015, 7.80504}, // SCI
    Coordinate{-121.238, 37.8942}, // SCK
    Coordinate{-70.7856, -33.3928}, // SCL
    Coordinate{-165.571, 61.8453}, // SCM
    Coordinate{7.10944, 49.2144}, // SCN
    Coordinate{51.0919, 43.86}, // SCO
    Coordinate{6.59917, 44.7006}, // SCP
    Coordinate{-8.41514, 42.8963}, // SCQ
    Coordinate{-1.29611, 60.4328}, // SCS
    Coordinate{53.9056, 12.6306}, // SCT
    Coordinate{-75.8356, 19.97}, // SCU
    Coordinate{26.354, 47.6875}, // SCV
    Coordinate{50.8383, 61.6417}, // SCW
    Coordinate{-95.2014, 16.2125}, // SCX
    Coordinate{-89.6175, -0.910278}, // SCY
    Coordinate{165.798, -10.7197}, // SCZ
    Coordinate{-77.1194, 43.2347}, // SDC
    Coordinate{13.5767, -14.9333}, // SDD
    Coordinate{-64.2997, -27.7561}, // SDE
    Coordinate{-85.7364, 38.1742}, // SDF
    Coordinate{47.0092, 35.2459}, // SDG
    Coordinate{-88.775, 14.7772}, // SDH
    Coordinate{146.465, -5.62859}, // SDI
    Coordinate{140.917, 38.1397}, // SDJ
    Coordinate{118.059, 5.90083}, // SDK
    Coordinate{17.4428, 62.5281}, // SDL
    Coordinate{-116.98, 32.5722}, // SDM
    Coordinate{6.10583, 61.83}, // SDN
    Coordinate{20.9629, 44.6447}, // SDO
    Coordinate{-160.521, 55.3136}, // SDP
    Coordinate{-69.6689, 18.4297}, // SDQ
    Coordinate{-3.82, 43.4269}, // SDR
    Coordinate{138.414, 38.0611}, // SDS
    Coordinate{72.35, 34.8078}, // SDT
    Coordinate{-43.1628, -22.9103}, // SDU
    Coordinate{34.7794, 32.1108}, // SDV
    Coordinate{-111.79, 34.85}, // SDX
    Coordinate{-104.192, 47.7069}, // SDY
    Coordinate{-122.309, 47.4489}, // SEA
    Coordinate{14.4725, 26.987}, // SEB
    Coordinate{-116.973, 32.8261}, // SEE
    Coordinate{-81.3425, 27.4564}, // SEF
    Coordinate{-76.8642, 40.8211}, // SEG
    Coordinate{153.716, 67.4633}, // SEK
    Coordinate{-86.9878, 32.3439}, // SEM
    Coordinate{0.693333, 51.5703}, // SEN
    Coordinate{-6.64422, 7.96}, // SEO
    Coordinate{102.14, 1.37127}, // SEQ
    Coordinate{-85.9083, 38.9247}, // SER
    Coordinate{-86.9536, 32.4389}, // SES
    Coordinate{34.8214, -2.45694}, // SEU
    Coordinate{25.5053, 29.3469}, // SEW
    Coordinate{-12.2072, 15.1794}, // SEY
    Coordinate{55.5219, -4.67434}, // SEZ
    Coordinate{10.6886, 34.7178}, // SFA
    Coordinate{-81.2375, 28.7778}, // SFB
    Coordinate{-61.27, 15.8686}, // SFC
    Coordinate{-67.4439, 7.88306}, // SFD
    Coordinate{120.303, 16.5956}, // SFE
    Coordinate{-117.323, 47.6831}, // SFF
    Coordinate{-63.0472, 18.0999}, // SFG
    Coordinate{-114.816, 30.9303}, // SFH
    Coordinate{-50.6894, 67.0169}, // SFJ
    Coordinate{18.0936, 46.8572}, // SFK
    Coordinate{-24.48, 14.885}, // SFL
    Coordinate{-70.7081, 43.3939}, // SFM
    Coordinate{-60.8089, -31.7117}, // SFN
    Coordinate{-122.375, 37.6189}, // SFO
    Coordinate{38.8469, 37.0939}, // SFQ
    Coordinate{120.271, 14.7944}, // SFS
    Coordinate{21.0769, 64.6247}, // SFT
    Coordinate{-71.4914, 41.9208}, // SFZ
    Coordinate{71.5, 37.5667}, // SGA
    Coordinate{73.4022, 61.3439}, // SGC
    Coordinate{9.79173, 54.9644}, // SGD
    Coordinate{8.08306, 50.7078}, // SGE
    Coordinate{-93.3886, 37.2456}, // SGF
    Coordinate{-83.8403, 39.8403}, // SGH
    Coordinate{144.323, -5.125}, // SGK
    Coordinate{-73.1289, 6.59028}, // SGL
    Coordinate{-112.939, 27.2969}, // SGM
    Coordinate{106.652, 10.8189}, // SGN
    Coordinate{148.595, -28.05}, // SGO
    Coordinate{120.14, -20.425}, // SGP
    Coordinate{-95.6567, 29.6222}, // SGR
    Coordinate{119.743, 5.04694}, // SGS
    Coordinate{-91.575, 34.5995}, // SGT
    Coordinate{-113.51, 37.0364}, // SGU
    Coordinate{-65.3503, -41.5917}, // SGV
    Coordinate{-134.158, 56.8864}, // SGW
    Coordinate{35.5811, -10.6808}, // SGX
    Coordinate{-135.316, 59.46}, // SGY
    Coordinate{100.617, 7.18333}, // SGZ
    Coordinate{121.336, 31.1981}, // SHA
    Coordinate{144.96, 43.5775}, // SHB
    Coordinate{38.2708, 14.0794}, // SHC
    Coordinate{-78.8964, 38.2639}, // SHD
    Coordinate{123.484, 41.64}, // SHE
    Coordinate{85.8911, 44.2417}, // SHF
    Coordinate{-157.163, 66.8881}, // SHG
    Coordinate{-166.089, 66.2494}, // SHH
    Coordinate{125.145, 24.8267}, // SHI
    Coordinate{55.5172, 25.3286}, // SHJ
    Coordinate{28.7689, -29.7308}, // SHK
    Coordinate{91.978, 25.7032}, // SHL
    Coordinate{135.364, 33.6622}, // SHM
    Coordinate{-123.147, 47.2336}, // SHN
    Coordinate{31.7169, -26.3586}, // SHO
    Coordinate{153.372, -27.9217}, // SHQ
    Coordinate{-106.98, 44.7692}, // SHR
    Coordinate{112.279, 30.3222}, // SHS
    Coordinate{145.393, -36.4289}, // SHT
    Coordinate{132.158, -11.1328}, // SHU
    Coordinate{-93.8256, 32.4467}, // SHV
    Coordinate{47.1211, 17.4669}, // SHW
    Coordinate{-159.569, 62.6922}, // SHX
    Coordinate{33.5, -3.61}, // SHY
    Coordinate{28.5536, -29.2667}, // SHZ
    Coordinate{109.12, 34.3767}, // SIA
    Coordinate{13.4, -3.74639}, // SIB
    Coordinate{-79.0778, 8.2625}, // SIC
    Coordinate{-22.95, 16.7376}, // SID
    Coordinate{84.98, 27.1594}, // SIF
    Coordinate{-66.0988, 18.4567}, // SIG
    Coordinate{-10.1847, 29.3672}, // SII
    Coordinate{-18.9167, 66.1333}, // SIJ
    Coordinate{-89.5617, 36.8989}, // SIK
    Coordinate{103.989, 1.35917}, // SIN
    Coordinate{145.083, -40.835}, // SIO
    Coordinate{33.9753, 45.0522}, // SIP
    Coordinate{104.579, -8.43001}, // SIQ
    Coordinate{7.32676, 46.2196}, // SIR
    Coordinate{23, -27.65}, // SIS
    Coordinate{-135.362, 57.0472}, // SIT
    Coordinate{-84.7769, 13.7167}, // SIU
    Coordinate{-87.4483, 39.1147}, // SIV
    Coordinate{98.9322, 2.667}, // SIW
    Coordinate{98.8905, 1.55446}, // SIX
    Coordinate{-122.468, 41.7814}, // SIY
    Coordinate{-64.8167, -13.0667}, // SJB
    Coordinate{-121.929, 37.3628}, // SJC
    Coordinate{-109.721, 23.1517}, // SJD
    Coordinate{-72.6393, 2.57972}, // SJE
    Coordinate{121.047, 12.3614}, // SJI
    Coordinate{18.3314, 43.8247}, // SJJ
    Coordinate{-45.8711, -23.2289}, // SJK
    Coordinate{-66.9858, -0.14806}, // SJL
    Coordinate{-71.2333, 18.8333}, // SJM
    Coordinate{-109.379, 34.5186}, // SJN
    Coordinate{-84.2089, 9.99389}, // SJO
    Coordinate{-49.4047, -20.8161}, // SJP
    Coordinate{24.3056, -17.4767}, // SJQ
    Coordinate{-60.8, -17.8324}, // SJS
    Coordinate{-100.496, 31.355}, // SJT
    Coordinate{-66.0019, 18.4392}, // SJU
    Coordinate{-62.4704, -16.2667}, // SJV
    Coordinate{114.697, 38.2808}, // SJW
    Coordinate{-88.1308, 18.3556}, // SJX
    Coordinate{22.8319, 62.6936}, // SJY
    Coordinate{-28.1703, 38.6628}, // SJZ
    Coordinate{-62.7186, 17.3111}, // SKB
    Coordinate{141.8, -8.08333}, // SKC
    Coordinate{66.9839, 39.7006}, // SKD
    Coordinate{9.56694, 59.185}, // SKE
    Coordinate{-98.5865, 29.38}, // SKF
    Coordinate{22.9709, 40.5197}, // SKG
    Coordinate{81.6358, 28.5858}, // SKH
    Coordinate{6.95108, 36.8627}, // SKI
    Coordinate{-161.224, 64.3711}, // SKK
    Coordinate{-5.82417, 57.2536}, // SKL
    Coordinate{15.0261, 68.5808}, // SKN
    Coordinate{5.20694, 12.9161}, // SKO
    Coordinate{21.6214, 41.9616}, // SKP
    Coordinate{28.3703, -30.0389}, // SKQ
    Coordinate{38.975, 5.69167}, // SKR
    Coordinate{9.29078, 55.2219}, // SKS
    Coordinate{74.3639, 32.5356}, // SKT
    Coordinate{24.4872, 38.9675}, // SKU
    Coordinate{34.0625, 28.6853}, // SKV
    Coordinate{-151.191, 61.9653}, // SKW
    Coordinate{45.215, 54.125}, // SKX
    Coordinate{-82.6522, 41.4333}, // SKY
    Coordinate{68.7917, 27.7219}, // SKZ
    Coordinate{-65.4786, -24.8444}, // SLA
    Coordinate{-95.2407, 42.5972}, // SLB
    Coordinate{-111.978, 40.7883}, // SLC
    Coordinate{19.1342, 48.6381}, // SLD
    Coordinate{-123.003, 44.9094}, // SLE
    Coordinate{-94.49, 36.1919}, // SLG
    Coordinate{167.537, -13.8517}, // SLH
    Coordinate{26.3667, -12.1742}, // SLI
    Coordinate{117.762, -22.2553}, // SLJ
    Coordinate{-74.2061, 44.3853}, // SLK
    Coordinate{54.0922, 17.0389}, // SLL
    Coordinate{-5.50194, 40.9519}, // SLM
    Coordinate{-97.6522, 38.7906}, // SLN
    Coordinate{-88.9642, 38.6428}, // SLO
    Coordinate{-100.931, 22.2543}, // SLP
    Coordinate{-157.166, 61.7006}, // SLQ
    Coordinate{-95.6211, 33.1597}, // SLR
    Coordinate{27.1799, 44.055}, // SLS
    Coordinate{-106.049, 38.5383}, // SLT
    Coordinate{-60.9931, 14.02}, // SLU
    Coordinate{77.0679, 31.0817}, // SLV
    Coordinate{-100.929, 25.5494}, // SLW
    Coordinate{-71.2, 21.3333}, // SLX
    Coordinate{66.5866, 66.5901}, // SLY
    Coordinate{-44.2361, -2.58694}, // SLZ
    Coordinate{-25.1706, 36.9714}, // SMA
    Coordinate{-69.3373, -52.7367}, // SMB
    Coordinate{19.6599, 45.0365}, // SMC
    Coordinate{-85.1528, 41.1433}, // SMD
    Coordinate{-84.6156, 37.0536}, // SME
    Coordinate{-121.591, 38.6956}, // SMF
    Coordinate{-76.7681, -12.4}, // SMG
    Coordinate{26.9117, 37.69}, // SMI
    Coordinate{-162.11, 63.49}, // SMK
    Coordinate{-75.2793, 23.5901}, // SML
    Coordinate{118.596, 4.44972}, // SMM
    Coordinate{-113.881, 45.1239}, // SMN
    Coordinate{-118.451, 34.0158}, // SMO
    Coordinate{151.55, -4.35}, // SMP
    Coordinate{112.975, -2.49917}, // SMQ
    Coordinate{-74.2306, 11.1194}, // SMR
    Coordinate{49.8158, -17.0939}, // SMS
    Coordinate{-55.6689, -12.4728}, // SMT
    Coordinate{9.88389, 46.5339}, // SMV
    Coordinate{-11.6847, 26.7317}, // SMW
    Coordinate{-120.457, 34.8989}, // SMX
    Coordinate{-13.3, 13.0467}, // SMY
    Coordinate{-54.4167, 4.35}, // SMZ
    Coordinate{-117.868, 33.6756}, // SNA
    Coordinate{130.654, -11.4228}, // SNB
    Coordinate{-80.9889, -2.205}, // SNC
    Coordinate{-24.2839, 16.5881}, // SNE
    Coordinate{-68.7332, 10.2834}, // SNF
    Coordinate{-60.9778, -16.3847}, // SNG
    Coordinate{151.991, -28.6203}, // SNH
    Coordinate{-9.0668, 5.03432}, // SNI
    Coordinate{-100.948, 32.6996}, // SNK
    Coordinate{-96.9428, 35.3572}, // SNL
    Coordinate{-65.6434, -14.9667}, // SNM
    Coordinate{-8.92472, 52.7019}, // SNN
    Coordinate{104.112, 17.1951}, // SNO
    Coordinate{-170.221, 57.1672}, // SNP
    Coordinate{-2.16111, 47.3106}, // SNR
    Coordinate{-121.606, 36.6628}, // SNS
    Coordinate{-73.5056, 7.38333}, // SNT
    Coordinate{-79.9436, 22.4922}, // SNU
    Coordinate{-61.1447, 4.55472}, // SNV
    Coordinate{94.3, 18.4564}, // SNW
    Coordinate{-69.3852, 19.0619}, // SNX
    Coordinate{-102.985, 41.0997}, // SNY
    Coordinate{-43.7192, -22.9322}, // SNZ
    Coordinate{17.1592, 46.6864}, // SOB
    Coordinate{110.757, -7.51611}, // SOC
    Coordinate{-47.4864, -23.4831}, // SOD
    Coordinate{14.1333, 2}, // SOE
    Coordinate{23.4083, 42.695}, // SOF
    Coordinate{7.13778, 61.1561}, // SOG
    Coordinate{20.9597, 69.7867}, // SOJ
    Coordinate{28.06, -29.8383}, // SOK
    Coordinate{-64.1511, 8.94528}, // SOM
    Coordinate{167.22, -15.505}, // SON
    Coordinate{17.0983, 61.2614}, // SOO
    Coordinate{-79.3911, 35.2372}, // SOP
    Coordinate{131.289, -0.894167}, // SOQ
    Coordinate{-1.35667, 50.9503}, // SOU
    Coordinate{-151.704, 59.4425}, // SOV
    Coordinate{-110.006, 34.2656}, // SOW
    Coordinate{-72.9703, 5.67639}, // SOX
    Coordinate{-2.64139, 59.1553}, // SOY
    Coordinate{-81.9565, 34.9157}, // SPA
    Coordinate{-64.9408, 18.3386}, // SPB
    Coordinate{-17.7556, 28.6264}, // SPC
    Coordinate{88.9085, 25.7592}, // SPD
    Coordinate{-103.783, 44.4803}, // SPF
    Coordinate{-82.6269, 27.765}, // SPG
    Coordinate{-89.6781, 39.8442}, // SPI
    Coordinate{22.5167, 36.9667}, // SPJ
    Coordinate{20.9596, 44.3499}, // SPL
    Coordinate{-69.3, 18.45}, // SPM
    Coordinate{145.729, 15.1189}, // SPN
    Coordinate{17.7196, -14.6576}, // SPP
    Coordinate{-87.9711, 17.9139}, // SPR
    Coordinate{-98.4919, 33.9889}, // SPS
    Coordinate{16.2981, 43.5389}, // SPU
    Coordinate{20.1294, 44.9762}, // SPV
    Coordinate{-95.2028, 43.1656}, // SPW
    Coordinate{30.8944, 30.1097}, // SPX
    Coordinate{-6.66082, 4.74672}, // SPY
    Coordinate{-94.1192, 36.1764}, // SPZ
    Coordinate{-120.076, 34.6069}, // SQA
    Coordinate{119.358, -31.2417}, // SQC
    Coordinate{117.961, 28.3799}, // SQD
    Coordinate{111.475, 0.0636111}, // SQG
    Coordinate{104.035, 21.2147}, // SQH
    Coordinate{117.845, 26.4281}, // SQJ
    Coordinate{-122.249, 37.5119}, // SQL
    Coordinate{17.6967, 64.9556}, // SQO
    Coordinate{23.3947, 55.8939}, // SQQ
    Coordinate{121.283, -2.5377}, // SQR
    Coordinate{-89.0098, 17.1859}, // SQS
    Coordinate{-123.187, 48.0981}, // SQV
    Coordinate{9.17278, 56.55}, // SQW
    Coordinate{-53.5033, -26.7811}, // SQX
    Coordinate{-52.0328, -31.3833}, // SQY
    Coordinate{-54.5222, -27.9089}, // SRA
    Coordinate{-66.7872, -14.0729}, // SRB
    Coordinate{-91.7375, 35.2106}, // SRC
    Coordinate{-64.7, -13.2833}, // SRD
    Coordinate{-65.1491, -19.2383}, // SRE
    Coordinate{110.374, -6.97139}, // SRG
    Coordinate{18.3794, 9.15111}, // SRH
    Coordinate{117.159, -0.481667}, // SRI
    Coordinate{-66.75, -14.8667}, // SRJ
    Coordinate{145.291, -42.1556}, // SRN
    Coordinate{5.33972, 59.7928}, // SRP
    Coordinate{-82.5544, 27.3956}, // SRQ
    Coordinate{33.6187, 1.72231}, // SRT
    Coordinate{-156.589, 61.7897}, // SRV
    Coordinate{-80.5203, 35.6458}, // SRW
    Coordinate{53.1936, 36.6358}, // SRY
    Coordinate{-63.1714, -17.8114}, // SRZ
    Coordinate{-38.3225, -12.9086}, // SSA
    Coordinate{-64.705, 17.7472}, // SSB
    Coordinate{-70.705, -32.7458}, // SSD
    Coordinate{75.934, 17.6274}, // SSE
    Coordinate{-98.4711, 29.3369}, // SSF
    Coordinate{8.70861, 3.755}, // SSG
    Coordinate{34.3947, 27.9772}, // SSH
    Coordinate{-81.3914, 31.1519}, // SSI
    Coordinate{12.4689, 65.9567}, // SSJ
    Coordinate{-70.8686, 5.13056}, // SSL
    Coordinate{-84.3683, 46.4792}, // SSM
    Coordinate{-45.0453, -22.0917}, // SSO
    Coordinate{-79.1792, 48.9167}, // SSQ
    Coordinate{168.153, -15.4715}, // SSR
    Coordinate{-56.7217, -36.55}, // SST
    Coordinate{14.2471, -6.26986}, // SSY
    Coordinate{8.35389, 55.99}, // STA
    Coordinate{-71.9428, 8.97417}, // STB
    Coordinate{-94.06, 45.5467}, // STC
    Coordinate{-72.035, 7.565}, // STD
    Coordinate{-89.5303, 44.545}, // STE
    Coordinate{-88.8486, 33.4331}, // STF
    Coordinate{-169.664, 56.5772}, // STG
    Coordinate{-113.56, 51.1342}, // STH
    Coordinate{-70.6047, 19.4061}, // STI
    Coordinate{-94.9097, 39.7719}, // STJ
    Coordinate{-54.7858, -2.42472}, // STM
    Coordinate{0.235, 51.885}, // STN
    Coordinate{-93.06, 44.9344}, // STP
    Coordinate{-78.5025, 41.4125}, // STQ
    Coordinate{9.22194, 48.69}, // STR
    Coordinate{-64.9733, 18.3372}, // STT
    Coordinate{72.7428, 21.1153}, // STV
    Coordinate{42.1133, 45.11}, // STW
    Coordinate{-64.8017, 17.7044}, // STX
    Coordinate{-57.9853, -31.4386}, // STY
    Coordinate{-50.5186, -10.4647}, // STZ
    Coordinate{-80.2211, 27.1817}, // SUA
    Coordinate{112.767, -7.38056}, // SUB
    Coordinate{-96.6556, 35.7894}, // SUD
    Coordinate{-87.4217, 44.8436}, // SUE
    Coordinate{16.2422, 38.9053}, // SUF
    Coordinate{125.479, 9.75757}, // SUG
    Coordinate{59.4778, 22.5361}, // SUH
    Coordinate{41.1281, 42.8581}, // SUI
    Coordinate{22.8856, 47.7033}, // SUJ
    Coordinate{130.391, 67.7919}, // SUK
    Coordinate{69.1667, 28.6333}, // SUL
    Coordinate{-80.3614, 33.995}, // SUM
    Coordinate{-114.296, 43.5039}, // SUN
    Coordinate{-121.453, 43.8764}, // SUO
    Coordinate{113.89, -7.02425}, // SUP
    Coordinate{-78.1694, -2.47083}, // SUQ
    Coordinate{-88.5419, 52.7086}, // SUR
    Coordinate{-90.6519, 38.6622}, // SUS
    Coordinate{31.6103, -7.94889}, // SUT
    Coordinate{178.559, -18.0447}, // SUV
    Coordinate{-92.0947, 46.6897}, // SUW
    Coordinate{-96.3844, 42.4025}, // SUX
    Coordinate{117.635, 62.185}, // SUY
    Coordinate{-61.8893, -37.4462}, // SUZ
    Coordinate{-170.492, 63.6864}, // SVA
    Coordinate{50.1747, -14.2786}, // SVB
    Coordinate{-108.156, 32.6367}, // SVC
    Coordinate{-61.1503, 13.1564}, // SVD
    Coordinate{-120.573, 40.3756}, // SVE
    Coordinate{2.46458, 8.01817}, // SVF
    Coordinate{5.63778, 58.8767}, // SVG
    Coordinate{-74.7667, 2.15}, // SVI
    Coordinate{14.6692, 68.2433}, // SVJ
    Coordinate{-88.3692, 16.7284}, // SVK
    Coordinate{28.945, 61.9428}, // SVL
    Coordinate{37.4146, 55.9726}, // SVO
    Coordinate{16.9474, -12.4049}, // SVP
    Coordinate{-5.89889, 37.4181}, // SVQ
    Coordinate{-149.054, 66.0169}, // SVS
    Coordinate{24.0767, -18.5206}, // SVT
    Coordinate{179.341, -16.8028}, // SVU
    Coordinate{-155.575, 61.0972}, // SVW
    Coordinate{60.8036, 56.7414}, // SVX
    Coordinate{-72.4397, 7.84083}, // SVZ
    Coordinate{116.415, 23.5686}, // SWA
    Coordinate{142.74, -37.0717}, // SWC
    Coordinate{-149.419, 60.1269}, // SWD
    Coordinate{143.935, -6.72217}, // SWE
    Coordinate{-74.1047, 41.5042}, // SWF
    Coordinate{143.549, -35.3758}, // SWH
    Coordinate{-96.5861, 33.6242}, // SWI
    Coordinate{167.438, -16.495}, // SWJ
    Coordinate{-97.0856, 36.1611}, // SWO
    Coordinate{14.5667, -22.6583}, // SWP
    Coordinate{117.414, -8.48861}, // SWQ
    Coordinate{-4.06778, 51.6053}, // SWS
    Coordinate{77.66, 60.7083}, // SWT
    Coordinate{159.23, 61.9217}, // SWV
    Coordinate{-100.466, 32.4672}, // SWW
    Coordinate{21.8167, -18.3742}, // SWX
    Coordinate{100.699, 4.21639}, // SWY
    Coordinate{7.63444, 48.5419}, // SXB
    Coordinate{146.965, -38.0917}, // SXE
    Coordinate{13.5206, 52.3786}, // SXF
    Coordinate{23.2667, -16.1125}, // SXG
    Coordinate{54.5394, 25.9083}, // SXI
    Coordinate{-8.59921, 54.2802}, // SXL
    Coordinate{-63.1094, 18.0408}, // SXM
    Coordinate{26.1156, -20.5534}, // SXN
    Coordinate{-50.6883, -11.6319}, // SXO
    Coordinate{-164.848, 62.5206}, // SXP
    Coordinate{-151.038, 60.475}, // SXQ
    Coordinate{74.7742, 33.9871}, // SXR
    Coordinate{37.7667, 6.83333}, // SXU
    Coordinate{78.0641, 11.7812}, // SXV
    Coordinate{-51.99, -6.64028}, // SXX
    Coordinate{-75.4161, 42.3025}, // SXY
    Coordinate{41.8392, 37.9781}, // SXZ
    Coordinate{-152.202, 58.3717}, // SYB
    Coordinate{151.177, -33.9461}, // SYD
    Coordinate{43.7292, 16.9667}, // SYE
    Coordinate{86.7103, 27.8092}, // SYH
    Coordinate{-86.4425, 35.5594}, // SYI
    Coordinate{55.6717, 29.5508}, // SYJ
    Coordinate{-22.7942, 65.0581}, // SYK
    Coordinate{100.959, 22.7933}, // SYM
    Coordinate{-93.0164, 44.4756}, // SYN
    Coordinate{139.787, 38.8122}, // SYO
    Coordinate{-80.9453, 8.08556}, // SYP
    Coordinate{-84.1394, 9.95722}, // SYQ
    Coordinate{-76.1064, 43.1111}, // SYR
    Coordinate{114.082, 71.9289}, // SYS
    Coordinate{4.02111, 46.4064}, // SYT
    Coordinate{142.823, -10.2083}, // SYU
    Coordinate{67.7172, 26.4731}, // SYW
    Coordinate{109.412, 18.3029}, // SYX
    Coordinate{-6.33111, 58.2156}, // SYY
    Coordinate{52.59, 29.5392}, // SYZ
    Coordinate{12.3667, -6.14106}, // SZA
    Coordinate{101.549, 3.13056}, // SZB
    Coordinate{40.9917, 11.7875}, // SZE
    Coordinate{36.5486, 41.2656}, // SZF
    Coordinate{13.0033, 47.7944}, // SZG
    Coordinate{84.8862, 47.4872}, // SZI
    Coordinate{-82.955, 21.6425}, // SZJ
    Coordinate{31.5886, -24.9609}, // SZK
    Coordinate{-119.915, 34.0606}, // SZN
    Coordinate{-119.062, 34.3469}, // SZP
    Coordinate{25.6552, 42.3767}, // SZR
    Coordinate{168.102, -46.8997}, // SZS
    Coordinate{-92.5303, 16.69}, // SZT
    Coordinate{120.401, 31.2631}, // SZV
    Coordinate{11.7834, 53.427}, // SZW
    Coordinate{113.811, 22.6394}, // SZX
    Coordinate{20.9378, 53.4819}, // SZY
    Coordinate{14.9022, 53.5847}, // SZZ
    Coordinate{-60.8322, 11.1497}, // TAB
    Coordinate{125.028, 11.2275}, // TAC
    Coordinate{-104.341, 37.2594}, // TAD
    Coordinate{128.659, 35.8942}, // TAE
    Coordinate{-0.533894, 35.5411}, // TAF
    Coordinate{123.853, 9.66408}, // TAG
    Coordinate{169.224, -19.455}, // TAH
    Coordinate{44.1392, 13.6858}, // TAI
    Coordinate{142.428, -3.199}, // TAJ
    Coordinate{134.016, 34.2142}, // TAK
    Coordinate{-152.109, 65.1744}, // TAL
    Coordinate{-97.8658, 22.2898}, // TAM
    Coordinate{-71.0164, 41.8742}, // TAN
    Coordinate{120.374, 36.2661}, // TAO
    Coordinate{-92.37, 14.7943}, // TAP
    Coordinate{17.4048, 40.5162}, // TAR
    Coordinate{69.2812, 41.2579}, // TAS
    Coordinate{20.2411, 49.0736}, // TAT
    Coordinate{-169.511, -14.2292}, // TAV
    Coordinate{-55.9258, -31.7503}, // TAW
    Coordinate{26.6869, 58.3075}, // TAY
    Coordinate{59.8331, 41.7647}, // TAZ
    Coordinate{80.4876, 9.30544}, // TBA
    Coordinate{109.334, 13.0494}, // TBB
    Coordinate{-111.383, 36.0928}, // TBC
    Coordinate{174.776, -1.22382}, // TBF
    Coordinate{141.226, -5.27861}, // TBG
    Coordinate{122.078, 12.3099}, // TBH
    Coordinate{-75.4522, 24.3153}, // TBI
    Coordinate{8.87694, 36.98}, // TBJ
    Coordinate{-92.1408, 37.7417}, // TBN
    Coordinate{32.8306, -5.07611}, // TBO
    Coordinate{-80.3811, -3.5525}, // TBP
    Coordinate{-81.7369, 32.4828}, // TBR
    Coordinate{44.9547, 41.6692}, // TBS
    Coordinate{-69.9378, -4.25694}, // TBT
    Coordinate{-175.149, -21.2411}, // TBU
    Coordinate{41.4828, 52.8058}, // TBW
    Coordinate{22.4014, -26.0667}, // TBY
    Coordinate{46.235, 38.1339}, // TBZ
    Coordinate{134.183, -19.6344}, // TCA
    Coordinate{-77.3996, 26.7453}, // TCB
    Coordinate{-103.603, 35.1828}, // TCC
    Coordinate{-69.7472, -2.89472}, // TCD
    Coordinate{28.7144, 45.0628}, // TCE
    Coordinate{83.3408, 46.6725}, // TCG
    Coordinate{11.017, -2.85}, // TCH
    Coordinate{-87.6114, 33.2206}, // TCL
    Coordinate{-97.4197, 18.4969}, // TCN
    Coordinate{-78.7492, 1.81456}, // TCO
    Coordinate{34.7781, 29.5878}, // TCP
    Coordinate{-70.2758, -18.0533}, // TCQ
    Coordinate{78.0258, 8.72417}, // TCR
    Coordinate{-107.272, 33.2369}, // TCS
    Coordinate{-156.028, 62.9936}, // TCT
    Coordinate{145.603, -35.8108}, // TCW
    Coordinate{56.8925, 33.6675}, // TCX
    Coordinate{-121.442, 37.6889}, // TCY
    Coordinate{98.4851, 24.9401}, // TCZ
    Coordinate{-71.6584, 5.43049}, // TDA
    Coordinate{-64.9181, -14.8186}, // TDD
    Coordinate{-78.9847, 36.2847}, // TDF
    Coordinate{126.17, 9.06683}, // TDG
    Coordinate{42.9167, 11.7833}, // TDJ
    Coordinate{-59.25, -37.2333}, // TDL
    Coordinate{-122.806, 46.4772}, // TDO
    Coordinate{142.869, -7.62278}, // TDS
    Coordinate{-101.826, 35.17}, // TDW
    Coordinate{102.319, 12.2746}, // TDX
    Coordinate{-83.4822, 41.5647}, // TDZ
    Coordinate{-87.4758, 15.7758}, // TEA
    Coordinate{-74.063, 40.849}, // TEB
    Coordinate{-50.6522, -24.3164}, // TEC
    Coordinate{8.70522, 57.0688}, // TED
    Coordinate{8.1225, 35.432}, // TEE
    Coordinate{122.229, -21.715}, // TEF
    Coordinate{-0.367, 11.8}, // TEG
    Coordinate{96.1346, 27.9417}, // TEI
    Coordinate{-146.691, 60.8725}, // TEK
    Coordinate{117.126, 5.62861}, // TEL
    Coordinate{147.512, -34.4217}, // TEM
    Coordinate{109.309, 27.8833}, // TEN
    Coordinate{-27.0908, 38.7619}, // TER
    Coordinate{36.6575, 15.1028}, // TES
    Coordinate{33.6397, -16.1083}, // TET
    Coordinate{167.65, -45.5331}, // TEU
    Coordinate{-1.21794, 40.4119}, // TEV
    Coordinate{-107.909, 37.9539}, // TEX
    Coordinate{-23.5583, 65.8694}, // TEY
    Coordinate{92.7872, 26.699}, // TEZ
    Coordinate{-64.7253, -3.38028}, // TFF
    Coordinate{149.32, -9.076}, // TFI
    Coordinate{-41.515, -17.8922}, // TFL
    Coordinate{141.642, -5.126}, // TFM
    Coordinate{-16.3459, 28.488}, // TFN
    Coordinate{-16.5725, 28.0444}, // TFS
    Coordinate{111.202, 2.17778}, // TGC
    Coordinate{19.2519, 42.3594}, // TGD
    Coordinate{-85.7756, 32.4919}, // TGE
    Coordinate{103.103, 5.3825}, // TGG
    Coordinate{168.551, -16.8911}, // TGH
    Coordinate{-76.005, -9.29}, // TGI
    Coordinate{167.804, -21.0958}, // TGJ
    Coordinate{24.4125, 46.4677}, // TGM
    Coordinate{146.47, -38.2072}, // TGN
    Coordinate{122.2, 43.5569}, // TGO
    Coordinate{89.9733, 61.59}, // TGP
    Coordinate{-57.4486, -14.6619}, // TGQ
    Coordinate{6.08953, 33.0736}, // TGR
    Coordinate{32.9653, -24.5206}, // TGS
    Coordinate{39.0717, -5.09209}, // TGT
    Coordinate{-87.2169, 14.0617}, // TGU
    Coordinate{26.7001, 43.3068}, // TGV
    Coordinate{-93.0225, 16.5636}, // TGZ
    Coordinate{-86.2467, 35.38}, // THA
    Coordinate{28.6167, -29.5228}, // THB
    Coordinate{-8.13667, 6.06639}, // THC
    Coordinate{105.468, 19.9017}, // THD
    Coordinate{-42.8244, -5.06056}, // THE
    Coordinate{150.579, -24.4939}, // THG
    Coordinate{-9.517, 18.45}, // THI
    Coordinate{99.9348, 20.4829}, // THL
    Coordinate{-115.281, 47.5736}, // THM
    Coordinate{12.3364, 58.3242}, // THN
    Coordinate{-15.3356, 66.2183}, // THO
    Coordinate{-108.213, 43.6583}, // THP
    Coordinate{105.861, 34.5583}, // THQ
    Coordinate{51.3136, 35.6892}, // THR
    Coordinate{99.8181, 17.2378}, // THS
    Coordinate{-10.817, 17.233}, // THT
    Coordinate{-76.8731, 39.9169}, // THV
    Coordinate{87.93, 65.8}, // THX
    Coordinate{5.26917, 14.8775}, // THZ
    Coordinate{19.7206, 41.4147}, // TIA
    Coordinate{-72.7319, 8.63139}, // TIB
    Coordinate{171.917, 7.13333}, // TIC
    Coordinate{1.46297, 35.341}, // TID
    Coordinate{35.415, 7.2025}, // TIE
    Coordinate{40.5444, 21.4833}, // TIF
    Coordinate{-148.234, -15.1197}, // TIH
    Coordinate{65.8642, 32.6053}, // TII
    Coordinate{-116.97, 32.5408}, // TIJ
    Coordinate{-113.624, 51.0575}, // TIL
    Coordinate{136.887, -4.5291}, // TIM
    Coordinate{-8.16667, 27.7}, // TIN
    Coordinate{13.1567, 32.6694}, // TIP
    Coordinate{145.619, 14.9992}, // TIQ
    Coordinate{79.5418, 13.6325}, // TIR
    Coordinate{171.225, -44.3029}, // TIU
    Coordinate{18.7233, 42.4047}, // TIV
    Coordinate{-122.578, 47.2681}, // TIW
    Coordinate{-80.7992, 28.5148}, // TIX
    Coordinate{-11.4333, 18.5667}, // TIY
    Coordinate{142.947, -5.845}, // TIZ
    Coordinate{-64.7013, -21.5557}, // TJA
    Coordinate{103.393, 1.05222}, // TJB
    Coordinate{115.437, -2.21636}, // TJG
    Coordinate{134.787, 35.5128}, // TJH
    Coordinate{-85.9383, 15.9269}, // TJI
    Coordinate{36.3736, 40.3117}, // TJK
    Coordinate{-51.6839, -20.7544}, // TJL
    Coordinate{65.3167, 57.1683}, // TJM
    Coordinate{107.755, -2.74556}, // TJQ
    Coordinate{117.374, 2.83639}, // TJS
    Coordinate{69.805, 37.9883}, // TJU
    Coordinate{-150.094, 62.3206}, // TKA
    Coordinate{9.36028, 4.08917}, // TKC
    Coordinate{-1.77472, 4.89583}, // TKD
    Coordinate{-135.218, 57.7797}, // TKE
    Coordinate{-120.139, 39.32}, // TKF
    Coordinate{105.179, -5.2425}, // TKG
    Coordinate{100.3, 15.2783}, // TKH
    Coordinate{-133.327, 55.9372}, // TKI
    Coordinate{-142.954, 63.3294}, // TKJ
    Coordinate{151.843, 7.46194}, // TKK
    Coordinate{128.881, 27.8364}, // TKN
    Coordinate{28.8847, -29.2347}, // TKO
    Coordinate{29.6703, -4.885}, // TKQ
    Coordinate{88.4017, 26.0164}, // TKR
    Coordinate{134.606, 34.1328}, // TKS
    Coordinate{99.2533, 16.896}, // TKT
    Coordinate{22.2617, 60.5147}, // TKU
    Coordinate{-138.445, -17.3553}, // TKV
    Coordinate{}, // TKW
    Coordinate{-145.027, -14.4577}, // TKX
    Coordinate{175.892, -38.2367}, // TKZ
    Coordinate{-166.339, 65.2403}, // TLA
    Coordinate{72.6114, 33.985}, // TLB
    Coordinate{-99.566, 19.3369}, // TLC
    Coordinate{29.1167, -22.1833}, // TLD
    Coordinate{43.7244, -23.3911}, // TLE
    Coordinate{-153.269, 63.3939}, // TLF
    Coordinate{-84.3503, 30.3967}, // TLH
    Coordinate{120.794, 1.12343}, // TLI
    Coordinate{-155.976, 62.8944}, // TLJ
    Coordinate{111.044, 59.8764}, // TLK
    Coordinate{24.7992, 59.4164}, // TLL
    Coordinate{-1.45753, 35.0134}, // TLM
    Coordinate{6.14611, 43.0972}, // TLN
    Coordinate{89.1006, 43.0306}, // TLQ
    Coordinate{-119.327, 36.1567}, // TLR
    Coordinate{1.36778, 43.635}, // TLS
    Coordinate{-160.969, 61.0969}, // TLT
    Coordinate{-75.5864, 9.5}, // TLU
    Coordinate{34.8828, 32.0094}, // TLV
    Coordinate{-71.6015, -35.3783}, // TLX
    Coordinate{-47.9014, -18.2169}, // TLZ
    Coordinate{-83.4886, 31.4289}, // TMA
    Coordinate{-80.4328, 25.6478}, // TMB
    Coordinate{119.244, -9.40972}, // TMC
    Coordinate{-8.167, 16.233}, // TMD
    Coordinate{-71.7597, 6.45111}, // TME
    Coordinate{73.2097, 2.20972}, // TMF
    Coordinate{118.646, 5.39972}, // TMG
    Coordinate{87.1933, 27.315}, // TMI
    Coordinate{67.31, 37.2867}, // TMJ
    Coordinate{-123.814, 45.4182}, // TMK
    Coordinate{-0.863056, 9.55694}, // TML
    Coordinate{49.3925, -18.1158}, // TMM
    Coordinate{175.97, -2.48624}, // TMN
    Coordinate{-61.4332, 7.25004}, // TMO
    Coordinate{23.5878, 61.4153}, // TMP
    Coordinate{0.0411111, 14.7908}, // TMQ
    Coordinate{5.45083, 22.8111}, // TMR
    Coordinate{6.71222, 0.378056}, // TMS
    Coordinate{-56.3992, -1.48444}, // TMT
    Coordinate{-85.0167, 9.73333}, // TMU
    Coordinate{150.849, -31.0839}, // TMW
    Coordinate{0.276111, 29.2367}, // TMX
    Coordinate{175.549, -37.16}, // TMZ
    Coordinate{117.216, 36.8572}, // TNA
    Coordinate{-167.922, 65.5631}, // TNC
    Coordinate{-79.9972, 21.7883}, // TND
    Coordinate{130.992, 30.605}, // TNE
    Coordinate{2.10611, 48.7514}, // TNF
    Coordinate{-5.91689, 35.7269}, // TNG
    Coordinate{125.704, 42.2539}, // TNH
    Coordinate{80.8544, 24.5572}, // TNI
    Coordinate{104.532, 0.9225}, // TNJ
    Coordinate{-165.272, 60.5756}, // TNK
    Coordinate{25.7, 49.525}, // TNL
    Coordinate{120.204, 22.9503}, // TNN
    Coordinate{-85.8132, 10.3156}, // TNO
    Coordinate{-115.946, 34.1317}, // TNP
    Coordinate{47.4789, -18.7969}, // TNR
    Coordinate{-128.203, 61.9569}, // TNS
    Coordinate{-80.8969, 25.8617}, // TNT
    Coordinate{-93.0217, 41.6744}, // TNU
    Coordinate{-77.5735, -1.06281}, // TNW
    Coordinate{106.014, 13.5317}, // TNX
    Coordinate{-118.34, 33.8033}, // TOA
    Coordinate{23.8375, 32.0961}, // TOB
    Coordinate{-83.2964, 34.5928}, // TOC
    Coordinate{104.16, 2.81889}, // TOD
    Coordinate{8.11056, 33.9397}, // TOE
    Coordinate{85.2117, 56.3833}, // TOF
    Coordinate{-160.397, 59.0536}, // TOG
    Coordinate{166.638, -13.3275}, // TOH
    Coordinate{-86.0122, 31.8606}, // TOI
    Coordinate{-83.8078, 41.5868}, // TOL
    Coordinate{-3.0075, 16.7306}, // TOM
    Coordinate{-82.9589, 8.82611}, // TOO
    Coordinate{-95.6225, 39.0686}, // TOP
    Coordinate{-70.0658, -22.1425}, // TOQ
    Coordinate{-104.153, 42.0644}, // TOR
    Coordinate{18.9178, 69.6814}, // TOS
    Coordinate{-56.3275, 5.86583}, // TOT
    Coordinate{165.259, -20.7903}, // TOU
    Coordinate{-53.6967, -24.6853}, // TOW
    Coordinate{137.188, 36.6483}, // TOY
    Coordinate{-7.67361, 8.28972}, // TOZ
    Coordinate{-82.5333, 27.9756}, // TPA
    Coordinate{-76.3375, -0.122778}, // TPC
    Coordinate{121.224, 25.0764}, // TPE
    Coordinate{-82.4492, 27.9156}, // TPF
    Coordinate{100.715, 4.86639}, // TPG
    Coordinate{-117.087, 38.0603}, // TPH
    Coordinate{146.989, -8.367}, // TPI
    Coordinate{87.6972, 27.3515}, // TPJ
    Coordinate{-97.4078, 31.1519}, // TPL
    Coordinate{-75.5264, -0.776111}, // TPN
    Coordinate{-76.3732, -6.50874}, // TPP
    Coordinate{-104.843, 21.4194}, // TPQ
    Coordinate{117.869, -22.7461}, // TPR
    Coordinate{12.4933, 37.9119}, // TPS
    Coordinate{81.15, 28.5169}, // TPU
    Coordinate{-95.0044, 35.9303}, // TQH
    Coordinate{-62.7724, -35.9711}, // TQL
    Coordinate{69.5324, 36.7707}, // TQN
    Coordinate{140.888, -21.835}, // TQP
    Coordinate{124.675, 24.6539}, // TRA
    Coordinate{-76.7483, 8.06667}, // TRB
    Coordinate{-103.411, 25.5681}, // TRC
    Coordinate{10.9242, 63.4575}, // TRD
    Coordinate{-6.87139, 56.5008}, // TRE
    Coordinate{10.2586, 59.1867}, // TRF
    Coordinate{176.196, -37.6719}, // TRG
    Coordinate{-117.327, 35.8125}, // TRH
    Coordinate{-82.4075, 36.4753}, // TRI
    Coordinate{117.566, 3.32667}, // TRK
    Coordinate{-96.2674, 32.7092}, // TRL
    Coordinate{-116.16, 33.6267}, // TRM
    Coordinate{7.64959, 45.2018}, // TRN
    Coordinate{152.514, -31.8886}, // TRO
    Coordinate{-70.7828, -8.1575}, // TRQ
    Coordinate{13.4722, 45.8275}, // TRS
    Coordinate{-79.1086, -8.08139}, // TRU
    Coordinate{76.92, 8.48222}, // TRV
    Coordinate{173.147, 1.38167}, // TRW
    Coordinate{-93.5906, 40.0836}, // TRX
    Coordinate{34.1667, 0.68}, // TRY
    Coordinate{78.7147, 10.7658}, // TRZ
    Coordinate{17.7256, -19.2619}, // TSB
    Coordinate{-77.5031, -2.38167}, // TSC
    Coordinate{71.4669, 51.0222}, // TSE
    Coordinate{12.1978, 45.6508}, // TSF
    Coordinate{-143.336, 63.3744}, // TSG
    Coordinate{20.7947, -6.43833}, // TSH
    Coordinate{129.331, 34.285}, // TSJ
    Coordinate{-98.8067, 22.0378}, // TSL
    Coordinate{-105.673, 36.4581}, // TSM
    Coordinate{117.346, 39.1244}, // TSN
    Coordinate{-6.33139, 49.9456}, // TSO
    Coordinate{-118.439, 35.135}, // TSP
    Coordinate{-49.8103, -29.41}, // TSQ
    Coordinate{21.3379, 45.8098}, // TSR
    Coordinate{-73.9719, 40.7425}, // TSS
    Coordinate{99.6158, 7.50861}, // TST
    Coordinate{175.065, -1.47439}, // TSU
    Coordinate{146.765, -19.2533}, // TSV
    Coordinate{108.246, -7.3466}, // TSY
    Coordinate{-11.1614, 28.4439}, // TTA
    Coordinate{9.68321, 39.9167}, // TTB
    Coordinate{-70.3767, -25.5639}, // TTC
    Coordinate{-122.401, 45.5494}, // TTD
    Coordinate{127.381, 0.831411}, // TTE
    Coordinate{-63.8183, -22.6283}, // TTG
    Coordinate{134.163, 35.53}, // TTJ
    Coordinate{-72.1006, 5.72639}, // TTM
    Coordinate{-74.8133, 40.2767}, // TTN
    Coordinate{-97.7428, 45.815}, // TTO
    Coordinate{-83.5147, 10.5689}, // TTQ
    Coordinate{119.821, -3.04256}, // TTR
    Coordinate{47.6167, -16.75}, // TTS
    Coordinate{121.093, 22.7547}, // TTT
    Coordinate{-5.31997, 35.5944}, // TTU
    Coordinate{-77.7081, 0.809444}, // TUA
    Coordinate{-149.529, -23.371}, // TUB
    Coordinate{-65.1047, -26.8408}, // TUC
    Coordinate{-13.658, 13.7327}, // TUD
    Coordinate{0.723056, 47.4319}, // TUF
    Coordinate{121.731, 17.6383}, // TUG
    Coordinate{38.7311, 31.6928}, // TUI
    Coordinate{35.5194, 6.25972}, // TUJ
    Coordinate{63.0302, 25.9864}, // TUK
    Coordinate{-95.8881, 36.1983}, // TUL
    Coordinate{148.241, -35.2628}, // TUM
    Coordinate{10.2272, 36.8511}, // TUN
    Coordinate{176.084, -38.7397}, // TUO
    Coordinate{-88.77, 34.2681}, // TUP
    Coordinate{-3.07709, 13.0592}, // TUQ
    Coordinate{-49.7197, -3.79361}, // TUR
    Coordinate{-110.941, 32.1161}, // TUS
    Coordinate{36.6189, 28.3656}, // TUU
    Coordinate{-62.0942, 9.08889}, // TUV
    Coordinate{-120.931, 55.0272}, // TUX
    Coordinate{44.9167, -17.8501}, // TVA
    Coordinate{-85.5822, 44.7417}, // TVC
    Coordinate{-96.185, 48.0656}, // TVF
    Coordinate{-83.8811, 30.9017}, // TVI
    Coordinate{-92.9011, 40.6844}, // TVK
    Coordinate{-119.995, 38.8939}, // TVL
    Coordinate{117.993, 39.7253}, // TVS
    Coordinate{-179.877, -16.6906}, // TVU
    Coordinate{98.2036, 14.1}, // TVY
    Coordinate{-160.275, 59.0744}, // TWA
    Coordinate{151.912, -27.5417}, // TWB
    Coordinate{-122.811, 48.0539}, // TWD
    Coordinate{-114.488, 42.4818}, // TWF
    Coordinate{118.122, 4.31333}, // TWU
    Coordinate{170.118, -44.2369}, // TWZ
    Coordinate{96.8494, 4.72083}, // TXE
    Coordinate{-39.6697, -17.5244}, // TXF
    Coordinate{120.654, 24.1863}, // TXG
    Coordinate{-93.9911, 33.4536}, // TXK
    Coordinate{13.2878, 52.5597}, // TXL
    Coordinate{118.253, 29.73}, // TXN
    Coordinate{-7.36273, 4.43781}, // TXU
    Coordinate{37.6067, 54.2367}, // TYA
    Coordinate{142.058, -29.4517}, // TYB
    Coordinate{124.778, 55.2833}, // TYD
    Coordinate{-151.138, 61.0767}, // TYE
    Coordinate{12.9936, 60.1547}, // TYF
    Coordinate{-81.2539, -4.57639}, // TYL
    Coordinate{-76.4403, 24.1625}, // TYM
    Coordinate{112.628, 37.7469}, // TYN
    Coordinate{-86.2514, 40.0306}, // TYQ
    Coordinate{-95.4028, 32.3539}, // TYR
    Coordinate{-83.9939, 35.8111}, // TYS
    Coordinate{-54.3472, -33.195}, // TYT
    Coordinate{-110.115, 34.4528}, // TYZ
    Coordinate{-88.1917, 17.5164}, // TZA
    Coordinate{-83.4453, 43.4586}, // TZC
    Coordinate{18.7247, 44.4586}, // TZL
    Coordinate{-83.1369, 39.9011}, // TZR
    Coordinate{39.7853, 40.9951}, // TZX
    Coordinate{-114.798, 32.4453}, // UAC
    Coordinate{125.287, -9.30397}, // UAI
    Coordinate{-45.4257, 61.1606}, // UAK
    Coordinate{22.2311, -10.7158}, // UAL
    Coordinate{-122.77, 45.2472}, // UAO
    Coordinate{-68.4211, -31.5711}, // UAQ
    Coordinate{-1.97833, 32.5144}, // UAR
    Coordinate{37.5342, 0.53056}, // UAS
    Coordinate{-89.6347, 17.3931}, // UAX
    Coordinate{-47.9661, -19.7647}, // UBA
    Coordinate{142.197, -9.95167}, // UBB
    Coordinate{155.685, -6.73333}, // UBI
    Coordinate{131.279, 33.93}, // UBJ
    Coordinate{104.87, 15.2513}, // UBP
    Coordinate{-88.3803, 33.4653}, // UBS
    Coordinate{-45.0761, -23.4414}, // UBT
    Coordinate{-75.3839, 43.145}, // UCA
    Coordinate{113.109, 41.1239}, // UCB
    Coordinate{-116.038, 36.9458}, // UCC
    Coordinate{25.4833, 50.6833}, // UCK
    Coordinate{-10.0575, 5.16765}, // UCN
    Coordinate{-80.4133, 41.0253}, // UCP
    Coordinate{53.8033, 63.5667}, // UCT
    Coordinate{-88.9858, 36.3797}, // UCY
    Coordinate{-76.35, -8.467}, // UCZ
    Coordinate{-116.275, 33.7483}, // UDD
    Coordinate{-79.89, 34.4494}, // UDG
    Coordinate{-48.2253, -18.8836}, // UDI
    Coordinate{22.2633, 48.6342}, // UDJ
    Coordinate{121.415, 1.10472}, // UDL
    Coordinate{13.1867, 46.0314}, // UDN
    Coordinate{73.8944, 24.6176}, // UDR
    Coordinate{145.53, -42.0756}, // UEE
    Coordinate{36.8667, -17.8764}, // UEL
    Coordinate{126.714, 26.3636}, // UEO
    Coordinate{-88.2369, 43.0411}, // UES
    Coordinate{66.9387, 30.2521}, // UET
    Coordinate{55.8742, 54.5575}, // UFA
    Coordinate{103.484, 48.8542}, // UGA
    Coordinate{-157.74, 57.4253}, // UGB
    Coordinate{60.6417, 41.5842}, // UGC
    Coordinate{-87.8678, 42.4222}, // UGN
    Coordinate{15.0277, -7.60278}, // UGO
    Coordinate{-157.396, 57.5233}, // UGS
    Coordinate{17.4397, 49.0294}, // UHE
    Coordinate{-76.6411, 5.69083}, // UIB
    Coordinate{109.042, 13.955}, // UIH
    Coordinate{-86.0542, 16.0917}, // UII
    Coordinate{102.557, 58.1333}, // UIK
    Coordinate{-124.563, 47.9367}, // UIL
    Coordinate{-91.1947, 39.9428}, // UIN
    Coordinate{-78.3656, -0.135556}, // UIO
    Coordinate{-4.16778, 47.975}, // UIP
    Coordinate{150.514, -31.4986}, // UIR
    Coordinate{169.637, 5.90917}, // UIT
    Coordinate{165.762, 8.92806}, // UJE
    Coordinate{124.499, 40.1517}, // UJU
    Coordinate{39.5714, -4.29694}, // UKA
    Coordinate{135.224, 34.6328}, // UKB
    Coordinate{135.647, 70.0111}, // UKG
    Coordinate{-123.201, 39.1258}, // UKI
    Coordinate{82.4942, 50.0361}, // UKK
    Coordinate{-95.725, 38.3025}, // UKL
    Coordinate{45.6556, 13.9333}, // UKR
    Coordinate{33.5833, 44.6833}, // UKS
    Coordinate{-75.3803, 40.4364}, // UKT
    Coordinate{105.73, 56.8567}, // UKX
    Coordinate{-67.8028, -49.3094}, // ULA
    Coordinate{168.283, -16.333}, // ULB
    Coordinate{-70.6978, -33.4936}, // ULC
    Coordinate{31.4161, -28.3206}, // ULD
    Coordinate{89.9197, 48.9917}, // ULG
    Coordinate{38.1169, 26.4833}, // ULH
    Coordinate{114.826, 60.7206}, // ULK
    Coordinate{-94.5022, 44.3194}, // ULM
    Coordinate{106.766, 47.8431}, // ULN
    Coordinate{92.0797, 49.9733}, // ULO
    Coordinate{144.257, -26.6086}, // ULP
    Coordinate{-76.2261, 4.0945}, // ULQ
    Coordinate{32.275, 2.8}, // ULU
    Coordinate{48.2267, 54.2683}, // ULV
    Coordinate{48.8028, 54.4011}, // ULY
    Coordinate{96.5242, 47.7128}, // ULZ
    Coordinate{-74.15, 20.25}, // UMA
    Coordinate{20.28, 63.7931}, // UME
    Coordinate{-149.127, 63.3314}, // UMM
    Coordinate{-86.045, 39.9353}, // UMP
    Coordinate{134.449, 60.3639}, // UMS
    Coordinate{-152.135, 69.3711}, // UMT
    Coordinate{-53.3139, -23.7992}, // UMU
    Coordinate{34.7625, 50.8583}, // UMY
    Coordinate{-38.9972, -15.3533}, // UNA
    Coordinate{68.9106, 36.6651}, // UND
    Coordinate{28.6719, -30.1111}, // UNE
    Coordinate{141.282, -6.12567}, // UNG
    Coordinate{-61.4147, 12.5986}, // UNI
    Coordinate{-160.799, 63.8883}, // UNK
    Coordinate{98.5853, 9.7775}, // UNN
    Coordinate{-91.9028, 36.8783}, // UNO
    Coordinate{-88.7039, 43.4264}, // UNU
    Coordinate{-85.8981, 35.2053}, // UOS
    Coordinate{-89.5367, 34.3844}, // UOX
    Coordinate{-82.5794, 23.0328}, // UPB
    Coordinate{119.554, -5.06167}, // UPG
    Coordinate{-85.0167, 10.9}, // UPL
    Coordinate{-102.039, 19.3965}, // UPN
    Coordinate{-155.86, 20.2653}, // UPP
    Coordinate{51.5431, 51.1508}, // URA
    Coordinate{-51.5619, -20.7758}, // URB
    Coordinate{87.4742, 43.9072}, // URC
    Coordinate{22.5094, 58.2297}, // URE
    Coordinate{-57.0383, -29.7833}, // URG
    Coordinate{64.8333, 60.1167}, // URJ
    Coordinate{1.18389, 49.3908}, // URO
    Coordinate{-76.1406, 6.32771}, // URR
    Coordinate{36.2967, 51.7517}, // URS
    Coordinate{99.1392, 9.13611}, // URT
    Coordinate{37.2794, 31.4119}, // URY
    Coordinate{-68.2958, -54.8433}, // USH
    Coordinate{-59.7764, 8.20139}, // USI
    Coordinate{57.3667, 66}, // USK
    Coordinate{100.062, 9.54778}, // USM
    Coordinate{129.352, 35.5933}, // USN
    Coordinate{29.4699, 38.6796}, // USQ
    Coordinate{143.111, 64.5486}, // USR
    Coordinate{-79.4428, 21.97}, // USS
    Coordinate{-81.3397, 29.9592}, // UST
    Coordinate{120.1, 12.1214}, // USU
    Coordinate{32.625, -18.9975}, // UTA
    Coordinate{144.529, -22.5831}, // UTB
    Coordinate{27.6933, -30.4075}, // UTG
    Coordinate{102.788, 17.3864}, // UTH
    Coordinate{169.853, 11.2225}, // UTK
    Coordinate{-90.3478, 34.685}, // UTM
    Coordinate{21.2597, -28.4011}, // UTN
    Coordinate{-153.704, 65.9928}, // UTO
    Coordinate{101.005, 12.6796}, // UTP
    Coordinate{52.1989, 65.4333}, // UTS
    Coordinate{28.6736, -31.5464}, // UTT
    Coordinate{52.8017, 54.64}, // UUA
    Coordinate{107.438, 51.8075}, // UUD
    Coordinate{-149.598, 70.3308}, // UUK
    Coordinate{113.285, 46.6603}, // UUN
    Coordinate{142.722, 46.8869}, // UUS
    Coordinate{-99.7436, 29.2114}, // UVA
    Coordinate{166.573, -20.6417}, // UVE
    Coordinate{-60.9525, 13.7333}, // UVF
    Coordinate{30.59, 25.4716}, // UVL
    Coordinate{-72.2148, 42.282}, // UWA
    Coordinate{-93.3761, 30.1314}, // UXL
    Coordinate{-83.4619, 39.9328}, // UYF
    Coordinate{24.9561, 12.0535}, // UYL
    Coordinate{109.73, 38.2742}, // UYN
    Coordinate{-66.8422, -20.45}, // UYU
    Coordinate{19.6974, 43.8988}, // UZC
    Coordinate{-106.614, 68.1639}, // UZM
    Coordinate{-57.9789, -29.7718}, // UZU
    Coordinate{21.7642, 63.0453}, // VAA
    Coordinate{4.96861, 44.9156}, // VAF
    Coordinate{-45.4733, -21.5889}, // VAG
    Coordinate{-64.0996, -18.4793}, // VAH
    Coordinate{141.302, -2.69717}, // VAI
    Coordinate{-165.601, 61.5408}, // VAK
    Coordinate{-38.9925, -13.2964}, // VAL
    Coordinate{72.8358, 3.47056}, // VAM
    Coordinate{43.3308, 38.4683}, // VAN
    Coordinate{158.731, -7.58583}, // VAO
    Coordinate{-71.3542, -33.3568}, // VAP
    Coordinate{27.8253, 43.2319}, // VAR
    Coordinate{36.9025, 39.7667}, // VAS
    Coordinate{}, // VAT
    Coordinate{-173.97, -18.5856}, // VAV
    Coordinate{31.045, 70.3553}, // VAW
    Coordinate{96.0896, 21.9405}, // VBC
    Coordinate{10.3314, 45.4286}, // VBS
    Coordinate{-94.2194, 36.3458}, // VBT
    Coordinate{-178.983, -17.2667}, // VBV
    Coordinate{18.3461, 57.6628}, // VBY
    Coordinate{105.712, 10.0853}, // VCA
    Coordinate{-121.962, 38.3778}, // VCB
    Coordinate{9.2, 4.01667}, // VCC
    Coordinate{131.003, -16.4033}, // VCD
    Coordinate{12.3519, 45.5053}, // VCE
    Coordinate{-66.1495, -40.6997}, // VCF
    Coordinate{-54.6169, -31.7669}, // VCH
    Coordinate{108.706, 15.4061}, // VCL
    Coordinate{-47.1344, -23.0069}, // VCP
    Coordinate{-70.0654, 10.1756}, // VCR
    Coordinate{106.629, 8.7325}, // VCS
    Coordinate{-96.9186, 28.8525}, // VCT
    Coordinate{-117.383, 34.5975}, // VCV
    Coordinate{34.9358, 29.9403}, // VDA
    Coordinate{9.28801, 61.0151}, // VDB
    Coordinate{-40.8631, -14.8636}, // VDC
    Coordinate{-17.8869, 27.8147}, // VDE
    Coordinate{-82.3453, 28.0139}, // VDF
    Coordinate{106.591, 17.515}, // VDH
    Coordinate{-82.3711, 32.1928}, // VDI
    Coordinate{-65.2838, -43.2098}, // VDM
    Coordinate{-65.9933, 9.22194}, // VDP
    Coordinate{-65.1472, -31.9533}, // VDR
    Coordinate{29.8447, 70.0653}, // VDS
    Coordinate{76.6341, 15.175}, // VDY
    Coordinate{-146.248, 61.1339}, // VDZ
    Coordinate{-146.366, 67.0086}, // VEE
    Coordinate{-109.51, 40.4408}, // VEL
    Coordinate{-96.1874, 19.1458}, // VER
    Coordinate{-84.5319, 40.2044}, // VES
    Coordinate{-20.2792, 63.425}, // VEY
    Coordinate{25.839, -18.0959}, // VFA
    Coordinate{80.6667, 16.5275}, // VGA
    Coordinate{-75.5611, 42.8433}, // VGC
    Coordinate{39.9467, 59.2817}, // VGD
    Coordinate{120.356, 17.5547}, // VGN
    Coordinate{-8.6275, 42.2292}, // VGO
    Coordinate{-115.194, 36.2106}, // VGT
    Coordinate{-76.6056, 0.978889}, // VGZ
    Coordinate{20.4316, -9.7}, // VHC
    Coordinate{16.8333, 64.5789}, // VHM
    Coordinate{-104.784, 31.0578}, // VHN
    Coordinate{120.276, 63.4592}, // VHV
    Coordinate{3.40333, 46.1692}, // VHY
    Coordinate{-138.853, -18.78}, // VHZ
    Coordinate{-51.1575, -27}, // VIA
    Coordinate{-111.688, 25.0553}, // VIB
    Coordinate{22.8158, 44.0222}, // VID
    Coordinate{16.5697, 48.1103}, // VIE
    Coordinate{-71.6728, 8.62417}, // VIG
    Coordinate{-91.7694, 38.1275}, // VIH
    Coordinate{105.671, 18.7367}, // VII
    Coordinate{-64.4286, 18.4456}, // VIJ
    Coordinate{-15.9319, 23.7181}, // VIL
    Coordinate{28.6139, 49.2397}, // VIN
    Coordinate{31.0583, -29.7708}, // VIR
    Coordinate{-119.393, 36.3186}, // VIS
    Coordinate{-2.72444, 42.8828}, // VIT
    Coordinate{150.32, -9.30639}, // VIV
    Coordinate{-40.2864, -20.2581}, // VIX
    Coordinate{-82.0333, 36.6871}, // VJI
    Coordinate{105.134, 9.95972}, // VKG
    Coordinate{37.2675, 55.5961}, // VKO
    Coordinate{63.99, 67.4883}, // VKT
    Coordinate{-76.9558, 38.7486}, // VKX
    Coordinate{-0.481667, 39.4894}, // VLC
    Coordinate{-83.2761, 30.7814}, // VLD
    Coordinate{-112.142, 35.6495}, // VLE
    Coordinate{-57.0292, -37.2353}, // VLG
    Coordinate{168.32, -17.6992}, // VLI
    Coordinate{-4.85194, 41.7061}, // VLL
    Coordinate{-63.4056, -21.255}, // VLM
    Coordinate{-67.9283, 10.1497}, // VLN
    Coordinate{-51.1422, -9.97945}, // VLP
    Coordinate{-70.7575, -28.5965}, // VLR
    Coordinate{168.177, -16.7961}, // VLS
    Coordinate{30.61, 56.3817}, // VLU
    Coordinate{-70.5842, 9.34083}, // VLV
    Coordinate{-4.53528, 53.2481}, // VLY
    Coordinate{-65.3781, -33.7253}, // VME
    Coordinate{-57.9431, -22.1583}, // VMI
    Coordinate{-63.2581, -32.3883}, // VMR
    Coordinate{144.823, -7.49483}, // VMU
    Coordinate{-82.4403, 27.0717}, // VNC
    Coordinate{}, // VND
    Coordinate{-2.72333, 47.7192}, // VNE
    Coordinate{25.2878, 54.6369}, // VNO
    Coordinate{82.8586, 25.4514}, // VNS
    Coordinate{21.5442, 57.3578}, // VNT
    Coordinate{35.3133, -22.0184}, // VNX
    Coordinate{-118.49, 34.2097}, // VNY
    Coordinate{14.3956, 50.2167}, // VOD
    Coordinate{44.3467, 48.7817}, // VOG
    Coordinate{50, -13.3833}, // VOH
    Coordinate{-9.767, 8.4}, // VOI
    Coordinate{22.7942, 39.2194}, // VOL
    Coordinate{-50.0025, -20.4572}, // VOT
    Coordinate{39.23, 51.815}, // VOZ
    Coordinate{-71.5574, -33.0683}, // VPA
    Coordinate{-84.8486, 34.1231}, // VPC
    Coordinate{15.6839, -17.0434}, // VPE
    Coordinate{-14.8506, 65.7206}, // VPN
    Coordinate{-86.5253, 30.4833}, // VPS
    Coordinate{33.4286, -19.1486}, // VPY
    Coordinate{-87.0072, 41.4539}, // VPZ
    Coordinate{-81.8767, 30.2186}, // VQQ
    Coordinate{-65.4936, 18.1347}, // VQS
    Coordinate{-81.4353, 23.0344}, // VRA
    Coordinate{-80.4179, 27.6556}, // VRB
    Coordinate{124.206, 13.5758}, // VRC
    Coordinate{18.5396, -31.6431}, // VRE
    Coordinate{58.1986, 68.8478}, // VRI
    Coordinate{-7.72, 41.2758}, // VRL
    Coordinate{10.8881, 45.3964}, // VRN
    Coordinate{-81.3036, 23.1228}, // VRO
    Coordinate{24.7283, -26.9808}, // VRU
    Coordinate{12.6817, 67.6883}, // VRY
    Coordinate{-92.8172, 17.995}, // VSA
    Coordinate{-7.88917, 40.7222}, // VSE
    Coordinate{-72.5172, 43.3436}, // VSF
    Coordinate{39.374, 48.418}, // VSG
    Coordinate{-119.21, 46.2186}, // VSK
    Coordinate{30.3517, 55.1264}, // VTB
    Coordinate{102.563, 17.9883}, // VTE
    Coordinate{107.093, 10.3703}, // VTG
    Coordinate{-100.549, 42.8567}, // VTN
    Coordinate{12.0622, 42.4302}, // VTR
    Coordinate{-76.9358, 20.9878}, // VTU
    Coordinate{83.2244, 17.7211}, // VTZ
    Coordinate{131.782, -22.2542}, // VUE
    Coordinate{-80.1508, 35.4167}, // VUJ
    Coordinate{-122.656, 45.6206}, // VUO
    Coordinate{-73.2494, 10.435}, // VUP
    Coordinate{46.26, 60.7883}, // VUS
    Coordinate{-73.6136, 4.16778}, // VVC
    Coordinate{-63.1353, -17.6447}, // VVI
    Coordinate{132.151, 43.3992}, // VVO
    Coordinate{8.62247, 26.7236}, // VVZ
    Coordinate{35.2644, -13.2742}, // VXC
    Coordinate{-25.0547, 16.8336}, // VXE
    Coordinate{14.7278, 56.9289}, // VXO
    Coordinate{121.693, 63.7567}, // VYI
    Coordinate{-89.1531, 41.3519}, // VYS
    Coordinate{-168.095, 65.6225}, // WAA
    Coordinate{45.1994, 20.5042}, // WAE
    Coordinate{175.025, -39.9622}, // WAG
    Coordinate{-96.6072, 46.2442}, // WAH
    Coordinate{46.953, -15.7741}, // WAI
    Coordinate{44.51, -22.3}, // WAK
    Coordinate{48.4333, -17.8}, // WAM
    Coordinate{-71.8069, -43.6153}, // WAP
    Coordinate{44.6167, -18.7}, // WAQ
    Coordinate{-7.08696, 52.1872}, // WAT
    Coordinate{20.9672, 52.1658}, // WAW
    Coordinate{12.0167, 32.9528}, // WAX
    Coordinate{-80.1306, 39.9011}, // WAY
    Coordinate{151.943, -28.1494}, // WAZ
    Coordinate{-162.278, 63.5158}, // WBB
    Coordinate{143.895, -5.6433}, // WBM
    Coordinate{}, // WBO
    Coordinate{-147.407, 66.3622}, // WBQ
    Coordinate{-85.5042, 43.7225}, // WBR
    Coordinate{-105.226, 40.0394}, // WBU
    Coordinate{-75.8522, 41.2972}, // WBW
    Coordinate{-73.775, -42.4903}, // WCA
    Coordinate{}, // WCH
    Coordinate{-148.483, 67.5044}, // WCR
    Coordinate{-97.7889, 36.3783}, // WDG
    Coordinate{17.4708, -22.48}, // WDH
    Coordinate{-83.6681, 33.9822}, // WDR
    Coordinate{110.908, 32.5917}, // WDS
    Coordinate{119.118, 36.6467}, // WEF
    Coordinate{122.229, 37.1869}, // WEH
    Coordinate{141.925, -12.6786}, // WEI
    Coordinate{26.6667, -28}, // WEL
    Coordinate{-131.663, 55.3444}, // WFB
    Coordinate{47.1, -21.45}, // WFI
    Coordinate{-68.3128, 47.2856}, // WFK
    Coordinate{79.6, 17.9155}, // WGC
    Coordinate{148.125, -30.0333}, // WGE
    Coordinate{110.642, 26.802}, // WGN
    Coordinate{-78.1444, 39.1439}, // WGO
    Coordinate{120.301, -9.6681}, // WGP
    Coordinate{146.307, -36.4158}, // WGT
    Coordinate{-130.007, 55.9033}, // WHD
    Coordinate{31.5164, 21.8003}, // WHF
    Coordinate{176.914, -37.9206}, // WHK
    Coordinate{-118.413, 34.2593}, // WHP
    Coordinate{-0.927356, 60.3766}, // WHS
    Coordinate{-96.1542, 29.2542}, // WHT
    Coordinate{-99.2839, 34.2256}, // WIB
    Coordinate{-3.09306, 58.4589}, // WIC
    Coordinate{175.085, -36.8083}, // WIK
    Coordinate{36.8148, -1.32172}, // WIL
    Coordinate{143.085, -22.3633}, // WIN
    Coordinate{143.375, -31.5267}, // WIO
    Coordinate{177.404, -39.0122}, // WIR
    Coordinate{168.55, 7.45083}, // WJA
    Coordinate{-118.219, 34.7411}, // WJF
    Coordinate{40.09, 1.73}, // WJR
    Coordinate{127.96, 37.4381}, // WJU
    Coordinate{169.246, -44.7225}, // WKA
    Coordinate{142.419, -36.3211}, // WKB
    Coordinate{26.5142, -18.3632}, // WKI
    Coordinate{141.802, 45.4044}, // WKJ
    Coordinate{-158.618, 59.2825}, // WKK
    Coordinate{155.221, -5.86139}, // WKN
    Coordinate{-78.4022, 27.2604}, // WKR
    Coordinate{-97.0375, 37.1686}, // WLD
    Coordinate{150.165, -26.8092}, // WLE
    Coordinate{174.805, -41.3272}, // WLG
    Coordinate{167.691, -15.412}, // WLH
    Coordinate{-159.986, 66.6}, // WLK
    Coordinate{-176.199, -13.2383}, // WLS
    Coordinate{-122.217, 39.5158}, // WLW
    Coordinate{48.833, -15.8333}, // WMA
    Coordinate{142.447, -38.2953}, // WMB
    Coordinate{-117.806, 40.8967}, // WMC
    Coordinate{}, // WMD
    Coordinate{120.555, -27.2864}, // WME
    Coordinate{-92.4706, 36.3689}, // WMH
    Coordinate{20.6517, 52.4511}, // WMI
    Coordinate{172.395, -43.4767}, // WML
    Coordinate{49.6833, -15.4367}, // WMN
    Coordinate{-163.413, 64.6892}, // WMO
    Coordinate{47.6167, -16.05}, // WMP
    Coordinate{49.7667, -16.1667}, // WMR
    Coordinate{138.952, -4.09833}, // WMX
    Coordinate{-161.979, 60.6903}, // WNA
    Coordinate{-133.228, 55.8497}, // WNC
    Coordinate{104.243, 23.3758}, // WNH
    Coordinate{123.583, -5.31667}, // WNI
    Coordinate{-89.2892, 52.8939}, // WNN
    Coordinate{123.27, 13.5847}, // WNP
    Coordinate{142.667, -25.4133}, // WNR
    Coordinate{68.39, 26.2194}, // WNS
    Coordinate{120.852, 27.9119}, // WNZ
    Coordinate{150.789, -34.5611}, // WOL
    Coordinate{}, // WON
    Coordinate{127.484, 39.1626}, // WOS
    Coordinate{119.494, 23.3667}, // WOT
    Coordinate{-150.052, 61.7542}, // WOW
    Coordinate{-72.6703, -45.3992}, // WPA
    Coordinate{47.6167, -15.5833}, // WPB
    Coordinate{-113.997, 49.5206}, // WPC
    Coordinate{-124.533, 49.8833}, // WPL
    Coordinate{-70.3327, -53.2537}, // WPR
    Coordinate{-67.6263, -54.9311}, // WPU
    Coordinate{174.365, -35.7683}, // WRE
    Coordinate{-132.37, 56.4844}, // WRG
    Coordinate{-107.951, 43.9628}, // WRL
    Coordinate{119.39, -30.0317}, // WRN
    Coordinate{16.8858, 51.1028}, // WRO
    Coordinate{132.191, -0.419444}, // WRR
    Coordinate{-2.88389, 53.745}, // WRT
    Coordinate{-2.95056, 59.3503}, // WRY
    Coordinate{-76.9917, 0.0708333}, // WSE
    Coordinate{-164.914, 54.5825}, // WSF
    Coordinate{-80.2903, 40.1364}, // WSG
    Coordinate{-72.8669, 40.8219}, // WSH
    Coordinate{-153.321, 57.7303}, // WSJ
    Coordinate{114.618, -8.14172}, // WSN
    Coordinate{-57.1738, 5.25015}, // WSO
    Coordinate{-83.9758, 14.736}, // WSP
    Coordinate{-71.8033, 41.3497}, // WST
    Coordinate{-122.953, 48.6178}, // WSX
    Coordinate{171.581, -41.7381}, // WSZ
    Coordinate{43.9667, -17.4833}, // WTA
    Coordinate{151.795, -27.5586}, // WTB
    Coordinate{-78.975, 26.6833}, // WTD
    Coordinate{170.239, 9.45833}, // WTE
    Coordinate{-162.98, 67.5611}, // WTK
    Coordinate{-162.667, 60.3353}, // WTL
    Coordinate{166.003, 10.1733}, // WTO
    Coordinate{147.253, -8.5625}, // WTP
    Coordinate{-109.986, 33.8106}, // WTR
    Coordinate{46.05, -18.7635}, // WTS
    Coordinate{175.679, -36.8358}, // WTZ
    Coordinate{106.803, 39.7919}, // WUA
    Coordinate{127.381, 0.83141}, // WUB
    Coordinate{135.447, -33.0432}, // WUD
    Coordinate{146.719, -7.34528}, // WUG
    Coordinate{114.208, 30.7836}, // WUH
    Coordinate{121.89, -28.7053}, // WUI
    Coordinate{120.22, -26.63}, // WUN
    Coordinate{118, 27.7008}, // WUS
    Coordinate{112.968, 38.5992}, // WUT
    Coordinate{27.975, 7.72583}, // WUU
    Coordinate{120.429, 31.4944}, // WUX
    Coordinate{111.248, 23.4567}, // WUZ
    Coordinate{14.6453, -22.98}, // WVB
    Coordinate{-121.79, 36.9358}, // WVI
    Coordinate{48.0167, -22.1197}, // WVK
    Coordinate{-69.6756, 44.5333}, // WVL
    Coordinate{-149.539, 61.5719}, // WWA
    Coordinate{-74.9083, 39.0086}, // WWD
    Coordinate{143.669, -3.58383}, // WWK
    Coordinate{-133.122, 56.1164}, // WWP
    Coordinate{-99.5228, 36.4381}, // WWR
    Coordinate{-164.641, 60.9392}, // WWT
    Coordinate{147.192, -33.9367}, // WWY
    Coordinate{108.431, 30.7978}, // WXN
    Coordinate{137.514, -33.0589}, // WYA
    Coordinate{-11.0472, 8.61047}, // WYE
    Coordinate{128.153, -15.5114}, // WYN
    Coordinate{-111.118, 44.6883}, // WYS
    Coordinate{1.83111, 50.1422}, // XAB
    Coordinate{-52.6619, -27.1339}, // XAP
    Coordinate{-0.895556, 14.2153}, // XAR
    Coordinate{-53.2042, 3.61361}, // XAU
    Coordinate{-91.0272, 53.9656}, // XBE
    Coordinate{-0.167, 12.983}, // XBG
    Coordinate{59.2661, 32.8981}, // XBJ
    Coordinate{5.29167, 46.2056}, // XBK
    Coordinate{-0.567, 12.65}, // XBO
    Coordinate{-97.8283, 33.1753}, // XBP
    Coordinate{1.20583, 47.6797}, // XBQ
    Coordinate{-75.7503, 44.6394}, // XBR
    Coordinate{4.8175, 46.8261}, // XCD
    Coordinate{105.69, -10.4506}, // XCH
    Coordinate{-109.516, 58.3914}, // XCL
    Coordinate{-82.0825, 42.3058}, // XCM
    Coordinate{4.20611, 48.7733}, // XCR
    Coordinate{3.35556, 49.0667}, // XCY
    Coordinate{4.64278, 49.785}, // XCZ
    Coordinate{-3.25, 10.9482}, // XDE
    Coordinate{-1.62472, 14.125}, // XDJ
    Coordinate{1.36278, 48.7067}, // XDR
    Coordinate{4.08528, 49.0044}, // XEP
    Coordinate{-88.3944, 42.6131}, // XES
    Coordinate{112.291, 32.15}, // XFN
    Coordinate{-3.16439, 10.383}, // XGA
    Coordinate{-0.218889, 14.4542}, // XGG
    Coordinate{14.9649, -16.7553}, // XGN
    Coordinate{-65.9928, 58.7114}, // XGR
    Coordinate{102.184, 27.9892}, // XIC
    Coordinate{-49.9764, -7.09056}, // XIG
    Coordinate{115.964, 43.9167}, // XIL
    Coordinate{108.751, 34.4469}, // XIY
    Coordinate{73.6081, 32.8767}, // XJM
    Coordinate{1.5, 12.467}, // XKA
    Coordinate{103.158, 19.4401}, // XKH
    Coordinate{-88.6431, 53.5247}, // XKS
    Coordinate{-1.1, 13.067}, // XKY
    Coordinate{-101.469, 58.6142}, // XLB
    Coordinate{2.62279, 48.8222}, // XLG
    Coordinate{-79.9133, 36.2561}, // XLL
    Coordinate{-16.4611, 16.0498}, // XLS
    Coordinate{-2.1, 11.1}, // XLU
    Coordinate{149.721, -37.5989}, // XMC
    Coordinate{-97.0856, 44.0164}, // XMD
    Coordinate{4.03, 50.3083}, // XME
    Coordinate{6.79139, 47.4867}, // XMF
    Coordinate{80.1481, 28.9633}, // XMG
    Coordinate{-146.071, -14.4375}, // XMH
    Coordinate{38.7714, -10.7383}, // XMI
    Coordinate{118.128, 24.5442}, // XMN
    Coordinate{-130.202, 63.1765}, // XMP
    Coordinate{-78.1208, -2.29917}, // XMS
    Coordinate{3.42167, 46.5344}, // XMU
    Coordinate{1.37694, 44.0267}, // XMW
    Coordinate{142.772, -9.9}, // XMY
    Coordinate{-94.3078, 36.2817}, // XNA
    Coordinate{102.043, 36.5275}, // XNN
    Coordinate{-81.0831, 33.6169}, // XNO
    Coordinate{114.429, 36.8828}, // XNT
    Coordinate{-3.867, 12.75}, // XNU
    Coordinate{0.7, 11.25}, // XPA
    Coordinate{-101.266, 55.7492}, // XPK
    Coordinate{-97.2736, 52.9964}, // XPP
    Coordinate{-102.511, 43.0225}, // XPR
    Coordinate{-84.1333, 9.44306}, // XQP
    Coordinate{-124.394, 49.3372}, // XQU
    Coordinate{-132.422, 61.9706}, // XRR
    Coordinate{-6.06, 36.7447}, // XRY
    Coordinate{-76.8942, 37.8597}, // XSA
    Coordinate{52.5833, 24.2833}, // XSB
    Coordinate{-71.5286, 21.5158}, // XSC
    Coordinate{-116.779, 37.7947}, // XSD
    Coordinate{0.503333, 13.4567}, // XSE
    Coordinate{-98.9072, 56.7928}, // XSI
    Coordinate{3.02861, 49.8689}, // XSJ
    Coordinate{6.63889, 45.95}, // XSN
    Coordinate{103.868, 1.41694}, // XSP
    Coordinate{-0.113612, 47.2567}, // XSU
    Coordinate{143.811, -27.9864}, // XTG
    Coordinate{-98.5122, 58.7061}, // XTL
    Coordinate{149.899, -25.8019}, // XTO
    Coordinate{-0.616667, 52.0722}, // XUD
    Coordinate{117.555, 34.0591}, // XUZ
    Coordinate{4.635, 45.9186}, // XVF
    Coordinate{-94.2039, 46.9903}, // XVG
    Coordinate{5.46905, 49.1224}, // XVN
    Coordinate{6.20421, 47.6386}, // XVO
    Coordinate{3.46126, 50.3247}, // XVS
    Coordinate{-103.751, 48.2597}, // XWA
    Coordinate{159.219, -9.09278}, // XYA
    Coordinate{2.31306, 49.1658}, // XYP
    Coordinate{-0.616667, 11.1667}, // XZA
    Coordinate{2.0732, 48.8103}, // XZB
    Coordinate{1.98028, 48.8422}, // XZX
    Coordinate{-125.304, 52.4514}, // YAA
    Coordinate{-85.0472, 73.0064}, // YAB
    Coordinate{-91.8244, 51.7272}, // YAC
    Coordinate{-93.4406, 48.6544}, // YAG
    Coordinate{-73.6753, 53.7547}, // YAH
    Coordinate{-72.0317, -36.5828}, // YAI
    Coordinate{-139.66, 59.5033}, // YAK
    Coordinate{-126.916, 50.5822}, // YAL
    Coordinate{-84.5094, 46.485}, // YAM
    Coordinate{24.45, 0.8}, // YAN
    Coordinate{11.5216, 3.83206}, // YAO
    Coordinate{138.083, 9.49889}, // YAP
    Coordinate{-76.1964, 53.5719}, // YAR
    Coordinate{177.545, -16.7589}, // YAS
    Coordinate{-82.4319, 52.9275}, // YAT
    Coordinate{-73.3214, 61.6622}, // YAU
    Coordinate{-123.3, 48.8667}, // YAV
    Coordinate{-89.5794, 53.8492}, // YAX
    Coordinate{-56.0831, 51.3919}, // YAY
    Coordinate{-125.772, 49.0822}, // YAZ
    Coordinate{-115.54, 51.2083}, // YBA
    Coordinate{-89.8053, 68.5358}, // YBB
    Coordinate{-68.2044, 49.1325}, // YBC
    Coordinate{-108.481, 59.5614}, // YBE
    Coordinate{-125.137, 48.8342}, // YBF
    Coordinate{-55.7875, 53.47}, // YBI
    Coordinate{-62.8103, 50.2836}, // YBJ
    Coordinate{-96.0778, 64.2989}, // YBK
    Coordinate{-125.273, 49.9519}, // YBL
    Coordinate{-131.087, 56.6797}, // YBM
    Coordinate{-130.249, 56.9667}, // YBO
    Coordinate{104.544, 28.8003}, // YBP
    Coordinate{-99.9522, 49.91}, // YBR
    Coordinate{-90.3769, 52.6086}, // YBS
    Coordinate{-101.679, 57.8894}, // YBT
    Coordinate{-104.009, 53.3325}, // YBU
    Coordinate{-97.0181, 52.3589}, // YBV
    Coordinate{-123.228, 48.7467}, // YBW
    Coordinate{-57.1861, 51.4419}, // YBX
    Coordinate{-110.741, 54.3047}, // YBY
    Coordinate{-124.982, 49.6794}, // YCA
    Coordinate{-105.137, 69.1081}, // YCB
    Coordinate{-74.5678, 45.0928}, // YCC
    Coordinate{-123.87, 49.0544}, // YCD
    Coordinate{-81.5064, 43.2858}, // YCE
    Coordinate{-124.984, 50.0236}, // YCF
    Coordinate{-117.632, 49.2961}, // YCG
    Coordinate{-65.4569, 47.0058}, // YCH
    Coordinate{-126.129, 67.0211}, // YCK
    Coordinate{-66.3303, 47.9908}, // YCL
    Coordinate{-79.1711, 43.1917}, // YCM
    Coordinate{-81.0153, 49.1067}, // YCN
    Coordinate{-115.144, 67.8167}, // YCO
    Coordinate{-119.283, 52.1167}, // YCP
    Coordinate{-121.627, 55.6872}, // YCQ
    Coordinate{-97.7603, 54.6108}, // YCR
    Coordinate{-90.7311, 63.3472}, // YCS
    Coordinate{-111.445, 52.075}, // YCT
    Coordinate{111.04, 35.1167}, // YCU
    Coordinate{-121.939, 49.1528}, // YCW
    Coordinate{-68.5169, 70.4858}, // YCY
    Coordinate{-115.873, 50.3303}, // YCZ
    Coordinate{-139.13, 64.0422}, // YDA
    Coordinate{-139.04, 61.3706}, // YDB
    Coordinate{-114.96, 53.2658}, // YDC
    Coordinate{-57.2308, 53.4272}, // YDE
    Coordinate{-57.3944, 49.2092}, // YDF
    Coordinate{-65.7858, 44.5458}, // YDG
    Coordinate{-103.538, 58.6625}, // YDJ
    Coordinate{-130.031, 58.4222}, // YDL
    Coordinate{-100.052, 51.1008}, // YDN
    Coordinate{-72.375, 48.7783}, // YDO
    Coordinate{-61.6822, 56.5506}, // YDP
    Coordinate{-120.183, 55.7422}, // YDQ
    Coordinate{-123.007, 49.0742}, // YDT
    Coordinate{-102.502, 60.2919}, // YDU
    Coordinate{-96.6922, 51.7844}, // YDV
    Coordinate{-103.132, 60.3156}, // YDW
    Coordinate{-110, 50.9333}, // YEA
    Coordinate{-84.0942, 46.4189}, // YEB
    Coordinate{-79.9294, 44.6847}, // YEE
    Coordinate{-113.579, 53.31}, // YEG
    Coordinate{52.6153, 27.4814}, // YEH
    Coordinate{-94.0717, 61.0939}, // YEK
    Coordinate{-82.5611, 46.3517}, // YEL
    Coordinate{-81.8575, 45.8425}, // YEM
    Coordinate{-102.966, 49.2103}, // YEN
    Coordinate{-87.6761, 56.0189}, // YER
    Coordinate{51.545, 30.7006}, // YES
    Coordinate{-116.465, 53.5789}, // YET
    Coordinate{-85.8119, 79.9944}, // YEU
    Coordinate{-133.483, 68.3039}, // YEV
    Coordinate{-78.2492, 48.565}, // YEY
    Coordinate{-81.6958, 52.2036}, // YFA
    Coordinate{-68.5561, 63.7567}, // YFB
    Coordinate{-66.5372, 45.8689}, // YFC
    Coordinate{-80.3414, 43.1325}, // YFD
    Coordinate{-69.0972, 48.7461}, // YFE
    Coordinate{-71.1733, 54.5539}, // YFG
    Coordinate{-87.9078, 51.5619}, // YFH
    Coordinate{-110.977, 57.2758}, // YFI
    Coordinate{-114.079, 64.1917}, // YFJ
    Coordinate{-109.167, 62.7}, // YFL
    Coordinate{-101.682, 54.6781}, // YFO
    Coordinate{-113.69, 61.1808}, // YFR
    Coordinate{-121.237, 61.7603}, // YFS
    Coordinate{-55.6739, 52.3728}, // YFX
    Coordinate{-75.1153, 46.1175}, // YGA
    Coordinate{-124.518, 49.6942}, // YGB
    Coordinate{-118.874, 53.9169}, // YGC
    Coordinate{-81.7108, 43.7678}, // YGD
    Coordinate{-116.982, 51.2992}, // YGE
    Coordinate{-123.5, 48.85}, // YGG
    Coordinate{-128.648, 66.2406}, // YGH
    Coordinate{133.239, 35.4933}, // YGJ
    Coordinate{-76.5969, 44.2253}, // YGK
    Coordinate{-77.7042, 53.6253}, // YGL
    Coordinate{-97.0433, 50.6281}, // YGM
    Coordinate{-94.4914, 54.5589}, // YGO
    Coordinate{-64.4797, 48.7753}, // YGP
    Coordinate{-86.9386, 49.7786}, // YGQ
    Coordinate{-61.7781, 47.425}, // YGR
    Coordinate{-81.8164, 69.3647}, // YGT
    Coordinate{-63.6111, 50.2819}, // YGV
    Coordinate{-77.7653, 55.2819}, // YGW
    Coordinate{-94.7108, 56.3578}, // YGX
    Coordinate{-82.9094, 76.4261}, // YGZ
    Coordinate{-56.2853, 52.5281}, // YHA
    Coordinate{-102.311, 52.8183}, // YHB
    Coordinate{-92.7442, 49.8317}, // YHD
    Coordinate{-121.498, 49.3683}, // YHE
    Coordinate{-83.6869, 49.7139}, // YHF
    Coordinate{-56.1125, 52.7658}, // YHG
    Coordinate{-125.25, 50.05}, // YHH
    Coordinate{-117.806, 70.7628}, // YHI
    Coordinate{-95.8503, 68.6356}, // YHK
    Coordinate{-79.935, 43.1736}, // YHM
    Coordinate{-84.7589, 49.1931}, // YHN
    Coordinate{-60.2281, 55.4489}, // YHO
    Coordinate{-94.2556, 52.1133}, // YHP
    Coordinate{-59.6367, 50.4689}, // YHR
    Coordinate{-123.719, 49.4606}, // YHS
    Coordinate{-137.545, 60.7894}, // YHT
    Coordinate{-73.4169, 45.5181}, // YHU
    Coordinate{-115.783, 60.8397}, // YHY
    Coordinate{-63.5103, 44.8797}, // YHZ
    Coordinate{-91.6386, 48.7739}, // YIB
    Coordinate{114.308, 27.8033}, // YIC
    Coordinate{119.912, 47.3106}, // YIE
    Coordinate{-58.6575, 51.2097}, // YIF
    Coordinate{-125.133, 50.4}, // YIG
    Coordinate{111.48, 30.5565}, // YIH
    Coordinate{-77.9253, 62.4172}, // YIK
    Coordinate{81.3303, 43.9558}, // YIN
    Coordinate{-77.9689, 72.6894}, // YIO
    Coordinate{-83.5304, 42.2379}, // YIP
    Coordinate{-94.6536, 53.8572}, // YIV
    Coordinate{120.032, 29.3447}, // YIW
    Coordinate{-118.059, 52.9967}, // YJA
    Coordinate{-123.47, 60.2356}, // YJF
    Coordinate{-124.263, 54.3972}, // YJM
    Coordinate{-73.2817, 45.2944}, // YJN
    Coordinate{-117.753, 53.3192}, // YJP
    Coordinate{128.41, 41.9072}, // YJS
    Coordinate{-58.55, 48.5414}, // YJT
    Coordinate{-120.449, 50.7025}, // YKA
    Coordinate{-103.677, 58.2361}, // YKC
    Coordinate{-81.6056, 44.2014}, // YKD
    Coordinate{-94.7981, 54.9153}, // YKE
    Coordinate{-80.3786, 43.4608}, // YKF
    Coordinate{-69.9992, 60.0272}, // YKG
    Coordinate{122.357, 40.5408}, // YKH
    Coordinate{-105.618, 57.2564}, // YKJ
    Coordinate{-130.433, 53.8}, // YKK
    Coordinate{-66.8053, 54.8053}, // YKL
    Coordinate{-120.544, 46.5681}, // YKM
    Coordinate{-97.3858, 42.9167}, // YKN
    Coordinate{44.2833, 37.5667}, // YKO
    Coordinate{-78.7583, 51.4733}, // YKQ
    Coordinate{129.772, 62.0933}, // YKS
    Coordinate{-78.9169, 53.8058}, // YKU
    Coordinate{-79.9814, 48.2103}, // YKX
    Coordinate{-109.181, 51.5153}, // YKY
    Coordinate{-79.3686, 43.8608}, // YKZ
    Coordinate{-112.032, 54.7703}, // YLB
    Coordinate{-69.8772, 62.8481}, // YLC
    Coordinate{-83.3469, 47.8203}, // YLD
    Coordinate{-117.246, 63.1317}, // YLE
    Coordinate{-87.9342, 52.1956}, // YLH
    Coordinate{-108.523, 54.1253}, // YLJ
    Coordinate{-79.5556, 44.4861}, // YLK
    Coordinate{-110.073, 53.3092}, // YLL
    Coordinate{-72.7889, 47.4097}, // YLQ
    Coordinate{-99.9853, 56.5133}, // YLR
    Coordinate{-77.0172, 49.0303}, // YLS
    Coordinate{-62.2806, 82.5178}, // YLT
    Coordinate{47.1417, 40.6317}, // YLV
    Coordinate{-119.378, 49.9572}, // YLW
    Coordinate{-122.631, 49.1008}, // YLY
    Coordinate{-135.868, 63.6164}, // YMA
    Coordinate{-120.747, 50.1228}, // YMB
    Coordinate{-119.319, 76.2392}, // YMD
    Coordinate{-67.4522, 48.8564}, // YME
    Coordinate{-85.8611, 49.0833}, // YMG
    Coordinate{-55.8478, 52.3028}, // YMH
    Coordinate{-70.2239, 47.5975}, // YML
    Coordinate{-111.223, 56.6533}, // YMM
    Coordinate{-59.1878, 55.0772}, // YMN
    Coordinate{-80.6083, 51.2919}, // YMO
    Coordinate{-127.029, 50.5756}, // YMP
    Coordinate{-76.1181, -5.89361}, // YMS
    Coordinate{-74.5281, 49.7719}, // YMT
    Coordinate{-124.983, 50.0667}, // YMU
    Coordinate{-79.3569, 71.3242}, // YMV
    Coordinate{-75.9906, 46.2728}, // YMW
    Coordinate{-74.0386, 45.6797}, // YMX
    Coordinate{-61.7889, 50.19}, // YNA
    Coordinate{38.0636, 24.1442}, // YNB
    Coordinate{-78.8311, 53.0106}, // YNC
    Coordinate{-75.5636, 45.5217}, // YND
    Coordinate{-97.8442, 53.9583}, // YNE
    Coordinate{-80.6792, 41.2608}, // YNG
    Coordinate{-121.976, 56.0356}, // YNH
    Coordinate{129.451, 42.8828}, // YNJ
    Coordinate{-104.082, 58.2767}, // YNL
    Coordinate{-77.8028, 49.7617}, // YNM
    Coordinate{-92.9711, 52.4733}, // YNO
    Coordinate{-61.1844, 55.9139}, // YNP
    Coordinate{-96.9581, 50.8367}, // YNR
    Coordinate{-76.1356, 51.6911}, // YNS
    Coordinate{120.979, 37.6578}, // YNT
    Coordinate{-110.906, 63.5936}, // YNX
    Coordinate{128.669, 38.0614}, // YNY
    Coordinate{120.203, 33.4258}, // YNZ
    Coordinate{-110.615, 64.6989}, // YOA
    Coordinate{-139.84, 67.57}, // YOC
    Coordinate{-117.094, 55.7094}, // YOE
    Coordinate{-85.9011, 51.6586}, // YOG
    Coordinate{-95.2789, 54.9331}, // YOH
    Coordinate{-76.6119, 52.2219}, // YOI
    Coordinate{-117.165, 58.6217}, // YOJ
    Coordinate{12.4303, 9.2575}, // YOL
    Coordinate{91.5145, 27.2564}, // YON
    Coordinate{-78.8967, 43.9228}, // YOO
    Coordinate{-119.408, 58.4914}, // YOP
    Coordinate{-80.8383, 44.5906}, // YOS
    Coordinate{35.0675, 29.9011}, // YOT
    Coordinate{-75.6672, 45.3225}, // YOW
    Coordinate{-105.673, 53.2144}, // YPA
    Coordinate{-124.931, 49.3219}, // YPB
    Coordinate{-124.076, 69.3606}, // YPC
    Coordinate{-79.8297, 45.2575}, // YPD
    Coordinate{-117.447, 56.2272}, // YPE
    Coordinate{-123.4, 48.4333}, // YPF
    Coordinate{-98.2739, 49.9031}, // YPG
    Coordinate{-78.0769, 58.4719}, // YPH
    Coordinate{-130.433, 54.5667}, // YPI
    Coordinate{-69.5997, 59.2967}, // YPJ
    Coordinate{-122.713, 49.2161}, // YPK
    Coordinate{-90.2142, 51.4464}, // YPL
    Coordinate{-93.9733, 51.8197}, // YPM
    Coordinate{-64.2886, 49.8364}, // YPN
    Coordinate{-85.4433, 54.9881}, // YPO
    Coordinate{-78.3633, 44.2306}, // YPQ
    Coordinate{-130.445, 54.2858}, // YPR
    Coordinate{-61.3681, 45.6567}, // YPS
    Coordinate{-124.017, 49.6167}, // YPT
    Coordinate{-124.5, 49.8342}, // YPW
    Coordinate{-77.2875, 60.0522}, // YPX
    Coordinate{-111.118, 58.7675}, // YPY
    Coordinate{-125.951, 54.3764}, // YPZ
    Coordinate{-79.3039, 44.975}, // YQA
    Coordinate{-71.3933, 46.7911}, // YQB
    Coordinate{-69.6178, 61.0464}, // YQC
    Coordinate{-101.091, 53.9714}, // YQD
    Coordinate{-113.894, 52.1822}, // YQF
    Coordinate{-82.9553, 42.2761}, // YQG
    Coordinate{-128.822, 60.1164}, // YQH
    Coordinate{-66.0883, 43.8272}, // YQI
    Coordinate{-94.3631, 49.7883}, // YQK
    Coordinate{-112.8, 49.6303}, // YQL
    Coordinate{-64.6786, 46.1122}, // YQM
    Coordinate{-86.6975, 50.1831}, // YQN
    Coordinate{-104.666, 50.4322}, // YQR
    Coordinate{-81.1097, 42.77}, // YQS
    Coordinate{-89.3217, 48.3719}, // YQT
    Coordinate{-118.885, 55.18}, // YQU
    Coordinate{-102.461, 51.2647}, // YQV
    Coordinate{-108.244, 52.7692}, // YQW
    Coordinate{-54.5681, 48.9369}, // YQX
    Coordinate{-60.0481, 46.1614}, // YQY
    Coordinate{-122.51, 53.0261}, // YQZ
    Coordinate{-117.31, 64.1161}, // YRA
    Coordinate{-94.9694, 74.7169}, // YRB
    Coordinate{-71.0506, 48.5208}, // YRC
    Coordinate{-57.0419, 53.6825}, // YRF
    Coordinate{-58.4578, 54.1794}, // YRG
    Coordinate{-69.5844, 47.7644}, // YRI
    Coordinate{-72.2658, 48.52}, // YRJ
    Coordinate{-93.7931, 51.0672}, // YRL
    Coordinate{-114.904, 52.4297}, // YRM
    Coordinate{-127.25, 51.6833}, // YRN
    Coordinate{-75.6461, 45.4603}, // YRO
    Coordinate{-76.0222, 45.3225}, // YRP
    Coordinate{-72.6806, 46.3517}, // YRQ
    Coordinate{-93.5575, 54.1675}, // YRS
    Coordinate{-92.1147, 62.8106}, // YRT
    Coordinate{-118.183, 50.9667}, // YRV
    Coordinate{-59.9597, 43.9294}, // YSA
    Coordinate{-80.7978, 46.6256}, // YSB
    Coordinate{-71.6914, 45.4386}, // YSC
    Coordinate{-123.162, 49.7817}, // YSE
    Coordinate{-105.841, 59.2503}, // YSF
    Coordinate{-110.682, 62.4183}, // YSG
    Coordinate{-75.9403, 44.9458}, // YSH
    Coordinate{-80.1375, 45.1733}, // YSI
    Coordinate{-65.89, 45.3161}, // YSJ
    Coordinate{-79.25, 56.5369}, // YSK
    Coordinate{-67.8364, 47.1572}, // YSL
    Coordinate{-111.962, 60.0203}, // YSM
    Coordinate{-119.229, 50.6825}, // YSN
    Coordinate{-59.7853, 54.9103}, // YSO
    Coordinate{-86.3458, 48.7572}, // YSP
    Coordinate{124.55, 44.9381}, // YSQ
    Coordinate{-84.6136, 72.9822}, // YSR
    Coordinate{-94.8522, 53.8456}, // YST
    Coordinate{-63.8336, 46.4406}, // YSU
    Coordinate{-62.6542, 58.4744}, // YSV
    Coordinate{-128.083, 52.15}, // YSX
    Coordinate{-125.241, 71.9936}, // YSY
    Coordinate{-77.2514, 45.8644}, // YTA
    Coordinate{-129.25, 53.4167}, // YTB
    Coordinate{-97.7078, 55.3189}, // YTD
    Coordinate{-76.525, 64.2303}, // YTE
    Coordinate{-71.6414, 48.5086}, // YTF
    Coordinate{-126.833, 50.8833}, // YTG
    Coordinate{-97.8625, 55.8047}, // YTH
    Coordinate{-87.0994, 48.8133}, // YTJ
    Coordinate{-89.8969, 53.8178}, // YTL
    Coordinate{-74.78, 46.4092}, // YTM
    Coordinate{-62.6211, 45.6119}, // YTN
    Coordinate{-125.91, 49.1553}, // YTP
    Coordinate{-69.9558, 58.6678}, // YTQ
    Coordinate{-81.3767, 48.5706}, // YTS
    Coordinate{-104.067, 52.8367}, // YTT
    Coordinate{-132.042, 52.765}, // YTU
    Coordinate{-131.117, 57.9167}, // YTX
    Coordinate{119.715, 32.5617}, // YTY
    Coordinate{-79.3961, 43.6275}, // YTZ
    Coordinate{-133.026, 69.4333}, // YUB
    Coordinate{-76.5183, 56.5361}, // YUD
    Coordinate{131.782, -22.2542}, // YUE
    Coordinate{-73.7408, 45.4706}, // YUL
    Coordinate{-114.606, 32.6567}, // YUM
    Coordinate{97.0382, 32.8387}, // YUS
    Coordinate{-86.2247, 66.5206}, // YUT
    Coordinate{-81.2425, 68.7758}, // YUX
    Coordinate{-78.8356, 48.2061}, // YUY
    Coordinate{43.2439, -11.7108}, // YVA
    Coordinate{-65.4603, 48.0711}, // YVB
    Coordinate{-105.267, 55.1514}, // YVC
    Coordinate{-119.331, 50.2461}, // YVE
    Coordinate{-110.825, 52.3569}, // YVG
    Coordinate{-64.0317, 67.5467}, // YVM
    Coordinate{-77.7828, 48.0533}, // YVO
    Coordinate{-68.4222, 58.095}, // YVP
    Coordinate{-126.799, 65.2814}, // YVQ
    Coordinate{-123.184, 49.1947}, // YVR
    Coordinate{-108.418, 55.8419}, // YVT
    Coordinate{-81.1086, 44.7442}, // YVV
    Coordinate{-94.0614, 52.6558}, // YVZ
    Coordinate{-77.3192, 45.9522}, // YWA
    Coordinate{-71.9294, 61.5886}, // YWB
    Coordinate{-97.24, 49.91}, // YWG
    Coordinate{-123.387, 48.4228}, // YWH
    Coordinate{-123.436, 65.2111}, // YWJ
    Coordinate{-66.8647, 52.9228}, // YWK
    Coordinate{-122.054, 52.1833}, // YWL
    Coordinate{-55.785, 52.5675}, // YWM
    Coordinate{-111.25, 65.7592}, // YWO
    Coordinate{-87.3753, 52.9594}, // YWP
    Coordinate{-71.1361, 49.945}, // YWQ
    Coordinate{-85.2233, 48.6269}, // YWR
    Coordinate{-122.949, 50.1436}, // YWS
    Coordinate{-110.857, 52.7958}, // YWV
    Coordinate{-123.437, 63.2097}, // YWY
    Coordinate{-115.782, 49.6122}, // YXC
    Coordinate{-113.519, 53.5719}, // YXD
    Coordinate{-106.7, 52.1708}, // YXE
    Coordinate{-110.721, 50.0189}, // YXH
    Coordinate{-77.6028, 45.6631}, // YXI
    Coordinate{-120.74, 56.2383}, // YXJ
    Coordinate{-68.4964, 48.4778}, // YXK
    Coordinate{-91.9056, 50.1142}, // YXL
    Coordinate{-92.5981, 62.24}, // YXN
    Coordinate{-65.7136, 66.145}, // YXP
    Coordinate{-140.869, 62.4103}, // YXQ
    Coordinate{-79.8489, 47.695}, // YXR
    Coordinate{-122.677, 53.8842}, // YXS
    Coordinate{-128.578, 54.4686}, // YXT
    Coordinate{-81.1511, 43.0331}, // YXU
    Coordinate{-122.36, 49.0253}, // YXX
    Coordinate{-135.067, 60.7094}, // YXY
    Coordinate{-84.7864, 47.9669}, // YXZ
    Coordinate{-79.4242, 46.3639}, // YYB
    Coordinate{-114.02, 51.1139}, // YYC
    Coordinate{-127.183, 54.8253}, // YYD
    Coordinate{-122.597, 58.8364}, // YYE
    Coordinate{-119.602, 49.4625}, // YYF
    Coordinate{-63.1192, 46.2892}, // YYG
    Coordinate{-93.5769, 69.5467}, // YYH
    Coordinate{-123.426, 48.6472}, // YYJ
    Coordinate{-101.076, 56.8644}, // YYL
    Coordinate{-114.094, 49.6364}, // YYM
    Coordinate{-107.691, 50.2925}, // YYN
    Coordinate{-104.169, 51.8092}, // YYO
    Coordinate{-94.0664, 58.7392}, // YYQ
    Coordinate{-52.7525, 47.6186}, // YYT
    Coordinate{-82.4686, 49.4117}, // YYU
    Coordinate{-88.9097, 50.2903}, // YYW
    Coordinate{-68.2075, 48.6089}, // YYY
    Coordinate{-79.6306, 43.6767}, // YYZ
    Coordinate{-121.322, 50.775}, // YZA
    Coordinate{-79.4656, 43.7428}, // YZD
    Coordinate{-82.5683, 45.8842}, // YZE
    Coordinate{-114.44, 62.4631}, // YZF
    Coordinate{-75.6672, 62.1794}, // YZG
    Coordinate{-114.777, 55.2931}, // YZH
    Coordinate{-131.814, 53.2542}, // YZP
    Coordinate{-82.3094, 42.9997}, // YZR
    Coordinate{-83.3594, 64.1933}, // YZS
    Coordinate{-127.333, 50.6806}, // YZT
    Coordinate{-115.787, 54.1439}, // YZU
    Coordinate{-66.2656, 50.2233}, // YZV
    Coordinate{-132.744, 60.1731}, // YZW
    Coordinate{100.675, 38.8019}, // YZY
    Coordinate{-117.609, 49.0556}, // YZZ
    Coordinate{-129.483, 55.4667}, // ZAA
    Coordinate{-96.0892, 56.0894}, // ZAC
    Coordinate{15.3467, 44.1083}, // ZAD
    Coordinate{16.0689, 45.7431}, // ZAG
    Coordinate{60.9033, 29.4733}, // ZAH
    Coordinate{61.8667, 30.9695}, // ZAJ
    Coordinate{-73.0863, -39.6498}, // ZAL
    Coordinate{122.06, 6.92242}, // ZAM
    Coordinate{-103.459, 20.7333}, // ZAP
    Coordinate{7.68556, 11.13}, // ZAR
    Coordinate{103.757, 27.3278}, // ZAT
    Coordinate{-1.04167, 41.6661}, // ZAZ
    Coordinate{-65.7389, 47.6297}, // ZBF
    Coordinate{19.4233, 54.1409}, // ZBG
    Coordinate{19.2333, 43.1167}, // ZBK
    Coordinate{150.5, -24.3958}, // ZBL
    Coordinate{-72.7419, 45.2908}, // ZBM
    Coordinate{148.215, -20.0199}, // ZBO
    Coordinate{60.3819, 25.4433}, // ZBR
    Coordinate{101.708, 19.2417}, // ZBY
    Coordinate{7.89933, 51.4833}, // ZCA
    Coordinate{8.18667, 48.7919}, // ZCC
    Coordinate{-102.686, 22.8974}, // ZCL
    Coordinate{-72.6514, -38.9258}, // ZCO
    Coordinate{-71.2169, -34.9669}, // ZCQ
    Coordinate{52.3358, 24.5031}, // ZDY
    Coordinate{-80.7861, 36.28}, // ZEF
    Coordinate{-128.157, 52.185}, // ZEL
    Coordinate{-78.5225, 52.2264}, // ZEM
    Coordinate{93.8281, 27.5883}, // ZER
    Coordinate{-133.373, 62.2069}, // ZFA
    Coordinate{-107.182, 59.3344}, // ZFD
    Coordinate{-134.86, 67.4069}, // ZFM
    Coordinate{-125.573, 64.9097}, // ZFN
    Coordinate{-118.433, 56.0814}, // ZFW
    Coordinate{-118.431, 49.0156}, // ZGF
    Coordinate{-94.0786, 54.8397}, // ZGI
    Coordinate{}, // ZGL
    Coordinate{25.9333, -15.9667}, // ZGM
    Coordinate{-95.4661, 52.045}, // ZGR
    Coordinate{-60.6739, 50.2597}, // ZGS
    Coordinate{167.587, -14.2181}, // ZGU
    Coordinate{110.358, 21.2175}, // ZHA
    Coordinate{91.9169, 24.3983}, // ZHM
    Coordinate{-116.475, 53.3936}, // ZHP
    Coordinate{6.79278, 47.0839}, // ZHV
    Coordinate{105.154, 37.5728}, // ZHY
    Coordinate{38.1517, 55.5533}, // ZIA
    Coordinate{-72.3486, -38.2456}, // ZIC
    Coordinate{-16.2817, 12.5556}, // ZIG
    Coordinate{-101.461, 17.6014}, // ZIH
    Coordinate{7.87786, 46.6747}, // ZIN
    Coordinate{12.25, 31.775}, // ZIS
    Coordinate{123.361, 66.7964}, // ZIX
    Coordinate{-98.0461, 54.5189}, // ZJG
    Coordinate{8.87861, 46.1608}, // ZJI
    Coordinate{-101.234, 52.1214}, // ZJN
    Coordinate{30.6614, -8.53333}, // ZKB
    Coordinate{-81.6778, 52.2825}, // ZKE
    Coordinate{-61.2658, 50.1958}, // ZKG
    Coordinate{9.76528, -2.53889}, // ZKM
    Coordinate{150.708, 65.7383}, // ZKP
    Coordinate{-17.0833, 20.85}, // ZLG
    Coordinate{-104.559, 19.1447}, // ZLO
    Coordinate{-71.5486, -35.8617}, // ZLR
    Coordinate{-58.9756, 50.8308}, // ZLT
    Coordinate{23.4824, 12.9012}, // ZLX
    Coordinate{11.6265, 52.0732}, // ZMG
    Coordinate{-121.333, 51.7367}, // ZMH
    Coordinate