/*
   Copyright (C) 2019 Montel Laurent <montel@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef QUICKTEXTCONFIGUREDIALOG_H
#define QUICKTEXTCONFIGUREDIALOG_H
#include <QDialog>
#include "quicktext_export.h"
class QuickTextConfigureWidget;
class QUICKTEXT_EXPORT QuickTextConfigureDialog : public QDialog
{
    Q_OBJECT
public:
    explicit QuickTextConfigureDialog(QWidget *parent = nullptr);
    ~QuickTextConfigureDialog();

protected:
    void closeEvent(QCloseEvent *e) override;

private:
    void writeConfig();
    void readConfig();
    void slotAccepted();
    void slotExport();
    void slotImport();
    QuickTextConfigureWidget *mQuickTextConfigureWidget = nullptr;
};

#endif // QUICKTEXTCONFIGUREDIALOG_H
