/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import org.openide.TopManager;
import org.openide.actions.ActionConstants;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class HelpAction
extends SystemAction {
    private static final long serialVersionUID = 4658008202517094416L;

    public String getName() {
        return "Help";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("OpenIDE-Transmodal-Action", Boolean.TRUE);
    }

    private static HelpCtx findHelpCtx() {
        Window window = WindowActivatedDetector.getCurrentActivatedWindow();
        Component component = window != null ? SwingUtilities.findFocusOwner(window) : null;
        HelpCtx helpCtx = component == null ? HelpCtx.DEFAULT_HELP : HelpCtx.findHelp(component);
        return helpCtx;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        HelpCtx helpCtx;
        final MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        if (menuElementArray != null && menuElementArray.length > 0 && !(menuElementArray[0].getComponent() instanceof ComboPopup)) {
            helpCtx = HelpCtx.findHelp(menuElementArray[menuElementArray.length - 1].getComponent());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MenuElement[] menuElementArray2 = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (menuElementArray2.length != menuElementArray.length) {
                        return;
                    }
                    int n = 0;
                    while (n < menuElementArray2.length) {
                        if (menuElementArray2[n] != menuElementArray[n]) {
                            return;
                        }
                        ++n;
                    }
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            });
        } else {
            helpCtx = HelpAction.findHelpCtx();
        }
        TopManager.getDefault().setStatusText(ActionConstants.BUNDLE.getString("CTL_OpeningHelp"));
        TopManager.getDefault().showHelp(helpCtx);
        TopManager.getDefault().setStatusText("");
    }

    static {
        WindowActivatedDetector.install();
    }

    private static class WindowActivatedDetector
    implements AWTEventListener {
        private static WeakReference currentWindowRef;
        private static boolean installed;

        private WindowActivatedDetector() {
        }

        static synchronized void install() {
            if (installed) {
                return;
            }
            installed = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new WindowActivatedDetector(), 64L);
        }

        static synchronized Window getCurrentActivatedWindow() {
            if (currentWindowRef != null) {
                return (Window)currentWindowRef.get();
            }
            return null;
        }

        private static synchronized void setCurrentActivatedWindow(Window window) {
            currentWindowRef = new WeakReference<Window>(window);
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent.getID() != 205) {
                return;
            }
            WindowActivatedDetector.setCurrentActivatedWindow(((WindowEvent)aWTEvent).getWindow());
        }
    }
}

