/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.TickUnits;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.Range;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public abstract class NumberAxis
extends ValueAxis {
    public static final boolean DEFAULT_AUTO_RANGE_INCLUDES_ZERO = true;
    public static final boolean DEFAULT_AUTO_RANGE_STICKY_ZERO = true;
    public static final NumberTickUnit DEFAULT_TICK_UNIT = new NumberTickUnit(1.0, new DecimalFormat("0"));
    private boolean inverted;
    private boolean autoRangeIncludesZero;
    private boolean autoRangeStickyZero;
    private NumberTickUnit tickUnit;

    protected NumberAxis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, AxisConstants.DEFAULT_TICK_PAINT, true, ValueAxis.DEFAULT_AUTO_RANGE_MINIMUM_SIZE, true, true, 0.0, 1.0, false, true, DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, 0.0, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    protected NumberAxis(String string, Font font, Paint paint, Insets insets, boolean bl, Font font2, Paint paint2, Insets insets2, boolean bl2, Stroke stroke, Paint paint3, boolean bl3, Number number, boolean bl4, boolean bl5, double d, double d2, boolean bl6, boolean bl7, NumberTickUnit numberTickUnit, boolean bl8, Stroke stroke2, Paint paint4, double d3, boolean bl9, double d4, Stroke stroke3, Paint paint5) {
        super(string, font, paint, insets, bl, font2, paint2, insets2, bl2, stroke, paint3, new Range(d, d2), bl3, number, bl7, NumberAxis.createStandardTickUnits(), bl8, stroke2, paint4, d3, bl9, d4, stroke3, paint5);
        if (number == null) {
            throw new IllegalArgumentException("NumberAxis(...): autoRangeMinimumSize cannot be null.");
        }
        this.autoRangeIncludesZero = bl4;
        this.autoRangeStickyZero = bl5;
        this.inverted = bl6;
        this.tickUnit = numberTickUnit;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean bl) {
        if (this.inverted != bl) {
            this.inverted = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean autoRangeIncludesZero() {
        return this.autoRangeIncludesZero;
    }

    public void setAutoRangeIncludesZero(boolean bl) {
        if (this.autoRangeIncludesZero != bl) {
            this.autoRangeIncludesZero = bl;
            if (this.isAutoRange()) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean autoRangeStickyZero() {
        return this.autoRangeStickyZero;
    }

    public void setAutoRangeStickyZero(boolean bl) {
        if (this.autoRangeStickyZero != bl) {
            this.autoRangeStickyZero = bl;
            if (this.isAutoRange()) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public NumberTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(NumberTickUnit numberTickUnit) {
        this.setTickUnitAttribute(numberTickUnit);
        this.setAutoTickUnitSelectionAttribute(false);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    protected void setTickUnitAttribute(NumberTickUnit numberTickUnit) {
        this.tickUnit = numberTickUnit;
    }

    public double calculateLowestVisibleTickValue() {
        double d = this.getTickUnit().getSize();
        double d2 = Math.ceil(this.getRange().getLowerBound() / d);
        return d2 * d;
    }

    public double calculateHighestVisibleTickValue() {
        double d = this.getTickUnit().getSize();
        double d2 = Math.floor(this.getRange().getUpperBound() / d);
        return d2 * d;
    }

    public int calculateVisibleTickCount() {
        double d = this.getTickUnit().getSize();
        Range range = this.getRange();
        return (int)(Math.floor(range.getUpperBound() / d) - Math.ceil(range.getLowerBound() / d) + 1.0);
    }

    public static TickUnits createStandardTickUnits() {
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(1.0E-7, new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(1.0E-6, new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(1.0E-5, new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(1.0E-4, new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(0.001, new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(0.01, new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(0.1, new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(1.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(10.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(100.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(1000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(10000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(100000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1000000.0, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E7, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E8, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E9, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E-7, new DecimalFormat("0.00000000")));
        tickUnits.add(new NumberTickUnit(2.5E-6, new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(2.5E-5, new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(2.5E-4, new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(0.0025, new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(0.025, new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(0.25, new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(2.5, new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(25.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(250.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(2500.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(25000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(250000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2500000.0, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E7, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E8, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E9, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E-7, new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(5.0E-6, new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(5.0E-5, new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(5.0E-4, new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(0.005, new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(0.05, new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(0.5, new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(5.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(50.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(500.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(5000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(50000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(500000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5000000.0, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E7, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E8, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E9, new DecimalFormat("#,###,###,##0")));
        return tickUnits;
    }

    public static TickUnits createIntegerTickUnits() {
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(1.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(2.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(5.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(10.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(20.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(50.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(100.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(200.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(500.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(1000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(10000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(20000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(50000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(100000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(200000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(500000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1000000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2000000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5000000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E7, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2.0E7, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5.0E7, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E8, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2.0E8, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5.0E8, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E9, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2.0E9, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5.0E9, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E10, new DecimalFormat("#,##0")));
        return tickUnits;
    }

    public static TickUnits createStandardTickUnits(Locale locale) {
        TickUnits tickUnits = new TickUnits();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        tickUnits.add(new NumberTickUnit(1.0E-7, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E-6, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E-5, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E-4, numberFormat));
        tickUnits.add(new NumberTickUnit(0.001, numberFormat));
        tickUnits.add(new NumberTickUnit(0.01, numberFormat));
        tickUnits.add(new NumberTickUnit(0.1, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-7, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-6, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-5, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-4, numberFormat));
        tickUnits.add(new NumberTickUnit(0.0025, numberFormat));
        tickUnits.add(new NumberTickUnit(0.025, numberFormat));
        tickUnits.add(new NumberTickUnit(0.25, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5, numberFormat));
        tickUnits.add(new NumberTickUnit(25.0, numberFormat));
        tickUnits.add(new NumberTickUnit(250.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2500.0, numberFormat));
        tickUnits.add(new NumberTickUnit(25000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(250000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2500000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E7, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E8, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E9, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-7, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-6, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-5, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-4, numberFormat));
        tickUnits.add(new NumberTickUnit(0.005, numberFormat));
        tickUnits.add(new NumberTickUnit(0.05, numberFormat));
        tickUnits.add(new NumberTickUnit(0.5, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E9, numberFormat));
        return tickUnits;
    }

    public static TickUnits createIntegerTickUnits(Locale locale) {
        TickUnits tickUnits = new TickUnits();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        tickUnits.add(new NumberTickUnit(1.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10.0, numberFormat));
        tickUnits.add(new NumberTickUnit(20.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100.0, numberFormat));
        tickUnits.add(new NumberTickUnit(200.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(20000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(200000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E10, numberFormat));
        return tickUnits;
    }
}

