/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.data.Range;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class VerticalLogarithmicAxis
extends VerticalNumberAxis {
    public static final double LOG10_VALUE = Math.log(10.0);
    public static final double SMALL_LOG_VALUE = 1.0E-100;
    private boolean log10TickLabelsFlag;
    private boolean allowNegativesFlag;
    private boolean smallLogFlag = false;
    private final DecimalFormat numberFormatterObj = new DecimalFormat("0.00000");

    public VerticalLogarithmicAxis() {
        this(null);
    }

    public VerticalLogarithmicAxis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, 1.0, 10.0);
    }

    public VerticalLogarithmicAxis(String string, Font font, double d, double d2) {
        this(string, font, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, AxisConstants.DEFAULT_TICK_PAINT, true, ValueAxis.DEFAULT_AUTO_RANGE_MINIMUM_SIZE, true, d, d2, false, true, NumberAxis.DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, 0.0, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT, true, false);
    }

    public VerticalLogarithmicAxis(String string, Font font, Paint paint, Insets insets, boolean bl, boolean bl2, Font font2, Paint paint2, Insets insets2, boolean bl3, Stroke stroke, Paint paint3, boolean bl4, Number number, boolean bl5, double d, double d2, boolean bl6, boolean bl7, NumberTickUnit numberTickUnit, boolean bl8, Stroke stroke2, Paint paint4, double d3, boolean bl9, double d4, Stroke stroke3, Paint paint5, boolean bl10, boolean bl11) {
        super(string, font, paint, insets, bl, bl2, font2, paint2, insets2, bl3, stroke, paint3, bl4, number, bl5, false, d, d2, bl6, bl7, numberTickUnit, bl8, stroke2, paint4, d3, bl9, d4, stroke3, paint5);
        this.log10TickLabelsFlag = bl10;
        this.allowNegativesFlag = bl11;
        if (!bl4) {
            this.setupSmallLogFlag();
        }
    }

    public void setLog10TickLabelsFlag(boolean bl) {
        this.log10TickLabelsFlag = bl;
    }

    public boolean getLog10TickLabelsFlag() {
        return this.log10TickLabelsFlag;
    }

    public void setAllowNegativesFlag(boolean bl) {
        this.allowNegativesFlag = bl;
    }

    public boolean getAllowNegativesFlag() {
        return this.allowNegativesFlag;
    }

    public void setRange(Range range) {
        super.setRange(range);
        this.setupSmallLogFlag();
    }

    protected void setupSmallLogFlag() {
        double d = this.getRange().getLowerBound();
        this.smallLogFlag = !this.allowNegativesFlag && d < 10.0 && d > 0.0;
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d2 = this.switchedLog10(range.getLowerBound());
        double d3 = this.switchedLog10(range.getUpperBound());
        double d4 = rectangle2D.getMaxY();
        double d5 = rectangle2D.getMinY();
        d = this.switchedLog10(d);
        if (this.isInverted()) {
            return d5 + (d - d2) / (d3 - d2) * (d4 - d5);
        }
        return d4 - (d - d2) / (d3 - d2) * (d4 - d5);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d = this.switchedLog10(range.getLowerBound());
        double d2 = this.switchedLog10(range.getUpperBound());
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getMaxY();
        if (this.isInverted()) {
            return d + Math.pow(10.0, ((double)f - d3) / (d4 - d3) * (d2 - d));
        }
        return d2 - Math.pow(10.0, ((double)f - d3) / (d4 - d3) * (d2 - d));
    }

    public void autoAdjustRange() {
        if (this.plot == null) {
            return;
        }
        if (this.plot instanceof VerticalValuePlot) {
            double d;
            VerticalValuePlot verticalValuePlot = (VerticalValuePlot)((Object)this.plot);
            Range range = verticalValuePlot.getVerticalDataRange();
            if (range == null) {
                range = new Range(0.0, 1.0);
            }
            double d2 = this.computeLogFloor(range.getLowerBound());
            if (!this.allowNegativesFlag && d2 >= 0.0 && d2 < 1.0E-100) {
                d2 = range.getLowerBound();
            }
            double d3 = range.getUpperBound();
            if (!this.allowNegativesFlag && d3 < 1.0 && d3 > 0.0 && d2 > 0.0) {
                d = Math.log(d3) / LOG10_VALUE;
                d = Math.ceil(-d + 0.001);
                d3 = (d = Math.pow(10.0, d)) > 0.0 ? Math.ceil(d3 * d) / d : Math.ceil(d3);
            } else {
                d3 = this.computeLogCeil(d3);
            }
            d = this.getAutoRangeMinimumSize().doubleValue();
            if (d3 - d2 < d) {
                d3 = (d3 + d2 + d) / 2.0;
                d2 = (d3 + d2 - d) / 2.0;
            }
            this.setRangeAttribute(new Range(d2, d3));
            this.setupSmallLogFlag();
        }
    }

    private double computeLogCeil(double d) {
        double d2;
        if (this.allowNegativesFlag) {
            if (d > 10.0) {
                d2 = Math.log(d) / LOG10_VALUE;
                d2 = Math.ceil(d2);
                d2 = Math.pow(10.0, d2);
            } else if (d < -10.0) {
                d2 = Math.log(-d) / LOG10_VALUE;
                d2 = Math.ceil(-d2);
                d2 = -Math.pow(10.0, -d2);
            } else {
                d2 = Math.ceil(d);
            }
        } else if (d > 0.0) {
            d2 = Math.log(d) / LOG10_VALUE;
            d2 = Math.ceil(d2);
            d2 = Math.pow(10.0, d2);
        } else {
            d2 = Math.ceil(d);
        }
        return d2;
    }

    private double computeLogFloor(double d) {
        double d2;
        if (this.allowNegativesFlag) {
            if (d > 10.0) {
                d2 = Math.log(d) / LOG10_VALUE;
                d2 = Math.floor(d2);
                d2 = Math.pow(10.0, d2);
            } else if (d < -10.0) {
                d2 = Math.log(-d) / LOG10_VALUE;
                d2 = Math.floor(-d2);
                d2 = -Math.pow(10.0, -d2);
            } else {
                d2 = Math.floor(d);
            }
        } else if (d > 0.0) {
            d2 = Math.log(d) / LOG10_VALUE;
            d2 = Math.floor(d2);
            d2 = Math.pow(10.0, d2);
        } else {
            d2 = Math.floor(d);
        }
        return d2;
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.ticks.clear();
        double d = this.getRange().getLowerBound();
        if (this.smallLogFlag && d < 1.0E-100) {
            d = 1.0E-100;
        }
        double d2 = this.getRange().getUpperBound();
        int n = (int)Math.rint(this.switchedLog10(d));
        int n2 = (int)Math.rint(this.switchedLog10(d2));
        boolean bl = false;
        int n3 = n;
        while (n3 <= n2) {
            int n4 = 10;
            if (n3 == n2) {
                n4 = 1;
            }
            int n5 = 0;
            while (n5 < n4) {
                String string;
                double d3;
                if (this.smallLogFlag) {
                    d3 = Math.pow(10.0, n3) + Math.pow(10.0, n3) * (double)n5;
                    if (n5 == 0) {
                        if (this.log10TickLabelsFlag) {
                            string = "10^" + n3;
                        } else if (n3 >= 0) {
                            string = Long.toString((long)Math.rint(d3));
                        } else {
                            this.numberFormatterObj.setMaximumFractionDigits(-n3);
                            string = this.numberFormatterObj.format(d3);
                        }
                    } else {
                        string = "";
                    }
                } else {
                    if (bl) {
                        --n5;
                    }
                    double d4 = d3 = n3 >= 0 ? Math.pow(10.0, n3) + Math.pow(10.0, n3) * (double)n5 : -(Math.pow(10.0, -n3) - Math.pow(10.0, -n3 - 1) * (double)n5);
                    if (n5 == 0) {
                        if (!bl) {
                            if (n3 > n && n3 < n2 && Math.abs(d3 - 1.0) < 1.0E-4) {
                                d3 = 0.0;
                                bl = true;
                                string = "0";
                            } else {
                                string = this.log10TickLabelsFlag ? (n3 < 0 ? "-" : "") + "10^" + Math.abs(n3) : Long.toString((long)Math.rint(d3));
                            }
                        } else {
                            string = "";
                            bl = false;
                        }
                    } else {
                        string = "";
                        bl = false;
                    }
                }
                if (d3 > d2) {
                    return;
                }
                double d5 = this.translateValueToJava2D(d3, rectangle2D2);
                Rectangle2D rectangle2D3 = this.tickLabelFont.getStringBounds(string, graphics2D.getFontRenderContext());
                float f = (float)(rectangle2D2.getX() - rectangle2D3.getWidth() - (double)this.tickLabelInsets.left - (double)this.tickLabelInsets.right);
                float f2 = (float)(d5 + rectangle2D3.getHeight() / 3.0);
                this.ticks.add(new Tick(new Double(d3), string, f, f2));
                ++n5;
            }
            ++n3;
        }
    }

    protected double switchedLog10(double d) {
        return this.smallLogFlag ? Math.log(d) / LOG10_VALUE : this.adjustedLog10(d);
    }

    public double adjustedLog10(double d) {
        boolean bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        if (d < 10.0) {
            d += (10.0 - d) / 10.0;
        }
        return bl ? -(Math.log(d) / LOG10_VALUE) : Math.log(d) / LOG10_VALUE;
    }
}

