/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class XYDotRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo) {
        Paint paint = xYPlot.getSeriesPaint(n);
        Stroke stroke = xYPlot.getSeriesStroke(n);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getXValue(n, n2);
        Number number2 = xYDataset.getYValue(n, n2);
        if (number2 != null) {
            double d = number.doubleValue();
            double d2 = number2.doubleValue();
            double d3 = valueAxis.translateValueToJava2D(d, rectangle2D);
            double d4 = valueAxis2.translateValueToJava2D(d2, rectangle2D);
            graphics2D.drawRect((int)d3, (int)d4, 1, 1);
            if (valueAxis.isCrosshairLockedOnData()) {
                if (valueAxis2.isCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(d, d2);
                } else {
                    crosshairInfo.updateCrosshairX(d);
                }
            } else if (valueAxis2.isCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairY(d2);
            }
        }
    }
}

