/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.MinMaxCategoryRenderer;
import com.jrefinery.data.DefaultCategoryDataset;
import com.jrefinery.ui.ApplicationFrame;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;

public class MinMaxCategoryPlotDemo
extends ApplicationFrame {
    public MinMaxCategoryPlotDemo(String string) {
        super(string);
        double[][] dArrayArray = new double[][]{{1.0, 4.0, 3.0, 5.0, 5.0, 7.0, 7.0, 8.0}, {5.0, 7.0, 6.0, 8.0, 4.0, 4.0, 2.0, 1.0}, {4.0, 3.0, 2.0, 3.0, 6.0, 3.0, 4.0, 3.0}};
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset(dArrayArray);
        defaultCategoryDataset.setSeriesName(0, "First");
        defaultCategoryDataset.setSeriesName(1, "Second");
        defaultCategoryDataset.setSeriesName(2, "Third");
        Object[] objectArray = new String[]{"Category 1", "Category 2", "Category 3", "Category 4", "Category 5", "Category 6", "Category 7", "Category 8"};
        defaultCategoryDataset.setCategories(objectArray);
        JFreeChart jFreeChart = ChartFactory.createVerticalBarChart("Min/Max Category Plot", "Category", "Value", defaultCategoryDataset, true, true, false);
        jFreeChart.setBackgroundPaint(Color.yellow);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setRenderer(new MinMaxCategoryRenderer());
        categoryPlot.setSeriesPaint(new Paint[]{Color.green, Color.orange, Color.red});
        HorizontalCategoryAxis horizontalCategoryAxis = (HorizontalCategoryAxis)categoryPlot.getDomainAxis();
        horizontalCategoryAxis.setSkipCategoryLabelsToFit(true);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        MinMaxCategoryPlotDemo minMaxCategoryPlotDemo = new MinMaxCategoryPlotDemo("Min/Max Category Chart Demo");
        minMaxCategoryPlotDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)minMaxCategoryPlotDemo));
        minMaxCategoryPlotDemo.setVisible(true);
    }
}

