/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.tooltips;

import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import java.text.DateFormat;
import java.text.NumberFormat;

public class StandardCategoryToolTipGenerator
implements CategoryToolTipGenerator {
    private NumberFormat numberFormat;
    private DateFormat dateFormat;

    public StandardCategoryToolTipGenerator() {
        this(NumberFormat.getInstance());
    }

    public StandardCategoryToolTipGenerator(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.dateFormat = null;
    }

    public StandardCategoryToolTipGenerator(DateFormat dateFormat) {
        this.numberFormat = null;
        this.dateFormat = dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String generateToolTip(CategoryDataset categoryDataset, int n, Object object) {
        String string = "";
        Number number = categoryDataset.getValue(n, object);
        if (number != null) {
            String string2 = categoryDataset.getSeriesName(n);
            if (string2 != null) {
                string = string + string2 + ", ";
            }
            String string3 = object.toString();
            String string4 = null;
            if (this.numberFormat != null) {
                string4 = this.numberFormat.format(number);
            } else if (this.dateFormat != null) {
                string4 = this.dateFormat.format(number);
            }
            string = string + string3 + " = " + string4;
        }
        return string;
    }
}

