/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.XYDataset;

public class Regression {
    public static double[] getOLSRegression(double[][] dArray) {
        double d;
        double d2;
        double d3;
        double d4;
        int n = dArray.length;
        if (n < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d4 = dArray[n2][0];
            d3 = dArray[n2][1];
            d5 += d4;
            d6 += d3;
            d2 = d4 * d4;
            d7 += d2;
            d = d4 * d3;
            d8 += d;
            ++n2;
        }
        d4 = d7 - d5 * d5 / (double)n;
        d3 = d8 - d5 * d6 / (double)n;
        d2 = d5 / (double)n;
        d = d6 / (double)n;
        double[] dArray2 = new double[2];
        dArray2[1] = d3 / d4;
        dArray2[0] = d - dArray2[1] * d2;
        return dArray2;
    }

    public static double[] getOLSRegression(XYDataset xYDataset, int n) {
        double d;
        double d2;
        double d3;
        double d4;
        int n2 = xYDataset.getItemCount(n);
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            d4 = xYDataset.getXValue(n, n3).doubleValue();
            d3 = xYDataset.getYValue(n, n3).doubleValue();
            d5 += d4;
            d6 += d3;
            d2 = d4 * d4;
            d7 += d2;
            d = d4 * d3;
            d8 += d;
            ++n3;
        }
        d4 = d7 - d5 * d5 / (double)n2;
        d3 = d8 - d5 * d6 / (double)n2;
        d2 = d5 / (double)n2;
        d = d6 / (double)n2;
        double[] dArray = new double[2];
        dArray[1] = d3 / d4;
        dArray[0] = d - dArray[1] * d2;
        return dArray;
    }

    public static double[] getPowerRegression(double[][] dArray) {
        double d;
        double d2;
        double d3;
        double d4;
        int n = dArray.length;
        if (n < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d4 = Math.log(dArray[n2][0]);
            d3 = Math.log(dArray[n2][1]);
            d5 += d4;
            d6 += d3;
            d2 = d4 * d4;
            d7 += d2;
            d = d4 * d3;
            d8 += d;
            ++n2;
        }
        d4 = d7 - d5 * d5 / (double)n;
        d3 = d8 - d5 * d6 / (double)n;
        d2 = d5 / (double)n;
        d = d6 / (double)n;
        double[] dArray2 = new double[2];
        dArray2[1] = d3 / d4;
        dArray2[0] = Math.pow(Math.exp(1.0), d - dArray2[1] * d2);
        return dArray2;
    }

    public static double[] getPowerRegression(XYDataset xYDataset, int n) {
        double d;
        double d2;
        double d3;
        double d4;
        int n2 = xYDataset.getItemCount(n);
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            d4 = Math.log(xYDataset.getXValue(n, n3).doubleValue());
            d3 = Math.log(xYDataset.getYValue(n, n3).doubleValue());
            d5 += d4;
            d6 += d3;
            d2 = d4 * d4;
            d7 += d2;
            d = d4 * d3;
            d8 += d;
            ++n3;
        }
        d4 = d7 - d5 * d5 / (double)n2;
        d3 = d8 - d5 * d6 / (double)n2;
        d2 = d5 / (double)n2;
        d = d6 / (double)n2;
        double[] dArray = new double[2];
        dArray[1] = d3 / d4;
        dArray[0] = Math.pow(Math.exp(1.0), d - dArray[1] * d2);
        return dArray;
    }
}

