/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.palm;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.openoffice.xmerge.converter.palm.PalmDB;
import org.openoffice.xmerge.converter.palm.PdbHeader;
import org.openoffice.xmerge.converter.palm.Record;

public final class PdbEncoder {
    private PdbHeader header = new PdbHeader();
    private PalmDB db = null;
    private static final int START_UNIQUE_ID = 47806;

    public PdbEncoder(PalmDB palmDB) {
        this.header.version = palmDB.getVersion();
        this.header.attribute = palmDB.getAttribute();
        this.db = palmDB;
        this.header.pdbName = palmDB.getPDBNameBytes();
        this.header.creatorID = palmDB.getCreatorID();
        this.header.typeID = palmDB.getTypeID();
        Date date = new Date();
        this.header.modificationDate = this.header.creationDate = date.getTime() / 1000L + 2082844800L;
        this.header.numRecords = palmDB.getRecordCount();
    }

    public void write(OutputStream outputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        this.header.write(dataOutputStream);
        if (this.header.numRecords > 0) {
            int n;
            int n2;
            Record record;
            int[] nArray = new int[this.header.numRecords];
            byte[] byArray = new byte[this.header.numRecords];
            nArray[0] = 78 + this.header.numRecords * 8;
            int n3 = this.header.numRecords - 1;
            int n4 = 0;
            while (n4 < n3) {
                record = this.db.getRecord(n4);
                n2 = record.getSize();
                byArray[n4] = record.getAttributes();
                nArray[n4 + 1] = nArray[n4] + n2;
                ++n4;
            }
            record = this.db.getRecord(n3);
            byArray[n3] = record.getAttributes();
            n2 = 47806;
            int n5 = 0;
            while (n5 < this.header.numRecords) {
                dataOutputStream.writeInt(nArray[n5]);
                n = byArray[n5] << 24;
                dataOutputStream.writeInt(n |= n2);
                ++n2;
                ++n5;
            }
            n = 0;
            while (n < this.header.numRecords) {
                Record record2 = this.db.getRecord(n);
                byte[] byArray2 = record2.getBytes();
                dataOutputStream.write(byArray2);
                ++n;
            }
        } else {
            dataOutputStream.writeShort(0);
        }
        dataOutputStream.flush();
    }
}

