/*************************************************************************
 *
 *  $RCSfile: SearchEnvironment.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.xmlsearch.qe;

import java.io.*;
import java.util.Vector;
import com.sun.xmlsearch.util.*;
import com.sun.xmlsearch.db.*;

class SearchEnvironment extends IndexAccessor {
  private IntegerArray _concepts;
  private IntegerArray _offsets;
  private byte[]       _allLists;

  private IntegerArray _concepts3;
  private IntegerArray _offsets3;
  private byte[]       _allChildren;
  
  private IntegerArray _documents;
  private IntegerArray _offsets2;
  private IntegerArray _titles;
  private byte[]       _positions;
  private int _currentBatchOffset = 0;
  private int _maxDocNumberInCache = -1;
  private int _positionsCacheSize = 1024*1024*2;
  private RandomAccessFile _positionsFile = null;
  private boolean _allInCache = false;
  
  private ByteArrayDecompressor _compr;
  
  private BtreeDict _tmap;
  
  //  protected SearchEnvironment() {}

  public SearchEnvironment(String indexDir) throws Exception {
    super(indexDir);
    _positions = new byte[_positionsCacheSize];
    readFromDB();
    _compr = new ByteArrayDecompressor(null, 0);
  }
  
  private void readMicroindexes(int docNo) throws java.io.IOException {
    //    System.out.println("readMicroindexes " + docNo);
    _currentBatchOffset = _offsets2.at(docNo);
    final int offsetLimit = _currentBatchOffset + _positionsCacheSize;
    int upTo = 0, nextDoc = docNo;
    int lastOffset = 0;
    do {
      if (++nextDoc == _offsets2.cardinality())
	lastOffset = (int)_positionsFile.length();
      else if (_offsets2.at(nextDoc) > offsetLimit)
	lastOffset = _offsets2.at(nextDoc);
    }
    while (lastOffset == 0);
    
    if (lastOffset > offsetLimit) {
      upTo = _offsets2.at(nextDoc - 1);
      _maxDocNumberInCache = nextDoc - 2;
    }
    else {
      upTo = lastOffset;
      _maxDocNumberInCache = nextDoc - 1;
    }

    if (_maxDocNumberInCache < docNo) {
      // cache too small for current microindex
      _positionsCacheSize = lastOffset - _currentBatchOffset;
      System.out.println("expanding cache to " + _positionsCacheSize);
      _positions = new byte[_positionsCacheSize];
      readMicroindexes(docNo);
      return;
    }

    _positionsFile.seek(_currentBatchOffset);
    _positionsFile.read(_positions, 0, upTo - _currentBatchOffset);
  }

  public void reset() {
    _maxDocNumberInCache = _allInCache ? _offsets2.cardinality() - 1 : -1;
  }

  public byte[] getPositions(int docNo) throws java.io.IOException {
    if (docNo > _maxDocNumberInCache)
      readMicroindexes(docNo);
    return _positions;
  }

  public int getDocumentIndex(int docNo) {
    return _offsets2.at(docNo) - _currentBatchOffset;
  }
  
  public void close() throws java.io.IOException {
    _positionsFile.close();
  }

  public int fetch(String conceptName) throws Exception {
    return _tmap.fetch(conceptName);
  }
  
  public String fetch(int conceptID) throws Exception {
    return _tmap.fetch(conceptID);
  }
  
  public String hitToString(QueryHit hit) throws Exception {
    StringBuffer result = new StringBuffer();
    result.append(hit.getScore());
    result.append(" ");
    result.append(fetch(_documents.at(hit.getDocument())));
    if (false) {
      result.append(" ");
      result.append(fetch(_titles.at(hit.getDocument())));
    }
    result.append(" [");
    result.append(hit.getBegin());
    result.append(", ");
    result.append(hit.getEnd());
    result.append("], {");
    int[] concepts = hit.getArray();
    for (int i = 0; i < concepts.length; i++) {
      if (concepts[i] > 0)
	result.append(fetch(concepts[i]));
      else
	result.append("--");
      if (i < concepts.length - 1)
	result.append(", ");
    }
    result.append("}");
    return result.toString();
  }
  
  public boolean occursInText(int concept) {
    return _concepts.binarySearch(concept) >= 0;
  }

  public NonnegativeIntegerGenerator getDocumentIterator(int concept) {
    int index = _concepts.binarySearch(concept);
    if (index >= 0)
      return new ConceptList(_allLists, _offsets.at(index));
    else
      return null;
  }
  
  public NonnegativeIntegerGenerator getChildIterator(int concept) {
    int index = _concepts3.binarySearch(concept);
    if (index >= 0)
      return new ConceptList(_allChildren, _offsets3.at(index));
    else
      return null;
  }
  
  public void getChildren(int concept, IntegerArray array) throws Exception {
    int index = _concepts3.binarySearch(concept);
    if (index >= 0) {
      int where = _offsets3.at(index);
      _compr.initReading(_allChildren, where + 1);
      _compr.ascDecode(_allChildren[where], array);
    }
  }
  
  public int getConceptLength(int concept) throws Exception {
    return _tmap.fetch(concept).length();
  }

  private void readChildrenData() throws Exception {
    try {
      InputStream in = getInputStream("CHILDREN.TAB");
      int k1 = in.read();
      _concepts3 = new IntegerArray(4096);
      StreamDecompressor sddocs = new StreamDecompressor(in);
      sddocs.ascDecode(k1, _concepts3);
      int k2 = in.read();
      _offsets3 = new IntegerArray(_concepts3.cardinality() + 1);
      _offsets3.add(0);
      StreamDecompressor sdoffsets = new StreamDecompressor(in);
      sdoffsets.ascDecode(k2, _offsets3);
      in.close();
      _allChildren = readByteArray("CHILDREN");
    } catch (FileNotFoundException e2) {
      _concepts3 = new IntegerArray(1);
    } catch (IOException e2) {
      _concepts3 = new IntegerArray(1);
    }
  }

  private void readFromDB() throws Exception {
    Schema schema = new Schema(this, false);
    BtreeDictParameters params = new BtreeDictParameters(schema, "DICTIONARY");
    params.readState();
    _tmap = new BtreeDict(params);

    readChildrenData();

    InputStream in = getInputStream("DOCS.TAB");
    int k1 = in.read();
    _concepts = new IntegerArray(4096);
    StreamDecompressor sddocs = new StreamDecompressor(in);
    sddocs.ascDecode(k1, _concepts);
    int k2 = in.read();
    _offsets = new IntegerArray(_concepts.cardinality() + 1);
    _offsets.add(0);
    StreamDecompressor sdoffsets = new StreamDecompressor(in);
    sdoffsets.ascDecode(k2, _offsets);     
    in.close();
    // Read the Lists data
    _allLists = readByteArray("DOCS");
    // Read the positions offset data
    in = getInputStream("OFFSETS");
    k1 = in.read();
    _documents = new IntegerArray(4096);
    sddocs = new StreamDecompressor(in);
    sddocs.ascDecode(k1, _documents);
    k2 = in.read();
    _offsets2 = new IntegerArray(_documents.cardinality() + 1);
    sdoffsets = new StreamDecompressor(in);
    sdoffsets.ascDecode(k2, _offsets2);
    // decompress _titles' ids table
    int k3 = in.read();
    _titles = new IntegerArray(_documents.cardinality());
    StreamDecompressor sdtitles = new StreamDecompressor(in);
    sdtitles.decode(k3, _titles);
    in.close();

    // Read in the Positions data
    _positionsFile = getRAF("POSITIONS", false);
    if (_positionsFile.length() <= _positionsCacheSize) {
      _allInCache = true;
      reset();
      _positionsFile.read(_positions);
      System.out.println("POS fits in cache");
    }
  }
  /**
   * For printf debugging.
   */
  private static boolean debugFlag = false;
  private static void debug(String str) {
    if( debugFlag ) {
      System.out.println("SearchEnvironment: " + str);
    }
  }
}
