/*************************************************************************
 *
 *  $RCSfile: namechai.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/03/08 14:45:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef ARY_CPP_NAMECHAI_HXX
#define ARY_CPP_NAMECHAI_HXX


// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS


namespace ary
{
namespace cpp
{
	class DisplayGate;

namespace ut
{
	class List_TplParameter;

class NameSegment
{
  public:
						NameSegment(
							const char *		i_sName );
	/** @precond MPT pTemplate.
		This cannot be used, except of inserting a new element
		in the segment list of ary::cpp::ut::NameChain. In that
		case, the template parameter list doe snot yet exist.
	*/
						NameSegment(
							const NameSegment &	i_rSeg );
						~NameSegment();

	// OPERATIONS
	List_TplParameter & AddTemplate();

	// INQUIRY
	const udmstri &		Name() const;

		/// @return as strcmp().
	intt			   	Compare(
							const NameSegment &	i_rOther ) const;
	void				Get_Text_AsScope(
							StreamStr &         o_rOut,
						    const ary::cpp::DisplayGate &
												i_rGate ) const;
	void				Get_Text_AsMainType(
						    StreamStr &         o_rName,
						    StreamStr &         o_rPostName,
						    const ary::cpp::DisplayGate &
												i_rGate ) const;
  private:
	udmstri				sName;
	Dyn<List_TplParameter>
						pTemplate;
};

class NameChain
{
  public:
    typedef std::vector<NameSegment>::const_iterator
            const_iterator;

						NameChain();
						~NameChain();

	// OPERATIONS
	void                Add_Segment(
							const char *	    i_sSeg );
	/** @precond  aSegments.size() > 0.
		Which means: Add_Segment() has to be called at least once before.
	*/
	List_TplParameter & Templatize_LastSegment();

	// INQUIRY
    const_iterator      begin() const          { return aSegments.begin(); }
    const_iterator      end() const            { return aSegments.end(); }

	///	@return like strcmp.
	intt				Compare(
							const NameChain &	i_rChain ) const;
	/// @ATTENTION Return value is volatile. Not reentrance enabled.
	const udmstri &		LastSegment() const;

	void				Get_Text(
							StreamStr &         o_rPreName,
						    StreamStr &         o_rName,
						    StreamStr &         o_rPostName,
						    const ary::cpp::DisplayGate &
												i_rGate ) const;
  private:
	std::vector< NameSegment >
						aSegments;
};


// IMPLEMENTATION
inline const udmstri &
NameSegment::Name() const
	{ return sName; }



}   // namespace ut
}   // namespace cpp
}   // namespace ary



#endif

