/*************************************************************************
 *
 *  $RCSfile: cntmbitm.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2003/04/17 16:53:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTMBITM_HXX
#define _CNTMBITM_HXX 1


#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

class SvStream;
class INetCoreNewsMessage;

namespace chaos {

class CntStorageNode;

/*=======================================================================
 *
 * CntMessageBodyItem Interface.
 *
 *=====================================================================*/
#define CNT_MESSAGEBODY_NONE      ((USHORT)0)
#define CNT_MESSAGEBODY_NEWS      ((USHORT)1)
#define CNT_MESSAGEBODY_NEWS_DATA ((USHORT)2)

class CntMessageBodyItemImp;

class CntMessageBodyItem : public SfxPoolItem {
private:
	CntMessageBodyItemImp *pImp;

	// Not implemented.
	CntMessageBodyItem& operator= (const CntMessageBodyItem& rItem);

	virtual SfxPoolItem* Create (SvStream& rStrm, USHORT nVersion) const;
	virtual SvStream&    Store (SvStream& rStrm, USHORT nVersion) const;

public:
	TYPEINFO();
	CntMessageBodyItem (void);
	CntMessageBodyItem (USHORT nWhich, const String& rURL);
	CntMessageBodyItem (const CntMessageBodyItem& rItem);
	virtual ~CntMessageBodyItem (void);

	virtual int operator== (const SfxPoolItem& rItem) const;

	virtual SfxPoolItem* Clone (SfxItemPool *pPool = NULL) const;

	USHORT               GetType (void) const;

	INetCoreNewsMessage* Get (void) const;
	BOOL Set (INetCoreNewsMessage *pMsg);

	static SvStream& LoadMessage (
		SvStream& rStrm, INetCoreNewsMessage& rMsg);
	static SvStream& StoreMessage (
		SvStream& rStrm, INetCoreNewsMessage& rMsg);

	virtual	BOOL PutValue   (const com::sun::star::uno::Any& rVal,
						     BYTE nMemberId = 0);
	virtual	BOOL QueryValue (com::sun::star::uno::Any& rVal,
							 BYTE nMemberId = 0) const;
};

}

#endif /* !_CNTMBITM_HXX */

