/*************************************************************************
 *
 *  $RCSfile: tablecontainer.cxx,v $
 *
 *  $Revision: 1.55.124.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 16:38:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBA_CORE_TABLECONTAINER_HXX_
#include "tablecontainer.hxx"
#endif
#ifndef DBACCESS_SHARED_DBASTRINGS_HRC
#include "dbastrings.hrc"
#endif
#ifndef _DBA_CORE_TABLE_HXX_
#include "table.hxx"
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _COMPHELPER_ENUMHELPER_HXX_
#include <comphelper/enumhelper.hxx>
#endif
#ifndef _DBA_CORE_RESOURCE_HXX_
#include "core_resource.hxx"
#endif
#ifndef _DBA_CORE_RESOURCE_HRC_
#include "core_resource.hrc"
#endif
#ifndef _COM_SUN_STAR_UTIL_XFLUSHABLE_HPP_
#include <com/sun/star/util/XFlushable.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XCONNECTION_HPP_
#include <com/sun/star/sdbc/XConnection.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XDATABASEMETADATA_HPP_
#include <com/sun/star/sdbc/XDatabaseMetaData.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBCX_XCOLUMNSSUPPLIER_HPP_
#include <com/sun/star/sdbcx/XColumnsSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBCX_XTABLESSUPPLIER_HPP_
#include <com/sun/star/sdbcx/XTablesSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_KEYRULE_HPP_
#include <com/sun/star/sdbc/KeyRule.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBCX_KEYTYPE_HPP_
#include <com/sun/star/sdbcx/KeyType.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_COLUMNVALUE_HPP_
#include <com/sun/star/sdbc/ColumnValue.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XROW_HPP_
#include <com/sun/star/sdbc/XRow.hpp>
#endif
#ifndef _COMPHELPER_TYPES_HXX_
#include <comphelper/types.hxx>
#endif
#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include <connectivity/dbtools.hxx>
#endif
#ifndef _COMPHELPER_EXTRACT_HXX_
#include <comphelper/extract.hxx>
#endif
#ifndef _DBHELPER_DBEXCEPTION_HXX_
#include <connectivity/dbexception.hxx>
#endif
#ifndef _DBA_CORE_TABLEDECORATOR_HXX_
#include "TableDeco.hxx"
#endif
#ifndef DBACORE_SDBCORETOOLS_HXX
#include "sdbcoretools.hxx"
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

using namespace dbaccess;
using namespace dbtools;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::sdb;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::util;
using namespace ::osl;
using namespace ::comphelper;
using namespace ::cppu;
using namespace ::connectivity::sdbcx;
using namespace ::utl;

//==========================================================================
//= OTableContainer
//==========================================================================
DBG_NAME(OTableContainer)
//------------------------------------------------------------------------------
OTableContainer::OTableContainer(const OConfigurationNode& _rTablesConfig,
								 const OConfigurationTreeRoot& _rCommitLocation,
								 ::cppu::OWeakObject& _rParent, 
								 ::osl::Mutex& _rMutex,
								 const Reference< XConnection >& _xCon,
								 sal_Bool _bCase,
								 IRefreshListener*	_pRefreshListener,
								 IWarningsContainer* _pWarningsContainer)
	:OFilteredContainer(_rParent,_rMutex,_xCon,_bCase,_pRefreshListener,_pWarningsContainer)
	,m_aCommitLocation(_rCommitLocation)
	,m_aTablesConfig(_rTablesConfig)
	,m_bInAppend(sal_False)
	,m_bInDrop(sal_False)
{					  
	DBG_CTOR(OTableContainer, NULL);
	m_aTablesConfig.setEscape(m_aTablesConfig.isSetNode());
}

//------------------------------------------------------------------------------
OTableContainer::~OTableContainer()
{
	//	dispose();
	DBG_DTOR(OTableContainer, NULL);
}

// -----------------------------------------------------------------------------
void OTableContainer::removeMasterContainerListener()
{
	Reference<XContainer> xCont(m_xMasterContainer,UNO_QUERY);
	if(xCont.is())
		xCont->removeContainerListener(this);
}
// -----------------------------------------------------------------------------
void SAL_CALL OTableContainer::flush(  ) throw(RuntimeException)
{
	for (ObjectIter i = m_aNameMap.begin(); i != m_aNameMap.end(); ++i)
	{
		if((*i).second.is())
		{
			Reference< ::com::sun::star::util::XFlushable > xFlush((*i).second, UNO_QUERY);
			if(xFlush.is())
				xFlush->flush();
		}
	}

}
// XServiceInfo
//------------------------------------------------------------------------------
IMPLEMENT_SERVICE_INFO2(OTableContainer, "com.sun.star.sdb.dbaccess.OTableContainer", SERVICE_SDBCX_CONTAINER, SERVICE_SDBCX_TABLES)
// -------------------------------------------------------------------------
sal_Bool OTableContainer::isNameValid(	const ::rtl::OUString& _rName,
										const Sequence< ::rtl::OUString >& _rTableFilter,
										const Sequence< ::rtl::OUString >& _rTableTypeFilter,
										const ::std::vector< WildCard >& _rWCSearch) const
{
	if ( OFilteredContainer::isNameValid(_rName,_rTableFilter,_rTableTypeFilter,_rWCSearch) )
	{// the table name is allowed (not filtered out)
		// no type filter
		if(!_rTableTypeFilter.getLength())
			return sal_True;

		// this is expensive but there is no other way to get the type of the table
		Reference<XPropertySet> xTable;
		::cppu::extractInterface(xTable,m_xMasterContainer->getByName(_rName));
		::rtl::OUString aTypeName;
		xTable->getPropertyValue(PROPERTY_TYPE) >>= aTypeName;
		const ::rtl::OUString* pTypeBegin	= _rTableTypeFilter.getConstArray();
		const ::rtl::OUString* pTypeEnd		= pTypeBegin + _rTableTypeFilter.getLength();
		for(;pTypeBegin != pTypeEnd;++pTypeBegin)
		{
			if(*pTypeBegin == aTypeName)
				return sal_True; // same as break and then checking
		}
	}
	return sal_False;
}
// -------------------------------------------------------------------------
Reference< XNamed > OTableContainer::createObject(const ::rtl::OUString& _rName)
{
	Reference<XPropertySet> xProp;
	if(m_xMasterContainer.is() && m_xMasterContainer->hasByName(_rName))
		m_xMasterContainer->getByName(_rName) >>= xProp;
	Reference<XColumnsSupplier > xSup(xProp,UNO_QUERY);

	OConfigurationNode aTableConfig;
	if(m_aTablesConfig.isValid())
	{
		if(m_aTablesConfig.hasByName(_rName))
			aTableConfig = m_aTablesConfig.openNode(_rName);
		else
		{
			aTableConfig = m_aTablesConfig.createNode(_rName);
			m_aCommitLocation.commit();
		}
	}

	if(xProp.is())
		return new ODBTableDecorator( aTableConfig, m_xMetaData, xSup, getDataSourceNumberFormats( m_xConnection ) );
	else
	{
		::rtl::OUString sCatalog,sSchema,sTable;
		::dbtools::qualifiedNameComponents(m_xMetaData,
											_rName,
											sCatalog, 
											sSchema, 
											sTable,
											::dbtools::eInDataManipulation);
		Any aCatalog;
		if(sCatalog.getLength())
			aCatalog <<= sCatalog;
		::rtl::OUString sType,sDescription;
		Sequence< ::rtl::OUString> aTypeFilter(3);
		static const ::rtl::OUString sAll = ::rtl::OUString::createFromAscii("%");
		static const ::rtl::OUString s_sTableTypeView(RTL_CONSTASCII_USTRINGPARAM("VIEW"));
		static const ::rtl::OUString s_sTableTypeTable(RTL_CONSTASCII_USTRINGPARAM("TABLE"));
		aTypeFilter[0] = s_sTableTypeView;
		aTypeFilter[1] = s_sTableTypeTable;
		aTypeFilter[2] = sAll;	// just to be sure to include anything else ....

		Reference< XResultSet > xRes = m_xMetaData.is() ? m_xMetaData->getTables(aCatalog,sSchema,sTable,aTypeFilter) : Reference< XResultSet >();
		if(xRes.is() && xRes->next())
		{
			Reference< XRow > xRow(xRes,UNO_QUERY);
			if(xRow.is())
			{
				sType			= xRow->getString(4);
				sDescription	= xRow->getString(5);
			}
		}
		::comphelper::disposeComponent(xRes);
		return new ODBTable(this,aTableConfig,
							m_xConnection,
							sCatalog,
							sSchema,
							sTable,
							sType,
							sDescription);
	}
}
// -----------------------------------------------------------------------------
Reference< XPropertySet > OTableContainer::createEmptyObject()
{
	Reference< XPropertySet > xRet;
	// frist we have to look if the master tables does support this
	// and if then create a table object as well with the master tables
	Reference<XColumnsSupplier > xMasterColumnsSup;
	Reference<XDataDescriptorFactory> xDataFactory(m_xMasterContainer,UNO_QUERY);
	if(xDataFactory.is())
	{
		xMasterColumnsSup = Reference< XColumnsSupplier >( xDataFactory->createDataDescriptor(), UNO_QUERY );
		xRet = new ODBTableDecorator( m_xMetaData, xMasterColumnsSup, getDataSourceNumberFormats( m_xConnection ) );
	}
	else
		xRet = new ODBTable(this, m_xConnection );
	return xRet;
}
// -----------------------------------------------------------------------------
// XAppend
void OTableContainer::appendObject( const Reference< XPropertySet >& descriptor )
{
	// append the new table with a create stmt
	::rtl::OUString aName = getString(descriptor->getPropertyValue(PROPERTY_NAME));
	if(m_xMasterContainer.is() && m_xMasterContainer->hasByName(aName))
	{
		String sMessage(DBACORE_RESSTRING(RID_STR_TABLE_IS_FILTERED));
		sMessage.SearchAndReplaceAscii("$name$", aName);
		throw SQLException(sMessage,*this,SQLSTATE_GENERAL,1000,Any());
	}

	m_bInAppend = sal_True;
	try
	{
		Reference<XAppend> xAppend(m_xMasterContainer,UNO_QUERY);
		if(xAppend.is())
		{
			xAppend->appendByDescriptor(descriptor);
		}
		else
		{
			::rtl::OUString aSql = ::dbtools::createSqlCreateTableStatement(descriptor,m_xConnection);

			OSL_ENSURE(m_xConnection.is(),"Connection is null!");
			Reference< XStatement > xStmt = m_xConnection->createStatement(  );
			if ( xStmt.is() )
				xStmt->execute(aSql);
			::comphelper::disposeComponent(xStmt);
		}
		// create a new config entry
		if(m_aTablesConfig.isValid())
		{
			::rtl::OUString sCatalog,sSchema,sTable,sComposedName;
			descriptor->getPropertyValue(PROPERTY_CATALOGNAME)	>>= sCatalog;
			descriptor->getPropertyValue(PROPERTY_SCHEMANAME)	>>= sSchema;
			descriptor->getPropertyValue(PROPERTY_NAME)			>>= sTable;

			::dbtools::composeTableName(m_xMetaData,sCatalog,sSchema,sTable,sComposedName,sal_False,::dbtools::eInDataManipulation);

			OConfigurationNode aTableConfig;
			if(m_aTablesConfig.hasByName(sComposedName))
				aTableConfig = m_aTablesConfig.openNode(sComposedName);
			else
			{
				aTableConfig = m_aTablesConfig.createNode(sComposedName);
				m_aCommitLocation.commit();
			}
			Reference<XUnoTunnel> xTunnel(descriptor,UNO_QUERY);
			if(xTunnel.is())
			{
				ODBTableDecorator* pDecoTable = (ODBTableDecorator*)xTunnel->getSomething(ODBTableDecorator::getUnoTunnelImplementationId());
				if(pDecoTable)
				{
					pDecoTable->setContext( aTableConfig.cloneAsRoot(), getDataSourceNumberFormats( m_xConnection ) );
				}
				else
				{
					ODBTable* pTable = (ODBTable*)xTunnel->getSomething(ODBTable::getUnoTunnelImplementationId());
					if ( pTable )
						pTable->setConfigurationNode( aTableConfig.cloneAsRoot() );
				}
			}
			// we must the table here because otherwise the ui information are lost
			Reference<XFlushable> xFlush(descriptor,UNO_QUERY);
			if(xFlush.is())
				xFlush->flush();
		}
	}
	catch(Exception&)
	{
		m_bInAppend = sal_False;
		throw;
	}
	m_bInAppend = sal_False;
}
// -------------------------------------------------------------------------
// XDrop
void OTableContainer::dropObject(sal_Int32 _nPos,const ::rtl::OUString _sElementName)
{
	m_bInDrop = sal_True;
	try
	{
		Reference< XDrop > xDrop(m_xMasterContainer,UNO_QUERY);
		if(xDrop.is())
			xDrop->dropByName(_sElementName);
		else
		{
			ObjectIter aIter = m_aElements[_nPos];
			if(!aIter->second.is()) // we want to drop a object which isn't loaded yet so we must load it
				aIter->second = createObject(_sElementName);
			::rtl::OUString sCatalog,sSchema,sTable,sComposedName;

			sal_Bool bIsView = sal_False;
			Reference<XPropertySet> xTable(aIter->second.get(),UNO_QUERY);
			if(xTable.is())
			{
				if( m_xMetaData.is() && m_xMetaData->supportsCatalogsInTableDefinitions() )
					xTable->getPropertyValue(PROPERTY_CATALOGNAME)	>>= sCatalog;
				if( m_xMetaData.is() && m_xMetaData->supportsSchemasInTableDefinitions() )
					xTable->getPropertyValue(PROPERTY_SCHEMANAME)	>>= sSchema;
				xTable->getPropertyValue(PROPERTY_NAME)			>>= sTable;

				::dbtools::composeTableName(m_xMetaData,sCatalog,sSchema,sTable,sComposedName,sal_True,::dbtools::eInTableDefinitions);

				::rtl::OUString sType;
				xTable->getPropertyValue(PROPERTY_TYPE)			>>= sType;
				bIsView = sType.equalsIgnoreAsciiCase(::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("VIEW")));
			}

			if(!sComposedName.getLength())
				::dbtools::throwFunctionSequenceException(*this);

			::rtl::OUString aSql = ::rtl::OUString::createFromAscii("DROP ");
			
			// #104282# OJ
			if ( bIsView ) // here we have a view
				aSql += ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("VIEW "));
			else
				aSql += ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("TABLE "));
			aSql += sComposedName;
			Reference< XStatement > xStmt = m_xConnection->createStatement(  );
			if(xStmt.is())
				xStmt->execute(aSql);
			::comphelper::disposeComponent(xStmt);

		}
		// we don't need to call dropByName when we have xMasterTables
		// now we have to delete the config entry
		if ( m_aTablesConfig.isValid() )
		{
			if ( m_aTablesConfig.hasByName(_sElementName) )
				m_aTablesConfig.removeNode(_sElementName);
		}
	}
	catch(Exception&)
	{
		m_bInDrop = sal_False;
		throw;
	}
	m_bInDrop = sal_False;
}
// -----------------------------------------------------------------------------
void SAL_CALL OTableContainer::elementInserted( const ContainerEvent& Event ) throw (RuntimeException)
{
	::osl::MutexGuard aGuard(m_rMutex);
	::rtl::OUString sName;
	if(!m_bInAppend && (Event.Accessor >>= sName) && !hasByName(sName))
	{
		if(!m_xMasterContainer.is() || m_xMasterContainer->hasByName(sName))
		{
			Reference<XNamed> xName = createObject(sName);
			insertElement(sName,xName);
			// and notify our listeners
			ContainerEvent aEvent(static_cast<XContainer*>(this), makeAny(sName), makeAny(xName), Any());
			OInterfaceIteratorHelper aListenerLoop(m_aContainerListeners);
			while (aListenerLoop.hasMoreElements())
				static_cast<XContainerListener*>(aListenerLoop.next())->elementInserted(aEvent);
		}
	}
}
// -----------------------------------------------------------------------------
void SAL_CALL OTableContainer::elementRemoved( const ContainerEvent& Event ) throw (RuntimeException)
{
	//	::osl::MutexGuard aGuard(m_rMutex);
	//	::rtl::OUString sName;
//	if( !m_bInDrop && m_xMasterContainer.is() && (Event.Accessor >>= sName) && hasByName(sName))
//	{
//		if( || !m_xMasterContainer->hasByName(sName))
//			;
//	}
}
// -----------------------------------------------------------------------------
void SAL_CALL OTableContainer::elementReplaced( const ContainerEvent& Event ) throw (RuntimeException)
{
	// create a new config entry
	if(m_aTablesConfig.isValid())
	{
		::rtl::OUString sOldComposedName,sNewComposedName;
		Reference<XPropertySet> xObject;
		Event.ReplacedElement	>>= sOldComposedName;
		Event.Accessor			>>= sNewComposedName;
		Event.Element			>>= xObject;
		
		if(m_aTablesConfig.hasByName(sOldComposedName))
			m_aTablesConfig.removeNode(sOldComposedName);
		
		OSL_ENSURE(!m_aTablesConfig.hasByName(sNewComposedName),"TableName already exists!");
		OConfigurationNode aTableConfig;
		if(m_aTablesConfig.hasByName(sNewComposedName))
			aTableConfig = m_aTablesConfig.openNode(sNewComposedName);
		else
			aTableConfig = m_aTablesConfig.createNode(sNewComposedName);
		m_aCommitLocation.commit();
		renameObject(sOldComposedName,sNewComposedName);
		if(hasByName(sNewComposedName))
		{
			Reference<XUnoTunnel> xTunnel;
			getByName(sNewComposedName) >>= xTunnel;
			if(xTunnel.is())
			{
				ODBTableDecorator* pDecoTable = (ODBTableDecorator*)xTunnel->getSomething(ODBTableDecorator::getUnoTunnelImplementationId());
				if(pDecoTable)
				{
					pDecoTable->setContext( aTableConfig.cloneAsRoot(), getDataSourceNumberFormats( m_xConnection ) );
				}
				else
				{
					ODBTable* pTable = (ODBTable*)xTunnel->getSomething(ODBTable::getUnoTunnelImplementationId());
					if ( pTable )
						pTable->setConfigurationNode( aTableConfig.cloneAsRoot() );
				}
			}
		}
	}
}
// -----------------------------------------------------------------------------
void SAL_CALL OTableContainer::disposing( const ::com::sun::star::lang::EventObject& Source ) throw (::com::sun::star::uno::RuntimeException)
{
}
// -----------------------------------------------------------------------------
void OTableContainer::setNewConfigNode(const ::utl::OConfigurationTreeRoot& _aConfigTreeNode)
{
	m_aCommitLocation	= _aConfigTreeNode;
	m_aTablesConfig		= _aConfigTreeNode.openNode(CONFIGKEY_DBLINK_TABLES);
	m_aTablesConfig.setEscape(m_aTablesConfig.isSetNode());
	// now set the new config node at our children
	::std::vector< ObjectIter >::iterator aIter = m_aElements.begin();
	for(;aIter != m_aElements.end();++aIter)
	{
		if((*aIter)->second.is())
		{
			Reference< XUnoTunnel > xTunnel((*aIter)->second, UNO_QUERY);
			ODBTableDecorator* pObjectImpl = NULL;
			if (xTunnel.is())
			{
				static Sequence<sal_Int8> aTunnelId = ODBTableDecorator::getUnoTunnelImplementationId();
				pObjectImpl = reinterpret_cast< ODBTableDecorator* >( xTunnel->getSomething( aTunnelId ) );
			}
			if(pObjectImpl)
			{
				OConfigurationNode aTableConfig;
				if(m_aTablesConfig.hasByName((*aIter)->first))
					aTableConfig = m_aTablesConfig.openNode((*aIter)->first);
				else
				{
					aTableConfig = m_aTablesConfig.createNode((*aIter)->first);
					m_aCommitLocation.commit();
				}
				pObjectImpl->setContext( aTableConfig.cloneAsRoot(), getDataSourceNumberFormats( m_xConnection ) );
			}
		}
	}
}
// -----------------------------------------------------------------------------

Sequence< ::rtl::OUString > OTableContainer::getTableTypeFilter(const Sequence< ::rtl::OUString >& _rTableTypeFilter) const
{
	static const ::rtl::OUString sAll = ::rtl::OUString::createFromAscii("%");
	Sequence< ::rtl::OUString > sTableTypes;
	if(_rTableTypeFilter.getLength() == 0)
	{
		// we want all catalogues, all schemas, all tables
		sTableTypes.realloc(3);
	
		static const ::rtl::OUString s_sTableTypeView(RTL_CONSTASCII_USTRINGPARAM("VIEW"));
		static const ::rtl::OUString s_sTableTypeTable(RTL_CONSTASCII_USTRINGPARAM("TABLE"));
		sTableTypes[0] = s_sTableTypeView;
		sTableTypes[1] = s_sTableTypeTable;
		sTableTypes[2] = sAll;	// just to be sure to include anything else ....
	}
	else
		sTableTypes = _rTableTypeFilter;
	return sTableTypes;
}
// -----------------------------------------------------------------------------
void OTableContainer::addMasterContainerListener()
{
	// we have to listen at the mastertables because it could happen that another inserts new tables
	Reference<XContainer> xCont(m_xMasterContainer,UNO_QUERY);
	if(xCont.is())
		xCont->addContainerListener(this);
}
// -----------------------------------------------------------------------------
