/*************************************************************************
 *
 *  $RCSfile: commandbase.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: fs $ $Date: 2001/08/30 08:01:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBA_CORE_COMMANDBASE_HXX_
#include "commandbase.hxx"
#endif
#ifndef _DBASHARED_APITOOLS_HXX_
#include "apitools.hxx"
#endif
#ifndef DBACCESS_SHARED_DBASTRINGS_HRC
#include "dbastrings.hrc"
#endif
#ifndef _UNOTOOLS_CONFIGNODE_HXX_
#include <unotools/confignode.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

//........................................................................
namespace dbaccess
{
//........................................................................

using namespace ::com::sun::star::uno;
using namespace ::utl;

//==========================================================================
//= OCommandBase
//==========================================================================
//--------------------------------------------------------------------------
void OCommandBase::storeTo(const OConfigurationNode& _rConfigLocation)
{
	DBG_ASSERT(_rConfigLocation.isValid(), "OCommandBase::storeTo : no empty locations allowed here !");

	_rConfigLocation.setNodeValue(CONFIGKEY_QRYDESCR_COMMAND,				makeAny(m_sCommand));
	_rConfigLocation.setNodeValue(CONFIGKEY_QRYDESCR_USE_ESCAPE_PROCESSING, makeAny(m_bEscapeProcessing));
	_rConfigLocation.setNodeValue(CONFIGKEY_QRYDESCR_UPDATE_TABLENAME,		makeAny(m_sUpdateTableName));
	_rConfigLocation.setNodeValue(CONFIGKEY_QRYDESCR_UPDATE_SCHEMANAME,		makeAny(m_sUpdateSchemaName));
	_rConfigLocation.setNodeValue(CONFIGKEY_QRYDESCR_UPDATE_CATALOGNAME,	makeAny(m_sUpdateCatalogName));
	_rConfigLocation.setNodeValue(CONFIGKEY_LAYOUTINFORMATION,				makeAny(m_aLayoutInformation));
}

//--------------------------------------------------------------------------
void OCommandBase::loadFrom(const OConfigurationNode& _rConfigLocation)
{
	DBG_ASSERT(_rConfigLocation.isValid(), "OCommandBase::loadFrom: no empty locations allowed here !");

	_rConfigLocation.getNodeValue(CONFIGKEY_QRYDESCR_COMMAND)				>>= m_sCommand;
	_rConfigLocation.getNodeValue(CONFIGKEY_QRYDESCR_USE_ESCAPE_PROCESSING) >>= m_bEscapeProcessing;
	_rConfigLocation.getNodeValue(CONFIGKEY_QRYDESCR_UPDATE_TABLENAME)		>>= m_sUpdateTableName;
	_rConfigLocation.getNodeValue(CONFIGKEY_QRYDESCR_UPDATE_SCHEMANAME)		>>= m_sUpdateSchemaName;
	_rConfigLocation.getNodeValue(CONFIGKEY_QRYDESCR_UPDATE_CATALOGNAME)	>>= m_sUpdateCatalogName;
	_rConfigLocation.getNodeValue(CONFIGKEY_LAYOUTINFORMATION)				>>= m_aLayoutInformation;
}

//........................................................................
}	// namespace dbaccess
//........................................................................


