/*************************************************************************
 *
 *  $RCSfile: commonpages.cxx,v $
 *
 *  $Revision: 1.50 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/02 15:24:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBAUI_COMMONPAGES_HXX_
#include "commonpages.hxx"
#endif

#ifndef _COM_SUN_STAR_SDB_XQUERIESSUPPLIER_HPP_
#include <com/sun/star/sdb/XQueriesSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HPP_ 
#include <com/sun/star/frame/XComponentLoader.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_SQLCONTEXT_HPP_
#include <com/sun/star/sdb/SQLContext.hpp>
#endif
#include <com/sun/star/sdb/CommandType.hpp>
#ifndef _COM_SUN_STAR_UTIL_XFLUSHABLE_HPP_ 
#include <com/sun/star/util/XFlushable.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_XQUERYDEFINITIONSSUPPLIER_HPP_
#include <com/sun/star/sdb/XQueryDefinitionsSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_XBOOKMARKSSUPPLIER_HPP_
#include <com/sun/star/sdb/XBookmarksSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBCX_XRENAME_HPP_
#include <com/sun/star/sdbcx/XRename.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCONTENTENUMERATIONACCESS_HPP_
#include <com/sun/star/container/XContentEnumerationAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XENUMERATIONACCESS_HPP_
#include <com/sun/star/container/XEnumerationAccess.hpp>
#endif
#ifndef _DBAUI_MODULE_DBU_HXX_
#include "moduledbu.hxx"
#endif
#ifndef _DBU_DLG_HRC_
#include "dbu_dlg.hrc"
#endif
#ifndef _DBAUI_DBADMIN_HRC_
#include "dbadmin.hrc"
#endif
#ifndef _DBAUI_DATASOURCEITEMS_HXX_
#include "dsitems.hxx"
#endif
#ifndef _DBAUI_STRINGLISTITEM_HXX_
#include "stringlistitem.hxx"
#endif
#ifndef _DBAUI_DBADMIN_HXX_
#include "dbadmin.hxx"
#endif
#ifndef _DBAUI_SQLMESSAGE_HXX_
#include "sqlmessage.hxx"
#endif
#ifndef DBACCESS_SHARED_DBUSTRINGS_HRC
#include "dbustrings.hrc"
#endif
#ifndef _SV_WAITOBJ_HXX
#include <vcl/waitobj.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _COMPHELPER_EXTRACT_HXX_
#include <comphelper/extract.hxx>
#endif
#ifndef _SFXITEMSET_HXX 
#include <svtools/itemset.hxx>
#endif
#ifndef _SFXSTRITEM_HXX 
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX 
#include <svtools/eitem.hxx>
#endif
#ifndef _DBAUI_LOCALRESACCESS_HXX_
#include "localresaccess.hxx"
#endif
#ifndef _DBAUI_DOCLINKDIALOG_HXX_
#include "doclinkdialog.hxx"
#endif
#ifndef _DBAUI_FILENOTATION_HXX_
#include "filenotation.hxx"
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _DBHELPER_DBEXCEPTION_HXX_
#include <connectivity/dbexception.hxx>
#endif
#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include <connectivity/dbtools.hxx>
#endif
#ifndef _DBAUI_QUERYDESIGNACCESS_HXX_
#include "querydesignaccess.hxx"
#endif
#ifndef _DBAUI_PROPERTYSETITEM_HXX_
#include "propertysetitem.hxx"
#endif
#ifndef _TOOLKIT_HELPER_VCLUNOHELPER_HXX_ 
#include <toolkit/unohlp.hxx>
#endif
#ifndef _SV_SVAPP_HXX 
#include <vcl/svapp.hxx>
#endif
#ifndef _SFXINTITEM_HXX 
#include <svtools/intitem.hxx>
#endif
#ifndef _DBAUI_LINKEDDOCUMENTS_HXX_
#include "linkeddocuments.hxx"
#endif
#ifndef DBACCESS_UI_BROWSER_ID_HXX
#include "browserids.hxx"
#endif
#ifndef _DBAUI_DATASOURCECONNECTOR_HXX_
#include "datasourceconnector.hxx"
#endif
#ifndef DBAUI_TOOLS_HXX
#include "UITools.hxx"
#endif
#ifndef _DBA_DBACCESS_HELPID_HRC_
#include "dbaccess_helpid.hrc"
#endif
#ifndef _FILEDLGHELPER_HXX
#include <sfx2/filedlghelper.hxx>
#endif
#ifndef _VCL_STDTEXT_HXX 
#include <vcl/stdtext.hxx>
#endif
#ifndef _SV_KEYCODE_HXX
#include <vcl/keycod.hxx>
#endif
#ifndef DBAUI_COMPONENTCLIENTMONITOR_HXX
#include "componentclientmonitor.hxx"
#endif
#ifndef DBAUI_DLGSAVE_HXX
#include "dlgsave.hxx"
#endif
#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#include <svtools/moduleoptions.hxx>
#endif
//.........................................................................
namespace dbaui
{
//.........................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::ucb;
	using namespace ::com::sun::star::sdb;
	using namespace ::com::sun::star::sdbc;
	using namespace ::com::sun::star::sdbcx;
	using namespace ::com::sun::star::beans;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::i18n;
	using namespace ::com::sun::star::util;
	using namespace ::com::sun::star::container;
	using namespace ::com::sun::star::frame;
	using namespace ::dbtools;

	//=========================================================================
	//= helper
	//=========================================================================
	void lcl_removeToolboxItemShortcuts(ToolBox& _rTB)
	{
		String		sItemText;
		sal_uInt16	nItemId;

		const sal_Char* pShortcutText = "~";
		const String	sReplaceText;

		sal_uInt16 nItems = _rTB.GetItemCount();
		for (sal_uInt16 i=0; i<nItems; ++i)
		{
			if (TOOLBOXITEM_BUTTON == _rTB.GetItemType(i))
			{	// it's a button with text
				nItemId = _rTB.GetItemId(i);
				sItemText = _rTB.GetItemText(nItemId);
				// replace the shortcut
				sItemText.SearchAndReplaceAllAscii(pShortcutText, sReplaceText);

				_rTB.SetItemText(nItemId, sItemText);
			}
		}
	}

	//========================================================================
	//= OCollectionPage
	//========================================================================
	//------------------------------------------------------------------------
	OCollectionPage::OCollectionPage( Window* pParent, const ResId& _rId, const SfxItemSet& _rCoreAttrs, sal_uInt16 _nObjectNameResId )
		:OGenericAdministrationPage( pParent, _rId, _rCoreAttrs )
		,OContainerListener(m_aMutex)
		,m_aFrame		(this, ResId(FL_COLLECTION))
		,m_aActions		(this, ResId(TLB_ACTIONS))
		,m_aObjects		(this, ResId(CTL_COLLECTION))
		,m_pListenerAdapter(NULL)
		,m_pAdminDialog(NULL)
		,m_nObjectNameResId(_nObjectNameResId)
		,m_nPageResId(_rId.GetId())
	{
		// no FreeResource!
		// derivee has to take care for this

		m_aActions.SetSelectHdl(LINK(this, OCollectionPage, OnToolboxClicked));
		lcl_removeToolboxItemShortcuts(m_aActions);

		m_aObjects.SetSelectHdl(LINK(this, OCollectionPage, OnSelectObject));
		m_aObjects.SetDoubleClickHdl( LINK( this, OCollectionPage, OnObjectDoubleClicked ) );
		m_aObjects.SetHighlightRange();
		m_aObjects.SetWindowBits(WB_SORT);
		m_aObjects.SetSelectionMode(
#if SUPD < 650
			SINGLE_SELECTION
#else
			MULTIPLE_SELECTION
#endif
			);

		enableToolBoxAcceleration( &m_aActions );
	}

	//------------------------------------------------------------------------
	OCollectionPage::~OCollectionPage()
	{
		setToolBox(NULL);
		if (m_pListenerAdapter)
		{
			m_pListenerAdapter->dispose();
			m_pListenerAdapter->release();
			m_pListenerAdapter = NULL;
		}
	}
	// -----------------------------------------------------------------------------
	void OCollectionPage::StateChanged( StateChangedType nType )
	{
		OGenericAdministrationPage::StateChanged( nType );

		if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
		{
			// Check if we need to get new images for normal/high contrast mode
			checkImageList();
		}
		else if ( nType == STATE_CHANGE_TEXT )
		{
			// The physical toolbar changed its outlook and shows another logical toolbar!
			// We have to set the correct high contrast mode on the new tbx manager.
			//	pMgr->SetHiContrast( IsHiContrastMode() );
			checkImageList();
		}
	}
	// -----------------------------------------------------------------------------
	void OCollectionPage::DataChanged( const DataChangedEvent& rDCEvt )
	{
		OGenericAdministrationPage::DataChanged( rDCEvt );

		if ((( rDCEvt.GetType() == DATACHANGED_SETTINGS	)	||
			( rDCEvt.GetType() == DATACHANGED_DISPLAY	))	&&
			( rDCEvt.GetFlags() & SETTINGS_STYLE		))
		{
			// Check if we need to get new images for normal/high contrast mode
			checkImageList();
		}
	}
	//------------------------------------------------------------------
	void OCollectionPage::resizeControls(const Size& _rDiff)
	{
		if ( _rDiff.Height() )
		{
			Size aOldSize = m_aObjects.GetSizePixel();
			aOldSize.Height() -= _rDiff.Height();
			m_aObjects.SetPosSizePixel(
					m_aObjects.GetPosPixel()+Point(0,_rDiff.Height()),
					aOldSize
					);
		}
	}
	//------------------------------------------------------------------------
	void OCollectionPage::onEntryDoubleClicked( )
	{
	}

	//------------------------------------------------------------------------
	IMPL_LINK( OCollectionPage, OnObjectDoubleClicked, void*, NOTINTERESTEDIN )
	{
		onEntryDoubleClicked( );
		return 0L;
	}

	//------------------------------------------------------------------------
	void OCollectionPage::enableControls(sal_Bool _bEnable)
	{
		m_aFrame.Enable(_bEnable);
		m_aObjects.Enable(_bEnable);
		m_aActions.Enable(_bEnable);
	}

	//------------------------------------------------------------------------
	Image OCollectionPage::getEntryImage() const
	{
		return Image();
	}

	//------------------------------------------------------------------------
	void OCollectionPage::ActivatePage(const SfxItemSet& _rSet)
	{
		// tabs for the tab control
		sal_Int32 nTabs[3];
		nTabs[0] = 2;									// two tabs
		nTabs[1] = 3 * GetSizePixel().Width() / 4;		// width of column 1
		nTabs[2] = GetSizePixel().Width() - nTabs[1];	// width of column 2
		m_aObjects.SetTabs( nTabs, MAP_PIXEL );

		SFX_ITEMSET_GET(_rSet, pIsNew, SfxBoolItem, DSID_NEWDATASOURCE, sal_True);
		if (pIsNew && pIsNew->GetValue())
		{
			DBG_ASSERT(NULL != m_pAdminDialog, "OCollectionPage::ActivatePage: don't have an admin dialog!");
				// needed below to save the changes

			sal_Int32 nResult = RET_NO;
			if (m_pAdminDialog)
			{
				if (!m_pAdminDialog->isApplyable())
				{
					ErrorBox aError(this, ModuleRes(ERR_CANTADMINQUERIES));
	
					String sMessgae = aError.GetMessText();
					sMessgae.SearchAndReplaceAllAscii("$objects$", ModuleRes(m_nObjectNameResId));
					aError.SetMessText(sMessgae);

					aError.Execute();
				}
				else
				{
					WarningBox aWarning(GetParent(), ModuleRes(WARN_SAVEFORQUERIES));
	
					String sMessgae = aWarning.GetMessText();
					sMessgae.SearchAndReplaceAllAscii("$objects$", ModuleRes(m_nObjectNameResId));
					aWarning.SetMessText(sMessgae);

					nResult = aWarning.Execute();
				}
			}
			if (RET_YES != nResult)
			{
				enableControls(sal_False);
				OGenericAdministrationPage::ActivatePage(_rSet);
				return;
			}
			m_pAdminDialog->applyChangesAsync();
			enableControls(sal_False);
			return;
		}

		// just in case ...
		enableControls(sal_True);

		// get the name of the data source
		SFX_ITEMSET_GET(_rSet, pNameItem, SfxStringItem, DSID_NAME, sal_True);
		DBG_ASSERT(pNameItem, "OCollectionPage::ActivatePage: missing the name attribute!");

		m_sDSName = pNameItem->GetValue();

		// clear the queries list box
		m_aObjects.Clear();
		m_xObjects.clear();

		// need a service factory
		if (!m_xORB.is())
		{
			DBG_ERROR("OCollectionPage::ActivatePage: have no service facrory!");
			OGenericAdministrationPage::ActivatePage(_rSet);
			return;
		}

		::osl::MutexGuard aGuard(m_aMutex);

		// get the database context and the object collection
		SFX_ITEMSET_GET(_rSet, pDSItem, OPropertySetItem, DSID_DATASOURCE_UNO, sal_True);
		DBG_ASSERT(pDSItem, "OCollectionPage::ActivatePage: missing the data source item!");

		if (pDSItem)
		{
			try
			{
				DBG_ASSERT(pDSItem->getPropertySet().is(), "OCollectionPage::ActivatePage: missing the data source object!");
				m_xObjects = getObjectCollection(pDSItem->getPropertySet());
			}
			catch(Exception&)
			{
				DBG_ERROR("OCollectionPage::ActivatePage: caught an exception while retrieving the object collection!");
			}
		}


		if (!m_xObjects.is())
		{
			DBG_ERROR("OCollectionPage::ActivatePage: could not retrieve the queries for the data source!");
		}
		else
		{
			// populate the list
			try
			{
				Sequence< ::rtl::OUString > aObjects = m_xObjects->getElementNames();
				const ::rtl::OUString* pObjects = aObjects.getConstArray();
				const ::rtl::OUString* pEnd = pObjects + aObjects.getLength();

				Reference< XPropertySet > xObject;
				for (;pObjects != pEnd; ++pObjects)
					insertEntry(*pObjects);
			}
			catch(Exception& e)
			{
				DBG_ERROR(	::rtl::OString("OCollectionPage::ActivatePage: something went wront while retrieving the query names (message: ")
						+=	::rtl::OString(e.Message.getStr(), e.Message.getLength(), RTL_TEXTENCODING_ASCII_US)
						+=	::rtl::OString(")!"));
			}

			// add the container listener
			if (m_pListenerAdapter)
			{
				m_pListenerAdapter->dispose();
				m_pListenerAdapter->release();
				m_pListenerAdapter = NULL;
			}
			Reference< XContainer > xBroadcaster(m_xObjects, UNO_QUERY);
			if (xBroadcaster.is())
			{
				m_pListenerAdapter = new OContainerListenerAdapter(this, xBroadcaster);
				m_pListenerAdapter->acquire();
			}
		}

		// initially enable or disable the buttons
		updateButtons();

		OGenericAdministrationPage::ActivatePage(_rSet);
	}

	//------------------------------------------------------------------------
	int OCollectionPage::DeactivatePage(SfxItemSet* _pSet)
	{
		if (m_pListenerAdapter)
		{
			m_pListenerAdapter->dispose();
			m_pListenerAdapter->release();
			m_pListenerAdapter = NULL;
		}
		m_xObjects.clear();

		return OGenericAdministrationPage::DeactivatePage(_pSet);
	}

	//------------------------------------------------------------------------
	BOOL OCollectionPage::FillItemSet(SfxItemSet& _rCoreAttrs)
	{
		// we haven't any items transported via this mechanism
		return sal_False;
	}

	//------------------------------------------------------------------------
	void OCollectionPage::implInitControls(const SfxItemSet& _rSet, sal_Bool _bSaveValue)
	{
		// check whether or not the selection is invalid or readonly (invalid implies readonly, but not vice versa)
		sal_Bool bValid, bReadonly;
		getFlags(_rSet, bValid, bReadonly);
	}

	//------------------------------------------------------------------------
	void OCollectionPage::updateButtons()
	{
		// nothing to do here
	}

	//------------------------------------------------------------------------
	void OCollectionPage::insertEntry( const ::rtl::OUString& _rName )
	{
		m_aObjects.SelectAll(FALSE);
		SvLBoxEntry* pEntry = m_aObjects.InsertEntry( _rName );
		m_aObjects.Select(pEntry);
		m_aObjects.SetCursor(pEntry);
	}

	//------------------------------------------------------------------------
	void OCollectionPage::_elementInserted( const ContainerEvent& _rEvent ) throw(RuntimeException)
	{
		::osl::MutexGuard aGuard(m_aMutex);
		// a new query has been created

		::rtl::OUString sObjectName;
		_rEvent.Accessor >>= sObjectName;

		insertEntry(sObjectName);
		updateButtons();
	}

	//------------------------------------------------------------------------
	SvLBoxEntry* OCollectionPage::findEntry( const ::rtl::OUString& _rName )
	{
		String sLookFor = _rName;

		SvLBoxEntry* pLoop = m_aObjects.First();
		while (pLoop)
		{
			if ( getEntryText( pLoop ) == sLookFor)
				return pLoop;
			pLoop = m_aObjects.Next(pLoop);
		}
		return NULL;
	}

	//------------------------------------------------------------------------
	void OCollectionPage::_elementRemoved( const ContainerEvent& _rEvent ) throw(RuntimeException)
	{
		::osl::MutexGuard aGuard(m_aMutex);
		// a bookmark has been removed

		::rtl::OUString sObjectName;
		_rEvent.Accessor >>= sObjectName;

		SvLBoxEntry* pEntry = findEntry(sObjectName);
		if (pEntry)
		{
			m_aObjects.GetModel()->Remove(pEntry);
			updateButtons();
		}
	}

	//------------------------------------------------------------------------
	void OCollectionPage::_elementReplaced( const ContainerEvent& _rEvent ) throw(RuntimeException)
	{
		::osl::MutexGuard aGuard(m_aMutex);
		// a bookmark has been replaced (i.e. the link location has been changed)

		::rtl::OUString sObjectName;
		_rEvent.Accessor >>= sObjectName;

		SvLBoxEntry* pEntry = findEntry(sObjectName);
		if (pEntry)
		{
			::rtl::OUString sNewLocation;
			_rEvent.Element >>= sNewLocation;
			if (sNewLocation.getLength())
			{
				OFileNotation aTransformer(sNewLocation, OFileNotation::N_URL);
				sNewLocation = aTransformer.get(OFileNotation::N_SYSTEM);
			}

			setEntryText( pEntry, 0, sObjectName );
			setEntryText( pEntry, 1, sNewLocation );
		}
	}

	//------------------------------------------------------------------------
	void OCollectionPage::fillViewSettings(OPageSettings* _pSettings)
	{
		// nothing to do, we do not really have view settings, we use them for a delayed toolbox action only
	}

	//------------------------------------------------------------------------
	void OCollectionPage::restoreViewSettings(const OPageSettings* _pSettings)
	{
		const OToolboxedPageViewSettings* pMySettings = static_cast<const OToolboxedPageViewSettings*>(_pSettings);
		if (!pMySettings)
			return;

		if (pMySettings->nDelayedToolboxAction)
			onToolBoxAction(pMySettings->nDelayedToolboxAction);
	}

	//------------------------------------------------------------------------
	void OCollectionPage::onToolBoxAction( sal_uInt16 _nClickedItemId )
	{
		// nothing to do here
	}

	//------------------------------------------------------------------------
	IMPL_LINK(OCollectionPage, OnToolboxClicked, void*, NOTINTERESTEDIN )
	{
		onToolBoxAction(m_aActions.GetCurItemId());
		return 0L;
	}

	//------------------------------------------------------------------------
	IMPL_LINK(OCollectionPage, OnSelectObject, SvTreeListBox*, NOTINTERESTEDIN)
	{
		// update the buttons
		updateButtons();
		return 0L;
	}

	//------------------------------------------------------------------------
	void OCollectionPage::implDeleteSelection(sal_uInt16 _nQueryResourceId)
	{
		// the selected entry
		sal_Bool bAskOnlyFirstTime = sal_True;
		String sQuestionRes = String(ModuleRes(_nQueryResourceId));
		SvLBoxEntry* pSelected = FirstSelected();
		while(pSelected)
		{
			String sSelected = getEntryText( pSelected );
			pSelected = NextSelected(pSelected);
			if (sSelected.Len())
			{
				// let the user confirm this
				if(bAskOnlyFirstTime)
				{
					String sQuestion;
					if(pSelected)
						sQuestion = String(ModuleRes(STR_QUERY_DROP_ALL));					
					else
					{
						sQuestion = sQuestionRes;
						sQuestion.SearchAndReplaceAscii("$name$", sSelected);
					}
				
					QueryBox aAsk(this, WB_YES_NO | WB_DEF_YES, sQuestion);
					aAsk.SetText(String(ModuleRes(STR_TITLE_CONFIRM_DELETION)));

					if (RET_YES != aAsk.Execute())
						// cancelled
						return;
					bAskOnlyFirstTime = sal_False;
				}				
				
				try
				{
					Reference< XNameContainer > xRemoveAccess(m_xObjects, UNO_QUERY);
					if (xRemoveAccess.is())
						xRemoveAccess->removeByName(sSelected);
						// will result in a call to our elementRemove method, which does the view handling
					else
						DBG_ERROR("OCollectionPage::implDeleteSelection: : missing the XNameContainer interface!");
				}
				catch(const Exception&)
				{
					DBG_ERROR("OCollectionPage::implDeleteSelection: : caught an exception while removing the object!");
				}
			}
			
		}
	}

	//------------------------------------------------------------------------
	String OCollectionPage::getSelectedObjectName( ) const
	{
		SvLBoxEntry* pSelected = FirstSelected();
		String sSelected;
		if (pSelected)
			sSelected = getEntryText( pSelected );

		DBG_ASSERT(0 != sSelected.Len(), "OCollectionPage::getSelectedObjectName: invalid selection!");
		return sSelected;
	}

	//========================================================================
	//= OQueryAdministrationPage
	//========================================================================
	//------------------------------------------------------------------------
	OQueryAdministrationPage::OQueryAdministrationPage( Window* pParent, const SfxItemSet& _rCoreAttrs )
		:OCollectionPage( pParent, ModuleRes(PAGE_QUERYADMINISTRATION), _rCoreAttrs, STR_QUERY_OBJECTS )
	{
		FreeResource();

		setToolBox(&m_aActions);

		addToolboxAccelerator( ID_DROP_QUERY, KeyCode( KEY_DELETE ) );
	}

	//------------------------------------------------------------------------
	OQueryAdministrationPage::~OQueryAdministrationPage()
	{
		deleteClientMonitor();
	}

	//------------------------------------------------------------------
	sal_Int16 OQueryAdministrationPage::getImageListId(sal_Int16 _eBitmapSet,sal_Bool _bHiContast) const
	{
		sal_Int16 nN = IMG_QUERYADMINISTRATION_SC;
		sal_Int16 nH = IMG_QUERYADMINISTRATION_SCH;
		if ( _eBitmapSet == SFX_SYMBOLS_LARGE )	 	 
		{
			nN = IMG_QUERYADMINISTRATION_LC;
			nH = IMG_QUERYADMINISTRATION_LCH;
		}

		return _bHiContast ? nH : nN;
	}
	//------------------------------------------------------------------------
	sal_Bool OQueryAdministrationPage::createClientMonitor()
	{
		if ( m_xConnectionClientMonitor.isValid() )
			return sal_True;

		// build a connection to our data source
		ODatasourceConnector aConnector( m_xORB, GetParent() );
		Reference< XConnection > xConnection = aConnector.connect( m_sDSName  );
		if ( !xConnection.is() )
			// nothing to do, the connector already displayed an error message
			return sal_False;

		// get the component interface of the connection
		Reference< XComponent > xConnComp( xConnection, UNO_QUERY );
		OSL_ENSURE( xConnComp.is(), "OQueryAdministrationPage::createClientMonitor: invalid connection (no XComponent)!" );

		// create the client monitor
		m_xConnectionClientMonitor = new OComponentClientMonitor( xConnComp );
		m_xConnectionClientMonitor->registerAnonymousClient( );

		return sal_True;
	}

	//------------------------------------------------------------------------
	void OQueryAdministrationPage::deleteClientMonitor()
	{
		if ( m_xConnectionClientMonitor.isValid() )
		{
			m_xConnectionClientMonitor->revokeAnonymousClient();
			m_xConnectionClientMonitor = NULL;
		}
	}

	//------------------------------------------------------------------------
	SfxTabPage*	OQueryAdministrationPage::Create( Window* _pParent, const SfxItemSet& _rAttrSet)
	{
		return new OQueryAdministrationPage(_pParent, _rAttrSet);
	}

	//------------------------------------------------------------------------
	int OQueryAdministrationPage::DeactivatePage(SfxItemSet* _pSet)
	{
		deleteClientMonitor();

		return OCollectionPage::DeactivatePage( _pSet );
	}

	//------------------------------------------------------------------------
	Reference< XNameAccess > OQueryAdministrationPage::getObjectCollection( const Reference< XPropertySet >& _rxDatasource ) const
	{
		Reference< XQueryDefinitionsSupplier > xSuppQueries(_rxDatasource , UNO_QUERY);
		if (xSuppQueries.is())
			return xSuppQueries->getQueryDefinitions();
		return Reference< XNameAccess >();
	}

	//------------------------------------------------------------------------
	Image OQueryAdministrationPage::getEntryImage() const
	{
		return Image(ModuleRes(QUERY_TREE_ICON));
	}

	//------------------------------------------------------------------------
	OPageSettings* OQueryAdministrationPage::createViewSettings()
	{
		return new OToolboxedPageViewSettings;
	}

	//------------------------------------------------------------------------
	void OQueryAdministrationPage::onToolBoxAction( sal_uInt16 _nClickedItemId )
	{
		if (ID_DROP_QUERY != _nClickedItemId)
		{
			OToolboxedPageViewSettings* pMySettings = new OToolboxedPageViewSettings;
			pMySettings->nDelayedToolboxAction = _nClickedItemId;

			OPageSettings* pTypedSettings = pMySettings;

			if (!prepareConnectionAction(m_pAdminDialog, m_aActions.GetItemText(_nClickedItemId), &pTypedSettings))
				return;
		}

		switch (_nClickedItemId)
		{
			case ID_NEW_QUERY_DESIGN:
				if ( createClientMonitor() )
				{
					OQueryDesignAccess aDispatcher( m_xORB, sal_False, sal_False );
					aDispatcher.create(m_sDSName, getClientMonitor( ) );
				}
				break;

			case ID_NEW_QUERY_SQL:
				if ( createClientMonitor() )
				{
					OQueryDesignAccess aDispatcher( m_xORB, sal_False, sal_True );
					aDispatcher.create( m_sDSName, getClientMonitor( ) );
				}
				break;

			case ID_EDIT_QUERY_DESIGN:
				if ( createClientMonitor() )
				{
					DBG_ASSERT( FirstSelected(), "OQueryAdministrationPage::onToolBoxAction: invalid selection!" );

					OQueryDesignAccess aDispatcher( m_xORB, sal_False, sal_False );
					aDispatcher.edit( m_sDSName, getEntryText( FirstSelected() ), getClientMonitor( ) );
				}
				break;

			case ID_EDIT_QUERY_SQL:
				if ( createClientMonitor() )
				{
					DBG_ASSERT( FirstSelected(), "OQueryAdministrationPage::onToolBoxAction: invalid selection!" );

					OQueryDesignAccess aDispatcher( m_xORB, sal_False, sal_True );
					aDispatcher.edit( m_sDSName, getEntryText( FirstSelected() ), getClientMonitor( ) );
				}
				break;

			case ID_DROP_QUERY:
				implDeleteSelection(STR_QUERY_DELETE_QUERY);
				break;
			case ID_RENAME_ENTRY:
				implRenameSelection();
				break;

			default:
				OSL_ENSURE(sal_False, "OQueryAdministrationPage::onToolBoxAction: invalid id!");
				break;
		}
	}

	//------------------------------------------------------------------------
	void OQueryAdministrationPage::updateButtons()
	{
		OCollectionPage::updateButtons();

		SvLBoxEntry* pEntry = FirstSelected();
		sal_Bool bSelectedSomething = (NULL != pEntry);
		sal_Bool bMultiSelection = sal_False;
		if(bSelectedSomething)
			bMultiSelection = (NULL != NextSelected(pEntry));

		m_aActions.EnableItem(ID_NEW_QUERY_DESIGN,	sal_True);
		m_aActions.EnableItem(ID_NEW_QUERY_SQL,		sal_True);
		m_aActions.EnableItem(ID_EDIT_QUERY_DESIGN,	!bMultiSelection && bSelectedSomething);
		m_aActions.EnableItem(ID_EDIT_QUERY_SQL,	!bMultiSelection && bSelectedSomething);
		m_aActions.EnableItem(ID_DROP_QUERY,		bSelectedSomething);
		m_aActions.EnableItem(ID_RENAME_ENTRY,		!bMultiSelection && bSelectedSomething);
	}

	//------------------------------------------------------------------------
	void OQueryAdministrationPage::implRenameSelection()
	{
		if(createClientMonitor())
		{
			try
			{
				::rtl::OUString sName = getEntryText( FirstSelected() );
				Reference<XRename> xRename;
				Reference<XQueriesSupplier> xSup(m_xConnectionClientMonitor->getComponent(),UNO_QUERY);
				Reference<XNameAccess> xNameAccess = xSup.is() ? xSup->getQueries() : Reference<XNameAccess>();
				if(xNameAccess.is() && xNameAccess->hasByName(sName))
					xNameAccess->getByName(sName) >>= xRename;

				if(xRename.is())
				{
					OSaveAsDlg aDlg(this,CommandType::QUERY,xNameAccess,NULL,NULL,sName,SAD_TITLE_PASTE_AS);
					if(aDlg.Execute() == RET_OK)
					{
						sName = aDlg.getName();
						if(xNameAccess.is() && !xNameAccess->hasByName(sName))
						{
							xRename->rename(sName);
							setEntryText(FirstSelected(),0,sName);
						}
					}
				}
			}
			catch(const SQLException& e)
			{
				::dbaui::showError(SQLExceptionInfo(e),this,m_xORB);
			}
			catch(const ElementExistException& e)
			{
				static ::rtl::OUString sStatus = ::rtl::OUString::createFromAscii("S1000");
				String sMsg = String(ModuleRes(STR_OBJECT_ALREADY_EXISTS));
				sMsg.SearchAndReplace('#',e.Message);
				::dbaui::showError(SQLExceptionInfo(SQLException(sMsg, e.Context, sStatus, 0, Any())),this,m_xORB);
			}
			catch(const Exception& )
			{
				OSL_ENSURE(0,"Exception catched!");
			}
		}
	}


	//========================================================================
	//= ODocumentLinksPage
	//========================================================================
	//------------------------------------------------------------------------
	ODocumentLinksPage::ODocumentLinksPage( Window* pParent, const SfxItemSet& _rCoreAttrs )
		:OCollectionPage( pParent, ModuleRes(PAGE_DOCUMENTLINKS), _rCoreAttrs, STR_DOCUMENT_OBJECTS )
	{
		FreeResource();
		setToolBox(&m_aActions);

		m_aActions.SetClickHdl(LINK(this, ODocumentLinksPage, OnDropDownToolboxButton));

		addToolboxAccelerator( ID_DROP_LINK, KeyCode( KEY_DELETE ) );
	}

	//------------------------------------------------------------------
	sal_Int16 ODocumentLinksPage::getImageListId(sal_Int16 _eBitmapSet,sal_Bool _bHiContast) const
	{
		sal_Int16 nN = IMG_DOCUMENTLINKS_SC;
		sal_Int16 nH = IMG_DOCUMENTLINKS_SCH;
		if ( _eBitmapSet == SFX_SYMBOLS_LARGE )	 	 
		{
			nN = IMG_DOCUMENTLINKS_LC;
			nH = IMG_DOCUMENTLINKS_LCH;
		}

		return _bHiContast ? nH : nN;
	}
	//------------------------------------------------------------------------
	void ODocumentLinksPage::onToolBoxAction( sal_uInt16 _nClickedItemId )
	{
		switch (_nClickedItemId)
		{
			case ID_OPEN_DOCUMENT:
				OnOpenDocument();
				break;

			case ID_EDIT_DOCUMENT:
				OnEditDocument();
				break;

			case ID_NEW_LINK:
				OnNewLink();
				break;

			case ID_EDIT_LINK:
				OnEditLink();
				break;

			case ID_DROP_LINK:
				OnDropLink();
				break;

			case ID_CREATE_NEW_DOC:
				// happens sometimes due to bad timing
				break;

			case ID_FORM_NEW_PILOT:
			case ID_DOCUMENT_CREATE_REPWIZ:
			{
				OLinkedDocumentsAccess aHelper(GetParent(), m_xORB, m_xObjects);
				SFX_ITEMSET_GET(GetItemSet(), pDataSource, SfxStringItem, DSID_NAME, sal_True);
				DBG_ASSERT( pDataSource, "ODocumentLinksPage::onToolBoxAction: no data source name!" );
				if ( ID_DOCUMENT_CREATE_REPWIZ != _nClickedItemId )
					aHelper.newFormWithPilot( pDataSource ? pDataSource->GetValue() : String(), -1, String(), Reference< XConnection >() );
				else
					aHelper.newReportWithPilot( pDataSource ? pDataSource->GetValue() : String(), -1, String(), Reference< XConnection >() );
				break;
			}

			default:
				DBG_ERROR("ODocumentLinksPage::onToolBoxAction: unexpected item id!");
				break;
		}
	}

	//------------------------------------------------------------------------
	::rtl::OUString ODocumentLinksPage::getLocation( const ::rtl::OUString& _rName ) const
	{
		::rtl::OUString sLocation;
		try
		{
#ifdef DBG_UTIL
			sal_Bool bSuccess =
#endif
			m_xObjects->getByName(_rName) >>= sLocation;
			DBG_ASSERT(bSuccess, "ODocumentLinksPage::getLocation: invalid bookmark returned!");
		}
		catch(const Exception&)
		{
			DBG_ERROR("ODocumentLinksPage::getLocation: caught an exception while retrieving the location!");
		}

		// convert the URL into system notation
		if (sLocation.getLength())
		{
			OFileNotation aTransformer(sLocation, OFileNotation::N_URL);
			sLocation = aTransformer.get(OFileNotation::N_SYSTEM);
		}
		return sLocation;
	}

	//------------------------------------------------------------------------
	void ODocumentLinksPage::OnOpenDocument()
	{
		OLinkedDocumentsAccess aHelper(GetParent(), m_xORB, m_xObjects);
		aHelper.open(getSelectedObjectName( ), sal_True);
	}

	//------------------------------------------------------------------------
	void ODocumentLinksPage::OnEditDocument()
	{
		OLinkedDocumentsAccess aHelper(GetParent(), m_xORB, m_xObjects);
		aHelper.open(getSelectedObjectName( ), sal_False);
	}

	//------------------------------------------------------------------------
	void ODocumentLinksPage::OnNewLink()
	{
		OLinkedDocumentsAccess aHelper(GetParent(), m_xORB, m_xObjects);
		aHelper.addLinkUI();
	}

	//------------------------------------------------------------------------
	void ODocumentLinksPage::OnEditLink()
	{
		OLinkedDocumentsAccess aHelper(GetParent(), m_xORB, m_xObjects);

		::rtl::OUString sSelected = getSelectedObjectName( );
		::rtl::OUString sLocation = aHelper.getLocation(sSelected);
		::rtl::OUString sNewName, sNewLocation;
		if (aHelper.edit(sSelected, sNewName, sNewLocation))
		{
			if ((sSelected == sNewName) && (sLocation != sNewLocation))
			{
				OFileNotation aTransformer(sNewLocation, OFileNotation::N_URL);
				sNewLocation = aTransformer.get(OFileNotation::N_SYSTEM);

				// the location changed, but not the name
				// -> need to set the location text in our view
				// (if the name changed, this is done automagically as we're a container listener and thus
				// get notified of the removal/reinsert)
				SvLBoxEntry* pEntry = findEntry(sSelected);
				if (pEntry)
				{
					setEntryText( pEntry, 0, sSelected );
					setEntryText( pEntry, 1, sNewLocation );
				}
				else
					DBG_ERROR("ODocumentLinksPage::OnEditLink: inconsistence: did not find the entry we edited!");
			}
		}
	}

	//------------------------------------------------------------------------
	void ODocumentLinksPage::OnDropLink()
	{
		implDeleteSelection(STR_QUERY_DROP_DOCUMENT_LINK);
	}

	//------------------------------------------------------------------------
	void ODocumentLinksPage::ActivatePage(const SfxItemSet& _rSet)
	{
		OCollectionPage::ActivatePage(_rSet);
	}

	//------------------------------------------------------------------------
	void ODocumentLinksPage::onEntryDoubleClicked( )
	{
		if (FirstSelected())
			OnEditLink();
	}

	//------------------------------------------------------------------------
	SfxTabPage*	ODocumentLinksPage::Create( Window* _pParent, const SfxItemSet& _rAttrSet)
	{
		return new ODocumentLinksPage(_pParent, _rAttrSet);
	}

	//------------------------------------------------------------------------
	Reference< XNameAccess > ODocumentLinksPage::getObjectCollection( const Reference< XPropertySet >& _rxDatasource ) const
	{
		Reference< XBookmarksSupplier > xSuppBokmarks(_rxDatasource , UNO_QUERY);
		if (xSuppBokmarks.is())
			return xSuppBokmarks->getBookmarks();
		return Reference< XNameAccess >();
	}

	//------------------------------------------------------------------------
	void ODocumentLinksPage::insertEntry( const ::rtl::OUString& _rName )
	{
		Image aEntryImage = getEntryImage();

		::rtl::OUString sName( _rName );
		sal_Unicode cTabulator = '\t';
		sName += ::rtl::OUString( &cTabulator, 1 );
		sName += getLocation( _rName );
		OCollectionPage::insertEntry( sName );
	}

	//------------------------------------------------------------------------
	void ODocumentLinksPage::updateButtons()
	{
		OCollectionPage::updateButtons();

		SvLBoxEntry* pEntry = FirstSelected();
		sal_Bool bSelectedSomething = (NULL != pEntry);
		sal_Bool bMultiSelection = sal_False;
		if(bSelectedSomething)
			bMultiSelection = (NULL != NextSelected(pEntry));

		// #95715# OJ
		sal_Bool bIsWriterInstalled = SvtModuleOptions().IsModuleInstalled(SvtModuleOptions::E_SWRITER);

		m_aActions.EnableItem(ID_OPEN_DOCUMENT,				!bMultiSelection && bSelectedSomething);
		m_aActions.EnableItem(ID_EDIT_DOCUMENT,				!bMultiSelection && bSelectedSomething);
		m_aActions.EnableItem(ID_NEW_LINK,					sal_True);
		m_aActions.EnableItem(ID_EDIT_LINK,					!bMultiSelection && bSelectedSomething);
		m_aActions.EnableItem(ID_DROP_LINK,					bSelectedSomething);
		m_aActions.EnableItem(ID_DOCUMENT_CREATE_REPWIZ,	bIsWriterInstalled);
		m_aActions.EnableItem(ID_FORM_NEW_PILOT,			bIsWriterInstalled);
	}

	//------------------------------------------------------------------------
	IMPL_LINK( ODocumentLinksPage, OnDropDownToolboxButton, void*, NOTINTERESTEDIN)
	{
		if (m_aActions.IsItemDown(ID_CREATE_NEW_DOC))
		{
			m_aActions.EndSelection();

			// tell the toolbox that the item is pressed down
			m_aActions.SetItemDown(ID_CREATE_NEW_DOC, sal_True);

			// simulate a mouse move (so the "down" state is really painted)
			Point aPoint = m_aActions.GetItemRect(ID_CREATE_NEW_DOC).TopLeft();
			MouseEvent aMove( aPoint, 0, MOUSE_SIMPLEMOVE | MOUSE_SYNTHETIC );
			m_aActions.MouseMove( aMove );

			m_aActions.Update();

			// execute the menu
			PopupMenu aNewForm(ModuleRes(RID_NEW_FORM));

			// look for installed modules
			// #95715# OJ
			SvtModuleOptions aModuleOpt;
			sal_Bool bIsWriterInstalled = aModuleOpt.IsModuleInstalled(SvtModuleOptions::E_SWRITER);
			aNewForm.EnableItem(ID_FORM_NEW_TEXT,			bIsWriterInstalled);
			aNewForm.EnableItem(ID_FORM_NEW_PILOT,			bIsWriterInstalled);
			aNewForm.EnableItem(ID_DOCUMENT_CREATE_REPWIZ,	bIsWriterInstalled);
			aNewForm.EnableItem(ID_FORM_NEW_CALC,			aModuleOpt.IsModuleInstalled(SvtModuleOptions::E_SCALC));
			aNewForm.EnableItem(ID_FORM_NEW_IMPRESS,		aModuleOpt.IsModuleInstalled(SvtModuleOptions::E_SIMPRESS));
			
			sal_uInt16 nId = aNewForm.Execute(&m_aActions, m_aActions.GetItemRect(ID_CREATE_NEW_DOC));

			// "cleanup" the toolbox state
			MouseEvent aLeave( aPoint, 0, MOUSE_LEAVEWINDOW | MOUSE_SYNTHETIC );
			m_aActions.MouseMove( aLeave );
			m_aActions.SetItemDown(ID_CREATE_NEW_DOC, sal_False);

			OLinkedDocumentsAccess aHelper(GetParent(), m_xORB, m_xObjects);
			if ( ID_FORM_NEW_PILOT == nId || ID_DOCUMENT_CREATE_REPWIZ == nId )
			{
				OToolboxedPageViewSettings* pMySettings = new OToolboxedPageViewSettings;
				pMySettings->nDelayedToolboxAction = nId;

				OPageSettings* pTypedSettings = pMySettings;
				if ( prepareConnectionAction(m_pAdminDialog, aNewForm.GetItemText(nId), &pTypedSettings) )
				{	// the real action is not executed asyncronously
					onToolBoxAction( nId );
				}
			}
			else
				aHelper.newForm(nId);
		}

		return 1L;
	}
//.........................................................................
}	// namespace dbaui
//.........................................................................

