/*************************************************************************
 *
 *  $RCSfile: merging.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <address.hxx>

#ifndef _SMART_COM_SUN_STAR_UTIL_XCANCELMANAGER_HXX_
#include <smart/com/sun/star/util/XCancelManager.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_UTIL_XCANCELLABLE_HXX_
#include <smart/com/sun/star/util/XCancellable.hxx>
#endif

#ifndef _VOS_CONDITN_HXX_ //autogen wg. OCondition
#include <vos/conditn.hxx>
#endif

#ifdef _USE_NAMESPACE
using namespace vos;
using namespace usr;
#endif


struct OAddressBookSourceMergingData : public OAddressBookSourceData
{
	static void fillClassInfo(
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps );

	Sequence<UString>                                     m_Sources;
};


class OAddressBookSourceMerging : 
	public OAddressBookSourceMergingData, public OPropertySet, 
	public XAddressBookJobFactorySupplier,
	public XJobFactory
{
public:

	SMART_UNO_DECLARATION( OAddressBookSourceMergingData, OPropertySet );
	OAddressBookSourceMerging( const XMultiServiceFactoryRef& xSrv );
	
	static XInterfaceRef create( const XMultiServiceFactoryRef& xMgr ) 	{
		return *new OAddressBookSourceMerging( xMgr ); }

	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

	virtual XJobFactoryRef getJobFactory();
	virtual XInterfaceRef createJob( 
		const UString& rType, const Sequence<UsrAny>& rArgs );

	OAddressBookSourceMergingData getData() { 
		OGuard aGuard( m_aMutex ); return *this; }

	const XAddressBookRecordContainerRef& getRecordContainer();
	Sequence<XAddressBookJobFactorySupplierRef> getSources();
	XAddressBookJobFactorySupplierRef getSource( const UString& rName );

	static void substituteUid( 
		Sequence<AddressBookParameteredPropertyValue>& rValues, 
		const UString& rSource, BOOL bUpwards );

protected:
	void setFastPropertyValue_NoBroadcast( 
		INT32 nHandle, const UsrAny& rValue ) THROWS( (Exception) );
private:

	OMutex                                                m_aMutex;
	XMultiServiceFactoryRef                               m_xMgr;
	XJobFactoryRef                                        m_xJobFactory;
	XAddressBookRecordContainerRef                        m_xRecordContainer;
};

USR_DECLIMPL_OBJECT_REF( OAddressBookSourceMerging );

class OAddressBookSourceMergingSynchronJob :
	public UsrObject, public XSynchronJob
{
public:
	SMART_UNO_DECLARATION( OAddressBookSourceMergingSynchronJob, UsrObject );
	OAddressBookSourceMergingSynchronJob( 
		const XMultiServiceFactoryRef& xMgr, 
		const OAddressBookSourceMergingRef& xSource, 
		const UString& rType, const Sequence<UsrAny>& rArgs );
	
	
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	// XCancelable
	virtual void cancel(){}
	virtual void suspend(){}
	virtual void resume(){}

	virtual UsrAny executeSynchron();

private:
	OAddressBookSourceMergingRef m_xSource;
	XMultiServiceFactoryRef      m_xMgr;
	UString                      m_aType;
	Sequence<UsrAny>             m_aArgs;
};


struct XInterfaceRefEqual
{
	inline bool operator()(const XAsynchronJobRef & x1, const XAsynchronJobRef & x2) const
	{
		return x1 == x2;
	}
};

struct XInterfaceRefHash
{
	inline size_t operator()(const XAsynchronJobRef & x1) const {
		return (size_t)(XAsynchronJob*)x1; }
};


struct OAddressBookMergingSubJobData
{
	OResultSet       m_aResultSet;
	BOOL             m_bDone;
	UString          m_aSchema;

	OAddressBookMergingSubJobData( 
		const UString& rSchema, const Sequence<AddressBookSortInfo>& rSorting )
		: m_aResultSet( rSorting ), m_bDone( FALSE ), m_aSchema( rSchema ) 
		{
		}
};

typedef NAMESPACE_STD(hash_map)
<XAsynchronJobRef, OAddressBookMergingSubJobData*, XInterfaceRefHash, XInterfaceRefEqual>
OXInterfaceResultSetHashMap;

class OAddressBookSourceMergingQueryJob :
	public UsrObject, public XAsynchronJob, public XJobListener
{
public:
	SMART_UNO_DECLARATION( OAddressBookSourceMergingJob, UsrObject );
	OAddressBookSourceMergingQueryJob( 
		const XMultiServiceFactoryRef& xMgr, 
		const OAddressBookSourceMergingRef& xSource, 
		const UString& rType, const Sequence<UsrAny>& rArgs );
	
	
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	// XCancelable
	virtual void cancel();
	virtual void suspend(){}
	virtual void resume(){}

	// XJobListenerRef
	virtual void   updateJobState( const JobEvent& rEvent );
	virtual void   disposing( const EventObject& rObj ){}

	virtual void executeAsynchron( const XJobListenerRef& xCallback );


private:
	void executeQueries( 
		const UString& rSource, const vector<UString>& rBasisSchemata, 
		const UString& rQuery, const Sequence<AddressBookSortInfo>& rSorting, 
		const Sequence<UString>& rProperties );
	
	void feedListener();

	void cutParentUidPart( AddressBookQueryTerm& rTerm );

	OMutex                              m_aMutex;
	OXInterfaceResultSetHashMap         m_aResultSets;
	Sequence<AddressBookSortInfo>       m_aSorting;
	XJobListenerRef                     m_xCallback;
	OAddressBookSourceMergingRef        m_xSource;
	XMultiServiceFactoryRef             m_xMgr;
	UString                             m_aType;
	Sequence<UsrAny>                    m_aArgs;
};

