/*************************************************************************
 *
 *  $RCSfile: toolbar.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <vos/mutex.hxx>
#include <tools/urlobj.hxx>
#include <usr/weak.hxx>
#include <usr/reflserv.hxx>
#include <usr/factoryhlp.hxx>
#include <usr/services.hxx>
#include <usr/smart2uno.hxx>
#include <toolkit/unoiface.hxx>
#ifndef _SMART_COM_SUN_STAR_FRAME_XCONTROLLER_HXX_
#include <smart/com/sun/star/frame/XController.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HXX_
#include <smart/com/sun/star/frame/XFrameActionListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HXX_
#include <smart/com/sun/star/frame/XComponentLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAME_HXX_
#include <smart/com/sun/star/frame/XFrame.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HXX_
#include <smart/com/sun/star/frame/FrameActionEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTION_HXX_
#include <smart/com/sun/star/frame/FrameAction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMELOADER_HXX_
#include <smart/com/sun/star/frame/XFrameLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XLOADEVENTLISTENER_HXX_
#include <smart/com/sun/star/frame/XLoadEventListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFILTERDETECT_HXX_
#include <smart/com/sun/star/frame/XFilterDetect.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICENAME_HXX_
#include <smart/com/sun/star/lang/XServiceName.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICEINFO_HXX_
#include <smart/com/sun/star/lang/XServiceInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XMultiServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XSingleServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUES_HXX_
#include <smart/com/sun/star/beans/PropertyValues.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUE_HXX_
#include <smart/com/sun/star/beans/PropertyValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYSTATE_HXX_
#include <smart/com/sun/star/beans/PropertyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HXX_
#include <smart/com/sun/star/beans/XPropertySetInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XMultiPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XFASTPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XFastPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XVETOABLECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XVetoableChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSTATE_HXX_
#include <smart/com/sun/star/beans/XPropertyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSTATECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyStateChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HXX_
#include <smart/com/sun/star/beans/PropertyAttribute.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertiesChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYACCESS_HXX_
#include <smart/com/sun/star/beans/XPropertyAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HXX_
#include <smart/com/sun/star/beans/XPropertyContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYSTATECHANGEEVENT_HXX_
#include <smart/com/sun/star/beans/PropertyStateChangeEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYCHANGEEVENT_HXX_
#include <smart/com/sun/star/beans/PropertyChangeEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCONTAINER_HXX_
#include <smart/com/sun/star/container/XContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XINDEXCONTAINER_HXX_
#include <smart/com/sun/star/container/XIndexContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HXX_
#include <smart/com/sun/star/container/XNameReplace.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCONTAINERLISTENER_HXX_
#include <smart/com/sun/star/container/XContainerListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XSET_HXX_
#include <smart/com/sun/star/container/XSet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_CONTAINEREVENT_HXX_
#include <smart/com/sun/star/container/ContainerEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XINDEXREPLACE_HXX_
#include <smart/com/sun/star/container/XIndexReplace.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HXX_
#include <smart/com/sun/star/container/XNameContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_MERGECONFLICTEXCEPTION_HXX_
#include <smart/com/sun/star/registry/MergeConflictException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HXX_
#include <smart/com/sun/star/registry/XSimpleRegistry.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_INVALIDVALUEEXCEPTION_HXX_
#include <smart/com/sun/star/registry/InvalidValueException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_REGISTRYKEYTYPE_HXX_
#include <smart/com/sun/star/registry/RegistryKeyType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HXX_
#include <smart/com/sun/star/registry/XRegistryKey.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_REGISTRYVALUETYPE_HXX_
#include <smart/com/sun/star/registry/RegistryValueType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_INVALIDREGISTRYEXCEPTION_HXX_
#include <smart/com/sun/star/registry/InvalidRegistryException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LOADER_XIMPLEMENTATIONLOADER_HXX_
#include <smart/com/sun/star/loader/XImplementationLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LOADER_CANNOTACTIVATEFACTORYEXCEPTION_HXX_
#include <smart/com/sun/star/loader/CannotActivateFactoryException.hxx>
#endif

#include <svtools/iniprop.hxx>
#include <svtools/iniman.hxx>

#ifndef _TOOLS_DEBUG_HXX //autogen wg. DBG_ASSERT
#include <tools/debug.hxx>
#endif

#include "adrbeam.hxx"
#include "toolbar.hrc"
#include "adrresid.hxx"

#ifdef _USE_NAMESPACE
using namespace usr;
using namespace vos;
#endif


// Konstanten -------------------------------------------------------------

SMART_UNO_IMPLEMENTATION( AdrToolBarListener, UsrObject );

AdrToolBarListener::AdrToolBarListener(AdrToolBar *pTB,UString aStr,USHORT nId):
		pToolBar(pTB),
		nIndex(nId),
		aCommand(aStr)
{
}

BOOL AdrToolBarListener::queryInterface( UsrUik aUIK, XInterfaceRef& rOut )
{
	if ( aUIK == XStatusListener::getSmartUik() )
	{
		rOut = (XStatusListener*)this;
		return TRUE;
	}
	else
	{
		return UsrObject::queryInterface( aUIK, rOut );
	}
}

void AdrToolBarListener::statusChanged(const FeatureStateEvent& rEvt)THROWS( (UsrSystemException) )
{
	if(rEvt.FeatureURL.Complete == aCommand)
	{
		pToolBar->EnableItem(nIndex,rEvt.IsEnabled);
	
		UsrAny aState=rEvt.State;
		if(aState.getReflection()==BOOL_getReflection())
		{
			BOOL bChecked=aState.getBOOL();
			pToolBar->CheckItem(nIndex, bChecked);
		}	

		/*
		UString FeatureDescriptor;
		BOOL Requery;
		UsrAny State;*/
	}
};

USHORT AdrToolBarListener::GetIndex()
{
	return nIndex;
}
void AdrToolBarListener::SetIndex(USHORT nId)
{
	nIndex=nId;
}

UString	AdrToolBarListener::GetCommand()
{
	return aCommand;
}
void AdrToolBarListener::SetCommand(const UString& aStr)
{
	aCommand=aStr;
}

AdrTBListBoxListener::AdrTBListBoxListener(AdrToolBar *pTB,UString aStr,USHORT nId):
	AdrToolBarListener(pTB,aStr,nId)
{
}

void AdrTBListBoxListener::statusChanged(const FeatureStateEvent& rEvt)THROWS( (UsrSystemException) )
{
	if(rEvt.FeatureURL.Complete == GetCommand())
	{
		pToolBar->EnableSourceList(rEvt.IsEnabled);
	
		UsrAny aState=rEvt.State;
		if(aState.getReflection()==Sequence<UString>::getReflection())
		{
			pToolBar->UpdateSourceList(FALSE);
			pToolBar->ClearSourceList();

			Sequence<UString>* pStringSeq = (Sequence<UString>*)aState.get();
			const UString* pStringArray = (const UString*)pStringSeq->getConstArray();

			UINT32 nCount = pStringSeq->getLen();
			XubString aEntry;
			for( UINT32 i=0; i<nCount; i++ )
			{
				aEntry=OUStringToString( pStringArray[i], CHARSET_SYSTEM );
				pToolBar->InsertSourceEntry(aEntry);
			}
			pToolBar->UpdateSourceList(TRUE);
		}	

		XubString aStr=OUStringToString( rEvt.FeatureDescriptor, CHARSET_SYSTEM );
		pToolBar->SelectSourceEntry(aStr);
	}
};

AdrTBQueryMenuListener::AdrTBQueryMenuListener(AdrToolBar *pTB,UString aStr,USHORT nId):
	AdrToolBarListener(pTB,aStr,nId)
{
}

void AdrTBQueryMenuListener::statusChanged(const FeatureStateEvent& rEvt)THROWS( (UsrSystemException) )
{
	if(rEvt.FeatureURL.Complete == GetCommand())
	{
		pToolBar->EnableSourceList(rEvt.IsEnabled);
	
		UsrAny aState=rEvt.State;
		if(aState.getReflection()==Sequence<UString>::getReflection())
		{
			pToolBar->ClearFilterMenu();
			
			Sequence<UString>* pStringSeq = (Sequence<UString>*) aState.get();
			const UString* pStringArray = (const UString*)pStringSeq->getConstArray();

			UINT32 nCount = pStringSeq->getLen();
			XubString aEntry;
			for( UINT32 i=0; i<nCount; i++ )
			{
				aEntry=OUStringToString( pStringArray[i], CHARSET_SYSTEM );
				USHORT nID=pToolBar->InsertFilterItem(aEntry);
				if(pStringArray[i]==rEvt.FeatureDescriptor)
				{
					XubString aStr=OUStringToString( rEvt.FeatureDescriptor, CHARSET_SYSTEM );
					pToolBar->SelectFilterItem(nID);
				}
			}
		}	
	}
};

AdrTBEditListener::AdrTBEditListener(AdrToolBar *pTB,UString aStr,USHORT nId):
	AdrToolBarListener(pTB,aStr,nId)
{
}

void AdrTBEditListener::statusChanged(const FeatureStateEvent& rEvt)THROWS( (UsrSystemException) )
{
	if(rEvt.FeatureURL.Complete == GetCommand())
	{
		pToolBar->EnableQuery(rEvt.IsEnabled);
	
		UsrAny aState=rEvt.State;
		if(aState.getReflection()==OUString_getReflection())
		{
			XubString aStr=OUStringToString( aState.getString(), CHARSET_SYSTEM );
			pToolBar->SetQueryString(aStr);
		}	
	}
}



SV_IMPL_PTRARR( AdrToolBarListenerArr, AdrToolBarListenerPtr);

AdrToolBar::AdrToolBar(Window* pParent, WinBits nStyle):
	ToolBox(pParent,AdrResId(RID_ADR_TOOLBAR)),
	aFtSource(this,WB_VCENTER),
	aLBSource(this,WB_DROPDOWN),
	aFtQuery(this,WB_VCENTER),
	aEdQuery(this),
	nSelMenuItem(0),
	nMenuId(0)
{
	SetStyle(GetStyle()|nStyle);
	SetOutStyle(TOOLBOX_STYLE_FLAT);
	Size aSize=GetSizePixel();
	Size a2Size(GetOutputSizePixel());
	a2Size.Width()=100;
	aLBSource.SetSizePixel(a2Size);
	aLBSource.SetDropDownLineCount(9);
	aLBSource.Show();
	aLBSource.SetSelectHdl(LINK( this, AdrToolBar, SelHdl));
	
	aTimer.SetTimeoutHdl(LINK( this, AdrToolBar, SendSelHdl));
	aTimer.SetTimeout(400);
	
	aMenuTimer.SetTimeoutHdl(LINK( this, AdrToolBar, MenuHdl));
	aMenuTimer.SetTimeout(300);
	
	aEdQuery.SetSizePixel(aLBSource.GetSizePixel());
	aEdQuery.Show();
	
	XubString aStr=GetItemText(TBC_FT_SOURCE);
	Rectangle aRect=GetItemRect(TBC_FT_SOURCE);
	aFtSource.SetText(aStr);
	aFtSource.SetSizePixel(aRect.GetSize());
	
	aStr=GetItemText(TBC_FT_QUERY);
	aRect=GetItemRect(TBC_FT_QUERY);
	aFtQuery.SetText(aStr);
	aFtQuery.SetSizePixel(aRect.GetSize());
	
	SetItemWindow(TBC_FT_SOURCE,&aFtSource);
	SetItemWindow(TBC_LB_SOURCE,&aLBSource);
	SetItemWindow(TBC_FT_QUERY ,&aFtQuery);
	SetItemWindow(TBC_ED_QUERY ,&aEdQuery);

	
}

AdrToolBar::~AdrToolBar()
{	
}
void AdrToolBar::InitListener()
{
	USHORT	nCount=GetItemCount();

	XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
	
	XDispatchRef xDisp(xController,USR_QUERY);

	XURLTransformerRef xTrans ( xMgr->createInstance( L"com.sun.star.util.URLTransformer" ), USR_QUERY );
	if( xTrans.is() )
	{
		URL aQueryURL;
		aQueryURL.Complete = L".uno:Adr/MenuFilter";
		xTrans->parseStrict( aQueryURL);
		AdrToolBarListener* pQuery=new AdrTBQueryMenuListener(this,aQueryURL.Complete,TBC_BT_AUTOFILTER);
		xDisp->addStatusListener(XStatusListenerRef(pQuery),aQueryURL);
	
		for(USHORT nPos=0;nPos<nCount;nPos++)
		{
			USHORT nId=GetItemId(nPos);
			if(nId==TBC_FT_SOURCE || nId==TBC_FT_QUERY) continue;
			
			URL aURL;
			aURL.Complete =StringToOUString(GetItemCommand(nId), CHARSET_SYSTEM);	
			
			xTrans->parseStrict( aURL );

			AdrToolBarListener* pListener=NULL;
			if(nId==TBC_LB_SOURCE)
			{
				pListener=new AdrTBListBoxListener(this,aURL.Complete,nId);
			}
			else if(nId==TBC_ED_QUERY)
			{
				pListener=new AdrTBEditListener(this,aURL.Complete,nId);
			}
			else
			{
				pListener=new AdrToolBarListener(this,aURL.Complete,nId);
			}

			XStatusListenerRef xListenerRef;

			aListenerArr.Insert( pListener, aListenerArr.Count() );

			xDisp->addStatusListener(XStatusListenerRef(pListener),aURL);
		}
	}
}

void AdrToolBar::SetXController(const XControllerRef& xCtr)
{
	xController=xCtr;
	InitListener();

}

void AdrToolBar::Select()
{
	USHORT	nId=GetCurItemId();

	if(nId!=TBC_BT_AUTOFILTER)
	{
		SendDispatch(nId,Sequence<PropertyValue>() );
	}
	else
	{
		Sequence<PropertyValue> aPropVal(2);
		PropertyValue* pPropertyVal = (PropertyValue*)aPropVal.getConstArray();
		pPropertyVal[0].Name=L"QueryText";
		UString aSelection=StringToOUString(aEdQuery.GetText(), CHARSET_SYSTEM);
		pPropertyVal[0].Value.setString(aSelection);

		pPropertyVal[1].Name=L"QueryField";
		pPropertyVal[1].Value.setString(aQueryField);
		SendDispatch(nId,aPropVal);
	}
}

void AdrToolBar::SendDispatch(USHORT nId, const Sequence< PropertyValue >& rArgs)
{
	UString aCommand=StringToOUString(GetItemCommand(nId), CHARSET_SYSTEM);
	
	XDispatchProviderRef xDSP( xController, USR_QUERY );
	
	if( xDSP.is() && aCommand.len())
	{
		XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
	
		XURLTransformerRef xTrans ( xMgr->createInstance( L"com.sun.star.util.URLTransformer" ), USR_QUERY );
		if( xTrans.is() )
		{
			// Datei laden
			URL aURL;
			aURL.Complete = aCommand;

			xTrans->parseStrict( aURL );

			XDispatchRef xDisp = xDSP->queryDispatch( aURL, UString(), FrameSearchFlag_SELF );
			
			if ( xDisp.Is() )
					xDisp->dispatch( aURL, rArgs);
		}
	}

}

void AdrToolBar::Click()
{
	USHORT	nId=GetCurItemId();

	if(nId==TBC_BT_AUTOFILTER)
	{
		aMenuTimer.Start();
	}
}

void AdrToolBar::ClearFilterMenu()
{
	aPopupMenu.Clear();
	nMenuId=0;
}
USHORT AdrToolBar::InsertFilterItem(const XubString& aMenuEntry)
{
	nMenuId++;
	aPopupMenu.InsertItem(nMenuId,aMenuEntry);

	return nMenuId;
}
void AdrToolBar::SelectFilterItem(USHORT	nId)
{
	aPopupMenu.CheckItem(nId);
	nSelMenuItem=nId;
	aQueryField=StringToOUString(
		aPopupMenu.GetItemText(nId).EraseAllChars( '~' ),CHARSET_SYSTEM);
}

void AdrToolBar::EnableSourceList(BOOL bFlag)
{
	aFtSource.Enable(bFlag);
	aLBSource.Enable(bFlag);
}

void AdrToolBar::ClearSourceList()
{
	aLBSource.Clear();
}

void AdrToolBar::UpdateSourceList(BOOL bFlag)
{
	aLBSource.SetUpdateMode(bFlag);
}

void AdrToolBar::InsertSourceEntry(const XubString& aEntry, USHORT nPos)
{
	aLBSource.InsertEntry(aEntry, nPos);
}

void AdrToolBar::SelectSourceEntry(const XubString& aStr)
{
	aLBSource.SelectEntry(aStr);
}

void AdrToolBar::EnableQuery(BOOL bFlag)
{
	aFtQuery.Enable(bFlag);
	aEdQuery.Enable(bFlag);
}

void AdrToolBar::SetQueryString(const XubString& aStr)
{
	aEdQuery.SetText(aStr);
}


long AdrToolBar::PreNotify( NotifyEvent& rNEvt )
{
	long nResult=TRUE;

	USHORT nSwitch=rNEvt.GetType();
	if(aEdQuery.HasFocus() && nSwitch==EVENT_KEYINPUT)// || nSwitch==EVENT_KEYUP)
	{
		const KeyCode& aKeyCode=rNEvt.GetKeyEvent()->GetKeyCode();
		USHORT nKey = aKeyCode.GetCode();
		if(nKey == KEY_RETURN)
		{
			Sequence<PropertyValue> aPropVal(2);
			PropertyValue* pPropertyVal = (PropertyValue*)aPropVal.getConstArray();
			pPropertyVal[0].Name = L"QueryText";
			UString aSelection = StringToOUString(aEdQuery.GetText(), CHARSET_SYSTEM);
			pPropertyVal[0].Value.setString(aSelection);
			pPropertyVal[1].Name=L"QueryField";
			pPropertyVal[1].Value.setString(aQueryField);
			SendDispatch(TBC_BT_AUTOFILTER,aPropVal);
			return nResult;
		}
		
	}
	
	nResult=ToolBox::PreNotify(rNEvt);

	return nResult;
}

IMPL_LINK( AdrToolBar, SelHdl, ListBox*, pLb )
{
	aTimer.Start();
	return 0;
}

IMPL_LINK( AdrToolBar, SendSelHdl, Timer*,pT)
{
	Sequence<PropertyValue> aPropVal(1);
	PropertyValue* pPropertyVal = (PropertyValue*)aPropVal.getConstArray();
	pPropertyVal[0].Name = L"DataSource";
	String aEntry( aLBSource.GetSelectEntry().EraseAllChars( '~' ) );
	UString aSelection = StringToOUString(aEntry, CHARSET_SYSTEM);
	pPropertyVal[0].Value.setString(aSelection);
	SendDispatch(TBC_LB_SOURCE,aPropVal);

	return 0;
}

IMPL_LINK( AdrToolBar, MenuHdl, Timer*,pT)
{
	if(IsItemDown(TBC_BT_AUTOFILTER))
	{
		EndSelection();		// vor SetDropMode (SetDropMode ruft SetItemImage)

		SetItemDown(TBC_BT_AUTOFILTER,TRUE);
		USHORT nId = aPopupMenu.Execute(this, GetItemRect(TBC_BT_AUTOFILTER));

		
		if(nId>0)
		{
			aPopupMenu.CheckItem(nSelMenuItem,FALSE);
			aPopupMenu.CheckItem(nId);
			nSelMenuItem=nId;
			aQueryField=StringToOUString(
				aPopupMenu.GetItemText(nId).EraseAllChars( '~' ),CHARSET_SYSTEM);
			Sequence<PropertyValue> aPropVal(2);
			PropertyValue* pPropertyVal = (PropertyValue*)aPropVal.getConstArray();
			pPropertyVal[0].Name = L"QueryText";
			UString aSelection = StringToOUString(aEdQuery.GetText(), CHARSET_SYSTEM);
			pPropertyVal[0].Value.setString(aSelection);
			pPropertyVal[1].Name=L"QueryField";
			pPropertyVal[1].Value.setString(aQueryField);
			SendDispatch(TBC_BT_AUTOFILTER,aPropVal);
		}
	
		Point aPoint;
		MouseEvent aLeave( aPoint, 0, MOUSE_LEAVEWINDOW | MOUSE_SYNTHETIC );
		MouseMove( aLeave );
		SetItemDown(TBC_BT_AUTOFILTER,FALSE);

		
	}	
	return 0;
}
