/*************************************************************************
 *
 *  $RCSfile: ldap.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <ldap.hxx>
#include <inet/ldapmsg.hxx>
#include <inet/inetldap.hxx>

#ifdef _USE_NAMESPACE
using namespace std;
#endif

#define LDAPCHARSET CHARSET_ANSI

// hello stupid solaris compiler:
inline BOOL operator<( const OAddressBookSourceLDAPQueryJobRef&,
					   const OAddressBookSourceLDAPQueryJobRef& )
{
	return FALSE;
}


OAddressBookSourceLDAPData::OAddressBookSourceLDAPData()
  	:
	m_TimeLimit( 0 ),
	m_SizeLimit( 100 ),
	m_Scope( AddressBookSourceLDAPScope_WHOLESUBTREE ),
	m_Port( 389 )
{
}

OAddressBookSourceLDAP::OAddressBookSourceLDAP(
	const XMultiServiceFactoryRef& xMgr ) :
	OPropertySet( 			
		m_aMutex, this,	
		OObjectClass<OAddressBookSourceLDAPData>::getInstance(), false ),
	m_xMgr( xMgr )
{
	m_ServiceName = L"stardiv.one.address.AddressBookSourceLDAP";

	AddressBookSourceLDAPSchemaDefinition aDefinition;
	aDefinition.Name = L"Person";
	AddressBookSourceLDAPFieldMapping aMapping[ 16 ];
	for( INT32 nPos = ARRSIZE( aMapping ); nPos--; )
		aMapping[ nPos ].Type = OUString_getReflection()->getIdlClass();
			
	aMapping[ 0 ].LDAPName = L"cn";
	aMapping[ 0 ].Name = L"Shownname";
	aMapping[ 1 ].LDAPName = L"sn";
	aMapping[ 1 ].Name = L"Surname";
	aMapping[ 2 ].LDAPName = L"givenName";
	aMapping[ 2 ].Name = L"Givenname";
	aMapping[ 3 ].LDAPName = L"o";
	aMapping[ 3 ].Name = L"Company";
	aMapping[ 4 ].LDAPName = L"ou";
	aMapping[ 4 ].Name = L"Department";
	aMapping[ 5 ].LDAPName = L"facsimileTelephoneNumber";
	aMapping[ 5 ].Name = L"Telephone";
	UString aAttrib1;
	aAttrib1 = L"Fax";
	aMapping[ 5 ].Parameters = Sequence<UString>( &aAttrib1, 1 );
	aMapping[ 6 ].LDAPName = L"telephoneNumber";
	aMapping[ 6 ].Name = L"Telephone";
	aMapping[ 7 ].LDAPName = L"manager";
	aMapping[ 7 ].Name = L"Managersname";
	aMapping[ 8 ].LDAPName = L"secretary";
	aMapping[ 8 ].Name = L"Secretaryname";
	aMapping[ 9 ].LDAPName = L"description";
	aMapping[ 9 ].Name = L"Note";
	aMapping[ 10 ].LDAPName = L"title";
	aMapping[ 10 ].Name = L"Jobtitle";
	aMapping[ 11 ].LDAPName = L"nickname";
	aMapping[ 11 ].Name = L"Nickname";
	aMapping[ 12 ].LDAPName = L"mail";
	aMapping[ 12 ].Name = L"EMail";
	aMapping[ 13 ].LDAPName = L"homephone";
	aMapping[ 13 ].Name = L"Telephone";
	aAttrib1 = L"Private";
	aMapping[ 13 ].Parameters = Sequence<UString>( &aAttrib1, 1 );
	aMapping[ 14 ].LDAPName = L"pager";
	aMapping[ 14 ].Name = L"Telephone";
	aAttrib1 = L"Pager";
	aMapping[ 14 ].Parameters = Sequence<UString>( &aAttrib1, 1 );
	aMapping[ 15 ].LDAPName = L"dn";
	aMapping[ 15 ].Name = L"Uid";
	aDefinition.FieldMappings = 
		Sequence<AddressBookSourceLDAPFieldMapping>( 
			aMapping, ARRSIZE( aMapping ) );
	m_Schemata = Sequence<AddressBookSourceLDAPSchemaDefinition>( 
		&aDefinition, 1 );
}

inline BOOL isEqual( const AddressBookSourceLDAPFieldMapping& r1, 
					 const AddressBookSourceLDAPFieldMapping& r2 )
{
	return r1.Name == r2.Name && isEqual( r1.Parameters, r2.Parameters ) &&
		r1.LDAPName == r2.LDAPName && r1.IsRequired == r2.IsRequired &&
		r1.Type->equals( r2.Type );
}

DECLARE_SEQEQUAL( AddressBookSourceLDAPFieldMapping )

inline BOOL isEqual( const AddressBookSourceLDAPSchemaDefinition& r1, 
					 const AddressBookSourceLDAPSchemaDefinition& r2 )
{
	return r1.Name == r2.Name && isEqual( r1.FieldMappings, r2.FieldMappings ) &&
		r1.BaseQuery == r2.BaseQuery && r1.BaseObject == r2.BaseObject;
}

DECLARE_SEQEQUAL( AddressBookSourceLDAPSchemaDefinition )

void OAddressBookSourceLDAPData::fillClassInfo(
	OObjectClassBase*& rpParentClass, 
	Sequence<OPropertyAccessor>& rProps )
{
	static OPropertyAccessor aProps[] = 
	{
		ADR_PROPERTY( 
			OAddressBookSourceLDAPData, Name, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceLDAPData, ServiceName, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceLDAPData, Server, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceLDAPData, User, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceLDAPData, Password, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceLDAPData, Port, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceLDAPData, TimeLimit, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceLDAPData, SizeLimit, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceLDAPData, Schemata, PropertyAttribute_BOUND ),
		ADR_PROPERTY( 
			OAddressBookSourceLDAPData, Scope, PropertyAttribute_BOUND )
	};
	rProps = Sequence<OPropertyAccessor>( 
		aProps, sizeof( aProps )/ sizeof( OPropertyAccessor ) );
}

const AddressBookSourceLDAPSchemaDefinition* OAddressBookSourceLDAPData::getSchemaDefinition( 
	const UString& rName )
{
	const AddressBookSourceLDAPSchemaDefinition* pBegin = m_Schemata.getConstArray();
	const AddressBookSourceLDAPSchemaDefinition* pEnd = pBegin + m_Schemata.getLen();
	while( pBegin != pEnd )
	{
		if( pBegin->Name == rName ) return pBegin;
		pBegin++;
	}
	return 0;
}


OAddressBookSourceLDAP::~OAddressBookSourceLDAP()
{
}

XJobFactoryRef OAddressBookSourceLDAP::getJobFactory()
{
	if( !m_xJobFactory.is() )
	{
		UsrAny aAny;
		aAny <<= XJobFactoryRef( this );
		m_xJobFactory = XJobFactoryRef(
			m_xMgr->createInstanceWithArguments( 
				L"stardiv.one.address.SynchronAndAsynchronJobFactory",
				Sequence<UsrAny>( &aAny, 1 ) ), USR_QUERY );
	}
	return m_xJobFactory;
}

XInterfaceRef OAddressBookSourceLDAP::createJob( 
	const UString& rType, const Sequence<UsrAny>& rArgs )
{
	if( rType == L"query" )
		return *new OAddressBookSourceLDAPQueryJob(
			m_xMgr, getConnection(), rType, rArgs );
	else
		return *new OAddressBookSourceLDAPSynchronJob(
			getConnection(), rType, rArgs );
}


XInterfaceRef OAddressBookSourceLDAP::create( 
	const XMultiServiceFactoryRef& xMgr )
{
	return *new OAddressBookSourceLDAP( xMgr );
}


XIdlClassRef OAddressBookSourceLDAP::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"stardiv.one.address.OAddressBookSourceLDAP", 
		OPropertySet::getStaticIdlClass(), 2,
		XAddressBookJobFactorySupplier_getReflection(),
		XJobFactory_getReflection()
		);
	return xClass;
}

BOOL OAddressBookSourceLDAP::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XAddressBookJobFactorySupplier );
	QUERYIFACE( XJobFactory );
	return OPropertySet::queryInterface( aUik, rOut );
}

Sequence<XIdlClassRef>	OAddressBookSourceLDAP::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

const OAddressBookLDAPConnectionRef& OAddressBookSourceLDAP::getConnection()
{
	if( !m_xConnection.is() )
		m_xConnection = new OAddressBookLDAPConnection(
			m_xMgr, this, *this );
	return m_xConnection;
}

void OAddressBookSourceLDAP::setFastPropertyValue_NoBroadcast( 
	INT32 nHandle, const UsrAny& rValue ) THROWS( (Exception) )
{
	OPropertySet::setFastPropertyValue_NoBroadcast( nHandle, rValue );
	m_xConnection = (OAddressBookLDAPConnection*)0;
}

//////////////////////////

OAddressBookLDAPConnection::OAddressBookLDAPConnection( 
	const XMultiServiceFactoryRef& xMgr,
	const XAddressBookJobFactorySupplierRef& xJobFactorySup,
	const OAddressBookSourceLDAPData& rData )
	: m_aData( rData ), m_eState( UNCONNECTED ), m_xJobFactorySup( xJobFactorySup ),
	  m_xMgr( xMgr), m_nNextId( 2 )
{
}


void OAddressBookLDAPConnection::open()
{
	OClearableGuard aGuard( m_aMutex );
	if( m_eState == UNCONNECTED ) 
	{
		m_eState = CONNECTING;
		m_aINetWrapper.newINetLDAPWrapper( m_pFactory );
		if( !m_pFactory ) THROW( RuntimeException() );
		
		m_pFactory->newLDAPConnection( m_xConnection );
		if( !m_xConnection.isValid() ) THROW( RuntimeException() );
		
		if( !m_xConnection->Open( 
			SHOULDTAKEUNICODE( m_aData.m_Server ), String( m_aData.m_Port ), 
			requestCallback, this ) ) THROW( RuntimeException() );
	}
}

INetCoreLDAPFilter* OAddressBookLDAPConnection::createFilters(
	const AddressBookQueryTerm& rTerm, 
	const Sequence<AddressBookSourceLDAPFieldMapping>& rMap )
{
	switch( rTerm.Function )
	{
		// all functions that operate on a field have to be replicated into
		// n filters corresponding to the ldap fields the property is mapped onto
		case AddressBookQueryFunction_PRESENT:
		case AddressBookQueryFunction_EQUALITYMATCH:
		case AddressBookQueryFunction_SUBSTRINGS:
		case AddressBookQueryFunction_APPROXMATCH:
		case AddressBookQueryFunction_LESSOREQUAL:
		case AddressBookQueryFunction_GREATEROREQUAL:
		{
			const UsrAny* pArgs = rTerm.Arguments.getConstArray();
			UString aField;
			if( !(*pArgs >>= aField ) ) THROW( IllegalArgumentException() );
		
			vector<UString> aMappings;
			const AddressBookSourceLDAPFieldMapping* pBegin = rMap.getConstArray();
			const AddressBookSourceLDAPFieldMapping* pEnd = pBegin + rMap.getLen();
			for( ;pBegin != pEnd; pBegin++ )
				if( pBegin->Name == aField ) aMappings.push_back( pBegin->LDAPName );
			// if the addressbook property maps to only one ldap field, create one filter
			if( aMappings.size() <= 1 )
				return createFilter( rTerm, aMappings.size() == 0 ? aField : aMappings[ 0 ], rMap );
			else
			{
				INetCoreLDAPOrFilter* pOrFilter;
				m_pFactory->newLDAPOrFilter( pOrFilter ); 
				for( vector<UString>::const_iterator aIter = aMappings.begin();
					 aIter != aMappings.end(); aIter++ )
				{
					INetCoreLDAPFilter* pSubFilter = createFilter(
						rTerm, *aIter, rMap );
					pOrFilter->SetFilter( *pSubFilter );
					delete pSubFilter;
				}
				return pOrFilter;
			}
		}
		default:
			return createFilter( rTerm, L"", rMap );
	}
}


INetCoreLDAPFilter* OAddressBookLDAPConnection::createFilter(
	const AddressBookQueryTerm& rTerm, const UString& rName, 
	const Sequence<AddressBookSourceLDAPFieldMapping>& rMap )
{
	INetCoreLDAPFilter* pFilter;
	const UsrAny* pArgs = rTerm.Arguments.getConstArray();
	const UsrAny* pEnd = rTerm.Arguments.getConstArray() +  rTerm.Arguments.getLen();
	UString aArg;
	UString aValue;
	switch( rTerm.Function )
	{
		case AddressBookQueryFunction_OR:
		{
			INetCoreLDAPOrFilter* pOrFilter;
			m_pFactory->newLDAPOrFilter( pOrFilter ); 
			pFilter = pOrFilter;
			while( pArgs != pEnd )
			{
				INetCoreLDAPFilter* pSubFilter = createFilters(
					*(const AddressBookQueryTerm*)pArgs->get(), rMap );
				pOrFilter->SetFilter( *pSubFilter );
				delete pSubFilter;
				pArgs++;
			}
			break;
		}
		case AddressBookQueryFunction_AND:
		{
			INetCoreLDAPAndFilter* pAndFilter;
			m_pFactory->newLDAPAndFilter( pAndFilter ); 
			pFilter = pAndFilter;
			while( pArgs != pEnd )
			{
				INetCoreLDAPFilter* pSubFilter = createFilters(
					*(const AddressBookQueryTerm*)pArgs->get(), rMap );
				pAndFilter->SetFilter( *pSubFilter );
				delete pSubFilter;
				pArgs++;
			}
			break;
		}
		case AddressBookQueryFunction_NOT:
		{
			INetCoreLDAPNotFilter* pNotFilter;
			m_pFactory->newLDAPNotFilter( pNotFilter );			
			pFilter = pNotFilter;
			INetCoreLDAPFilter* pSubFilter = createFilters(
				*(const AddressBookQueryTerm*)pArgs->get(), rMap );
			pNotFilter->SetFilter( *pSubFilter );
			delete pSubFilter;
			break;
		}
		case AddressBookQueryFunction_PRESENT:
		{
			INetCoreLDAPPresentFilter* pPresentFilter;
			m_pFactory->newLDAPPresentFilter( pPresentFilter ); 
			pFilter = pPresentFilter;
			pPresentFilter->SetAttributeType( OUStringToString( rName, LDAPCHARSET ) );
			break;
		}
		case AddressBookQueryFunction_EQUALITYMATCH:
		{
			INetCoreLDAPEqualityMatchFilter* pEqualFilter;
			m_pFactory->newLDAPEqualityMatchFilter( pEqualFilter ); 
			pFilter = pEqualFilter;
			*pArgs++ >>= aArg;
			*pArgs++ >>= aValue;
			INetCoreLDAPAttributeValuePair* pPair;
			m_pFactory->newLDAPAttributeValuePair( pPair );
			pPair->SetType( OUStringToString( rName, LDAPCHARSET ) );
			pPair->SetValue( OUStringToString( aValue, LDAPCHARSET ) );
			pEqualFilter->SetAssertion( *pPair );
			delete pPair;
			break;
		}
		case AddressBookQueryFunction_SUBSTRINGS:
		{
			INetCoreLDAPSubstringFilter* pSubFilter;
			m_pFactory->newLDAPSubstringFilter( pSubFilter ); 
			pFilter = pSubFilter;
			pSubFilter->SetAttributeType( OUStringToString( rName, LDAPCHARSET ) );
			pArgs++;
			*pArgs++ >>= aArg;
			if( aArg.len() )
				pSubFilter->SetSubstring( OUStringToString( 
					aArg, LDAPCHARSET ), INETCORELDAP_SUBSTRING_INITIAL );
			for( ;pArgs + 1 != pEnd; pArgs++ )
			{
				*pArgs >>= aArg;
				pSubFilter->SetSubstring( OUStringToString(
					aArg, LDAPCHARSET ), INETCORELDAP_SUBSTRING_ANY );
			}
			*pArgs >>= aArg;
			if( aArg.len() )
				pSubFilter->SetSubstring( OUStringToString(
					aArg, LDAPCHARSET ), INETCORELDAP_SUBSTRING_FINAL );
			break;
		}
		case AddressBookQueryFunction_APPROXMATCH:
		{
			INetCoreLDAPApproxMatchFilter* pAppFilter;
			m_pFactory->newLDAPApproxMatchFilter( pAppFilter ); 
			pFilter = pAppFilter;
			pArgs++;
			*pArgs++ >>= aValue;
			INetCoreLDAPAttributeValuePair* pPair;
			m_pFactory->newLDAPAttributeValuePair( pPair );
			pPair->SetType( OUStringToString( rName, LDAPCHARSET ) );
			pPair->SetValue( OUStringToString( aValue, LDAPCHARSET ) );
			pAppFilter->SetAssertion( *pPair );
			delete pPair;
			break;
		}
		case AddressBookQueryFunction_LESSOREQUAL:
		{
			INetCoreLDAPLessOrEqualFilter* pLEFilter;
			m_pFactory->newLDAPLessOrEqualFilter( pLEFilter ); 
			pFilter = pLEFilter;
			pArgs++;
			*pArgs++ >>= aValue;
			INetCoreLDAPAttributeValuePair* pPair;
			m_pFactory->newLDAPAttributeValuePair( pPair );
			pPair->SetType( OUStringToString( rName, LDAPCHARSET ) );
			pPair->SetValue( OUStringToString( aValue, LDAPCHARSET ) );
			pLEFilter->SetAssertion( *pPair );
			delete pPair;
			break;
		}
		case AddressBookQueryFunction_GREATEROREQUAL:
		{
			INetCoreLDAPGreaterOrEqualFilter* pGEFilter;
			m_pFactory->newLDAPGreaterOrEqualFilter( pGEFilter );
			pFilter = pGEFilter;
			pArgs++;
			*pArgs++ >>= aValue;
			INetCoreLDAPAttributeValuePair* pPair;
			m_pFactory->newLDAPAttributeValuePair( pPair );
			pPair->SetType( OUStringToString( rName, LDAPCHARSET ) );
			pPair->SetValue( OUStringToString( aValue, LDAPCHARSET ) );
			pGEFilter->SetAssertion( *pPair );
			delete pPair;
			break;
		}
		default: THROW( IllegalArgumentException() );
	}
	return pFilter;
}
		
void OAddressBookLDAPConnection::runQueries()
{
	list<OAddressBookSourceLDAPQueryJobRef> aQueued;
	{
		OGuard aGuard( m_aMutex );
		aQueued = m_aQueuedJobs;
		m_aQueuedJobs = list<OAddressBookSourceLDAPQueryJobRef>();
	}

	for( list<OAddressBookSourceLDAPQueryJobRef>::const_iterator aIter = 
			 aQueued.begin(); aIter != aQueued.end(); aIter++ )
	{
		OAddressBookSourceLDAPQueryJob& rJob = *(OAddressBookSourceLDAPQueryJob*)*aIter;
		
		if( !rJob.m_aSchemata.getLen() )
		{
			XAddressBookSchemataSupplierRef xSup(
				getRecordContainer(), USR_QUERY );
			rJob.m_aSchemata = xSup->getSchemata()->getElementNames();
		}
		
		const UString* pSchema = rJob.m_aSchemata.getConstArray();
		const UString* pEnd = pSchema + rJob.m_aSchemata.getLen();
		
		const AddressBookSourceLDAPSchemaDefinition* pSourceSchema 
			= m_aData.m_Schemata.getConstArray();
		const AddressBookSourceLDAPSchemaDefinition* pSourceSchemaEnd = 
			pSourceSchema + m_aData.m_Schemata.getLen();
		
		for(; pSchema != pEnd; pSchema++ )
		{
			// find corresponding source schema
			const AddressBookSourceLDAPSchemaDefinition* pCur;
			for( pCur = pSourceSchema; pCur != pSourceSchemaEnd; pCur++ )
				if( pCur->Name == *pSchema ) break;
			if( pCur != pSourceSchemaEnd )
			{
				// create the LDAP request
				INetCoreLDAPSearchRequestMessage* pSearch;
				if ( m_pFactory->newLDAPSearchRequestMessage( pSearch ) )
				{
					pSearch->SetMessageID( 0 );
					
					INetCoreLDAPFilter* pFilter = createFilters( 
						rJob.m_aTerm, pCur->FieldMappings );
					// if we have a base query, and that to the filter
					if( pCur->BaseQuery.len() )
					{
						XAddressBookQueryParserRef xParser(
							m_xMgr->createInstance( 
								L"stardiv.one.address.AddressBookQueryParser" ), USR_QUERY );
						if( !xParser.is() ) THROW( IllegalArgumentException() );
						Sequence<AddressBookSourceLDAPFieldMapping> aEmptyMap;
						INetCoreLDAPFilter* pBaseQuery = createFilters( 
							xParser->parseTerm( pCur->BaseQuery ), aEmptyMap );
						INetCoreLDAPAndFilter* pAndFilter;
						m_pFactory->newLDAPAndFilter( pAndFilter );
						pAndFilter->SetFilter( *pBaseQuery );
						pAndFilter->SetFilter( *pFilter );
						pFilter = pAndFilter;
					}
					pSearch->SetFilter( *pFilter );
					delete pFilter;
				
					pSearch->SetBaseObject( 
						OUStringToString( 
							rJob.m_aUid.len() ? rJob.m_aUid : pCur->BaseObject, 
							LDAPCHARSET ) );
					pSearch->SetAttributesOnly( FALSE );
				
					const AddressBookSourceLDAPFieldMapping* pBegin = 
						pCur->FieldMappings.getConstArray();
					const AddressBookSourceLDAPFieldMapping* pEnd = 
						pBegin + pCur->FieldMappings.getLen();
					// collect all requested props
					Sequence<UString> aProps = rJob.m_aProperties;
					UString* pFirstProp = aProps.getArray();
					UString* pLastProp = pFirstProp + aProps.getLen();
					sort( pFirstProp, pLastProp, isLess );
					for( ;pBegin != pEnd; pBegin++ ) 
					{
						pair<UString*, UString*> aPair = 
							equal_range( 
								pFirstProp, pLastProp, pBegin->Name, isLess );
						if( aPair.first != aPair.second )
							pSearch->SetAttributeType( OUStringToString( 
								pBegin->LDAPName, LDAPCHARSET ) );
					}
					
					pSearch->SetTimeLimit( m_aData.m_TimeLimit );
					pSearch->SetSizeLimit( m_aData.m_SizeLimit );

					if( rJob.m_aUid.len() )
					{
						pSearch->SetScope      (
							INETCORELDAP_SEARCH_SCOPE_BASEOBJECT);
						pSearch->SetDerefAlias (
							INETCORELDAP_SEARCH_DEREF_FINDING_BASEOBJECT);
					}
					else
					{
						pSearch->SetDerefAlias( INETCORELDAP_SEARCH_DEREF_ALWAYS );
						INetCoreLDAPSearchScope eLDAPScope = 
							INETCORELDAP_SEARCH_SCOPE_WHOLESUBTREE;
						switch( m_aData.m_Scope )
						{
							case AddressBookSourceLDAPScope_WHOLESUBTREE:
								eLDAPScope  = INETCORELDAP_SEARCH_SCOPE_WHOLESUBTREE; break;
							case AddressBookSourceLDAPScope_BASEOBJECT:
								eLDAPScope  = INETCORELDAP_SEARCH_SCOPE_BASEOBJECT; break;
							case AddressBookSourceLDAPScope_SINGLELEVEL:
								eLDAPScope  = INETCORELDAP_SEARCH_SCOPE_SINGLELEVEL; break;
						}
						
						pSearch->SetScope( eLDAPScope );
					}
					rJob.m_aMsgIds.push_back( m_nNextId++ );
					{
						OGuard aGuard( m_aMutex );
						m_aRunningJobs.push_back( 
							OAddressBookSourceLDAPQueryJobRef( &rJob ) );
					}
					m_xConnection->Search( *pSearch );
					delete pSearch;
				}
			}
		}
	}
	m_aQueuedJobs = list<OAddressBookSourceLDAPQueryJobRef>();
}

void OAddressBookLDAPConnection::query( 
	const OAddressBookSourceLDAPQueryJobRef& xJob )
{
	open();
	{
		OGuard aGuard( m_aMutex );
		m_aQueuedJobs.push_back( xJob );
	}
	if( m_eState == READY )
		runQueries();
}

void OAddressBookLDAPConnection::cancel( 
	const OAddressBookSourceLDAPQueryJobRef& xJob )
{
	OClearableGuard aGuard( m_aMutex );
	// if not yet running, remove from list
	list<OAddressBookSourceLDAPQueryJobRef>::iterator aIter;
	for( aIter = m_aQueuedJobs.begin(); aIter != m_aQueuedJobs.end(); aIter++ )
	{
		if( xJob == *aIter )
		{
			m_aQueuedJobs.erase( aIter );
			return;
		}
	}
	// already running so cancel requests
	for( aIter = m_aRunningJobs.begin(); aIter != m_aRunningJobs.end(); 
		 aIter++ )
	{
		if( xJob == *aIter )
		{
			m_aRunningJobs.erase( aIter );
			aGuard.clear();
			for( vector<UINT16>::const_iterator aIter = 
					 xJob->m_aMsgIds.begin(); aIter != xJob->m_aMsgIds.end();
				 aIter++ )
			{
				m_xConnection->Abandon( *aIter );
				m_nNextId++;
			}
			JobEvent aEvent;
			aEvent.Type = JobEventType_ERROR;
			UsrException aExp;
			aEvent.Data <<= CancelledException();
			xJob->m_xCallback->updateJobState( aEvent );
			return;
		}
	}
}

list<OAddressBookSourceLDAPQueryJobRef>::iterator
OAddressBookLDAPConnection::findJob(
	UINT16 nMsgId )
{
	for( list<OAddressBookSourceLDAPQueryJobRef>::iterator aIter = 
			 m_aRunningJobs.begin(); aIter != m_aRunningJobs.end();
		 aIter++ )
	{
		for( vector<UINT16>::const_iterator aMsgIdIter = 
				 (*aIter)->m_aMsgIds.begin();
			 aMsgIdIter != (*aIter)->m_aMsgIds.end(); aMsgIdIter++ )
			if( nMsgId == *aMsgIdIter ) return aIter;
	}
	return m_aRunningJobs.end();
}


XAddressBookRecordContainerRef OAddressBookLDAPConnection::getRecordContainer()
{
	if( !m_xContainr.is() )
	{
		UsrAny aAny;
		aAny <<= m_xJobFactorySup;
		m_xContainr = XAddressBookRecordContainerRef(
			m_xMgr->createInstanceWithArguments( 
				L"stardiv.one.address.AddressBookSourceAccess",
				Sequence<UsrAny>( &aAny, 1 ) ), USR_QUERY );
	}
	return m_xContainr;
}


int OAddressBookLDAPConnection::requestCallback(
	INetCoreLDAPConnection* pConnection, int nReplyCode,
	const void* pReplyData, USHORT nMsgID, void* pSearcher )
{
	return ((OAddressBookLDAPConnection*)pSearcher)->callback(
		pConnection, nReplyCode, pReplyData, nMsgID );
}

int OAddressBookLDAPConnection::callback(
	INetCoreLDAPConnection* pConnection, int nReplyCode,
	const void* pReplyData, USHORT nMsgID )
{
	switch ( nReplyCode )
	{
		case INETCORELDAP_REPLY_CONNECT_DONE:
		{
			m_eState = BINDING;
			m_xConnection->Bind( 
				OUStringToString( m_aData.m_User, LDAPCHARSET ),
				OUStringToString( m_aData.m_Password, LDAPCHARSET ) );
			break;
		}
		case INETCORELDAP_REPLY_NETWORK_ERROR:
		case INETCORELDAP_REPLY_RESOLVER_ERROR:
		case INETCORELDAP_REPLY_CONNECT_ERROR:
		case INETCORELDAP_REPLY_REQUEST_ERROR:
		case INETCORELDAP_REPLY_RESPONSE_ERROR:
		case INETCORELDAP_REPLY_CONNECTION_TERMINATED:
		{
			const OAddressBookSourceLDAPQueryJobRef* pJob = 0;
			list<OAddressBookSourceLDAPQueryJobRef>::iterator aIter;
			{
				OGuard aGuard( m_aMutex );
				aIter = findJob( nMsgID );
				if( aIter != m_aRunningJobs.end() ) pJob = &*aIter;
			}
			JobEvent aEvent;
			aEvent.Type = JobEventType_ERROR;
			aEvent.Data <<= CantConnectException();
			
			// no Job found -> general error -> notify all jobs
			if( !pJob )
			{
				list<OAddressBookSourceLDAPQueryJobRef> aJobs;
				{
					OGuard aGuard( m_aMutex );
					aJobs = m_aQueuedJobs;
 					aJobs.insert( aJobs.end(), m_aRunningJobs.begin(), 
 								  m_aRunningJobs.end() );
					m_aQueuedJobs = m_aRunningJobs = 
						list<OAddressBookSourceLDAPQueryJobRef>();
				}
				for( list<OAddressBookSourceLDAPQueryJobRef>::iterator aIter = 
						 aJobs.begin(); aIter != aJobs.end();
					 aIter++ )
				{
					aEvent.Source = (*aIter);
					(*aIter)->m_xCallback->updateJobState( aEvent );
				}
				m_eState = UNCONNECTED;
				m_nNextId = 2;
				delete m_pFactory;
			}
			else
			{
				aEvent.Source = *pJob;
				(*pJob)->m_xCallback->updateJobState( aEvent );
				{
					OGuard aGuard( m_aMutex );
					aIter = findJob( nMsgID );
					if( aIter != m_aRunningJobs.end() ) 
						m_aRunningJobs.erase( aIter );
				}
			}
			break;
		}
		case INETCORELDAP_REPLY_RESPONSE_DONE:
		{
			if( m_eState == BINDING )
			{
				m_eState = READY;
				runQueries();
				return 1;
			}
			const OAddressBookSourceLDAPQueryJobRef* pJob;
			{
				OClearableGuard aGuard( m_aMutex );
				const OAddressBookSourceLDAPQueryJobRef* pJob = 0;
				list<OAddressBookSourceLDAPQueryJobRef>::iterator 
					aIter = findJob( nMsgID );
				if( aIter != m_aRunningJobs.end() ) pJob = &*aIter;
				if( pJob )
				{
					vector<UString> aVec;
					copySequenceToContainer( (*pJob)->m_aSchemata, aVec );
					m_aRunningJobs.erase( aIter );
					
					vector<UString>::iterator aSchemaIter = aVec.begin();
					vector<UINT16>::iterator aMsgIter = (*pJob)->m_aMsgIds.begin();
					while( aSchemaIter != aVec.end() )
					{
						if( *aMsgIter == nMsgID )
						{
							(*pJob)->m_aMsgIds.erase( aMsgIter );
							aVec.erase( aSchemaIter );
							break;
						}
						aSchemaIter ++;
						aMsgIter++;
					}
					copyContainerToSequence( aVec, (*pJob)->m_aSchemata );
					aGuard.clear();
					// sort and notify result
					if( (*pJob)->m_pSet )
					{
						(*pJob)->m_pSet->getRecords().sort();
						JobEvent aEvent;
						aEvent.Source = *pJob;
						aEvent.Type = JobEventType_DATA;
						for( list<ORecord>::iterator aIter = (*pJob)->m_pSet->getRecords().begin();
							 aIter != (*pJob)->m_pSet->getRecords().end(); aIter++ )
						{
							aEvent.Data <<= OObjectClass<ORecord>::getInstance().getPropertyValues(
								&*aIter );
							(*pJob)->m_xCallback->updateJobState( aEvent );
						}
					}
						
					if( !aVec.size() )
					{
						JobEvent aEvent;
						aEvent.Source = *pJob;
						aEvent.Type = JobEventType_DONE;
						(*pJob)->m_xCallback->updateJobState( aEvent );
					}
				}
			}
			break;
		}
		case INETCORELDAP_REPLY_SEARCHENTRY:
		{
			if ( pReplyData )
			{

				const INetCoreLDAPEntry* pEntry =
					(const INetCoreLDAPEntry*)pReplyData;
				// the fields of the current schema
				Sequence<AddressBookParameteredProperty>* pSchemaFields = 0;
				{
					OClearableGuard aGuard( m_aMutex );
					list<OAddressBookSourceLDAPQueryJobRef>::iterator 
						aIter = findJob( nMsgID );
					if( aIter == m_aRunningJobs.end() ) return 1;
					const OAddressBookSourceLDAPQueryJobRef* pJob = &*aIter;
					const UString* pSchema = 
						(*pJob)->m_aSchemata.getConstArray();
					const UString* pSchemaEnd = pSchema +
						(*pJob)->m_aSchemata.getLen();
					vector<UINT16>::iterator aMsgIter = 
						(*pJob)->m_aMsgIds.begin();

					while( pSchema != pSchemaEnd )
					{
						if( *aMsgIter == nMsgID )
							break;
						aMsgIter++;
						pSchema++;
					}
					aGuard.clear();

					ORecord aRecord;
					aRecord.m_SchemaName = *pSchema;
					aRecord.m_IsRemovable = FALSE;
					String aName;
					pEntry->GetObjectName( aName );
					aRecord.m_Uid = StringToOUString( aName, LDAPCHARSET );
						
					USHORT nCnt = pEntry->GetAttributeCount();
					INetCoreLDAPAttribute* pAttrs = NULL;

						
					vector<AddressBookParameteredPropertyValue>  aValues;
					AddressBookParameteredPropertyValue  aValue;
					Sequence<AddressBookParameteredValue>* pSequence;
					

					aValue.Type = OUString_getReflection()->getIdlClass();
					aValue.IsWritable = FALSE;

					AddressBookParameteredValue aPMValue;
					BOOL bSimulateUid = TRUE;
					USHORT i;
					String aSType;
					for( i = 0; i< nCnt && bSimulateUid; ++i )
					{
						pAttrs = pEntry->GetAttribute( i );
						pAttrs->GetType( aSType );
						if( aSType == "dn" )
							bSimulateUid = FALSE;
					}
					if( bSimulateUid ) nCnt++;

					// get schema definition
					XAddressBookSchemataSupplierRef xSup(
						getRecordContainer(), USR_QUERY );
					UsrAny aProps = xSup->getSchemata()->getByName(
						*pSchema );
					XPropertySetRef xProp;
					if( !(aProps >>= xProp ) ) THROW( RuntimeException() );
					aProps = xProp->getPropertyValue( L"Properties" );
					if( aProps.getReflection() != 
						Sequence<AddressBookParameteredProperty>::getReflection() )
						THROW( RuntimeException() );
					const Sequence<AddressBookParameteredProperty>& aSchemaFields =  
						*(const Sequence<AddressBookParameteredProperty>*)
						aProps.get();

					// consider all ldap properties
					for ( i = 0; i < nCnt; ++i )
					{
						
						String aSType, aSValue;
						USHORT nValCnt;
						if( i < pEntry->GetAttributeCount() )
						{
							pAttrs = pEntry->GetAttribute(i);
							pAttrs->GetType( aSType );
							nValCnt = pAttrs->GetValueCount();
						}
						else 
						{
							pAttrs = 0;
							nValCnt = 1;
							aSType = "dn";
						}
							
						UString aType = StringToOUString( aSType, LDAPCHARSET );
						const AddressBookSourceLDAPSchemaDefinition* pSchemaDefinition = 
							m_aData.getSchemaDefinition( *pSchema );
						const AddressBookSourceLDAPFieldMapping* pFields = 
							pSchemaDefinition->FieldMappings.getConstArray();
						// find corresponding addressbook field
						INT32 nLen = pSchemaDefinition->FieldMappings.getLen();
						for( INT32 nPos = 0; nPos < nLen; nPos++ )
						{
							if( pFields[ nPos ].LDAPName == aType )
							{
								aValue.Name = pFields[ nPos ].Name;
								// if we already have a property with this name, use it
								pSequence = 0;
								for( vector<AddressBookParameteredPropertyValue>::iterator 
										 aIter = aValues.begin();
									 aIter != aValues.end(); aIter++ )
									if( (*aIter).Name == aValue.Name )
									{
										pSequence = &(*aIter).Values;
										break;
									}
								if( !pSequence )
								{
									// copy property definition to property
									const AddressBookParameteredProperty* pParProp = 
										aSchemaFields.getConstArray();
									for( INT32 nPos = aSchemaFields.getLen(); nPos--; )
										if( pParProp[ nPos ].Name == aValue.Name )
										{
											aValue.AddressBookParameteredProperty::operator=(
												pParProp[ nPos ] );
											break;
										}
									
									aValues.push_back( aValue );
									pSequence = &aValues.back().Values;
								}
								aPMValue.Parameters = pFields[ nPos ].Parameters;
								// append values to the sequence in the propertyvalue
								INT32 nLen = pSequence->getLen();
								pSequence->realloc( nLen + nValCnt );
								AddressBookParameteredValue* pValue = pSequence->getArray();
								if( i < pEntry->GetAttributeCount() )
									for ( USHORT j = 0; j < nValCnt; ++j )
									{
										pAttrs->GetValue( aSValue, j );
										aPMValue.Value  <<= StringToOUString( aSValue, LDAPCHARSET );
										pValue[ nLen + j ] = aPMValue;
									}
								else
								{
									aPMValue.Value  <<= aRecord.m_Uid;
									pValue[ nLen ] = aPMValue;
								}
							}
						}
						delete pAttrs;
					}
					
					// copy values to sequence
					sort( aValues.begin(), aValues.end(), isLessProperty );
					copyContainerToSequence( aValues, aRecord.m_Values );
					
					if( !(*pJob)->m_pEval || 
						(*pJob)->m_pEval->evaluateTerm( &aRecord ) )
					{
						if( (*pJob)->m_pSet ) (*pJob)->m_pSet->appendRecord( aRecord);
						else
						{
							JobEvent aEvent;
							aEvent.Source = *pJob;
							aEvent.Type = JobEventType_DATA;
							aEvent.Data <<= 
								OObjectClass<ORecord>::getInstance().getPropertyValues(
									&aRecord );
							(*pJob)->m_xCallback->updateJobState( aEvent );
						}
					}
				}
				break;
			}
		}
	}
	return 1;
}

//////////////////////////////////////////////////////////////

	
OAddressBookSourceLDAPQueryJob::OAddressBookSourceLDAPQueryJob( 
	const XMultiServiceFactoryRef& xMgr, 
	const OAddressBookLDAPConnectionRef& xConn, 
	const UString& rType, const Sequence<UsrAny>& rArgs ) :
	m_xConn( xConn ), m_aType( rType ), m_pSet(0 ), 
	m_pCurrentSchema( 0 ), m_xMgr( xMgr ), m_pEval( 0 )
{
	const UsrAny* pArgs = rArgs.getConstArray();
	if( !(pArgs[ 0 ] >>= m_aProperties ) ||
		!(pArgs[ 1 ] >>= m_aQuery ) ||
		!(pArgs[ 2 ] >>= m_aSortInfo ) ||
		!(pArgs[ 3 ] >>= m_aSchemata ) )
		THROW( IllegalArgumentException() );
	if( m_aSortInfo.getLen() ) m_pSet = new OResultSet( m_aSortInfo );
}

OAddressBookSourceLDAPQueryJob::~OAddressBookSourceLDAPQueryJob()
{
	delete m_pSet;
	delete m_pEval;
}

XIdlClassRef OAddressBookSourceLDAPQueryJob::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"stardiv.one.address.OAddressBookSourceLDAPQueryJob", 
		UsrObject::getUsrObjectIdlClass(), 2,
		XCancellable_getReflection(),
		XAsynchronJob_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookSourceLDAPQueryJob::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookSourceLDAPQueryJob::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XAsynchronJob );
	QUERYIFACE( XCancellable );
	QUERYIFACE( XJob );
	return UsrObject::queryInterface( aUik, rOut );
}

void OAddressBookSourceLDAPQueryJob::cancel()
{
	m_xConn->cancel( this );
}

BOOL OAddressBookSourceLDAPQueryJob::eliminateUidQueries( 
	AddressBookQueryTerm& rTerm, BOOL bReverse )
{
	BOOL bResult = FALSE;
	switch( rTerm.Function )
	{
		case AddressBookQueryFunction_PRESENT:
		case AddressBookQueryFunction_EQUALITYMATCH:
		case AddressBookQueryFunction_SUBSTRINGS:
		case AddressBookQueryFunction_APPROXMATCH:
		case AddressBookQueryFunction_LESSOREQUAL:
		case AddressBookQueryFunction_GREATEROREQUAL:
		{
			if( rTerm.Arguments.getLen() )
			{
				UString aField;
				rTerm.Arguments.getConstArray()[ 0 ] >>= aField;
				if( aField == L"Uid" )
				{
					bResult = TRUE;
					AddressBookQueryTerm aTerm;
					aTerm.Function = AddressBookQueryFunction_PRESENT;
					aTerm.Arguments.realloc( 1 );
					aTerm.Arguments.getArray()[ 0 ] <<= UString( L"objectClass" );
					if( !bReverse )
						rTerm = aTerm;
					else
					{
						rTerm.Function = AddressBookQueryFunction_NOT;
						rTerm.Arguments.realloc( 1 );
						aTerm.Arguments.getArray()[ 0 ] <<= aTerm;
					}
				}
			}
			break;
		}
		case AddressBookQueryFunction_AND:
		case AddressBookQueryFunction_OR:
		case AddressBookQueryFunction_NOT:
		{
			UsrAny* pArgs = rTerm.Arguments.getArray();
			for( INT32 nPos = rTerm.Arguments.getLen(); nPos--; )
			{
				if( pArgs[ nPos ].getReflection() != 
					AddressBookQueryTerm_getReflection() )
					THROW( IllegalArgumentException() );
				if( eliminateUidQueries( 
					*(AddressBookQueryTerm*)pArgs[ nPos ].get(), 
					( rTerm.Function == AddressBookQueryFunction_NOT ) 
					^ bReverse ) )
					bResult = TRUE;
			}
			break;
		}
	}
	return bResult;
}


void OAddressBookSourceLDAPQueryJob::executeAsynchron( 
	const XJobListenerRef& xCallback )
{
	// LDAP does not support empty queries
	if( !m_aQuery.len() ) m_aQuery = L"(objectClass=*)";
//  	{
//  		JobEvent aEvent;
//  		aEvent.Type = JobEventType_DONE;
//  		aEvent.Source = *this;
//  		xCallback->updateJobState( aEvent );
//  	}
//  	else
	XAddressBookQueryParserRef xParser(
		m_xMgr->createInstance( 
			L"stardiv.one.address.AddressBookQueryParser" ), USR_QUERY );
	TRY
		{
			m_aTerm = xParser->parseTerm( m_aQuery );
			OAddressBookEvaluator::normalize( m_aTerm );

			// since the dn is not necessarily a property of the object
			// we simulate searching the dn by setting it as baseobject
			// to keep good speed at searching single entries by dn.
			// to keep it simple we only do this if there is only one equality
			// query on the Uid. in all other cases we substitute the 
			// Uid query part with a true or false expression based on
			// the number of nots preceding the condition in the query tree.
			// this gives us a result set containing the real result set so
			// that we may then evaluate the expressions on the client.

			m_aLocalTerm = m_aTerm;
			if( m_aTerm.Function == AddressBookQueryFunction_EQUALITYMATCH &&
				m_aTerm.Arguments.getLen() == 2 )
			{
				UString aField;
				UsrAny* pArgs = m_aTerm.Arguments.getArray();
				pArgs[ 0 ] >>= aField;
				if( aField == L"Uid" )
					pArgs[ 1 ] >>= m_aUid;
			}
			if( eliminateUidQueries( m_aTerm, FALSE ) && !m_aUid.len())
			{
				m_pEval = new OAddressBookEvaluator( m_aLocalTerm );
				// we have to process the query on the client so we need
				// all fields affected by the query.
				vector<UString> aNeededFields = 
					OAddressBookEvaluator::getFields( m_aTerm );
				vector<UString> aWantedFields;
				copySequenceToContainer( m_aProperties, aWantedFields );
				sort( aWantedFields.begin(), aWantedFields.end(), 
					  isLess );
				aWantedFields.erase(
					unique( aWantedFields.begin(), aWantedFields.end(), 
							UStringEqual() ), aWantedFields.end() );
				INT32 nOldSize = aNeededFields.size();
				aNeededFields.reserve( nOldSize + aWantedFields.size() );
				copy( aWantedFields.begin(), aWantedFields.end(), 
					  back_insert_iterator< vector<UString> >( aNeededFields ) );
				inplace_merge( aNeededFields.begin(), 
							   aNeededFields.begin() + nOldSize, 
							   aNeededFields.end() );
				copyContainerToSequence( 
					aNeededFields, m_aProperties );
			}
		}
	CATCH( IllegalArgumentException, e )
		{
			JobEvent aEvent;
			aEvent.Type = JobEventType_ERROR;
			aEvent.Source = *this;
			aEvent.Data <<= e;
			xCallback->updateJobState( aEvent );
		}
	END_CATCH;
	m_xCallback = xCallback;
	m_xConn->query( this );
}

////////////////////////////////////////////////////////////


inline BOOL isLessFieldMapping( 
	const AddressBookSourceLDAPFieldMapping& r1, 
	const AddressBookSourceLDAPFieldMapping& r2 )
{
	return r1.Name < r2.Name;
}

XIdlClassRef OAddressBookSourceLDAPSynchronJob::getStaticIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		L"stardiv.one.address.OAddressBookSourceLDAPSynchronJob", 
		UsrObject::getUsrObjectIdlClass(), 2,
		XCancellable_getReflection(),
		XSynchronJob_getReflection() );
	return xClass;
}

Sequence<XIdlClassRef>	OAddressBookSourceLDAPSynchronJob::getIdlClasses()
{
	XIdlClassRef pClasses[ 1 ] = { getStaticIdlClass() };
	return Sequence< XIdlClassRef >( pClasses, 1 );
}

BOOL OAddressBookSourceLDAPSynchronJob::queryInterface( Uik aUik, XInterfaceRef & rOut )
{
	QUERYIFACE( XJob );
	QUERYIFACE( XSynchronJob );
	QUERYIFACE( XCancellable );
	return UsrObject::queryInterface( aUik, rOut );
}

UsrAny OAddressBookSourceLDAPSynchronJob::executeSynchron( )
{
	if( m_aType == L"getSchemata" )
	{
		Sequence<AddressBookSourceLDAPSchemaDefinition> aSchemata;
		{
			OGuard aGuard( m_xConn->getMutex() );
			aSchemata = m_xConn->getData().m_Schemata;
		}
		OAddressBookSchemaData aSchema;
		AddressBookParameteredProperty aProperty;
		aProperty.Type = OUString_getReflection()->getIdlClass();

		// iterate over all schemata
		Sequence<Sequence<PropertyValue> > aRet( aSchemata.getLen() );
		Sequence<PropertyValue>* pRet = aRet.getArray();
		
		AddressBookSourceLDAPSchemaDefinition* pDefinitions = 
			aSchemata.getArray();
		UString aName;
		INT32 nPos;
		for( nPos = 0; nPos < aRet.getLen(); nPos++ )
		{
			aSchema.m_Name = pDefinitions[ nPos ].Name;
			Sequence<AddressBookSourceLDAPFieldMapping>& rMapping = 
				pDefinitions[ nPos ].FieldMappings;
			
			// sort Mapping so that parameter combinations belonging
			// to the same property can be done sequencially 
			sort( rMapping.getArray(), rMapping.getArray() + rMapping.getLen(), 
				  isLessFieldMapping );
			aName = L"";
			Sequence<UString> aParameters;
			
			const AddressBookSourceLDAPFieldMapping* pMap = rMapping.getConstArray();
			vector<AddressBookParameteredProperty>   aProps;
			vector<AddressBookPropertyParameterInfo> aInfos;
			AddressBookPropertyParameterInfo aInfo;
			
			for( INT32 nPropPos = 0; nPropPos <= rMapping.getLen(); nPropPos++ )
			{
				const AddressBookSourceLDAPFieldMapping& rMap = pMap[ nPropPos ];
				BOOL bRealProp = nPropPos < rMapping.getLen();
				Sequence<UString> aNewParameters;
				if( bRealProp )
				{
					aNewParameters = rMap.Parameters;
					sort( aNewParameters.getArray(), 
						  aNewParameters.getArray() + aNewParameters.getLen(), isLess );
				}
				if( !bRealProp || aName != rMap.Name  ||
					!isEqual( aParameters, aNewParameters ) )
				{
					if( aInfo.MaxCount != 0 ) 
					{
						aInfo.IsWritable = FALSE;
						
						INT32 nOldParCount = aProperty.Parameters.getLen();
						aProperty.Parameters.realloc( nOldParCount + aInfo.Parameters.getLen() );
						copy( aInfo.Parameters.getConstArray(), 
							  aInfo.Parameters.getConstArray() + aInfo.Parameters.getLen(),
							  aProperty.Parameters.getArray() + nOldParCount );
						inplace_merge( 
							aProperty.Parameters.getArray(),
							aProperty.Parameters.getArray() + nOldParCount,
							aProperty.Parameters.getArray() + 
							aProperty.Parameters.getLen(), isLess );
						aProperty.Parameters.realloc(
							unique(
								aProperty.Parameters.getArray(),
								aProperty.Parameters.getArray() +
								aProperty.Parameters.getLen(), 
								UStringEqual() ) -
							aProperty.Parameters.getArray() );
						
						if( aInfo.MaxCount == SHRT_MAX )
							aProperty.MaxCount = SHRT_MAX;
						else
							aProperty.MaxCount += aInfo.MaxCount;
						aProperty.MinCount += aInfo.MinCount;
						aInfos.push_back( aInfo );
					}
					
					aInfo.MinCount = 0;
					aInfo.MaxCount = SHRT_MAX;
					aInfo.Parameters = aNewParameters;

					if( !bRealProp || aName != rMap.Name )
					{
						if( aName.len() )
						{
							// Name has changed so we have to append aProperty
							aProperty.Name = aName;
							copyContainerToSequence( 
								aInfos, aProperty.AllowedParameterCombinations );
							aProps.push_back( aProperty );
							aProperty.MinCount = 0;
							aProperty.MaxCount = 0;
							aInfos.erase( aInfos.begin(), aInfos.end() );
						}
						if( bRealProp ) aName = rMap.Name;
					}
				}
				if( !bRealProp ) continue;
				if( rMap.IsRequired ) aInfo.MinCount++;
			}
			
			copyContainerToSequence( aProps, aSchema.m_Properties );
			pRet[ nPos ] = 
				OObjectClass<OAddressBookSchemaData>::getInstance().
				getPropertyValues( &aSchema );
		}
		UsrAny aRetAny;
		aRetAny <<= aRet;
		return aRetAny;
	}
	else if( m_aType == L"getProperties" )
	{
		UsrAny aAny;
		aAny <<= Sequence<PropertyValue>();
		return aAny;
	}
	THROW( IllegalArgumentException() );
	return UsrAny();
}
