/*************************************************************************
 *
 *  $RCSfile: xml.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <propset.hxx>

#ifndef __STARDIV_ONE_ADDRESS_XML_HXX__
#include <stardiv/one/address/xml.hxx>
#endif

#ifndef __STARDIV_UNO_IO_STREAM_HXX__
#include <stardiv/uno/io/stream.hxx>
#endif

#ifndef __STARDIV_UNO_LANG_FACTORY_HXX__
#include <stardiv/uno/lang/factory.hxx>
#endif

#ifndef __STARDIV_ONE_UTIL_CLONE_HXX__
#include <stardiv/one/util/clone.hxx>
#endif

#include <stardiv/xml/sax/saxdoch.hxx>


#ifndef _VOS_THREAD_HXX_
#include <vos/thread.hxx>
#endif

#ifndef _VOS_CONDITN_HXX_
#include <vos/conditn.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#include <usr/services.hxx>

#ifdef _USE_NAMESPACE
using namespace vos;
using namespace usr;
#endif


Reflection*	getReflectionFromClass( 
	const XIdlClassRef& xIdlClass );


struct OElement
{
	BOOL              m_bStart;
	UString           m_aName;
	XAttributeListRef m_xAttributes;
	INT32             m_nLine;

};

OPERATORSFORSOLARIS( OElement )


class OXMLReader : 
	public OThread, public UsrObject, public XDocumentHandler, 
	public XAddressBookXMLImport
{
public:
	SMART_UNO_DECLARATION( OXMLReader, UsrObject );
	static XInterfaceRef createInstance( const XMultiServiceFactoryRef& xFact ) {
		return *new OXMLReader( xFact ); }
	OXMLReader( const XMultiServiceFactoryRef& xFact ) : 
		m_xFact( xFact ), m_bDone( FALSE ) {}
	
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();
	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	virtual void setTarget( const UsrAny& rResult );
	virtual UsrAny getResult(); 

	virtual void startDocument(void) THROWS( (SAXException, UsrSystemException) );
    virtual void endDocument(void) THROWS( (SAXException, UsrSystemException) );
    virtual void startElement(const UString& aName, const XAttributeListRef& xAttribs) THROWS( (SAXException, UsrSystemException) );
    virtual void endElement(const UString& aName) THROWS( (SAXException, UsrSystemException) );
    virtual void characters(const UString& aChars) THROWS( (SAXException, UsrSystemException) );
    virtual void ignorableWhitespace(const UString& aWhitespaces) THROWS( (SAXException, UsrSystemException) );
    virtual void processingInstruction(const UString& aTarget, const UString& aData) THROWS( (SAXException, UsrSystemException) );
    virtual void setDocumentLocator(const XLocatorRef& xLocator) THROWS( (SAXException, UsrSystemException) );

protected:
	virtual void run();

private:

	OElement                getHead();
	void                    pushBack( const OElement& rElement );
	
	Reflection* getSubElementReflection( 
		Reflection* pRefl, const void* pDest, const UString& rSubElement );
	void readValue( Reflection* pReflection, void* pDest );
	void setSubElement(
		Reflection* pRefl, void* pDest, const UString& rSubElement, 
		const UsrAny& rAny );


	UsrAny                  m_aException;
	BOOL                    m_bDone;
	OMutex                  m_aMutex;
	UsrAny                  m_aAny;
	
	XLocatorRef             m_xLocator;
	XMultiServiceFactoryRef m_xFact;
	NAMESPACE_STD(list)<OElement>          m_aQueue;
	OCondition              m_aDataAvailable;
};
