/*************************************************************************
 *
 *  $RCSfile: asyncloadthread.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: as $ $Date: 2002/07/29 08:17:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "helper/asyncloadthread.hxx"

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
#include <classes/argumentanalyzer.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_THREADHELPBASE_HXX_
#include <threadhelp/threadhelpbase.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_WRITEGUARD_HXX_
#include <threadhelp/writeguard.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XINTERFACE_HXX_
#include <macros/xinterface.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XTYPEPROVIDER_HXX_
#include <macros/xtypeprovider.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_GENERIC_HXX_
#include <macros/generic.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_DEBUG_HXX_
#include <macros/debug.hxx>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HPP_
#include <com/sun/star/frame/XComponentLoader.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XFRAMELOADER_HPP_
#include <com/sun/star/frame/XFrameLoader.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XLoadEventListener_HPP_
#include <com/sun/star/frame/XLoadEventListener.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_URL_HPP_
#include <com/sun/star/util/URL.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONHANDLER_HPP_
#include <com/sun/star/task/XInteractionHandler.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONREQUEST_HPP_
#include <com/sun/star/task/XInteractionRequest.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONABORT_HPP_
#include <com/sun/star/task/XInteractionAbort.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XINTERACTIONFILTERSELECT_HPP_
#include <com/sun/star/document/XInteractionFilterSelect.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_AMBIGOUSFILTERREQUEST_HPP_
#include <com/sun/star/document/AmbigousFilterRequest.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _THREAD_HXX_
#include <osl/thread.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________

AsyncLoadThread::AsyncLoadThread( const css::uno::Reference< css::frame::XFrame >&       xFrame      ,
                                  const css::uno::Reference< css::frame::XFrameLoader >& xLoader     ,
                                  const css::util::URL                                   aURL        ,
                                  const css::uno::Sequence< css::beans::PropertyValue >& lDescriptor ,
                                        LoadEventListener*                               pListener   )
    : ThreadHelpBase        ( &Application::GetSolarMutex() )
    , ::osl::Thread         (                               )
    , m_xFrame              ( xFrame                        )
    , m_xLoader             ( xLoader                       )
    , m_aURL                ( aURL                          )
    , m_lDescriptor         ( lDescriptor                   )
{
    m_pExternalListener = pListener;
    m_pOwnListener      = NULL     ;

    if (m_pExternalListener==NULL)
    {
        m_pOwnListener = new LoadEventListener();
        m_xListener = css::uno::Reference< css::frame::XLoadEventListener >(*m_pOwnListener,css::uno::UNO_QUERY);
    }
    else
    {
        m_xListener = css::uno::Reference< css::frame::XLoadEventListener >(*m_pExternalListener,css::uno::UNO_QUERY);
    }
}

//_________________________________________________________________________________________________________________

void SAL_CALL AsyncLoadThread::run()
{
    LOG_WARNING( "AsyncLoadThread::run()", "This functionality will may be dangerous. Who tested it :-)" )

    // use ring references between the used loader and the external load event listener explicitly!
    // The can handle this situation by using disposing() events. And we mustn't synchronize that.
    // But we can use the load listener imeplementation later to wait for finishing of the started
    // load operation. So we hold the environment for this reuqest alive (means the frame and the descriptor).
    if (m_pExternalListener!=NULL)
        m_pExternalListener->setBroadcaster(m_xLoader);
    else
        m_pOwnListener->setBroadcaster(m_xLoader);

    m_xLoader->load(m_xFrame       ,
                    m_aURL.Complete,
                    m_lDescriptor  ,
                    m_xListener    );

    if (m_pExternalListener!=NULL)
        m_pExternalListener->waitForFinish();
    else
        m_pOwnListener->waitForFinish();

    // now our onTerminated() method should be called and we release
    // all used ressources then.
    // The ring reference between the listener and the broadcaster was
    // released automaticly inside the listener implementation.
    // See there for further informations.
}

//_________________________________________________________________________________________________________________

void SAL_CALL AsyncLoadThread::onTerminated()
{
    m_xFrame            = css::uno::Reference< css::frame::XFrame >();
    m_xLoader           = css::uno::Reference< css::frame::XFrameLoader >();
    m_aURL              = css::util::URL();
    m_lDescriptor       = css::uno::Sequence< css::beans::PropertyValue >();
    m_xListener         = css::uno::Reference< css::frame::XLoadEventListener >();
    m_pExternalListener = NULL;

    // It's not realy neccessary to delete this pointer directly!
    // Of course - we created it inside our ctor if no external listener was given.
    // But we hold a uno reference to him too. And if we release such reference
    // (and we have it done before), then the memory will be freed automaticly by uno!
    // Forget the pointer - that's it.
    m_pOwnListener      = NULL;
}

} // namespace framework
