/*************************************************************************
 *
 *  $RCSfile: sessionlistener.cxx,v $
 *
 *  $Revision: 1.1.4.2 $
 *
 *  last change: $Author: vg $ $Date: 2004/05/18 09:38:27 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_______________________________________________
// my own includes

#ifndef __FRAMEWORK_SERVICES_TYPEDETECTION_HXX_
#include <services/sessionlistener.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_RESETABLEGUARD_HXX_
#include <threadhelp/resetableguard.hxx>
#endif

#ifndef __FRAMEWORK_PROTOCOLS_H_
#include <protocols.h>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

#include <osl/thread.h>


#include <vcl/svapp.hxx>
#include <tools/urlobj.hxx>
#include <tools/tempfile.hxx>
#include <unotools/tempfile.hxx>
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#include <com/sun/star/lang/XComponent.hpp>
#include <com/sun/star/container/XNameAccess.hpp>
#include <com/sun/star/container/XNameContainer.hpp>
#include <com/sun/star/beans/NamedValue.hpp>
#include <com/sun/star/beans/XPropertySet.hpp>
#include <com/sun/star/frame/XFramesSupplier.hpp>
#include <com/sun/star/frame/XStorable.hpp>
#include <com/sun/star/frame/XComponentLoader.hpp>
#include <com/sun/star/util/XModifiable.hpp>
#include <com/sun/star/util/XChangesBatch.hpp>
#include <osl/time.h>
#include <comphelper/processfactory.hxx>
#include <svtools/pathoptions.hxx>
#include <svtools/internaloptions.hxx>

//_______________________________________________
// interface includes

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

#include <com/sun/star/uno/Sequence.hxx>
//_______________________________________________
// includes of other projects

//_______________________________________________
// namespace

using namespace com::sun::star::uno;
using namespace com::sun::star::util;
using namespace com::sun::star::frame;
using namespace com::sun::star::lang;
using namespace com::sun::star::beans;
using namespace com::sun::star::container;

using namespace rtl;

namespace framework{

//_______________________________________________
// non exported const

//_______________________________________________
// non exported definitions

//_______________________________________________
// declarations

//***********************************************
// XInterface, XTypeProvider, XServiceInfo

DEFINE_XINTERFACE_4(
        SessionListener,
        OWeakObject,
        DIRECT_INTERFACE(css::lang::XTypeProvider),
        DIRECT_INTERFACE(css::lang::XInitialization),
        DIRECT_INTERFACE(css::frame::XSessionManagerListener),
        DIRECT_INTERFACE(css::lang::XServiceInfo))

DEFINE_XTYPEPROVIDER_4(
        SessionListener,
        css::lang::XTypeProvider,
        css::lang::XInitialization,
        css::frame::XSessionManagerListener,
        css::lang::XServiceInfo)

DEFINE_XSERVICEINFO_ONEINSTANCESERVICE(
       SessionListener,
       cppu::OWeakObject,
       SERVICENAME_SESSIONLISTENER,
       IMPLEMENTATIONNAME_SESSIONLISTENER)

DEFINE_INIT_SERVICE(SessionListener,
                    {
                        /* Add special code for initialization here, if you have to use your own instance
                           during your ctor is still in progress! */
                    }
                   )

SessionListener::SessionListener(const css::uno::Reference< css::lang::XMultiServiceFactory >& xSMGR )
        : ThreadHelpBase      (&Application::GetSolarMutex())
        , OWeakObject         (                             )
        , m_xSMGR             (xSMGR                        )
{   
}

SessionListener::~SessionListener()
{
    if (m_rSessionManager.is()) 
    {
        css::uno::Reference< XSessionManagerListener> me(this);
        m_rSessionManager->removeSessionManagerListener(me);
    }
}

void SAL_CALL SessionListener::disposing(const com::sun::star::lang::EventObject&) throw (RuntimeException)
{
}

void SAL_CALL SessionListener::initialize(const Sequence< Any  >& args)
    throw (RuntimeException)
{

    OUString aSMgr = OUString::createFromAscii("com.sun.star.frame.SessionManagerClient");
    if (args.getLength() > 0)
    {
        NamedValue v;
        for (int i = 0; i < args.getLength(); i++)
        {
            if (args[i] >>= v)
            {
                if (v.Name.equalsAscii("SessionManagerName"))
                    v.Value >>= aSMgr;
                else if (v.Name.equalsAscii("SessionManager"))
                    v.Value >>= m_rSessionManager;
            }
        }
    }
    if (!m_rSessionManager.is())
        m_rSessionManager = Reference< XSessionManagerClient >
            (m_xSMGR->createInstance(aSMgr), UNO_QUERY_THROW);
    
   Reference< XSessionManagerListener> me(this);
   m_rSessionManager->addSessionManagerListener(me);

   // configuration provider
   m_cfgProv = Reference< XMultiServiceFactory > (
           m_xSMGR->createInstance(OUString::createFromAscii(
        "com.sun.star.configuration.ConfigurationProvider")),
         UNO_QUERY_THROW);
}   


sal_Bool SAL_CALL SessionListener::doRestore()
    throw (RuntimeException)
{
   // restore a saved session
   return _restoreSession();   
}
struct _workerargs
{
    SessionListener *pSL;
    sal_Bool bShutdown;
    sal_Bool bCancelable;
};

extern "C" {
    static void _doSave_workerfunc(void* arg)
{
    struct _workerargs *pwa = (struct _workerargs *)arg;
    try {
        pwa->pSL->doSaveImpl(pwa->bShutdown, pwa->bCancelable);
        // now we can delete the arg struct
        delete pwa;
    } catch (...)
    {}
}
}

void SAL_CALL SessionListener::doSave( sal_Bool bShutdown, sal_Bool bCancelable )
    throw (RuntimeException)
{
    struct _workerargs *pworkerargs = new struct _workerargs;
    pworkerargs->pSL = this;
    pworkerargs->bShutdown = bShutdown;
    pworkerargs->bCancelable = bCancelable;
    // arg struct will be deleted by the workerthread
    if (osl_createThread(_doSave_workerfunc, pworkerargs) == 0)
        throw RuntimeException();
}

   
void SessionListener::doSaveImpl( sal_Bool bShutdown, sal_Bool bCancelable )
    throw (RuntimeException)
{

    /*
       if document is unnamed 
         - if interaction is possible, ask to save as...
         - else save to temporary location
         - make note of file for reopening
       if document has a name but is unsaved
         - if interaction is possible, ask to save
         - else, save changes to temp file(?)
         - make note of file for reopening
       if document is unmodified, 
         just make a note of it for reopeneing
    */
    if (bShutdown)
    {
        ResetableGuard aGuard(m_aLock);    
        try 
        {
        Reference< ::com::sun::star::frame::XFramesSupplier >
            xDesktop( m_xSMGR->createInstance(
            OUString::createFromAscii("com.sun.star.frame.Desktop")), UNO_QUERY_THROW);

                
        // get backup path
        String aSavePath( SvtPathOptions().GetBackupPath() );
        SvtInternalOptions aOpt;

        Reference< ::com::sun::star::frame::XFrame > xTask;
        Reference< ::com::sun::star::container::XIndexAccess > 
           xList( xDesktop->getFrames(), ::com::sun::star::uno::UNO_QUERY_THROW );
        // number of open frames
        sal_Int32 nCount = xList->getCount();
        // iterate through frames
        for (sal_Int32 i=0; i<nCount; ++i)
        {
        
            ::com::sun::star::uno::Any aVal = xList->getByIndex(i);
            if ( !(aVal>>=xTask) || !xTask.is() ) continue;
            try
            {
                // ask for controller
                Reference< ::com::sun::star::frame::XController > xCtrl = xTask->getController();
                if ( xCtrl.is() )
                {
                    // ask for model
                    Reference< ::com::sun::star::frame::XModel > xModel( xCtrl->getModel(), UNO_QUERY );
                    if (!xModel.is()) continue; //if the component has no model, there is nothing to save

                    // get information from the model
                    OUString aOriginalURL, aPassword, aFilterName, aTitle;

                    // document url...
                    aOriginalURL = INetURLObject(xModel->getURL()).GetMainURL(INetURLObject::DECODE_WITH_CHARSET);

                    // get the media descriptor and retrieve title, filter name and password
                    Sequence < PropertyValue > aArgs( xModel->getArgs() );
                    sal_Int32 nProps = aArgs.getLength();
                    for ( sal_Int32 nProp = 0; nProp<nProps; nProp++ )
                    {
                        const PropertyValue& rProp = aArgs[nProp];
                        if( rProp.Name == OUString(RTL_CONSTASCII_USTRINGPARAM("FilterName")) )
                            rProp.Value >>= aFilterName;
                        if( rProp.Name == OUString(RTL_CONSTASCII_USTRINGPARAM("Password")) )
                            rProp.Value >>= aPassword;
                        if( rProp.Name == OUString(RTL_CONSTASCII_USTRINGPARAM("Title")) )
                                rProp.Value >>= aTitle;
                    }
                
                    // url to which the document was saved (if it has to be saved)
                    OUString aSaveURL;
                    
                    // is the document in a modified state?
                    Reference< XModifiable > xModifiable(xModel, UNO_QUERY);
                    if (xModifiable.is() && xModifiable->isModified())
                    {
                        // save modified files to temporary location
                        Reference< XStorable > xStor( xModel, UNO_QUERY );
                        if (xStor.is())
                        {
                            String aExt( OUString::createFromAscii(".sav") );
                            ::utl::TempFile aTempFile( OUString::createFromAscii("ssn") ,
                                &aExt, &aSavePath );
                            aSaveURL = aTempFile.GetURL();                        

                            // if the document was loaded with a password, it should be
                            // stored with password
                            if ( aPassword.getLength() )
                            {
                                Sequence < PropertyValue > aSaveArgs(1);
                                aSaveArgs[0].Name = OUString::createFromAscii("Password");
                                aSaveArgs[0].Value <<= aPassword;
                                xStor->storeToURL(aSaveURL, aSaveArgs);
                            }
                            else 
                            {
                                xStor->storeToURL(aSaveURL, Sequence < PropertyValue >());
                            }
                            // set document to unmodified, so the user won't be asked to 
                            // save again, when queryExit is called at the desktop service
                            xModifiable->setModified(sal_False);
                            
                        }
                    }
                    
                    // remember what to put in registry                
                    SessionItem_t item;
                    item.Title = aTitle;
                    item.Filter = aFilterName;
                    item.OriginalURL = aOriginalURL;
                    item.SaveURL = aSaveURL;
                    m_sessionList.push_back(item);
                        
                }                
            } catch (::com::sun::star::uno::Exception& e) {
                // not much we can do
                // we continue and try to save other documents
                OString aMsg = OUStringToOString(e.Message, RTL_TEXTENCODING_UTF8);
                OSL_ENSURE(sal_False, aMsg.getStr());
            }
        }         
        } catch (com::sun::star::uno::Exception& e) {
            // got no desktop service
            OString aMsg = OUStringToOString(e.Message, RTL_TEXTENCODING_UTF8);
            OSL_ENSURE(sal_False, aMsg.getStr());
        }
        _saveSession();
    } // if bShutdown
    m_rSessionManager->saveDone(this);
}

void SAL_CALL SessionListener::approveInteraction( sal_Bool bInteractionGranted )
    throw (RuntimeException)
{
    if (_pcInteract != NULL)
        osl_setCondition(*_pcInteract);
}

void SessionListener::shutdownCanceled()
    throw (RuntimeException)
{
    if (_pcCancelShutdown != NULL)
        osl_setCondition(*_pcCancelShutdown);
}

sal_Bool SessionListener::_restoreSession()
{
    // look into session list
    sal_Bool result = sal_False;
    try
    {
       Sequence< Any > args(1);
        args[0] <<= OUString::createFromAscii("org.openoffice.Office.Common/Internal/SessionList");
        Reference< XNameContainer > aContainer(
            m_cfgProv->createInstanceWithArguments(OUString::createFromAscii(
            "com.sun.star.configuration.ConfigurationUpdateAccess"), args), UNO_QUERY_THROW);
        Sequence< OUString > names = aContainer->getElementNames();

       
        for (sal_Int32 i = 0; i < names.getLength(); i++)
        {
            OUString aName =  names[i];
            Reference< XPropertySet> aSet;
            if (aContainer->getByName(aName) >>= aSet)
            {
                OUString aTitle , aFilter, aOriginalURL, aSaveURL;
                aSet->getPropertyValue(OUString::createFromAscii("Title")) >>= aTitle;
                aSet->getPropertyValue(OUString::createFromAscii("Filter")) >>= aFilter;
                aSet->getPropertyValue(OUString::createFromAscii("OriginalURL")) >>= aOriginalURL;
                aSet->getPropertyValue(OUString::createFromAscii("SaveURL")) >>= aSaveURL;

                // load component from url and stuff...
                Sequence < PropertyValue > aArgs( 1 );
                aArgs[0].Name = ::rtl::OUString::createFromAscii("Referer");
                aArgs[0].Value <<= ::rtl::OUString::createFromAscii("private:user");
                OUString aLoadURL;
                if (aSaveURL.getLength() > 0)
                {
                    aArgs.realloc(3);
                    aArgs[1].Name = OUString::createFromAscii("AsTemplate");
                    aArgs[2].Name = OUString::createFromAscii("SalvagedFile");
                    if (aOriginalURL.getLength() > 0)
                    {
                        aArgs[1].Value <<= sal_False;
                        aArgs[2].Value <<= aOriginalURL;
                    } 
                    else
                    {
                        // previously unsaved file (UnnamedX)
                        aArgs[1].Value <<= sal_True;
                        aArgs[2].Value <<= OUString();
                   }
                    aLoadURL = aSaveURL;
                }
                else
                    aLoadURL = aOriginalURL;

                if ( aLoadURL.getLength() > 0)
                {
                    Reference< XComponentLoader >
                        xDesktop( m_xSMGR->createInstance(
                        OUString::createFromAscii("com.sun.star.frame.Desktop")), UNO_QUERY_THROW);
                    Reference< XComponent > xDoc = xDesktop->loadComponentFromURL(
                            aLoadURL, OUString::createFromAscii("_default"), 0, aArgs);

                    result = sal_True;

                    // set filter
                    if (xDoc.is() && aFilter.getLength())
                    {
                        // put the real filter name into the documents media descriptor
                        Reference< XModel > xModel( xDoc, UNO_QUERY );
                        Sequence< PropertyValue > sArgs = xModel->getArgs();
                        sal_Int32 nArgs = sArgs.getLength();
                        sal_Int32 nFilterProp = nArgs;
                        for ( sal_Int32 n=0; n<nArgs; n++ )
                        {
                            PropertyValue& rProp = sArgs[n];
                            if ( rProp.Name.compareToAscii("FilterName") == COMPARE_EQUAL )
                            {
                                nFilterProp = n;
                                break;
                            }
                        }
                        if ( nFilterProp == nArgs )
                        {
                            // currently no filter set
                            sArgs.realloc( nArgs+1 );
                            sArgs[nFilterProp].Name = ::rtl::OUString::createFromAscii("FilterName");
                        }
                        sArgs[nFilterProp].Value <<= aFilter;                    
                        xModel->attachResource( ::rtl::OUString( aOriginalURL ), sArgs );
                    }
                }
                // delete from list
                aContainer->removeByName(aName);
            }
        }
        // write cleared list 
        Reference< XChangesBatch >(aContainer, UNO_QUERY_THROW)->commitChanges();
     } catch (com::sun::star::uno::Exception& e) {
        OString aMsg = OUStringToOString(e.Message, RTL_TEXTENCODING_UTF8);
        OSL_ENSURE(sal_False, aMsg.getStr());
    }
    return result;
}


void SessionListener::_saveSession()
{
    try
    {
        Sequence< Any > args(1);
        args[0] <<= OUString::createFromAscii("org.openoffice.Office.Common/Internal/SessionList");
        Reference< XNameContainer > aContainer(
            m_cfgProv->createInstanceWithArguments(OUString::createFromAscii(
            "com.sun.star.configuration.ConfigurationUpdateAccess"), args), UNO_QUERY_THROW);
        Reference< XSingleServiceFactory > aFactory(aContainer, UNO_QUERY_THROW);

        sal_Int32 index = 0;
        SessionList_t::const_iterator  iter = m_sessionList.begin();
        while ( iter != m_sessionList.end() )
        {
            OUString aName = OUString::createFromAscii("n") + OUString::valueOf(index, 10);


            Reference< XPropertySet > aSet(aFactory->createInstance(), UNO_QUERY_THROW);
            aSet->setPropertyValue(OUString::createFromAscii("Title"), makeAny(iter->Title));
            aSet->setPropertyValue(OUString::createFromAscii("Filter"), makeAny(iter->Filter));
            aSet->setPropertyValue(OUString::createFromAscii("OriginalURL"), makeAny(iter->OriginalURL));
            aSet->setPropertyValue(OUString::createFromAscii("SaveURL"), makeAny(iter->SaveURL));
            aContainer->insertByName(aName, makeAny(aSet));            
            
            // next entry...
            index++;
            iter++;
        }                
        // persist
        Reference< XChangesBatch >(aContainer, UNO_QUERY_THROW)->commitChanges();
        m_sessionList.erase(m_sessionList.begin(), m_sessionList.end()); 
        // clear vector...
        
    } catch (com::sun::star::uno::Exception& e) {
        OString aMsg = OUStringToOString(e.Message, RTL_TEXTENCODING_UTF8);
        OSL_ENSURE(sal_False, aMsg.getStr());
    }
}

void SessionListener::_doInteraction(
        const OUString& title, const OUString& url, sal_Bool bCanceable, sal_Bool* save, sal_Bool* cancel)
{
}

sal_Bool SessionListener::_cancelShutdown()
{
    oslCondition c;
    _pcCancelShutdown = &c;
    TimeValue t;
    t.Seconds = 5;
    t.Nanosec = 0;
    m_rSessionManager->cancelShutdown();
    sal_Bool b = osl_waitCondition(c, &t);
    _pcCancelShutdown = NULL;
    return b;
}

sal_Bool SessionListener::_requestInteraction()
{
    oslCondition c;
    _pcInteract = &c;
    TimeValue t;
    t.Seconds = 5;
    t.Nanosec = 0;
    m_rSessionManager->queryInteraction(Reference<XSessionManagerListener>(this));
    sal_Bool b = osl_waitCondition(c, &t);
    _pcInteract = NULL;
    return b;
}

void SessionListener::_finishInteraction()
{
    m_rSessionManager->interactionDone(Reference< XSessionManagerListener >(this));
}

}
