/*************************************************************************
 *
 *  $RCSfile: test.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: pl $ $Date: 2001/09/04 17:20:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <crypt.hxx>

#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
// -----------------------------------------------------------------------

class MyApp : public Application
{
public:
	void Main( );
};

// -----------------------------------------------------------------------

MyApp aMyApp;

// -----------------------------------------------------------------------

class MyWin : public WorkWindow
{
public:
		 MyWin( Window* pParent, WinBits aWinStyle ) :
			 WorkWindow(pParent, aWinStyle) {}

	void Paint( const Rectangle& );
	void Resize();

	void MouseButtonDown( const MouseEvent& rMEvt );
	void KeyInput( const KeyEvent& rKEvt );
};

// -----------------------------------------------------------------------

void MyApp::Main( )
{
	MyWin aMainWin( NULL, WB_APP | WB_STDWORK );

	aMainWin.SetText( "Star-View - Workbench" );
	aMainWin.Show();

	Execute();
}

// -----------------------------------------------------------------------

void MyWin::Paint( const Rectangle& )
{
//	  String f1name( "tst.txt" ), f2name( "tst.out" ), f3name( "tst.bak" );
	char f1name[]="tst.txt\0" , f2name[]="tst.out\0", f3name[]="tst.bak\0", fkey[]="12345\0";
//	  String fname( "DLL Nix Gut : " ), fkey( "12345" );
	String fname( "DLL Nix Gut : " );
	ULONG nBackErr;


	if(!(nBackErr=cryptit((char *) &f1name, (char *) &f2name,
		(char *) &fkey, TRUE))) fname="DLL Cryp : ";
	String ErrStr(nBackErr);
	fname+=ErrStr;
	fname+="  ";

	if(!(nBackErr=cryptit((char *) &f2name,(char *) &f3name,
		(char *) &fkey, FALSE))) fname+=" - DLL Back : ";
	fname+=ErrStr;

	Size  aWinSize	= GetOutputSizePixel();
	Size  aTextSize = GetTextSize( fname );
	Point aPos( aWinSize.Width() / 2  - aTextSize.Width() / 2,
				aWinSize.Height() / 2 - aTextSize.Height() / 2 );

	DrawText( aPos, fname );
}

// -----------------------------------------------------------------------

void MyWin::Resize()
{
	Invalidate();
}

// -----------------------------------------------------------------------

void MyWin::MouseButtonDown( const MouseEvent& )
{
}

// -----------------------------------------------------------------------

void MyWin::KeyInput( const KeyEvent& rKEvt )
{
	WorkWindow::KeyInput( rKEvt );
}
