/*************************************************************************
 *
 *  $RCSfile: agent.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:30:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdlib.h>
#include <string.h>

#ifndef _SVDLG_HXX
#include <svdlg.hxx>
#endif

#ifndef _SVCTRL_HXX
#include <svctrl.hxx>
#endif

#ifndef _SVCTRL2_HXX
#include <svctrl2.hxx>
#endif

#include <svsound.hxx>

#include <urlobj.hxx>

#include "agsdkdll.hxx"

///////////////////////////////////////////////////////////////////////////////
//	Test AgentDlg
//

#define BTN_CHAPI_SHUTDOWN			1
#define BTN_CHAPI_ADDCHITEM			2
#define BTN_CHAPI_DELCHITEM			3
#define BTN_CHAPI_SETTRANS			4
#define BTN_CHAPI_SETCHANNEL		5
#define BTN_CHAPI_SETCHANNELNAME	6
#define BTN_CHAPI_SETUPDPERIODE		7
#define BTN_CHAPI_SETAGENTNAME		8

class AgentDlg : public ModelessDialog
{
	ToolBox*			pBox;
	MultiLineEdit*		pEdit;
	RadioButton*		pRBFile;
	RadioButton*		pRBMemory;

	AgentInst 			pTickerInst;
	ChannelApiFncs* 	pChApi;
	BOOL 				bGetData;

	char*				pTextBuffer;

	DECL_LINK(SelectHdl, ToolBox*);
public:
	AgentDlg(AgentInst pInst, ChannelApiFncs* pChannelFncs);
	~AgentDlg();

	virtual BOOL	Close();

	void			SetEditText(const String& rStr) { pEdit->SetText(rStr); }

	BOOL			RequestAsFile() const { return pRBFile->IsChecked(); }

	void			SetDataPermission(BOOL bNew) { bGetData = bNew; }
	BOOL			GetDataPermission() const { return bGetData; }
	AgentInst 		GetInst() const { return pTickerInst; }
	ChannelApiFncs*	GetChApi() const { return pChApi; }

	char*			GetTextBuffer() { return pTextBuffer; }
	void			SetTextBuffer(char* pBuf) { pTextBuffer = pBuf; }
};

AgentDlg::AgentDlg(AgentInst pInst, ChannelApiFncs* pChannelFncs) :
	ModelessDialog( NULL )
{
	pTickerInst	= pInst;
	pChApi		= pChannelFncs;
	bGetData 	= TRUE;

	pTextBuffer = NULL;

	SetSizePixel( Size(500,400) );
	SetText( "StarDivision Sammelruf" );
	SetBackgroundBrush( Brush(Color(COL_LIGHTGREEN)) );

	pRBFile		= new RadioButton(this);
	pRBMemory	= new RadioButton(this);

	pRBFile->SetPosSizePixel( Point(5, 60), Size(200, 12) );
	pRBMemory->SetPosSizePixel( Point(5, 75), Size(200, 12) );

	pRBFile->SetText( "Local File Stream" );
	pRBMemory->SetText( "Memory Stream" );

	pRBMemory->Check(TRUE);

	pEdit = new MultiLineEdit( this, WB_HSCROLL | WB_VSCROLL | WB_BORDER );
	pEdit->SetReadOnly( TRUE );
	pEdit->SetPosSizePixel( Point(10,110), Size(475, 255) );

	pBox = new ToolBox( this, WB_SVLOOK | WB_BORDER | WB_LINESPACING );
	pBox->SetLineCount( 2 );

	pBox->InsertItem( BTN_CHAPI_SHUTDOWN,	"fncShutDownAgent" );
	pBox->InsertItem( BTN_CHAPI_ADDCHITEM,	"fncAddChannelItem" );
	pBox->InsertItem( BTN_CHAPI_DELCHITEM,	"fncDelChannelItem" );
	pBox->InsertItem( BTN_CHAPI_SETTRANS,	"fncSetTransmitter" );
	pBox->InsertItem( BTN_CHAPI_SETCHANNEL,	"fncSetChannel" );
	pBox->InsertBreak();
	pBox->InsertItem( BTN_CHAPI_SETCHANNELNAME,	"fncSetChannelName" );
	pBox->InsertItem( BTN_CHAPI_SETUPDPERIODE,	"fncSetUpdPeriode" );
	pBox->InsertItem( BTN_CHAPI_SETAGENTNAME,	"fncSetChannelAgentName" );

	Size aSz( pBox->CalcWindowSizePixel() );
	pBox->SetSizePixel( aSz );
	pBox->SetSelectHdl(LINK(this, AgentDlg, SelectHdl));

//	pBox->Show();
	pEdit->Show();
//	pRBFile->Show();
//	pRBMemory->Show();
}

AgentDlg::~AgentDlg()
{
	delete pEdit;
	delete pBox;
	delete pRBFile;
	delete pRBMemory;
}

BOOL AgentDlg::Close()
{
	pChApi->fncShutDownAgent(pTickerInst);
	return TRUE;
}

IMPL_LINK( AgentDlg, SelectHdl, ToolBox*, pBox )
{
	USHORT nItemId = pBox->GetCurItemId();
	switch ( nItemId )
	{
		case BTN_CHAPI_SHUTDOWN : {
				pChApi->fncShutDownAgent(pTickerInst);
			} break;

		case BTN_CHAPI_ADDCHITEM : {
				pChApi->fncAddChannelItem(pTickerInst, "TestAddChannel",
					"http://www.stardiv.de/", "/channels/sdi/", 60, "TestAgent" );
			} break;

		case BTN_CHAPI_DELCHITEM : {
				pChApi->fncDelChannelItem(pTickerInst, "TestAddChannel" );
			} break;

		case BTN_CHAPI_SETTRANS : {
				pChApi->fncSetTransmitter(pTickerInst, "TestAddChannel",
					"http://ok.stardiv.de" );
			} break;

		case BTN_CHAPI_SETCHANNEL : {
				pChApi->fncSetChannel(pTickerInst, "TestAddChannel",
					"/channel/OK/" );
			} break;

		case BTN_CHAPI_SETCHANNELNAME : {
				pChApi->fncSetChannelName(pTickerInst, "TestAddChannel",
					"TestAddChannelRenamed" );
			} break;

		case BTN_CHAPI_SETUPDPERIODE : {
				pChApi->fncSetUpdPeriode(pTickerInst, "TestAddChannel", 120 );
			} break;

		case BTN_CHAPI_SETAGENTNAME : {
				pChApi->fncSetChannelAgentName(pTickerInst, "TestAddChannel",
					 "TestAgentRenamed" );
			} break;
	}
	return 1;
}

///////////////////////////////////////////////////////////////////////////////
//	AgentAPI
//

static AgentDlg* pDlg;

void _SV_CALL InitAgent(AgentInst pInst, ChannelApiFncs* pChannelFncs)
{
	pChannelFncs->fncSetUpdPeriode(pInst, "StarDivision Sammelruf", 30 );

	pDlg = new AgentDlg( pInst, pChannelFncs );
	pDlg->Show();
}

void  _SV_CALL ShutDownAgent()
{
	delete pDlg;
}

unsigned char _SV_CALL NewDataPermission(const char* pChannelName)
{
	return pDlg->GetDataPermission();
}

void  _SV_CALL NewData(const char* pChannelName, const char* pURL)
{
	pDlg->SetDataPermission(FALSE);

	if( pDlg->RequestAsFile() )
	{
		INetURLObject aObj( pURL );
		String aLocalFile;

		FileDialog* pFileDialog = new FileDialog( NULL, WB_SAVEAS );
		pFileDialog->SetPath(aObj.GetLastName());
		pFileDialog->Execute();
		aLocalFile = pFileDialog->GetPath();
		delete pFileDialog;

		pDlg->GetChApi()->fncGetChannelObj(pDlg->GetInst(), pURL, AS_LOCAL_FILE, aLocalFile );
	}
	else
		pDlg->GetChApi()->fncGetChannelObj(pDlg->GetInst(), pURL, AS_MEMORY, NULL );
}

void _SV_CALL NotifyChannelObjFile(const char* pURL, const char* pLocalFileName)
{
	pDlg->GetChApi()->fncSetLastSuccUpd(pDlg->GetInst());
	pDlg->SetDataPermission(TRUE);
	pDlg->SetEditText( "" );
}

void _SV_CALL NotifyChannelObjData(const char* pURL, void* pBuffer,
	long nOffset, long nLen, long nTotalSize )
{
	char* pTextBuffer = pDlg->GetTextBuffer();
	if( nOffset == 0 )
	{
		if( pTextBuffer )
			delete pTextBuffer;
		pTextBuffer = new char [nTotalSize + 1];
		memset( pTextBuffer, 0, nTotalSize + 1 );
		pDlg->SetTextBuffer( pTextBuffer );
	}

	memcpy( &(((char*)pTextBuffer)[nOffset]), pBuffer, nLen );

	if( nOffset + nLen == nTotalSize )
	{
		String aMsg( pTextBuffer );
		aMsg.ConvertLineEnd();
		pDlg->SetEditText( aMsg );
		pDlg->GetChApi()->fncSetLastSuccUpd(pDlg->GetInst());
		pDlg->SetDataPermission(TRUE);
		Sound::Beep();
	}
}

void _SV_CALL RegisterChannels(AgentInst pInst, ChannelApiFncs* pChApi)
{
	pChApi->fncAddChannelItem(pInst,
		"StarDivision Sammelruf",
		"http://www.stardiv.de/",
		"intern/data/transmitter.dat",
		30,
		"Ticker" );
}

void _SV_CALL RegisterUpdateTransmitter(AgentInst pInst, ChannelApiFncs* pChApi)
{
	pChApi->fncSetUpdateTransmitter(pInst,
		"http://ok.stardiv.de/sammel/updates/SammelrufUpdate.txt" );
}

