/*************************************************************************
 *
 *  $RCSfile: unowinreg.c,v $
 *
 *  $Revision: 1.1.4.1 $
 *
 *  last change: $Author: vg $ $Date: 2004/03/30 14:27:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <Windows.h>
#include <jni.h>

BOOL __stdcall _DllMainCRTStartup(
    HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
    return TRUE;
}

JNIEXPORT jboolean JNICALL 
    Java_com_sun_star_lib_loader_WinRegKey_winreg_1RegOpenClassesRoot(
    JNIEnv *env, jclass cls, jlongArray hkresult)
{
    jboolean ret = JNI_FALSE;
    PHKEY phkey = (PHKEY)(*env)->GetLongArrayElements(env, hkresult, 0);
    if (RegOpenKeyEx(HKEY_CLASSES_ROOT, NULL, 0, KEY_READ, phkey) 
        == ERROR_SUCCESS)
        ret = JNI_TRUE;
    (*env)->ReleaseLongArrayElements(env, hkresult, (jlong *)phkey, 0);
    return ret;
}

JNIEXPORT jboolean JNICALL 
    Java_com_sun_star_lib_loader_WinRegKey_winreg_1RegOpenCurrentConfig(
    JNIEnv *env, jclass cls, jlongArray hkresult)
{
    jboolean ret = JNI_FALSE;
    PHKEY phkey = (PHKEY)(*env)->GetLongArrayElements(env, hkresult, 0);
    if (RegOpenKeyEx(HKEY_CURRENT_CONFIG, NULL, 0, KEY_READ, phkey) 
        == ERROR_SUCCESS)
        ret = JNI_TRUE;
    (*env)->ReleaseLongArrayElements(env, hkresult, (jlong *)phkey, 0);
    return ret;
}

JNIEXPORT jboolean JNICALL 
    Java_com_sun_star_lib_loader_WinRegKey_winreg_1RegOpenCurrentUser(
    JNIEnv *env, jclass cls, jlongArray hkresult)
{
    jboolean ret = JNI_FALSE;
    PHKEY phkey = (PHKEY)(*env)->GetLongArrayElements(env, hkresult, 0);
    if (RegOpenKeyEx(HKEY_CURRENT_USER, NULL, 0, KEY_READ, phkey) 
        == ERROR_SUCCESS)
        ret = JNI_TRUE;
    (*env)->ReleaseLongArrayElements(env, hkresult, (jlong *)phkey, 0);
    return ret;
}

JNIEXPORT jboolean JNICALL 
    Java_com_sun_star_lib_loader_WinRegKey_winreg_1RegOpenLocalMachine(
    JNIEnv *env, jclass cls, jlongArray hkresult)
{
    jboolean ret = JNI_FALSE;
    PHKEY phkey = (PHKEY)(*env)->GetLongArrayElements(env, hkresult, 0);
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, NULL, 0, KEY_READ, phkey) 
        == ERROR_SUCCESS)
        ret = JNI_TRUE;
    (*env)->ReleaseLongArrayElements(env, hkresult, (jlong *)phkey, 0);
    return ret;
}

JNIEXPORT jboolean JNICALL 
    Java_com_sun_star_lib_loader_WinRegKey_winreg_1RegOpenUsers(
    JNIEnv *env, jclass cls, jlongArray hkresult)
{
    jboolean ret = JNI_FALSE;
    PHKEY phkey = (PHKEY)(*env)->GetLongArrayElements(env, hkresult, 0);
    if (RegOpenKeyEx(HKEY_USERS, NULL, 0, KEY_READ, phkey) == ERROR_SUCCESS)
        ret = JNI_TRUE;
    (*env)->ReleaseLongArrayElements(env, hkresult, (jlong *)phkey, 0);
    return ret;
}

JNIEXPORT jboolean JNICALL 
    Java_com_sun_star_lib_loader_WinRegKey_winreg_1RegOpenKeyEx(
    JNIEnv *env, jclass cls, jlong parent, jstring name, jlongArray hkresult)
{    
    jboolean ret = JNI_FALSE;
    const char *namestr = (*env)->GetStringUTFChars(env, name, 0);
    PHKEY phkey = (PHKEY)(*env)->GetLongArrayElements(env, hkresult, 0);
    if (RegOpenKeyEx((HKEY)parent, namestr, 0, KEY_READ, phkey) 
        == ERROR_SUCCESS)
        ret = JNI_TRUE;
    (*env)->ReleaseStringUTFChars(env, name, namestr);
    (*env)->ReleaseLongArrayElements(env, hkresult, (jlong *)phkey, 0);
    return ret;
}


JNIEXPORT jboolean JNICALL 
    Java_com_sun_star_lib_loader_WinRegKey_winreg_1RegCloseKey(
    JNIEnv *env, jclass cls, jlong hkey)
{
    jboolean ret = JNI_FALSE;
    if (RegCloseKey((HKEY)hkey) == ERROR_SUCCESS)
        ret = JNI_TRUE;
    return ret;
}

JNIEXPORT jboolean 
    JNICALL Java_com_sun_star_lib_loader_WinRegKey_winreg_1RegQueryValueEx(
    JNIEnv *env, jclass cls, jlong hkey, jstring value, jlongArray type,
    jbyteArray data, jlongArray size)
{
    jboolean ret = JNI_FALSE;
    const char* valuestr = (*env)->GetStringUTFChars(env, value, 0);
    LPDWORD ptype = (LPDWORD)(*env)->GetLongArrayElements(env, type, 0);
    LPBYTE  pdata = (LPBYTE)(*env)->GetByteArrayElements(env, data, 0);
    LPDWORD psize = (LPDWORD)(*env)->GetLongArrayElements(env, size, 0);
    if (RegQueryValueEx((HKEY)hkey, valuestr, NULL, ptype, pdata, psize) 
        == ERROR_SUCCESS)
        ret = JNI_TRUE;
    (*env)->ReleaseStringUTFChars(env, value, valuestr);
    (*env)->ReleaseLongArrayElements(env, type, (jlong *)ptype, 0);
    (*env)->ReleaseByteArrayElements(env, data, (jbyte *)pdata, 0);
    (*env)->ReleaseLongArrayElements(env, size, (jlong *)psize, 0);
    return ret;
}

JNIEXPORT jboolean JNICALL 
    Java_com_sun_star_lib_loader_WinRegKey_winreg_1RegQueryInfoKey(
    JNIEnv *env, jclass cls, jlong hkey, jlongArray subkeys, 
    jlongArray maxSubkeyLen, jlongArray values, jlongArray maxValueNameLen,
    jlongArray maxValueLen, jlongArray secDescriptor)
{
    jboolean ret = JNI_FALSE;
    LPDWORD psubkeys = (LPDWORD)(*env)->GetLongArrayElements(env, subkeys, 0);
    LPDWORD pmaxSubkeyLen = 
        (LPDWORD)(*env)->GetLongArrayElements(env, maxSubkeyLen, 0);
    LPDWORD pvalues = (LPDWORD)(*env)->GetLongArrayElements(env, values, 0);
    LPDWORD pmaxValueNameLen = 
        (LPDWORD)(*env)->GetLongArrayElements(env, maxValueNameLen, 0);
    LPDWORD pmaxValueLen = 
        (LPDWORD)(*env)->GetLongArrayElements(env, maxValueLen, 0);
    LPDWORD psecDescriptor = 
        (LPDWORD)(*env)->GetLongArrayElements(env, secDescriptor, 0);
    FILETIME ft;
    if (RegQueryInfoKey((HKEY)hkey, NULL, NULL, NULL, psubkeys, pmaxSubkeyLen, 
                        NULL, pvalues, pmaxValueNameLen, pmaxValueLen, 
                        psecDescriptor, &ft) == ERROR_SUCCESS)
        ret = JNI_TRUE;
    (*env)->ReleaseLongArrayElements(env, subkeys, (jlong*)psubkeys, 0);
    (*env)->ReleaseLongArrayElements(
        env, maxSubkeyLen, (jlong*)pmaxSubkeyLen, 0);
    (*env)->ReleaseLongArrayElements(env, values, (jlong*)pvalues, 0);
    (*env)->ReleaseLongArrayElements(
        env, maxValueNameLen, (jlong*)pmaxValueNameLen, 0);
    (*env)->ReleaseLongArrayElements(env, maxValueLen, (jlong*)pmaxValueLen, 0);
    (*env)->ReleaseLongArrayElements(
        env, secDescriptor, (jlong*)psecDescriptor, 0);
    return ret;
}
