/*************************************************************************
 *
 *  $RCSfile: semaimpl.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <osl/semaphor.h>

#include "semaimpl.h"

/*****************************************************************************/
/* NewSemaphore */
/*****************************************************************************/
SemaphoreRef NewSemaphore(sal_uInt32 initialCount)
{
	SemaphoreRef	pSemaphore;

	pSemaphore = malloc(sizeof(struct _SemaphoreRec));

	if (pSemaphore)
	{
		pSemaphore->waitingList = pSemaphore->lastInList = NULL;
		pSemaphore->count = initialCount;
		pSemaphore->state = 0;
	}

	return pSemaphore;
}

/*****************************************************************************/
/* DisposeSemaphore */
/*****************************************************************************/
OSErr DisposeSemaphore(SemaphoreRef pSemaphore)
{
	OSErr	status;

	status = CancelSemaphore(pSemaphore, kSemaphoreDisposed);

	if (status == kSemaphoreNoError)
		free(pSemaphore);

	return status;
}

/*****************************************************************************/
/* CancelSemaphore */
/*****************************************************************************/
OSErr CancelSemaphore(SemaphoreRef pSemaphore, int state)
{
	if (pSemaphore == NULL)
		return kSemaphoreInvalid;
	pSemaphore->state = state;
	while (pSemaphore->waitingList)
		ReleaseSemaphore(pSemaphore);
	pSemaphore->state = kSemaphoreNoError;

	return kSemaphoreNoError;
}

/*****************************************************************************/
/* GetSemaphore */
/*****************************************************************************/
OSErr GetSemaphore(SemaphoreRef pSemaphore)
{
	if (pSemaphore == NULL)
		return kSemaphoreInvalid;

	ThreadBeginCritical();
	if (pSemaphore->count > 0)
	{
		pSemaphore->count--;
		ThreadEndCritical();
		return kSemaphoreNoError;
	}
	else
	{
		struct _ThreadElem	*curThread  = malloc(sizeof(struct _ThreadElem));
		int				result = 0;

		GetCurrentThread(&curThread->id);
		curThread->next = NULL;
		curThread->result = &result;

		if (pSemaphore->waitingList == NULL)
			pSemaphore->waitingList = pSemaphore->lastInList = curThread;
		else
		{
			pSemaphore->lastInList->next = curThread;
			pSemaphore->lastInList = curThread;
		}

		SetThreadStateEndCritical(curThread->id, kStoppedThreadState, kNoThreadID);

		/* Use this because we don't know if pSemaphore is still valid */
		return result;
	}
}

/*****************************************************************************/
/* IsSemaphoreAvailiable */
/*****************************************************************************/
sal_Bool IsSemaphoreAvailiable(SemaphoreRef pSemaphore)
{
	return (sal_Bool)(pSemaphore && pSemaphore->count > 0);
}

/*****************************************************************************/
/* _ReleaseSemaphore */
/*****************************************************************************/
OSErr ReleaseSemaphore(SemaphoreRef pSemaphore)
{
	if (pSemaphore == NULL)
		return kSemaphoreInvalid;

	ThreadBeginCritical();

	if (pSemaphore->waitingList != NULL)
	{
		struct _ThreadElem	*nextToActivate;
		ThreadID			nextThreadID;
		int					*pResult;

		nextToActivate = pSemaphore->waitingList;
		nextThreadID = nextToActivate->id;
		pResult = nextToActivate->result;

		pSemaphore->waitingList = pSemaphore->waitingList->next;
		if (pSemaphore->waitingList == NULL)
			pSemaphore->lastInList = NULL;

		free(nextToActivate);
		if (pResult)
			*pResult = pSemaphore->state;

		/* Do not set the state to kRunningThreadState !!! */
		SetThreadStateEndCritical(nextThreadID, kReadyThreadState, kNoThreadID);
	}
	else
	{
		pSemaphore->count++;
		ThreadEndCritical();
	}

	return kSemaphoreNoError;
}


