/*************************************************************************
 *
 *  $RCSfile: sockimpl.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "system.h"
#include "timerimp.h"
#include "sockimpl.h"

#define OT_SMARTLINK
#define kOTInvalidResult -2

/*****************************************************************************/
/* Asynchronous socket notifier */
/*****************************************************************************/
pascal void SocketNotifier(void *context, OTEventCode code, OTResult result, void *cookie)
{
	TSocket *s = (TSocket *)context;
	OSStatus	status;

	OT_SMARTLINK;
	switch (code)
	{
/* Completion events */
		case T_OPENCOMPLETE:
			if (result == kOTNoError)
			{
				s->epRef = (EndpointRef)cookie;
				OTSetBlocking(s->epRef);
			}
			OTSetEvent(&s->fSyncComplete, result);
			break;
		case T_BINDCOMPLETE:
		case T_UNBINDCOMPLETE:
		case T_ACCEPTCOMPLETE:
		case T_GETPROTADDRCOMPLETE:
		case T_DISCONNECTCOMPLETE:
		case T_OPTMGMTCOMPLETE:
		case T_GETINFOCOMPLETE:
			OTSetEvent(&s->fSyncComplete, result);
			break;
/* Pending events */
		case T_DATA:
			s->result = code;
			break;
		case T_GODATA:
		case T_GOEXDATA:
			OTLook(s->epRef);
			break;
		case T_ORDREL:
//			epState = OTGetEndpointState(s->epRef);
//			status = OTRcvOrderlyDisconnect(s->epRef);
//			if (status == kOTLookErr) {
//				result = OTLook(s->epRef);
//			}
//			result = status;
			break;
		case T_LISTEN:
			break;
		case T_DISCONNECT:
			if (cookie == NULL)	/* Could be affect OTListen -> handle later */
			{
			}
			else	/* OTConnect was rejected */
			{
				TCall	*sndCall = (TCall *)cookie;
				TDiscon	discon;
				result = OTRcvDisconnect(s->epRef, &discon);
				if (result != kOTNoError)
					s->result = result;
				else
				{
/* SCHLUESSELSTELLE: Der fehlgeschlagene Connect darf nicht ueber die Sequence identifiziert
   werden, wenn sie nicht gesetzt ist, sondern allein ueber den Context (=Socket). */

					if (discon.sequence == sndCall->sequence || discon.sequence == NULL)
						OTSetEvent(&s->fSyncComplete, T_DISCONNECT);
				}
			}
			break;
		case T_CONNECT:
			status = OTRcvConnect(s->epRef, nil);
			if (status == kOTNoError)
				OTSetEvent(&s->fSyncComplete, T_CONNECT);
			else
				OTSetEvent(&s->fSyncComplete, T_DISCONNECT);
			break;
		case T_MEMORYRELEASED:
			s->result = result;
			break;
	}
	s->result = result;
}

/*****************************************************************************/
/* OTWaitForPending */
/*****************************************************************************/
/* This function waits until a pending event appears on the endpoint or the timeout
   expires. It returns the pending event code or T_TIMEOUT */

static pascal void _PendingTimerTask(void *arg)
{
	*(sal_Bool *)arg = true;
}


/*****************************************************************************/
OTResult OTWaitForPending(EndpointRef epRef, long timeout)
{
	OTResult	result;
	long		task;
	sal_Bool		timeElapsed = false;
	OSErr		error;

/* Timer Task fuer Timeouts aufsetzen */
#if defined(__POWERPC__)
	if (timeout >= 0)
	{
		task = CreateTimerTask(_PendingTimerTask, &timeElapsed);
		ScheduleTimerTask(task, timeout);
	}
#endif
	do {

/* System am Leben erhalten !!! Da wir noch pollen, geht dadurch aber die Performance
   in die Knie. z.Z. schadet es nicht, wenn wir das System hier blockieren, muss aber
   in Zukunft komplett umgestellt werden ! */

/*		YieldSystemTask();   */

		result = OTLook(epRef);
		error = YieldToAnyThread();
		if (error != noErr)
			break;
	} while ((result == 0 && !timeElapsed) || result == kOTStateChangeErr);
	if (result > 0)
		timeElapsed = false;
	if (timeElapsed && result == 0)
		result = T_TIMEOUT;
/* Timertask zerstoeren */
#if defined(__POWERPC__)
	if (timeout >= 0)
	{
		CancelTimerTask(task);
		DestroyTimerTask(task);
	}
#endif
	return result;
}

/*****************************************************************************/
/* Functions for handling event gates */
/*****************************************************************************/
void OTResetEvent(OTSyncEvent *sync)
{
	sync->result = kOTInvalidResult;
}

/*****************************************************************************/
void OTSetEvent(OTSyncEvent *sync, OTResult result)
{
	sync->result = result;
}

/*****************************************************************************/
OTResult OTGetEvent(OTSyncEvent *sync)
{
	OTResult	result;
	OSErr		error = noErr;
	while (sync->result == kOTInvalidResult && error == noErr)
	{

/* Neue Funktion YieldSystemTask aufrufen, um das System am Leben zu erhalten */
		YieldSystemTask();

		error = YieldToAnyThread();
	}
	result = sync->result;
	OTResetEvent(sync);
	return result;
}

/*****************************************************************************/
static pascal void _EventTimerTask(void *arg)
{
	OTSetEvent((OTSyncEvent *)arg, T_TIMEOUT);
}

/*****************************************************************************/
OTResult OTWaitEvent(OTSyncEvent *sync, long timeout)
{
	OTResult	result;
	long		task;
#if defined(__POWERPC__)
	if (timeout >= 0)
	{
		task = CreateTimerTask(_EventTimerTask, sync);
		ScheduleTimerTask(task, timeout);
	}
#endif
	result = OTGetEvent(sync);
#if defined(__POWERPC__)
	if (timeout >= 0)
	{
		CancelTimerTask(task);
		DestroyTimerTask(task);
	}
#endif
	return result;
}

/*****************************************************************************/
/* Functions for queueing incoming connections */
/*****************************************************************************/
typedef struct OTInConLink {
	OTLink			fLink;
	OTSequence		sequence;
	TSocketAddress	addr;
} OTInConLink;

/*****************************************************************************/
OSStatus OTEnqueueInConnect(OTList *list, const TCall *call)
{
	OTInConLink	*link = OTAllocMem(sizeof(OTInConLink));
	OSStatus	status;
	if (link)
	{
		link->sequence = call->sequence;
		link->addr = *(TSocketAddress *)call->addr.buf;
		OTAddLast(list, &link->fLink);
	}
	status = link ? kOTNoError : kENOMEMErr;
	return status;
}

/*****************************************************************************/
OSStatus OTGetInConnect(OTList *list, TCall *call)
{
	OTInConLink	*link;
	OSStatus	status;
 	link = OTGetLinkObject(OTGetFirst(list), OTInConLink, fLink);
 	if (link)
	{
		if (call)
		{
			call->opt.len = 0;
			call->udata.len = 0;
			call->sequence = link->sequence;
			call->addr.len = sizeof(TSocketAddress);
			if (call->addr.maxlen >= call->addr.len)
			{
				*(TSocketAddress *)call->addr.buf = link->addr;
				status = kOTNoError;
			}
			else
				status = kEINVALErr;
		}
		else
			status = kOTNoError;
	}
	else
		status = kOTNoDataErr;
	return status;
}

/*****************************************************************************/
static sal_Bool CompareSequence(const void *refPtr, OTLink *link)
{
	OTInConLink *incon = OTGetLinkObject(link, OTInConLink, fLink);
	return (sal_Bool)(incon->sequence == *(OTSequence *)refPtr);
}

/*****************************************************************************/
OSStatus OTDequeueInConnect(OTList *list, OTSequence sequence)
{
	OTLink 		*link;
	OTInConLink *incon;
	OSStatus	status;
	link = OTFindAndRemoveLink(list, CompareSequence, &sequence);
	incon = OTGetLinkObject(link, OTInConLink, fLink);
	if (incon)
	{
		OTFreeMem(incon);
		status = kOTNoError;
	}
	else
		status = kOTNoDataErr;
	return status;
}


