/*************************************************************************
 *
 *  $RCSfile: mutex.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __SEMAPHOR_HXX
#include "Semaphor.hxx"
#endif

#ifndef __SCHEDULE_HXX
#include "schedule.hxx"
#endif

//----------------------------------------------------------------------------
//	SALMutex::SALMutex
//----------------------------------------------------------------------------

SALMutex::SALMutex() :
    SALItem(),
    SALSemaphore(),
    mpOwner(NULL)
{
}

//----------------------------------------------------------------------------
//	SALMutex::acquire
//----------------------------------------------------------------------------

BOOL SALMutex::acquire()
{
    SALThread *pActiveThread = SCHEDULER->activeThread();

    if (mpOwner == NULL)
        setOwner(pActiveThread);
    else if (mpOwner == pActiveThread)
        mnValue++;
    else
    {
        SCHEDULER->readyQueue()->remove(pActiveThread);
        append(pActiveThread);
        SCHEDULER->dispatch();
    }
    return TRUE;
}

//----------------------------------------------------------------------------
//	SALMutex::release
//----------------------------------------------------------------------------

BOOL SALMutex::release()
{
    SALThread *pActiveThread = SCHEDULER->activeThread();

    if (mpOwner == pActiveThread)
    {
        if (mnValue > 0)
            mnValue--;
        else
        {
            SALThread *pThread = first();

           	setOwner(pThread);

            if (pThread)
            {
            	remove(pThread);

            	SCHEDULER->readyQueue()->append(pThread);
            	SCHEDULER->dispatch();
            }
        }
        return TRUE;
    }
    return FALSE;
}

//----------------------------------------------------------------------------
//	SALMutex::isAvailiable
//----------------------------------------------------------------------------

BOOL SALMutex::isAvailiable() const
{
    return (BOOL)(mpOwner == NULL || mpOwner == SCHEDULER->activeThread());
}

//----------------------------------------------------------------------------
//	SALMutex::setOwner
//----------------------------------------------------------------------------

void SALMutex::setOwner(SALThread *pThread)
{
    if (mpOwner)
        mpOwner->mutexQueue()->removeItem(this);

    mnValue = 0;
    mpOwner = pThread;
    if (pThread)
		pThread->mutexQueue()->appendItem(this);
}

//============================================================================
//
//	OSL-Interface
//
//============================================================================

#include <osl/mutex.h>

extern "C" {
    

/** Create a thread-local mutex.
	@return 0 if the mutex could not be created, otherwise a handle to the mutex.
*/
oslMutex SAL_CALL osl_createMutex()
{
    SALMutex *pMutex = new SALMutex();

    return (oslMutex)pMutex;
}



/** Release the OS-structures and free mutex data-structure. 
	@param Mutex the mutex-handle 
*/
void SAL_CALL osl_destroyMutex(oslMutex hMutex)
{
    SALMutex *pMutex = (SALMutex *)hMutex;

	if (pMutex)
    	delete pMutex;
}


/** Acquire the mutex, block if already acquired by another thread.
	@param Mutex handle to a created mutex.
	@return False if system-call fails.
*/
sal_Bool SAL_CALL osl_acquireMutex(oslMutex hMutex)
{
    SALMutex *pMutex = (SALMutex *)hMutex;

    if (pMutex)
        return (sal_Bool)pMutex->acquire();
    else
        return sal_False;
}



/** Try to acquire the mutex without blocking.
	@param Mutex handle to a created mutex.
	@return False if it could not be acquired.
*/
sal_Bool SAL_CALL osl_tryToAcquireMutex(oslMutex hMutex)
{
    SALMutex *pMutex = (SALMutex *)hMutex;

    if (pMutex)
    {
        if (pMutex->isAvailiable())
            return (sal_Bool)pMutex->acquire();
        else
            return sal_False;
    }
    else
        return sal_False;
}



/** Release the mutex.
	@param Mutex handle to a created mutex.
	@return False if system-call fails.
*/
sal_Bool SAL_CALL osl_releaseMutex(oslMutex hMutex)
{
    SALMutex *pMutex = (SALMutex *)hMutex;

    if (pMutex)
        return (sal_Bool)pMutex->release();
    else
        return sal_False;
}


} // extern "C"

	

