/*************************************************************************
 *
 *  $RCSfile: xml2utf.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jbu $ $Date: 2000/10/25 08:13:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// TODO: Woher?
#define Max( a, b )		(((a)>(b)) ? (a) : (b) )
#define Min( a, b )		(((a)<(b)) ? (a) : (b) )

/*
* 
* Text2UnicodeConverter
*
**/
namespace sax_expatwrap {
	
class Text2UnicodeConverter 
{

public:
	Text2UnicodeConverter( const OString & sEncoding );
	Text2UnicodeConverter( rtl_TextEncoding encoding );
	~Text2UnicodeConverter();

	Sequence < sal_Unicode > convert( const Sequence<sal_Int8> & );
	sal_Bool canContinue() {  return m_bCanContinue; }

private:
	void init( rtl_TextEncoding encoding );

	rtl_TextToUnicodeConverter 	m_convText2Unicode;
	rtl_TextToUnicodeContext   	m_contextText2Unicode;
	sal_Bool					m_bCanContinue;
	sal_Bool					m_bInitialized;
	rtl_TextEncoding			m_rtlEncoding;
	Sequence<sal_Int8>				m_seqSource;
};

/*----------------------------------------
*
* Unicode2TextConverter
*
**-----------------------------------------*/
class Unicode2TextConverter 
{
public:
	Unicode2TextConverter( const OString & sEncoding );
	Unicode2TextConverter( rtl_TextEncoding encoding );
	~Unicode2TextConverter();

	inline Sequence<sal_Int8> convert( const OUString &s )
		{
			return convert( s.getStr() , s.getLength() );
		}
	Sequence<sal_Int8> convert( const sal_Unicode * , sal_Int32 nLength );
	sal_Bool canContinue() {  return m_bCanContinue; }

private:
	void init( rtl_TextEncoding encoding );

	rtl_UnicodeToTextConverter 	m_convUnicode2Text;
	rtl_UnicodeToTextContext   	m_contextUnicode2Text;
	sal_Bool					m_bCanContinue;
	sal_Bool					m_bInitialized;
	rtl_TextEncoding			m_rtlEncoding;
	Sequence<sal_Unicode>		m_seqSource;
};



/*----------------------------------------
*
* XMLFile2UTFConverter
*
**-----------------------------------------*/
class XMLFile2UTFConverter
{
public:
	XMLFile2UTFConverter( ):
		m_bStarted( sal_False ),
		m_pText2Unicode( 0 ),
		m_pUnicode2Text( 0 )
		{}

	~XMLFile2UTFConverter();
	
	void setInputStream( Reference< XInputStream > &r ) { m_in = r; }
	void setEncoding( const OString &s ) { m_sEncoding = s; }


	
	// @param nMaxToRead The number of chars, that should be read. Note that this is no exact number. There
	//                   may be returned less or more bytes than ordered.
	sal_Int32 readAndConvert( Sequence<sal_Int8> &seq , sal_Int32 nMaxToRead ) 
		throw ( IOException,
				NotConnectedException ,
				BufferSizeExceededException ,
				RuntimeException );

private:

	// Called only on first Sequence of bytes. Tries to figure out file format and encoding information.
	// @return TRUE, when encoding information could be retrieved
	// @return FALSE, when no encoding information was found in file
	sal_Bool scanForEncoding( Sequence<sal_Int8> &seq );

	// Called only on first Sequence of bytes. Tries to figure out
	// if enough data is available to scan encoding
	// @return TRUE, when encoding is retrievable
	// @return FALSE, when more data is needed
	sal_Bool isEncodingRecognizable( const Sequence< sal_Int8 > & seq );

	// When encoding attribute is within the text (in the first line), it is removed.
	void removeEncoding( Sequence<sal_Int8> &seq );
	
	// Initializes decoding depending on m_sEncoding setting
	void initializeDecoding();
private:
	Reference< XInputStream >  m_in;
		
	sal_Bool m_bStarted;
	OString m_sEncoding;

	Text2UnicodeConverter *m_pText2Unicode;
	Unicode2TextConverter *m_pUnicode2Text;	
};
}
