/*************************************************************************
 *
 *  $RCSfile: excchart.cxx,v $
 *
 *  $Revision: 1.19 $
 *
 *  last change: $Author: rt $ $Date: 2003/05/21 07:55:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//___________________________________________________________________

#include "scitems.hxx"
#ifndef _SVX_SIZEITEM_HXX //autogen
#include <svx/sizeitem.hxx>
#endif
#ifndef _SVX_PAGEITEM_HXX //autogen
#include <svx/pageitem.hxx>
#endif
#ifndef _SVX_ULSPITEM_HXX //autogen
#include <svx/ulspitem.hxx>
#endif
#ifndef _SVX_LRSPITEM_HXX //autogen
#include <svx/lrspitem.hxx>
#endif

#ifndef SC_XIESCHER_HXX
#include "xiescher.hxx"
#endif

#ifndef _IMP_OP_HXX
#include "imp_op.hxx"
#endif
#ifndef _EXCIMP8_HXX
#include "excimp8.hxx"
#endif

#ifndef SC_XCLIMPCHARTS_HXX
#include "XclImpCharts.hxx"
#endif


//___________________________________________________________________

void ImportExcel::Chart3D( void )
{
}

void ImportExcel::ChartAlruns( void )
{
}

void ImportExcel::ChartArea( void )
{
}

void ImportExcel::ChartAreaformat( void )
{
}

void ImportExcel::ChartAttachedlabel( void )
{
}

void ImportExcel::ChartAxesused( void )
{
}

void ImportExcel::ChartAxis( void )
{
}

void ImportExcel::ChartAxislineformat( void )
{
}

void ImportExcel::ChartAxisparent( void )
{
}

void ImportExcel::ChartBar( void )
{
}

void ImportExcel::ChartCatserrange( void )
{
}

void ImportExcel::ChartChart( void )
{
}

void ImportExcel::ChartChartformat( void )
{
}

void ImportExcel::ChartChartline( void )
{
}

void ImportExcel::ChartDataformat( void )
{
	UINT16		nXi, nYi, nIss, nGrbit;

	aIn >> nXi >> nYi >> nIss >> nGrbit;
}

void ImportExcel::ChartDefaulttext( void )
{
}

void ImportExcel::ChartDropbar( void )
{
}

void ImportExcel::ChartFontx( void )
{
}

void ImportExcel::ChartFrame( void )
{
}

void ImportExcel::ChartIfmt( void )
{
}

void ImportExcel::ChartLegend( void )
{
}

void ImportExcel::ChartLegendxn( void )
{
}

void ImportExcel::ChartLine( void )
{
}

void ImportExcel::ChartLineform( void )
{
}

void ImportExcel::ChartMarkerformat( void )
{
}

void ImportExcel::ChartPicf( void )
{
}

void ImportExcel::ChartPie( void )
{
}

void ImportExcel::ChartPieformat( void )
{
}

void ImportExcel::ChartPlotarea( void )
{
}

void ImportExcel::ChartPos( void )
{
}

void ImportExcel::ChartRadar( void )
{
}

void ImportExcel::ChartRadararea( void )
{
}

void ImportExcel::ChartSbaseref( void )
{
}

void ImportExcel::ChartSerauxerrbar( void )
{
}

void ImportExcel::ChartSerauxtrend( void )
{
}

void ImportExcel::ChartSerfmt( void )
{
}

void ImportExcel::ChartSeries( void )
{
	UINT16 nSdtX, nSdtY, nValx, nValy;

	aIn >> nSdtX >> nSdtY >> nValx >> nValy;
}

void ImportExcel::ChartSerieslist( void )
{
}

void ImportExcel::ChartSeriestext( void )
{
}

void ImportExcel::ChartSerparent( void )
{
}

void ImportExcel::ChartSertocrt( void )
{
	UINT16 nIndex;

	aIn >> nIndex;
}

void ImportExcel::ChartShtprops( void )
{
	UINT16	nGrbit;
	UINT8	nMdBlank;

	aIn >> nGrbit >> nMdBlank;

	const sal_Char *pText;

	switch( nMdBlank )
	{
		case 0x00:	pText = "not plotted";	break;
		case 0x01:	pText = "zero";			break;
		case 0x02:	pText = "interpolated";	break;
		default:	pText = NULL;
	}
}

void ImportExcel::ChartSurface( void )
{
}

void ImportExcel::ChartText( void )
{
}

void ImportExcel::ChartTick( void )
{
}

void ImportExcel::ChartValuerange( void )
{
}

//void ImportExcel::ApplyChartType( SvInPlaceObjectRef& rIPObj, XclImpChart* pChartType )
//{	}


//___________________________________________________________________

void ImportExcel8::ChartEof( void )
{
    // #90118# be able to read following CONTINUE record as MSODRAWING
    aIn.InitializeRecord( false );
    bObjSection = TRUE;
}

void ImportExcel8::ChartScl( void )
{
	if ( !pExcRoot->bChartTab || !bFirstScl )
		return ;		// das folgende ist nur fuer ChartTabs

	bFirstScl = FALSE;

	UINT16	nNscl, nDscl;

	aIn >> nNscl >> nDscl;

	if( !nNscl )
		nNscl = 1;
	if( !nDscl )
		nDscl = nNscl;
	if( nNscl == nDscl + 1 )
		nNscl = nDscl;		// 51/50 ist nicht mehr als ganzes Blatt
	double	fScale = (double) nNscl / nDscl;

	DBG_ASSERT( pStyleSheetItemSet, "-ImportExcel8::ChartScl: pStyleSheetItemSet==NULL" );

	const Size&	rSize = ((const SvxSizeItem&) pStyleSheetItemSet->Get( ATTR_PAGE_SIZE )).GetSize();
	long nWidth = rSize.Width();
	long nHeight = rSize.Height();

	if ( pExcRoot->bDefaultPage )
	{	// Landscape einstellen
		long nTmp = nWidth;
		nWidth = nHeight;
		nHeight = nTmp;
		pStyleSheetItemSet->Put( SvxSizeItem( ATTR_PAGE_SIZE,
			Size( nWidth, nHeight ) ) );
		SvxPageItem aPageItem(
			( const SvxPageItem& ) pStyleSheetItemSet->Get( ATTR_PAGE ) );
		aPageItem.SetLandscape( TRUE );
		pStyleSheetItemSet->Put( aPageItem );
	}

	double fWidth = (double) nWidth * HMM_PER_TWIPS;		// 100stel mm
	double fHeight = (double) nHeight * HMM_PER_TWIPS;

	// Margins abziehen
	const SvxULSpaceItem& rULSpace =
		( const SvxULSpaceItem & ) pStyleSheetItemSet->Get( ATTR_ULSPACE );
	const SvxLRSpaceItem& rLRSpace =
		( const SvxLRSpaceItem & ) pStyleSheetItemSet->Get( ATTR_LRSPACE );
	double fLRMargin = rLRSpace.GetLeft() + rLRSpace.GetRight();
	double fULMargin = rULSpace.GetUpper() + rULSpace.GetLower();

	fLRMargin = fLRMargin * HMM_PER_TWIPS;		// 100stel mm
	fULMargin = fULMargin * HMM_PER_TWIPS;

	// Hier schummeln wir Kopf-/Fusszeilen etc. hinzu, alles nicht genau,
	// nach dem Laden muessten die ChartTabs per ScPrintFunc GetDocPageSize
	// umstaendlich auf die echte Groesse angepasst werden.
	long nWidthExtra = 2000;		// 1 cm Zeilenkoepfe, 1 cm sonstiges
	long nHeightExtra = 3500;		// 0,5 + 0,25 je Kopf-/Fusszeile, Spaltenkoepfe etc.

	fWidth -= fLRMargin + nWidthExtra;
	fHeight -= fULMargin + nHeightExtra;

	long nW = (long) (fWidth * fScale);
	long nH = (long) (fHeight * fScale);
	long nX = (long) ((long)fWidth > nW ? ((fWidth - nW) / 2) : 0);
	long nY = (long) ((long)fHeight > nH ? ((fHeight - nH) / 2) : 0 );

    if( XclImpEscherObj* pEscherObj = GetObjectManager().GetLastEscherObjAcc() )
        pEscherObj->SetAnchor( Rectangle( nX, nY, nX + nW, nY + nH ) );
}


//___________________________________________________________________

