/*************************************************************************
 *
 *  $RCSfile: editable.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: nn $ $Date: 2002/11/20 14:32:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SC_EDITABLE_HXX
#define SC_EDITABLE_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

class ScDocument;
class ScViewFunc;
class ScMarkData;
class ScRange;


class ScEditableTester
{
	BOOL	bIsEditable;
	BOOL	bOnlyMatrix;

public:
			// no test in ctor
			ScEditableTester();

			// calls TestBlock
			ScEditableTester( ScDocument* pDoc, USHORT nTab,
						USHORT nStartCol, USHORT nStartRow, USHORT nEndCol, USHORT nEndRow );

			// calls TestSelectedBlock
			ScEditableTester( ScDocument* pDoc, 
						USHORT nStartCol, USHORT nStartRow, USHORT nEndCol, USHORT nEndRow,
						const ScMarkData& rMark );

			// calls TestRange
			ScEditableTester( ScDocument* pDoc, const ScRange& rRange );

			// calls TestSelection
			ScEditableTester( ScDocument* pDoc, const ScMarkData& rMark );

			// calls TestView
			ScEditableTester( ScViewFunc* pView );

			~ScEditableTester() {}

			// Several calls to the Test... methods check if *all* of the ranges
			// are editable. For several independent checks, Reset() has to be used.
	void	TestBlock( ScDocument* pDoc, USHORT nTab,
						USHORT nStartCol, USHORT nStartRow, USHORT nEndCol, USHORT nEndRow );
	void	TestSelectedBlock( ScDocument* pDoc, 
						USHORT nStartCol, USHORT nStartRow, USHORT nEndCol, USHORT nEndRow,
						const ScMarkData& rMark );
	void	TestRange( ScDocument* pDoc, const ScRange& rRange );
	void	TestSelection( ScDocument* pDoc, const ScMarkData& rMark );
	void	TestView( ScViewFunc* pView );

	void	Reset();

	BOOL	IsEditable() const			{ return bIsEditable; }
	BOOL	IsFormatEditable() const	{ return bIsEditable || bOnlyMatrix; }
	USHORT	GetMessageId() const;
};

#endif

