/*************************************************************************
 *
 *  $RCSfile: chtm3d2.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/26 18:00:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _E3D_LIGHT3D_HXX //autogen
#include <svx/light3d.hxx>
#endif
#ifndef _E3D_DLIGHT3D_HXX //autogen
#include <svx/dlight3d.hxx>
#endif
#include "chtmodel.hxx"
#include <svx/obj3d.hxx>
#ifndef _CHTSCENE_HXX
#include "chtscene.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif
#ifndef _CAMERA3D_HXX //autogen
#include <svx/camera3d.hxx>
#endif
#ifndef _E3D_EXTRUD3D_HXX //autogen
#include <svx/extrud3d.hxx>
#endif
#ifndef _E3D_POLYGON3D_HXX //autogen
#include <svx/polygn3d.hxx>
#endif

#ifndef _SVX_SVXIDS_HRC //autogen
#include <svx/svxids.hrc>
#endif

#include "chmod3d.hxx"
#include "schattr.hxx"
#include "objid.hxx"

#include "axisobj.hxx"

#ifndef _SVX3DITEMS_HXX
#include <svx/svx3ditems.hxx>
#endif

#define SCH_MIN(a, b) (((a) < (b))? (a): (b))

long ChartModel::GetChartShapeType()
{
	long nShape   =CHART_SHAPE3D_IGNORE;   // BM: ANY instead of IGNORE
	long nOldShape=CHART_SHAPE3D_IGNORE;

    if( Is3DChart() &&
        ( GetBaseType() == CHTYPE_BAR ||
          GetBaseType() == CHTYPE_COLUMN ))
    {
        const SfxPoolItem *pPoolItem;
        long nRowCnt=GetRowCount();
        long nColCnt=GetColCount();
        for(long nRow=0;nRow<nRowCnt;nRow++)
        {
            for(long nCol=0;nCol<nColCnt;nCol++)
            {
                const SfxItemSet& rAttr=GetDataPointAttr(nCol,nRow);
                if(rAttr.GetItemState(SCHATTR_STYLE_SHAPE, TRUE, &pPoolItem) == SFX_ITEM_SET)
                {
                    nShape=((const SfxInt32Item*) pPoolItem)->GetValue();
                }
                else
                {
                    if(!GetDataPointObj(nCol,nRow))
                    {
                        nShape=nOldShape;
                    }
                    else
                    {
                        nShape=CHART_SHAPE3D_SQUARE;
                    }
                }


                if( (nShape!=nOldShape) && nOldShape!=CHART_SHAPE3D_IGNORE)
                    return CHART_SHAPE3D_ANY;

                nOldShape=nShape;
            }
        }
    }

    return nShape;
}
long ChartModel::GetChartShapeType(long nRow)
{
	long nShape   =CHART_SHAPE3D_IGNORE;
	long nOldShape=CHART_SHAPE3D_IGNORE;
	const SfxPoolItem *pPoolItem;
	long nColCnt=GetColCount();
	for(long nCol=0;nCol<nColCnt;nCol++)
	{
		const SfxItemSet& rAttr=GetDataPointAttr(nCol,nRow);
		if(rAttr.GetItemState(SCHATTR_STYLE_SHAPE, TRUE, &pPoolItem) == SFX_ITEM_SET)
		{
			nShape=((const SfxInt32Item*) pPoolItem)->GetValue();
		}
		else
		{
			if(!GetDataPointObj(nCol,nRow))
			{
				nShape=nOldShape;
			}
			else
			{
				nShape=CHART_SHAPE3D_SQUARE;
			}
		}

		if( (nShape!=nOldShape) && nOldShape!=CHART_SHAPE3D_IGNORE)
				return CHART_SHAPE3D_ANY;

		nOldShape=nShape;
	}
	return nShape;
}
/*************************************************************************
|*                                                 |
|* 3D-Balken erzeugen; aPos: links, unten, hinten  |__
|*                                                /
\************************************************************************/
E3dCompoundObject* ChartModel::Create3DBar(Vector3D         aPos,
										   Vector3D			aSizeVec,
										   long				nCol,
										   long				nRow,
										   SfxItemSet		&rAttr,
										   BOOL				bIsSimple,
										   double			fMinPos,
										   double			fOriPos,
										   double			fMaxPos)
{
	Matrix4D aTransMat;

	long mode=CHART_SHAPE3D_SQUARE;
	double fHeight=fMaxPos-fMinPos;
	double a,b;


	const SfxPoolItem *pPoolItem = NULL;
	if (rAttr.GetItemState(SCHATTR_STYLE_SHAPE, TRUE, &pPoolItem) == SFX_ITEM_SET)
		mode=((const SfxInt32Item*) pPoolItem)->GetValue();
	if( (mode==CHART_SHAPE3D_ANY) ||
		(mode==CHART_SHAPE3D_IGNORE)		// BM #66527# shouldn't happen but actually does :-(
	  )
		mode=CHART_SHAPE3D_SQUARE;

	CHART_TRACE1( "Create3DBar Mode=%ld", mode );

	PolyPolygon aPolyPoly;
	Vector3D aDestCenter;
	E3dCompoundObject* pObj;
	E3dDefaultAttributes aDefltAttr3D;

	long nSegs=32;

	double fBase =
		( IsBar()
		  ? SCH_MIN( aSizeVec.Y(), aSizeVec.Z())
		  : SCH_MIN( aSizeVec.X(), aSizeVec.Z()) )
		/ 2.0 - 1.0;

	aDestCenter = aPos + (aSizeVec / 2);

	double fTmp = IsBar()
		? aDestCenter.X()
		: aDestCenter.Y();
	BOOL bNegativ=(fTmp < fOriPos);

	if(mode!=CHART_SHAPE3D_SQUARE && IsBar())
	{
		a=aPos.X()-fOriPos;
		b=aPos.X()+aSizeVec.X()-fOriPos;

		double fTmp=aSizeVec.X();
		aSizeVec.X()=aSizeVec.Y();
		aSizeVec.Y()=fTmp;
		aSizeVec.Z()=-aSizeVec.Z(); //90Grad drehen
	}
	else
	{
		a=aPos.Y()-fOriPos;
		b=aPos.Y()+aSizeVec.Y()-fOriPos;
	}

	const double fRelH  =(double)( (bNegativ) ? fOriPos-fMaxPos : fMinPos-fOriPos);

	a=fRelH-a;
	b=fRelH-b;

	if(bNegativ)
	{
		double tmp=a;
		a=b;
		b=tmp;
	}


	if(mode==CHART_SHAPE3D_HANOI)
	{
		b=a;
		mode=CHART_SHAPE3D_CONE;
	}

	// add extra points to extrusion-rectangle, to get a uniformly light-distribution
	// the distance of these offset points is dependent of the setting of "edge-rounding"
	double fRoundedEdge = 0.0;

	fRoundedEdge = ((double)((const Svx3DPercentDiagonalItem&)
		rAttr.Get(SDRATTR_3DOBJ_PERCENT_DIAGONAL)).GetValue()) / 200.0;
//-/	SfxItemState nState = rAttr.GetItemState( SID_ATTR_3D_PERCENT_DIAGONAL, TRUE, &pPoolItem );
//-/	if( nState == SFX_ITEM_DEFAULT )
//-/		fRoundedEdge = aDefltAttr3D.GetDefaultPercentDiag();
//-/	else if( nState == SFX_ITEM_SET && pPoolItem )
//-/		fRoundedEdge = SAL_STATIC_CAST( double, ( SAL_STATIC_CAST( const SfxUInt16Item*, pPoolItem )->GetValue() ))
//-/			/ 200.0;

	// always use extra points, so set percent diagonal to 0.4 which is 0% in the UI
	if( fRoundedEdge == 0.0 )
		fRoundedEdge = 0.4 / 200.0;

	switch( mode )
	{
		case CHART_SHAPE3D_CYLINDER:
			{
				double fOffset = (fBase * 2.0 * fRoundedEdge) * 1.05;		// increase by 5% for safety
				short nPolySize;

				aPos = Vector3D( 0.0, 0.0, 0.0 );
				if( 2.0 * fOffset < fBase &&
					2.0 * fOffset < aSizeVec.Y() )
				{
					nPolySize = 8;
					Polygon aPoly( nPolySize );
					aPoly[0] = Point( aPos.X(),						aPos.Y() );
						  
					aPoly[1] = Point( aPos.X() + fBase - fOffset,	aPos.Y() );
					aPoly[2] = Point( aPos.X() + fBase,				aPos.Y() );
					aPoly[3] = Point( aPos.X() + fBase,				aPos.Y() + fOffset );
						  
					aPoly[4] = Point( aPos.X() + fBase,				aPos.Y() + aSizeVec.Y() - fOffset );
					aPoly[5] = Point( aPos.X() + fBase,				aPos.Y() + aSizeVec.Y());
					aPoly[6] = Point( aPos.X() + fBase - fOffset,	aPos.Y() + aSizeVec.Y());
						  
					aPoly[7] = Point( aPos.X(),						aPos.Y() + aSizeVec.Y());

					aPolyPoly.Insert( aPoly );
				}
				else
				{
					nPolySize = 4;
					Polygon aPoly( nPolySize );

					aPoly[0]=Point(aPos.X()			, aPos.Y());
					aPoly[1]=Point(aPos.X()	+ fBase	, aPos.Y());
					aPoly[2]=Point(aPos.X() + fBase	, aPos.Y() + aSizeVec.Y());
					aPoly[3]=Point(aPos.X()			, aPos.Y() + aSizeVec.Y());
					
					aPolyPoly.Insert(aPoly);
				}
			
				pObj = new SchE3dLatheObj(aDefltAttr3D, aPolyPoly);
  				((E3dLatheObj*)pObj)->SetItem( Svx3DHorizontalSegmentsItem( nSegs ));


				// #67170# just write the necessary attributes
//-/				SfxItemSet aSegmentAttr(*pItemPool, SID_ATTR_3D_START, SID_ATTR_3D_END,
//-/													SCHATTR_STYLE_START, SCHATTR_STYLE_END,
//-/													0);
				SfxItemSet aSegmentAttr(*pItemPool, 
					SDRATTR_3D_FIRST, SDRATTR_3D_LAST,
					SCHATTR_STYLE_START, SCHATTR_STYLE_END,
					0, 0);

  				rAttr.Put( Svx3DHorizontalSegmentsItem( nSegs ));

				aSegmentAttr.Put(rAttr);
				PutDataPointAttr(nCol, nRow, aSegmentAttr);
			}
			break;


		case CHART_SHAPE3D_PYRAMID:
			nSegs = 4;
			aTransMat.RotateY( F_PI / 4.0 );		// rotate edge to front
			// continue with same code as for cone

		case CHART_SHAPE3D_CONE:
			{
				aPos = Vector3D( 0, 0, 0 );
				double fOffset = (fBase * fRoundedEdge) * 1.05;		// increase by 5% for safety

				BOOL bIsTip = (fRelH == 0.0 || fHeight == 0.0) ||	// nonstacked chart
					(fBase * b <= fOffset * fRelH);					// tip of stacked chart

				long nPolySize;
				double r1, r2;
				if( bIsTip )
				{
					r1 = 0.0;
					r2 = ( fRelH == 0.0 )? fBase : ( fBase * a ) / fRelH;
					nPolySize = 6;
				}
				else
				{
					r1 = ( fBase * b ) / fRelH;
					r2 = ( fBase * a ) / fRelH;
					nPolySize = 8;
				}
				double fTemp	= ((r2-r1) * (r2-r1)) / (aSizeVec.Y() * aSizeVec.Y());
				double fOffsetX = sqrt( fOffset * fOffset / (1.0 + 1.0/fTemp ));
				double fOffsetY = sqrt( fOffset * fOffset / (1.0 + fTemp ));

				Polygon aPoly( nPolySize );
				short i=0;

				if( ! bIsTip )		// skip these points for the tip
				{
					aPoly[i++] = Point( aPos.X(),					aPos.Y());
					aPoly[i++] = Point( aPos.X() + r1 - fOffset,	aPos.Y());
				}
				aPoly[i++] = Point( aPos.X() + r1,					aPos.Y());
				aPoly[i++] = Point( aPos.X() + r1 + fOffsetX,		aPos.Y() + fOffsetY);
				aPoly[i++] = Point( aPos.X() + r2 - fOffsetX,		aPos.Y() + aSizeVec.Y() - fOffsetY);
				aPoly[i++] = Point( aPos.X() + r2,					aPos.Y() + aSizeVec.Y());
				aPoly[i++] = Point( aPos.X() + r2 - fOffset,		aPos.Y() + aSizeVec.Y());
				aPoly[i++] = Point( aPos.X(),						aPos.Y() + aSizeVec.Y());

				aPolyPoly.Insert( aPoly );

				pObj = new SchE3dLatheObj( aDefltAttr3D, aPolyPoly );
  				((E3dLatheObj*)pObj)->SetItem( Svx3DHorizontalSegmentsItem( nSegs ));

				// #67170# just write the necessary attributes
//-/				SfxItemSet aSegmentAttr(*pItemPool, SID_ATTR_3D_START, SID_ATTR_3D_END,
//-/													SCHATTR_STYLE_START, SCHATTR_STYLE_END,
//-/													0);
				SfxItemSet aSegmentAttr(*pItemPool, 
					SDRATTR_3D_FIRST,		SDRATTR_3D_LAST,
					SCHATTR_STYLE_START,	SCHATTR_STYLE_END,
					0, 0);

				rAttr.Put( Svx3DHorizontalSegmentsItem( nSegs ));

				aSegmentAttr.Put(rAttr);
				PutDataPointAttr(nCol, nRow, aSegmentAttr);
			}
			break;
		default:
		case CHART_SHAPE3D_SQUARE:
			{
				double fOffset = (aSizeVec.Z() * fRoundedEdge) * 1.05;		// increase by 5% for safety

				if( 2.0 * fOffset < aSizeVec.X() &&
					2.0 * fOffset < aSizeVec.Y() )
				{
					Polygon aPoly( 13 );
					aPoly[ 0] = Point( aPos.X() + fOffset,					aPos.Y() );
					aPoly[ 1] = Point( aPos.X(),							aPos.Y() );
					aPoly[ 2] = Point( aPos.X(),							aPos.Y() + fOffset );

					aPoly[ 3] = Point( aPos.X(),							aPos.Y() + aSizeVec.Y() - fOffset );
					aPoly[ 4] = Point( aPos.X(),							aPos.Y() + aSizeVec.Y());
					aPoly[ 5] = Point( aPos.X() + fOffset,					aPos.Y() + aSizeVec.Y());

					aPoly[ 6] = Point( aPos.X() + aSizeVec.X() - fOffset,	aPos.Y() + aSizeVec.Y());
					aPoly[ 7] = Point( aPos.X() + aSizeVec.X(),				aPos.Y() + aSizeVec.Y());
					aPoly[ 8] = Point( aPos.X() + aSizeVec.X(),				aPos.Y() + aSizeVec.Y() - fOffset );

					aPoly[ 9] = Point( aPos.X() + aSizeVec.X(),				aPos.Y() + fOffset );
					aPoly[10] = Point( aPos.X() + aSizeVec.X(),				aPos.Y() );
					aPoly[11] = Point( aPos.X() + aSizeVec.X() - fOffset,	aPos.Y() );

					aPoly[12] = aPoly[ 0];
					aPolyPoly.Insert( aPoly );
				}
				else
				{
					Polygon aPoly(5);
					aPoly[0]=Point(aPos.X(), aPos.Y());
					aPoly[1]=Point(aPos.X(), aPos.Y() + aSizeVec.Y());
					aPoly[2]=Point(aPos.X() + aSizeVec.X(), aPos.Y() + aSizeVec.Y());
					aPoly[3]=Point(aPos.X() + aSizeVec.X(), aPos.Y());
					aPoly[4]=aPoly[0];

					aPolyPoly.Insert(aPoly);
				}

				pObj = new SchE3dExtrudeObj(aDefltAttr3D, aPolyPoly, aSizeVec.Z());
			}
			break;

	}

	Vector3D aOldCenter=pObj->GetCenter();
	if(mode!=CHART_SHAPE3D_SQUARE)
	{
		if(IsBar())
		{
			aTransMat.Translate(-aOldCenter);//Zentrum in Nullpunkt setzen
			aTransMat.RotateZ(-3.1415927/2.0);//Saeule umwerfen (90Grad nach rechts)
			if(bNegativ)
				aTransMat.RotateZ(3.1415927);//Spitze nach unten oder links(Kegel, etc.)
			aOldCenter=Vector3D(0,0,0);
		}
		else if(bNegativ)
		{
			aTransMat.Translate(-aOldCenter);//Zentrum in Nullpunkt setzen
			if(bNegativ)
				aTransMat.RotateZ(3.1415927);//Spitze nach unten oder links(Kegel, etc.)
			aOldCenter=Vector3D(0,0,0);
		}
	}
	aTransMat.Translate(aDestCenter - aOldCenter);//An die gewuenschte Position schieben
	//aTransMat=pObj->GetTransform()*aTransMat;
	pObj->NbcSetTransform(aTransMat);

	pObj->SetModel (this);
    // #106658# the ChartModel has a different Pool default for the
    // Svx3DPercentDiagonalItem.  The Geometry is created while using a global
    // pool (Model is not set). Ensure recreating the geometry with new Model
    pObj->DestroyGeometry();

	pObj->InsertUserData(new SchObjectId(CHOBJID_DIAGRAM_DATA));

	// the number vertical segments is always fixed
	rAttr.ClearItem( SDRATTR_3DOBJ_VERT_SEGS );
	pObj->SetItemSet(rAttr);

	pObj->InsertUserData(new SchDataPoint(nCol, nRow));

	return  pObj;
}
/*************************************************************************
|*
|* Neues 3D-Object erzeugen
|*
\************************************************************************/
E3dObject* ChartModel::Create3DObject (UINT16     ID)
{
	E3dObject *pMyObject = new SchE3dObject;
	pMyObject->SetModel (this);
	pMyObject->InsertUserData(new SchObjectId(ID));
	return pMyObject;
}

E3dScene* ChartModel::Create3DScene (UINT16     ID)
{
	E3dScene* pMyObject = new ChartScene( this );
	pMyObject->InsertUserData(new SchObjectId(ID));
	return pMyObject;
}

E3dObject* ChartModel::Create3DAxisObj( UINT16 nId )
{
	E3dObject *pMyObject = new Sch3dAxisObj;
	pMyObject->SetModel( this );
	pMyObject->InsertUserData( new SchObjectId( nId ) );
	return pMyObject;
}

/*************************************************************************
|*
|* 3D-Polygon erzeugen
|*
\************************************************************************/
void  ChartModel::Create3DPolyObject (const SfxItemSet  *pAttr,
						 E3dPolygonObj     *pMyObject,
						 UINT16            nID,
						 E3dObject *pParent)
{
	pMyObject->InsertUserData(new SchObjectId(nID));
	pParent->Insert3DObj (pMyObject);
	pMyObject->SetModel (this);

//-/	pMyObject->NbcSetAttributes(*pAttr, FALSE);
	pMyObject->SetItemSet(*pAttr);

}


void  ChartModel::Create3DExtrudePolyObj(const SfxItemSet  *pAttr,
						 E3dExtrudeObj     *pMyObject,
						 UINT16            nID,
						 E3dObject *pParent)
{
	pMyObject->InsertUserData(new SchObjectId(nID));
	pParent->Insert3DObj (pMyObject);
	pMyObject->SetModel (this);

//-/	pMyObject->NbcSetAttributes(*pAttr, FALSE);
	pMyObject->SetItemSet(*pAttr);

}

/*************************************************************************
|*
|* 3D-Scene erzeugen
|*
\************************************************************************/

ChartScene* ChartModel::CreateScene (const Rectangle &rRect,
						 const Vector3D  &aLightVec,
						 double          fSpotIntensity,
						 Color&          rSpotColor,
						 double          fAmbientIntensity,
						 Color&          rAmbientColor)
{
	ChartScene *pMyScene = new ChartScene (this);

	pMyScene->InsertUserData(new SchObjectId(CHOBJID_DIAGRAM));
	pMyScene->NbcSetSnapRect(rRect);

	return pMyScene;
}

void SchRectObj::NbcSetOutlinerParaObject(OutlinerParaObject* pTextObject)
{
	SdrRectObj::NbcSetOutlinerParaObject(pTextObject);
	ChartModel* pModel=(ChartModel*)GetModel();
	if(pModel)
		pModel->SetTextFromObject(this,pTextObject);
}

//////////////////////////////////////////////////////////////////////////////

void ImpStoreObjcetsAttr(SdrObject *pObj)
{
	ChartModel* pModel = (ChartModel*)pObj->GetModel();
	if(pModel)
		pModel->StoreObjectsAttributes(pObj, pObj->GetItemSet(), FALSE);
}

//////////////////////////////////////////////////////////////////////////////

void SchRectObj::SetItem(const SfxPoolItem& rItem)
{
	SdrRectObj::SetItem(rItem);
	ImpStoreObjcetsAttr(this);
}

void SchRectObj::ClearItem(USHORT nWhich)
{
	SdrRectObj::ClearItem(nWhich);
	ImpStoreObjcetsAttr(this);
}

void SchRectObj::SetItemSet(const SfxItemSet& rSet)
{
	SdrRectObj::SetItemSet(rSet);
	ImpStoreObjcetsAttr(this);
}

//////////////////////////////////////////////////////////////////////////////

void SchE3dExtrudeObj::SetItem(const SfxPoolItem& rItem)
{
	E3dExtrudeObj::SetItem(rItem);
	ImpStoreObjcetsAttr(this);
}

void SchE3dExtrudeObj::ClearItem(USHORT nWhich)
{
	E3dExtrudeObj::ClearItem(nWhich);
	ImpStoreObjcetsAttr(this);
}

void SchE3dExtrudeObj::SetItemSet(const SfxItemSet& rSet)
{
	E3dExtrudeObj::SetItemSet(rSet);
	ImpStoreObjcetsAttr(this);
}

//////////////////////////////////////////////////////////////////////////////

void SchE3dPolygonObj::SetItem(const SfxPoolItem& rItem)
{
	E3dPolygonObj::SetItem(rItem);
	ImpStoreObjcetsAttr(this);
}

void SchE3dPolygonObj::ClearItem(USHORT nWhich)
{
	E3dPolygonObj::ClearItem(nWhich);
	ImpStoreObjcetsAttr(this);
}

void SchE3dPolygonObj::SetItemSet(const SfxItemSet& rSet)
{
	E3dPolygonObj::SetItemSet(rSet);
	ImpStoreObjcetsAttr(this);
}

//////////////////////////////////////////////////////////////////////////////

void SchE3dLatheObj::SetItem(const SfxPoolItem& rItem)
{
	E3dLatheObj::SetItem(rItem);
	ImpStoreObjcetsAttr(this);
}

void SchE3dLatheObj::ClearItem(USHORT nWhich)
{
	E3dLatheObj::ClearItem(nWhich);
	ImpStoreObjcetsAttr(this);
}

void SchE3dLatheObj::SetItemSet(const SfxItemSet& rSet)
{
	E3dLatheObj::SetItemSet(rSet);
	ImpStoreObjcetsAttr(this);
}

//////////////////////////////////////////////////////////////////////////////

void SchE3dObject::SetItem(const SfxPoolItem& rItem)
{
	E3dObject::SetItem(rItem);
	ImpStoreObjcetsAttr(this);
}

void SchE3dObject::ClearItem(USHORT nWhich)
{
	E3dObject::ClearItem(nWhich);
	ImpStoreObjcetsAttr(this);
}

void SchE3dObject::SetItemSet(const SfxItemSet& rSet)
{
	E3dObject::SetItemSet(rSet);
	ImpStoreObjcetsAttr(this);
}

//////////////////////////////////////////////////////////////////////////////

//-/void SchRectObj::NbcSetAttributes(const SfxItemSet& rAttr, FASTBOOL bReplaceAll)
//-/{
//-/	SdrRectObj::NbcSetAttributes(rAttr,bReplaceAll);
//-/	ChartModel* pModel=(ChartModel*)GetModel();
//-/	if(pModel)
//-/		pModel->StoreObjectsAttributes(this,rAttr,bReplaceAll);
//-/};
//-/void SchE3dExtrudeObj::NbcSetAttributes(const SfxItemSet& rAttr, FASTBOOL bReplaceAll)
//-/{
//-/	E3dExtrudeObj::NbcSetAttributes(rAttr,bReplaceAll);
//-/	ChartModel* pModel=(ChartModel*)GetModel();
//-/	if(pModel)
//-/		pModel->StoreObjectsAttributes(this,rAttr,bReplaceAll);
//-/};
//-/void SchE3dPolygonObj::NbcSetAttributes(const SfxItemSet& rAttr, FASTBOOL bReplaceAll)
//-/{
//-/	E3dPolygonObj::NbcSetAttributes(rAttr,bReplaceAll);
//-/	ChartModel* pModel=(ChartModel*)GetModel();
//-/	if(pModel)
//-/		pModel->StoreObjectsAttributes(this,rAttr,bReplaceAll);
//-/};
//-/void SchE3dLatheObj::NbcSetAttributes(const SfxItemSet& rAttr, FASTBOOL bReplaceAll)
//-/{
//-/	E3dLatheObj::NbcSetAttributes(rAttr,bReplaceAll);
//-/	ChartModel* pModel=(ChartModel*)GetModel();
//-/	if(pModel)
//-/		pModel->StoreObjectsAttributes(this,rAttr,bReplaceAll);
//-/};
//-/void SchE3dObject::NbcSetAttributes(const SfxItemSet& rAttr, FASTBOOL bReplaceAll)
//-/{
//-/	E3dObject::NbcSetAttributes(rAttr,bReplaceAll);
//-/	ChartModel* pModel=(ChartModel*)GetModel();
//-/	if(pModel)
//-/		pModel->StoreObjectsAttributes(this,rAttr,bReplaceAll);
//-/};

