/*************************************************************************
 *
 *  $RCSfile: showwin.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 10:57:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SD_SHOWWIN_HXX
#define _SD_SHOWWIN_HXX

#include <limits.h>
#include <vcl/timer.hxx>
#include <vcl/graph.hxx>
#ifndef _SD_SDWINDOW_HXX
#include "sdwindow.hxx"
#endif

// -----------
// - Defines -
// -----------

#define SLIDE_NO_TIMEOUT ULONG_MAX

// ---------
// - Enums -
// ---------

enum ShowWindowMode
{
    SHOWWINDOWMODE_NORMAL = 0,
    SHOWWINDOWMODE_PAUSE = 1,
    SHOWWINDOWMODE_END = 2,
    SHOWWINDOWMODE_BLANK = 3
};

// ----------------
// - SdShowWindow -
// ----------------

class SdViewShell;
class SdPreviewWin;
class FuSlideShow;

class SdShowWindow : public SdWindow
{
private:

	Timer			aPauseTimer;
	Wallpaper		aShowBackground;
	Graphic			aLogo;
	SdPreviewWin*	pPreview;
	ULONG			nPauseTimeout;
	USHORT			nRestartPage;
    ShowWindowMode  eShowWindowMode;
	BOOL			bShowNavigatorAfterSpecialMode;

					DECL_LINK( PauseTimeoutHdl, Timer* pTimer );

protected:

	virtual void	KeyInput(const KeyEvent& rKEvt);
	virtual void	MouseMove(const MouseEvent& rMEvt);
	virtual void	MouseButtonUp(const MouseEvent& rMEvt);
	virtual void	MouseButtonDown(const MouseEvent& rMEvt);
	virtual void	Paint(const Rectangle& rRect);
	virtual long	ParentNotify(NotifyEvent& rNEvt);
	virtual void	GetFocus();

	void			DrawPauseScene( BOOL bTimeoutOnly );
	void			DrawEndScene();
	void			DrawBlankScene();

	void			TerminateShow();
	void			RestartShow();

	BitmapEx		aWaitIcon;
	Bitmap			aRestoreSpace;
 
public:

					SdShowWindow(Window* pParent, SdPreviewWin* pPreviewWin = NULL);
					~SdShowWindow();

	SdViewShell*	GetViewShell() const { return pViewShell; }
	
   	BOOL			SetEndMode();
	BOOL			SetPauseMode( USHORT nPageToRestart, ULONG nTimeoutSec = SLIDE_NO_TIMEOUT, Graphic* pLogo = NULL );
	BOOL			SetBlankMode( USHORT nPageToRestart, const Color& rBlankColor );
	
	ShowWindowMode  GetShowWindowMode() const { return eShowWindowMode; }

	void			DrawWaitIcon();
	void			ClearWaitIcon();
};

#endif // _SD_SHOWWIN_HXX
