/*************************************************************************
 *
 *  $RCSfile: register.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:50:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <svdlg.hxx>
#include <svctrl.hxx>
#include <svtab.hxx>

class SetupRegisterTP1 : public TabPage
{
public:
	FixedText	m_ftRegisterNo;
	Edit		m_edRegisterNo;
	FixedText	m_ftRegisterNo2;

	FixedText	m_ftVendor;
	Edit		m_edVendor;

	FixedText	m_ftPrivate;
	RadioButton m_rbMrs;
	RadioButton m_rbMr;
	FixedText	m_ftName;
	Edit		m_edLastName;
	Edit		m_edFirstName;

	FixedText	m_ftBusiness;
	RadioButton m_rbCompany;
	FixedText	m_ftCompany;
	Edit		m_edCompany;

	FixedText	m_ftName2;
	Edit		m_edName2;

	FixedText	m_ftStreet;
	Edit		m_edStreet;

	FixedText	m_ftAddress;
	Edit		m_edZipCode;
	Edit		m_edCity;
	Edit		m_edCountry;

	FixedText	m_ftEmail;
	Edit		m_edEmail;

	FixedText	m_ftCostumerNo;
	Edit		m_edCostumerNo;
	FixedText	m_ftCostumerNo2;

public:
	SetupRegisterTP1(Window * pParent);

	ByteString GetFormatted();
};

class SetupRegisterTP2 : public TabPage
{
public:
	FixedText	m_ftPrivate;
	GroupBox	m_gbPrivate;
	CheckBox	m_cbPrivate;

	FixedText	m_ftOS;
	GroupBox	m_gbOS;
	CheckBox	m_cbWin95;
	CheckBox	m_cbWin3x;
	CheckBox	m_cbWinNT;
	CheckBox	m_cbOS2;
	CheckBox	m_cbApple;
	CheckBox	m_cbUnix;
	CheckBox	m_cbLinux;

	FixedText	m_ftNetwork;
	GroupBox	m_gbNetwork;
	CheckBox	m_cbNetwork;
	FixedText	m_ftNetOS;
	ListBox		m_lbNetOS;
	FixedText	m_ftClients;
	Edit		m_edClients;

	FixedText	m_ftSupport;
	GroupBox	m_gbSupport;
	CheckBox	m_cbTelefon;
	CheckBox	m_cbFax;
	CheckBox	m_cbLetter;
	CheckBox	m_cbInternet;

	FixedText	m_ftNotice;

public:
	SetupRegisterTP2(Window * pParent);
};

class SetupRegisterTP3 : public TabPage
{
public:
	FixedText	m_ftCheckData;
	FixedText	m_ftData;

public:
	SetupRegisterTP3(Window * pParent);
};

class SetupRegisterDialog : public ModalDialog
{
protected:
	SetupRegisterTP1 m_tp1;
	SetupRegisterTP2 m_tp2;
	SetupRegisterTP3 m_tp3;
	int				 m_nCurrentPage;

	void ShowPage(int nNextPage);

	FixedLine		 m_fl;
	PushButton		 m_pbBackward;
	PushButton		 m_pbForward;
	PushButton		 m_pbRegister;
	CancelButton	 m_pbCancel;

	DECL_LINK(BackwardHdl,PushButton*);
	DECL_LINK(ForwardHdl,PushButton*);
	DECL_LINK(RegisterHdl,PushButton*);

public:
	SetupRegisterDialog(Window * pParent);

	ByteString GetRegisterNo()	const { return m_tp1.m_edRegisterNo.GetText(); }
	ByteString GetVendor()		const { return m_tp1.m_edVendor.GetText(); }
	ByteString GetCostumerNo()	const { return m_tp1.m_edCostumerNo.GetText(); }
	ByteString GetFirstName()	const { return m_tp1.m_edFirstName.GetText(); }
	ByteString GetLastName()	const { return m_tp1.m_edLastName.GetText(); }
	ByteString GetName2()		const { return m_tp1.m_edName2.GetText(); }
	ByteString GetCompany()		const { return m_tp1.m_edCompany.GetText(); }
	ByteString GetStreet()		const { return m_tp1.m_edStreet.GetText(); }
	ByteString GetZipCode()		const { return m_tp1.m_edZipCode.GetText(); }
	ByteString GetCity()		const { return m_tp1.m_edCity.GetText(); }
	ByteString GetCountry()		const { return m_tp1.m_edCountry.GetText(); }
	ByteString GetEmail()		const { return m_tp1.m_edEmail.GetText(); }
	BOOL   IsMr()			const { return m_tp1.m_rbMr.IsChecked(); }
	BOOL   IsMrs()			const { return m_tp1.m_rbMrs.IsChecked(); }
	BOOL   IsChecked()		const { return m_tp1.m_rbCompany.IsChecked();}

	BOOL   IsPrivate()		const { return m_tp2.m_cbPrivate.IsChecked();}
	BOOL   IsWin95()		const { return m_tp2.m_cbWin95.IsChecked();}
	BOOL   IsWin3x()		const { return m_tp2.m_cbWin3x.IsChecked();}
	BOOL   IsWinNT()		const { return m_tp2.m_cbWinNT.IsChecked();}
	BOOL   IsOS2()			const { return m_tp2.m_cbOS2.IsChecked();}
	BOOL   IsApple()		const { return m_tp2.m_cbApple.IsChecked();}
	BOOL   IsUnix()			const { return m_tp2.m_cbUnix.IsChecked();}
	BOOL   IsLinux()		const { return m_tp2.m_cbLinux.IsChecked();}
	BOOL   IsNetwork()		const { return m_tp2.m_cbNetwork.IsChecked();}
	// ByteString GetNetOS()		const { return m_tp2.m_
	ByteString GetClients()		const { return m_tp2.m_edClients.GetText(); }
	BOOL   IsTelefon()		const { return m_tp2.m_cbTelefon.IsChecked();}
	BOOL   IsFax()			const { return m_tp2.m_cbFax.IsChecked();}
	BOOL   IsLetter()		const { return m_tp2.m_cbLetter.IsChecked();}
	BOOL   IsInternet()		const { return m_tp2.m_cbInternet.IsChecked();}
};

