/*************************************************************************
 *
 *  $RCSfile: mainwnd.hxx,v $
 *
 *  $Revision: 1.9.94.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 18:52:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SETUP_MAINWND_HXX
#define _SETUP_MAINWND_HXX

#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#include "actntype.hxx"
#include "stpwatch.hxx"
#include "textani.hxx"
#include "fadedef.h"

class SiSlide;
class SiProgressBar;
class Texture;
class VirtualDevice;

// ---------------------------------------------------------------------
// ---------------------------------------------------------------------

class HeadWin : public Window
{
    BOOL 			m_bTextMode;
    BOOL 			m_bIsBlack;
    Image			m_aVendorBMP;
    Image			m_aVendorHC_BMP;
    Image			m_aProductBMP;
    Image			m_aLogoBMP;
    Font			m_aProductFont;
    String 			m_aProductName;

public:
                    HeadWin(Window* pParent, WinBits nWinBits, ResMgr* pMgr);
                   ~HeadWin();

    virtual void    Resize();
    virtual void    Paint( const Rectangle& rRect );
    virtual void    DataChanged( const DataChangedEvent& rDCEvt );

    void            SetLogoBMP( const ByteString& rNew );
    void            SetVendorBMP( const ByteString& rNew );
    void            SetProductBMP( const ByteString& rNew );
    void            SetProductName( const String& rNew );

    void            SetIsBlack( BOOL bIsBlack ) { m_bIsBlack = bIsBlack; }
    BOOL            IsBlack() const { return m_bIsBlack; }
};

// ---------------------------------------------------------------------
// ---------------------------------------------------------------------
#ifndef _SV_GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif

class GifAnimator
{
	Window*      m_pWindow;
	Graphic*	 m_pAnim;
	FixedBitmap* m_pFB;
	Rectangle    m_aRect;

	ResMgr*      m_pResMgr;

	bool  		 m_bAnim;
    bool         m_bIsBlack;
	Timer 		 m_aStartAnimTimer;

	DECL_LINK(AnimHdl, void*);

	void SetPosSize();

	// no copy and no assign
	GifAnimator(GifAnimator const&);
	GifAnimator& operator=(GifAnimator const&);
	void SetSize();

public:
	GifAnimator(Window* _pParent, ResMgr* _pResMgr);
	~GifAnimator();
	
	void SetPos(Point const& _aPoint);			 // Position, where FixedBitmap should stay
	void StartAnim( BOOL bIsBlack );
	void StopAnim();
	void Paint();        // repaint the Animation
};

// -----------------------------------------------------------------------------

class FixedTextDC : public FixedText
{
	void DataChanged( const DataChangedEvent& rDCEvt );
	// StyleSettings could only changed, if AllowChanges := TRUE

public:
	BOOL m_bAllowChanges;

	FixedTextDC( Window* pParent, WinBits nStyle = 0 )
			:FixedText(pParent, nStyle),
			 m_bAllowChanges(TRUE)
		{}
	
	FixedTextDC( Window* pParent, const ResId& rResId )
			:FixedText(pParent, rResId),
			 m_bAllowChanges(TRUE)
		{}
};

// -----------------------------------------------------------------------------

class LeftWin : public Window
{
	Image				m_aClockImg;
	Image				m_aHC_ClockImg;

	FixedTextDC			m_aFTPrepare;
	FixedTextDC			m_aFTMkDir;
	FixedTextDC			m_aFTCopy;
	FixedTextDC			m_aFTLocal;
	FixedTextDC			m_aFTRegisterUno;
	FixedTextDC			m_aFTChange;

	FixedTextDC			m_aFTDelete;
	FixedTextDC			m_aFTRmDir;
	FixedTextDC			m_aFTUnregister;

	FixedTextDC			m_aFTRecoverFiles;
	FixedTextDC			m_aFTRecoverLocal;
	FixedTextDC			m_aFTRecoverHelp;

	SiInstallSubMode	eActiveMode;
	SiProgressBar*		m_pProgress;
    BOOL				m_bInProgress   : 1;
    BOOL                m_bUseSysColors : 1;
    BOOL 			    m_bIsBlack      : 1;
    BOOL                m_bSetColors    : 1;
    BOOL                m_bShowInstInfo : 1;
    BOOL                m_bInPaint      : 1;
	USHORT 				m_nPercent;

	SiStopWatch			m_aStopWatch;
	Time 				m_aLastTime;
	AutoTimer			m_aTimer;
	long				m_lGuess;
	SiActionType		m_eOldActionType;

	GifAnimator         m_aAnimator;

	void				SetFTColor(FixedTextDC& rText, BOOL bActive = FALSE);
	void				DrawTime(Time* pTime = NULL);
	DECL_LINK(TimeoutHdl, void*);

	void                DataChanged( const DataChangedEvent& rDCEvt );
    void                LanguageChanged();

public:
		                LeftWin(Window* pParent, WinBits nWinBits, ResMgr* pMgr);
		               ~LeftWin();
	virtual void 		Resize();
	virtual void		Paint(const Rectangle& rRect);

	void 				SetVendorBMP( const ByteString& rNew );

	void 				StartUnknownProgress();
	void				StopUnknownProgress();

	void				StartProgress();
	void				StopProgress();

	void				SetPercentage(USHORT nPercent);
	void				ShowInstInfo(BOOL bShow, SiInstallSubMode eMode = ISM_INVALID,
									 SiEnvironment* pEnv = NULL, USHORT nUserProf = 0,
									 USHORT nMaxProf = 0);
	void                SetActionType( SiActionType eType, BOOL bForceSetting = FALSE );

    void                SetIsBlack( BOOL bIsBlack ) { m_bIsBlack = bIsBlack; m_bSetColors = TRUE; }
    BOOL                IsBlack() const { return m_bIsBlack; }

    void                SetUseSysColors( BOOL bUseSysColors ) { m_bUseSysColors = bUseSysColors; m_bSetColors = TRUE; }
    BOOL                UseSysColors() const { return m_bUseSysColors; }
};

// ---------------------------------------------------------------------
// ---------------------------------------------------------------------

class ContWin : public Window
{
	VirtualDevice*		m_pVDev;
	Texture*			m_pTexture;
	SiSlide*			m_pActSlide;

	Point				m_aTextPos;
	Image				m_aImg;
    BOOL 				m_bDoFade   : 1;
    BOOL                m_bIsBlack  : 1;

	::com::sun::star::presentation::FadeEffect m_eFadeType;
	FadeSpeed			m_eFadeSpeed;

	void					ReDrawVDev();
	void 					DrawSlideText(OutputDevice* pOutDev, BOOL bDraw = TRUE);
	void					DrawSlideBitmap(OutputDevice* pOutDev);
	virtual void            DataChanged( const DataChangedEvent& rDCEvt );

public:
		ContWin(Window* pParent, WinBits nWinBits, ResMgr* pMgr);
		~ContWin();

	virtual void 			Resize();
	virtual void			Paint(const Rectangle& rRect);

	void 					Reset();
	void					AnimSlide(const SiSlide* pSlide);

    void                    SetIsBlack( BOOL bIsBlack ) { m_bIsBlack = bIsBlack; }
    BOOL                    IsBlack() const { return m_bIsBlack; }
};

// ---------------------------------------------------------------------
// ---------------------------------------------------------------------

class SetupWindow : public WorkWindow
{
	HeadWin*			m_pHeadWin;
	LeftWin*			m_pLeftWin;
	ContWin*			m_pContWin;

    void                SetBackColor();

public:
                        SetupWindow();
                       ~SetupWindow();

    void                InitChildren( ResMgr* pMgr );

	virtual BOOL    	Close();
	virtual void		Resize();
    virtual void        DataChanged( const DataChangedEvent& rDCEvt );

	HeadWin*			GetHeadWin() const { return m_pHeadWin; }
	LeftWin*			GetLeftWin() const { return m_pLeftWin; }
	ContWin*			GetContWin() const { return m_pContWin; }

	void				SetProductName(const String& rNew)
						{ m_pHeadWin->SetProductName(rNew); }
	void 				SetProductBMP( const ByteString& rNew )
						{ m_pHeadWin->SetProductBMP(rNew); }
	void 				SetVendorBMP( const ByteString& rNew )
						{ m_pHeadWin->SetVendorBMP(rNew); }
	void 				SetLogoBMP( const ByteString& rNew )
						{ m_pHeadWin->SetLogoBMP(rNew); }
};

#endif // __MAINWND_HXX

