/*************************************************************************
 *
 *  $RCSfile: printer.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ka $ $Date: 2001/05/03 08:04:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFX_PRINTER_HXX
#define _SFX_PRINTER_HXX


#ifndef _PRINT_HXX //autogen
#include <vcl/print.hxx>
#endif

class SfxFont;
class SfxTabPage;
class SfxItemSet;

struct SfxPrinter_Impl;

#define SFX_RANGE_NOTSET	((USHORT)0xFFFF)

// class SfxFontSizeInfo -------------------------------------------------

class SfxFontSizeInfo
{
private:
	static USHORT			pStaticSizes[];
	Size*					pSizes;
	USHORT					nSizes;
	BOOL					bScalable;

public:
	SfxFontSizeInfo( const SfxFont& rFont, const OutputDevice& rDevice );
	~SfxFontSizeInfo();

	BOOL					HasSize(const Size &rSize) const;
	BOOL					IsScalable() const { return bScalable; }

	USHORT					SizeCount() const { return nSizes; }
	const Size& 			GetSize( USHORT nNo ) const
							{ return pSizes[nNo]; }
};

// class SfxFont ---------------------------------------------------------

class SfxFont
{
private:
	String					aName;
	FontFamily				eFamily;
	FontPitch				ePitch;
	CharSet 				eCharSet;

	SfxFont&				operator=(const SfxFont& rFont); // not implemented

public:
	SfxFont( const FontFamily eFam,
			 const String& aName,
			 const FontPitch eFontPitch = PITCH_DONTKNOW,
			 const CharSet eFontCharSet = RTL_TEXTENCODING_DONTKNOW );
	// ZugriffsMethoden:
	inline const String&	GetName() const { return aName; }
	inline FontFamily		GetFamily() const { return eFamily; }
	inline FontPitch		GetPitch() const { return ePitch; }
	inline CharSet			GetCharSet() const { return eCharSet; }
};

// class SfxPrinter ------------------------------------------------------

class SfxPrinter : public Printer
{
private:
	JobSetup				aOrigJobSetup;
	SfxItemSet*				pOptions;
	SfxPrinter_Impl*		pImpl;
	BOOL					bKnown;

	void                    UpdateFonts_Impl();

public:
							SfxPrinter( SfxItemSet *pTheOptions );
							SfxPrinter( SfxItemSet *pTheOptions,
										const String &rPrinterName );
							SfxPrinter( SfxItemSet *pTheOptions,
										const JobSetup &rTheOrigJobSetup );
							SfxPrinter( SfxItemSet *pTheOptions,
										const String &rPrinterName,
										const JobSetup &rTheOrigJobSetup );
							SfxPrinter( const SfxPrinter &rPrinter );
							~SfxPrinter();

	SfxPrinter*				Clone() const;

	static SfxPrinter*		Create( SvStream &rStream, SfxItemSet *pOptions );
	SvStream&				Store( SvStream &rStream ) const;

	const JobSetup& 		GetOrigJobSetup() const	{ return aOrigJobSetup; }
	void					SetOrigJobSetup( const JobSetup &rNewJobSetup );

	const SfxItemSet&		GetOptions() const { return *pOptions; }
	void					SetOptions( const SfxItemSet &rNewOptions );

	void					EnableRange( USHORT nRange );
	void					DisableRange( USHORT nRange );
	BOOL					IsRangeEnabled( USHORT nRange ) const;

	BOOL					IsKnown() const { return bKnown; }
	BOOL					IsOriginal() const { return bKnown; }

	USHORT					GetFontCount();
	const SfxFont*			GetFont( USHORT nNo ) const;
	const SfxFont*          GetFontByName( const String &rFontName );

    BOOL                    InitJob( Window* pUIParent, BOOL bDocumentContainsTransparentObjects );
};

#endif
