/*************************************************************************
 *
 *  $RCSfile: statmplx.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:52:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXSTATMPLX_HXX
#define _SFXSTATMPLX_HXX

#include <ctrlitem.hxx>

class SfxStatusForwarder_Impl;

//====================================================================

class SfxStatusMultiplexer: public SfxPoolItem, public SfxListener

/*	[Beschreibung]

	Mit Instanzen dieser Klasse kann eine einzelne <SfxControllerItem> Instanz
	(z.B. ein <SfxToolBoxControl>) auf die Status mehrerer Slots reagieren.

	So etwas wird ben"otigt, wenn die Status nicht unabh"angig voneinander
	sind, sondern z.B. eine Position relativ zu einer anderen ist. Dann
	sammelt der SfxStatusMultiplexer die verschiedenen Status und leitet
	sie erst wenn alle verf"ugbar sind oder keine weiteren mehr folgen sind
	an das eigentlichen SfxControllerItem weiter.

	[Beispiel]

	class MyToolBoxControl: public SfxToolBoxControl
	{
		SfxStatusMultiplexer	aMpx;

	protected:
		virtual void            StateChanged( SfxPoolItem *pStatus );
		...

	public:
								MyToolBoxControl( USHORT nMasterSlotId );
								...
	};

	MyToolBoxControl::MyToolBoxControl( USHORT nMasterSlotId ):
		SfxToolBoxControl( nMasterSlotId ),
		aMpx( *this, SID_SLAVE_SLOT_1, SID_SLAVE_SLOT_2, ..., 0 )
	{
	}

	void MyToolBoxControl::StateChanged( SfxPoolItem *pStatus )
	{
		if ( pStatus == &aMpx )
		{
			SfxPoolItem *pSlave1 = aMpx.GetStatus( SID_SLAVE_SLOT_1 );
			...
		}
	}
*/

{
	USHORT					 nCount;
	SfxStatusForwarder_Impl* pForwarder;

protected:
	void				StateChanged( SfxStatusForwarder_Impl *pFrom,
									  SfxPoolItem *pItem );
	virtual void		SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
								const SfxHint& rHint, const TypeId& rHintType );

public:
						SfxStatusMultiplexer( SfxControllerItem &rController,
											  USHORT nSlotId, ... );
						~SfxStatusMultiplexer();

	SfxPoolItem*		GetStatus( USHORT nSlotId ) const;
};


#endif

