/*************************************************************************
 *
 *  $RCSfile: viewsh.hxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 16:09:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXVIEWSH_HXX
#define _SFXVIEWSH_HXX

#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif
#ifndef _COM_SUN_STAR_UI_XCONTEXTMENUINTERCEPTOR_HPP_
#include <com/sun/star/ui/XContextMenuInterceptor.hpp>
#endif
#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif
#include "shell.hxx"

#define SFX_VIEWSH_INCLUDES_CLIENTSH_HXX	1
#include "clientsh.hxx"

class SfxBaseController;
class Size;
class Fraction;
class Window;
class KeyEvent;
class WorkWindow;
class SvBorder;
class SdrView;
class SfxFrame;
class SfxMedium;
class SfxModule;
class SfxViewFrame;
class SfxItemPool;
class SfxTabPage;
class SfxPrintMonitor;
class SfxFrameSetDescriptor;
class PrintDialog;
class SfxPrinter;
class SfxProgress;
class SfxInPlaceClient;
class SfxMenuBarManager;
class SvEmbeddedObject;
class SvInPlaceObject;
class SvInPlaceClient;
class SvInPlaceClientMemberList;
class SfxInPlaceClient;
class SfxAcceleratorManager;
class SvStringsDtor;
class SfxFrameItem;
class Dialog;
class Menu;
class NotifyEvent;

#define SFX_PRINTER_PRINTER			 1 	// ohne JOBSETUP => temporaer
#define SFX_PRINTER_JOBSETUP    	 2
#define SFX_PRINTER_OPTIONS      	 4
#define SFX_PRINTER_CHG_ORIENTATION  8
#define SFX_PRINTER_CHG_SIZE 		16
#define SFX_PRINTER_ALL         	31

#define SFX_PRINTER_CHG_ORIENTATION_FLAG  3
#define SFX_PRINTER_CHG_SIZE_FLAG 		  4

enum SfxScrollingMode
{
	SCROLLING_NO,
	SCROLLING_YES,
	SCROLLING_AUTO,
	SCROLLING_DEFAULT
};

// "Geeicht" mit www.apple.com und Netscape 3.01
#define DEFAULT_MARGIN_WIDTH 8
#define DEFAULT_MARGIN_HEIGHT 12

//========================================================================

// 	@[SfxViewShell-Flags]

#define	SFX_VIEW_MAXIMIZE_FIRST		 0x0001 /* 	die erste View wird maximiert
												dargestellt */
#define	SFX_VIEW_OPTIMIZE_EACH	     0x0002	/* 	jede View wird in optimaler
												Gr"o\se dargestellt */
#define	SFX_VIEW_DISABLE_ACCELS		 0x0004	/*	die Acceleratoren werden
												disabled, solange diese
												View den Focus hat */
#define	SFX_VIEW_OBJECTSIZE_EMBEDDED 0x0008	/* 	Views von embedded Objekten
												werden in optimaler Gr"o\se
												dargestellt */
#define SFX_VIEW_HAS_PRINTOPTIONS    0x0010 /*  Options-Button und Options-
												Dialog im PrintDialog */
#define SFX_VIEW_CAN_PRINT			 0x0020 /*  enabled Printing ohne Printer
												erzeugen zu m"ussen */
#define SFX_VIEW_NO_SHOW			 0x0040 /*  Window der ViewShell darf nicht
												automatisch geshowed werden */
#define SFX_VIEW_IMPLEMENTED_AS_FRAMESET 0x0080 /*  Das Dokument ist als
													Frameset implementiert*/
#define SFX_VIEW_NO_NEWWINDOW		0x0100		/* keine weitere View erlauben */

/*	[Beschreibung]

	Die SfxViewShell-Flags steuern das Verhalten der SfxViewShell f"ur die
	Dauer ihrer Lebenszeit. Sie werden im Konstruktor der <SfxViewShell>
	angegeben.
*/

//=========================================================================

#define SFX_DECL_VIEWFACTORY(Class) \
private: \
	static SfxViewFactory *pFactory; \
public: \
	static SfxViewShell  *CreateInstance(SfxViewFrame *pFrame, SfxViewShell *pOldView); \
	static void 		  RegisterFactory( USHORT nPrio = USHRT_MAX ); \
	static SfxViewFactory&Factory() { return *pFactory; } \
    static void           InitFactory()

#define SFX_IMPL_VIEWFACTORY(Class, rResId) \
	SfxViewFactory* Class::pFactory; \
	SfxViewShell* __EXPORT Class::CreateInstance(SfxViewFrame *pFrame, SfxViewShell *pOldView) \
	{ return new Class(pFrame, pOldView); } \
    void Class::RegisterFactory( USHORT nPrio ) \
	{ \
		pFactory = new SfxViewFactory(&CreateInstance,&InitFactory,nPrio,rResId);\
		InitFactory(); \
	} \
    void Class::InitFactory()

#define SFX_VIEW_REGISTRATION(DocClass) \
			DocClass::Factory().RegisterViewFactory( Factory() )

#define SFX_REGISTER_VIEW(ViewShellClass) \
			Factory().RegisterViewFactory( ViewShellClass::Factory() )

// -----------------------------------------------------------------------
class SfxViewShell: public SfxShell, public SfxListener
{
#ifdef _SFXVIEWSH_HXX
friend class SfxViewFrame;
friend class SfxTopViewFrame;
friend class SfxPlugInFrame;
friend class SfxInPlaceFrame;
friend class SfxInternalFrame;
friend class SfxInternalObject; //! besser via SfxInPlaceFrame
friend class SfxExternalTopViewFrame_Impl;
friend class SfxOfficeDocController;
friend class SfxBaseController;
#endif

	struct SfxViewShell_Impl*	pImp;

	SvInPlaceClientMemberList   aIPClientList;
	SfxViewFrame*				pFrame;
	SfxShell*					pSubShell;
	Window*						pWindow;
	BOOL                        bMaximizeFirst;
	BOOL						bOptimizeEach;
	BOOL						bNoNewWindow;

protected:
	virtual void                Activate(BOOL IsMDIActivate);
	virtual void                Deactivate(BOOL IsMDIActivate);

	virtual Size                GetOptimalSizePixel() const;

	virtual void				InnerResizePixel( const Point &rOfs, const Size &rSize );
	virtual void                OuterResizePixel( const Point &rOfs, const Size &rSize );
	virtual void                SetZoomFactor( const Fraction &rZoomX, const Fraction &rZoomY );

	virtual void				Move();

	virtual void                SFX_NOTIFY( SfxBroadcaster& rBC,
										const TypeId& rBCType,
										const SfxHint& rHint,
										const TypeId& rHintType );
public:
	// Iteration
	static SfxViewShell*        GetFirst( const TypeId* pType = 0, BOOL bOnlyVisible = TRUE );
	static SfxViewShell*        GetNext( const SfxViewShell& rPrev,
										 const TypeId* pType = 0, BOOL bOnlyVisible = TRUE );
	static SfxViewShell*        Current();

	// Ctoren/Dtoren Initialisierung
								TYPEINFO();
								SFX_DECL_INTERFACE(SFX_INTERFACE_SFXVIEWSH);

								SfxViewShell( SfxViewFrame *pFrame, USHORT nFlags = 0 );
	virtual                     ~SfxViewShell();

	// In-Place
	virtual SfxInPlaceClient*	CreateIPClient( WorkWindow * pTop, WorkWindow * pDoc, Window * pDraw );
	SfxInPlaceClient *          GetIPClient() const;
	SfxInPlaceClient *          GetUIActiveClient() const;
	SfxInPlaceClient* 			FindIPClient( SvEmbeddedObject *pObj, Window *pObjParentWin ) const;
	ErrCode						DoVerb( SfxInPlaceClient *pIPClient, long nVerb );
	virtual ErrCode 			DoVerb(long nVerb);
	virtual	void				UIActivate( SvInPlaceObject *pIPObj );
	virtual	void				UIDeactivate( SvInPlaceObject *pIPObj );
	virtual ErrCode             DirectLoad( SfxFrame* pFrame, SfxMedium& rMedium );
	virtual void				JumpToMark( const String& rMark );

	void						VisAreaChanged(const Rectangle& rRect);

	// Verhaltens-Flags
	BOOL                        IsMaximizeFirst() const { return bMaximizeFirst; }
	BOOL                        IsOptimizeEach() const { return bOptimizeEach; }
	HACK(inline) BOOL           UseObjectSize() const;
	SfxScrollingMode			GetScrollingMode() const;
	void						SetScrollingMode( SfxScrollingMode eMode );

	// Misc
	virtual USHORT              PrepareClose( BOOL bUI = TRUE, BOOL bForBrowsing = FALSE );
	virtual String              GetSelectionText( BOOL bCompleteWords = FALSE );
	virtual BOOL				HasSelection( BOOL bText = TRUE ) const;
	virtual SdrView*			GetDrawView() const;
	void                        SetSubShell( SfxShell *pShell );
	SfxShell*                   GetSubShell() const { return pSubShell; }
	void						AddSubShell( SfxShell& rShell );
	void						RemoveSubShell( SfxShell *pShell=NULL );
	SfxShell*					GetSubShell( USHORT );

	// Focus, KeyInput, Cursor
	void						GotFocus() const;
	inline void					LostFocus() const;
	virtual void				ShowCursor( FASTBOOL bOn = TRUE );
	virtual FASTBOOL			KeyInput( const KeyEvent &rKeyEvent );

	// Viewing Interface
	Window*                     GetWindow() const { return pWindow; }
	void                        SetWindow( Window *pViewPort );
	virtual void				AdjustPosSizePixel( const Point &rOfs, const Size &rSize );
	const SvBorder&             GetBorderPixel() const;
	void                        SetBorderPixel( const SvBorder &rBorder );
	void						InvalidateBorder();
	inline SfxViewFrame*        GetViewFrame() const;
	void						AdjustVisArea(const Rectangle& rRect);

	// Printing Interface
	virtual void				PreparePrint( PrintDialog *pPrintDialog = 0 );
	virtual ErrCode				DoPrint( SfxPrinter *pPrinter, PrintDialog *pPrintDialog, BOOL bSilent );
	virtual USHORT              Print( SfxProgress &rProgress, PrintDialog *pPrintDialog = 0 );
	virtual SfxPrinter*         GetPrinter( BOOL bCreate = FALSE );
	virtual USHORT              SetPrinter( SfxPrinter *pNewPrinter, USHORT nDiffFlags = SFX_PRINTER_ALL );
	virtual SfxTabPage*         CreatePrintOptionsPage( Window *pParent, const SfxItemSet &rOptions );
	virtual PrintDialog*        CreatePrintDialog( Window *pParent );
	void						LockPrinter( BOOL bLock = TRUE );
	BOOL						IsPrinterLocked() const;

	// Workingset
	virtual void                WriteUserData( String&, BOOL bBrowse = FALSE );
	virtual void                ReadUserData( const String&, BOOL bBrowse = FALSE );
    virtual void                WriteUserDataSequence ( ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >&, sal_Bool bBrowse = sal_False );
    virtual void                ReadUserDataSequence ( const ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >&, sal_Bool bBrowse = sal_False );
	virtual void				QueryObjAreaPixel( Rectangle& rRect ) const;

	virtual SfxObjectShell*		GetObjectShell();

	virtual void				MarginChanged();
	const Size&					GetMargin() const;
	void						SetMargin( const Size& );
	void 						DisconnectAllClients();
	virtual SfxFrame*     		GetSmartSelf( SfxFrame* pSelf, SfxMedium& rMedium );
	BOOL						NewWindowAllowed() const			{ return !bNoNewWindow; }
	void						SetNewWindowAllowed( BOOL bSet )	{ bNoNewWindow = !bSet; }

    void                        SetController( SfxBaseController* pController );
    ::com::sun::star::uno::Reference< ::com::sun::star::frame::XController >
								GetController();

    ::cppu::OInterfaceContainerHelper& GetContextMenuInterceptors() const;
    BOOL                        TryContextMenuInterception( Menu& rIn, Menu*& rpOut, ::com::sun::star::ui::ContextMenuExecuteEvent aEvent );

	void						SetAdditionalPrintOptions( const com::sun::star::uno::Sequence < com::sun::star::beans::PropertyValue >& );

#if _SOLAR__PRIVATE
    void                        AddContextMenuInterceptor_Impl( const ::com::sun::star::uno::Reference < ::com::sun::star::ui::XContextMenuInterceptor >& xInterceptor );
    void                        RemoveContextMenuInterceptor_Impl( const ::com::sun::star::uno::Reference < ::com::sun::star::ui::XContextMenuInterceptor >& xInterceptor );
	FASTBOOL					GlobalKeyInput_Impl( const KeyEvent &rKeyEvent );
	BOOL                        IsImplementedAsFrameset_Impl() const;

	void 						NewIPClient_Impl( SfxInPlaceClient *pIPClient )
								{ aIPClientList.Insert(pIPClient); }
	void 						IPClientGone_Impl( SfxInPlaceClient *pIPClient )
								{ aIPClientList.Remove(pIPClient); }
	SvInPlaceClientMemberList*	GetIPClientList_Impl( BOOL bCreate = TRUE ) const
								{ return &((SfxViewShell*)this)->aIPClientList; }
	void						DisconnectClients_Impl(SvInPlaceClient *pIP);
	void						DiscardClients_Impl();
	BOOL						PlugInsActive() const;

	SfxPrinter*					SetPrinter_Impl( SfxPrinter *pNewPrinter );
	BOOL						IsShowView_Impl() const;

	long						HandleNotifyEvent_Impl( NotifyEvent& rEvent );
	BOOL						HasKeyListeners_Impl();
	BOOL						HasMouseClickListeners_Impl();

	// Shell Interface
	void                        ExecPrint_Impl(SfxRequest &);
	void                        ExecMisc_Impl(SfxRequest &);
	void						GetState_Impl(SfxItemSet&);
	SfxFrameSetDescriptor* 		GetFrameSet_Impl() const;
	void						SetFrameSet_Impl(SfxFrameSetDescriptor*);
	void 						CheckIPClient_Impl( SvInPlaceClient*, const Rectangle& );
	void						PushSubShells_Impl( BOOL bPush=TRUE );
	SfxMenuBarManager*			GetMenuBar_Impl( BOOL bPlugin = FALSE );
//	void 						SetMenuBar_Impl( const ResId& );
    void                        ReleaseMenuBar_Impl();
	SfxAcceleratorManager*		GetAccMgr_Impl();
	void						TakeOwnerShip_Impl();
	BOOL						GotOwnerShip_Impl();
#endif
};

//========================================================================

inline void	SfxViewShell::LostFocus() const

/*	[Beschreibung]

	Diese Methode mu\s vom Applikationsentwickler gerufen werden, wenn
	das Edit-Window den Focus verloren hat. Der SFx hat so z.B. die
	M"oglichkeit, den Accelerator auszuschalten, damit in bestimmten
	Floating-Windows die Cursor-Tasten, die Delete-Taste etc. funktionieren,
	obwohl sie "uber den Accelerator umdefiniert sind.


	[Anmerkung]

	<StarView> liefert leider keine M"oglichkeit, solche Events
	'von der Seite' einzuh"angen.
*/

{
}

//------------------------------------------------------------------------

inline SfxViewFrame* SfxViewShell::GetViewFrame() const

/*	[Bechreibung]

	Diese Methode liefert einen Pointer auf die <SfxViewFrame>-Instanz,
	in der diese SfxViewShell dargestellt wird. Dieses ist die Instanz,
	die imKonstruktor durchgereicht wurde. Es ist gew"ahrleistet, da\s
	der zur"uckgegebene Pointer auf eine g"ultige SfxViewFrame-Instanz
	zeigt.


	[Querverweise]

	<SfxShell::GetFrame()const>
*/

{
	return pFrame;
}

#endif // #ifndef _SFXVIEWSH_HXX


