/*************************************************************************
 *
 *  $RCSfile: urllst.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:52:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// includes ******************************************************************

#define _SVSTDARR_STRINGSSORTDTOR
#include <svtools/svstdarr.hxx>

#pragma hdrstop
#include "urllst.hxx"
#include "sfxuno.hxx"

// defines *******************************************************************

// Makros ********************************************************************


//****************************************************************************
// SfxUrlList_Impl
//****************************************************************************

SfxUrlList_Impl::SfxUrlList_Impl()
: mpStringList ( 0 )
{
}

SfxUrlList_Impl::SfxUrlList_Impl(SvStringsSortDtor* pStringList)
: mpStringList ( pStringList )
/*
	Die StringListe gehoert SfxUrlList_Impl
*/
{
}

SfxUrlList_Impl::~SfxUrlList_Impl()
{
	if ( mpStringList )
		delete mpStringList;
}

com::sun::star::uno::Sequence< rtl::OUString > SAL_CALL SfxUrlList_Impl::getList(void) throw ( com::sun::star::uno::RuntimeException )
{
	if ( !mpStringList )
		return com::sun::star::uno::Sequence< rtl::OUString >();
	else
	{
		// Url-Anzahl
		USHORT nListCount = mpStringList->Count();
		// Sequence dafuer
		com::sun::star::uno::Sequence< rtl::OUString > aUlist ( nListCount );

		rtl::OUString* pUString = aUlist.getArray();
		for ( USHORT i = 0	; i < nListCount ; i++ )
		{
			*(pUString) = S2U(*mpStringList->GetObject(i));
			pUString++;
		}
		return aUlist;
	}
}

void SAL_CALL SfxUrlList_Impl::setList(const com::sun::star::uno::Sequence< rtl::OUString >& List_) throw ( com::sun::star::uno::RuntimeException )
{
	if ( mpStringList )
		delete mpStringList;
	mpStringList = new SvStringsSortDtor;
	const rtl::OUString* pUStr = List_.getConstArray();
	for ( USHORT i = 0; i < List_.getLength(); i++ )
	{
		mpStringList->Insert(new XubString ( U2S(*pUStr)));
		pUStr++;
	}
}

com::sun::star::uno::Any SAL_CALL SfxUrlList_Impl::queryInterface( const com::sun::star::uno::Type& rType ) throw ( com::sun::star::uno::RuntimeException )
{
	/* Attention: Don't use mutex or guard in this method!!! Is a method of XInterface.	*/
	/* Ask for my own supported interfaces ...											*/
	com::sun::star::uno::Any aReturn ( ::cppu::queryInterface(	rType,
																static_cast< ::com::sun::star::frame::XUrlList* >( this )
															 )
									 );																															\
	/* If searched interface supported by this class ... */
	if ( aReturn.hasValue() == sal_True )
	{
		/* ... return this information. */
		return aReturn;
	}
	else
	{
		/* Else; ... ask baseclass for interfaces! */
		return OWeakObject::queryInterface( rType );
	}
}


