/*************************************************************************
 *
 *  $RCSfile: ipmenu.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:54:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <ipmenu.hxx>
#include <tools/link.hxx>
#include <tools/debug.hxx>
#pragma hdrstop

/************************************************************************/
/*************************************************************************
|*    SvInPlaceMenuBar::SvInPlaceMenuBar()
|*
|*    Beschreibung
*************************************************************************/
SvInPlaceMenuBar::SvInPlaceMenuBar( const ResId & rId )
	: MenuBar( rId )
{
	USHORT * pRes = (USHORT *)GetClassRes();
	nCount0       = pRes[ 0 ];
	nCount1       = pRes[ 1 ];
	nCount2       = pRes[ 2 ];
	IncrementRes( sizeof( short ) * 3 );
}

SvInPlaceMenuBar::SvInPlaceMenuBar( MenuBar * pBar,
									USHORT nPos0, USHORT nCount0P,
									USHORT nPos1, USHORT nCount1P,
									USHORT nPos2, USHORT nCount2P )
	: MenuBar()
{
	nCount0       = nCount0P;
	nCount1       = nCount1P;
	nCount2       = nCount2P;

	USHORT i;
	for( i = nPos0; i < nPos0 + nCount0; i++ )
		InsertItem( *pBar, i );
	for( i = nPos1; i < nPos1 + nCount1; i++ )
		InsertItem( *pBar, i );
	for( i = nPos2; i < nPos2 + nCount2; i++ )
		InsertItem( *pBar, i );
}

/*************************************************************************
|*    SvInPlaceMenuBar::~SvInPlaceMenuBar()
|*
|*    Beschreibung
*************************************************************************/
SvInPlaceMenuBar::~SvInPlaceMenuBar()
{
}

/*************************************************************************
|*    SvInPlaceMenuBar::InsertItem()
|*
|*    Beschreibung
*************************************************************************/
void SvInPlaceMenuBar::InsertItem( Menu & rMenu, USHORT nPos )
{
	CopyItem( rMenu, nPos );
}

/*************************************************************************
|*    SvInPlaceMenuBar::PushSelectHdl()
|*    SvInPlaceMenuBar::PopSelectHdl()
|*
|*    Beschreibung
*************************************************************************/
void SvInPlaceMenuBar::PushSelectHdl( const Link & rLink )
{
	MenuBar::SetSelectHdl( rLink );
	for( USHORT i = 0; i < GetItemCount(); i++ )
	{
		USHORT nId = GetItemId( i );
		GetPopupMenu( nId )->SetSelectHdl( rLink );
	}
}

void SvInPlaceMenuBar::PopSelectHdl()
{
	MenuBar::SetSelectHdl( Link());
	for( USHORT i = 0; i < GetItemCount(); i++ )
	{
		USHORT nId = GetItemId( i );
		GetPopupMenu( nId )->SetSelectHdl( Link() );
	}
}

/*************************************************************************
|*    SvInPlaceMenuBar::PushActivateHdl()
|*    SvInPlaceMenuBar::PopActivateHdl()
|*
|*    Beschreibung
*************************************************************************/
void SvInPlaceMenuBar::PushActivateHdl( const Link & rLink )
{
	DBG_ERROR( "not implemented" );
}

void SvInPlaceMenuBar::PopActivateHdl()
{
	DBG_ERROR( "not implemented" );
}

/*************************************************************************
|*    SvInPlaceMenuBar::PushDeactivateHdl()
|*    SvInPlaceMenuBar::PopDeactivateHdl()
|*
|*    Beschreibung
*************************************************************************/
void SvInPlaceMenuBar::PushDeactivateHdl( const Link & rLink )
{
	DBG_ERROR( "not implemented" );
}

void SvInPlaceMenuBar::PopDeactivateHdl()
{
	DBG_ERROR( "not implemented" );
}

/*************************************************************************
|*    SvInPlaceMenuBar::PushHighliteHdl()
|*    SvInPlaceMenuBar::PopHighliteHdl()
|*
|*    Beschreibung
*************************************************************************/
void SvInPlaceMenuBar::PushHighlightHdl( const Link & rLink )
{
	DBG_ERROR( "not implemented" );
}

void SvInPlaceMenuBar::PopHighlightHdl()
{
	DBG_ERROR( "not implemented" );
}

