/*
 * This file was generated automatically by xsubpp version 1.9507 from the 
 * contents of GenInfoParser.xs. Do not edit this file, edit GenInfoParser.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "GenInfoParser.xs"
/*************************************************************************
 *
 *  $RCSfile: GenInfoParser.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2001/06/18 14:34:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <gen_info.hxx>
#include <st_gilrw.hxx>
#include <gi_list.hxx>
#include <simstr.hxx>

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* 
 * GenInfoParser wraps the giparser API in a single class.
 * The perl statement $a = GenInfoParser->new() will create a 
 * new instance of GenInfoParser. See the usage notes 
 * in GenInfoParser.pm.
 */


class GenInfoParser {
    public:
        GenInfoParser() { m_pList=NULL; }
        ~GenInfoParser();
        
        bool        load_list(const char *pFileName);
        const char* get_key(const char *pPath);
        const char* get_value(const char *pPath);
        int         get_key_vector(const char **pppKey[], const char *pPath);

    private:
        List_GenericInfo*                   m_pList;
};

GenInfoParser::~GenInfoParser()
{
    delete m_pList;
}

bool 
GenInfoParser::load_list(const char *pFileName)
{
    ST_InfoListReader   aReader;
    m_pList = new List_GenericInfo;
    if ( m_pList )
        if ( aReader.LoadList(*m_pList, Simstr(pFileName)) ) {
            return 1;
        }
        else {
            delete m_pList;
            m_pList = NULL;
        }
    return 0;
}

const char *
GenInfoParser::get_key(const char *pPath)
{
    if ( !m_pList )
        return NULL;

    const GenericInfo* pGenInfo = (*m_pList)[Simstr(pPath)];
    if ( pGenInfo ) {
        return pGenInfo->Key().str();
    }
    else {
        return NULL;
    }
}

const char *
GenInfoParser::get_value(const char *pPath)
{
    if ( !m_pList )
        return NULL;

    const GenericInfo* pGenInfo = (*m_pList)[Simstr(pPath)];
    if ( pGenInfo ) {
        return pGenInfo->Value().str();
    }
    else {
        return NULL;
    }
}

int
GenInfoParser::get_key_vector(const char **pppKeys[], const char *pPath)
{   
    // caller is responsible for freeing pppKeys
    const List_GenericInfo* pList;

    if ( !m_pList )
        return 0;
    
    if ( pPath ) {
        const GenericInfo* pGenInfo = (*m_pList)[Simstr(pPath)];
        if ( pGenInfo && pGenInfo->HasSubList() ) {
            pList = &pGenInfo->SubList();
        }
        else 
            return 0;
    }
    else {
        pList = m_pList;
    }

    int nKeys = pList->Size();
    if ( !nKeys )
        return 0;
    else 
        *pppKeys = new const char*[nKeys];

    if ( !pppKeys )
        return 0;

    List_GenericInfo::const_iterator it;
    const char **pTmp = *pppKeys;    
    for ( it = pList->Begin(); it != pList->End(); ++it) {
        *pTmp++ = (*it).Key().str();
    }
   
    return nKeys;
}


/* The rest of this file contains the glue for the 
 * GenInfoParser perl bindings
 */

#line 198 "GenInfoParser.c"
XS(XS_GenInfoParser_new)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: GenInfoParser::new(CLASS)");
    {
	char *	CLASS = (char *)SvPV(ST(0),PL_na);
	GenInfoParser *	RETVAL;

	RETVAL = new GenInfoParser();
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), CLASS, (void*)RETVAL );
 
    }
    XSRETURN(1);
}

XS(XS_GenInfoParser_DESTROY)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: GenInfoParser::DESTROY(THIS)");
    {
	GenInfoParser *	THIS;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
        THIS = (GenInfoParser *)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "GenInfoParser::DESTROY() -- THIS is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };

	delete THIS;
    }
    XSRETURN_EMPTY;
}

XS(XS_GenInfoParser_load_list)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: GenInfoParser::load_list(THIS, pFileName)");
    {
	const char *	pFileName = (const char *)SvPV(ST(1),PL_na);
	GenInfoParser *	THIS;
	bool	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
        THIS = (GenInfoParser *)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "GenInfoParser::load_list() -- THIS is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };

	RETVAL = THIS->load_list(pFileName);
	ST(0) = boolSV(RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

XS(XS_GenInfoParser_get_keys)
{
    dXSARGS;
    if (items < 1 || items > 2)
	Perl_croak(aTHX_ "Usage: GenInfoParser::get_keys(THIS, pPath=NULL)");
    SP -= items;
    {
	const char *	pPath;
	GenInfoParser *	THIS;

	if (items < 2)
	    pPath = NULL;
	else {
	    pPath = (const char *)SvPV(ST(1),PL_na);
	}

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
        THIS = (GenInfoParser *)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "GenInfoParser::get_keys() -- THIS is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 206 "GenInfoParser.xs"
    const char **ppKeys;
    int nKeys = THIS->get_key_vector(&ppKeys, pPath);
    if ( nKeys ) {
        EXTEND(SP, nKeys);
        for ( int i=0; i < nKeys; i++ )
            PUSHs(sv_2mortal(newSVpv(ppKeys[i], 0)));
        delete [] ppKeys;
    }
#line 291 "GenInfoParser.c"
	PUTBACK;
	return;
    }
}

XS(XS_GenInfoParser_get_key)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: GenInfoParser::get_key(THIS, pPath)");
    {
	const char*	pPath = (const char *)SvPV(ST(1),PL_na);
	GenInfoParser *	THIS;
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
        THIS = (GenInfoParser *)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "GenInfoParser::get_key() -- THIS is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 219 "GenInfoParser.xs"
    ST(0) = sv_newmortal();
    const char *pKey = THIS->get_key(pPath);
    if ( pKey )
        sv_setpv(ST(0), pKey);
#line 318 "GenInfoParser.c"
    }
    XSRETURN(1);
}

XS(XS_GenInfoParser_get_value)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: GenInfoParser::get_value(THIS, pPath)");
    {
	const char*	pPath = (const char *)SvPV(ST(1),PL_na);
	GenInfoParser *	THIS;
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
        THIS = (GenInfoParser *)SvIV((SV*)SvRV( ST(0) ));
    else {
        warn( "GenInfoParser::get_value() -- THIS is not a blessed SV reference" );
        XSRETURN_UNDEF;
    };
#line 228 "GenInfoParser.xs"
    ST(0) = sv_newmortal();
    const char *pValue = THIS->get_value(pPath);
    if ( pValue )
        sv_setpv(ST(0), pValue);
#line 344 "GenInfoParser.c"
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_GenInfoParser)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXS("GenInfoParser::new", XS_GenInfoParser_new, file);
        newXS("GenInfoParser::DESTROY", XS_GenInfoParser_DESTROY, file);
        newXS("GenInfoParser::load_list", XS_GenInfoParser_load_list, file);
        newXS("GenInfoParser::get_keys", XS_GenInfoParser_get_keys, file);
        newXS("GenInfoParser::get_key", XS_GenInfoParser_get_key, file);
        newXS("GenInfoParser::get_value", XS_GenInfoParser_get_value, file);
    XSRETURN_YES;
}

