/*************************************************************************
 *
 *  $RCSfile: svtabbx.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/06 10:52:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVTABBX_HXX
#define _SVTABBX_HXX

#include "svtreebx.hxx"

#ifndef _SVTOOLS_ACCESSIBLETABLEPROVIDER_HXX
#include "accessibletableprovider.hxx"
#endif

#include <vector>

enum SvTabJustify
{
	AdjustRight = SV_LBOXTAB_ADJUST_RIGHT,
	AdjustLeft = SV_LBOXTAB_ADJUST_LEFT,
	AdjustCenter = SV_LBOXTAB_ADJUST_CENTER,
	AdjustNumeric = SV_LBOXTAB_ADJUST_NUMERIC
};

class SvTabListBox : public SvTreeListBox
{
private:
	SvLBoxTab*					pTabList;
	USHORT						nTabCount;
	XubString					aCurEntry;
	ULONG						nDummy1;
	ULONG						nDummy2;

protected:
	SvLBoxEntry*				pViewParent;

	static const xub_Unicode*	GetToken( const xub_Unicode* pPtr, USHORT& rLen );

	virtual void				SetTabs();
	virtual void				InitEntry( SvLBoxEntry*, const XubString&, const Image&, const Image& );

	String						GetTabEntryText( ULONG nPos, USHORT nCol ) const;

public:
	SvTabListBox( Window* pParent, WinBits = WB_BORDER );
	SvTabListBox( Window* pParent, const ResId& );
	~SvTabListBox();
	void			SetTabs( long* pTabs, MapUnit = MAP_APPFONT );
	USHORT			TabCount() const { return (USHORT)nTabCount; }
	long 			GetTab( USHORT nTab ) const;
	void			SetTab( USHORT nTab, long nValue, MapUnit = MAP_APPFONT );
	long			GetLogicTab( USHORT nTab );

	SvLBoxEntry*	InsertEntry( const XubString&, ULONG nPos = LIST_APPEND,
								 USHORT nCol = 0xffff, void* pUserData = NULL );
	SvLBoxEntry*	InsertEntry( const XubString&, SvLBoxEntry* pParent,
								 ULONG nPos, USHORT nCol, void* pUserData = NULL );
	SvLBoxEntry*	InsertEntry( const XubString&, const Image& rExpandedEntryBmp,
								 const Image& rCollapsedEntryBmp, SvLBoxEntry* pParent = NULL,
								 ULONG nPos = LIST_APPEND, USHORT nCol = 0xffff, void* pUserData = NULL );

	virtual	String	GetEntryText( SvLBoxEntry* pEntry ) const;
	String			GetEntryText( SvLBoxEntry*, USHORT nCol ) const;
	String			GetEntryText( ULONG nPos, USHORT nCol = 0xffff ) const;
	void			SetEntryText( const XubString&, ULONG, USHORT nCol=0xffff );
	void			SetEntryText(const XubString&,SvLBoxEntry*,USHORT nCol=0xffff);
	ULONG			GetEntryPos( const XubString&, USHORT nCol = 0xffff );
	ULONG			GetEntryPos( const SvLBoxEntry* pEntry ) const;

	virtual void	Resize();
	void			SetTabJustify( USHORT nTab, SvTabJustify );
	SvTabJustify	GetTabJustify( USHORT nTab ) const;
};

inline long SvTabListBox::GetTab( USHORT nTab ) const
{
	DBG_ASSERT( nTab < nTabCount, "GetTabPos:Invalid Tab" );
	return pTabList[nTab].GetPos();
}

// class SvHeaderTabListBox ---------------------------------------------------

class HeaderBar;
namespace svt {
    class AccessibleTabListBox;
}

class SvHeaderTabListBox : public SvTabListBox, public svt::IAccessibleTableProvider
{
private:
	typedef ::std::vector< ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible >	> AccessibleChildren;

	sal_Bool					m_bFirstPaint;
	HeaderBar*					m_pHeaderBar;
	svt::AccessibleTabListBox* 	m_pAccessible;
	AccessibleChildren			m_aAccessibleChildren;

	DECL_LINK( ScrollHdl_Impl, SvTabListBox* );
	DECL_LINK( CreateAccessibleHdl_Impl, HeaderBar* );

public:
	SvHeaderTabListBox( Window* pParent, WinBits nBits );
	SvHeaderTabListBox( Window* pParent, const ResId& );
	~SvHeaderTabListBox();

	virtual void	Paint( const Rectangle& );

	void			InitHeaderBar( HeaderBar* pHeaderBar );

	// Accessible -------------------------------------------------------------
	/** @return  The count of the rows. */
	virtual	long					GetRowCount() const;
    /** @return  The count of the columns. */
	virtual sal_uInt16				GetColumnCount() const;

    /** @return  The position of the current row. */
	virtual sal_Int32				GetCurrRow() const;
    /** @return  The position of the current column. */
	virtual sal_uInt16				GetCurrColumn() const;

    /** @return  The description of a row.
        @param _nRow The row which description is in demand. */
    virtual ::rtl::OUString			GetRowDescription( sal_Int32 _nRow ) const;
    /** @return  The description of a column.
        @param _nColumn The column which description is in demand. */
	virtual ::rtl::OUString			GetColumnDescription( sal_uInt16 _nColumn ) const;

    /** @return  <TRUE/>, if the object has a row header. */
	virtual sal_Bool				HasRowHeader() const; //GetColumnId
    /** @return  <TRUE/>, if the object can focus a cell. */
	virtual sal_Bool				IsCellFocusable() const;
	virtual sal_Bool				GoToCell( sal_Int32 _nRow, sal_uInt16 _nColumn );

	virtual void					SetNoSelection();
	virtual void					SelectAll();
	virtual void					SelectAll( BOOL bSelect, BOOL bPaint=TRUE );	// just to disambiguate the SelectAll from the base' class SelectAll
	virtual void					SelectRow( long _nRow, BOOL _bSelect = TRUE, BOOL bExpand = TRUE );
	virtual void					SelectColumn( sal_uInt16 _nColumn, sal_Bool _bSelect = sal_True );
	virtual sal_Int32				GetSelectedRowCount() const;
	virtual sal_Int32				GetSelectedColumnCount() const;
    /** @return  <TRUE/>, if the row is selected. */
	virtual BOOL					IsRowSelected( long _nRow ) const;
	virtual sal_Bool				IsColumnSelected( long _nColumn ) const;
	virtual void					GetAllSelectedRows( ::com::sun::star::uno::Sequence< sal_Int32 >& _rRows ) const;
	virtual void					GetAllSelectedColumns( ::com::sun::star::uno::Sequence< sal_Int32 >& _rColumns ) const;

    /** @return  <TRUE/>, if the cell is visible. */
	virtual sal_Bool				IsCellVisible( sal_Int32 _nRow, sal_uInt16 _nColumn ) const;
	virtual String					GetAccessibleCellText( long _nRow, USHORT _nColumnPos ) const;

	virtual Rectangle				calcHeaderRect( sal_Bool _bIsColumnBar, BOOL _bOnScreen = TRUE );
	virtual Rectangle				calcTableRect( BOOL _bOnScreen = TRUE );
	virtual Rectangle				GetFieldRectPixelAbs( sal_Int32 _nRow, sal_uInt16 _nColumn, BOOL _bIsHeader, BOOL _bOnScreen = TRUE );

	virtual XACC					CreateAccessibleCell( sal_Int32 _nRow, sal_uInt16 _nColumn );
    virtual XACC					CreateAccessibleRowHeader( sal_Int32 _nRow );
    virtual XACC					CreateAccessibleColumnHeader( sal_uInt16 _nColumnPos );

	virtual sal_Int32				GetAccessibleControlCount() const;
    virtual XACC					CreateAccessibleControl( sal_Int32 _nIndex );
    virtual sal_Bool				ConvertPointToControlIndex( sal_Int32& _rnIndex, const Point& _rPoint );

	virtual sal_Bool				ConvertPointToCellAddress( sal_Int32& _rnRow, sal_uInt16& _rnColPos, const Point& _rPoint );
    virtual sal_Bool				ConvertPointToRowHeader( sal_Int32& _rnRow, const Point& _rPoint );
    virtual sal_Bool				ConvertPointToColumnHeader( sal_uInt16& _rnColPos, const Point& _rPoint );

	virtual ::rtl::OUString			GetAccessibleName( ::svt::AccessibleBrowseBoxObjType _eType, sal_Int32 _nPos = -1 ) const;
    virtual ::rtl::OUString			GetAccessibleDescription( ::svt::AccessibleBrowseBoxObjType _eType, sal_Int32 _nPos = -1 ) const;

	virtual void					FillAccessibleStateSet( ::utl::AccessibleStateSetHelper& _rStateSet, ::svt::AccessibleBrowseBoxObjType _eType ) const;
	virtual void					FillAccessibleStateSetForCell( ::utl::AccessibleStateSetHelper& _rStateSet, sal_Int32 _nRow, sal_uInt16 _nColumn ) const;
    virtual void					GrabTableFocus();

	// OutputDevice
	virtual BOOL					GetGlyphBoundRects( const Point& rOrigin, const String& rStr, int nIndex, int nLen, int nBase, MetricVector& rVector );

	// Window
    virtual Rectangle				GetWindowExtentsRelative( Window *pRelativeWindow );
    virtual void					GrabFocus();
    virtual XACC					GetAccessible( BOOL bCreate = TRUE );
    virtual Window*					GetAccessibleParentWindow() const;
    virtual Window*					GetWindow() const;

	/** Creates and returns the accessible object of the whole BrowseBox. */
    virtual XACC					CreateAccessible();

	virtual Rectangle				GetFieldCharacterBounds(sal_Int32 _nRow,sal_Int32 _nColumnPos,sal_Int32 nIndex);
	virtual sal_Int32				GetFieldIndexAtPoint(sal_Int32 _nRow,sal_Int32 _nColumnPos,const Point& _rPoint);
};

#endif // #ifndef _SVTABBX_HXX


