/*************************************************************************
 *
 *  $RCSfile: frmsel.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/24 16:51:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_FRMSEL_HXX
#define _SVX_FRMSEL_HXX

// include ---------------------------------------------------------------

#ifndef _LINK_HXX //autogen
#include <tools/link.hxx>
#endif
#ifndef _WINDOW_HXX //autogen
#include <vcl/ctrl.hxx>
#endif
#ifndef _COLOR_HXX //autogen
#include <vcl/color.hxx>
#endif
#ifndef _SV_BITMAP_HXX
#include <vcl/bitmap.hxx>
#endif
#ifndef SVX_LINKLINE_HXX
#include <linelink.hxx>
#endif

// -----------------------------------------------------------------------

	/*-----------------------------------------------------------*\

		Diese Klasse stellt das von Word bekannte Bedienelement
		fuer die Rahmeneinstellung zur Verfuegung.
		Dem Ctor kann dabei uebergeben werden, ob der Rahmen
		einer Tabelle oder eines Absatzes eingestellt werden soll.

	\*-----------------------------------------------------------*/

// enum ------------------------------------------------------------------

enum SvxFrameSelectorType
{
	SVX_FRMSELTYPE_TABLE = 0,
	SVX_FRMSELTYPE_PARAGRAPH
};
enum SvxFrameSelectorLine
{
	SVX_FRMSELLINE_NONE = 0,
	SVX_FRMSELLINE_LEFT,
	SVX_FRMSELLINE_RIGHT,
	SVX_FRMSELLINE_TOP,
	SVX_FRMSELLINE_BOTTOM,
	SVX_FRMSELLINE_HOR,
	SVX_FRMSELLINE_VER
};
enum SvxFrameLineState
{
	SVX_FRMLINESTATE_SHOW = 0,
	SVX_FRMLINESTATE_HIDE,
	SVX_FRMLINESTATE_DONT_CARE
};
enum SvxFrameShadow
{
    SVX_FRMSHADOW_NONE = 0,
    SVX_FRMSHADOW_BOT_RIGHT,
    SVX_FRMSHADOW_TOP_RIGHT,
    SVX_FRMSHADOW_BOT_LEFT,
    SVX_FRMSHADOW_TOP_LEFT
};
enum SvxSelArrowType
{
	SVX_SELARROWTYPE_LEFT = 0,
	SVX_SELARROWTYPE_RIGHT,
	SVX_SELARROWTYPE_UP,
	SVX_SELARROWTYPE_DOWN
};

// class SvxFrameLine -----------------------------------------------------

class SvxFrameLine
{
    friend class SvxFrameSelector;

	Point				aStartPos;		// Stuetzpunkte
	Point				aMidPos;
	Point				aEndPos;
	Color				aColor;			// Farbe
    SvxLineStruct       aStyle;       // interner Style
    SvxLineStruct       aCoreStyle;   // Core Style
    SvxFrameLineState   aState;       // sichtbar? Tristate?
	BOOL				bIsSelected;	// selektiert?

public:
                        SvxFrameLine();

    SvxLineStruct       GetStyle() const { return aCoreStyle; }
	void				SetStyle( const SvxLineStruct& aStyle );
	Color				GetColor() const { return aColor; }
	void				SetColor( const Color& rColor )  { aColor = rColor; }
    SvxFrameLineState   GetState() const { return aState; }
	void				SetState( SvxFrameLineState eState );
    const Point&        GetStartPos()const  {return aStartPos;}
    const Point&        GetEndPos()const  {return aEndPos;}
    Point&              GetStartPos() {return aStartPos;}
    Point&              GetEndPos() {return aEndPos;}
    BOOL                IsSelected() const {return bIsSelected;}

    static struct SvxLineStruct NO_LINE;        // darstellbare Linien-Styles:
	static struct SvxLineStruct THIN_LINE;
	static struct SvxLineStruct THICK_LINE;
	static struct SvxLineStruct THIN_DOUBLE_LINE;
	static struct SvxLineStruct THICK_DOUBLE_LINE;
};

// class SvxFrameSelector ------------------------------------------------
struct SvxFrameSelector_Impl;
class SvxFrameSelectorAccessible_Impl;

class SvxFrameSelector : public Control
{
    friend SvxFrameSelectorAccessible_Impl;
	friend SvxFrameSelector_Impl;

    SvxFrameShadow      eShadow;        // Schattenposition
    Color               aShadowCol;   // aktuelle Schattenfarbe
    BOOL                bIsClicked;
    Link                aSelectLink;
    SvxFrameSelector_Impl*  pImpl;

#ifdef _SVX_FRMSEL_CXX
    void                InitBitmap_Impl();
	void				DrawSelArrow_Impl( OutputDevice& rDev,
										   Point aPos,
										   Color aCol,
										   SvxSelArrowType eType );
	void				DrawContents_Impl( OutputDevice& rVirDev );
	void				DrawFrameLine_Impl( OutputDevice& rVirDev,
											Point from,
											Point to,
											BOOL bHor,
											SvxLineStruct& dline,
											SvxLineStruct& lt,
											SvxLineStruct& lLine,
											SvxLineStruct& lb,
											SvxLineStruct& rt,
											SvxLineStruct& rLine,
											SvxLineStruct& rb );
	void				LineClicked_Impl( SvxFrameLine& aLine,
										  BOOL bShiftPressed,
										  BOOL bDoubleClick );
    BOOL                IsAnyLineSelected_Impl() const;
    SvxFrameSelectorLine GetFirstSelLineForKey_Impl()const;
#endif

	inline const Color&	GetPaintColor( const Color& rNormalColor ) const;
	const Color&		GetDisplayBackgroundColor( void ) const;
	inline const Color&	GetDisplayBackgroundColor( const StyleSettings& rSettings ) const;
	void				ToggleOneLine( SvxFrameLine& aCurLine );
	void				ToggleAllSelectedLines();

protected:
	virtual void 		Paint( const Rectangle& rRect );
	virtual void    	MouseButtonDown( const MouseEvent& rMEvt );
	virtual void    	MouseButtonUp( const MouseEvent& rMEvt );
    virtual void        DataChanged( const DataChangedEvent& rDCEvt );
    virtual void        KeyInput( const KeyEvent& rKEvt );
    virtual void        GetFocus();
    virtual void        LoseFocus();

public:
						SvxFrameSelector( Window* pParent,
                                          const ResId& rResId);
                        ~SvxFrameSelector();
    void                Initialize(  SvxFrameSelectorType eType, BOOL bDontCare );

    SvxFrameLine&       GetLine(SvxFrameSelectorLine eWhich);

	void 				ShowLines();
	void				HideLines();
	void				SelectLine( SvxFrameSelectorLine eNewLine,
									BOOL bSet = TRUE );

    SvxFrameShadow      GetShadowPos() const { return eShadow;}
    void                SetShadowPos( SvxFrameShadow eShadowPos ) { eShadow = eShadowPos;}
    Color               GetShadowColor() const {return aShadowCol;}
    void                SetShadowColor( const Color& aColor ) { aShadowCol = aColor; }

	void				SetCurLineColor( const Color& aColor );
    void                SetCurLineStyle( const SvxLineStruct& rStyle );

	void				SetSelectLink(const Link& rLnk) {aSelectLink = rLnk;}

	BOOL				IsDirty() const { return bIsClicked; }
	BOOL				IsAnyLineSet() const;

    virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > CreateAccessible();
};


#endif

