/*************************************************************************
 *
 *  $RCSfile: ctrdial.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 15:00:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <math.h>
#pragma hdrstop

#include "ctrdial.hxx"

#ifndef _SV_BITMAP_HXX
#include <vcl/bitmap.hxx>
#endif
#ifndef _SV_SYSTEM_HXX
#include <vcl/system.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
#include <svtools/colorcfg.hxx>
#endif

// static functions

inline static Color GetBackgroundColor( const StyleSettings& rStyleSettings )
{
	return rStyleSettings.GetDialogColor();
}


inline static Color GetTextColor( const StyleSettings& rStyleSettings )
{
	svtools::ColorConfig aColorConfig;
	Color aWindowTextColor( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
	return aWindowTextColor;
}


inline static Color GetButtonTextColor( const StyleSettings& rStyleSettings )
{
	return rStyleSettings.GetButtonTextColor();
}


inline static Color GetHighlightColor( const StyleSettings& rStyleSettings )
{
	return rStyleSettings.GetHighlightColor();
}


inline static Color GetNonHighlightColor( const StyleSettings& rStyleSettings )
{
	return rStyleSettings.GetMenuColor();
}


inline static Color GetDisabledColor( const StyleSettings& rStyleSettings )
{
	return rStyleSettings.GetDisableColor();
}


inline static void GetColors( const StyleSettings& rStyleSettings, Color& rBackGround, Color& rText )
{
	rBackGround = ::GetBackgroundColor( rStyleSettings );
	rText = ::GetTextColor( rStyleSettings );
}




inline void SvxCtrDialBmp::GetColors( Color& rBackGround, Color& rText ) const
{
    ::GetColors( GetStyleSettings(), rBackGround, rText );
}


inline Color SvxCtrDialBmp::GetBackgroundColor( void ) const
{
    return ::GetBackgroundColor( GetStyleSettings() );
}


inline Color SvxCtrDialBmp::GetTextColor( void ) const
{
    return ::GetTextColor( GetStyleSettings() );
}


inline Color SvxCtrDialBmp::GetButtonTextColor( void ) const
{
    return ::GetButtonTextColor( GetStyleSettings() );
}


inline Color SvxCtrDialBmp::GetHighlightColor( void ) const
{
    return ::GetHighlightColor( GetStyleSettings() );
}


inline Color SvxCtrDialBmp::GetNonHighlightColor( void ) const
{
    return ::GetNonHighlightColor( GetStyleSettings() );
}


inline Color SvxCtrDialBmp::GetDisabledColor( void ) const
{
    return ::GetDisabledColor( GetStyleSettings() );
}


void SvxCtrDialBmp::DrawBackground( BOOL bEnabled )
{
    SetLineColor();
    SetFillColor( GetBackgroundColor() );
    DrawRect( aDrawRect );
}

void SvxCtrDialBmp::DrawShadow( BOOL bEnabled )
{
    EnableRTL( true ); // #107807# draw 3D effect in correct direction

    SetLineColor();

    BYTE nDiff = bEnabled ? 0x18 : 0x10;
    Color aColor( GetBackgroundColor() );
    aColor.DecreaseLuminance( nDiff );
    SetFillColor( aColor );
    DrawPie( aDrawRect, aDrawRect.BottomCenter(), aDrawRect.TopRight() );

    aColor.DecreaseLuminance( nDiff );
    SetFillColor( aColor );
    DrawPie( aDrawRect, aDrawRect.BottomRight(), aDrawRect.RightCenter() );

    aColor = GetBackgroundColor();
    aColor.IncreaseLuminance( nDiff );
    SetFillColor( aColor );
    DrawPie( aDrawRect, aDrawRect.TopCenter(), aDrawRect.BottomLeft() );

    aColor.IncreaseLuminance( nDiff );
    SetFillColor( aColor );
    DrawPie( aDrawRect, aDrawRect.TopLeft(), aDrawRect.LeftCenter() );

    EnableRTL( false );
}

void SvxCtrDialBmp::DrawCalibration( BOOL bEnabled )
{
    Point	aStartPos( nCenterX, nCenterY );
    Point	aPos;
    BYTE	nDiff = bEnabled ? 0x18 : 0x10;
    double	fAlpha;
    short	nX, nY;

	Color	aFullColor( bEnabled? GetTextColor() : GetDisabledColor() );
	Color	aLightColor( aFullColor );
	if( aFullColor.GetLuminance() < GetBackgroundColor().GetLuminance() )
		// lines darker than background -> make lighter
		aLightColor.IncreaseLuminance( nDiff );
	else
		aLightColor.DecreaseLuminance( nDiff );

    for( short nAng = 0; nAng < 360; nAng += 15 )
	{
        if( nAng % 45 )
			SetLineColor( aLightColor );
        else
			SetLineColor( aFullColor );

        fAlpha = nAng * F_PI180;
        nX = (short)( -nCenterX * cos( fAlpha ) );
        nY = (short)( nCenterY * sin( fAlpha ) );
        if( nY > 0 ) nY++;
        aPos = Point( nCenterX - nX, nCenterY - nY );
        DrawLine( aStartPos, aPos );
	}

    Rectangle a4Rect( aDrawRect.Left() + 8, aDrawRect.Top() + 8,
                      aDrawRect.Right() - 8, aDrawRect.Bottom() - 8);
    SetLineColor();
    SetFillColor( GetBackgroundColor() );
    DrawEllipse( a4Rect );
}

void SvxCtrDialBmp::InitBitmap( const Size& rSize )
{
    aDrawRect.SetPos( Point() );
    aDrawRect.SetSize( rSize );
    nCenterX = rSize.Width() / 2;
    nCenterY = rSize.Height() / 2;
    SetOutputSize( rSize );
    SetBackground();
    SetFillColor( GetBackgroundColor() );
}

void SvxCtrDialBmp::InitBitmap( const Size& rSize, const Font& rFont )
{
    InitBitmap( rSize );
    SetFont( rFont );
}

void SvxCtrDialBmp::DrawBackgrBitmap( const Size& rSize, BOOL bEnabled )
{
    InitBitmap( rSize );
    DrawBackground( bEnabled );
    DrawShadow( bEnabled );
    DrawCalibration( bEnabled );
}

void SvxCtrDialBmp::DrawBackgrBitmap( const SvxCtrDialBmp& rSrc )
{
    DrawBitmap( Point(), rSrc.GetBitmap( Point(), aDrawRect.GetSize() ) );
}

void SvxCtrDialBmp::DrawElements( const String& rText, short nDelta, BOOL bEnabled )
{
    Font	aFont = GetFont();
	const BOOL	bMain = ( nDelta % 450 ) != 0;
	Color		aTextColor( bEnabled? GetTextColor() : GetDisabledColor() );
	Color		aBtnTextColor( bEnabled? GetButtonTextColor() : GetDisabledColor() );

	aFont.SetColor( aBtnTextColor );
    aFont.SetOrientation( nDelta );
	aFont.SetWeight( WEIGHT_BOLD );
    SetFont( aFont );

    double		fAlpha = nDelta * F_PI1800;
    double		fWidth = GetTextWidth( rText ) / 2;
    double		fHeight = GetTextHeight() / 2;
    Point		aPos(	(short)(nCenterX - fWidth * cos( fAlpha ) - fHeight * sin( fAlpha )),
						(short)(nCenterY + fWidth * sin( fAlpha ) - fHeight * cos( fAlpha )) );

    DrawText( aPos, rText );

    short		nX = (short)((4 - nCenterX) * cos( fAlpha ));
    short		nY = (short)((nCenterY - 4) * sin( fAlpha ));
    aPos.X() = nCenterX - nX;
    aPos.Y() = nCenterY - nY;
    short		nSize = bMain? 2 : 3;

    SetLineColor( aTextColor );
    SetFillColor( Color( bEnabled ? (bMain? GetNonHighlightColor() : GetHighlightColor() ) : GetDisabledColor() ) );
	DrawEllipse( Rectangle( aPos.X() - nSize, aPos.Y() - nSize, aPos.X() + nSize, aPos.Y() + nSize ) );
}




inline void SvxCtrDial::GetColors( Color& rBackGround, Color& rText ) const
{
	::GetColors( GetSettings().GetStyleSettings(), rBackGround, rText );
}


/*************************************************************************
#*	Member:		SvxCtrDial										Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Konstruktor der Klasse SvxCtrDial
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

SvxCtrDial::SvxCtrDial( Window* pParent, Size aSize, WinBits nWinStyle) :
	Control( pParent, nWinStyle ),
    aEnabledBmp( *this ),
    aDisabledBmp( *this ),
    aBufferBmp( *this )
{
	DBG_ASSERT( pParent, "-SvxCtrDial::SvxCtrDial(): no parent, no cookies!" );

	aWinSize = aSize;
	aRotFont = pParent->GetFont();
    Init();
}

/*************************************************************************
#*	Member:		SvxCtrDial									Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Konstruktor der Klasse SvxCtrDial
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

SvxCtrDial::SvxCtrDial( Window* pParent,Size aSize, Font aFont, WinBits nWinStyle) :
	Control( pParent, nWinStyle ),
    aEnabledBmp( *this ),
    aDisabledBmp( *this ),
    aBufferBmp( *this )
{
	DBG_ASSERT( pParent, "-SvxCtrDial::SvxCtrDial(): no parent, no cookies!" );

	aWinSize = aSize;
	aRotFont = aFont;
	Init();
}

/*************************************************************************
#*	Member:		SvxCtrDial									Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		MD_Test
#*
#*  Funktion:	Konstruktor der Klasse SvxCtrDial
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

SvxCtrDial::SvxCtrDial( Window* pParent, const ResId& rResId) :
	Control( pParent, rResId ),
    aEnabledBmp( *this ),
    aDisabledBmp( *this ),
    aBufferBmp( *this )
{
	DBG_ASSERT( pParent, "-SvxCtrDial::SvxCtrDial(): no parent, no cookies!" );

	aWinSize = GetOutputSizePixel();
	aRotFont = OutputDevice::GetDefaultFont(
		DEFAULTFONT_UI_SANS, Application::GetSettings().GetUILanguage(), DEFAULTFONT_FLAGS_ONLYONE );
	Init();
}

/*************************************************************************
#*  Member:     Init                                        Datum:16.05.01
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:   common constructor instructions
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxCtrDial::Init()
{
    EnableRTL( false ); // #107807# don't mirror mouse handling
    bNoSel = false;
	nDelta = 0;
	aRotFont.SetTransparent( TRUE );
	SetOutputSizePixel( aWinSize );
	nCenterX = aWinSize.Width() / 2;
	nCenterY = aWinSize.Height() / 2;
	SetBackground();
	aEnabledBmp.DrawBackgrBitmap( aWinSize, TRUE );
	aDisabledBmp.DrawBackgrBitmap( aWinSize, FALSE );
	aBufferBmp.InitBitmap( aWinSize, aRotFont );
}

/*************************************************************************
#*	Member:		Paint										Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Aktualisiert den Control und zeichnet den
#*				gedrehten Text.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxCtrDial::Paint( const Rectangle& aRect )
{
    DrawBitmap( Point(), aBufferBmp.GetBitmap( Point(), aWinSize ) );
}

/*************************************************************************
#*  Member:     Invalidate                                  Datum:16.05.01
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Aktualisiert den Control und zeichnet den
#*				gedrehten Text.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxCtrDial::Invalidate()
{
    aBufferBmp.DrawBackgrBitmap( IsEnabled() ? aEnabledBmp : aDisabledBmp );
    if( !bNoSel )
        aBufferBmp.DrawElements( GetText(), nDelta, IsEnabled() );
    Control::Invalidate();
}

/**************************************************************************/

void SvxCtrDial::DataChanged( const DataChangedEvent& rDCEvt )
{
    if( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
    {
        Init();
        Invalidate();
        Paint( Rectangle( Point(), aWinSize ) );
    }
	else
        Control::DataChanged( rDCEvt );
}

/*************************************************************************
#*	Member:		MouseButtonDown								Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Reagiert auf einen einzelnen Mouse-Event. Hierbei
#*				wird die aktuelle Maus- Koordinate ermittelt und
#*				der entsprechende Winkel eingestellt. Anschliessend
#*				wird die Ausgabe aktualisiert.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxCtrDial::MouseButtonDown( const MouseEvent& rMEvt )
{
	double x;
	double y;
	double h,h1;
	double nAlpha;
	Point aPos=rMEvt.GetPosPixel();

	CaptureMouse();

	if(rMEvt.IsLeft())
	{
		x=aPos.X()-nCenterX;
		y=nCenterY-aPos.Y();

		h=sqrt(x*x+y*y);

		if(h!=0)
		{
            h1 = acos( x / h );
            nAlpha = h1 / F_PI1800;
			if(y>=0)
			{
				nDelta=(short) (150.*floor(nAlpha/150.+0.5));
			}
			else
			{
				nDelta=(short) (150.*floor((3600-nAlpha)/150.+0.5));
			}
			if(nDelta==3600) nDelta=0;
		}

        bNoSel = false;
		Invalidate();
		Update();
		CtrModified();
	}
	Control::MouseButtonDown(rMEvt );
}

/*************************************************************************
#*	Member:		MouseButtonUp								Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Ende einer Benutzeraktion mit der Maus. Es werden
#*				die aktuelle Maus- Koordinate ermittelt und der
#*				entsprechende Winkel eingestellt. Anschliessend
#*				wird die Ausgabe aktualisiert.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxCtrDial::MouseButtonUp( const MouseEvent& rMEvt )
{
	ReleaseMouse();

	Control::MouseButtonUp(rMEvt );
	CtrMouseUp();
}

/*************************************************************************
#*	Member:		MouseMove									Datum:08.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Reagiert kontinuierlich auf Mausbewegungen. Hierbei
#*				wird die aktuelle Maus- Koordinate ermittelt und
#*				der entsprechende Winkel eingestellt. Anschliessend
#*				wird die Ausgabe aktualisiert.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/

void SvxCtrDial::MouseMove( const MouseEvent& rMEvt )
{
	double x;
	double y;
	double h,h1;
	double nAlpha;
	Point aPos=rMEvt.GetPosPixel();

	if(rMEvt.IsLeft() && IsMouseCaptured())
	{
		x=aPos.X()-nCenterX;
		y=nCenterY-aPos.Y();

		h=sqrt(x*x+y*y);

		if(h!=0)
		{
			h1=acos(x/h);
            nAlpha= h1 / F_PI1800;
			if(y>=0)
			{
				nDelta=(short) floor(nAlpha+0.5);
			}
			else
			{
				nDelta=(short) floor(3600.5-nAlpha);
			}
			if(nDelta==3600) nDelta=0;
		}
		Invalidate();
		Update();
		CtrModified();
	}
	Control::MouseMove(rMEvt );

}

/*************************************************************************
#************************************************************************/
USHORT SvxCtrDial::GetOrientation()
{
	return (USHORT ) nDelta/10;
}

void SvxCtrDial::SetOrientation(short nAlpha)
{
    bNoSel = false;
	if(nAlpha>360)
	{
		nAlpha=nAlpha % 360;
	}
	else if(nAlpha<0)
	{
		nAlpha=nAlpha % 360;
		nAlpha=360+nAlpha;
	}

	nDelta=nAlpha*10;
	Invalidate();
	Update();
}

bool SvxCtrDial::HasOrientation() const
{
    return !bNoSel;
}

void SvxCtrDial::SetNoOrientation()
{
    bNoSel = true;
    Invalidate();
    Update();
}

/*************************************************************************
#*	Member:		CtrModified									Datum:11.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Teilt einem installierten Handler mit, dass
#*				eine Veraenderung eingetreten ist.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void SvxCtrDial::CtrModified()
{
	aCtrModifiedLink.Call( this );
}

/*************************************************************************
#*	Member:		CtrModified									Datum:11.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxCtrDial
#*
#*  Funktion:	Teilt einem installierten Handler mit, dass
#*				die Maus losgelassen wurde.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void SvxCtrDial::CtrMouseUp()
{
	aMouseUpLink.Call( this );
}


