/*************************************************************************
 *
 *  $RCSfile: svxurlbk.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2001/08/09 16:02:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string.h>
#pragma hdrstop

#include <sot/exchange.hxx>
#include <sot/formats.hxx>

#include "svxurlbk.hxx"

//-----------------------------------------------------------------------

sal_uInt32 SvxINetBookmark::HasFormat( SotDataObject& rObj )

/*	[Beschreibung]

	Liefert sal_True, falls in dem SvDataObject ein entsp. ::com::sun::star::text::Bookmark-Format
	gefunden wurde.
*/

{
	return INetBookmark::_HasFormat( rObj );
}

//-----------------------------------------------------------------------

sal_Bool SvxINetBookmark::SetData( SvData& rData )

/*	[Beschreibung]

	Liefert sal_True, falls in dem SvDataObject ein entsp. ::com::sun::star::text::Bookmark-Format
	gefunden steht, das wir unterstuetzen. Wenn ja, werden die Daten
	ins Data-Object kopiert.
*/

{
	return INetBookmark::_SetData( rData );
}

//-----------------------------------------------------------------------

sal_Bool SvxINetBookmark::Copy( SotDataObject& rObj ) const

/*	[Beschreibung]

	Diese Methode kopiert diese Instanz in das Clipboard.
*/

{
	return INetBookmark::_Copy( rObj );
}

//-----------------------------------------------------------------------

sal_Bool SvxINetBookmark::Paste( SotDataObject& rObj, sal_uInt32 nFormat )

/*	[Beschreibung]

	Diese Methode "uberschreibt den Wert dieser Instanz mit dem
	Inhalt des DragServers an Position 'nItem'. Es wird vorausgesetzt,
	da\s sich das eigene Format im DragServer befindet.
*/

{
	return INetBookmark::_Paste( rObj, nFormat );
}

//=======================================================================

#if SUP <= 397

sal_uInt32 SvxINetBookmark::HasFormat( SvDataObject& rObj )
{
	SotDataObject& rSotObj = rObj;
	return SvxINetBookmark::HasFormat( rSotObj );
}

sal_Bool SvxINetBookmark::Copy( SvDataObject& rObj ) const
{
	SotDataObject& rSotObj = rObj;
	return Copy( rSotObj );
}

sal_Bool SvxINetBookmark::Paste( SvDataObject& rObj, sal_uInt32 nFormat )
{
	SotDataObject& rSotObj = rObj;
	return Paste( rSotObj, nFormat );
}

#endif



