/*************************************************************************
 *
 *  $RCSfile: lingtest.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:29 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifdef USEHM
#include <hmwrap.hxx>
#else
#include <lingwrap.hxx>
#endif

#include "dialogs.hxx"
#include "svxitems.hxx"
#include "option.hxx"

#include "dialogs.hrc"
#include "lingtest.hrc"

// define ----------------------------------------------------------------

#define MID_FILE			   100
#define MID_QUIT			   101

#define MID_DIALOG 			   110
#define MID_OPTION 			   111
#define MID_HYPHEN 			   112
#define MID_THES			   113
#define MID_SPELL			   114

// static ----------------------------------------------------------------

static SpellCheck* pSpeller = 0;

// class MyApp -----------------------------------------------------------

class MyApp : public Application
{
public:
	virtual void 	Main( int, char*[] );
};

// class AppWin ----------------------------------------------------------

class AppWin: public WorkWindow
{
	String			aWord;

public:
					AppWin();

	void			Paint( const Rectangle& rRect );

	DECL_LINK( FileSelect, Menu * );
	DECL_LINK( DialogSelect, Menu * );
};

// AppWin::AppWin() ------------------------------------------------------

AppWin::AppWin() :

	WorkWindow( 0, WinBits( WB_APP | WB_STDWORK ) ),

	aWord( String() )
{
}

// AppWin::FileSelect() --------------------------------------------------

IMPL_LINK( AppWin, FileSelect, Menu *, pMenu )
{
	switch ( pMenu->GetCurItemId() )
	{
		case MID_QUIT:
			Close();
			break;
	}
	return TRUE;
}

// AppWin::DialogSelect() ------------------------------------------------

IMPL_LINK( AppWin, DialogSelect, Menu *, pMenu )
{
	switch ( pMenu->GetCurItemId() )
	{
		case MID_OPTION:
		{
			OptionDialog* pDlg = new OptionDialog( this );
			pDlg->SetMinHead( pSpeller->GetMinHead() );
			pDlg->SetMinTrail( pSpeller->GetMinTrail() );
			pDlg->SetWord( aWord );
			pDlg->SetLanguage( pSpeller->GetActualLanguage() );
			pDlg->Execute();
			DBG_ASSERT( pSpeller, "kein Speller" );
			pSpeller->SetActualLanguage( (LanguageType)pDlg->GetLanguage() );
			pSpeller->SetMinHead( pDlg->GetMinHead() );
			pSpeller->SetMinTrail( pDlg->GetMinTrail() );
			aWord = pDlg->GetWord();
			delete pDlg;
		}
		break;

		case MID_HYPHEN:
		{
			String aTmp( "Autobahn" );
			DBG_ASSERT( pSpeller, "kein Speller" );
			pSpeller->HyphenateWord( aWord.Len() ? aWord : aTmp );
			SvxHyphenator* pHyphen = new SvxHyphenator( this, pSpeller, TRUE, TRUE );
			delete pHyphen;
		}
		break;

		case MID_THES:
		{
			if ( !LinguBase::LoadDll() )
			{
				InfoBox( this, "Load LinguDll failed!" ).Execute();
				break;
			}

			DBG_ASSERT( pSpeller, "kein Speller" );
			Thesaurus* pThes =
#ifdef USEHM
				new Thesaurus( pSpeller->GetDicPath(),
							   pSpeller->GetActualLanguage() );
#else
				new Thesaurus( pSpeller );
#endif
			DBG_ASSERT( pThes, "kein Thesaurus" );

			if ( pThes->HasError() )
			{
				InfoBox( this, "Thesaurus has errors!" ).Execute();
				delete pThes;
				break;
			}

			pApp->Wait(TRUE);
			String aTmp( "Liebhaber" );
			pThes->LookUp( aWord.Len() ? aWord : aTmp );
			pApp->Wait(FALSE);
			SvxThesaurusDialog* pDlg =
				new SvxThesaurusDialog( this, pThes, FALSE );
			pDlg->Execute();
			pThes->EndLookUp();
			delete pDlg;
			delete pThes;
		}
		break;

		case MID_SPELL:
		{
			String aTmp( "ersezen");
			DBG_ASSERT( pSpeller, "kein Speller" );
			pSpeller->SpellWord( aWord.Len() ? aWord : aTmp );
			SvxSpellWrapper* pWrp = new SvxSpellWrapper( this, pSpeller,
				SVX_DOCPOS_START, SVX_DOCPOS_END, FALSE, FALSE );
			delete pWrp;
		}
		break;

	}
	return TRUE;
}

// AppWin::Paint() -------------------------------------------------------

void AppWin::Paint( const Rectangle& rRect )
{
}

// MyApp::Main() ---------------------------------------------------------

void MyApp::Main( int, char*[] )
{
	SvxDialogDll	aSvxDll;

#ifdef WIN
	pSpeller = new SpellCheck( DirEntry( "s:\\swgnet.win" ),
							   DirEntry( "s:\\swgnet.win" ) );
	pSpeller->SetActualLanguage( LANGUAGE_GERMAN );
#else
#ifdef OS2
	pSpeller = new SpellCheck( DirEntry( "s:\\swgnet.os2" ),
							   DirEntry( "s:\\swgnet.os2" ) );
	pSpeller->SetActualLanguage( LANGUAGE_GERMAN );
#else
	pSpeller = 0;
#endif
#endif

	ChangeAppFont( Font( ResId(RID_APPFONT) ) );
	EnableSVLook();

	AppWin aMainWin;
	aMainWin.SetText( "SVX Example" );
	aMainWin.Show();

	MenuBar aMenuBar;

	PopupMenu aFileMenu;
	PopupMenu aDialogMenu;
	PopupMenu aDrawMenu;

	aMenuBar.InsertItem( MID_FILE,		String( ResId( RID_FILE ) ) );
	aMenuBar.InsertItem( MID_DIALOG, 	String( ResId( RID_DIALOG ) ) );

	aMenuBar.ChangePopupMenu( MID_FILE,		&aFileMenu );
	aMenuBar.ChangePopupMenu( MID_DIALOG,	&aDialogMenu );

	aFileMenu.InsertItem	( MID_QUIT,		String( ResId( RID_FILE_QUIT ) ) );

	aDialogMenu.InsertItem	( MID_OPTION,	String( ResId( RID_DIALOG_OPTION ) ) );
	aDialogMenu.InsertItem	( MID_HYPHEN,	String( ResId( RID_DIALOG_HYPHEN ) ) );
	aDialogMenu.InsertItem	( MID_THES,		String( ResId( RID_DIALOG_THESAU ) ) );
	aDialogMenu.InsertItem	( MID_SPELL,	String( ResId( RID_DIALOG_SPELL ) ) );

	aFileMenu.PushSelectHdl( LINK( &aMainWin, AppWin, FileSelect ) );
	aDialogMenu.PushSelectHdl( LINK( &aMainWin, AppWin, DialogSelect ) );

	ChangeAppMenu( &aMenuBar );
	Execute();
	delete pSpeller;
}

// aMyApp ----------------------------------------------------------------

MyApp aMyApp;

